#version 3.7;

#local UseRadiosity = yes;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 600
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars_Definitions.inc"
#include "BorderChars_Macros.inc"
#include "BorderChars_Styles.inc"

#local CameraX = 0;
#local CameraY = 0;
#local CameraZ = 12.4;

camera {
   location <CameraX, CameraY, -CameraZ>
   direction <0, 0, 1>
   look_at <CameraX, CameraY, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#declare TextColor_Outer = texture {pigment {color White}}

#declare TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {pigment {color (<96, 56, 13> / 255 * 1.5 + White * 4) / 5}}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4;
#local ZOffset = -.1;

#declare TextScale = 1;

#declare GAP_Width = .06;   //Distance between characters
#declare SPACE_Width = .2;  //Distance between words
#declare LineSpacing = 1.5; //Distance between lines

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 1;

InitializeVariables (NLines)

#local Style = 0;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;

Stylize (Style, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)

//Use   \"   for quote marks.
//Use   ^    for a heart.

#declare LineText [0] = "Normal";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message1 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = LeftMargin + MaxLineWidth + SPACE_Width;

#local Style = 0;
#local TextDepth = .08;
#local InvisibleBorderWidth = .04;

Stylize (Style, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)

#declare LineText [0] = "Thin";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message2 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = LeftMargin + MaxLineWidth + SPACE_Width;

#local Style = 0;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;

Stylize (Style, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)

#declare LineText [0] = "<Italic>";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message3 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing;

#declare TextColor_Inner = texture {
   #local Color0 = color <0.9671, 0.6440, 0.6228>; //Red
   #local Color1 = color <0.5376, 0.0436, 0.0674>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#local Style = 2;
#local TextDepth = .08;
#local BorderWidth = .03;
#local BorderDepth = .05;

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "Left";
#declare LineText [1] = "align";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message4 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare TextColor_Inner = texture {
   #local Color0 = color <0.6280, 0.8939, 0.8723>; //Green
   #local Color1 = color <0.1405, 0.4175, 0.1519>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = CENTERED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "Center";
#declare LineText [1] = "align";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local LeftMargin = -MaxLineWidth / 2;

#local Message5 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare TextColor_Inner = texture {
   #local Color0 = color <0.5607, 0.6878, 0.9814>; //Blue
   #local Color1 = color <0.1811, 0.2305, 0.2083>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = RIGHT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "Right";
#declare LineText [1] = "align";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local LeftMargin = CameraZ * 2/3 - MaxLineWidth - .4;

#local Message6 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing * 3;

#declare TextColor_Inner = texture {
   #local Color0 = color <0.8749, 0.7677, 0.6582>; //Brown
   #local Color1 = color <0.2034, 0.1822, 0.0507>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = JUSTIFIED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = yes; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 120; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "Micro-justification";
#declare LineText [1] = "including <italics>";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message7 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing * 5;

#declare TextColor_Inner = texture {
   #local Color0 = color <0.8196, 0.6339, 0.8780>;
   #local Color1 = color <0.0965, 0.1283, 0.3460>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "Automatic kerning";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message8 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing * 6;

#declare TextColor_Inner = texture {
   #local Color0 = color <0.9295, 0.9816, 0.7871>; //Yellow
   #local Color1 = color <0.8464, 0.6731, 0.1741>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "Adjustable widths: ";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local Message9 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing * 7;

#local Message10 = object {
   #local NSteps = 9;
   #local MinBorder = .03;
   #local MaxBorder = .075; //Start with wide border and thin center
   #local MaxInvisibleBorder = .05; //End with thin stroke width
   #local TLeftMargin = 1;
   union {
      #for (I, 0, NSteps - 1)
         #local CurBorder = MaxBorder - (MaxBorder - MinBorder) * (I / (NSteps - 1));
         Stylize (Style, TextDepth, 0, CurBorder, BorderDepth, -999, -999, -999)
         #declare NLines = 1;
         InitializeVariables (NLines)
         #declare LineText [0] = "o";
         CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)
         object {Paragraph translate TLeftMargin * x}
         #local TLeftMargin = TLeftMargin + MaxLineWidth + GAP_Width;
      #end //#for
      #for (I, 1, NSteps - 1)
         #local CurInvBorder = MaxInvisibleBorder * (I / (NSteps - 1));
         Stylize (Style, TextDepth, CurInvBorder, MinBorder, BorderDepth, -999, -999, -999)
         #declare NLines = 1;
         InitializeVariables (NLines)
         #declare LineText [0] = "o";
         CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)
         object {Paragraph translate TLeftMargin * x}
         #local TLeftMargin = TLeftMargin + MaxLineWidth + GAP_Width;
      #end //#for
   } //union
   translate <LeftMargin, TopMargin, ZOffset>
} //object

//Next...

#declare TextColor_Inner = texture {
   #local Color0 = color <0.9766, 0.6792, 0.9913>; //Pink
   #local Color1 = color <0.9645, 0.2563, 0.4112>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare LineAlignment = CENTERED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare AlignLastLine = no; //Only meaningful when LineAlignment = JUSTIFIED
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 4;

InitializeVariables (NLines)

#declare LineText [0] = "I";
#declare LineText [1] = "^";
#declare LineText [2] = "POV-";
#declare LineText [3] = "Ray";

CreateParagraphTextObject (NLines, LineAlignment, AlignLastLine)

#local LeftMargin = CameraZ * 2/3 - .4 - MaxLineWidth;
#local TopMargin = CameraZ / 2 - 1 - .4 - LineSpacing * 3;

#local Message11 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

object {Message1}
object {Message2}
object {Message3}
object {Message4}
object {Message5}
object {Message6}
object {Message7}
object {Message8}
object {Message9}
object {Message10}
object {Message11}

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor}
   } //plane
} //object

object {Background}
