/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * [VERSION 1.2]                                                                                                   * */
/* *                                                                                                                 * */
/* * INSTRUCTIONS FOR USE:                                                                                           * */
/* *                                                                                                                 * */
/* * This file contains some example styles to demonstrate the many possible ways that characters with different     * */
/* * border widths can be combined in interesting ways. You will no doubt want to create your own unique styles.     * */
/* *                                                                                                                 * */
/* * The file "Sample_Styles.pov" demonstrates each of the styles defined in this file.                              * */
/* *                                                                                                                 * */
/* * There are two variables used within these samples that require special explanation:                             * */
/* *                                                                                                                 * */
/* *    [TextScale] Since the final character objects will be scaled along the x and y axes by [TextScale], this     * */
/* *    could also change the border widths. Therefore, widths are divided by the value of [TextScale] prior to      * */
/* *    character creation so that the final result after scaling will be correct.                                   * */
/* *                                                                                                                 * */
/* *    [InvisibleBorderWidth] This variable can be used to decrease the stroke width of some of the character       * */
/* *    styles. Good values are 0 (no reduction in stroke width) to around .04.                                      * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef (TextColor_Outer)

   #declare TextColor_Outer = texture {pigment {color <1, 1, 1>}}

#end //#ifndef

#ifndef (TextColor_Inner)

   #declare TextColor_Inner = texture {pigment {color <1, 0, 0>}}

#end //#ifndef

#ifndef (Color0)

   #declare Color0 = color <.4, 0, 0>; //Bottom/Outside
   #declare Color1 = color <1, 0, 0>; //Top/Inside

#end //#ifndef

#ifndef (TextColor_Back)

   #declare TextColor_Back = texture {TextColor_Outer}

#end //#ifndef

#macro Stylize (Style, TextDepth, P1, P2, P3, P4, P5, P6)

   #for (I, 0, 81)
      #switch (Style)
         #case (0) //Plain
            #local InvisibleBorderWidth = P1 / TextScale;
            MakeCharacter (I, InvisibleBorderWidth)
            #declare Character = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (1) //Raised center
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local BorderHeight = P3;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               intersection {
                  object {Character scale <1, 1, TextDepth>}
                  plane {z, 1}
               } //intersection
               texture {TextColor_Inner}
            } //object
            #declare Character = object {
               union {
                  object {Character_Outer}
                  object {Character_Inner translate -BorderHeight * z}
               } //union
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (2) //Lowered center
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local BorderDepth = P3;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               intersection {
                  object {Character scale <1, 1, 1.1>}
                  plane {z, 1}
               } //intersection
               texture {TextColor_Inner}
            } //object
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner translate (-1 + BorderDepth) * z}
               } //difference
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (3) //Striped
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local StripeWidth = P3 / TextScale;
            #local StripeHeight = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local StripeWidth = StripeWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
            MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
            #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               difference {
                  object {Character}
                  object {Character_Inner2 translate -.1 * z}
               } //difference
               texture {TextColor_Inner}
            } //object
            #declare Character = object {
               intersection {
                  union {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                     object {Character_Inner translate -StripeHeight * z}
                  } //union
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (4) //Color gradient
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local StripeWidth = P3 / TextScale;
            #local NSteps = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local StripeWidth = StripeWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
            #local StripeWidthIncrement = StripeWidth / NSteps;
            #for (J, 0, NSteps)
               #local ColorRatio = J / (NSteps - 1);
               #local CurColor = Color1 * ColorRatio + Color0 * (1 - ColorRatio);
               #local CurBorderWidth = BorderWidth + J * StripeWidthIncrement;
               MakeCharacter (I, CurBorderWidth + InvisibleBorderWidth)
               #if (J < NSteps)
                  #local CurTexture = texture {pigment {color CurColor}}
               #else
                  #local CurTexture = texture {TextColor_Outer}
               #end //#if
               #local Character_Inner = object {Character scale <1, 1, 1.3> texture {CurTexture}}
               #local Character_Outer = object {
                  union {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                     object {Character_Inner}
                  } //union
               } //object
            #end //#for
            #declare Character = object {
               intersection {
                  object {Character_Outer}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (5) //Hollow stripe
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local StripeWidth = P3 / TextScale;
            #local StripeDepth = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local StripeWidth = StripeWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character scale <1, 1, 1.1>}
            MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
            #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               difference {
                  object {Character}
                  object {Character_Inner2 translate -.1 * z}
               } //difference
            } //object
            #declare Character = object {
               intersection {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + StripeDepth) * z}
                     texture {TextColor_Outer}
                  } //difference
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (6) //Hollow inside
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {Character scale <1, 1, 1.2> texture {TextColor_Outer}}
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner translate -.1 * z}
               } //difference
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (7) //Angled bevel
            #local BorderHeight = P1;
            #local NSteps = P2;
            MakeCharacter (I, 0)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.2> translate -.1 * z texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
                  plane {z, 0 inverse texture {TextColor_Inner}}
               } //intersection
            } //object
            #local Character_Inner = object {
               intersection {
                  union {
                     #local Increment = BorderHeight / NSteps;
                     #for (J, 1, NSteps)
                        MakeCharacter (I, Increment * J)
                        #if (J = NSteps)
                           #declare Character = object {
                              intersection {
                                 object {Character translate -.1 * z}
                                 plane {z, 0 inverse texture {TextColor_Outer}}
                              } //intersection
                           } //object
                        #end //#if
                        object {Character translate (-Increment * J) * z}
                     #end //#for
                  } //union
                  plane {z, 0}
               } //intersection
               texture {TextColor_Inner}
            } //object
            #declare Character = object {
               union {
                  object {Character_Outer}
                  object {Character_Inner}
               } //union
               translate -TextDepth * z //Back is at z = 0
            } //object
            #break
         #case (8) //Rounded bevel
            #local BorderHeight = P1;
            #local NSteps = P2;
            #local R = BorderHeight;
            MakeCharacter (I, 0)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.2> translate -.1 * z texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
                  plane {z, 0 inverse texture {TextColor_Inner}}
               } //intersection
            } //object
            #local Character_Inner = object {
               intersection {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 1, NSteps)
                        #local CurAngle = J * Increment;
                        #local CurBorderWidth = R * (1 + cos (radians (CurAngle + 180)));
                        #local CurBorderHeight = R * sin (radians (CurAngle));
                        MakeCharacter (I, CurBorderWidth)
                        #if (J = NSteps)
                           #declare Character = object {
                              intersection {
                                 object {Character translate -.1 * z}
                                 plane {z, 0 inverse texture {TextColor_Outer}}
                              } //intersection
                           } //object
                        #end //#if
                        object {Character translate -CurBorderHeight * z}
                     #end //#for
                  } //union
                  plane {z, 0}
               } //intersection
               texture {TextColor_Inner}
            } //object
            #declare Character = object {
               union {
                  object {Character_Outer}
                  object {Character_Inner}
               } //union
               translate -TextDepth * z //Back is at z = 0
            } //object
            #break
         #case (9) //Solid hourglass (convex)
            #local EffectWidth = P1;
            #local NSteps = P2;
            #local TempCharacter = object {
               union {
                  #local SegmentLength = TextDepth / NSteps;
                  #local DeltaTheta = 180 / (NSteps - 1);
                  #local CurZ = TextDepth;
                  #local Theta = 0;
                  #for (J, 1, NSteps)
                     #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                     MakeCharacter (I, CurBorder)
                     #local Segment = object {Character translate -1 * z scale <1, 1, SegmentLength>}
                     object {Segment translate CurZ * z}
                     #local CurZ = CurZ - SegmentLength;
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -TextDepth * z //Back is at z = 0
            } //object
            #declare Character = object {TempCharacter}
            #break
         #case (10) //Hollow hourglass (convex)
            #local EffectWidth = P1;
            #local WallThickness = P2 / TextScale;
            #local NSteps = P3;
            #local TempCharacter = object {
               union {
                  #local SegmentLength = TextDepth / NSteps;
                  #local DeltaTheta = 180 / (NSteps - 1);
                  #local CurZ = TextDepth;
                  #local Theta = 0;
                  #for (J, 1, NSteps)
                     #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                     MakeCharacter (I, CurBorder)
                     #local Character_Outer = object {Character}
                     MakeCharacter (I, CurBorder + WallThickness)
                     #local Character_Inner = object {Character scale <1, 1, 1.2>}
                     #local Segment = object {
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                        } //difference
                        translate -1 * z
                        scale <1, 1, SegmentLength>
                     } //object
                     object {Segment translate CurZ * z}
                     #local CurZ = CurZ - SegmentLength;
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -TextDepth * z //Back is at z = 0
            } //object
            #declare Character = object {TempCharacter}
            #break
         #case (11) //Solid hourglass (concave)
            #local EffectWidth = P1;
            #local NSteps = P2;
            #local TempCharacter = object {
               union {
                  #local SegmentLength = TextDepth / NSteps;
                  #local DeltaTheta = 180 / (NSteps - 1);
                  #local CurZ = TextDepth;
                  #local Theta = 0;
                  #for (J, 1, NSteps)
                     #local CurBorder = EffectWidth * sin (radians (Theta));
                     MakeCharacter (I, CurBorder)
                     #local Segment = object {Character translate -1 * z scale <1, 1, SegmentLength>}
                     object {Segment translate CurZ * z}
                     #local CurZ = CurZ - SegmentLength;
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -TextDepth * z //Back is at z = 0
            } //object
            #declare Character = object {TempCharacter}
            #break
         #case (12) //Hollow hourglass (concave)
            #local EffectWidth = P1;
            #local WallThickness = P2 / TextScale;
            #local NSteps = P3;
            #local TempCharacter = object {
               union {
                  #local SegmentLength = TextDepth / NSteps;
                  #local DeltaTheta = 180 / (NSteps - 1);
                  #local CurZ = TextDepth;
                  #local Theta = 0;
                  #for (J, 1, NSteps)
                     #local CurBorder = EffectWidth * sin (radians (Theta));
                     MakeCharacter (I, CurBorder)
                     #local Character_Outer = object {Character}
                     MakeCharacter (I, CurBorder + WallThickness)
                     #local Character_Inner = object {Character scale <1, 1, 1.2>}
                     #local Segment = object {
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                        } //difference
                        translate -1 * z
                        scale <1, 1, SegmentLength>
                     } //object
                     object {Segment translate CurZ * z}
                     #local CurZ = CurZ - SegmentLength;
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -TextDepth * z //Back is at z = 0
            } //object
            #declare Character = object {TempCharacter}
            #break
         #case (13) //Solid hourglass (concave)
            #local EffectWidth = P1;
            #local NSteps = P2;
            #local TempCharacter = object {
               union {
                  #local SegmentLength = TextDepth / NSteps;
                  #local DeltaTheta = 90 / (NSteps - 1);
                  #local CurZ = TextDepth;
                  #local Theta = 0;
                  #for (J, 1, NSteps)
                     #local CurBorder = EffectWidth * sin (radians (Theta));
                     MakeCharacter (I, CurBorder)
                     #local Segment = object {Character translate -1 * z scale <1, 1, SegmentLength>}
                     object {Segment translate CurZ * z}
                     #local CurZ = CurZ - SegmentLength;
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -TextDepth * z //Back is at z = 0
            } //object
            #declare Character = object {TempCharacter}
            #break
         #case (14) //Hollow inside, bordered
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local SolidWidth = P3 / TextScale;
            #local BorderDepth = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local SolidWidth = SolidWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character texture {TextColor_Outer}}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Middle = object {Character texture {TextColor_Inner}}
            MakeCharacter (I, BorderWidth + SolidWidth + InvisibleBorderWidth)
            #local Character_Inner = object {Character texture {TextColor_Outer}}
            MakeCharacter (I, BorderWidth + SolidWidth + BorderWidth + InvisibleBorderWidth)
            #local Character_Hole = object {Character texture {TextColor_Outer}}
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Middle scale <1, 1, 1.2> translate -.1 * z}
               } //difference
            } //object
            #declare Character = object {
               union {
                  object {Character}
                  object {Character_Middle translate BorderDepth * z}
               } //union
            } //object
            #declare Character = object {
               difference {
                  object {Character}
                  object {Character_Inner scale <1, 1, 1.2> translate -.1 * z}
               } //difference
            } //object
            #declare Character = object {
               union {
                  object {Character}
                  object {Character_Inner}
               } //union
            } //object
            #declare Character = object {
               difference {
                  object {Character}
                  object {Character_Hole scale <1, 1, 1.2> translate -.1 * z}
               } //difference
            } //object
            #declare Character = object {
               intersection {
                  object {Character scale <1, 1, 1.1>}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (15) //Hollow stripe with raised center
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local StripeWidth = P3 / TextScale;
            #local StripeDepth = P4;
            #local InnerHeight = P5;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local StripeWidth = StripeWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character texture {TextColor_Outer}}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #declare Character = object {Character scale <1, 1, 1.2 + StripeDepth> texture {TextColor_Outer}}
            #local Character_Outer = object {
               difference {
                  object {Character_Outer}
                  object {Character translate -1.2 * z}
               } //difference
            } //object
            MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
            #declare Character = object {
               intersection {
                  union {
                     object {Character_Outer}
                     object {Character translate -InnerHeight * z texture {TextColor_Inner}}
                  } //union
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (16) //Angled reverse bevel
            #local BorderDepth = P1;
            #local NSteps = P2;
            MakeCharacter (I, 0)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            #local Character_Inner = object {
               union {
                  #local Increment = BorderDepth / NSteps;
                  #for (J, 1, NSteps)
                     MakeCharacter (I, Increment * J)
                     #declare Character = object {
                        intersection {
                           object {Character translate .1 * z}
                           plane {z, 1}
                        } //intersection
                     } //object
                     object {Character translate (Increment * J) * z}
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -1 * z
            } //object
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner}
               } //difference
               translate -TextDepth * z //Back is at z = 0
            } //object
            #break
         #case (17) //Rounded reverse bevel/concave
            #local BorderDepth = P1;
            #local NSteps = P2;
            #local R = BorderDepth;
            MakeCharacter (I, 0)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            #local Character_Inner = object {
               union {
                  #local Increment = 90 / NSteps;
                  #for (J, 1, NSteps)
                     #local CurAngle = J * Increment;
                     #local CurBorderWidth = R * (1 + cos (radians (CurAngle + 180)));
                     #local CurBorderDepth = R * sin (radians (CurAngle));
                     MakeCharacter (I, CurBorderWidth)
                     #declare Character = object {
                        intersection {
                           object {Character translate .1 * z}
                           plane {z, 1}
                        } //intersection
                     } //object
                     object {Character translate CurBorderDepth * z}
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -1 * z
            } //object
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner}
               } //difference
               translate -TextDepth * z //Back is at z = 0
            } //object
         #break
         #case (18) //Rounded reverse bevel/convex
            #local BorderDepth = P1;
            #local NSteps = P2;
            #local R = BorderDepth;
            MakeCharacter (I, 0)
            #local Character_Outer = object {
               intersection {
                  object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
            } //object
            #local Character_Inner = object {
               union {
                  #local Increment = 90 / NSteps;
                  #for (J, 1, NSteps)
                     #local CurAngle = J * Increment;
                     #local CurBorderDepth = R * (1 + cos (radians (CurAngle + 180)));
                     #local CurBorderWidth = R * sin (radians (CurAngle));
                     MakeCharacter (I, CurBorderWidth)
                     #declare Character = object {
                        intersection {
                           object {Character translate .1 * z}
                           plane {z, 1}
                        } //intersection
                     } //object
                     object {Character translate CurBorderDepth * z}
                  #end //#for
               } //union
               texture {TextColor_Outer}
               translate -1 * z
            } //object
            #declare Character = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner}
               } //difference
               translate -TextDepth * z //Back is at z = 0
            } //object
         #break
         #case (19) //Stack
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local SpacerDepth = P3;
            #local NSteps = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {Character scale <1, 1, 1.2> texture {TextColor_Outer}}
            MakeCharacter (I, InvisibleBorderWidth)
            #declare Character = object {Character texture {TextColor_Outer}}
            #declare Character = object {
               union {
                  difference {
                     intersection {
                        object {Character scale <1, 1, 1.1>}
                        plane {z, TextDepth texture {TextColor_Back}}
                     } //intersection
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  #for (J, 1, NSteps - 1)
                     difference {
                        object {
                           Character
                           scale <1, 1, TextDepth>
                        } //object
                        object {Character_Inner translate -.1 * z}
                        translate (-TextDepth * J - SpacerDepth * J) * z
                     } //difference
                  #end //#for
               } //union
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (20) //Raised inner border
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local RaisedBorderWidth = P3 / TextScale;
            #local RaisedBorderHeight = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local RaisedBorderWidth = RaisedBorderWidth / S;
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Inner}}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {Character}
            MakeCharacter (I, BorderWidth + RaisedBorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               difference {
                  object {Character_Inner}
                  object {Character translate -.1 * z}
               } //difference
               texture {TextColor_Outer}
            } //object
            #declare Character = object {
               intersection {
                  union {
                     object {Character_Outer}
                     object {Character_Inner translate -RaisedBorderHeight * z}
                  } //union
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
         #case (21) //Specular highlights
            #local InvisibleBorderWidth = P1 / TextScale;
            #local BorderWidth = P2 / TextScale;
            #local BorderDepth = P3;
            #local Angle = P4;
            #local S = 1 / (1 - InvisibleBorderWidth * 2);
            #local BorderWidth = BorderWidth / S;
            #local R = BorderWidth * 2.5;
            #local XOffset = R * sin (radians (Angle));
            #local YOffset = R * cos (radians (Angle));
            MakeCharacter (I, InvisibleBorderWidth)
            #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
            MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
            #local Character_Inner = object {
               intersection {
                  object {Character scale <1, 1, 1.1>}
                  plane {z, 1}
               } //intersection
               texture {TextColor_Inner}
            } //object
            #declare Character_Outer = object {
               difference {
                  object {Character_Outer}
                  object {Character_Inner translate (-1 + BorderDepth) * z}
               } //difference
            } //object
            MakeCharacter (I, BorderWidth * 2 + InvisibleBorderWidth)
            #local Character_Inner = object {Character}
            MakeCharacter (I, BorderWidth * 1 + InvisibleBorderWidth)
            #local Character_Inner = object {
               difference {
                  object {Character_Inner}
                  object {Character translate <XOffset, YOffset, -.1>}
               } //difference
               texture {TextColor_Outer}
            } //object
            #declare Character = object {
               intersection {
                  union {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //union
                  plane {z, TextDepth texture {TextColor_Back}}
               } //intersection
               scale <S, S, 1>
               translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            } //object
            #break
      #end //#switch
      #declare BorderCharacter [I] = object {Character}
   #end //#for

#end //#macro Stylize
