#version 3.7;

//------------------------------------------
// Nine smoothly connected Bezier patches
// Adapted from: bezier.pov written by Ilan Schnell
// http://ilan.schnell-web.net/prog/povray/bicubic.pov
//
// POV-Ray Scene description language written by
// Bill Walker - 2016
//------------------------------------------



//  To do - 

//  Cartesian grid - big and small 'ticks'
//  transparent texture on grid, to show TempGradient on interior_texture
//  support frame
//  level indicator
//  incoming sine waves


global_settings { assumed_gamma 1.0 }
#include "colors.inc"
#include "TempGradient.inc"
#include "InterpolateControlPointsFrom.mcr"

//background { rgb 0.0 }

#declare Original = camera {
	location <3.2,  5.0, -9.0>
	look_at  <3.0, -1.5,  3> angle 55
	up y right 2*x}

#declare Top = camera {	
	location <10, 27, 9.7>
	look_at  <10, 0, 11>   angle 55}

#declare Level = camera {
	location <-25, 5, 10>
	look_at  <5, 5, 10>   angle 55}


#declare DownFromFront = camera {
	location <10, 30, -10>
	look_at  <10, 1,  10>   angle 55}

camera {Top}

light_source {<500,	500,	-500> rgb <0.9, 1, 0.9> }
#declare o = <0, 0, 0>;

########################################
#declare CornerPoints = true;
#declare Cylinders = false;

#declare CyR = 0.02;
#declare Spheres = false;
#declare SphR = 0.25;
#declare Slopes = false;
#declare ControlToSurface = false;

#declare UVtex = true;
#declare UVoverride = false; // elevation line mode
#declare UVMAP = 2;
#declare Individual = false;
#declare Fix = 180; // rotates texture around x by this many degrees
########################################

// 9 patches:  BLUE	RED	ORANGE  	GREEN	YELLOW	PURPLE		BLACK	Grey50	Grey20
// 9 Patches:  A B C D E F
#declare PatchRows = 3;
#declare PatchColumns = 3;

// A - BEZIER PATCH corner points
#declare A11 = <1,(0),19>;		#declare A12 = <3,0,19>; 		#declare A13 = <5,0,19>; 		#declare A14 = <7,(0),19>; // r 1
#declare A21 = <1, 0, 17>; 		#declare A22 = <3,0,17>; 		#declare A23 = <5,0,17>; 		#declare A24 = <7, 0, 17>;
#declare A31 = <1, 0, 15>; 		#declare A32 = <3,0,15>; 		#declare A33 = <5,0,15>; 		#declare A34 = <7, 0, 15>;
#declare A41 = <1,(0),13>; 		#declare A42 = <3,0,13>; 		#declare A43 = <5,0,13>; 		#declare A44 = <7,(0),13>; // r 4
#declare APoints = array[4] {A11, A41, A14, A44};

// B - BEZIER PATCH corner points
#declare B11 = A14; 			#declare B12 = <9,0,19>; 		#declare B13 = <11,0,19>; 		#declare B14 = <13,(0),19>; // r 1
#declare B21 = <7,0,17>; 		#declare B22 = <9,0,17>; 		#declare B23 = <11,0,17>; 		#declare B24 = <13, 0, 17>;
#declare B31 = <7,0,15>; 		#declare B32 = <9,0,15>; 		#declare B33 = <11,0,15>; 		#declare B34 = <13, 0, 15>;
#declare B41 = A44; 			#declare B42 = <9,0,13>; 		#declare B43 = <11,0,13>; 		#declare B44 = <13,(0),13>; // r 4
#declare BPoints = array[4] {B11, B41, B14, B44};

// C - BEZIER PATCH corner points
#declare C11 = B14; 			#declare C12 = <15,0,19>; 		#declare C13 = <17,0,19>; 		#declare C14 = <19,(0),19>; // r 1
#declare C21 = <13,0,17>; 		#declare C22 = <15,0,17>; 		#declare C23 = <17,0,17>; 		#declare C24 = <19, 0, 17>;
#declare C31 = <13,0,15>; 		#declare C32 = <15,0,15>; 		#declare C33 = <17,0,15>; 		#declare C34 = <19, 0, 15>;
#declare C41 = B44; 			#declare C42 = <15,0,13>; 		#declare C43 = <17,0,13>; 		#declare C44 = <19,(0),13>; // r 4
#declare CPoints = array[4] {C11, C41, C14, C44};

// D - BEZIER PATCH corner points
#declare D11 = A41; 			#declare D12 = A42; 			#declare D13 = A43; 			#declare D14 = A44; 		// r 1
#declare D21 = <1, 0, 11>; 		#declare D22 = <3,0,11>; 		#declare D23 = <5,0,11>; 		#declare D24 = <7, 0, 11>;
#declare D31 = <1, 0, 9>; 		#declare D32 = <3,0,9>; 			#declare D33 = <5,0,9>; 			#declare D34 = <7, 0, 9>;
#declare D41 = <1,(0),7>; 		#declare D42 = <3,0,7>; 			#declare D43 = <5,0,7>; 			#declare D44 = <7,(0),7>; // r 4
#declare DPoints = array[4] {D11, D41, D14, D44};

// E - BEZIER PATCH corner points
#declare E11 = D14; 			#declare E12 = B42; 			#declare E13 = B43; 			#declare E14 = B44; 		// r 1
#declare E21 = <7,0,11>; 		#declare E22 = <9,0,11>; 		#declare E23 = <11,0,11>; 		#declare E24 = <13, 0, 11>;
#declare E31 = <7,0,9>; 			#declare E32 = <9,0,9>; 			#declare E33 = <11,0,9>; 		#declare E34 = <13, 0, 9>;
#declare E41 = D44; 			#declare E42 = <9,0,7>; 			#declare E43 = <11,0,7>; 		#declare E44 = <13,(0),7>; // r 4
#declare EPoints = array[4] {E11, E41, E14, E44};

// F - BEZIER PATCH corner points
#declare F11 = E14; 			#declare F12 = C42; 			#declare F13 = C43; 			#declare F14 = C44; 		// r 1
#declare F21 = <13,0,11>; 		#declare F22 = <15,0,11>; 		#declare F23 = <17,0,11>; 		#declare F24 = <19, 0, 11>;
#declare F31 = <13,0,9>; 		#declare F32 = <15,0,9>; 		#declare F33 = <17,0,9>; 		#declare F34 = <19, 0, 9>;
#declare F41 = E44; 			#declare F42 = <15,0,7>; 		#declare F43 = <17,0,7>; 		#declare F44 = <19,(0),7>; // r 4
#declare FPoints = array[4] {F11, F41, F14, F44};

// G - BEZIER PATCH corner points
#declare G11 = D41; 			#declare G12 = D42; 			#declare G13 = D43; 			#declare G14 = D44; 		// r 1
#declare G21 = <1, 0, 5>; 		#declare G22 = <3,0,5>; 			#declare G23 = <5,0,5>; 			#declare G24 = <7, 0, 5>;
#declare G31 = <1, 0, 3>; 		#declare G32 = <3,0,3>; 			#declare G33 = <5,0,3>; 			#declare G34 = <7, 0, 3>;
#declare G41 = <1,(1),1>; 		#declare G42 = <3,0,1>; 			#declare G43 = <5,0,1>; 			#declare G44 = <7,(0),1>; // r 4
#declare GPoints = array[4] {G11, G41, G14, G44};

// H - BEZIER PATCH corner points
#declare H11 = G14; 			#declare H12 = E42; 			#declare H13 = E43; 			#declare H14 = E44; 		// r 1
#declare H21 = <7,0,5>; 			#declare H22 = <9,0,5>; 			#declare H23 = <11,0,5>; 		#declare H24 = <13, 0, 5>;
#declare H31 = <7,0,3>; 			#declare H32 = <9,0,3>; 			#declare H33 = <11,0,3>; 		#declare H34 = <13, 0, 3>;
#declare H41 = G44; 			#declare H42 = <9,0,1>; 			#declare H43 = <11,0,1>; 		#declare H44 = <13,(0),1>; // r 4
#declare HPoints = array[4] {H11, H41, H14, H44};

// I - BEZIER PATCH corner points
#declare I11 = H14; 			#declare I12 = F42; 			#declare I13 = F43; 			#declare I14 = F44; 		// r 1
#declare I21 = <13,0,5>; 		#declare I22 = <15,0,5>; 		#declare I23 = <17,0,5>; 		#declare I24 = <19, 0, 5>;
#declare I31 = <13,0,3>; 		#declare I32 = <15,0,3>; 		#declare I33 = <17,0,3>; 		#declare I34 = <19, 0, 3>;
#declare I41 = H44; 			#declare I42 = <15,0,1>; 		#declare I43 = <17,0,1>; 		#declare I44 = <19,(0),1>; // r 4
#declare IPoints = array[4] {I11, I41, I14, I44};


// Interpolate major rows to establish control points as endpoints for fine column interpolation
//***  Initially adjacent edges were skippped - but they need to be interpolated too!
//		can skip actual interpolation and just set next edge equal to interpolated

// Interpolate ROW 1 data
#declare Given_data = array[10] {A11, <0,0,0>, <0,0,0>, A14, <0,0,0>, <0,0,0>, B14, <0,0,0>, <0,0,0>, C14};
#declare Interpolated_data = InterpolateControlPointsFrom (Given_data);
#debug "Interpolating MAJOR Row 1 \n"
#for (i, 0, 9)
#debug concat("<", vstr(3, Interpolated_data[i], ", ", 3, 0), ">, ")
#end
#debug " \n"
#declare A12 = Interpolated_data[1]; #declare A13 = Interpolated_data[2]; 
#declare B12 = Interpolated_data[4]; #declare B13 = Interpolated_data[5]; 
#declare C12 = Interpolated_data[7]; #declare C13 = Interpolated_data[8]; 

// Interpolate ROW 4 data
#declare Given_data = array[10] {A41, <0,0,0>, <0,0,0>, A44, <0,0,0>, <0,0,0>, B44, <0,0,0>, <0,0,0>, C44};
#declare Interpolated_data = InterpolateControlPointsFrom (Given_data);
#debug "Interpolating MAJOR Row 2 \n"
#for (i, 0, 9)
#debug concat("<", vstr(3, Interpolated_data[i], ", ", 3, 0), ">, ")
#end
#debug " \n"
#declare A42 = Interpolated_data[1]; #declare A43 = Interpolated_data[2]; 
#declare B42 = Interpolated_data[4]; #declare B43 = Interpolated_data[5]; 
#declare C42 = Interpolated_data[7]; #declare C43 = Interpolated_data[8]; 			//  <-- This last was erroneously set at _B_43

#declare D12 = Interpolated_data[1]; #declare D13 = Interpolated_data[2]; 
#declare E12 = Interpolated_data[4]; #declare E13 = Interpolated_data[5]; 			//  <-- This is what was missing
#declare F12 = Interpolated_data[7]; #declare F13 = Interpolated_data[8]; 


// Interpolate ROW 8 data
#declare Given_data = array[10] {D41, <0,0,0>, <0,0,0>, D44, <0,0,0>, <0,0,0>, E44, <0,0,0>, <0,0,0>, F44};
#declare Interpolated_data = InterpolateControlPointsFrom (Given_data);
#debug "Interpolating MAJOR Row 3 \n"
#for (i, 0, 9)
#debug concat("<", vstr(3, Interpolated_data[i], ", ", 3, 0), ">, ")
#end
#debug " \n"
#declare D42 = Interpolated_data[1]; #declare D43 = Interpolated_data[2]; 
#declare E42 = Interpolated_data[4]; #declare E43 = Interpolated_data[5]; 
#declare F42 = Interpolated_data[7]; #declare F43 = Interpolated_data[8]; 

#declare G12 = Interpolated_data[1]; #declare G13 = Interpolated_data[2]; 
#declare H12 = Interpolated_data[4]; #declare H13 = Interpolated_data[5];			//  <-- This is what was missing
#declare I12 = Interpolated_data[7]; #declare I13 = Interpolated_data[8]; 

// Interpolate ROW 12 data
#declare Given_data = array[10] {G41, <0,0,0>, <0,0,0>, G44, <0,0,0>, <0,0,0>, H44, <0,0,0>, <0,0,0>, I44};
#declare Interpolated_data = InterpolateControlPointsFrom (Given_data);
#debug "Interpolating MAJOR Row 4 \n"
#for (i, 0, 9)
#debug concat("<", vstr(3, Interpolated_data[i], ", ", 3, 0), ">, ")
#end
#debug " \n"
#declare G42 = Interpolated_data[1]; #declare G43 = Interpolated_data[2]; 
#declare H42 = Interpolated_data[4]; #declare H43 = Interpolated_data[5]; 
#declare I42 = Interpolated_data[7]; #declare I43 = Interpolated_data[8]; 

/*
// reestablish continuity
#declare B11 = A14; 
#declare B21 = A24; 
#declare B31 = A34; 
#declare B41 = A44; 

#declare C11 = B14;
#declare C21 = B24;
#declare C31 = B34;
#declare C41 = B44; 



#declare D11 = A41; 	#declare D12 = A42; 		#declare D13 = A43;		#declare D14 = A44;

#declare E11 = D14; 	#declare E12 = B42; 		#declare E13 = B43;		#declare E14 = B44;
#declare E21 = D24;
#declare E31 = D34;
#declare E41 = D44; 

#declare F11 = E14; 	#declare F12 = C42; 		#declare F13 = C43;		#declare F14 = C44;
#declare F21 = E24;
#declare F31 = E34;
#declare F41 = E44;



#declare G11 = D41;		#declare G12 = D42; 		#declare G13 = D43;		#declare G14 = D44;

#declare H11 = G14; 	#declare H12 = E42; 		#declare H13 = E43;		#declare H14 = E44;
#declare H21 = G24;
#declare H31 = G34;
#declare H41 = G44; 

#declare I11 = H14; 	#declare I12 = F42; 		#declare I13 = F43;		#declare I14 = F44;
#declare I21 = H24;
#declare I31 = H34;
#declare I41 = H44; 
*/




#declare PointGrid = array [12][12] {
{A11, A12, A13, A14, B11, B12, B13, B14, C11, C12, C13, C14},
{A21, A22, A23, A24, B21, B22, B23, B24, C21, C22, C23, C24},
{A31, A32, A33, A34, B31, B32, B33, B34, C31, C32, C33, C34},
{A41, A42, A43, A44, B41, B42, B43, B44, C41, C42, C43, C44},

{D11, D12, D13, D14, E11, E12, E13, E14, F11, F12, F13, F14},
{D21, D22, D23, D24, E21, E22, E23, E24, F21, F22, F23, F24},
{D31, D32, D33, D34, E31, E32, E33, E34, F31, F32, F33, F34},
{D41, D42, D43, D44, E41, E42, E43, E44, F41, F42, F43, F44},

{G11, G12, G13, G14, H11, H12, H13, H14, I11, I12, I13, I14},
{G21, G22, G23, G24, H21, H22, H23, H24, I21, I22, I23, I24},
{G31, G32, G33, G34, H31, H32, H33, H34, I31, I32, I33, I34},
{G41, G42, G43, G44, H41, H42, H43, H44, I41, I42, I43, I44}
}

#debug "First-Pass PointGrid \n"
#for (i, 0, 11)
// Send all points to debug stream before interpolating columns
	#for (j, 0, 11)
	#debug concat("<", vstr(3, PointGrid[i][j], ", ", 1, 0), "> ")
	#end
#debug " \n"
#end
#debug " \n\n"

#for (i, 0, 11)
// Interpolate All column data
#declare Given_data = array[10] {PointGrid[11][i], <0,0,0>, <0,0,0>, PointGrid[7][i], <0,0,0>, <0,0,0>, PointGrid[3][i], <0,0,0>, <0,0,0>, PointGrid[0][i]};
#declare Interpolated_data = InterpolateControlPointsFrom (Given_data);
#declare PointGrid[10][i] = Interpolated_data[1]; #declare PointGrid[9][i] = Interpolated_data[2]; 
#declare PointGrid[6][i]  = Interpolated_data[4]; #declare PointGrid[5][i] = Interpolated_data[5]; 
#declare PointGrid[2][i]  = Interpolated_data[7]; #declare PointGrid[1][i] = Interpolated_data[8]; 

#debug concat ("Interpolating Column ", str(i, 3, 0), "\n")
#for (j, 0, 9)
#debug concat("<", vstr(3, Interpolated_data[j], ", ", 1, 0), ">, ")
#end
#debug " \n"
#end


#debug "Final PointGrid \n"
#for (i, 0, 11)
// Send all points to debug stream
	#for (j, 0, 11)
	#debug concat("<", vstr(3, PointGrid[i][j], ", ", 1, 0), "> ")
	#end
#debug " \n"
#end
#debug " \n\n"


/*
// reestablish continuity
#declare B11 = A14; 
#declare B21 = A24; 
#declare B31 = A34; 
#declare B41 = A44; 

#declare C11 = B14;
#declare C21 = B24;
#declare C31 = B34;
#declare C41 = B44; 



#declare D11 = A41; 	#declare D12 = A42; 		#declare D13 = A43;		#declare D14 = A44;

#declare E11 = D14; 	#declare E12 = B42; 		#declare E13 = B43;		#declare E14 = B44;
#declare E21 = D24;
#declare E31 = D34;
#declare E41 = D44; 

#declare F11 = E14; 	#declare F12 = C42; 		#declare F13 = C43;		#declare F14 = C44;
#declare F21 = E24;
#declare F31 = E34;
#declare F41 = E44;



#declare G11 = D41;		#declare G12 = D42; 		#declare G13 = D43;		#declare G14 = D44;

#declare H11 = G14; 	#declare H12 = E42; 		#declare H13 = E43;		#declare H14 = E44;
#declare H21 = G24;
#declare H31 = G34;
#declare H41 = G44; 

#declare I11 = H14; 	#declare I12 = F42; 		#declare I13 = F43;		#declare I14 = F44;
#declare I21 = H24;
#declare I31 = H34;
#declare I41 = H44; 

*/

#declare PointGrid = array [12][12] {
{A11, A12, A13, A14, B11, B12, B13, B14, C11, C12, C13, C14},
{A21, A22, A23, A24, B21, B22, B23, B24, C21, C22, C23, C24},
{A31, A32, A33, A34, B31, B32, B33, B34, C31, C32, C33, C34},
{A41, A42, A43, A44, B41, B42, B43, B44, C41, C42, C43, C44},

{D11, D12, D13, D14, E11, E12, E13, E14, F11, F12, F13, F14},
{D21, D22, D23, D24, E21, E22, E23, E24, F21, F22, F23, F24},
{D31, D32, D33, D34, E31, E32, E33, E34, F31, F32, F33, F34},
{D41, D42, D43, D44, E41, E42, E43, E44, F41, F42, F43, F44},

{G11, G12, G13, G14, H11, H12, H13, H14, I11, I12, I13, I14},
{G21, G22, G23, G24, H21, H22, H23, H24, I21, I22, I23, I24},
{G31, G32, G33, G34, H31, H32, H33, H34, I31, I32, I33, I34},
{G41, G42, G43, G44, H41, H42, H43, H44, I41, I42, I43, I44}
}

#declare AllPoints = array [144] {
A11, A12, A13, A14, B11, B12, B13, B14, C11, C12, C13, C14,
A21, A22, A23, A24, B21, B22, B23, B24, C21, C22, C23, C24,
A31, A32, A33, A34, B31, B32, B33, B34, C31, C32, C33, C34,
A41, A42, A43, A44, B41, B42, B43, B44, C41, C42, C43, C44,

D11, D12, D13, D14, E11, E12, E13, E14, F11, F12, F13, F14,
D21, D22, D23, D24, E21, E22, E23, E24, F21, F22, F23, F24,
D31, D32, D33, D34, E31, E32, E33, E34, F31, F32, F33, F34,
D41, D42, D43, D44, E41, E42, E43, E44, F41, F42, F43, F44,

G11, G12, G13, G14, H11, H12, H13, H14, I11, I12, I13, I14,
G21, G22, G23, G24, H21, H22, H23, H24, I21, I22, I23, I24,
G31, G32, G33, G34, H31, H32, H33, H34, I31, I32, I33, I34,
G41, G42, G43, G44, H41, H42, H43, H44, I41, I42, I43, I44
}

#declare I = 0;
#while (I < 144)
sphere {AllPoints[I], SphR/2 no_shadow texture {pigment{Yellow}   finish {phong 0.6 phong_size 20}}}
#declare I = I + 1;
#end

//#####################################################################################################
//#####################################################################################################
#if (CornerPoints = true)
	#declare APoints = array[4] {A11, A14, A41, A44};
	#declare BPoints = array[4] {B11, B14, B41, B44};
	#declare CPoints = array[4] {C11, C14, C41, C44};
	#declare DPoints = array[4] {D11, D14, D41, D44};
	#declare EPoints = array[4] {E11, E14, E41, E44};
	#declare FPoints = array[4] {F11, F14, F41, F44};
	#declare GPoints = array[4] {G11, G14, G41, G44};
	#declare HPoints = array[4] {H11, H14, H41, H44};
	#declare IPoints = array[4] {I11, I14, I41, I44};

	#declare I = 0;
	#while (I < 4)
		sphere {APoints[I], SphR no_shadow texture {pigment{Blue}   finish {phong 0.6 phong_size 20}}}
		sphere {BPoints[I], SphR no_shadow texture {pigment{Red}    finish {phong 0.6 phong_size 20}}}
		sphere {CPoints[I], SphR no_shadow texture {pigment{Orange} finish {phong 0.6 phong_size 20}}}
		sphere {DPoints[I], SphR no_shadow texture {pigment{Green}  finish {phong 0.6 phong_size 20}}}
		sphere {EPoints[I], SphR no_shadow texture {pigment{Yellow} finish {phong 0.6 phong_size 20}}}
		sphere {FPoints[I], SphR no_shadow texture {pigment{Violet} finish {phong 0.6 phong_size 20}}}
		sphere {GPoints[I], SphR no_shadow texture {pigment{Gray10} finish {phong 0.6 phong_size 20}}}
		sphere {HPoints[I], SphR no_shadow texture {pigment{Gray50} finish {phong 0.6 phong_size 20}}}
		sphere {IPoints[I], SphR no_shadow texture {pigment{Gray90} finish {phong 0.6 phong_size 20}}}
		#declare I = I + 1;
	#end
#end
//#####################################################################################################
//#####################################################################################################



#declare PatchA = bicubic_patch {
   	type 1 flatness 0.001
   	u_steps 4 v_steps 4  //  uses 2^u_steps * 2^v_steps triangles to create patch
   	#if (Individual = true)
   		uv_vectors <0, 0> <1, 0> <1, 1> <0, 1>  // original definition
   	#else
   	//  DEFINE THIS PATCH'S POSITION IN THE GRID
   	#declare Col = 1;
   	#declare Row = 1;
   	// Calculate proper uv vectors for unified mapping
   	uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
   	#end
   	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
   	//uv_mapping
   	#if (UVtex = false)
   	texture {
      	pigment {
         		checker 
         		color rgbf <1, 1, 1, 0.5> 
         		color rgbf <0, 0, 1, 0.7> 
         		scale 1/3
      	} // end pigment pattern
      	finish {phong 0.6 phong_size 20}
   	} // end texture
   	#end
   no_shadow
} // end bicubic patch



#declare PatchB = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0, 0> <1, 0> <1, 1> <0, 1>
	#else
	//  DEFINE THIS PATCH'S POSITION IN THE GRID
	#declare Col = 2;
   	#declare Row = 1;
   	// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
	//uv_mapping
	#if (UVtex = false)
	texture {
		pigment {
			checker 
			color rgbf <1, 1, 1, 0.5> 
			color rgbf <1, 0, 0, 0.7> 
			scale 1/3
		}
	finish {phong 0.6 phong_size 20}
	}
	#end
	no_shadow
}

#declare PatchC = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0, 0> <1, 0> <1, 1> <0, 1>
	#else
	//  DEFINE THIS PATCH'S POSITION IN THE GRID
	#declare Col = 3;
   	#declare Row = 1;
   	// Calculate proper uv vectors for unified mapping
   	uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
	//uv_mapping
	#if (UVtex = false)
	texture {
		pigment {
			checker 
			color rgbf <1, 1, 1, 0.5> 
			color rgbf <1, 0.5, 0, 0.7> 
			scale 1/3
		}
	finish {phong 0.6 phong_size 20}
	}
	#end
	no_shadow
}


#declare PatchD = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
	//  DEFINE THIS PATCH'S POSITION IN THE GRID
	#declare Col = 1;
   	#declare Row = 2;
   	// Calculate proper uv vectors for unified mapping
   	uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
	//uv_mapping
	#if (UVtex = false)
	texture {
		pigment {
		checker 
		color rgbf <1, 1, 1, 0.5> 
		color rgbf <0, 1, 0, 0.7> 
		scale 1/3
		}
		finish {phong 0.6 phong_size 20}
	}
	#end
	no_shadow
}



#declare PatchE = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
		//  DEFINE THIS PATCH'S POSITION IN THE GRID
		#declare Col = 2;
   		#declare Row = 2;
   		// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
	//uv_mapping
	#if (UVtex = false)
		texture {pigment {checker color rgbf <1, 1, 1, 0.5> color rgbf <1, 1, 0, 0.7> scale 1/3} finish {phong 0.6 phong_size 20} }
	#end
	no_shadow
}

#declare PatchF = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
		//  DEFINE THIS PATCH'S POSITION IN THE GRID
		#declare Col = 3;
   		#declare Row = 2;
   		// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
   	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
   //uv_mapping
   #if (UVtex = false)
   texture {
      pigment {
         checker 
         color rgbf <1, 1, 1, 0.5> 
         color rgbf <1, 0, 1, 0.7> 
         scale 1/3
      }
      finish {phong 0.6 phong_size 20}
   }
   #end
   no_shadow
}

#declare PatchG = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
		//  DEFINE THIS PATCH'S POSITION IN THE GRID
		#declare Col = 1;
   		#declare Row = 3;
   		// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
   //uv_mapping
   #if (UVtex = false)
   texture {
      pigment {
         checker 
         color rgbf <1, 1, 1, 0.5> 
         color rgbf <1, 1, 1, 0.1> 
         scale 1/3
      }
      finish {phong 0.6 phong_size 20}
   }
   #end
   no_shadow
}

#declare PatchH = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
		//  DEFINE THIS PATCH'S POSITION IN THE GRID
		#declare Col = 2;
   		#declare Row = 3;
   		// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
   //uv_mapping
   #if (UVtex = false)
   texture {
      pigment {
         checker 
         color rgbf <1, 1, 1, 0.5> 
         color rgbf <1, 1, 1, 0.5> 
         scale 1/3
      }
      finish {phong 0.6 phong_size 20}
   }
   #end
   no_shadow
}


#declare PatchI = bicubic_patch {
	type 1 flatness 0.001
	u_steps 4 v_steps 4
	#if (Individual = true)
		uv_vectors <0,0> <1,0> <1,1> <0,1>
	#else
		//  DEFINE THIS PATCH'S POSITION IN THE GRID
		#declare Col = 3;
   		#declare Row = 3;
   		// Calculate proper uv vectors for unified mapping
   		uv_vectors <(Col-1)/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, (Row-1)/PatchRows> <Col/PatchColumns, Row/PatchRows> <(Col-1)/PatchColumns, Row/PatchRows> // define as part of 4-patch whole
	#end
	PointGrid[(Row-1)*4+0][(Col-1)*4+0], PointGrid[(Row-1)*4+0][(Col-1)*4+1], PointGrid[(Row-1)*4+0][(Col-1)*4+2], PointGrid[(Row-1)*4+0][(Col-1)*4+3]
	PointGrid[(Row-1)*4+1][(Col-1)*4+0], PointGrid[(Row-1)*4+1][(Col-1)*4+1], PointGrid[(Row-1)*4+1][(Col-1)*4+2], PointGrid[(Row-1)*4+1][(Col-1)*4+3]
	PointGrid[(Row-1)*4+2][(Col-1)*4+0], PointGrid[(Row-1)*4+2][(Col-1)*4+1], PointGrid[(Row-1)*4+2][(Col-1)*4+2], PointGrid[(Row-1)*4+2][(Col-1)*4+3]
	PointGrid[(Row-1)*4+3][(Col-1)*4+0], PointGrid[(Row-1)*4+3][(Col-1)*4+1], PointGrid[(Row-1)*4+3][(Col-1)*4+2], PointGrid[(Row-1)*4+3][(Col-1)*4+3]
   //uv_mapping
   #if (UVtex = false)
   texture {
      pigment {
         checker 
         color rgbf <1, 1, 1, 0.5> 
         color rgbf <1, 1, 1, 0.9> 
         scale 1/3
      }
      finish {phong 0.6 phong_size 20}
   }
   #end
   no_shadow
}


#declare Patches = #union {
object {PatchA}
object {PatchB}
object {PatchC}
object {PatchD}
object {PatchE}
object {PatchF}
object {PatchG}
object {PatchH}
object {PatchI}
}



#object {Patches

//uv_vectors <0, 0> <1, 0> <1, 1> <0, 1> // standard mapping
#if (UVoverride = false)
uv_mapping // <--- comment out to get ELEVATION LINES   :)
#end

#if (UVtex = true)
	#switch (UVMAP)
	#case (0)
  	texture { pigment { image_map { png "POV-Ray.png" } scale 1} rotate x*Fix}
  	#break
  	
  	#case (1)
  	texture { pigment { image_map { png "grid.png" } } }
  	#break
  	
  	#case (2)
  	texture { pigment { image_map { png "grid2.png" } } }
  	#break
  	
  	#case (3)
  	texture { pigment { image_map { png "grid3.png" } } }
  	#break
  	
  	#case (4)
  	interior_texture  { pigment { image_map { png "Numbered_Grid-Red-Blue.png"  } scale 1} rotate x*Fix finish {phong 0.6 phong_size 20}}
  			texture { pigment { image_map { png "Numbered_Grid-Red-Green.png" } scale 1} rotate x*Fix finish {phong 0.6 phong_size 20}}
  	#break
  	
  	#case (5)
	pigment {TempGradient scale 1.5 translate y*-0.155}
  	
  	#end // end switch
#end
}

//cylinder {<4, -2, -4> <4, 4, -4> 0.5 pigment {TempGradient scale Range translate y*Shift} }
