
// vehicle model was inspired by a cover picture - Valentin Braitenberg  "Vehikel. Experimente mit kybernetischen Wesen"  http://www.amazon.de/Vehikel-Experimente-mit-kybernetischen-Wesen/dp/3499195313/ref=sr_1_7?s=books&ie=UTF8&qid=1455209234&sr=1-7

//___________________________________________________________________________________________________________________________________

// materials

#declare T3 =
material {
        texture {
                pigment {
                        aoi 
                        color_map {
                                [0.4    rgbt 1]
                                [0.45   rgbf <1,1,1,0.2>]
                                [0.5    rgb 1]
                                [0.55   rgbf <1,1,1,0.2>]
                                [0.6    rgbt 1]
                        }
                }
                normal {
                        dents -0.25
                        scale 0.002
                }
                finish {
                        emission 0.01 
                        diffuse 0.6 
                        reflection {0, 1 fresnel on}
                        conserve_energy
                }
        }
        interior {
                ior 1.3 
                media {absorption 0.02}
        }
}

#declare T4 =
material {
	texture {
		pigment {color rgb 0}
		finish {diffuse 0 reflection 0.7}
	}
	interior {ior 1.5}
}

#declare T5 =
material {
	texture {
		pigment {color rgb 0}
		finish {diffuse 0 reflection 0.55}
	}
	interior {ior 1.5}
}


#declare T6 =
material {
	texture {
		pigment {color rgb 0}
		finish {diffuse 0 reflection 0.3}
	}
	interior {ior 1.5}
}

#macro MetalMat (Color)

texture {
	aoi
	texture_map {
		[0      pigment {color srgb Color*1.5}       
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
                [0.4    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
                [0.6    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
		[1      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
	}        
}

#end
 
#declare cover =
material {
        MetalMat (<0.75,0,0.1>)
        interior {ior 1.5}
} 

#macro MetalMat2 (Color, Color2)
 
texture {
        uv_mapping
	gradient z
	rotate y*-90
	texture_map {
	        [0.35   aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
	        [0.35   aoi
	                texture_map {
	                	[0      pigment {color srgb Color2*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color2}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color2*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color2}
	                                }
                                ]
	                }
	        ]
	        [0.65   aoi
	                texture_map {
	                	[0      pigment {color srgb Color2*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color2}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color2*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color2}
	                                }
                                ]
	                }
	        ]
	        [0.65   aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
        }            
}

#end
 
#declare flag =
material {
        MetalMat2 (<1,0,1>*1.3, <1,1,1>*1.5)
        interior {ior 1.5}
} 

#declare SkinCol = <0.82,0.73,0.6>*1.5;

#declare Skin =
texture {
        pigment {color rgb SkinCol filter 0.75}
        finish {ambient 0 diffuse 0.6}
}
texture {
        pigment {
                aoi  
                color_map {
                        [0      rgb SkinCol*0.7 filter 1]
                        [0.167  rgb SkinCol*1.2 transmit 0.66]
                        [0.333  rgb SkinCol+2.5 filter 0.1]
                        [0.5    rgb 4]
                        [0.667  rgb SkinCol+2.5 filter 0.1]
                        [0.833  rgb SkinCol*1.2 transmit 0.66]
                        [1      rgb SkinCol*0.7 filter 1]
                }
        }
        finish {
                emission <0.006,0.0055,0.01>*0.01
                diffuse 0.6 
                specular 0.1 
                roughness 0.03 
        }
}
texture {
        pigment {color rgb SkinCol transmit 0.15}
        finish {
                emission SkinCol*0.01
                diffuse 0.6 
                specular 0.1 
                roughness 0.03
        }
        //normal {dents -0.25 scale 0.01}
}

#declare M_tyre =
material {
	texture {Skin}
        interior {
                ior 1.45
                media {
                        scattering {1, rgb 8 extinction 0.2}
                        method 3
                        aa_level 4
                        intervals 1
                        samples 10
                }
        }
}

#declare M_pla =
material {
        texture {
                pigment {color rgb 0.8}
                //normal {bozo 0.3 scale 0.01}
                finish {
                        diffuse 0.5 
                        phong 1 
                        phong_size 80 
                        reflection {0.1, 0.3}
                }
        }
}

#macro Dens (glowcol)

#declare density_1 =
density{
        spherical
        color_map {
                [0      rgb 0] 
                [0.05   rgb 0]
                [0.5    rgb glowcol]
                [1      rgb glowcol]
        }
}

#declare density_2 =
density {
        spherical
        color_map {
                [0      rgb 0] 
                [0.6    rgb 0]
                [0.7    rgb glowcol]
                [0.8    rgb glowcol*2]
                [1      rgb glowcol*16]  
        }
}

density {
        average
        density_map {
                [0.4    density_1]
                [1      density_2]
        }
}

#end

#macro hsl_ (H, S, L)			

#if (H < 1/3) #local R = min (2-H*6,1); #end
#if (H > 2/3) #local R = min ((H-2/3)*6,1); #end
#if (H >= 1/3 & H <= 2/3) #local R = 0; #end
#if (H <= 1/3) #local G_ = min (H*6,1); #end
#if (H > 1/3 & H < 2/3) #local G_ = min (2-(H-1/3)*6,1); #end
#if (H >= 2/3) #local G_ = 0; #end
#if (H > 1/3 & H <= 2/3) #local B = min ((H-1/3)*6,1); #end
#if (H > 2/3) #local B = min (2-(H-2/3)*6,1); #end
#if (H <= 1/3) #local B = 0; #end
#local RGB_ = ((1-S)+S*<R,G_,B>)*L;		

<RGB_.x,RGB_.y,RGB_.z>

#end   

#macro M_glow ()

#declare Color_ = (hsl_ (rand (colrand), 1, 1));

material {
        texture {
                pigment {color rgbt 1}
        }
        interior {
                ior 1.3
                media {
                        emission rgb 1
                        Dens (Color_)
                }
        }
}

#end
                         
//____________________________________________________________________________________________________________________________________________________

// "axles" 

// Casey Uhrig  http://www.c0d3m0nk3y.com/gallery/robot.html and http://www.c0d3m0nk3y.com/gallery/engine.html

#declare show_grip = 1;

#declare vent_rad = 10;
#declare vent_rim_rad = 1;

#declare VentRing = 
union {
	difference {
		cylinder {<0,0,-1>, <0,0,1>, vent_rad}
		cylinder {<0,0,-100>, <0,0,100>, vent_rad-vent_rim_rad}
	}
	difference {
		cylinder {<0,0,-0.5>, <0,0,0.5>, vent_rad-0.001}
		cylinder {<0,0,-100>, <0,0,100>, vent_rad-vent_rim_rad-0.5}
		cylinder {<0,0,-100>, <0,0,-0.5>, vent_rad-vent_rim_rad}
	}
	difference {
		cylinder {<0,0,-0.75>, <0,0,10>, vent_rad+0.25}
		cylinder {<0,0,-100>, <0,0,100>, vent_rad-vent_rim_rad+0.5}
	}
	
	torus {
		vent_rad-vent_rim_rad, 0.5
		rotate <90,0,0>
		translate <0,0,-0.5>
	}
	torus {
		vent_rad, 0.25
		rotate <90,0,0>
		translate <0,0,-0.75>
	}
}

#declare vent_slit_rad = 0.25;

#declare VentVents = 
union {
	difference {
		cylinder {<0,0,0>, <0,0,1>, vent_rad-0.5}
		#local xc = 0;
		#local yc = 0;
		#local xr = 7.5;
		#local yr = xr;
		#local num_slits = 12;
		#local ang_step = 3.14/num_slits;
		#local ang = 1.57+ang_step;
		#while (ang < 4.71)
    		        #local sx = xc+xr*cos (ang);
    		        #local sy = yc+yr*sin (ang);
			cylinder {<-sx,sy,-100>, <-sx,sy,100>, vent_slit_rad}
			cylinder {<sx,sy,-100>, <sx,sy,100>, vent_slit_rad}
			box {<-sx,-vent_slit_rad+sy,-100>, <sx,vent_slit_rad+sy,100>}
			#local ang = ang+ang_step;
		#end
	}
}

#declare Vent = 
union {
	object {VentRing}
	object {VentVents}
}

#declare brake_rot = -25;

#declare engine_mechanics = 
union {
	difference {
		cylinder {<-10,0,0>, <10,0,0>, 5}
		cylinder {<-100,0,0>, <100,0,0>, 4}
		difference {
			cylinder {<-100,0,0>, <-11,0,0>, 10}
			cylinder {<-100,0,0>, <100,0,0>, 4.8}
		}
        }
        sphere {<-4,0,-5>, 1.75}
        sphere {<-4,0,5>, 1.75}
        difference {
		torus {
			4, 1
			rotate <90,90,0>
			scale <6,1,1>
			translate <-10,0,0>
		}
		difference {
			cylinder {<-100,0,0>, <-13,0,0>, 10}
			cylinder {<-100,0,0>, <100,0,0>, 4.8}
		}
		difference {
			cylinder {<-12.75,0,0>, <0,0,0>, 10}
			cylinder {<-100,0,0>, <100,0,0>, 4}
		}
	}
        difference {
		torus {
			4, 1
			rotate <90,90,0>
			scale <6,1,1>
			translate <10,0,0>
		}
		difference {
			cylinder {<100,0,0>, <13,0,0>, 10}
			cylinder {<-100,0,0>, <100,0,0>, 4.8}
		}
		difference {
			cylinder {<12.75,0,0>, <0,0,0>, 10}
			cylinder {<-100,0,0>, <100,0,0>, 4}
		}
	} 
	torus {
		4, 0.75
		rotate <90,90,0>
		translate <-12,0,0>
	}
	torus {
		4, 0.75
		rotate <90,90,0>
		translate <10.5,0,0>
	}
	torus {
		4, 0.75
		rotate <90,90,0>
		translate <12,0,0>
	}
	torus {
		4, 0.75
		rotate <90,90,0>
		translate <-10.5,0,0>
	} 
	// intake slits
	#declare Count = 0;
	#while (Count < 360)
		sphere {
			<0,0,0>, 0.15
			scale <4,1,1>
			translate <-9,5,0>
    		        rotate <Count,0,0>
		}
		sphere {
			<0,0,0>, 0.15
			scale <4,1,1>
			translate <6,5,0>
    		        rotate <Count,0,0>
		}
    	        cylinder { 
    		        <-9,5,0>, <6,5,0>, 0.15
    		        rotate <Count,0,0>
    	        }
    	        #declare Count = Count+18;
        #end
	// rivets
	#declare Count = 0;
	#while (Count < 360)
		union {
    		        sphere {<0,-4.8,0>, 0.05}
    		        sphere {<27,-4.8,0>, 0.05}
    		        cylinder {<0,-4.8,0>, <27,-4.8,0>, 0.05}
    		        rotate <Count,0,0>
    		        translate <-13.5,0,0>
    	        }
    	        #declare Count = Count+3;
        #end
        torus {
    	        4.8, 0.05
		rotate <90,90,0>
		translate <-13.5,0,0>
		translate <27,0,0>
	}
        torus {
    	        4.8, 0.05
		rotate <90,90,0>
		translate <-13.5,0,0>
	} 
	// air brakes
	#declare Count = 0;
	#while (Count < 360)
		union {
		        difference {
    		                cylinder {<7,0,0>, <9.5,0,0>, 5.125}
    		                cylinder {<-100,0,0>, <100,0,0>, 5}
    		                box {<-100,1.25,-100>, <100,100,100>}
    		                box {<-100,-100,-100>, <100,-1.25,100>}
    		                box {<-100,-100,100>, <100,100,0>}
    		                union {
    		                        cylinder {<7.25,-0.75,-100>, <7.25,-0.75,100>, 0.2}
    		                        cylinder {<7.25,-0.25,-100>, <7.25,-0.25,100>, 0.2}
    		                        cylinder {<7.25,0.25,-100>, <7.25,0.25,100>, 0.2}
    		                        cylinder {<7.25,0.75,-100>, <7.25,0.75,100>, 0.2}
    		                        cylinder {<7.75,-0.75,-100>, <7.75,-0.75,100>, 0.2}
    		                        cylinder {<7.75,-0.25,-100>, <7.75,-0.25,100>, 0.2}
    		                        cylinder {<7.75,0.25,-100>, <7.75,0.25,100>, 0.2}
    		                        cylinder {<7.75,0.75,-100>, <7.75,0.75,100>, 0.2}
    		                        cylinder {<8.25,-0.75,-100>, <8.25,-0.75,100>, 0.2}
    		                        cylinder {<8.25,-0.25,-100>, <8.25,-0.25,100>, 0.2}
    		                        cylinder {<8.25,0.25,-100>, <8.25,0.25,100>, 0.2}
    		                        cylinder {<8.25,0.75,-100>, <8.25,0.75,100>, 0.2}
    		                        cylinder {<8.75,-0.75,-100>, <8.75,-0.75,100>, 0.2}
    		                        cylinder {<8.75,-0.25,-100>, <8.75,-0.25,100>, 0.2}
    		                        cylinder {<8.75,0.25,-100>, <8.75,0.25,100>, 0.2}
    		                        cylinder {<8.75,0.75,-100>, <8.75,0.75,100>, 0.2}
    			                translate <0.25,0,0>
    		                }
    	                }
    		        // air brake connector hinge
    		        cylinder {<7,-1,4.90>, <7,1,4.9>, 0.25}
    		        sphere {<7,-1,4.9>, 0.25}
    		        sphere {<7,1,4.9>, 0.25}
    		        union {
    		        	box {<6.75,-1,3>, <7.25,1,4.9>}
    		        	cylinder {<7,-1,3>, <7,-1,4.9>, 0.25}
    		        	cylinder {<7,1,3>, <7,1,4.9>, 0.25}
    		        	translate <-7,0,5>
    		        	rotate <0,brake_rot,0>
    		        	translate <7,0,-5>
    		        }
    		        translate <-7,0,5>
    		        rotate <0,-brake_rot,0>
    		        translate <7,0,-5>
    		        rotate <Count,0,0>
    	        }
    	        #declare Count = Count+36;
        #end
        union { 
	        cylinder {<-3,0,-1.5>, <-3,5,-1.5>, 1.5}
	        cylinder {<-6,6.5,-1.5>, <-5,6.5,-1.5>, 1.5}
	        difference {
	        	torus {1.5, 1.5 rotate <90,0,0>}
	        	box {<-100,-100,-100>, <100,0,100>}
	        	box {<-100,-100,-100>, <0,100,100>}
	        	translate <-5,5,-1.5>
	        }
	        cylinder {<-8,0,-1.5>, <-8,5,-1.5>, 1.5}
	        difference {
	        	torus {1.5, 1.5 rotate <90,0,0>}
	        	box {<-100,-100,-100>, <100,0,100>}
	        	box {<-100,-100,-100>, <0,100,100>}
	        	rotate y*-180
	        	translate <-6,5,-1.5>
	        }
	        cylinder {<-3,0,1.5>, <-3,5,1.5>, 1.5}
	        cylinder {<-6,6.5,1.5>, <-5,6.5,1.5>, 1.5}
	        difference {
	        	torus {1.5, 1.5 rotate <90,0,0>}
	        	box {<-100,-100,-100>, <100,0,100>}
	        	box {<-100,-100,-100>, <0,100,100>}
	        	translate <-5,5,1.5>
	        }
	        cylinder {<-8,0,-1.5>, <-8,5,1.5>, 1.5}
	        difference {
	        	torus {1.5, 1.5 rotate <90,0,0>}
	        	box {<-100,-100,-100>, <100,0,100>}
	        	box {<-100,-100,-100>, <0,100,100>}
	        	rotate y*-180
	        	translate <-6,5,1.5>
	        }
	        material {T5}
	}
	object {Vent scale 0.125 translate <0,0,-5.75> rotate <15,0,0>}
}

#declare engine_cover = 
union {
	difference {
		union {
			// the main shell
			cylinder {<-8,0,0>, <8,0,0>, 5.75}
    		        // round the front
    		        torus {
    			        5.5, 0.25
    			        rotate <90,90,0>
    			        translate <-8,0,0>
    		        }
    	        }
		// cut out the center
		cylinder {<-100,0,0>, <100,0,0>, 5.25}
		// cut the hold for the sphere
		cylinder {<-4,0,100>, <-4,0,-100>, 2}
		// vent hole
		cylinder {<0,0,-100>, <0,0,0>, 1.5 rotate <15,0,0>}
		/* --- the air intake cutout --- */
		// cut the air intake hole
		cylinder {<-3,0,-1.5>, <-3,100,-1.5>, 1.5}
		// cut the air intake hole
		cylinder {<-3,0,1.5>, <-3,100,1.5>, 1.5}
		// cutout the rest of the air intake
		box {<-100,0,-3>, <-3,100,3>}
		//box {<-5,0,-1.5>,<-3.5,100,1.5>}
		/* --- end air intake cutout --- */
		// cut the back off with an angle
		box {
			<0,-100,-100>, <100,100,100>
			rotate <0,0,-35>
			translate <2,0,0>
		}
		// cut holes around sphere
		#declare cnt = 0;
		#while (cnt < 360)	
			cylinder {
				<-2.25,0,-100>, <-2.25,0,100>, 0.125
				rotate <0,0,cnt>
				translate <-4,0,0>
			}
			#declare cnt = cnt+18;
		#end	
		material {cover}
	}
}

//_____________________________________________________________________________________________________________________
 
// Gilles Tran  http://www.oyonale.com/modeles.php?lang=en&page=20

#declare Wheel = 
blob {
        threshold 0.6
        sphere {0, 1.3, 1 scale <1,1.2,1>}
        cylinder {0, -y*8, 0.8, 1}
        #declare Teta = 0;
        #while (Teta < 360)
                cylinder {0,x*3.4,0.4,1  rotate y*Teta}
                cylinder {0,y,0.4,1  translate x*3 rotate y*Teta}
                sphere {0, 0.6, 1 translate x*3 rotate y*Teta}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+6)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+12)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+18)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+24)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+30)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+36)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+42)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+48)}
                sphere {0, 0.4, 1 translate x*3 rotate y*(Teta+54)}
                sphere {0, 0.5, 1 translate x*3 rotate y*(Teta+60)}
                sphere {0, 0.5, 1 translate x*3 rotate y*(Teta+66)}
                #declare Teta = Teta+72;
        #end
}  

#declare Eye = 
union {
        torus {4.5, 0.5}
        difference {
                sphere {0, 4.3}

                box {-5, 5 scale <1,1,0.05>}
                box {-5, 5 scale <1,1,0.05> translate z}
                box {-5, 5 scale <1,1,0.05> translate z*2}
                box {-5, 5 scale <1,1,0.05> translate z*3}
                box {-5, 5 scale <1,1,0.05> translate z*4}
                box {-5, 5 scale <1,1,0.05> translate -z}
                box {-5, 5 scale <1,1,0.05> translate -z*2}
                box {-5, 5 scale <1,1,0.05> translate -z*3}
                box {-5, 5 scale <1,1,0.05> translate -z*4}
                scale <1,0.7,1>
        }

} 

#declare Ring2 = 
union {
        cylinder {-0.2*x, 0.2*x, 0.6}
        torus {0.55, 0.05 rotate z*90 scale <2,1,1> translate -x*0.2}
        torus {0.55, 0.05 rotate z*90 scale <2,1,1> translate x*0.2}
}

#declare Elbow2 = 
intersection {
        torus {2, 0.5} 
        plane {z, 0 inverse} 
        plane {x, 0 inverse}
}

#declare Ring1 = union {
        cylinder {-0.2*x, 0.2*x, 1.2}
        torus {1.1, 0.1 rotate z*90 scale <2,1,1> translate -x*0.2}
        torus {1.1, 0.1 rotate z*90 scale <2,1,1> translate x*0.2}
        union {
                #declare Teta = 0;
                #while (Teta < 360)
                        union {
                                sphere {0, 0.1 translate <0.15,1.2,0>}
                                sphere {0, 0.1 translate <-0.15,1.2,0> rotate x*10}
                                rotate x*Teta
                        }
                        #declare Teta = Teta+20;
                #end
        }
}

#declare Elbow1 = 
intersection {
        torus {2, 1} 
        plane {z, 0 inverse} 
        plane {x, 0 inverse}
}

#declare Elbow = 
union {
        intersection {
                torus {5, 1.5} 
                plane {x, 0 inverse}  
                plane {z, 0 inverse}
        }
        object {Ring1 scale 1.5/1.2 translate z*5}
        object {Ring1 scale 1.5/1.2 translate z*5 rotate y*45}
        object {Ring1 rotate y*90 scale 1.5/1.2 translate x*5}
}

// ========================================= 
// Pipe 1 Length = 10*x
//-----------------------------------------
#declare ElPipe1 = 
union {
        difference {
                intersection {
                        sphere {0, 3 scale <2.5,1,1>}
                        plane {x, 5}
                        plane {x, -5 inverse}
                }
                torus {3, 0.2 rotate z*90 translate x*0.15}
                cylinder {0, 6*y, 0.8 rotate x*-30 translate -x*3.5}
                cylinder {0, 6*y, 1 rotate x*-60 translate -x*1.2}
                cylinder {0, 6*y, 1 rotate x*-45 translate x*1.5}
                cylinder {0, 6*y, 0.8 rotate x*20 translate -x*3.5}
                cylinder {0, 6*y, 1 rotate x*30 translate -x*1.2}
                cylinder {0, 6*y, 1 rotate x*65 translate x*1.5}
        } 
        object {Eye scale 0.8/7 translate y*2.5 rotate x*-30 translate -x*3.5}
        torus {0.8, 0.2 scale <1,2,1> translate y*2.5 rotate x*-30 translate -x*3.5}
        torus {1, 0.2 scale <1,2,1> translate y*2.8 rotate x*-60 translate -x*1.2}
        object {Eye scale 1/6 translate y*3 rotate x*-60 translate -x*1.2}
        torus {1, 0.2 scale <1,2,1> translate y*2.8 rotate x*-45 translate x*1.5}
        torus {0.8, 0.2 scale <1,2,1> translate y*2.5 rotate x*20 translate -x*3.5}
        torus {1, 0.2 scale <1,2,1> translate y*2.8 rotate x*30 translate -x*1.2}
        torus {1, 0.2 scale <1,2,1> translate y*2.8 rotate x*65 translate x*1.5}
        torus {2, 0.3 rotate z*90 translate -x*5}
        torus {2, 0.3 rotate z*90 translate x*5}
        torus {3.2, 0.2 rotate z*90 translate x*5.2}
        #declare Teta = 0;
        #while (Teta < 360)
                sphere {0, 1 scale <1.5,0.3,0.1> rotate z*10 rotate x*5 translate <4,3,0> rotate x*Teta}
                sphere {0, 0.2 scale <3,1,1> translate <-5,2.3,0> rotate x*Teta}
                #declare Teta = Teta+15;
        #end
        translate x*5
}

//-----------------------------------------
// Pipe 6 Length = 44*x
//-----------------------------------------
#declare ElPipe6i = 
union {
        cylinder {0, 8*x, 1}
        object {Elbow1 translate <8,0,-2>}
        object {Elbow1 rotate y*180 translate <12,0,-2>}
        object {Elbow1 rotate y*90 translate <12,0,-2>}
        cylinder {0, z*4, 1 translate <14,0,-2>}
        object {Elbow1 rotate -y*90 translate <16,0,2>}
        object {Elbow1 translate <16,0,2>}
        object {Elbow1 rotate y*180 translate <20,0,2>}
        object {Elbow1 translate <20,0,-2>}
        object {Elbow1 rotate y*180 translate <24,0,-2>}
        object {Elbow1 rotate y*90 translate <26,0,-2>}
        object {Elbow1 rotate -y*90 translate <30,0,-2>}
        cylinder {0, 2*x, 1 translate x*30}
        object {Ring1}
        object {Ring1 translate x*8}
        object {Ring1 rotate y*90 translate <10,0,-2>}
        object {Ring1 rotate y*90 translate <14,0,-2>}
        object {Ring1 rotate y*90 translate <14,0,2>}
        object {Ring1 rotate y*90 translate <18,0,2>}
        object {Ring1 translate x*20}
        object {Ring1 rotate y*90 translate <22,0,-2>}
        object {Ring1 scale <3,1,1> translate <25,0,-4>}
        object {Ring1 rotate y*90 translate <28,0,-2>}
        object {Ring1 translate x*30}
        object {Ring1 translate x*32}  
}       

#declare ElPipe6 = 
union {
        union {
                object {ElPipe6i translate <0,1.5,1>}
                object {ElPipe6i scale <-1,1,-1> translate <33,-1.5,-1>}
                translate x*6
        }
        object {Ring1 scale 1.5}
        blob {
                threshold 0.6
                cylinder {0, 2*x, 2*1.5, 1}
                cylinder {0, <6,1.7,1>, 1.7, 1}
                cylinder {0, <7,-1.7,-1>, 1.7, 1}
        }
        union {
                object {Ring1 scale 1.5}
                blob {
                        threshold 0.6
                        cylinder {0, 2*x, 2*1.5, 1}
                        cylinder {0, <6,1.7,1>, 1.7, 1}
                        cylinder {0, <5,-1.7,-1>, 1.7, 1}
                }
                scale <-1,1,1>
                translate x*44
        }
        object {Wheel scale 0.3 translate <1,3,0>}
}

//_____________________________________________________________________________________________

#declare Triangle =
union {
        triangle {<-1,0,1>, <0,1,0>, <1,0,1>}
        triangle {<1,0,1>, <0,1,0>, <1,0,-1>}
        triangle {<-1,0,-1>, <0,1,0>, <1,0,-1>}
        triangle {<-1,0,1>, <0,1,0>, <-1,0,-1>}
        scale 0.5
}

#macro CylinderGrip (wid, dia, cnt) 

union {
        #if (show_grip)
                #local s = wid/cnt;
                #local ang = 0;
                #local ang_step = (360*s)/(pi*dia);
                #while (ang < 360)
                        #local start_x = 0;
                        #local end_x = wid;
                        #local step_x = (end_x-start_x)/cnt;
                        #local n = start_x;
                        #while (n < end_x)
                                object {Triangle scale s translate <n+s/2,dia/2,0> rotate <ang,0,0>}
                                #local n = n+step_x;
                        #end
                        #local ang = ang+ang_step;
                #end
        #end
}

#end

#declare Bolt = 
union {
        cylinder {<0,-0.3125,0>, <0,0.3125,0>, 1}
        cylinder {<0,0.3125,0>, <0,0.4375,0>, 1.0625}
        cylinder {<0,-0.3125,0>, <0,-0.4375,0>, 1.0625}
        difference {
                union {
                        torus {0.8125, 0.25}
                        cylinder {<0,-0.25,0>, <0,0.25,0>, 0.8125}
                }
                box {<-10,-10,-10>, <10,0,10>}
                cylinder {<0,-0.125,0.5>, <0,1,0.5>, 0.16}
                cylinder {<0,-0.125,-0.5>, <0,1,-0.5>, 0.16}
                cylinder {<-0.4,-0.125,0>, <-0.4,1,0>, 0.16}
                cylinder {<0.4,-0.125,0>, <0.4,1,0>, 0.16}
                cylinder {<0,-0.125,0>, <0,1,0>, 0.32}
                box {<-0.16,-0.125,0.5>, <0.16,1,-0.5>}
                box {<-0.4,-0.125,-0.16>, <0.4,1,0.16>}
                sphere {<0,0.41,0.5>, 0.26}
                sphere {<0,0.41,-0.5>, 0.26}
                sphere {<-0.4,0.41,0>, 0.26}
                sphere {<0.4,0.41,0>, 0.26}
                sphere {<0,0.41,0>, 0.42}
                cylinder {<0,0.41,0.5>, <0,0.41,-0.5>, 0.26}
                cylinder {<-0.4,0.41,0>, <0.4,0.41,0>, 0.26}
                translate <0,0.4375,0>
        }
        cylinder {<0,-0.4375,0>, <0,-0.5,0>, 1}
        object {
                CylinderGrip (0.625, 2, 4)
                rotate <0,0,90>
                translate <0,-0.3125,0>
        }
}

#macro RoundDisc (inner, outer)

union {
        torus {inner, outer}
        cylinder {<0,-outer,0>, <0,outer,0>, inner}
} 

#end

#macro RoundCylinder (inner, outer, length) 

union {
        torus {inner-outer, outer translate <0,length/2-outer,0>}
        cylinder {<0,-length/2+outer,0>, <0,length/2-outer,0>, inner}
        cylinder {<0,-length/2,0>, <0,length/2, 0>, inner-outer}
        torus {inner-outer, outer translate <0,-(length/2)+outer,0>}
}

#end

#macro RoundCylinder2 (inner, outer, length)

union {
        torus {inner, outer translate <0,length/2-outer,0>}
        cylinder {<0,-length/2+outer,0>, <0, length/2-outer,0>, inner+outer}
        cylinder {<0,-length/2,0>, <0,length/2, 0>, inner}
        torus {inner, outer translate <0,-(length/2)+outer,0>}
}

#end

#macro Tube (inner, outer, inner2, outer2, length)

union {
        difference {
                RoundCylinder2 (inner, outer, length)
                cylinder {<0,-1000,0>, <0,1000,0>, inner2 - outer2}
                cylinder {<0,-1000,0>, <0,-(length/2-outer2),0>, inner2}
                cylinder {<0,1000,0>, <0,length/2-outer2,0>, inner2}
        }
        torus {inner2, outer2 translate <0,length/2-outer2,0>}
        torus {inner2, outer2 translate <0,-(length/2-outer2),0>}
}

#end

#macro RoundCylinderWidthBars (inner, outer, bar_rad, length) 

union {
        object {RoundCylinder (inner, outer, length)}
        #local tpad_y1 = length/2-(outer+bar_rad*2);
        #local tpad_y2 = -length/2+(outer+bar_rad*2);
        #local loop = 0;
        #while (loop < 360)
                union {
                        sphere {<0,tpad_y1,-inner>, bar_rad}
                        cylinder {<0,tpad_y1,-inner>, <0,tpad_y2,-inner>, bar_rad}
                        sphere {<0,tpad_y2,-inner>, bar_rad}
                        rotate <0,loop,0>
                }
                #local loop = loop+36;
        #end
}

#end

#macro BoltTube (inner, outer, inner2, outer2, length)

union {
        Tube (inner, outer, inner2, outer2, length)
        object {Bolt scale inner2-outer2*3 translate <0,length/2,0>}
        object {Bolt scale inner2-outer2*3 rotate <180,0,0> translate <0,-length/2,0>}
}

#end

#macro RoundBox (w, h, d, r)

union {
        cylinder {<-w/2+r,-h/2+r,-d/2+r>, <w/2-r,-h/2+r,-d/2+r>, r}
        cylinder {<-w/2+r,h/2-r,-d/2+r>, <w/2-r,h/2-r,-d/2+r>, r}
        cylinder {<-w/2+r,-h/2+r,d/2-r>, <w/2-r,-h/2+r,d/2-r>, r}
        cylinder {<-w/2+r,h/2-r,d/2-r>, <w/2-r,h/2-r,d/2-r>, r}
        cylinder {<-w/2+r,-h/2+r,-d/2+r>, <-w/2+r,h/2-r,-d/2+r>, r}
        cylinder {<w/2-r,-h/2+r,-d/2+r>, <w/2-r,h/2-r,-d/2+r>, r}
        cylinder {<-w/2+r,-h/2+r,d/2-r>, <-w/2+r,h/2-r,d/2-r>, r}
        cylinder {<w/2-r,-h/2+r,d/2-r>, <w/2-r,h/2-r,d/2-r>, r}
        sphere {<-w/2+r,-h/2+r,-d/2+r>, r}
        sphere {<w/2-r,-h/2+r,-d/2+r>, r}
        sphere {<-w/2+r,-h/2+r,d/2-r>, r}
        sphere {<w/2-r,-h/2+r,d/2-r>, r}
        sphere {<-w/2+r,h/2-r,-d/2+r>, r}
        cylinder {<-w/2+r,h/2-r,-d/2+r>, <-w/2+r,h/2-r,d/2-r>, r}
        sphere {<-w/2+r,h/2-r,d/2-r>, r}
        sphere {<w/2-r,h/2-r,-d/2+r>, r}
        cylinder {<w/2-r,h/2-r,-d/2+r>, <w/2-r,h/2-r,d/2-r>, r}
        sphere {<w/2-r,h/2-r,d/2-r>, r}    
        box {<-w/2,-h/2+r,-d/2+r>, <w/2,h/2-r,d/2-r>}
        box {<-w/2+r,-h/2,-d/2+r>, <w/2-r,h/2,d/2-r>}
        box {<-w/2+r,-h/2+r,-d/2>, <w/2-r,h/2-r,d/2>}
} 

#end

/*-----------------------------------------------------*/
/* VENT                                                */
/*-----------------------------------------------------*/

#declare Vent = 
union {
        #local VentBlade =
        object {
                box {<-10,-1.5,-0.1>, <10,1.5,0.1>}
                rotate <45,0,0>
        }
        difference {
                union {
                        cylinder {<0,0,-2>, <0,0,2>, 10}
                        cylinder {<0,0,0>, <0,0,15>, 12}
                        torus {10, 2 rotate <90,0,0>}
                }
                cylinder {<0,0,-5>, <0,0,-1.7>, 10}
                cylinder {<0,0,-10>, <0,0,10>, 9}
        }
        intersection {
                cylinder {<0,0,-2>, <0,0,2>, 9.5}
                union {
                        object {VentBlade translate <0,-8,0>}
                        object {VentBlade translate <0,-6,0>}
                        object {VentBlade translate <0,-4,0>}
                        object {VentBlade translate <0,-2,0>}
                        object {VentBlade}
                        object {VentBlade translate <0,2,0>}
                        object {VentBlade translate <0,4,0>}
                        object {VentBlade translate <0,6,0>}
                        object {VentBlade translate <0,8,0>}
                }
        }
        scale 0.10625
} 

#macro CylinderGrip (wid, dia, cnt) 

union {
        #local s_ = wid/cnt;
        #local ang = 0;
        #local ang_step = (360*s_)/(pi*dia);
        #while (ang < 360)
                #local start_x = 0;
                #local end_x = wid;
                #local step_x = (end_x-start_x)/cnt;
                #local n = start_x;
                #while (n < end_x)
                        object {Triangle scale s_ translate <n+s_/2,dia/2,0> rotate <ang,0,0>}
                        #local n = n+step_x;
                #end
                #local ang = ang+ang_step;
        #end
}

#end

#macro MultiJoint (d1, d2, d3, d4, d5, s1, s2, s3, s4, s5, s6, r1, r2, cnt)

union {
        difference {
                union {
                        object {RoundCylinder (d2/2, r2, s5) rotate <90,0,0> translate <0,0,-s6/2-s5/2>}
                        object {RoundBox (d2/2+s1+r1, d2, s5, r2) translate <(d2/2+s1+r1)/2,0,-s6/2-s5/2>}
                }
                cylinder {<0,0,-s6/2-s5/2>, <0,0,-1000>, d1/2}
                cylinder {<0,0,-s6/2-s5+r2/2>, <0,0,-1000>, d1/2+r2}
                cylinder {<0,0,-1000>, <0,0,1000>, d4/2}
        }
        torus {d1/2+r2, r2 rotate <90,0,0> translate <0,0,-s6/2-s5+r2>}
        union {
                object {RoundCylinder (d2/2, r2, s5) rotate <90, 0, 0> translate <0,0,s6/2+s5/2>}
                object {RoundBox (d2/2+s1+r1, d2, s5, r2) translate <(d2/2+s1+r1)/2,0,s6/2+s5/2>}
        }
        // R1
        difference {
                object {RoundDisc (d3/2-r1, r1) rotate <0,0,90> translate <d2/2+s1+r1,0,0>}
                box {<d2/2+s1+r1,-1000,-1000>, <1000,1000,1000>}
        }
        // S2
        cylinder {<d2/2+s1+r1,0,0>, <d2/2+s1+r1+s2,0,0>, d3/2}
        // R2 #1
        difference {
                object {RoundDisc (d3/2-r2, r2) rotate <0,0,90> translate <d2/2+s1+r1+s2,0,0>}
                box {<-1000,-1000,-1000>, <d2/2+s1+r1+s2,1000,1000>}
        }
        // S3
        cylinder {<d2/2+s1+r1+s2+r2,0,0>, <d2/2+s1+r1+s2+r2+s3,0,0>, d5/2}
        // the grip
        object {
                CylinderGrip (s3, d5, cnt)
                translate <d2/2+s1+r1+s2+r2,0,0>
        }
        // R2 #2
        difference {
                object {RoundDisc (d3/2-r2, r2) rotate <0,0,90> translate <d2/2+s1+r1+s2+r2+s3+r2,0,0>}
                box {<d2/2+s1+r1+s2+r2+s3+r2,-1000,-1000>, <1000,1000,1000>}
        }
        // S4
        cylinder {<d2/2+s1+r1+s2+r2+s3+r2,0,0>, <d2/2+s1+r1+s2+r2+s3+r2+s4,0,0>, d3/2} 
} 

#end

#declare d1 = 4;
#declare d2 = 6;
#declare d3 = 10;
#declare d4 = 2;
#declare d5 = 9;
#declare s1 = 1;
#declare s2 = 0.5;
#declare s3 = 2;
#declare s4 = 2;
#declare s5 = 1.5;
#declare s6 = 4;
#declare r1 = 1;
#declare r2 = 0.25;    

#declare MJ = 
object {
        MultiJoint (d1, d2, d3, d4, d5, s1, s2, s3, s4, s5, s6, r1, r2, 4)
        scale 0.5
}

#declare engine = 
union {
	object {engine_mechanics}
	object {engine_cover}
}

#declare axis1 =
union {
	object {engine scale 0.6 translate <71.6,0,0>}
        object {engine scale 0.6*<-1,1,1> translate <-71.6,0,0>}
        object {MJ rotate x*-22 translate <-84,0,0>}
        object {MJ scale <-1,1,1> translate <84,0,0>}
        union {
                object {ElPipe1 rotate y*-90}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,10>}
                object {ElPipe6 rotate y*-90 translate <0,0,20>}
                object {ElPipe1 rotate y*-90 translate <0,0,54>}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,64>} 
                object {ElPipe6 rotate y*-90 translate <0,0,74>}
                object {ElPipe1 rotate y*-90 translate <0,0,118>}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,128>}
                rotate <-90,0,90>
                translate x*69
                scale 0.9
        }
}
 
#declare axis2 =
union {
	object {engine scale 0.6 translate <71.6,0,0>}
        object {engine scale 0.6*<-1,1,1> translate <-71.6,0,0>}
        object {MJ rotate x*202 translate <-84,0,0>}
        object {MJ scale <-1,1,1> translate <84,0,0>}
        union {
                object {ElPipe1 rotate y*-90}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,10>}
                object {ElPipe6 rotate y*-90 translate <0,0,20>}
                object {ElPipe1 rotate y*-90 translate <0,0,58>}
                object {ElPipe1 scale <-1,1,-1> translate x*14 rotate y*-90 translate <0,0,64>} 
                object {ElPipe6 scale <-1,1,-1> rotate y*-90 translate <0,0,119>}
                object {ElPipe1 rotate y*-90 translate <0,0,118>}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,128>}
                rotate <-90,0,90>
                translate x*69
                scale 0.9
        }
}

//___________________________________________________________________________________________________________________________________

// rear wheel - Kerwin D Kanago  http://www.irtc.org/ftp/pub/stills/1996-08-31/hotenuf.zip
 
#declare SR1 = 0.1;                                                     // Spokes come into the hub this far off center
#declare SR2 = 0.2;                                                     // half the lenght of the hub
#declare SDia = 0.015;                                                  // diameter of a spoke
#declare Wdia = 1.8;                                                    // diameter of inside edge of wheel
#declare Nlen = 0.1;                                                    // fraction of the spoke is the nipple
#declare N1 = SR1*Nlen/Wdia;                                            
#declare N2 = SR2*Nlen/Wdia;                                            
#declare N3 = Wdia-Nlen;                                                
#declare Tlen = 0.2;                                                    // fraction of spoke that is threaded (partly under nipple)
#declare T_1 = SR1*Tlen/Wdia;                                           
#declare T_2 = SR2*Tlen/Wdia;                                           
#declare T_3 = Wdia-Tlen;                                               
                                                                        
#declare Spoke1 =                                                       // one group of spokes 2 up and 2 down, 2 to left of hub and 2 to the right
union {
        union {
                cylinder {<SR1,SR2,0>, <0,0,Wdia>, SDia}
                cylinder {<SR1,-1*SR2,0>, <0,0,Wdia>, SDia rotate <0,360/28,0>}
                cylinder {<-1*SR1,SR2,0>, <0,0,Wdia>, SDia  rotate <0,360*2/28,0>}
                cylinder {<-1*SR1,-1*SR2,0>, <0,0,Wdia>, SDia rotate <0,360*3/28,0>}
        }
        union {
                cylinder {<N1,N2,N3>, <0,0,Wdia>, SDia*1.5}
                cylinder {<N1,-1*N2,N3>, <0,0,Wdia>, SDia*1.5 rotate <0,360/28,0>}
                cylinder {<-1*N1,N2,N3>, <0,0,Wdia>, SDia*1.5 rotate <0,360*2/28,0>}
                cylinder {<-1*N1,-1*N2,N3>, <0,0,Wdia>, SDia*1.5 rotate <0,360*3/28,0>}
        }
        union {
                cylinder {<T_1,T_2,T_3>, <0,0,Wdia>, SDia*1.05}
                cylinder {<T_1,-1*T_2,T_3>, <0,0,Wdia>, SDia*1.05 rotate <0,360/28,0>}
                cylinder {<-1*T_1,T_2,T_3>, <0,0,Wdia>, SDia*1.05 rotate <0,360*2/28,0>}
                cylinder {<-1*T_1,-1*T_2,T_3>, <0,0,Wdia>, SDia*1.05 rotate <0,360*3/28,0>}
        }
}

#declare Spoke2 =
union {
        cylinder {<SR1,SR2,0>, <0,0,Wdia>, SDia}
        cylinder {<SR1,-1*SR2,0>, <0,0,Wdia>, SDia rotate <0,360/28,0>}
        cylinder {<-1*SR1,SR2,0>, <0,0,Wdia>, SDia  rotate <0,360*2/28,0>}
        cylinder {<-1*SR1,-1*SR2,0>, <0,0,Wdia>, SDia rotate <0,360*3/28,0>}
}

#declare r_wheel =
union {
        #declare Count = 0;
        #while (Count < 8)
                object {Spoke1 rotate <0,Count*360/7,0>}
                #declare Count=Count+1;
        #end
        lathe {                                                         // rim 
                cubic_spline
                7, 
                <Wdia+0.35,0.11>
                <Wdia+0.25,0.1>
                <Wdia+0.05,0.07>
                <Wdia,0.0>
                <Wdia+0.05,-0.07>
                <Wdia+0.25,-0.1>
                <Wdia+0.35,-0.11>
        }
        torus {                                                        
                Wdia+0.2,
                0.024
                scale <1,1/1.1,1>
                translate <0,-0.095,0>
        }
        torus {                                                        
                Wdia+0.2,
                0.024
                scale <1,1/1.1,1>
                translate <0,0.095,0>
        }
        union {
                torus {                                                 // body of tire
                        Wdia+0.35,
                        0.15*1.1
                        scale <1,1/1.1,1>
                }
                torus {                                                 // tread
                        Wdia+0.35,
                        0.15*1.1
                        scale <1.04,1/(1.1*1.2),1.04>
                }
                torus {                                                 // whitewall
                        Wdia+0.35,
                        0.15*0.9
                        scale <1,1.01/0.9,1>
                }
                material {M_tyre scale 0.07}
        }                                                               // hub and axel
        disc {<0,SR2-SDia,0>, y, SR1+3*SDia}  
        disc {<0,SDia-SR2,0>, y, SR1+3*SDia}
        cylinder {SR2*1.7*y, -SR2*1.7*y, SR1/4}
        cylinder {SR2*1.4*y, -SR2*1.4*y, SR1/2} 
        rotate <90,0,-90>
}

//___________________________________________________________________________________________________________________________________

#declare ElPipe_4  = 
union {
        torus {2, 0.3 rotate z*90 translate -x*12}
        torus {1.5, 0.2 rotate z*90 translate x*10}
        sphere {0, 1.5 scale <0.5,1,1> translate x*10}
        cylinder {-12*x, x*10, 1}
        cone {10*x, 1.5, x*12, 2}
        torus {2, 0.2 rotate z*90 translate x*12}
        torus {2.6, 0.2 rotate z*90 translate x*11}
        union {
                cylinder {-12*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
        }
        union {
                cylinder {-12*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*90
        }
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*180
        }
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*270
        }
        torus {1, 0.15 rotate z*90 translate -x*10}
        torus {1, 0.15 rotate z*90 translate -x*6}
        torus {1, 0.15 rotate z*90 translate -x*2}
        torus {1, 0.15 rotate z*90 translate x*2}
        torus {1, 0.15 rotate z*90 translate x*2}
        torus {1, 0.15 rotate z*90 translate x*7}
        #declare Teta = 0;
        #while (Teta < 360)
                union {
                        sphere {0, 0.8 scale <1,0.2,0.2> rotate -z*25 translate <11.5,2.4,0>}
                        cylinder {<-12,2,0>, <-10.5,1,0>, 0.1}
                        sphere {0, 1 scale <1,0.1,0.1> rotate -z*25 translate <-10.5,1,0>}
                        rotate x*Teta
                }
                #declare Teta = Teta+10;
        #end
        translate x*12
        scale 1.5
}

#declare leg_connector =
union {
        object {RoundCylinder (3.75, 0.5, 4) rotate <0,0,90> translate <0,-11,0>}
        difference {
                sphere {<0,0,0>, 10}
                cylinder {<-1000,-11,0>, <-1,-11,0>, 3.5}
                cylinder {<1,-11,0>, <1000,-11,0>, 3.5}
                box {<-100,-6,-100>, <100,100,100>}
        }
        #local loop = 0;
        #while (loop < 360)
                object {
                        RoundBox (2, 2, 0.5, 0.125) 
                        translate <0,0,-9.85> 
                        rotate <-45,0,0> 
                        rotate <0,loop,0>
                }
                #local loop = loop+36;
        #end
}

#macro Leg (isLeft)

union {
        #local theigh_len = 7;
        #local caf_len = 13.9;
        object {                       
                #local d1 = 4;
                #local d2 = 6;
                #local d3 = 10;
                #local d4 = 2;
                #local d5 = 9;
                #local s1 = 0;
                #local s2 = 0.5;
                #local s3 = 2;
                #local s4 = 2;
                #local s5 = 1.5;
                #local s6 = 4;
                #local r1 = 1;
                #local r2 = 0.25; 
                MultiJoint (d1, d2, d3, d4, d5, s1, s2, s3, s4, s5, s6, r1, r2, 4)
                scale 0.6 
                #if (isLeft = false) 
                        rotate <0,0,180> 
                #end
        }
        union {
                // bolt
                object {Bolt scale 0.75 rotate <-90,0,0> translate <0,0,-2>}
                // theigh
                object {RoundCylinder (1.25, 0.25, 2) rotate <90,0,0>}
                cylinder {<0,0,0>, <0,-theigh_len,0>, 1}
                // theigh pad
                object { 
                        RoundCylinderWidthBars (1.5, 0.25, 0.125, 2.75)
                        translate <0,-3.75-3,0>
                        material {cover}
                } 
                object { 
                        RoundCylinderWidthBars (1.5, 0.25, 0.125, 2.75)
                        translate <0,-3.75-12,0>
                        material {cover}
                }
                // nee
                union {
                        // caf
                        cylinder {<0,0,0>, <0,-caf_len,0>, 1}
                        // ankle
                        object {BoltTube (2.5, 0.25, 1.25, 0.1, 2.75) rotate <0,0,180> translate <0,-caf_len,0>}
                        // rotate at the nee, fwd-back
                        object {
                                ElPipe_4 
                                rotate <-90,0,90> 
                                scale 0.77
                                translate <0,-42,0>
                        } 
                        rotate <0,0,0>
                        translate <0,-theigh_len,0>
                }
                // rotate whole jeg, side-side
                #if (! isLeft) 
                        rotate <0,0,2.4>
                #else 
                        rotate <0,0,-2.4>
                #end
        }
        // rotate whole leg, fwd-back
        rotate <0,0,0>
}

#end    

#macro Leg2 (isLeft)

union {
        #local theigh_len = 7;
        #local caf_len = 13.9;
        object {                       
                #local d1 = 4;
                #local d2 = 6;
                #local d3 = 10;
                #local d4 = 2;
                #local d5 = 9;
                #local s1 = 0;
                #local s2 = 0.5;
                #local s3 = 2;
                #local s4 = 2;
                #local s5 = 1.5;
                #local s6 = 4;
                #local r1 = 1;
                #local r2 = 0.25; 
                MultiJoint (d1, d2, d3, d4, d5, s1, s2, s3, s4, s5, s6, r1, r2, 4)
                scale 0.6 
                #if (isLeft = false) 
                        rotate <0,0,180> 
                #end
        }
        union {
                // bolt
                object {Bolt scale 0.75 rotate <-90,0,0> translate <0,0,-2>}
                // theigh
                object {RoundCylinder (1.25, 0.25, 2) rotate <90,0,0>}
                cylinder {<0,0,0>, <0,-theigh_len,0>, 1}
                // theigh pad
                object { 
                        RoundCylinderWidthBars (1.5, 0.25, 0.125, 2.75)
                        translate <0,-3.75-3,0>
                        material {cover}
                } 
                object { 
                        RoundCylinderWidthBars (1.5, 0.25, 0.125, 2.75)
                        translate <0,-3.75-12,0>
                        material {cover}
                }
                // nee
                union {
                        // caf
                        cylinder {<0,0,0>, <0,-caf_len,0>, 1}
                        // ankle
                        object {BoltTube (2.5, 0.25, 1.25, 0.1, 2.75) rotate <0,0,180> translate <0,-caf_len,0>}
                        // rotate at the nee, fwd-back 
                        object {
                                ElPipe_4 
                                rotate <-90,0,90> 
                                scale 0.77
                                translate <0,-42,0>
                        }                        
                        rotate <0,0,0>
                        translate <0,-theigh_len,0>
                }
                // rotate whole jeg, side-side
                #if (! isLeft) 
                        rotate <0,0,-2.4>
                #else 
                        rotate <0,0,2.4>
                #end
        }
        // rotate whole leg, fwd-back
        rotate <0,0,0>
}

#end    

#declare axis3 =
union {
	object {engine scale 0.6 translate <71.6,0,0>}
        object {engine scale 0.6*<-1,1,1> translate <-107.5+38*0.9,0,0>}        
        object {leg_connector scale 0.5 rotate z*90 translate <-126+38*0.9,0,0> material {cover}}
        torus {3.8, 0.25 rotate z*90 translate <-123.5+38*0.9,0,0>}
        union {                               
                object {leg_connector material {cover}}     
                object {
                    Leg (true)                  // left leg
                    translate <-7,-11,0>
                }
                object {
                    Leg (false)                 // right leg
                    translate <7,-11,0>
                }
                scale 0.5 
                rotate z*-90 
                rotate x*90 
                translate <-121+38*0.9,0,0> 
        }
        union {                                    
                object {
                    Leg2 (true)                  // left leg
                    translate <-11,-11,0>
                }
                object {
                    Leg2 (false)                 // right leg
                    translate <11,-11,0>
                }
                scale 0.5 
                rotate z*-90 
                rotate x*90
                rotate y*180 
                translate <-181+38*0.9,0,0> 
        }                
        object {MJ rotate x*90 translate <-120.5+38*0.9,0,0>}
        object {MJ scale <-1,1,1> translate <84,0,0>} 
        union {
                object {ElPipe1 rotate y*-90}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,10>}
                object {ElPipe6 rotate y*-90 translate <0,0,20>}
                object {ElPipe1 rotate y*-90 translate <0,0,60>}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,65.5>} 
                object {ElPipe6 rotate y*-90 translate <0,0,75.5>}
                object {ElPipe1 rotate y*-90 translate <0,0,119.5>}
                object {ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <0,0,129.5>}
                rotate <-90,0,90>
                translate x*69
                scale 0.9
        }
        object {r_wheel scale 10 translate <-175.5+38*0.9,0,0>}
}

//___________________________________________________________________________________________________________________________________

// shaft

#declare R0 = 0.3;               
#declare Ra = 3-R0;               
#declare Ri = Ra/(1+2/3*sqrt (3));
#declare Mi = <0,-Ra+Ri,0>;       
#declare S_3_Angle = -210;        

#macro Segment_of_Torus (R_major_, R_minor_, Segment_Angle_)

#local D = 0.000001;
#local R_major = R_major_;
#local R_minor = R_minor_;
#local Segment_Angle = Segment_Angle_;
#local Negativ_Flag = 1; 
#local Segment_Angle = -Segment_Angle; 

intersection {
        torus {R_major, R_minor sturm}
        union {
                box   { 
                        <-1,-1,0>, <1,1,1>
                        scale <R_major+R_minor+D,R_minor+D,R_major+R_minor+D>
                }
                box   { 
                        <-1,-1,-1>, <1,1,0>
                        scale <R_major+R_minor+D,R_minor+D,R_major+R_minor+D>
                        rotate <0,-Segment_Angle,0>
                }
        }
}

#end

#declare Segment =
object { 
        Segment_of_Torus (Ri, R0, S_3_Angle) 
        rotate <-90,0,60>
}

#declare Wheel2 = 
union {
        blob {
                threshold 0.6
                sphere {0, 1.3, 1 scale <1,1.2,1>}
                cylinder {0, -y*8, 0.8, 1}
        }
        union {
                torus {Ra, R0 rotate <90,0,0>}
                object {Segment translate Mi}
                object {Segment translate Mi rotate <0,0,120>}
                object {Segment translate Mi rotate <0,0,240>}
                rotate x*-90
        }
        scale 0.5
        material {cover}
}

#declare shaft =
union {
        difference { // Joint to bracket plate
                union {
                        box {<0.5,1.5,0.5>, <-0.5,-0.25,-0.5>}          
                        cylinder {<0,-0.25,0.5>, <0,-0.25,-0.5>, 0.5}   
                }
                box {<0.6,0.25,-0.4>, <-0.6,-0.76,0.4>}
        } 
        union {  // Control rod
                cylinder {<0,0.8,0>, <7,0.8,0>, 0.2}   
                object {Wheel2 rotate <90,90,0> translate <7,0.8,0>}
                rotate z*-10 
                rotate y*180
        }
        union {  // Joint knob
                object {Wheel2 rotate <90,0,90> translate <0,-0.25,0.6+3.4>}
                cylinder {<0,-0.25,0.95>, <0,-0.25,-0.75+0.2>, 0.1}
                cylinder {<0,-0.25,1.5>, <0,-0.25,-0.75+0.22>, 0.2}
                sphere {<0,-0.25,-0.75+0.2>, 0.1}
                material {T5}
        }
        union {  // vert rod
                cylinder {<0,-0.25,0.39>, <0,-0.25,-0.39>, 0.5}
                box {<0.5,-0.25,-0.4>, <-0.5,-1,0.4>}
                box {<0.5,-0.75,-0.5>, <-0.5,-1,0.5>}
                intersection {
                        box {<0.5,-1,-0.5>, <-0.5,-2,0.5>}
                        cone {<0,-1,0>, 0.70711, <0,-2,0>, 0.5}
                }
                cylinder {<0,-1,0>, <0,-8,0>, 0.5}
                cylinder {<0,-7.9,0>, <0,-8.1,0>, 0.75}
                translate y*0.25
                translate y*-0.25
        }  
        translate y*0.25 
}

// --------------------- Tripod 

#declare leg1_ = 
object {
        axis1 
        scale 0.4
        rotate x*-90 
        rotate z*90 
        translate y*-13
        translate y*-21     
        rotate x*45         // leg angle
        translate z*-4.5
}

#declare leg2_ = 
object {
        axis2 
        scale 0.4
        rotate x*-90 
        rotate z*90 
        translate y*-13
        translate y*-21     
        rotate x*45         // leg angle
        translate z*-4.5
}

#declare leg3_ = 
object {
        axis3 
        scale 0.4
        rotate x*-90 
        rotate z*90 
        translate y*-13
        translate y*-21     
        rotate x*74         // leg angle
        translate <0,-0.07,-4.5>
}

#macro Foot () 

union {
        difference {
                union {
                        sphere {<0,0,0>, 4}
                        cylinder {<0,0,-2>, <0,0,0>, 4}
                        sphere {<0,0,-2>, 4}
                }
                box {<-100,-100,-100>, <100,0,100>}
                cylinder {<-100,4,0>, <100,4,0>, 2}
                translate <0,0.25,0>
                material {cover}
        }
        union {
                torus {3.75,0.25 translate <0,0.25,0>}
                torus {3.75,0.25 translate <0,0.25,-2>}
                cylinder {<-3.75,0.25,0>, <-3.75,0.25,-2>, 0.25}
                cylinder {<3.75,0.25,0>, <3.75,0.25,-2>, 0.25}
                material {cover}
        }
        torus {3.75, 0.25 translate <0,-0.25,0>}
        torus {3.75, 0.25 translate <0,-0.25,-2>}
        cylinder {<0,-0.25,0>, <0,-0.75,0>, 4}
        box {<-4,-0.75,-2>, <4,-0.25,0>}
        cylinder {<0,-0.25,-2>, <0,-0.75,-2>, 4}
        torus {3.75, 0.25 translate <0,-0.75,0>}
        torus {3.75, 0.25 translate <0,-0.75,-2>}
        cylinder {<-3.75,-0.25,0>, <-3.75,-0.25,-2>, 0.25}
        cylinder {<-3.75,-0.75,0>, <-3.75,-0.75,-2>, 0.25}
        cylinder {<3.75,-0.25,0>, <3.75,-0.25,-2>, 0.25}
        cylinder {<3.75,-0.75,0>, <3.75,-0.75,-2>, 0.25}
        translate <0,-4,0>
}

#end

#macro BoltTube2 (inner, outer, inner2, outer2, length)

union {
        Tube (inner, outer, inner2, outer2, length)
        object {Bolt scale (inner2-outer2*3)*1.35 translate <0,length/2*2,0>}
        object {Bolt scale inner2-outer2*3 rotate <180,0,0> translate <0,-length/2,0>}
}

#end

#macro Leg (isLeft)

union {
        #local theigh_len = 7;
        #local caf_len = 5;
        union {
                union {    
                    object {BoltTube2 (2.25, 0.3, 1.25+0.7, 0.3, 2.75) rotate <0,0,90>}
                    cylinder {<0,0,0>, <0,-caf_len,0>, 1}
                    object {BoltTube (1.75, 0.25, 1.25, 0.1, 2.75) rotate <0,0,90> translate <0,-caf_len,0>}
                    object {
                        Foot ()
                        translate <0,-caf_len,0>
                    }
                    translate <0,-theigh_len,0>
                }
        }
}

#end

#declare Legs = 
union {
        object {
                Leg (false) 
                scale 0.22
                rotate y*-90 
                rotate z*90
                rotate y*180
                translate <6.4,-2.5,0>
        }
        translate <0,0,0>
        material {T4}
}  

#macro RoundCylinder (inner, outer, length) 

union {
        torus {inner-outer, outer translate <0,length/2-outer,0>}
        cylinder {<0,-length/2+outer,0>, <0,length/2-outer,0>, inner}
        cylinder {<0,-length/2,0>, <0,length/2, 0>, inner-outer}
        torus {inner-outer, outer translate <0,-(length/2)+outer,0>}
}

#end

#macro RoundCylinderWidthBars2 (inner, outer, bar_rad, length) 

union {
        object {RoundCylinder (inner, outer, length)}
        #local tpad_y1 = length/2-(outer+bar_rad*2);
        #local tpad_y2 = -length/2+(outer+bar_rad*2);
        #local loop = 0;
        #while (loop < 360)
                union {
                        sphere {<0,tpad_y1,-inner>, bar_rad}
                        cylinder {<0,tpad_y1,-inner>, <0,tpad_y2,-inner>, bar_rad}
                        sphere {<0,tpad_y2,-inner>, bar_rad}
                        rotate <0,loop,0>
                }
                #local loop = loop+12;
        #end
}

#end

#declare tripod =
union {
        union {
                object {leg2_}  
                object {leg3_ rotate y*120 translate y*-0.05}
                object {leg1_ rotate y*240}
                translate y*-2.25
        }
        union {
                object {Legs rotate y*-30}
                object {Legs rotate y*90}
                object {Legs rotate y*210}                
        }
        object {RoundCylinder (3, 0.05, 2.52) translate y*-2.25}//cylinder {<0,-0.99,0>, <0,-3.51,0>, 3}   // leg plate
        union {
                difference { // adjustment cylinder
                        union {
                                RoundCylinderWidthBars2 (2, 0.1, 0.04, 2) //cylinder {<0,-1,0>, <0,1,0>, 2}           
                                object {RoundBox (3, 1.8, 2, 0.1) translate z} //box {<1.5,-0.9,0>, <-1.5,0.9,2>}          
       
                        }
                        box {<0.1,-1.35,0>, <-0.1,1.35,3>}
                        box {<-2.1,-0.1,-1>, <2.1,0.1,2.1>}
                }
                union {  // control knobs
                        cylinder {<-0.5,0.5,1.625>, <4,0.5,1.625>, 0.2}
                        cylinder {<0.5,-0.5,1.625>, <-4,-0.5,1.625>, 0.2}
                        object {Wheel2 translate y*3 rotate <-90,0,90> rotate y*-90 translate <3.8,0.5,1.625>}
                        object {Wheel2 translate y*2 rotate <90,0,90> rotate y*-90 translate <-3.8,-0.5,1.625>}
                }
                rotate y*210
                material {T5}
        }
        translate y*-0.5
}

//___________________________________________________________________________________________________________________________________

#declare Triangle_ =
union {
        triangle {<-1,0,1>, <0,1,0>, <1,0,1>}
        triangle {<1,0,1>, <0,1,0>, <1,0,-1>}
        triangle {<-1,0,-1>, <0,1,0>, <1,0,-1>}
        triangle {<-1,0,1>, <0,1,0>, <-1,0,-1>}
        scale 0.5
}

#macro TriRing_ (start_y, end_y, step_y) 

union {
        #local step_ang = 6;
        #local pos_y = start_y;
        #while (pos_y <= end_y)
                #local ang = 0;
                #while (ang < 360)
                        object {Triangle_ scale 0.125 rotate <-90,0,0> translate <0,pos_y,-1> rotate <0,ang,0>}
                        #local ang = ang+step_ang;
                #end
                #local pos_y = pos_y+step_y;
        #end
}

#end

// Stefan Maes  http://www.irtc.org/ftp/pub/old-competition/competition-Jun-95/sm_xrays.zip

#declare CapillaryHolder =
difference { 
        union { 
                cylinder {<0,0,0>, <0,0,6.5>, 1.5}
		cylinder {<0,0,6.5>, <0,0,7>, 3}
	}
	cylinder {<0,0,-1>, <0,0,8>, 0.4}
} 

#declare BlackScrew =
difference {
	union { 
                cone {<3.3,0,1.15>, 0.85, <3.45,0,1.15>, 1}
		cone {<3.45,0,1.15>, 1, <3.6,0,1.15>, 0.85}
		cylinder {<3.6,0,1.15>, <3.8,0,1.15>, 0.85}
		cone {<3.8,0,1.15>, 0.85, <3.95,0,1.15>, 1}
		cone {<3.95,0,1.15>, 1, <4.1,0,1.15>, 0.85}
		cylinder {<4.1,0,1.15>, <4.3,0,1.15>, 0.85}
		cone {<4.2,0,1.15>, 0.85, <4.35,0,1.15>, 1}
		cone {<4.35,0,1.15>, 1, <4.5,0,1.15>, 0.85}
	}
	box {<3.3,-0.65,0.5>, <4.7,0.65,1.7>}
	material {T5}
} 

#declare TopPiece =
union {
	difference { 
                union { 
                        cylinder {<0,0,0>, <0,0,2.3>, 3.5}
			cone {<0,0,2.3>, 3.5, <0,0,3>, 3}
		}
		plane {-z, -3.25 rotate x*55 rotate z*180}
		plane {-z, -3.25 rotate x*55}
		cylinder {<0,0,1>, <0,0,4>, 1.5}
		cylinder {<3.3,0,1.15>, <4,0,1.15>, 1}
	}
        object {BlackScrew}
} 

#declare MidPiece1 = cylinder {<0,0,0>, <0,0,1>, 2.5} 

#declare Ring =
difference { 
        difference { 
                cylinder {<0,0,0>, <0,0,1.5>, 6}
		cylinder {<0,0,-1>, <0,0,3>, 4}
	}
	cylinder {<5,0,0.75>, <7,0,0.75>, 0.5}
	sphere {<6.4,0,0.75>, 0.8}
	cylinder {<5,0,0.75>, <7,0,0.75>, 0.5 rotate z*90}
	sphere {<6.4,0,0.75>, 0.8 rotate z*90}
	cylinder {<5,0,0.75>, <7,0,0.75>, 0.5 rotate z*180}
	sphere {<6.4,0,0.75>, 0.8 rotate z*180}
	cylinder {<5,0,0.75>, <7,0,0.75>, 0.5 rotate z*270}
	sphere {<6.4,0,0.75>, 0.8 rotate z*270}      
} 

#declare Rod =
union { 
        cylinder {<-6,0,0>, <6,0,0>, 0.9}
	sphere {<-6,0,0>, 0.9 scale <0.9,1,1>}
	sphere {<6,0,0>, 0.9 scale <0.9,1,1>}
}

#declare Wires =
difference {
	union { 
                cone {<0,0,  0>, 3.5, <0,0,0.5>,   4}
		cone {<0,0,0.5>,   4, <0,0,  1>, 3.5}
		cone {<0,0,  1>, 3.5, <0,0,1.5>,   4}
		cone {<0,0,1.5>,   4, <0,0,  2>, 3.5}
		cone {<0,0,  2>, 3.5, <0,0,2.5>,   4}
		cone {<0,0,2.5>,   4, <0,0,  3>, 3.5}
		cone {<0,0,  3>, 3.5, <0,0,3.5>,   4}
		cone {<0,0,3.5>,   4, <0,0,  4>, 3.5}
		cone {<0,0,  4>, 3.5, <0,0,4.5>,   4}
		cone {<0,0,4.5>,   4, <0,0,  5>, 3.5}
		cone {<0,0,  5>, 3.5, <0,0,5.5>,   4}
		cone {<0,0,5.5>,   4, <0,0,  6>, 3.5}
		cone {<0,0,  6>, 3.5, <0,0,6.5>,   4}
		cone {<0,0,6.5>,   4, <0,0,  7>, 3.5}
	}
	box {<-3.2,-5,-1>, <3.2,5,8> inverse}
	union {
		cylinder {<-4,0,2>, <4,0,2>, 1}
		cylinder {<-4,0,5>, <4,0,5>, 1}
		box {<-4,-1,2>, <4,1,5>}
	}
} 

#declare HeightAdjust =
union {
	object {Wires}
	object {Ring translate <0,0,1.0> rotate z*12}
	object {Rod translate <0,0,3.4>}
	object {Ring translate <0,0,4.3> rotate z*-39}
} 

#declare MidPiece2 = cylinder {<0,0,0>, <0,0,0.7>, 2.5}

#declare Trapezium =
union {
	difference { 
	        box {<0,-5.5,0>, <4,5.5,3.5>}
		plane {-z, 4.9 rotate x*243 inverse}
		plane {-z, 4.9 rotate x*243 rotate z*180 inverse}
	}
	difference { 
	        plane {-z, 4.9 rotate x*243}
		box {<0,-5.5,0>, <4,5.5,3.5> inverse}
	}
	difference { 
	        plane {-z, 4.9 rotate x*243 rotate z*180}
		box {<0,-5.5,0>, <4,5.5,3.5> inverse}
	}
	translate <0,0,-1000>
} 

#declare XYShifter =
union { 
        box {<8,7.5,0>, <4,-7.5,0.6>}
        cylinder {<-10,0,0.3>, <10,0,0.3>, 1.1}
	difference {
		box {<-12.6,-0.9,-0.9>, <-10,0.9,0.9> rotate x*35}
		cylinder {<-13,0,0>, <-9,0,0>, 0.8}
		translate <0,0,0.3>
	}
	difference {
		box {<12,-0.9,-0.9>, <10,0.9,0.9> rotate x*35}
		cylinder {<13,0,0>, <9,0,0>, 0.8}
		translate <0,0,0.3>
	}      
}

#declare Screw =
difference { 
        cylinder {<0,0,0>, <0,0,0.3>, 1.3}
	box {<-0.3,-1.5,0.15>, <0.3,1.5,0.4>}
}

#declare XAdjust =
union {
	difference { 
	        box {<-10,-10,0>, <10,10,5>}
		cone {<0,0,0>, 12.5, <0,0,5>, 11.3 inverse}
		object {Trapezium translate <4,0,1002.1>}
		object {Trapezium translate <7,0,1002.1>}
		object {Trapezium translate <-10.2,0,1002.1>}
		box {<11,-12,3.7>, <6,12,4.4>}
		cylinder {<0,0,4.6>, <0,0,6>, 1.4 translate <7, 6,0>}
		cylinder {<0,0,4.6>, <0,0,6>, 1.4 translate <7,-6,0>}
		sphere {<0,10.2,3>, 1.25}
	}
	object {BlackScrew rotate z*90 translate <0,5.7,1.85>}
	object {Screw rotate z*15 translate <7,6,4.6>}
	object {Screw rotate z*65 translate <7,-6,4.6>}
	object {XYShifter translate <0,0,3.8>}
} 

#declare XRail1 =
intersection {
	difference { 
	        box {<-14.4,10,-3>, <14.4,8,4.2>}
		cylinder{ 
		        <0,-14.5,0>, <0,14.5,0>, 14.5
			scale <1,1,0.29>
			translate <0,0,5>
		}
	}
	cylinder { 
		<0,-14.5,0>, <0,14.5,0>, 14.5
		scale <1,1,0.29> 
		translate <0,0,3.5>
	}
} 

#declare XRail2 =
intersection {
	difference { 
	        box {<-14.4,10,-3>, <14.4,6.5,4.2>}
		cylinder { 
		        <0,-14.5,0>, <0,14.5,0>, 14.5
			scale <1,1,0.29> 
			translate <0,0,5>
		}
	}
	cylinder { 
	        <0,-14.5,0>, <0,14.5,0>, 14.5
		scale <1,1,.29> 
		translate <0,0,3.5>
	}
} 

#declare SquareScrew =
difference {
	box {<2,-0.9,-0.9>, <0,0.9,0.9> rotate x*23}
	cylinder {<3,0,0>, <-1,0,0>, 0.8}
	translate <0,0,0.3>
} 

#declare XBow =
union {
      difference {
	        union {
	                difference { 
	                        box {<-20,-10,0>, <20,10,4.2>}
		                cylinder {
		                        <0,-14.5,0>, <0,14.5,0>, 14.5
				        scale <1,1,0.29> 
				        translate <0,0,5>
			        }
		        }
	                object {XRail1 translate <0,0,1.4>}
	                object {XRail1 rotate z*180 translate <0,0,1.4>}
	                object {XRail2 translate <0,0,2.8>}
	                object {XRail2 rotate z*180 translate <0,0,2.8>}
	        }
	        cylinder {<0,0,-3>, <0,0,8>, 15.5 inverse}
	        box {<-20,-2,-1.5>, <-16,2,2>}
	        box {< 15,-2,-1.5>, < 20,2,2>}
        } 
        object {SquareScrew translate <15,0,0.1> }
        object {SquareScrew rotate z*180 translate <15,0,0.1>}
} 

#declare YAdjust =
union {
	difference {
		union { 
		        box {<-10,-10,3>, <10,10,5>}
			cylinder{ 
			        <-10,0,0>, <10,0,0>, 10
				scale <1,1,0.2> 
				translate <0,0,3>
			}
		}
		cylinder {<0,0,-5>, <0,0,5>, 12.5 inverse}
		object {Trapezium translate <4,0,1002.1>}
		object {Trapezium translate <7,0,1002.1>}
		object {Trapezium translate <-10.2,0,1002.1>}
		box {<11,-12,3.7>, <6,12,4.4>}
		sphere {<0,10.2,3>, 1.25}
	}
	object {BlackScrew rotate z*90 translate <0,5.7,1.85>}
	object {XYShifter translate <0,0,3.4>}
	rotate z*-90
} 

#declare MidPiece3 =
difference { 
        box {<-9,-9.9,-1>, <9,9.9,2>}
	object {YAdjust}
	object {XRail1 translate <0,0,-1.4>}
	object {XRail1 rotate z*180 translate <0,0,-1.4>}
	object {XRail2}
	object {XRail2 rotate z*180}
	cylinder {<0,0,-5>, <0,0,5>, 12.5 inverse}
} 

#declare YRail1 =
intersection {
	difference { 
	        box {<-18.4,10,-3>, <18.4,8,4.2>}
		cylinder {
		        <0,-18.5,0>, <0,18.5,0>, 18.5
			scale <1,1,0.29> 
			translate <0,0,4>
		}
	}
	cylinder { 
	        <0,-18.5,0>, <0,18.5,0>, 18.5
		scale <1,1,0.29> 
		translate <0,0,2.5>
	}
} 

#declare YRail2 =
intersection {
	difference { 
	        box {<-18.4,10,-3>, <18.4,6.5,4.2>}
		cylinder {
		        <0,-18.5,0>, <0,18.5,0>, 18.5
			scale <1,1,0.29> 
			translate <0,0,4>
		}
	}
	cylinder { 
	        <0,-18.5,0>, <0,18.5,0>, 18.5
		scale <1,1,0.29> 
		translate <0,0,2.5>
	}
}

#declare YBow =
union {
        object {SquareScrew translate <14.8,0,-2.7>}
        object {SquareScrew translate <14.8,0,-2.7> rotate z*180}
        difference {
	        union {
	                difference { 
	                        box {<-20,-10,-3>, <20,10,4.2>}
			        cylinder{ 
			                <0,-18.5,0>, <0,18.5,0>, 18.5
				        scale <1,1,0.29> 
				        translate <0,0,4>
				}
		        }
	                object {YRail1 translate <0,0,1.5>}
	                object {YRail2 translate <0,0,3.0>}
	                object {YRail1 rotate z*180 translate <0,0,1.5>}
	                object {YRail2 rotate z*180 translate <0,0,3.0>}
	        }
	        cylinder {<0,0,-8>, <0,0,8>, 17.5 inverse}
	        box {<-20,-2,-3.5>, <-16,2,-0.5>}
	        box {< 15,-2,-3.5>, < 20,2,-0.5>}
	}
        rotate z*-90
} 

#declare MidPiece4 =
difference { 
        box {<-9,-9.9,-4>, <9,9.9,1.5>}
	object {YBow translate <0,0,-2>}
} 

#declare MidPiece5 =
union {
	cylinder {<0,0,0>, <0,0,1.3>, 10.4}
	cylinder {<0,0,1.3>, <0,0,2>, 7}
} 

#declare ClipBox =
box { 
        <-1.98,-1.98,-1>, <1.98,1.98,7>
	rotate z*45
	translate <19,0,0>
} 

#declare ClipBox2 =
union { 
        object {ClipBox}
	object {ClipBox rotate z*4.5}
} 

#declare ClipBox3 =
union { 
        object {ClipBox2}
	object {ClipBox2 rotate z*9}
	object {ClipBox2 rotate z*18}
	object {ClipBox2 rotate z*27}
	object {ClipBox2 rotate z*36}
} 

#declare ClipBox4 =
union { 
        object {ClipBox3}
	object {ClipBox3 rotate z*45}
	object {ClipBox3 rotate z*90}
	object {ClipBox3 rotate z*135}
	object {ClipBox3 rotate z*180}
	object {ClipBox3 rotate z*225}
	object {ClipBox3 rotate z*270}
	object {ClipBox3 rotate z*315}
} 

#declare FastenRing =
difference {
        union { 
                cone {<0,0,0>, 16.5, <0,0,1>, 17.5}
        	cylinder {<0,0,1>, <0,0,4>, 17.5}
        	cone {<0,0,4>, 17.5, <0,0,5>, 16.5}
	}
        object {ClipBox4}
} 

#declare GonioHead =
union {
        object {FastenRing      translate <0,0,-4>}
        object {FastenRing      translate <0,0,5>}
        object {MidPiece5       translate <0,0,10> material {T6}}
        object {YBow            translate <0,0,15>}
        object {MidPiece4       translate <0,0,17.2>}
        object {XBow            translate <0,0,17.2>}
        object {MidPiece3       translate <0,0,20> material {T6}}
        object {YAdjust         translate <0,0,20> material {T6}}
        object {XAdjust         translate <0,0,24.9>}
        object {MidPiece2       translate <0,0,29.9>}
        object {HeightAdjust    translate <0,0,30.6> material {T6}}
        object {MidPiece1       translate <0,0,37.6>}
        object {TopPiece        translate <0,0,38.6>}
        object {CapillaryHolder translate <0,0,35.3> material {T6}}
}

#declare BoltTop_ =
union {
        cylinder {<0,-0.3125,0>, <0,0.3125,0>, 1}
        cylinder {<0,0.3125,0>, <0,0.4375,0>, 1.0625}
        cylinder {<0,-0.3125,0>, <0,-0.4375,0>, 1.0625}
        union {
                torus {0.8125, 0.25}
                cylinder {<0,-0.25,0>, <0,0.25,0>, 0.8125}
                translate <0,0.4375,0>
        }
        cylinder {<0,-0.4375,0>, <0,-0.5,0>, 1}
        TriRing_ (-0.25, 0.25, 0.125)
        object {GonioHead rotate x*90 rotate y*20 scale <1,-1,1>*0.121 translate y*5.4}
}

//___________________________________________________________________________________________________________________________________

// front wheels - N.B.  http://www.irtc.org/ftp/pub/stills/1998-02-28/14t.zip

#declare F_AXL_LNG01 = 27;
#declare F_AXL_DST01 = 18;
#declare F_AXL_RAD01 = 1;
#declare F_AXL_HGT01 = 8;
#declare F_AXL_RAD02 = 4.5;
#declare F_AXL_RAD03 = 4;
#declare F_AXL_RAD10 = 0.5;
#declare F_AXL_LNG10 = 5;
#declare F_AXL_A01 = F_AXL_LNG01-F_AXL_DST01;
#declare F_AXL_B01 = F_AXL_HGT01-F_AXL_RAD02-F_AXL_RAD03;
#declare F_AXL_C01 = sqrt (pow (F_AXL_A01, 2)+pow (F_AXL_B01, 2));
#declare F_AXL_C02 = F_AXL_RAD02/F_AXL_RAD03*F_AXL_C01/(F_AXL_RAD02/F_AXL_RAD03+1);
#declare F_AXL_a01 = atan2 (F_AXL_B01, F_AXL_A01);
#declare F_AXL_a02 = acos (F_AXL_RAD02/F_AXL_C02);
#declare F_AXL_a00 = F_AXL_a02-F_AXL_a01;
#declare F_AXL_b00 = degrees (pi/2-F_AXL_a00);
#declare F_AXL_ROT01 = 0;
#declare INNR01 = 10;
#declare OUTR01 = 18;
#declare WHITE = 15;
#declare SMOO01 = (OUTR01-INNR01)/2;
#declare SMOO02 = 0.5;
#declare SM0s01 = 0.5;
#declare WIDT01 = 17;
#declare DEPTH01 = 0.7;
#declare WHEEL_RAD00 = 18;
#declare WHEEL_RAD10 = 1;
#declare WHEEL_RAD01 = 15;
#declare WHEEL_RAD02 = 2; 
#declare WHEEL_RAD12 = WHEEL_RAD02/2;
#declare WHEEL_RAD11 = WHEEL_RAD01-WHEEL_RAD02+WHEEL_RAD12;
#declare WHEEL_RAD13 = 15;
#declare WHEEL_RAD14 = 0.2;
#declare CYL_RAD01 = 1.7;
#declare CYL_LNG01 = 3.5;
#declare SP_WH_NUM01 = 8;
#declare SP_WH_ANG00 = 360/(SP_WH_NUM01+1);
#declare SP_WH_LNG01 = 2.5;
#declare SP_WH_LNG11 = 0.4;
#declare SP_WH_RAD01 = 2.1;
#declare SP_WH_RAD11 = 2.3;
#declare SP_WH_RAD02 = 0.15;
#declare BR_DSK_RAD00 = 6;
#declare BR_DSK_THK00 = 1.5;
#declare BR_DSK_RAD01 = 10;
#declare BR_DSK_THK01 = 0.4;
#declare BR_DSK_RAD11 = 1;
#declare BR_DSK_RAD02 = 0.4;
#declare BR_DSK_NUM01 = 23;
#declare BR_DSK_ANG01 = 360/(BR_DSK_NUM01+1);
#declare BR_DSK_RAD13 = 5.5;
#declare BR_DSK_RAD23 = 3.5;
#declare BR_DSK_THK03 = 2.5;
#declare BR_DSK_RAD04 = 2;
#declare BR_DSK_THK04 = 3;

#declare TY00 =
union {
        union {
                torus {WHEEL_RAD00, WHEEL_RAD10 rotate x*90 scale <1,1,2*0.7>}
                torus {
                        WHEEL_RAD00-(WHEEL_RAD00-WHEEL_RAD01)/2, (WHEEL_RAD00-WHEEL_RAD01)/2*1.05
                        rotate x*90 
                        scale <1,1,0.3>
                        translate z*-WHEEL_RAD02*0.7
                }
                torus {
                        WHEEL_RAD00-(WHEEL_RAD00-WHEEL_RAD01)/2, (WHEEL_RAD00-WHEEL_RAD01)/2*1.05
                        rotate x*90 
                        scale <1,1,0.3>
                        translate z*WHEEL_RAD02*0.7
                }
                scale <1,1,1.05>
                material {M_tyre}
        }
        torus {WHEEL_RAD11, WHEEL_RAD12 rotate x*90 scale <1,1,2>}
        difference {
                cylinder {<0,0,-WHEEL_RAD12*2>, <0,0,WHEEL_RAD12*2>, WHEEL_RAD13}
                cylinder {<0,0,-WHEEL_RAD12*2.2>, <0,0,WHEEL_RAD12*2.2>, WHEEL_RAD11}
        }
        torus {WHEEL_RAD13, WHEEL_RAD14 rotate x*90 translate z*-WHEEL_RAD12*2}
        torus {WHEEL_RAD13, WHEEL_RAD14 rotate x*90 translate z*WHEEL_RAD12*2}
        cylinder {<0,0,-CYL_LNG01> <0,0,CYL_LNG01> CYL_RAD01}
        sphere {0, CYL_RAD01 scale <1,1,0.5> translate <0,0,-CYL_LNG01>}
        cylinder {<0,0,-SP_WH_LNG11/1.5>, <0,0,SP_WH_LNG11/1.5>, SP_WH_RAD11 translate z*-SP_WH_LNG01}
        cylinder {<0,0,SP_WH_LNG11/1.5>, <0,0,-SP_WH_LNG11/1.5>, SP_WH_RAD11 translate z*SP_WH_LNG01}
        #declare SP_01 =
        union {
                #while (SP_WH_NUM01 >= 0)
                        cylinder {
                           vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
                           vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01-SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01-SP_WH_ANG00*2)>)
                           SP_WH_RAD02
                        }
                        sphere {
                           vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
                           SP_WH_RAD02
                        }
                        sphere {
                           vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01-SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01-SP_WH_ANG00*2)>)
                           SP_WH_RAD02
                        }
                        cylinder {
                           vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
                           vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01+SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01+SP_WH_ANG00*2)>)
                           SP_WH_RAD02
                           rotate z*SP_WH_ANG00/2
                        }
                        sphere {
                           vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
                           SP_WH_RAD02
                           rotate z*SP_WH_ANG00/2
                        }
                        sphere {
                           vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01+SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01+SP_WH_ANG00*2)>)
                           SP_WH_RAD02
                           rotate z*SP_WH_ANG00/2
                        }
                        #declare SP_WH_NUM01 = SP_WH_NUM01-1;
                #end
        }
        object {SP_01}
        object {SP_01 rotate y*180 rotate z*SP_WH_ANG00/4}
        translate z*-(CYL_LNG01+BR_DSK_THK00*2)
}
 
#declare F_AXL_LNG01 = 27;
#declare F_AXL_DST01 = 18;
#declare F_AXL_RAD01 = 1;
#declare F_AXL_HGT01 = 8;
#declare F_AXL_RAD02 = 4.5;
#declare F_AXL_RAD03 = 4;
#declare F_AXL_RAD10 = 0.5;
#declare F_AXL_LNG10 = 5; 
                
#declare f_wheels =
union {     
        object { 
                TY00
                rotate x*3
                scale 0.85*<1,1,-1>
                rotate y*F_AXL_ROT01
                translate <0,F_AXL_HGT01,(F_AXL_LNG01+1+16)>
        }
        object { 
                TY00
                rotate x*3
                scale 0.85
                rotate y*F_AXL_ROT01
                translate <0,F_AXL_HGT01,-(F_AXL_LNG01+1+16)>
        }
        object { 
                leg_connector
                rotate x*-90 
                rotate z*20
                rotate x*3
                scale 0.17*<1,1,-1>
                rotate y*F_AXL_ROT01
                translate <0,F_AXL_HGT01,(F_AXL_LNG01+1+20)>+<-0.07,0.18,-0.43> 
                material {cover}
        }
        object {
                leg_connector 
                rotate x*-90 
                rotate z*20
                rotate x*3
                scale 0.17
                rotate y*F_AXL_ROT01
                translate <0,F_AXL_HGT01,-(F_AXL_LNG01+1+20)>+<-0.07,0.18,0.43> 
                material {cover}
        }
}

//___________________________________________________________________________________________________________________________________

// "egghead" 

#declare banner =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.853,0.394,0.392> <2.626,0.483,0.311>  <2.323,0.601,0.204>  <2.096,0.689,0.123> 
		<2.853,0.394,0.392> <2.917,0.561,-0.191> <2.793,0.687,-0.122> <2.566,0.776,-0.203> 
		<2.853,0.394,0.392> <2.917,0.561,-0.191> <2.778,0.793,-0.389> <2.892,1.026,-0.914> 
		<2.853,0.394,0.392> <3.144,0.473,-0.11>  <3.119,0.937,-0.833> <3.233,1.17,-1.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.516,0,1.544>      <1.281,0,1.127>      <0.968,0,0.571>      <0.733,0,0.154> 
		<1.093,-0.191,1.662> <0.859,-0.191,1.245> <0.806,-0.143,0.519> <0.572,-0.143,0.102> 
		<0.437,0,1.828>      <0.444,0,1.259>      <0.212,0,0.652>      <0.22,0,0.083> 
		<-0.026,0,1.95>      <-0.018,0,1.380>     <-0.008,0,0.621>     <0,0,0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.579,0.725,1.499> <1.350,0.725,1.145> <1.045,0.725,0.672> <0.815,0.725,0.318> 
		<1.417,0.678,1.638> <1.188,0.678,1.284> <0.844,0.624,0.677> <0.615,0.624,0.322> 
		<1.709,0.087,1.489> <1.474,0.087,1.073> <1.130,0.145,0.624> <0.896,0.145,0.207> 
		<1.516,0,1.544>     <1.281,0,1.127>     <0.968,0,0.571>     <0.733,0,0.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.853,0.394,0.392> <2.626,0.483,0.311> <2.323,0.601,0.204> <2.096,0.689,0.123> 
		<2.597,0.326,0.834> <2.370,0.414,0.754> <2.007,0.543,0.423> <1.780,0.631,0.342> 
		<1.961,0.838,1.17>  <1.732,0.838,0.816> <1.391,0.901,0.664> <1.162,0.901,0.31> 
		<1.579,0.725,1.499> <1.35,0.725,1.145>  <1.045,0.725,0.672> <0.815,0.725,0.318> 
	}
	scale <1,1,-1>
	material {flag}
}

#declare antenna =
union { 
        #declare i = 0;
        #while (i < 6)
                sphere {
                        0, 0.177+sin (i*pi*7)*0.02
                        translate <i*i*-0.4,0,i*-7> 
                }
                #declare i = i+0.002;
        #end
        object {
                banner 
                scale 2 
                rotate x*-90 
                rotate z*-90 
                rotate x*-90 
                rotate y*-55 
                translate <5.5*5.5*-0.4,0,5.5*-7>
        }
        scale 1.2 
        rotate <90,0,0> 
        material {M_pla}
}

//___________________________________________________________________________________________________________________________________

#declare ElPipe4_ = 
union {
        cylinder {-10*x, x*10, 1}
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
        }
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*90
        }
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*180
        }
        union {
                cylinder {-10*x, -6*x, 0.15}
                cylinder {-5*x, -2*x, 0.15}
                cylinder {-x, x, 0.15}
                cylinder {2*x, 4*x, 0.15}
                cylinder {5*x, 7*x, 0.15}
                cylinder {8*x, 10*x, 0.15}
                sphere {0, 0.15 translate -x*6}
                sphere {0, 0.15 translate -x*5}
                sphere {0, 0.15 translate -x*2}
                sphere {0, 0.15 translate -x}
                sphere {0, 0.15 translate x}
                sphere {0, 0.15 translate x*2}
                sphere {0, 0.15 translate x*4}
                sphere {0, 0.15 translate x*5}
                sphere {0, 0.15 translate x*7}
                sphere {0, 0.15 translate x*8}
                sphere {0, 0.25 translate -x*5.5}
                sphere {0, 0.25 translate -x*1.5}
                sphere {0, 0.25 translate x*1.5}
                sphere {0, 0.25 translate x*4.5}
                sphere {0, 0.25 translate x*7.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate -x*5.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate -x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*1.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0} translate x*4.5}
                intersection {torus {0.5, 0.15 rotate x*90} plane {y, 0 inverse} translate x*7.5}
                translate -z
                rotate x*270
        }
        torus {1, 0.15 rotate z*90 translate -x*10}
        torus {1, 0.15 rotate z*90 translate -x*6}
        torus {1, 0.15 rotate z*90 translate -x*2}
        torus {1, 0.15 rotate z*90 translate x*2}
        torus {1, 0.15 rotate z*90 translate x*6}
        torus {1, 0.15 rotate z*90 translate x*9.99}
        scale 0.01
        rotate z*90
        rotate y*90 
}

//____________________________________________________________________________________________________________________________________________________

#declare colrand = seed (0); 
#declare rt = seed (2);

#declare egghead =
union {
        ovus {1, 0.25 hollow double_illuminate material {T3}} 
        #declare p = 0;
        #while (p < 50)
                sphere {
                        <0,0,0>, 1
                        hollow
                        M_glow ()
                        scale 0.07
                        translate 0.92*pow (rand (rt), 0.5)*y
                        rotate 360*<rand (rt),rand (rt),rand (rt)>
                }
                #declare p = p+1;
        #end                                
        union {
                torus {0.154, 0.005 translate <0,-0.986,0>} 
                torus {0.432, 0.005 translate <0,-0.9,0>}   
                torus {0.661, 0.005 translate <0,-0.75,0>}  
                torus {0.856, 0.005 translate <0,-0.52,0>}  
                torus {0.966, 0.005 translate <0,-0.26,0>}  
                torus {1, 0.005}                            
                torus {0.966, 0.005 translate <0,0.26,0>}   
                torus {0.856, 0.005 translate <0,0.52,0>}   
                torus {0.689, 0.005 translate <0,0.75,0>}   
                torus {0.507, 0.005 translate <0,0.94,0>}   
                torus {0.323, 0.005 translate <0,1.09,0>}
                torus {0.166, 0.005 translate <0,1.191,0>}          
                union {
                        torus {0.154+0.005, 0.001 translate <0,-0.986,0>}  
                        torus {0.432+0.005, 0.001 translate <0,-0.9,0>}    
                        torus {0.661+0.005, 0.001 translate <0,-0.75,0>}   
                        torus {0.856+0.005, 0.001 translate <0,-0.52,0>}   
                        torus {0.966+0.005, 0.001 translate <0,-0.26,0>}   
                        torus {1+0.005, 0.001}                             
                        torus {0.966+0.005, 0.001 translate <0,0.26,0>}    
                        torus {0.856+0.005, 0.001 translate <0,0.52,0>}    
                        torus {0.689+0.005, 0.001 translate <0,0.75,0>}    
                        torus {0.507+0.005, 0.001 translate <0,0.94,0>}    
                        torus {0.323+0.005, 0.001 translate <0,1.09,0>}    
                        torus {0.166+0.005, 0.001 translate <0,1.191,0>}     
                        material {cover}
                } 
                union {
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 1)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.154,-0.986,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end
                                                
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.432,-0.9,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end
                        
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.661,-0.75,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end
                        
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.856,-0.52,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end  
                                                      
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.966,-0.26,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end 
                                                       
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <1,0,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end 
                                                       
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.856,0.52,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end 
                                                       
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.689,0.75,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end 
                                                       
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.507,0.94,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end 
                                                       
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 3)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.323,1.09,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end  
                                                      
                        #declare q = 0;
                        #declare r = rand (rt);
                        #while (q < 1)
                                sphere {0, 0.04 scale <1,1/1.4,1> translate <0.166,1.191,0> rotate y*(r*360+q*120+(rand (rt)-0.5)*90)}
                                #declare q = q+1;
                        #end
                        material {T5}
                }
                sphere {0, 0.03 scale <1,0.5,1> translate <0,-1,0>}
                sphere {0, 0.03 scale <1,0.5,1> translate <0,1.25,0>}
                #declare s = 0;
                #while (s < 20)
                        object {ElPipe4_ translate <0,-1.15+s*0.2,0>}
                        #declare s = s+1;
                #end 
                sphere {0, 0.01 scale <1,50,1> translate <0,-1.15,0>}
                torus {0.01, 0.0015 rotate z*90 scale <1,43.6087,1> translate <0,-1.15,0>} 
                torus {0.01, 0.0015 rotate z*90 rotate y*90 scale <1,43.6087,1> translate <0,-1.15,0>} 
                sphere {0, 0.01 scale <1,100,1> translate <0,2.85,0>} 
                torus {0.01, 0.0015 rotate z*90 scale <1,87.087,1> translate <0,2.85,0>} 
                torus {0.01, 0.0015 rotate z*90 rotate y*90 scale <1,87.087,1> translate <0,2.85,0>}                               
                union {
                        sphere {0, 0.02 scale <1,0.4,1> translate <0,-1.14,0>}
                        sphere {0, 0.02 scale <2,0.4,2> translate <0,1.275,0>}
                        sphere {0, 0.02 scale <1.5,0.4,1.5> translate <0,1.305,0>}
                        sphere {0, 0.02 scale <1,0.4,1> translate <0,1.34,0>}
                        torus {0.06, 0.01 scale <1,1.5,1> rotate <0,0,90> translate <-1,0,0>}
                        torus {0.045, 0.01 scale <1,1.5,1> rotate <0,0,90> translate <-1.02,0,0>}
                        torus {0.03, 0.01 scale <1,1.5,1> rotate <0,0,90> translate <-1.04,0,0>}
                        sphere {0, 0.03 scale <1,0.7,1> translate <-1.05,0,0>}
                        material {cover}
                }
        }
        scale 15*<1,1.4,1>
        rotate <90,0,-90>
        rotate y*-90 
        translate y*18.35
} 
        
//____________________________________________________________________________________________________________________________________________________

//#declare vehicle =
union {             
        object {antenna translate <0,33.35,0>}         
        object {egghead}
        object {shaft scale 1.5 translate y*0.9}        
        object {BoltTop_ scale 1.5 translate y*-2.75 rotate <180,0,0>}        
        object {tripod translate y*-3 rotate y*-30}
        object {f_wheels translate <26,-61.6,0>}
        hollow double_illuminate
        material {T4}
        scale 0.3*<1,1,-1>
        rotate y*-20
        rotate x*5
        rotate z*-1.5
        translate <-15,-13,-60> 
} 
