/*
   ----------------              primitives3.pov                ------------------------
   ----------------              1.February 2016                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.7;

#declare RAD = 32; 
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 5
        noise_generator 2
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 60*RAD                
                        nearest_count min (20,RAD)      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media on
                        always_sample off
                }
        #end
}

#include "stdinc.inc"

sky_sphere {
        pigment {
                average
                pigment_map {
                        [1      function {max (min (y, 1), 0)} 
                                color_map {
                                        [0      rgb 2.35]
                                        [0.96   rgb 4.5]
                                        [1      rgb 13.5]
                                }
                        ]
                        [1      function {max (min (y, 1), 0)}
                                turbulence 0.2
                                color_map {
                                        [0      rgbt 1]
                                        [0.5    rgbt <0.385,0.77,1.1,1>]
                                }
                                rotate <0,0,-45>
                        ]
                }
        } 
}

light_source {  
        <2000,1000,1500>, 
        color <2.42,2.23,1.87>
        area_light <100,0,0>, <0,100,0> 7, 7 adaptive 1 jitter circular orient
}

#declare camloc = <0,3.9,-5.85>;
#declare lookat = <-0.9,-0.5,0>;

camera {
        location camloc
        look_at lookat
        right x*image_width/image_height 
        up y 
        angle 36.3852*image_width/image_height
        //focal_point lookat+(camloc-lookat)*-0.1 aperture 0.05 blur_samples 200 confidence 0.99 variance 1/200000
}

//____________________________________________________________________________________________________

// original Skin material by Rene Bui  Human skin : sss+aoi  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.421073fe53a72495e23538ee0@news.povray.org%3E/?ttop=313762&toff=250

#declare SkinCol = <0.95,0.9,0.85>;  

#declare T1 =
material {
        texture {
                pigment {color rgb SkinCol filter 0.75}
                finish {ambient 0 diffuse 0.6}
        }
        texture {
                pigment {
                        aoi 
                        color_map {
                                [0      rgb SkinCol*0.7 filter 1]
                                [0.167  rgb SkinCol*1.2 transmit 0.66]
                                [0.333  rgb SkinCol+5 filter 0.1]
                                [0.5    rgb 10]
                                [0.667  rgb SkinCol+5 filter 0.1]
                                [0.833  rgb SkinCol*1.2 transmit 0.66]
                                [1      rgb SkinCol*0.7 filter 1]
                        }
                }
                finish {
                        emission SkinCol*0.01
                        diffuse 0.6 
                        specular 0.1 
                        roughness 0.03 
                }
        }
        texture {
                pigment {color rgb SkinCol transmit 0.15}
                finish {
                        emission SkinCol*0.01
                        diffuse 0.6 
                        specular 0.1 
                        roughness 0.03 
                }
                normal {
                        dents -0.25
                        scale 0.002
                }
        }
        interior {
                ior 1.35
                media {
                        scattering {1, rgb 8 extinction 0.2}
                        method 3
                        aa_level 4
                        intervals 1
                        samples 10
                }
        }
}

//____________________________________________________________________________________________________

// Making colormaps by use of a color palette collection with up to 65536 color_map entries - see http://news.povray.org/povray.binaries.images/message/%3Cweb.560286c8f956c062746db0c30%40news.povray.org%3E/#%3Cweb.560286c8f956c062746db0c30%40news.povray.org%3E
// Original ColorMapScan macro by Christophe Bouffartigue - Insects and... Spiderman  http://www.irtc.org/ftp/pub/stills/2001-06-30/cbspider.zip
// Crackle pattern suggested by Christopher James Huff  http://news.povray.org/povray.binaries.images/message/%3Ccjameshuff-60FE99.19152913102003%40netplex.aussie.org%3E/#%3Ccjameshuff-60FE99.19152913102003%40netplex.aussie.org%3E    

#declare mapnum = 7;                

#macro ColorMapScan (map, pigfun, mapnum, colnum, mapmax, reverse)    
 
#declare PigScan = 
pigment {
        image_map {png map} 
        warp {repeat y flip y}
}

#if (mapnum > mapmax)
        #declare reverse = 1;       
#end

#local J = 0;       
#local K = mod (colnum,256);
#local L = 0;
#local O = 256/colnum;
#if (K = 0)
        #local N = int (colnum/256);
#else
        #local N = int (colnum/256)+1;
#end 

pigfun
pigment_map { 
        #while (J < N)
                [L/colnum
                        pigfun
                        color_map {  
                                #local I = L/colnum;
                                #if (J = N)
                                        #local M = 1;
                                #else
                                        #local M = I+O;
                                #end
                                #while (I < M)
                                        #if (L < colnum+1)
                                                #if (reverse)
                                                        [I      eval_pigment (PigScan, <mapnum/mapmax-1/(mapmax*2),1-I+0.5/colnum,0.5>)]
                                                #else
                                                        [I      eval_pigment (PigScan, <mapnum/mapmax-1/(mapmax*2),I+0.5/colnum,0.5>)]                
                                                #end
                                                #local I = I+(1/colnum);
                                                #local L = L+1;
                                        #end
                                #end
                        }
                ]
                #local J = J+1;
        #end
}

#end 

#declare f_radi = function {pattern {cells}}
#declare f_pig1 = function {pattern {crackle metric 1 form <0,-2,2>}}   
 
#declare f_p =
pigment { 
        function {-100*f_pig1 (x-f_radi (x,y,z), y-f_radi (x,y,z), z-f_radi (x,y,z))}
}

#declare T2 =
material {
	texture {
                pigment {       
                        average 
                        pigment_map {
		                [0.25   color rgb <65,136,166>/255]
                                [1      ColorMapScan ("2500_colormaps18", f_p, mapnum, 256*64, 11, 0)
                                        scale 5
                                ]
                        }
                }
		normal {
			average
			normal_map {
				[1      quilted 3
					control0 0.5
					control1 0.9
					scale 0.24
					turbulence 1
				]
				[1      bumps 0.9
					warp {turbulence 1}
					scale 2
				]
				[1      bumps 0.6
					//warp {turbulence 0.5}   // uncommenting causes black pixels on wireframes! (see http://news.povray.org/povray.binaries.images/thread/%3Cweb.56b0ca867e1cd917dea14abf0%40news.povray.org%3E/)
					scale 0.01
				]
			}
                        scale 0.05
		}
                finish {diffuse 0.5 reflection 0.01}
	}
	interior {ior 1.4}
}
 
//____________________________________________________________________________________________________   

// parabol macro found in Google Code Archive  https://storage.googleapis.com/google-code-archive-source/v2/code.google.com/spirals/source-archive.zip  (caution! - a 1.3 GB download)

#macro fonctionX (xx)

tan (xx)*cos (xx)

#end

#macro fonctionY (xx) 

tan (xx+pi/2)*cos (xx+pi/2)*asin (xx+pi/2)*sin (xx+pi/2)

#end 

#declare oldcoord = array [500]; 
#declare newcoord = array [500]; 
#declare oldcoord [0] = <-1214,0,0>;

#macro parabol (zmin, zmax, nbPts, a, b, c, rsphere, rcyl, rx, ry, tx, tz, id)

#local zcur = zmin; 
#local step = (zmax-zmin)/nbPts; 
#local index = 0; 

union {
        #while (zcur <= zmax)
                sphere {
                        <0,fonctionX (zcur),fonctionY (zcur)>, 
                        rsphere 
                        rotate rx*x 
                        rotate ry*y 
                        translate tx*x 
                        translate tz*z
                } 
                #if (id != 0)
                        #declare oldcoord [index] = newcoord [index];
                #end
                #declare newcoord [index] = 
                vtransform (
                        <0,fonctionX (zcur),fonctionY (zcur)>, 
                        transform {
                                rotate rx*x 
                                rotate ry*y 
                                translate tx*x 
                                translate tz*z
                        }
                );
                #if (index != 0)
                        cylinder {
                                <0,fonctionX (zcur),fonctionY (zcur)>,
                                <0,fonctionX (zcur-step),fonctionY (zcur-step)>, 
                                rcyl
                                rotate rx*x 
                                rotate ry*y 
                                translate tx*x 
                                translate tz*z
                        } 
                #end 
                #local index = index+1;
                #local zcur = zcur+step; 
        #end 
        #if (id != 0)
                #local index = 0; 
                #while (index <= nbPts)
                        cylinder {
                                oldcoord [index], newcoord [index], rcyl 
                        }
                        #local index = index+1; 
                #end 
        #end 
}
 
#end  

#declare birdy =
union {
        #declare nbsteps = 100;  
        #declare index = 0; 
        #declare rs = 0.012; 
        #declare gr = 2; 
        #while (index <= nbsteps)
                object {
                        parabol (0, 2*pi, 100, 1, 0, 0, rs, rs, 2*index/nbsteps*360, 0.5*index/nbsteps*360, gr*cos (index/nbsteps*2*pi), gr*sin (index/nbsteps*2*pi), index)
                }
                #declare index = index+1;  
        #end
        material {T1}
}

object {birdy}
object {birdy scale 0.4 rotate y*140 translate <-5,-1.2,1.5>} 
object {birdy scale 0.4 rotate y*280 translate <-7,-1.2,7>}

plane {
        y, -2 
        material {T2}
}
