/*
   ----------------              primitives2.pov                ------------------------
   ----------------              29.January 2016                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.7;

#declare RAD = 16;  
                
global_settings {
        assumed_gamma 1
        max_trace_level 4
        noise_generator 2 
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 60*RAD                
                        nearest_count min (20, RAD)      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 2      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media off
                        always_sample off
                }
        #end
}        

#include "stdinc.inc"

#declare cam_loc = <-2,-2,8>;
#declare lookat = <0,-1,0>;  

camera { 
        location cam_loc
        look_at lookat 
        right x*image_width/image_height 
        up y 
        angle 67.38*image_width/image_height*0.75
}

sky_sphere {
        pigment {
                average
                pigment_map {
                        [1      function {max (min (y, 1), 0)} 
                                color_map {
                                        [0      rgb 2.35]
                                        [0.96   rgb 4.5]
                                        [1      rgb 13.5]
                                }
                        ]
                        [1      function {max (min (y, 1), 0)}
                                turbulence 0.2
                                color_map {
                                        [0      rgbt 1]
                                        [0.5    rgbt <0.385,0.77,1.1,1>]
                                }
                                rotate z*-45
                        ]
                }
        }
}  

//____________________________________________________________________________________________________

// material definition inspired by http://hd4desktop.com/images/b/1920x1080_3d-view-abstract-balls-cubes-render-d-HD-Wallpaper.jpg 
// original MetalMat macro by James Holsenback  UberPOV  http://news.povray.org/povray.binaries.images/message/%3C5294ab48%241%40news.povray.org%3E/#%3C5294ab48%241%40news.povray.org%3E

#macro MetalMat (Color)

texture {
	aoi
	texture_map {
		[0      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
                [0.4    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
                [0.6    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
		[1      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
	}        
}

#end

#declare T1 =
material {
	MetalMat (<1,0,0>)              // red superellipsoids
	interior {ior 1.5}
}   

//____________________________________________________________________________________________________

#macro MetalMat2 (Color)

texture {
	gradient y
	scale 0.5
	rotate <-20,20,20>
	texture_map {
	        [0.4    aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
                [0.45   pigment {color rgb <0,0.5,1>}
	                normal {granite 0.02 scale 0.001}
	                finish {
	        	        emission 0.5
	        	        phong 8
	        	        phong_size 200
	        	        ambient 0
	        	        reflection 0.2
	        	}
	        ]
	        [0.55   pigment {color rgb <0,0.5,1>}
	                normal {granite 0.02 scale 0.001}
	                finish {
	        	        emission 0.5
	        	        phong 8
	        	        phong_size 200
	        	        ambient 0
	        	        reflection 0.2
	        	}
	        ]
	        [0.6    aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
        }            
}

#end

#declare T2 =
material {
	MetalMat2 (<0,0.5,1.6>)         // blue sphere     
	interior {ior 1.5}
}

//____________________________________________________________________________________________________

#declare epaint =
texture {
	crackle
	metric 30
	offset 0.4
	scale 0.2
	texture_map {
		[0.03   pigment {color srgb <1,0.98,0.96>}
			finish {
				ambient 0
				diffuse 0.1
				reflection {0, 1 fresnel on}
				specular 2
				roughness 0.007
				brilliance 5
			}
			normal {
				crackle
				metric 30
				offset 0.4
				slope_map {
					[0      <0, 8>]
					[0      <1,-8>]
					[0.05   <1, 8>]
					[0.05   <0,-8>]
				}
				poly_wave 2
			}
		]
		[0.03   pigment {
				crackle
				metric 30
				offset 0.4
				scale 0.4
				color_map {
					[0.05   srgb <0.05,0.115,0.05>]
					[0.05   srgb <0.02,0.115,0.08>]
					[0.2    srgb <0.02,0.115,0.08>]
					[0.2    srgb <0.01,0.105,0.12>]
					[0.25   srgb <0.01,0.105,0.12>]
					[0.25   srgb <0.02,0.115,0.08>]
				}
			}
                        normal {
                                bumps 0.1 
                                warp {turbulence 0.5} 
                                scale <0.02,0.02,0.02>*0.03
                        }
			finish {
				ambient 0
				diffuse 0.6
				reflection {0, <0.085,0.0915,0.085> fresnel on}
				metallic
				specular 0.8
				roughness 0.01
				brilliance 1
			}
		]
	}
}

#declare T3 =
material {
	texture {epaint}                // "wired" superellipsoids
	interior {ior 4}
        scale 3
}

//____________________________________________________________________________________________________

// original Granule macro by Loki  Funky Granules  http://news.povray.org/povray.binaries.images/thread/%3Cweb.443fb66aa9f0c1853e48c3860%40news.povray.org%3E/

#declare r1 = seed (0);

#macro GRANULE (GrObj, Res)

#local MinExt = 0;
#local MaxExt = 0;

Extents (GrObj, MinExt, MaxExt)

#local MinCxLim = Res*floor ((MinExt.x)/Res);
#local MinCyLim = Res*floor ((MinExt.y)/Res);
#local MinCzLim = Res*floor ((MinExt.z)/Res);
#local MaxCxLim = Res*ceil ((MaxExt.x)/Res);
#local MaxCyLim = Res*ceil ((MaxExt.y)/Res);
#local MaxCzLim = Res*ceil ((MaxExt.z)/Res);

#local Cz = MinCxLim;
#local n = 0;
union {
	#while (Cz < MaxCzLim)
		#local Cy = MinCxLim;
		#while (Cy < MaxCyLim)
			#local Cx = MinCxLim;
			#while (Cx < MaxCxLim)
				#if (inside (GrObj,<Cx+(Res*0.5),Cy+(Res*0.5),Cz+(Res*0.5)>))
					object {
						#if (rand (r1) > 0.2)
                                                        superellipsoid {<0.4,0.4> scale Res*0.5 translate (<Cx,Cy,Cz>+Res*0.5)} material {T1}
                                                #else
                                                        superellipsoid {<0.4,0.4> scale Res*0.5 translate (<Cx,Cy,Cz>+Res*0.5)} material {T3}
                                                #end 
					}
				#end
				#local Cx = Cx+Res;
			#end
			#local Cy = Cy+Res;
		#end
		#local n = n+1;
		#local Cz = Cz+Res;
	#end
}

#end

#declare set_up = 
difference {
        box {-15, <15,15,8>}
        box {-7, <7,7,8.1>}
}

GRANULE (set_up, 2)

difference {
        box {-16, <16,16,8>}
        box {-15, <15,15,8.1>}
        pigment {color rgb 0}
}

sphere {
        <0,0.5,0>, 0.5 
        material {T2}
        scale 5
        translate <4.5,-7,-4.5>
}