/*
   ----------------              primitives1.pov                ------------------------
   ----------------              29.January 2016                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.7;
                
global_settings {
        assumed_gamma 2.2
        max_trace_level 5
        noise_generator 2
}        

#include "stdinc.inc" 

#declare camloc = <8,2,0>;
#declare lookat = <0,-1.375,0>;
#declare camang = 30*image_width/image_height;

camera {
        ultra_wide_angle
        location <8,2,0>
        look_at <0,-1.375,0>
        angle 30*image_width/image_height
        right image_width/image_height*x
        //focal_point <4.2,1.05,0> aperture 0.02 blur_samples 400 confidence 0.9999 variance 0
}

light_source {<75000,100000,-30000>, color rgb 1.5}

sky_sphere {
        pigment {
                function {max (min (y, 1), 0)}
                color_map {
                        [0      rgb <221,221,221>/255]
                        [0.1029 rgb <229,229,229>/255]
                        [0.1512 rgb <241,241,241>/255]
                        [0.1949 rgb <239,239,239>/255]
                        [0.2444 rgb <227,227,227>/255]
                        [0.2921 rgb <213,213,213>/255]
                        [0.3732 rgb <180,180,180>/255]
                        [0.4255 rgb <172,172,172>/255]
                        [0.7067 rgb <126,126,126>/255]
                        [0.774  rgb <119,119,119>/255]
                        [0.8275 rgb <114,114,114>/255]
                        [0.885  rgb <111,111,111>/255]                        
                        [0.9425 rgb <107,107,107>/255]                        
                        [1      rgb <103,103,103>/255]
                }
        }
}

//____________________________________________________________________________________________________

// material definition inspired by http://hd4desktop.com/images/b/1920x1080_3d-view-abstract-balls-cubes-render-d-HD-Wallpaper.jpg 
// original MetalMat macro by James Holsenback  UberPOV  http://news.povray.org/povray.binaries.images/message/%3C5294ab48%241%40news.povray.org%3E/#%3C5294ab48%241%40news.povray.org%3E

#macro MetalMat (Color)

texture {
	aoi
	texture_map {
		[0      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
                [0.4    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
                [0.6    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
		[1      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
                ]
	}        
}

#end

#declare T2 =
material {
	MetalMat (<187,21,7>/170.934)   // big spheres    
	interior {ior 1.5}
}

#declare T4 =
material {
	MetalMat (<244,225,201>/255)    // wireframe    
	interior {ior 1.5}
} 

//____________________________________________________________________________________________________

// Normal derived from a pigment by Martial Rameaux  Kokeshis  http://cathemline.org/povcheri/sources/kokeshis_scr.zip

#declare C_map =
color_map {
	[0      rgb <1,0.93,0.8>]
	[0.85   rgb <1,0.93,0.8>]
	[0.85   Scarlet]
	[1      Black]
}

#declare P_Onion =
pigment {
	onion
	color_map {C_map}
	warp {turbulence 0.5 omega 0.1}
	frequency 12
	rotate x*45
}
                               
#macro MetalMat3 (Color)

texture {
	aoi
	texture_map {
		[0      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	ambient 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }                    
                        normal {
                                pigment_pattern {P_Onion}
                                0.7 
                                accuracy 0.001
                        }
                        scale 0.7
                ]
                [0.5    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
		[1      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	ambient 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }        
                        normal {
                                pigment_pattern {P_Onion}
                                0.7 
                                accuracy 0.001
                        }
                        scale 0.7
                ]
	}        
}

#end

#declare T1 =
material {
	MetalMat3 (<9,182,171>/1020+0.375)      // small spheres   
	interior {ior 1.5}
} 

//____________________________________________________________________________________________________

// pattern inspired by David Burnett and Christopher James Huff  warp function test images  http://news.povray.org/povray.binaries.images/thread/%3Ccjameshuff-60FE99.19152913102003%40netplex.aussie.org%3E/    

#declare f_radi = function {pattern {radial}}
#declare f_pig1 = function {pattern {crackle metric 19 form <1,0,0>}}

#macro MetalMat4 (Color)

texture {
	function {f_pig1 (x-f_radi (x,y,z),y-f_radi (x,y,z),z-f_radi (x,y,z))}
	scale 0.1
	texture_map {
	        [0.385  aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
                [0.395  pigment {color srgb <9,182+30,171-30>/255}
	                normal {granite 0.02 scale 0.001}
	                finish {
	                        brilliance 4
	                        diffuse 0
	                        ambient 0
	                        emission 0.5
	                        metallic
	                        specular 0.8
	                        roughness 0.025
	                        reflection {0, 1}
	        	}
	        ]
	        [0.405  pigment {color srgb <9,182+30,171-30>/255}
	                normal {granite 0.02 scale 0.001}
	                finish {
	                        brilliance 4
	                        diffuse 0
	                        ambient 0
	                        emission 0.5
	                        metallic
	                        specular 0.8
	                        roughness 0.025
	                        reflection {0, 1}
	        	}
	        ]
	        [0.415  aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
	        [0.585  aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
                [0.595  pigment {color srgb <9,182-30,171+30>/255}
	                normal {granite 0.02 scale 0.001}
	                finish {
	                        brilliance 4
	                        diffuse 0
	                        ambient 0
	                        emission 0.5
	                        metallic
	                        specular 0.8
	                        roughness 0.025
	                        reflection {0, 1}
	        	}
	        ]
	        [0.605  pigment {color srgb <9,182-30,171+30>/255}
	                normal {granite 0.02 scale 0.001}
	                finish {
	                        brilliance 4
	                        diffuse 0
	                        ambient 0
	                        emission 0.5
	                        metallic
	                        specular 0.8
	                        roughness 0.025
	                        reflection {0, 1}
	        	}
	        ]
	        [0.615  aoi
	                texture_map {
	                	[0      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
                                [0.4    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
                                [0.6    pigment {color srgb 0}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {0, 1}
	                                }
                                ]
	                	[1      pigment {color srgb Color*1.5}
	                                finish {
	                                	brilliance 4
	                                	diffuse 0
	                                	ambient 0
	                                	metallic
	                                	specular 0.8
	                                	roughness 0.025
	                                	reflection {srgb Color}
	                                }
                                ]
	                }
                ]
        }            
}

#end 

#declare T3 =
material {
	MetalMat4 (<9,182,171>/255)     // plane
	interior {ior 1.5}
}

//____________________________________________________________________________________________________

// Facetted_Sphere macro by Friedrich A. Lohmller  Facetted_Sphere  http://www.f-lohmueller.de/pov_tut/all_shapes/shapes3_42e.htm

#macro Facetted_Sphere (Quarter_Meridian_Segments, Equatorial_Segments)

#local Facets_Silhouette =
prism {
        -2, 2,
        2*Quarter_Meridian_Segments+4
        <-2, -1>,
        #local Nr    = -Quarter_Meridian_Segments;
        #local EndNr =  Quarter_Meridian_Segments;
        #while (Nr < EndNr+1)
                #local Angle_degrees = Nr* 90/EndNr;
                #local Angle_radians = radians (Angle_degrees);
                <cos (Angle_radians), sin (Angle_radians)>,
                #local Nr = Nr+1;
        #end
        <-2, 1>,
        <-2, -1>
        rotate <-90,0,0> 
        scale <1,1,-1>
}

intersection {
        #local Nr = 0;                
        #local EndNr = Equatorial_Segments;
        #while (Nr < EndNr)
                object { 
                        Facets_Silhouette
                        rotate <0,Nr*360/EndNr,0>
                } 
                #local Nr = Nr+1; 
        #end 
}

#end

//____________________________________________________________________________________________________

// Wireframe structure see poly.pov  https://commons.wikimedia.org/wiki/File:Hexahedron.jpg

#declare notwireframe = 0;
#declare withreflection = 0;
#declare flashiness = 0.25;

#macro This_shape_will_be_drawn ()

pentagonalhexecontahedron (1) 
#declare rotation = seed (1096+3);

#end

#declare tau = (1+sqrt (5))/2;
#declare sq2 = sqrt (2);
#declare sq297 = sqrt (297);
#declare xi = (pow (sq297+17,1/3)-pow (sq297-17,1/3)-1)/3;
#declare sqweird = sqrt(tau-5/27);
#declare ouch = pow ((tau+sqweird)/2,1/3)+pow ((tau-sqweird)/2,1/3);
#declare alfa = ouch-1/ouch;
#declare veta = (ouch+tau+1/ouch)*tau;

#macro snubdodecahedron (s)

addevenpermsevensgn (<2*alfa,2,2*veta>*s)
addevenpermsevensgn (<alfa+veta/tau+tau,-alfa*tau+veta+1/tau,alfa/tau+veta*tau-1>*s)
addevenpermsevensgn (<-alfa/tau+veta*tau+1,-alfa+veta/tau-tau,alfa*tau+veta-1/tau>*s)
addevenpermsevensgn (<-alfa/tau+veta*tau-1,alfa-veta/tau-tau,alfa*tau+veta+1/tau>*s)
addevenpermsevensgn (<alfa+veta/tau-tau,alfa*tau-veta+1/tau,alfa/tau+veta*tau+1>*s)
autoface ()

#end

#macro pentagonalhexecontahedron (s)

snubdodecahedron (s) 
dual ()

#end

#declare points = array [1000];
#declare npoints = 0;
#declare faces = array [1000];
#declare nfaces = 0; 

#macro addpoint (a)

#declare points [npoints] = a;
#declare npoints = npoints+1;

#end

#macro addevenperms (a) 

addpoint (a)
addpoint (<a.y,a.z,a.x>)
addpoint (<a.z,a.x,a.y>) 

#end

#macro addevenpermsevensgn (a)

addevenperms (a)
addevenperms (a*<-1,-1,1>)
addevenperms (a*<-1,1,-1>)
addevenperms (a*<1,-1,-1>)

#end 

#macro addface (d,l)

#local a = vnormalize (d)/l; 
#local f = 1;
#local n = 0; 
#while (n < nfaces-0.5)
        #if (vlength (faces [n]-a) < 0.00001) 
                #local f = 0; 
        #end
        #local n = n+1; 
#end
#if (f)
        #declare faces [nfaces] = a;
        #declare nfaces = nfaces+1;
#end

#end

#macro dual ()

#declare temp = faces;
#declare faces = points;
#declare points = temp; 
#declare temp = nfaces;
#declare nfaces = npoints;
#declare npoints = temp;
 
#end

#macro autoface () 

#declare elength = 1000;
#local a = 0; 
#while (a < npoints-0.5) 
        #local b = 0; 
        #while (b < npoints-0.5)
                #local c = vlength (points [a]-points [b]); 
                #if (c > 0.00001 & c < elength) 
                        #local elength = c; 
                #end
                #local b = b+1; 
        #end 
        #local a = a+1; 
#end
#local a = 0; 
#while (a < npoints-0.5)
        #local b = a+1; 
        #while (b < npoints-0.5)
                #if (vlength (points [a]-points [b]) < elength+0.00001) 
                        #local c = b+1; 
                        #while (c < npoints-0.5)
                                #if (vlength (points [a]-points [c]) < elength+0.00001)
                                        #local n = vnormalize (vcross (points [b]-points [a],points [c]-points [a]));
                                        #local d = vdot (n,points [a]);
                                        #if (d < 0) 
                                                #local n = -n; 
                                                #local d = -d; 
                                        #end
                                        #local f = 1;
                                        #local e = 0; 
                                        #while (e < npoints-0.5)
                                                #if (vdot (n, points [e]) > d+0.00001) 
                                                        #local f = 0; 
                                                #end
                                                #local e = e+1; 
                                        #end
                                        #if (f)
                                                #declare ld = d;
                                                addface (n, d)
                                        #end
                                #end
                                #local c = c+1; 
                        #end 
                #end
                #local b = b+1; 
        #end
        #local a = a+1; 
#end

#end

This_shape_will_be_drawn ()

#declare rot1 = rand (rotation)*pi*2;
#declare rot2 = acos (1-2*rand (rotation));
#declare rot3 = (rand (rotation)+clock)*pi*2;

#macro dorot ()

rotate rot1*180/pi*y
rotate rot2*180/pi*x
rotate rot3*180/pi*y 

#end

#local b = 0;
#local a = 0; 
#while (a < npoints-0.5)
        #local c = vlength (points [a]); 
        #if (c > b) 
                #local b = c; 
        #end
        #local a = a+1; 
#end
#local a = 0; 
#while (a < npoints-0.5)
        #local points [a] = points [a]/b;
        #local a = a+1; 
#end
#local a = 0; 
#while (a < nfaces-0.5)
        #local faces [a] = faces [a]*b;
        #local a = a+1; 
#end

#macro addp (a)

#declare p [np] = a;
#declare np = np+1;

#end

#declare Wireframe_sphere =
union {
        #local a = 0; 
        #while (a < nfaces-0.5)
                #declare p = array [20];
                #declare np = 0;
                #local b = 0; 
                #while (b < npoints-0.5)
                        #if (vdot (faces [a],points [b]) > 1-0.00001) 
                                addp (b) 
                        #end
                        #local b = b+1; 
                #end
                #local c = 0; 
                #while (c < np-0.5)
                        #local d = 0; 
                        #while (d < np-0.5) 
                                #if (p [c] < p [d]-0.5)
                                        #local f = 1;
                                        #local e = 0; 
                                        #while(e < np-0.5) 
                                                #if (e!=c & e!=d & vdot (vcross (points [p [c]],points [p [d]]),points [p [e]]) < 0)
                                                        #local f = 0;
                                                #end 
                                                #local e = e+1; 
                                        #end
                                        #if (f)
                                                object {
                                                        cylinder {points [p [c]], points [p [d]], 0.01*0.8 dorot ()}
                                                        material {T4}
                                                }
                                        #end 
                                #end        
                                #local d = d+1; 
                        #end
                        #local c = c+1; 
                #end
                #local a = a+1; 
        #end
        #local a = 0; 
        #while (a < npoints-0.5)
                object {
                        sphere {points [a], 0.01*0.8 dorot ()}
                        material {T4}
                }
                #local a = a+1; 
        #end
}

//____________________________________________________________________________________________________

// sphere coordinates generated by circle_place utility by Samuel Benge  circle_place.exe for Windows  http://news.povray.org/povray.binaries.utilities/thread/%3Cweb.4c7453bd99210acbf151112e0@news.povray.org%3E/

#include "cp_pts.inc"   

#declare objects =
array [7] {
        sphere {<0,0.45,0>, 0.45 material {T1}}
        sphere {<0,0.475,0>, 0.475 material {T1}}
        sphere {<0,0.5,0>, 0.5 material {T1}}
        sphere {<0,0.53,0>, 0.53 material {T1}}
        sphere {<0,0.57,0>, 0.57 material {T1}}
        sphere {<0,0.62,0>, 0.62 material {T1}}
        sphere {<0,1.35,0>, 1.35 material {T2}}
}

#declare r1 = seed (0);

union {
        #declare V = 0;
        #while (V < dimension_size (cp_pts, 1))
                #declare v1 = cp_size_2-cp_size_1;
                #declare v2 = 1/v1*(cp_pts [V].z-cp_size_1);
                #declare access = ceil (v2*(dimension_size (objects,1)-1));
                #if (access > dimension_size (objects,1)-1) 
                        #declare access = dimension_size (objects,1)-1; 
                #end
                #if (access < 0) 
                        #declare access = 0; 
                #end
                #if (access = 6)
                        union {
                                object {
                                        Facetted_Sphere (12, 48)
                                        scale 0.88
                                        rotate 360*<rand (r1),rand (r1),rand (r1)>
                                        material {T2}
                                }
                                object {Wireframe_sphere}
                                rotate 360*<rand (r1),rand (r1),rand (r1)>
                                translate y
                                scale <1,1,1>*cp_pts [V].z*1.35
                                translate <cp_pts [V].x,0,cp_pts [V].y>
                        } 
                #else
                        object {
                                objects [access]
                                rotate y*360*rand (r1)
                                scale <1,1,1>*cp_pts [V].z
                                translate <cp_pts [V].x,0,cp_pts [V].y>
                        }
                #end
                #declare V = V+1;
        #end
        translate (x+z)*-0.5
        scale 20
}

plane {y, -0.00001 material {T3}}  

//____________________________________________________________________________________________________
          
// Google Code Archive  knotknot  https://code.google.com/archive/p/spirals/source/default/source?page=4

#declare T6 =
material {
	MetalMat (<9,182,171>/510+<244,225,201>/510*1.2)        // boundary              
	interior {ior 1.5}
} 

#declare T7 =
material {
	MetalMat (<244,225,201>/255*1.2)                        // cylinders
	interior {ior 1.5}
} 

#declare rado = 0.009;
#declare nbSteps = 250;
#declare inc = 2*pi/nbSteps;
#declare ango = 0;
#declare angleDecale = 0.5*pi;
#declare k1 = 2;
#declare k2 = 5;
#declare c = 1;
#declare coef = 0.125;
#declare o1 = 0.5;
#declare o2 = o1/3;
#declare R = 2;
#declare r = 1.5;

#macro fx (theta) 

(R+r*cos (2*o1*theta))*sin (2*o2*theta); 

#end

#macro fy (theta) 

(R+r*cos (2*o1*theta))*cos (2*o2*theta); 

#end

#macro fz (theta) 

r*sin (2*o1*theta); 

#end

#declare nappe =
union {
        #declare indice = 0;
        #while (indice < 3*nbSteps)
                #declare ax = c*fx (ango);
                #declare ay = c*fy (ango);
                #declare az = fz (ango);
                #declare sx = c*fx (ango+inc);
                #declare sy = c*fy (ango+inc);
                #declare sz = fz (ango+inc);
                #declare mycoef0 = 0;  
                #declare opx = c*fx (ango+mycoef0*pi+angleDecale);
                #declare opy = c*fy (ango+mycoef0*pi+angleDecale);
                #declare opz = fz (ango+mycoef0*pi+angleDecale);
                #declare mycoef = 0.5*cos (2*pi*indice/nbSteps); 
                #declare predpx = c*fx (ango+pi-mycoef*angleDecale);
                #declare predpy = c*fy (ango+pi-mycoef*angleDecale);
                #declare predpz = fz (ango+pi-mycoef*angleDecale);
                #if ((VDist (<ax,az,ay>, <opx,opz,opy>) != 0) & (VDist (<ax,az,ay>, <sx,sz,sy>) !=0 ) & (VDist (<ax,az,ay>, <predpx,predpz,predpy>) != 0))
                        cylinder {<ax,az,ay>, <predpx,predpz,predpy>, rado material {T7}}
                        cylinder {<ax,az,ay>, <sx,sz,sy>, rado*2 material {T6}}
                        sphere {<ax,az,ay>, 1.01*rado*2 material {T7}}
                #end
                #declare ango = ango+inc;
                #declare indice = indice+1;
        #end
}

object {nappe scale 0.15 rotate z*220 rotate x*-70 rotate y*180 rotate x*-34 translate <3.11304-0.225,-0.00001+0.45,1.2014>}
