/*
   ----------------              curiosity.pov                  ------------------------
   ----------------             14.February 2016                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.7;

#declare RAD = 64;  // radiosity quality settings 0 = out; 2 = acceptable; 16 = ok; final = 64
                
global_settings {
        #declare a_g = 2.6;
        assumed_gamma a_g
        max_trace_level 5
        noise_generator 2 
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 30*RAD                
                        nearest_count min (20, RAD)      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        media on                          
                }
        #end
}
         
#include "stdinc.inc"

#declare camloc = <0,-14,3>;
#declare lookat = <0,-14.15,-1>;
#declare camang = 52*image_width/image_height;

camera {
        ultra_wide_angle
        location camloc 
        right -x*image_width/image_height 
        up y 
        look_at lookat
        angle camang
}

sky_sphere {
        pigment {
                average
                pigment_map {
                        [1      function {max (min (y, 1), 0)} 
                                color_map {
                                        [0      rgb 2.35]
                                        [0.96   rgb 4.5]
                                        [1      rgb 13.5]
                                }
                        ]
                        [1      function {max (min (y, 1), 0)}
                                turbulence 0.2
                                color_map {
                                        [0      rgbt 1]
                                        [0.5    rgbt <0.385,0.77,1.1,1>]
                                }
                                rotate z*-45
                        ]
                }
        }
}

//_________________________________________________________________________________

// "ground"

#declare resx = 200;
#declare resz = 200;
 
#declare D = 0.00001;

#declare areal = 
intersection {
        height_field {
                function resx, resz {
                        pigment {
                                average
                                pigment_map {
                                        [1      bozo 
                                                scale 0.025
                                                color_map {
                                                        [0      rgb 0]
                                                        [1      rgb 1.6]
                                                }
                                        ]
                                        [1      function {sin (radians (x*300))+sin (radians (z*300))}
                                                color_map {
                                                        [0      rgb 0]
                                                        [1      rgb 0.4]
                                                }
                                        ]
                                }
                        }
                }
        }
        box {<D,-0.2,D>, <1-D,1-D,1-D>}
        translate <-0.5,-0.8,-0.9> 
        scale <4000,120,4000>
}

// material based on - Bill Hails  Textures.inc for Tea pic  http://news.povray.org/povray.binaries.scene-files/attachment/%3C4456112b%40news.povray.org%3E/us-ascii?ttop=393045&toff=300

#local C_Porcelain = rgb 1;

#local P_Porcelain = pigment {color C_Porcelain}

#local N_Porcelain =
normal {
	average
	normal_map {
		[1      bozo 0.633 scale 0.5]
		[1      bozo 0.633]
		[1      bozo 0.633 scale 2]
		[1      bumps 0.15
			warp {turbulence 1}
			scale 0.2
		]
		[1      bumps 0.1
			warp {turbulence 0.5}
			scale 0.001
		]
	}
} 

#local F_Porcelain =
finish {
	ambient 0
	diffuse 0.62
	brilliance 0.8
	reflection {0.1, 0.3 fresnel on}
	conserve_energy
}

#local T_Porcelain =
texture {
	pigment {P_Porcelain}
	normal {N_Porcelain}
	finish {F_Porcelain}
}

#local I_Porcelain = interior {ior 1.53}

#declare T1 =
material {
	texture {T_Porcelain}
	interior {I_Porcelain}
	scale 0.5
}

object {
        areal
        material {T1}
}  

//__________________________________________________________

#declare p_micro2 =
pigment {
        crackle 
        turbulence 1
        color_map {
                [0      White*0.9] 
                [0.01   White*0.9] 
                [0.02   White]
                [1      White]
        }
        scale 5
}


#declare p_micro1 =
pigment {
        cells 
        turbulence 0.5
        color_map {
                [0      White*0.9] 
                [1      White]
        }
        scale 0.01
}

#declare p_brushed_new =
pigment {
        average 
        turbulence 0
        pigment_map {
                [0      p_micro1]
                [0.1    p_micro1 rotate 45*x]
                [0.2    p_micro1 rotate -45*x]
                [0.3    p_micro2]
                [0.4    p_micro1 rotate 45*y]
                [0.5    p_micro1 rotate -45*y]
                [0.6    p_micro1 rotate 90*z]
                [0.7    p_micro2 rotate 45]
                [0.8    p_micro1 rotate 45*z]
                [0.9    p_micro1 rotate 90*y]
                [1      p_micro1 rotate -45*z]
        }
        scale 0.1
}

#declare n_brushed_new = normal {pigment_pattern {p_brushed_new} 0.1 accuracy 0.005}

#declare scal = <4000,100,4000>;
#declare loc0 = <-0.5*scal.x+0.0001,-0.8*scal.y,-0.9*scal.z+0.0001>;

#declare spherelocs = array [resx+1][resz+1];

#for (nx, 0, resx, 1)
        #for (nz, 0, resz, 1)
                #declare spherelocs [nx][nz] = <-1000,-1000,-1000>;
        #end
#end

#declare spheres =
union {
        #declare nx = 0;
        #while (nx < resx+1)
                #declare nz = 0;
                #while (nz < resz+1)
                        #declare loc = <nx*scal.x/(resx-1)+loc0.x,1000,nz*scal.z/(resz-1)+loc0.z>;
                        #declare Norm = <0,0,0>;
        		#declare sphereloc = trace (areal, loc, -y, Norm);
        		#if (vlength (Norm) != 0)
                                sphere {sphereloc, scal.x/resx*0.04}
                                #declare spherelocs [nx][nz] = sphereloc;
                        #end
                        #declare nz = nz+1;
                #end
                #declare nx = nx+1;
        #end
}

#declare cyls =
union {
        #declare nx = 1;
        #while (nx < resx-2)
                #declare nz = 1;
                #while (nz < resz-2)
                        cylinder {spherelocs [nx+1][nz+1], spherelocs [nx][nz+1], scal.x/resx*0.01}
                        cylinder {spherelocs [nx+1][nz+1], spherelocs [nx+1][nz], scal.x/resx*0.01}
                        cylinder {spherelocs [nx+1][nz-1], spherelocs [nx][nz], scal.x/resx*0.01}    
                        #declare nz = nz+1;
                #end
                #declare nx = nx+1;
        #end
}

union {
        object {spheres}
        object {cyls}
        material {
                texture { 
                        pigment {color rgb 0}
                        finish {ambient 0 diffuse 0 reflection 0.7} 
                        normal {n_brushed_new 0.1 scale 0.25}
                }
                interior {ior 1.5}
        }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////  

#include "vehicle.inc"
#include "particle.inc"
 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////  

// "tree" on the right

// Tsutomu Higo  lptglftg

#macro Dla15 (Nmax, Rds) 

#declare R1 = seed (8);
#declare Cp = array [Nmax][5]
#declare Cp [0][0] = 0;                
#declare Cp [0][1] = 0;                
#declare Cp [0][2] = -100/(0+2);       
#declare Cp [0][3] = 0;                
#declare Cp [0][4] = 2*pi*rand (R1);   

sphere {
        <Cp [0][0],Cp [0][2],Cp [0][1]>, Rds
        MetalMat (hsl_ (240/360,0.4,1))
        no_shadow
}

#declare Np = 1;
 
#while (Np < Nmax)
        #declare Cp [Np][4] = 2*pi*rand (R1);
        #if (Np = 1) 
                #declare Cp [Np][3] = 2;
                #declare Cp [Np][0] = Cp [Np][3]*cos (Cp [Np][4]);
                #declare Cp [Np][1] = Cp [Np][3]*sin (Cp [Np][4]);
                #declare Cp [Np][2] = -100/(Np/100+2);
                #declare Nsclose = 0;
        #else
                #declare Ns = Np-1; 
                #while (Ns > 0)
                        #declare Det = 0;
                        #declare Adis = abs (Cp [Np][4]-Cp [Ns][4]);
                        #if (Adis > pi) 
                                #declare Adis = 2*pi-Adis; 
                        #end
                        #if (Cp [Ns][3]*sin (Adis/2) < 0.6)
                                #declare Cp [Np][3] = Cp [Ns][3]*cos (Adis)+2*sin (acos (Cp [Ns][3]*sin (Adis)/2));
                                #declare Cp [Np][0] = Cp [Np][3]*cos (Cp[Np][4]);
                                #declare Cp [Np][1] = Cp [Np][3]*sin (Cp[Np][4]);
                                #declare Cp [Np][2] = -100/(Np/100+2);
                                #declare Nsclose = Ns;
                                #declare Det = 1;
                                #declare Ns = 1;
                        #end
                        #declare Ns = Ns-1; 
                #end
                #if (Det = 0)
                        #declare Cp [Np][3] = 2;
                        #declare Cp [Np][0] = Cp [Np][3]*cos (Cp [Np][4]);
                        #declare Cp [Np][1] = Cp [Np][3]*sin (Cp [Np][4]);
                        #declare Cp [Np][2] = -100/(Np/100+2);
                        #declare Nsclose = 0;
                #end
        #end
        #if (Np > 10)
        union {
                sphere {<Cp [Np][0]*0.5,Cp [Np][2],Cp [Np][1]*0.5>, Rds*(1-Np/Nmax+0.1)}
                cylinder {<Cp [Np][0]*0.5,Cp [Np][2],Cp [Np][1]*0.5>, <Cp [Nsclose][0]*0.5,Cp [Nsclose][2],Cp [Nsclose][1]*0.5>, Rds*(1-Np/Nmax+0.1)}
                MetalMat (hsl_ (240/360+Np/Nmax*(1-240/360),0.4,1))
        }
        #end
        #declare Np = Np+1; 
#end 
  
#end 

#macro Dla15_ (Nmax, Rds) 

#declare R1 = seed (8+12345);
#declare Cp = array [Nmax][5]
#declare Cp [0][0] = 0;             
#declare Cp [0][1] = 0;             
#declare Cp [0][2] = -100/(0+2);    
#declare Cp [0][3] = 0;             
#declare Cp [0][4] = 2*pi*rand (R1);

sphere {
        <Cp [0][0],Cp [0][2],Cp [0][1]>, Rds
        MetalMat (hsl_ (240/360,0.4,1))
        no_shadow
}

#declare Np = 1;
 
#while (Np < Nmax)
        #declare Cp [Np][4] = 2*pi*rand (R1);
        #if (Np = 1) 
                #declare Cp [Np][3] = 2;
                #declare Cp [Np][0] = Cp [Np][3]*cos (Cp [Np][4]);
                #declare Cp [Np][1] = Cp [Np][3]*sin (Cp [Np][4]);
                #declare Cp [Np][2] = -100/(Np/100+2);
                #declare Nsclose = 0;
        #else   
                #declare Ns = Np-1; 
                #while (Ns > 0)
                        #declare Det = 0;
                        #declare Adis = abs (Cp [Np][4]-Cp [Ns][4]);
                        #if (Adis > pi) 
                                #declare Adis = 2*pi-Adis; 
                        #end
                        #if (Cp [Ns][3]*sin (Adis/2) < 0.6)
                                #declare Cp [Np][3] = Cp [Ns][3]*cos (Adis)+2*sin (acos (Cp [Ns][3]*sin (Adis)/2));
                                #declare Cp [Np][0] = Cp [Np][3]*cos (Cp[Np][4]);
                                #declare Cp [Np][1] = Cp [Np][3]*sin (Cp[Np][4]);
                                #declare Cp [Np][2] = -100/(Np/100+2);
                                #declare Nsclose = Ns;
                                #declare Det = 1;
                                #declare Ns = 1;
                        #end
                        #declare Ns = Ns-1; 
                #end
                #if (Det = 0)
                        #declare Cp [Np][3] = 2;
                        #declare Cp [Np][0] = Cp [Np][3]*cos (Cp [Np][4]);
                        #declare Cp [Np][1] = Cp [Np][3]*sin (Cp [Np][4]);
                        #declare Cp [Np][2] = -100/(Np/100+2);
                        #declare Nsclose = 0;
                #end
        #end
        #if (Np > 60)
                union {
                        sphere {<Cp [Np][0]*0.25,Cp [Np][2],Cp [Np][1]*0.25>, Rds*(1-Np/Nmax+0.1)}
                        cylinder {<Cp [Np][0]*0.25,Cp [Np][2],Cp [Np][1]*0.25>, <Cp [Nsclose][0]*0.25,Cp [Nsclose][2],Cp [Nsclose][1]*0.25>, Rds*(1-Np/Nmax+0.1)}
                        MetalMat (hsl_ (240/360+Np/Nmax*(1-240/360),0.4,1))
                }
        #end
        #declare Np = Np+1; 
#end 
  
#end

#declare halftree1 = union {Dla15 (14000, 0.2)}
#declare halftree2 = union {Dla15_ (1000, 0.2)}

union {
        object {halftree1 translate y*50}
        object {halftree2 scale <1,-1,1> translate y*-40}
        scale 4
        translate <400,40,-570>*0.8
}
  
// Tsutomu Higo  lpcrstr7 

union {  
        #declare Imax = 24;
        #declare I = Imax;
        #while (I > -Imax)
                disc {
                        <0,50/Imax*(Imax-I),0>, y, 5*(1+cos (pi/Imax*I)), 3*(1+cos (pi/Imax*I)) 
                        material {
                                texture {
                                        pigment {color rgb <1-max (0, I/24),0.2,max (0, I/24)>}
                                        finish {
                                                ambient 0
                                                diffuse 1
                                                reflection 0.7
                                                brilliance 1
                                        }
                                }
                                interior {ior 1.35}
                        }
                }
                #declare I = I-1; 
        #end
        scale <2,1.35,2>*1.4*0.8
        translate <400,130,-570>*0.8
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////  

// structure on the left

// Tsutomu Higo  lpclstr6

#declare R1 = seed (22);

union {
        #declare Jmax = 15;
        #declare J = Jmax;
        #while (J > 0)
                #declare Imax = 100;
                #declare I = Imax;
                #declare Pichi = <500*rand (R1),0,500*rand (R1)>;
                #while (I > -20)
                        disc {
                                <0,0,0>, y, 30*pow (0.97,I), 20*pow (0.97,I)
                                translate Pichi 
                                translate y*2*I
                                texture {
                                        pigment {color rgbt <1-max (0, I/100),0,max (0, I/100)>}
                                        finish {
                                                diffuse 1
                                                reflection 0.75
                                        }
                                        normal {
                                                dents -0.25
                                                scale 0.002
                                        }
                                }
                        }
                        #declare I = I-1; 
                #end
                #declare J = J-1; 
        #end 
        scale 2
        translate <-520,-18.926,-880>*2
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////  

// "city"

// texture - Tekno Franannsa  Crackle city - new source  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3c96f0bc@news.povray.org%3E/crackscape5.pov.txt

#declare tBuildings =
texture {
	#local fWindowBar = 0.025;				// framewidth
	function {
		min (min (x-floor (x), 1-x+floor (x)),
		min (min (y-floor (y), 1-y+floor (y)),
		     min (z-floor (z), 1-z+floor (z))))*2
	}
	texture_map {
		[fWindowBar
			pigment {color rgb 0.3}
			finish {specular 0.3 roughness 0.1}
		]
		[fWindowBar
			#local fLightsOn = 0.2;                 // 0 = no lights on / 1 = all lights on
			cells
			texture_map {
				[fLightsOn
					pigment {color rgb <1,0.975,0.95>*0.9}
					finish {
						reflection {0.5, 1}
						conserve_energy
						diffuse 0
						emission 0.5
						specular 1
						roughness 0.004
					}
					normal {
						spotted 0.1
						scale 3
						warp {repeat x offset y}
						warp {repeat y offset z}
						warp {repeat z offset x}
					}
				]
				[fLightsOn
					pigment {color rgb <0.8,0.85,1>}
					finish {
						reflection {0.9 metallic}
						diffuse 0
					}
					normal {
						spotted 0.1
						scale 3
						warp {repeat x offset y}
						warp {repeat y offset z}
						warp {repeat z offset x}
					}
				]
			}
		]
	}
}

#declare M_as =
material {
	texture {tBuildings}
	interior {ior 1.5}
	scale 3
}

// structure - Hans-Jakob Schwer  alienstation   http://www.codeworx.org/povray/alienstation.pov
                                
#macro rek2 (stufe, x_, y_, z_, x2_, y2_, z2_,ori) 

object {     
        #if (stufe > 2)
                difference {
                        box {<x_,y_,z_>, <x2_,y2_,z2_>} 
                        sphere {<0,0,0>, 4.5}
                }  
        #else
                difference {
                        box {<x_,y_,z_>, <x2_,y2_,z2_>}  
                        sphere  {<0,0,0>, 4.5}
                }                
        #end             
} 

#if (stufe > 0)   
        #local dx = x2_-x_;
        #local dy = y2_-y_;
        #local dz = z2_-z_;  
        #local dxv = dx*0.1;
        #local dyv = dy*0.1;
        #local dzv = dz*0.1;
        #if (ori = 0) 
                rek2 (stufe-1, x_+dxv, y_-dy, z_+dzv, x2_-dxv, y2_-dy, z2_-dzv, 0)                
                #if (mod (stufe, 7) = 0)
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 2)    
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 3)
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 4)    
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 5)        
                #end     
        #end
        #if(ori = 1) 
                rek2 (stufe-1, x_+dxv, y_+dy, z_+dzv, x2_-dxv, y2_+dy, z2_-dzv, 1)             
                #if (mod (stufe, 7) = 0)
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 2)    
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 3)
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 4)    
                        rek2 (stufe-3, x_, y_, z_, x2_, y2_, z2_, 5)        
                #end      
        #end 
        #if (ori = 2) 
                rek2 (stufe-1, x_+dx, y_+dyv, z_+dzv, x2_+dx, y2_-dyv, z2_-dzv, 2)                
                #if (mod (stufe, 5) = 0)
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 0)    
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 1)        
                #end      
        #end 
        #if (ori = 3) 
                rek2 (stufe-1, x_-dx, y_+dyv, z_+dzv, x2_-dx, y2_-dyv, z2_-dzv, 3)
                #if (mod (stufe, 5) = 0)
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 0)    
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 1)        
                #end
        #end
        #if (ori = 4) 
                rek2 (stufe-1, x_+dxv, y_+dyv, z_+dz, x2_-dxv, y2_-dyv, z2_+dz, 4)               
                #if (mod (stufe, 4) = 0)
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 0)    
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 1)        
                #end     
        #end 
        #if (ori = 5) 
                rek2 (stufe-1, x_+dxv, y_+dyv, z_-dz, x2_-dxv, y2_-dyv, z2_-dz, 5)
                #if (mod (stufe, 4) = 0)
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 0)    
                        rek2 (stufe, x_, y_, z_, x2_, y2_, z2_, 1)        
                #end     
        #end
#end 
   
#end
         
union {
        union {
                #local tt = 27; 
                #local h = 1;
                #local j = 0.4;
                #local k = 1;     
                rek2 (tt, h, j, k, -h, -j, -k, 0)    
                rek2 (tt, h, j, k, -h, -j, -k, 1)           
                rek2 (tt, h, j, k, -h, -j, -k, 2) 
                rek2 (tt, h, j, k, -h, -j, -k, 3) 
                rek2 (tt, h, j, k, -h, -j, -k, 4) 
                rek2 (tt, h, j, k, -h, -j, -k, 5) 
        } 
        union {
                #local tt = 27; 
                #local h = 1;
                #local j = 0.4;
                #local k = 1;     
                rek2 (tt, h, j, k, -h, -j, -k, 0)    
                rek2 (tt, h, j, k, -h, -j, -k, 1)           
                rek2 (tt, h, j, k, -h, -j, -k, 2) 
                rek2 (tt, h, j, k, -h, -j, -k, 3) 
                rek2 (tt, h, j, k, -h, -j, -k, 4) 
                rek2 (tt, h, j, k, -h, -j, -k, 5)
                scale 0.24
                rotate <0,90,0>
                translate <0,3.6,-2> 
        }
        scale 40
        rotate <0,-37,0>
        translate <400,0,-1800>
        material {M_as} 
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////  

// "stones"

#declare sto_r = 10;
#declare cone_r1 = 8;
#declare cone_r2 = 4;
#declare theta = 90/pi*acos (1/(2*sin (0.2*pi)));

#declare sto1 = 
blob {
	sphere {<0,0,0>, sto_r, 4}
	sphere {<0,cone_r1,0>, cone_r2, 1}
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*theta
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*theta
		rotate y*72
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*theta
		rotate y*144
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*theta
		rotate y*216
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*theta
		rotate y*288
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
		rotate z*theta
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
		rotate z*theta
		rotate y*72
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
		rotate z*theta
		rotate y*144
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
		rotate z*theta
		rotate y*216
        }
	sphere {
                <0,cone_r1,0>, cone_r2, 1
		rotate z*180
		rotate z*theta
		rotate y*288
        }
}

#declare sto2 = 
blob {
	sphere {<0,0,0>, (sto_r+cone_r2)*0.75, 4}
	sphere {<0,cone_r1,0>, cone_r2, -1}
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*theta
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*theta
		rotate y*72
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*theta
		rotate y*144
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*theta
		rotate y*216
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*theta
		rotate y*288
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
		rotate z*theta
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
		rotate z*theta
		rotate y*72
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
		rotate z*theta
		rotate y*144
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
		rotate z*theta
		rotate y*216
        }
	sphere {
                <0,cone_r1,0>, cone_r2, -1
		rotate z*180
		rotate z*theta
		rotate y*288
        }
}

// original MetalMat macro by James Holsenback  UberPOV  http://news.povray.org/povray.binaries.images/message/%3C5294ab48%241%40news.povray.org%3E/#%3C5294ab48%241%40news.povray.org%3E

#macro MetalMat_N (Color)

texture {
	aoi
	texture_map {
		[0      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
	                normal {n_brushed_new 0.1 scale 0.25}
                ]
                [0.4    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
                [0.6    pigment {color srgb 0}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {0, 1}
	                }
                ]
		[1      pigment {color srgb Color*1.5}
	                finish {
	                	brilliance 4
	                	diffuse 0
	                	metallic
	                	specular 0.8
	                	roughness 0.025
	                	reflection {srgb Color}
	                }
	                normal {n_brushed_new 0.1 scale 0.25}
                ]
	}        
}

#end
 
#declare radi = 3/sto_r;
#declare Q = seed (3); 
#declare R = seed (0);
#declare S = seed (20);
#declare n = 0;
#while (n < 10000)
        #declare SkinCol = <0.7+rand (Q)*0.3,0.7,0.7+rand (Q)*0.3>*1.2;
        #declare start_place = <rand (Q)*4000-1999.96,1000,rand (Q)*4000-3599.96>;
        #declare start_size = (rand (Q)+1)/2.5*0.5;
        #declare norm = <0,0,0>;
        #declare end_place = trace (areal, start_place, -y, norm);
        #if (vlength (norm) != 0)
                object {
                        #if (rand (S) > 0.5)
                                sto1
                        #else
                                sto2
                        #end
                        #if (rand (R) > 0.5)
                                material {      // material based on  Rene Bui  Human skin : sss+aoi  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.421073fe53a72495e23538ee0%40news.povray.org%3E/
                                        texture {
                                                pigment {color rgb SkinCol filter 0.75}
                                                finish {ambient 0 diffuse 0.6}
                                        }
                                        texture {
                                                pigment {
                                                        aoi 
                                                        color_map {
                                                                [0      rgb SkinCol*0.7 filter 1]
                                                                [0.167  rgb SkinCol*1.2 transmit 0.66]
                                                                [0.333  rgb SkinCol+5 filter 0.1]
                                                                [0.5    rgb 10]
                                                                [0.667  rgb SkinCol+5 filter 0.1]
                                                                [0.833  rgb SkinCol*1.2 transmit 0.66]
                                                                [1      rgb SkinCol*0.7 filter 1]
                                                        }
                                                }
                                                finish {
                                                        emission SkinCol*0.01
                                                        diffuse 0.6 
                                                        specular 0.1 
                                                        roughness 0.03 
                                                }
                                        }
                                        texture {
                                                pigment {color rgb SkinCol transmit 0.15}
                                                finish {
                                                        emission SkinCol*0.01
                                                        diffuse 0.6 
                                                        specular 0.1 
                                                        roughness 0.03 
                                                }
                                                normal {
                                                        dents -0.25
                                                        scale 0.002
                                                }
                                        }
                                        interior {
                                                ior 1.35
                                                media {
                                                        scattering {1, rgb 8 extinction 0.2}
                                                        method 3
                                                        aa_level 4
                                                        intervals 1
                                                        samples 10
                                                }
                                        }
                                }
                        #else
                                material {
	                                MetalMat_N (SkinCol)
	                                interior {ior 1.5}
                                }
                        #end
                        scale start_size
                        rotate <rand (Q)*360,rand (Q)*360,rand (Q)*360>
                        translate end_place+start_size*radi*y*25
                } 
        #end
        #declare n = n+1;
#end

/////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

// "birds"

#local C_Porcelain2 = rgb 2;

#local P_Porcelain2 = pigment {color C_Porcelain2}

#local N_Porcelain2 =
normal {
	average
	normal_map {
		[1      bozo 0.2 scale 0.5]
		[1      bozo 0.2]
		[1      bozo 0.2 scale 2]
	}
}

#local F_Porcelain2 =
finish {
	ambient 0
	diffuse 0.92
	brilliance 0.8
	reflection {0.1, 0.3 fresnel on}
}

#local T_Porcelain2 =
texture {
	pigment {P_Porcelain2}
	normal {N_Porcelain2}
	finish {F_Porcelain2}
}

#local I_Porcelain2 = interior {ior 1.53}

#declare T2_ =
material {
	texture {T_Porcelain2}
	interior {I_Porcelain2}
	scale 0.5
}

#declare T2 =
material {
	texture {pigment {color rgb 1.4} finish {diffuse 1 emission 0.2}}
}

// structure -  http://spirals.googlecode.com/svn/pearls/scene/AfficheMarseille/paraboleSkyWaterJustABird.pov

#declare nbsteps = 120;  
#declare oldcoord = array [500]; 
#declare newcoord = array [500]; 
#declare oldcoord [0] = <-1214,0,0>;
#declare posmin = 100; 

#macro parabol (zmin, zmax, nbPts, a, b, c, rsphere, rcyl, rx, ry, tx, id)

#local zcur = zmin; 
#local step = (zmax-zmin)/nbPts; 
#local index = 0; 
union {
        #while (zcur <= zmax)
                #local pos = <0,a*zcur*zcur+b*zcur+c,zcur>;
                #local transfo = transform {rotate rx*x rotate ry*y translate tx*x}
                #local posmodif = vtransform (pos, transform {transfo}); 
                #if (posmodif.y < posmin) 
                        #declare posmin = posmodif.y; 
                #end
                sphere {pos, rsphere material {T2} transform {transfo}} 
                #if (id != 0)
                        #declare oldcoord [index] = newcoord [index];
                #end
                #declare newcoord [index] = vtransform (<0,a*zcur*zcur+b*zcur+c,zcur>, transform {transfo});
                #if (index != 0)
                        cylinder {
                                pos, <0,a*(zcur-step)*(zcur-step)+b*(zcur-step)+c,zcur-step>, rcyl
                                material {T2}
                                transform {transfo}
                        } 
                #end 
                #local index = index+1;
                #local zcur = zcur+step; 
        #end 
        #if (id != 0)
                #local index = 0; 
                #while (index <= nbPts)
                        cylinder {
                                oldcoord [index], newcoord [index], rcyl 
                                material {T2}
                        }
                        #local index = index+1; 
                #end 
        #end 
} 

#end 

#macro bird ()

#local xmin = -1; 
#local xmax = 1; 
#local xcur =  xmin;
#local index = 0; 
#local step = (xmax-xmin)/nbsteps; 
#local rs = 0.00615;
 
union {
        #while (xcur <= xmax)
                object {parabol (-0.5, 0.5, 25, 2, 0, 0, rs, rs, 360*index/nbsteps, 30*index/nbsteps,xcur, index)}
                #declare xcur = xcur+step;
                #declare index = index+1;  
        #end
} 

#end 

#declare bub = object {bird ()}

#declare bu = seed (98765);
#declare nb = 1;

#declare bubb =
union {
        object {bub scale 0.5} 
        #declare tra = <2.5*rand (bu),0,-6*rand (bu)>;
        object {bub scale 0.5 translate tra}
        object {bub scale 0.5 translate <0,0,-9*rand (bu)>*0.5+tra*0.5+x*5}                                      
        object {bub scale 0.5 translate <2.5*rand (bu),0,-6*rand (bu)> rotate ( 60+rand (bu)*10)*y}
        object {bub scale 0.5 translate <2.5*rand (bu),0,-6*rand (bu)> rotate (120+rand (bu)*10)*y}
        object {bub scale 0.5 translate <2.5*rand (bu),0,-6*rand (bu)> rotate (180+rand (bu)*10)*y}
        object {bub scale 0.5 translate <2.5*rand (bu),0,-6*rand (bu)> rotate (240+rand (bu)*10)*y}
        object {bub scale 0.5 translate <2.5*rand (bu),0,-6*rand (bu)>+x*3 rotate (300+rand (bu)*10)*y}
}

object {bubb scale 3.5 rotate y*50 translate <0,10,-70>}