/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * [VERSION 1.0]                                                                                                   * */
/* *                                                                                                                 * */
/* * INSTRUCTIONS FOR USE:                                                                                           * */
/* *                                                                                                                 * */
/* * This file contains some example styles to demonstrate the many possible ways that characters with different     * */
/* * border widths can be combined in interesting ways. You will no doubt want to create your own unique styles.     * */
/* *                                                                                                                 * */
/* * The .pov file "Sample_Styles" demonstrates each of the styles defined in this file.                             * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef (TextColor_Outer)

   #declare TextColor_Outer = texture {pigment {color <1, 1, 1>}}

#end //#ifndef

#ifndef (TextColor_Inner)

   #declare TextColor_Inner = texture {pigment {color <1, 0, 0>}}

#end //#ifndef

#ifndef (Color1)

   #declare Color1 = color <.4, 0, 0>; //Bottom/Outside
   #declare Color2 = color <1, 0, 0>; //Top/Inside

#end //#ifndef

#ifndef (TextColor_Back)

   #declare TextColor_Back = texture {pigment {color <1, 1, 1>}}

#end //#ifndef

#macro Stylize (IndexValue, Style, TextDepth, P1, P2, P3, P4)

   #switch (Style)
      #case (0) //Plain
         #local BorderWidth = P1;
         MakeCharacter (IndexValue, BorderWidth)
         #declare Character = object {
            intersection {
               object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (1) //Raised center
         #local BorderWidth = P1;
         #local BorderHeight = P2;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {
            intersection {
               object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
         } //object
         MakeCharacter (IndexValue, BorderWidth)
         #local Character_Inner = object {
            intersection {
               object {Character scale <1, 1, TextDepth>}
               plane {z, 1}
            } //intersection
            texture {TextColor_Inner}
         } //object
         #declare Character = object {
            union {
               object {Character_Outer}
               object {Character_Inner translate -BorderHeight * z}
            } //union
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (2) //Lowered center
         #local BorderWidth = P1;
         #local BorderDepth = P2;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {
            intersection {
               object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
         } //object
         MakeCharacter (IndexValue, BorderWidth)
         #local Character_Inner = object {
            intersection {
               object {Character scale <1, 1, 1.1>}
               plane {z, 1}
            } //intersection
            texture {TextColor_Inner}
         } //object
         #declare Character = object {
            difference {
               object {Character_Outer}
               object {Character_Inner translate (-1 + BorderDepth) * z}
            } //difference
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (3) //Striped
         #local BorderWidth = P1;
         #local StripeWidth = P2;
         #local StripeHeight = P3;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
         MakeCharacter (IndexValue, BorderWidth + StripeWidth)
         #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
         MakeCharacter (IndexValue, BorderWidth)
         #local Character_Inner = object {
            difference {
               object {Character}
               object {Character_Inner2 translate -.1 * z}
            } //difference
            texture {TextColor_Inner}
         } //object
         #declare Character = object {
            intersection {
               union {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  object {Character_Inner translate -StripeHeight * z}
               } //union
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (4) //Color gradient
         #local BorderWidth = P1;
         #local StripeWidth = P2;
         #local NSteps = P3;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
         #for (I, 0, NSteps)
            #local ColorRatio = I / (NSteps - 1);
            #local CurColor = Color2 * ColorRatio + Color1 * (1 - ColorRatio);
            MakeCharacter (IndexValue, BorderWidth + I * StripeWidth / (NSteps - 1))
            #if (I < NSteps)
               #local CurTexture = texture {pigment {color CurColor}}
            #else
               #local CurTexture = texture {TextColor_Outer}
            #end //#if
            #local Character_Inner = object {Character scale <1, 1, 1.3> texture {CurTexture}}
            #local Character_Outer = object {
               union {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  object {Character_Inner}
               } //union
            } //object
         #end //#for
         #declare Character = object {
            intersection {
               object {Character_Outer}
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (5) //Hollow stripe
         #local BorderWidth = P1;
         #local StripeWidth = P2;
         #local StripeDepth = P3;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {Character scale <1, 1, 1.1>}
         MakeCharacter (IndexValue, BorderWidth + StripeWidth)
         #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
         MakeCharacter (IndexValue, BorderWidth)
         #local Character_Inner = object {
            difference {
               object {Character}
               object {Character_Inner2 translate -.1 * z}
            } //difference
         } //object
         #declare Character = object {
            intersection {
               difference {
                  object {Character_Outer}
                  object {Character_Inner translate (-1 + StripeDepth) * z}
                  texture {TextColor_Outer}
               } //difference
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (6) //Hollow inside
         #local BorderWidth = P1;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {
            intersection {
               object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               plane {z, TextDepth texture {TextColor_Back}}
            } //intersection
         } //object
         MakeCharacter (IndexValue, BorderWidth)
         #local Character_Inner = object {
            Character
            scale <1, 1, 1.2>
            texture {TextColor_Outer}
         } //object
         #declare Character = object {
            difference {
               object {Character_Outer}
               object {Character_Inner translate -.1 * z}
            } //difference
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (7) //Angled bevel
         #local BorderHeight = P1;
         #local NSteps = P2;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {
            intersection {
               object {
                  Character
                  scale <1, 1, 1.2>
                  translate -.1 * z
                  texture {TextColor_Outer}
               } //object
               plane {z, TextDepth texture {TextColor_Back}}
               plane {z, 0 inverse texture {TextColor_Inner}}
            } //intersection
         } //object
         #local Character_Inner = object {
            intersection {
               union {
                  #local Increment = BorderHeight / NSteps;
                  #for (I, 1, NSteps)
                     MakeCharacter (IndexValue, Increment * I)
                     #if (I = NSteps)
                        #declare Character = object {
                           intersection {
                              object {Character translate -.1 * z}
                              plane {z, 0 inverse texture {TextColor_Outer}}
                           } //intersection
                        } //object
                     #end //#if
                     object {Character translate (-Increment * I) * z}
                  #end //#for
               } //union
               plane {z, 0}
            } //intersection
            texture {TextColor_Inner}
         } //object
         #declare Character = object {
            union {
               object {Character_Outer}
               object {Character_Inner}
            } //union
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (8) //Rounded bevel
         #local BorderHeight = P1;
         #local NSteps = P2;
         #local R = BorderHeight;
         MakeCharacter (IndexValue, 0)
         #local Character_Outer = object {
            intersection {
               object {
                  Character
                  scale <1, 1, 1.2>
                  translate -.1 * z
                  texture {TextColor_Outer}
               } //object
               plane {z, TextDepth texture {TextColor_Back}}
               plane {z, 0 inverse texture {TextColor_Inner}}
            } //intersection
         } //object
         #local Character_Inner = object {
            intersection {
               union {
                  #local Increment = 90 / NSteps;
                  #for (I, 1, NSteps)
                     #local CurAngle = I * Increment;
                     #local CurBorderWidth = R * (1 + cos (radians (CurAngle + 180)));
                     #local CurBorderHeight = R * sin (radians (CurAngle));
                     MakeCharacter (IndexValue, CurBorderWidth)
                     #if (I = NSteps)
                        #declare Character = object {
                           intersection {
                              object {Character translate -.1 * z}
                              plane {z, 0 inverse texture {TextColor_Outer}}
                           } //intersection
                        } //object
                     #end //#if
                     object {Character translate -CurBorderHeight * z}
                  #end //#for
               } //union
               plane {z, 0}
            } //intersection
            texture {TextColor_Inner}
         } //object
         #declare Character = object {
            union {
               object {Character_Outer}
               object {Character_Inner}
            } //union
            translate -TextDepth * z //Back is at z = 0
         } //object
         #break
      #case (9) //Solid hourglass (convex)
         #local EffectWidth = P1;
         #local NSteps = P2;
         #local TempCharacter = object {
            union {
               #local SegmentLength = TextDepth / NSteps;
               #local DeltaTheta = 180 / (NSteps - 1);
               #local CurZ = TextDepth;
               #local Theta = 0;
               #for (I, 1, NSteps)
                  #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                  MakeCharacter (IndexValue, CurBorder)
                  #local Segment = object {
                     Character
                     translate -1 * z
                     scale <1, 1, SegmentLength>
                  } //object
                  object {Segment translate CurZ * z}
                  #local CurZ = CurZ - SegmentLength;
                  #local Theta = Theta + DeltaTheta;
               #end //#for
            } //union
            texture {TextColor_Outer}
            translate -TextDepth * z //Back is at z = 0
         } //object
         #declare Character = object {TempCharacter}
         #break
      #case (10) //Hollow hourglass (convex)
         #local EffectWidth = P1;
         #local WallThickness = P2;
         #local NSteps = P3;
         #local TempCharacter = object {
            union {
               #local SegmentLength = TextDepth / NSteps;
               #local DeltaTheta = 180 / (NSteps - 1);
               #local CurZ = TextDepth;
               #local Theta = 0;
               #for (I, 1, NSteps)
                  #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                  MakeCharacter (IndexValue, CurBorder)
                  #local Character_Outer = object {Character}
                  MakeCharacter (IndexValue, CurBorder + WallThickness)
                  #local Character_Inner = object {Character scale <1, 1, 1.2>}
                  #local Segment = object {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                     translate -1 * z
                     scale <1, 1, SegmentLength>
                  } //object
                  object {Segment translate CurZ * z}
                  #local CurZ = CurZ - SegmentLength;
                  #local Theta = Theta + DeltaTheta;
               #end //#for
            } //union
            texture {TextColor_Outer}
            translate -TextDepth * z //Back is at z = 0
         } //object
         #declare Character = object {TempCharacter}
         #break
      #case (11) //Hollow hourglass (concave)
         #local EffectWidth = P1;
         #local WallThickness = P2;
         #local NSteps = P3;
         #local TempCharacter = object {
            union {
               #local SegmentLength = TextDepth / NSteps;
               #local DeltaTheta = 180 / (NSteps - 1);
               #local CurZ = TextDepth;
               #local Theta = 0;
               #for (I, 1, NSteps)
                  #local CurBorder = EffectWidth * sin (radians (Theta));
                  MakeCharacter (IndexValue, CurBorder)
                  #local Character_Outer = object {Character}
                  MakeCharacter (IndexValue, CurBorder + WallThickness)
                  #local Character_Inner = object {Character scale <1, 1, 1.2>}
                  #local Segment = object {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                     translate -1 * z
                     scale <1, 1, SegmentLength>
                  } //object
                  object {Segment translate CurZ * z}
                  #local CurZ = CurZ - SegmentLength;
                  #local Theta = Theta + DeltaTheta;
               #end //#for
            } //union
            texture {TextColor_Outer}
            translate -TextDepth * z //Back is at z = 0
         } //object
         #declare Character = object {TempCharacter}
         #break
      #case (12) //Solid hourglass (concave)
         #local EffectWidth = P1;
         #local NSteps = P2;
         #local TempCharacter = object {
            union {
               #local SegmentLength = TextDepth / NSteps;
               #local DeltaTheta = 90 / (NSteps - 1);
               #local CurZ = TextDepth;
               #local Theta = 0;
               #for (I, 1, NSteps)
                  #local CurBorder = EffectWidth * sin (radians (Theta));
                  MakeCharacter (IndexValue, CurBorder)
                  #local Segment = object {
                     Character
                     translate -1 * z
                     scale <1, 1, SegmentLength>
                  } //object
                  object {Segment translate CurZ * z}
                  #local CurZ = CurZ - SegmentLength;
                  #local Theta = Theta + DeltaTheta;
               #end //#for
            } //union
            texture {TextColor_Outer}
            translate -TextDepth * z //Back is at z = 0
         } //object
         #declare Character = object {TempCharacter}
         #break
      #else
         MakeCharacter (IndexValue, 0)
         #declare Character = object {
            Character
            texture {TextColor_Outer}
            translate -1 * z //Back is at z = 0
         } //object
         #break
   #end //#switch

#end //#macro Stylize
