// PoVRay 3.7 Scene File " ... .pov"
// author:  ...
// date:    ...
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera {perspective angle 75               // front view
                            location  <0.0 , 1.0 ,-3.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}

// sun ----------------------------------------------------------------------
light_source{< 3000,3000,-3000> color rgb 1}
// sky ----------------------------------------------------------------------
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere
// ground -------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment{ checker color rgb<1,1,1>*1.2 color rgb<0.25,0.15,0.1>*0}
              //normal { bumps 0.75 scale 0.025}
                finish { phong 0.1}
              } // end of texture
     } // end of plane
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//---------------------------------------------------------------------------


sphere{0,1 translate y

material{texture{pigment{rgbt 1}
                 finish{}
                 }  
        interior{//ior 1.3 
                media {
                      // (---general values---)
                      /*intervals 10           // number of intervals used for sampling [10]
                      samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
                      confidence 0.9         // statistic parameter higher->better quality [0.9]
                      variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
                      ratio 0.9              // distribution between lit and unlit areas [0.9]
                      */
                      scattering {1, rgb 1 }
                      method 3               // adaptive sampling
                      density { 
                                  agate scale .3
                                  color_map {[.5 color rgb <1,0,0>]
                                            [.5 color rgb <1,.5,0>]
                                            [.6 color rgb 100]
                                          }
                                }
                      }
                 media {
                      // (---general values---)
                      intervals 10           // number of intervals used for sampling [10]
                      samples 1,10            // minimum and maximum number of samples taken per interval [1,1]
                      //confidence 0.9         // statistic parameter higher->better quality [0.9]
                      //variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
                      //ratio 0.9              // distribution between lit and unlit areas [0.9]
                      //
                      absorption 1
                      method 3               // adaptive sampling
                      density { 
                                  agate scale .3
                                  color_map {[.5 color rgb <1,0,0>]
                                            [.5 color rgb <1,.5,0>]
                                            [.6 color rgb <200,50,0>]
                                          }
                                }
                      }
                }         
        }
         hollow
         }