                                                                                                                              // PoVRay 3.7 Scene File " ... .pov"
// author:  ...
// date:    ...
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera {perspective angle 75               // front view
                            location  <0.0 , 2 ,-3.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 0 , 0.0>}

// sun ----------------------------------------------------------------------
light_source{< 3000,3000,-3000> color rgb 1}
// sky ----------------------------------------------------------------------
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere
// ground -------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment{ checker color rgb<1,1,1>*1.2 color rgb<0.25,0.15,0.1>*0}
              //normal { bumps 0.75 scale 0.025}
                finish { phong 0.1}
              } // end of texture
     } // end of plane
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//---------------------------------------------------------------------------


#declare Shape= // ==>> Insert your shape here ==>>
cylinder { <0,0,0>,<0,1,0>, 0.5} // end of cylinder -------------------------------------


#macro Pigm()  // ==>> Insert your main pigment here ==>>
    crackle form<1,1,0>  scale .1
      color_map {
                [0 color rgb 1]
                [1 color rgb 0]
              }
#end

#declare Threshold=0.3; // changes the area in the texture where the inner material starts in the main pigment
 
#declare Pigmt=pigment {
      Pigm()
    } 




/////////////////////////////////////////////////////////////////


#declare fn_Pigm=function {pigment{Pigm()}} 

#declare IsoShape=
isosurface {
  function{fn_Pigm(x/2, y/2, z/2).gray}  
  
  threshold Threshold
  contained_by { box {min_extent(Shape),max_extent(Shape) } }
  accuracy 0.003
  max_gradient 5

} // end of isosurface ------------------------------



intersection{
            object{Shape} 
            object{IsoShape} 
            
  
  material{texture{
                   pigment{color rgbft <0,.7,1, .5,.5>}
                   finish{specular .5 phong 1 reflection{0,1 fresnel }}
                   } 
          interior{ior 1.3 fade_color <0,.3,1> fade_distance 1}  
            
           }  
 hollow          
} // end of isosurface ------------------------------


 
