//*PMRawBegin
#version 3.7;
//*PMRawEnd

global_settings {
   adc_bailout 0.0039216
   ambient_light rgb<0, 0, 0>
   assumed_gamma 1
   max_trace_level 20
   noise_generator 2
   
   radiosity {
      count 100
      error_bound 0.5
      low_error_factor 0.3
      minimum_reuse 0.01
      nearest_count 7
      recursion_limit 3
   }
}

camera {
   orthographic
   location <-0.38583, 4.644, -20.444>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.7777, 0, 0>
   up <0, 1, 0>
   look_at <0, 0, 0>
   angle 45
}

#declare Dec_pigm_spike = pigment {
   //*PMRawBegin
   function{ 1/(1 + pow( exp( x*x  + y*y + z*z ), 2 ) ) }
   //turbulence <3,3,3>
   //*PMRawEnd
}

#declare Dec_pigm_spike_0 = pigment {
   //*PMRawBegin
   function{ 1/(1 + pow( sqrt( x*x  + y*y + z*z ), 7 ) ) }
   //turbulence <3,3,3>
   //*PMRawEnd
}

#declare Dec_density_spike = density {
   pigment_pattern {Dec_pigm_spike}
   
   warp {
      turbulence <0.7, 0.8, 0.7>
      omega 0.6
      lambda 2.7
   }
}

#declare Dec_density_spike_0 = density {
   pigment_pattern {Dec_pigm_spike_0}
   
   warp {
      turbulence <1, 1, 1>
      omega 0.6
      lambda 2.7
   }
}

#declare Dec_density_spike_1 = density {
   pigment_pattern {Dec_pigm_spike}
   
   warp {
      turbulence <0.9, 0.9, 0.9>
      omega 0.6
      lambda 3
   }
}

#declare Dec_density_center = density {
   //*PMRawBegin
   function{ pow( (1/(1 + pow( sqrt( x*x  + y*y + z*z ), 4 ) ) ),2) }
   turbulence <.15,.9,.15> lambda 2.5
   turbulence <-.15,.9,-.15> lambda 2.5
   //*PMRawEnd
}

text {
   ttf "crystal.ttf"
   "2015"
   1, <0, 0>
   
   texture {
      normal {
         bumps
         0.5
         turbulence <0.1, 0.1, 0.1>
         scale 0.002
         bump_size 0.1
         accuracy 0.001
      }
      
      pigment {
         color rgb<1, 0.80392, 0.13725>
      }
      
      finish {
         diffuse 0.3
         specular 0.1
         roughness 0.01
      }
   }
   scale <2.886, 1.605, 0.466>
   rotate y*(-29.6)
   translate <10.7329, -119.267, 536.704>
   hollow
}

light_source {
   <11.043, -119.27, 529.94>, rgb<1, 1, 1>
   spotlight
   radius 60
   falloff 60
   point_at <13.244, -118.79, 538.31>
   media_interaction off
   media_attenuation off
}

#declare Dec_pp_arm = pigment {
   //*PMRawBegin
   function{ (4/ (1 + pow( (x*x  + y*y + z*z), 2 )))*2 }
   
   turbulence <4,4,0>
   //*PMRawEnd
}

#declare Dec_pp_arm_inverso = pigment {
   //*PMRawBegin
   function{ (4/ ( pow( (x*x  + y*y + z*z), 1.5 )))*2 }
   
   turbulence <4,4,0>
   //*PMRawEnd
}

#declare Dec_pp_spiral1 = pigment {
   spiral1 3
   
   warp {
      turbulence <0.1, 0.1, 0.1>
   }
   
   warp {
      turbulence <-0.1, -0.1, -0.1>
   }
}

#declare Dec_center = sphere {
   <0, 0, 0>, 1.3
   
   material {
      texture {
         pigment {
            color rgbf <1, 1, 1, 1>
         }
      }
      
      interior {
         media {
            //*PMName media_center
            
            density {
               //*PMName density_center
               Dec_density_center
               scale <0.12, 0.05, 0.12>
            }
            intervals 11
            samples 5,10
            emission rgb<12, 10, 7>
         }
      }
   }
   scale <16, 0.5, 16>
   hollow
}

#declare Dec_spike = sphere {
   <0, 0, 0>, 3
   
   material {
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
      
      interior {
         media {
            //*PMName media_star
            
            density {
               //*PMName density_star
               Dec_density_spike
               scale <0.2, 0.8, 0.2>
            }
            intervals 20
            emission rgb<5, 5, 5>
         }
         
         media {
            //*PMName media_star_0
            
            density {
               //*PMName density_star
               Dec_density_spike_0
               scale <0.05, 0.9, 0.05>
            }
            intervals 20
            emission rgb<20, 20, 5>
         }
         
         media {
            //*PMName media_star_1
            
            density {
               //*PMName density_star
               Dec_density_spike_1
               scale <0.3, 0.8, 0.3>
            }
            intervals 20
            emission rgb<6, 8, 3>
         }
      }
   }
   scale <0.5, 2, 0.5>
   rotate <0, 0, 0>
   translate <0, 0, 0>
   hollow
}

union {
   //*PMName u_explosion
   
   object {
      //*PMName obj_center
      Dec_center
      hollow
   }
   
   object {
      //*PMName obj_spike
      Dec_spike
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   plane {
      <0, 1, 0>, 0
      
      texture {
         average
         
         texture_map {
            [ 1 wrinkles
            turbulence <0.5, 2, 0.5>
            lambda 2.5
            
            texture_map {
               [ 0 pigment {
                  color rgbt <0, 0, 0, 0.99>
               }
               
               finish {
                  emission rgb<0.415686, 0.415686, 0.415686>
               }
               ]
               [ 1 pigment {
                  color rgbt <1, 1, 1, 0.95>
               }
               
               finish {
                  emission rgb<0.0862745, 0.0862745, 0.0862745>
                  diffuse 0.6
               }
               ]
            }
            
            warp {
               spherical orientation <0, 0, 1>
            }
            scale 0.1
            
            warp {
               turbulence <0.7, 0.8, 0.7>
               lambda 2.5
            }
            scale <850, 700, 700>
            ]
            [ 1 agate
            agate_turb 0.5
            turbulence <0.7, 0.7, 0.7>
            lambda 3
            scale 1600
            
            texture_map {
               [ 0 crackle
               solid
               turbulence <1, 1, 1>
               
               texture_map {
                  [ 0 pigment {
                     color rgb<1, 1, 1>
                  }
                  ]
                  [ 0.1 wrinkles
                  noise_generator 3
                  turbulence <0.2, 0.2, 0.2>
                  
                  texture_map {
                     [ 0 pigment {
                        color rgbt <0.003, 0.003, 0.003, 0.99>
                     }
                     ]
                     [ 0.1 pigment {
                        color rgbt <0.0588235, 0, 0, 0.99>
                     }
                     ]
                  }
                  ]
               }
               scale 0.002
               ]
               [ 0.99 crackle
               solid
               turbulence <1, 1, 1>
               lambda 5
               
               texture_map {
                  [ 0 pigment {
                     color rgb<1, 1, 1>
                  }
                  
                  finish {
                     emission rgb<1, 0.384314, 0.384314>
                  }
                  ]
                  [ 0.25 wrinkles
                  noise_generator 3
                  turbulence <0.2, 0.2, 0.2>
                  
                  texture_map {
                     [ 0 pigment {
                        color rgbt <0.003, 0.003, 0.003, 0.99>
                     }
                     ]
                     [ 0.1 pigment {
                        color rgbt <0, 0, 0, 0.99>
                     }
                     ]
                  }
                  ]
               }
               scale 0.002
               ]
               [ 1 crackle
               solid
               turbulence <1, 1, 1>
               omega 0.8
               lambda 5
               
               texture_map {
                  [ 0 pigment {
                     color rgb<1, 1, 1>
                  }
                  
                  finish {
                     emission rgb<5, 0.99608, 0.58431>
                  }
                  ]
                  [ 0.3 wrinkles
                  noise_generator 3
                  turbulence <0.2, 0.2, 0.2>
                  
                  texture_map {
                     [ 0 pigment {
                        color rgbt <0.003, 0.003, 0.003, 0.99>
                     }
                     ]
                     [ 0.1 pigment {
                        color rgbt <0, 0, 0, 0.99>
                     }
                     ]
                  }
                  ]
               }
               scale 0.001
               ]
            }
            ]
            [ 1 crackle
            solid
            
            texture_map {
               [ 0 pigment {
                  color rgb<1, 1, 1>
               }
               
               finish {
                  emission rgb<0, 0, 60>
                  diffuse 0.6
                  brilliance 0.2
                  specular 0.5
                  roughness 0.05
               }
               ]
               [ 0.16 pigment {
                  color rgbt <0, 0, 0, 1>
               }
               ]
            }
            ]
            [ 1 //*PMName white
            crackle
            solid
            turbulence <1, 1, 1>
            
            texture_map {
               [ 0 pigment {
                  color rgb<1, 1, 1>
               }
               
               finish {
                  emission rgb<64, 64, 64>
                  diffuse 0.6
                  brilliance 0.2
                  specular 0.5
                  roughness 0.05
               }
               ]
               [ 0.16 pigment {
                  color rgbt <0, 0, 0, 1>
               }
               ]
            }
            ]
         }
      }
      scale 0.002
      rotate x*90
      translate z*500
      no_shadow
      no_reflection
      hollow
   }
   hollow
}

#declare Dec_center_galaxy = sphere {
   <0, 0, 0>, 0.5
   
   material {
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
      
      interior {
         media {
            //*PMName media_center
            
            density {
               //*PMRawBegin
               function{ pow( (1/(1 + pow( sqrt( x*x  + y*y + z*z ), 4 ) ) ),2) }
               //turbulence <3,3,3>
               //*PMRawEnd
               scale 0.1
            }
            samples 5,10
            emission rgb<8, 7, 6>
         }
      }
   }
   hollow
}

#declare Dec_center_spiral_galaxy = sphere {
   <0, 0, 0>, 1.2
   
   material {
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
      
      interior {
         media {
            density {
               pigment_pattern {Dec_pp_spiral1}
               
               density_map {
                  [ 0.9 color rgbt <0, 0, 0, 1>
                  ]
                  [ 1 pigment_pattern {Dec_pp_arm}
                  scale 0.1
                  
                  color_map {
                     [ 0 color rgbt <0, 0, 0, 1>
                     ]
                     [ 0.08 color rgbt <1, 1, 1, 1>
                     ]
                     [ 0.2 color rgbt <0, 0, 0, 1>
                     ]
                     [ 0.3 color rgbt <2, 0, 0, 1>
                     ]
                     [ 0.4 color rgbt <1, 1, 1, 1>
                     ]
                     [ 1 color rgbt <1, 0.721569, 0.356863, 1>
                     ]
                  }
                  ]
               }
            }
            intervals 11
            samples 3,20
            emission rgb<2, 1, 0.5>
         }
      }
   }
   scale <1, 1, 0.1>
   hollow
}

#declare Dec_arms_galaxy = sphere {
   <0, 0, 0>, 1
   
   material {
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
      
      interior {
         media {
            density {
               onion
               
               warp {
                  turbulence <0.2, 0.2, 0.2>
               }
               
               warp {
                  turbulence <-0.2, -0.2, -0.2>
               }
               
               density_map {
                  [ 0 color rgbt <0, 0, 0, 1>
                  ]
                  [ 0.7 pigment_pattern {Dec_pp_spiral1}
                  
                  density_map {
                     [ 0.3 color rgbt <0, 0, 0, 1>
                     ]
                     [ 1 pigment_pattern {Dec_pp_arm}
                     
                     color_map {
                        [ 0 color rgbt <0, 0, 0, 1>
                        ]
                        [ 0.1 color rgbt <1, 1, 1, 1>
                        ]
                        [ 1 color rgbt <0, 0, 0, 1>
                        ]
                     }
                     scale 0.1
                     ]
                  }
                  scale <0.5, 0.5, 5>
                  ]
                  [ 1 color rgbt <0, 0, 0, 1>
                  ]
               }
            }
            intervals 11
            samples 2,5
            emission rgb<1, 1, 1>
            
            scattering {
               1, rgb<1, 1, 1>
               extinction 0
            }
         }
         
         media {
            density {
               onion
               
               warp {
                  turbulence <0.21, 0.21, 0.21>
               }
               
               warp {
                  turbulence <-0.21, -0.21, -0.21>
               }
               
               density_map {
                  [ 0 color rgbt <0, 0, 0, 1>
                  ]
                  [ 0.4 pigment_pattern {Dec_pp_spiral1}
                  
                  density_map {
                     [ 0.7 color rgbt <0, 0, 0, 1>
                     ]
                     [ 1 pigment_pattern {Dec_pp_arm_inverso}
                     
                     color_map {
                        [ 0 color rgbt <0, 0, 0, 1>
                        ]
                        [ 0.1 color rgbt <15, 10, 5, 1>
                        ]
                        [ 0.5 color rgbt <0, 0, 0, 1>
                        ]
                     }
                     scale 0.1
                     ]
                  }
                  scale <0.5, 0.5, 5>
                  ]
                  [ 0.6 color rgbt <0, 0, 0, 1>
                  ]
               }
            }
            intervals 11
            samples 2,5
            emission rgb<5, 3.5, 2>
         }
      }
   }
   scale <1, 1, 0.02>
   hollow
}

union {
   //*PMName u_galaxy
   
   object {
      //*PMName obj_center_galaxy
      Dec_center_galaxy
      hollow
   }
   
   object {
      //*PMName obj_center_spiral_galaxy
      Dec_center_spiral_galaxy
      no_shadow
      hollow
   }
   
   object {
      //*PMName obj_arms_galaxy
      Dec_arms_galaxy
      no_shadow
      hollow
   }
   scale 1
   rotate x*75.6
   translate <6.82932, 1.89962, 8.3574>
   hollow
}

#declare Dec_density_star = density {
   //*PMRawBegin
   function{ pow( (1/(1 + pow( sqrt( x*x  + y*y + z*z ), 4 ) ) ),2) }
   //turbulence <3,3,3>
   //*PMRawEnd
}

#declare Dec_star = sphere {
   <0, 0, 0>, 0.5
   hollow
}

#declare Dec_merge_star = merge {
   //*PMName merge_star
   
   object {
      //*PMName obj_star
      Dec_star
      hollow
   }
   
   object {
      //*PMName obj_star_spyke
      Dec_star
      scale <0.05, 3, 0.05>
      hollow
   }
   
   object {
      //*PMName obj_star_spyke_oriz
      Dec_star
      scale <3, 0.05, 0.05>
      hollow
   }
   hollow
}

object {
   //*PMName obj_star_01
   Dec_merge_star
   
   texture {
      pigment {
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         //*PMName media_star
         
         density {
            //*PMName density_star
            Dec_density_star
            scale 0.13
         }
         intervals 25
         samples 5,10
         emission rgb<10, 10, 10>
      }
      
      media {
         //*PMName m_spyke_vert
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.01, 0.4, 0.01>
         }
         intervals 20
         emission rgb<15, 15, 15>
      }
      
      media {
         //*PMName m_spyke_oriz
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.4, 0.01, 0.01>
         }
         intervals 20
         emission rgb<15, 15, 15>
      }
   }
   translate <-6.81657, 0.782809, 9.72406>
   hollow
}

object {
   //*PMName obj_star_02
   Dec_merge_star
   
   texture {
      pigment {
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         //*PMName media_star
         
         density {
            //*PMName density_star
            Dec_density_star
            scale 0.13
         }
         intervals 25
         samples 5,10
         emission rgb<20, 10, 10>
      }
      
      media {
         //*PMName m_spyke_vert
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.01, 0.4, 0.01>
         }
         intervals 20
         emission rgb<20, 15, 15>
      }
      
      media {
         //*PMName m_spyke_oriz
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.4, 0.01, 0.01>
         }
         intervals 20
         emission rgb<20, 15, 15>
      }
   }
   scale 0.5
   translate <-1.71657, 1.11614, 9.72406>
   hollow
}

object {
   //*PMName obj_star_03
   Dec_merge_star
   
   texture {
      pigment {
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         //*PMName media_star
         
         density {
            //*PMName density_star
            Dec_density_star
            scale 0.13
         }
         intervals 25
         samples 5,10
         emission rgb<20, 10, 10>
      }
      
      media {
         //*PMName m_spyke_vert
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.01, 0.4, 0.01>
         }
         intervals 20
         emission rgb<20, 15, 15>
      }
      
      media {
         //*PMName m_spyke_oriz
         
         density {
            //*PMName density_star
            Dec_density_star
            scale <0.4, 0.01, 0.01>
         }
         intervals 20
         emission rgb<20, 15, 15>
      }
   }
   scale 0.2
   translate <5.81119, 1.793, 8.09801>
   hollow
}
//*PMRawBegin
#declare Rnd_x = seed (35);
#declare Rnd_y = seed (74);
#declare Rnd_scale = seed (32);
#declare Rnd_emis = seed (17);
#declare Rnd_red = seed (9);
#declare Rnd_blu = seed (963);
#declare Rnd_turb = seed (762);

#for (y_cols, 1.6 , -8 , -0.5)

 #for (x_line, -8.6 , 8.6 , 1)
  object{ Dec_merge_star
          texture { pigment { color rgbt <1, 1, 1, 1> } }
          interior {
           media {
            density { Dec_density_star scale 0.13 turbulence rand(Rnd_turb)*.2 }
            intervals 25
            samples 5,10
            emission rgb< 10+rand(Rnd_red)*10 , 10, 10+rand(Rnd_blu)*10 >
           }
           media {         
            density { Dec_density_star scale <0.01, 0.4, 0.01> }
            intervals 20
            emission rgb<15, 15, 15>
           }
           media {
            density { Dec_density_star scale <0.4, 0.01, 0.01> }
            intervals 20
            emission rgb<15, 15, 15>
           }
          }
          #local x_var = (-1+2* rand( Rnd_x ))/3;
          #local y_var = (-1+2* rand( Rnd_y ))/3;
          #local scale_var = ( 7 * rand( Rnd_scale ));
          scale rand(Rnd_scale)/3
          translate< x_line+x_var , y_cols+y_var , 14.5>
          hollow
  }
 #end

#end
//*PMRawEnd