// macros to create a dandelion clock 

#include "transforms.inc"

#declare meshMossGeneralRand = seed(11282);   

// Macro to return a random number

#macro meshMossr(num)
        rand(meshMossGeneralRand)*num
#end

#macro mkMossLeaf(minBend, maxBend, detailLevel, transformation)
    
    #local midHeight=minBend+meshMossr(maxBend-minBend);//.2 .3    
    #local endWidth=0.001+meshMossr(0.0025);   
    #local midWidth=0.1675+meshMossr(0.02);
    
    
    #local  TestSpline = spline {
                 natural_spline           
    
                 0.0, vtransform(<-0.05, 0.05, 0>, transformation), 
                 0.2+meshMossr(0.1), vtransform(<-(midWidth*2), 0.125+(midHeight*0.5), 0.4>, transformation),
                 0.4+meshMossr(0.1), vtransform(<-(midWidth*1.5+meshMossr(0.0125)), 0.16+(midHeight), 0.8>-meshMossr(0.05), transformation),
                 0.8+meshMossr(0.1), vtransform(<-((midWidth*0.2)+meshMossr(0.0125)), 0.2+(midHeight*0.85)+meshMossr(0.05), 1.85>, transformation),
                 1.0, vtransform(<-endWidth, 0.1+(midHeight), 2.0> , transformation)
   }
 
     #local  TestSpline3 = spline {
                 natural_spline           
    
                 0.0, vtransform(<0.05, 0.05, 0>, transformation), 
                 0.2+meshMossr(0.1), vtransform(<(midWidth*2), 0.125+(midHeight*0.5), 0.4>, transformation),
                 0.4+meshMossr(0.1), vtransform(<midWidth*1.5+meshMossr(0.0125), 0.16+(midHeight)+meshMossr(0.05), 0.8>, transformation),
                 0.8+meshMossr(0.1), vtransform(<(midWidth*0.2)+meshMossr(0.0125), 0.2+(midHeight*0.85)-meshMossr(0.05), 1.85>, transformation),
                 1.0, vtransform(<endWidth, 0.1+(midHeight), 2.0>, transformation)
   }
    #local  TestSpline2 = spline {
                 natural_spline           
    
                 0.0, vtransform(<0.0, 0.03, 0>, transformation), 
                 0.2+meshMossr(0.1), vtransform(<-0.01+meshMossr(0.02), 0.04+(midHeight*0.5), 0.4>, transformation),
                 0.4+meshMossr(0.1), vtransform(<-0.01+meshMossr(0.02), 0.08+(midHeight), 0.8>, transformation),
                 0.8+meshMossr(0.1), vtransform(<-0.01+meshMossr(0.02), 0.1+(midHeight*0.85), 1.6>, transformation),
                 1.0, vtransform(<-0.01+meshMossr(0.02), 0.1+midHeight, 2.0>, transformation)
   }
                  
 #local lastHeight=0.01;
 
 #local meshStep=detailLevel;

    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+meshMossr(0.001)-meshMossr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline(mCount),
            0.5 ((TestSpline(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline(mCount+meshStep),
            0.5 ((TestSpline(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2) 
                 uv_vectors <msp1(mCount2).x, mCount2>,<msp2(mCount2).x, mCount2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>
//               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>
            }
            triangle { msp2(mCount2),                msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
                uv_vectors <msp2(mCount2).x, mCount2>,<msp2(mCount2+meshStep2).x, mCount2+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>            
//              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+meshMossr(0.001)-meshMossr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline3(mCount),
            0.5 ((TestSpline3(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline3(mCount+meshStep),
            0.5 ((TestSpline3(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2)
                 uv_vectors <msp1(mCount2).x, mCount2>,<msp2(mCount2).x, mCount2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>            
//               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
             }
            triangle {    msp2(mCount2),             msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount2>,<msp2(mCount2+meshStep2).x, mCount2+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>                        
//              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>                        
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  

#end


#macro mkMoss(detailLevel)

mesh {

// first set of leaves    
    #local pRot=meshMossr(10);
    #local lH = 0;
    #local mH = meshMossr(7);
    #while (lH < 6+mH)
    #local pCount=0;  
    #while(pCount < 3)
        
         
         mkMossLeaf(0.1, 0.15, detailLevel, transform { scale <1+meshMossr(0.2), 1, 1+meshMossr(0.1)> scale 1-(lH*0.075) rotate <-(35+(lH*3)+meshMossr(5)), 0, 0> translate <0, 0, 0.0> rotate <0, pRot, 0> translate <0, lH*(0.5-lH/100), 0> }) // scale <1+meshMossr(0.2), 1, 1+meshMossr(0.1)> scale 1-(lH*0.1) rotate <-(35+lH*5+meshMossr(5)), 0, 0> translate <0, 0, 0.1> }
        
         
        //rotate <0, pRot, 0>
        //translate <0, lH*(0.5-lH/80), 0>
        
         
        #local pRot=pRot+80+meshMossr(40);
        #local pCount=pCount+1;
    #end
    #local lH=lH+1;
    #end

// rotate a set of leaves around edge
    #local outerRotation=0;
    #while(outerRotation < 360)
    #local pRot=meshMossr(10);
    #local lH = 0;
    #local mH = meshMossr(6);
    #while (lH < 5+mH)
    #local pCount=0;  
    #while(pCount < 3)
        
         
         mkMossLeaf(0.1, 0.15, detailLevel, transform { scale <1+meshMossr(0.2), 1, 1+meshMossr(0.1)> scale 1-(lH*0.075) rotate <-(35+(lH*3)+meshMossr(5)), 0, 0> translate <0, 0, 0.0> rotate <0, pRot, 0> translate <0, lH*(0.5-lH/100), 0> translate <0, 1, 0> rotate <0, 0, 35+meshMossr(15)> translate <0, -1, 0> rotate <0, outerRotation, 0> }) // scale <1+meshMossr(0.2), 1, 1+meshMossr(0.1)> scale 1-(lH*0.1) rotate <-(35+lH*5+meshMossr(5)), 0, 0> translate <0, 0, 0.1> }
        
         
        //rotate <0, pRot, 0>
        //translate <0, lH*(0.5-lH/80), 0>
        
         
        #local pRot=pRot+80+meshMossr(40);
        #local pCount=pCount+1;
    #end
    #local lH=lH+1;
    #end              
    #local outerRotation=outerRotation+30+meshMossr(30);
    #end

}

#end

 /*


//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
#declare Camera_0 = camera {perspective angle 75               // front view
                            location  <0.0 , 9 ,-13.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}
camera{Camera_0}

// radiosity (global illumination) settings
#default{ finish{ ambient 0 diffuse 1 }} 

global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]

    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]

    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}

// sun ----------------------------------------------------------------------
light_source{< 3000,3000,-3000> color rgb 1}
// sky ----------------------------------------------------------------------
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere


#declare clump= object { mkMoss(0.1) scale 0.1 }  

union {
#declare clumpCount=0;
#while(clumpCount < 300)
 object { clump translate <meshMossr(5), meshMossr(0.4), meshMossr(5)> }
 #declare clumpCount=clumpCount+1;
#end
texture
{
        pigment 
        {    
                wrinkles 
                triangle_wave 
                turbulence 0.75
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.07, 0.13, 0.020> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.11, 0.19, 0.023> ]
                }
                scale 0.01
                translate <0, -1, 0>                          
        }
        
        finish { specular albedo 0.2 roughness 0.05 diffuse albedo 0.4, 0.1 brilliance 2.5 }
        normal { bumps scale 0.025 }
    //    finish { phong 0.5 }
}
}     
*/