#version 3.7;

#include "transforms.inc"

#declare lTexGeneralRand = seed(5129);   
#declare lGeneralRand = seed(5552);   

// Macro to return a random number

#macro lr(num)
        rand(lGeneralRand)*num
#end

#macro lrTex(num)
        rand(lTexGeneralRand)*num
#end


#macro mkLPadLeaf(minBend, maxBend, detailLevel)

#declare Strength_1 = 1.0; //(+ or -) strength of component's radiating density
#declare Radius1  = 1.00; //(0 < Radius) outer sphere of influence on other components
#local lp1 = blob{
  threshold 0.65 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  cylinder{<0, -0.1, 0>,<0, 0.1, 0.00>, 2.7+lr(0.2), 1 scale <1, 0.025, 1> }          
  #local sCount=0;
  #while(sCount < 20)
    sphere{  <0, 0.00, 0.00>, 0.3+lr(0.3), 1 scale <1, 0.2+lr(0.15), 1> translate <-0.75+lr(1.5), 0, -0.75+lr(1.5)> }  
    #local sCount=sCount+1; 
  #end  
  sphere{  <0, 0.00, 0.00>, 0.4+lr(0.4), 1 scale <1, 0.4+lr(0.4), 1> translate <1.0+lr(1.5), 0.0, -0.1> rotate <0, lr(360), 0> }  
  sphere{  <0, 0.00, 0.00>, 0.4+lr(0.4), 1 scale <1, 0.4+lr(0.4), 1> translate <1.0+lr(1.5), 0.0, -0.1> rotate <0, lr(360), 0> }  
  sphere{  <0, 0.00, 0.00>, 0.4+lr(0.4), 1 scale <1, 0.4+lr(0.4), 1> translate <1.0+lr(1.5), 0.0, -0.1> rotate <0, lr(360), 0> }  
  sphere{  <0, 0.00, 0.00>, 0.4+lr(0.4), 1 scale <1, 0.4+lr(0.4), 1> translate <1.0+lr(1.5), 0.0, -0.1> rotate <0, lr(360), 0> }  
  sphere{  <0, 0.00, 0.00>, 0.4+lr(0.4), 1 scale <1, 0.4+lr(0.4), 1> translate <1.0+lr(1.5), 0.0, -0.1> rotate <0, lr(360), 0> }  
  
  sphere{  <0, 0.00, 0.00>, 1+lr(0.5), -(1.5+lr(0.5)) scale <.05+lr(0.1), 4, 1> translate <0, 0.0, -(0.8+lr(0.4))> rotate <0, lr(360), 0> }  

  
 } //------------------------------------------------------ end of blob object             
#local lp2 = blob{
  threshold 0.65 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  cylinder{<0, -0.1, 0>,<0, 0.1, 0.00>, 2.7+lr(0.2), 1  }          
  #local sCount=0;
  #while(sCount < 20)
    sphere{  <0, 0.00, 0.00>, 0.3+lr(0.3), 1 scale <1, 1, 1> translate <-0.75+lr(1.5), 0, -0.75+lr(1.5)> }  
    #local sCount=sCount+1; 
  #end  
  
 } //------------------------------------------------------ end of blob object             

intersection {
difference { object { lp1 } object { lp1 scale <1.01, 1, 1.01> translate <0, -0.02, 0> }    }
    object { lp2 }
}
    
#end


#macro mklPad(detailLevel)
union {
    
        union { object { mkLPadLeaf(0.01, 0.02, detailLevel) scale <1+lr(0.1), 1, 1+lr(0.1)> scale 1+lr(0.5) translate <0, 0, -1> }
        
        cylinder { <0, -6, -1> <0, 0, 0> 0.03 }
         
        
        }
#local brownVal=lrTex(0.07);         

       material {
/*
texture
{
        pigment 
        {       
            
                granite  
                triangle_wave 
                turbulence 0.5
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.02+brownVal, 0.2-brownVal, 0.00001>*(0.45+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 0.5+lrTex(0.1) rgb <0.02+brownVal, 0.1-brownVal, 0.0001>*(0.45+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.03+brownVal, 0.12-brownVal, 0.0001>*(0.4+lrTex(0.2)) ]
                }
                scale 2
        }
       
    //    finish { phong 0.5 }
} 
*/
texture
{
        pigment 
        {       
            
                granite  
                triangle_wave 
                turbulence 0.5
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.08, 0.05, 0.00001>*(0.4+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 0.5+lrTex(0.1) rgb <0.22, 0.3, 0.0001>*(0.4+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.25, 0.33, 0.01>*(0.4+lrTex(0.2)) ]
                }
                scale 2
        }
       
    //    finish { phong 0.5 }
} 
texture
{
        pigment 
        {       
            
                radial  
                triangle_wave 
                turbulence 0.5
                omega 0.75
                lambda 2.25       
                frequency 20
                colour_map
                {
                        [ 0.0 rgbt <0.07, 0.03, 0.00001, 0.2>*(0.4+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 0.5+lrTex(0.1) rgbt <0.12, 0.2, 0.0001, 0.3>*(0.4+lrTex(0.2)) ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgbt <0.09, 0.135, 0.0001, 0.7>*(0.4+lrTex(0.2)) ]
                }
                translate <0, 0, 0.5> 
                
        }
       
    //    finish { phong 0.5 }
} 
texture
{
        pigment 
        {       
            
                granite
                scallop_wave  
                 
                turbulence 0.5
                omega 0.85
                lambda 2.25       
                
                colour_map
                {
                        [ 0.0 rgbt 1]        //<0.05, 0.08, 0.005>
                        [ 0.9 rgbt 1 ]        //<0.05, 0.08, 0.005>
                        [ 0.9 rgbt <0.04, 0.01, 0.0001, 1>*(0.4+lrTex(0.2)) ]
                        [ 1 rgbt <0.04, 0.01, 0.0001, 0.05>*(0.4+lrTex(0.2)) ]
                }
                scale 0.01
                
        }
       
    //    finish { phong 0.5 }
} 
texture
{
        pigment 
        {        
                onion   
                triangle_wave 
                turbulence 0.075
                omega 0.95
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.06, 0.02, 0.002, 0.1+lrTex(0.1)> ]        //<0.05, 0.08, 0.005>
                        [ 0.15 rgbt <.06, 0.03, 0.002, 0.2+lrTex(0.2)> ]        //<0.05, 0.08, 0.005>
                        [ 0.3 rgbt <.07, 0.04, 0.002, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.125 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1.9
                translate <0, 0, -1>
        }

        finish { specular albedo 0.3 roughness 0.01 diffuse albedo 0.4 brilliance 1.4 reflection { 0.01, 0.08 fresnel on } conserve_energy }
        normal { wrinkles 0.1 turbulence 0.3 sine_wave scale 0.1 translate <0, 0, 0.5>}

} 
           interior { ior 1.6 } 
            }
        } 
#end



