// macros to create a dandelion clock 

#include "transforms.inc"

#declare daisyGeneralRand = seed(1282);   

// Macro to return a random number

#macro daisyr(num)
        rand(daisyGeneralRand)*num
#end

#macro daisyLeaf(minBend, maxBend, detailLevel)
    
    #local midHeight=minBend+daisyr(maxBend-minBend);//.2 .3
    
    #local  TestSpline = spline {
                 natural_spline           
    
    #local spointDiff=daisyr(0.01);
    #local spoint=0.1;
                 0.0, <-0.05, 0.05, 0>, 
    #while(spoint < 0.71)   
        #local spos=spoint*0.35+spointDiff;
            spoint, <-(spos+0.02), 0.05+(sin(spoint*4)*midHeight), (spoint*2)>,        

        #local spointDiff=daisyr(0.1);
        #local spoint=spoint+0.1;
        #end
                 0.8, <-0.3, 0.05+(sin(3)*midHeight), 1.8>
                 1.0, <0, 0.05+(sin(4)*midHeight), 2>
                };

        #local  TestSpline3 = spline {
                 natural_spline           

    #local spoint=0.1+daisyr(0.1);
                 0.0, <0.05, 0.05, 0>, 
    #while(spoint < 0.71)   
        #local spos=spoint*0.35+spointDiff;
            spoint, <(spos+0.02), 0.05+(sin(spoint*4)*midHeight), (spoint*2)>,        

        #local spoint=spoint+0.1;
        #end
                 0.8, <0.3, 0.05+(sin(3)*midHeight), 1.8>
                 1.0, <0, 0.05+(sin(4)*midHeight), 2>
                };

                                 
        #local  TestSpline2 = spline {
                 natural_spline
                 0.0, <0, 0.05, 0> 
                 0.3, <0, (sin(1.2)*midHeight), 0.6>
                 0.5, <0, (sin(2)*midHeight), 1.05>
                 0.7, <0, (sin(2.8)*midHeight), 1.4>
                 1.0, <0, 0.05+(sin(4.0)*midHeight), 2>
                };
  
union{ 
union {
sphere { <0, 0.0, 0> 0.05 scale <1, 3, 1> }
cylinder { <0, 0.0, 0> <0, -0.25, 0> 0.05 }   
scale <1, 1, 0.25>
rotate <80-(midHeight*40), 0, 0> translate <0, 0.05, 0> 

}
 #local lastHeight=0.01;
 
 #local meshStep=detailLevel;

mesh {
    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline(mCount),
            0.5 ((TestSpline(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline(mCount+meshStep),
            0.5 ((TestSpline(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2) 
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>
            }
            triangle { msp2(mCount2),                msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline3(mCount),
            0.5 ((TestSpline3(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline3(mCount+meshStep),
            0.5 ((TestSpline3(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2)
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
             }
            triangle {    msp2(mCount2),             msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>                        
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


}   
      
}
#end




#macro mkDaisyFlowerPetal(minBend, maxBend, detailLevel)
    
    #local midHeight=minBend+daisyr(maxBend-minBend);//.2 .3    
    #local endWidth=0.06+daisyr(0.01);   
    #local midWidth=0.15+daisyr(0.02);
    
    
    #local  TestSpline = spline {
                 natural_spline           
    
                 0.0, <-0.05, 0.05, 0>, 
                 0.2+daisyr(0.1), <-(midWidth*0.6), 0.05+(midHeight*0.5), 0.4>,
                 0.5+daisyr(0.1), <-(midWidth), 0.05+(midHeight), 1.0>,
                 0.9+daisyr(0.01), <-((midWidth*0.95)), 0.04+(midHeight*0.5), 1.8>,
                 1.0, <-endWidth, (midHeight), 2.0>
   }
 
     #local  TestSpline3 = spline {
                 natural_spline           
    
                 0.0, <0.05, 0.05, 0>, 
                 0.2+daisyr(0.1), <(midWidth*0.6), 0.05+(midHeight*0.5), 0.4>,
                 0.5+daisyr(0.1), <midWidth, 0.05+(midHeight), 1.0>,
                 0.9+daisyr(0.01), <(midWidth*0.95), 0.04+(midHeight*0.5), 1.8>,
                 1.0, <endWidth, (midHeight), 2.0>
   }
    #local  TestSpline2 = spline {
                 natural_spline           
    
                 0.0, <0.0, 0.03, 0>, 
                 0.2+daisyr(0.1), <0, 0.05+(midHeight*0.5), 0.4>,
                 0.5+daisyr(0.1), <0, 0.05+(midHeight*0.5), 1.0>,
                 0.8+daisyr(0.1), <0, 0.04+(midHeight*0.5), 1.6>,
                 1.0, <0, 0.02-(midHeight*0.5), 2.0>
   }
                  
union{ 
 #local lastHeight=0.01;
 
 #local meshStep=detailLevel;

mesh {
    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline(mCount),
            0.5 ((TestSpline(mCount)+TestSpline3(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline3(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline(mCount+meshStep),
            0.5 ((TestSpline(mCount+meshStep)+TestSpline3(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline3(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*2.5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2) 
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>
            }
            triangle { msp2(mCount2),                msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  
/*

    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline3(mCount),
            0.5 ((TestSpline3(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline3(mCount+meshStep),
            0.5 ((TestSpline3(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2)
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
             }
            triangle {    msp2(mCount2),             msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>                        
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  
*/

}   
      
}
#end

#macro mkDaisyFlowerStamen(minBend, maxBend, detailLevel)
    
    #local midHeight=minBend+daisyr(maxBend-minBend);//.2 .3    
    #local endWidth=0.05+daisyr(0.005);   
    #local midWidth=0.075+daisyr(0.005);
    
    
    #local  TestSpline = spline {
                 natural_spline           
    
                 0.0, <-0.05, 0.05, 0>, 
                 0.2, <-(midWidth*0.8), 0.07-(midHeight*0.5), 0.2>,
                 0.5, <-midWidth, 0.07-(midHeight), 0.5>,
                 0.8, <-(midWidth*0.9), 0.1-(midHeight*0.5), 0.8>,
                 0.9, <-endWidth, 0.05+(midHeight), 1.0>
                 1.0, <-endWidth*6, 0.05+(midHeight), 1.0>
   }
 
     #local  TestSpline3 = spline {
                 natural_spline           
    
                 0.0, <0.05, 0.05, 0>, 
                 0.2, <(midWidth*0.8), 0.07-(midHeight*0.5), 0.2>,
                 0.5, <midWidth, 0.07-(midHeight), 0.5>,
                 0.8, <(midWidth*0.9), 0.1-(midHeight*0.5), 0.8>,
                 0.9, <endWidth, 0.05+(midHeight), 1.0>
                 1.0, <endWidth*6, 0.05+(midHeight), 1.0>
   }
    #local  TestSpline2 = spline {
                 natural_spline           
    
                 0.0, <0.0, 0.03, 0>, 
                 0.2, <0.01, 0.02-(midHeight*0.5), 0.2>,
                 0.5, <-0.01, 0.01-(midHeight), 0.5>,
                 0.8, <0.01, 0.01-(midHeight*0.5), 0.8>,
                 0.9, <-0.01, 0.0+daisyr(0.01)+(midHeight), 1.0>
                 1.0, <-endWidth*6, 0.0+daisyr(0.01)+(midHeight), 1.05>
   }

    #local  TestSpline4 = spline {
                 natural_spline           
    
                 0.0, <0.0, 0.03, 0>, 
                 0.2, <0.01, 0.02-(midHeight*0.5), 0.2>,
                 0.5, <-0.01, 0.01-(midHeight), 0.5>,
                 0.8, <0.01, 0.01-(midHeight*0.5), 0.8>,
                 0.9, <-0.01, 0.0+daisyr(0.01)+(midHeight), 1.0>
                 1.0, <endWidth*6, 0.0+daisyr(0.01)+(midHeight), 1.05>
   }
                  
union{ 
 #local lastHeight=0.01;
 
 #local meshStep=detailLevel;

mesh {
    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline(mCount),
            0.5 ((TestSpline(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline(mCount+meshStep),
            0.5 ((TestSpline(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*2.5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2) 
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>
            }
            triangle { msp2(mCount2),                msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+daisyr(0.001)-daisyr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline3(mCount),
            0.5 ((TestSpline3(mCount)+TestSpline4(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline4(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline3(mCount+meshStep),
            0.5 ((TestSpline3(mCount+meshStep)+TestSpline4(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline4(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2)
               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
             }
            triangle {    msp2(mCount2),             msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>                        
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


}   
      
}
#end



#macro mkDaisyFlower()
union {

union {
    #declare pCount=daisyr(5);  
    #while(pCount < 360) 
        #if(daisyr(1) < 0.9) // miss petal if higher
        object { mkDaisyFlowerPetal(0.1, 0.2, 0.1) scale 2 scale 1+daisyr(0.1) rotate <-daisyr(30), 0, 0> translate <0, 0, 1> rotate <0, pCount, 0> }
        #end 
        #declare pCount=pCount+10+daisyr(10);
    #end

        material {
            texture { 
            pigment { uv_mapping gradient y scale 1.5 translate <0, -0.5, 0> triangle_wave omega 0.8 lambda 3 turbulence 0.1
            colour_map { [ 0.0 rgb <0.427, 0.427, 0.427> ] [ 0.8 rgb <0.45, 0.45, 0.45> ] } 
            } 
            finish { specular albedo 0.1 roughness 0.4 brilliance 1.2 diffuse albedo 0.6  }  
            normal { uv_mapping gradient y 1 triangle_wave scale <.02, 1, .02> }
            }
            interior { ior 1.6 } 
            }
        } 
union {
#declare pCount2=30;
#while(pCount2 < 60)
    #declare pCount=daisyr(10);  
    #while(pCount < 360) 
        object { mkDaisyFlowerStamen(0.2-(pCount2*0.002), 0.3-(pCount2*0.003), 0.1) scale 1.5 scale <1+((55-pCount2)*0.01), 1, 0.65+daisyr(0.1)+((55-pCount2)*0.01)> scale 1+daisyr(0.1) translate <0, 0, 2> rotate <-30+(-(pCount2+daisyr(10))), 0, 0> translate <0, -1.75, 0.2> rotate <0, pCount, 0> }
         
        #declare pCount=pCount+16+daisyr(8);
    #end
    #declare pCount2=pCount2+4+daisyr(2);
#end           

        material {
            texture { 
            pigment { uv_mapping gradient y scale 1.5 translate <0, -0.5, 0> triangle_wave omega 0.8 lambda 3 turbulence 0.4
            colour_map { [ 0.0 rgbf <.57, 0.3, 0.01, 0.1> ] [ 0.8 rgb <0.050, 0.20, 0.01> ] } 
            } 
            finish { specular albedo 0.01 roughness 0.1 brilliance 1.8 diffuse albedo 0.6, 0.1  }  
            normal { granite 1 triangle_wave scale 0.015 }
            }
            interior { ior 1.6 } 
            }
        } 
}

#end




#macro mkDaisy(min_stem_bends, max_stem_bends, stem_bend_min, stem_bend_max, stemStep, stemTex, headTex)
union {
// stem 
#local numStemBends=min_stem_bends+(daisyr(max_stem_bends-min_stem_bends));
#local stemBendCount=0;
#local stemBendSteps=1/numStemBends;   
#local stemHeight=70+daisyr(10);
#local stemSpline = spline { natural_spline
#local stemBendDir=1;
                     0, < 0, 0, 0.0>,
    #while(stemBendCount < numStemBends)
        #if(numStemBends = 1) // only 1 bend so randomise the position  
            #local stemBendPos=0.3+daisyr(0.5);
        #else
            #local stemBendPos=(1/(numStemBends+1))*(stemBendCount+1);
        #end
                     #if(stemBendDir)  
                            #local stemBendAmount=stem_bend_min+((stem_bend_max-stem_bend_min)/2)+(daisyr((stem_bend_max-stem_bend_min))/2);
                            #local stemBendDir=stemBendDir*-1;
                        stemBendPos, <(stemBendAmount*stemBendDir), -(stemHeight*stemBendPos),(stemBendAmount*stemBendDir*0.2)>,
                     #end
        #local stemBendCount=stemBendCount+1;
    #end                    
                     1.0, <0, -stemHeight, 0>
} 
#local stemNormal = stemSpline(0.02)-stemSpline(0.0);

#local dPC = 0;
blob {
    threshold 0.6 
    #local stemC = 0;
    #while(stemC < 1-(stemStep*0.9))       
         cylinder { stemSpline(stemC), stemSpline(stemC+stemStep), 1.1, 1 }
         sphere { stemSpline(stemC), 1.1, -1 }
    
        #local stemC=stemC+stemStep;
    #end
    
    material { stemTex }
} 

 
// head
union {
sphere { <0, 0, 0> 2 scale <1, 0.25, 1> 
material { headTex }
}        

object { mkDaisyFlower() scale 1.7+daisyr(0.2) }

    Reorient_Trans(-y, stemNormal)  

} // end of head
    translate <0, stemHeight, 0>   
}

#end





#macro mkDaisyCluster(numFlowers, min_stem_bends, max_stem_bends, min_bend_amount, max_bend_amount, stemStep, numLeaves, minLeafRotation, maxLeafRotation, minLeafBend, maxLeafBend, leafDetail, leafTex, stemTex, headTex)   
union {

#local dlCount=0;             
#local daisyrot=daisyr(360);
#local daisyrotStep=360/(numFlowers);


#local flower=0;
#local totalFlower = 0;
#local totalSeed = 0;

#while(dlCount < numFlowers)                                                                                                                                                  
    #local daisyrot=daisyrot+(daisyrotStep*0.9)+daisyr(daisyrotStep*0.15);
//    object { dl1  scale 0.03+daisyr(0.0025) rotate <0, 180, -(6+daisyr(8))> translate <(0.015+daisyr(0.01)), 0, 0> rotate <0, daisyrot, 0> }
    #local dlCount=dlCount+1;
//    object { dl1  scale 0.03+daisyr(0.0025) rotate <0, 180, -(6+daisyr(8))> translate <(0.015+daisyr(0.01)), 0, 0> rotate <0, daisyrot, 0> }
            object { mkDaisy(
                    min_stem_bends, // min_stem_bends 
                    max_stem_bends, // max_stem_bends
                    min_bend_amount, // minimum amount of bend 
                    max_bend_amount,  // maximum amount of bend
                    stemStep, // stemStep distance between cylinders in the stem decrease if you can see the straight edges  
                    stemTex,
                    headTex
                    ) 
           
     scale 0.03 rotate <-(10+daisyr(10)), 0, 0> translate <0.05, 0, 0> rotate <0, daisyrot, 0> }   

#end
union {
#local dCount=0; 
#local daisyrot=0;
#local daisyrStep=180/numLeaves;
#local daisyrOff=360/numLeaves;
#while(dCount <numLeaves)  
#local daisyrot=daisyrot+daisyrStep+daisyr(daisyrOff);
object { daisyLeaf(minLeafBend,maxLeafBend, leafDetail) scale <1, 1, 0.75>*0.75 translate <0, 0, 0.2> rotate <-(minLeafRotation+daisyr(maxLeafRotation-minLeafRotation)), daisyrot, 0> }// object { lp scale <-1, 1, 1> } 
#local dCount=dCount+1;
#end                   
material { leafTex }
}

}
#end       


