// macros to create a dandelion clock 

#include "transforms.inc"

#declare cTexGeneralRand = seed(11282);   
#declare cGeneralRand = seed(11282);   

// Macro to return a random number

#macro cr(num)
        rand(cGeneralRand)*num
#end

#macro crTex(num)
        rand(cTexGeneralRand)*num
#end


#macro mkCloverLeaf(minBend, maxBend, detailLevel)
    
    #local midHeight=minBend+cr(maxBend-minBend);//.2 .3    
    #local endWidth=0.01+cr(0.01);   
    #local midWidth=0.675+cr(0.05);
    
    
    #local  TestSpline = spline {
                 natural_spline           
    
                 0.0, <-0.05, 0.05, 0>, 
                 0.2+cr(0.1), <-(midWidth*0.75), 0.125+(midHeight*0.5), 0.4>,
                 0.4+cr(0.1), <-(midWidth*1.3+cr(0.0125)), 0.16+(midHeight), 0.8>-cr(0.05),
                 0.8+cr(0.1), <-((midWidth*1.0)+cr(0.0125)), 0.2+(midHeight*0.85)+cr(0.05), 1.85>,
                 1.0, <-endWidth, 0.1+(midHeight), 2.0>
   }
 
     #local  TestSpline3 = spline {
                 natural_spline           
    
                 0.0, <0.05, 0.05, 0>, 
                 0.2+cr(0.1), <(midWidth*0.75), 0.125+(midHeight*0.5), 0.4>,
                 0.4+cr(0.1), <midWidth*1.3+cr(0.0125), 0.16+(midHeight)+cr(0.05), 0.8>,
                 0.8+cr(0.1), <(midWidth*1.0)+cr(0.0125), 0.2+(midHeight*0.85)-cr(0.05), 1.85>,
                 1.0, <endWidth, 0.1+(midHeight), 2.0>
   }
    #local  TestSpline2 = spline {
                 natural_spline           
    
                 0.0, <0.0, 0.03, 0>, 
                 0.2+cr(0.1), <-0.01+cr(0.02), 0.04+(midHeight*0.5), 0.4>,
                 0.4+cr(0.1), <-0.01+cr(0.02), 0.08+(midHeight), 0.8>,
                 0.8+cr(0.1), <-0.01+cr(0.02), 0.1+(midHeight*0.85), 1.6>,
                 1.0, <-0.01+cr(0.02), 0.1+midHeight, 2.0>
   }
                  
union{ 
 #local lastHeight=0.01;
 
 #local meshStep=detailLevel;

mesh {
    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+cr(0.001)-cr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline(mCount),
            0.5 ((TestSpline(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline(mCount+meshStep),
            0.5 ((TestSpline(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*2.5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2) 
                 uv_vectors <msp1(mCount2).x, mCount2>,<msp2(mCount2).x, mCount2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>
//               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>
            }
            triangle { msp2(mCount2),                msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
                uv_vectors <msp2(mCount2).x, mCount2>,<msp2(mCount2+meshStep2).x, mCount2+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>            
//              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


    #local mCount=0;
    #while(mCount < 1)   
     
        #local currentHeight=0.01+cr(0.001)-cr(0.002);  
        
        #local msp1 = spline {
            natural_spline
            0.0 TestSpline3(mCount),
            0.5 ((TestSpline3(mCount)+TestSpline2(mCount))/2)+<0, lastHeight, 0>,
            1.0 TestSpline2(mCount)
        }                          
        
        #local msp2 = spline {
            natural_spline
            0.0 TestSpline3(mCount+meshStep),
            0.5 ((TestSpline3(mCount+meshStep)+TestSpline2(mCount+meshStep))/2)+<0, currentHeight, 0>,
            1.0 TestSpline2(mCount+meshStep)
        }                          
        
        #local mCount2=0;
        #local meshStep2 = detailLevel*2.5;
        
        #while(mCount2 < 1)
            triangle {     msp1(mCount2),             msp2(mCount2),             msp1(mCount2+meshStep2)
                 uv_vectors <msp1(mCount2).x, mCount2>,<msp2(mCount2).x, mCount2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>            
//               uv_vectors <msp1(mCount2).x, mCount>,<msp2(mCount2).x, mCount>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>            
             }
            triangle {    msp2(mCount2),             msp2(mCount2+meshStep2),                       msp1(mCount2+meshStep2) 
              uv_vectors <msp2(mCount2).x, mCount2>,<msp2(mCount2+meshStep2).x, mCount2+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount2+meshStep2>                        
//              uv_vectors <msp2(mCount2).x, mCount>,<msp2(mCount2+meshStep2).x, mCount+meshStep2>,<msp1(mCount2+meshStep2).x,  mCount+meshStep2>                        
            }
            #local mCount2=mCount2+meshStep2;
        #end
        #local mCount = mCount+meshStep;
        #local lastHeight=currentHeight;
    #end  


}   
      
}
#end


#macro mkClover(detailLevel)
union {
    #local pCount=0;  
    
    #local pRot=cr(10);
    #while(pCount < 3)
         
        union { object { mkCloverLeaf(0.15, 0.2, detailLevel) scale <1+cr(0.2), 1, 1+cr(0.1)> scale 1+cr(0.5) rotate <-(5+cr(10)), 0, 0> translate <0, 0, 0.1> }
        
        cylinder { <0, -2, 0> <0, 0, 0.1> 0.1 }
         
        rotate <0, pRot, 0>
        
        }
        sphere { <0, -2, 0> 0.1 }
        cylinder { <0, -8, 0> <0, -2, 0> 0.1 }
         
        #local pRot=pRot+100+cr(20);
        #local pCount=pCount+1;
    #end


       material {
texture
{
        pigment 
        {       
            
                granite  
                triangle_wave 
                turbulence 0.5
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.045, 0.10, 0.0010>*(0.5+crTex(0.5)) ]        //<0.05, 0.08, 0.005>
                        [ 0.85+crTex(0.1) rgb <0.03, 0.08, 0.001>*(0.5+crTex(0.5)) ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.12, 0.135, 0.075>*(0.5+crTex(0.5)) ]
                }
                scale 2
        }
       
    //    finish { phong 0.5 }
} 
texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.01
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.26, 0.3, 0.2, 0.5> ]        //<0.05, 0.08, 0.005>
                        [ 0.08 rgbt <.26, 0.3, 0.2, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.125 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 2
        }
}   

texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.04
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.26, 0.3, 0.2, 0.6> ]        //<0.05, 0.08, 0.005>
                        [ 0.05 rgbt <.26, 0.3, 0.2, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.12 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1
        }
        finish { specular albedo 0.13 roughness 0.03 diffuse albedo 0.5,0.1 brilliance 1.5 reflection { 0.01, 0.04 fresnel on } conserve_energy }
        normal { bumps 0.6 scale 0.0125 }
} 

           interior { ior 1.6 } 
            }
        } 
#end





