     // PoVRay 3.7 Scene File " ... .pov"
// author:  ...
// date:    ...
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"
#include "transforms.inc"     
#include "clover.inc"    
#include "daisy_low_mem.inc"
#include "mesh_moss.inc"  
#include "lillypad2.inc"    
#include "dandelion.inc"


#declare useHDR                 = 1;
#declare useFocalBlur           = 1; // 1-10  used 6  
#declare useRad                 = 0;// 1=load 2=save
#declare radQuality             = 2;// 1-10 1=low 10=high     // norad tood 36 minutes  with rad 2h33m
#declare useSubSurface          = 0; //1-10 used 4
#declare useTestTex             = 0;
#declare showGrass              = 0;     
#declare showTree               = 1;
#declare diffTree               = 0;
#declare showMushroom           = 0;     
#declare showMoss               = 0;    
#declare showDandelions         = 1;
#declare showDaisies            = 0;     
#declare showStones             = 0;
#declare isoAccuracy            = 0.005;  // 0.0005 3m27s    
#declare showWater              = 0;       
#declare grassScale             = 0.75;
#declare grassStep              = 0.9;
#declare showSnow               = 0;  
#declare showLilyPads           = 0;    

global_settings{ assumed_gamma 1.0 }                                                                                                                                 

 
// radiosity (global illumination) settings
global_settings {   
 

#if(useSubSurface)
  mm_per_unit 5 // was 10
  subsurface { samples 10*useSubSurface, 2*useSubSurface radiosity on}// do another render with this on..
#end

#if(useRad)
ambient_light 0
  radiosity {

#if(useRad = 2)
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.0005           // end pretrace at this size
#end
#if(useRad = 1)
    pretrace_start 1           // start pretrace at this size
    pretrace_end   1           // end pretrace at this size
    always_sample off  // 
#end

    count 20*radQuality 75*radQuality                      // higher -> higher quality (1..1600) [35]

    nearest_count 10+(radQuality) 5+radQuality //10+(radQuality/2)               // higher -> higher quality (1..10) [5]

    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
//    maximum_reuse 0.1
    adc_bailout 0.01/2
    error_bound 1.1-(radQuality/10)               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    brightness 1               // brightness of radiosity effects (0..1) [1]
    normal on                  // take surface normals into account [off]

//  media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
#end 
}

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
                           
camera {//perspective angle 90             // front view
                           location  <-3 , 11, -13> //13
                            right     x*image_width/image_height
                            look_at   <-1, 1, 2.9>
                            
#if(useFocalBlur)
  aperture 0.01        // [0...N] larger is narrower depth of field (blurrier)
  blur_samples useFocalBlur*10       // number of rays per pixel for sampling
  focal_point <2.5, 3.5, 1.2> // z=0.5 <3.075, 1, -2.25>
  confidence 0.9+(0.009*useFocalBlur) //0.8999+(useFocalBlur/1000)           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/(20000*useFocalBlur)            // [0...1] how precise to calculate (smaller is more accurate)
#end                            
}

//sphere { <0, 1.25, -0.375> 0.025 pigment { rgb <1, 0, 0> } finish { specular 1 } }
  
#declare generalRand = seed(71282);   

// Macro to return a random number

#macro gr(num)
        rand(generalRand)*num
#end

#declare textureRand = seed(2451);   

// Macro to return a random number

#macro tr(num)
        rand(textureRand)*num
#end
                            
#declare mossGeneralRand = seed(71282);   

// Macro to return a random number

#macro mr(num)
        rand(mossGeneralRand)*num
#end
                            
#declare mushRand = seed(4652);   

// Macro to return a random number

#macro mushr(num)
        rand(mushRand)*num
#end

#declare dGeneralRand = seed(71282);   

// Macro to return a random number

#macro dr(num)
        rand(dGeneralRand)*num
#end


#declare stngeneralRand = seed(25);   

//stone rand

#macro stnr(num)
        rand(stngeneralRand)*num
#end


#declare MyWoodFinish = finish { specular albedo 0.12 roughness 0.2 brilliance 3 diffuse albedo 0.5 }        
#declare MyWoodFinish2 = finish { specular albedo 0.15 roughness 0.1 brilliance 4 diffuse albedo 0.4 }        

#declare MyWoodNormal = normal { average normal_map {  

[ 1 
                        granite 0.5
                        scallop_wave    
                        turbulence 1.5
                        omega 0.7 
                        scale <15, 0.03, 0.05>
                        ]
[0.25 granite  0.5 turbulence 0.3 scale <0.5, 0.045, 0.03> ] 
   [ 0.75 wood 0.3 triangle_wave   omega 0.7 lambda 2.1 
turbulence 0.07 
rotate <1, 92, 1>    
scale <0.5, 0.04, 0.04>   
  ]                              
[ 1.0 dents 0.5 turbulence 0.175 omega 0.75 lambda 3 scale 0.05  ]
[ 0.8 bumps 0.1 turbulence 0.475 omega 0.5 lambda 2.2 scale 0.025  ]
 }     
}

#if(useTestTex)
#declare MyWood = texture {  pigment {rgb 0.5 } }
#else
#declare MyWood = texture {
pigment { 
wrinkles     
omega 0.7                       
turbulence 0.254
lambda 2.45
colour_map {
[ 0.0 rgb <0.235, 0.205, 0.062>*2 ]
[ 0.4 rgb <0.12, 0.104, 0.052>*2 ]
[ 0.7 rgb <0.16, 0.13, 0.052>*2 ]
[ 0.9 rgb <0.22, 0.198, 0.068>*2 ]
[ 1.0 rgb <0.215, 0.175, 0.085>*2 ]   

}   
scale <0.18, 0.18, 1>
rotate <0, 91, 0>
     
} 
}
texture {
pigment { wood triangle_wave   omega 0.7357 lambda 2.1
turbulence 0.0875

color_map {

[ 0.0 rgbt <0.20, 0.14, 0.014, 0.28>*1.0 ]
[ 0.025 rgbt <0.20, 0.16, 0.02325, 0.24>*1.0 ]
[ 0.07 rgbt <0.21, 0.14, 0.018, 0.26>*1.0 ]
[ 0.125 rgbt <0.18, 0.115, 0.015, 0.17>*1.0 ]
[ 0.4 rgbt <0.13, 0.075, 0.0239, 0.084>*1.0 ]
[ 1.0 rgbt <0.11, 0.065, 0.032, 0.24>*1.0 ]   
}  

rotate <0, 0, 0>
rotate <0, 90, 0> 
//  scale <1.5, 1, 1>
scale <1, 0.1, 0.1>
}
} 
texture {
pigment { wood triangle_wave   omega 0.7 lambda 2.1
turbulence 0.0875

color_map {
[ 0.0 rgbt <0.14, 0.08, 0.0164, 0.04>*1.0 ]
[ 0.7 rgbt <0.21, 0.15, 0.022, 0.10>*1.0 ]
[ 0.8 rgbt <0.31, 0.21, 0.041, 0.24>*1.0 ]
[ 0.95 rgbt <0.17, 0.12, 0.0385, 0.04>*1.0 ]
[ 1.0 rgbt <0.11, 0.078, 0.021, 0.24>*1.0 ]
}  
 
rotate <0, -89.5, 0>    
scale <0.7, 0.03, 0.03>   

}
finish { MyWoodFinish }
normal { MyWoodNormal scale 2 }     
} 
texture {
pigment { 
wrinkles     
omega 0.8                      
turbulence 0.854
lambda 2.45
colour_map {
[ 0.0 rgbt <0.235, 0.145, 0.042, 1.7>*0.25 ]
[ 0.4 rgbt <0.12, 0.084, 0.032, 0.15>*0.25 ]
[ 0.7 rgbt <0.16, 0.09, 0.042, 1.3>*0.25 ]
[ 0.9 rgbt <0.22, 0.128, 0.038, 0.2>*0.25 ]
[ 1.0 rgbt <0.215, 0.145, 0.055, 1.7>*0.25 ]   

}   
scale 0.05
     
} 
}                                               
#end // end of useTestTex
                            
// use trace to place an object onto a surface
#macro Place_Object(Surface, Object, Pos, Norm)
    //Allow the user to pass scalars as vectors
    #local Pos = Pos + <0,0,0>;

    //Trace onto the surface
    #local N = <0,0,0>;
    #local SO = trace(Surface, Pos, z, N);

    //Check if we hit the surface
    #if (vlength(N)>0)   
    #warning "Hit"
        //place the object
        object {
            Object
  
            //Adjust the Normal if the user wants us to
            #if (Norm)
                Reorient_Trans(z,N)
            #end

            //Translate to final position
            translate SO
        }
    #else
        #warning "Missed"
    #end
#end // End Macro

#macro Drop_Object(Surface, Object, Pos, Norm)
    //Allow the user to pass scalars as vectors
    #local Pos = Pos + <0,0,0>;

    //Trace onto the surface
    #local N = <0,0,0>;
    #local SO = trace(Surface, Pos, -y, N);

    //Check if we hit the surface
    #if (vlength(N)>0)   
    #warning "Hit"
        //place the object
        object {
            Object
  
            //Adjust the Normal if the user wants us to
            #if (Norm)
                Reorient_Trans(y,N)
            #end

            //Translate to final position
            translate SO
        }
    #else
        #warning "Missed"
    #end
#end // End Macro


// Create an infinite sphere around scene and allow any pigment on it


#if(useHDR)
sphere  { 0 1 hollow
  pigment{
    image_map{ exr "Sky019.exr" //"Portsmouth_Probe.hdr"// "SM_HDRI-Pack3-14.hdr"  // was harbour   Harbour_3_Ref  Japan_blossom_FINAL
               
               map_type 1 interpolate 2 }
                   
               
      }// end pigment        
      finish { ambient 1 diffuse 1 emission 2 } // was emission 2   
      
    scale 4000 // no_image     
    rotate <0, 0, 0>      
    translate <0, 0, 0>
// rotate <0, -10, 0>   
// rotate <10, 0, 0>
// rotate <0, 140, 0>
 rotate <0, 0, 0>  // -140
// rotate <10, 0, -10>
 // no_image
} // end
#end     

#if(useRad)
light_source {
  <0,0,0>             // light's position (translated below)
  color rgb <1, 0.85, 0.6>*0.6 // 0.6      // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <60, 100, -50>   // <x y z> position of light  
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 1000
  fade_power 2

}   
#else
light_source {
  <0,0,0>             // light's position (translated below)
  color rgb <1, 0.85, 0.7>*1       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <60, 100, -50>   // <x y z> position of light  
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 10000
  fade_power 2

}   

#end

// axis 
/*
difference {
union {
cylinder { <-100, 4, 0> <100, 4, 0> 0.2 pigment { rgb <1, 0, 0> } }    
cylinder { <0, 4, -100> <0, 4, 100> 0.2 pigment { rgb <0, 0, 1> } }    
}
union { 
#declare axisd = -50;
#while(axisd < 50)
torus { 0.2, 0.05 rotate <90, 0, 0> translate <0, 4, axisd> }
torus { 0.2, 0.05 rotate <0, 0, 90> translate <axisd, 4, 0> }   
#declare axisd=axisd+1;
#end
}
} 
*/

/*
#declare  mushroomSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.5, <0.035, -0.5, -0.015> 
         1.0, <0, -1, .015> 
       }; 
        
#declare Strength = 1.0; //(+ or -) strength of component's radiating density
#declare Radius1  = 1.0; //(0 < Radius) outer sphere of influence on other components
union {

union {
difference { 

blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  #declare stemC=0;
  #while(stemC < 1)
    
//    sphere{<0, 0, 0>, 0.075+(stemC/15),1 scale <1, 1, 1> translate mushroomSpline(stemC) }
    #declare stemY=0;
        #while(stemY < 180)
        sphere{<0, 0, 0>, 0.075+(stemC/15),1 scale <0.175+mushr(0.15), 1, 1>*(0.75+(sin(stemC*3))) rotate <0, stemY+mushr(5), 0> translate mushroomSpline(stemC) }
        #declare stemY=stemY+10+mushr(5);
        #end
        
    #declare stemC=stemC+0.01;
  #end
 
  //cylinder{<-1.50,0,0>,< -0.25,1.50,0>, Radius1, Strength}
  // sturm 
  scale 1 
}
box { <-0.05, 0, 0.05> <0.05, 0.2, -0.2> translate mushroomSpline(0.85) }
cylinder { <0, 0.2, 0.05> <0, 0.2, -0.2> 0.05 translate mushroomSpline(0.85) }
cylinder { <0, 0, 0> <0, 0.25, 0> 0.14 translate mushroomSpline(0.85) }
}
 

  //cylinder{<-1.50,0,0>,< -0.25,1.50,0>, Radius1, Strength}
  // sturm 
  scale 1 
    texture{ 
        bozo
        turbulence 0.1
        omega 0.5
        lambda 3.5
        texture_map { 
                [ 0.0 mushroomTopTex1 ]
                [ 0.2 mushroomTopTex1 ]
                [ 0.8 mushroomTopTex2 ]
                [ 0.8 mushroomBottomTex ]
                [ 1.0 mushroomBottomTex ]

         }
           scale 0.01
}
*/

#declare tgeneralRand = seed(150);   

// Macros to return a random number

#macro tr(num)
        rand(tgeneralRand)*num
#end


#declare hf1func=function{pigment { agate scale 0.2 }  }   
   

#if(showTree) 
   
#declare treeCutter = height_field{function 350,350 {hf1func(x,0,y).gray }      
  translate <-0.5, 0, -0.5> 
  scale<20, 5, 20>
  rotate<90,0,0>
  translate <0, 0, 0>
} // end of HF_Square ---------------------------------- 


background { colour rgb 0.5 }

#declare treeWidth = 3;

#declare tree1 = blob {  threshold 0.6
#declare treeSpline1  = spline {
     natural_spline
      0, < 0, 15, 0.0>,
     0.7, < -0.5, 5, 0>,
     0.8, < -1, 3.5, 0>,
     1.0, < -6, -1, 0>
 }   

    #declare tp = 0;
    #while(tp < 0.7)
            sphere { 0, (1.5+tr(0.5))-(tp*0.1), 1 translate treeSpline1(tp) translate <-(treeWidth), 0, 0> rotate <0, 0+tr(2), 0> }
            #declare tp=tp+0.01;
    #end 

    #while(tp < 1)
            sphere { 0, (1.75+tr(0.25))-(tp*0.5), 1 translate treeSpline1(tp) translate <-(treeWidth), 0, 0> rotate <0, 0+tr(2), 0> }
            #declare tp=tp+0.005;
    #end  


#declare treeSpline2  = spline {
     natural_spline
      0, < 0, 15, 0.0>,
     0.7, < -0.5, 5, 0>,
     0.8, < -1, 3.5, 0>,
     1.0, < -4, -2, 0>
 }   

    #declare tp = 0;
    #while(tp < 0.7)
            sphere { 0, (1.5+tr(0.5))-(tp*0.1), 1 translate treeSpline2(tp) translate <-(treeWidth), 0, 0> rotate <0, -10+tr(2), 0> }
            #declare tp=tp+0.01;
    #end  
    #while(tp < 1)
            sphere { 0, (1.75+tr(0.25))-(tp*0.5), 1 translate treeSpline2(tp) translate <-(treeWidth), 0, 0> rotate <0, -10+tr(2), 0> }
            #declare tp=tp+0.005;
    #end  
    
#declare treeSpline3  = spline {
     natural_spline
      0, < 0, 15, 0.0>,
     0.7, < -0.5, 5, 0>,
     0.8, < -1, 3.5, -0.75>,
     1.0, < -4, -2, -0.25>
 }   

    #declare tp = 0;
    #while(tp < 0.7)
            sphere { 0, (1.5+tr(0.5))-(tp*0.1), 1 translate treeSpline3(tp) translate <-(treeWidth), 0, 0> rotate <0, -50+tr(2), 0> }
            #declare tp=tp+0.01;
    #end 

    #while(tp < 1)
            sphere { 0, (1.75+tr(0.25))-(tp*0.5), 1 translate treeSpline3(tp) translate <-(treeWidth), 0, 0> rotate <0, -50+tr(2), 0> }
            #declare tp=tp+0.005;
    #end  

  
    #declare tp2=-70;
    #while(tp2 > -360)

#declare treeSpline4  = spline {
     natural_spline
      0, < 0, 15, 0.0>,
     0.7, < -0.25, 5, 0>,
     0.8, < -0.5, 3.5, -0.1>,
     1.0, < -(2+tr(2)), -2, 0.1>
 }   
  
    #declare tp = 0;
    #while(tp < 0.7)
            sphere { 0, (1.5+tr(0.5))-(tp*0.1), 1 translate treeSpline4(tp) translate <-(treeWidth), 0, 0> rotate <0, tp2+tr(2), 0> }
            #declare tp=tp+0.01;
    #end 

    #while(tp < 1)
            sphere { 0, (1.75+tr(0.25))-(tp*0.2), 1 translate treeSpline4(tp) translate <-(treeWidth), 0, 0> rotate <0, tp2+tr(2), 0> }
            #declare tp=tp+0.005;
    #end  
    #declare tp2=tp2-(15+tr(10));
    #end 
    
}


    // bark lines 
    
/*vtransform(<0, 1, 0>, transform { rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0>})
               vtransform(<0, 1, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) 0.05 }    
*/
/*   #declare barkLineTex = texture { 
    pigment { bozo turbulence 1 color_map { [ 0.0 rgb <0.1, 0.08, 0.06> ] [ 1.0 rgb <0.04, 0.05, 0.02> ] } scale 0.1 omega 0.9 lambda 3 }  
    normal { agate 0.5 turbulence 0.4 scale <0.25, 0.6, 0.25>   }
    }

    #declare tp2 = 0;
    #while(tp2 < 360)
    #declare tp = 0.05;
    #declare nextPos=<-1.55, 0, 0>+treeSpline1(0);
    #while(tp < 0.7)  
                sphere { 0, (0.25+tr(0.15)),1 scale <.5, 2, 1> translate <-(1.25+tr(0.1)), 0, 0>+<-(treeWidth), 0, 0>+treeSpline1(tp) rotate <0, tp2+tr(2), 0> }//ture { barkLineTex }  }
            #declare tp=tp+0.05+tr(0.03);
    #end  
    #declare tp2=tp2+3+gr(1);
    #end                                        
*/
 
/*
union {
    #declare tp = 0;
    #while(tp < 1)
            sphere { <0, 0, 0> (0.1+tr(0.1)) scale <0.4, 1, 1> translate <-1.4, 0, 0>+treeSpline1(tp) translate <-(treeWidth), 0, 0> rotate <0, 0+tr(2), 0> }
            #declare tp=tp+0.02;
    #end  
    pigment { rgb <1, 0, 0> }

}
*/ 

#declare treeDirt = texture {
pigment { wrinkles scallop_wave omega 0.8 lambda 2.8 turbulence 0.395 colour_map { 
            [ 0.0 rgbt <1, 1, 1, 1> ]
            [ 0.4 rgbt <1, 1, 1, 1> ]
            [ 0.4 rgbt <0.095, 0.074, 0.0113, 1> ]
            [ 0.41 rgbt <0.095, 0.174, 0.0113, 0.2> ]
            [ 0.52 rgbt <0.045, 0.034, 0.0053, 0.15> ]
            [ 0.6 rgbt <0.055, 0.144, 0.0083, 0.15> ]
            [ 0.89 rgbt <0.095, 0.074, 0.0113, 1> ]
            [ 0.9 rgbt <1, 1, 1, 1> ]
            [ 1.0 rgbt <1, 1, 1, 1> ]
            
         }
          scale 0.275
        }              
        
finish {  ambient 0 diffuse albedo 0.5 brilliance 2.0 } 
normal { granite 0.9 scale 0.015 }
}
texture {
pigment {
            granite 
            turbulence 0.225
            lambda 3.1
            omega 0.725
            octaves 9
            colour_map {
                [ 0.0 rgbt 1 ]
                [ 0.2 rgbt 1 ]
                [ 0.2 rgbt <0.1, 0.08, 0.01, 1> ]
                [ 0.51 rgbt <0.1, 0.07, 0.01, 0.15> ]
                [ 0.75 rgbt <0.1, 0.22, 0.01, 0.15> ]
                [ 0.76 rgbt <0.1, 0.18, 0.01, 0.11> ]
                [ 0.9 rgbt <0.1, 0.25, 0.01, 0.11> ]
                [ 0.91 rgbt <0.1, 0.07, 0.02, 1> ]
                [ 0.91 rgbt 1 ]
                [ 1.0 rgbt 1 ]
            }        
            scale 0.1
         }
normal { wrinkles 1 scale 0.01 }
finish {  ambient 0 diffuse albedo 0.4 brilliance 1.4 }
} 

#declare treeWoodTex = texture { 
pigment { bozo omega 0.7 lambda 3 turbulence 1 colour_map { [ 0.0 rgb <0.3, 0.27, 0.23> ] [1.0 rgb <0.235, 0.2, 0.16> ] } scale <0.25, 1.0, 0.25> }
finish { specular albedo 0.05 roughness 0.2 diffuse albedo 0.7 brilliance 0.9 }
}
texture { 
pigment { wood omega 0.7 lambda 2.3 turbulence .0175 colour_map { [ 0.0 rgbt <0.27, 0.16, 0.06, 0.8> ] [0.8 rgbt <0.15, 0.07, 0.026, 0.6> ] [ 1.0 rgbt <0.15, 0.085, 0.023, 0.25> ] } rotate <92, 0, 2> scale <3, 0.5, 3> }
finish { specular albedo 0.05 roughness 0.2 diffuse albedo 0.7 brilliance 0.9 }
normal { granite 0.5 turbulence 0.4 scale <0.25, 0.8, 0.25> omega 0.8 }
}
texture { 
pigment { wrinkles  omega 0.75 lambda 3.3 turbulence .275 colour_map { [ 0.0 rgbt <0.25, 0.19, 0.09, 0.8> ] [0.6 rgbt <0.185, 0.09, 0.046, 0.6> ] [ 0.9 rgbt <0.16, 0.075, 0.043, 0.25> ] } rotate <92, 0, 2> scale <.025, 1.0, .025> }
finish { specular albedo 0.05 roughness 0.3 diffuse albedo 0.7 brilliance 0.9 }
normal { agate 1.5 agate_turb 0.8 scale <0.25, 1.2, 0.25> omega 0.8 }
}
//texture { treeDirt }
//texture { treeDirt scale 0.5 }

#declare FinalTree = union { 
#if(diffTree)
difference { 
//object { tree1 scale 1.0225 }
//object { tree1 scale 1.009 }

object { tree1 scale 1.0225 }
object { tree1 scale 1.017 }
object { treeCutter  rotate <0, 30, 0> rotate <-80, 0, -10> translate <-9.6, 1.5, -1.5>    }
}
difference {
object { tree1 scale 1.017001 }
object { tree1 scale 1.005 }                                             // was 3
object { treeCutter  rotate <0, 30, 0> rotate <-80, 0, -10> translate <-9.6, 1.5, -1.5> texture { pigment { 
    wrinkles turbulence 0.3 omega 0.75 lambda 2.75 scale 0.4 colour_map { [ 0.0 rgb <0.15, 0.08, 0.04>*0.75 ] [ 1.0 rgb <0.25, 0.195, 0.13>*1.5 ] } }
       finish { specular albedo 0.05 roughness 0.3 diffuse albedo 0.7 brilliance 0.9 } 
       normal { granite 1.5 scale 0.1 }
    }
    }
}

object { tree1 
#if(useTestTex)
texture {
pigment {rgb 0.5 }
}
#else
texture {
        pigment {uv_mapping image_map { jpeg "tree_bark4.jpg" map_type 0 } scale 5 translate <0, -1.5, 0> }// granite turbulence 1 color_map { [ 0.0 rgb <0.065, 0.04, 0.030> ] [ 1.0 rgb <0.04,0.05, 0.03> ] } scale 0.1 omega 0.9 lambda 3 }  
        finish { specular albedo 0.05 roughness 0.3 diffuse albedo 0.55 brilliance 1.1 } 

        normal { uv_mapping //crackle 1 turbulence 0.4 omega 0.7 scale <0.25, 0.6, 0.25>  }  
        // texture normal {} attribute
// create a texture that has a bumpiness corresponding to color index
// image maps into X-Y plane from <0,0,0> to <1,1,0>
bump_map { // uses image color or index as bumpiness
  jpeg "tree_bark4.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
       // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // once           // for no repetitive tiling
  // [use_color | use_index]
  bump_size 2     // 0...3
}
 scale 5     
 translate <0, -1.5, 0>


}
}
texture { treeDirt }  
#end
//texture { treeDirt scale 0.5 }
}   
#else
object { tree1 scale 1.0225 }

#end  
#if(useTestTex)
texture {
pigment {rgb 0.5 }
}
#else
texture {
        pigment {uv_mapping image_map { jpeg "tree_bark2.jpg" map_type 0 } scale 5 }// granite turbulence 1 color_map { [ 0.0 rgb <0.065, 0.04, 0.030> ] [ 1.0 rgb <0.04,0.05, 0.03> ] } scale 0.1 omega 0.9 lambda 3 }  
        finish { specular albedo 0.05 roughness 0.1 diffuse albedo 0.5 brilliance 1.75 } 

        normal { uv_mapping //crackle 1 turbulence 0.4 omega 0.7 scale <0.25, 0.6, 0.25>  }  
        // texture normal {} attribute
// create a texture that has a bumpiness corresponding to color index
// image maps into X-Y plane from <0,0,0> to <1,1,0>
bump_map { // uses image color or index as bumpiness
  jpeg "tree_bark2.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
       // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // once           // for no repetitive tiling
  // [use_color | use_index]
  bump_size 0.25     // 0...3
}
 scale 4
}
}
texture { treeDirt }
#end
    
}     
// add some moss

object { FinalTree
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }

#if(showMoss)



#declare mossTexDirt = texture
{
        pigment 
        {    
                wrinkles 
                triangle_wave 
                turbulence 0.75
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.04, 0.03, 0.001> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.025, 0.018, 0.005> ]
                }
                scale 0.01
                translate <0, -1, 0>                          
        }
        
        finish { specular albedo 0.01 roughness 0.1 diffuse albedo 0.4 brilliance 2.5 }
        normal { granite 0.5 scale 0.05 }
    //    finish { phong 0.5 }
}

#if(useTestTex) 
#declare mossTex1 = texture { pigment { rgb 0.5 } }
#else
#declare mossTex1 = texture
{
        pigment 
        {    
                wrinkles 
                triangle_wave 
                turbulence 0.75
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.08, 0.13, 0.020> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.13, 0.19, 0.023> ]
                }
                scale 0.01
                translate <0, -1, 0>                          
        }
        
        finish { specular albedo 0.2 roughness 0.05 diffuse albedo 0.4, 0.1 brilliance 2.5 }
        normal { bumps scale 0.025 }
    //    finish { phong 0.5 }
}   
texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.01
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.05, 0.02, 0.001, 0.25> ]        //<0.05, 0.08, 0.005>
                        [ 0.08 rgbt <.04, 0.02, 0.001, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.125 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 2
        }
}   
texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.04
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.04, 0.02, 0.002, 0.4> ]        //<0.05, 0.08, 0.005>
                        [ 0.05 rgbt <.03, 0.02, 0.002, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.12 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1
        }
        finish { specular albedo 0.13 roughness 0.03 diffuse albedo 0.5,0.1 brilliance 1.5 reflection { 0.01, 0.04 fresnel on } conserve_energy }
        normal { bumps 0.6 scale 0.0125 }
} 
#end

#declare mossTex2 = texture
{
        pigment 
        {    
                wrinkles 
                triangle_wave 
                turbulence 0.75
                omega 0.75
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.09, 0.15, 0.016> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.12, 0.19, 0.019> ]
                }
                scale 0.01
                translate <0, -1, 0>                          
        }
        
        finish { specular albedo 0.2 roughness 0.08 diffuse albedo 0.4, 0.1 brilliance 2.5 }
        normal { bumps scale 0.025 }
    //    finish { phong 0.5 }
}


#declare moss1=mkMoss(0.1);
#declare moss2=mkMoss(0.1);
#declare moss3=mkMoss(0.1);
#declare moss4=mkMoss(0.1);
#declare moss5=mkMoss(0.1);
#declare moss6=mkMoss(0.1);
#declare moss7=mkMoss(0.1);
#declare moss8=mkMoss(0.1);
#declare moss9=mkMoss(0.1);
#declare moss10=mkMoss(0.1);
         
         
#declare mosses = array [10] { 
moss1,
moss2,
moss3,
moss4,
moss5,
moss6,
moss7,
moss8,
moss9,
moss10 }   


#declare  F_BumpsA= function { pigment{wrinkles turbulence 0.495 omega 0.7 lambda 4 scale 0.25} }
#declare  F_Moss_BumpsB= function { pigment{spherical turbulence 0.15 omega 0.7 lambda 4 scale <10, 7, 5> translate <3, 3, 1>} }


#macro Add_Moss(landSurface, reorient, sVect, eVect, gSize, gSpace, gRandSpace, gRandSize, mTex)
               
        #local objStartPos = sVect;
        #local objEndPos = eVect;   
        #local gZPos=sVect.z;
        #local gYPos=sVect.y;       

        #local gXEnd=eVect.x;
        #local gZEnd=eVect.z;     
        #local cCount=0;
        
        #local gXPos = sVect.x;
        #declare percentDone = -1;     
        #local startOffVal=1;
        #local endOffVal = 1; 
        #local gzOffsetStart = 0;
        #local gzOffsetEnd = 0;
        union
        {
        #while(gXPos < gXEnd)     

                #if(floor(((gXPos-sVect.x)/(gXEnd-sVect.x))*100) > percentDone)  
                        #declare percentDone=floor(((gXPos-sVect.x)/(gXEnd-sVect.x))*100);
                        #warning concat(concat(concat(str(percentDone, 3, 1), "% Done. "), str(cCount,0,0)), " clumps.")
                #end      
                
 
                #if(startOffVal > 0)
                    #local gzOffsetStart = gzOffsetStart+mr(gRandSpace*5);
                    #if(gzOffsetStart > (gRandSpace*10))
                        #local startOffVal = -1;
                    #end    
                #else
                    #local gzOffsetStart = gzOffsetStart-mr(gRandSpace*5);
                    #if(gzOffsetStart < -(gRandSpace*10))
                        #local startOffVal = 1;
                    #end    
                #end

                
                #if(endOffVal > 0)
                    #local gzOffsetEnd = gzOffsetEnd+mr(gRandSpace*5);
                    #if(gzOffsetEnd > gRandSpace*10)
                        #local endOffVal = -1;
                    #end    
                #else
                    #local gzOffsetEnd = gzOffsetEnd-mr(gRandSpace*5);
                    #if(gzOffsetEnd < -(gRandSpace*10))
                        #local endOffVal = 1;
                    #end    
                #end

                
                #local gZPos=sVect.z-gzOffsetStart;
                #local gZEnd=eVect.z+gzOffsetEnd;     

                #while(gZPos < gZEnd)

                        #local N = <0,0,0>;                                                          
                        
                        #local grassPos=<gXPos+mr(gRandSpace), gYPos, gZPos>;
                        #local S = trace(landSurface, grassPos, <0, -1, 0>, N); 

                        #if(vlength(N) > 0) // hit       

                                #if(F_BumpsA(grassPos.x, 0.5, grassPos.z).red+F_Moss_BumpsB(grassPos.x, 0.5, grassPos.z).red > 1)
//                                #if(F_Moss_BumpsB(grassPos.x, 0.5, grassPos.z).red > 0.5)
                                    object { mosses[mr(10)] scale <gSize+mr(gRandSize), gSize+mr(gRandSize*2.5), gSize+mr(gRandSize)>  rotate <mr(10), mr(360), 0> Reorient_Trans(reorient,N) translate S } 
                                #end
                                #declare cCount=cCount+1;
                        #end
                                        
                       
                    #local gZPos=gZPos+gSpace+mr(gRandSpace);
                #end                                       
                #local gXPos=gXPos+(gSpace)+mr(gRandSpace);
        
        #end
        
        }


        #if(cCount = 0)
                #warning "add_moss Error: no moss has hit the object try using different direction or start/end pos for moss!"
        #end   
        #warning concat("Total: ", str(cCount,1,0), " moss clumps used")      
                material {
                texture 
                {    
                        mTex  
                }
                 interior { ior 1.5 }
                }
        
        
        

#end // End Mac                          

//#macro Add_Moss(landSurface,                                       reorient, sVect,          eVect,         gSize, gSpace,     gRandSpace, gRandSize,   mossTex)
/*
object { Add_Moss(object { tree1  scale 1.0225 rotate <0, 0, -90> }, true,     <1, 10, -3.25>, <6, 10, -2.2>, 0.01,   0.01,       0.01,        0.02,         mossTex )
    rotate <0, 0, 90> 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }

object { Add_Moss(object { tree1  scale 1.0225 rotate <0, 0, -90> }, true,     <2, 10, 0>,     <6, 10, 2>,    0.01,   0.015        0.02,        0.022, mossTex)
    rotate <0, 0, 90> 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }
*/
 
//object { Add_Moss(object { tree1  scale 1.0225 rotate <0, 0, -90> }, true,     <1.25, 10, -3.5>,<6, 10, 2>,   0.01, 0.015,       0.015,       0.005, mossTex1, mossTex2, mossTex3)

/*
object { Add_Moss(object { FinalTree  rotate <0, 0, -90> }, true,     <0.25, 10, -4.5>,<7, 10, 2>,   0.0175, 0.01,       0.01,       0.01, mossTex1, mossTexDirt)
    rotate <0, 0, 90> 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }

object { Add_Moss(object { FinalTree  rotate <0, 0, -90> }, true,     <0.25, 10, -4.5>,<7, 10, 2>,   0.0175, 0.015,       0.01,       0.01, mossTex2, mossTexDirt)
    rotate <0, 0, 90> 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }
*/

//#macro Add_Moss(landSurface, reorient, sVect, eVect, gSize, gSpace, gRandSpace, gRandSize, mTex)    //0.02                         //0.01
object { Add_Moss(object { FinalTree  rotate <0, 0, -90> }, true,     <0.25, 10, -3.25>,<7, 10, 2.5>,   0.02, 0.02,       0.015,       0.01, mossTex1)
    rotate <0, 0, 90> 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
 }

#end

#end // end of showTree

// ground
// ground -------------------------------------------------------------------
//---------------------------------------------------------------------------
 // ----------------- HF_Square macro ------------------                          
 

#local sfunc=function{pigment { average pigment_map { 
//[0.35 granite colour_map { [ 0.0 rgb 0] [ 1.0 rgb 1 ] } turbulence 0.1  ]
[ 0.1 wrinkles  colour_map { [ 0.0 rgb 0] [ 1.0 rgb 1 ] } turbulence 0.0375  scale 0.5  ]
[ 0.3 spherical sine_wave  colour_map { [ 0.0 rgb 0] [ 1.0 rgb 0.85 ] } turbulence 0.31 scale 0.35 translate <0.6, 0, 0.2> ]
[ 0.9 spherical ramp_wave colour_map { [ 0.0 rgb 1] [ 1.0 rgb 0 ] } turbulence 0.35 scale <0.8, 0.75, 0.75>*1.5 translate <-0.5, 0, 1.1> ]

   } 
     }
   }   
// water
#if(showWater)
box { <-100, -10, -3> <0, 3.0, 35> 
#if(useTestTex)
texture {
pigment { rgbt <0.95, 0.97, 0.96, 1> }//.05 was value                                                       // was 0.5
}
#else
material {
texture {
pigment { rgbt <0.95, 0.97, 0.96, 1> }//.05 was value                                                       // was 0.5
normal { average normal_map {
 [ 0.05 
 ripples 0.1 frequency 8 scale 1.2 omega 0.6 turbulence 0.2] [ 0.1 wrinkles 0.05 scale 1.5 turbulence 0.2 omega 0.7 lambda 5
  ] } 
 }
finish { specular albedo 0.3 roughness 0.005 diffuse albedo 0.01 brilliance 5 ambient 0 reflection { 0.01, 0.5  fresnel on } conserve_energy }     
}
  interior {
    ior 1.31              // index of refraction
/*    fade_power 1001    // values larger than 1000 give realistic exponential attenuation
    fade_distance 0.5    // distance where light reaches half intensity
    fade_color <0.05, 0.1, 0.08, 0.5> // color for fading        
*/
  media {
    scattering { 
      2 <0.5, 0.65, 0.4> 
      extinction 2
    }
    }
  media {
    absorption <0.8, 0.6, 1.0, 0.5>
  }    


}
}
#end
       
/*
          material
          {    
                texture { 
                        pigment 
                        {
                                rgbt <0.85, 0.855, 0.852, 0.95>
                        }                                  
                        finish { specular albedo 0.3 roughness 0.01 diffuse albedo 0.01 ambient 0.0   brilliance 3 reflection { 0.01, 0.8 fresnel on  } conserve_energy }
                        normal { average normal_map { [ 0.1 ripples 0.1 frequency 4 scale 0.1 omega 0.7 turbulence 0.3] [ 0.05 bumps 0.1 scale 0.2 turbulence 0.1 ] } }
                }

                interior 
                {
                        ior 1.31
                       // dispersion 1.01
                       // dispersion_samples 20    
                        fade_distance 1
                        fade_power 1001
     //                   fade_color <0.0, 0.0, 0.0>
                }     
        }     
        */
   
}
#end 
 
#declare Ground1 = //height_field{
//    function 250,250 { sfunc(x, y, z).gray*1//+f_ridged_mf(x*8, y*0,z*4, 1.2,3,8,1.18,5,1)*0.15 
       
  //  } 
object{ HF_Square( function { sfunc(x, y, z).gray*0.8}, //Function,
                     0, // UseUVheight:  0 or 1
                     1, // UseUVtexture: 0 or 1
               <100,100>, // Resolution,
                     1, // Smooth: 0 or 1
                     "",// FileName, ""=no file,
           <-1,0,-1>*2, //MnExt,
           <1,1,1>*2    //MxExt
                      ) //------------------------------ 

} // end of HF_Square ---------------------------------- 

#declare Ground = union { object { Ground1 }
object { Ground1 scale <1, 1, -1> translate <0, 0, 4>  }   
object { Ground1 scale <-1, 1, 1> translate <4, 0, 0>  }   
object { Ground1 scale <-1, 1, -1> translate <4, 0, 4>  }   


  translate <-0.5, 0, -0.5>  
  scale<24,5,20>*1
  rotate<-2,0,-2>
  translate<-1.5,-3,8>
#if(useTestTex)
texture { pigment { rgb 0.5 } }
#else
  texture{ pigment { 
  granite omega 0.85 lambda 4 turbulence 0.7 colour_map {
                [ 0.0 rgb <0.05, 0.034, 0.01> ]
                [ 0.4 rgb <0.02, 0.015, 0.004> ]
                [ 0.6 rgb <0.05, 0.02, 0.005> ]
                [ 0.8 rgb <0.02, 0.01, 0.003> ]
                [ 1.0 rgb <0.05, 0.03, 0.009> ]
                
            }  
            }
            finish { specular  0.05 roughness 0.5 diffuse albedo 0.5 brilliance 2 }
            normal { granite 0.5 scale 0.0075 turbulence 0.2 }
         } // end of texture
#end
}



#if(useTestTex)
#declare bladeTex = texture   { pigment { rgb 0.5 } }
#declare bladeTexGreen = texture   { pigment { rgb 0.25 } }
#else
#declare bladeTex = texture
{
        pigment 
        {       
            uv_mapping
                gradient x   
                triangle_wave 
                turbulence 0.5
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.065, 0.14, 0.004> ]        //<0.05, 0.08, 0.005>
                        [ 0.7 rgb <0.115, 0.165, 0.004> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.19, 0.14, 0.005> ]
                }
                scale 0.05
        }
        
    //    finish { phong 0.5 }
} 
texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.1
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.25, 0.1, 0.05, 0.1> ]        //<0.05, 0.08, 0.005>
                        [ 0.4 rgbt <.25, 0.1, 0.05, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.5 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1
        }
}   
texture
{
        pigment 
        {       
        uv_mapping
                wrinkles   
                triangle_wave 
                turbulence 0.1
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <0.075, 0.04, 0.01, 0.1> ]        //<0.05, 0.08, 0.005>
                        [ 0.3 rgbt <0.175, 0.12, 0.04, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.3 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1.2
        }
        finish { specular albedo 0.1 roughness 0.075 diffuse albedo 0.5,0.2 brilliance 2 reflection { 0.009, 0.05 fresnel on } conserve_energy}
        normal { bumps scale 0.0125 }
}   


#declare bladeTexGreen = texture
{

        pigment 
        {       
            uv_mapping
                gradient x   
                triangle_wave 
                turbulence 0.5
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgb <0.065, 0.14, 0.005> ]        //<0.05, 0.08, 0.005>
                        [ 0.7 rgb <0.07, 0.14, 0.005> ]        //<0.05, 0.08, 0.005>
                        [ 1.0 rgb <0.11, 0.14, 0.006> ]

                }
                scale 0.05
        }
/*
pigment {
                granite   
                triangle_wave 
                turbulence 0.5
                omega 0.76
                lambda 2.25
                colour_map
                {    
                #declare gt1 = 0;
                #while(gt1 < 1)
                        [ gt1 rgb <0.075+tr(0.045), 0.125+tr(0.05), 0.006+tr(0.006)>*(0.7+tr(0.4)) ]        //<0.05, 0.08, 0.005>
                    #declare gt1=gt1+0.05;
                #end
                }
                scale 0.1   
                }        
*/
    //    finish { phong 0.5 }
}  
texture
{
        pigment 
        {        
            uv_mapping
                gradient y   
                triangle_wave 
                turbulence 0.1
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <.125, 0.1, 0.05, 0.1> ]        //<0.05, 0.08, 0.005>
                        [ 0.4 rgbt <.125, 0.1, 0.05, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.5 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1
        }
}   
texture
{
        pigment 
        {       
        uv_mapping
                wrinkles   
                triangle_wave 
                turbulence 0.1
                omega 0.65
                lambda 2.25
                colour_map
                {
                        [ 0.0 rgbt <0.025, 0.06, 0.01, 0.1> ]        //<0.05, 0.08, 0.005>
                        [ 0.3 rgbt <0.085, 0.12, 0.025, 1> ]        //<0.05, 0.08, 0.005>
                        [ 0.3 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 1.2
        }
        finish { specular albedo 0.1 roughness 0.075 diffuse albedo 0.5,0.2 brilliance 2 reflection { 0.009, 0.05 fresnel on } conserve_energy}
        normal { bumps scale 0.0125 }
}
#end

#macro mkGrass(numBlades)                   

    #local bladeCount=0;   
    
    mesh {   
    
    #while(bladeCount < numBlades)  
        #local yRotate = <0, gr(360), 0>;
        #local xRotate = <gr(60), 0, 0>;
    
        #local gTop = vrotate(vrotate(<-0.1+gr(0.2), 1.0+gr(0.3), 0.1+gr(0.4)>, xRotate), yRotate); 
        #local gMiddle = vrotate(vrotate(<-0.05+gr(0.1), 0.5+gr(0.2), (gr(0.1)-gr(0.15))>, xRotate), yRotate);
        #local gWidth1 = 0.01+gr(0.03);
        #local gWidth2 = 0.01+gr(0.02); 
        #local gWidth3 = 0.00+gr(0.01);
        #local gDepth=0.005+gr(0.02); 
        
        #local  grassSpline = spline {
                 natural_spline
                 0.00, <0, 0.0, 0>
                 0.5, gMiddle 
                 1.0, gTop
               };   
        
        #local  grassSplineLeft = spline {
                 natural_spline
                 0.00, <-gWidth1, 0.0, -(gDepth/2)>
                 0.5, gMiddle-<gWidth2, 0, -gDepth> 
                 1.0, gTop-<gWidth3, 0, 0> 
               };   
        
        #local  grassSplineRight = spline {
                 natural_spline
                 0.00, <gWidth1, 0.0, -(gDepth/2)>
                 0.5, gMiddle+<gWidth2, 0, -gDepth> 
                 1.0, gTop+<gWidth3, 0, 0> 
               };   
        #local gpDetail=0.01;
    
    //#declare grass = union {
    
        mkGrassBlade(grassSpline, grassSplineLeft, grassSplineRight, gpDetail, xRotate, yRotate)
        #local bladeCount=bladeCount+1;
    #end
      

    }
#end 

#macro mkGrassBlade(grassSpline, grassSPlineLeft, grassSplineRight, gpDetail, xRotate, yRotate)

    #local bTex = texture { bladeTex rotate <xRotate.x, yRotate.y, 0> }
    
    #local gp = 0;
    #while(gp < 1)
            triangle { grassSpline(gp), grassSplineLeft(gp), grassSpline(gp+gpDetail) 
            uv_vectors <0, gp>,<grassSplineLeft(gp).x, gp>,<0,  gp+gpDetail >

            }//texture { bTex } }
            triangle { grassSpline(gp+gpDetail), grassSplineLeft(gp), grassSplineLeft(gp+gpDetail) 
            uv_vectors <0, gp+gpDetail>,<grassSplineLeft(gp).x, gp>,<grassSplineLeft(gp+gpDetail).x, gp+gpDetail >
           }//texture { bTex }}
    
            #local gp=gp+gpDetail;
    #end
//            triangle { grassSpline(0.2), grassSplineLeft(0.2), grassSpline(0.4) }
//            triangle { grassSpline(0.4), grassSplineLeft(0.2), grassSplineLeft(0.4) }
                       

    #local gp = 0;
    #while(gp < 1)
            triangle { grassSpline(gp), grassSplineRight(gp), grassSpline(gp+gpDetail)
            uv_vectors <0, gp>,<grassSplineRight(gp).x,gp>,<0, gp+gpDetail>

            }// texture { bTex }}
            triangle { grassSpline(gp+gpDetail), grassSplineRight(gp), grassSplineRight(gp+gpDetail) 
            uv_vectors <0, gp+gpDetail>,<grassSplineRight(gp).x, gp>,<grassSplineRight(gp+gpDetail).x, gp+gpDetail>

            }//texture { bTex }}
    
            #local gp=gp+gpDetail;
    #end
//            triangle { grassSpline(0.2), grassSplineLeft(0.2), grassSpline(0.4) }
//            triangle { grassSpline(0.4), grassSplineLeft(0.2), grassSplineLeft(0.4) }
#end


#if(showGrass)

#declare grass1 = union { 
#declare gUnique=0; 
#while(gUnique < 8)
#declare grass = object { mkGrass(30) }
#declare gc=0;
#while(gc < 2)     
object { grass scale 0.25+gr(0.1) rotate <gr(1), gr(360), gr(1)> translate <-0.1+gr(0.2), 0, -0.1+gr(0.2)> }
#declare gc=gc+1;
#end
#declare gUnique=gUnique+1;
#end

         rotate 90*y } 
#declare grass2 = union { 
#declare gUnique=0; 
#while(gUnique < 8)
#declare grass = object { mkGrass(27) }
#declare gc=0;
#while(gc < 2)     
object { grass scale 0.25+gr(0.1) rotate <gr(1), gr(360), gr(1)> translate <-0.1+gr(0.2), 0, -0.1+gr(0.2)> }
#declare gc=gc+1;
#end
#declare gUnique=gUnique+1;
#end

         rotate 90*y } 
#declare grass3 = union { 
#declare gUnique=0; 
#while(gUnique < 8)
#declare grass = object { mkGrass(23) }
#declare gc=0;
#while(gc < 2)     
object { grass scale 0.25+gr(0.1) rotate <gr(1), gr(360), gr(1)> translate <-0.1+gr(0.2), 0, -0.1+gr(0.2)> }
#declare gc=gc+1;
#end
#declare gUnique=gUnique+1;
#end

         rotate 90*y } 
#declare grass4 = union { 
#declare gUnique=0; 
#while(gUnique < 8)
#declare grass = object { mkGrass(20) }
#declare gc=0;
#while(gc < 2)     
object { grass scale 0.25+gr(0.1) rotate <gr(1), gr(360), gr(1)> translate <-0.1+gr(0.2), 0, -0.1+gr(0.2)> }
#declare gc=gc+1;
#end
#declare gUnique=gUnique+1;
#end

         rotate 90*y } 
#declare grass5 = union { 
#declare gUnique=0; 
#while(gUnique < 8)
#declare grass = object { mkGrass(17) }
#declare gc=0;
#while(gc < 2)     
object { grass scale 0.25+gr(0.1) rotate <gr(1), gr(360), gr(1)> translate <-0.1+gr(0.2), 0, -0.1+gr(0.2)> }
#declare gc=gc+1;
#end
#declare gUnique=gUnique+1;
#end

         rotate 90*y }   


#declare clover1 = object { mkClover(0.1) scale 0.035 }
#declare clover2 = object { mkClover(0.1) scale 0.035  }
#declare clover3 = object { mkClover(0.1) scale 0.035  }
#declare clover4 = object { mkClover(0.1) scale 0.035  }
#declare clover5 = object { mkClover(0.1) scale 0.035 }
#declare clover6 = object { mkClover(0.1) scale 0.035 }
#declare clover7 = object { mkClover(0.1) scale 0.035 }
#declare clover8 = object { mkClover(0.1) scale 0.035 }
#declare clover9 = object { mkClover(0.1) scale 0.035 }
#declare clover10 = object { mkClover(0.1) scale 0.035 }
#declare clover11 = object { mkClover(0.1) scale 0.035 }
#declare clover12 = object { mkClover(0.1) scale 0.035 }
#declare clover13 = object { mkClover(0.1) scale 0.035 }
#declare clover14 = object { mkClover(0.1) scale 0.035 }
#declare clover15 = object { mkClover(0.1) scale 0.035 }
#declare clover16 = object { mkClover(0.1) scale 0.035 }
#declare clover17 = object { mkClover(0.1) scale 0.035 }
#declare clover18 = object { mkClover(0.1) scale 0.035 }
#declare clover19 = object { mkClover(0.1) scale 0.035 }
#declare clover20 = object { mkClover(0.1) scale 0.035 }

#declare clovers = array [20] { clover1, 
                                clover2,
                                clover3,
                                clover4,
                                clover5,
                                clover6,
                                clover7,
                                clover8,
                                clover9,
                                clover10,
                                clover11,
                                clover12,
                                clover13,
                                clover14,
                                clover15,
                                clover16,
                                clover17,
                                clover18,
                                clover19,
                                clover20                                
                                }
                                
        
#declare grasses = array [5] { grass1, grass2, grass3, grass4, grass5 }
         
#macro Add_Grass(landSurface, reorient, sVect, eVect, gSize2, gSpace2, gRandSpace2, gRandSize2, gTex)
        
        #local gSize=gSize2*grassScale;
        #local gSpace=gSpace2*grassStep;       
        #local gRandSpace=gRandSpace2*grassStep;
        #local gRandSize=gRandSize2*grassScale;
        
               
        #local objStartPos = sVect;
        #local objEndPos = eVect;   
        #local gZPos=sVect.z;
        #local gYPos=sVect.y;       

        #local gXEnd=eVect.x;
        #local gZEnd=eVect.z;     
        #local cCount=0;
        

        #declare percentDone = -1;
        union
        {
        #while(gZPos < gZEnd)
                #local gXPos=sVect.x+gr(gRandSpace);

                #if(floor(((gZPos-sVect.z)/(gZEnd-sVect.z))*100) > percentDone)  
                        #declare percentDone=floor(((gZPos-sVect.z)/(gZEnd-sVect.z))*100);
                        #warning concat(concat(concat(str(percentDone, 3, 1), "% Done. "), str(cCount,0,0)), " clumps.")
                #end      

                #while(gXPos < gXEnd)      
                    #local doClover=0;
                    #if(cr(1) > 0.75)
                        #local doClover=1; 
                        // make this a smaller step
                        #local gXPos=gXPos-(gSpace/4);
                    #end

                        #local N = <0,0,0>;                                                          
                        
                        #local grassPos=<gXPos, gYPos, gZPos+gr(gRandSpace)>;
                        #local S = trace(landSurface, grassPos, <0, -1, 0>, N); 

                        #if(vlength(N) > 0) // hit       
                                
                                #if(doClover = 1)
                                   object { clovers[cr(20)] scale <1+cr(0.2), 1, 1+cr(0.2)> scale (1+cr(0.3))*grassScale translate <0, cr(0.5), 0> rotate <cr(10), cr(360), 0> Reorient_Trans(reorient,N) translate S  }  
                                #else                              
                                object { grasses[gr(5)] scale <gSize+gr(gRandSize), gSize+gr(gRandSize*2.5), gSize+gr(gRandSize)>  rotate <gr(10), gr(360), 0> Reorient_Trans(reorient,N) translate S } 
                                #end
                                #declare cCount=cCount+1;
                        #end
                                        
                        #if(doClover)
                            #local gXPos=gXPos+(gSpace*0.7)+gr(gRandSpace/2);
                        #else
                            #local gXPos=gXPos+(gSpace)+gr(gRandSpace);
                        #end
                #end                                       
                #local gZPos=gZPos+gSpace+gr(gRandSpace);
        
        #end
        
                texture 
                { 
                        gTex
                }
        }


        #if(cCount = 0)
                #warning" add_grass Error: no grass has hit the object try using different direction or start/end pos for grass!"
        #end   
        #warning concat("Total: ", str(cCount,1,0), " grass clumps used")   
        

#end // End Mac    
#declare  F_BumpsB= function { pigment{spherical turbulence 0.275 omega 0.6 lambda 4 scale 22 translate <-1, 0, 3.5>} }

#macro Add_Tree_Grass(landSurface, reorient, sVect, eVect, gSize, gSpace, gRandSpace, gRandSize, gTex, gTexDry)
               
        #local objStartPos = sVect;
        #local objEndPos = eVect;   
        #local gZPos=sVect.z;
        #local gYPos=sVect.y;       

        #local gXEnd=eVect.x;
        #local gZEnd=eVect.z;     
        #local cCount=0;
        

        #declare percentDone = -1;
        union
        {
        #while(gZPos < gZEnd)
                #local gXPos=sVect.x+gr(gRandSpace);

                #if(floor(((gZPos-sVect.z)/(gZEnd-sVect.z))*100) > percentDone)  
                        #declare percentDone=floor(((gZPos-sVect.z)/(gZEnd-sVect.z))*100);
                        #warning concat(concat(concat(str(percentDone, 3, 1), "% Done. "), str(cCount,0,0)), " clumps.")
                #end      

                #while(gXPos < gXEnd)     
                    #local doClover=0;
                    #if(cr(1) > 0.4)
                        #local doClover=1; 
                        // make this a smaller step
                        #local gXPos=gXPos-(gSpace/4);
                    #end

                        #local N = <0,0,0>;                                                          
                        
                        #local grassPos=<gXPos, gYPos, gZPos+gr(gRandSpace)>;
                        #local S = trace(landSurface, grassPos, <0, -1, 0>, N); 

                        #if(vlength(N) > 0) // hit       
                                #if(F_BumpsB(grassPos.x, 0.5, grassPos.z).red > 0.5)
                                    // check if clover
                                    #if(doClover)
                                       object { clovers[cr(20)] scale <1+cr(0.2), 1, 1+cr(0.2)> scale 1+cr(0.3) translate <0.1, cr(0.5), 0> rotate <cr(10), cr(360), 0> Reorient_Trans(reorient,N) translate S  }  
                                       object { clovers[cr(20)] scale <1+cr(0.2), 1, 1+cr(0.2)> scale 1+cr(0.3) translate <-0.1, cr(0.5), 0> rotate <cr(10), cr(360), 0> Reorient_Trans(reorient,N) translate S  }  
                                    #else                              
                                       object { grasses[gr(5)] scale <gSize+gr(gRandSize), gSize+gr(gRandSize*2.5), gSize+gr(gRandSize)>  rotate <gr(10), gr(360), 0> Reorient_Trans(reorient,N) translate S 
                                        }             
                                    #end
                                #else
                                    #if(doClover)
                                       object { clovers[cr(20)] scale <1+cr(0.2), 1, 1+cr(0.2)> scale 1+cr(0.3) translate <0.1, cr(0.5), 0> rotate <cr(10), cr(360), 0> Reorient_Trans(reorient,N) translate S  }  
                                       object { clovers[cr(20)] scale <1+cr(0.2), 1, 1+cr(0.2)> scale 1+cr(0.3) translate <-0.1, cr(0.5), 0> rotate <cr(10), cr(360), 0> Reorient_Trans(reorient,N) translate S  }  
                                    #else                              

                                    object { grasses[gr(5)] scale <gSize+gr(gRandSize), gSize+gr(gRandSize*2.5), gSize+gr(gRandSize)>  rotate <gr(10), gr(360), 0> Reorient_Trans(reorient,N) translate S 
                                                    texture 
                                        { 
                                                gTex
                                        }

                                        } 
                                    #end                                
                                #end
                                #declare cCount=cCount+1;
                        #end
                                        
                        #if(doClover)
                            #local gXPos=gXPos+(gSpace*0.7)+gr(gRandSpace/2);
                        #else
                            #local gXPos=gXPos+(gSpace)+gr(gRandSpace);
                        #end
                       
                #end                                       
                #local gZPos=gZPos+gSpace+gr(gRandSpace);
        
        #end
                                                    texture 
                { 
                        gTexDry
                }
        
        }


        #if(cCount = 0)
                #warning" add_grass Error: no grass has hit the object try using different direction or start/end pos for grass!"
        #end   
        #warning concat("Total: ", str(cCount,1,0), " grass clumps used")   
        

#end // End Mac    

           
#end





#declare g1 = difference { object { Ground } 
object { tree1 scale 1.065 
    rotate <0, -35, 3>
    translate <3.25, 3.75, 3.5>    
    }  

    sphere { <1.9, 0, 2> 6.5 }
//water
box { <-100, -10, -3> <0, 2.8, 35> } 

cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <-5.25, 10, -1.0> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <-5, 10, -5> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <-7, 10, -7> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <3, 10, -7> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <16, 10,  10> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <25, 10,  22> }
cylinder { <0, -10, 0> <0, 10, 0> 0.65 translate <39, 10,  33> }

}               

#if(showGrass)

//#macro Add_Grass(landSurface, orient, sVect, eVect, gSize, gSpace, gRandSpace, gRandSize, gTex)




// front

// in front of pond
object { Add_Grass(g1, <0, 1, 0>, <-12, 10, -10>, <-9.5, 0, -3>, 1.0, 0.35, 0.25, 1.5, bladeTexGreen) }  // make greener 
object { Add_Grass(g1, <0, 1, 0>, <-10, 10, -4>, <-8, 0, 0>, 1.0, 0.35, 0.25, 1.5, bladeTexGreen) }  // make greener 
object { Add_Grass(g1, <0, 1, 0>, <-8, 10, -2>, <-6, 0, 2>, 1.0, 0.35, 0.25, 1.5, bladeTexGreen) }  // make greener 
object { Add_Grass(g1, <0, 1, 0>, <-6, 10, -1>, <-2, 0, 4>, 1.0, 0.35, 0.25, 1.5, bladeTexGreen) }  // make greener 

// left front

object { Add_Grass(g1, <0, 1, 0>, <-12, 10, -10>, <-7.5, 0, 2>, 0.6, 0.15, 0.125, 1.0, bladeTexGreen) }  // make greener 

// right of tree
object { Add_Grass(g1, <0, 1, 0>, <10, 10, -10>, <20, 0, 3>, 0.6, 0.2, 0.15, 1.0, bladeTexGreen) }  // make greener 

// right side back
object { Add_Grass(g1, <0, 1, 0>, <2, 10, 6>, <70, 0, 60>, 0.6, 0.275, 0.25, 1.0, bladeTexGreen) }  // make greener 

// left side back behind pond
object { Add_Grass(g1, <0, 1, 0>, <-40, 10, 30>, <5, 0, 68>, 0.6, 0.275, 0.25, 1.0, bladeTexGreen) }  // make greener 
// left side back long grass
object { Add_Grass(g1, <0, 1, 0>, <-40, 10, 26>, <5, 0, 32>, 0.8, 0.3, 0.4, 2.5, bladeTexGreen) }  // make greener 

// patches of greener grass near tree
object { Add_Tree_Grass(g1, <0, 1, 0>, <-7, 10, -6.5>, <12, 0, 4.0>, 0.7, 0.4, 0.65, 1.75, bladeTexGreen, bladeTex) }  // make dry 
                                               
// dry grass near tree
object { Add_Tree_Grass(g1, <0, 1, 0>, <-8, 10, -9.5>, <15, 0, 6.5>, 0.6, 0.2, 0.125, 1, bladeTexGreen, bladeTex) }  // make dry 



#end 





#if(showMushroom)

#declare mushroomBottomTex = texture {
        pigment { granite turbulence 0.9 omega 0.7 lambda 2.5 colour_map { [ 0.0 rgb <0.8, 0.775, 0.75>*0.5 ]   [ 0.7 rgb <0.8, 0.775, 0.75>*0.35 ] [ 1.0 rgb <0.8, 0.5, 0.175>*0.2 ] }  scale 0.1 }
        finish { specular albedo 0.05 roughness 0.2 diffuse albedo 0.7 brilliance 0.8 }
} 

#if(useTestTex)
#declare mushroomTopTex1 = texture{             
        pigment { granite turbulence 0.9 omega 0.7 lambda 2.5 colour_map { [ 0.0 rgb <0.8, 0.775, 0.75>*0.5 ]   [ 0.7 rgb <0.8, 0.775, 0.75>*0.35 ] [ 1.0 rgb <0.8, 0.5, 0.175>*0.2 ] }  scale 0.1 }
        finish { specular albedo 0.05 roughness 0.2 diffuse albedo 0.7 brilliance 0.8 }
} 
#declare mushroomTopTex2 = texture{            
        pigment { granite turbulence 0.9 omega 0.7 lambda 2.5 colour_map { [ 0.0 rgb <0.8, 0.775, 0.75>*0.5 ]   [ 0.7 rgb <0.8, 0.775, 0.75>*0.35 ] [ 1.0 rgb <0.8, 0.5, 0.175>*0.2 ] }  scale 0.1 }
        finish { specular albedo 0.05 roughness 0.2 diffuse albedo 0.7 brilliance 0.8 }
} 
#else
#declare mushroomTopTex1 = texture{ pigment {           
        bozo
        turbulence 0.2
        omega 0.5
        lambda 3.5
        #declare cNum = 0;
        colour_map {      
            #while(cNum < 1)   
                [ cNum color rgb <0.1+tr(0.4),0.03+tr(.1),0.2+tr(0.25)>*(0.125+tr(0.125)) ]
            #declare cNum=cNum+0.02;
            #end  
            }
           scale 1
           }                                          //0.075
           finish { specular albedo 0.1 roughness 0.05 phong albedo 0.01 phong_size 80  diffuse albedo 0.65 brilliance 5 reflection { 0.008, 0.01 fresnel on }
            conserve_energy     
  } // finish 
           normal { 
                average 
                normal_map {
                    [ 0.5 granite 0.185 scale <1, 1.25, 1>*2 turbulence 0.1 omega 0.7 lambda 3]
                    [ 0.5 wrinkles 0.25 scale <1, 2, 1>*1 turbulence 0.1 omega 0.7 lambda 3]
                }
                }

         }     

#declare mushroomTopTex2 = texture{ pigment {           
        bozo
        turbulence 0.2
        omega 0.5
        lambda 3.5
        #declare cNum = 0;
        colour_map {      
            #while(cNum < 1)   
                [ cNum color rgb <0.1+tr(0.4),0.035+tr(.1),0.2+tr(0.25)>*(0.085+tr(0.05)) ]
            #declare cNum=cNum+0.02;
            #end  
            }
           scale 1
           }                                          //0.075
           finish { specular albedo 0.1 roughness 0.05 phong albedo 0.01 phong_size 80  diffuse albedo 0.65 brilliance 5 reflection { 0.008, 0.01 fresnel on }
            conserve_energy     
  } // finish 
           normal { 
                average 
                normal_map {
                    [ 0.5 granite 0.385 scale <1, 1.25, 1>*2 turbulence 0.1 omega 0.7 lambda 3]
                    [ 0.5 wrinkles 0.5 scale <1, 2, 1>*1 turbulence 0.1 omega 0.7 lambda 3]
                    [ 0.75 agate 0.75 scale <1, 2, 1>*1 scallop_wave turbulence 0.05 omega 0.55 lambda 2]                   
                }
                }

         }   
#end
#declare  mushroomSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.5, <0.15, -0.7, -0.05> 
         1.0, <0, -1.5, .015> 
//         0.5, <0.035, -0.5, -0.015> 
//         1.0, <0, -1, .015> 
       }; 
        
#declare Strength = 1.0; //(+ or -) strength of component's radiating density
#declare Radius1  = 1.0; //(0 < Radius) outer sphere of influence on other components
union {

blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  sphere{< 0,  0,   0>, 1, 1 scale <1,1,1>}
//  sphere{< 0,  0,   0>, 1,-15 scale <0.9,1.35,0.9> translate <0, -1, 0>}
  sphere{< 0,  0,   0>, 1,-10 scale <0.9,1.375,0.95> translate <0, -1, 0> texture { mushroomBottomTex } }
  sphere{< 0,  0,   0>, 1,-6 scale <0.9,1.35,0.9> translate <0.025, -1, -0.125> texture { mushroomBottomTex } }
  sphere{< 0,  0,   0>, 1,-6 scale <0.9,1.35,0.9> translate <-0.075, -1, 0> texture { mushroomBottomTex } }
  sphere{< 0,  0,   0>, 1,-6 scale <0.9,1.35,0.9> translate <0.075, -1, 0.075> texture { mushroomBottomTex } }
  
  // large dents to add shape
  #declare dentC=0;
  #while(dentC < 50)
    sphere{< 0,  0,   0>, 0.475+mushr(0.025),-1 scale <1, 1, 1> translate <0, 0, -(0.915+mushr(0.0125))> rotate <10+mushr(60), mushr(360), 0> }
  
    #declare dentC=dentC+1;
  #end
  
  // small dents to add holes
  #declare dentC=0;
  #while(dentC < 30)
    #declare dSize=0.015+mushr(0.01);
    #declare dZPos = -(0.445+mushr(0.025));
    #declare dRotX=30+mushr(60);
    #declare dRotY=mushr(360);
    
//    sphere{< 0,  0,   0>, 0.015+mushr(0.01),-1 scale <1, 1, 0.2> translate <0, 0, -(0.445+mushr(0.025))> rotate <30+mushr(60), mushr(360), 0> pigment { rgb <0, 0, 1> } }
    sphere{< 0,  0,   0>, dSize,-2 scale <1, 1, 0.4> translate <0, 0, dZPos> rotate <dRotX, dRotY, 0>  }
  
    #declare dentC=dentC+1;
  #end

 

  //cylinder{<-1.50,0,0>,< -0.25,1.50,0>, Radius1, Strength}
  // sturm 
  scale 1 
#if(useTestTex)
texture {
pigment {rgb 0.5 }
}
#else
    texture{ 
        bozo
        turbulence 0.1
        omega 0.5
        lambda 3.5
        texture_map { 
                [ 0.0 mushroomTopTex1 ]
                [ 0.2 mushroomTopTex1 ]
                [ 0.8 mushroomTopTex2 ]
                [ 0.8 mushroomBottomTex ]
                [ 1.0 mushroomBottomTex ]

         } 
         
           scale 0.01
}      
#end

         rotate <-5, 0, -5>
  translate<0.05,1.0,0>
 } //------------------------------------------------------ end of blob object  


// mushroom stem

union {

blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  #declare stemC=0;
  #while(stemC < 1)
    
//    sphere{<0, 0, 0>, 0.075+(stemC/15),1 scale <1, 1, 1> translate mushroomSpline(stemC) }
    #declare stemY=0;
        #while(stemY < 180)
//      sphere{<0, 0, 0>, 0.075+(stemC/15),1 scale <0.175+mushr(0.15), 1, 1>*(0.75+(sin(stemC*3))) rotate <0, stemY+mushr(5), 0> translate mushroomSpline(stemC) }
      sphere{<0, 0, 0>, 0.075+(stemC/15),1 scale <0.175+mushr(0.15), 1, 1>*(0.75+(sin(stemC)*0.1)) rotate <0, stemY+mushr(5), 0> translate mushroomSpline(stemC) }
        #declare stemY=stemY+10+mushr(5);
        #end
        
    #declare stemC=stemC+0.01;
  #end
 
  //cylinder{<-1.50,0,0>,< -0.25,1.50,0>, Radius1, Strength}
  // sturm 
  scale 1 
}
 


#if(useTestTex)
texture {
pigment {rgb 0.5 }
}
#else
  texture{ pigment{           
        wrinkles
        turbulence 0.2
        omega 0.85
        lambda 3.5
        #declare cNum = 0;
        colour_map {      
            #while(cNum < 1)   
                [ cNum color rgb <0.4+tr(0.15),0.3+tr(.1),0.2+tr(0.1)>*(0.6+tr(0.25)) ]
            #declare cNum=cNum+0.1;
            #end  
             }
           scale <0.01, 0.025, 0.01>*0.5
           }                                          //0.075
           finish { specular albedo 0.035 roughness 0.2 diffuse albedo 0.7 brilliance 0.9 reflection { 0.008, 0.01 fresnel on } conserve_energy  } 
       }
       texture {
       pigment { gradient y omega 0.85 lambda 3 turbulence 0.175 scale <2, 1.7, 2>
        colour_map {
            [ 0 rgbt <0.025, 0.01, 0.0005, 0.01> ]
            [ 0.2 rgbt <0.04, 0.02, 0.001, 0.1> ]
            [ 0.5 rgbt <0.05, 0.02, 0.001, 0.25> ]
            [ 0.8 rgbt <0.045, 0.02, 0.001, 0.1> ]            
            [ 1 rgbt <0.03, 0.01, 0.0005, 0.01> ]            
        }
            translate <0, 0.2, 0>    
        }
           finish { specular albedo 0.025 roughness 0.075 diffuse albedo 0.45 brilliance 3 reflection { 0.007, 0.009 fresnel on } conserve_energy  } 
           normal { 
                average 
                normal_map {
                    [ 0.5 granite 0.185 scale <0.01, 0.0125, 0.01>*2 turbulence 0.1 omega 0.7 lambda 3]
                    [ 0.5 wrinkles 0.25 scale <0.01, 0.01, 0.01>*1 turbulence 0.1 omega 0.7 lambda 3]
                    
                }
                }
  }            
  #end 
  rotate <0, -10, 0> 
  translate<0,1.35,0>
 } //-------------------------------------      
 // move the whole mushroom    
 scale 2 
 rotate <-5, 0, -10>
 translate <1.9, 3.3, -5>
}
#end  


// steps

#declare stepR=-720;
union {
#while(stepR < 720)
    union {
/*
      box { <-3, 0.1, 0.0> <0.1, 0.2, 0.6> } 
      box { <-3, 0.0, 0.05> <0.1, 0.2, 0.6> } 
      cylinder { <-3, 0.15, 0> <0.1, 0.15, 0> 0.05 } 
*/
      difference {
        box { <-3, 0.1, -.5> <0.1, 0.2, 0.6> } 
        cylinder { <0, 0, 0> <0, 0.21, 0> 0.4 scale <6, 1, 1> translate <-0.5, 0, -0.4> }
      } 
      difference {
        box { <-3, -0.1, -.5> <0.1, 0.19, 0.6> } 
        cylinder { <0, -0.2, 0> <0, 0.21, 0> 0.4 scale <6, 1, 1> translate <-0.5, 0, -0.35> }
      } 
      intersection {
        torus { 0.4, 0.05 scale <6, 1, 1> translate <-0.5, 0.15, -0.4> }  
        box { <-3, 0.0, -.5> <0.1, 0.25, 0.6> }   
      }
        translate <-0.3, stepR*0.025, 0> rotate <0, stepR, 0> 
        }
    #declare stepR=stepR+10;
#end

// middle part
//cylinder { <0, -5, 0> <0, 6, 0> 0.4  } 
#declare stepR=-720;
#while(stepR < 720)
      //  difference { box { <-3, 0, 0> <0, 0.2, 0.6> }  box { <-3.1, -0.1, -0.1> <0.1, 0.1, 0.7> } }
        sphere { <0, 0, 0> 0.4 
        translate <-0.3, stepR*0.025, 0> rotate <0, stepR, 0>  }
    #declare stepR=stepR+2;
#end


// stop seeing through to hdr probe below
difference {
cylinder { <0, -100, 0> <0, 100, 0> 3.35 }
cylinder { <0, -101, 0> <0, 101, 0> 3.25 }
box { <-4, -1, -4> <4, 10, 0> rotate <0, 40, 0> }
}


#if(useTestTex)
texture {
pigment {rgb 0.5 }
}
#else
texture {
        MyWood scale 3 rotate <0, 0, 90>
}
#end
rotate <0, -40, 3>
translate <3.25, 2.5, 2.4>      

} 
// create a regular point light source
/*
light_source {
  <1, 0, 0>                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
translate <3.25, 2.5, 2.4>      
}
*/


difference {
object { Ground }  
cylinder { <0, -100, 0> <0, 100, 0> 3.3  rotate <0, 0, 3> translate <3.25, 2, 2.4>   } 
}
 
                        


#declare dlHeadTex = material {
texture {
pigment { rgb <0.375, 0.475, 0.2>*0.5 }
finish { specular albedo 0.2 roughness 0.1 brilliance 1.4 diffuse albedo 0.6 reflection { 0.009, 0.01 fresnel on } conserve_energy } 
normal { quilted 1 scale 0.1 turbulence 0.3 }
}
interior { ior 1.6 }
}
#declare dStemTex =     material {
texture { pigment { wrinkles triangle_wave omega 0.85 lambda 3 turbulence 0.1 colour_map { [ 0.0 rgb <0.15, 0.227, 0.01> ] [ 0.85 rgb <0.1, 0.2, 0.008> ]  [ 1.0 rgb <.175, 0.1, .01> ]  } scale 1 }
 finish { specular albedo 0.1 roughness 0.07 brilliance 1.2 diffuse albedo 0.65 reflection { 0.01, 0.05 fresnel on } conserve_energy }
    normal { granite 0.2 scale 0.3 turbulence 0.3 }
 }   
texture { pigment { gradient y triangle_wave omega 0.9 lambda 5 turbulence 0.2 colour_map { [ 0.0 rgbt <0.15, 0.227, 0.01, 0.6> ] [ 1.0 rgbt <.175, 0.085, .007, 0.01> ]  } scale 130 translate <0, 70, 0>  }
 }   
interior { ior 1.6 }
}
  
#declare seedTex = texture {
    pigment { bozo triangle_wave omega 0.65 lambda 2.3 colour_map { [ 0.0 rgb <0.185, 0.075, 0.004>*0.15 ] [ 1.0 rgb <0.375, 0.195, 0.08>*0.15 ] } scale 0.3 }
    finish { specular albedo 0.3 roughness 0.05 brilliance 4.8 diffuse albedo 0.4 reflection { 0.008, 0.05 fresnel on } conserve_energy }  
    normal { granite 0.4 scale 0.001 }
} 

#local dlBaseTex1 = texture { 
pigment { uv_mapping gradient y triangle_wave turbulence 0.2 omega 0.8 lambda 3 
colour_map { 
[ 0.0 rgb <0.14, 0.10, 0.005> ] 
[ 0.4 rgb <0.10, 0.13, 0.002> ]  
[ 1 rgb <0.065, 0.15, 0.0015> ] 
}  
}
     finish { specular 0.085 roughness 0.005 brilliance 1.5 diffuse albedo 0.5 reflection { 0.009, 0.05 fresnel on } conserve_energy } 
        normal {  average normal_map { [ 0.8 crackle 1 scale 0.075 turbulence 0.3 ] [ 0.5 granite 0.5 scale 0.001 turbulence 0.5 ] } }
    }


#declare dlBrownTex = material {
texture { dlBaseTex1 }
texture { 
pigment {  bozo turbulence 0.2 omega 0.4 lambda 2 
colour_map { 
[ 0.0 rgbt <0.12, 0.03, .0005, 0.1>  ]
[ 0.1 rgbt <0.18, 0.04, 0.001, 0.1>  ] 
[ 0.2 rgbt <0.065, 0.02, 0.0005, 0.2> ] 
[0.2 rgbt 1 ] [ 1.0 rgbt 1 ] 
}  warp { repeat y flip x }  scale 0.05 }
     finish { specular 0.025 roughness 0.005 brilliance 2.5 diffuse albedo 0.3 reflection { 0 } conserve_energy } 
}
interior { ior 1.6 }
}

#declare dlHairTex = material {
                texture {
                    pigment { rgb <0.98, 1, 1>*0.35 }
                    finish { specular albedo 0.15 roughness 0.05 diffuse albedo 0.6, 0.2 brilliance 0.8 reflection { 0.01, 0.03 fresnel on } conserve_energy }
                }
                interior { ior 1.5 }
            }  

#if(showDandelions)                       

#declare dl8 = object 
{ 
    mkDandelionCluster(
        1,      // numDandelions - number of seed heads       
        3,      // numFlowers - number of flowering heads
        7,      // minSeeds - number of seeds ranges from 2-7 seem about right
        8,      // maxSeeds - should be >= minSeeds  2-7 seem about right   
        48,     // num seed hairs - Hairs/seed    
        0.02,   // hair Thickness   
        false,   // use Low Memory option recommended for all but extreme close ups as alows more copies (reduced memory usage).
        1,      // min_stem_bends 
        1,      // max_stem_bends
        8,      // minimum amount of bend 
        12,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        28,     // numLeaves, these will be rotated randomly'ish around the base.
        15,     // minLeafRotation - min angle upwards
        55,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.3,    // maxLeafBend - max amount of bend   
        0.01,    // leafDetail 0.01 good, 0.1 low
        dlBrownTex, // leaf texture
        dStemTex,   // stem texture
        dlHairTex,    // hair texture    
        dlHeadTex
        )
}    

#declare dl7 = object 
{ 
    mkDandelionCluster(
        1,      // numDandelions - number of seed heads       
        2,      // numFlowers - number of flowering heads
        6,      // minSeeds - number of seeds ranges from 2-7 seem about right
        7,      // maxSeeds - should be >= minSeeds  2-7 seem about right   
        48,     // num seed hairs - Hairs/seed    
        0.02,   // hair Thickness   
        false,   // use Low Memory option recommended for all but extreme close ups as alows more copies (reduced memory usage).
        1,      // min_stem_bends 
        1,      // max_stem_bends
        8,      // minimum amount of bend 
        12,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        28,     // numLeaves, these will be rotated randomly'ish around the base.
        15,     // minLeafRotation - min angle upwards
        55,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.3,    // maxLeafBend - max amount of bend   
        0.01,    // leafDetail 0.01 good, 0.1 low
        dlBrownTex, // leaf texture
        dStemTex,   // stem texture
        dlHairTex,    // hair texture    
        dlHeadTex
        )
}    
#declare dl6 = object 
{ 
    mkDandelionCluster(
        2,      // numDandelions - number of seed heads       
        1,      // numFlowers - number of flowering heads
        5,      // minSeeds - number of seeds ranges from 2-7 seem about right
        6,      // maxSeeds - should be >= minSeeds  2-7 seem about right   
        48,     // num seed hairs - Hairs/seed    
        0.02,   // hair Thickness   
        false,   // use Low Memory option recommended for all but extreme close ups as alows more copies (reduced memory usage).
        1,      // min_stem_bends 
        1,      // max_stem_bends
        8,      // minimum amount of bend 
        12,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        28,     // numLeaves, these will be rotated randomly'ish around the base.
        15,     // minLeafRotation - min angle upwards
        55,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.3,    // maxLeafBend - max amount of bend   
        0.01,    // leafDetail 0.01 good, 0.1 low
        dlBrownTex, // leaf texture
        dStemTex,   // stem texture
        dlHairTex,    // hair texture    
        dlHeadTex
        )
}    
#declare dl5 = object 
{ 
    mkDandelionCluster(
        3,//3   // numDandelions - number of seed heads       
        0,      // numFlowers - number of flowering heads
        5,      // minSeeds - number of seeds ranges from 2-7 seem about right
        6,      // maxSeeds - should be >= minSeeds  2-7 seem about right   
        48,     // num seed hairs - Hairs/seed    
        0.02,   // hair Thickness   
        false,   // use Low Memory option recommended for all but extreme close ups as alows more copies (reduced memory usage).
        1,      // min_stem_bends 
        1,      // max_stem_bends
        8,      // minimum amount of bend 
        12,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        28,     // numLeaves, these will be rotated randomly'ish around the base.
        15,     // minLeafRotation - min angle upwards
        55,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.3,    // maxLeafBend - max amount of bend   
        0.01,    // leafDetail 0.01 good, 0.1 low
        dlBrownTex, // leaf texture
        dStemTex,   // stem texture
        dlHairTex,    // hair texture    
        dlHeadTex
        )
    
}    
                        //l8
Drop_Object(Ground, object { dl5 scale 0.51 }, <-5.25, 10, -1.0>, false)     
Drop_Object(Ground, object { dl7 scale 0.51 }, <-5, 10, -5>, false)     
Drop_Object(Ground, object { dl8 scale 0.515 }, <-7, 10, -7>, false)     
Drop_Object(Ground, object { dl6 scale 0.52 rotate <0, 0, 10> }, <3, 10, -7>, false)     

Drop_Object(Ground, object { dl6 scale 0.525 rotate <0, 0, 15> }, <16, 10,  10>, false)     
Drop_Object(Ground, object { dl7 scale 0.54 rotate <0, 0, 15> }, <25, 10,  22>, false)     
Drop_Object(Ground, object { dl8 scale 0.57 rotate <0, 0, 15> }, <39, 10,  33>, false)     

/*
Drop_Object(g1, object { dl7 scale 0.565 }, <-7, 10, -7>, true)     
Drop_Object(g1, object { dl6 scale 0.57 }, <-8, 10, -6>, true)     
Drop_Object(g1, object { dl5 scale 0.575 }, <-5, 10, 1>, true)     
Drop_Object(g1, object { dl5 scale 0.57 rotate <0, 0, 10> }, <3, 10, -7>, true)     
Drop_Object(g1, object { dl6 scale 0.585 rotate <0, 0, 15> }, <14, 10, 4>, true)     
Drop_Object(g1, object { dl7 scale 0.575 rotate <0, 0, 15> }, <16, 10,  10>, true)     

Drop_Object(g1, object { dl8 scale 0.59 rotate <0, 0, 15> }, <25, 10,  22>, true)     
Drop_Object(g1, object { dl8 scale 0.62 rotate <0, 0, 15> }, <39, 10,  33>, true)     

 
#declare dzp = 10;
#while(dzp < 30)
    #declare dxp = -30+dr(20);
    #while(dxp < 0)
        #declare dType=dr(5);
        #if(dType > 4)
            Drop_Object(g1, object { dl8 scale 0.565+dr(0.15) }, <dxp, 10, dzp>, true)   
        #elseif(dType > 3)                        
            Drop_Object(g1, object { dl7 scale 0.565+dr(0.15) }, <dxp, 10, dzp>, true)   
        #elseif(dType > 2)
            Drop_Object(g1, object { dl6 scale 0.565+dr(0.15) }, <dxp, 10, dzp>, true)   
        #elseif(dType > 1)
            Drop_Object(g1, object { dl5 scale 0.55+dr(0.15) }, <dxp, 10, dzp>, true)   
        #end
        #declare dxp=dxp+10+dr(10);
    #end
    #declare dzp=dzp+3+dr(3);
#end

*/ 
#end



// daisies

#if(showDaisies)
#declare daisyHeadTex = material {
texture {
pigment { rgb <0.375, 0.475, 0.2>*0.5 }
finish { specular albedo 0.2 roughness 0.1 brilliance 1.4 diffuse albedo 0.6 reflection { 0.009, 0.01 fresnel on } conserve_energy } 
normal { quilted 1 scale 0.1 turbulence 0.3 }
}
interior { ior 1.6 }
}
#declare daisyStemTex =     material {
texture { pigment { wrinkles triangle_wave omega 0.85 lambda 3 turbulence 0.1 colour_map { [ 0.0 rgb <0.15, 0.227, 0.01> ] [ 0.85 rgb <0.1, 0.2, 0.008> ]  [ 1.0 rgb <.175, 0.1, .01> ]  } scale 1 }
 finish { specular albedo 0.1 roughness 0.07 brilliance 1.2 diffuse albedo 0.65 reflection { 0.01, 0.05 fresnel on } conserve_energy }
    normal { granite 0.2 scale 0.3 turbulence 0.3 }
 }   
texture { pigment { gradient y triangle_wave omega 0.9 lambda 5 turbulence 0.2 colour_map { [ 0.0 rgbt <0.15, 0.227, 0.01, 0.6> ] [ 0.95 rgbt <.17, 0.075, .003, 0.02> ]  } scale 110 translate <0, 70, 0>  }
 }   
interior { ior 1.6 }
}
  
#local daisyBaseTex1 = texture { 
pigment { bozo triangle_wave turbulence 1 omega 0.8 lambda 3  scale 0.05
colour_map { 
[ 0.0 rgb <0.01, 0.04, 0.003> ] 
[ 0.5 rgb <0.03, 0.08, 0.008> ]  
[ 1 rgb <0.02, 0.06, 0.009> ] 
}  
}
     finish { specular 0.2 roughness 0.1 brilliance 3 diffuse albedo 0.45 reflection { 0.009, 0.05 fresnel on } conserve_energy } 
        normal {  average normal_map { [ 0.4 wrinkles 1 scale 0.075 turbulence 0.3 ] [ 0.1 granite 0.5 scale 0.001 turbulence 0.5 ] } }
    }


#declare daisyBrownTex = material {
texture { daisyBaseTex1 }
interior { ior 1.6 }
}


//#macro mkDaisyCluster(numFlowers, min_stem_bends, max_stem_bends, min_bend_amount, max_bend_amount, stemStep, numLeaves, minLeafRotation, maxLeafRotation, minLeafBend, maxLeafBend, 

//leafDetail, leafTex, stemTex, headTex)   

#declare daisy1 = object 
{ 
    mkDaisyCluster(
        5,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        1,      // max_stem_bends
        2,      // minimum amount of bend 
        5,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        10,     // minLeafRotation - min angle upwards
        35,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy2 = object 
{ 
    mkDaisyCluster(
        4,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        2,      // max_stem_bends
        1,      // minimum amount of bend 
        2,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        10,     // minLeafRotation - min angle upwards
        35,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy3 = object 
{ 
    mkDaisyCluster(
        3,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        1,      // max_stem_bends
        2,      // minimum amount of bend 
        5,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        10,     // minLeafRotation - min angle upwards
        35,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy4 = object 
{ 
    mkDaisyCluster(
        2,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        2,      // max_stem_bends
        1,      // minimum amount of bend 
        2,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        10,     // minLeafRotation - min angle upwards
        35,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy5 = object 
{ 
    mkDaisyCluster(
        1,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        1,      // max_stem_bends
        3,      // minimum amount of bend 
        4,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        10,     // minLeafRotation - min angle upwards
        35,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   

#declare daisy6 = object 
{ 
    mkDaisyCluster(
        5,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        2,      // max_stem_bends
        1,      // minimum amount of bend 
        2,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        12,     // numLeaves, these will be rotated randomly'ish around the base.
        25,     // minLeafRotation - min angle upwards
        45,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy7 = object 
{ 
    mkDaisyCluster(
        4,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        1,      // max_stem_bends
        2,      // minimum amount of bend 
        5,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        9,     // numLeaves, these will be rotated randomly'ish around the base.
        25,     // minLeafRotation - min angle upwards
        45,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy8 = object 
{ 
    mkDaisyCluster(
        3,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        2,      // max_stem_bends
        1,      // minimum amount of bend 
        2,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        8,     // numLeaves, these will be rotated randomly'ish around the base.
        25,     // minLeafRotation - min angle upwards
        45,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy9 = object 
{ 
    mkDaisyCluster(
        2,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        1,      // max_stem_bends
        3,      // minimum amount of bend 
        4,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        7,     // numLeaves, these will be rotated randomly'ish around the base.
        25,     // minLeafRotation - min angle upwards
        45,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   
#declare daisy10 = object 
{ 
    mkDaisyCluster(
        1,      // numFlowers - number of flowering heads
        1,      // min_stem_bends 
        2,      // max_stem_bends
        1,      // minimum amount of bend 
        2,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        6,     // numLeaves, these will be rotated randomly'ish around the base.
        25,     // minLeafRotation - min angle upwards
        45,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.2,    // maxLeafBend - max amount of bend   
        0.05,    // leafDetail 0.01 good, 0.1 low
        daisyBrownTex, // leaf texture
        daisyStemTex,   // stem texture
        daisyHeadTex
        )
        scale 0.5              
}   



#declare daisies = array [10] { daisy1, 
                                daisy2,
                                daisy3,
                                daisy4,
                                daisy5,
                                daisy6, 
                                daisy7,
                                daisy8,
                                daisy9,
                                daisy10
                                }
                                

#declare dCount=0;
#while(dCount < 50)
Drop_Object(g1, object { daisies[daisyr(10)] scale 0.9+daisyr(0.1) rotate <0, daisyr(360), 0> }, <-12+daisyr(22), 10, -10+daisyr(20)>, false)     
#local dCount=dCount+1;
#end

#declare dCount=0;
#while(dCount < 50)
Drop_Object(g1, object { daisies[daisyr(10)] scale 1.0+daisyr(0.1) rotate <0, daisyr(360), 0> }, <-3+daisyr(40), 10, 5+daisyr(30)>, false)     
#local dCount=dCount+1;
#end

#declare dCount=0;
#while(dCount < 50)
Drop_Object(g1, object { daisies[daisyr(5)] scale 1.1+daisyr(0.1) rotate <0, daisyr(360), 0> }, <-43+daisyr(90), 10, 39+daisyr(50)>, false)     
#local dCount=dCount+1;
#end

#end












#if(showStones)

// stone
#declare stoneFinish = finish {

    diffuse albedo 0.6         // ambient surface reflection color [0.1] 
    brilliance 1.6
    specular 0.025 roughness 0.15
//    phong albedo 0.125          // amount [0.0]
//    phong_size 30      // (1.0..250+) (dull->highly polished) [40]
  } 

#declare stoneFinishDamp = finish {
                      
    diffuse albedo 0.3         // ambient surface reflection color [0.1] 
    brilliance 3.0
    specular 0.4 roughness 0.002
    phong 0.1          // amount [0.0]
    phong_size 90      // (1.0..250+) (dull->highly polished) [40]   
    reflection { 0.01, 0.5 fresnel on } conserve_energy
  } 

#declare stoneFinishWet = finish {
                      
    diffuse albedo 0.3         // ambient surface reflection color [0.1] 
    brilliance 3.0
    specular  0.0 
    phong  0.0          // amount [0.0]
  } 



#declare fn_scallop_ripples=function { pigment {
        ripples          
        scallop_wave
        turbulence 0.5
        omega 0.5
        lambda 5
        colour_map
        {
                [ 0.0 rgb 0.5 ]
                [ 0.9 rgb 0.5 ]
                [ 0.92 rgb 1 ]
                [ 0.94 rgb 1 ]
                [ 1.0 rgb 0.5 ]
                
        }  
        scale <0.25, 0.6, 0.15>
}

}


//#declare stoneTexWet=texture { pigment { rgb <0, 0, 1> } }
//#declare stoneTexDamp=texture { pigment { rgb <0, 1, 0> } }
//#declare stoneTex=texture { pigment { rgb <1, 0, 0> } }

#declare  S = function { sqrt(pow(x,2) + pow(y,2) + pow(z,2)) - 2 }                      


#macro mkStone()

#local s1 = stnr(0.25); 
#local s2 = stnr(0.2); 
#local s3 = stnr(0.3);     
#local s4 = stnr(0.12); 
#local s5 = stnr(0.15);  
#local s6 = stnr(0.1);  
#local s7 = stnr(1);     
#local s8 = stnr(0.125);     
#local s9 = stnr(0.01);     



   



isosurface {
  function { S(x,y*((1.25+(s1))-y/12),z)-f_wrinkles(x*(0.2+s2),y*(0.3+s3),z*(0.02+s4))*(0.03+s5)- 
               fn_scallop_ripples(x,y,z).gray*(0.001+s6)-f_wrinkles(x*(2+s7),y*(3+s7),z*(3+s7))*(0.005+s8)-f_crackle(x*15, y*15, z*15)*(0.01+s9) }
        accuracy isoAccuracy               
        max_gradient 2.75
        contained_by{sphere{0,2.2}}  
#if(useTestTex)
        texture { pigment {rgb 0.3} }
#else       
material {
texture
{
pigment {
        wrinkles          
        triangle_wave
        turbulence 0.55+tr(0.1)
        omega 0.8+tr(0.1)
        lambda 3+tr(1)
        colour_map
        { 
        
        #if(tr(1) > 0.75)
                [ 0.0 rgb <0.095+tr(0.05), 0.08+tr(0.015), 0.07+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.2+tr(0.1) rgb <0.075+tr(0.04), 0.074+tr(0.01), 0.06+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.4+tr(0.1) rgb <0.095+tr(0.04), 0.0825+tr(0.01), 0.08+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.7+tr(0.1) rgb <0.08+tr(0.04), 0.07+tr(0.01), 0.07+tr(0.0151)>*(0.125+tr(0.125)) ]//9>*(0.05+tr(0.05)) ]
                [ 1.0 rgb <0.1+tr(0.05), 0.08+tr(0.03), 0.075+tr(0.015)>*(0.125+tr(0.125)) ]//>*(0.01+tr(0.05)) ]
        #elseif(tr(1) > 0.4)
                [ 0.0 rgb <0.125+tr(0.1), 0.05+tr(0.025), 0.025+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.2+tr(0.1) rgb <0.35+tr(0.1), 0.12+tr(0.025), 0.05+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.4+tr(0.1) rgb <0.125+tr(0.1), 0.05+tr(0.025), 0.025+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.7+tr(0.1) rgb <0.35+tr(0.1), 0.12+tr(0.025), 0.05+tr(0.01)>*(0.125+tr(0.125)) ]//9>*(0.05+tr(0.05)) ]
                [ 1.0 rgb <0.125+tr(0.1), 0.05+tr(0.025), 0.025+tr(0.01)>*(0.125+tr(0.125)) ]//>*(0.01+tr(0.05)) ]
        #elseif(tr(1) > 0.7)
                [ 0.0 rgb <0.125+tr(0.1), 0.12+tr(0.025), 0.05+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.2+tr(0.1) rgb <0.35+tr(0.1), 0.24+tr(0.025), 0.075+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.4+tr(0.1) rgb <0.125+tr(0.1), 0.125+tr(0.025), 0.05+tr(0.01)>*(0.125+tr(0.125)) ]
                [ 0.7+tr(0.1) rgb <0.35+tr(0.1), 0.2+tr(0.025), 0.075+tr(0.01)>*(0.125+tr(0.125)) ]//9>*(0.05+tr(0.05)) ]
                [ 1.0 rgb <0.125+tr(0.1), 0.1+tr(0.025), 0.05+tr(0.01)>*(0.125+tr(0.125)) ]//>*(0.01+tr(0.05)) ]
        #elseif(tr(1) > 0.5)
                [ 0.0 rgb <0.05+tr(0.02), 0.04+tr(0.01), 0.005+tr(0.0051)>*(0.125+tr(0.125)) ]
                [ 0.2+tr(0.1) rgb <0.075+tr(0.02), 0.034+tr(0.01), 0.005+tr(0.0051)>*(0.125+tr(0.125)) ]
                [ 0.4+tr(0.1) rgb <0.025+tr(0.02), 0.0225+tr(0.015), 0.005+tr(0.0051)>*(0.125+tr(0.125)) ]
                [ 0.7+tr(0.1) rgb <0.05+tr(0.02), 0.03+tr(0.01), 0.005+tr(0.0051)>*(0.125+tr(0.125)) ]//9>*(0.05+tr(0.05)) ]
                [ 1.0 rgb <0.025+tr(0.02), 0.02+tr(0.01), 0.005+tr(0.005)>*(0.125+tr(0.125)) ]//>*(0.01+tr(0.05)) ]
        #else
                [ 0.0 rgb <0.095+tr(0.05), 0.08+tr(0.015), 0.07+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.2+tr(0.1) rgb <0.075+tr(0.04), 0.074+tr(0.01), 0.06+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.4+tr(0.1) rgb <0.095+tr(0.04), 0.0825+tr(0.01), 0.08+tr(0.0151)>*(0.125+tr(0.125)) ]
                [ 0.7+tr(0.1) rgb <0.08+tr(0.04), 0.07+tr(0.01), 0.07+tr(0.0151)>*(0.125+tr(0.125)) ]//9>*(0.05+tr(0.05)) ]
                [ 1.0 rgb <0.1+tr(0.05), 0.08+tr(0.03), 0.075+tr(0.015)>*(0.125+tr(0.125)) ]//>*(0.01+tr(0.05)) ]
        #end                

        }  
        scale <0.75, 1.2, 0.5>*(0.5+tr(1))
        }                
}
texture
{
        pigment {
        ripples          
        scallop_wave
        turbulence 0.1+tr(0.3)
        omega 0.55+tr(0.1)
        lambda 4+tr(1)
        colour_map
        {
                [ 0.0 rgbt <1, 1, 1, 1> ]
                [ 0.9 rgbt <1, 1, 1, 1> ]
                [ 0.9 rgbt <0.0+tr(0.1), 0.1+tr(0.05), 0.04+tr(0.02), 1> ]
                [ 0.92 rgbt <0.0+tr(0.1), 0.1+tr(0.05), 0.042+tr(0.02), 0.1+tr(0.4)> ]
                [ 0.94 rgbt <0.1+tr(0.1), 0.072+tr(0.025), 0.042+tr(0.02), 0.1+tr(0.4)> ]
                [ 0.99 rgbt <0.1+tr(0.1), 0.072+tr(0.025), 0.052+tr(0.02), 1> ]
                [ 0.99 rgbt <1, 1, 1, 1> ]
                [ 1.0 rgbt <1, 1, 1, 1> ]
                
        }
        scale <0.25, 0.6, 0.15>*(1+tr(1))
        }
        finish { stoneFinishDamp }
}    
 
interior { ior 1.6 }  
}
#end                            

#local stoneH=0.3+stnr(0.7);
#local stoneS=0.001+stnr(0.025)+stnr(0.025)+stnr(0.025)+stnr(0.025);

#if(stnr(1) > 0.7)
translate <0, +stnr(0.5), 0>
#else
translate <0, 0.9+stnr(0.2), 0>
#end

scale <1, stoneH, 1>*stoneS
  
rotate <stnr(3), stnr(360), stnr(3)>
       
}


#end




#declare stCount = 0;
#while(stCount < 150)
Drop_Object(Ground, object { mkStone() scale <3.0+stnr(2.5), 1.0+stnr(1.0), 1.5+stnr(2.5)> } , <-20+stnr(14), 10, 2+stnr(18)>, 1)
Drop_Object(Ground, object { mkStone() scale <3.0+stnr(2.5), 1.0+stnr(1.0), 1.5+stnr(2.5)> } , <-30+stnr(30), 10, 10+stnr(14)>, 1)
#declare stCount=stCount+1;
#end


  

#declare stCount = 0;
#while(stCount < 80)
Drop_Object(Ground, object { mkStone() scale 0.5+stnr(0.75) }, <-12+stnr(22), 10, -9+stnr(7)>, 1)
#declare stCount=stCount+1;
#end
/*

#declare stCount = 0;
#while(stCount < 16000)
Drop_Object(Ground, object { mkStone() scale 0.04+stnr(0.01)+stnr(0.01)+stnr(0.01)+stnr(0.01) }, <-8+stnr(12), 10, -3+stnr(10)>, 1)
Drop_Object(Ground,  object { mkStone() scale 0.04+stnr(0.01)+stnr(0.01)+stnr(0.01)+stnr(0.01) }, <-8+stnr(20), 10, -3+stnr(4)>, 1)
#declare stCount=stCount+1;
#end
*/

#end


#declare creature = union
{
        // create a smooth blobby shape
#declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density


blob {
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
// body
#declare xp = -2.7;
#declare rstep = -0.25;
#declare r = 0;
        #while(r > -5)
                sphere { <xp-0.0125, 0, 0>, 0.05, 1 rotate <0, 0, r> translate <-xp, 0, 0> }
                sphere { <xp, 0, -0.035>, 0.02, 1 rotate <0, 0, r> translate <-xp, 0, 0> }
                sphere { <xp+0.0125, 0, 0>, 0.05, 1 rotate <0, 0, r> translate <-xp, 0, 0> }
                #declare r = r+rstep;
        #end

#declare xp2 = -0.5;
#declare rstep2 = -1;
#declare r2 = 0;        
#declare rx = 0;  
#declare ry = 0;
#declare coff = 0.1;
        #while(r2 > -25)
                sphere { <xp2-0.0125, 0, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2, 0, -0.035>, 0.02, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2+0.0125, 0, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }


                sphere { <xp2-0.0125*coff, -0.03, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2+0.0125*coff, -0.03, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }

                sphere { <xp2-0.0125*coff, -0.075, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2+0.0125*coff, -0.075, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }

                sphere { <xp2-0.0125*coff, -0.1, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2+0.0125*coff, -0.1, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }

                sphere { <xp2-0.0125*(coff*0.75), -0.15, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }
                sphere { <xp2+0.0125*(coff*0.75), -0.15, 0>, 0.05, 1 rotate <0, 0, r2> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx, 0, r> translate <-xp, 0, 0> }


                #declare r2 = r2+rstep2;             
                #declare rx = rx+0.75;       
                #declare coff = coff*1.165;
        #end     
        
        // head
        sphere { <xp2, 0, -0.035>, 0.095, 1 scale <1, 1.6, 1> rotate <0, 0, r2-8> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx+10, 0, r> translate <-xp-0.01, 0.01, -0.015> }
        
        // ear
        sphere { <0.04, -0.02, -0.04>, 0.02, 1 translate <xp2-0.035, 0, -0.035> rotate <0, 0, r2-8> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx+10, 0, r> translate <-xp+0.01, 0.0025, -0.015> }
        sphere { <0.05, -0.02, -0.04>, 0.0125, -0.5 translate <xp2-0.035, 0, -0.035> rotate <0, 0, r2-8> translate <-xp2, 0, 0> translate <xp, 0, 0> rotate <rx+10, 0, r> translate <-xp+0.01, 0.0025, -0.015> }

        
        // arm
        #declare xp = 0;
        #declare yp = 0;
        #declare zp = 0;             
        #declare rad = 0.045;
//        #declare armOff = <0.025, 0.45, 0.1>;
        #declare armOff = <0.0125, 0.425, 0.05>;
        // shoulder
        #while(yp > -0.02)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp-0.0075;
                #declare yp = yp-0.005;
                #declare zp = zp-0.002;     
                #declare rad = rad-0.0015;
        #end

        // extra bicep/ tricep 
//        sphere { 0 rad*0.5, 0.8 scale <2, 1, 3> translate <xp, yp, zp> translate <xp-0.025, yp+0.005, zp> translate armOff }
//        sphere { 0 rad*0.5, 0.8 scale <1.5, 1, 3> translate <xp, yp, zp> translate <xp-0.015, yp-0.025, zp> translate armOff }   
        sphere { 0 rad*0.9, 1 scale <1.75, 1, 1.5> rotate <0, -15, 35> translate <-0.07, 0.4, 0.025> }
        sphere { 0 rad*0.7, 1 scale <2, 1, 1.25> rotate <0, -15, 35> translate <-0.085, 0.335, 0.025> }

        // bicep
        #while(yp > -0.03)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp-0.0085;
                #declare yp = yp-0.007;
                #declare zp = zp-0.002;     
                #declare rad = rad+0.005;
        #end

        // from bicep to elbow
        #while(yp > -0.065)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp-0.0085;
                #declare yp = yp-0.007;
                #declare zp = zp-0.002;     
                #declare rad = rad-0.0025;
        #end  
        
        // first part of forearm
        #while(yp < -0.0375)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp+0.001;
                #declare yp = yp+0.0065;
                #declare zp = zp+0.0002;     
                #declare rad = rad-0.001;
        #end  
       
        #declare zpOff = 0.00075; 
        // second part of forearm
        #while(yp < 0.04)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp+0.0036;
                #declare yp = yp+0.004+zpOff;
                #declare zp = zp+zpOff;
                #declare zpOff = zpOff*1.15;     
                #declare rad = rad-0.0002;
        #end  

        // hand
        sphere { 0 rad, 1 scale <1.4, 2.5, 0.75> translate <0, 0.025, 0> translate  <xp, yp, zp> translate <xp, yp, zp> translate armOff }
        
        // right arm
        // arm
        #declare xp = 0;
        #declare yp = 0;
        #declare zp = 0;             
        #declare rad = 0.045;
        #declare armOff = <0.11, 0.41, 0.02>;
        // shoulder
        #while(yp > -0.0175)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp+0.0075;
                #declare yp = yp-0.005;
                #declare zp = zp+0.002;     
                #declare rad = rad-0.0015;
        #end  

        // extra bicep/ tricep 
//        sphere { 0 rad*0.5, 0.8 scale <2, 1, 3> translate <xp, yp, zp> translate <xp+0.015, yp+0.01, zp> translate armOff }
//        sphere { 0 rad*0.5, 0.8 scale <3, 1, 3> translate <xp, yp, zp> translate <xp+0.025, yp-0.035, zp> translate armOff }
        sphere { 0 rad*0.9, 1 scale <2, 1, 1.5> rotate <0, -15, -45> translate <0.19, 0.39, 0.04> }
        sphere { 0 rad*0.7, 1 scale <2.5, 1, 1.25> rotate <0, -15, -40> translate <0.22, 0.32, 0.025> }

        // bicep
        #while(yp > -0.03)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp+0.0075;
                #declare yp = yp-0.005;
                #declare zp = zp+0.002;     
                #declare rad = rad+0.005;
        #end  

        
        // from bicep to elbow
        #while(yp > -0.05)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp+0.0085;
                #declare yp = yp-0.005;
                #declare zp = zp+0.002;     
                #declare rad = rad-0.0025;
        #end  
        
        
        // first part of forearm
        #while(yp < -0.02)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp-0.001;
                #declare yp = yp+0.0065;
                #declare zp = zp+0.0002;     
                #declare rad = rad-0.001;
        #end  
        
        #declare zpOff = 0.00075; 
        // second part of forearm
        #while(yp < 0.04)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate armOff }
                #declare xp = xp-0.003;
                #declare yp = yp+0.0045+zpOff;
                #declare zp = zp+zpOff;
                #declare zpOff = zpOff*1.15;     
                #declare rad = rad-0.0002;
        #end  

        // hand
        sphere { 0 rad, 1 scale <1.4, 2.5, 0.75> translate <0, 0.025, 0> translate  <xp, yp, zp> translate <xp, yp, zp> translate armOff }
        
       // legs    
           
       // left leg
        #declare xp = 0;
        #declare yp = 0;
        #declare zp = 0;             
        #declare rad = 0.065;
        #declare legOff = <-0.05, 0.02, 0.02>;
        // thigh
        #while(yp < 0.035)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate legOff }
                #declare xp = xp-0.0075;
                #declare yp = yp+0.005;
                #declare zp = zp+0.002;     
                #declare rad = rad-0.0015;
        #end  

        #while(yp > -0.145)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate legOff }
                #declare xp = xp+0.001;
                #declare yp = yp-0.005;
                #declare zp = zp+0.0002;     
                #declare rad = rad-0.00075;
        #end 
        
        // foot 
        sphere { 0 rad, 1 scale <3.5, 1.5, 1> translate <-0.04, 0, 0> rotate <0, 15, -35> translate <xp, yp, zp> translate <xp, yp, zp> translate legOff }


       // right leg
        #declare xp = 0;
        #declare yp = 0;
        #declare zp = 0;             
        #declare rad = 0.065;
        #declare legOff = <0.05, 0.02, 0.02>;
        // thigh
        #while(yp < 0.035)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate legOff }
                #declare xp = xp+0.0075;
                #declare yp = yp+0.005;
                #declare zp = zp+0.002;     
                #declare rad = rad-0.0015;
        #end  

        #while(yp > -0.145)
                sphere { <xp, yp, zp> rad, 1 translate <xp, yp, zp> translate legOff }
                #declare xp = xp-0.001;
                #declare yp = yp-0.005;
                #declare zp = zp+0.0002;     
                #declare rad = rad-0.00075;
        #end  
 
        // foot 
        sphere { 0 rad, 1 scale <3.5, 1.5, 1> translate <0.04, 0, 0> rotate <0, -15, 35> translate <xp, yp, zp> translate <xp, yp, zp> translate legOff }
        
        // tail
        
        #declare rad = 0.0325;
        #declare zr = 0;
        #declare tailOff = <0.0, 0.0, -0.02>;
        #while(zr < 30)
                sphere { <-0.2, 0, 0> rad, 1 rotate <0, 0, zr> translate <0.2, 0, 0> translate tailOff }
                #declare zr = zr+1;     
                #declare rad = rad-0.0002;
        #end  

//        #declare rad = 0.03;
        #declare zr = 30;
        #declare tailOff = <-0.0375, -0.14, -0.02>;
        #while(zr > -210)
                sphere { <0.075, 0, 0> rad, 1 rotate <0, 0, zr> translate tailOff }
                #declare zr = zr-5;     
                #declare rad = rad-0.0002;
        #end  
  
        #declare zr = -30;
        #declare tailOff = <-0.2125, -0.04, -0.02>;
        // thigh
        #while(zr < 65)
                sphere { <0.125, 0, 0> rad, 1 rotate <0, 0, zr> translate tailOff }
                #declare zr = zr+2;     
                #declare rad = rad-0.0002;
        #end  

//  cylinder { -z, +z, RadiusVal, StrengthVal }
  // [sturm]
}
        
}       






#declare snowTex = texture {
pigment {
// granite poly_wave 10 omega 0.675 lambda 3.5 turbulence <0.25, 0.05, 0.25>//0.182  
//bozo omega 0.75 lambda 2.2 turbulence 0.325 
crackle       
omega 0.7
lambda 2.5
turbulence 0.5
        colour_map { 
/*
                        [ 0.0 rgbt <1, 1, 1, 0.1> ]
                        [ 0.5 rgbt <1, 1, 1, 0.01> ]
                        [ 0.55 rgbt <0.9, 0.825, 0.5, 0.1> ]
                        [ 1.0 rgbt <0.8, 0.675, 0.2, 0.2> ]  
*/
                        [ 0.0 rgbt <.88, 0.9, 0.9, 0.05> ]
                        [ 0.7 rgbt <.88, 0.9, 0.9, 0.005> ]         //.5
                        [ 0.85 rgbt <0.8, 0.725, 0.5, 0.05> ]   //.55
                        [ 1.0 rgbt <0.7, 0.575, 0.2, 0.1> ]  

                        }
                        scale <3.5, 4.75, 3.5>   
}
//finish { diffuse albedo 0.7 specular albedo 0.1 roughness 0.0002 brilliance 0.9 reflection { 0.01, 0.075 fresnel on } conserve_energy
                                           //0.05         //0.0001
finish { diffuse albedo 0.7 specular albedo 0.1 roughness 0.005 brilliance 0.9 reflection { 0.007, 0.05 fresnel on } conserve_energy
#if(useSubSurface)
//      subsurface { translucency <1.295,1.30,1.31> }
//      subsurface { translucency <1.4,1.25,1.1>*0.5 }  //0.9
      subsurface { translucency <1.3,1.2,1.25>*0.9 }  //0.9
#end
 }
normal { granite 0.2 scale 0.005 }
}
 texture {
pigment {
// granite poly_wave 10 omega 0.675 lambda 3.5 turbulence <0.25, 0.05, 0.25>//0.182  
//bozo omega 0.75 lambda 2.2 turbulence 0.325 
crackle       
omega 0.85
lambda 3.5
turbulence 0.85
        colour_map { 
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.675 rgbt <0.9, 0.9, 0.9, 1> ]
                        [ 0.675 rgbt <0.9, 0.9, 0.9, 0.1> ]
                        [ 0.7 rgbt <0.15, 0.085, 0.01, 0.3> ]
                        [ 1.0 rgbt <0.15, 0.085, 0.01, 0.1> ]
                        }                      
                        scale <0.025, 0.05, 0.025>   
}  
                                          //0.05          //0.0001
finish { diffuse albedo 0.7 specular albedo 0.15 roughness 0.005 brilliance 0.9 reflection { 0.007, 0.05 fresnel on } conserve_energy

 }
normal { granite 0.2 scale 0.005 }
}


object { creature
material { texture { pigment { leopard turbulence 0.05 omega 0.7 lambda 3 scale 0.01 colour_map { [ 0 rgbt <.3, .2, 0.05, 0.25>*0.4 ] [0.3 rgb <0.35, 0.45, 0.06>*0.4 ] [ 0.6 rgb <0.14, 0.12, 0.08>*0.4 ] } } 
finish { specular albedo 0.1 roughness 0.005 brilliance 2 diffuse albedo 0.5 reflection { 0.009, 0.02 fresnel on } conserve_energy
#if(useSubSurface)
      subsurface { translucency <4.09,3.59 3.19>*0.5 }  //0.9
#end
}
normal { crackle 1 turbulence 0.1 scale 0.025 } 
}
interior { ior 1.6 }
} 
scale 3.4 rotate <90, -90, -50> rotate <0, 60, 0> translate <2, 3.25, 1.3>
}
  
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
/*
light_source {
  <0,0,0>             // light's position (translated below)
  color rgb <0.05, 0.5, 2>       // light's color
  area_light
  <.3, 0, 0> <0, 0, .3> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <3.5, 2, 1.25>   // <x y z> position of light     
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 5
  fade_power 2

}
 */
// iceTex
#declare iceTex1 = texture {
pigment { rgbf <1, 1, 1, 0.3> }           //0.1          //0.05
finish { diffuse albedo 0.1 specular albedo 0.075 roughness 0.075 brilliance 2.5 reflection { 0.05, 0.01 fresnel on } conserve_energy 
#if(useSubSurface)
//subsurface { translucency <29.5,30,31> }
//subsurface { translucency <34.5,30,31>*0.5 } // remove 0.5
subsurface { translucency <31.5,30,31>*0.55 } // remove 0.5
#end
}
normal { granite 0.1 scale 0.01 }
}

#declare iceTex2 = texture {
pigment { rgbf <1, 1, 1, 0.1> }           //0.15         //0.02
finish { diffuse albedo 0.5 specular albedo 0.1  roughness 0.05 brilliance 1.2 reflection { 0.005, 0.03 fresnel on } conserve_energy 
#if(useSubSurface)
// subsurface { translucency <29.5,30,31> }
// subsurface { translucency <34.5,30,31>*0.5 } // remove 0.5
 subsurface { translucency <31.5,30,31>*0.45 } // remove 0.5
#end
}
normal { granite 0.15 scale 0.008 }
}


#declare snowfunc=function{pigment { average pigment_map { 
[0.02 granite colour_map { [ 0.0 rgb 0] [ 1.0 rgb 1 ] } turbulence 0.75 scale 0.03  ]
[ 0.5 crackle form <0.8, 0, 0>  colour_map { [ 0.0 rgb 0] [ 1.0 rgb 1 ] } turbulence 0.01375 scale 0.12 ]
[ 0.1 wrinkles colour_map { [ 0.0 rgb 0] [ 1.0 rgb 1 ] } turbulence 0.275 scale <0.125, 0.1, 0.1>  ]
[ 1 spherical colour_map {  [ 0.0 rgb 0] [0.5 rgb 1 ] [ 1.0 rgb 0 ] } omega 0.76 lambda 1.6 turbulence 0.1 scale 0.45 translate <0.5, 0.0, 0> ]
   } 
     }
   }   



#if(showSnow)

 // ----------------- HF_Square macro ------------------
#declare Fn_1 =
 function(x, y, z)
  {1-(-f_snoise3d(x*4,y*1,z*4)*0.5)+f_wrinkles(x*500.1,y*10.1, z*500.1)*0.1}
// -----------------------------------------------------
#declare snowPart = intersection {
height_field{
//    function Resolution,Resolution {
//        (sin(y*pi*5)+1)/4+f_ridged_mf(x*28, y*60,z*4, 1.2,3,6,1.18,5,1)*0.55/5

//       f_ridged_mf(x*0.01, y*0.03,z*0.01, 0.2,4,7,1.8,5,2)*0.5
//a        f_ridged_mf(x*0.01, y*0.03,z*0.01, 0.2,4,7,1.8,5,2)*0.5
// (sin(y*pi*10)+1)*0.35+f_ridged_mf(x*14, y*30,z*4, 1.2,3,6,1.18,5,1)*0.55/5

    function 1000,1000 { snowfunc(x, y, z).gray*1+f_ridged_mf(x*8, y*0,z*4, 1.2,3,8,1.18,5,1)*0.0125
       
    } 
    //smooth
  rotate y*90
  }
  box { <0, 0.3, -1> <1, 1.01, 0> }           
}





difference {
merge {

            object{snowPart
            }
            object{snowPart scale <-1, 1, 1>translate <2, 0, 0>
            }
    translate -x*0.5
    scale <0.5,1,1>
  scale<38,3,38>
  rotate<0,70,2>
  translate<20,2.65, 18>

}

// mysits -> community -> Forum -> Technical Product Area -> Poodle/SSLv3
    sphere { <1.9, 0, 2> 6.5 }

    

material {    
texture {       
snowTex
}         
interior { ior 1.31 }   
} 
} // end of HF_Square ---------------------------------- 





#end


#if(showLilyPads)
#declare lCount=0;

#while(lCount < 15)
object { mklPad(0.05) scale 0.4+lr(0.4) rotate <lr(0.5), lr(360), lr(0.5)> translate <-20+lr(18), 2.97+lr(0.01), 7+lr(13)> }
object { mklPad(0.05) scale 0.4+lr(0.4) rotate <lr(0.5), lr(360), lr(0.5)> translate <-20+lr(18), 2.98+lr(0.01), 7+lr(13)> }
object { mklPad(0.05) scale 0.4+lr(0.4) rotate <lr(0.5), lr(360), lr(0.5)> translate <-20+lr(18), 2.99+lr(0.01), 7+lr(13)> }

#declare lCount=lCount+1;

#end

#end

object { mkDandelionSeed(false, 58, 0.02, dlHairTex) scale .5 rotate <24, 70, 0> translate <-4, 9.5, -9> } 
object { mkDandelionSeed(false, 52, 0.02, dlHairTex) scale .5 rotate <34, 60, 0> translate <1, 9.5, -7> } 
object { mkDandelionSeed(false, 48, 0.02, dlHairTex) scale .5 rotate <44, 50, 0> translate <-7, 8.5, -3> } 
object { mkDandelionSeed(false, 48, 0.02, dlHairTex) scale .5 rotate <40, 30, 0> translate <-6, 7.5, 4> } 
object { mkDandelionSeed(false, 48, 0.02, dlHairTex) scale .5 rotate <37, 30, 0> translate <12, 5.5, 4> } 

