//*PMRawBegin
#version 3.7;
//*PMRawEnd

// modify clouds_1 last warp=2 in animation
global_settings {
   adc_bailout 0.0019216
   ambient_light rgb<0, 0, 0>
   assumed_gamma 1
   max_trace_level 20
   number_of_waves 20
   noise_generator 2
   
   radiosity {
      adc_bailout 0.001
      count 55
      error_bound 1.2
      low_error_factor 0.8
      nearest_count 7
      recursion_limit 3
   }
}

#declare Dec_p_atm = pigment {
   spherical
   
   pigment_map {
      [ 0 color rgb<0, 0, 0>
      ]
      [ 0.008 color rgb<1, 1, 1>
      ]
   }
   poly_wave 3.7
}

#declare Dec_m_atmo_plus = material {
   //*PMName m_atmo
   
   texture {
      //*PMName t_atmosphere
      
      pigment {
         //*PMName p_atmosphere
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         density {
            pigment_pattern {Dec_p_atm}
         }
         method 2
         intervals 11
         samples 1,3
         
         scattering {
            1, rgb<1, 1.05, 1.1>
         }
      }
      ior 1
      dispersion 1.012
      dispersion_samples 4
      fade_distance 10
      fade_power 2
   }
   scale 840
}

#declare Dec_m_atmo = material {
   //*PMName m_atmo
   
   texture {
      //*PMName t_atmosphere
      
      pigment {
         //*PMName p_atmosphere
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         density {
            pigment_pattern {Dec_p_atm}
         }
         method 2
         intervals 11
         absorption rgb<1, 1, 1>
         
         scattering {
            1, rgb<2, 2, 2>
         }
      }
   }
   scale 850
}

#declare Dec_brown = pigment {
   color srgb<0.45098, 0.337255, 0.215686>
}

#declare Dec_gray = pigment {
   color srgb<0.572549, 0.545098, 0.462745>
}

#declare Dec_gray_1 = pigment {
   color srgb<0.572549, 0.513725, 0.396078>
}

#declare Dec_green_land = pigment {
   agate
   agate_turb 0.5
   turbulence <0.1, 0.1, 0.1>
   lambda 2.4
   scale 0.2
   
   color_map {
      [ 0 color srgb<0.360784, 0.407843, 0.247059>
      ]
      [ 1 color srgb<0.27451, 0.415686, 0.188235>
      ]
   }
}

#declare Dec_white = pigment {
   color rgb<1, 1, 1>
}

#declare Dec_pigm_cloud_h = pigment {
   bozo
   noise_generator 2
   
   warp {
      turbulence <0.3, 0.3, 0.3>
   }
   
   pigment_map {
      [ 0.3 color rgbt <0, 0, 0, 1>
      ]
      [ 0.8 granite
      noise_generator 2
      
      warp {
         turbulence <1, 1, 1>
         lambda 2.3
      }
      
      color_map {
         [ 0 color rgbt <0, 0, 0, 1>
         ]
         [ 1 color rgb<1, 1, 1>
         ]
      }
      
      warp {
         spherical orientation <0, 0, 1>
      }
      
      warp {
         turbulence <0.1, 0.2, 0.1>
         omega 0.6
         lambda 1.85
      }
      scale <1, 0.4, 1>
      
      warp {
         turbulence <8, 0.3, 0>
         octaves 1
         omega 0.1
         lambda 1
      }
      ]
   }
   scale <0.65, 0.5, 0.65>
   
   warp {
      turbulence <0, 1, 0>
      omega 0.3
      lambda 1
   }
}

#declare Dec_tex_cloud_h = texture {
   pigment {
      //*PMName pigm_cloud_h
      Dec_pigm_cloud_h
   }
   
   finish {
      diffuse 0.6
   }
}

#declare Dec_pigm_cloud_l_1 = pigment {
   bozo
   noise_generator 3
   scale 0.7
   
   warp {
      turbulence <0.8, 0.9, 0.8>
      octaves 7
      lambda 3
   }
   
   warp {
      turbulence <0, 2, 0.1>
      octaves 1
      omega 1
      lambda 1
   }
   
   pigment_map {
      [ 0.2 wrinkles
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.5
      }
      
      pigment_map {
         [ 0 color rgb<1, 1, 1>
         ]
         [ 1 color rgbt <0, 0, 0, 1>
         ]
      }
      poly_wave 2
      scale <0.2, 0.1, 0.2>
      ]
      [ 0.4 color rgbt <0.686275, 0.686275, 0.686275, 1>
      ]
   }
   rotate z*90
}

#declare Dec_pigm_cloud_l = pigment {
   bozo
   noise_generator 3
   scale 0.7
   
   warp {
      turbulence <0.8, 0.9, 0.8>
      octaves 7
      lambda 3
   }
   
   warp {
      turbulence <0, 2, 0.1>
      octaves 1
      omega 1
      lambda 1
   }
   
   pigment_map {
      [ 0.2 wrinkles
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.5
      }
      
      pigment_map {
         [ 0 color rgb<1, 1, 1>
         ]
         [ 1 color rgbt <0, 0, 0, 1>
         ]
      }
      poly_wave 2
      scale <0.2, 0.1, 0.2>
      ]
      [ 0.4 bozo
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         octaves 7
         omega 0.6
      }
      
      pigment_map {
         [ 0.55 color rgbt <0, 0, 0, 1>
         ]
         [ 0.6 color rgbt <1, 1, 1, 0.5>
         ]
         [ 0.65 color rgbt <0, 0, 0, 1>
         ]
      }
      scale <2, 1, 2>
      ]
   }
}

#declare Dec_tex_cloud_l = texture {
   pigment {
      //*PMName p_cloud_l
      Dec_pigm_cloud_l
   }
   
   normal {
      average
      
      normal_map {
         [ 1 agate
         0.5
         agate_turb 0.5
         ]
         [ 0.4 //*PMName n_cloud_l
         pigment_pattern {Dec_pigm_cloud_l}
         ]
      }
   }
   
   finish {
      diffuse 0.8
      brilliance 0.8
      specular 0.02
      roughness 0.02
   }
}

#declare Dec_tex_cloud_hl = texture {
   //*PMName t_cloud_hl
   planar
   
   warp {
      turbulence <0.05, 0, 0>
      lambda 3
   }
   scale 1600
   
   texture_map {
      [ 0.1 //*PMName t_cloud_h_north_n
      Dec_tex_cloud_h
      scale 0.1
      ]
      [ 0.45 //*PMName t_cloud_l_north_n
      Dec_tex_cloud_l
      scale <0.125, 0.1, 0.1>
      ]
      [ 0.55 //*PMName t_cloud_l_north_s
      Dec_tex_cloud_l
      scale <0.125, 0.1, 0.1>
      ]
      [ 0.9 //*PMName t_cloud_h_south_s
      Dec_tex_cloud_h
      scale 0.1
      ]
   }
   translate y*(-800)
}

#declare Dec_tex_ocean = texture {
   pigment {
      color srgb<0, 0.117647, 0.392157>
   }
}

#declare Dec_p_planet = pigment {
   gradient <0, 1, 0>
   turbulence <0.12, 0.12, 0.12>
   lambda 3
   
   pigment_map {
      [ 0 //*PMName ice
      Dec_white
      ]
      [ 0.05 //*PMName ice
      Dec_white
      ]
      [ 0.1 Dec_gray
      ]
      [ 0.2 Dec_brown
      ]
      [ 0.3 Dec_green_land
      ]
      [ 0.7 Dec_green_land
      ]
      [ 0.8 Dec_brown
      ]
      [ 0.9 Dec_gray_1
      ]
      [ 0.95 //*PMName ice
      Dec_white
      ]
      [ 1 //*PMName ice
      Dec_white
      ]
   }
   scale 7.7
}

#declare Dec_p_land = pigment {
   agate
   agate_turb 0.5
   
   pigment_map {
      [ 0.38 Dec_p_planet
      ]
      [ 0.38 //*PMName blue_river
      color srgb<0, 0, 1>
      ]
      [ 0.41 //*PMName blue_river
      color srgb<0, 0, 1>
      ]
      [ 0.41 Dec_p_planet
      ]
   }
   
   warp {
      turbulence <0.1, 0.1, 0.1>
   }
   poly_wave 2.2
}

#declare Dec_p_land_norm = pigment {
   agate
   agate_turb 0.5
   
   pigment_map {
      [ 0.2 agate
      agate_turb 0.5
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.3
      }
      scale 0.2
      
      color_map {
         [ 0 color rgb<0, 0, 0>
         ]
         [ 0.2 color rgb<0.152941, 0.152941, 0.152941>
         ]
         [ 0.6 color rgb<0.262745, 0.262745, 0.262745>
         ]
         [ 1 color rgb<0.152941, 0.152941, 0.152941>
         ]
      }
      ]
      [ 0.35 //*PMName blue_river
      granite
      scale 0.075
      
      color_map {
         [ 0 color rgb<0.00784314, 0.00784314, 0.00784314>
         ]
         [ 1 color rgb<0.0235294, 0.0235294, 0.0235294>
         ]
      }
      ]
      [ 0.5 agate
      agate_turb 0.5
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.3
      }
      scale 0.2
      
      color_map {
         [ 0 color rgb<0, 0, 0>
         ]
         [ 0.2 color rgb<0.152941, 0.152941, 0.152941>
         ]
         [ 0.6 color rgb<0.262745, 0.262745, 0.262745>
         ]
         [ 1 color rgb<0.152941, 0.152941, 0.152941>
         ]
      }
      ]
   }
   
   warp {
      turbulence <0.1, 0.1, 0.1>
   }
   poly_wave 2.2
}

#declare Dec_t_land = texture {
   pigment {
      Dec_p_land
   }
   
   normal {
      pigment_pattern {Dec_p_land_norm}
      0.13
      bump_size 0.3
      accuracy 0.0001
   }
   
   finish {
   }
}

#declare Dec_t_land_coast = texture {
   finish {
   }
   
   pigment {
      pigment_pattern {Dec_p_planet}
      
      pigment_map {
         [ 0 granite
         turbulence <0.4, 0.4, 0.4>
         lambda 2.5
         scale 0.1
         
         pigment_map {
            [ 0 color srgb<0.509804, 0.533333, 0.341176>
            ]
            [ 0.5 color srgb<0.364706, 0.388235, 0.345098>
            ]
         }
         ]
         [ 0.25 granite
         turbulence <0.4, 0.4, 0.4>
         lambda 2.5
         scale 0.1
         
         pigment_map {
            [ 0 color srgb<0.509804, 0.533333, 0.341176>
            ]
            [ 0.5 color srgb<0.290196, 0.470588, 0.145098>
            ]
         }
         ]
         [ 0.75 granite
         turbulence <0.4, 0.4, 0.4>
         lambda 2.5
         scale 0.1
         
         pigment_map {
            [ 0 color srgb<0.509804, 0.533333, 0.341176>
            ]
            [ 0.5 color srgb<0.290196, 0.470588, 0.145098>
            ]
         }
         ]
         [ 1 granite
         turbulence <0.4, 0.4, 0.4>
         lambda 2.5
         scale 0.1
         
         pigment_map {
            [ 0 color srgb<0.509804, 0.533333, 0.341176>
            ]
            [ 0.5 color srgb<0.364706, 0.388235, 0.345098>
            ]
         }
         ]
      }
   }
}

#declare Dec_p_land_mid = pigment {
   agate
   agate_turb 0.5
   
   pigment_map {
      [ 0.38 color srgb<0.286275, 0.188235, 0.0901961>
      ]
      [ 0.38 //*PMName blue_river
      color srgb<0, 0, 1>
      ]
      [ 0.4 //*PMName blue_river
      color srgb<0, 0, 1>
      ]
      [ 0.4 color srgb<0.286275, 0.188235, 0.0901961>
      ]
   }
   
   warp {
      turbulence <0.4, 0.4, 0.4>
      lambda 2.6
   }
   poly_wave 2.2
}

#declare Dec_p_land_mid_norm = pigment {
   agate
   agate_turb 0.5
   
   pigment_map {
      [ 0.27 agate
      agate_turb 0.5
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.3
      }
      scale 0.2
      
      color_map {
         [ 0 color rgb<0, 0, 0>
         ]
         [ 0.2 color rgb<0.152941, 0.152941, 0.152941>
         ]
         [ 0.6 color rgb<0.262745, 0.262745, 0.262745>
         ]
         [ 1 color rgb<0.152941, 0.152941, 0.152941>
         ]
      }
      ]
      [ 0.35 //*PMName blue_river
      granite
      scale 0.075
      
      color_map {
         [ 0 color rgb<0.00784314, 0.00784314, 0.00784314>
         ]
         [ 1 color rgb<0.0235294, 0.0235294, 0.0235294>
         ]
      }
      ]
      [ 0.43 agate
      agate_turb 0.5
      
      warp {
         turbulence <0.5, 0.5, 0.5>
         lambda 2.3
      }
      scale 0.2
      
      color_map {
         [ 0 color rgb<0, 0, 0>
         ]
         [ 0.2 color rgb<0.152941, 0.152941, 0.152941>
         ]
         [ 0.6 color rgb<0.262745, 0.262745, 0.262745>
         ]
         [ 1 color rgb<0.152941, 0.152941, 0.152941>
         ]
      }
      ]
   }
   
   warp {
      turbulence <0.4, 0.4, 0.4>
      lambda 2.6
   }
   poly_wave 2.2
}

#declare Dec_t_land_mid = texture {
   pigment {
      Dec_p_land_mid
   }
   
   normal {
      pigment_pattern {Dec_p_land_mid_norm}
      0.13
      bump_size 0.06
      accuracy 1e-05
   }
   
   finish {
   }
}

#declare Dec_wrinkles = pigment {
   wrinkles
   noise_generator 3
   scale 1.2
   
   warp {
      turbulence <0.1, 0.1, 0.1>
      lambda 2.2
   }
}

#declare Dec_granite = pigment {
   granite
   noise_generator 2
}

#declare Dec_p_mount = pigment {
   pigment_pattern {Dec_granite}
   scale 0.4
   
   pigment_map {
      [ 0.2 color rgb<1, 1, 1>
      ]
      [ 0.4 Dec_gray_1
      ]
   }
   
   warp {
      turbulence <0.1, 0, 0.1>
      lambda 2.5
   }
}

#declare Dec_p_mount_normal = pigment {
   pigment_pattern {Dec_granite}
   scale 0.4
   
   pigment_map {
      [ 0 color rgb<1, 1, 1>
      ]
      [ 1 color rgb<0.203922, 0.203922, 0.203922>
      ]
   }
   poly_wave 0.5
   
   warp {
      turbulence <0.1, 0, 0.1>
      lambda 2.5
   }
}

#declare Dec_tex_continents = texture {
   pigment_pattern {Dec_wrinkles}
   
   texture_map {
      [ 0.2 //*PMName t_mountains
      pigment_pattern {Dec_wrinkles}
      
      texture_map {
         [ 0 //*PMName mount
         
         pigment {
            Dec_p_mount
         }
         
         normal {
            pigment_pattern {Dec_p_mount_normal}
            1
            bump_size 0.85
            accuracy 1e-05
         }
         
         finish {
         }
         ]
         [ 0.4 //*PMName land_mid
         Dec_t_land_mid
         ]
      }
      ]
      [ 0.48 //*PMName t_land
      Dec_t_land
      ]
      [ 0.49 //*PMName t_coast
      Dec_t_land_coast
      ]
      [ 0.495 //*PMName t_coast
      Dec_t_land_coast
      ]
      [ 0.5 //*PMName ocean_coast
      
      pigment {
         color srgb<0, 0.27451, 0.392157>
      }
      ]
      [ 0.6 //*PMName ocean
      
      pigment {
         color srgb<0, 0.113725, 0.388235>
      }
      ]
      [ 0.65 //*PMName ocean_deep
      Dec_tex_ocean
      ]
   }
   scale 0.13
}

#declare Dec_pigm_map_continents = pigment {
   planar
   
   warp {
      turbulence <0.1, 0.2, 0.1>
      lambda 3
   }
   
   warp {
      turbulence <-0.1, -0.2, -0.1>
      lambda 3
   }
}

#declare Dec_tex_surface = texture {
   //*PMName t_surface
   pigment_pattern {Dec_pigm_map_continents}
   
   texture_map {
      [ 0.1 //*PMName north_pole
      
      pigment {
         //*PMName p_north_pole
         Dec_white
      }
      
      finish {
         diffuse 0.6
         brilliance 0.5
         specular 0.05
         roughness 0.05
      }
      ]
      [ 0.1 //*PMName ocean
      Dec_tex_ocean
      ]
      [ 0.14 //*PMName ocean
      Dec_tex_ocean
      ]
      [ 0.14 //*PMName tex_continents
      Dec_tex_continents
      ]
      [ 0.86 //*PMName tex_continents
      Dec_tex_continents
      ]
      [ 0.86 //*PMName ocean
      Dec_tex_ocean
      ]
      [ 0.9 //*PMName ocean
      Dec_tex_ocean
      ]
      [ 0.9 //*PMName south_pole
      
      pigment {
         //*PMName p_south_pole
         Dec_white
      }
      
      finish {
         diffuse 0.6
         brilliance 0.5
         specular 0.05
         roughness 0.05
      }
      ]
   }
}

union {
   //*PMName planet
   
   sphere {
      //*PMName terra
      <0, 0, 0>, 800
      
      texture {
         //*PMName t_terra
         Dec_tex_surface
         scale 1600
         translate y*(-800)
      }
      hollow false
   }
   
   sphere {
      //*PMName clouds
      <0, 0, 0>, 800.1
      
      texture {
         //*PMName t_clouds
         Dec_tex_cloud_hl
      }
      no_shadow
      hollow
   }
   
   sphere {
      //*PMName atmosphere
      <0, 0, 0>, 840
      
      material {
         //*PMName m_atmosphere
         Dec_m_atmo_plus
      }
      no_shadow
      no_reflection
      hollow
   }
   //*PMRawBegin
   //rotate 360*clock*y
   //*PMRawEnd
   rotate y*180
   no_reflection
   hollow
}

camera {
   orthographic
   location <0, 0, -1900>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <3021, 0, 0>
   up <0, 1700, 0>
   look_at <0, 0, 0>
}

light_source {
   <40000, 0, -40000>, rgb<1, 1, 1>
   parallel
   fade_distance 56565
   fade_power 10000
}

#declare Dec_p_d_star = pigment {
   spherical
   poly_wave 3
}

#declare Dec_density_star = density {
   pigment_pattern {Dec_p_d_star}
}

#declare Dec_pp_arm = pigment {
   //*PMRawBegin
   function{ (4/ (1 + pow( (x*x  + y*y + z*z), 2 )))*2 }
   
   turbulence <4,4,0>
   //*PMRawEnd
}

#declare Dec_pp_linear = pigment {
   //*PMRawBegin
   function{ 1-(pow((x*x  + y*y),.5))/1.6 }
   
   //*PMRawEnd
}

#declare Dec_pp_spheric = pigment {
   //*PMRawBegin
   function{ ( pow( (x*x  + y*y + z*z), 4 )) }
   turbulence 30
   //*PMRawEnd
}

#declare Dec_pp_spiral1 = pigment {
   spiral1 2
   turbulence <0.15, 0.1, 0.15>
   lambda 3
   
   warp {
      turbulence <-0.1, -0.1, -0.1>
      lambda 2.5
   }
}

#declare Dec_Cmap_colored_arm = color_map {
   [ 0 color rgbt <0, 0, 0, 1>
   ]
   [ 0.03 color rgbt <0.768627, 0.596078, 0.411765, 1>
   ]
   [ 0.05 color rgbt <1, 0.682353, 0.482353, 1>
   ]
   [ 0.09 color rgb<1, 1, 1>
   ]
}

union {
   //*PMName u_galaxy_sphere_pow
   
   sphere {
      //*PMName sphere_center
      <0, 0, 0>, 1.1
      
      material {
         texture {
            pigment {
               color rgbt <1, 1, 1, 1>
            }
         }
         
         interior {
            media {
               density {
                  spherical
                  
                  density_map {
                     [ 0 color rgb<0, 0, 0>
                     ]
                     [ 0.25 pigment_pattern {Dec_pp_spiral1}
                     
                     density_map {
                        [ 0.9 color rgbt <0, 0, 0, 1>
                        ]
                        [ 1 pigment_pattern {Dec_pp_arm}
                        
                        color_map {
                           [ 0 color rgbt <0, 0, 0, 1>
                           ]
                           [ 0.08 color rgbt <1, 1, 1, 1>
                           ]
                           [ 0.2 color rgbt <0, 0, 0, 1>
                           ]
                           [ 0.3 color rgbt <1, 0.662745, 0.403922, 1>
                           ]
                           [ 0.4 color rgbt <1, 1, 1, 1>
                           ]
                           [ 1 color rgbt <0.447059, 0.4, 0.239216, 1>
                           ]
                        }
                        scale <0.05, 0.05, 1>
                        ]
                     }
                     ]
                  }
               }
               intervals 11
               samples 1,5
               emission rgb<0.22, 0.25, 0.27>
            }
            
            media {
               //*PMName media_star
               
               density {
                  //*PMName density_star
                  Dec_density_star
                  scale 0.2
               }
               intervals 25
               samples 5,10
               emission rgb<0.04, 0.04, 0.06>
            }
         }
      }
      scale <1, 1, 3>
      no_shadow
      no_reflection
      hollow
   }
   
   sphere {
      //*PMName sphere_arms
      <0, 0, 0>, 1.5
      
      material {
         texture {
            pigment {
               color rgbt <1, 1, 1, 1>
            }
         }
         
         interior {
            media {
               density {
                  average
                  
                  warp {
                     turbulence <0.1, 0.1, 0.1>
                  }
                  
                  density_map {
                     [ 1 pigment_pattern {Dec_pp_spiral1}
                     
                     warp {
                        turbulence <0.11, 0.11, 0.11>
                        lambda 2.2
                     }
                     
                     density_map {
                        [ 0.9 color rgbt <0, 0, 0, 1>
                        ]
                        [ 1 pigment_pattern {Dec_pp_spheric}
                        
                        color_map {
                           [ 0.8 color rgbt <0, 0, 0, 1>
                           ]
                           [ 1 color rgb<20, 15, 10>
                           ]
                        }
                        scale 0.02
                        ]
                     }
                     scale <0.7, 0.7, 0.3>
                     ]
                     [ 1 pigment_pattern {Dec_pp_spiral1}
                     
                     warp {
                        turbulence <0.1, 0.1, 0.1>
                     }
                     
                     density_map {
                        [ 0.9 color rgbt <0, 0, 0, 1>
                        ]
                        [ 1 pigment_pattern {Dec_pp_spheric}
                        
                        color_map {
                           [ 0.8 color rgbt <0, 0, 0, 1>
                           ]
                           [ 1 color rgb<25, 25, 20>
                           ]
                        }
                        scale 0.02
                        ]
                     }
                     scale <0.7, 0.7, 0.3>
                     rotate y*10
                     ]
                  }
               }
               intervals 11
               samples 5,5
               emission rgb<0.05, 0.05, 0.05>
            }
            
            media {
               //*PMName media_colored_arm
               
               density {
                  pigment_pattern {Dec_pp_linear}
                  
                  warp {
                     turbulence <0.2, 0.2, 0.2>
                     lambda 2.5
                  }
                  
                  warp {
                     turbulence <-0.2, -0.2, -0.2>
                     lambda 2.5
                  }
                  
                  density_map {
                     [ 0.2 color rgbt <0, 0, 0, 1>
                     ]
                     [ 0.6 pigment_pattern {Dec_pp_spiral1}
                     
                     density_map {
                        [ 0.2 color rgbt <0, 0, 0, 1>
                        ]
                        [ 0.8 pigment_pattern {Dec_pp_arm}
                        
                        color_map {
                           Dec_Cmap_colored_arm
                        }
                        scale <0.2, 0.2, 0.02>
                        ]
                        [ 1 color rgbt <0, 0, 0, 1>
                        ]
                     }
                     scale 1
                     ]
                     [ 1 color rgbt <0, 0, 0, 1>
                     ]
                  }
               }
               method 2
               intervals 11
               samples 5,10
               emission rgb<0.3, 0.3, 0.3>
            }
         }
      }
      scale <1, 1, 0.1>
      no_shadow
      no_reflection
      hollow
   }
   scale <110, 100, 100>
   rotate <111.1, 0, 30>
   translate <-1311.62, -601.446, -61.1602>
   //*PMRawBegin
   no_radiosity
   //*PMRawEnd
   no_shadow
   no_reflection
   hollow
}

#declare Dec_star = sphere {
   <0, 0, 0>, 0.5
   no_shadow
   no_reflection
   hollow
}

#declare Dec_merge_star = merge {
   //*PMName merge_star
   
   object {
      //*PMName obj_star
      Dec_star
      no_shadow
      no_reflection
      hollow
   }
   
   object {
      //*PMName obj_star_spyke
      Dec_star
      scale <0.2, 4, 1>
      no_shadow
      no_reflection
      hollow
   }
   
   object {
      //*PMName obj_star_spyke_oriz
      Dec_star
      scale <4, 0.2, 1>
      no_shadow
      no_reflection
      hollow
   }
   no_shadow
   no_reflection
   hollow
}
//*PMRawBegin
#declare Rnd_x = seed (35);
#declare Rnd_y = seed (74);
#declare Rnd_scale = seed (32);
#declare Rnd_emis = seed (17);
#declare Rnd_red = seed (9);
#declare Rnd_blu = seed (963);
#declare Rnd_green = seed (7765);
#declare Rnd_turb = seed (762);
#declare scala = 10;
#declare lumen = 1;
#declare ymin = -1000;
#declare ymax = 1000;
#declare xmin = -1600;
#declare xmax = 1600;
#declare ydelta = 80;
#declare xdelta = 150;

#for (y_cols, ymax , ymin , -ydelta)

 #for (x_line, xmin , xmax , xdelta)
          #local scale_var = -5 + ( 10 * rand( Rnd_scale ) );
          #local scaling = rand(Rnd_scale) * scala + scale_var;
          #local x_var = (-1+2* rand( Rnd_x ))*100;
          #local y_var = (-1+2* rand( Rnd_y ))*100;
  object{ Dec_merge_star
          texture { pigment { color rgbt <1, 1, 1, 1> } }
          interior {
           media {
            density { Dec_density_star turbulence rand(Rnd_turb)*.2 }
            intervals 11
            samples 1,2
            emission rgb< lumen+rand(Rnd_red)*9 , lumen , lumen+rand(Rnd_blu)*9 >/(scaling*2)
           }
           media {         
            density { Dec_density_star scale <1, 4, 1> }
            intervals 11
            emission rgb<lumen, lumen, lumen>/scaling       
           }
           media {
            density { Dec_density_star scale <4, 1, 1> }
            intervals 11
            emission rgb<lumen, lumen, lumen>/scaling
           }
          }
          scale scaling
          translate< x_line+x_var , y_cols+y_var , 5000 >
          hollow
          no_radiosity
  }
 #end

#end
//*PMRawEnd
//*PMRawBegin
#declare Rnd_x = seed (678);
#declare Rnd_y = seed (986);
#declare Rnd_scale = seed (124);
#declare Rnd_emis = seed (324);
#declare Rnd_red = seed (679);
#declare Rnd_blu = seed (4236);
#declare Rnd_green = seed (459);
#declare Rnd_turb = seed (927);
#declare scala = 4;
#declare lumen = 1;
#declare ymin = -1000;
#declare ymax = 1000;
#declare xmin = -1600;
#declare xmax = 1600;
#declare ydelta = 60;
#declare xdelta = 120;

#for (y_cols, ymax , ymin , -ydelta)

 #for (x_line, xmin , xmax , xdelta)
          #local scale_var = -5 + ( 10 * rand( Rnd_scale ) );
          #local scaling = rand(Rnd_scale) * scala + scale_var;
          #local x_var = (-1+2* rand( Rnd_x ))*100;
          #local y_var = (-1+2* rand( Rnd_y ))*100;
  object{ Dec_merge_star
          texture { pigment { color rgbt <1, 1, 1, 1> } }
          interior {
           media {
            density { Dec_density_star turbulence rand(Rnd_turb)*.2 }
            intervals 1
            samples 1,2
            emission rgb< lumen+rand(Rnd_red)*10 , lumen , lumen+rand(Rnd_blu)*10 >/scaling
           }
           media {         
            density { Dec_density_star scale <1, 4, 1> }
            intervals 11
            emission rgb<lumen, lumen, lumen>/scaling           
           }
           media {
            density { Dec_density_star scale <4, 1, 1> }
            intervals 11
            emission rgb<lumen, lumen, lumen>/scaling
           }
          }
          scale scaling
          translate< x_line+x_var , y_cols+y_var , 5000 >
          hollow
          no_radiosity
  }
 #end

#end
//*PMRawEnd
//*PMRawBegin
#declare Rnd_x = seed (44);
#declare Rnd_y = seed (87);
#declare Rnd_scale = seed (111);
#declare Rnd_emis = seed (29);
#declare Rnd_red = seed (132);
#declare Rnd_blu = seed (325);
#declare Rnd_green = seed (7895);
#declare Rnd_turb = seed (357);
#declare scala = .5;
#declare lumen = 1;
#declare ymin = -1000;
#declare ymax = 1000;
#declare xmin = -1600;
#declare xmax = 1600;
#declare ydelta = 8;
#declare xdelta = 15;

#for ( y_cols , ymax , ymin , -ydelta )

 #for ( x_line , xmin , xmax , xdelta )
          #local x_var = (-1+2* rand( Rnd_x ))*100;
          #local y_var = (-1+2* rand( Rnd_y ))*100;
          #local scale_var = -1 + ( 2 * rand( Rnd_scale ) );
          #local scaling = rand(Rnd_scale) * scala + scale_var;
  object{ Dec_merge_star

          texture { pigment { color rgbt <1, 1, 1, 1> } }
          interior {
           media {
            density { Dec_density_star }
            intervals 11
            samples 1,2
            emission rgb< lumen+rand(Rnd_red)*5 , lumen , lumen+rand(Rnd_blu)*5 >/scaling
           }
          }
          scale scaling
          translate< x_line+x_var , y_cols+y_var , 5000 >
          hollow
          no_radiosity
  }
 #end

#end
//*PMRawEnd
//*PMRawBegin
#declare Rnd_x = seed (897);
#declare Rnd_y = seed (3261);
#declare Rnd_scale = seed (11759);
#declare Rnd_emis = seed (5782);
#declare Rnd_red = seed (6743);
#declare Rnd_blu = seed (545);
#declare Rnd_green = seed (1875);
#declare Rnd_turb = seed (2314);
#declare scala = 60;
#declare lumen = 1;
#declare ymin = -1000;
#declare ymax = 1000;
#declare xmin = -1600;
#declare xmax = 1600;
#declare ydelta = 100;
#declare xdelta = 200;

#for (y_cols, ymax , ymin , -ydelta)

 #for (x_line, xmin , xmax , xdelta)
          #local x_var = (-1+2* rand( Rnd_x ))*100;
          #local y_var = (-1+2* rand( Rnd_y ))*100;
          #local scale_var = -50 + ( 100 * rand( Rnd_scale ) );
          #local scaling = rand(Rnd_scale) * scala + scale_var;
          #local redshift = lumen + ( 2 * rand( Rnd_red ) );
          #local blushift = lumen + ( 2 * rand( Rnd_blu ) );
          #if( redshift > blushift )
           #local redshift = redshift * 1.25;
           #local blushift = blushift / 1.25;
          #else
           #local redshift = redshift / 2;
           #local blushift = blushift * 1.5;
          #end
  sphere{ <0,0,0> 1
          texture { pigment { color rgbt <1, 1, 1, 1> } }
          interior {
           media {
            density { Dec_density_star scale .5 
                     warp{ turbulence < rand(Rnd_turb)*3 , rand(Rnd_turb)*3 , rand(Rnd_turb)*3 >lambda 3}
             }
            intervals 1
            samples 2,4
            //emission rgb < redshift , lumen , blushift >/(scaling*30)
            emission rgb < .41 , .28 , .22 >*redshift/(scaling*5)
           }
          }
          scale <rand(Rnd_scale)*scaling , rand(Rnd_scale)*scaling , rand(Rnd_scale)*scaling>*10
          translate< x_line+x_var , y_cols+y_var , 5000 >
          hollow
          no_radiosity
  }
 #end

#end
//*PMRawEnd

#declare Dec_p_univ = pigment {
   granite
   noise_generator 3
   
   warp {
      turbulence <0.5, 0.5, 0.5>
      lambda 2.3
   }
   
   color_map {
      [ 0 color rgb<0.129412, 0.0980392, 0.0666667>
      ]
      [ 0.3 color rgb<0.0862745, 0.0196078, 0>
      ]
      [ 1 color rgb<0.0470588, 0.0392157, 0.0392157>
      ]
   }
   poly_wave 2
   
   warp {
      turbulence <0.7, 0.5, 0.5>
      lambda 2.3
   }
}