/* linear_v_srgb.pov
 * Persistence of Vision Ray Tracer scene description file
 *
 * Compare POV-Ray stock colors with and without gamma adjustment.
 *
 * Copyright © 2014 Richard Callwood III.  Some rights reserved.
 * This work is licensed under a Creative Commons Attribution-NonCommercial-
 * ShareAlike 3.0 Unported License.  For the legalese, see:
 *   http://creativecommons.org/licenses/by-nc-sa/3.0/deed.en_US
 *
 * 25-nov-2014  Created.
 */
#version 3.7;

#ifndef (Diffuse) #declare Diffuse = 0.6; #end
#ifndef (Draft) #declare Draft = no; #end

#include "colors.inc"
#include "shapes.inc"

global_settings { assumed_gamma 1 }

#declare SPACING = 2.2;
camera
{ orthographic
  location -10 * z
  right 13 * SPACING * x
  up 8 * SPACING * y
}

light_source
{ <0, 1, -1> * 1000, rgb 1
  parallel point_at 0
  #if (!Draft)
    area_light 250 * x, 250 * y, 9, 9
    circular orient adaptive 0 jitter
  #end
}

#default { finish { ambient Diffuse / 6 diffuse Diffuse } }

plane
{ -z, 0
  pigment { rgb 0.5 }
}

//==============================================================================

#declare N = 102;

#declare Colors = array[N]
{ Red, Yellow, Green, Cyan, Blue, Magenta, White, Gray50, Black,
  Aquamarine, BlueViolet, Brown, CadetBlue, Coral, CornflowerBlue,
  DarkGreen, DarkOliveGreen, DarkOrchid, DarkSlateBlue, DarkSlateGray,
  DarkSlateGrey, DarkTurquoise, Firebrick, ForestGreen, Gold, Goldenrod,
  GreenYellow, IndianRed, Khaki, LightBlue, LightSteelBlue, LimeGreen,
  Maroon, MediumAquamarine, MediumBlue, MediumForestGreen, MediumGoldenrod,
  MediumOrchid, MediumSeaGreen, MediumSlateBlue, MediumSpringGreen,
  MediumTurquoise, MediumVioletRed, MidnightBlue, Navy, NavyBlue, Orange,
  OrangeRed, Orchid, PaleGreen, Pink, Plum, Salmon, SeaGreen, Sienna,
  SkyBlue, SlateBlue, SpringGreen, SteelBlue, Tan, Thistle, Turquoise,
  Violet, VioletRed, Wheat, YellowGreen, SummerSky, RichBlue, Brass,
  Copper, Bronze, Bronze2, Silver, BrightGold, OldGold, Feldspar, Quartz,
  NeonPink, DarkPurple, NeonBlue, CoolCopper, MandarinOrange, LightWood,
  MediumWood, DarkWood, SpicyPink, SemiSweetChoc, BakersChoc, Flesh,
  NewTan, NewMidnightBlue, VeryDarkBrown, DarkBrown, DarkTan,
  GreenCopper, DkGreenCopper, DustyRose, HuntersGreen, Scarlet,
  Med_Purple, Light_Purple, Very_Light_Purple,
}
#declare Names = array[N][3]
{ { "Red", "", "" },
  { "Yellow", "", "" },
  { "Green", "", "" },
  { "Cyan", "", "" },
  { "Blue", "", "" },
  { "Magenta", "", "" },
  { "White", "", "" },
  { "Gray50", "", "" },
  { "Black", "", "" },
  { "Aquamarine", "", "" },
  { "Blue", "Violet", "" },
  { "Brown", "", "" },
  { "Cadet", "Blue", "" },
  { "Coral", "", "" },
  { "Cornflower", "Blue", "" },
  { "Dark", "Green", "" },
  { "Dark", "Olive", "Green" },
  { "Dark", "Orchid", "" },
  { "Dark", "Slate", "Blue" },
  { "Dark", "Slate", "Gray" },
  { "Dark", "Slate", "Grey" },
  { "Dark", "Turquoise", "" },
  { "Firebrick", "", "" },
  { "Forest", "Green", "" },
  { "Gold", "", "" },
  { "Goldenrod", "", "" },
  { "Green", "Yellow", "" },
  { "Indian", "Red", "" },
  { "Khaki", "", "" },
  { "Light", "Blue", "" },
  { "Light", "Steel", "Blue" },
  { "Lime", "Green", "" },
  { "Maroon", "", "" },
  { "Medium", "Aquamarine", "" },
  { "Medium", "Blue", "" },
  { "Medium", "Forest", "Green" },
  { "Medium", "Goldenrod", "" },
  { "Medium", "Orchid", "" },
  { "Medium", "Sea", "Green" },
  { "Medium", "Slate", "Blue" },
  { "Medium", "Spring", "Green" },
  { "Medium", "Turquoise", "" },
  { "Medium", "Violet", "Red" },
  { "Midnight", "Blue", "" },
  { "Navy", "", "" },
  { "Navy", "Blue", "" },
  { "Orange", "", "" },
  { "Orange", "Red", "" },
  { "Orchid", "", "" },
  { "Pale", "Green", "" },
  { "Pink", "", "" },
  { "Plum", "", "" },
  { "Salmon", "", "" },
  { "Sea", "Green", "" },
  { "Sienna", "", "" },
  { "Sky", "Blue", "" },
  { "Slate", "Blue", "" },
  { "Spring", "Green", "" },
  { "Steel", "Blue", "" },
  { "Tan", "", "" },
  { "Thistle", "", "" },
  { "Turquoise", "", "" },
  { "Violet", "", "" },
  { "Violet", "Red", "" },
  { "Wheat", "", "" },
  { "Yellow", "Green", "" },
  { "Summer", "Sky", "" },
  { "Rich", "Blue", "" },
  { "Brass", "", "" },
  { "Copper", "", "" },
  { "Bronze", "", "" },
  { "Bronze2", "", "" },
  { "Silver", "", "" },
  { "Bright", "Gold", "" },
  { "Old", "Gold", "" },
  { "Feldspar", "", "" },
  { "Quartz", "", "" },
  { "Neon", "Pink", "" },
  { "Dark", "Purple", "" },
  { "Neon", "Blue", "" },
  { "Cool", "Copper", "" },
  { "Mandarin", "Orange", "" },
  { "Light", "Wood", "" },
  { "Medium", "Wood", "" },
  { "Dark", "Wood", "" },
  { "Spicy", "Pink", "" },
  { "Semi", "Sweet", "Choc" },
  { "Bakers", "Choc", "" },
  { "Flesh", "", "" },
  { "New", "Tan", "" },
  { "New", "Midnight", "Blue" },
  { "Very", "Dark", "Brown" },
  { "Dark", "Brown", "" },
  { "Dark", "Tan", "" },
  { "Green", "Copper", "" },
  { "Dk", "Green", "Copper" },
  { "Dusty", "Rose", "" },
  { "Hunters", "Green", "" },
  { "Scarlet", "", "" },
  { "Med_", "Purple", "" },
  { "Light_", "Purple", "" },
  { "Very_", "Light_", "Purple" },
}

#macro Text (S)
  Center_Object (text { ttf "cyrvetic" S 1, 0 }, x)
#end

#macro Sample (Index)
  #local Adjusted =
    srgb <Colors[Index].red, Colors[Index].green, Colors[Index].blue>;
  #local Label = Center_Object
  ( #if (Names[Index][1] = "") object #else union #end
    { #for (Line, 0, 2)
        #if (Names[Index][Line] != "")
          object { Text (Names[Index][Line]) translate -Line * y }
        #end
      #end
    },
    y
  )
  intersection
  { sphere { 0, 1 }
    plane { -z, 0.75 }
    pigment
    { object
      { Label scale <0.24, 0.24, -1>
        pigment
        { gradient x color_map { [0.5 Adjusted] [0.5 Colors[Index]] }
          scale 2
        }
        pigment { rgb (Colors[Index].gray < 0.5? 1: 0) }
      }
    }
  }
#end

#for (I, 0, N-1)
  object
  { Sample (I)
    translate
    < (mod (I, 13) - 6) * SPACING,
      (3.5 - floor (I / 13)) * SPACING,
      0
    >
  }
#end
