#version 3.7;
//--------------------------------------------------------------------------
// The HDR probe with this demo is no good, just included for those who do not have
// access to a better one, I suggest changing this for a decent outdoor probe.
//
//

#include "dandelion.inc"



#declare useFocalBlur           = 2; // 1-10  used 6  
#declare useRad                 = 1;// 1=load 2=save
#declare radQuality             = 1;// 1-10 1=low 10=high     // norad tood 36 minutes  with rad 2h33m
#declare useHDR                 = 1;

global_settings{ assumed_gamma 1.0 }                                                                                                                                 
 
// radiosity (global illumination) settings
global_settings {   

#if(useRad)
ambient_light 0
  radiosity {

#if(useRad = 2)
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.0005           // end pretrace at this size
#end
#if(useRad = 1)
    pretrace_start 1           // start pretrace at this size
    pretrace_end   1           // end pretrace at this size
    always_sample off  // 
#end

    count 20*radQuality 75*radQuality                      // higher -> higher quality (1..1600) [35]

    nearest_count 10+(radQuality) 5+radQuality //10+(radQuality/2)               // higher -> higher quality (1..10) [5]

    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    adc_bailout 0.01/2
    error_bound 1.1-(radQuality/10)               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    brightness 0.5             // brightness of radiosity effects (0..1) [1]
    normal on                  // take surface normals into account [off]

  }
#end 
}

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
                           
camera {
                           location  <1, 10, -16>
                            right     x*image_width/image_height
                            look_at   <1, 3, 3>
                            
#if(useFocalBlur)
  aperture 0.0001         // [0...N] larger is narrower depth of field (blurrier)
  blur_samples useFocalBlur*20       // number of rays per pixel for sampling
  focal_point <1, 3, -5> // z=0.5 <3.075, 1, -2.25>
  confidence 0.9+(0.009*useFocalBlur) //0.8999+(useFocalBlur/1000)           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/(20000*useFocalBlur)            // [0...1] how precise to calculate (smaller is more accurate)
#end                            
}

#if(useHDR)
sphere  { 0 1 hollow
  pigment{
    image_map{ hdr "tate_env.hdr"  //Portsmouth_Probe
               map_type 1 interpolate 2 }
      }// end pigment        
      finish { ambient 1 diffuse 1 emission 0.25 }//0.7}    
      
    scale 4000 // no_image     
    translate <0, 0, 0>
    rotate <0, 0, 0>  // -140
    no_image
} // end
#end     

// Create an infinite sphere around scene and allow any pigment on it
sky_sphere{ pigment { bozo  triangle_wave 
                      color_map { [0.00 rgb 0.3 ]
                                  [1.00 rgb 0.1] 
                                } 
                      scale 2         
                    } // end of pigment
          } //end of skysphere -------------------------------------


light_source {
  <0,0,0>             // light's position (translated below)
  color rgb <1, 0.8, 0.6>*1       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <60, 100, -250>   // <x y z> position of light  
  fade_distance 10000
  fade_power 2

} 


#declare dlHeadTex = material {
texture {
pigment { rgb <0.375, 0.475, 0.2>*0.5 }
finish { specular albedo 0.2 roughness 0.1 brilliance 1.4 diffuse albedo 0.6 reflection { 0.009, 0.01 fresnel on } conserve_energy } 
normal { quilted 1 scale 0.1 turbulence 0.3 }
}
interior { ior 1.6 }
}
#declare dStemTex =     material {
texture { pigment { wrinkles triangle_wave omega 0.85 lambda 3 turbulence 0.1 colour_map { [ 0.0 rgb <0.15, 0.227, 0.01> ] [ 0.85 rgb <0.1, 0.2, 0.008> ]  [ 1.0 rgb <.175, 0.1, .01> ]  } scale 1 }
 finish { specular albedo 0.1 roughness 0.07 brilliance 1.2 diffuse albedo 0.65 reflection { 0.01, 0.05 fresnel on } conserve_energy }
    normal { granite 0.2 scale 0.3 turbulence 0.3 }
 }   
texture { pigment { gradient y triangle_wave omega 0.9 lambda 5 turbulence 0.2 colour_map { [ 0.0 rgbt <0.15, 0.227, 0.01, 0.6> ] [ 1.0 rgbt <.175, 0.085, .007, 0.01> ]  } scale 130 translate <0, 70, 0>  }
 }   
interior { ior 1.6 }
}
  
#declare seedTex = texture {
    pigment { bozo triangle_wave omega 0.65 lambda 2.3 colour_map { [ 0.0 rgb <0.185, 0.075, 0.004>*0.15 ] [ 1.0 rgb <0.375, 0.195, 0.08>*0.15 ] } scale 0.3 }
    finish { specular albedo 0.3 roughness 0.05 brilliance 4.8 diffuse albedo 0.4 reflection { 0.008, 0.05 fresnel on } conserve_energy }  
    normal { granite 0.4 scale 0.001 }
} 

#local dlBaseTex1 = texture { pigment { uv_mapping gradient y triangle_wave turbulence 0.2 omega 0.8 lambda 3 colour_map { [ 0.0 rgb <0.11, 0.14, 0.01> ] [ 0.4 rgb <0.046, 0.11, 0.004> ]  [ 1 rgb <0.03, 0.09, 0.002> ] }  }
     finish { specular 0.1 roughness 0.005 brilliance 1.5 diffuse albedo 0.4 reflection { 0.009, 0.05 fresnel on } conserve_energy } 
        normal {  average normal_map { [ 0.8 crackle 1 scale 0.075 turbulence 0.3 ] [ 0.5 granite 0.5 scale 0.001 turbulence 0.5 ] } }
    }


#declare dlBrownTex = material {
texture { dlBaseTex1 }
texture { pigment {  bozo turbulence 0.2 omega 0.4 lambda 2 colour_map {  [ 0.0 rgbt <0.07, 0.02, .0005, 0.1>  ][ 0.05 rgbt <0.09, 0.03, 0.001, 0.1>  ] [ 0.175 rgbt <0.045, 0.02, 0.0005, 0.2> ] [0.175 rgbt 1 ] [ 1.0 rgbt 1 ] }  warp { repeat y flip x }  scale 0.05 }
     finish { specular 0.025 roughness 0.005 brilliance 2.5 diffuse albedo 0.2 reflection { 0 } conserve_energy } 
}
interior { ior 1.6 }
}

#declare dlHairTex = material {
                texture {
                    pigment { rgb <0.98, 1, 1>*0.45 }
                    finish { specular albedo 0.15 roughness 0.05 diffuse albedo 0.7, 0.2 brilliance 0.7 reflection { 0.01, 0.03 fresnel on } conserve_energy }
                }
                interior { ior 1.5 }
            }            


//object { mkDandelionCluster() translate <1, 5, -14> }    
#declare dlC = object 
{ 
    mkDandelionCluster(
        3,      // numDandelions - number of flower heads 
        5,      // minSeeds - number of seeds ranges from 2-7 seem about right
        7,      // maxSeeds - should be >= minSeeds  2-7 seem about right   
        48,     // num seed hairs - Hairs/seed    
        0.02,   // hair Thickness   
        true,   // use Low Memory option recommended for all but extreme close ups as alows more copies (reduced memory usage).
        1,      // min_stem_bends 
        1,      // max_stem_bends
        8,      // minimum amount of bend 
        12,     // maximum amount of bend
        0.05,   // stemStep distance between cylinders in the stem decrease if you can see the straight edges 
        24,     // numLeaves, these will be rotated randomly'ish around the base.
        15,     // minLeafRotation - min angle upwards
        55,     // maxLeafRotation - max angle upwards          
        0.1,    // minLeafBend - min amount the leaf bends 0.1-.3 seem reasonable  
        0.3,    // maxLeafBend - max amount of bend   
        0.01,    // leafDetail 0.01 good, 0.1 low
        dlBrownTex, // leaf texture
        dStemTex,   // stem texture
        dlHairTex,    // hair texture    
        dlHeadTex
        )
}      

object { dlC translate <1, 2, -6> }

        