// ----------------------------------------------------------------------
// Persistence of Vision Ray Tracer Scene Description File
// File: stpaul.inc
// Desc: The dome of St. Pauls Cathedral.
// Date: 1996.10.04
// Auth: Ib Rasmusen (ib@ibras.dk)
// ----------------------------------------------------------------------
// Desc: The front of St. Pauls Cathedral.
// Date: April-May 2003
// Auth: Ib Rasmusen (ib@ibras.dk)
// 
// For use in the Capriccio project run in the newsgroups on the 
// povray.org newsserver, the front of the cathedral was added.
// Only the part visible in the Cappricio scene was modelled.      
// This file imports statue include files by Jim Charter
// and a height_field png-file by Peter Hertel
// ----------------------------------------------------------------------
// Conditions of use:
// You have my permission to use these objects in your own scenes, as
// long as you don't pass it of as your own creation. 
// (This permission does not extend to the included files, which are
// the property of their authors.)
// ----------------------------------------------------------------------
// This file assumes that the standard pov includes are included
// in your main scene file.
//
// This scene was not written with publication in mind, so it is not
// commented, and the object naming is a mess of mixed danish and english
// ----------------------------------------------------------------------

/************************ Declarations *******************************/

#ifndef(ShowDetail)
   #declare ShowDetail = 1;
#end

#ifndef(showDome)
   #declare showDome = 1;
#end

/*-------------------------- Textures -------------------------------*/

#declare T_Stp_Stone=texture {
	pigment {
		granite
		color_map {
			[0 0.5 color rgb<0.96, 0.96, 1>*1.12 color rgb<0.95, 0.95, 1>*1.12]
			[0.5 1 color rgb 1 color rgb 1]
		}
		scale 0.003
	}
	finish {diffuse 0.63}
	normal{bumps bump_size 0.1 scale 0.01}
}

#declare T_Stp_Stairs=texture {
   pigment { rgb <0.3, 0.3, 0.3> }
}

/* Original textures
#declare T_Stp_Lead=texture {
   pigment { rgb 0.70 }        
   finish { ambient 0.0 diffuse 0.6  }
}
texture {
   pigment{ gradient y
      color_map{
	      [0.000, 0.500 color rgbf <0.99, 0.99, 0.99, 1.0>
		                 color rgbf <0.99, 0.99, 0.99, 0.0>]
	      [0.500, 1.001 color rgbf <0.99, 0.99, 0.99, 0.0>
		                 color rgbf <0.99, 0.99, 0.99, 0.0>]
      }
   }
   finish { ambient 0.0 diffuse 0.6  }
}

#declare T_Stp_Gold = texture {
   T_Gold_3A
}
*/   
// textures suggested by Matti Karnaattu
/*
#declare T_Stp_Lead = texture {
	pigment {color rgb <0.24398, 0.22308, 0.25292> }
	finish {ambient 0 diffuse 1 }
};
*/

#local T_Stp_Lead1 = texture {
	pigment{
		image_map{jpeg "cathedral/dome1.jpg" once}
		scale<1/8, 1/2, 1/8>
		translate y*0.5
	
		warp{repeat z/8}
		warp{repeat x/8}
		warp{spherical}
		
		rotate y*5.625
	}
	finish{diffuse 0.56 phong 0}
};

#local T_Stp_Lead_Torus = texture {
	pigment{
		image_map{jpeg "cathedral/dome1torus.jpg" once}
		scale<1/40, 1/4, 1>
		warp{repeat y/4}
		warp{repeat x/40}
		warp{toroidal}
		rotate -x*90
	}
	finish{diffuse 0.56 phong 0}
	rotate y*85
};

#local T_Stp_Lead2 = texture {
	pigment{
		image_map{jpeg "cathedral/dome2.jpg" once}
		scale<1/4, 1/2, 1/4>
		translate y*0.5
	
		warp{repeat z/4}
		warp{repeat x/4}
		warp{spherical}
	}
	finish{diffuse 0.56 phong 0}
};

#local T_Stp_Lead3 = texture {
	pigment{
		image_map{jpeg "cathedral/dome3.jpg" once}
		scale<1/4, 1/2, 1/4>
		translate y*0.5
	
		warp{repeat z/4}
		warp{repeat x/4}
		warp{spherical}
		
		rotate y*22.5
	}
	finish{diffuse 0.56 phong 0}
};

#declare Spec = 0.2;
#declare Rough = 0.05;
#declare T_Stp_Gold = texture {
	pigment { rgb <0.773339, 0.58031, 0.305109> }
	finish {
		ambient 0
		diffuse 1 - Spec
		specular Spec roughness Rough metallic
		reflection <0.889704, 0.555986, 0.203232> * Spec
	}
};

#declare T_Stp_Windowglass=texture { //  T_Beerbottle_Glass from glass_old
   finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      specular 1
      roughness 0.001
   }
   pigment { color rgbf <0.7, 0.5, 0.1, 0.6> }
}
   
#declare T_Stp_Windowlead=texture {
   pigment { rgb 0.4 } 
	finish {ambient 0 diffuse 1 }
}

#declare T_Stp_Windowpane=texture {
   pigment { rgb 0.2 }
	finish {ambient 0 diffuse 1 }
}

#declare T_Stp_Door=texture {
   pigment { rgb <0.34, 0.22, 0.16> }
	finish {ambient 0 diffuse 1 }
}

#declare T_Stp_Black=texture {
   pigment { rgb 0 }
	finish {ambient 0 diffuse 1 }
}

/*------------------------- Objects ----------------------------------*/

/*-------------------------- Dome -------------------------------*/

#declare Sokkel=union{
   cylinder { <0, -300, 0>, <0, -27, 0>, 758 }
   cylinder { <0,  -27, 0>, <0, -18, 0>, 768 }
   cylinder { <0,  -18, 0>, <0, -11, 0>, 780 }
   cylinder { <0,  -11, 0>, <0,   0, 0>, 790 }
   cylinder { <0,    0, 0>, <0,  15, 0>, 680 }
   cylinder { <0,   15, 0>, <0,  28, 0>, 602 }
   cylinder { <0,   28, 0>, <0,  40, 0>, 597 }
   torus { 790, 4 translate <0, -6, 0> }
}

/*------------ Sjlegang ----------------*/

#declare Snegl=union{
   torus { 6, 2.5 }
   torus { 6, 2.5 translate <0,  4, 0> }
   torus { 2, 2.5 translate <0,  4, 0> }
   torus { 6, 2.5 translate <0, -4, 0> }
   torus { 2, 2.5 translate <0, -4, 0> }
   box { <8, -8, -4>, <12, 8, 8> }
   cylinder { <10, -8, -4>, <10, 8, -4>, 2 }
   rotate <0, 0, 90>
}

#declare Blad=difference{
   torus { 40, 17 rotate <0, 0, 90> scale <1, 2, 1> translate <0, -23, 0> }
   torus { 40, 14 rotate <0, 0, 90> scale <1, 2, 1> translate <0, -23, 0> }
   plane { x, 0 rotate <0, -30, 0> }
   plane { x, 0 translate <-6, 0, 0> }
   plane {-x, 0 rotate <0, 30, 0> }
   plane {-x, 0 translate < 6, 0, 0> }
   plane { y, 0 }
   plane { -y, 0 translate <0, 23, 0> }
   plane {-z, 0 translate <0, 0, 24> }
   plane { z, 0 translate <0, 0, 6> }
}

#declare Kapitael=union{
   cylinder { <0, 0, 0>, <0, 8, 0>, 17 }
   torus { 17, 2 translate <0, 6, 0> }
   cone { <0, 8, 0>, 12, <0, 31, 0>, 18 }
   cylinder { <0, 31, 0>, <0, 51, 0>, 18 }
   object { Blad translate <0, 8, -38> }
   object { Blad translate <0, 8, -38> rotate <0, 45, 0> }
   object { Blad translate <0, 8, -38> rotate <0, 90, 0> }
   object { Blad translate <0, 8, -38> rotate <0,135, 0> }
   object { Blad translate <0, 8, -38> rotate <0,180, 0> }
   object { Blad translate <0, 8, -38> rotate <0,225, 0> }
   object { Blad translate <0, 8, -38> rotate <0,270, 0> }
   object { Blad translate <0, 8, -38> rotate <0,315, 0> }

   object { Snegl translate <0, 39, -21> }
   object { Snegl translate <0, 39, -21> rotate <0,  90, 0> }
   object { Snegl translate <0, 39, -21> rotate <0, 180, 0> }
   object { Snegl translate <0, 39, -21> rotate <0, 270, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0,   0, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0,  90, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0, 180, 0> }
   object { Snegl rotate <0, -45, 0> translate <19, 39, -19> rotate <0, 270, 0> }
}

#declare Pillar=union{
   box { <-28.5, 0, -28.5>, <28.5, 22, 28.5> }
   box { <-26.5, 22, -26.5>, <26.5, 32, 26.5> }
   torus { 22, 3 translate <0, 35, 0> }
   difference{
      cylinder { <0, 36, 0>, <0, 52, 0>, 22 }
      torus { 34, 16 translate <0, 52, 0> }
   }
   torus { 17.5, 3 translate <0, 52, 0> }
   difference{
      cylinder { <0, 55, 0>, <0, 230, 0>, 18.5 }
      torus { 18.5, 1 translate <0,  80, 0> }
      torus { 18.5, 1 translate <0, 105, 0> }
      torus { 18.5, 1 translate <0, 130, 0> }
      torus { 18.5, 1 translate <0, 155, 0> }
      torus { 18.5, 1 translate <0, 180, 0> }
      torus { 18.5, 1 translate <0, 205, 0> }
      torus { 18.5, 1 translate <0, 230, 0> }
   }
   difference{
      cone { <0, 230, 0>, 18.5, <0, 355, 0>, 17 }
      torus { 18.5, 1 translate <0, 230, 0> }
      torus { 18.2, 1 translate <0, 255, 0> }
      torus { 17.9, 1 translate <0, 280, 0> }
      torus { 17.6, 1 translate <0, 305, 0> }
      torus { 17.3, 1 translate <0, 330, 0> }
   }
   object { Kapitael translate <0, 355, 0> }
}

#declare ArcKapi=union{
   box { <-15, -1, -3>, <15, -5, 0> }
   cylinder { <-15, -3, -3>, <15, -3, -3>, 2 }
   object { Snegl rotate <0,  45, 0> translate <-17, 31, -7> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -28> rotate <0,  45, 0> translate <-8, 0, 0> scale <0.6, 0.6, 0.6> }
   object { Snegl rotate <0, -45, 0> translate < 17, 31, -7> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -28> rotate <0, -45, 0> translate <8, 0, 0> scale <0.6, 0.6, 0.6> }
   object { Blad translate <0, 0, -30>  scale <0.7, 1.0, 0.5> }
   box { <-16, 24, -9>, <16, 27, 0> }
   cylinder { <-16, 25.5, -9>, <16, 25.5, -9>, 1.5 }
   box { <-15, 27, -3>, <15, 45, 0> }
   box { <-13.5, 45, -4.5>, <13.5, 48, 0> }
   cylinder { <-13.5, 46.5, -4.5>, <13.5, 46.5, -4.5>, 1.5 }
   box { <-15, 48, -5.5>, <15, 51, 0> }
   cylinder { <-15, 49.5, -5.5>, <15, 49.5, -5.5>, 1.5 }
}

#declare ArcDeco=union{
   difference {
      cylinder { <0, 275,  0>, <0, 275, -3>, 56 }
      cylinder { <0, 275,  1>, <0, 275, -4>, 53 }
      plane { y, 0 translate <0, 275, 0> }
   }
   difference{
      torus { 54.5, 1.5 rotate <-90, 0, 0> translate <0, 275, -3> }
      plane { y, 0 translate <0, 275, 0> }
   }
   difference{
      torus { 51.5, 1.5 rotate <-90, 0, 0> translate <0, 275, -2> }
      plane { y, 0 translate <0, 275, 0> }
   }
   object { ArcKapi translate <-47, 226, 0> }
   object { ArcKapi translate < 47, 226, 0> }
}

#declare Arc=union{
   difference{
      box { <-10, 0, -75>, <10, 406, 110> }
      box { <-20, 0, -32>, <20, 275, 32> }
      cylinder { <-20, 275, 0>, <20, 275, 0>, 32 }
      cylinder { <-20, 372, 0>, <20, 372, 0>, 17 }
   }
   box { <-15,  0, -70>, <15,  28, -27> }
   box { <-12, 28, -70>, <12,  40, -30> }
   box { <-15,  0,  27>, <15,  28, 100> }
   box { <-12, 28,  30>, <12,  40, 100> }
   object { ArcDeco rotate <0, 90, 0> translate <-10, 0, 0> }
   object { ArcDeco rotate <0, -90, 0> translate <10, 0, 0> }
}

#declare ArcPair=union{
   object { Arc translate <0, 0, -660> rotate <0, 3*360/64, 0> }
   object { Arc translate <0, 0, -660> rotate <0, 5*360/64, 0> }
}

#declare N_Cutout=union{
   box { <-42, 59, -2>, <42, 407, 2> }
   cylinder { <0, 106, 0>, <0, 270, 0>, 31 }
   sphere { <0, 270, 0>, 31 }
}

#declare N_Sidecut=union{
   box { <-14,  0, -27>, <14,  28, 27> }
   box { <-17, 28, -30>, <17,  40, 30> }
   box { <-20, 40, -32>, <20, 275, 32> }
   cylinder { <-20, 275, 0>, <20, 275, 0>, 32 }
}

#declare N_Arc=difference{
   union{
      difference{
	 cylinder { <0, -2, 0>, <0, 2, 0>, 55 }
	 cylinder { <0, -5, 0>, <0, 5, 0>, 42 }
      }
      torus { 53.5, 1.5 translate <0, 2, 0> }
      torus { 51, 1 translate <0, 3, 0> }
      rotate <-90, 0, 0>
   }
   plane { y, 0 }
}

#declare N_Frame=union{
   difference{
      box { <-36, -18, -3>, <36, 18, 0> }
      box { <-33, -15, -4>, <33, 15, 1> }
   }
   cylinder { <-30,  12, 0>, < 30,  12, 0>, 1.5 }
   cylinder { <-30, -12, 0>, < 30, -12, 0>, 1.5 }
   cylinder { <-30,  12, 0>, <-30, -12, 0>, 1.5 }
   cylinder { < 30,  12, 0>, < 30, -12, 0>, 1.5 }

   cylinder { <-32,  14, 0>, < 32,  14, 0>, 1.0 }
   cylinder { <-32, -14, 0>, < 32, -14, 0>, 1.0 }
   cylinder { <-32,  14, 0>, <-32, -14, 0>, 1.0 }
   cylinder { < 32,  14, 0>, < 32, -14, 0>, 1.0 }

   cylinder { <-34.5,  16.5, -3>, < 34.5,  16.5, -3>, 1.5 }
   cylinder { <-34.5, -16.5, -3>, < 34.5, -16.5, -3>, 1.5 }
   cylinder { <-34.5,  16.5, -3>, <-34.5, -16.5, -3>, 1.5 }
   cylinder { < 34.5,  16.5, -3>, < 34.5, -16.5, -3>, 1.5 }
}

#declare N_GPart=difference{
   union{
      torus { 21, 1.5 translate <6, 0, 6> }
      torus { 15, 1.5 }
      torus { 12, 1.5 }
      torus {  9, 1.5 }
      torus { 12, 1.2 translate <4, 0, 4> }
      sphere { <-3, 0, 4>, 4 scale <1, 0.7, 1>}
      sphere { < 2, 0, -3>, 4 }
      rotate <-90, 0, 0>
   }
   plane { -x, 0 rotate <0, 0, 45> translate <4, 0, 0> }
}

#declare N_Guirl=union{
   sphere { <-31,  11, 0>, 9 }
   sphere { < 31,  11, 0>, 9 }
   sphere { <-12, -15, 0>, 5 }
   sphere { < -4, -16, 0>, 4 }
   sphere { <  4, -16, 0>, 4 }
   sphere { < 12, -15, 0>, 5 }
   difference {
      union{
	 torus { 26, 1.5 rotate <90, 0, 0> translate <0, 21, -1> }
	 torus { 23, 1.5 rotate <90, 0, 0> translate <0, 15, -1> }
	 torus { 25, 1.5 rotate <90, 0, 0> translate <0, 14, -1> }
      }
      plane {-y, 0 translate <0, 14, 0> }
   }
   object { N_GPart translate <-23.5, -3.5, -1> }
   object { N_GPart rotate <0, 180, 0> translate <23.5, -3.5, -1> }
   scale <1, 1, 0.5>
}

#declare N_MPart=difference{
   sphere { <0, 0, 0>, 31 }
   sphere { <0, 0, 0>, 27 }
   plane { z, 0 }
   plane { y, 0 }
   plane { x, 0  rotate <0, 0,  7> }
   plane {-x, 0  rotate <0, 0, -7> }
}

#declare N_Musling=union{
   object { N_MPart rotate <0, 0, -13.5> }
   object { N_MPart rotate <0, 0, -40.5> }
   object { N_MPart rotate <0, 0, -67.5> }
   object { N_MPart rotate <0, 0,  13.5> }
   object { N_MPart rotate <0, 0,  40.5> }
   object { N_MPart rotate <0, 0,  67.5> }
   difference {
      sphere { <0, 0, 0>, 27 }
      plane { y, 0 translate <0, 2, 0> }
      plane { z, 0 translate <0, 0, 23> }
   }
}

#declare Niche=union{
   difference{
      union{
	 box { <-75,  0, -744>, <75,  22, -550> }
	 box { <-75, 22, -741>, <75,  40, -550> }
	 box { <-75, 40, -738>, <75, 406, -550> }
      }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
      torus { 660, 17 translate <0, 372, 0> }
      object { N_Sidecut translate <0, 0, -660> rotate <0,  360/64, 0> }
      object { N_Sidecut translate <0, 0, -660> rotate <0, -360/64, 0> }
      object { N_Cutout translate <0, 0, -738> }
   }

   object { ArcDeco rotate <0, 90, 0> translate <0, 0,-660> rotate <0, 360/64, 0> }
   object { ArcDeco rotate <0,-90, 0> translate <0, 0,-660> rotate <0,-360/64, 0> }

   box { <-5,  0, -590>, <1, 28, -633> rotate <0, 360/64, 0> }
   box { <-2, 28, -590>, <1, 40, -630> rotate <0, 360/64, 0> }
   box { <-5,  0, -687>, <1, 28, -730> rotate <0, 360/64, 0> }
   box { <-2, 28, -690>, <1, 40, -730> rotate <0, 360/64, 0> }

   box { <5,  0, -590>, <-1, 28, -633> rotate <0, -360/64, 0> }
   box { <2, 28, -590>, <-1, 40, -630> rotate <0, -360/64, 0> }
   box { <5,  0, -687>, <-1, 28, -730> rotate <0, -360/64, 0> }
   box { <2, 28, -690>, <-1, 40, -730> rotate <0, -360/64, 0> }

   box { <-36, 71, -738>, <36, 105, -735> }
   cylinder { <-32,  99, -738>, <32,  99, -738>, 1.5 }
   cylinder { <-35, 101, -739>, <35, 101, -739>, 1.5 }
   cylinder { <-38, 103, -740>, <38, 103, -740>, 1 }
   cylinder { <-38, 106, -740>, <38, 106, -740>, 2 }

   cylinder { <-60, 243, -738>, <-42, 243, -738>, 1.5 }
   cylinder { < 42, 243, -738>, < 60, 243, -738>, 1.5 }
   cylinder { <-42, 243, -736>, <-29, 243, -736>, 1.5 }
   cylinder { < 29, 243, -736>, < 42, 243, -736>, 1.5 }
   difference {
      torus { 31, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 243, -738>
   }

   cylinder { <-60, 258, -738>, <-42, 258, -738>, 1.5 }
   cylinder { < 42, 258, -738>, < 60, 258, -738>, 1.5 }
   cylinder { <-42, 258, -736>, <-29, 258, -736>, 1.5 }
   cylinder { < 29, 258, -736>, < 42, 258, -736>, 1.5 }
   difference {
      torus { 31, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 258, -738>
   }

   cylinder { <-60, 260, -738>, <-42, 260, -738>, 1.5 }
   cylinder { < 42, 260, -738>, < 60, 260, -738>, 1.5 }
   cylinder { <-42, 260, -736>, <-29, 260, -736>, 1.5 }
   cylinder { < 29, 260, -736>, < 42, 260, -736>, 1.5 }
   difference {
      torus { 30.5, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 260, -738>
   }

   cylinder { <-60, 268, -739>, <-42, 268, -739>, 1.5 }
   cylinder { < 42, 268, -739>, < 60, 268, -739>, 1.5 }
   cylinder { <-42, 268, -737>, <-28, 268, -737>, 1.5 }
   cylinder { < 28, 268, -737>, < 42, 268, -737>, 1.5 }
   difference {
      torus { 29.5, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 268, -738>
   }

   cylinder { <-60, 270, -739.5>, <-42, 270, -739.5>, 1.5 }
   cylinder { < 42, 270, -739.5>, < 60, 270, -739.5>, 1.5 }
   cylinder { <-42, 270, -737.5>, <-27, 270, -737.5>, 1.5 }
   cylinder { < 27, 270, -737.5>, < 42, 270, -737.5>, 1.5 }
   difference {
      torus { 28, 1.5  }
      plane { z, 0 translate <0, 0, 2> }
      translate <0, 270, -738>
   }

   object { N_Musling translate <0, 270, -738> }
   object { N_Arc translate <0, 270, -738> }
   object { N_Frame translate <0, 342, -736> }
   object { N_Guirl translate <0, 380, -736> }
}

#declare A_WGlass=box { <-35, 40, 0>, <35, 210, 1> texture { T_Stp_Windowglass } interior { ior 1.5 }  }

#declare A_WBars=union{
   #declare h = -35;
   #while (h < 36)
      cylinder { <h, 40, 0>, <h, 210, 0>, 1 }
      #declare h = h + 5;
   #end
   #declare h = 40;
   #while (h < 211)
      cylinder { <-35, h, 0>, <35, h, 0>, 1 }
      #declare h = h + 8.5;
   #end
   texture { T_Stp_Windowlead }
}

#declare A_WWall=union{
   difference {
      box { <-75, 40, -595>, <75, 325, -550> }
      box { <-35, 40, -600>, <35, 250, -500> }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
   }
   difference{
      box { <-75, 210, -580>, <75, 406, -550> }
      plane { x, 0 rotate <0,  360/64, 0> }
      plane {-x, 0 rotate <0, -360/64, 0> }
   }

   difference {
      box { <-30, 265, -600>, <30, 310, -595> }
      box { <-27, 268, -601>, <27, 307, -597> }
   }
   cylinder { <-29, 266, -600>, < 29, 266, -600>, 1 }
   cylinder { <-29, 309, -600>, < 29, 309, -600>, 1 }
   cylinder { <-29, 266, -600>, <-29, 309, -600>, 1 }
   cylinder { < 29, 266, -600>, < 29, 309, -600>, 1 }

   cylinder { <-27, 268, -599>, < 27, 268, -599>, 1 }
   cylinder { <-27, 307, -599>, < 27, 307, -599>, 1 }
   cylinder { <-27, 268, -599>, <-27, 307, -599>, 1 }
   cylinder { < 27, 268, -599>, < 27, 307, -599>, 1 }

   cylinder { <-24, 271, -599>, < 24, 271, -599>, 1 }
   cylinder { <-24, 304, -599>, < 24, 304, -599>, 1 }
   cylinder { <-24, 271, -599>, <-24, 304, -599>, 1 }
   cylinder { < 24, 271, -599>, < 24, 304, -599>, 1 }

   cylinder { <-22, 273, -598>, < 22, 273, -598>, 1 }
   cylinder { <-22, 302, -598>, < 22, 302, -598>, 1 }
   cylinder { <-22, 273, -598>, <-22, 302, -598>, 1 }
   cylinder { < 22, 273, -598>, < 22, 302, -598>, 1 }
}

#declare A_Window=union{
   object { A_WWall }
   object { A_WGlass translate <0, 0, -565> }
   object { A_WBars translate <0, 0, -565> }
}

#declare A_WindowTrio=union{
   object { A_Window rotate <0,   360/32, 0> }
   object { A_Window rotate <0, 2*360/32, 0> }
   object { A_Window rotate <0, 3*360/32, 0> }
}

#declare Arcade=union{
   #declare ang=360/64;
   #while (ang < 360)
      object { Pillar translate <0, 0, -740> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
   #declare ang=0;
   #while (ang < 360)
      object { Niche rotate <0, ang, 0> }
      object { ArcPair rotate <0, ang, 0> }
      object { A_WindowTrio rotate <0, ang, 0> }
      #declare ang = ang + 360/8;
   #end
}

/*------------ Entablement ---------------*/

#declare Entablement=union{
   cylinder { <0,  0, 0>, <0,  6, 0>, 762 }
   cylinder { <0,  6, 0>, <0, 14, 0>, 764 }
   cylinder { <0, 14, 0>, <0, 16, 0>, 763 }
   cylinder { <0, 16, 0>, <0, 66, 0>, 764 }
   torus { 764, 2 translate <0, 18, 0> }
   #declare ang=0;
   #while (ang < 360)
      box { <-5, 56, -788>, <5, 66, 760> rotate <0, ang, 0> }
      #declare ang = ang + 360/192;
   #end
   cylinder { <0, 66, 0>, <0, 74, 0>, 792 }
   cylinder { <0, 74, 0>, <0, 82, 0>, 796 }
}

/*------------ Balustrade ----------------*/

#declare Baluster=union{
   cylinder { <0, 0, 0>, <0, 2, 0>, 7.5 }
   cone { <0, 2, 0>, 7.5, <0, 4, 0>, 5.5 }
   cylinder { <0, 4, 0>, <0, 8, 0>, 5.5 }
   torus { 5.5, 2 translate <0, 6, 0> }
   difference{
      sphere { <0, 14, 0>, 7.5 }
      plane { -y, 0 translate <0, 15.367, 0> }
   }
   cone { <0, 15.367, 0>, 7.3913, <0, 31, 0>, 4.5 }
   cylinder { <0, 31, 0>, <0, 35, 0>, 4.5 }
   torus { 4.5, 2 translate <0, 33, 0> }
   sphere { < 0, 0, 0> 7.5 scale <1.0, 0.8, 1.0> translate <0, 40, 0> }
   cone { <0, 45, 0>, 5.5, <0, 47, 0>, 7.5 }
   cylinder { <0, 47, 0>, <0, 49, 0>, 7.5 }
}

#declare B_Sokkel=difference{
   union{
      cylinder { <0, 0, 0>, <0, 21, 0>, 771 }
      cone { <0, 21, 0>, 771, <0, 32, 0>, 767.5 }
   }
   cylinder { <0, -1, 0>, <0, 33, 0>, 750 }
}

#declare B_Pillar=union{
   box { <-15.5, 0, -776>, <15.5, 21, -750> }
   intersection{
      box { <-15.5, 21, -776>, <15.5, 32, -750> }
      plane { x, 0 rotate <0, 0, 12.8> translate < 15.5, 21, 0> }
      plane {-x, 0 rotate <0, 0,-12.8> translate <-15.5, 21, 0> }
      plane {-z, 0 rotate <19.98, 0, 0> translate <0, 21, -776> }
   }
   box { <-13, 32, -772>, <13, 81, -750> }
}

#declare B_Rail=union{
   difference{
      cylinder { <0,  0, 0>, <0, 12, 0>, 772 }
      cylinder { <0, -1, 0>, <0, 13, 0>, 750 }
   }
   torus { 772, 2.5 translate <0, 9.5, 0> }
   torus { 750, 2.5 translate <0, 9.5, 0> }
}

#declare Balustrade=union{
   object { B_Sokkel }

   #declare ang=0;
   #while (ang < 360)
      object { Baluster translate <0, 32, -760> rotate <0, ang, 0> }
      #declare ang = ang + 360/224;
   #end

   #declare ang=360/64;
   #while (ang < 360)
      object { B_Pillar rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end

   object { B_Rail translate <0, 81, 0> }
}

/*------------ Galleri ----------------*/

#declare FlatPillar=union{
   difference{
      box { <-16, 0, -16>, <16, 274, 16> }
      #declare h=27;
      #while (h < 270)
	 cylinder { <-20, h, -16.5>, < 20, h, -16.5>, 1 }
	 cylinder { <-16, h, -20>, <-16, h,  20>, 1 }
	 cylinder { < 16, h, -20>, < 16, h,  20>, 1 }
	 #declare h = h + 27;
      #end
   }
   cylinder { <-17, 272, -17>, < 17, 272,-17>, 2 }
   cylinder { <-17, 272, -17>, <-17, 272, 17>, 2 }
   cylinder { < 17, 272, -17>, < 17, 272, 17>, 2 }
   sphere { <-17, 272, -17>, 2 }
   sphere { < 17, 272, -17>, 2 }

   box { <-15.5, 274, -15.5>, <15.5, 305, 15.5> }

   box { <-20.5, 296, -24>, <-15.5, 305, 15.5> }
   box { <-11.5, 296, -24>, < -6.5, 305, 15.5> }
   box { < -2.5, 296, -24>, <  2.5, 305, 15.5> }
   box { <  6.5, 296, -24>, < 11.5, 305, 15.5> }
   box { < 15.5, 296, -24>, < 20.5, 305, 15.5> }

   box { <-29, 305, -34>, <29, 316, 16> }

   cylinder { <-30, 320, -34>, <-25, 320, -34>, 4 }
   cylinder { <-24, 320, -34>, <-19, 320, -34>, 4 }
   cylinder { <-18, 320, -34>, <-13, 320, -34>, 4 }
   cylinder { <-12, 320, -34>, < -7, 320, -34>, 4 }
   cylinder { < -6, 320, -34>, < -1, 320, -34>, 4 }
   cylinder { <  0, 320, -34>, <  5, 320, -34>, 4 }
   cylinder { <  6, 320, -34>, < 11, 320, -34>, 4 }
   cylinder { < 12, 320, -34>, < 17, 320, -34>, 4 }
   cylinder { < 18, 320, -34>, < 23, 320, -34>, 4 }
   cylinder { < 24, 320, -34>, < 30, 320, -34>, 4 }

   box { <-30, 316, -34>, <30, 324, 16> }
}

#declare Blind=union{
   difference{
      box { <-43, 0, -6>, <43, 304, 16> }
      box { <-26, 182, -10>, <26, 252, 20> }
      #declare h=27;
      #while (h < 270)
	 cylinder { <-50, h, -6.5>, < 50, h, -6.5>, 1 }
	 #declare h = h + 27;
      #end
   }

   box { <-26, 257, -9>, <-15, 305, 0> }
   box { <-15, 262, -9>, < 15, 305, 0> }
   box { < 15, 257, -9>, < 26, 305, 0> }

   cylinder { <-43, 272,  -6>, <43, 272, -6>, 2 }

   cylinder { <-36, 262,  -6>, < 36, 262, -6>, 2 }
   sphere { <-36, 262,  -6>, 2 }
   sphere { < 36, 262,  -6>, 2 }
   cylinder { <-36, 238,  -6>, <-36, 262, -6>, 2 }
   cylinder { < 36, 238,  -6>, < 36, 262, -6>, 2 }
   cylinder { <-34, 175,  -6>, <-34, 240, -6>, 2 }
   cylinder { < 34, 175,  -6>, < 34, 240, -6>, 2 }
   cylinder { <-34, 175,  -6>, <-19, 175, -6>, 2 }
   sphere { <-34, 175,  -6>, 2 }
   cylinder { < 19, 175,  -6>, < 34, 175, -6>, 2 }
   sphere { < 34, 175,  -6>, 2 }
   cylinder { <-21, 171,  -6>, < 21, 171, -6>, 2 }

   cylinder { <-36, 162,  -6>, < 36, 162, -6>, 2 }
   sphere { <-36, 162,  -6>, 2 }
   sphere { < 36, 162,  -6>, 2 }
   cylinder { <-36,  42,  -6>, < 36,  42, -6>, 2 }
   sphere { <-36,  42,  -6>, 2 }
   sphere { < 36,  42,  -6>, 2 }
   cylinder { <-36,  42,  -6>, <-36, 162, -6>, 2 }
   cylinder { < 36,  42,  -6>, < 36, 162, -6>, 2 }
   cylinder { <-36, 160,  -6>, < 36, 160, -6>, 1.5 }
   cylinder { <-36,  44,  -6>, < 36,  44, -6>, 1.5 }
   cylinder { <-34,  44,  -6>, <-34, 160, -6>, 1.5 }
   cylinder { < 34,  44,  -6>, < 34, 160, -6>, 1.5 }
   cylinder { <-34, 158,  -6>, < 34, 158, -6>, 1 }
   cylinder { <-34,  46,  -6>, < 34,  46, -6>, 1 }
   cylinder { <-32,  46,  -6>, <-32, 158, -6>, 1 }
   cylinder { < 32,  46,  -6>, < 32, 158, -6>, 1 }

   box { <-30.5, 296, -16>, <-25.5, 305, 16> }
   box { <-22.5, 296, -16>, <-17.5, 305, 16> }
   box { <-14.5, 296, -16>, < -9.5, 305, 16> }
   box { < -6.5, 296, -16>, < -1.5, 305, 16> }
   box { <  1.5, 296, -16>, <  6.5, 305, 16> }
   box { <  9.5, 296, -16>, < 14.5, 305, 16> }
   box { < 17.5, 296, -16>, < 22.5, 305, 16> }
   box { < 25.5, 296, -16>, < 30.5, 305, 16> }

   box { <-43, 305, -18>, <43, 316, 16> }

   cylinder { <-30, 320, -20>, <-25, 320, -20>, 4 }
   cylinder { <-24, 320, -20>, <-19, 320, -20>, 4 }
   cylinder { <-18, 320, -20>, <-13, 320, -20>, 4 }
   cylinder { <-12, 320, -20>, < -7, 320, -20>, 4 }
   cylinder { < -6, 320, -20>, < -1, 320, -20>, 4 }
   cylinder { <  0, 320, -20>, <  5, 320, -20>, 4 }
   cylinder { <  6, 320, -20>, < 11, 320, -20>, 4 }
   cylinder { < 12, 320, -20>, < 17, 320, -20>, 4 }
   cylinder { < 18, 320, -20>, < 23, 320, -20>, 4 }
   cylinder { < 24, 320, -20>, < 29, 320, -20>, 4 }
}

#declare G_Window=union{
   #declare h = 182 + (70 / 8);
   #while (h < 252)
      cylinder { <-26, h, 15>, <26, h, 15>, 1 }
      #declare h = h + (70 / 8);
   #end
   #declare h = -26 + (52 / 12);
   #while (h < 26)
      cylinder { <h, 182, 15>, <h, 252,  15>, 1 }
      #declare h = h + (52 / 12);
   #end
   texture { T_Stp_Windowlead }
}

#declare G_WGlass=box { <-26, 182, 15>, <26, 252, 16> texture { T_Stp_Windowglass } interior { ior 1.5 } }

#declare Gallery=union{
   #declare ang=360/64;
   #while (ang < 360)
      object { FlatPillar translate <0, 0, -610> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
   #declare ang=0;
   #while (ang < 360)
      object { Blind    translate <0, 0, -610> rotate <0, ang, 0> }
      object { G_Window translate <0, 0, -610> rotate <0, ang, 0> }
      object { G_WGlass translate <0, 0, -610> rotate <0, ang, 0> }
      #declare ang = ang + 360/32;
   #end
}

/*------------ Kuppel ----------------*/

#declare Ring=union{
   cylinder { <0,  0, 0>, <0, 16, 0>, 628 }
   cylinder { <0, 16, 0>, <0, 53, 0>, 626 }
   torus { 626, 8.5 translate <0, 44.5, 0> }
   cylinder { <0, 53, 0>, <0, 93, 0>, 604 }
   torus { 604, 9 translate <0, 84, 0> }
   texture {T_Stp_Lead1 translate y*5}
}

#declare Dome_A=difference{
   union{
      difference{
	 sphere { <0, 0, 0>, 592 scale <1, 1.1, 1> }
	 plane { x, 0 rotate <0, 360/64, 0> }
	 plane {-x, 0 rotate <0, -(360/64), 0> }
      }
      torus { 592, 9 texture{T_Stp_Lead_Torus} rotate <90, 84.375, 0> scale <1, 1.1, 1>}
      torus { 592, 9 texture{T_Stp_Lead_Torus} rotate <90, 95.625, 0> scale <1, 1.1, 1>}
      difference{
	 torus { 592, 3 rotate <90, 86.3, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus { 592, 3 rotate <90, 93.7, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus {  38, 3 rotate <92, 0, 0> translate <0, 48, -590> }
	 plane {-y, 0 translate <0, 48, 0> }
      }
   }
   plane { y, 0 }
   cylinder { <0, 555, 0>, <0, 1000, 0>, 295 }
   plane {-z, 0 }
   bounded_by { box { <-60, 0, -593>, <60, 655, 0> } }
}

#declare Dome_B=difference{
   union{
      difference{
	 sphere { <0, 0, 0>, 592 scale <1, 1.1, 1> }
	 plane { x, 0 rotate <0, 360/64, 0> }
	 plane {-x, 0 rotate <0, -(360/64), 0> }
      }
      torus { 592, 9 texture{T_Stp_Lead_Torus} rotate <90, 84.375, 0> scale <1, 1.1, 1>}
      torus { 592, 9 texture{T_Stp_Lead_Torus} rotate <90, 95.625, 0> scale <1, 1.1, 1>}
      difference{
	 torus { 592, 3 rotate <90, 86.3, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus { 592, 3 rotate <90, 93.7, 0> scale <1, 1.1, 1>}
	 plane { y, 0 translate <0, 48, 0> }
      }
      difference{
	 torus {  38, 3 rotate <92, 0, 0> translate <0, 48, -590> }
	 plane {-y, 0 translate <0, 48, 0> }
      }
   }
   plane { y, 0 }
   cylinder { <0, 555, 0>, <0, 1000, 0>, 170 }
   plane {-z, 0 }                                                                   
   bounded_by { box { <-60, 0, -593>, <60, 655, 0> } }
}

#declare LeadDome=union{
   #declare ang = 0;
   #while (ang < 360 )
      object { Dome_B rotate <0,  360/32*2+ang, 0> }
      object { Dome_A rotate <0,    360/32+ang, 0> }
      object { Dome_A rotate <0,         0+ang, 0> }
      object { Dome_A rotate <0, -(360/32)+ang, 0> }
      #declare ang = ang + 45;
   #end
   texture {T_Stp_Lead1}
}

#declare D_Win=difference{
   cylinder { <0, 560, 0>, <0, 608, 0>, 170.1 }
   plane { x, 0 translate <-12, 0, 0> }
   plane {-x, 0 translate < 12, 0, 0> }
   texture { T_Stp_Windowlead }
}

#declare DomeWindow=union{
   cylinder { <0, 555, 0>, <0, 620, 0>, 170 }
   cylinder { <0, 620, 0>, <0, 635, 0>, 173 }
   #declare ang = 0;
   #while (ang < 180 )
      object { D_Win rotate <0, ang-9, 0> }
      object { D_Win rotate <0, ang, 0> }
      object { D_Win rotate <0, ang+9, 0> }
      #declare ang = ang + 45;
   #end
}

#declare Dome=union{
   object { Ring }
   object { LeadDome   translate <0, 93, 0> }
   object { DomeWindow translate <0, 93, 0> }
}

/*------------ Platform ----------------*/

#declare Pattern=union{
   box { <-5, 5, -2>, <5, 25, 2> }
   cylinder { <0, 25, -2>, <0, 25, 2>, 5 }
   box { <-3, 7, -2>, <3, 25, 3> }
   cylinder { <0, 25, -2>, <0, 25, 3>, 3 }
   translate  <0, 0, -175>
}

#declare SnirkelDel=union{
   cylinder { <0, 32, 0>, <0, 32, -6>, 3 }
   difference{
      torus { 7, 3 rotate <0, 0, 90> }
      plane { -z, 0 }
      plane { -z, 0 rotate <31.373, 0, 0> }
      translate <0, 25, -6>
   }
   difference{
      torus { 17, 3 rotate <0, 0, 90> }
      plane { y, 0 translate <0, 1, 0> }
      plane { z, 0 rotate <31.373, 0, 0> }
      translate <0, 4.5, -18.5>
   }
   torus { 3, 3 rotate <0, 0, 90> translate <0, 25, -6> }
   sphere { <0, 25, -6>, 3 }
}

#declare Snirkel=union{
   object { SnirkelDel translate <-6, 0, 0> }
   object { SnirkelDel translate <-2, 0, 0> }
   object { SnirkelDel translate < 2, 0, 0> }
   object { SnirkelDel translate < 6, 0, 0> }
   cylinder { <-6, 5.5, -2>, <6, 5.5, -2>, 3 }
   sphere { <-6, 5.5, -2>, 3 }
   sphere { < 6, 5.5, -2>, 3 }
}

#declare Rekverk=union{
   torus { 174, 0.5  translate <0,  5, 0> }
   torus { 174, 0.5  translate <0, 38, 0> }
   #declare ang = 0;
   #while (ang < 360 )
      cylinder { <0, 5, -174>, <0, 38, -174>, 0.5 rotate <0, ang, 0> }
      #declare ang = ang + 360/192;
   #end
   #declare ang = 0;
   #while (ang < 360 )
      cylinder { <0, 0, -174>, <0, 5, -174>, 0.5 rotate <0, ang, 0> }
      #declare ang = ang + 360/24;
   #end
   texture { T_Stp_Gold }
}

#declare Gesims=union{
   torus {175, 4 }
   difference {
      cylinder { <0, 0, 0>, <0, 58, 0>, 175 }
      #declare ang = 0;
      #while (ang < 360 )
	 object { Pattern rotate <0, ang, 0> }
	 #declare ang = ang + 360/64;
      #end
   }
   #declare ang = 360/16;
   #while (ang < 360 )
      object { Snirkel translate <0, 4, -175> rotate <0, ang-(360/64), 0> }
      object { Snirkel translate <0, 4, -175> rotate <0, ang+(360/64), 0> }
      #declare ang = ang + 360/8;
   #end
   difference{
      torus { 175, 12 translate <0, 38, 0> }
      plane { y, 0 translate <0, 38, 0> }
   }
   torus { 175, 2 translate <0, 56, 0> }
}

#declare Platform=union{
   object { Gesims }
   object { Rekverk translate <0, 58, 0> }
}

/*------------ Fodstykke ----------------*/

#declare F_Door=union{
   box { <-21, 0, -1>, <21, 60, 3> }
   cylinder { <0, 60, -1>, <0, 60, 3>, 21 }
   box { <-18, 0, -1>, <18, 60, 5> }
   cylinder { <0, 60, -1>, <0, 60, 5>, 18 }
}

#declare F_Midt=union{
   difference{
      box { <-31, 0, -125>, < 31, 104, 0> }
      object { F_Door translate <0, 0, -125> }
   }
   box { <-2, 0, -122>, <2, 81, -120> }
   difference{
      box { <-10, 0, -127>, <10, 23, -120> }
      plane { x, 0 rotate <0, 0, 5> translate <-5, 0, 0> }
      plane {-x, 0 rotate <0, 0,-5> translate < 5, 0, 0> }
      translate <0, 80, 0>
   }
   cylinder { <-31, 103, -124>, <31, 103, -124>, 2 }
   cylinder { <-31, 107, -125>, <31, 107, -125>, 2 }
}

#declare F_Window=union{
   box { <-9, 22, -1>, <9, 62, 3> }
   cylinder { <0, 62, -1>, <0, 62, 3>, 9 }
   box { <-7, 25, -1>, <7, 62, 6> }
   cylinder { <0, 62, -1>, <0, 62, 6>, 7 }
}

#declare F_Glass=union{
   box { <-7, 25, 5.5>, <7, 62, 6> }
   cylinder { <0, 62, 5.5>, <0, 62, 6>, 7 }
   texture { T_Stp_Windowlead }
}

#declare F_Side=union{
   difference{
      box { <-21, 0, -132>, <21, 104, 0> }
      object { F_Window translate <0, 0, -132> }
   }
   object { F_Glass translate <0, 0, -132> }
   cylinder { <-10, 22, -132>, <10, 22, -132>, 1 }
   cylinder { <-21, 103, -131>, < 21, 103, -131>, 2 }
   cylinder { <-21, 107, -132>, < 21, 107, -132>, 2 }
   cylinder { <-20, 103, -131>, <-20, 103,    0>, 2 }
   cylinder { <-21, 107, -132>, <-21, 107,    0>, 2 }
   cylinder { < 20, 103, -131>, < 20, 103,    0>, 2 }
   cylinder { < 21, 107, -132>, < 21, 107,    0>, 2 }
   sphere { <-20, 103, -131>, 2 }
   sphere { <-21, 107, -132>, 2 }
   sphere { < 20, 103, -131>, 2 }
   sphere { < 21, 107, -132>, 2 }
}

#declare F_Corner=union{
   box { < -40, 0, -123>, <40, 104, 0> }
   cylinder { <-40, 103, -122>, <40, 103, -122>, 2 }
   cylinder { <-40, 107, -123>, <40, 107, -123>, 2 }
   cylinder { <-40, 114, -138>, <40, 114, -138>, 5 }
   box { <-40, 109, -138>, <40, 119, 0> }
   rotate <0, 45, 0>
}

#declare KvartFod=union{
   object { F_Side translate <-52, 0, 0> }
   object { F_Midt }
   object { F_Side translate < 52, 0, 0> }
   cylinder { <-85, 114, -134>, < 85, 114, -134>, 5 }
   cylinder { <-85, 114, -134>, <-85, 114,    0>, 5 }
   box { <-85, 109, -134>, <85, 119, 0> }
   cylinder { < 85, 114, -134>, < 85, 114,    0>, 5 }
   sphere { <-85, 114, -134>, 5 }
   sphere { < 85, 114, -134>, 5 }
   object { F_Corner }
}

#declare Fodstykke=union{
   object { KvartFod }
   object { KvartFod rotate <0,  90, 0> }
   object { KvartFod rotate <0, 180, 0> }
   object { KvartFod rotate <0, 270, 0> }
}

/*------------ Trn ----------------*/

#declare Hak=intersection{
   plane { x, 0 translate <-4, 0, 0> }
   plane {-x, 0 rotate <0, 45, 0> translate < 2.828, 0, -2.828> }
}

#declare T_Kapitael=difference{
   cone { <0, 164, 0>, 11, <0, 184, 0>, 17 }
   #declare ang=0;
   #while (ang < 360)
      object { Hak rotate <0, ang, 0> }
      #declare ang = ang + 45;
   #end
}

#declare T_Urn=union{
   cylinder { <0, 0, 0>, <0, 4, 0>, 9 }
   cylinder { <0, 4, 0>, <0, 8, 0>, 7 }
   cone { <0, 0, 0>, 9, <0, 16, 0>, 3 }
   difference{
      sphere { <0, 0, 0>, 10 scale <1, 1.4, 1> translate <0, 25, 0>}
      plane {-y, 0 translate <0, 25, 0> }
   }
   difference{
      sphere { <0, 19.4, 0>, 10.6 }
      plane { y, 0 translate <0, 25, 0> }
   }
   cone { <0, 26, 0>, 3, <0, 60, 0>, 0 }
   sphere { <0, 44, 0>, 3 }
   sphere { <0, 52, 0>, 2 }
   texture { T_Stp_Gold }
}

#declare T_Urnpair=union{
   box { <-20, 0, -11>, <20, 4, 11> }
   object { T_Urn translate <-10, 4, 0> }
   object { T_Urn translate < 10, 4, 0> }
}

#declare T_Pillar=union{
   box { <-13, 0, -13>, <13, 4, 13> }
   torus { 10, 3 translate <0, 7, 0> }
   torus { 10, 2.5 translate <0, 12, 0> }
   cylinder { <0, 0, 0>, <0, 165, 0>, 11 }
   torus { 10, 2 translate <0, 165, 0> }
   object { T_Kapitael }
}

#declare T_Pillarpair=union{
   box { <-26, 0, -13>, <26, 6, 13> }
   object { T_Pillar translate <-13, 6, 0> }
   object { T_Pillar translate < 13, 6, 0> }
}

#declare T_WGlass1=box {
   <-24, 50, 2>, <24, 165, 3>
   texture { T_Stp_Windowlead }
}

#declare T_Side=union{
   difference{
      box { <-60,  0, -100>, <60, 184, 0> }
      box { <-22, 50, -101>, <22, 165, 1> }
   }
   object { T_WGlass1 translate <0, 0, -100> }
   difference{
      box { <-5, 0, -101>, <5, 10, -100> }
      plane { x, 0 rotate <0, 0, 5> translate <-2, 0, 0> }
      plane {-x, 0 rotate <0, 0,-5> translate < 2, 0, 0> }
      translate <0, 165, 0>
   }
   cylinder { <-60, 50, -100>, < 60, 50, -100>, 3 }
   cylinder { <-60, 50, -100>, <-60, 50,    0>, 3 }
   cylinder { < 60, 50, -100>, < 60, 50,    0>, 3 }
   sphere { <-60, 50, -100>, 3 }
   sphere { < 60, 50, -100>, 3 }
   cylinder { <-20, 44, -100>, < 20, 44, -100>, 2 }
   cylinder { <-20, 44, -100>, <-20, 14, -100>, 2 }
   cylinder { < 20, 44, -100>, < 20, 14, -100>, 2 }
   cylinder { <-20, 14, -100>, < 20, 14, -100>, 2 }

   box { <-73, 190, -134>, <73, 238, 0> }
   box { <-76, 194, -137>, <76, 204, 0> }
   cylinder { <-76, 199, -137>, < 76, 199, -137>, 3 }
   cylinder { <-76, 199, -137>, <-76, 199,    0>, 3 }
   cylinder { < 76, 199, -137>, < 76, 199,    0>, 3 }
   sphere { <-76, 199, -137>, 3}
   sphere { < 76, 199, -137>, 3}

   #declare pos = -69;
   #while (pos < 72)
      sphere { <pos, 220, -134>, 4 }
      #declare pos = pos+6;
   #end

   #declare pos = -131;
   #while (pos < -92)
      sphere { <-73, 220, pos>, 4 }
      sphere { < 73, 220, pos>, 4 }
      #declare pos = pos+6;
   #end

   box { <-88, 224, -140>, <88, 234, 0> }
   cylinder { <-88, 229, -140>, < 88, 229, -140>, 3 }
   cylinder { <-88, 229, -140>, <-88, 229,    0>, 3 }
   cylinder { < 88, 229, -140>, < 88, 229,    0>, 3 }
   sphere { <-88, 229, -140>, 3 }
   sphere { < 88, 229, -140>, 3 }
}

#declare T_Window=union{
   box { <-8, 55, -1>, <8, 130, 5> }
   cylinder { <0, 130, -1>, <0, 130, 5>, 8 }
}

#declare T_WGlass2=union{
   box { <-8, 55, 3>, <8, 130, 4> }
   cylinder { <0, 130, 3>, <0, 130, 4>, 8 }
   texture { T_Stp_Windowlead }
}

#declare T_Corner=union{
   difference{
      box { <-28.3, 0, -113>, <28.3, 184, 0> }
      object { T_Window translate <0, 0, -113> }
   }
   cylinder { <-28.5, 50, -113>, < 28.5, 50, -113>, 3 }

   box { <-25, 190, -120>, <25, 238, 0> }
   box { <-25, 194, -123>, <25, 204, 0> }
   cylinder { <-25, 199, -123>, < 25, 199, -123>, 3 }

   #declare pos = -12;
   #while (pos < 18)
      sphere { <pos, 220, -120>, 4 }
      #declare pos = pos+6;
   #end

   box { <-25, 224, -140>, <25, 234, 0> }
   cylinder { <-25, 229, -140>, < 25, 229, -140>, 3 }

   rotate <0, 45, 0>
}

#declare KvartTow=union{
   object { T_Side }
   object { T_Corner }
   object { T_WGlass2 translate <0, 0, -113> rotate <0, 45, 0> }
   object { T_Pillarpair translate <-47, 0, -119> }
   object { T_Pillarpair translate < 47, 0, -119> }
   object { T_Urnpair translate <-47, 238, -119> }
   object { T_Urnpair translate < 47, 238, -119> }
}

#declare Tower=union{
   object { KvartTow }
   object { KvartTow rotate <0,  90, 0> }
   object { KvartTow rotate <0, 180, 0> }
   object { KvartTow rotate <0, 270, 0> }
}

/*------------ Loft ----------------*/

#declare L_WGlass=cylinder{
   <0, 88, -75>, <0, 88, 0>, 24
   texture { T_Stp_Windowlead }
}

#declare L_Side=union{
   difference{
      union{
	 box { <-48, 0, -80>, <48, 145, 0> }
	 cylinder { <0, 88, -82>, <0, 88, 0>, 30 }
      }
      cylinder { <0, 88, -90>, <0, 88, 0>, 24 }
   }
   box { <-34,  54, -82>, < 34,  60, 0> }
   box { <-34,  54, -82>, <-28, 125, 0> }
   box { < 34,  54, -82>, < 28, 125, 0> }
   box { <-37, 116, -82>, < 37, 125, 0> }
   box { <-37, 108, -82>, <-31, 125, 0> }
   box { < 37, 108, -82>, < 31, 125, 0> }

   box { <-53, 135, -85>, <53, 145, 0> }
   box { <-57, 138, -89>, <57, 142, 0> }

   box { <-47, 145, -79>, <47, 175, 0> }
   box { <-50, 169, -82>, <50, 175, 0> }
   cylinder { <-50, 173, -82>, < 50, 173, -82>, 2 }
   cylinder { <-50, 173, -82>, <-50, 173,   0>, 2 }
   cylinder { < 50, 173, -82>, < 50, 173,   0>, 2 }
   sphere { <-50, 173, -82>, 2 }
   sphere { < 50, 173, -82>, 2 }

   object { L_WGlass }
}

#declare L_Corner=union{
   box { <-20, 0, -86>, <20, 145, 0> }
   box { <-20, 135, -91>, <20, 145, 0> }
   box { <-20, 138, -95>, <20, 142, 0> }

   cylinder { <-15, 130, -86>, <15, 130, -86>, 2 }
   cylinder { <-15, 130, -86>, <-15, 10, -86>, 2 }
   cylinder { < 15, 130, -86>, < 15, 10, -86>, 2 }
   cylinder { <-15, 10, -86>, <15, 10, -86>, 2 }

   box { <-20, 145, -85>, <20, 175, 0> }
   box { <-20, 169, -88>, <20, 175, 0> }
   cylinder { <-20, 173, -88>, <20, 173, -88>, 2 }

   rotate <0, 45, 0>
}

#declare KvartLoft=union{
   object { L_Side }
   object { L_Corner }
}

#declare L_Domelead=difference{
   union{
      sphere { <0, 0, 0>, 75 }
      torus { 75, 2 scale <1, 3, 1> rotate <90,  60, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90, -60, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90,  30, 0> }
      torus { 75, 2 scale <1, 3, 1> rotate <90, -30, 0> }
      scale <1, 1.3, 1>
   }
   plane { y, 0 }
   texture {T_Stp_Lead2}
}

#declare L_Domegold=union{
   difference{
      union{
	 torus { 77, 2 rotate <90,  60, 0> }
	 torus { 77, 2 rotate <90, -60, 0> }
	 torus { 77, 2 rotate <90,  30, 0> }
	 torus { 77, 2 rotate <90, -30, 0> }
	 scale <1, 1.3, 1>
      }
      plane { y, 0 }
   }
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> }
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0,  90, 0>}
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0, 180, 0>}
   torus { 11, 2 rotate <-63, 0, 0> translate <0, 50, -65> rotate <0, 270, 0>}
   torus { 25, 3  translate <0, 97, 0> }
   texture { T_Stp_Gold }
}

#declare Loft=union{
   object { KvartLoft }
   object { KvartLoft rotate <0,  90, 0> }
   object { KvartLoft rotate <0, 180, 0> }
   object { KvartLoft rotate <0, 270, 0> }
   object { L_Domelead translate <0, 175, 0> }
   object { L_Domegold translate <0, 175, 0> }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> texture { T_Stp_Windowlead } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0,  90, 0> texture { T_Stp_Windowlead } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0, 180, 0> texture { T_Stp_Windowlead } }
   cylinder { <0, -3, 0>, <0, 0, 0>, 11 rotate <-63, 0, 0> translate <0, 225, -65> rotate <0, 270, 0> texture { T_Stp_Windowlead } }
}

/*------------ Spir ----------------*/

#declare S_Base=union{
   difference{
      cone { <0, 0, 0>, 30, <0, 130, 0>, 17 }
      box { <-40, 45, -40>, <40, 100, 40> }
   }
   sphere { <0, 0, 0>, 45 scale <1, 0.3, 1> translate <0, 20, 0>}
   torus { 24, 6 translate <0, 112, 0> }
   texture { T_Stp_Gold }
}

#declare S_SnirkelDel=union{
   cylinder { <0, 48, 0>, <0, 48, -9>, 3 }
   difference{
      torus { 10.5, 3 rotate <0, 0, 90> }
      plane { -z, 0 }
      plane { -z, 0 rotate <31.373, 0, 0> }
      translate <0, 37.5, -9>
   }
   difference{
      torus { 25.5, 3 rotate <0, 0, 90> }
      plane { y, 0 translate <0, 1.5, 0> }
      plane { z, 0 rotate <31.373, 0, 0> }
      translate <0, 6.75, -27.75>
   }
   torus { 4.5, 3 rotate <0, 0, 90> translate <0, 37.5, -9> }
   sphere { <0, 37.5, -9>, 3 }
   torus { 5, 3 rotate <0, 0, 90> translate <0, 2, -3> }
   sphere { <0, 2, -3>, 3 }
   cylinder { <0, 0, 0>, <0, 45, 0>, 3 }
}

#declare S_Snirkel=union{
   object { S_SnirkelDel translate <-2, 0, 0> }
   object { S_SnirkelDel translate < 2, 0, 0> }
   rotate <0, 0, 180>
   translate <0, 51, 0>
   texture { T_Stp_Gold }
}

#declare Globe=union{
   sphere { <0, 0, 0>, 40 }
   difference{
      sphere { <0, 0, 0>, 43 }
      box { <-50, -50, -50>, <50, -3, 50> }
      box { <-50,  3, -50>, <-3, 50, -3> }
      box { <-50,  3,  50>, <-3, 50,  3> }
      box { < 50,  3, -50>, < 3, 50, -3> }
      box { < 50,  3,  50>, < 3, 50,  3> }
   }
   texture { T_Stp_Gold }
}

#declare CrossArc=difference{
   torus { 35, 8 rotate <90, 0, 0> }
   plane { y, 0 }
   plane { x, 0 }
}

#declare CrossPind=union{
   cylinder { <0, 0, -9>, <0, 0, 9>, 5 }
   sphere { <0, 0, -9>, 3 }
   sphere { <0, 0,  9>, 3 }
}

#declare CrossKryds=union{
   object { CrossPind translate <-18,  18, 0> }
   object { CrossPind translate < 18,  18, 0> }
   object { CrossPind translate <-18, -18, 0> }
   object { CrossPind translate < 18, -18, 0> }
   box { <-14.5, -14.5, -8>, <14.5, 14.5, 8> rotate <0, 0, 45> }
   difference{
      union{
	 sphere { <0, 0, 0>, 27 scale <1, 1, 0.5> }
	 box { <-18, -18, -10>, <18, 18, 10> }
      }
      cylinder { <-20,   0, -30>, <-20,   0, 30>, 11 }
      cylinder { < 20,   0, -30>, < 20,   0, 30>, 11 }
      cylinder { <  0,  20, -30>, <  0,  20, 30>, 11 }
      cylinder { <  0, -20, -30>, <  0, -20, 30>, 11 }
   }
}

#declare Cross=union{
   cylinder { <0, 0, 0>, <0, 150, 0>, 8 }
   cylinder { <-55, 100, 0>, <55, 100, 0>, 8 }
   sphere { <-55, 100, 0>, 8 }
   sphere { < 55, 100, 0>, 8 }
   sphere { < 0, 150, 0>, 8 }
   object { CrossArc translate <-35, 65, 0> }
   object { CrossArc rotate <0, 0,  90> translate < 35,  65, 0> }
   object { CrossArc rotate <0, 0, 180> translate < 35, 135, 0> }
   object { CrossArc rotate <0, 0, 270> translate <-35, 135, 0> }
   object { CrossKryds translate < 0, 100, 0> }
   texture { T_Stp_Gold }
}


#declare Spir=union{
   object { S_Base translate <0, 0, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,   0, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,  45, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0,  90, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 135, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 180, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 225, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 270, 0> }
   object { S_Snirkel translate <0, 45, -16> rotate <0, 315, 0> }
   object { Globe translate <0, 170, 0> }
   object { Cross translate <0, 200, 0> }
}

/*-------------------------- Facade -------------------------------*/

/*--- Statues by Jim Charter ---*/
#include "cathedral/statueClockRight.inc"
#include "cathedral/statueClockLeft.inc"
#include "cathedral/statueMainCenter.inc"
#include "cathedral/statueMainLeft.inc"
#include "cathedral/statueMainRight.inc"

/* --- Columns and Pilaster ---*/

#declare FcdSoejleKapitaelBlad=union{
   difference {
      box { <-14, -120, 5>, <14, 0, 13> }
      plane { x, 0 rotate <0, 0, 5> translate <-14, 0, 0> }
      plane {-x, 0 rotate <0, 0, -5> translate <14, 0, 0> }
   }
   difference {
      cylinder { <-14, 0, 0>, <14, 0, 0>, 13 }
      cylinder { <-15, 0, 0>, <15, 0, 0>, 5 }
      plane { y, 0 }
      plane { z, 0 }
   }
   box { <-14, 5, 0>, <14, 13, -3> }
   difference {
      cylinder { <0, 5, -3>, <0, 13, -3>, 14 }
      plane {-z, 0 translate <0, 0, -3> }
   }
   rotate <-10, 0, 0>
}

#declare FcdSoejleKapitaelSnirkel=union{
   difference {
      cylinder { <0, 0, 0>, <0, 0, 50>, 36 scale <1, 70/36, 1> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 26 scale <1, 60/26, 1> }
      plane {-x, 0 }
      plane { y, 0 }
      plane {-y, 0 rotate <0, 0, -45> translate <0, 46, 0> }
      translate <42, -82, 0>
   }
   difference {
      cylinder { <0, 0, 0>, <0, 0, 50>, 36 scale <70/36, 1, 1> }
      cylinder { <0, 0, -1>, <0, 0, 51>, 26 scale <60/26, 1, 1> }
      plane {-x, 0 }
      plane { y, 0 }
      plane { y, 0 rotate <0, 0, -45> translate <-46, 0, 0> }
      translate <88, -36, 0>
   }
   cylinder { <88, -18, 0>, <88, -18, 50>, 18 }
   cylinder { <88, -18, -3>, <88, -18, 50>, 8 }
   rotate <0, 22.5, 0> translate <0, 0, -70>
}

#declare FcdSoejleKapitaelSnirkel2=union{
   cylinder { <13, -13,  0>, <13, -13, 30>, 13 }
   cylinder { <13, -13, -3>, <13, -13, 30>, 6 }
   rotate <0, -22.5, 0> translate <5, 0, -95>
}

#declare FcdSoejleKapitaelBlomst=union{
   difference {
      cylinder { <0, 0, 0>, <0, 28, 0>, 18 }
      torus { 20, 12 scale <1, 25/12, 1> }
      cone { <0, 18, 0>, 1, <0, 29, 0>, 12 }
   }
   difference {
      torus { 15, 5 }
      plane { y, 0 }
      translate <0, 25, 0>
   }
   sphere { <0, 26,0>, 7 }
   rotate <-120, 0, 0>
}

#declare FcdSoejleKapitaelDelA=union{
   difference {
      box { <0, 210, 0>, <125, 220, -125> }
      plane {-x, 0 rotate <0, -45, 0> }
      plane {-x, 0 rotate <0, 45, 0> translate <115, 0, -115> }
      cylinder { <0, 209, -333>, <0, 221, -333>, 233 }
   }
   difference {
      box { <0, 195, 0>, <115, 210, -115> }
      plane {-x, 0 rotate <0, -45, 0> }
      plane {-x, 0 rotate <0, 45, 0> translate <105, 0, -105> }
      cylinder { <0, 194, -333>, <0, 211, -333>, 243 }
   }
   difference {
      object { FcdSoejleKapitaelSnirkel translate <0, 195, 0> }
      plane {-z, 0 rotate <0, 45, 0> }
   }
   object { FcdSoejleKapitaelSnirkel2 translate <0, 185, 0> }
}

#declare FcdSoejleKapitaelDel=union{
   object { FcdSoejleKapitaelDelA }
   object { FcdSoejleKapitaelBlad translate <0, 63, -78> rotate <0, -22.5, 0> }
   object { FcdSoejleKapitaelDelA scale <-1, 1, 1> }
   object { FcdSoejleKapitaelBlad translate <0, 63, -78> rotate <0, -22.5, 0> scale <-1, 1, 1> }
   object { FcdSoejleKapitaelBlad translate <0, 110, -88> }
   object { FcdSoejleKapitaelBlad translate <0, 110, -88> rotate <0, -45, 0> }
   object { FcdSoejleKapitaelBlad scale <2, 1, 2> translate <0, 150, -100> rotate <0, -45, 0>  }
   object { FcdSoejleKapitaelBlomst translate <0, 212, -80> }
}

#declare FcdSoejleKapitael=union{
   object { FcdSoejleKapitaelDel }
   object { FcdSoejleKapitaelDel rotate <0,  90, 0> }
   object { FcdSoejleKapitaelDel rotate <0, 180, 0> }
   object { FcdSoejleKapitaelDel rotate <0, 270, 0> }
   cylinder { <0, 185, 0>, <0, 195, 0>, 95 }
   cone { <0, 0, 0>, 60, <0, 220, 0>, 70 }
   torus { 70, 10 translate <0, 10, 0> }
}

#declare FcdSoejleTrimmings=union{    //Hjde 1755
   box { <-128, 0, -128>, <128, 26, 128> }
   torus { 111, 16 translate <0, 36, 0> }
   difference {
      cylinder { <0, 52, 0>, <0, 70, 0>, 111 }
      torus { 111, 15 translate <0, 68, 0> }
   }
   torus { 100, 10 translate <0, 75, 0> }
   cylinder { <0, 85, 0>, <0, 90, 0>, 100 }
   difference {
      cylinder { <0, 90, 0>, <0, 95, 0>, 99.9135 }
      torus { 99.9135, 5 translate <0, 95, 0> }
   }
#if(ShowDetail)
   object { FcdSoejleKapitael translate <0, 1535, 0> }
#end
}

#declare FcdSoejleSmooth=union{    //Hjde 1755
   object { FcdSoejleTrimmings }
   cone { <0, 90, 0>, 95, <0, 1535, 0>, 70 }
}

#declare FcdSoejleFluted=union{    //Hjde 1755
   object { FcdSoejleTrimmings }
   difference {
      cone { <0, 90, 0>, 95, <0, 1535, 0>, 70 }
      #declare ang = 0;
      #while (ang <360)
         cone { <0, 89, 0>, 11, <0, 1536, 0>, 8 translate <0, 0, -98> rotate <1, ang, 0> }
         #declare ang = ang + 360/24;
      #end
   }      
}

#declare FcdPilasterBaseProfile=union {
   cylinder { <0, 3, -3>, <1, 3, -3>, 3 }
   difference {    
      union {
         box { <0, 0, -3>, <1, 10, 5> }
         box { <0, 10, -1>, <1, 18, 5> }
      }   
      cylinder { <-0.1, 10, -3>, <1.1, 10, -3>, 3 }
   }
   cylinder { <0, 15.5, -1>, <1, 15.5, -1>, 2.5 }
}

#declare FcdPilasterKapitaelBlad=union {
   difference {
      union {
         box { <-6, 0, 2>, <6, -9, -3> }
         cylinder { <0, 0, -3>, <0, -9, -3>, 6 }
      }
      cylinder { <-7, -9, -9>, <7, -9, -9>, 8 }   
      cylinder { <-7, -9, -9>, <7, -9, -9>, 9 inverse }   
      box { <-7, -5, 0>, <7, 7.3, -5> rotate <-8.6125, 0, 0> translate <0, -15, 0> }  
   }
   difference {
      box { <-6, -9, 2>, <6, -15, -3> }
      box { <-7, -5, 0>, <7, 7.3, -5> rotate <-8.6125, 0, 0> translate <0, -15, 0> }  
   }
}
         
#declare FcdPilasterKapitaelDel=union {
   difference {
      box { <-30, 0, -30>, <0, -2, 0> }
      cylinder { <0, 1, -66>, <0, -3, -66>, 45 }
      plane { x, 0 rotate <0, 45, 0> }
      plane { x, 0 rotate <0, -45, 0> translate <-27, 0, -30> }
   }   
#if(ShowDetail)
   difference {
      box { <-30, -2, -30>, <0, -15, 0> }  
      cylinder { <0, 1, -66>, <0, -30, -66>, 46 }     
      union {
         box { <-25, 10, -10>, <0, -10, 10> }
         cylinder { <0, 0, -15>, <0, 0, 15>, 10 scale <1.3, 1, 1> }
         rotate <0, -45, 0> translate <-20, -16, -20> 
      }
      plane { x, 0 rotate <0, 45, 0> }
      plane { x, 0 rotate <0, -45, 0> translate <-26, 0, -29> }
   }
   difference {                               
      union {
         cylinder { <0, 0, 0>, <3.5, 0, 0>, 10 } 
         cylinder { <0, 0, 0>, <4.5, 0, 0>, 5 } 
         cylinder { <0, 0, 0>, <5.5, 0, 0>, 1.5 } 
         rotate <0, 67.5, 0>  translate <-18, -12, -20> 
      }   
      plane { x, 0 rotate <0, 45, 0> }
   }   
   difference {
      sphere { <0, 0, 0>, 23 scale <1, 0.5, 1>   }
      plane {-y, 0 translate <0, 1, 0> }
      plane { y, 0 translate <0, -5, 0> }
      plane {-z, 0 translate <0, 0, -10> }
      translate <0, -11, 0>
   }   
#end
}

#declare FcdPilasterKapitael=union {
   object { FcdPilasterKapitaelDel }
   object { FcdPilasterKapitaelDel scale <-1, 1, 1> }
#if(ShowDetail)      
   object { FcdPilasterKapitaelBlad translate <0, -21, -20> }
   object { FcdPilasterKapitaelBlad rotate <0, 45, 0> translate <-17.5, -21, -17.5> }
   object { FcdPilasterKapitaelBlad translate <-10, -30, -20> }
   object { FcdPilasterKapitaelBlad translate < 10, -30, -20> }
   object { FcdSoejleKapitaelBlomst scale 0.25 translate <0, -3, -20> }
#end   
}   

#declare FcdPilaster=union {
   difference {
      object { FcdPilasterBaseProfile scale <52, 1, 1> translate <-26, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-20, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 20, 0, 0> }
      translate <0, 0, 0>
   }
   difference {
      object { FcdPilasterBaseProfile scale <36, 1, 1> translate <-6, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <20, 0, 0>
   }
   difference {
      object { FcdPilasterBaseProfile scale <36, 1, 1> translate <-6, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <20, 0, 0>
      scale <-1, 1, 1>
   }
   box { <-20, 18, 0>, <20, 453, 30> }  
   difference {
      cylinder { <-25, 420-12, 0>, <25, 420-12, 0>, 2.5 }
      plane { x, 0 rotate <0,  45, 0> translate <-20, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 20, 0, 0> }
   }       
   object { FcdPilasterKapitael translate <0, 453, 20> }
   object { FcdPilasterKapitael rotate <0,  90, 0> translate <0, 453, 20> }
   object { FcdPilasterKapitael rotate <0, -90, 0> translate <0, 453, 20> }
}      

#declare FcdMainGesims1Profile=union{
   box { <0, 0, 0>, <1, 100, 20> }
   box { <0, 12, 0>, <1, 27, -2> }
   box { <0, 27, 0>, <1, 35, -3> }
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 4 scale <1, 1, 2/4> }
      plane {-y, 0 }
      translate <0, 33, -4> 
   }
   box { <0, 33, 0>, <1, 35, -7> }
   box { <0, 65, 0>, <1, 75, -10> }
   box { <0, 75, 0>, <1, 98, -30> }
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 8 }
      plane {-y, 0 }
      translate <0, 98, -30> 
   }
   box { <0, 98, 0>, <1, 100, -40> }
}

#declare FcdMainGesims2ProfileA=union{
   box { <0, 0, 40>, <1, 70, 0> }
   box { <0, 9, 0>, <1, 17, -2> }
   difference {  
      box { <0, 17, 0>, <1, 26, -5> }
      cylinder { <-0.1, 0, 0>, <1.1, 0, 0>, 3 scale <1, 2, 1> translate <0, 17, -5> }
   }           
   cylinder { <0, 70, 0>, <1, 70, 0>, 5 }
   box { <0, 70, 20>, <1, 83, -24> }
}

#declare FcdMainGesims2ProfileB=union{
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 8 }
      plane {-y, 0 }
      translate <0, 91, -24> 
   }
   box { <0, 91, 70>, <1, 95, -36> }
}

#declare FcdMainGesims2Profile=union{
   object { FcdMainGesims2ProfileA }
   object { FcdMainGesims2ProfileB }
}

#declare FcdMainGesims3Profile=union{ //Topaligned
   box { <0, 0, 0>, <1, -2, -22> }  
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 8 scale <1, 1, 0.5> }
      plane {-y, 0 }
      translate <0, -2, -14>
   }   
   box { <0, -2, 0>, <1, -18, -14> }
   cylinder { <0, -18, 0>, <1, -18, 0>, 5 }
}

#declare FcdMainGesims4Profile=union{ //Topaligned
   box { <0, 0, 0>, <1, -3, -20> }  
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 5 }
      plane {-y, 0 }
      translate <0, -3, -14>
   }   
   box { <0, -3, 0>, <1, -11, -15> }
   box { <0, -11, 0>, <1, -18, -13> }
   cylinder { <0, -18, 0>, <1, -18, 0>, 3 }
   box { <0, -35, 0>, <1, -36, -6> }
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 3 }
      plane {-y, 0 }
      translate <0, -36, -2>
   }                   
   box { <0, -39, 0>, <1, -43, -2> }
}


#declare FcdMainGesims2Konsol=union{
#if(ShowDetail)
   cylinder { <-5, 3, -2>, <5, 3, -2>, 3 }
   difference {
      box { <-5, 0, 0>, <5, 24, -9> }
      cylinder { <-6, 0, 0>, <6, 0, 0>, 34 scale <1, 37/34, 1> translate <0, 2, -36> }
      torus { 34, 1 rotate <0, 0, 90> scale <1, 37/34, 1> translate <-2, 2, -36> }
      torus { 34, 1 rotate <0, 0, 90> scale <1, 37/34, 1> translate < 2, 2, -36> }
   }                                       
   difference {
      cylinder { <-5, 29, 0>, <5, 29, 0>, 10 }
      torus { 10, 1 rotate <0, 0, 90> translate <-2, 29, 0> }
      torus { 10, 1 rotate <0, 0, 90> translate < 2, 29, 0> }
   }   
   box { <-5, 35, 0>, <5, 44, -7> }
   cylinder { <-5, 39, -12>, <5, 39, -12>, 6 }
#else
   box { <-5, 0, 0>, <5, 44, -5> }
   cylinder { <-5, 39, -12>, <5, 39, -12>, 6 }
#end   
}

#declare FcdCordon1Profile=difference {
   cylinder { <0, 0, 0>, <1, 0, 0>, 6.5 }
   box { <-0.1, -1.5, -7>, <1.1, 1.5, -4.5> }
   scale <1, 1, 5.5/6.5>
}   
  
#declare FcdTowerUrn1=union{
   box { <-12, 0, -12>, <12, 8, 12> }
   difference {
      cylinder { <0, 8, 0>, <0, 20, 0>, 10 }
      torus { 13, 8.554 sturm translate <0, 16, 0>}
   }
   torus { 5.5, 1 sturm translate <0, 19, 0> }
                                              
   #declare ang = 0;
   #while (ang < 360)                                              
      difference { 
         sphere { <0, 0, 0>, 17 scale <0.45, 1, 1> }
         plane {-y, 0 }
         rotate <0, ang, 0> translate <0, 36 ,0>
      }
      #declare ang = ang + 360/3;
   #end   
      
   difference {
      cylinder { <0, 36, 0>, <0, 48, 0>, 12 }
      torus { 18, 12 sturm translate <0, 49, 0> }
   }
   torus { 6, 1 sturm translate <0, 48, 0> }
   #declare ang = 0;
   #while(ang < 360)
      cylinder { <0, 48, -3.5>, <0, 60, -3.5>, 2 rotate <0, ang, 0> }
      #declare ang = ang + 360/6;
   #end   
   torus { 6, 1 sturm translate <0, 60, 0> }
   difference {
      sphere { <0, 0, 0>, 5 }
      plane { y, 0 }
      translate <0, 60, 0>         
   }
   cylinder { <0, 64, 0>, <0, 69, 0>, 3 }
   torus { 3, 1 sturm translate <0, 70, 0> }
}

#declare FcdTowerUrn1Gold=union{
   object { FcdTowerUrn1 }
   sphere { <0, 75, 0>, 5 texture { T_Stp_Gold } }
}

#declare FcdTowerUrn1Plain=union{
   object { FcdTowerUrn1 }
   sphere { <0, 75, 0>, 5 }
}

/*--------------- Tower --------------------*/

#declare FcdTowerBaseCornerBrickLayer=difference {
   box { <0, 0, 0>, <140, 17, 140> }
   box { <-1, -1,  15>, <3, 18,  18> }
   box { <-1, -1,  51>, <3, 18,  54> }
   box { <-1, -1,  87>, <3, 18,  90> }
   box { <-1, -1, 123>, <3, 18, 126> }
   box { < 33, -1, -1>, < 36, 18, 3> }
   box { < 69, -1, -1>, < 72, 18, 3> }
   box { <105, -1, -1>, <108, 18, 3> }
}
   
#declare FcdTowerBaseCorner=union {
   box { <-75, 0, -75>, <75, 20+39, 75> }
   box { <-68, 20+39, -68>, <68, 95+39, 68> }
   object { FcdTowerBaseCornerBrickLayer translate <-70.5, 19+39, -70.5> }
   object { FcdTowerBaseCornerBrickLayer scale <-1, 1, 1> rotate <0, 90, 0> translate <-70.5, 39+39, -70.5> }
   object { FcdTowerBaseCornerBrickLayer translate <-70.5, 59+39, -70.5> }
   object { FcdTowerBaseCornerBrickLayer scale <-1, 1, 1> rotate <0, 90, 0> translate <-70.5, 79+39, -70.5> }
   box { <-75, 95+39, -75>, <75, 105+39, 75> }
}

#declare FcdTowerBaseMidBrickLayer=difference {
   box { <0, 0, 0>, <284, 17, 17> }
   box { < 38, -1, -1>, < 41, 18, 3> }
   box { < 79, -1, -1>, < 82, 18, 3> }
   box { <120, -1, -1>, <123, 18, 3> }
   box { <161, -1, -1>, <164, 18, 3> }
   box { <202, -1, -1>, <205, 18, 3> }
   box { <243, -1, -1>, <246, 18, 3> }
}

#declare FcdTowerBaseMidBricks=union {
   box { <0, 20+39, 3>, <304, 95+39, 20> }
   object { FcdTowerBaseMidBrickLayer translate <0, 19+39, 0> }
   object { FcdTowerBaseMidBrickLayer translate <20.5, 39+39, 0> }
   object { FcdTowerBaseMidBrickLayer translate <0, 59+39, 0> }
   object { FcdTowerBaseMidBrickLayer translate <20.5, 79+39, 0> }
}

#declare FcdTowerBase=union {
   box { <-245, 0, -245>, <245, 20+39, 245> }
   object { FcdTowerBaseCorner translate <-195, 0, -195> }
   object { FcdTowerBaseCorner translate < 195, 0, -195> }
   object { FcdTowerBaseCorner translate <-195, 0,  195> }
   object { FcdTowerBaseMidBricks translate <-152, 0, -240> }
   object { FcdTowerBaseMidBricks rotate <0, 90, 0> translate <-240, 0, 152> }
   box { <-245, 95+39, -245>, <245, 105+39, 245> }
}

/*--- Floor 1 ---*/

#declare FcdTowerF1PilasterPair=union {   
   box { <-65, 0, -10>, <-5, 12, 46> }
   box { < 65, 0, -10>, < 5, 12, 46> }
   object { FcdPilaster translate <-35, 12, 0> }
   object { FcdPilaster translate < 35, 12, 0> }   
   #declare pos = 0;
   #while (pos < 400)       
      difference {
         box { <-20, pos, 5>, <20, pos+40, 20> }
         box { <-21, pos+17, 4>, <21,pos+20, 8> }
         box { <-21, pos+37, 4>, <21,pos+41, 8> }
         box { <-1.5, pos+18, 4>, <1.5, pos+38, 8> }
      }   
      #declare pos = pos + 40;
   #end   
   box { <-20, 400, 5>, <20, 417, 20> }
   cylinder { <-20, 420, 5>, <20, 420, 5>, 2.5 }
   box { <-20, 400, 5>, <20, 465, 20> }   
   difference {
      object { FcdMainGesims1Profile scale <200, 1, 1> translate <-100, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-55, 0, 0> } 
      plane {-x, 0 rotate <0, -45, 0> translate < 55, 0, 0> } 
      translate <0, 465, 0>
   }   
}

#declare FcdTowerF1WindowGesims1Profil=union{
   box { <0, 0, 0>, <1, 20, -1> }
   cylinder { <0, 5, -1>, <1, 5, -1>, 2 }
   box { <0, 5, 0>, <1, 20, -3> }
   box { <0, 10, 0>, <1, 20, -4> }
   box { <0, 16, 0>, <1, 20, -5> }
   cylinder { <0, 18, -5>, <1, 18, -5>, 1 }
   box { <0, 18, 0>, <1, 20, -6> }
}
   
#declare FcdTowerF1WindowGesims1Arc=union{
   difference {
      cylinder { <0,  0, 0>, <0, 20, 0>, 45 scale <1, 1, 30/45> }
      cylinder { <0, -1, 0>, <0, 21, 0>, 44 scale <1, 1, 29/44> }
   }    
   torus { 44, 2 scale <1, 1, 29/44> translate <0, 5, 0> }
   difference {
      cylinder { <0,  5, 0>, <0, 20, 0>, 45 scale <1, 1, 30/45> }
      cylinder { <0, -1, 0>, <0, 21, 0>, 42 scale <1, 1, 27/42> }
   }   
   difference {
      cylinder { <0, 10, 0>, <0, 20, 0>, 45 scale <1, 1, 30/45> }
      cylinder { <0, -1, 0>, <0, 21, 0>, 41 scale <1, 1, 26/41> }
   }   
   difference {
      cylinder { <0, 16, 0>, <0, 20, 0>, 45 scale <1, 1, 30/45> }
      cylinder { <0, -1, 0>, <0, 21, 0>, 40 scale <1, 1, 25/40> }
   }   
   torus { 40, 1 scale <1, 1, 25/40> translate <0, 18, 0> }
   difference {
      cylinder { <0, 18, 0>, <0, 20, 0>, 45 scale <1, 1, 30/45> }
      cylinder { <0, -1, 0>, <0, 21, 0>, 39 scale <1, 1, 24/39> }
   }   
}

#declare FcdTowerF1WindowRib1=difference{
   box { <-90, 0, -215>, <90, 90, -170> }
   cylinder { <0, 0, -216>, <0, 0, -100>, 43 }
   torus { 43, 42 rotate <90, 0, 0> scale <1, 1, 27/42> translate <0, 0, -215> }
   plane { x, 0 translate <-5, 0, 0> }
   plane {-x, 0 translate < 5, 0, 0> }        
}

#declare FcdTowerF1WindowRib2=difference{
   box { < -88, 0, -215>, <-43, 10, -185> }
   cylinder { <0, -1, 0>, <0, 11, 0>, 42 scale <1, 1, 27/42> translate <-43, 0, -215> }
}

#declare FcdTowerF1Window=union{
   box { <-161, 0, -235>, <-101, 12, -175> } // Pilaster Plinth
   box { < 161, 0, -235>, < 101, 12, -175> } // Pilaster Plinth
   object { FcdPilaster translate <-131, 12, -225> }
   object { FcdPilaster translate < 131, 12, -225> }     
   difference {  // Plinth
      box { <-112, 0, -224>, <112, 30, -170> }
      box { < -81, -1, -225>, <81, 32, -100> }
   }   
   difference { 
      box { <-112, 0, -220>, <112, 465, -170> }
      box { < -85, -1, -221>, <85, 284, -100> }
      box { < -88, -1, -215>, <88, 284, -100> }
      cylinder { <0, 284, -221>, <0, 284, -100>, 85 }
      cylinder { <0, 284, -215>, <0, 284, -100>, 88 }
   }    
   cylinder { <-112, 420, -220>, <112, 420, -220>, 2.5 }
   difference { 
      box { <-90, 0, -215>, <90, 400, -170> }
      box { < -43, 0, -221>, <43, 284, -185> }
      box { < -31, 165, -221>, <31, 284, -100> }
      cylinder { <0, 284, -221>, <0, 284, -100>, 31 }
      cylinder { <0, -1, 0>, <0, 285, 0>, 45 scale <1, 1, 30/45> translate <-43, 0, -215> }
      cylinder { <0, -1, 0>, <0, 285, 0>, 45 scale <1, 1, 30/45> translate < 43, 0, -215> }
      torus { 43, 45 rotate <90, 0, 0> scale <1, 1, 30/45> translate <0, 284, -215> }
   }
   #declare pos = 30;
   #while (pos < 265)        
      object { FcdTowerF1WindowRib2 translate <0, pos, 0> }
      object { FcdTowerF1WindowRib2 scale <-1, 1, 1> translate <0, pos, 0> }
      #declare pos = pos + 37;
   #end
   difference {
      object { FcdTowerF1WindowGesims1Profil scale <32, 1, 1> translate <-6, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      translate <85, 264, -220>
   }   
   difference {
      object { FcdTowerF1WindowGesims1Profil scale <12, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <85, 264, -220>
   }   
   difference {
      object { FcdTowerF1WindowGesims1Profil scale <32, 1, 1> translate <-6, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      translate <85, 264, -220>
      scale <-1, 1, 1>
   }                                 
   difference {
      object { FcdTowerF1WindowGesims1Profil scale <12, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <85, 264, -220>
      scale <-1, 1, 1>
   }   
   difference {
      object { FcdTowerF1WindowGesims1Arc }
      plane { z, 0 }
      plane { x, 0 }
      translate <43, 264, -215>
   }   
   difference {
      object { FcdTowerF1WindowGesims1Arc }
      plane { z, 0 }
      plane { x, 0 }
      translate <43, 264, -215>
      scale <-1, 1, 1>
   }   
   difference { 
      union {
         difference {
            cylinder { <0, 0, 0>, <0, 0, -1>, 111 }
            cylinder { <0, 0, 1>, <0, 0, -6>,  90 }
         }
         difference {
            cylinder { <0, 0, 0>, <0, 0, -2>, 111 }
            cylinder { <0, 0, 1>, <0, 0, -6>,  98 }
         }                                       
         intersection {
            torus { 109, 4 scale <1, 2/4, 1> rotate <90, 0, 0> translate <0, 0, -2> }
            cylinder { <0, 0, 1>, <0, 0, -6>, 109 }
         }
         difference {
            cylinder { <0, 0, 0>, <0, 0, -5>, 111 }
            cylinder { <0, 0, 1>, <0, 0, -6>, 109 } 
         }
      }
      plane { y, 0 }
      translate <0, 284, -220>
   }      

   box { <-43, 165, -188>, <-31, 284, -180> }
   box { <-44, 160, -189>, <-30, 165, -180> } //Sokkel
   box { <-45, 274, -190>, <-29, 284, -170> } //Gesims
   box { <-46, 282, -191>, <-28, 284, -170> } //Gesims
   box { < 43, 165, -188>, < 31, 284, -180> }
   box { < 45, 160, -190>, < 29, 165, -180> } //Sokkel
   box { < 44, 274, -189>, < 30, 284, -170> } //Gesims
   box { < 46, 282, -191>, < 28, 284, -170> } //Gesims
   difference{
      cylinder { <0, 284, -188>, <0, 284, -180>, 43 }
      cylinder { <0, 284, -190>, <0, 284, -100>, 31 }
      plane { y, 0 translate <0, 284, 0> }
   }                             
   box { <-46, 160, -198>, <46, 155, -180> }
   difference {
      box { <-43, 100, -195>, <43, 155, -180> }
      box { <-35, 108, -200>, <35, 147, -192> }
   }
   box { <-30 , 113, -195>, <30, 142, -190> }
   box { <-70,   95, -222>, <70, 100, -180> }
   difference {
      box { <-65,  30, -217>, <65,  95, -180> }
      box { <-55,  40, -220>, <55,  85, -214> }
   }
   box { <-50,  45, -217>, <50,  80, -210> }
   box { <-70,  0, -222>, <70,  30, -180> }
   
   #declare ang = -87.5;
   #while (ang < 90)
      object { FcdTowerF1WindowRib1 rotate <0, 0, ang> translate <0, 284, 0> }
      #declare ang = ang + 25;
   #end
   union {
      box { < -31, 165, 0>, <31, 284, 1> }
      cylinder { <0, 284, 0>, <0, 284, 1>, 31 }
      translate <0, 0, -185>
      texture { T_Stp_Windowpane }
   }                     
   object { FcdMainGesims1Profile scale <290, 1, 1> translate <-145, 465, -225> }
}

#declare FcdTowerF1Wall=union{
   object { FcdTowerF1PilasterPair translate <-195, 0, -250> }
   box { <-161, 0, -235>, <-101, 12, -175> }
   object { FcdPilaster translate <-131, 12, -225> }
   object { FcdTowerF1Window }
   object { FcdPilaster translate < 131, 12, -225> }
   box { < 161, 0, -235>, < 101, 12, -175> }
   object { FcdTowerF1PilasterPair translate < 195, 0, -250> }
   difference {
      object { FcdMainGesims1Profile scale <100, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <-140, 465, -250>
   }   
   difference {
      object { FcdMainGesims1Profile scale <100, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <-140, 465, -250>      
      scale <-1, 1, 1>
   }   
}

#declare FcdTowerF1=union{
   object { FcdTowerF1Wall }
   object { FcdTowerF1Wall rotate <0, 90, 0> }
}
   
/*--- Floor 2 ---*/

#declare FcdTowerF2PilasterPair=union {
   difference {
      box { <-55, 0, -6>, <55, 50, 40> }
      box { <-9, -1, -10>, <9, 51, 4> }
   }   
   object { FcdPilaster scale <0.85, 355/453, 0.85> translate <-32, 50, 0> }
   object { FcdPilaster scale <0.85, 355/453, 0.85> translate < 32, 50, 0> }   

   object { FcdPilasterBaseProfile scale <40, 355/453, 0.85> translate <-20, 50, 9> }
   #declare pos = 64;
   #while (pos < 350)       
      difference {
         box { <-20, pos, 9>, <20, pos+30.6, 20> }
         box { <-21, pos+13, 4>, <21, pos+15.3, 12> }
         box { <-21, pos+28.3, 4>, <21, pos+31, 12> }
         box { <-1.5, pos+15, 4>, <1.5, pos+30, 12> }
      }   
      #declare pos = pos + 30.6;
   #end   
   box { <-20, 370, 9>, <20, 405, 20> }
   object { FcdCordon1Profile scale <40, 1, 1> translate <-20, 116.5, 9> }
   cylinder { <-20, 370, 9>, <20, 370, 9>, 2 }
   difference {
      object { FcdMainGesims2Profile scale <200, 1, 1> translate <-100, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-49, 0, 0> } 
      plane {-x, 0 rotate <0, -45, 0> translate < 49, 0, 0> } 
      translate <0, 405, 0>
   }   
   object { FcdMainGesims2Konsol translate <-44, 431, 0> }
   object { FcdMainGesims2Konsol translate <-14.67, 431, 0> }
   object { FcdMainGesims2Konsol translate < 14.67, 431, 0> }
   object { FcdMainGesims2Konsol translate < 44, 431, 0> }
}

#declare FcdTowerF2WindowColumn=union{
   box { <-19, 0, -19>, <19, 50, 19> }
   difference {
      object { FcdPilasterBaseProfile scale <40, 355/453, 0.85> translate <-20, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> translate <-13, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <13, 0, 0> }
      translate <0, 50, -13>
   }   
   difference {
      object { FcdPilasterBaseProfile scale <30, 355/453, 0.85> translate <-10, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <13, 50, -13>
   }   
   difference {
      object { FcdPilasterBaseProfile scale <30, 355/453, 0.85> translate <-10, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <13, 50, -13>
      scale <-1, 1, 1>
   }   
   box { <-13, 50, -13>, <13, 123, 13> }
   difference {
      object { FcdCordon1Profile scale <40, 1, 1> translate <-20, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> translate <-13, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <13, 0, 0> }
      translate <0, 116.5, -13>
   }   
   difference {
      object { FcdCordon1Profile scale <30, 1, 1> translate <-10, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <13, 116.5, -13>
   }   
   difference {
      object { FcdCordon1Profile scale <30, 1, 1> translate <-10, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <13, 116.5, -13>
      scale <-1, 1, 1>
   }   
   object { FcdSoejleSmooth scale 0.105 translate <0, 123, 0> }
}
   
#declare FcdTowerF2WindowframeProfile=union{
   box { <0, 0, 0>, <1, 14, -1> }
   box { <0, 5, -1>, <1, 14, -3> }
   difference {
      box { <0, 10, -3>, <1, 14, -5> }
      cylinder { <-0.1, 9, -5>, <1.1, 9, -5>, 2 }
   }   
}

#declare FcdTowerF2WindowTopProfile1=union{
  box { <0, 0, 16>, <1, 26, 0> }
  box { <0, 4, 0>, <1, 12, -1> }
  box { <0, 9.5, 0>, <1, 12, -3> }
  difference {
     cylinder { <0, 0, 0>, <1, 0, 0>, 6 }
     plane {-y, 0 }
     translate <0, 22, 0>
  }   
  box { <0, 22, 0>, <1, 26, -9> }
}

#declare FcdTowerF2WindowTopProfile2=union{
  box { <0, -4, 25>, <1, 0, 0> }
  difference {
     cylinder { <0, 0, 0>, <1, 0, 0>, 2 }
     plane {-y, 0 } 
     translate <0, 2, 0>
  }   
  box { <0, 2, 25>, <1, 4, -4> }
}

#declare FcdTowerF2Window=union{
   box { <-122, 0, 0>, <122, 50, 40> }
   object { FcdPilasterBaseProfile scale <246, 355/453, 0.85> translate <-123, 50, 6> }
   object { FcdCordon1Profile scale <224, 1, 1> translate <-112, 116.5, 6> }
   object { FcdTowerF2WindowColumn translate <-65, 0, 3> }     
   difference {
      box { <-65, 50, 6>, <65, 123, 40> }
      box { <-33, 68, 0>, <33, 105, 10> }
   }
   object { FcdTowerF2WindowColumn translate < 65, 0, 3> } 
   #declare pos = 64;
   #while (pos < 300)       
      difference {
         box { <-20, pos, 9>, <45, pos+30.6, 20> }
         box { <-21, pos+13, 4>, <46, pos+15.3, 12> }
         box { <-21, pos+28.3, 4>, <46, pos+31, 12> }
         box { <-3, pos+15, 4>, <0, pos+30, 12> }
         translate <-92, 0, 0>
      }   
      difference {
         box { <-20, pos, 9>, <45, pos+30.6, 20> }
         box { <-21, pos+13, 4>, <46, pos+15.3, 12> }
         box { <-21, pos+28.3, 4>, <46, pos+31, 12> }
         box { <-3, pos+15, 4>, <0, pos+30, 12> }
         translate <-92, 0, 0>
         scale <-1, 1, 1>
      }   
      #declare pos = pos + 30.6;
   #end   
   #while (pos < 350)       
      difference {
         box { <-112, pos, 9>, <112, pos+30.6, 20> }
         box { <-113, pos+13, 4>, <113, pos+15.3, 12> }
         box { <-113, pos+28.3, 4>, <113, pos+31, 12> }
         box { <-95, pos+15, 4>, <-92, pos+30, 12> }
         box { < 95, pos+15, 4>, < 92, pos+30, 12> }
      }   
      #declare pos = pos + 30.6;
   #end                        
   cylinder { <-112, 370, 9>, <112, 370, 9>, 2 }
   box { <-112, 370, 9>, <112, 405, 40> }
   difference {      
      object { FcdTowerF2WindowframeProfile scale <94, 1, 1> translate <-47, 0, 0> }
      plane { x, 0 rotate <0, 0, 45> translate <-33, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> translate <33, 0, 0> }
      translate <0, 308.8-14-2.3, 9>
   }   
   difference {      
      object { FcdTowerF2WindowframeProfile scale <200, 1, 1> translate <-185, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <-33, 308.8-14-2.3, 9>
   }   
   difference {      
      object { FcdTowerF2WindowframeProfile scale <200, 1, 1> translate <-185, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> }
      rotate <0, 0, 90> translate <-33, 308.8-14-2.3, 9>
      scale <-1, 1, 1>
   }   
   box { <-47, 123, 10>, <47, 308.8, 11> texture { T_Stp_Windowpane } }
   difference {      
      object { FcdTowerF2WindowTopProfile1 scale <180, 1, 1> translate <-90, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> translate <-75, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate <75, 0, 0> }
      translate <0, 308.8-2.3, -7>
   }   
   difference {      
      object { FcdTowerF2WindowTopProfile1 scale <30, 1, 1> translate <-14, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <75, 308.8-2.3, -7>
   }   
   difference {      
      object { FcdTowerF2WindowTopProfile1 scale <30, 1, 1> translate <-14, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <75, 308.8-2.3, -7>
      scale <-1, 1, 1>
   }                                   
   difference {
      box { <-85, 334, 0>, <85, 385, 9> }
      plane { x, 0 rotate <0, 0, -60> translate <-84, 334, 0> }
      plane {-x, 0 rotate <0, 0,  60> translate < 84, 334, 0> }    
   }
   union {
      difference {
        object { FcdTowerF2WindowTopProfile2 scale <110, 1, 1> translate <-10, 0, 0> }
        plane { x, 0 rotate <0, 45, 0> }
        plane {-x, 0 rotate <0, 0, -30> translate <97.285, 0, 0> }
     }   
      difference {
        object { FcdTowerF2WindowTopProfile2 scale <40, 1, 1> translate <-30, 0, 0> }
        plane {-x, 0 rotate <0, -45, 0> }
        rotate <0, 90, 0>
     }   
     rotate <0, 0, 30> translate <-84, 334, -16>
   }  
   union {
      difference {
        object { FcdTowerF2WindowTopProfile2 scale <110, 1, 1> translate <-10, 0, 0> }
        plane { x, 0 rotate <0, 45, 0> }
        plane {-x, 0 rotate <0, 0, -30> translate <97.285, 0, 0> }
     }   
      difference {
        object { FcdTowerF2WindowTopProfile2 scale <40, 1, 1> translate <-30, 0, 0> }
        plane {-x, 0 rotate <0, -45, 0> }
        rotate <0, 90, 0>
     }   
     rotate <0, 0, 30> translate <-84, 334, -16>
     scale <-1, 1, 1>
   }  
   object { FcdMainGesims2Profile scale <292, 1, 1> translate <-146, 405, -10> }
   #declare pos = -119;
   #while(pos < 120)
      object { FcdMainGesims2Konsol translate <pos, 431, -10> }
      #declare pos = pos + 34;
   #end   
}

#declare FcdTowerF2Wall=union{
   object { FcdTowerF2PilasterPair translate <-195, 0, -244> }
   box { <-151, 0, -231>, <-105, 50, -185> }
   object { FcdPilaster  scale <0.85, 355/453, 0.85> translate <-128, 50, -225> }
   object { FcdTowerF2Window translate <0, 0, -215> }
   object { FcdPilaster  scale <0.85, 355/453, 0.85> translate < 128, 50, -225> }
   box { < 151, 0, -231>, < 105, 50, -185> }
   object { FcdTowerF2PilasterPair translate < 195, 0, -244> }
   difference {
      object { FcdMainGesims2Profile scale <100, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <-146, 405, -244>
   }   
   object { FcdMainGesims2Konsol rotate <0, -90, 0> translate <-146, 431, -239> }
   difference {
      object { FcdMainGesims2Profile scale <100, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <-146, 405, -244>      
      scale <-1, 1, 1>
   }   
   object { FcdMainGesims2Konsol rotate < 0, 90, 0> translate < 146, 431, -239> }
}
                                                                  
#declare FcdTowerF2=union{
   object { FcdTowerF2Wall }
   object { FcdTowerF2Wall rotate <0, 90, 0> }
}
   
/*--- Floor 3 (Clock/Hole) ---*/

#local F3 = seed(0);

#declare FcdTowerF3WallScroll=union {
   sphere { <-21, 10, -25>, 4 }
   cylinder { <-21, 10, -25>, <-18, 10, -25>, 10 }
   cylinder { <-20, 10, -25>, < 20, 10, -25>,  8 }
   cylinder { < 21, 10, -25>, < 18, 10, -25>, 10 }
   sphere { < 21, 10, -25>, 4 }
                                                            
   difference {
      cylinder { <-18, 0, 0>, <18, 0, 0>, 19 scale <1, 25/19, 1> }
      cylinder { <-19, 0, 0>, <19, 0, 0>, 16 scale <1, 22/16, 1> }
      plane {-y, 0 }
      plane { z, 0 }
      translate <0, 40, -25>
   }                                                            
   sphere { <-21, 40, -5>, 2 }
   cylinder { <-21, 40, -5>, <-18, 40, -5>, 5 }
   cylinder { <-20, 40, -5>, < 20, 40, -5>, 4 }
   cylinder { < 21, 40, -5>, < 18, 40, -5>, 5 }
   sphere { < 21, 40, -5>, 2 }
}
   
#declare FcdTowerF3Wall=union {
   box { <-245,  0, -245>, <-145, 40, -145> }
   box { <-247, 40, -247>, <-143, 45, -143> }
   box { <-205,  0, -205>, <0, 90, 0> }                             
   box { <-207, 85, -207>, <0, 90, 0> }                             
   
   box { <-120,  0, -230>, <120, 90, 0> }
   box { <-122, 40, -232>, <122, 45, 0> }
   box { <-122, 85, -232>, <122, 90, 0> }

   box { <-200, 90, -200>, <-100, 300, -100> }
   box { <-187, 105, -205>, <-123, 260, -200> }
   box { <-205, 105, -187>, <-200, 260, -123> }   
   union {
      box { <-25, 300, -25>, <25, 350, 25> }
      object { FcdTowerF3WallScroll translate <0, 300, -25> rotate <0, -90, 0> }
      object { FcdTowerF3WallScroll translate <0, 300, -25> }
      object { FcdTowerF3WallScroll translate <0, 300, -25> rotate <0,  90, 0> }
      object { FcdTowerUrn1Gold translate <0, 350, 0> }
      rotate <0, 45, 0> translate <-165, 0, -165> 
   }
   difference {
      box { <-110, 90, -220>, <110, 300, -60> }
      cylinder { <0, 200, -230>, <0, 200, -70>, 57 texture { T_Stp_Black } }
   }   
   difference {
      cylinder { <0, 200, -230>, <0, 200, -220>, 93 }
      cylinder { <0, 200, -240>, <0, 200, -210>, 57 }
   }   
   difference {
      cylinder { <0, 200, -220>, <0, 200, -60>, 155 }
      plane { y, 0 translate <0, 300, 0> }         
      plane { x, 0 translate <-110, 0, 0> }
      plane {-x, 0 translate < 110, 0, 0> }
   }                         
   
   difference {
      object { FcdMainGesims3Profile scale <130, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      translate <-200, 300, -200>
   }   
   difference {
      object { FcdMainGesims3Profile scale <130, 1, 1> translate <-105, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0, 90, 0> translate <-200, 300, -200>
   }   
   difference {
      object { FcdMainGesims3Profile scale <40, 1, 1> translate <-15, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0, 90, 0> translate <-110, 300, -220>
   }   
   difference {
      object { FcdMainGesims3Profile scale <40, 1, 1> translate <-15, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0, 90, 0> translate <-110, 300, -220>
      scale <-1, 1, 1>
   }   
   difference {
      object { FcdMainGesims3Profile scale <30, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      plane {-x, 0 rotate <0, 0, 25.088> translate <0, -18, 0> }
      translate <-110, 300, -220>
   }   
   difference {
      object { FcdMainGesims3Profile scale <30, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      plane {-x, 0 rotate <0, 0, 25.088> translate <0, -18, 0> }
      translate <-110, 300, -220>
      scale <-1, 1, 1> 
   }                                                     
   difference { //Gesims segmentbue
      union {
         difference {
            cylinder { <0, 0, 200>, <0, 0, -22>, 155 }
            cylinder { <0, 0, 201>, <0, 0, -25>, 153 }
         }
         intersection {
            torus { 153, 8 rotate <90, 0, 0> scale <1, 1, 0.5> translate <0, 0, -14> }
            cylinder { <0, 0, 0>, <0, 0, -22>, 153 }
         }   
         difference {
            cylinder { <0, 0, 0>, <0, 0, -14>, 153 }
            cylinder { <0, 0, 1>, <0, 0, -15>, 137 }
         }
         torus { 137, 5 rotate <90, 0, 0> }
         translate <0, 200, -220>   
      }
      plane { x, 0 rotate <0, 0,  25.088> translate <-110, 282, 0> }
      plane {-x, 0 rotate <0, 0, -25.088> translate < 110, 282, 0> }
      plane { y, 0 translate <0, 200, 0> }
   }              
#if(ShowDetail)
   // Decoration around clock face
   #declare ang = 0;
   #while (ang < 360)
      #local ra = rand(F3) * 4 + 4;
      sphere { <0, 0, 0>, ra translate <0, 108-ra, 0> rotate <0, 0, ang> translate <0, 200, -220>} 
      #local ra = rand(F3) * 4 + 4;
      sphere { <0, 0, 0>, ra translate <0,  87+ra, 0> rotate <0, 0, ang+2> translate <0, 200, -220>} 
      #declare ang = ang + 4;
   #end 
#end     
}

#declare FcdTowerF3=union {
	object { FcdTowerF3Wall }
	object { FcdTowerF3Wall rotate <0,  90, 0> }
	object { FcdTowerF3Wall rotate <0, 180, 0> }
	object { FcdTowerF3Wall rotate <0, 270, 0> }
	object { statueClockLeft rotate <0, 180, 0> scale <15, 15, 10> translate <-200, 40, -235> }
	object { statueClockRight rotate <0, 90, 0> scale <15, 15, 15> translate <180, 40, -230> }
}

/*--- Floor 4 ---*/

#declare FcdTowerF4GesimsProfile=union{    
   box { <0, 0, 0>, <1, -2, -12> }
   difference {
      cylinder { <0, -2, -7>, <1, -2, -7>, 3 }
      plane {-y, 0 translate <0, -2, 0> }
   }   
   box { <0, -5, 0>, <1, -10, -7> }
   cylinder { <0, -10, 0>, <1, -10, 0>, 5 } 
}                                   

#declare FcdTowerF4Corner=union{                   
   difference {
      box { <-57, 0, -210>, <57, 125, 0> } 
      box { <-17, -1, -211>, <17, 131, -200> }
   }   
   difference {
      object { FcdTowerF4GesimsProfile scale <95, 1, 1> translate <-70, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <-57, 125, -210>
   }   
   difference {
      object { FcdTowerF4GesimsProfile scale <95, 1, 1> translate <-70, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <-57, 125, -210>
      scale <-1, 1, 1>
   }   
   difference {
      object { FcdTowerF4GesimsProfile scale <70, 1, 1> translate <-35, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-20, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 20, 0, 0> }
      translate <-37, 125, -210>
   }
   difference {
      object { FcdTowerF4GesimsProfile scale <70, 1, 1> translate <-35, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-20, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 20, 0, 0> }
      translate < 37, 125, -210>
   }
   difference {
      object { FcdTowerF4GesimsProfile scale <50, 1, 1> translate <-15, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 125, -210>
   }
   difference {
      object { FcdTowerF4GesimsProfile scale <50, 1, 1> translate <-15, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 125, -210>
      scale <-1, 1, 1>
   }
   object { FcdTowerF4GesimsProfile scale <40, 1, 1> translate <-20, 125, -200> }
   
   box { <-20, 0, -20>, <20, 13.65, 20> translate <-37, 125, -190> }
   object { FcdSoejleSmooth scale 0.14 translate <-37, 135, -190> }
   box { <-20, 0, -20>, <20, 13.65, 20> translate <-37, 125, -150> }
   box { <-14, 0, -14>, <14, 260, 14> translate <-37, 125, -150> }
   
   box { <-20, 0, -20>, <20, 13.65, 20> translate < 37, 125, -190> }
   object { FcdSoejleSmooth scale 0.14 translate < 37, 135, -190> }
   box { <-20, 0, -20>, <20, 13.65, 20> translate < 37, 125, -150> }
   box { <-14, 0, -14>, <14, 260, 14> translate < 37, 125, -150> }

   box { <-51, 380, -204>, <51, 430, 0> } 
   difference {
      object { FcdMainGesims4Profile scale <70, 1, 1> translate <-50, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0, 90, 0> translate <-51, 430, -204>
   }   
   difference {
      object { FcdMainGesims4Profile scale <140, 1, 1> translate <-70, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> translate < 51, 0, 0> } 
      plane { x, 0 rotate <0,  45, 0> translate <-51, 0, 0> } 
      translate <0, 430, -204>
   }   
   difference {
      object { FcdMainGesims4Profile scale <70, 1, 1> translate <-50, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0, 90, 0> translate <-51, 430, -204>
      scale <-1, 1, 1>
   }   
}                     

#local F4R = 170;
#declare FcdTowerF4Rotunda=union{       
   cylinder { <0, 0, 0>, <0, 125, 0>, F4R }
   // Gesims
   cylinder { <0, 125, 0>, <0, 123, 0>, F4R+12 }
   difference {
      torus { F4R+7, 3 sturm translate <0, 123, 0> }
      plane {-y, 0 translate <0, 123, 0> }
   }   
   cylinder { <0, 120, 0>, <0, 115, 0>, F4R+7 }
   torus { F4R, 5 sturm translate <0, 115, 0> }
   
   difference {
      cylinder { <0, 125, 0>, <0, 138.65, 0>, 170 }
      cylinder { <0, 124, 0>, <0, 139, 0>, 130 }
   }   
   difference {
      cylinder { <0, 125, 0>, <0, 380, 0>, 164 }
      cylinder { <0, 124, 0>, <0, 390, 0>, 136 }
      plane { x, 0 translate <-62, 0, 0> }
      box { <-23, 124, -170>, <23, 390, 170> }
      plane {-x, 0 translate < 62, 0, 0> }
      rotate <0, -45, 0>
   }   
   difference {
      cylinder { <0, 125, 0>, <0, 380, 0>, 164 }
      cylinder { <0, 124, 0>, <0, 390, 0>, 136 }
      plane { x, 0 translate <-62, 0, 0> }
      box { <-23, 124, -170>, <23, 390, 170> }
      plane {-x, 0 translate < 62, 0, 0> }
      rotate <0, 45, 0>
   }   
   #declare ang = 0;
   #while(ang < 360) 
      object { FcdSoejleSmooth scale 0.14 translate <0, 135, -150> rotate <0, ang+15, 0> }
      object { FcdSoejleSmooth scale 0.14 translate <0, 135, -150> rotate <0, ang-15, 0> }
      #declare ang = ang + 90;
   #end   
   difference {
      cylinder { <0, 125, 0>, <0, 380, 0>, 100 }
      cylinder { <0, 124, 0>, <0, 381, 0>,  80 }
      box { <-25, 124, -110>, <25, 270, 110> }
      box { <-110, 124, -25>, <110, 270, 25> }
      box { <-25, 310, -110>, <25, 350, 110> }
      cylinder { <0, 350, -110>, <0, 350, 110>, 25 }
      box { <-110, 310, -25>, <110, 350, 25> }
      cylinder { <-110, 350, 0>, <110, 350, 0>, 25 }
   }
   difference {   
      cylinder { <0, 380, 0>, <0, 430, 0>, 164 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 80 }
   }
   // Gesims
   difference {                            
      cylinder { <0, 430, 0>, <0, 427, 0>, 164+20 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 164 }
   }
   difference {
      torus { 164+14, 5 sturm translate <0, 427, 0> }
      plane {-y, 0 translate <0, 427, 0> }
   }   
   difference {                            
      cylinder { <0, 427, 0>, <0, 419, 0>, 164+15 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 164 }
   }
   difference {                            
      cylinder { <0, 419, 0>, <0, 412, 0>, 164+13 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 164 }
   }
   torus { 164, 3 sturm translate <0, 412, 0> }
   difference {                            
      cylinder { <0, 395, 0>, <0, 394, 0>, 164+6 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 164 }
   }
   difference {
      torus { 164+2, 3 sturm translate <0, 394, 0> }
      plane {-y, 0 translate <0, 394, 0> }
   }   
   difference {                            
      cylinder { <0, 391, 0>, <0, 387, 0>, 164+2 }
      cylinder { <0, 379, 0>, <0, 431, 0>, 164 }
   }
}

#declare FcdTowerF4=union{
   object { FcdTowerF4Rotunda }
   #declare ang = 45;
   #while(ang < 360)
      object { FcdTowerF4Corner rotate <0, ang, 0> }
      #declare ang = ang + 90;
   #end
}
                      
/*--- Floor 5 ---*/

#declare FcdTowerF5ArcGesimsProfile=union{
   box { <0, 0, 0>, <1, -2, -3> }
   cylinder { <0, 0, 0>, <1, 0, 0>, 1 scale <1, 2, 1> translate <0, -2, -1> }
   box { <0, 0, 0>, <1, -8, -1> }
}

#declare FcdTowerF5ArcGesims=union{
   difference {
      cylinder { <0, 0, -85>, <0, 0, -94>, 24 }
      cylinder { <0, 0, -84>, <0, 0, -95>, 20 }
      plane { y, 0 }                    
      cylinder { <0, 0, 0>, <0, 25, 0>, 85 }
      cylinder { <0, 0, 0>, <0, 25, 0>, 93 inverse }
   }   
   difference {
      cylinder { <0, 0, -85>, <0, 0, -96>, 24 }
      cylinder { <0, 0, -84>, <0, 0, -97>, 22 }
      plane { y, 0 }                    
      cylinder { <0, 0, 0>, <0, 25, 0>, 85 }
      cylinder { <0, 0, 0>, <0, 25, 0>, 95 inverse }
   }   
   difference { // Keystone
      box { <-10, 15.5, -96>, <10, 32, -90> }
      plane { x, 0 rotate <0, 0,  10> translate <-5, 15.5, 0> }
      plane {-x, 0 rotate <0, 0, -10> translate < 5, 15.5, 0> }
      cylinder { <0, 0, 0>, <0, 35, 0>, 95.5 inverse }
   }
}

#declare FcdTowerF5GesimsProfile=union{
   box { <0, 0, 0>, <1, -2, -10> }                   
   difference {
      cylinder { <0, 0, 0>, <1, 0, 0>, 1.5 scale <1, 2, 1> }
      plane {-y, 0 }
      translate <0, -2, -7> 
   }
   box { <0, 0, 0>, <1, -10, -7> }
   cylinder { <0, -10, 0>, <1, -10, 0>, 2 }
}

#declare FcdTowerF5GesimsR92=union{
   difference {
      cylinder { <0, 0, 0>, <0, -2, 0>, 102 }
      cylinder { <0, 1, 0>, <0, -11, 0>, 92 }
   }
   difference {
      torus { 99, 1.5 scale <1, 2, 1> }
      plane {-y, 0 }
      translate <0, -2, 0>
   }      
   difference {
      cylinder { <0, 0, 0>, <0, -10, 0>, 99 }
      cylinder { <0, 1, 0>, <0, -11, 0>, 92 }
   }
   torus { 92, 2 translate <0, -10, 0> }
}

#declare FcdTowerF5GesimsR103=union{
   difference {
      cylinder { <0, 0, 0>, <0, -2, 0>, 113 }
      cylinder { <0, 1, 0>, <0, -11, 0>, 103 }
   }
   difference {
      torus { 110, 1.5 scale <1, 2, 1> }
      plane {-y, 0 }
      translate <0, -2, 0>
   }      
   difference {
      cylinder { <0, 0, 0>, <0, -10, 0>, 110 }
      cylinder { <0, 1, 0>, <0, -11, 0>, 103 }
   }
   torus { 103, 2 translate <0, -10, 0> }
}

#declare FcdTowerF5Arc1=union{
   difference {
      box { <-29, 0, 0>, <29, 90, 14> }
      box { <-17, -1, -1>, <17, 50, 15> }
      cylinder { <0, 50, -1>, <0, 50, 15>, 17 }
   }           
   difference {
      union {
         difference {
            cylinder { <0, 0, 0>, <0, 0, -1>, 24 }
            cylinder { <0, 0, 1>, <0, 0, -2>, 20 }
         }   
         difference {
            cylinder { <0, 0, 0>, <0, 0, -3>, 24 }
            cylinder { <0, 0, 1>, <0, 0, -4>, 22 }
         }   
      }                                         
      plane { y, 0 }
      translate <0, 50, 0>
   }
   difference { // Keystone
      box { <-10, 65.5, -3>, <10, 80, 0> }
      plane { x, 0 rotate <0, 0,  10> translate <-5, 65.5, 0> }
      plane {-x, 0 rotate <0, 0, -10> translate < 5, 65.5, 0> }
   }
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <15, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 50, 0>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <17, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 50, 0>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <15, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 50, 0>
      scale <-1, 1, 1>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <17, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 50, 0>
      scale <-1, 1, 1>
   }   
   object { FcdTowerF5GesimsProfile scale <60, 1, 1> translate <-30, 90, 0> }
}
   
#declare FcdTowerF5Level1Coloumn=union{
   box { <-11, 0, -11>, <11, 90, 11> }
   #declare ang = 0;
   #while(ang < 360)         
      difference {
         object { FcdTowerF5GesimsProfile scale <42, 1, 1> translate <-21, 0, 0> }
         plane { x, 0 rotate <0,  45, 0> translate <-11, 0, 0> }
         plane {-x, 0 rotate <0, -45, 0> translate < 11, 0, 0> }
         translate <0, 90, -11> rotate <0, ang, 0>
      }   
      #declare ang = ang + 90;
   #end
}
   
#declare FcdTowerF5Level1Rotunda=union{
   difference {
      cylinder { <0,  0, 0>, <0, 90, 0>, 92 }
      cylinder { <0, -1, 0>, <0, 91, 0>, 85 }
      plane { x, 0 rotate <0,  22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-17, -1, -100>, <17, 50, -75> }
      cylinder { <0, 50, -100>, <0, 50, -75>, 17 }                           
      bounded_by { box { <-37, 0, -97>, <37, 91, -75> } }
   }   
   difference {
      cylinder { <0,  0, 0>, <0, 90, 0>, 96 }
      cylinder { <0, -1, 0>, <0, 91, 0>, 92 }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      rotate <0, 22.5, 0>
   }                         
   difference {
      cylinder { <0,  0, 0>, <0, 90, 0>, 96 }
      cylinder { <0, -1, 0>, <0, 91, 0>, 92 }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      rotate <0, -22.5, 0>
   }                         
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <9, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 50, -90>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <10, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 50, -90>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <9, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 50, -90>
      scale <-1, 1, 1>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <10, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 50, -90>
      scale <-1, 1, 1>
   }                                       
   object { FcdTowerF5ArcGesims translate <0, 50, 0> }
   difference {
      object { FcdTowerF5GesimsR92 translate <0, 90, 0> }
      plane { x, 0 rotate <0,  20, 0> }
      plane {-x, 0 rotate <0, -20, 0> }
   }   
}
   
#declare FcdTowerF5Level1Segment=union{
   object { FcdTowerUrn1Plain translate <-40, 0, -185> }
   object { FcdTowerF5Level1Coloumn translate <-40, 0, -155> }
   object { FcdTowerF5Arc1 translate <0, 0, -162> } 
   object { FcdTowerF5Level1Coloumn translate < 40, 0, -155> }
   object { FcdTowerUrn1Plain translate < 40, 0, -185> }
   object { FcdTowerF5Arc1 rotate <0,  90, 0> translate <-40, 0, -115> } 
   object { FcdTowerF5Arc1 rotate <0, -90, 0> translate < 40, 0, -115> } 
   object { FcdTowerF5Level1Rotunda rotate <0, 45, 0> }
}                                                  

#declare FcdTowerF5Level2Segment=union{
   difference {
      cylinder { <0,  0, 0>, <0, 145, 0>, 92 }
      cylinder { <0, -1, 0>, <0, 146, 0>, 85 }
      plane { x, 0 rotate <0,  22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
      box { <-17, 18, -100>, <17, 85, -75> }
      cylinder { <0, 85, -100>, <0, 85, -75>, 17 }                           
      bounded_by { box { <-37, 0, -97>, <37, 146, -75> } }
   }   
   difference {
      torus { 92, 2 translate <0, 119, 0> }
      plane { x, 0 rotate <0,  22.5, 0> }
      plane {-x, 0 rotate <0, -22.5, 0> }
   }   
   difference {
      cylinder { <0,  0, 0>, <0, 145, 0>, 96 }
      cylinder { <0, -1, 0>, <0, 146, 0>, 92 }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      rotate <0, 22.5, 0>
   }   
   difference {
      torus { 96, 2 translate <0, 119, 0> }
      plane { x, 0 rotate <0,  7.5, 0> }
      plane {-x, 0 rotate <0, -7.5, 0> }
      rotate <0, 22.5, 0>
   }   
   sphere { <0, 119, -96>, 2 rotate <0, 22.5+7.5, 0> }
   sphere { <0, 119, -96>, 2 rotate <0, 22.5-7.5, 0> }
   difference {
      cylinder { <0,  0, 0>, <0, 145, 0>, 103 }
      cylinder { <0, -1, 0>, <0, 146, 0>,  96 }
      plane { x, 0 rotate <0,  5, 0> }
      plane {-x, 0 rotate <0, -5, 0> }
      rotate <0, 22.5, 0>
   }   
   difference {
      torus { 103, 2 translate <0, 119, 0> }
      plane { x, 0 rotate <0,  5, 0> }
      plane {-x, 0 rotate <0, -5, 0> }
      rotate <0, 22.5, 0>
   }                                              
   union{
      sphere { <0, 119, -103>, 2 }
      cylinder { <0, 119, -103>, <0, 119, -90>, 2}
      rotate <0, 22.5+5, 0> 
   }
   union{
      sphere { <0, 119, -103>, 2 }
      cylinder { <0, 119, -103>, <0, 119, -90>, 2}
      rotate <0, 22.5-5, 0> 
   }
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <9, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 85, -90>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <10, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 85, -90>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <9, 1, 1> translate <-6, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-17, 85, -90>
      scale <-1, 1, 1>
   }   
   difference {   
      object { FcdTowerF5ArcGesimsProfile scale <10, 1, 1> translate <-3, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-17, 85, -90>
      scale <-1, 1, 1>
   }                                       
   object { FcdTowerF5ArcGesims translate <0, 85, 0> }
   difference {
      object { FcdTowerF5GesimsR92 translate <0, 145, 0> }
      plane { x, 0 rotate <0,  20, 0> }
      plane {-x, 0 rotate <0, -20, 0> }
   }   
   union {
      difference {
         object { FcdTowerF5GesimsR103 translate <0, 145, 0> }
         plane { x, 0 rotate <0,  45, 0> translate <0, 0, -103> rotate <0,  5, 0> }
         plane {-x, 0 rotate <0, -45, 0> translate <0, 0, -103> rotate <0, -5, 0> }
      }      
      difference {
         object { FcdTowerF5GesimsProfile scale <30, 1, 1> translate <-10, 0, 0> }
         plane { x, 0 rotate <0, 45, 0> }
         rotate <0, -90, 0> translate <0, 145, -103> rotate <0, -5, 0>
      }   
      difference {
         object { FcdTowerF5GesimsProfile scale <30, 1, 1> translate <-10, 0, 0> }
         plane { x, 0 rotate <0, 45, 0> }
         rotate <0, -90, 0> translate <0, 145, -103> rotate <0, -5, 0>
         scale <-1, 1, 1>
      }   
      rotate <0, 22.5, 0>
   }   
}

#declare FcdTowerF5Level2Side=union{
   difference {
      cylinder { < 0, 0, 0>, <16.5874, 0, 0>, 70 scale <1, 85/70, 1> }
      cylinder { <-1, 0, 0>, <17, 0, 0>, 65 scale <1, 80/65, 1> }
      plane {-y, 0 }
      plane { z, 0 }
      plane {-z, 0 translate <0, 0, 65> }
      translate <0, 85, -65> 
   }
   difference {
      box { <3, 0, 0>, <13.5874, 80, -65> }
      cylinder { <-1, 0, 0>, <17, 0, 0>, 70 scale <1, 85/70, 1> translate <0, 85, -65> }
   }
   box { <0, 0, 0>, <16.5874, 5, -65> }
}     

#declare FcdTowerF5Level2Torch=union{
   box { <-10, 0, -10>, <10, 5, 10> }
   difference {
      cylinder { <0, 5, 0>, <0, 18.5, 0>, 8.25 }
      torus { 11, 6 scale <1, 9/6, 1> translate <0, 18.5, 0> }
   }
   torus { 5, 1 translate <0, 18.5, 0> }      
   #declare ang = 0;
   #while(ang < 360)
      cylinder { <0, 18.5, 0>, <0, 34, 0>, 1.5 translate <0, 0, -3> rotate <0, ang, 0> }
      #declare ang = ang + 360/6;
   #end   
   cylinder { <0, 34, 0>, <0, 36, 0>, 8 }      
   torus { 8, 1 translate <0, 35, 0> }      
   #declare ang = 0;
   #while(ang < 360)
      torus { 2.5, 2 rotate <0, 0, 90> translate <0, 40, -7> rotate <0, ang, 0> }
      #declare ang = ang + 360/16;
   #end                                                    
   torus { 7, 3.5 translate <0, 40, 0> }      
   difference {
      cylinder { <0, 40, 0>, <0, 54, 0>, 6.5 }
      torus { 10, 7.5 scale <1, 6/7.5, 1> translate <0, 51, 0> }
   }
   torus { 3.5, 0.5 translate <0, 54, 0> }                                               
   union{
      #declare cnt = 0;
      #while(cnt < 100)
         sphere { <0, 0, 0>, 1.5 translate <rand(F3)*6-3, rand(F3)*12-6, rand(F3)*6-3> }
         #declare cnt = cnt + 1;
      #end
      translate <-2, 6, 0> rotate <0, 0, -60>
      translate <0, 55, 0>
   }   
}


#declare FcdTowerF5Level2SegmentSided=union{
   object { FcdTowerF5Level2Segment }
   object { FcdTowerF5Level2Side translate <-47.5601, 0, -91.3621> }
   object { FcdTowerF5Level2Side translate <-47.5601, 0, -91.3621> scale <-1, 1, 1> }
   box { <-40, 0, 0>, <40, 5, -155> }
   object { FcdTowerF5Level2Torch translate <-40, 0, -155> }
   object { FcdTowerF5Level2Torch translate < 40, 0, -155> }
}

#declare FcdTowerF5Level3CutOut=intersection{
   box { <-11, 0, -100>, <11, 25, 100> }
   cylinder { <0, -7, -100>, <0, -7, 100>, 31 }
}

#declare FcdTowerF5Level3Snirkel=union{
   torus { 6, 2.5 rotate <0, 0, 90> translate <0, 20, -96>}
   torus { 2, 2.5 rotate <0, 0, 90> translate <0, 20, -96>}
   difference {
      torus { 17.5, 2.5 rotate <0, 0, 90> scale <1, 25/17.5, 1> translate <0, 45, -110> }
      plane {-y, 0 translate <0, 45, 0> }
      plane { z, 0 rotate <-45, 0, 0> translate <0, 20, -96> }
   }                                                         
   difference {
     box { <-2, 20, 0>, <2, 50, -100> }
     cylinder { <-3, 0, 0>, <3, 0, 0>, 17.5 scale <1, 25/17.5, 1> translate <0, 45, -110> }
   }   
   torus { 2.5, 2.5 rotate <0, 0, 90> translate <0, 45, -95>}
}
   
#declare FcdTowerF5Level3Deco=union{
   difference {
      cylinder { <0,  0, 0>, <0, 12, 0>, 103 }
      plane { x, 0 rotate <0,  5, 0> }
      plane {-x, 0 rotate <0, -5, 0> }
   }                         
   difference {
      torus { 103, 1.5 translate <0, 10.5, 0> }
      plane { x, 0 rotate <0,  5, 0> }
      plane {-x, 0 rotate <0, -5, 0> }
   }                                           
   union{
      sphere { <0, 10.5, -103>, 1.5 }
      cylinder { <0, 10.5, -103>, <0, 10.5, 90>, 1.5 }
      rotate <0, 5, 0>
   }   
   union{
      sphere { <0, 10.5, -103>, 1.5 }
      cylinder { <0, 10.5, -103>, <0, 10.5, 90>, 1.5 }
      rotate <0, -5, 0>
   }              
   object { FcdTowerF5Level3Snirkel rotate <0, -3.6, 0> }
   object { FcdTowerF5Level3Snirkel rotate <0, -1.3, 0> }
   object { FcdTowerF5Level3Snirkel rotate <0,  1.3, 0> }
   object { FcdTowerF5Level3Snirkel rotate <0,  3.6, 0> }
   difference {
      union {
         cylinder { <0,  50, 0>, <0, 60, 0>, 101 }
         difference {
            torus { 101, 2 scale <1, 2, 1> }
            plane {-y, 0 }
            translate <0, 59, 0> 
         }   
         cylinder { <0, 59, 0>, <0, 60, 0>, 104 }
      }   
      plane { x, 0 rotate <0,  5, 0> }
      plane {-x, 0 rotate <0, -5, 0> }
   }                         
          
}

#declare FcdTowerF5Level3=union{
   cylinder { <0, 0, 0>, <0, 12, 0>, 96 }
   torus { 96, 1.5 translate <0, 10.5, 0> }
   difference {
      cylinder { <0, 12, 0>, <0, 65, 0>, 90 }
      object { FcdTowerF5Level3CutOut translate <0, 20, 0> }
      object { FcdTowerF5Level3CutOut rotate <0,  45, 0> translate <0, 20, 0> }
      object { FcdTowerF5Level3CutOut rotate <0,  90, 0> translate <0, 20, 0> }
      object { FcdTowerF5Level3CutOut rotate <0, 135, 0> translate <0, 20, 0> }
   }   
   cylinder { <0, 12, 0>, <0, 50, 0>, 88 texture { T_Stp_Windowpane } }      
   cylinder { <0, 50, 0>, <0, 60, 0>, 98 }
   difference {
      torus { 98, 2 scale <1, 2, 1> }
      plane {-y, 0 }
      translate <0, 59, 0> 
   }   
   cylinder { <0, 59, 0>, <0, 60, 0>, 101 }
   #declare ang = 22.5;
   #while(ang < 360)
      object { FcdTowerF5Level3Deco rotate <0, ang, 0> }
      #declare ang = ang + 45;
   #end                          
}

#declare FcdTowerF5=union {                               
   #declare ang = 45;
   #while(ang < 360)
      object { FcdTowerF5Level1Segment rotate <0, ang, 0> }
      object { FcdTowerF5Level2SegmentSided translate <0, 90, 0> rotate <0, ang, 0> }
      object { FcdTowerF5Level2Segment translate <0, 90, 0> rotate <0, ang+45, 0> }
      #declare ang = ang + 90;
   #end                          
   object { FcdTowerF5Level3 translate <0, 235, 0> }
}
   
/*--- Floor 6 ---*/

#declare FcdTowerF6Lead=union {
  difference { 
     cylinder { <0, 0, 0>, <0, 100, 0>, 92 }
     torus { 200, 145 translate <0, 100, 0> }                      
     cylinder { <0, 54, -90>, <0, 54, 90>, 12 }
     cylinder { <-90, 54, 0>, <90, 54, 0>, 12 }
  }
  torus { 12, 2 rotate <-71.5, 0, 0> translate <0, 54, -64> }
  torus { 12, 2 rotate <-71.5, 0, 0> translate <0, 54, -64> rotate <0, 90, 0> }
  torus { 12, 2 rotate <-71.5, 0, 0> translate <0, 54, -64> rotate <0, 180, 0> }
  torus { 12, 2 rotate <-71.5, 0, 0> translate <0, 54, -64> rotate <0, 270, 0> }
  torus { 55, 4 translate <0, 100, 0> }
  #declare ang = 22.5;
  #while(ang < 360)
     difference {
        torus { 145, 1.5 rotate <90, 0, 0> translate <200, 100, 0> }
        plane { y, 0 }
        plane {-y, 0 translate <0, 100, 0> }
        plane {-x, 0 translate <92, 0, 0> }
        rotate <0, ang, 0> 
     }   
     #declare ang = ang + 45;
  #end   
  sphere { <0, 0, 0>, 55 scale <1, 60/55, 1> translate <0, 100, 0> }    
  #declare ang = 22.5;
  #while(ang < 180)  
     difference {
        torus { 55, 1.5 rotate <90, ang, 0> scale <1, 60/55, 1> }
        plane { y, 0 }
        translate <0, 100, 0> 
     }   
     #declare ang = ang + 45;
  #end   
  torus { 26, 4 translate <0, 158, 0> }
  texture { T_Stp_Lead3 }
}  
     
#declare FcdTowerF6Snirkel=union {
   object { S_Snirkel translate <-4, 0, 0> }
   object { S_Snirkel translate < 4, 0, 0> }
   scale <0.6, 40/55, 1>                  
   translate <0, 0, -10>
}
   
#declare FcdTowerF6Gold=union {
   cylinder { <0, 158, 0>, <0, 172, 0>, 25 }
   cylinder { <0, 172, 0>, <0, 212, 0>, 10 }
   object { FcdTowerF6Snirkel translate <0, 172, 0> }
   object { FcdTowerF6Snirkel rotate <0, 90, 0> translate <0, 172, 0> }
   object { FcdTowerF6Snirkel rotate <0, 180, 0> translate <0, 172, 0> }
   object { FcdTowerF6Snirkel rotate <0, 270, 0> translate <0, 172, 0> }
   cylinder { <0, 212, 0>, <0, 232, 0>, 15 }
   torus { 15, 2 translate <0, 220, 0> }  
   cone { <0, 232, 0>, 11, <0, 247, 0>, 8 }
   torus { 9, 1.5 translate <0, 246, 0> }  
   sphere { <0, 0, 0>, 19 scale <1, 27/19, 1> translate <0, 273, 0> }
   difference {
      torus { 26, 8.5 }
      torus { 26, 8.3 }
      cylinder { <0, 2, 0>, <0, 9, 0>, 27 inverse }
      translate <0, 273-11, 0> 
   }   
   texture { T_Stp_Gold }
}

#declare FcdTowerF6=union {
   object { FcdTowerF6Lead }
   object { FcdTowerF6Gold }
}

/*---- Assembled Tower (without clock) ----*/

#declare FcdTower=union{
   object { FcdTowerBase }
   object { FcdTowerF1 translate <0,  105+39, 0> }
   object { FcdTowerF2 translate <0,  670+39, 0> }
   object { FcdTowerF3 translate <0, 1170+39, 0> }
   object { FcdTowerF4 translate <0, 1470+39, 0> }
   object { FcdTowerF5 translate <0, 1900+39, 0> }
   object { FcdTowerF6 translate <0, 2200+39, 0> }
}
   
/*------------- Clock ----------------*/ 
                     
#declare FcdTowerClockI=difference {
   cylinder { <0, 0, 0>, <0, 0, -1>, 83 }
   cylinder { <0, 0, 1>, <0, 0, -2>, 55 }
   plane { x, 0 rotate <0, 0,  1.5> }
   plane {-x, 0 rotate <0, 0, -1.5> }
   texture { T_Stp_Gold }                                   
}

#declare FcdTowerClockV=union{
   difference {
      cylinder { <0, 0, 0>, <0, 0, -1>, 83 }
      cylinder { <0, 0, 1>, <0, 0, -2>, 55 }
      plane { x, 0 rotate <0, 0, -11.77> translate <-1, 55, 0> }
      plane {-x, 0 rotate <0, 0, -11.77> translate < 1, 55, 0> }
      plane { y, 0 }
   }
   difference {
      cylinder { <0, 0, 0>, <0, 0, -1>, 83 }
      cylinder { <0, 0, 1>, <0, 0, -2>, 55 }
      plane { x, 0 rotate <0, 0,  11.24> translate <-1, 55, 0> }
      plane {-x, 0 rotate <0, 0,  11.24> translate < -2.1727, 82.9716, 0> }
      plane {-x, 0 rotate <0, 0, -11.77> translate <-1, 55, 0> }
   }
   texture { T_Stp_Gold }
}

#declare FcdTowerClockX=union{
   difference {
      cylinder { <0, 0, 0>, <0, 0, -1>, 83 }
      cylinder { <0, 0, 1>, <0, 0, -2>, 55 }
      plane { x, 0 rotate <0, 0, -22.3> translate <4.478, 82.86, 0> }
      plane {-x, 0 rotate <0, 0, -22.3> translate <6.907, 82.63, 0> }
      plane { y, 0 }
   }
   difference {
      cylinder { <0, 0, 0>, <0, 0, -1>, 83 }
      cylinder { <0, 0, 1>, <0, 0, -2>, 55 }
      plane { x, 0 rotate <0, 0,  18.25> translate < -6.5121, 82.7441, 0> }
      plane {-x, 0 rotate <0, 0,  18.25> translate < -2.1727, 82.9716, 0> }
      plane { y, 0 }
   }
   texture { T_Stp_Gold }
}

#declare FcdTowerClockBigHand=union {
   box { <-2, -20, 0>, <2, 92, -1> }
   cylinder { <0,  70, 0>, <0,  70, -1>, 6 }
   cylinder { <0,   0, 0>, <0,   0, -1>, 8 }
   cylinder { <0, -20, 0>, <0, -20, -1>, 5 }
   difference {
      cylinder { <0, 0, 0>, <0, 0, -1>, 13 }
      cylinder { <0, 0, 1>, <0, 0, -2>, 10 }
      plane { x, 0 rotate <0, 0, -30> translate <-8, -5, 0> }
      plane {-x, 0 rotate <0, 0,  30> translate < 8, -5, 0> }
      translate <0, 25, 0>
   }   
   texture { T_Stp_Gold }
}

#declare FcdTowerClockLittleHand=union {
   box { <-2, 0, 0>, <2, 35, -1> }
   box { <-5, 35, 0>, <5, 45, -1> }
   cylinder { <-5, 40, 0>, <-5, 40, -1>, 5 }
   cylinder { < 5, 40, 0>, < 5, 40, -1>, 5 }
   difference {
      box { <-9, 43.16, 0>, <9, 54, -1> }
      plane { x, 0 rotate <0, 0, -39.3> translate <0, 54, 0> }
      plane {-x, 0 rotate <0, 0,  39.3> translate <0, 54, 0> }
   }   
   texture { T_Stp_Gold }
}

#declare FcdTowerClockHours   =  12;
#declare FcdTowerClockMinutes =  50;

#declare FcdTowerClock=union {
   difference {
      cylinder { <0, 0, 10>, <0, 0, -1>, 93 }
      cylinder { <0, 0, 11>, <0, 0, -2>, 55 }
      texture { T_Stp_Black }
   }
   #declare ang = 0;
   #while(ang < 180)
      difference {
         cylinder { <0, 0, -1>, <0, 0, -2>, 93 }
         cylinder { <0, 0, 0>, <0, 0, -3>, 86 }
         plane { x, 0 translate <-1.5, 0, 0> }
         plane {-x, 0 translate < 1.5, 0, 0> }
         texture { T_Stp_Gold }
         bounded_by { box { <-1.6, -94, 0>, <1.6, 94, -3> } }
         rotate <0, 0, ang>
      }
      #declare ang = ang + 6;
   #end                   
   torus { 85, 1 rotate <90, 0, 0> translate <0, 0, -2> texture { T_Stp_Gold } }
   
   object { FcdTowerClockI rotate <0, 0, -30> translate <0, 0, -1> }

   object { FcdTowerClockI rotate <0, 0, -57> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -63> translate <0, 0, -1> }

   object { FcdTowerClockI rotate <0, 0, -84.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -90> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -95.5> translate <0, 0, -1> }
                          
   object { FcdTowerClockI rotate <0, 0, -112.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -117.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -122.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -127.5> translate <0, 0, -1> }

   object { FcdTowerClockV rotate <0, 0, -150> translate <0, 0, -1> }

   object { FcdTowerClockV rotate <0, 0, -176.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -183> translate <0, 0, -1> }

   object { FcdTowerClockV rotate <0, 0, -203.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -211> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -216> translate <0, 0, -1> }

   object { FcdTowerClockV rotate <0, 0, -231> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -238.5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -243> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -247.5> translate <0, 0, -1> }

   object { FcdTowerClockI rotate <0, 0, -266.5> translate <0, 0, -1> }
   object { FcdTowerClockX rotate <0, 0, -275> translate <0, 0, -1> }

   object { FcdTowerClockX rotate <0, 0, -300> translate <0, 0, -1> }

   object { FcdTowerClockX rotate <0, 0, -325> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -333.5> translate <0, 0, -1> }

   object { FcdTowerClockX rotate <0, 0,  5> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -3> translate <0, 0, -1> }
   object { FcdTowerClockI rotate <0, 0, -8> translate <0, 0, -1> }
   
   object { FcdTowerClockBigHand rotate <0, 0, -6*(FcdTowerClockMinutes)> translate <0, 0, -3> }
   object { FcdTowerClockLittleHand rotate <0, 0, -30*(FcdTowerClockHours+(FcdTowerClockMinutes/60))> translate <0, 0, -2> }
   // Minute numbers 15, 30, 45, 60 faked
   #declare ang = 0;
   #while (ang < 360)
      union { 
         cylinder { <0, 0, 10>, <0, 0, -1>, 7 scale <5/7, 1, 1> translate <-4, 101, 0> }
         cylinder { <0, 0, 10>, <0, 0, -1>, 7 scale <5/7, 1, 1> translate < 4, 101, 0> }
         texture { T_Stp_Black }
         rotate <0, 0, ang>
      }   
      union { 
         cylinder { <0, 0, 0>, <0, 0, -1>, 6 scale <5/7, 1, 1> translate <-4, 101, -1> }
         cylinder { <0, 0, 0>, <0, 0, -1>, 6 scale <5/7, 1, 1> translate < 4, 101, -1> }
         texture { T_Stp_Gold }
         rotate <0, 0, ang>
      }   
      #declare ang = ang + 90;
   #end   
}      
   
/*-------------- Facade midsection ---------------------*/

#declare FcdStairsSide=union {
   box { <-32, 0, -32>, <32, 144, 32> }
   box { <-42, 124, -42>, <42, 134, 42> }
   box { <-10, 144, -10>, <10, 154, 10> }
   box { <-21, 0, 32>, <21, 145, 225> }
}
   
#declare FcdStairs=union {
   #declare xlen = 744;
   #declare zlen = 194;
   #declare cnt = 0;
   #while(cnt < 10)          
      box { <-xlen, cnt*6, -zlen>, <xlen, (cnt+1)*6, zlen> texture { T_Stp_Stairs } }
      #declare xlen = xlen - 14;
      #declare zlen = zlen - 14;
      #declare cnt = cnt + 1;
   #end
   #declare zlen = 68;
   #declare cnt = 0;
   #while(cnt < 13)          
      box { <-580, cnt*6+60, zlen>, <580, (cnt+11)*6, 300> texture { T_Stp_Stairs } }
      #declare zlen = zlen + 14;
      #declare cnt = cnt + 1;
   #end
   box { <-625, 0, zlen>, <-580, 144, 750> }
   box { <-580, 0, zlen>, < 580, 144, 750> texture { T_Stp_Stairs }  }
   box { < 625, 0, zlen>, < 580, 144, 750> }
   object { FcdStairsSide translate <-580, 0, 99> } 
   object { FcdStairsSide translate < 580, 0, 99> } 
}

#declare FcdFloor1SidedoorWindowGesimsProfile=union {
  box { <0, 0, 0>, <1, -10, -1> }
  box { <0, 0, 0>, <1,  -4, -3> }
  box { <0, 0, 0>, <1,  -2, -4> }
}
  
#declare FcdFloor1SidedoorPane=difference {
   box { <-31,   0,  0>, < 0, 155, 10> }
   box { <-25,  10, -1>, <-5,  40,  2> }
   box { <-25,  45, -1>, <-5,  75,  2> }
   box { <-25,  80, -1>, <-5, 110,  2> }
   box { <-25, 115, -1>, <-5, 145,  2> }
   texture { T_Stp_Door }
}

#declare FcdFloor1SidedoorGesimsProfile=union {
   box { <0, 0, 0>, <1,  -2, -17> }
   difference {
      cylinder{ <0, 0, 0>, <1, 0, 0>, 3 scale <1, 1, 2/3> }
      plane {-y, 0 }
      translate <0, -2, -14>
   }   
   box { <0, 0, 0>, <1, -10, -14> }
}

#declare FcdFloor1Sidesection=union {      
   difference {
      box { <-165, 0, 0>, <165, 465, 300> }
      box { <-45, -1, -1>, <45, 466,  20> }
      box { <-36, -1, -1>, <36, 155,  30> }
      box { <-31, -1, -1>, <31, 155, 200> }
      box { <-37, 195, -1>, <37, 327, 30> }
      box { <-25, 195, -1>, <25, 290, 200> }
      cylinder { <0, 290, -1>, <0, 290, 200>, 25 }
      box { <-37, 340, -1>, <37, 440, 30> }
   }   
   object { FcdFloor1SidedoorPane translate <0, 0, 30> }
   object { FcdFloor1SidedoorPane scale <-1, 1, 1> translate <0, 0, 30> }
   object { FcdMainGesims2Konsol scale <1, 3/4, 3/4> translate <-41, 155, 20> }
   object { FcdMainGesims2Konsol scale <1, 3/4, 3/4> translate < 41, 155, 20> }
   object { FcdFloor1SidedoorGesimsProfile scale <110, 1, 1> translate <-55, 195, 20> }
   difference {
      cylinder { <0, 290, 29>, <0, 290, 30>, 37 }
      cylinder { <0, 290, 20>, <0, 290, 40>, 30 }
      plane { y, 0 translate <0, 290, 0> }
   }   
   difference {
      cylinder { <0, 290, 26>, <0, 290, 30>, 37 }
      cylinder { <0, 290, 20>, <0, 290, 40>, 35 }
      plane { y, 0 translate <0, 290, 0> }
   }                                 
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-25, 290, 30>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <10, 1, 1> translate <-5, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-25, 290, 30>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-25, 290, 30>
      scale <-1, 1, 1>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <10, 1, 1> translate <-5, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <-25, 290, 30>
      scale <-1, 1, 1>
   }   
   
   box { <-25, 195, 35>, <25, 315, 36> texture { T_Stp_Windowpane } }
}

#declare FcdFloor1MidsectionCutout=union {
   cylinder{ <0, 0, 0>, <0, 125, 0>, 23 }
   sphere { <0, 125, 0>, 23 }
}
   
#declare FcdFloor1MidsectionCutoutDeco=union {
   difference {
      cylinder { <0, 125, -1>, <0, 125, 0>, 35 }
      cylinder { <0, 125, -5>, <0, 125, 1>, 28 }
      plane { y, 0 translate <0, 125, 0> }
   }   
   difference {
      cylinder { <0, 125, -4>, <0, 125, 0>, 35 }
      cylinder { <0, 125, -5>, <0, 125, 1>, 33 }
      plane { y, 0 translate <0, 125, 0> }
   }                                  
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-23, 125, 0>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <-23, 125, 0>
      scale <-1, 1, 1>
   }   
   // Indvendig gesims
   difference {
      cylinder { <0, 125, 0>, <0, 115, 0>, 23 }
      cylinder { <0, 126, 0>, <0, 114, 0>, 22 }
      plane { z, 0 }
   }   
   difference {
      cylinder { <0, 125, 0>, <0, 121, 0>, 23 }
      cylinder { <0, 126, 0>, <0, 114, 0>, 20 }
      plane { z, 0 }
   }   
   difference {
      cylinder { <0, 125, 0>, <0, 123, 0>, 23 }
      cylinder { <0, 126, 0>, <0, 114, 0>, 19 }
      plane { z, 0 }
   }   
}
   
#declare FcdFloor1MidsectionPilaster=difference {
   box { <0, 0, -10>, <46, 465, 0> }
   #declare pos = 5;
   #while(pos < 42)
      cylinder { <pos, 0, -10>, <pos, 465, -10>, 1.5 }
      #declare pos = pos + 6;
   #end   
}

#declare FcdFloor1MaindoorKarmProfile=union {
   box { <0,  5, 0>, <1, 23, -2> }
   box { <0, 15, 0>, <1, 23, -3> }
   box { <0, 20, 0>, <1, 23, -6> }
}
   
#declare FcdFloor1MaindoorTopProfile=union {
   box { <0,  0, 20>, <1, 11, -8> }
   box { <0, 11, 20>, <1, 22, -12> }
   box { <0, 22, 20>, <1, 25, -14> }
}
   
#declare FcdFloor1Midsection=union {
   difference {
      box { <-300,   0, 0>, <300, 465, 200> }
      box { < -86,  -1, -1>, <  86, 335, 201> }
      box { <-259,   0, -1>, <-189, 335,  10> }
      box { <-259, 350, -1>, <-189, 450,  10> }
      box { <-247,  15, -1>, <-201, 153,  15> }
      box { < 259,   0, -1>, < 189, 335,  10> }
      box { < 259, 350, -1>, < 189, 450,  10> }
      box { < 247,  15, -1>, < 201, 153,  15> }
      object { FcdFloor1MidsectionCutout translate <-224, 175, 10> }
      object { FcdFloor1MidsectionCutout translate < 224, 175, 10> }
   }   
   box { <-272, 165, -5>, <-178, 175, 0> }
   box { < 272, 165, -5>, < 178, 175, 0> }
   object { FcdFloor1MidsectionCutoutDeco translate <-224, 175, 10> }
   object { FcdFloor1MidsectionCutoutDeco translate < 224, 175, 10> }

   object { FcdFloor1MidsectionPilaster translate <-178, 0, 0> }
   object { FcdFloor1MidsectionPilaster translate < 132, 0, 0> }

   object { FcdFloor1SidedoorPane scale <86/31, 335/155, 2> translate <0, 0, 15> }
   object { FcdFloor1SidedoorPane scale <-86/31, 335/155, 2> translate <0, 0, 15> }
   difference {
      object { FcdFloor1MaindoorKarmProfile scale <220, 1, 1> translate <-110, 0, 0> }
      plane { x, 0 rotate <0, 0,  45> translate <-86, 0, 0> } 
      plane {-x, 0 rotate <0, 0, -45> translate < 86, 0, 0> } 
      translate <0, 335, 0>
   }   
   difference {
      object { FcdFloor1MaindoorKarmProfile scale <360, 1, 1> translate <-335, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45>} 
      rotate <0, 0, 90> translate <-86, 335, 0>
   }   
   difference {
      object { FcdFloor1MaindoorKarmProfile scale <360, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0, 0, 45>} 
      rotate <0, 0, -90> translate < 86, 335, 0>
   }   
   difference {
      object { FcdFloor1MaindoorTopProfile scale <260, 1, 1> translate <-130, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-105, 0, 0> } 
      plane {-x, 0 rotate <0, -45, 0> translate < 105, 0, 0> } 
      translate <0, 410, -20>
   }   
   difference {
      object { FcdFloor1MaindoorTopProfile scale <50, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <105, 410, -20>
   }   
   difference {
      object { FcdFloor1MaindoorTopProfile scale <50, 1, 1> translate <-25, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> } 
      rotate <0,  90, 0> translate <-105, 410, -20>
   }   
}                                       

#declare FcdFloor1=union {

   object { FcdSoejleFluted scale 0.265 translate <-580, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate <-510, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate <-367, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate <-297, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate <-155, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < -85, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate <  85, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < 155, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < 297, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < 367, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < 510, 0, -296> }
   object { FcdSoejleFluted scale 0.265 translate < 580, 0, -296> }

   object { FcdFloor1Sidesection translate <-437, 0, -250> }
   object { FcdFloor1Midsection translate <   0, 0,   50> }
   object { FcdFloor1Sidesection translate < 437, 0, -250> }
   difference {
      object { FcdMainGesims1Profile scale <1300, 1, 1> translate <-650, 465, -320> }
      plane { x, 0 rotate <0,  45, 0> translate <-600, 0, -320> }
      plane {-x, 0 rotate <0, -45, 0> translate < 600, 0, -320> }
   }   
   difference {
      object { FcdMainGesims1Profile scale <150, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <600, 465, -320>
   }   
   difference {
      object { FcdMainGesims1Profile scale <150, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> }
      rotate <0, -90, 0> translate <600, 465, -320>
      scale <-1, 1, 1>                                                
   }
   box { <-590, 465, -310>, <590, 565, 600> }
}   

#declare FcdFloor2Sidesection1=union { // Outside   
   difference {
      box { <0, 0, 10>, <108, 500, 200> }
      box { <15, 123, 0>, <93, 295, 15> }
      box { <15, 310, 0>, <93, 395, 15> }
      intersection {
         box { <27, 50, 0>, <81, 105, 100> }
         cylinder { <54, 30, 0>, <54, 30, 100>, 75 }
      }   
      box { <27, 125, 0>, <81, 255, 100> }
      cylinder { <54, 255, 1>, <54, 255, 99>, 27 }
   }   

   box { <27, 50, 20>, <81, 105, 21> texture { T_Stp_Windowpane } }

   object { FcdCordon1Profile scale <108, 1, 1> translate <0, 116.5, 10> }

   difference {
      cylinder { <54 255, 14>, <54, 255, 15>, 39 }
      cylinder { <54, 255, 10>, <54, 255, 20>, 32 }
      plane { y, 0 translate <0, 255, 0> }
   }   
   difference {
      cylinder { <54, 255, 11>, <54, 255, 15>, 39 }
      cylinder { <54, 255, 10>, <54, 255, 20>, 37 }
      plane { y, 0 translate <0, 255, 0> }
   }                                 
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      translate <27, 255, 15>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <10, 1, 1> translate <-5, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> translate <27, 255, 15>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <16, 1, 1> translate <-12, 0, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      scale <-1, 1, 1>
      translate <81, 255, 15>
   }   
   difference {
      object { FcdFloor1SidedoorWindowGesimsProfile scale <10, 1, 1> translate <-5, 0, 0> }
      plane { x, 0 rotate <0, 45, 0> }
      rotate <0, -90, 0> scale <-1, 1, 1>
      translate <81, 255, 15>
   }   
   box { <27, 125, 20>, <81, 285, 21> texture { T_Stp_Windowpane } }

   box { <0, 405, 0>, <108, 500, 200> }
   object { FcdMainGesims2Profile scale <110, 1, 1> translate <0, 405, 0> }
   difference {
      object { FcdMainGesims2Profile scale <70, 1, 1> translate <-20, 405, 0> }
      plane {-x, 0 rotate <0, -45, 0> }
      rotate <0, 90, 0> translate <108, 0, -10>
   }   
   object { FcdMainGesims2Konsol translate <24, 431, 0> }
   object { FcdMainGesims2Konsol translate <54, 431, 0> }
   object { FcdMainGesims2Konsol translate <84, 431, 0> }
   object { FcdMainGesims2Konsol rotate <0, 90, 0> translate <108, 431, -5> }
}

#declare FcdFloor2Sidesection2=union {   // Inside
   box { <-117, 0, 0>, <0, 500, 500> }        
   object { FcdPilaster scale <0.85, 355/453, 0.85> translate <-23, 50, -10> }
   box { <-46, 44, 0>, <0, 50, -17> }        
   object { FcdPilaster scale <0.85, 355/453, 0.85> translate <-94, 50, -10> }   
   box { <-117, 44, 0>, <-71, 50, -17> }        
   object { FcdCordon1Profile scale <50, 1, 1> translate <-86, 116.5, 0> }
}
      
#declare FcdFloor2Midsection=union {
   difference {
      box { <-300,   0,  0>, < 300, 405, 200> }
      box { < -86,  68, -1>, <  86, 335, 201> }
      intersection {
         cylinder { <0, 77, -1>, <0, 77, 201>, 272 }
         box { < -86,  334.99, -1>, <  86, 350, 201> }
      }   
      box { <-259,  45, -1>, <-189, 335,  10> }
      box { <-247,  60, -1>, <-201, 153,  15> }
      box { < 259,  45, -1>, < 189, 335,  10> }
      box { < 247,  60, -1>, < 201, 153,  15> }
      object { FcdFloor1MidsectionCutout translate <-224, 175, 10> }
      object { FcdFloor1MidsectionCutout translate < 224, 175, 10> }
   }   
   box { <-272, 165, -5>, <-178, 175, 0> }
   box { < 272, 165, -5>, < 178, 175, 0> }
   object { FcdFloor1MidsectionCutoutDeco translate <-224, 175, 10> }
   object { FcdFloor1MidsectionCutoutDeco translate < 224, 175, 10> }

   box { <-178, 45, -10>, <-132, 405, 0> }
   box { < 178, 45, -10>, < 132, 405, 0> }

   box { <-86, 45, 10>, <86, 350, 11> texture { T_Stp_Windowpane } }

   difference {
      object { FcdFloor1MaindoorKarmProfile scale <220, 1, 1> translate <-110, 0, 0> }
      plane { x, 0 rotate <0, 0,  45> translate <-86, 0, 0> } 
      plane {-x, 0 rotate <0, 0, -45> translate < 86, 0, 0> } 
      rotate <0, 0, 180> translate <0, 68, 0>
   }   
   difference {
      object { FcdFloor1MaindoorKarmProfile scale <360, 1, 1> translate <-335, 0, 0> }
      plane {-x, 0 rotate <0, 0, -35>} 
      rotate <0, 0, 90> translate <-86, 335, 0>
   }   
   difference {
      object { FcdFloor1MaindoorKarmProfile scale <360, 1, 1> translate <-25, 0, 0> }
      plane { x, 0 rotate <0, 0, 35>} 
      rotate <0, 0, -90> translate < 86, 335, 0>
   }
   difference {
      union {
         difference {
            cylinder { <0, 0, 0>, <0, 0, -2>, 272+23 }
            cylinder { <0, 0, 1>, <0, 0, -8>, 272+5 }
         }   
         difference {
            cylinder { <0, 0, 0>, <0, 0, -3>, 272+23 }
            cylinder { <0, 0, 1>, <0, 0, -8>, 272+15 }
         }   
         difference {
            cylinder { <0, 0, 0>, <0, 0, -6>, 272+23 }
            cylinder { <0, 0, 1>, <0, 0, -8>, 272+20 }
         }                                      
         translate <0, 77, 0>
      }
      plane { x, 0 rotate <0, 0,  55> translate <-86, 335, 0> }      
      plane {-x, 0 rotate <0, 0, -55> translate < 86, 335, 0> }      
   }   
}                                       

#declare FcdFloor2=union {   
   box { <-600, 0, -320>, <600, 44.6, 600> }
   cylinder { <-600, 42.6, -320>, <-600, 42.6, 600>, 2 }
   sphere { <-600, 42.6, -320>, 2 }
   cylinder { <-600, 42.6, -320>, <600, 42.6, -320>, 2 }
   sphere { < 600, 42.6, -320>, 2 }
   cylinder { < 600, 42.6, -320>, < 600, 42.6, 600>, 2 }

   box { <-400, 0, -325>, <400, 44.6, -320> }
   cylinder { <-400, 42.6, -325>, <-400, 42.6, 320>, 2 }
   sphere { <-400, 42.6, -325>, 2 }
   cylinder { <-400, 42.6, -325>, <400, 42.6, -325>, 2 }
   sphere { < 400, 42.6, -325>, 2 }
   cylinder { < 400, 42.6, -325>, < 400, 42.6, 320>, 2 }
   
   object { FcdSoejleFluted scale 0.205 translate <-367, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate <-297, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate <-155, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate < -85, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate <  85, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate < 155, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate < 297, 44.6, -296> }
   object { FcdSoejleFluted scale 0.205 translate < 367, 44.6, -296> }
   
   object { FcdFloor2Sidesection1 translate <388, 0, -234> }
   object { FcdFloor2Sidesection2 translate <388, 0, -234> }
   object { FcdFloor2Midsection   translate <  0, 0,   50> }
   object { FcdFloor2Sidesection2 translate <388, 0, -234> scale <-1, 1, 1> }
   object { FcdFloor2Sidesection1 translate <388, 0, -234> scale <-1, 1, 1> }
   
   box { <-388, 405, -317>, <388, 488, 600> }
   difference {
      object { FcdMainGesims2ProfileA scale <880, 1, 1> translate <-440, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> translate <-388, 0, 0> } 
      plane {-x, 0 rotate <0, -45, 0> translate < 388, 0, 0> } 
      translate <0, 405, -317>
   }                                          
   #declare pos = -383;
   #while (pos <= 383)
      object { FcdMainGesims2Konsol translate <pos, 431, -317> }
      #declare pos = pos + 766/25;
   #end
   difference {
      object { FcdMainGesims2ProfileA scale <250, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <388, 405, -317>
   }   
   difference {
      object { FcdMainGesims2ProfileA scale <250, 1, 1> translate <-50, 0, 0> }
      plane { x, 0 rotate <0,  45, 0> } 
      rotate <0, -90, 0> translate <388, 405, -317>
      scale <-1, 1, 1>
   }   
   #declare pos = -312;
   #while (pos <= -252)
      object { FcdMainGesims2Konsol rotate <0, -90, 0> translate < 388, 431, pos> }
      object { FcdMainGesims2Konsol rotate <0,  90, 0> translate <-388, 431, pos> }
      #declare pos = pos + 30;
   #end                                      
      
}

/* --- Pediment ---*/

#declare FcdPedimentKonsol=union {
   difference {
      box { <-8, 0, 20>, <8, -2.5, -20> }
      plane { x, 0 rotate <0, 0, 45> translate <-8, 0, 0> }
      plane {-x, 0 rotate <0, 0, -45> translate <8, 0, 0> }
      plane { z, 0 rotate <-45, 0, 0> translate <0, 0, -20> }
   }     
   difference {
      box { <-10, -2.5, 20>, <5.5, -7.5, -17.5> }
      plane { x, 0 rotate <0, 0, -26> translate <-5.5, -2.5, 0> }
      plane {-x, 0 rotate <0, 0, -26> translate < 5.5, -2.5, 0> }
   }
}      
      
#declare FcdPedimentEdge=union {
   difference {
      union {      
         difference {
            object { FcdMainGesims2ProfileB scale <480, 1, 1> translate <-12, -83, 0> }
            plane { x, 0 rotate <0, 45, 0> translate <0, 0, -24> }
         }
         difference {   
            object { FcdMainGesims2ProfileB scale <110, 1, 1> rotate <0, 90, 0> translate <24, -83, 74> }
            plane {-x, 0 rotate <0, 45, 0> translate <0, 0, -24> }
         }
         box { <0, 0, 20>, <460, -13, -24> }
         box { <0, -13, 20>, <460, -21, 0> }
         cylinder { <0, -21, 5>, <460, -21, 5>, 5 }
         rotate <0, 0, 26> 
      }                
      plane { y, 0 }
      plane {-x, 0 translate <412, 0, 0> }
   }                                                    
   #declare pos = 60.7926;
   #while (pos < 480)
      object { FcdPedimentKonsol translate <pos, -13, 0> rotate <0, 0, 26> }
      #declare pos = pos + 34.09;
   #end   
}      
   
#declare FcdPedimentTympanum=difference {    
   object {
	   height_field {png "cathedral/cathedral_relief.png" smooth }  // height_field image by Peter Hertel
	   scale <700, 20, 171>
	   rotate <-90, 0, 0>   
	   translate <-350, 0, 0>
	}
	plane {-y, 0 rotate <0, 0,  26> translate <-350, 0, 0> }   
	plane {-y, 0 rotate <0, 0, -26> translate < 350, 0, 0> }   
	plane { -z, 0 translate <0, 0, 1000> }
}

#declare FcdPediment=union {   
   difference {
      box { <-412, 0, -312>, <412, 210, -260> }
      plane {-y, 0 rotate <0, 0,  26> translate <-412, 0, 0> }
      plane {-y, 0 rotate <0, 0, -26> translate < 412, 0, 0> }
   }                                 
   object { FcdPedimentEdge translate <-412, 0, -317> }
   object { FcdPedimentEdge translate <-412, 0, -317> scale <-1, 1, 1> }   
   object { FcdPedimentTympanum translate <0, 0, -317> }
   
   box { <-500,  0, -225>, <500, 52, -150> }
   box { <-500, 52, -227>, <500, 57, -150> }

   box { <-388,   0, -300>, <-300,  75, -250> } 
   box { <-392,  75, -304>, <-296,  80, -250> } 
   object { statueMainLeft rotate <0, 180, 0> scale <-16, 16, 16> translate <-366, 80, -275> }
   box { < -21, 200, -300>, <  21, 225, -250> } 
   box { < -25, 225, -300>, <  25, 230, -250> } 
   object { statueMainCenter rotate <0, 180, 0> scale <-16, 16, 16> translate <0, 230, -275> }
   box { < 388,   0, -300>, < 300,  75, -250> } 
   box { < 392,  75, -304>, < 296,  80, -250> } 
   object { statueMainRight rotate <0, 180, 0> scale <-16, 16, 16> translate <355, 80, -275> }
}
   

/*------------ Finished Dome and Facade ----------------*/

#declare StPaulsDome=union{
   object { Sokkel }
   object { Arcade rotate <0, 22.5, 0> }
   object { Entablement translate <0,  406, 0> }
   object { Balustrade  translate <0,  488, 0> }
   object { Gallery     translate <0,  488, 0> }
   object { Dome        translate <0,  812, 0> }
   object { Platform    translate <0, 1538, 0> }
   object { Fodstykke   translate <0, 1596, 0> }
   object { Tower       translate <0, 1715, 0> }
   object { Loft        translate <0, 1953, 0> }
   object { Spir        translate <0, 2228, 0> }
   translate <0, 1700, 0>
   texture { T_Stp_Stone }
}

#declare StPaulsFacade=union {
   object { FcdTower translate <-740, 0, 0> }
   object { FcdTower scale <-1, 1, 1> translate < 740, 0, 0> }
   object { FcdTowerClock translate <740, 1370+39, -230> }     
   object { FcdStairs translate <0, 0, -586> }
   object { FcdFloor1 translate <0, 144, 0> }
   object { FcdFloor2 translate <0, 709, 0> }
   object { FcdPediment translate <0, 1197, 0> }
   translate <0, 0, -2855>
   texture { T_Stp_Stone }
}
   

