#include "boats/boat8/body.inc"
#include "boats/boat8/front.inc"
#include "boats/boat8/top.inc"
#include "boats/boat8/mast1.inc"
#include "boats/boat8/mast2.inc"
#include "boats/boat8/sail1.inc"
#include "boats/boat8/sail2.inc"
#include "boats/boat8/sail3.inc"
#include "boats/boat8/shade.inc"

#declare Txt = texture{
	pigment{
		wood 
		scale 0.55 
		warp {turbulence 0.6 octaves 5 lambda 2.6 omega 0.61}
		scale<0.08, 0.08, 0.5> 
		color_map {
			[ 0.0 rgb<0.26, 0.17, 0.11>]
    		[ 0.4 rgb<0.19, 0.16, 0.11>]
    		[ 0.8 rgb<0.17, 0.15, 0.11>]
		}
	} 
	finish {diffuse 0.7}
	rotate y*90 scale<1, 0.4, 1>
}

#declare SailTxt = texture{
	pigment{
		gradient x 
		color_map {
			[ 0.0 0.5 color rgb 0.8 color rgb 0.8]
    		[ 0.5 1.0 color rgb <0.06, 0.09, 0.16> color rgb <0.06, 0.09, 0.16>]
		}                
		frequency 1.3
	} 
	finish {diffuse 0.7}
	normal{wrinkles 0.18 scale<0.1, 0.5, 0.5>}
}

#declare ShadeTxt = texture{
	pigment{color rgb 0.72}
	finish {diffuse 0.6}
	normal{wrinkles 0.22 scale<0.03, 0.4, 0.4>}
}

#declare Boat8 = union {
	object{
		Body
		texture{Txt}
	}
	
	object{
		Front
		texture{Txt rotate z*80}
	}
	
	object{
		Top
		texture{Txt}
	}
	 
	object{
		Mast1
		texture{Txt}
	}
	
	object{
		Mast2
		texture{Txt rotate z*60}
	} 
	 
	object{
		Sail1
		texture{SailTxt rotate z*100 translate y*7.2}
	}
	  
	object{
		Sail2
		texture{SailTxt rotate z*12 translate x*8}
	}
	  
	object{
		Sail3
		texture{SailTxt rotate z*35 translate<3, 0, 0>}
	}
	  
	object{
		Shade
		texture{ShadeTxt}
	} 
}