#include "boats/boat4/body.inc"
#include "boats/boat4/front.inc"
#include "boats/boat4/top.inc"
#include "boats/boat4/mast1.inc"
#include "boats/boat4/mast2.inc"
#include "boats/boat4/mast3.inc"
#include "boats/boat4/sacks.inc"

#declare Txt = texture{
	pigment{
		wood 
		scale 0.55 
		warp {turbulence 0.6 octaves 5 lambda 2.6 omega 0.61}
		scale<0.08, 0.08, 0.6> 
		color_map {
			[ 0.0 rgb<0.23, 0.16, 0.11>]
    		[ 0.4 rgb<0.16, 0.17, 0.11>]
    		[ 0.8 rgb<0.15, 0.13, 0.11>]
		}
	} 
	finish {diffuse 0.75}
	rotate y*90 scale<1.5, 0.3, 1>
}

#declare SackTxt = texture{
	pigment{color rgb 0.7}
	finish {diffuse 0.6}
	normal{wrinkles 0.23 scale<0.3, 0.1, 0.07>}
}

#declare Boat4 = union {
	object{
		Body
		texture{Txt}
	}
	
	object{
		Front
		texture{Txt rotate z*110}
	}
	
	object{
		Top
		texture{Txt}
	}
	
	object{
		Mast1
		texture{Txt rotate z*95}
	}
	
	object{
		Mast2
		texture{Txt rotate z*80}
	}
	
	object{
		Mast3
		texture{Txt rotate y*45}
	}     
	
	object{
		Sacks
		texture{SackTxt}
	}
}
