#include "boats/boat3/body.inc"
#include "boats/boat3/top.inc"
#include "boats/boat3/shade.inc"

#declare Txt = texture{
	pigment{
		wood 
		scale 0.55 
		warp {turbulence 0.6 octaves 5 lambda 2.6 omega 0.61}
		scale<0.08, 0.08, 0.5> 
		color_map {
			[ 0.0 rgb<0.28, 0.15, 0.11>]
    		[ 0.4 rgb<0.21, 0.16, 0.11>]
    		[ 0.8 rgb<0.19, 0.14, 0.11>]
		}
	} 
	finish {diffuse 0.75}
	rotate y*90 scale<1.6, 0.25, 1>
}

#declare ShadeTxt = texture{
	pigment{color rgb <0.68, 0.65, 0.65>}
	finish {diffuse 0.7}
	normal{wrinkles 0.14 scale<0.1, 0.5, 0.5>}
}

#declare Boat3 = union {
	object{
		Body
		texture{Txt}
	}

	
	object{
		Top
		texture{Txt}
	}
	
	object{
		Shade
		texture{ShadeTxt}
	}
}
