#include "boats/boat12/body.inc"
#include "boats/boat12/front.inc"
#include "boats/boat12/mast1.inc"
#include "boats/boat12/mast2.inc" 
#include "boats/boat12/rope.inc"
#include "boats/boat12/sail.inc"
#include "boats/boat12/seats.inc"
#include "boats/boat12/top.inc"

#declare Txt = texture{
	pigment{
		wood 
		scale 0.55 
		warp {turbulence 0.6 octaves 5 lambda 2.6 omega 0.61}
		scale<0.08, 0.08, 0.5> 
		color_map {
			[ 0.0 rgb<0.27, 0.16, 0.1>]
    		[ 0.4 rgb<0.20, 0.15, 0.1>]
    		[ 0.8 rgb<0.18, 0.14, 0.1>]
		}
	} 
	finish {diffuse 0.7}
	rotate y*90 scale<1, 0.2, 1>
}

#declare SailTxt = texture{
	pigment{color rgb 0.8} 
	finish {diffuse 0.7}
	normal{wrinkles 0.16 scale 0.4}
}

#declare RopeTxt = texture{
	pigment{color rgb<0.6, 0.55, 0.5>} 
	finish {diffuse 0.7}
	normal{bumps 0.35 scale 0.002}
}

#declare Boat12 = union {
	object{
		Body
		texture{Txt}
	} 
	
	object{
		Front
		texture{Txt rotate z*110}
	}
	
	object{
		Rope
		texture{RopeTxt}
	}
	
	object{
		Mast1
		texture{Txt rotate z*95}
	}
	
	object{
		Mast2
		texture{Txt rotate -z*70}
	}
	
	object{
		Sail
		texture{SailTxt}
	}
	
	object{
		Top
		texture{Txt}
	} 
}