#include "boats/boat11/body.inc"
#include "boats/boat11/front.inc"
#include "boats/boat11/back.inc"
#include "boats/boat11/mast1.inc"
#include "boats/boat11/mast2.inc"
#include "boats/boat11/mast3.inc"
#include "boats/boat11/ribs.inc" 
#include "boats/boat11/sail.inc"
#include "boats/boat11/top.inc"

#declare Txt = texture{
	pigment{
		wood 
		scale 0.55 
		warp {turbulence 0.6 octaves 5 lambda 2.6 omega 0.61}
		scale<0.08, 0.08, 0.5> 
		color_map {
			[ 0.0 rgb<0.27, 0.13, 0.07>]
    		[ 0.4 rgb<0.20, 0.14, 0.07>]
    		[ 0.8 rgb<0.15, 0.11, 0.07>]
		}
	} 
	finish {diffuse 0.7}
	rotate y*90 scale<1, 0.4, 1>
}

#declare SailTxt = texture{
	pigment{
		gradient x 
		color_map {
			[ 0.0 0.5 color rgb<0.82, 0.8, 0.8> color rgb<0.82, 0.8, 0.8>]
    		[ 0.5 1.0 color rgb <0.06, 0.09, 0.16> color rgb <0.06, 0.09, 0.16>]
		}                
		frequency 1.54
	} 
	finish {diffuse 0.64}
	normal{wrinkles -0.08 scale<0.1, 0.5, 0.5>}
}

#declare Boat11 = union { 
	object{
		Body
		texture{Txt}
	} 
	       
	object{
		Front
		texture{Txt rotate z*80}
	}
	         
	object{
		Mast1
		texture{Txt rotate -z*15}
	}
	   
	object{
		Mast2
		texture{Txt rotate -z*80}
	} 
	     
	object{
		Mast3
		texture{Txt rotate z*17}
	}
	       
	object{
		Ribs
		texture{Txt rotate z*90}
	}
	         
	object{
		Sail
		texture{SailTxt rotate z*15 translate -x*0.38}
	}
	
	object{
		Top
		texture{Txt}
	}    
}