#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house8/house8.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
		normal{
			bump_map{
				jpeg "houses/house8/house8b.jpg"
				map_type 0
			}          
			bump_size -6
		}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare Column = union {
	sphere{0, 0.005 scale<1, 0.7, 1>}
	sphere{0, 0.005 scale<1, 0.7, 1> translate y*0.035}
	sphere{0, 0.005 translate y*0.008}                 
	difference{
		sphere{0, 0.005 scale<1, 6, 1>}
		plane{y, 0}
		translate y*0.008
	}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.002, 0.03, 0.03> translate<0.005, 0.005, 0.002>} 
	object{E5 scale<0.002, 0.03, 0.03> translate<0.02 - 0.001, 0.005, 0.002>}       
	object{E5 scale<0.002, 0.03, 0.03> translate<0.035 - 0.002, 0.005, 0.002>}
	
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.005, 0.002>}
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.02 - 0.001, 0.002>}        
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.035 - 0.002, 0.002>}
	
	object{Glass scale<0.03, 0.03, 1> translate<0.005, 0.005, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.04, 0.005, 0.03>}
	object{E5 scale<0.04, 0.005, 0.03> translate y*0.035}
	object{E5 scale<0.005, 0.04, 0.03>}
	object{E5 scale<0.005, 0.04, 0.03> translate x*0.035}
	
	object{E5 scale<0.05, 0.05, 0.03> translate<-0.005, -0.005, 0.0026>}
	
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.12, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.13 - 0.004, 0.002>}
		
	object{Glass scale<0.04, 0.12, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.01, 0.14, 0.03>}
	object{E5 scale<0.01, 0.14, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.13, 0>}
	
	object{WindowFrame2}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.002, 0.14, 0.03> translate<0.01, 0, 0.003>}
	object{E5 scale<0.002, 0.16, 0.03> translate<0.03 - 0.001, 0, 0.003>}
	object{E5 scale<0.002, 0.14, 0.03> translate<0.05 - 0.002, 0, 0.003>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.02}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.02 - 0.002}
		plane{y, 0}
		translate<0.03, 0.14, 0.003>
	}
	
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.02 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.04 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.06 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.08 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.10 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.12 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.14 - 0.002, 0.003>}
	
	object{Glass scale<0.04, 0.14, 1> translate<0.01, 0, 0.0035>}
	object{
		Glass 
		clipped_by{cylinder{<0.5, 0.5, -1>, <0.5, 0.5, 1>, 0.5}} 
		clipped_by{plane{-y, -0.5}}
		translate -y*0.5
		scale<0.04, 0.04, 1>
		translate<0.01, 0.14, 0.0035>
	}
	texture{WindowFrameTxt}
}

#declare Window3 = union {
	object{E5 scale<0.005, 0.14, 0.03>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.005, 0, -0.002>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.06 - 0.005, 0, 0>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.05, 0, -0.002>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.025}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.02}
		plane{y, 0}
		translate<0.03, 0.14, -0.002>
	}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.025}
		plane{y, 0}
		translate<0.03, 0.14, 0>
	}
	
	object{WindowFrame3}
}

#declare Window3AndBalcony = union {
	object{Window3}
	object{E5 scale<0.082, 0.006, 0.1> translate<-0.011, -0.006, -0.015>}
	object{E5 scale<0.08, 0.006, 0.1> translate<-0.01, -0.01, -0.01>}
			
	object{E6 scale<0.01, 0.034, 0.01> translate<-0.01, 0, -0.01>}
	object{E6 scale<0.01, 0.034, 0.01> translate<0.06, 0, -0.01>}
		
	object{E6 scale<0.082, 0.006, 0.015> translate<-0.011, 0.04 - 0.006, -0.015>}
		
	object{E5 scale<0.011, 0.006, 0.1> translate<-0.011, 0.04 - 0.006, -0.015 + 0.015>}
	object{E5 scale<0.011, 0.006, 0.1> translate<0.06, 0.04 - 0.006, -0.015 + 0.015>}
			
	object{Column translate<0.01, 0, -0.005>}
	object{Column translate<0.02, 0, -0.005>}
	object{Column translate<0.03, 0, -0.005>}
	object{Column translate<0.04, 0, -0.005>}
	object{Column translate<0.05, 0, -0.005>}
}

#declare WindowFrame4 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.09 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.09 - 0.008, 0.03> translate<0.02 - 0.001, 0.004, 0>}
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.045 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.055 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.065 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.075 - 0.001, 0>} 

	object{Glass scale<0.03, 0.08, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window4 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.09 - 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
  
	object{WindowFrame4 translate z*0.002}
	
	translate -z*0.004
}

#declare Window5 = union {
	difference{
		cylinder{0, <0, 0, 0.03>, 0.02}
		plane{y, 0}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.016}
	}
    object{E5 scale<0.032, 0.004, 0.02> translate<-0.016, 0, 0>}
    object{
    	Glass 
    	translate<-0.5, -0.5, 0> 
    	clipped_by{cylinder{<0, 0, -1>, <0, 0, 1>, 0.016}}
    	clipped_by{plane{-y, 0}} 
    	translate<0, 0, 0.002>
    }
    
	translate<0.02, 0, -0.003>
}

#declare House8 = union {
	// facade
	object{E1 scale<0.4, 0.84, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.4, 0.004, 0.4> translate<0, 0.74, -0.004>}
	object{E6 scale<0.4, 0.006, 0.4> translate<0, 0.744, -0.006>}
	
	// 1st floor
	object{Window1 translate<0.04, 0.05, -0.004>}
	object{Window1 translate<0.11, 0.05, -0.004>}
	object{Window1 translate<0.18, 0.05, -0.004>}
	object{Window1 translate<0.25, 0.05, -0.004>}
	object{Window1 translate<0.32, 0.05, -0.004>}
	  
	// 2nd floor
	object{Window2 translate<0.02, 0.14, -0.004>}
	object{Window2 translate<0.12, 0.14, -0.004>}
	object{Window2 translate<0.22, 0.14, -0.004>}
	object{Window2 translate<0.32, 0.14, -0.004>}
	
	// bars
	object{E5 scale<0.39, 0.01, 0.03> translate<0.005, 0.13, -0.005>}
	object{E5 scale<0.39, 0.01, 0.03> translate<0.005, 0.30, -0.005>}
	object{E5 scale<0.39, 0.01, 0.03> translate<0.005, 0.50, -0.005>}
	object{E5 scale<0.39, 0.01, 0.03> translate<0.005, 0.54, -0.005>}
	object{E5 scale<0.39, 0.01, 0.03> translate<0.005, 0.68, -0.005>}
 
	// 3rd floor
	object{Window3AndBalcony translate<0.02, 0.32, -0.005>}
	object{Window3AndBalcony translate<0.12, 0.32, -0.005>}
	object{Window3AndBalcony translate<0.22, 0.32, -0.005>}
	object{Window3AndBalcony translate<0.32, 0.32, -0.005>} 
	
	// 4th floor
	object{Window4 translate<0.03, 0.55, 0.001>}
	object{Window4 translate<0.13, 0.55, 0.001>}
	object{Window4 translate<0.23, 0.55, 0.001>}
	object{Window4 translate<0.33, 0.55, 0.001>}
   
	// attic
	object{Window5 translate<0.03, 0.7, 0>}
	object{Window5 translate<0.13, 0.7, 0>}
	object{Window5 translate<0.23, 0.7, 0>}
	object{Window5 translate<0.33, 0.7, 0>}

	texture{FacadeTxt scale<0.4, 0.85, 1> translate<0, -0.1, 0>}
}