#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house7/house7.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
		normal{
			bump_map{
				jpeg "houses/house7/house7b.jpg"
				map_type 0
			}          
			bump_size -6
		}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.6; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#local Pgm = pigment{
	cells
	color_map{
		[0.0 0.2 color rgb<1.1, 0.6, 0.4> color rgb<0.9, 0.4, 0.2>]
		[0.2 0.4 color rgb<1.1, 0.7, 0.5> color rgb<1.1, 0.5, 0.3>]
		[0.4 0.8 color rgb<1, 0.6, 0.4> color rgb<0.9, 0.4, 0.3>]
		[0.8 1.0 color rgb<1.1, 0.65, 0.45> color rgb<1.05, 0.55, 0.35>]
	}	
}

#declare ChimneyTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/tower.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.66}
		translate -y*0.5
		scale<0.15, 0.18, 0.15>
	#end
}

#declare Base = height_field {
	jpeg "houses/house7/base7.jpg"
    smooth  
    rotate -x*90
    
    texture{
    	pigment{
    		image_map{
				jpeg "houses/house7/base7map.jpg"
				map_type 0
			}
    	}
    	finish{phong 0.1 phong_size 70}
    }
     
    scale<1, 1, 0.004>
    translate z*0.001
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.06, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.002, 0.06, 0.03> translate<0.03 - 0.001, 0.01, 0.002>}
	object{E5 scale<0.004, 0.06, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.004, 0.002>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.03 - 0.001, 0.002>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.05 - 0.001, 0.002>}
		
	object{Glass scale<0.04, 0.06, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {  
	object{E5 scale<0.01, 0.08, 0.03>}
	object{E5 scale<0.01, 0.08, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.07, 0>}
	
	object{E5 scale<0.06, 0.01, 0.03> translate<0, -0.01, 0.0015>}
	object{E5 scale<0.06, 0.01, 0.03> translate<0, -0.02, 0.003>}
	                             
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.12, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.003, 0.12, 0.03> translate<0.03 - 0.0015, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.003, 0.03> translate<0.01, 0.03 - 0.0015, 0.002>}
	object{E3 scale<0.04, 0.003, 0.03> translate<0.01, 0.05 - 0.0015, 0.002>}
	object{E3 scale<0.04, 0.003, 0.03> translate<0.01, 0.07 - 0.0015, 0.002>}
	object{E3 scale<0.04, 0.003, 0.03> translate<0.01, 0.09 - 0.0015, 0.002>}
	object{E3 scale<0.04, 0.003, 0.03> translate<0.01, 0.11 - 0.0015, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.13 - 0.004, 0.002>}
		
	object{Glass scale<0.04, 0.12, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.01, 0.14, 0.03>}
	object{E5 scale<0.01, 0.14, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.13, 0>}
	
	object{WindowFrame2}
}

#declare Window3 = union {
	object{E5 scale<0.04, 0.04, 0.03>}
	object{E5 scale<0.01, 0.03, 0.03> translate <0.005, 0.005, -0.002>}
	object{E5 scale<0.01, 0.03, 0.03> translate <0.04 - 0.015, 0.005, -0.002>}
	
	object{E3 scale<0.01, 0.01, 0.03> translate<0.015, 0.005, -0.002>}
	object{E3 scale<0.01, 0.01, 0.03> translate<0.015, 0.04 - 0.015, -0.002>}
}

#declare Bar = union {
	object{E5 scale<0.5, 0.01, 0.02> rotate x*45 translate -z*0.005}
	object{E5 scale<0.5, 0.005, 0.02> rotate x*45 translate<0, 0.004, -0.003>}
	object{E5 scale<0.5, 0.005, 0.02> rotate x*45 translate<0, -0.004, -0.003>}
}

#declare Chimney = union {
	cylinder{0, <0, 0.06, 0>, 0.005}
	cone{<0, -0.01, 0>, 0, <0, 0.02, 0>, 0.01 translate y*0.05}
	cylinder{0, <0, 0.007, 0>, 0.01 hollow clipped_by{plane{y, 0.005}} translate y*0.07}
	
	cone{<0, -0.001, 0>, 0.013, <0, 0.01, 0>, 0 clipped_by{plane{-y, 0}} translate y*0.078}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0.008, 0.07, 0>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<-0.008, 0.07, 0>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0, 0.07, 0.008>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0, 0.07, -0.008>}
	
	texture{ChimneyTxt}
}

#declare Roof = union {
	// tile roof
	#include "houses/tileroof.inc"
	difference{
		object{
			Roof1(20, 0.75, 0.18, 0.13, 20, 6, 1, Pgm, 130)
			translate -z*0.01 
			rotate 90*y
			rotate z*30
			translate <0, 0, 0.15>       
		}
		plane{z, 0 rotate x*60}
		translate -x*0.004          
	}
	
	difference{
		object{
			Roof1(20, 0.75, 0.52, 0.13, 40, 6, 1, Pgm, 132)
			translate -z*0.01 
			rotate -x*30
		}
		plane{x, 0 rotate -z*60}
		plane{-x, 0 rotate z*60 translate x*0.52}
		translate -x*0.01
	}
	
	object{
		Roof1(25, 0.75, 0.24/23, 0.173, 1, 9, 0, Pgm, 134)
		translate -x*(0.24/28/2)
		translate -z*0.013 
		rotate -90*x
		rotate y*35
		rotate -z*40 
		rotate x*60
		translate -x*0.004
	}
	
	object{
		Roof1(20, 0.75, 0.24/24, 0.2, 1, 3, 0, Pgm, 136)
		rotate -z*20
		translate<0.103, 0.0614, 0.106>
		translate -x*0.01
	} 
	
	object{Chimney translate<0.01, -0.03, 0.07>}
	object{Chimney translate<0.25, 0.06, 0.18>}
	object{Chimney translate<0.35, 0.04, 0.12>}

	translate<-0.005, 0, -0.005>
}

#declare House7 = union {
	// facade
	object{E1 scale<0.5, 0.93, 1> translate -y*0.1}
	
	// basement
	difference {
		object{Base scale<0.52, 0.21, 1> translate<-0.01, -0.1, 0>}
		plane{-z, 0 translate z*0.002}
		plane{x, 0}
		plane{-x, 0 translate x*0.5}
	}
	
	// top
	object{E6 scale<0.51, 0.01, 0.41> translate<-0.005, 0.83, -0.005>}
	object{E6 scale<0.52, 0.01, 0.42> translate<-0.01, 0.84, -0.01>}
	
	// left wall
	union {
		object{E1 scale<0.4, 0.93, 1> translate -y*0.1 rotate -y*90}
		object{Window3 rotate y*90 translate<-0.003, 0.77, 0.09>}
		object{Window3 rotate y*90 translate<-0.003, 0.77, 0.18>}
		texture{FacadeTxt  scale<0.52, 0.95, 1> translate<-0.01, -0.1, 0> rotate -y*90}      
	}
	
	// bars
	object{Bar translate y*0.29}
	object{Bar translate y*0.33}
	object{Bar translate y*0.52}
	object{Bar translate y*0.56}
	object{Bar translate y*0.74}
	
	// 1st floor
	object{Window1 translate<0.04, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.09, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.18, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.27, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.36, 0.18, -0.005>}
	
	// 2nd floor
	object{Window2 translate<0.04, 0.35, -0.003>}
	object{Window2 translate<0.04 + 0.09, 0.35, -0.003>}
	object{Window2 translate<0.04 + 0.18, 0.35, -0.003>}
	object{Window2 translate<0.04 + 0.27, 0.35, -0.003>}
	object{Window2 translate<0.04 + 0.36, 0.35, -0.003>}
	
	// 3rd floor
	object{Window2 translate<0.04, 0.58, -0.004>}
	object{Window2 translate<0.04 + 0.09, 0.58, -0.003>}
	object{Window2 translate<0.04 + 0.18, 0.58, -0.003>}
	object{Window2 translate<0.04 + 0.27, 0.58, -0.003>}
	object{Window2 translate<0.04 + 0.36, 0.58, -0.003>}
	
	// attic
	object{Window3 translate<0.05, 0.77, -0.003>}
	object{Window3 translate<0.05 + 0.09, 0.77, -0.003>}
	object{Window3 translate<0.05 + 0.18, 0.77, -0.003>}
	object{Window3 translate<0.05 + 0.27, 0.77, -0.003>}
	object{Window3 translate<0.05 + 0.36, 0.77, -0.003>}
	
	// roof
    object{Roof translate y*0.85}
	
	texture{FacadeTxt scale<0.52, 0.95, 1> translate<-0.01, -0.1, 1>}
}