#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house2/house21.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.64 phong 0.04}
		normal{
			bump_map{
				jpeg "houses/house2/house21b.jpg"
				map_type 0
			}          
			bump_size -6
		}
	#end
}

#declare SideTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house2/house22.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.64 phong 0.04}
		normal{
			bump_map{
				jpeg "houses/house2/house22b.jpg"
				map_type 0
			}          
			bump_size 6
		}
	#end
}

#declare TowerTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/tower.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.64}
		normal{
			bump_map{
				jpeg "houses/towerb.jpg"
				map_type 0
			}          
			bump_size 10
		}
		
		translate -y*0.5
		scale 0.32
		translate 0.05
	#end
}

#declare Base = height_field {
	jpeg "houses/house2/base2.jpg"
    smooth  
    rotate -x*90
    texture{
    	pigment{
    		image_map{
				jpeg "houses/house2/base2map.jpg"
				map_type 0
			}
    	}
    	finish{phong 0.1 phong_size 70}
    }
     
    scale<1, 1, 0.004>
    translate z*0.001
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.4; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.2, 0.1>*k color rgb<0.33, 0.2, 0.1>*k] 
    			[0.3 0.6 color rgb<0.33, 0.2, 0.1>*k color rgb<0.36, 0.2, 0.1>*k]
    			[0.6 1.0 color rgb<0.36, 0.2, 0.1>*k color rgb<0.3, 0.2, 0.1>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.002, 0.022, 0.03> translate <0.004, 0.004, 0.001>}
	object{E5 scale<0.002, 0.022, 0.03> translate<0.03 - 0.006, 0.004, 0.001>}
	object{E3 scale<0.022, 0.002, 0.03> translate<0.004, 0.004, 0.001>}
	object{E3 scale<0.022, 0.002, 0.03> translate <0.004, 0.03 - 0.006, 0.001>}
	
	object{E3 scale<0.002, 0.022, 0.03> translate <0.015 - 0.001, 0.004, 0.001>}
	object{E3 scale<0.022, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0.001>}
	
	object{Glass scale<0.022, 0.022, 1> translate<0.004, 0.004, 0.0015>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {    
	object{E5 scale<0.04, 0.04, 0.03> translate<-0.005, -0.005, 0.002>}
	object{E5 scale<0.004, 0.03, 0.03>}
	object{E5 scale<0.004, 0.03, 0.03> translate<0.03 - 0.004, 0, 0>}
	object{E3 scale<0.022, 0.004, 0.03> translate x*0.004}
	object{E3 scale<0.022, 0.004, 0.03> translate <0.004, 0.03 - 0.004, 0>}
	
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.003, 0.07, 0.03> translate<0.015, 0.005, -0.002>}
	object{E5 scale<0.003, 0.07, 0.03> translate<0.03 - 0.003/2, 0.005, -0.002>}
	object{E5 scale<0.003, 0.07, 0.03> translate<0.045 - 0.003, 0.005, -0.002>}
	
	object{E3 scale<0.024, 0.003, 0.03> translate<0.018, 0.005, -0.002>}
	object{E3 scale<0.024, 0.003, 0.03> translate<0.018, 0.023, -0.002>}
	object{E3 scale<0.024, 0.003, 0.03> translate<0.018, 0.04, -0.002>}
	object{E3 scale<0.024, 0.003, 0.03> translate<0.018, 0.057, -0.002>}
	object{E3 scale<0.024, 0.003, 0.03> translate<0.018, 0.075 - 0.003, -0.002>}

	object{Glass scale<0.03, 0.07, 1> translate<0.015, 0.005, -0.0015>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.06, 0.08, 0.03>}
	object{E5 scale<0.01, 0.08, 0.03> translate<0.005, 0, -0.004>}
	object{E5 scale<0.01, 0.08, 0.03> translate<0.045, 0, -0.004>}
	object{E3 scale<0.03, 0.005, 0.03> translate<0.015, 0, -0.004>}
	object{E3 scale<0.03, 0.005, 0.03> translate<0.015, 0.075, -0.004>}
	
	object{E5 scale<0.065, 0.005, 0.03> translate<-0.0025, 0.075, -0.0045>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.015}
		cylinder{<0, 0, -1>, <0, 0, 0.002>, 0.02}
		plane{y, 0}
		translate<0.03, 0.08, -0.001>
	}
	
	object{WindowFrame2}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.002, 0.15, 0.03> translate<0.005, 0, 0.002>} 
	object{E5 scale<0.002, 0.15, 0.03> translate<0.045 - 0.002, 0, 0.002>}       
	object{E5 scale<0.002, 0.195, 0.03> translate<0.025 - 0.001, 0.002, 0.002>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.04}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.036}
		plane{-x, 0}
		plane{y, 0}
		scale<0.5, 1, 1>
		translate<0.025, 0.15, 0.002>
	}
	difference{
		cylinder{0, <0, 0, 0.03>, 0.04}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.036}
		plane{x, 0}
		plane{y, 0}
		scale<0.5, 1, 1>
		translate<0.025, 0.15, 0.002>
	}
	
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.02, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.04, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.06, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.08, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.10, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.12, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.14, 0.002>}
	object{E3 scale<0.036, 0.002, 0.03> translate<0.007, 0.16, 0.002>}
	
	object{Glass scale<0.04, 0.15, 1> translate<0.005, 0, 0.0025>}
	object{Glass translate<-0.5, -0.5, 0> clipped_by{cylinder{<0, 0, -1>, <0, 0, 1>, 0.5}} 
		scale<0.04, 0.08, 1> 
		translate<0.025, 0.15, 0.0025>
	}
	texture{WindowFrameTxt}
}

#declare Window3 = union {
	object{E5 scale<0.005, 0.15, 0.03>}
	object{E5 scale<0.005, 0.15, 0.03> translate x*0.045}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.05}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.04}
		plane{-x, 0}
		plane{y, 0}
		scale<0.5, 1, 1>
		translate<0.025, 0.15, 0>
	}
	difference{
		cylinder{0, <0, 0, 0.03>, 0.05}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.04}
		plane{x, 0}
		plane{y, 0}
		scale<0.5, 1, 1>
		translate<0.025, 0.15, 0>
	}
	
	object{WindowFrame3}
}

#declare Window4 = union {
	difference{
		cylinder{0, <0, 0, 0.03>, 0.016} 
		cylinder{<0, 0, -1>, <0, 0, 0.001>, 0.013}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.01}
	}                                    
	object{Glass translate<-0.5, -0.5, 0> clipped_by{cylinder{<0, 0, -1>, <0, 0, 1>, 0.013}} translate z*0.0012}
	translate -z*0.003
}

#declare Column1 = union {
	// front
	union {
		object{E1 scale<0.015, 0.1, 1> translate x*0.135}
		object{E1 scale<0.015, 0.1, 1> translate <0.135, 0, 0.01>}
		object{E3 scale<0.019, 0.006, 0.014> translate <0.133, 0, -0.002>}
		object{E3 scale<0.017, 0.004, 0.012> translate <0.134, 0.006, -0.001>}
		object{E3 scale<0.019, 0.006, 0.014> translate <0.133, 0.095 - 0.006, -0.002>}
		object{E3 scale<0.017, 0.004, 0.012> translate <0.134, 0.085, -0.001>}
		translate<0, 0.1, -0.002>
		texture{FacadeTxt scale<0.47, 1, 1> translate<-0.02, -0.1, 0>}
	}
	// side
	union {
		object{E1 scale<0.014, 0.006, 1> rotate -y*90 translate<0.133, 0, -0.002>}
		object{E1 scale<0.014, 0.006, 1> rotate -y*90 translate<0.133, 0.095 - 0.006, -0.002>}
		object{E1 scale<0.014, 0.006, 1> rotate -y*90 translate<0.133 + 0.019, 0, -0.002>}
		object{E1 scale<0.014, 0.006, 1> rotate -y*90 translate<0.133 + 0.019, 0.095 - 0.006, -0.002>} 
		
		object{E1 scale<0.012, 0.004, 1> rotate -y*90 translate<0.134, 0.006, -0.001>}
		object{E1 scale<0.012, 0.004, 1> rotate -y*90 translate<0.134, 0.085, -0.001>}
		object{E1 scale<0.012, 0.004, 1> rotate -y*90 translate<0.134 + 0.017, 0.006, -0.001>}
		object{E1 scale<0.012, 0.004, 1> rotate -y*90 translate<0.135 + 0.016, 0.085, -0.001>}
		
		object{E1 scale<0.01, 0.1, 1> rotate -y*90 translate<0.135, 0, 0>}
		object{E1 scale<0.01, 0.1, 1> rotate -y*90 translate<0.135 + 0.015, 0, 0>}
		
		translate<0, 0.1, -0.002>
		texture{FacadeTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.1, 0>}
	}
}

#declare Column2 = union {
	object{E5 scale<0.02, 0.14, 0.03>}
	object{E5 scale<0.022, 0.01, 0.03> translate<-0.001, 0, -0.001>}
	object{E5 scale<0.022, 0.01, 0.03> translate<-0.001, 0.14 - 0.01, -0.001>}
	object{E5 scale<0.024, 0.007, 0.03> translate<-0.002, 0, -0.002>}
	object{E5 scale<0.024, 0.007, 0.03> translate<-0.002, 0.14 - 0.007, -0.002>}
}

#declare Column3 = union {
	sphere{0, 0.004 scale<1, 0.6, 1>}
	sphere{0, 0.004 scale<1, 0.6, 1> translate y*0.05}
	
	sphere{0, 0.004 scale<1, 0.6, 1> translate y*0.025}
	
	sphere{0, 0.004 translate y*0.03}
    sphere{0, 0.004 translate y*0.02}
    
    difference{
    	sphere{0, 0.004}
    	plane{y, 0}
    	scale<1, 5, 1>
    	translate y*0.03
    }
    difference{
    	sphere{0, 0.004}
    	plane{-y, 0}
    	scale<1, 5, 1>
    	translate y*0.02
    }
}

#declare Column4 = union {
	object{E1 scale<0.01, 0.05, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.05, -0.3, 0>} 
		translate<0, 0.01, 0>
	}
	object{E1 scale<0.01, 0.05, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, -0.3, 0>} 
		translate<0, 0.01, 0.01>
	}
	object{E1 scale<0.01, 0.05, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.15, -0.3, 0>}
		rotate -y*90 
		translate<0, 0.01, 0>
	}
	object{E1 scale<0.01, 0.05, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.2, -0.3, 0>}
		rotate -y*90 
		translate<0.01, 0.01, 0>
	}
}

#declare Balcony = union {
	object{E1 scale<0.16, 0.004, 1>}
	object{E1 scale<0.165, 0.006, 1> translate<-0.0025, 0.004, -0.0025>}
	
	object{E1 scale<0.1, 0.004, 1> rotate -y*90 texture{SideTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.45, -0.05>}}
	object{E1 scale<0.1, 0.004, 1> rotate -y*90 texture{SideTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.45, -0.05>} 
		translate x*0.16
	}
	object{E1 scale<0.1025, 0.006, 1> rotate -y*90 texture{SideTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.45, -0.05>}
		translate<-0.0025, 0.004, -0.0025>
	}
	object{E1 scale<0.1025, 0.006, 1> rotate -y*90 texture{SideTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.45, -0.05>} 
		translate<0.1625, 0.004, -0.0025>
	}
	
	// bottom
	object{E1 scale<0.16, 0.1, 1> rotate x*90 texture{SideTxt scale<0.47, 1, 1> rotate x*90 translate<-0.1, 0, 0.45>}}
	object{E1 scale<0.165, 0.1025, 1> rotate x*90 texture{SideTxt scale<0.47, 1, 1> rotate x*90 translate<-0.1, 0, 0.45>}
		translate<-0.0025, 0.004, -0.0025>
	}
	object{E1 scale<0.165, 0.1025, 1> rotate x*90 texture{SideTxt scale<0.47, 1, 1> rotate x*90 translate<-0.1, 0, 0.45>}
		translate<-0.0025, 0.01, -0.0025>
	}
	
	// top
	object{E1 scale<0.162, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} translate<-0.001, 0.06, -0.001>}
	object{E1 scale<0.158, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} translate<0.001, 0.06, 0.014>}
	object{E1 scale<0.165, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} translate<-0.0025, 0.064, -0.0025>}
	object{E1 scale<0.16, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} translate<0.001, 0.064, 0.019 - 0.0025>}
	
	object{E1 scale<0.162, 0.015, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate x*90 
		translate<-0.001, 0.06, -0.001>
	}
	object{E1 scale<0.165, 0.019, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate x*90 
		translate<-0.0025, 0.064, -0.0025>
	}
	object{E1 scale<0.165, 0.019, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate x*90 
		translate<-0.0025, 0.07, -0.0025>
	}      
	
	// left
	object{E1 scale<0.1, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate -y*90 
		translate<-0.001, 0.06, -0.001>
	}
	object{E1 scale<0.1, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate -y*90 
		translate<0.014, 0.06, -0.001>
	}
	object{E1 scale<0.1, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} rotate -y*90 
		translate<-0.0025, 0.064, -0.0025>
	}
	object{E1 scale<0.1, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} rotate -y*90 
		translate<0.015 - 0.0025, 0.064, -0.0024>
	}
	
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<-0.001, 0.06, 0.015 - 0.001>
	}  
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<-0.0025, 0.064, 0.019 - 0.0025>
	}  
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<-0.0025, 0.07, 0.019 - 0.0025>
	}
	
	// right   
	object{E1 scale<0.1, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate -y*90 
		translate<0.16 - 0.015 + 0.001, 0.06, -0.001>
	}
	object{E1 scale<0.1, 0.004, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.406, 0>} rotate -y*90 
		translate<0.16 + 0.001, 0.06, -0.001>
	}
	object{E1 scale<0.1, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} rotate -y*90 
		translate<0.16 - 0.015 + 0.0025, 0.064, -0.0025>
	}
	object{E1 scale<0.1, 0.006, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.41, 0>} rotate -y*90 
		translate<0.16 + 0.0025, 0.064, -0.0024>
	}
	
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<0.16 - 0.015 + 0.001, 0.06, 0.015 - 0.001>
	}  
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<0.16 - 0.015 + 0.0025, 0.064, 0.019 - 0.0025>
	}  
	object{E1 scale<0.015, 0.1, 1> texture{SideTxt scale<0.47, 1, 1> translate<-0.1, 0.416, 0>} 
		rotate x*90
		translate<0.16 - 0.015 + 0.0025, 0.07, 0.019 - 0.0025>
	}  
	         
	object{Column4}
	object{Column4  rotate y*180 translate<0.06, 0, 0.01>}
	object{Column4 rotate y*90 translate<0.1, 0, 0.01>}
	object{Column4 rotate -y*90 translate<0.16, 0, 0>}
	object{Column4 rotate y*180 translate<0.01, 0, 0.05>}
	object{Column4 translate<0.15, 0, 0.04>}
	
	object{Column3 translate<0.02, 0.01, 0.005>}
	object{Column3 translate<0.03, 0.01, 0.005>}
	object{Column3 translate<0.04, 0.01, 0.005>}
	
	object{Column3 translate<0.07, 0.01, 0.005>}
	object{Column3 translate<0.08, 0.01, 0.005>}
	object{Column3 translate<0.09, 0.01, 0.005>}
	
	object{Column3 translate<0.12, 0.01, 0.005>}
	object{Column3 translate<0.13, 0.01, 0.005>}
	object{Column3 translate<0.14, 0.01, 0.005>}

	object{Column3 translate<0.005, 0.01, 0.02>}
	object{Column3 translate<0.005, 0.01, 0.03>}
	
	object{Column3 translate<0.155, 0.01, 0.02>}
	object{Column3 translate<0.155, 0.01, 0.03>}
	
	texture{SideTxt scale<0.47, 1, 1> translate<-0.1, -0.66, 0> rotate y*45}	                                            
}

#declare TowerPart = difference{
	union{
		box{0, <0.03, 0.04, 0.03>}
		box{<-0.003, 0.04, -0.003>, <0.033, 0.043, 0.03>}
		box{<-0.005, 0.043, -0.005>, <0.035, 0.045, 0.03>}
	}
	box{<0.005, -1, -1>, <0.025, 0.035, 0.005>}
	plane{x, 0 rotate y*45}
	plane{-x, 0 rotate -y*45 translate x*0.03}
}

#declare Tower = union {
	// front-back
	union{
		object{TowerPart}
		object{TowerPart rotate y*180 translate<0.03, 0, 0.03>}
		object{E1 scale<0.1, 0.1, 1> rotate x*5 clipped_by{plane{-x, 0 rotate -z*5}} clipped_by{plane{x, 0 rotate z*5}}}
		
		// top
		sphere{<0.015, 0.185, 0.015>, 0.002}
		sphere{0, 0.01 scale<0.15, 1, 0.15> translate<0.015, 0.196, 0.015>}
		
		texture{TowerTxt}
	}      
	
	// sides
	union{
		object{TowerPart rotate y*90 translate z*0.03}
		object{TowerPart rotate -y*90 translate<0.03, 0, 0>}
		texture{TowerTxt rotate y*90}
	} 
	
	// roof
	difference{
		box{<0, 0.045, 0>, <0.03, 0.2, 0.03>}
		plane{z, 0 rotate x*6 translate<0, 0.045, 0> texture{TowerTxt}}
		plane{-z, 0 rotate -x*6 translate<0, 0.045, 0.03> texture{TowerTxt}}
		plane{x, 0 rotate -z*6 translate<0, 0.045, 0> texture{TowerTxt rotate y*90}}
		plane{-x, 0 rotate z*6 translate<0.03, 0.045, 0> texture{TowerTxt rotate y*90}}
	}
	
	translate -x*0.015
}

#declare House2 = union {
	// facade
	difference {
		union {
			object{E1 scale<0.43, 0.83, 1> translate y*0.07}
			object{E1 scale<0.43, 0.2, 1> translate -y*0.2 rotate x*15 translate y*0.07}
		}
		box{<0.185, -1, -1>, <0.245, 0.23, 1>}
		box{<0.14, 0.09, -1>, <0.29, 0.21, 1>}
	}
	// basement
	difference {
		object{Base scale<0.47, 0.2, 1> translate -y*0.205 rotate x*15 translate y*0.07 translate -x*0.02}

		box{<0.185, -1, -1>, <0.245, 0.23, 1>}
		box{<0.14, 0.09, -1>, <0.29, 0.21, 1>}
		plane{-z, 0 translate z*0.002 rotate x*15 translate y*0.07}
		plane{x, 0 rotate y*45 rotate x*15 translate y*0.07}
		plane{-x, 0 rotate -y*45 rotate x*15 translate y*0.07 translate x*0.43}
	}
	
	object{E6 scale<0.195, 0.006, 0.1> translate<-0.005, 0.1 - 0.006, -0.005>}
	object{E6 scale<0.19, 0.004, 0.1> translate<-0.0025, 0.09, -0.0025>}
	
	object{E6 scale<0.195, 0.006, 0.1> translate<-0.005, 0.1 - 0.006, -0.005> translate x*0.245}
	object{E6 scale<0.19, 0.004, 0.1> translate<-0.0025, 0.09, -0.0025> translate x*0.245}
	
	// Columns 1
	object{Column1}
	object{Column1 translate x*0.035}
	object{Column1 translate x*0.035}
	object{Column1 translate x*0.11}
	object{Column1 translate x*0.145}
		
	// portal
	object{E6 scale<0.06, 0.005, 0.4> translate<0.13, 0.195, -0.006>}
	object{E6 scale<0.06, 0.005, 0.4> translate<0.24, 0.195, -0.006>}
	
	object{E6 scale<0.065, 0.005, 0.4> translate<0.13 - 0.0025, 0.195, -0.008>}
	object{E6 scale<0.065, 0.005, 0.4> translate<0.24 - 0.0025, 0.195, -0.008>}
	
	object{E6 scale<0.06, 0.01, 0.4> translate<0.13, 0.2, -0.007>}
	object{E6 scale<0.06, 0.01, 0.4> translate<0.24, 0.2, -0.007>}
	
	object{E6 scale<0.065, 0.005, 0.4> translate<0.13 - 0.0025, 0.21, -0.008>}
	object{E6 scale<0.065, 0.005, 0.4> translate<0.24 - 0.0025, 0.21, -0.008>}
	       
	difference{
		union {
			object{E6 scale<1, 0.01, 0.2> translate<0, 1, -0.01> texture{TowerTxt translate -y*0.37 rotate -z*90 scale<7, 0.5, 1> rotate x*90}}
			object{E6 scale<0.01, 1, 0.2> translate<1, 0, -0.01> texture{TowerTxt translate -y*0.37 scale<0.5, 7, 1> rotate y*90}}
			cylinder{<1, 1, -0.01>, <1, 1, 0.02>, 0.02 texture{TowerTxt translate -y*0.37 scale<0.5, 7, 1> rotate x*90 translate -z*5.4}}
			object{E5 scale<1, 1, 0.2>}
			translate<-0.5, -0.5, 0> 
			rotate z*45 
		}
		plane{y, 0}
		scale<0.13, 0.04, 1>
		translate<0.215, 0.215, -0.006>
	}
	object{E1 translate -x*0.5 scale<0.06, 0.2, 1> rotate x*90 translate<0.215, 0.215, -0.006>}
	         
	// top
	object{E6 scale<0.435, 0.005, 0.405> translate<-0.0025, 0.845, -0.0025>}
	object{E6 scale<0.435, 0.005, 0.405> translate<-0.0025, 0.86, -0.0025>}
	
	object{E6 scale<0.47, 0.005, 0.44> translate<-0.02, 0.88, -0.02>}
	object{E6 scale<0.47, 0.005, 0.44> translate<-0.02, 0.895, -0.02>}
	object{E6 scale<0.46, 0.01, 0.43> translate<-0.015, 0.885, -0.015>}
	
	#local counter=0;  
    #while (counter < 15)
    	difference{
    		object{E5 translate -y*1 scale<0.01, 0.02, 0.02> rotate -x*45}
    		plane{-y, 0}
    		translate<counter * 0.03, 0.88, -0.015>
    	}
        #local counter = counter + 1;
    #end

	// left wall
	union {
		object{E1 scale<0.4, 0.83, 1> rotate -y*90 translate<0, 0.07, 0>}
		difference{
			 object{E1 scale<0.5, 0.17, 1> rotate -y*90 translate<0, -0.17, -0.1>}
			 plane{z, 0 rotate x*15}
			 translate y*0.07
		}
	
		difference{
			object{E1 rotate -y*90 scale<1, 0.17, 0.2> translate<0, -0.17, -0.1>}
			plane{z, 0 rotate x*15}
			translate<0.245, 0.07, 0>
		}
		difference{
			object{E1 rotate -y*90 scale<1, 0.17, 0.2> translate<0, -0.17, -0.1>}
			plane{z, 0 rotate x*15}
			translate<0.185, 0.07, 0>
		}
		
		object{E1 rotate -y*90 scale<1, 0.02, 0.12> translate<0.185, 0.07, 0>}
		object{E1 rotate -y*90 scale<1, 0.02, 0.12> translate<0.245, 0.07, 0>}
		
		object{E1 rotate -y*90 scale<1, 0.11, 0.16> translate<0.14, 0.1, 0>}
		object{E1 rotate -y*90 scale<1, 0.11, 0.16> translate<0.29, 0.1, 0>}
		
		// left
		difference {
			object{Base scale<0.47, 0.197, 1> translate -y*0.205 rotate y*90 translate <0, 0.074, 0.22>}
			plane{-x, 0 translate x*0.002}
			plane{z, 0 rotate -y*45 rotate x*15 translate y*0.07}
		}
		
		// center
		difference {
			object{Base scale<0.47, 0.197, 1> translate -y*0.205 rotate y*90 translate <0, 0.074, 0.22>}
			plane{-x, 0 translate x*0.002}
			plane{z, 0 rotate -y*45 rotate x*15 translate y*0.07}
			translate x*0.245
		}
				
		texture{SideTxt scale<0.47, 1, 1> rotate -y*90 translate<0, -0.1, -0.05>}      
	}
	  
	// bars
	object{E5 scale<0.43, 0.005, 0.002> translate<0, 0.335, -0.002>}
	object{E5 scale<0.43, 0.005, 0.002> translate<0, 0.355, -0.002>}
	object{E5 scale<0.43, 0.005, 0.004> translate<0, 0.415, -0.004>}
	object{E6 scale<0.434, 0.005, 0.4> translate<-0.002, 0.565, -0.005>}
	object{E6 scale<0.434, 0.005, 0.4> translate<-0.002, 0.625, -0.002>}
	object{E5 scale<0.434, 0.005, 0.4> translate<-0.002, 0.655, -0.005>}
	object{E6 scale<0.435, 0.005, 0.405> translate<-0.0025, 0.8, -0.004>}
	
	object{E5 scale<0.43, 0.002, 0.002> translate<0, 0.413, -0.002>}
	object{E5 scale<0.432, 0.005, 0.4> translate<-0.001, 0.560, -0.004>}
	object{E6 scale<0.432, 0.002, 0.4> translate<-0.001, 0.623, -0.001>}
	object{E5 scale<0.432, 0.005, 0.4> translate<-0.001, 0.650, -0.004>}
	
	
	// 1st floor
	object{Window1 translate<0.06, 0.16, -0.004>}
	object{Window1 translate<0.33, 0.16, -0.004>}
	object{Window1 translate<0.06, 0.28, -0.004>}
	object{Window1 translate<0.33, 0.28, -0.004>}
	
	object{E5 scale<0.005, 0.03, 0.03> translate<0.155, 0.28, -0.001>}
	object{E5 scale<0.005, 0.02, 0.03> translate<0.155 + 0.03 - 0.0025, 0.285, -0.001>}
	object{E5 scale<0.005, 0.02, 0.03> translate<0.155 + 0.06 - 0.0025, 0.285, -0.001>}
	object{E5 scale<0.005, 0.02, 0.03> translate<0.155 + 0.09 - 0.0025, 0.285, -0.001>}
	object{E5 scale<0.005, 0.03, 0.03> translate<0.155 + 0.12 - 0.005, 0.28, -0.001>}
	
	object{E3 scale<0.11, 0.005, 0.03> translate<0.16, 0.28, -0.001>}
	object{E3 scale<0.11, 0.005, 0.03> translate<0.16, 0.305, -0.001>}
	
	object{Glass scale<0.11, 0.02, 1> translate<0.16, 0.285, -0.0005>}
	
	// 2nd floor
	object{Window2 translate<0.05, 0.42, -0.002>} 
	object{Window2 translate<0.32, 0.42, -0.002>}
	
	object{Window3 translate<0.145, 0.36, -0.008>}
	object{Window3 translate<0.19, 0.36, -0.01>}
	object{Window3 translate<0.235, 0.36, -0.008>}
	
	// 3rd floor
	object{Window2 translate<0.05, 0.66, -0.004>} 
	object{Window2 translate<0.32, 0.66, -0.004>}
	
	object{Window3 translate<0.145, 0.6, -0.008>}
	object{Window3 translate<0.19, 0.6, -0.01>}
	object{Window3 translate<0.235, 0.6, -0.008>}
	
	// Columns 2
	object{Column2 translate<0.01, 0.42, -0.001>}
	object{Column2 translate<0.13, 0.42, -0.001>}
	object{Column2 translate<0.28, 0.42, -0.001>}
	object{Column2 translate<0.40, 0.42, -0.001>}
	object{Column2 translate<0.01, 0.66, -0.001>}
	object{Column2 translate<0.13, 0.66, -0.001>}
	object{Column2 translate<0.28, 0.66, -0.001>}
	object{Column2 translate<0.40, 0.66, -0.001>}
	
	// attic
	object{Window4 translate<0.08, 0.825, 0>}
	object{Window4 translate<0.17, 0.825, 0>}
	object{Window4 translate<0.215, 0.825, 0>}
	object{Window4 translate<0.26, 0.825, 0>}
	object{Window4 translate<0.35, 0.825, 0>}
	
	// Stairway
	union{
		object{E3 scale<0.06, 0.11, 0.08> translate<0.185, -0.1, 0>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.01, 0.01>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.02, 0.02>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.03, 0.03>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.04, 0.04>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.05, 0.05>}
		object{E3 scale<0.06, 0.01, 0.08> translate<0.185, 0.06, 0.06>}
	}
	  
	// Door
	object{E1 scale<0.15, 0.2, 1> translate<0.14, 0.07, 0.08>}     
	
	object{E5 scale<0.005, 0.105, 0.1> translate<0.19, 0.07, 0.08 - 0.004>}
	object{E5 scale<0.005, 0.105, 0.1> translate<0.235, 0.07, 0.08 - 0.004>}
	object{E3 scale<0.04, 0.005, 0.1> translate<0.195, 0.17, 0.08 - 0.004>}
	
	object{E3 scale<0.04, 0.04, 0.1> translate<0.195, 0.07, 0.08 - 0.002>}
	object{E5 scale<0.003, 0.06, 0.1> translate<0.195, 0.11, 0.08 - 0.002>}
	object{E5 scale<0.003, 0.06, 0.1> translate<0.235 - 0.003, 0.11, 0.08 - 0.002>}
	object{E5 scale<0.003, 0.06, 0.1> translate<0.215 - 0.003/2, 0.11, 0.08 - 0.002>}
	
	object{E3 scale<0.04 - 0.006, 0.003, 0.1> translate<0.198, 0.17 - 0.003, 0.08 - 0.002>}
	object{E3 scale<0.04 - 0.006, 0.003, 0.1> translate<0.198, 0.15 - 0.003/2, 0.08 - 0.002>}
	object{E3 scale<0.04 - 0.006, 0.003, 0.1> translate<0.198, 0.13 - 0.003/2, 0.08 - 0.002>}
	
	object{Glass scale<0.04, 0.06, 1> translate<0.195, 0.11, 0.08 - 0.001>}
	
	// Balconies
	object{Balcony translate<0.135, 0.35, -0.05>}
	object{Balcony translate<0.135, 0.59, -0.05>}
	
	// Towers
	object{Tower translate<0.08, 0.9, 0.01>}
	object{Tower translate<0.35, 0.9, 0.01>}

	texture{FacadeTxt scale<0.47, 1, 1> translate<-0.02, -0.1, 0>}
}