#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house16/house16.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.05, 0.03> translate<0.01, 0.01, 0>}
	object{E5 scale<0.004, 0.05, 0.03> translate<0.025 - 0.002, 0.01, 0>}
	object{E5 scale<0.004, 0.05, 0.03> translate<0.04 - 0.004, 0.01, 0>}
	  
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.01, 0.00001>}
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.025 - 0.002, 0.00001>}
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.045 - 0.002, 0.00001>} 
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.06 - 0.004, 0.00001>}

	object{Glass scale<0.04, 0.06, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.05, 0.01, 0.03>}
	object{E5 scale<0.05, 0.01, 0.03> translate <0, 0.06, 0>}
	object{E5 scale<0.01, 0.05, 0.03> translate<0, 0.01, 0>}
	object{E5 scale<0.01, 0.05, 0.03> translate<0.04, 0.01, 0>}
  
	object{WindowFrame1 translate z*0.002}
	
	translate -z*0.0026
}

#declare WindowFrame2 = union {                 
	object{E5 scale<0.004, 0.08, 0.03> translate<0.01, 0.01, 0>}
	object{E5 scale<0.004, 0.08, 0.03> translate<0.025 - 0.002, 0.01, 0>}
	object{E5 scale<0.004, 0.08, 0.03> translate<0.04 - 0.004, 0.01, 0>}
	  
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.01, 0.00001>}
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.03 - 0.002, 0.00001>}
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.05 - 0.002, 0.00001>} 
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.07 - 0.002, 0.00001>}
	object{E5 scale<0.022, 0.004, 0.03> translate<0.014, 0.09 - 0.004, 0.00001>}

	object{Glass scale<0.04, 0.09, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.06, 0.11, 0.03> translate<-0.005, -0.005, 0.0027>}
	
	object{E5 scale<0.05, 0.01, 0.03>}
	object{E5 scale<0.05, 0.01, 0.03> translate <0, 0.09, 0>}
	object{E5 scale<0.01, 0.08, 0.03> translate<0, 0.01, 0>}
	object{E5 scale<0.01, 0.08, 0.03> translate<0.04, 0.01, 0>}
  
	object{WindowFrame2 translate z*0.002}
	
	translate -z*0.003
}

#declare House16 = union {
	// facade
	object{E1 scale<0.4, 0.54, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.4, 0.01, 0.4> translate<0, 0.44, -0.005>}
	object{E6 scale<0.4, 0.01, 0.4> translate<0, 0.45, -0.01>}
	
	// bars
  	object{E5 scale<0.4, 0.03, 0.003> translate<0, 0.23, -0.003>}
  	object{E5 scale<0.4, 0.02, 0.002> translate<0, 0.235, -0.005>}
 
	// 1st floor
	object{Window1 translate<0.05, 0.1, 0>}
	object{Window1 translate<0.175, 0.1, 0>}
	object{Window1 translate<0.3, 0.1, 0>}
    
    // 3rd floor
    object{Window2 translate<0.03, 0.3, 0>}
    object{Window2 translate<0.1, 0.3, 0>}
    object{Window2 translate<0.175, 0.3, 0>}
    object{Window2 translate<0.25, 0.3, 0>}
    object{Window2 translate<0.32, 0.3, 0>}
    
	texture{FacadeTxt scale<0.4, 0.56, 1> translate<0, -0.1, 0>}
}