#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house15/house15.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare Bar = union {
	object{E5 scale<0.5, 0.02, 0.002> translate -z*0.002}
	object{E5 scale<0.5, 0.01, 0.002> translate<0, 0.005, -0.004>}
}

#declare Square = union {
	object{E5 scale<0.04, 0.04, 0.02>}
	object{E5 scale<0.02, 0.02, 0.02> translate<0.01, 0.01, -0.002>}
	rotate z*45
	translate -z*0.003
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.11, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.11, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.11, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
		
	object{Glass scale<0.04, 0.11, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.01, 0.12, 0.03>}
	object{E5 scale<0.01, 0.12, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.11, 0>}
	
	object{WindowFrame1}
}

#declare Chimney = union {
	cylinder{0, <0, 0.1, 0>, 0.01}
	cone{<0, 0.1, 0>, 0.01, <0, 0.12, 0>, 0.015}
	cone{<0, 0.11, 0>, 0.025, <0, 0.14, 0>, 0 clipped_by{plane{-y, -0.115}}}
	scale 0.5
}

#declare House15 = union {
	// facade
	object{E1 scale<0.5, 0.51, 1> translate -y*0.1}
	
	// right wall
	object{E1 scale<0.4, 0.52, 1> 
		texture{FacadeTxt scale<0.4, 0.52, 1>}
		rotate -y*90 
		translate<0.5, -0.1, 0>
	}
	
	// top
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.41, -0.005>}
	#local counter=0;  
    #while (counter < 12)
   		object{E5 scale<0.02, 0.01, 0.02> translate<0.02 + (0.04*counter), 0.405, -0.003>}
        #local counter = counter + 1;
    #end
	
	// bars
  	object{Bar translate<0, 0.105, 0>}
  	object{Bar translate<0, 0.33, 0>}
  	
  	// squares
  	object{Square translate<0.05, 0.04, 0>}
  	object{Square translate<0.15, 0.04, 0>}
  	object{Square translate<0.25, 0.04, 0>}
  	object{Square translate<0.35, 0.04, 0>}
  	object{Square translate<0.45, 0.04, 0>}
  	
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.05, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.15, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.25, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.35, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.45, 0.36, -0.003>}  
	
	// 1st floor
	object{Window1 translate<0.07, 0.18, -0.003>}
	object{Window1 translate<0.22, 0.18, -0.003>}
	object{Window1 translate<0.37, 0.18, -0.003>}
	
	object{Chimney translate<0.02, 0.385, 0.02>}
	object{Chimney translate<0.25, 0.395, 0.025>}
	   
	texture{FacadeTxt scale<0.5, 0.52, 1> translate<0, -0.1, 0>}
	translate y*0.03
}