#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house9/house9.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
		normal{
			bump_map{
				jpeg "houses/house9/house9b.jpg"
				map_type 0
			}          
			bump_size 3*-4
		}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.4; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Base = height_field {
	jpeg "houses/house9/base9.jpg"
    smooth  
    rotate -x*90
    
    texture{
    	pigment{
    		image_map{
				jpeg "houses/house9/base9map.jpg"
				map_type 0
			}
    	}
    	finish{phong 0.12 phong_size 60}
    }
     
    scale<1, 1, 0.004>
    translate z*0.001
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.1 - 0.006, 0>}
	
	object{E5 scale<0.002, 0.1 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.1 - 0.008, 0.03> translate<0.02 - 0.001, 0.004, 0>}
	object{E5 scale<0.002, 0.1 - 0.008, 0.03> translate<0.04 - 0.006, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.045 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.055 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.065 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.075 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.085 - 0.001, 0>} 

	object{Glass scale<0.03, 0.09, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.1 - 0.004, 0>}
	object{E5 scale<0.004, 0.1 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.1 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
  
	object{WindowFrame1 translate z*0.002}
	
	translate -z*0.004
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.12, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.13 - 0.004, 0.002>}
		
	object{Glass scale<0.04, 0.12, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.07, 0.15, 0.03> translate<-0.005, -0.005, 0.004>}
	object{E5 scale<0.01, 0.14, 0.03>}
	object{E5 scale<0.01, 0.14, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.13, 0>}
	
	object{WindowFrame2}
}

#declare House9 = union {
	// facade
	object{E1 scale<0.5, 0.9, 1> translate -y*0.1}
	
	// basement
	difference {
		object{Base scale<0.52, 0.1593*0.92, 1> translate<-0.01, -0.1, 0>}
		plane{-z, 0 translate z*0.002}
		plane{x, 0}
		plane{-x, 0 translate x*0.5}
	}
	
	// top
	object{E6 scale<0.512, 0.03, 0.412> translate<-0.006, 0.8, -0.006>}
	object{E6 scale<0.52, 0.01, 0.42> translate<-0.01, 0.81, -0.01>}
	
	// left wall
	object{E1 scale<0.4, 0.9, 1> texture{FacadeTxt scale<0.52, 0.92, 1>} translate -y*0.1 rotate -y*90}
	
	// bars
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.05, -0.006>} 
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.11, -0.006>}
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.29, -0.006>}
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.35, -0.006>}
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.57, -0.006>}
	object{E5 scale<0.5, 0.01, 0.006> translate<0, 0.63, -0.006>}
	
	// columns
	object{E5 scale<0.03, 0.17, 0.02> translate<0.01, 0.12, -0.004>}
	object{E5 scale<0.03, 0.17, 0.02> translate<0.10, 0.12, -0.004>}
	object{E5 scale<0.03, 0.17, 0.02> translate<0.19, 0.12, -0.004>}
	object{E5 scale<0.03, 0.17, 0.02> translate<0.28, 0.12, -0.004>}
	object{E5 scale<0.03, 0.17, 0.02> translate<0.37, 0.12, -0.004>}
	object{E5 scale<0.03, 0.17, 0.02> translate<0.46, 0.12, -0.004>}
	
	object{E5 scale<0.03, 0.16, 0.02> translate<0.01, 0.64, -0.004>}
	object{E5 scale<0.03, 0.16, 0.02> translate<0.10, 0.64, -0.004>}
	object{E5 scale<0.03, 0.16, 0.02> translate<0.19, 0.64, -0.004>}
	object{E5 scale<0.03, 0.16, 0.02> translate<0.28, 0.64, -0.004>}
	object{E5 scale<0.03, 0.16, 0.02> translate<0.37, 0.64, -0.004>}
	object{E5 scale<0.03, 0.16, 0.02> translate<0.46, 0.64, -0.004>}
	
	// 1st floor
	object{Window1 translate<0.05, 0.15, 0.001>}
	object{Window1 translate<0.14, 0.15, 0.001>}
	object{Window1 translate<0.23, 0.15, 0.001>}
	object{Window1 translate<0.32, 0.15, 0.001>}
	object{Window1 translate<0.41, 0.15, 0.001>}
	  
	// 2nd floor
	object{Window2 translate<0.04, 0.39, -0.006>}
	object{Window2 translate<0.13, 0.39, -0.006>}
	object{Window2 translate<0.22, 0.39, -0.006>}
	object{Window2 translate<0.31, 0.39, -0.006>}	
	object{Window2 translate<0.40, 0.39, -0.006>}	
 
	// 3rd floor
	object{Window1 translate<0.05, 0.66, 0.001>}
	object{Window1 translate<0.14, 0.66, 0.001>}
	object{Window1 translate<0.23, 0.66, 0.001>}
	object{Window1 translate<0.32, 0.66, 0.001>}
	object{Window1 translate<0.41, 0.66, 0.001>}
	
	#include "houses/house9/sunshade3.inc"	                
	object{Sunshade scale<0.019, 0.0224, 0.021> translate<0.25, 0.52, -0.004>}
	object{Sunshade scale<0.015, 0.018, 0.016> translate<0.16, 0.76, -0.001>}
	                
	texture{FacadeTxt scale<0.52, 0.92, 1> translate<-0.01, -0.1, 0>}
	translate -y*0.02
}