#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare WindowFrameTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare Glass = object{
	E1
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}

#declare Bar = union {
	object{E5 scale<0.5, 0.02, 0.002> translate -z*0.002}
	object{E5 scale<0.5, 0.01, 0.002> translate<0, 0.005, -0.004>}
}

#declare Square = union {
	object{E5 scale<0.04, 0.04, 0.02>}
	object{E5 scale<0.02, 0.02, 0.02> translate<0.01, 0.01, -0.002>}
	rotate z*45
	translate -z*0.003
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.11, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.11, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.11, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
		
	object{Glass scale<0.04, 0.11, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.01, 0.12, 0.03>}
	object{E5 scale<0.01, 0.12, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.11, 0>}
	
	object{WindowFrame1}
}

#declare Chimney = union {
	cylinder{0, <0, 0.1, 0>, 0.01}
	cone{<0, 0.1, 0>, 0.01, <0, 0.12, 0>, 0.015}
	cone{<0, 0.11, 0>, 0.025, <0, 0.14, 0>, 0 clipped_by{plane{-y, -0.115}}}
	scale 0.5
}

#declare House15 = union {
	// facade
	object{E1 scale<0.5, 0.51, 1> translate -y*0.1}
	
	// right wall
	object{E1 scale<0.4, 0.52, 1> 
		texture{FacadeTxt scale<0.4, 0.52, 1>}
		rotate -y*90 
		translate<0.5, -0.1, 0>
	}
	
	// top
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.41, -0.005>}
	#local counter=0;  
    #while (counter < 12)
   		object{E5 scale<0.02, 0.01, 0.02> translate<0.02 + (0.04*counter), 0.405, -0.003>}
        #local counter = counter + 1;
    #end
	
	// bars
  	object{Bar translate<0, 0.105, 0>}
  	object{Bar translate<0, 0.33, 0>}
  	
  	// squares
  	object{Square translate<0.05, 0.04, 0>}
  	object{Square translate<0.15, 0.04, 0>}
  	object{Square translate<0.25, 0.04, 0>}
  	object{Square translate<0.35, 0.04, 0>}
  	object{Square translate<0.45, 0.04, 0>}
  	
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.05, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.15, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.25, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.35, 0.36, -0.003>}
  	object{E5 scale<0.02, 0.02, 0.02> rotate z*45 translate<0.45, 0.36, -0.003>}  
	
	// 1st floor
	object{Window1 translate<0.07, 0.18, -0.003>}
	object{Window1 translate<0.22, 0.18, -0.003>}
	object{Window1 translate<0.37, 0.18, -0.003>}
	
	object{Chimney translate<0.02, 0.385, 0.02>}
	object{Chimney translate<0.25, 0.395, 0.025>}
	   
	texture{FacadeTxt scale<0.5, 0.52, 1> translate<0, -0.1, 0>}
	translate y*0.03
	texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}