#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare WindowFrameTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare Glass = object{
	E1
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}

#declare Rect = union {
	object{E5 scale<0.01, 0.03, 0.03>}
	object{E5 scale<0.01, 0.03, 0.03> translate x*0.05}
	object{E5 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E5 scale<0.04, 0.01, 0.03> translate<0.01, 0.02, 0>}
}

#declare Ornament = union {
	object{E5 scale<0.46, 0.01, 0.03>}
	object{E5 scale<0.46, 0.01, 0.03> translate y*0.06}
	object{E5 scale<0.01, 0.05, 0.03> translate y*0.01}
	object{E5 scale<0.01, 0.05, 0.03> translate<0.45, 0.01, 0>}
	
	object{Rect translate<0.05, 0.02, 0>}
	object{Rect translate<0.17, 0.02, 0>}
	object{Rect translate<0.27, 0.02, 0>}
	object{Rect translate<0.37, 0.02, 0>}
	
	translate -z*0.003
}

#declare Column = union {
	sphere{0, 0.005 scale<1, 0.7, 1>}
	sphere{0, 0.005 scale<1, 0.7, 1> translate y*0.035}
	sphere{0, 0.005 translate y*0.008}                 
	difference{
		sphere{0, 0.005 scale<1, 6, 1>}
		plane{y, 0}
		translate y*0.008
	}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.003, 0.1, 0.03> translate<0.01, 0.02, 0.002>}        
	object{E5 scale<0.003, 0.1, 0.03> translate<0.025 - 0.003/2, 0.02, 0.002>}
	object{E5 scale<0.003, 0.1, 0.03> translate<0.04 - 0.003, 0.02, 0.002>}
	
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.02 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.04 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.06 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.08 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.10 - 0.003, 0.002>}
	
	object{Glass scale<0.03, 0.1, 1> translate<0.01, 0.02, 0.003>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {  
	object{E5 scale<0.05, 0.005, 0.04> translate<0, 0.005, -0.002>}
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.01, -0.004>}
	object{E5 scale<0.05, 0.01, 0.03> translate y*0.12}
	object{E5 scale<0.01, 0.1, 0.03> translate y*0.02}
	object{E5 scale<0.01, 0.1, 0.03> translate<0.04, 0.02, 0>} 
	                               
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.13, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<-0.01, 0.02, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<0.05, 0.02, 0.003>}
	object{E5 scale<0.07, 0.005, 0.03> translate<-0.01, 0.135, -0.002>}
	                             
	object{WindowFrame1}
}   

#declare Bars = union {
	object{E5 scale<0.01, 0.22, 0.03>}
	object{E5 scale<0.01, 0.22, 0.03> translate<0.45, 0, 0>}
	object{E5 scale<0.44, 0.01, 0.03> translate<0.01, 0, 0>}
	object{E5 scale<0.44, 0.01, 0.03> translate<0.01, 0.21, 0>}
	
	translate -z*0.003
}

#declare House12 = union {
	// facade
	object{E1 scale<0.5, 0.9, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.76, -0.005>}
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.79, -0.005>}	
	
	// 1st floor
	object{Window1 translate<0.065, 0.14, -0.005>}
	object{Window1 translate<0.165, 0.14, -0.005>}
	object{Window1 translate<0.265, 0.14, -0.005>}
	object{Window1 translate<0.365, 0.14, -0.005>}
	  
	// 2nd floor
	object{Window1 translate<0.065, 0.47, -0.005>}
	object{Window1 translate<0.165, 0.47, -0.005>}
	object{Window1 translate<0.265, 0.47, -0.005>}
	object{Window1 translate<0.365, 0.47, -0.005>}
 
   	object{Ornament translate<0.02, 0.01, 0>}
   	object{Ornament translate<0.02, 0.34, 0>}
   	object{Ornament translate<0.02, 0.68, 0>}
   	
   	object{Bars translate<0.02, 0.1, 0>}
   	object{Bars translate<0.02, 0.43, 0>}
  	
	texture{FacadeTxt scale<0.5, 0.9, 1> translate<0, -0.1, 0>}
	texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}