#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house11/house11.jpg"
				map_type 0
			}
		}
		normal{
			bump_map{
				jpeg "houses/house11/house11.jpg"
				map_type 0
			}          
			bump_size 25*-5
		}
		finish{diffuse 0.65 phong 0}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare Ornament = union {
	torus{0.01, 0.005 rotate x*90 scale<1, 1, 0.4>}
	sphere{0, 0.0075 scale<1, 1, 0.4>}
	sphere{0, 0.01 scale<3, 1, 0.1>}
	sphere{0, 0.01 scale<2.5, 1, 0.16>}
	scale<1, 1, 2>
}

#declare Column = union {
	sphere{0, 0.005 scale<1, 0.7, 1>}
	sphere{0, 0.005 scale<1, 0.7, 1> translate y*0.035}
	sphere{0, 0.005 translate y*0.008}                 
	difference{
		sphere{0, 0.005 scale<1, 6, 1>}
		plane{y, 0}
		translate y*0.008
	}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.09 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.02 - 0.003/2, 0.004, 0>}
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.015 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.025 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.035 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.045 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.055 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.065 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.075 - 0.003/2, 0>} 

	object{Glass scale<0.03, 0.08, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.05, 0.205, 0.003> translate -z*0.003}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0, -0.005>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0.05, -0.005>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0.16, -0.005>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0.19, -0.005>}

	object{WindowFrame1 translate<0.005, 0.065, -0.0055>}
	translate z*0.002
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.06, 0.03> translate<0.0, 0, 0>}
	object{E5 scale<0.004, 0.06, 0.03> translate<0.02 - 0.002, 0, 0>}
	object{E5 scale<0.004, 0.06, 0.03> translate<0.04 - 0.004, 0, 0>}
	        
	object{E3 scale<0.032, 0.004, 0.03> translate<0.004, 0.0, 0>}
	object{E3 scale<0.032, 0.004, 0.03> translate<0.004, 0.02 - 0.002, 0>}
	object{E3 scale<0.032, 0.004, 0.03> translate<0.004, 0.04 - 0.002, 0>}
	object{E3 scale<0.032, 0.004, 0.03> translate<0.004, 0.06 - 0.004, 0>}
		
	object{Glass scale<0.038, 0.058, 1> translate<0.001, 0.001, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.05, 0.1, 0.003> translate<0, 0.01, -0.003>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0, -0.005>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0.09, -0.005>}
	object{E5 scale<0.06, 0.01, 0.005> translate<-0.005, 0.11, -0.005>}
	
	object{WindowFrame2 translate<0.005, 0.015, -0.0055>}
	translate z*0.002
}

#declare House11 = union {
	// facade
	object{E1 scale<0.62, 0.98, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.63, 0.01, 0.4> translate<-0.005, 0.88, -0.005>}
	object{E6 scale<0.64, 0.01, 0.4> translate<-0.01, 0.89, -0.01>}
	
	// columns
	object{E5 scale<0.02, 0.8, 0.003> translate<0.0, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.1, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.2, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.3, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.4, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.5, 0.08, -0.003>}
	object{E5 scale<0.02, 0.8, 0.003> translate<0.6, 0.08, -0.003>}

	// bars
	object{E5 scale<0.62, 0.03, 0.003> translate<0, 0.05, -0.003>}
	object{E5 scale<0.62, 0.01, 0.002> translate<0, 0.06, -0.005>}
	
	object{E5 scale<0.08, 0.03, 0.003> translate<0.02, 0.29, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.12, 0.29, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.22, 0.29, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.32, 0.29, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.42, 0.29, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.52, 0.29, -0.003>}
	object{E5 scale<0.62, 0.01, 0.002> translate<0, 0.3, -0.005>}
	
	object{E5 scale<0.08, 0.03, 0.003> translate<0.02, 0.37, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.12, 0.37, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.22, 0.37, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.32, 0.37, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.42, 0.37, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.52, 0.37, -0.003>}
	object{E5 scale<0.62, 0.01, 0.002> translate<0, 0.38, -0.005>}
	
	object{E5 scale<0.08, 0.03, 0.003> translate<0.02, 0.61, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.12, 0.61, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.22, 0.61, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.32, 0.61, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.42, 0.61, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.52, 0.61, -0.003>}
	object{E5 scale<0.62, 0.01, 0.002> translate<0, 0.62, -0.005>}
	
	object{E5 scale<0.08, 0.03, 0.003> translate<0.02, 0.69, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.12, 0.69, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.22, 0.69, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.32, 0.69, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.42, 0.69, -0.003>}
	object{E5 scale<0.08, 0.03, 0.003> translate<0.52, 0.69, -0.003>}
	object{E5 scale<0.62, 0.01, 0.002> translate<0, 0.70, -0.005>}
	
	// 1st floor
	object{Window1 translate<0.035, 0.08, 0>}
	object{Window1 translate<0.135, 0.08, 0>}
	object{Window1 translate<0.235, 0.08, 0>}
	object{Window1 translate<0.335, 0.08, 0>}
	object{Window1 translate<0.435, 0.08, 0>}
	object{Window1 translate<0.535, 0.08, 0>}
	  
	// 2nd floor
	object{Window1 translate<0.035, 0.4, 0>}
	object{Window1 translate<0.135, 0.4, 0>}
	object{Window1 translate<0.235, 0.4, 0>}
	object{Window1 translate<0.335, 0.4, 0>}
	object{Window1 translate<0.435, 0.4, 0>}
	object{Window1 translate<0.535, 0.4, 0>}
 
	// 3rd floor
	object{Window2 translate<0.035, 0.74, 0>}
	object{Window2 translate<0.135, 0.74, 0>}
	object{Window2 translate<0.235, 0.74, 0>}
	object{Window2 translate<0.335, 0.74, 0>}
	object{Window2 translate<0.435, 0.74, 0>}
	object{Window2 translate<0.535, 0.74, 0>}

   	object{Ornament translate<0.06, 0.345, 0>}
   	object{Ornament translate<0.16, 0.345, 0>}
   	object{Ornament translate<0.26, 0.345, 0>}
   	object{Ornament translate<0.36, 0.345, 0>}
   	object{Ornament translate<0.46, 0.345, 0>}
   	object{Ornament translate<0.56, 0.345, 0>}
   	
   	object{Ornament translate<0.06, 0.665, 0>}
   	object{Ornament translate<0.16, 0.665, 0>}
   	object{Ornament translate<0.26, 0.665, 0>}
   	object{Ornament translate<0.36, 0.665, 0>}
   	object{Ornament translate<0.46, 0.665, 0>}
   	object{Ornament translate<0.56, 0.665, 0>}
  	
	texture{FacadeTxt scale<0.64, 1, 1> translate<-0.01, -0.1, 0>}
}