/*
   ----------------          painted_capriccio_2.pov            ------------------------
   ----------------             30.September 2014               ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------  


        demonstrates render2paint method 2
        
        before you render this file, render "capriccio_NK.pov" and "capriccio_NK_depthmap.pov" first !

        render at +fn16 +w1700 +h2160  or multiples thereof - aspect ratio has to the same as in the base image
 
        for more details see http://news.povray.org/povray.binaries.images/thread/%3Cweb.54282b0a46a0060aabef77bb0%40news.povray.org%3E/         
                                                   
*/

#version 3.7;

global_settings {
        assumed_gamma 2.2
        max_trace_level 255
}

#include "stdinc.inc"
#include "functions.inc"

camera {
	orthographic
	location -z
	look_at  0
	right    x
	up       y
}

light_source {<0,0,-100000> color rgb 1}

background {rgb 1}

//___________________________________________________________________________________________________

#declare resol = 0.0005;                // take 0.001 or smaller for final (dependent on RAM and patience) / take 0.01 or something like that for test renders
                                        
#declare lseed = seed (0);
#declare f_img =                        // base image
function {
        pigment {
                image_map {             // an interpretation of the wonderful capriccio scene file (http://hof.povray.org/capriccio.html / http://news.povray.org/povray.general/thread/%3C3E814BA5.6C535F62%40mail.com%3E/)                                                                               
                        png "capriccio_NK.png"             // (original painting of William Marlow: http://www.tate.org.uk/art/images/work/N/N06/N06213_10.jpg)
                        interpolate 2 
                        once
                } 
                translate -0.5
        }
}

#declare HF =                           // depth map of the whole scene - render it with high resolution, no AA and at 16 bit resolution (e.g. +fn16) 
height_field {                          
	png "capriccio_NK_depthmap.png" 
        smooth
	translate <-0.5,-1,-0.5>
	rotate -90*x
        scale <1,1,100>
} 

#declare X = -0.5025;
#while (X < 0.5025)
	#declare Y = -0.5025;
	#while (Y < 0.5025)
                #declare Norm = <0,0,0>;
                #declare start = <X+RRand (-0.05,0.05,lseed)*resol,Y+RRand (-0.05,0.05,lseed)*resol,-20>;
                #declare Inter = trace (HF, start, z, Norm);
                #if (vlength (Norm) != 0)
                        #declare paint_pig = f_img (Inter.x,Inter.y,Inter.z);
                        object {
                                box {-1, 1}
                                scale RRand (0.5,lseed,1)*<1,1,0.5>
                                texture {
                                        pigment {
                                                marble
                                                turbulence 0.25
                                                scale RRand (1,2,lseed)
                                                color_map {
                                                        [0      paint_pig+0.03]
                                                        [1      paint_pig-0.03]
                                                }
                                                rotate <360*rand (lseed),360*rand (lseed),360*rand (lseed)>
                                        }
                                        finish {emission 0.3 diffuse 0.8}
                                        normal {bozo scale 0.25}
                                }
                                scale resol*0.7
                                Reorient_Trans (z,Norm)
                                #if (Inter.z > 98)
                                        rotate <RRand (-5,5,lseed),RRand (-5,5,lseed),RRand (-5,5,lseed)>
                                #end
                                translate Inter
                        }
		#end
		#declare Y = Y+resol*0.8;
	#end
        #debug concat ("ready: ",str ((X+0.5)*100,0,2)," %\n")
	#declare X = X+resol*0.8;
#end

