/*
   ----------------          painted_capriccio_1.pov            ------------------------
   ----------------             30.September 2014               ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------  


        demonstrate render2paint method 1
 
        render at +fn16 +w1700 +h2160  or multiples thereof - aspect ratio has to the same as in the base image
 
        for more details see http://news.povray.org/povray.binaries.images/thread/%3Cweb.54282b0a46a0060aabef77bb0%40news.povray.org%3E/         
                                                   
*/

#version 3.7;

global_settings {
        assumed_gamma 2.2
        max_trace_level 255
}

#include "stdinc.inc" 

#include "capriccio_NK_scene.inc"                                           // all scene objects have to be placed into a big union called "image_scene"   
                                                                            // you need the complete scene to shoot objects from camera location with a color derived from a former scene render
#declare cam_ang = 24;                                                      
#declare cam_loc = <0,1.5,-60>;                                             // camera settings have to be the same as in the original render
#declare lookat  = <0,9,0>;

camera {                                                                   
        location cam_loc
        right x*image_width/image_height
        up y
        look_at lookat 
        angle cam_ang                   
}  
                                                                           // from here on you calculate points, which fill the whole scene view area
#declare cam_mirror = 1;                                                   // -1, if camera right vector is negative
#declare back_dist = 1;                                                    // needed for "planting" from camera location
#declare cam_z = 0.5*image_width/image_height/tan (radians (cam_ang*0.5)); // amount of camera zoom
#declare cam_ang_up = degrees (2*atan2 (0.5/cam_z,1));                     // camera angle in cam_up direction                                               
#declare cam_a = cam_mirror*image_width/image_height;                      // camera aspect ratio
#declare cam_s = y;                                                        // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                              // camera direction vector
#declare cam_r = vnormalize (vcross (cam_s,cam_d));                        // camera right vector
#declare cam_up = vnormalize (vcross (cam_d,cam_r));                       // camera up vector
#declare cam_dir = cam_d*cam_z;                                            // direction vector scaled
#declare cam_right = cam_r*cam_a;                                          // right vector scaled

#declare fz = vlength (cam_dir);
#declare fx = vlength (cam_right)*0.5;
#declare fy = vlength (cam_up)*0.5; 

#macro OrientZ (p1,p2,cs)
        
#local nz = vnormalize (p2-p1);
#local nx = vnormalize (vcross (cs,nz)); 
#local ny = vcross (nz,nx);
matrix <nx.x,nx.y,nx.z,ny.x,ny.y,ny.z,nz.x,nz.y,nz.z,p1.x,p1.y,p1.z>
          
#end

#declare view_area =
union { 
        triangle {0,y,x+y}
        triangle {0,x,x+y}
        pigment {color rgb 1}
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc, lookat, cam_up) 
}

//___________________________________________________________________________________________________

#declare resol = 0.4;                                                   // take 0.1 for final (dependent on RAM and patience) / take 1 or something like that for test renders
                                                                        // the variable resol isn't comparable in both methods - in method 1 the resol value has to be about 100 times larger than in method 2
#declare sign_scale = resol*0.007;
#declare jitter_seed = seed (0);
#declare lseed = seed (0);
#declare jitter_fac = 0.4*resol;

#declare image_pig =
function { 
        pigment {            // an interpretation of the wonderful capriccio scene file (http://hof.povray.org/capriccio.html / http://news.povray.org/povray.general/thread/%3C3E814BA5.6C535F62%40mail.com%3E/)
                image_map {png "capriccio_NK" interpolate 2 once}                      // (original painting by William Marlow: http://www.tate.org.uk/art/images/work/N/N06/N06213_10.jpg)    
                translate <-0.5,-0.5,0>
                scale 2*<cam_mirror*fx,fy,0.5>
                translate fz*z
                scale back_dist
                OrientZ (cam_loc, lookat, cam_up)
        }
}

//___________________________________________________________________________________________________

#for (x_pos, -2, 102, resol)
        #for (y_pos, -2, 102, resol*image_width/image_height)
                #declare dir_y = vaxis_rotate (lookat-cam_loc,vcross (lookat-cam_loc,cam_up),(0.5-(y_pos+jitter_fac*(rand (jitter_seed)-0.5))*0.01)*cam_ang/image_width*image_height);    
                #declare dir_xy = vaxis_rotate (dir_y,cam_up,(0.5-(x_pos+jitter_fac*(rand (jitter_seed)-0.5))*0.01)*cam_mirror*cam_ang);            
                #declare Norm1 = <0,0,0>;
                #declare Inter1 = trace (view_area, cam_loc, dir_xy, Norm1);
                #declare Norm = <0,0,0>;
                #declare Inter = trace (image_scene, cam_loc, dir_xy, Norm);
                #if ((vlength (Norm1) != 0) & (vlength (Norm) != 0))
                        #declare paint_pig = image_pig (Inter1.x,Inter1.y,Inter1.z);
                        object {
                                box {-1, 1}
                                scale RRand (0.5,1,lseed)*<1,0.5,1>
                                texture {
                                        pigment {
                                                marble
                                                turbulence 0.25
                                                scale RRand (1,2,lseed)
                                                color_map {
                                                        [0      paint_pig+0.02]
                                                        [1      paint_pig-0.02]
                                                }
                                                rotate <360*rand (lseed),360*rand (lseed),360*rand (lseed)>
                                        }
                                        finish {emission 0.4 diffuse 1 specular 0 roughness 0.01 metallic 0.7}
                                        normal {bozo scale 0.25}
                                }
                                scale sign_scale*vlength (cam_loc-Inter)
                                Reorient_Trans (y,Norm)
                                translate Inter
                        }
                #end
        #end
        #debug concat ("ready: ",str (x_pos,0,2)," %\n")
#end

light_source {cam_loc color rgb 1}
background {rgb 1}