// Persistence of Vision Ray Tracer Scene Description File
// File: water.inc
// Desc: water setup for capricio scene
// Date: March 2003
// Auth: Christoph Hormann

#include "functions.inc"

#declare fn_RMF=
  function {
    f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)
  }

#declare M_Water_1 =
material {
  texture {
    pigment {
      color rgbft <0.83, 0.85, 0.7, 0.6, 0.6>
    }
    finish {
      diffuse 0.15
      ambient 0.0

      reflection {
        0.02, 1.0
        fresnel on
      }

      conserve_energy

      specular 0.4
      roughness 0.003
    }
    normal {
      bozo 0.65
      //function { fn_RMF(x, y, z) } 0.5
      scale 0.2
    }

  }
  interior {
    ior 1.33

    media {
      absorption <1.0,0.95,1.4>*1.5
      scattering {1 <0.5,0.6,0.48>*1.65 extinction 0.2}
    }
  }
}

box {
  <-160, -3, -160>, <160, 0, 160>

  material {
    M_Water_1
  }

  hollow on
  scale 0.9
}

plane {
  y, -0.8
  texture {
    pigment { color rgb <1,1,0.8>*0.5 }
    finish { ambient 0 diffuse 0.6 }
  }
}

