// Persistence Of Vision Ray Tracer Include File
// -------------------------------------------------------
// File: @(#)steps.inc
// Desciption: steps for capriccio scene
// Creation Date: $ 03 May 2003, 21:40:22 $
// Last modified: $ 18 May 2003, 13:05:42 $
// Author: Christoph Hormann
//

box {
        <-15,-1,-61>,<11,-10,-60.5>
        pigment {color rgb 0}
}

#include "math.inc"
#include "transforms.inc" 

#declare showHelpers = off;
#declare test_version = off;

#declare Step_Point_Cnt=9;
#declare Step_Brick_Length=0.4;

#declare verkuerz = 0.83;

#declare Steps_Point=array[Step_Point_Cnt]
  
#declare Steps_Point[0] = <4.40, 0, -49.0+(-49.0+42)*(verkuerz-1)>;
#declare Steps_Point[1] = <2.70, 0, -42.0+(-42.0+42)*(verkuerz-1)>;
#declare Steps_Point[2] = <1.00, 0, -44.0+(-44.0+42)*(verkuerz-1)>;
#declare Steps_Point[3] = <1.72, 0, -46.5+(-46.5+42)*(verkuerz-1)>;
#declare Steps_Point[4] = <1.84, 0, -49.3+(-49.3+42)*(verkuerz-1)>;
#declare Steps_Point[5] = <0.50, 0, -53.0+(-53.0+42)*(verkuerz-1)>;
#declare Steps_Point[6] = <-0.5, 0, -54.5+(-54.5+42)*(verkuerz-1)>;
#declare Steps_Point[7] = <-1.0, 0, -56.0+(-56.0+42)*(verkuerz-1)>;
#declare Steps_Point[8] = <5.00, 0, -56.1+(-56.1+42)*(verkuerz-1)>;

#declare VCorner=array[Step_Point_Cnt]
#declare AngleCorner=array[Step_Point_Cnt]
  
#declare Rough_Depth=0.065;  

#macro GammaColor(Color,Gamma)
    rgb <pow(Color.red,Gamma),pow(Color.green,Gamma),pow(Color.blue,Gamma)>
#end

#declare GammaFact=0.95/1.6;

#declare Pig_01=
  pigment {
    granite
    color_map {
    [ 0.0 GammaColor(<-0.1+0.52066, 0.28444+0.02, 0.1477+0.1>, GammaFact) ]
    [ 0.07143 GammaColor(<-0.1+0.46559, 0.27319+0.02, 0.16636+0.1>, GammaFact) ]
    [ 0.14286 GammaColor(<-0.1+0.27864, 0.18743+0.02, 0.11466+0.1>, GammaFact) ]
    [ 0.21429 GammaColor(<-0.1+0.24256, 0.11145+0.02, 0.04878+0.1>, GammaFact) ]
    [ 0.28571 GammaColor(<-0.1+0.52103, 0.29214+0.02, 0.16361+0.1>, GammaFact) ]
    [ 0.35714 GammaColor(<-0.1+0.49678, 0.25704+0.02, 0.11819+0.1>, GammaFact) ]
    [ 0.42857 GammaColor(<-0.1+0.46407, 0.23744+0.02, 0.09539+0.1>, GammaFact) ]
    [ 0.5 GammaColor(<-0.1+0.4901, 0.25791+0.02, 0.08423+0.1>, GammaFact) ]
    [ 0.57143 GammaColor(<-0.1+0.32481, 0.20354+0.02, 0.11417+0.1>, GammaFact) ]
    [ 0.64286 GammaColor(<-0.1+0.25754, 0.11627+0.02, 0.04027+0.1>, GammaFact) ]
    [ 0.71429 GammaColor(<-0.1+0.71489, 0.36262+0.02, 0.19439+0.1>, GammaFact) ]
    [ 0.78571 GammaColor(<-0.1+0.60619, 0.27694+0.02, 0.12174+0.1>, GammaFact) ]
    [ 0.85714 GammaColor(<-0.1+0.52414, 0.226+0.02, 0.10211+0.1>, GammaFact) ]
    [ 0.92857 GammaColor(<-0.1+0.6355, 0.26683+0.02, 0.11801+0.1>, GammaFact) ]
    [ 1.0 GammaColor(<-0.1+0.48726, 0.22516+0.02, 0.09356+0.1>, GammaFact) ]
    }
    scale 3.6
  }

#declare Pig_02=
  pigment {
    granite
    color_map {
    [ 0.0 GammaColor(<-0.1+0.71751, 0.46027+0.02, 0.21413+0.1>, GammaFact) ]
    [ 0.07143 GammaColor(<-0.1+0.67224, 0.35562+0.02, 0.13393+0.1>, GammaFact) ]
    [ 0.14286 GammaColor(<-0.1+0.50723, 0.27805+0.02, 0.13057+0.1>, GammaFact) ]
    [ 0.21429 GammaColor(<-0.1+0.70768, 0.40683+0.02, 0.19828+0.1>, GammaFact) ]
    [ 0.28571 GammaColor(<-0.1+0.55962, 0.34056+0.02, 0.17378+0.1>, GammaFact) ]
    [ 0.35714 GammaColor(<-0.1+0.56063, 0.38891+0.02, 0.17916+0.1>, GammaFact) ]
    [ 0.42857 GammaColor(<-0.1+0.5355, 0.36126+0.02, 0.17454+0.1>, GammaFact) ]
    [ 0.5 GammaColor(<-0.1+0.69465, 0.45514+0.02, 0.22346+0.1>, GammaFact) ]
    [ 0.57143 GammaColor(<-0.1+0.55314, 0.38382+0.02, 0.16846+0.1>, GammaFact) ]
    [ 0.64286 GammaColor(<-0.1+0.54368, 0.36618+0.02, 0.1804+0.1>, GammaFact) ]
    [ 0.71429 GammaColor(<-0.1+0.6931, 0.49904+0.02, 0.26604+0.1>, GammaFact) ]
    [ 0.78571 GammaColor(<-0.1+0.46422, 0.31843+0.02, 0.13066+0.1>, GammaFact) ]
    [ 0.85714 GammaColor(<-0.1+0.57314, 0.3437+0.02, 0.17707+0.1>, GammaFact) ]
    [ 0.92857 GammaColor(<-0.1+0.65285, 0.41853+0.02, 0.20013+0.1>, GammaFact) ]
    [ 1.0 GammaColor(<-0.1+0.53778, 0.37426+0.02, 0.19291+0.1>, GammaFact) ]
    }
    scale 3.2
    translate 2
  }    

#declare Pig_03=
  pigment {
    granite
    color_map {
    [ 0.0 GammaColor(<-0.1+0.29287, 0.17938+0.02, 0.10341+0.1>, GammaFact) ]
    [ 0.07143 GammaColor(<-0.1+0.23964, 0.13832+0.02, 0.07289+0.1>, GammaFact) ]
    [ 0.14286 GammaColor(<-0.1+0.25385, 0.14917+0.02, 0.08083+0.1>, GammaFact) ]
    [ 0.21429 GammaColor(<-0.1+0.34498, 0.20143+0.02, 0.11958+0.1>, GammaFact) ]
    [ 0.28571 GammaColor(<-0.1+0.36164, 0.20929+0.02, 0.12449+0.1>, GammaFact) ]
    [ 0.35714 GammaColor(<-0.1+0.38888, 0.21961+0.02, 0.12963+0.1>, GammaFact) ]
    [ 0.42857 GammaColor(<-0.1+0.36847, 0.20522+0.02, 0.09958+0.1>, GammaFact) ]
    [ 0.5 GammaColor(<-0.1+0.38522, 0.21882+0.02, 0.10797+0.1>, GammaFact) ]
    [ 0.57143 GammaColor(<-0.1+0.45191, 0.27154+0.02, 0.14464+0.1>, GammaFact) ]
    [ 0.64286 GammaColor(<-0.1+0.50905, 0.3153+0.02, 0.17443+0.1>, GammaFact) ]
    [ 0.71429 GammaColor(<-0.1+0.4551, 0.25922+0.02, 0.12858+0.1>, GammaFact) ]
    [ 0.78571 GammaColor(<-0.1+0.5349, 0.31875+0.02, 0.16943+0.1>, GammaFact) ]
    [ 0.85714 GammaColor(<-0.1+0.36967, 0.19816+0.02, 0.09196+0.1>, GammaFact) ]
    [ 0.92857 GammaColor(<-0.1+0.31343, 0.18609+0.02, 0.08677+0.1>, GammaFact) ]
    [ 1.0 GammaColor(<-0.1+0.29287, 0.19291+0.02, 0.09598+0.1>, GammaFact) ]
    }
    scale 3.7
    translate -2    
  }

#declare Pig_04=
  pigment {
    granite
    color_map {
    [ 0.0 GammaColor(<-0.1+0.21413, 0.13017+0.02, 0.07322+0.1>, GammaFact) ]
    [ 0.07143 GammaColor(<-0.1+0.3027, 0.18578+0.02, 0.08556+0.1>, GammaFact) ]
    [ 0.14286 GammaColor(<-0.1+0.36446, 0.23921+0.02, 0.11877+0.1>, GammaFact) ]
    [ 0.21429 GammaColor(<-0.1+0.3827, 0.26144+0.02, 0.13418+0.1>, GammaFact) ]
    [ 0.28571 GammaColor(<-0.1+0.35759, 0.2357+0.02, 0.11218+0.1>, GammaFact) ]
    [ 0.35714 GammaColor(<-0.1+0.32796, 0.23012+0.02, 0.10482+0.1>, GammaFact) ]
    [ 0.42857 GammaColor(<-0.1+0.26221, 0.17819+0.02, 0.07189+0.1>, GammaFact) ]
    [ 0.5 GammaColor(<-0.1+0.27614, 0.1728+0.02, 0.06699+0.1>, GammaFact) ]
    [ 0.57143 GammaColor(<-0.1+0.31307, 0.19882+0.02, 0.08294+0.1>, GammaFact) ]
    [ 0.64286 GammaColor(<-0.1+0.32513, 0.20578+0.02, 0.0921+0.1>, GammaFact) ]
    [ 0.71429 GammaColor(<-0.1+0.29928, 0.18443+0.02, 0.08773+0.1>, GammaFact) ]
    [ 0.78571 GammaColor(<-0.1+0.23677, 0.14367+0.02, 0.06173+0.1>, GammaFact) ]
    [ 0.85714 GammaColor(<-0.1+0.24934, 0.1716+0.02, 0.07174+0.1>, GammaFact) ]
    [ 0.92857 GammaColor(<-0.1+0.33384, 0.22613+0.02, 0.10654+0.1>, GammaFact) ]
    [ 1.0 GammaColor(<-0.1+0.4036, 0.27614+0.02, 0.1447+0.1>, GammaFact) ]
    }
    scale 3
  }    

#declare Tex_Steps=
  texture {
    pigment {
      bozo
      pigment_map {        
        [0.35 Pig_02 ]
        [0.50 Pig_01 ]        
        [0.67 Pig_03 ]        
      }
      warp { 
        turbulence 0.68
        lambda 3
        omega 0.6
      }
      scale 0.5      
    }
    finish {
      diffuse 0.8*0.6
      specular 0.08
      brilliance 0.3
    }
  }

#declare Tex_Steps2=
  texture {
    pigment {
      bozo
      pigment_map {
        [0.15 Pig_03 ]
        [0.40 Pig_04 ]        
        [0.57 Pig_03 ]       
      }
      warp { 
        turbulence 0.8
        lambda 3
        omega 0.6
      }
      scale 0.5      
    }
    finish {
      diffuse 0.72*0.6
      specular 0.1
      brilliance 0.3
    }
  }

#local fn_Surface=
  function {
    pigment {
      bozo
      color_map {
        [0 rgb 0]
        [0.65 rgb 0.27]
        [1 rgb 1]
      }
      warp {
        turbulence 0.6
        lambda 2.7
        omega 0.65
      }
      scale 0.6
    }
  }  

  
#local Cnt=0;
  
#while (Cnt < Step_Point_Cnt)
    
  #if ((Cnt>0) & (Cnt < Step_Point_Cnt-1))
    #declare AngleCorner[Cnt]=VAngle(Steps_Point[Cnt]-Steps_Point[Cnt-1],
                                     Steps_Point[Cnt]-Steps_Point[Cnt+1]);
    #declare VCorner[Cnt]=vnormalize(
                            vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt-1])+
                            vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt+1])
                          );
      
    #if ((VCorner[Cnt].x>0.1) & (Steps_Point[Cnt].x<2))
      #declare VCorner[Cnt]=-VCorner[Cnt];
    #end
  #else
    #if (Cnt>0)
      #declare VCorner[Cnt]=vrotate(vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt-1]), 90*y);
    #else
      #declare VCorner[Cnt]=vrotate(vnormalize(Steps_Point[Cnt]-Steps_Point[Cnt+1]), -90*y);
    #end
    #declare AngleCorner[Cnt]=pi;
  #end
  
  #local Cnt=Cnt+1;
#end
  
union { 

  #local Start_Level=true;
  #local SSeed=seed(9);
  #local YPos=Step_Surface_Height;
  #local XPos=0;
  #while (YPos > -0.4)    
    
    #local Cnt=0;
    #while (Cnt < Step_Point_Cnt)
      
      #if (showHelpers)
        cylinder { Steps_Point[Cnt]-y, Steps_Point[Cnt]+Step_Surface_Height*y, 0.05  pigment { color rgb x } }
        cylinder { 0, VCorner[Cnt], 0.05  pigment { color rgb z } translate Steps_Point[Cnt]+Step_Surface_Height*y }
      #end
        
      #if (Cnt < Step_Point_Cnt-1)
        #local Seg_Length=vlength(Steps_Point[Cnt+1]-Steps_Point[Cnt]);
        intersection {
          
         #if (test_version)          
          box {              
            <XPos, -1, -2>, <XPos-Step_Depth, YPos, Seg_Length+2>
            Reorient_Trans(z, Steps_Point[Cnt+1]-Steps_Point[Cnt]) 
            texture { Tex_Steps translate rand(SSeed)*10 }
          }          
         #else
          merge {
            
            #if (Start_Level)
              #local ZPos=0;
              #local ZEnd=Seg_Length;
            #else
              #local ZPos=-2;   
              #local ZEnd=Seg_Length+2;
            #end
            
            #while (ZPos < ZEnd)  
                
              #local BLength=Step_Brick_Length*(1+0.2*(rand(SSeed)-0.5));
              #if (ZPos+BLength > ZEnd)
                #local BLength=ZEnd-ZPos;
              #end
              #local RndMove=rand(SSeed)*10;
                
              #local fn_Brick=
                function {
                  f_rounded_box(                      
                    x+Step_Depth*0.5, 
                    y+Step_Height*0.5, 
                    z-BLength*0.5, 
                    Step_Round,                      
                    Step_Depth*0.5, Step_Height*0.5, BLength*0.5 
                  ) 
                  -Rough_Depth*0.24
                  +fn_Surface(x, y+RndMove, z).red*Rough_Depth*1.35                    
                }
                
              isosurface {
                  
                function { fn_Brick(x, y, z) }
                  
                max_gradient 5
                  
                contained_by {  
                  box {                      
                    //<0, 0, 0>, <-Step_Depth, -Step_Height, BLength>
                    <Rough_Depth, Rough_Depth, -Rough_Depth>, 
                    <-Step_Depth-Rough_Depth, -Step_Height-Rough_Depth, BLength+Rough_Depth>                      
                  }
                }
                
                #if (YPos > 0)                 
                  texture { Tex_Steps translate rand(SSeed)*10 } 
                #else
                  texture { Tex_Steps2 translate rand(SSeed)*10 }                   
                #end
                
                translate <XPos, YPos, ZPos>
              }
                
              #undef fn_Brick
                
              #local ZPos=ZPos+BLength;
            #end 
            #if (YPos=Step_Surface_Height)
              box {              
                <XPos-Step_Round, -1, Step_Round>, <XPos-Step_Depth+Step_Round, YPos-Step_Round*3, Seg_Length-Step_Round>
              }    
            #else
              box {              
                <XPos-Step_Round, -1, Step_Round>, <XPos-Step_Depth+Step_Round, YPos-Step_Round, Seg_Length-Step_Round>
              }              
            #end
            Reorient_Trans(z, Steps_Point[Cnt+1]-Steps_Point[Cnt])     
          }
         #end
          plane {   
            VCorner[Cnt], 0
            rotate 90*y
            #if (showHelpers)
              pigment { color rgb z } 
            #end
          }             
          plane { 
            VCorner[Cnt+1], 0
            rotate -90*y
            translate Seg_Length*vnormalize(Steps_Point[Cnt+1]-Steps_Point[Cnt])
            #if (showHelpers)
              pigment { color rgb x } 
            #end
          }  
          translate Steps_Point[Cnt]
        }
      #end 
      
      #local Cnt=Cnt+1;
    #end  
    
    #local YPos=YPos-Step_Height;
    #local XPos=XPos+Step_Depth;
    #if (Start_Level)
      #local Start_Level=false;
    #end
  #end 
  
  intersection {
  
    prism {                                
      linear_sweep 
      linear_spline 
      Step_Surface_Height-0.1,  
      Step_Surface_Height+0.1,
      Step_Point_Cnt 
      
      #local Cnt=0;
      #while (Cnt < Step_Point_Cnt)
        #local Point=Steps_Point[Cnt]-VCorner[Cnt]*Step_Depth*0.5;
        
        ,<Point.x, Point.z>
        #local Cnt=Cnt+1;
      #end         
    }
    
    
    #if (test_version) 
      
      plane {
        y, Step_Surface_Height-Step_Round*1
      }
      
    #else
    
      #local fn_Plane=
        function {
          y
          +fn_Surface(x, y, z).red*Rough_Depth                    
        }
    
      isosurface {
      
        function { fn_Plane(x, y, z) }
                  
        max_gradient 5
                  
        contained_by {  
          box {                      
            <-1, -0.1, -40>, 
            <5, 0.01, -55>                      
          }
        }      
        
        translate (Step_Surface_Height-Step_Round*0.7)*y
      }
    #end
  } 
    
  texture { Tex_Steps2 }
  
  translate <0.1, 0, -1.2> 
}

