#local BarkP = color rgb<0.56, 0.4, 0.3>*2;  
#local Bark = texture {
	pigment{
		wrinkles
		turbulence 0.2
		color_map {
			[0 color BarkP*0.6]
			[0.6 color BarkP*0.8]
		}
		scale<0.1, 0.4, 0.1>
	}
	finish {diffuse 0.5 phong 0}
}
texture {
	pigment{
		wrinkles
		turbulence 0.25
		color_map {
			[0 rgb 0.8]
			[0.6 rgbt<0, 0, 0, 1>]
		}
		scale<0.2, 0.7, 0.2>
	}
	finish {diffuse 0.5 phong 0}
}
texture {
	pigment{
		wrinkles
		turbulence 0.2
		color_map {
			[0 rgb<0.21, 0.25, 0.17>*3]
			[0.6 rgbt<0, 0, 0, 1>]
		}
		scale<0.1, 0.6, 0.1>
		rotate y*45
	}
	finish {diffuse 0.5 phong 0}
}

#macro Post(baseRadius, topRadius, heightY)
	#local P = pigment{
		wrinkles
		turbulence 0.1
		color_map {
			[0 rgb 1]
			[0.55 rgb 0]
		}
		scale 0.16
	}
	#local F = function{
		pigment{P}	
	}
	
	#local F1 = function {x*x + z*z - (baseRadius * baseRadius) + ((baseRadius - topRadius) * y) + F(x*2, heightY * 0.3 * y, z*2).grey*0.05}
	
	isosurface {
		function{F1(x, y/heightY, z)}
		max_gradient 5
		#if(baseRadius > topRadius)
			contained_by{box{<-baseRadius*1.1, 0, -baseRadius*1.1>, <baseRadius*1.1, heightY, baseRadius*1.1>}}
		#else
			contained_by{box{<-topRadius*1.1, 0, -topRadius*1.1>, <topRadius*1.1, heightY, topRadius*1.1>}}
		#end
	}
#end

#local P11=function{pattern{wood turbulence 0.03 scale 0.01 translate<0.5, 0.5, 0>}}
#local P12=function{pattern{wrinkles turbulence 0.3 scale<0.1, 0.02, 0.1>}}
#local HF1 = height_field {
	function 300, 300 
	{P11(x, y, z)*0.3 + P12(x, y, z)}
	translate <-0.5, 0, -0.5>
	scale <3, 0.05, 3>
}	
#declare Post1 = intersection {
	object{Post(0.6, 0.7, 10)}
	object{HF1 rotate -z*16 translate y*9}
	texture{Bark}
	scale 0.15
}

#local P21=function{pattern{wood turbulence 0.04 scale<0.01, 0.01, 1> translate<0.5, 0.5, 0>}}
#local P22=function{pattern{wrinkles turbulence 0.4 scale<1, 1, 7> translate<-0.4, -0.4, 0>}}
#local HF2 = height_field {
	function 300, 300 
	{P21(x, y, z)/50 +
	P22(x, y, z)
	}
	translate <-0.5, 0, -0.5>
	scale<3, 1, 3>
}	
#declare Post2 = intersection {
	object{Post(0.6, 0.8, 10)}
	object{HF2 translate y*6}
	texture{Bark}
	scale 0.15
}

#local P3=function{pattern{wrinkles turbulence 0.1 scale<0.5, 0.5, 0.5> translate<-0.6, 0, 0>}}
#local HF3 = height_field {
	function 300, 300 
	{P3(x, y, z)}
	translate <-0.5, 0, -0.5>
	scale<3, 5, 3>
}	
#declare Post3 = intersection {
	object{Post(0.6, 0.8, 10)}
	object{HF3 translate y*6}
	texture{Bark}
	scale 0.15
}


   