/*
   ----------------           capriccio_NK_scene.inc            ------------------------
   ----------------             30.September 2014               ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------  


        demonstrate render2paint method 1
 
        for details see http://news.povray.org/povray.binaries.images/thread/%3Cweb.54282b0a46a0060aabef77bb0%40news.povray.org%3E/ 
        this file is a modification of the wonderful capriccio scene (http://hof.povray.org/capriccio.html / http://news.povray.org/povray.general/thread/%3C3E814BA5.6C535F62%40mail.com%3E/)        
                                                   
*/

#declare reverse = 
transform {
	matrix <
	       -1,0,0,
		0,1,0,
		0,0,1,
		0,0,0 >  
}

#declare image_scene =          // start image_scene union
union {


   #include "cathedral/Stpaul2.inc" 
	union {
			#include "colors.inc"
			#include "metals.inc"
			object {StPaulsDome}

			#include "colors.inc"
			#include "metals.inc"
			object {StPaulsFacade}
		scale 0.0246 rotate -14*y translate <-12,0,220>
	}


#macro MediaSampleParams() method 3 samples 12*3 jitter 0.5 #end

#declare atm_shell=
sphere{
 0, 100
 scale <1,0.039999,1>
 hollow
 pigment {rgbt 1}
}

object {atm_shell translate y*5 scale 200}

#declare cloud_shell=
difference {
        sphere {-y*(10e5), 10e5+2.17}
        sphere {-y*(10e5), 10e5+2} 
        hollow
        pigment {rgbt 1} 
}

object {cloud_shell translate y*5 scale 200}


#declare M_Water_1 =
material {
  texture {
    pigment {
      color rgbft <0.83, 0.85, 0.7+0.05, 0.6, 0.6>
    }
    finish {
      diffuse 0.15
      ambient 0.0
      specular 0.4
      roughness 0.003
    }
    normal {
      bozo 0.65
      scale 0.2
    }

  }
}

box {
  <-160, -3, -160>, <160, 0, 160>

  material {
    M_Water_1
  }

  hollow on
  scale 0.9
}

plane {
  y, -0.8
  texture {
    pigment { color rgb 0.5 }
    finish { ambient 0 diffuse 0.6 }
  }
}




#local widthHouse1 = 2.4;
#local widthHouse2 = 4.3;
#local widthHouse3 = 4;
#local widthHouse4 = 4;
#local widthHouse5 = 5;
#local widthHouse6 = 5;
#local widthHouse7 = 5;
#local widthHouse8 = 4;
#local widthHouse9 = 5;
#local widthHouse10 = 4;

union {
	// 1
		#include "houses/house1/house1.inc"
		object {House1 scale 10 translate <0, 0, 0.44>}

	// 2
	#local shift2 = widthHouse1;
		#include "houses/house2/house2.inc"
		object{House2 scale 10 translate <shift2, 0, 0.4>}

	// 3
	#local shift3 = shift2 + widthHouse2;
		#include "houses/house3/house3.inc"
		object {House3 scale 10 rotate -y*4 translate <shift3, 0, 0.5>}

	// 4
	#local shift4 = shift3 + widthHouse3;
		#include "houses/house4/house4.inc"
		object {House4 scale 10 rotate y*10 translate <shift4, 0.4, 1.6>}

	// 5
	#local shift5 = shift4 + widthHouse4;
		#include "houses/house5/house5.inc"
		object {House5 scale 10 translate <shift5, 0, 0.7>}

        // 6
        #local shift6 = shift5 + widthHouse5;
		#include "houses/house6/house6.inc"
		object {House6 scale 10 translate <shift6, 0, 0.6>}

	// 7
	#local shift7 = shift6 + widthHouse6;
		#include "houses/house7/house7.inc"
		object {House7 scale 10 translate <shift7, 0, 0.7>}

	// 8
	#local shift8 = shift7 + widthHouse7;
		#include "houses/house8/house8.inc"
		object {House8 scale 10 translate <shift8, 0, 0.9>}

	// 9
	#local shift9 = shift8 + widthHouse8;
		#include "houses/house9/house9.inc"
		object {House9 scale 10 rotate -y*3 translate <shift9, 0, 0.8>}

	// 10
	#local shift10 = shift9 + widthHouse9;
		#include "houses/house10/house10.inc"
		object {House10 scale 10 rotate -y*3 translate <shift10, 0, 1>}
	
	//_________________________________________________________________________
	// 4
	#local widthHouse13 = 5.0;
	//#local shift11 = shift10 + widthHouse4;
		#include "houses/house13/house13.inc"
		object {House13 scale 10 rotate -y*6 translate <-widthHouse13, 0, -0.05>}
	//_________________________________________________________________________

	rotate -y*81 
	translate <-5.5, 0, -35>
}


#local widthHouse11 = 6.2;
#local widthHouse12 = 5.0;
#local widthHouse13 = 5.0;
#local widthHouse14 = 6.0;
#local widthHouse15 = 5.0;
#local widthHouse16 = 4.0;

union {
	// 11
	#local shift11 = widthHouse11;
		#include "houses/house11/house11.inc"
		object {House11 rotate y*80 scale 10 translate z*shift11}
	
	// 12
	#local shift12 = shift11 + widthHouse12;
		#include "houses/house12/house12.inc"
		object {House12 rotate y*90 scale 10 translate<0.1, 0, shift12>}
	
	// 13
	#local shift13 = shift12 + widthHouse13;
		//#include "houses/house13/house13.inc"
		object {House13 rotate y*90 scale 10 translate<0, -0.2, shift13>}

	// 14
	#local shift14 = shift13 + widthHouse14;
		#include "houses/house14/house14.inc"
		object {House14 rotate y*90 scale 10 translate<0.1, -0.2, shift14>}
	
	// 15
	#local shift15 = shift14 + widthHouse15;
		#include "houses/house15/house15.inc"
		object {House15 rotate y*90 scale 10 translate<0, -0.2, shift15>}
	
	// 16
	#local shift16 = shift15 + widthHouse16;
		#include "houses/house16/house16.inc"
		object {House16 rotate y*90 scale 10 translate<0, -0.2, shift16>}

        //_________________________________________________________________________
	// 17
		object {House7 rotate y*80 scale 10 translate <1,0.1,0.2>}
	//_________________________________________________________________________
	
	// 16
	#local shift16 = shift15 + widthHouse16;
		object {House16 rotate y*90 scale 10 translate <1,0,-16.5>}
		object {House16 rotate y*90 scale 10 translate <1,5,-16.5>}
		object {House16 rotate y*90 scale 10 translate <1,0,-20.5>}
		object {House16 rotate y*90 scale 10 translate <1,5,-20.5>}
        //_________________________________________________________________________
	
	rotate -y*0
	translate <6.3, 0, -32.5>
}



#declare Step_Depth=0.25;
#declare Step_Height=0.15;
#declare Step_Round=0.01;
#declare Step_Surface_Height=0.7;


	#include "figures/manOnSlip.inc"
	object{ 
          manOnSlip transform { reverse } rotate y*-30 scale<0.13, 0.12, 0.13> 
          translate < 2.0+0.12,  Step_Surface_Height-Step_Round*0.7, -47.0 >
        }
 
	#include "figures/womanOnSteps.inc"            
	object{ 
          womanOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53+0.12,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }

	#include "figures/childOnSteps.inc"             
	object{ 
          childOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53+0.12,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }

        #include "figures/manInBoat.inc"
        object{ manInBoat transform { reverse } rotate y*-90 scale 0.11 
        //translate <-1, .05,-38>}
        translate <-1.2, .05,-38>}


	#include "figures/figureOnProw.inc"
	#include "figures/rope.inc"             
	object{ figureOnProw 
		transform { reverse } 
		rotate y*105 scale 0.10 
		translate <-3.5, 0.25, -42.5> //<-2.7, 0.25, -46.7>
	}
	object{
		Rope scale 0.1 translate <-3.4, 0.28, -42.5>
		texture{
			pigment{color rgb<0.5, 0.4, 0.3>} 
			finish {diffuse 0.7}
			normal{bumps 0.35 scale 0.002}
		}
	} 

 

	#include "env/steps3.inc"


	#include "env/posts.inc"
    object {
    	Post1
    	rotate <-15, 0, 7>
    	translate <-1.1, -1.14, -47.3> //<-1.1, -1.15, -49.8>
    }
    object {
    	Post2
    	rotate -y*100
    	rotate <-30, -30, 0>
    	translate <-0.3, -0.16, -47.3> //<-0.3, -0.3, -49.5>
    } 
    object {
    	Post3
    	//rotate -y*80
    	rotate <-5, 0, 8>
    	translate <0.8, -0.2, -43> //<0.8, -0.4, -43>
    }



	#include "boats/boat1/boat_1.inc" 
    object {
    	boat_1
    	scale .25
    	rotate <-10,25,-5>
    	translate <-1.2, -.05, -38> // <-1, -.05, -38>
    } 

	#include "boats/boat2/boat_2.inc"
	object {
		boat_2 
		scale 0.1 
		rotate <-7.0, -15.0, 0.0>
		translate <-4.4, 0.0, -42.5>  
	}

	#include "boats/boat3/boat3.inc"
	object {
		Boat3
		translate -y*0.2 
		scale 0.36 //0.3
		rotate -y*40
		translate <-2.8, 0, -21>
	}

	#include "boats/boat4/boat4.inc"
	object {
		Boat4
		translate -y*0.1 
		scale 0.7
		rotate -y*74
		translate <-1.8, 0, -14.0>
	}

	#include "boats/boat5/boat5.inc"
	object {
		Boat5
		translate -y*0.2 
		scale 0.4
		rotate -y*45
		translate <-0.6, 0, -15>
	}

	#include "boats/boat6/boat6.inc"
	object {
		Boat6
		translate -y*0.2 
		scale 0.6
		rotate -y*75  
		translate <-0.2, 0, -12>
	}

	#include "boats/boat7/boat7.inc"
	object {
		Boat7
		translate -y*0.2 
		scale 0.55   
		rotate -x*5
		rotate -y*80
		translate <0.4, 0, -1>
	}

	#include "boats/boat8/boat8.inc"
	object {
		Boat8
		translate -y*0.2 
		scale 0.5  
		rotate x*8
		rotate -y*65
		translate <1.5, 0, -6>
	}
  
	#include "boats/boat9/boat9.inc"
	object {
		Boat9
		translate -y*0.2 
		scale 0.35
		rotate -y*60
		translate <1.8, 0, -7.8>
	}

	#include "boats/boat10/boat10.inc"
	object {
		Boat10
		translate -y*0.2 
		scale 0.35
		rotate -y*45
		translate <2.5, 0, 2>
	}

	#include "boats/boat11/boat11.inc"
	object {
		Boat11
		translate -y*0.1 
		scale 0.7
		rotate -y*45
		translate <1.5, 0, -41>
	}


	#include "boats/boat12/boat12.inc"
	object {
		Boat12
		translate -y*0.2 
		scale 0.7 
		rotate -x*5
		rotate y*70
		translate <4.5, 0, -35>
	}

	#include "boats/boat13/boat13.inc"
	object {
		Boat13
		translate -y*0.2 
		scale 0.5
		rotate y*75
		translate <5.3, 0, -20.5>
	}

	union {
		box{<-30, -0.1, 10>, <30, 0.03, 200>}
		box{<-30, 0.03, 13>, <30, 0.08, 200>}
		box{<-30, 0.08, 16>, <30, 0.13, 200>}
			
		box{<-30, 0, 40>, <30, 0.18, 200>}
		box{<-30, 0, 42>, <30, 0.23, 200>}
		box{<-30, 0, 44>, <30, 0.28, 200>}
		box{<-30, 0, 46>, <30, 0.33, 200>}
			
		pigment{color rgb<0.17, 0.15, 0.15>*3}
		finish {diffuse 0.65}
		normal{bumps 0.8 scale <0.02, 0.007, 0.02>}      
	}
		
	#include "people/people.inc"
	   
	object{Man1 translate<2.7, 0.13, 19>}
	object{Woman1 translate<3.0, 0.08, 15>}
	object{Woman2 translate<3.3, 0.08, 15>}
	 
	
	object{Man3 translate<4.5, 0.08, 15>}
	object{Woman10 translate<4.8, 0.08, 15>}
	
	object{Man4 translate<6.5, 0.08, 15>}
	object{Woman8 translate<6.8, 0.08, 15>}
	
	object{Woman7 translate<7.5, 0.13, 18>}
	object{Man7 translate<8.0, 0.13, 18>}
	
	object{Woman6 translate<6.8, 0.13, 26>}
	object{Man8 translate<7.1, 0.13, 26>}
	
	object{Man2 translate<4.3, 0.13, 22>}
	object{Woman9 translate<4.7, 0.13, 24>}
	
	object{Man9 translate<10, 0.33, 53>}
	
	object{Woman3 translate<5, 0.33, 58>}

	object{Woman4 translate<9.4, 0.33, 50>}
	object{Man10 translate<7.4, 0.33, 50>}
	
	object{Woman5 translate<7, 0.33, 57>}
	object{Man6 translate<7.6, 0.33, 57>}
	
	object{Man5 translate<11, 0.33, 55>}
	object{Woman11 translate<11.4, 0.33, 55>}

}  // end image_scene union

