/*
   ----------------             capriccio-NK.pov                ------------------------
   ----------------             30.September 2014               ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------  


        needed to demonstrate render2paint methods - render e.g. at +fn16 +w1700 +h2160
 
        for the origin of this modified scene - see at http://hof.povray.org/capriccio.html         
                                                   and http://news.povray.org/povray.general/thread/%3C3E814BA5.6C535F62%40mail.com%3E/
*/

#version 3.7;

#include "stdinc.inc"

/************************************* Flags ****************************************/ 

#declare querformat = 3;  //___________________________________________________________

#declare showCathedral = 1;
#declare showDome = 1;
#declare showEntrance = 1;
#declare showSteps = 1;

#declare showLeftHouses = 1;
#declare showHouse1 = 1;
#declare showHouse2 = 1;
#declare showHouse3 = 1;
#declare showHouse4 = 1;
#declare showHouse5 = 1;
#declare showHouse6 = 1;
#declare showHouse7 = 1;
#declare showHouse8 = 1;
#declare showHouse9 = 1;
#declare showHouse10 = 1;

#declare showRightHouses = 1;
#declare showHouse11 = 1;
#declare showHouse12 = 1;
#declare showHouse13 = 1;
#declare showHouse14 = 1;
#declare showHouse15 = 1;
#declare showHouse16 = 1;

#declare showWater = 1;
#declare water_media = 1;//___________________________________________________
#declare showFog = 1;
#declare showMediaFog = 1;
#declare showClouds = 1;

#declare showIsoSlip = 1;
#declare showFigures = 1; 
#declare showManOnSlip = 1;   
#declare showWomanOnSteps = 1;
#declare showchildOnSteps = 1;    
#declare showmanInBoat = 1;
#declare showfigureOnProw = 1;

#declare showBoats = 1;
#declare showBoat1 = 1;
#declare showBoat2 = 1;
#declare showBoat3 = 1;
#declare showBoat4 = 1;
#declare showBoat5 = 1;
#declare showBoat6 = 1;
#declare showBoat7 = 1;
#declare showBoat8 = 1;
#declare showBoat9 = 1;
#declare showBoat10 = 1;
#declare showBoat11 = 1;
#declare showBoat12 = 1;
#declare showBoat13 = 1;

#declare showPosts = 1;

#declare use_Rad = 1;
#declare Rad_HQ = 1;//___________________________________________________________
#declare use_area_light = 1;//___________________________________________________

#declare Camera = 0;

//#declare Sun_Pos=vnormalize(<15, 8, 3>);
// Sun flags
#declare useSun = 0;
//#declare sunZenithAngle = 30;             // 0 - 90
//#declare sunAzimuthAngle = 75; // changed // 0 is north (direction <0, 0, 1>)
#declare sunZenithAngle = 45; // 57
#declare sunAzimuthAngle = 80+5; // 47
#declare sunLightColor = <1.9,1.75,1.5>*1.5;  // <2.0, 1.7, 1.3> * 0.8;
#declare sunSize = 10;                    // Angle
#declare sunLightShadowMinimumDetail = 0; // 0 - 9
#declare sunLightShadowMaximumDetail = 4; // 0 - 9

// sunLightShadowMinimumDetail must be less or equal than
// sunLightShadowMaximumDetail. If sunLightShadowMaximumDetail is
// greater than zero then sunLightShadowMinimumDetail must be greater
// than zero.

#declare sunLightInteractWithMedia = 1;
#declare sunPhotonsRefraction = off;
#declare sunPhotonsReflection = off;
#declare sunPhotonsAreaLight = off;


/********************************* global variables **********************************/

#declare reverse = 
transform {
	matrix <
	       -1,0,0,
		0,1,0,
		0,0,1,
		0,0,0 >  
}

/********************************* global_settings **********************************/

global_settings {
	max_trace_level 70
	assumed_gamma 2.8
	#if (use_Rad)
		radiosity {
			pretrace_start 0.08			
			#if (Rad_HQ)
			  pretrace_end   0.00125
			  count 300
			  nearest_count 8
			  error_bound 0.02
			#else
			  pretrace_end   0.016
			  count  40 //99 changed
			  nearest_count 1//5
			  error_bound 1 // 1.0 // changed
			#end
			recursion_limit 1 // 3
			low_error_factor 0.5
			gray_threshold 0.9 // 0.2 // changed
			minimum_reuse 0.015
			brightness 2.3-1.3 // changed
			normal on
			media off
		}
	#end
}

/************************************* Camera ***************************************/

#switch (Camera)
  #case (1)         // --- test view for foreground stairs ---
  
  camera {
    location <3,5,-60>
    right x*image_width/image_height
    up y
    look_at <2,0,-50>
    angle 32-2.5
  }     
    
  #break
#else
  
  camera {
    location <0, 1.5, -60>
    right x*image_width/image_height
    up y
    #if (querformat=1)          // 4x3
        look_at <0,8,0>
        angle 33.5 
    #end 
    #if (querformat=0)          // 3x4
        look_at <0,7.5,0>+<0,0.2,0> 
        angle 24               
    #end
    #if (querformat=2)          // square
        look_at <0,7.75,0> 
        angle (33.5+24)/2               
    #end 
    #if (querformat=3)          // 850*1080 similar to the original Marlow painting
        look_at <0,7.5,0>+<0,1.5,0> 
        angle 24               
    #end 
  }  

    #if (querformat=4)
    camera {                    // scene from above
        orthographic
        look_at <0,0,50> 
        //angle 24
        
        location <0, 1.5+200, 50>
        up z*250
        right -x*250*image_width/image_height
    }                
    #end
      
#end

/************************************* Lights ***************************************/

#if(useSun)
	#include "env/sun.inc"
#else
  light_source {
    y*10000
    color rgb <2,1.6,1.3>*1.15  //<2,1.65,1.125>*1.15   //<2,1.6,1>*0.7 //<2.0, 1.6, 1.3>       //*1.15

    #if (use_area_light)
      area_light 100*x 100*z  4,4
      adaptive 0
      jitter orient circular
    #end

    rotate <sunZenithAngle, 0, 0>
    rotate <0, sunAzimuthAngle, 0>
  }
#end

#if (!use_Rad)
  light_source {
    y*10000    
    color rgb <2,1.6,1.3>    
    rotate <sunZenithAngle, 0, 0>
    rotate <0, sunAzimuthAngle, 0>
  }
#end

/************************************* Cathedral ************************************/

#if(showCathedral)
   #include "cathedral/Stpaul2.inc" 
	union {
		#if(showDome)
			#include "colors.inc"
			#include "metals.inc"
			object {StPaulsDome}
		#end

		#if(showEntrance)
			#include "colors.inc"
			#include "metals.inc"
			object {StPaulsFacade}
		#end
		scale 0.0246 rotate -14*y translate <-12,0,220>
	}
#end

/**************************************** Sky ***************************************/

sky_sphere {
        pigment {
                gradient y
                color_map {
                        [0      rgb <113*0.8*1.75,162*0.975*1.45,220*1.15>/255] //<0.6-0.1,0.7-0.1,1.0>*0.8]
                        [0.5    rgb <113*0.4,162*0.7,220*1.1>/255*0.75]         //<104-100+70*0.2,155-30+170*0.2,202+210*0.2>/255*0.55]
                }
        }
}

#macro MediaSampleParams() method 3 samples 12*3 jitter 0.5 #end

#declare atm_shell=
sphere{
 0, 100
 scale <1,0.039999,1>
 hollow
 pigment {rgbt 1}
 interior{
  media{
   scattering {1 rgb 0.01*<1-0.2,0.8,0.6+0.2>/200 extinction 0}
  // absorption rgb 0.2 
   //emission rgb 0.025
   MediaSampleParams ()
  }
  media {
        scattering {3 rgb 0.00001*0.2/50 extinction 0}
        absorption rgb 0.05*<0.01+0.5,0.40+0.25,0.95>*0.2/200 
        emission rgb 0.03*<0.9529-0.25,0.9412-0.25,0.6863>*0.2/200
        MediaSampleParams ()
  }
 }
}

object {atm_shell translate y*5 scale 200}

#declare cloud_shell=
difference {
        sphere {-y*(10e5), 10e5+2.17}
        sphere {-y*(10e5), 10e5+2} 
        hollow
        pigment {rgbt 1} 
        interior {
                 media {
                        scattering {1, rgb 2*<0.9-0.3,0.95-0.25,1>/70*1.5 extinction 0}
                        absorption rgb 2/70*<0.5+0.5,0.75+0.25,1>*0.8*1.25  
                        emission rgb 0.5*<0.5-0.1,0.4,0.3+0.1>/18/4
                        MediaSampleParams()
                        density {
                                granite  
                                scale 50*0.33
                                scale 1/10 warp {turbulence 2 lambda 3 octaves 8} scale 10  
                                scale 2   
                                translate <-1,0,-1>
                                color_map {
                                        [0.59 rgb 0]
                                        [0.66 rgb 2.5]
                                }
                        }
                        density {
                                gradient z  
                                scale 150
                                scale 1/10 warp {turbulence 2 lambda 3 octaves 8} scale 10  
                                scale 2   
                                translate <0,0,-18>
                                color_map {
                                        [0.05 rgb <0,0.01,0.1>]
                                        [0.45 rgb 1]
                                }
                        }
                }
        }
}

#if (showClouds)

light_group { 
        object {cloud_shell translate y*5 scale 200}
        light_source {
                y*10000
                color rgb <2,1.65,1.125>*0.7//<2,1.6,1>*0.7//<2.0, 1.6, 1.3>//*1.15
                #if (use_area_light)
                        area_light 100*x 100*z  4,4
                        adaptive 0
                        jitter orient circular
                #end
                rotate <sunZenithAngle, 0, 0>
                rotate <0, sunAzimuthAngle, 0>
        }
        global_lights off
}
 
#end

/***************************************** Fog **************************************/

#if (showFog)
	fog {
		fog_type 2
		distance 1500
		color <0.6,0.75,0.9>
		fog_alt 10
		fog_offset 0
	}
#end

#if (showMediaFog)
sphere { 
        0, 300 
        pigment {color rgbt <1,1,1,1>}
        interior {
                media {        
                        scattering {5, 0.002*0.075*10 eccentricity 0.85 extinction 1}
                        method 3
                        intervals 1
                        samples 7  
                        density {
                                planar
                                poly_wave 2
                                color_map {
                                        [0      rgb 0]
                                        [1      rgb 1]
                                }
                                scale 20
                        }      
                }
        }
        hollow
}

#end

/*************************************** Water **************************************/

#if (showWater)

#declare M_Water_1 =
material {
  texture {
    pigment {
      color rgbft <0.83, 0.85, 0.7+0.05, 0.6, 0.6>
    }
    finish {
      diffuse 0.15
      ambient 0.0

      reflection {
        0.02, 1.0
        fresnel on
      }

      conserve_energy

      specular 0.4
      roughness 0.003
    }
    normal {
      bozo 0.65
      //function { fn_RMF(x, y, z) } 0.5
      scale 0.2
    }

  }
  interior {
    ior 1.33

    media {
      absorption <1.0,0.95,1.4-0.2>*1.5
      scattering {1 <0.5,0.6-0.05,0.48>*1.65 extinction 0.2}
    }
  }
}

box {
  <-160, -3, -160>, <160, 0, 160>

  material {
    M_Water_1
  }

  hollow on
  scale 0.9
}

plane {
  y, -0.8
  texture {
    pigment { color rgb 0.5 }
    finish { ambient 0 diffuse 0.6 }
  }
}

#end

/********************************* Houses. Left Side ********************************/ 

#local widthHouse1 = 2.4;
#local widthHouse2 = 4.3;
#local widthHouse3 = 4;
#local widthHouse4 = 4;
#local widthHouse5 = 5;
#local widthHouse6 = 5;
#local widthHouse7 = 5;
#local widthHouse8 = 4;
#local widthHouse9 = 5;
#local widthHouse10 = 4;

union {
	// 1
	#if(showLeftHouses & showHouse1)
		#include "houses/house1/house1.inc"
		object {House1 scale 10 translate <0, 0, 0.44>}
	#end

	// 2
	#local shift2 = widthHouse1;
	#if(showLeftHouses & showHouse2)
		#include "houses/house2/house2.inc"
		object{House2 scale 10 translate <shift2, 0, 0.4>}
	#end

	// 3
	#local shift3 = shift2 + widthHouse2;
	#if(showLeftHouses & showHouse3)
		#include "houses/house3/house3.inc"
		object {House3 scale 10 rotate -y*4 translate <shift3, 0, 0.5>}
	#end

	// 4
	#local shift4 = shift3 + widthHouse3;
	#if(showLeftHouses & showHouse4)
		#include "houses/house4/house4.inc"
		object {House4 scale 10 rotate y*10 translate <shift4, 0.4, 1.6>}
	#end

	// 5
	#local shift5 = shift4 + widthHouse4;
	#if(showLeftHouses & showHouse5)
		#include "houses/house5/house5.inc"
		object {House5 scale 10 translate <shift5, 0, 0.7>}
	#end

        // 6
        #local shift6 = shift5 + widthHouse5;
	#if(showLeftHouses & showHouse6)
		#include "houses/house6/house6.inc"
		object {House6 scale 10 translate <shift6, 0, 0.6>}
	#end

	// 7
	#local shift7 = shift6 + widthHouse6;
	#if(showLeftHouses & showHouse7)
		#include "houses/house7/house7.inc"
		object {House7 scale 10 translate <shift7, 0, 0.7>}
	#end

	// 8
	#local shift8 = shift7 + widthHouse7;
	#if(showLeftHouses & showHouse8)
		#include "houses/house8/house8.inc"
		object {House8 scale 10 translate <shift8, 0, 0.9>}
	#end

	// 9
	#local shift9 = shift8 + widthHouse8;
	#if(showLeftHouses & showHouse9)
		#include "houses/house9/house9.inc"
		object {House9 scale 10 rotate -y*3 translate <shift9, 0, 0.8>}
	#end

	// 10
	#local shift10 = shift9 + widthHouse9;
	#if(showLeftHouses & showHouse10)
		#include "houses/house10/house10.inc"
		object {House10 scale 10 rotate -y*3 translate <shift10, 0, 1>}
	#end
	
	//_________________________________________________________________________
	// 4
	#local widthHouse13 = 5.0;
	//#local shift11 = shift10 + widthHouse4;
	#if(showLeftHouses & showHouse4)
		#include "houses/house13/house13.inc"
		object {House13 scale 10 rotate -y*6 translate <-widthHouse13, 0, -0.05>}
	#end
	//_________________________________________________________________________

	rotate -y*81 
	translate <-5.5, 0, -35>
}


/********************************* Houses. Right Side ********************************/

#local widthHouse11 = 6.2;
#local widthHouse12 = 5.0;
#local widthHouse13 = 5.0;
#local widthHouse14 = 6.0;
#local widthHouse15 = 5.0;
#local widthHouse16 = 4.0;

union {
	// 11
	#local shift11 = widthHouse11;
	#if(showRightHouses & showHouse11)
		#include "houses/house11/house11.inc"
		object {House11 rotate y*80 scale 10 translate z*shift11}
	#end
	
	// 12
	#local shift12 = shift11 + widthHouse12;
	#if(showRightHouses & showHouse12)
		#include "houses/house12/house12.inc"
		object {House12 rotate y*90 scale 10 translate<0.1, 0, shift12>}
	#end
	
	// 13
	#local shift13 = shift12 + widthHouse13;
	#if(showRightHouses & showHouse13)
		//#include "houses/house13/house13.inc"
		object {House13 rotate y*90 scale 10 translate<0, -0.2, shift13>}
	#end

	// 14
	#local shift14 = shift13 + widthHouse14;
	#if(showRightHouses & showHouse14)
		#include "houses/house14/house14.inc"
		object {House14 rotate y*90 scale 10 translate<0.1, -0.2, shift14>}
	#end
	
	// 15
	#local shift15 = shift14 + widthHouse15;
	#if(showRightHouses & showHouse15)
		#include "houses/house15/house15.inc"
		object {House15 rotate y*90 scale 10 translate<0, -0.2, shift15>}
	#end
	
	// 16
	#local shift16 = shift15 + widthHouse16;
	#if(showRightHouses & showHouse16)
		#include "houses/house16/house16.inc"
		object {House16 rotate y*90 scale 10 translate<0, -0.2, shift16>}
	#end

        //_________________________________________________________________________
	// 17
	#if(showRightHouses & showHouse11)
		object {House7 rotate y*80 scale 10 translate <1,0.1,0.2>}
	#end        
	//_________________________________________________________________________
	
	// 16
	#local shift16 = shift15 + widthHouse16;
	#if(showRightHouses & showHouse16)
		object {House16 rotate y*90 scale 10 translate <1,0,-16.5>}
		object {House16 rotate y*90 scale 10 translate <1,5,-16.5>}
		object {House16 rotate y*90 scale 10 translate <1,0,-20.5>}
		object {House16 rotate y*90 scale 10 translate <1,5,-20.5>}
	#end
        //_________________________________________________________________________
	
	rotate -y*0
	translate <6.3, 0, -32.5>
}

/*********************************** Steps measures ***********************************/ 

#declare Step_Depth=0.25;
#declare Step_Height=0.15;
#declare Step_Round=0.01;
#declare Step_Surface_Height=0.7;

/*************************************** Figures **************************************/             

#if(showFigures & showManOnSlip)
	#include "figures/manOnSlip.inc"
	object{ 
          manOnSlip transform { reverse } rotate y*-30 scale<0.13, 0.12, 0.13> 
          translate < 2.0+0.12,  Step_Surface_Height-Step_Round*0.7, -47.0 >
        }
#end
 
#if(showFigures & showWomanOnSteps)
	#include "figures/womanOnSteps.inc"            
	object{ 
          womanOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53+0.12,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }
#end  

#if(showFigures & showchildOnSteps)
	#include "figures/childOnSteps.inc"             
	object{ 
          childOnSteps transform { reverse } rotate y*-32 scale 0.13 
          translate < 1.53+0.12,  Step_Surface_Height-Step_Height*2, -47.55 > 
        }
#end 

#if(showFigures & showmanInBoat)
        #include "figures/manInBoat.inc"
        object{ manInBoat transform { reverse } rotate y*-90 scale 0.11 
        //translate <-1, .05,-38>}
        translate <-1.2, .05,-38>}
#end 


#if(showFigures & showfigureOnProw)
	#include "figures/figureOnProw.inc"
	#include "figures/rope.inc"             
	object{ figureOnProw 
		transform { reverse } 
		rotate y*105 scale 0.10 
		translate <-3.5, 0.25, -42.5> //<-2.7, 0.25, -46.7>
	}
	object{
		Rope scale 0.1 translate <-3.4, 0.28, -42.5>
		texture{
			pigment{color rgb<0.5, 0.4, 0.3>} 
			finish {diffuse 0.7}
			normal{bumps 0.35 scale 0.002}
		}
	} 
#end
 
/************************************** Slip *****************************************/

#if(showIsoSlip)   
	#include "env/steps3.inc"
#else
  #declare slip =
    union {
      box { <-3,   -2, -12>,    <3,    0.2, 12> }  
      box { <-3.25,-2, -12.25>, <3.25, 0.2, 12.25>  translate y*-0.25 } 
      box { <-3.5, -2, -12.5>,  <3.5,  0.2, 12.5>   translate y*-0.5 }     
      box { <-3.75,-2, -12.75>, <3.75, 0.2, 12.75>  translate y*-0.75 }
      box { <-4,   -2, -13>,    <4,    0.2, 13>     translate y*-1 } 
        
    }
  
  union { 
        
    object { slip }
    object { slip rotate y*20 translate <-3.95,-0.00001,-0.5>   }       

    rotate -32*y              
    translate <10.4, 0.3, -54>
          
    translate -y*0.5
    scale <1, 0.5, 1>
    translate y*0.5 
           
    pigment { color rgb <0.75,0.7,0.6> }  
            
  }
#end

/**************************************** Posts ***************************************/

#if(showPosts)
	#include "env/posts.inc"
    object {
    	Post1
    	rotate <-15, 0, 7>
    	translate <-1.1, -1.14, -47.3> //<-1.1, -1.15, -49.8>
    }
    object {
    	Post2
    	rotate -y*100
    	rotate <-30, -30, 0>
    	translate <-0.3, -0.16, -47.3> //<-0.3, -0.3, -49.5>
    } 
    object {
    	Post3
    	//rotate -y*80
    	rotate <-5, 0, 8>
    	translate <0.8, -0.2, -43> //<0.8, -0.4, -43>
    }
#end

/**************************************** Boats ***************************************/ 

#if(showBoats & showBoat1)
	#include "boats/boat1/boat_1.inc" 
    object {
    	boat_1
    	scale .25
    	rotate <-10,25,-5>
    	translate <-1.2, -.05, -38> // <-1, -.05, -38>
    } 
#end

#if(showBoats & showBoat2)
	#include "boats/boat2/boat_2.inc"
	object {
		boat_2 
		scale 0.1 
		rotate <-7.0, -15.0, 0.0>
		translate <-4.4, 0.0, -42.5>  
	}
#end

#if(showBoats & showBoat3)
	#include "boats/boat3/boat3.inc"
	object {
		Boat3
		translate -y*0.2 
		scale 0.36 //0.3
		rotate -y*40
		translate <-2.8, 0, -21>
	}
#end

#if(showBoats & showBoat4)
	#include "boats/boat4/boat4.inc"
	object {
		Boat4
		translate -y*0.1 
		scale 0.7
		rotate -y*74
		translate <-1.8, 0, -14.0>
	}
#end

#if(showBoats & showBoat5)
	#include "boats/boat5/boat5.inc"
	object {
		Boat5
		translate -y*0.2 
		scale 0.4
		rotate -y*45
		translate <-0.6, 0, -15>
	}
#end

#if(showBoats & showBoat6)
	#include "boats/boat6/boat6.inc"
	object {
		Boat6
		translate -y*0.2 
		scale 0.6
		rotate -y*75  
		translate <-0.2, 0, -12>
	}
#end

#if(showBoats & showBoat7)
	#include "boats/boat7/boat7.inc"
	object {
		Boat7
		translate -y*0.2 
		scale 0.55   
		rotate -x*5
		rotate -y*80
		translate <0.4, 0, -1>
	}
#end

#if(showBoats & showBoat8)
	#include "boats/boat8/boat8.inc"
	object {
		Boat8
		translate -y*0.2 
		scale 0.5  
		rotate x*8
		rotate -y*65
		translate <1.5, 0, -6>
	}
#end
  
#if(showBoats & showBoat9)
	#include "boats/boat9/boat9.inc"
	object {
		Boat9
		translate -y*0.2 
		scale 0.35
		rotate -y*60
		translate <1.8, 0, -7.8>
	}
#end

#if(showBoats & showBoat10)
	#include "boats/boat10/boat10.inc"
	object {
		Boat10
		translate -y*0.2 
		scale 0.35
		rotate -y*45
		translate <2.5, 0, 2>
	}
#end

#if(showBoats & showBoat11)
	#include "boats/boat11/boat11.inc"
	object {
		Boat11
		translate -y*0.1 
		scale 0.7
		rotate -y*45
		translate <1.5, 0, -41>
	}
#end

#if(showBoats & showBoat12)
	#include "boats/boat12/boat12.inc"
	object {
		Boat12
		translate -y*0.2 
		scale 0.7 
		rotate -x*5
		rotate y*70
		translate <4.5, 0, -35>
	}
#end

#if(showBoats & showBoat13)
	#include "boats/boat13/boat13.inc"
	object {
		Boat13
		translate -y*0.2 
		scale 0.5
		rotate y*75
		translate <5.3, 0, -20.5>
	}
#end

#if(showSteps)
	union {
		box{<-30, -0.1, 10>, <30, 0.03, 200>}
		box{<-30, 0.03, 13>, <30, 0.08, 200>}
		box{<-30, 0.08, 16>, <30, 0.13, 200>}
			
		box{<-30, 0, 40>, <30, 0.18, 200>}
		box{<-30, 0, 42>, <30, 0.23, 200>}
		box{<-30, 0, 44>, <30, 0.28, 200>}
		box{<-30, 0, 46>, <30, 0.33, 200>}
			
		pigment{color rgb<0.17, 0.15, 0.15>*3}
		finish {diffuse 0.65}
		normal{bumps 0.8 scale <0.02, 0.007, 0.02>}      
	}
		
	#include "people/people.inc"
	   
	object{Man1 translate<2.7, 0.13, 19>}
	object{Woman1 translate<3.0, 0.08, 15>}
	object{Woman2 translate<3.3, 0.08, 15>}
	 
	object{Man3 translate<4.5, 0.08, 15>}
	object{Woman10 translate<4.8, 0.08, 15>}
	
	object{Man4 translate<6.5, 0.08, 15>}
	object{Woman8 translate<6.8, 0.08, 15>}
	
	object{Woman7 translate<7.5, 0.13, 18>}
	object{Man7 translate<8.0, 0.13, 18>}
	
	object{Woman6 translate<6.8, 0.13, 26>}
	object{Man8 translate<7.1, 0.13, 26>}
	
	object{Man2 translate<4.3, 0.13, 22>}
	object{Woman9 translate<4.7, 0.13, 24>}
	
	object{Man9 translate<10, 0.33, 53>}
	
	object{Woman3 translate<5, 0.33, 58>}

	object{Woman4 translate<9.4, 0.33, 50>}
	object{Man10 translate<7.4, 0.33, 50>}
	
	object{Woman5 translate<7, 0.33, 57>}
	object{Man6 translate<7.6, 0.33, 57>}
	
	object{Man5 translate<11, 0.33, 55>}
	object{Woman11 translate<11.4, 0.33, 55>}
#end