//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"     
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"        
#include "transforms.inc"  


#declare useTripodLights        = 0;



#declare tgeneralRand = seed(150);   

// Macros to return a random number

#macro tr(num)
        rand(tgeneralRand)*num
#end





#declare  leftLegSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.2, <0.2, 5, -1.5> 
         0.5, <0.6, 15, 1.5> 
         0.8, <2.0, 26, 8> 
         0.9, <4.0, 31, 7> 
         1.0, <8.0, 32, 5> 
       }; 


#declare  leftLegSpline2 = spline {
         natural_spline
         0.00, <-1.2, 0, -2.5>
         0.2, <0.2, 5, -1.5> 
         0.5, <0.6, 15, 1.5> 
         0.8, <2.0, 26, 8> 
         0.9, <4.0, 31, 7> 
         1.0, <8.0, 32, 5> 
       }; 
       
#declare  leftLegSpline3 = spline {
         natural_spline
         0.00, <1.2, 0, -2.5>
         0.2, <0.2, 5, -1.5> 
         0.5, <0.6, 15, 1.5> 
         0.8, <2.0, 26, 8> 
         0.9, <4.0, 31, 7> 
         1.0, <8.0, 32, 5> 
       }; 
       




#declare  backLegSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.2, <0, 5, -1.5> 
         0.5, <0, 15, 1.1> 
         0.8, <0, 26, -0> 
         0.9, <0, 31, -3> 
         1.0, <0, 32, -7> 
       };      

#declare  backLegSpline2 = spline {
         natural_spline
         0.00, <-1.2, 0, -2.5>
         0.2, <0, 5, -1.5> 
         0.5, <0, 15, 1.1> 
         0.8, <0, 26, -0> 
         0.9, <0, 31, -3> 
         1.0, <0, 32, -7> 
       }; 
       
#declare  backLegSpline3 = spline {
         natural_spline
         0.00, <1.2, 0, -2.5>
         0.2, <0, 5, -1.5> 
         0.5, <0, 15, 1.1> 
         0.8, <0, 26, -0> 
         0.9, <0, 31, -3> 
         1.0, <0, 32, -7> 
       }; 
       

#declare lightGlassMaterial = material {
    texture {
        pigment { rgbt <0.95, 0.99, 0.95, 0.9> }  
        finish { diffuse albedo 0.05 brilliance 2 reflection { 0.5, 0.01 fresnel on } conserve_energy }
    }                            
    interior { ior 1.5 }
    
}

#declare tripodTex = texture {
    pigment { granite colour_map {
     
 #declare tc = 0;
 #while(tc < 1.0)
    [ tc rgb <0.15+tr(0.3), 0.1+tr(0.2), 0.05+tr(0.15)> ]
    
    #declare tc=tc+0.05;
 #end 
     
     } 
     scale 5
     turbulence 0.3
     omega 0.75
     lambda 3.2
    }
    
    
    finish { specular albedo 0.3 roughness 0.05 diffuse albedo 0.25 brilliance 8 metallic 1.0 reflection { 0.04, 0.3 metallic 1 fresnel on } 
    conserve_energy }
    normal { granite 0.1 scale 0.001 }
}
texture {
    pigment { wrinkles triangle_wave scale 1.4 omega 0.75 lambda 2.75 turbulence 0.2 colour_map { [ 0 rgbt <0.02, 0.01, 0.003, 0.75> ] [ 1.0 rgbt <0.02, 0.01, 0.003, 0.3> ] } }
    finish { diffuse albedo 0.1 brilliance 1.5 }
  normal { granite 0.1 scale 0.01 }
}

#declare tripodWindowTex =  texture {
    pigment { granite colour_map {
     
 #declare tc = 0;
 #while(tc < 1.0)
    [ tc rgb <0.3+tr(0.15), 0.3+tr(0.1), 0.3+tr(0.1)> ]
    
    #declare tc=tc+0.1;
 #end 
     
     } 
     scale 5
     turbulence 0.3
     omega 0.75
     lambda 3.2
    }
    
    
    finish { specular albedo 0.3 roughness 0.05 diffuse albedo 0.25 brilliance 8 metallic 1.0 reflection { 0.04, 0.3 metallic 1 fresnel on } 
    conserve_energy }
    normal { quilted 0.5 scale 0.01 }
}
texture {
    pigment { wrinkles triangle_wave scale 1.4 omega 0.75 lambda 2.75 turbulence 0.2 colour_map { [ 0 rgbt <0.02, 0.01, 0.003, 0.75> ] [ 1.0 rgbt <0.02, 0.01, 0.003, 0.3> ] } }
    finish { diffuse albedo 0.1 brilliance 1.5 }
  normal { granite 0.1 scale 0.001 }
}


                    


#declare tripodFoot=union {        
    
    torus { 1, 0.025 translate <0, 0.025, 0>  }   
    cylinder { <0, 0, 0> <0, 0.05, 0> 1 }
    difference {
    cylinder { <0, 0.05, 0> <0, 0.1, 0> 0.975 }
    torus { 0.975, 0.05 translate <0, 0.1, 0> }    
    }                                          
    intersection { 
        sphere { 0, 0.925 scale <1, 0.5, 1> }
        box { <-1, 0, -1> <1, 0.6, 1> }
        translate <0, 0.1, 0> 
    }
}                   

#declare tripodFootTop = union {
    intersection { torus { 0.425, 0.075 } box { <-0.6, -0.1, -0.6> <0.6, 0, 0.6> } }   
    
    cone { <0, 0, 0> 0.5 <0, 0.5, 0> 0.275 }
    translate <0, 0.525, 0>  
} 

#declare halfTorusCutter = union {
    intersection {
        torus { 0.5, 0.035 }
        box { <-0.55, -0.04, -0.55> <0.55,  0.04, 0> }
    }  
    sphere { <-0.5, 0, 0> 0.035 }
    sphere { <0.5, 0, 0> 0.035 }
    
    scale <1, 4, 1> 
}

#declare QTorusCutter = union {
    intersection {
        torus { 0.5, 0.035 }
        box { <-0.55, -0.04, -0.55> <0,  0.04, 0> }
    }  
    sphere { <-0.5, 0, 0> 0.035 }
    sphere { <0, 0, -0.5> 0.035 }
    
    scale <1, 4, 1> 
} 

#declare armCutter = union {
    intersection {
        torus { 0.8, 0.05 }
        box { <-0.85, -0.06, -0.85> <0,  0.06, 0> }
    }  
    sphere { <-0.8, 0, 0> 0.05 }
    sphere { <0, 0, -0.8> 0.05 }
    
    scale <1, 4, 1> 
}  

#declare armCutter2 = intersection {

    difference {
        cylinder { <0, -1, 0> <0, 1, 0> 0.801 }
        cylinder { <0, -1, 0> <0, 1, 0> 0.675 }
    }
    sphere { <0, 0, -0.8> 0.8 }
}

#declare armCutter3 = union {
    intersection {
        torus { 0.8, 0.05 }
        box { <-0.85, -0.06, -0.85> <0.85,  0.06, 0> }
    }  
    sphere { <-0.8, 0, 0> 0.05 }
    sphere { <0.85, 0, 0> 0.05 }
    
    scale <1, 4, 1> 
}  



#declare tripodLeftLeg = union {
    #declare tp1 = 0;   
    #declare tr1 = 0.195;
    #while(tp1 < 0.2)
        sphere { 0, tr1 translate leftLegSpline(tp1) }
        sphere { 0, tr1 translate leftLegSpline2(tp1) }
        sphere { 0, tr1 translate leftLegSpline3(tp1) }
        #declare tp1=tp1+0.005;                           
        #if(tp1>0.125)
            #declare tp1=tp1-0.0035;
            #declare tr1=0.25;
        #end
    #end 
    
    
    
    //  knee bit that 3 base feet go into
    union {
        difference {
        sphere { 0, 0.5 scale <1, 5, 1> }
        //torus { 0.5, 0.035 scale <1, 4, 1> translate <0, 0.2, 0> }
        //torus { 0.5, 0.035 scale <1, 4, 1> translate <0, -0.2, 0> }
        object { halfTorusCutter  translate <0, 0.2, 0> }
        object { halfTorusCutter  translate <0, -0.2, 0> }
        
        
        }
        intersection {
        difference {
            sphere { 0, 0.6 scale <1, 5, 1> }
            sphere { 0, 0.575 scale <1, 5, 1> }
            }
            box { <-1, -5, -3> <1, 0, 3> rotate <-75, 0, 0> }
        }   
//        cone { <0, 1.75, 0> 0.45 <0, 3, 0.1> 0.2 }
        union {
          cone { <0, 0, 0> 0.4 <0, 1.25, 0> 0.2 } 
          sphere { <0, 1.25, 0> 0.2 }
          torus { 0.3, 0.1 }
          rotate <5, 0, 0> 
          translate <0, 1.75, 0>
        }
        rotate <5, 0, -2> translate <0, 0, -0.2> translate leftLegSpline(0.22)     
    }    
    
    // smooth bit out of knee upto top/elbow part
    #declare lRad=0.2;
    #declare step = 0.24;
    #while(tp1 < 0.73)
        sphere { 0, lRad translate leftLegSpline(tp1) }
        
        #if(tp1 > step)
           #declare Direction = (leftLegSpline(tp1+0.001) -leftLegSpline(tp1-0.001));   

           #declare step=step+0.04;
           torus { lRad, lRad*0.05 scale <1, 3, 1> 
           transform {Reorient_Trans(y,Direction)}  
           translate leftLegSpline(tp1)
           }
        
        #end 
        
        
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.003;
        
    #end 
    
    // bit at top of leg near elbow
    union {
        difference {
            cylinder { <0, 0, 0> <0, 2, 0> 0.7 }
            cylinder { <0, 0.2, 0> <0, 2.1, 0> 0.6 }
            box { <-2, 0, -2> <2, 3, 2> rotate <-30, -45, 0> translate <0, 1.2, 0> }
        }         
        torus { 0.6, 0.1 } 

        intersection {
        difference { torus { 0.6, 0.1 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -45, 0> translate <0, 1.2, 0> 
        }
        cylinder { <0, 0, 0> <0, 2, 0> 0.7 }  
        }  
        rotate <10, 0, -8>        
        translate leftLegSpline(tp1)
    }
    
    #declare lRad=0.4;
    // final part upto head
    #while(tp1 < 0.79)
        sphere { 0, lRad translate leftLegSpline(tp1) }
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.001;
        
    #end 
    #declare tp1=0.86;
    #while(tp1 < 1)
        sphere { 0, lRad translate leftLegSpline(tp1) }
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.001;
        
    #end 

    // top leg outer casing before shoulder
    union {
        difference {
            cylinder { <0, 0, 0> <0, 7, 0> 0.8 }
            cylinder { <0, 0.2, 0> <0, 3, 0> 0.65 }
            cylinder { <0, 4, 0> <0, 7.2, 0> 0.65 }
            box { <-2, 0, -2> <2, 3, 2> rotate <-30, -45, 0> translate <0, 6.0, 0> }
            box { <-2, -3, -2> <2, 0, 2> rotate <-30, -45, 0> translate <0, 0.35, 0> }    
            
            // cut into this
            object { armCutter rotate <0, 0, 0> translate <0, 1.1, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 1.1, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 1.1, 0> }

            object { armCutter rotate <0, -60, 0> translate <0, 1.7, 0> }
            object { armCutter rotate <0, -180, 0> translate <0, 1.7, 0> }
            object { armCutter rotate <0, -300, 0> translate <0, 1.7, 0> }

            object { armCutter rotate <0, 0, 0> translate <0, 2.3, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 2.3, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 2.3, 0> }

            object { armCutter rotate <0, -60, 0> translate <0, 2.9, 0> }
            object { armCutter rotate <0, -180, 0> translate <0, 2.9, 0> }
            object { armCutter rotate <0, -300, 0> translate <0, 2.9, 0> }

            object { armCutter rotate <0, 0, 0> translate <0, 3.5, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 3.5, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 3.5, 0> }

            object { armCutter3 rotate <0, -90, 0> translate <0, 4.1, 0> }
            object { armCutter3 rotate <0, -90, 0> translate <0, 4.7, 0> }
            object { armCutter3 rotate <0, -90, 0> translate <0, 5.3, 0> }

            
            object { armCutter2 rotate <0, 90, 0> translate <0, 5, 0> }

        } 
        intersection {
        difference { torus { 0.725, 0.075 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -45, 0> translate <0, 6, 0> 
        }
        cylinder { <0, 0, 0> <0, 7, 0> 0.8 }     
        }  


        intersection {
        difference { torus { 0.725, 0.075 } box {<-1,0, -1> <1, 0.2, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -45, 0> translate <0, 0.35, 0> 
        }
        cylinder { <0, 0, 0> <0, 7, 0> 0.8 }     
        }  


        
        rotate <-5, 0, -18> 
        translate <-0.01, 0, 0.15>       
        translate leftLegSpline(0.77)
    }

    // top outer casing/shoulder 
    difference { 
    union {
        difference {
            cylinder { <0, 0, 0> <0, 5, 0> 1.1 }
            cylinder { <0, -0.2, 0> <0, 2, 0> 0.75 }
            cylinder { <0, 3, 0> <0, 5.2, 0> 0.75 } 
            box { <-2, -3, -2> <2, 0, 2> rotate <0, 0, 30> translate <0, 0.4, 0> }
        } 
        intersection {
        difference { torus { 0.825, 0.075 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1/cos(radians(30)), 1, 1> rotate <0, 0, 30> translate <0, 0.4, 0> 
        }
        cylinder { <0, 0, 0> <0, 5, 0> 0.9 }   
        }  

    }
                intersection {  // cut out section at top
                difference {                
                    cylinder { <0, -0.1, 0> <0, 5, 0> 1.11 }
                    cylinder { <0, -0.2, 0> <0, 4, 0> 1.0 }
                }
                sphere { 0, 0.9 scale <1, 3.5, 1> translate <-1.1, 0.25, 0> }
            }
            cylinder { <0, 0, 0> <0, 3.5, 0> 0.1 scale <2, 1, 0.5> translate <0, 1, -1.1> rotate <0, 25, 0> } 
            cylinder { <0, 0, 0> <0, 3.5, 0> 0.1 scale <2, 1, 0.5> translate <0, 1, 1.1> rotate <0, -25, 0> } 
            
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 1.25, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 2.0, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 2.75, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 3.5, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 4.25, 0> }


        
        rotate <0, 0, -75> rotate <0, 25, 0>
        translate <0, 0.65, 0>       
        translate leftLegSpline(0.88)
    }
    
    
/*
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(0) }
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(0.2) }
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(0.5) }
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(0.8) }
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(0.9) }
        sphere { 0, 0.3 pigment { rgb <1, 0, 0> } translate leftLegSpline(1) }
*/        
    
    rotate <0, 0, 0>
    translate <0, 1, 0> 
}





#declare tripodBackLeg = union {
    #declare tp1 = 0;   
    #declare tr1 = 0.195;
    #while(tp1 < 0.2)
        sphere { 0, tr1 translate backLegSpline(tp1) }
        sphere { 0, tr1 translate backLegSpline2(tp1) }
        sphere { 0, tr1 translate backLegSpline3(tp1) }
        #declare tp1=tp1+0.005;                           
        #if(tp1>0.125)
            #declare tp1=tp1-0.0035;
            #declare tr1=0.25;
        #end
    #end 
    
    
    
    //  knee bit that 3 base feet go into

    union {
        difference {
        sphere { 0, 0.5 scale <1, 5, 1> }
        //torus { 0.5, 0.035 scale <1, 4, 1> translate <0, 0.2, 0> }
        //torus { 0.5, 0.035 scale <1, 4, 1> translate <0, -0.2, 0> }
        object { halfTorusCutter  translate <0, 0.2, 0> }
        object { halfTorusCutter  translate <0, -0.2, 0> }
        
        
        }
        intersection {
        difference {
            sphere { 0, 0.6 scale <1, 5, 1> }
            sphere { 0, 0.575 scale <1, 5, 1> }
            }
            box { <-1, -5, -3> <1, 0, 3> rotate <-75, 0, 0> }
        }   
//        cone { <0, 1.75, 0> 0.45 <0, 3, 0.1> 0.2 }
        union {
          cone { <0, 0, 0> 0.4 <0, 1.25, 0> 0.2 } 
          sphere { <0, 1.25, 0> 0.2 }
          torus { 0.3, 0.1 }
          rotate <7, 0, 0> 
          translate <0, 1.75, 0>
        }
        rotate <9, 0, -2> translate <0, 0, -0.2> translate backLegSpline(0.22)     
    }    
     
     
    // smooth bit out of knee upto top/elbow part
    #declare lRad=0.2;
    #declare step = 0.24;
    #while(tp1 < 0.73)
        sphere { 0, lRad translate backLegSpline(tp1) }
        
        #if(tp1 > step)
           #declare Direction = (backLegSpline(tp1+0.001) -backLegSpline(tp1-0.001));   

           #declare step=step+0.04;
           torus { lRad, lRad*0.05 scale <1, 3, 1> 
           transform {Reorient_Trans(y,Direction)}  
           translate backLegSpline(tp1)
           }
        
        #end 
        
        
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.003;
        
    #end 
    
    // bit at top of leg near elbow
    union {
        difference {
            cylinder { <0, 0, 0> <0, 2, 0> 0.7 }
            cylinder { <0, 0.2, 0> <0, 2.1, 0> 0.6 }
            box { <-2, 0, -2> <2, 3, 2> rotate <-30, -45, 0> translate <0, 1.2, 0> }
        }         
        torus { 0.6, 0.1 } 

        intersection {
        difference { torus { 0.6, 0.1 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -45, 0> translate <0, 1.2, 0> 
        }
        cylinder { <0, 0, 0> <0, 2, 0> 0.7 }  
        }
        rotate <0, 45, 0>  
        rotate <-20, 0, 0>        
        translate backLegSpline(tp1)
    }
    
    #declare lRad=0.4;
    // final part upto head
    #while(tp1 < 0.79)
        sphere { 0, lRad translate backLegSpline(tp1) }
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.001;
        
    #end 
    #declare tp1=0.86;
    #while(tp1 < 1)
        sphere { 0, lRad translate backLegSpline(tp1) }
        #declare tp1=tp1+0.0015;
        #declare lRad=lRad*1.001;
        
    #end 
 
    // top leg outer casing before shoulder
    union {
        difference {
            cylinder { <0, 0, 0> <0, 7, 0> 0.8 }
            cylinder { <0, 0.2, 0> <0, 3, 0> 0.65 }
            cylinder { <0, 4, 0> <0, 7.2, 0> 0.65 }
            box { <-2, 0, -2> <2, 3, 2> rotate <-30, -90, 0> translate <0, 6.0, 0> }
            box { <-2, -3, -2> <2, 0, 2> rotate <-30, -90, 0> translate <0, 0.35, 0> }    
            
            // cut into this
            object { armCutter rotate <0, 0, 0> translate <0, 1.1, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 1.1, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 1.1, 0> }

            object { armCutter rotate <0, -60, 0> translate <0, 1.7, 0> }
            object { armCutter rotate <0, -180, 0> translate <0, 1.7, 0> }
            object { armCutter rotate <0, -300, 0> translate <0, 1.7, 0> }

            object { armCutter rotate <0, 0, 0> translate <0, 2.3, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 2.3, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 2.3, 0> }

            object { armCutter rotate <0, -60, 0> translate <0, 2.9, 0> }
            object { armCutter rotate <0, -180, 0> translate <0, 2.9, 0> }
            object { armCutter rotate <0, -300, 0> translate <0, 2.9, 0> }

            object { armCutter rotate <0, 0, 0> translate <0, 3.5, 0> }
            object { armCutter rotate <0, -120, 0> translate <0, 3.5, 0> }
            object { armCutter rotate <0, -240, 0> translate <0, 3.5, 0> }

            object { armCutter3 rotate <0, -90, 0> translate <0, 4.1, 0> }
            object { armCutter3 rotate <0, -90, 0> translate <0, 4.7, 0> }
            object { armCutter3 rotate <0, -90, 0> translate <0, 5.3, 0> }

            
            object { armCutter2 rotate <0, 90, 0> translate <0, 5, 0> }

        } 
        intersection {
        difference { torus { 0.725, 0.075 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -90, 0> translate <0, 6, 0> 
        }
        cylinder { <0, 0, 0> <0, 7, 0> 0.8 }     
        }  


        intersection {
        difference { torus { 0.725, 0.075 } box {<-1,0, -1> <1, 0.2, 1> } 
        scale <1, 1, 1/cos(radians(30))> rotate <-30, -90, 0> translate <0, 0.35, 0> 
        }
        cylinder { <0, 0, 0> <0, 7, 0> 0.8 }     
        }  


        rotate <0, 90, 0>
        rotate <-25, 0, 0> 
        translate <0, 0, -0.05>       
        translate backLegSpline(0.77)
    }
     
    // top outer casing/shoulder 
    difference { 
    union {
        difference {
            cylinder { <0, 0, 0> <0, 5, 0> 1.1 }
            cylinder { <0, -0.2, 0> <0, 2, 0> 0.75 }
            cylinder { <0, 3, 0> <0, 5.2, 0> 0.75 } 
            box { <-2, -3, -2> <2, 0, 2> rotate <0, 0, 30> translate <0, 0.4, 0> }
        } 
        intersection {
        difference { torus { 0.825, 0.075 } box {<-1,-0.2, -1> <1, 0, 1> } 
        scale <1/cos(radians(30)), 1, 1> rotate <0, 0, 30> translate <0, 0.4, 0> 
        }
        cylinder { <0, 0, 0> <0, 5, 0> 0.9 }   
        }  

    }
                intersection {  // cut out section at top
                difference {                
                    cylinder { <0, -0.1, 0> <0, 5, 0> 1.11 }
                    cylinder { <0, -0.2, 0> <0, 4, 0> 1.0 }
                }
                sphere { 0, 0.9 scale <1, 3.5, 1> translate <-1.1, 0.25, 0> }
            }
            cylinder { <0, 0, 0> <0, 3.5, 0> 0.1 scale <2, 1, 0.5> translate <0, 1, -1.1> rotate <0, 25, 0> } 
            cylinder { <0, 0, 0> <0, 3.5, 0> 0.1 scale <2, 1, 0.5> translate <0, 1, 1.1> rotate <0, -25, 0> } 
            
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 1.25, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 2.0, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 2.75, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 3.5, 0> }
            object { armCutter3 scale 1.375 rotate <0, -90, 0> translate <0, 4.25, 0> }


        
        rotate <0, 90, 0> rotate <-75, 0, 0>
        translate <0, 0.45, 0>       
        translate backLegSpline(0.88)
    }
    
    
        
    
    rotate <0, 0, 0>
    translate <0, 1, 0> 
}





#declare tripodLeftLegAllParts = union {                                    
    // back foot
    object { tripodFoot }                      
    object { tripodFootTop }  
    object { tripodLeftLeg }
    
    // left foot
    object { tripodFoot translate <-1.2, 0, -2.5> }                  
    object { tripodFootTop translate <-1.2, 0, -2.5> }  

    // right foot
    object { tripodFoot translate <1.2, 0, -2.5> }                  
    object { tripodFootTop translate <1.2, 0, -2.5> }  

    
}

#declare tripodBackLegAllParts = union {                                    
    // back foot
    object { tripodFoot }                      
    object { tripodFootTop }  
    object { tripodBackLeg }
    
    // left foot
    object { tripodFoot translate <-1.2, 0, -2.5> }                  
    object { tripodFootTop translate <-1.2, 0, -2.5> }  

    // right foot
    object { tripodFoot translate <1.2, 0, -2.5> }                  
    object { tripodFootTop translate <1.2, 0, -2.5> }  

    
}  

#declare tripodRightLegAllParts = object {tripodLeftLegAllParts scale <-1, 1, 1> }


#declare bodyBase = union {
    difference {
    union {
        cylinder { <0, 0, -4> <0, 0, 4> 1.25 }
        sphere { <0, 0, -4> 1.25 }
        sphere { <0, 0, 4> 1.25 }  
        scale <2, 1, 0.5>
    } 
        cylinder { <0, 0, 0> <0, 5, 0> 1.15 
        rotate <0, 90, 0> rotate <-75, 0, 0>
        translate <0, 0.45, 0>       
        translate backLegSpline(0.88)
        translate <0, 1, 15>            
        translate <0, -33.25, -6.5> 
        }
    

        cylinder { <0, 0, 0> <0, 4, 0> 1.2 
        rotate <0, 0, -75> rotate <0, 25, 0>
        translate <0, 0.65, 0>       
        translate leftLegSpline(0.88)   
        translate <-8, 1, 0>
        translate <0, -33.25, -6.5> 
        }
        cylinder { <0, 0, 0> <0, 4, 0> 1.2  
        rotate <0, 0, -75> rotate <0, 25, 0>
        translate <0, 0.65, 0>       
        translate leftLegSpline(0.88)
        scale <-1, 1, 1>   
        translate <8, 1, 0>
        translate <0, -33.25, -6.5> 
        }

    }
    
    
}




#declare headBase = union {    

    intersection {
        difference {
            cylinder { <0, -2, 0> <0, 0, 0> 5 }
            cylinder { <0, -2.1, 0> <0, 0.1, 0> 3 }   
            cylinder { <0, -10, -5.1> <0, -10, 5.1> 9 }    
            // outer groove
            difference {
                cylinder { <0, -0.1, 0> <0, 0.1, 0> 5.01 }
                cylinder { <0, -0.11, 0> <0, 0.11, 0> 4.9 }               
            }   
            // inner groove
            cylinder { <0, -0.1, 0> <0, 0.1, 0> 3.1 }


            cone { <0, 0, -0.0001> 9.9 <0, 0, 2.1> 7 translate <0, -10, 0> rotate <0, -10, 0> translate <0, 0, -5> }           

            // cut grooves
//            cylinder { <0, 0, -5.1> <0, 0, 2.1> 0.05 scale <1, 0.5, 1> translate <0, 0, 0> }               
            
            translate <0, 0, 5>

        }                      
        box { <-5, -2.1, 0> <0, 0.11, 3> }    
        
        
        
    } 
    // bevel top part
    intersection {
        torus { 4.9, 0.1 translate <0, -0.1, 5> }
        box { <-5.1, -0.1, -0.01> <0, 0.11, 3> }
    }
    intersection {
        torus { 3.1, 0.1 translate <0, -0.1, 5> }
        box { <-5.1, -0.1, -0.01> <0, 0.11, 3> }
    }   
    
    // lower pointy bit
    intersection {
        union {
            difference {
                cylinder { <0, -10, -1> <0, -10, 2> 10 } 
                cylinder { <0, -10, -1.1> <0, -10, 2.1> 9 } 
                box { <-11, -11, -5> <11, 11, 0> rotate <0, -10, 0> }
                box { <-11, -11, 0> <11, 11, 5> rotate <0, 5, 0> translate <0, 0, 2> }
                
                // cut grooves
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -1> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -3> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -5> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -7> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -9> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -11> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -13> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -15> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -17> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -19> translate <0, -10, 0> }               
                cylinder { <0, 0, -1.1> <0, 0, 2.1> 0.04 scale <1, 0.25, 1> translate <0, 10, 0> rotate <0, 0, -21> translate <0, -10, 0> }               
                
                // cutout for bevel
                intersection {
                    difference {
                        cylinder { <0, -10, -0.4> <0, -10, 2.1> 11.01 }
                        cylinder { <0, -10, -0.51> <0, -10, 2.11> 9.9 }                               
                    }                                                  
                box { <-11, -11, -0.1> <11, 12, 0.1> rotate <0, -10, 0> }
                } 

                // cutout for bevel other side
                intersection {
                    difference {
                        cylinder { <0, -10, -0.1> <0, -10, 2.1> 10.1 }
                        cylinder { <0, -10, -0.11> <0, -10, 2.11> 9.9 }                               
                    }                                                  
                box { <-11, -11, 1.9> <11, 11, 2.0> rotate <0, 5, 0> }
                } 
                // slope underneath
                cone { <0, 0, -0.0001> 9.9 <0, 0, 2.1> 7 translate <0, -10, 0> rotate <0, -10, 0> }           
                
                // cut grooves      
      #declare gy = 9.9-7;
      #declare gz = 2.1;
      
      #declare at2 = atan2(gy, gz)*180/pi;
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -1> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -3> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -5> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -7> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -9> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -11> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -13> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -15> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -17> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -19> translate <0, -10, 0> rotate <0, -10, 0> }                
           cylinder { <0, 0, 0> <0, 0, 2> 0.04 scale <1, 0.25, 1> rotate <at2, 0, 0> translate <0, 9.9, 0> rotate <0, 0, -21> translate <0, -10, 0> rotate <0, -10, 0> }                
                
            } 
            // bevel                      

            difference {
                torus { 9.9, 0.1 rotate <90, 0, 0> scale  <1/cos(radians(10)), 1, 1>  rotate <0, -10, 0> translate <0, -10, 0.1>  }

                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -1> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -3> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -5> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -7> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -9> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -11> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -13> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -15> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -17> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -19> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -21> rotate <0, -10, 0> translate <0, -10, 0.1>  } 
            
           }

            // bevel oher side                      
           difference {
                torus { 9.9, 0.1 rotate <90, 0, 0> scale  <1/cos(radians(5)), 1, 1>  rotate <0, 5, 0> translate <0, -10, 1.9>  }
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -1> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -3> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -5> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -7> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -9> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -11> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -13> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -15> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -17> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -19> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
                torus { 0.1, 0.01 rotate <0, 0, 90> scale <4, 1, 1> translate <0, 9.9, 0> rotate <0, 0, -21> rotate <0, 5, 0> translate <0, -10, 1.9>  } 
            }
         }   
        box { <0, -2, -0.2> <6, 0.100001, 2.2> }      
    }  
     
          
      
    rotate <-15, 0, -10>
    rotate <0, 90, 0> 
    translate < 0, -1, 0>
}


#declare neckPart = union {
    // small front face frame
    cylinder { <0, 0, 0> <0, 1, 0> 0.05 rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0> }
    cylinder { <0, 0, 0> <0, 1, 0> 0.05 rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0> }
    cylinder { <-0.15, 0, 0> <0.15, 0, 0> 0.05 }        
    cylinder { vtransform(<0, 1, 0>, transform { rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0>})
               vtransform(<0, 1, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) 0.05 }
    
    // connect cylinders
    sphere { <-0.15, 0, 0> 0.05 }
    sphere { <0.15, 0, 0> 0.05 }
    sphere { <0, 1, 0> 0.05 rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0> }
    sphere { <0, 1, 0> 0.05 rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0> }
    
    // small face
polygon {  5,  
  vtransform(<-0.15, 0.0, -0.05>, transform { rotate <60, 0, 0> }),
  vtransform(<0.15, 0.0, -0.05>, transform { rotate <60, 0, 0> }), 
  vtransform(<0, 1.0, -0.05>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0.0, 0>}),
  vtransform(<0, 1.0, -0.05>, transform { rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0.0, 0>}), 
  vtransform(<-0.15, 0.0, -0.05>, transform { rotate <60, 0, 0> })
}


    //2nd face anti-clock frame
    
    cylinder { <0, 0, 0> <0, 0, 3> 0.05 rotate <0, 45, 0> translate <0.15, 0, 0> }
    cylinder { <0, 0, 0> <0, 0, 2> 0.05 rotate <0, 45, 0> 
        translate vtransform(<0, 1, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }        
    
    cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0>})
               vtransform(<0, 0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 0.05 }               

    // spheres 
    sphere { <0, 0, 3> 0.05  rotate <0, 45, 0> translate <0.15, 0, 0> }
    sphere { vtransform(<0, 0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 0.05 } 
            
    // 2nd face 

 mesh {
 triangle {
  vtransform(<0.2, 0.0, 0.0>, transform { rotate <60, 0, 0> }), 
  vtransform(<0.05, 0.0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }),
  vtransform(<0.05, 0.0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })  
  }
  triangle { 
  vtransform(<0.05, 0.0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 
  vtransform(<0.0, 1.0, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.2, 0.0, 0>}),
  vtransform(<0.2, 0.0, 0.0>, transform { rotate <60, 0, 0> })                          
  }
  }

  // 3rd face near back
  cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }),
             vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 0.05 }
             
  cylinder { vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }),
           vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }

  cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 
             vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }
  
  
  // spheres 
  sphere { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 0.05 } 
  sphere { vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }
  

    // mesh face
 mesh {
 triangle {
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }), 
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2>,
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 
  }
  triangle { 
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2>
  vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }),
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })                          
  }
  }
   
  // back
  cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2>
             vtransform(<0, 0, 3>, transform { rotate <0, -45, 0> translate <-0.15, 0, 0> })+<0.5, 0, 2> 0.05 }
              
  cylinder { vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2>
             vtransform(<0, 0, 2>, 
                 transform { rotate <0, -45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0>}) })+<0.55, 0, 2.2> 0.05 }
   
   // back face
 mesh {
 triangle {
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2>, 
  vtransform(<0, 0, 3>, transform { rotate <0, -45, 0> translate <-0.15, 0, 0> })+<0.5, 0, 2>,
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 
  }
  triangle { 
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2>
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, -45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, 20> rotate <60, 0, 0> translate <-0.15, 0, 0>}) })+<0.55, 0, 2.2>,
  vtransform(<0, 0, 3>, transform { rotate <0, -45, 0> translate <-0.15, 0, 0> })+<0.5, 0, 2>                         
  }
  }   
   
 // other side scale -1 of side from above (excluding back
 union {
 
     //2nd face anti-clock frame
    
    cylinder { <0, 0, 0> <0, 0, 3> 0.05 rotate <0, 45, 0> translate <0.15, 0, 0> }
    cylinder { <0, 0, 0> <0, 0, 2> 0.05 rotate <0, 45, 0> 
        translate vtransform(<0, 1, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }        
    
    cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0>})
               vtransform(<0, 0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 0.05 }               

    // spheres 
    sphere { <0, 0, 3> 0.05  rotate <0, 45, 0> translate <0.15, 0, 0> }
    sphere { vtransform(<0, 0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 0.05 } 
            
    // 2nd face 

 mesh {
 triangle {
  vtransform(<0.2, 0.0, 0.0>, transform { rotate <60, 0, 0> }), 
  vtransform(<0.05, 0.0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }),
  vtransform(<0.05, 0.0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })  
  }
  triangle { 
  vtransform(<0.05, 0.0, 2>, 
        transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
            transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }), 
  vtransform(<0.0, 1.0, 0>, transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.2, 0.0, 0>}),
  vtransform(<0.2, 0.0, 0.0>, transform { rotate <60, 0, 0> })                          
  }
  }

  // 3rd face near back
  cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }),
             vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 0.05 }
             
  cylinder { vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }),
           vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }

  cylinder { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 
             vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }
  
  
  // spheres 
  sphere { vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2> 0.05 } 
  sphere { vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 0.05 }
  

    // mesh face
 mesh {
 triangle {
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> }), 
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })+<-0.5, 0, 2>,
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2> 
  }
  triangle { 
  vtransform(<0, 0, 2>, 
                 transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
                 transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) })+<-0.55, 0, 2.2>
  vtransform(<0, 0, 2>, 
      transform { rotate <0, 45, 0> translate vtransform(<0, 1, 0>, 
          transform { rotate <0, 0, -20> rotate <60, 0, 0> translate <0.15, 0, 0>}) }),
  vtransform(<0, 0, 3>, transform { rotate <0, 45, 0> translate <0.15, 0, 0> })                          
  }
  }
  scale <-1, 1, 1> 
  }
}

#declare neck = union {

  object { neckPart rotate <0, 0, 0> translate <0, 0, -5> rotate <0, 0, 0> translate <0, 0, 5> }          
  object { neckPart scale 1.02 rotate <-5, 0, 0> translate <0, 0, -5> rotate <5, 0, 0> translate <0, 0, 5.3> }          
  object { neckPart scale 1.04 rotate <-10, 0, 0> translate <0, 0, -5> rotate <10, 0, 0> translate <0, 0, 5.6> }          
  object { neckPart scale 1.06 rotate <-15, 0, 0> translate <0, 0, -5> rotate <15, 0, 0> translate <0, 0, 5.875> }          
  object { neckPart scale 1.08 rotate <-20, 0, 0> translate <0, 0, -5> rotate <20, 0, 0> translate <0, 0, 6.125> }          
  object { neckPart scale 1.1 rotate <-25, 0, 0> translate <0, 0, -5> rotate <25, 0, 0> translate <0, 0, 6.3> }          
  object { neckPart scale 1.12 rotate <-30, 0, 0> translate <0, 0, -5> rotate <30, 0, 0> translate <0, 0, 6.425> }          

}
/*             
#declare headCutter = union { 
        intersection {
            difference {
                box { <-2, -2, -2> <2, 2, 2> }
                cylinder { <0, -2, -3> <0, -2, 3> 1 rotate <0, 0, -45> }
                cylinder { <0, -2, -3> <0, -2, 3> 1 rotate <0, 0, 45> }                
            }                                                          
            union {
            cylinder { <0, 0, -2.1> <0, 0, 2.1> 1 translate <0, 0, 0>  }      
            box { <-2.1, -0.75, -2.1> <2.1, 2.1, 2.1> }
            }     
        } 
}   
         
#declare head = union {
    difference {
        intersection {
            difference {
                torus { 5, 2 rotate <0, 0, 90> }
                torus { 5, 1.95 rotate <0, 0, 90> }  
            }
            object { headCutter scale <1.75, 1, 3> rotate <0, 90, 0> translate <0, 6.75, 0.175>  }       
            }   
        box { <0, -5, 0> <5, 5, 5> rotate <0, 45, 0> scale <1, 1, 0.75> rotate <0, 60, 0> translate <0.6, 5, -1.7> pigment { rgb <1, 0, 0> } }
    }
    translate <0, -5, 0>

    rotate <0,0, 0>     
}
*/
/* 2nd attempt
#declare headside = union {
    intersection {
        torus { 1, 0.05 }
        box { <-1.1, -0.1, 0> <0, 0.1, 1.1> rotate <0, -20, 0>  }
            
    }
    cylinder { <-1, 0, 0> <-1, 0, -3> 0.05 rotate <0, -20, 0> }
    cylinder { <-1, 0, 0> <-1, 0, 5> 0.05 rotate <0, 20, 0> } 
    
    difference {
        box { <0, -0.05, -3> <2, 0.05, 0> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, -20, 0> }   
        box { <0, -0.1, 0> <3, 0.1, 3> rotate <0, 50, 40> translate <-1, 0, -3> rotate <0, -20, 0> } 
        box { <0, 0, 0> <2, 1, 5> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, 20, 0> }  
    } 
    difference {
        box { <0, -0.05, 0> <2, 0.05, 5> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, 20, 0> }  
        box { <0, -0.1, -5> <3, 0.1, 0> rotate <0, -30, 40> translate <-1, 0, 5> rotate <0, 20, 0> } 
        box { <0, 0, -3> <2, 1, 0> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, -20, 0> }
    }
    intersection {
        box { <0, -0.05, -3> <2, 0.05, 0> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, -20, 0> }
        box { <0, -0.05, 0> <2, 0.05, 5> rotate <0, 0, 40> translate <-1, 0, 0> rotate <0, 20, 0> }  
    } 

    cone { <0, 0.025, 0> 1.0475 <0, 0.905, 0> 0 }
//rotate <0, 0, 90>
} 

#declare head= union {
object { headside translate <-1, 0, 0> }
object { headside translate <-1, 0, 0>  scale <-1, 1, 1> }
}

*/
            
       
         
#declare head = union {
 union {  

    // underneath part
       union {
       intersection  {
        union {
         intersection {
            ovus{ 1, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> }
            union {
              box { <-1.1, 0, -2> <1.1, 2, 0> rotate <15, 0, 0> translate <0, 0.5, -0.025> }
              box { <-1.1, 0, 0> <1.1, 2, 4> rotate <-5, 0, 0> translate <0, 0.5, -0.025> }
            } 
         //   texture { pigment { rgb <0.3, 0.01, 0.4> } }
        } 
        intersection {
            ovus{ 1, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> }
            union {
            //  box { <-1.1, 0, -2> <1.1, 2, 0> rotate <15, 0, 0> translate <0, 0.5, -0.025> }
              box { <-1.1, 0, 0> <1.1, 2, 4> rotate <-5, 0, 0> translate <0, 0.5, -0.025> }
            }
            translate <0, -0.5, 0.025> 
            scale <1, -1, 1>
            rotate <-10, 0, 0> 
            translate <0, 0.5, -0.025>     
        }  
        intersection {
            ovus{ 1, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> }
            union {
              box { <-1.1, 0, -2> <1.1, 2, 0> rotate <15, 0, 0> translate <0, 0.5, -0.025> }
            //  box { <-1.1, 0, 0> <1.1, 2, 4> rotate <-5, 0, 0> translate <0, 0.5, -0.025> }
            }
            translate <0, -0.5, 0.025> 
            scale <1, -1, 1>
            rotate <30, 0, 0> 
            translate <0, 0.5, -0.025>   
        } 
         
        }
        difference {
            sphere { <0, 0, 0> 1.0 scale <2, 1, 2> translate <0, 1.1, 1.2>  }
            sphere { 0, 0.21 scale <1.35, 1, 1> translate <0, 0.625, -0.6>   }
        }
       }    
        translate <0, -0.5, 0.025>
        rotate <0, 5, 0>
        scale <1, 0.85, 1>
        rotate <0, -5, 0>
        translate <0, 0.5, -0.025>
        
       }
    
    // raised bit at front
    difference {
        union {
            cone { <0, 0, 0> 0.15 <0, 0, 0.3> 0.1 } 
            torus { 0.14, 0.01 rotate <90, 0, 0> }
            rotate <-15, 0, 0> translate <0, 0.7, -0.825> 
        }
        cone { <0, 0, -0.01> 0.13 <0, 0, 0.29> 0.08 rotate <-15, 0, 0> translate <0, 0.7, -0.825> } 
        ovus{ 1.00, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> translate <0, -0.01, 0> } 
        scale <1.25, 1, 1> 
    }
    
    // main head part    
    difference {
        intersection {
            ovus{ 1.00, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> }
            union {
                box { <-1.1, 0, -2> <1.1, 2, 0> rotate <15, 0, 0> translate <0, 0.5, -0.025> }
                box { <-1.1, 0, 0> <1.1, 2, 4> rotate <-5, 0, 0> translate <0, 0.5, -0.025> }
            }
        } 
        union {
            cone { <0, 0, -0.1> 0.1499 <0, 0, 0.3> 0.1 } 
            rotate <-15, 0, 0> translate <0, 0.7, -0.825> 
            scale <1.25, 1, 1> 
        }

        ovus{ 1.00, 0.65 scale <1, 1.25, 1>*0.99 rotate <90, 0, 0> }
        union {
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 1.5> rotate <0, -60, 0> translate <-0.425, 0, -0.425> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.65> rotate <0, -20, 0> translate <-0.6, 0, -0.265> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.45> rotate <0, -5, 0> translate <-0.63, 0, -0.09> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.65> rotate <0, 5, 0> translate <-0.67, 0, 0.125> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 15, 0> translate <-0.615, 0, 0.30> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 17, 0> translate <-0.615, 0, 0.465> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 20, 0> translate <-0.575, 0, 0.605> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.5> rotate <0, 27, 0> translate <-0.5, 0, 0.765> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 40, 0> translate <-0.4, 0, 0.90> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.3> rotate <0, 55, 0> translate <-0.3, 0, 1> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.3> rotate <0, 65, 0> translate <-0.15, 0, 1.05> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.15> rotate <0, 75, 0> translate <-0.015, 0, 1.05> } 
        }
        union {
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 1.5> rotate <0, -60, 0> translate <-0.425, 0, -0.425> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.65> rotate <0, -20, 0> translate <-0.6, 0, -0.265> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.45> rotate <0, -5, 0> translate <-0.63, 0, -0.09> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.65> rotate <0, 5, 0> translate <-0.67, 0, 0.125> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 15, 0> translate <-0.615, 0, 0.30> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 17, 0> translate <-0.615, 0, 0.465> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 20, 0> translate <-0.575, 0, 0.605> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.5> rotate <0, 27, 0> translate <-0.5, 0, 0.765> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.35> rotate <0, 40, 0> translate <-0.4, 0, 0.90> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.3> rotate <0, 55, 0> translate <-0.3, 0, 1> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.3> rotate <0, 65, 0> translate <-0.15, 0, 1.05> } 
                box { <-2, -1, -2> <0, 2, 0> rotate <0, 45, 0> scale <1, 1, 0.15> rotate <0, 75, 0> translate <-0.015, 0, 1.05> } 
                scale <-1, 1, 1>
        }
    }
    
    // trim parts on head
    union { 
    //1st
        union 
        {
            object{ Round_Box(<-.01, -0.15, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -15> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <22, -20, -45> 
            translate <-0.625, 0.74, -0.375>
        }        

    //2nd
        union 
        {
            object{ Round_Box(<-.01, -0.185, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <5, -14, -42> 
            translate <-0.70, 0.72, -0.19>
        }        

    //3rd
        union 
        {
            object{ Round_Box(<-.01, -0.21, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <45, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <2, -10, -40> 
            translate <-0.735, 0.70, 0.01>
        }        

    //4th
        union 
        {
            object{ Round_Box(<-.01, -0.2, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -5> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-14, -5, -39> 
            translate <-0.725, 0.705, 0.225>
        }        

    //5th
        union 
        {
            object{ Round_Box(<-.01, -0.18, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-7, 0, -39> 
            translate <-0.71, 0.705, 0.425>
        }        
        
    //6th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-10, 0, -39> 
            translate <-0.685, 0.71, 0.5675>
        }        

    //7th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <30, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-13, 5, -41> 
            translate <-0.635, 0.72, 0.715>
        }        

    //8th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <30, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 12, 0> rotate <-25, 0, -42>  
            translate <-0.545, 0.7375, 0.8975>
        }        

    //9th
        union 
        {
            object{ Round_Box(<-.01, -0.215, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -18> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-30, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-10, 12, 0> rotate <-25, 0, -48> rotate <2, 5, 0>  
            translate <-0.43, 0.758, 1.04>
        }        

    //10th
        union 
        {
            object{ Round_Box(<-.01, -0.215, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -18> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-30, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 80, 0> rotate <-57, -30, 0> rotate <0, 0, 0>  
            translate <-0.3125, 0.7725, 1.16>
        }        


    //11th
        union 
        {
            object{ Round_Box(<-.01, -0.235, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -17> rotate <15, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -9> rotate <-20, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 80, 0> rotate <-63, -16, 0> rotate <0, 0, 0>  
            translate <-0.1425, 0.79, 1.245>
        }        


   
       // cylinder { <-0.7 0.625, -0.43> <-0.65, 0.7, -0.4> 0.01 } 
     
    }

    // other side scaled -1
        union { 
    //1st
        union 
        {
            object{ Round_Box(<-.01, -0.15, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -15> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <22, -20, -45> 
            translate <-0.625, 0.74, -0.375>
        }        

    //2nd
        union 
        {
            object{ Round_Box(<-.01, -0.185, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <5, -14, -42> 
            translate <-0.70, 0.72, -0.19>
        }        

    //3rd
        union 
        {
            object{ Round_Box(<-.01, -0.21, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <45, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <2, -10, -40> 
            translate <-0.735, 0.70, 0.01>
        }        

    //4th
        union 
        {
            object{ Round_Box(<-.01, -0.2, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <40, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -5> rotate <-40, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-14, -5, -39> 
            translate <-0.725, 0.705, 0.225>
        }        

    //5th
        union 
        {
            object{ Round_Box(<-.01, -0.18, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-7, 0, -39> 
            translate <-0.71, 0.705, 0.425>
        }        
        
    //6th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-10, 0, -39> 
            translate <-0.685, 0.71, 0.5675>
        }        

    //7th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <30, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-13, 5, -41> 
            translate <-0.635, 0.72, 0.715>
        }        

    //8th
        union 
        {
            object{ Round_Box(<-.01, -0.175, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -20> rotate <30, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-35, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 12, 0> rotate <-25, 0, -42>  
            translate <-0.545, 0.7375, 0.8975>
        }        

    //9th
        union 
        {
            object{ Round_Box(<-.01, -0.215, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -18> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-30, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <-10, 12, 0> rotate <-25, 0, -48> rotate <2, 5, 0>  
            translate <-0.43, 0.758, 1.04>
        }        

    //10th
        union 
        {
            object{ Round_Box(<-.01, -0.215, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -18> rotate <25, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -10> rotate <-30, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 80, 0> rotate <-57, -30, 0> rotate <0, 0, 0>  
            translate <-0.3125, 0.7725, 1.16>
        }        


    //11th
        union 
        {
            object{ Round_Box(<-.01, -0.235, -0.01>,<0.02, 0.01, 0.01>, 0.005 , 0) rotate <0, 0, 5> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -17> rotate <15, 0, 0> }
            object{ Round_Box(<-.01, -0.01, -0.01>,<0.02, 0.125, 0.01>, 0.005 , 0) rotate <0, 0, -9> rotate <-20, 0, 0> }  
            sphere { <0, 0, 0> 0.0125 }
            rotate <0, 80, 0> rotate <-63, -16, 0> rotate <0, 0, 0>  
            translate <-0.1425, 0.79, 1.245>
        }        


   
       // cylinder { <-0.7 0.625, -0.43> <-0.65, 0.7, -0.4> 0.01 } 
     
        scale <-1, 1, 1>
    }   
    
    // tail fin part on head
/*
    union {
        difference {
            box { <-0.005, 0, -0.7> <0.005, 0.14, 0.2> }
            box { <-0.02, 0.06, 0.12> <0.02, 0.15, 0.21> }
        } 
        cylinder { <-0.004999999999, 0.06, 0.12> <0.004999999999, 0.06, 0.12> 0.08 }
        cylinder { <0, 0.14, -0.7> <0, 0.14, 0.12> 0.01 scale <1.5, 1, 1> }
        cylinder { <0, 0, 0.2> <0, 0.06, 0.2> 0.01 scale <1.5, 1, 1> }
        intersection { 
            torus { 0.08, 0.01 rotate <0, 0, 90> }
            box { <-0.02, 0, 0> <0.02, 0.1, 0.1> }
            scale <1.5, 1, 1> 
            translate <0, 0.06, 0.12>
        }
        rotate <10, 0, 0> 
        translate <0, 0.67, 1.34>  
    }
*/
    
    // eye part on head
/*    blob {
    
        threshold 0.6 
        cylinder { <0, 0.1, 0.025> <0, 0, 0.5> 0.025, 1 scale <2, 1, 1> }
        cylinder { <0, 0.1, -0.025> <0, 0.0, -0.25> 0.025, 1 scale <2, 1, 1> }
        cylinder { <-0.025, 0.1, 0.0> <-0.15, -0.05, -0.05> 0.025, 1  }

        sphere { <0, 0, 0> 0.025, 1 scale <4, 1, 4> translate <0, 0.1, 0> }
        
        translate <-0.8, 0.8, 0>   
      //  pigment { rgb <1, 0, 0> }
    }
*/
#declare  eyeSplineTop = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.3, <0, 0.15, 0.2> 
         1.0, <0, -0.01, 1.0> 
       };   

#declare  eyeSplineLeft = spline {
         natural_spline
         0.00, <-0.14, 0.0, 0.17>
         0.5, <-0.08, 0.075, 0.185> 
         1.0, <0, 0.15, 0.2> 
       };  

#declare  eyeSplineLeftSide = spline {
         natural_spline
         0.00, <0, 0, 0>
         0.25, <-0.14, 0.0, 0.17> 
         0.8 <-0.03733, 0.02, 0.78> 
         1.0, <0, -0.01, 1> 
       };  


#declare  eyeSplineRight = spline {
         natural_spline
         0.00, <0.14, 0.035, 0.17>
         0.5, <0.08, 0.095, 0.185> 
         1.0, <0, 0.15, 0.2> 
       };  
       
#declare  eyeSplineRightSide = spline {
         natural_spline
         0.00, <0, 0, 0>
         0.25, <0.14, 0.035, 0.17> 
         1.0, <0, -0.01, 1> 
       };  


    // left eye    
    union 
    {

        blob {
            threshold 0.6     
            
            // bit over top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineTop(ep) }
                #declare ep=ep+0.01;
            #end
        

            #declare ep = 0.2;     
            #declare esin = 0; 
            #while(ep < 0.4 )  
                    sphere { 0, 0.02 1 scale <1+(sin(radians(esin*180))*2), 1, 1> translate eyeSplineTop(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.05;
            #end

            
            // left side to top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1> translate eyeSplineLeft(ep) }
                #declare ep=ep+0.01;
            #end

            #declare ep = 0.75;
            #declare esin = 0; 
            #while(ep < 0.95 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1+(sin(radians(esin*180))*3)> translate eyeSplineLeft(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.025;
            #end
        
        
            // left side bottom
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineLeftSide(ep) }
                #declare ep=ep+0.01;
            #end
            

            // right side to top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineRight(ep) }
                #declare ep=ep+0.05;
            #end   
            
            #declare ep = 0.75;
            #declare esin = 0; 
            #while(ep < 0.95 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1+(sin(radians(esin*180))*3)> translate eyeSplineRight(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.025;
            #end
            
            
            // right side bottom
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineRightSide(ep) }
                #declare ep=ep+0.01;
            #end
            
            }    

    
        // build the faces
        // front
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineLeft(0), eyeSplineTop(0.15) } 
            triangle { eyeSplineTop(0.15), eyeSplineLeft(0), eyeSplineLeftSide(0.1) } 
           
            triangle { eyeSplineLeftSide(0.1), eyeSplineLeftSide(0), eyeSplineTop(0.15) }
            }
        //other side
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineRight(0), eyeSplineTop(0.15) } 
            triangle { eyeSplineTop(0.15), eyeSplineRight(0), eyeSplineRightSide(0.1) } 
           
            triangle { eyeSplineRightSide(0.1), eyeSplineRightSide(0), eyeSplineTop(0.15) }
            }


        // back
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineLeft(0), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.3), eyeSplineTop(0.5), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineLeftSide(0.6), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineTop(0.75), eyeSplineLeftSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineLeftSide(0.85), eyeSplineLeftSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineTop(0.9), eyeSplineLeftSide(0.85) } 
            triangle { eyeSplineTop(0.9), eyeSplineLeftSide(0.85), eyeSplineLeftSide(1) } 
            } 
        // other side
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineRight(0), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.3), eyeSplineTop(0.5), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineRightSide(0.6), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineTop(0.75), eyeSplineRightSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineRightSide(0.85), eyeSplineRightSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineTop(0.9), eyeSplineRightSide(0.85) } 
            triangle { eyeSplineTop(0.9), eyeSplineRightSide(0.85), eyeSplineRightSide(1) } 
            } 

        
        // frame across mesh
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineLeftSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineLeftSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineLeftSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineLeftSide(0.8) 0.0025 }    
        cylinder { eyeSplineTop(0.9), eyeSplineLeftSide(0.8) 0.0025 }    
        
        // other side
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineRightSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineRightSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineRightSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineRightSide(0.8) 0.0025 }    
        cylinder { eyeSplineTop(0.9), eyeSplineRightSide(0.8) 0.0025 }    

        // front
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.08) 0.0025 }    
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.16) 0.0025 }    
        
        // other side 
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.08) 0.0025 }    
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.16) 0.0025 }    

        rotate <-1, 0, 15>
        translate <-0.365, 0.89, -0.375>
    }             

// right eye
    union 
    {

        blob {
            threshold 0.6     
            
            // bit over top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineTop(ep) }
                #declare ep=ep+0.01;
            #end
        

            #declare ep = 0.2;     
            #declare esin = 0; 
            #while(ep < 0.4 )  
                    sphere { 0, 0.02 1 scale <1+(sin(radians(esin*180))*2), 1, 1> translate eyeSplineTop(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.05;
            #end

            
            // left side to top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1> translate eyeSplineLeft(ep) }
                #declare ep=ep+0.01;
            #end

            #declare ep = 0.75;
            #declare esin = 0; 
            #while(ep < 0.95 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1+(sin(radians(esin*180))*3)> translate eyeSplineLeft(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.025;
            #end
        
        
            // left side bottom
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineLeftSide(ep) }
                #declare ep=ep+0.01;
            #end
            

            // right side to top
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineRight(ep) }
                #declare ep=ep+0.05;
            #end   
            
            #declare ep = 0.75;
            #declare esin = 0; 
            #while(ep < 0.95 )  
                    sphere { 0, 0.01, 1 scale <1, 1, 1+(sin(radians(esin*180))*3)> translate eyeSplineRight(ep) }
                #declare ep=ep+0.01;
                #declare esin=esin+0.025;
            #end
            
            
            // right side bottom
            #declare ep = 0;
            #while(ep < 1 )  
                    sphere { 0, 0.02, 1 scale <1, 1, 1> translate eyeSplineRightSide(ep) }
                #declare ep=ep+0.01;
            #end
            
            }    

    
        // build the faces
        // front
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineLeft(0), eyeSplineTop(0.15) } 
            triangle { eyeSplineTop(0.15), eyeSplineLeft(0), eyeSplineLeftSide(0.1) } 
           
            triangle { eyeSplineLeftSide(0.1), eyeSplineLeftSide(0), eyeSplineTop(0.15) }
            }
        //other side
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineRight(0), eyeSplineTop(0.15) } 
            triangle { eyeSplineTop(0.15), eyeSplineRight(0), eyeSplineRightSide(0.1) } 
           
            triangle { eyeSplineRightSide(0.1), eyeSplineRightSide(0), eyeSplineTop(0.15) }
            }


        // back
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineLeft(0), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.3), eyeSplineTop(0.5), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineLeftSide(0.6), eyeSplineLeftSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineTop(0.75), eyeSplineLeftSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineLeftSide(0.85), eyeSplineLeftSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineTop(0.9), eyeSplineLeftSide(0.85) } 
            triangle { eyeSplineTop(0.9), eyeSplineLeftSide(0.85), eyeSplineLeftSide(1) } 
            } 
        // other side
        mesh {
            triangle { eyeSplineTop(0.3), eyeSplineRight(0), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.3), eyeSplineTop(0.5), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineRightSide(0.6), eyeSplineRightSide(0.4) } 
            triangle { eyeSplineTop(0.5), eyeSplineTop(0.75), eyeSplineRightSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineRightSide(0.85), eyeSplineRightSide(0.6) } 
            triangle { eyeSplineTop(0.75), eyeSplineTop(0.9), eyeSplineRightSide(0.85) } 
            triangle { eyeSplineTop(0.9), eyeSplineRightSide(0.85), eyeSplineRightSide(1) } 
            } 

        
        // frame across mesh
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineLeftSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineLeftSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineLeftSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineLeftSide(0.8) 0.0025 }    
        cylinder { eyeSplineTop(0.9), eyeSplineLeftSide(0.8) 0.0025 }    
        
        // other side
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineRightSide(0.4) 0.0025 }    
        cylinder { eyeSplineTop(0.5), eyeSplineRightSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineRightSide(0.6) 0.0025 }    
        cylinder { eyeSplineTop(0.7), eyeSplineRightSide(0.8) 0.0025 }    
        cylinder { eyeSplineTop(0.9), eyeSplineRightSide(0.8) 0.0025 }    

        // front
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.08) 0.0025 }    
        cylinder { eyeSplineTop(0.3), eyeSplineLeftSide(0.16) 0.0025 }    
        
        // other side 
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.08) 0.0025 }    
        cylinder { eyeSplineTop(0.3), eyeSplineRightSide(0.16) 0.0025 }    

        rotate <-1, 0, 15>
        translate <-0.365, 0.89, -0.375> 
        scale <-1, 1, 1> 
    } 
    difference {
    intersection {
        difference {
            torus { 1.1, 0.175 rotate <0, 0, 90> }
            #declare tcut = 0;
            #while(tcut < 70)
                torus { 0.175 0.0025 scale <1, 2, 1> translate <0, 0, -1.1> rotate <50+tcut, 0, 0> }
                #declare tcut=tcut+5;
            #end 
            sphere { 0, 0.15 scale <1, 1, 2.5> translate <0, 1.15, 0> rotate <-25, 0, 0> }
        }
        box { <-0.2, 0.45, 0> <0.2, 1.4, 1.25> rotate <-40, 0, 0>} 
        translate <0, -0.15, 0.05>  
    }
        ovus{ 1.00, 0.65 scale <1, 1.25, 1> rotate <90, 0, 0> }
    }
    // window
    sphere { 0, 0.15 scale <1, 1, 2.5> translate <0, 1.15, 0> rotate <-25, 0, 0>  translate <0, -0.15, 0.05>
        texture { tripodWindowTex }
    }  
    // parts underneath head
    // left side
    union {     
        intersection {
            difference {
                torus { 0.5, 0.2 } 
                #declare tcut = 0;
                #while(tcut < 90)
                    torus { 0.2, 0.0025 scale <1, 2, 1> rotate <90, 0, 0> translate <-0.5, 0, 0> rotate <0, 0+tcut, 0> }
                    #declare tcut=tcut+8;
                #end 
            }
            box { <-0.8, -0.3, 0> <0, 0.3, 0.8> }
        }
        intersection {
            difference {
                torus { 0.3, 0.2 } 
                #declare tcut = 0;
                #while(tcut < 90)
                    torus { 0.2, 0.0025 scale <1, 2, 1> rotate <90, 0, 0> translate <-0.3, 0, 0> rotate <0, -(0+tcut), 0> }
                    #declare tcut=tcut+12;
                #end 
            
            }
            box { <-0.6, -0.3, -0.6> <0, 0.3, 0> }  
            translate <-0.2, 0, 0>
        }             
        intersection {
            sphere { 0, 0.2 }
            box { <0, -0.3, -0.3> <0.3, 0.3, 0.3> }
            translate <-0.2, 0, -0.3> 
        }            
        intersection {
            sphere { 0, 0.2 }
            box { <0, -0.3, -0.3> <0.3, 0.3, 0.3> }
            translate <0, 0, 0.5> 
        }
                    
        scale <1, 0.75, 1>
        rotate <0, 0, 25>
        
        translate <-0.25, 0.65, 0.08> 
    }                                   
    // right side scale -1 of left
    union {     
        intersection {
            difference {
                torus { 0.5, 0.2 } 
                #declare tcut = 0;
                #while(tcut < 90)
                    torus { 0.2, 0.0025 scale <1, 2, 1> rotate <90, 0, 0> translate <-0.5, 0, 0> rotate <0, 0+tcut, 0> }
                    #declare tcut=tcut+8;
                #end 
            }
            box { <-0.8, -0.3, 0> <0, 0.3, 0.8> }
        }
        intersection {
            difference {
                torus { 0.3, 0.2 } 
                #declare tcut = 0;
                #while(tcut < 90)
                    torus { 0.2, 0.0025 scale <1, 2, 1> rotate <90, 0, 0> translate <-0.3, 0, 0> rotate <0, -(0+tcut), 0> }
                    #declare tcut=tcut+12;
                #end 
            
            }
            box { <-0.6, -0.3, -0.6> <0, 0.3, 0> }  
            translate <-0.2, 0, 0>
        }             
        intersection {
            sphere { 0, 0.2 }
            box { <0, -0.3, -0.3> <0.3, 0.3, 0.3> }
            translate <-0.2, 0, -0.3> 
        }            
        intersection {
            sphere { 0, 0.2 }
            box { <0, -0.3, -0.3> <0.3, 0.3, 0.3> }
            translate <0, 0, 0.5> 
        }
                    
        scale <1, 0.75, 1>
        rotate <0, 0, 25>
        
        translate <-0.25, 0.65, 0.08> 
        scale <-1, 1, 1>
    }                                   
    scale <1.5, 2, 2.75>  
  }
  // add parts that scaling above was causing issues with..

  union
  {
        // gun type attachment
        union {
            torus { 0.1, 0.02 scale <1, 1, 1> }
            torus { 0.08, 0.02 scale <1, 1, 1> translate <0, 0.03, 0> }
            sphere { 0, 0.085 translate <0, 0.08, 0> }
            union {
                torus { 0.06, 0.01 }
                cylinder { <0, 0, 0> <0, 0.05, 0> 0.05 }   
                difference {
                    cone { <0, 0.05, 0> 0.05 <0, 0.1, 0> 0.03 }
                    cylinder { <0, 0.05, 0> <0, 0.11, 0> 0.02 }
                    
                }   
                torus { 0.025, 0.005 translate <0, 0.1, 0> }                                            
                
                translate <0, 0.04, 0> rotate <0, 0, 30> rotate <0, 30, 0> translate <0, 0.1, 0> 
            }
            scale 1.2
            rotate <0, 0, 80>       
            translate <-0.2, 0, 0> 
            rotate <0, -5, -5> 
            translate <-0.49, 0, 0> 

            rotate <0, 0, 35>
        
            translate <-0.72, 1.1, -0.05> 
        }
        // gun other side
                union {
            torus { 0.1, 0.02 scale <1, 1, 1> }
            torus { 0.08, 0.02 scale <1, 1, 1> translate <0, 0.03, 0> }
            sphere { 0, 0.085 translate <0, 0.08, 0> }
            union {
                torus { 0.06, 0.01 }
                cylinder { <0, 0, 0> <0, 0.05, 0> 0.05 }   
                difference {
                    cone { <0, 0.05, 0> 0.05 <0, 0.1, 0> 0.03 }
                    cylinder { <0, 0.05, 0> <0, 0.11, 0> 0.02 }
                    
                }   
                torus { 0.025, 0.005 translate <0, 0.1, 0> }                                            
                
                translate <0, 0.04, 0> rotate <0, 0, 30> rotate <0, 30, 0> translate <0, 0.1, 0> 
            }
            scale 1.2
            rotate <0, 0, 80>       
            translate <-0.2, 0, 0> 
            rotate <0, -5, -5> 
            translate <-0.49, 0, 0> 

            rotate <0, 0, 35>
        
            translate <-0.72, 1.1, -0.05> 
            scale <-1, 1, 1>
        }   
        // lights
        // big light
        union {  
            sphere { <0, 0, 0> 0.175 scale <1, 1, 0.2> material { lightGlassMaterial }} 
            #if(useTripodLights)
                // An area light (creates soft shadows)
            // WARNING: This special light can significantly slow down rendering times!
            light_source {
              <0,0,0>             // light's position (translated below)
              color rgb <2, 2, 2.2>*2       // light's color
              area_light
              <.1, 0, 0> <0, 0, .1> // lights spread out across this distance (x * z)
              4, 4                // total number of lights in grid (4x*4z = 16 lights)
              adaptive 0          // 0,1,2,3...
              jitter              // adds random softening of light
              circular            // make the shape of the light circular
              orient              // orient light
              translate <0, 0, 0.2>   // <x y z> position of light    
              // light_source { ...
          // put this inside a light_source to add light fading
            fade_distance 1
            fade_power 2

            }

            #end
            difference {
                cylinder { <0, 0, -0.1> <0, 0, 0.2> 0.2 }
                cylinder { <0, 0, -0.11> <0, 0, 0.25> 0.17 }  
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 40> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 80> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 120> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 160> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 200> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 240> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 280> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 320> }
            } 
            torus { 0.185, 0.015 rotate <90, 0, 0> translate <0, 0, -0.1> }
            // 2nd lens part
            difference {
                cylinder { <0, 0, 0.1> <0, 0, 0.3> 0.235 }
                cylinder { <0, 0, -0.11> <0, 0, 0.35> 0.205 }  
            }                                               
            torus { 0.22, 0.015 rotate <90, 0, 0> translate <0, 0, 0.1> }

            difference {
                cylinder { <0, 0, 0.3> <0, 0, 0.32> 0.25 }
                cylinder { <0, 0, 0.2> <0, 0, 0.35> 0.2 }  
            }                                               
            torus { 0.25, 0.01 rotate <90, 0, 0> translate <0, 0, 0.31> }   
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 30> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 60> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 90> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 120> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 150> }

            // base of 2nd lense                            
            union {
            difference {
                intersection {
                    sphere { 0, 0.365 }
                    box { <-0.4, -0.4, -0.15> <0.4, 0.4, 0.15> }
                }
                torus { 0.365, 0.01 }
                torus { 0.365, 0.01 rotate <0, 0, 30> }
                torus { 0.365, 0.01 rotate <0, 0, 60> }
                torus { 0.365, 0.01 rotate <0, 0, 90> }
                torus { 0.365, 0.01 rotate <0, 0, 120> }
                torus { 0.365, 0.01 rotate <0, 0, 150> }
                torus { 0.365, 0.005 rotate <90, 0, 0> }
                
                       
                cylinder { <0, 0, -0.2> <0, 0, 0.14> 0.3 }
                scale <1, 1, 2>
            }   
                torus { 0.315, 0.015 rotate <90, 0, 0> translate <0, 0, -0.3> }
                translate <0, 0, 0.6> 
            }
            translate <0, 1.35, -2.15>           
        }
       
       // small lights
         union {  
            sphere { <0, 0, 0> 0.175 scale <1, 1, 0.2> material { lightGlassMaterial }} 
            #if(useTripodLights)
                // An area light (creates soft shadows)
            // WARNING: This special light can significantly slow down rendering times!
            light_source {
              <0,0,0>             // light's position (translated below)
              color rgb <2, 2, 2.2>*2       // light's color
              area_light
              <.1, 0, 0> <0, 0, .1> // lights spread out across this distance (x * z)
              4, 4                // total number of lights in grid (4x*4z = 16 lights)
              adaptive 0          // 0,1,2,3...
              jitter              // adds random softening of light
              circular            // make the shape of the light circular
              orient              // orient light
              translate <0, 0, 0.2>   // <x y z> position of light    
              // light_source { ...
          // put this inside a light_source to add light fading
            fade_distance 1
            fade_power 2

            }

            #end
            difference {
                cylinder { <0, 0, -0.1> <0, 0, 0.2> 0.2 }
                cylinder { <0, 0, -0.11> <0, 0, 0.25> 0.17 }  
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 40> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 80> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 120> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 160> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 200> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 240> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 280> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 320> }
            } 
            torus { 0.185, 0.015 rotate <90, 0, 0> translate <0, 0, -0.1> }
            // 2nd lens part
            difference {
                cylinder { <0, 0, 0.1> <0, 0, 0.3> 0.235 }
                cylinder { <0, 0, -0.11> <0, 0, 0.35> 0.205 }  
            }                                               
            torus { 0.22, 0.015 rotate <90, 0, 0> translate <0, 0, 0.1> }

            difference {
                cylinder { <0, 0, 0.3> <0, 0, 0.32> 0.25 }
                cylinder { <0, 0, 0.2> <0, 0, 0.35> 0.2 }  
            }                                               
            torus { 0.25, 0.01 rotate <90, 0, 0> translate <0, 0, 0.31> }   
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 30> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 60> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 90> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 120> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 150> }

            // base of 2nd lense                            
            union {
            difference {
                intersection {
                    sphere { 0, 0.365 }
                    box { <-0.4, -0.4, -0.15> <0.4, 0.4, 0.15> }
                }
                torus { 0.365, 0.01 }
                torus { 0.365, 0.01 rotate <0, 0, 30> }
                torus { 0.365, 0.01 rotate <0, 0, 60> }
                torus { 0.365, 0.01 rotate <0, 0, 90> }
                torus { 0.365, 0.01 rotate <0, 0, 120> }
                torus { 0.365, 0.01 rotate <0, 0, 150> }
                torus { 0.365, 0.005 rotate <90, 0, 0> }
                
                       
                cylinder { <0, 0, -0.2> <0, 0, 0.14> 0.3 }
                scale <1, 1, 2>
            }   
                torus { 0.315, 0.015 rotate <90, 0, 0> translate <0, 0, -0.3> }
                translate <0, 0, 0.6> 
            } 
            scale <0.6, 0.6, 0.8>
            translate <-0.95, 0.95, -1.45>           
        }      
        // right side
         union {  
            sphere { <0, 0, 0> 0.175 scale <1, 1, 0.2> material { lightGlassMaterial }} 
            #if(useTripodLights)
                // An area light (creates soft shadows)
            // WARNING: This special light can significantly slow down rendering times!
            light_source {
              <0,0,0>             // light's position (translated below)
              color rgb <2, 2, 2.2>*2       // light's color
              area_light
              <.1, 0, 0> <0, 0, .1> // lights spread out across this distance (x * z)
              4, 4                // total number of lights in grid (4x*4z = 16 lights)
              adaptive 0          // 0,1,2,3...
              jitter              // adds random softening of light
              circular            // make the shape of the light circular
              orient              // orient light
              translate <0, 0, 0.2>   // <x y z> position of light    
              // light_source { ...
          // put this inside a light_source to add light fading
            fade_distance 1
            fade_power 2

            }

            #end
            difference {
                cylinder { <0, 0, -0.1> <0, 0, 0.2> 0.2 }
                cylinder { <0, 0, -0.11> <0, 0, 0.25> 0.17 }  
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 40> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 80> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 120> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 160> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 200> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 240> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 280> }
                box { <-0.25, -0.05, -0.09> <0, 0.05, -0.06> rotate <0, 0, 320> }
            } 
            torus { 0.185, 0.015 rotate <90, 0, 0> translate <0, 0, -0.1> }
            // 2nd lens part
            difference {
                cylinder { <0, 0, 0.1> <0, 0, 0.3> 0.235 }
                cylinder { <0, 0, -0.11> <0, 0, 0.35> 0.205 }  
            }                                               
            torus { 0.22, 0.015 rotate <90, 0, 0> translate <0, 0, 0.1> }

            difference {
                cylinder { <0, 0, 0.3> <0, 0, 0.32> 0.25 }
                cylinder { <0, 0, 0.2> <0, 0, 0.35> 0.2 }  
            }                                               
            torus { 0.25, 0.01 rotate <90, 0, 0> translate <0, 0, 0.31> }   
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 30> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 60> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 90> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 120> }
            box { <-0.3, -0.02, 0.32> <0.3, 0.02, 0.45> rotate <0, 0, 150> }

            // base of 2nd lense                            
            union {
            difference {
                intersection {
                    sphere { 0, 0.365 }
                    box { <-0.4, -0.4, -0.15> <0.4, 0.4, 0.15> }
                }
                torus { 0.365, 0.01 }
                torus { 0.365, 0.01 rotate <0, 0, 30> }
                torus { 0.365, 0.01 rotate <0, 0, 60> }
                torus { 0.365, 0.01 rotate <0, 0, 90> }
                torus { 0.365, 0.01 rotate <0, 0, 120> }
                torus { 0.365, 0.01 rotate <0, 0, 150> }
                torus { 0.365, 0.005 rotate <90, 0, 0> }
                
                       
                cylinder { <0, 0, -0.2> <0, 0, 0.14> 0.3 }
                scale <1, 1, 2>
            }   
                torus { 0.315, 0.015 rotate <90, 0, 0> translate <0, 0, -0.3> }
                translate <0, 0, 0.6> 
            } 
            scale <0.6, 0.6, 0.8>
            translate <0.95, 0.95, -1.45>           
        }   
        // arm parts with circluar blade
        #declare bladeArmSpline1 = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.2, <1.25, 0, 0.25> 
         0.4, <2.5, 0, -0.5> 
         0.6, <2.5, 0, -1.75> 
         0.8, <1.5, 0, -2.75> 
         1.0, <1.25, 0, -3.5> 
       };         

        #declare bladeArmSpline2 = spline {
         natural_spline
         0.00, <0, 0.0, 0.25>
         0.2, <1.25, 0, 0.5> 
         0.4, <2.5, 0, -0.5> 
         0.6, <2.5, 0, -1.75> 
         0.8, <1.5, 0, -2.75> 
         1.0, <1.25, 0, -3.5> 
       };         

        #declare bladeArmSpline3 = spline {
         natural_spline
         0.00, <0, 0.0, 0.125>
         0.2, <1.25, 0, 0.375> 
         0.4, <2.5, 0, -0.5> 
         0.6, <2.5, 0, -1.75> 
         0.8, <1.5, 0, -2.75> 
         1.0, <1.25, 0, -3.5> 
       };         

        #declare bladeArmSpline4 = spline {
         natural_spline
         0.00, <0, 0.0, 0.125>
         0.2, <1.25, 0, 0.375> 
         0.4, <2.5, 0, -0.5> 
         0.6, <2.5, 0, -1.75> 
         0.8, <1.5, 0, -2.75> 
         1.0, <1.35, 0, -3.5> 
       };         

        #declare bladeArmSpline5 = spline {
         natural_spline
         0.00, <0, 0.0, 0.125>
         0.2, <1.25, 0, 0.375> 
         0.4, <2.5, 0, -0.5> 
         0.6, <2.5, 0, -1.75> 
         0.8, <1.5, 0, -2.75> 
         1.0, <1.15, 0, -3.5> 
       };         

       // arm right side
       union {  
            // base part
            union { 
                cylinder { bladeArmSpline1(0.0) bladeArmSpline1(0.05) 0.07 }
                #declare bDir = (bladeArmSpline1(0)-bladeArmSpline1(0.05));   
                torus { 0.06, 0.01 rotate <90, 0, 0> 
                transform {Reorient_Trans(z,bDir) }
                translate bladeArmSpline1(0.05)  
                                              
                }

            }
            union { 
                cylinder { bladeArmSpline2(0.0) bladeArmSpline2(0.05) 0.07 }
                #declare bDir = (bladeArmSpline2(0)-bladeArmSpline2(0.05));   
                torus { 0.06, 0.01 rotate <90, 0, 0> 
                transform {Reorient_Trans(z,bDir) }
                translate bladeArmSpline2(0.05)  
                                              
                }
            }

            // long parts
            #declare bp1 = 0;   
            #declare bp1Diff=0.03;
            
            #while(bp1 < 1)
                cone { bladeArmSpline1(bp1), 0.04-(bp1*0.005) bladeArmSpline1(bp1+bp1Diff), 0.04-((bp1+bp1Diff)*0.005) } 
                sphere { bladeArmSpline1(bp1+bp1Diff), 0.04-((bp1+bp1Diff)*0.005) }  
                #declare bp1=bp1+bp1Diff;
            #end 

            #declare bp2 = 0;   
            #declare bp2Diff=0.03;
            
            #while(bp2 < 0.4)
                cone { bladeArmSpline2(bp2), 0.04-(bp2*0.005) bladeArmSpline2(bp2+bp2Diff), 0.04-((bp2+bp2Diff)*0.005) } 
                sphere { bladeArmSpline2(bp2+bp2Diff), 0.04-((bp2+bp2Diff)*0.005) }  
                #declare bp2=bp2+bp2Diff;
            #end                            
            
            // join 2 arms together
            #declare bp3 = 0.265;   
            #declare bp3Diff=0.0025;
            blob {
            threshold 0.6 
            #while(bp3 < 0.45)
             //   cone { bladeArmSpline3(bp3), 0.20-(bp3*0.005) bladeArmSpline3(bp3+bp2Diff), 0.20-((bp3+bp3Diff)*0.005) scale <1, 0.2, 1> } 
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline1(bp3+bp3Diff) }  
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline2(bp3+bp3Diff+0.01) }  
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline3(bp3+bp3Diff+0.007) }  
                #declare bp3=bp3+bp3Diff;
            #end                            
            }
            
            // marker spheres
/*
            sphere { bladeArmSpline1(0.2) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline2(0.2) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline2(0.4) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.4) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.6) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.85) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(1) ,0.07 pigment { rgb <1, 0, 0> } }
*/
            // bridge parts   
            #declare bridgePos = 0.1;
            union {
            
                difference {
                    box { <-0.10, -0.035, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.035, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <0.10, 0, 0> }
                }
                intersection {
                    box { <-0.10, -0.04, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.04, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }                    
                }
                
                rotate <0, -10, 0>
                translate <0, 0, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5>+bladeArmSpline1(bridgePos)
            }
            #declare bridgePos = 0.15;
            union {
            
                difference {
                    box { <-0.10, -0.035, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.035, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <0.10, 0, 0> }
                }
                intersection {
                    box { <-0.10, -0.04, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.04, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }                    
                }
                
                rotate <0, 0, 0>
                translate <0, 0, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5>+bladeArmSpline1(bridgePos)
                     
            }
                                                   
            cylinder { bladeArmSpline1(0.2075), bladeArmSpline2(0.2175), 0.04 scale <1, 0.5, 1>  }
            cylinder { bladeArmSpline1(0.24), bladeArmSpline2(0.25), 0.06 scale <1, 0.3, 1>  }
             
            // blade at end
            union {
                difference {
                    cylinder { <0, -0.04, 0> <0, 0.04, 0> 0.5 }
                   // cylinder { <0, -0.06, 0> <0, 0.06, 0> 0.3 scale <1, 1, 1.5> }
                    box { <-1.8, -1.8, -1.1> <1.8, 0, 1.2> rotate <0, 0, 5> translate <-0.4, -0.04, 0> }
                    box { <-1.8, 0, -1.2> <1.8, 1.8, 1.2> rotate <0, 0, -5> translate <-0.4, 0.04, 0> }
                    cone { <0, -0.051, 0> 0.45 <0, 0.001, 0> 0.35 scale <1, 1, 1.5> }
                    cone { <0, 0.051, 0> 0.45 <0, -0.001, 0> 0.35 scale <1, 1, 1.5> }
                    translate <0.5, 0, 0>
                    scale <1, 0.75, 1.0>*1.4
                    rotate <0, 90, 0>    
                    translate <0, 0, -0.4>
                    } 

                
                //cylinder { <0, 0, -0.2> <0, 0, 0.2> 0.2 }  
                difference {
                union {
                        object{ Round_Cone( <0,0,-0.3>, 0.3, <0,0,0.2>, 0.15 , 0.05, 0) 
                        scale <0.5, 1, 1> 
                        }
                        object{ Round_Cone( <0,0,-0.3>, 0.3, <0,0,0.2>, 0.15 , 0.05, 0) 
                        scale <1, 0.5, 1> 
                        } 
                }
                cylinder { <-1, 0, -0.4> <1, 0, -0.4> 0.15 rotate <0, 0, 0> }    
                scale <1, 0.5, 1>    
                }
                difference {
                    box { <-0.4, -0.03, -0.6> <0.4, 0.03, 0> }
                    cylinder { <-0.7, -0.1, 0> <-0.7, 0.1, 0> 0.635 }
                    cylinder { <0.7, -0.1, 0> <0.7, 0.1, 0> 0.635 }
                    translate <0, 0, 0.1>
                }                  
                translate bladeArmSpline1(1)
            } 
            
                // part that attaches blade to arm
                #declare bp3 = 0.75;   
                #declare bp3Diff=0.005;
                blob {
                threshold 0.6 
                #while(bp3 < 0.98)
                 //   cone { bladeArmSpline3(bp3), 0.20-(bp3*0.005) bladeArmSpline3(bp3+bp2Diff), 0.20-((bp3+bp3Diff)*0.005) scale <1, 0.2, 1> } 
                    sphere { 0, 0.08+((bp3-0.75)*0.075), 1 scale <1, 1, 1> translate bladeArmSpline1(bp3) }  
                    sphere { 0, 0.08+((bp3-0.75)*0.025), 1 scale <1, 1, 1> translate bladeArmSpline4(bp3) }  
                    sphere { 0, 0.08+((bp3-0.75)*0.025), 1 scale <1, 1, 1> translate bladeArmSpline5(bp3) }  
                    #declare bp3=bp3+bp3Diff;
                #end                            
                }
    
            rotate <0, 0, -60>
            translate <1.20, 0.725, 0.3>
       }   
       
       // arm left side scale -1
       union {  
            // base part
            union { 
                cylinder { bladeArmSpline1(0.0) bladeArmSpline1(0.05) 0.07 }
                #declare bDir = (bladeArmSpline1(0)-bladeArmSpline1(0.05));   
                torus { 0.06, 0.01 rotate <90, 0, 0> 
                transform {Reorient_Trans(z,bDir) }
                translate bladeArmSpline1(0.05)  
                                              
                }

            }
            union { 
                cylinder { bladeArmSpline2(0.0) bladeArmSpline2(0.05) 0.07 }
                #declare bDir = (bladeArmSpline2(0)-bladeArmSpline2(0.05));   
                torus { 0.06, 0.01 rotate <90, 0, 0> 
                transform {Reorient_Trans(z,bDir) }
                translate bladeArmSpline2(0.05)  
                                              
                }
            }

            // long parts
            #declare bp1 = 0;   
            #declare bp1Diff=0.03;
            
            #while(bp1 < 1)
                cone { bladeArmSpline1(bp1), 0.04-(bp1*0.005) bladeArmSpline1(bp1+bp1Diff), 0.04-((bp1+bp1Diff)*0.005) } 
                sphere { bladeArmSpline1(bp1+bp1Diff), 0.04-((bp1+bp1Diff)*0.005) }  
                #declare bp1=bp1+bp1Diff;
            #end 

            #declare bp2 = 0;   
            #declare bp2Diff=0.03;
            
            #while(bp2 < 0.4)
                cone { bladeArmSpline2(bp2), 0.04-(bp2*0.005) bladeArmSpline2(bp2+bp2Diff), 0.04-((bp2+bp2Diff)*0.005) } 
                sphere { bladeArmSpline2(bp2+bp2Diff), 0.04-((bp2+bp2Diff)*0.005) }  
                #declare bp2=bp2+bp2Diff;
            #end                            
            
            // join 2 arms together
            #declare bp3 = 0.265;   
            #declare bp3Diff=0.0025;
            blob {
            threshold 0.6 
            #while(bp3 < 0.45)
             //   cone { bladeArmSpline3(bp3), 0.20-(bp3*0.005) bladeArmSpline3(bp3+bp2Diff), 0.20-((bp3+bp3Diff)*0.005) scale <1, 0.2, 1> } 
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline1(bp3+bp3Diff) }  
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline2(bp3+bp3Diff+0.01) }  
                sphere { 0, 0.10-((bp3+bp3Diff)*0.125), 1 scale <1, 1, 1> translate bladeArmSpline3(bp3+bp3Diff+0.007) }  
                #declare bp3=bp3+bp3Diff;
            #end                            
            }
            
            // marker spheres
/*
            sphere { bladeArmSpline1(0.2) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline2(0.2) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline2(0.4) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.4) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.6) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(0.85) ,0.07 pigment { rgb <1, 0, 0> } }
            sphere { bladeArmSpline1(1) ,0.07 pigment { rgb <1, 0, 0> } }
*/
            // bridge parts   
            #declare bridgePos = 0.1;
            union {
            
                difference {
                    box { <-0.10, -0.035, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.035, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <0.10, 0, 0> }
                }
                intersection {
                    box { <-0.10, -0.04, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.04, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }                    
                }
                
                rotate <0, -10, 0>
                translate <0, 0, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5>+bladeArmSpline1(bridgePos)
            }
            #declare bridgePos = 0.15;
            union {
            
                difference {
                    box { <-0.10, -0.035, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.035, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    cylinder { <0, -0.05, 0> <0, 0.05, 0> (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5 scale <0.5, 1, 1> translate <0.10, 0, 0> }
                }
                intersection {
                    box { <-0.10, -0.04, -(bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> <0.10, 0.04, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }
                    torus { (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos)).z*0.5, 0.035 scale <0.5, 1, 1> translate <-0.10, 0, 0> }                    
                }
                
                rotate <0, 0, 0>
                translate <0, 0, (bladeArmSpline2(bridgePos).z-bladeArmSpline1(bridgePos).z)*0.5>+bladeArmSpline1(bridgePos)
                     
            }
                                                   
            cylinder { bladeArmSpline1(0.2075), bladeArmSpline2(0.2175), 0.04 scale <1, 0.5, 1>  }
            cylinder { bladeArmSpline1(0.24), bladeArmSpline2(0.25), 0.06 scale <1, 0.3, 1>  }
             
            // blade at end
            union {
                difference {
                    cylinder { <0, -0.04, 0> <0, 0.04, 0> 0.5 }
                   // cylinder { <0, -0.06, 0> <0, 0.06, 0> 0.3 scale <1, 1, 1.5> }
                    box { <-1.8, -1.8, -1.1> <1.8, 0, 1.2> rotate <0, 0, 5> translate <-0.4, -0.04, 0> }
                    box { <-1.8, 0, -1.2> <1.8, 1.8, 1.2> rotate <0, 0, -5> translate <-0.4, 0.04, 0> }
                    cone { <0, -0.051, 0> 0.45 <0, 0.001, 0> 0.35 scale <1, 1, 1.5> }
                    cone { <0, 0.051, 0> 0.45 <0, -0.001, 0> 0.35 scale <1, 1, 1.5> }
                    translate <0.5, 0, 0>
                    scale <1, 0.75, 1.0>*1.4
                    rotate <0, 90, 0>    
                    translate <0, 0, -0.4>
                    } 

                
                //cylinder { <0, 0, -0.2> <0, 0, 0.2> 0.2 }  
                difference {
                union {
                        object{ Round_Cone( <0,0,-0.3>, 0.3, <0,0,0.2>, 0.15 , 0.05, 0) 
                        scale <0.5, 1, 1> 
                        }
                        object{ Round_Cone( <0,0,-0.3>, 0.3, <0,0,0.2>, 0.15 , 0.05, 0) 
                        scale <1, 0.5, 1> 
                        } 
                }
                cylinder { <-1, 0, -0.4> <1, 0, -0.4> 0.15 rotate <0, 0, 0> }    
                scale <1, 0.5, 1>    
                }
                difference {
                    box { <-0.4, -0.03, -0.6> <0.4, 0.03, 0> }
                    cylinder { <-0.7, -0.1, 0> <-0.7, 0.1, 0> 0.635 }
                    cylinder { <0.7, -0.1, 0> <0.7, 0.1, 0> 0.635 }
                    translate <0, 0, 0.1>
                }                  
                translate bladeArmSpline1(1)
            } 
            
            // part that attaches blade to arm
            #declare bp3 = 0.75;   
            #declare bp3Diff=0.005;
            blob {
            threshold 0.6 
            #while(bp3 < 0.98)
             //   cone { bladeArmSpline3(bp3), 0.20-(bp3*0.005) bladeArmSpline3(bp3+bp2Diff), 0.20-((bp3+bp3Diff)*0.005) scale <1, 0.2, 1> } 
                sphere { 0, 0.08+((bp3-0.75)*0.075), 1 scale <1, 1, 1> translate bladeArmSpline1(bp3) }  
                sphere { 0, 0.08+((bp3-0.75)*0.025), 1 scale <1, 1, 1> translate bladeArmSpline4(bp3) }  
                sphere { 0, 0.08+((bp3-0.75)*0.025), 1 scale <1, 1, 1> translate bladeArmSpline5(bp3) }  
                #declare bp3=bp3+bp3Diff;
            #end                            
            }   
                    
            rotate <0, 0, -60>
            translate <1.20, 0.725, 0.3>
            scale <-1, 1, 1>
       } 
       // spline objects   


#declare spCount=0;
#while(spCount < 8) 
#declare spMulti=0.9+tr(0.3);      
#declare  spline1 = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.2, <(-0.1)+tr(0.2), -(0.2+tr(0.2)), -(0.8+tr(0.3))>*spMulti 
         0.4, <(-0.1)+tr(0.2), -(1.0+tr(0.2)), -(1.4+tr(0.3))>*spMulti 
         0.6, <(-0.1)+tr(0.2), -(1.6+tr(0.2)), -(2.2+tr(0.3))>*spMulti 
         0.8, <(-0.1)+tr(0.2), -(2.3+tr(0.2)), -(2.7+tr(0.3))>*spMulti 
         1.0, <(-0.1)+tr(0.2), -(2.8+tr(0.35)), -(3.9+tr(0.45))>*spMulti 
       };     
       
       
            #declare sp = 0;   
      union {
            blob {
            threshold 0.6
            #while(sp < 0.998)  
                #if(sp < 0.03)
                    sphere { spline1(sp), 0.05, 1 }  
                #else 
                    sphere { spline1(sp), 0.035-(sp/200), 1 }  
                #end
                #declare sp=sp+0.001;
            #end                
            sphere { spline1(0.998), 0.035-(sp/200), 1 pigment { rgb <0.9, 0.95, 1> } finish { emission 1 } }  

            }
    #declare spCount=spCount+1;    
          sphere{ 0,0.1
                  pigment { rgbt 1 } hollow
                           interior
                           { media
                             {
                               emission colour rgb <5,6,10> samples 20,100
                               density
                               { spherical turbulence 0.05 omega 0.7 density_map
                                 {
                                   [0.0 rgb <0, 0, 0> ]          
                                   [0.8 rgb <0.1, 0.1, .1>]
                                   [1 rgb <2.5, 2.5, 2.5> ]
                                 }  
                                scale <0.1, 0.1, 0.1> 
                               }
                             }
                           } 
      translate spline1(1)
          } 
            rotate <tr(30), 20-(spCount*4), 0>
            translate  <0, -0.065, -1.15>
            rotate <0, -30+(spCount*6.57), 0>                         
          }          
    #end

    // bit at base of neck 
    intersection {
        difference { 
            sphere { <0, 0, 0> 1.0 scale <1.1, 0.5, 1.1> }
            sphere { <0, 0, 0> 1.0 scale <1.1, 0.5, 1.1> translate <0, -0.1, 0> }
            cone { <0, -0.1, 0> 0.7 <0, 0.51, 0> 0.9 } 
            cylinder { <0, 0, 0> <0, 0, 3> 0.85 }          

            #declare cc1 = -90;
            #while(cc1 < 90)
                torus { 1 0.01 rotate <0, 0, 90> scale <1, 0.5, 1.1> rotate <0, cc1, 0> }
                #declare cc1=cc1+15;
            #end
        }   
        cone { <0, 0.51, 0> 1.4 <0, 0, 0> 1 }
        translate <0, -0.3, -0.2> 
    }

    // spikes on head
    union {
        cone { <0, 0, 0> 0.03 <0, 0.65, 0> .005 }
        sphere { <0, 0.75, 0> 0.005 }
        rotate <40, 0, 0> translate <0,2, 1>   
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.6, 0> .005 }
        sphere { <0, 0.7, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.9, 1.2> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.6, 0> .005 }
        sphere { <0, 0.65, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.8, 1.4> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.6, 0> .005 }
        sphere { <0, 0.6, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.7, 1.6> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.55, 0> .005 }
        sphere { <0, 0.55, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.65, 1.8> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.5, 0> .005 }
        sphere { <0, 0.5, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.6, 2.0> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.5, 0> .005 }
        sphere { <0, 0.5, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.575, 2.2> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.5, 0> .005 }
        sphere { <0, 0.45, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.55, 2.4> 
    }  
    union {                                   
        cone { <0, 0, 0> 0.03 <0, 0.5, 0> .005 }
        sphere { <0, 0.4, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.5, 2.6> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.45, 0> .005 }
        sphere { <0, 0.35, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.45, 2.8> 
    }  
    union {
        cone { <0, 0, 0> 0.03 <0, 0.45, 0> .005 }
        sphere { <0, 0.35, 0> 0.005 }
        rotate <40, 0, 0> translate <0,1.4, 3.0> 
    }  

                        
  }  
  
    rotate <-10, 0, 0>
}  


#declare tripod = union
{


object {tripodLeftLegAllParts translate <-8, 0, 0>  }
object {tripodRightLegAllParts translate <8, 0, 0>  }
object { tripodBackLegAllParts translate <0, 0, 15> }

object { bodyBase translate <0, 33.25, 6.5>  }

object { headBase  translate <-5, 35.5, 7> }
object { headBase  translate <-5, 35.5, 7> scale <-1, 1, 1> } 

object { neck rotate <-5, 0, 0> translate <0, 34.1, 3> }


object { head scale 3 rotate <-5, 0, 0> translate <0, 35, 6> }


//object { head scale 2 rotate <0, 20, 0> translate <0, 30, 0> }
//object { head scale 2 rotate <0, 90, 0> translate <0, 20, 0> }

#if(useTestTex)
texture { pigment { rgb 0.37 } finish { specular 1 } }
#else
texture { tripodTex } 
#end


}                 

