// PoVRay 3.7 Scene File " ... .pov"
// author:  ...
// date:    ...
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"        
#include "transforms.inc"    


#declare useRad                 = 0; // 1=load 2=save
#declare radQuality             = 7;// 1-10 1=low 10=high     // norad tood 36 minutes  with rad 2h33m
#declare useHDR                 = 1;
#declare useSubSurface          = 3; //1-10 used 4   
#declare useAntSubSurface       = 0; // switch on or off for ants
#declare useFocalBlur           = 5; // 1-10  used 6  
#declare showAnts               = 1; 
#declare lightLantern           = 0;   
#declare showTable              = 1;  
#declare showLantern            = 1;  
#declare useIso                 = 0;
#declare useTestTex             = 0;
#declare showTripod             = 1; 



global_settings{ assumed_gamma 1.0 }                                                                                                                                 

 
// radiosity (global illumination) settings
global_settings {   
 

#if(useSubSurface)
  mm_per_unit 5 // was 10
  subsurface { samples 10*useSubSurface, 2*useSubSurface radiosity on}// do another render with this on..
#end

#if(useRad)
ambient_light 0
  radiosity {

#if(useRad = 2)
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.0005           // end pretrace at this size
#end
#if(useRad = 1)
    pretrace_start 1           // start pretrace at this size
    pretrace_end   1           // end pretrace at this size
    always_sample off  // 
#end

    count 20*radQuality 75*radQuality                      // higher -> higher quality (1..1600) [35]

    nearest_count 10+(radQuality) 5+radQuality //10+(radQuality/2)               // higher -> higher quality (1..10) [5]

    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
//    maximum_reuse 0.1
    adc_bailout 0.01/2
    error_bound 1.1-(radQuality/10)               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    brightness 1               // brightness of radiosity effects (0..1) [1]
    normal on                  // take surface normals into account [off]

//  media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
#end 
}
// Set a color of the background (sky)
//background { color rgb< 1, 1, 1> }

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera {//perspective angle 90             // front view
                            location  <-2.5 , 2, -3.5> // x was -2.5  y was 2.0
                            right     x*image_width/image_height
                            look_at   <-0.6 , -0.5 , -1.0>
                            
                            
#if(useFocalBlur)
  aperture 0.05// 0.05         // [0...N] larger is narrower depth of field (blurrier)
  blur_samples useFocalBlur*10       // number of rays per pixel for sampling
  focal_point <-1, 1, -2.5>//<1, 1, 3.5> // z=0.5 <3.075, 1, -2.25>
  confidence 0.9+(0.009*useFocalBlur) //0.8999+(useFocalBlur/1000)           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/(20000*useFocalBlur)            // [0...1] how precise to calculate (smaller is more accurate)
#end                            
                            }   
                            
                            
#declare ageneralRand = seed(2150);   

// Macros to return a random number

#macro ar(num)
        rand(ageneralRand)*num
#end

#declare tgeneralRand = seed(150);   

// Macros to return a random number

#macro tr(num)
        rand(tgeneralRand)*num
#end


// sun ----------------------------------------------------------------------
//light_source{< 3000,3000,-3000> color White}
// sky ----------------------------------------------------------------------
/*sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere

  */

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  <0,0,0>             // light's position (translated below)
  color rgb <1, 0.75, 0.6>*0.3      // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>   // <x y z> position of light  
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 150
  fade_power 2

}

//-------------------------------------------------------------------------
#declare spoon = union {
    union { 
        difference {
        union
        {        
            intersection {
                sphere { <0, 0, 0> 1 }
                box { <0, -1.1, -1.1> <1.1, 1.1, 1.1> }
                }
            intersection {
            sphere { <0, 0, 0> 1 }
            box { <-1.1, -1.1, -1.1> <0, 1.1, 1.1> }
            scale <1.5, 1, 1> 
            }
        } 
        union
        {        
            intersection {
                sphere { <0, 0, 0> 1 }
                box { <-0.0001, -1.1, -1.1> <1.1, 1.1, 1.1> }
                }
            intersection {
            sphere { <0, 0, 0> 1 }
            box { <-1.1, -1.1, -1.1> <0, 1.1, 1.1> }
            scale <1.5, 1, 1> 
            } 
            scale 0.95
            
        }    
            box { <-3, -0.3, -1.1> <1.1, 1.1, 1.1> }
       } 
       
       union {
       intersection {
            torus { 0.97, 0.03 }
            box { <0, -0.2, -1.2> <1.2, 0.2, 1.2> }
       
       }
       
       intersection {
            torus { 0.97, 0.03 }
            box { <-1.2, -0.2, -1.2> <0, 0.2, 1.2> }
            scale <1.5, 1, 1> 
       }
       scale 0.956
       scale <1, 1.25, 1> 
       translate <0, -0.3, 0> 
       }  
       
    }      
    
    union {
        difference {  
        intersection { 
            torus { 0.3, 0.1 rotate <90, 0, 0> scale <1, 1, 2> }
            box { <-0.5, 0, -0.5> <0, 0.5, 0.5> rotate <0, 0, -15> } 
            }  
            box { <0, 0, -0.5> <0.5, 0.5, 0.5> rotate <0, 0, 10> }
            
            rotate <0, 0, 15>
            translate <1.35, 0, 0> 
            rotate <0, 0, -15>
        }

        intersection { 
            torus { 1.05, 0.1 rotate <90, 0, 0> scale <1, 1, 2> }
            box { <0, -1.4, -1.4> <1.4, 0, 1.4> rotate <0, 0, -15> }
        }  

        union {
            cone { <0, 0, 0> 0.1, <5, 0, 0> 0.25 }
            intersection {
                sphere { <0, 0, 0> 0.25 }
                box { <0, -0.3, -0.3> <0.4, 0.3, 0.3> }
                scale <2, 1, 1>
                translate <5, 0, 0>
            }
            scale <1, 1, 2> translate <0, 0.3, 0>            rotate <0, 0, 25>
            translate <1.35, 0, 0> 
            rotate <0, 0, -12>
         }
 
        translate <-0.05, 0, 0>
    }    
    scale <1, 0.5, 1>
    rotate <0, 0, 0>
    scale 0.275
    rotate <0, 0, -8.1>
    material {
    texture { 
        pigment { rgb <0.035, 0.032, 0.0275>*4 }  
        finish { specular albedo 0.1 roughness 0.1 diffuse albedo 0.25 brilliance 8 metallic 0.5 reflection { 0.075, 0.2  fresnel on } conserve_energy }     
        normal { granite 0.025 scale 0.001 }
     } 
     interior { ior 1.6 }
     }
    } // ------------------------------------------------------------------ 
//-------------------------------------------------------------------------

object { spoon rotate <0, 0, -1.5> rotate <0, 181, 0> translate <0.9, 0.14, 2.665> }
object { spoon rotate <0, 0, -1.5> rotate <0, 88+180, 0> translate <2.7, 0.14, -0.4> }
object { spoon rotate <0, 0, -1.5> rotate <0, -89+180, 0> translate <-3.05, 0.14, 1.1> }
//object { spoon  rotate <0, 182, 0> translate <1.0, 0.14, -2.85> }
object { spoon  rotate <0, 180, 0> rotate <-15, 0, -37> rotate <0, 50, 0> translate <0.4, 0.22, -3.70> }




#declare chinaWhiteTex = texture {
//    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.0 rgb <1, 0.995, 0.975>*0.65 ] [ 1.0 rgb <0.97, 0.95, 0.9>*0.65 ] } scale <4, 0.05, 4> turbulence 0.5 }
    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.0 rgb <1, 0.995, 0.975>*0.7 ] [ 1.0 rgb <0.97, 0.95, 0.9>*0.7 ] } scale <4, 0.075, 4> turbulence 0.5 }
    normal { average normal_map { [ 1 wrinkles 0.5 scale <10, 0.05, 10> turbulence 0.45 ] [0.5 granite 0.025 scale 0.002 ] }}
    finish { specular albedo 0.1 roughness 0.25 diffuse albedo 0.6 brilliance 1.1 }
} 
texture {  
    pigment { rgbt <0.975, 0.95, 0.9, 0.95> }
//    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.008, 0.025 fresnel on } conserve_energy }
    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.01, 0.1 fresnel on } conserve_energy }
    normal { granite 0.0125 omega 0.5 scallop_wave scale <0.9, 0.1, 0.2> rotate <30, 22, 150> }
}

#declare chinaWhiteTexInside = texture {
//    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.0 rgb <1, 0.995, 0.975>*0.65 ] [ 1.0 rgb <0.97, 0.95, 0.9>*0.65 ] } scale <4, 0.05, 4> turbulence 0.5 }
    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.0 rgb <1, 0.995, 0.975>*0.7 ] [ 1.0 rgb <0.97, 0.95, 0.9>*0.7 ] } scale <4, 0.075, 4> turbulence 0.5 }
    normal { average normal_map { [ 1 wrinkles 0.5 scale <10, 0.05, 10> turbulence 0.45 ] [0.1 granite 0.025 scale 0.002 ] }}
    finish { specular albedo 0.1 roughness 0.25 diffuse albedo 0.6 brilliance 1.1 }
} 
texture {  
    pigment { rgbt <0.975, 0.95, 0.9, 0.95> }
//    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.008, 0.025 fresnel on } conserve_energy }
    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.03, 0.2 fresnel on } conserve_energy }
    normal { wrinkles 0.0125 omega 0.5 scallop_wave scale <0.2, 0.1, 0.2> }
}

#declare chinaBlueTex = texture {
//    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.3 rgb <0.01, 0.025, 0.15>*0.8 ][ 0.5 rgb <0.09, 0.11, 0.2>*0.8 ] [ 0.7 rgb <0.008, 0.025, 0.1>*0.8 ] } scale <4, 0.05, 4> turbulence 0.5 }
    pigment { gradient y omega 0.7 lambda 2.9 colour_map { [ 0.3 rgb <0.01, 0.02, 0.15>*0.8 ][ 0.5 rgb <0.035, 0.075, 0.2>*0.8 ] [ 0.7 rgb <0.008, 0.02, 0.1>*0.8 ] } scale <4, 0.075, 4> turbulence 0.5 }
    normal {  average normal_map { [ 1 wrinkles 0.5 scale <10, 0.05, 10> turbulence 0.45 ] [0.5 granite 0.025 scale 0.002 ] } }
    finish { specular albedo 0.1 roughness 0.25 diffuse albedo 0.6 brilliance 1.1 }
} 
texture {  
    pigment { rgbt <0.975, 0.95, 0.9, 0.95> }
    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.01, 0.1 fresnel on } conserve_energy }
//    finish { specular albedo 0.2 roughness 0.0025 diffuse albedo 0.4 brilliance 2.0 reflection { 0.008, 0.025 fresnel on } conserve_energy }
    normal { granite 0.0125 omega 0.5 scallop_wave scale <0.9, 0.1, 0.2> rotate <30, 22, 150> }
}

#declare chinaBlueWhiteTex = texture {  gradient y triangle_wave scale <1, 0.25, 1> translate <0, -0.0225, 0>
    texture_map {  [ 0.0 chinaWhiteTex ] [ 0.475 chinaWhiteTex ] [ 0.525 chinaBlueTex ] [ 1.0 chinaBlueTex ] } 
}


// bowl
#declare bowl = union {
difference {
intersection { 
    sphere { 0, 1 }
    box { <-1.1, -0.75, -1.1> <1.1, 0, 1.1> }
    } 
    sphere { 0, 0.975 texture { chinaWhiteTexInside } }   
}
    difference { 
        cylinder { <0, 0, 0> <0, 0.125, 0> 1.025 }
        cylinder { <0, -0.01, 0> <0, 0.31, 0> 0.975 }       
    }                                                
    torus { 1, 0.025 }
    torus { 1, 0.025 translate <0, 0.125, 0> }
    difference { 
        cylinder { <0, -0.775, 0> <0, -0.75, 0> 0.665 } 
        cylinder { <0, -0.8, 0> <0, -0.76, 0> 0.665 } 
    }
    torus { 0.64, 0.025 translate <0, -0.775, 0> }
    texture { chinaBlueWhiteTex }  
    translate <0, 0.8, 0>  
    scale 0.85
}             

object { bowl translate <0.1, 0, 3.7>  }
object { bowl translate <0, 0, -3.8>  }

object { bowl translate <3.7, 0, 0.2>  }
object { bowl translate <-3.8, 0, 0.1>  }

// honey dipper


#declare MyWoodFinish = finish { specular albedo 0.22 roughness 0.05 brilliance 2 diffuse albedo 0.5 }        
#declare MyWoodFinish2 = finish { specular albedo 0.25 roughness 0.025 brilliance 3 diffuse albedo 0.4 }        

#declare MyWoodNormal = normal { average normal_map {  

[ 1 
                        granite 0.75
                        scallop_wave    
                        turbulence 1.5
                        omega 0.7 
                        scale <15, 0.03, 0.05>
                        ]
[0.25 granite  0.5 turbulence 0.3 scale <0.5, 0.045, 0.03> ] 
   [ 0.75 wood 0.5 triangle_wave   omega 0.7 lambda 2.1 
turbulence 0.07 
rotate <1, 92, 1>    
scale <0.5, 0.04, 0.075>   
translate <0, 0.87, -0.750>  ]                              
[ 1.0 dents 0.5 turbulence 0.175 omega 0.75 lambda 3 scale 0.05  ]
[ 0.8 bumps 0.05 turbulence 0.475 omega 0.5 lambda 2.2 scale 0.025  ]
 }     
}


#declare MyWood = texture {
pigment { 
wrinkles     
omega 0.7                       
turbulence 0.254
lambda 2.45
colour_map {
[ 0.0 rgb <0.225, 0.0875, 0.057>*2 ]
[ 0.4 rgb <0.16, 0.054, 0.052>*2 ]
[ 0.7 rgb <0.29, 0.07, 0.052>*2 ]
[ 0.9 rgb <0.23, 0.088, 0.058>*2 ]
[ 1.0 rgb <0.205, 0.0795, 0.045>*2 ]   

}   
scale <0.12, 0.12, 1>
rotate <10, 92, 0>
     
} 
finish { MyWoodFinish }    
normal { MyWoodNormal scale 2 }     
} 
texture {
pigment { wood triangle_wave   omega 0.7357 lambda 2.1
turbulence 0.0875

color_map {

[ 0.0 rgbt <0.30, 0.23, 0.088, 0.88>*1.0 ]
[ 0.025 rgbt <0.30, 0.25, 0.08325, 0.54>*1.0 ]
[ 0.07 rgbt <0.29, 0.21, 0.098, 0.96>*1.0 ]
[ 0.125 rgbt <0.28, 0.215, 0.065, 0.27>*1.0 ]
[ 0.4 rgbt <0.20, 0.175, 0.0639, 0.384>*1.0 ]
[ 1.0 rgbt <0.17, 0.145, 0.038, 0.84>*1.0 ]   
}  

rotate <2, 0, 0>
rotate <0, 92, 3> 
  warp {
    black_hole <-0.4, 0.749, 0.05>, 0.2   // position and radius
    strength 4                    // strength of deformation
    repeat <0.5, 0.5, 0.1> 
    turbulence <0.25, 0.25, 0.1> 
    inverse                        // invert effect             
  }  
//  scale <1.5, 1, 1>
scale <1, 0.1, 0.1>
}
finish { MyWoodFinish }
normal { MyWoodNormal scale 2 }     
} 
texture {
pigment { wood triangle_wave   omega 0.7 lambda 2.1
turbulence 0.0475

color_map {
[ 0.0 rgbt <0.16, 0.13, 0.0824, 0.24>*1.0 ]
[ 0.7 rgbt <0.25, 0.21, 0.098, 0.84>*1.0 ]
[ 0.8 rgbt <0.32, 0.28, 0.101, 1.44>*1.0 ]
[ 0.95 rgbt <0.19, 0.15, 0.0635, 0.64>*1.0 ]
[ 1.0 rgbt <0.15, 0.118, 0.061, 0.44>*1.0 ]
}  
 
rotate <0, -75, -40>    
scale <0.3, 0.0291275, 0.05>   
translate <0.524, 0.814, -0.750>   
  warp {
    black_hole <-0.4, 0.749, 0.05>, 0.2   // position and radius
    strength 4                    // strength of deformation
    inverse                        // invert effect
  }  
  scale <1.5, 1, 1>   
  translate <0.4, -0.2, 0>

}
finish { MyWoodFinish }
normal { MyWoodNormal scale 2 }     
}

#declare hMat =   material {
  texture{ pigment{ color rgbft<0.5, 0.28, 0.001, 0.15, 0.6> }
           finish { specular albedo 0.25  roughness 0.3 phong albedo 0.3 phong_size 30 diffuse albedo 0.6 brilliance 2.1 reflection { 0.008, 0.03 fresnel on } conserve_energy  
#if(useSubSurface)
      subsurface { translucency <.1, .21, 0.4>*4 }  //0.9
#end           
           }
           normal { dents 0.2 scale 0.5 }
           } 
         interior { ior 1.45 }
         }   

#declare dipper = union {
    object{ Round_Cone( <0,0,0>, 0.10, <0.1, 0, 0>, 0.20 , 0.025, 0) }  
    cone { <0.125, 0, 0> 0.1 <0.15, 0, 0> 0.2 } 
    torus { 0.2, 0.02 rotate <0, 0, 90> translate <0.17, 0, 0> }
    cone { <0.19, 0, 0> 0.2 <0.215, 0, 0> 0.1 } 

    cone { <0.215, 0, 0> 0.1 <0.24, 0, 0> 0.23 } 
    torus { 0.23, 0.02 rotate <0, 0, 90> translate <0.26, 0, 0> }
    cone { <0.28, 0, 0> 0.23 <0.305, 0, 0> 0.1 } 

    cone { <0.305, 0, 0> 0.1 <0.330, 0, 0> 0.24 } 
    torus { 0.24, 0.02 rotate <0, 0, 90> translate <0.35, 0, 0> }
    cone { <0.37, 0, 0> 0.24 <0.395, 0, 0> 0.1 } 

    cone { <0.395, 0, 0> 0.1 <0.420, 0, 0> 0.24 } 
    torus { 0.24, 0.02 rotate <0, 0, 90> translate <0.44, 0, 0> }
    cone { <0.46, 0, 0> 0.24 <0.485, 0, 0> 0.1 } 

    cone { <0.485, 0, 0> 0.1 <0.510, 0, 0> 0.21 } 
    torus { 0.21, 0.02 rotate <0, 0, 90> translate <0.53, 0, 0> }
    cone { <0.55, 0, 0> 0.21 <0.575, 0, 0> 0.1 } 
    
    cylinder { <0.05, 0, 0> <0.62, 0, 0> 0.1 }
    
    union {
        intersection {
            torus { 0.2, 0.02 rotate <0, 0, 90> }
            box { <-0.1, -0.3, -0.3> <0, 0.3, 0.3> }
        }
        cylinder { <-0.02, 0, 0> <0, 0, 0> 0.2 }  
        intersection {
            sphere { 0, 0.22 }
            box { <0, -0.3, -0.3> <0.3, 0.3, 0.3> } 
            scale <0.75, 1, 1>           
        }
        translate <0.615, 0, 0>
    } 
    // handle
    cone { <0.6, 0, 0> 0.075 <2, 0, 0> 0.1 }
    difference {
        cylinder { <2, 0, 0> <2.025, 0, 0> 0.125 }
        torus { 0.125, 0.025 rotate <0, 0, 90> translate <2.0, 0, 0> }
    }                                                                  
    torus { 0.125, 0.025 rotate <0, 0, 90> scale <2, 1, 1> translate <2.075, 0, 0> }
    cylinder { <2.12, 0, 0> <2.125, 0, 0> 0.125 }
} 


union {
// dipper
object { dipper
    texture { 
    MyWood    
    }    
 scale 0.7 
 rotate <0, 0, -4>
 }   
// honey

blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
//sphere{ 0, 0.39, 1 scale <0.7,1,0.95> translate <0.08, 0.0, 0> rotate <0, 0, -8> }
//sphere{ 0, 0.47, 1 scale <0.2,1,0.95> translate <0.14, -0.015, 0>rotate <0, 0, -8> }
//sphere{ 0, 0.5, 1 scale <0.2,1,0.95> translate <0.22, -0.0175, 0> rotate <0, 0, -8>}
//sphere{ 0, 0.51, 1 scale <0.3,1,0.9> translate <0.32, -0.0225, 0> rotate <0, 0, -8>}
//sphere{ 0, 0.5, 1 scale <0.4,1,0.9> translate <0.41, -0.035, 0> rotate <0, 0, -8>}

sphere{ 0, 0.37, 1 scale <0.7,1,0.95> translate <0.08, -0.0125, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.32, 1 scale <0.2,0.95,0.95> translate <0.18, -0.04, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.37, 1 scale <0.2,0.95,0.95> translate <0.24, -0.04, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.47, 1 scale <0.2,0.95,0.95> translate <0.34, -0.03, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.44, 1 scale <0.2,0.95,0.95> translate <0.42, -0.025, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.3, 1 scale <0.2,0.95,0.95> translate <0.46, -0.025, 0> }

cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.32, 1 scale <0.2,0.95,0.95> translate <0.18, -0.34, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.37, 1 scale <0.2,0.95,0.95> translate <0.24, -0.304, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.47, 1 scale <0.2,0.95,0.95> translate <0.34, -0.303, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.44, 1 scale <0.2,0.95,0.95> translate <0.42, -0.3025, 0> }
cylinder{ <-0.05, 0, 0>, <0.05, 0, 0>, 0.3, 1 scale <0.2,0.95,0.95> translate <0.46, -0.3025, 0> }


  sphere { 0, 0.5, 1 scale <1, 0.15, 0.7> rotate <0 -30, 0> translate <-0.1, -0.25, 0> }
  sphere { 0, 0.65, 1 scale <0.8, 0.13, 1.1> rotate <0, 10, 0> translate <0.2, -0.265, -0.20> }
material { hMat }
   scale 0.7 
 } //------------------------------------------------------ end of blob object  
 
 rotate <0, -28, 0>
 translate <0, 0.2, 0>
 scale 0.9
 translate <-2.4, 0, -0.6>
 
}
#declare myGlass = material {
    texture {
    pigment { rgbt <0.99, 1, 0.99, 0.99> }
    finish { specular albedo 0.8 roughness 0.01 brilliance 5 diffuse albedo 0.1 reflection { 0.01, 0.4 fresnel on } conserve_energy } 
    }
    interior { ior 1.5 }
}
// honey pot   
#declare brownCeramic = texture {
    pigment { granite omega 0.8   turbulence 0.4 scale <0.02, 0.1, 0.02>  colour_map { [ 0.0 rgb <0.04, 0.013, 0.001> ] [ 0.45 rgb <0.02, 0.01, 0.0002> ] [ 0.9 rgb <0.2, 0.085, 0.01>*1.5 ]  } }
    finish { specular albedo 0.3 roughness 0.02 brilliance 4.2 diffuse albedo 0.35 reflection { 0.01, 0.2 fresnel on } conserve_energy }
    normal { average normal_map { [ 1  granite 0.1 omega 0.7 scale <0.02, 0.1, 0.02>  ] [ dents 1 scale <0.02, 0.1, 0.02>  ] } } 
}                              
#declare lightCeramic = texture {
    pigment { granite omega 0.8   turbulence 0.4 scale <0.02, 0.1, 0.02>   colour_map { [ 0.0 rgb <0.3, 0.165, 0.05>*1.5 ] [ 0.45 rgb <0.2, 0.085, 0.01>*1.5 ] [ 0.8 rgb <0.04, 0.015, 0.001> ]  } }
    finish { specular albedo 0.3 roughness 0.02 brilliance 2.2 diffuse albedo 0.45 reflection { 0.01, 0.2 fresnel on } conserve_energy }
    normal { average normal_map { [ 1  granite 0.1 omega 0.7 scale <0.02, 0.1, 0.02>  ] [ dents 1 scale <0.02, 0.1, 0.02>  ] } } 
}    

union {
    torus { 0.45, 0.05 scale <1, 1.5, 1> }
    torus { 0.42, 0.05 scale <1, 1.5, 1> translate <0, 0.125, 0>}
    torus { 0.39, 0.05 scale <1, 1.5, 1> translate <0, 0.25, 0>}
    torus { 0.36, 0.05 scale <1, 1.5, 1> translate <0, 0.375, 0>}
    torus { 0.33, 0.05 scale <1, 1.5, 1> translate <0, 0.5, 0>}
    
    // lid
    union {
    difference {
        intersection { 
            sphere { 0, 0.35 }
            cone { <0, 0, 0> 0.3, <0, 0.5, 0> 1 }
        }
        sphere { <0, -0.1, 0> 0.35 }
        cone { <0, 0, 0.02> 0.10 <0, 0.3, 0> 0.15 scale <1, 1, 1.4> translate <0, -0.01, -0.4> }
        scale <1, 0.45, 1>
    }
        intersection { 
            sphere { 0, 0.375 }
            sphere { <0, 0.375, 0> 0.125 }
            scale <1, 0.45, 1>
        }                         
        difference {
            cylinder { <0, 0, 0> <0, 0.15, 0> 0.1 }
            torus { 0.1, 0.03 scale <1, 2, 1> translate <0, 0.075, 0> }
            translate <0, 0.375*0.425, 0>
        }  
        intersection {
            sphere { 0, 0.1 }
            box { <-0.2, 0, -0.2> <0.2, 0.2, 0.2> } 
            scale <1, 0.4, 1> 
            translate <0, 0.375*0.425, 0>
            translate <0, 0.15, 0> 
        }
        translate <0, 0.575, 0>   
        rotate <0, -33, 0>
    texture {
        gradient y triangle_wave omega 0.7 turbulence 0.1 texture_map {
            [ 0.0 brownCeramic scale 0.5 ]
            [ 1.0 lightCeramic scale 0.5 ]  
        }
            scale <1, 0.25, 1>  
            translate <0, 0.575, 0>
    }

    }                   
    texture {
        gradient y triangle_wave omega 0.7 turbulence 0.1 texture_map {
            [ 0.0 brownCeramic ]
            [ 0.2 brownCeramic ]
            [ 0.4 lightCeramic ]  
            [ 1.0 lightCeramic ]  
        }  
            scale <1, 0.125, 1>  
            translate <0, -0.045, 0>
    }
    translate <0, 0.075, 0>
    scale 1.15     
    translate <-2, 0, 1>
}


        
// floor 

/*
plane { y, -2.19
 // ----------------- HF_Square macro ------------------
material {       

texture {  
pigment { rgb 1 } 
// pigment { tcpcheck  }

finish { specular albedo 0.2 diffuse albedo 0.5 roughness 0.05 brilliance 2.3 reflection { 0.006, 0.05 fresnel on } conserve_energy } }
interior { ior 1.6 }
}                          // tiling pattern in the xz plane  
//  translate<0,-2.19,0>
 
}
*/


#if(showTable)
#declare tcp1 = pigment{
           tiling 6 // 1~24 Pattern_Number
              color_map{
                [ 0.0 color rgb<1,0.009,0>*0.7]
                [ 0.5 color rgb<1,0.009,0>*0.6]
                [ 1.0 color rgb<1,0.009,0>*0.4]
                } // end color_map
           scale 0.05   
           turbulence 0.025
           
           // rotate<-90,0,0> // align to xy plane
        } // end pigment
#declare tcp3 = pigment{
           tiling 6 // 1~24 Pattern_Number
              color_map{
                [ 0.0 color rgb<1,.99,.98>*0.8]
                [ 0.5 color rgb<1,.99,.98>*.7]
                [ 1.0 color rgb<1,.99,.98>*0.6]
                } // end color_map
           scale 0.05
           turbulence 0.025
           // rotate<-90,0,0> // align to xy plane
        } // end pigment
#declare tcp4 = pigment{
           tiling 6 // 1~24 Pattern_Number
              color_map{
                [ 0.0 color rgb<1,.105,0.10>*0.7]
                [ 0.5 color rgb<1,.255,0.25>*.6]
                [ 1.0 color rgb<1,.255,0.25>*0.4]
                } // end color_map
           scale 0.05
           turbulence 0.025
           // rotate<-90,0,0> // align to xy plane
        } // end pigment

#declare tcpcheck = pigment {  // new in POV-Ray 3.7
  square //max.4 colors/textures
  pigment { tcp1 }
  pigment { tcp4 rotate <0, 90, 0> }
  pigment { tcp3 rotate <0, 180, 0>}
  pigment { tcp4 rotate <0, -90, 0>}  
  scale 2     
  turbulence 0.005 omega 1.5 lambda 10
  //rotate<-90,0,0>
}
  
   
#declare hf2func=function{pattern{bumps omega 0.4 lambda 1 
    scale .02 }}   

#declare hf3func=function{pigment{marble sine_wave omega 0.1 lambda 11 turbulence 0.03 frequency 3
    scale 1 colour_map { [ 0.0 rgb 0][ 0.999 rgb 0] [ 1.0 rgb 0.5 ] } }}   

#declare hf4func=function{pigment{marble sine_wave omega 0.1 lambda 11 turbulence 0.03 frequency 3
    scale 1 colour_map { [ 0.0 rgb 0][ 0.999 rgb 0] [ 1.0 rgb 0.5 ] } rotate <0, 90, 0> }}  
     
// -----------------------------------------------------

height_field{function 800,800 {hf2func(x,0,y)*0.001+hf3func(x,0,y).red*0.003+hf4func(x,0,y).red*0.003} smooth
  translate <-0.5, -0.00125, -0.5>
  scale 10

material {       

texture {                       
  
 pigment { tcpcheck scale 0.06  }//checker pigment { tcpcheck scale 0.25 } , pigment { tcpcheck scale 0.125 } scale 0.05 }

finish { specular albedo 0.05 diffuse albedo 0.4 roughness 0.08 brilliance 3.0 reflection { 0.007, 0.015 fresnel on } conserve_energy }
normal { granite 0.02 scale 0.0025}      
}
interior { ior 1.6 }
}                          //        rotate <0, -30, 0>
} 


#end // end of show table

#if(useHDR)
sphere  { 0 1 hollow
  pigment{
    image_map{ hdr "Backyard_Ref_original.hdr"// "SM_HDRI-Pack3-14.hdr"  // was harbour   Harbour_3_Ref  Japan_blossom_FINAL
               
               map_type 1 interpolate 2 }
                   
               
      }// end pigment        
      finish { ambient 1 diffuse 1 emission 0.35}
    scale 4000 // no_image
// rotate <0, -10, 0>   
// rotate <10, 0, 0>
// rotate <0, 140, 0>
 rotate <0, 0, 0>  // -140
// rotate <10, 0, -10>
//  no_image
} // end
#end     

#macro getSplinePos(lSpline, currentPoint, nextDistance, stepSize)

#local pPos=currentPoint;      
#local totalLen = 0;
#local stepLen=0;
#while(stepLen <= nextDistance)
        #local pPos=pPos+stepSize;
        #if(pPos > 1.0)
            #local pPos=1.0;
            #break
        #end
        #local stepLen=vlength(lSpline(pPos)-lSpline(currentPoint));
//        #warning str(stepLen, 5, 5)
#end                                     
pPos

#end

#macro mkAntennae(rad, spos, epos, tSpline)
        #local lspos = spos;    
        #local lrad = rad;
        #local nextBlob=lspos;
        #local srad=rad;    
        #local rChange = 0.4; 
        #local rChangeDiff=0.1; 
        #local rRad = rad*0.9;
                
                

                #while (lspos < epos)      
                   
              
                   #local Direction = (tSpline(lspos+0.001) -tSpline(lspos-0.001));   


                   sphere { 0, srad, 1 scale <1, 1, 0.6>   
                   //transform {Reorient_Trans(z,Direction)}   
                   translate tSpline(lspos)
                   
                   }
                   #if(lspos > 0.95)
                    #local srad=srad*0.975;//*1.005;                    
                   #else  
                   #if(lspos < 0.4)
                    #local srad=asin(srad*1.005);//*1.005; 
                   #else 
                    
                    #if(lspos < rChange) 
                    #local srad=asin(srad*1.01);  
                    #else
                    #local rChange=rChange+rChangeDiff;
                    #local rChangeDiff=rChangeDiff*0.85;
                    #local srad=rRad;
                    #local rRad=rRad*1.05;
                    #end
                   #end
                   #end  
                   #local lspos = getSplinePos(tSpline, lspos, srad*0.1, 0.001);                    

                #end 
                                
#end
                    // 4    //115
 #declare antColour=<0.225, 0.07, 0.0015>;   
 #declare antColourBeige=<0.5, 0.3, 0.1>;
 #declare antColourLight=<100/255, 18/255, 3/255>;
 #declare antHairColour=<140/255, 70/255, 30/255>*0.3;
 

#declare antBody1 =   texture{ pigment{ bozo triangle_wave  turbulence 0.4 omega 0.7 lambda 4 colour_map { [ 0.0  color rgb antColour*0.15 ] [ 1.0 color rgb antColour*0.1 ] } scale <0.035, 0.1, 0.05> }
           finish { specular albedo 0.1 roughness 0.005 diffuse albedo 0.5 brilliance 2.5 reflection { 0.01, 0.075 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*.25 }  //0.9
#end
          
            }
           normal { average normal_map { [ 1 dents 0.04 scale <0.025, 0.5, 0.025> turbulence 0.4 omega 0.7 ] 
                              [ 1 wrinkles 0.025 scale <0.025, 0.5, 0.025> turbulence 0.4 omega 0.7 ] 
           }}
         }   

#declare antBody2 =   texture{ pigment{ bozo triangle_wave  turbulence 0.5 omega 0.8 lambda 3 colour_map { [ 0.0  color rgb antColour*0.1 ] [ 1.0 color rgb antColour*0.15 ] } scale <0.135, 0.2, 0.1> }
           finish { specular albedo 0.07 roughness 0.05 diffuse albedo 0.5 brilliance 1.25 reflection { 0.005, 0.02 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*0.5 }  //0.9
#end
          
            }
           normal { agate 0.075 scallop_wave scale 0.25 agate_turb 0.5 omega 0.675 lambda 3.4 }
         }   
         
#declare antBody3 =   texture{ pigment{ bozo triangle_wave  turbulence 0.3 omega 0.7 lambda 2.4 colour_map { [ 0.0  color rgb antColourBeige*0.7 ] [ 1.0 color rgb antColourBeige*0.5 ] } scale <0.1, 0.05, 0.15> }
           finish { specular albedo 0.1 roughness 0.025 diffuse albedo 0.6 brilliance 1.15 reflection { 0.005, 0.06 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*1}  //0.9
#end
          
            }
           normal { granite 0.025 scallop_wave scale 0.001 turbulence 0.3 omega 0.7 }
         }   
#declare antBody4 =   texture{ pigment{ rgb 0.001  }
           finish { specular albedo 0.005 roughness 0.05 diffuse albedo 0.3 brilliance 3.15 reflection { 0.005, 0.008 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*0.1}  //0.9
#end
          
            }
           normal { granite 0.025 scallop_wave scale 0.001 turbulence 0.3 omega 0.7 }
         }   

         
#declare antLegMat = material {
texture{ pigment{ wrinkles triangle_wave turbulence 0.7 omega 0.8 lambda 3 colour_map { 
    [ 0.0  color rgb antColour*0.1] 
    [ 0.1 color rgb antColourLight*0.65]
     [ .3 color rgb antColour*0.05] 
    [ 0.5 color rgb antColourLight*0.4]
     [ .65 color rgb antColour*0.05] 
     [ .9 color rgb antColour*0.15] 
     [ 1 color rgb 0.02 ]
     } scale <0.5, 0.5, 0.5> }
           finish { specular albedo 0.1 roughness 0.015 diffuse albedo 0.5, 0.1 brilliance 2.0 reflection { 0.005, 0.09 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*1 }  //0.9
#end
          
            }
           normal { granite 0.01 scale 0.0001 turbulence 0.7 omega 0.75 }
         } 
         interior { ior 1.6 }  
}

#declare antMat =   material { texture { gradient y scale 2 turbulence 0.025 translate <0, 0.075, 0> omega 0.7 lambda 2.8 triangle_wave texture_map { 
 [ 0.45  pigment{ granite  triangle_wave colour_map { [ 0.0 color rgb antColourLight*0.8 ] [ 0.0 color rgb antColourLight*0.2 ] [ 1.0 rgb antColourLight*0.7 ] } turbulence 0.2 omega 0.65 lambda 3.2 scale 0.1 }
           finish { specular albedo 0.1 roughness 0.0015 diffuse albedo 0.6, 0.2 brilliance 0.9 reflection { 0.005, 0.025 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*9 }  //0.9
#end
            }
           normal { granite 0.2 scallop_wave scale 0.007 turbulence 0.3 omega 0.7 }
          
         ]

 [ 0.6  pigment{ granite triangle_wave  colour_map { [ 0.0 rgb antColour*0.2 ] [ 1.0 rgb antColour*0.1 ] } turbulence 0.5 omega 0.8 lambda 2.5 scale 0.1 }
           finish { specular albedo 0.1 roughness 0.0015  diffuse albedo 0.5, 0.1 brilliance 1.2 reflection { 0.005, 0.035 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*1 }  //0.9
#end
          
            }
           normal { granite 0.2 scallop_wave scale 0.007 turbulence 0.3 omega 0.7 }
          
         ]
        }           
        scale <0.35, 1, 2>
        }
         interior { ior 1.6 }
         }


#declare antHairMat =   material { texture { gradient y scale 2 turbulence 0.025 translate <0, 0.075, 0> omega 0.75 lambda 2.8 triangle_wave texture_map { 
 [ 0.4  pigment{ wrinkles  triangle_wave colour_map { [ 0.0 color rgb antHairColour*0.5 ] [ 1.0 rgb antHairColour*0.75 ] } turbulence 0.2 omega 0.65 lambda 3.2 scale 0.01 }
           finish { specular albedo 0.1 roughness 0.0025 diffuse albedo 0.6, 0.4 brilliance 2.3 reflection { 0.008, 0.01 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.1, .1, 0.1>*0.6 }  //0.9
#end
 //         
            }
//           normal { granite 0.3 scallop_wave scale 0.007 turbulence 0.3 omega 0.7 }
          
         ]

 [ 0.6  pigment{ wrinkles triangle_wave  colour_map { [ 0.0 rgb antHairColour*0.2 ] [ 1.0 rgb antHairColour*.8 ] } turbulence 0.5 omega 0.8 lambda 2.5 }
           finish { specular albedo 0.1 roughness 0.0025 diffuse albedo 0.6, 0.4 brilliance 2.9 reflection { 0.008, 0.01 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.1, .1, 0.1>*0.25 }  //0.9
#end
          
           }
//           normal { granite 0.3 scallop_wave scale 0.007 turbulence 0.3 omega 0.7 }
          
         ]
        }           
        scale <0.35, 1, 2>
        }
         interior { ior 1.6 }
         }



#declare antennaeMat =   material { 

  texture{ pigment{ granite turbulence 0.4 omega 0.8 lambda 3.2 colour_map { [ 0.0  color rgb antColourLight*0.6 ] [ 1.0 color rgb antColour*0.4 ] } scale <0.15, .1, .1> }
           finish { specular albedo 0.1 roughness 0.0025 diffuse albedo 0.5, 0.4 brilliance 1.5 reflection { 0.015, 0.05 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*.25 }  //0.9
#end
          
            }
           normal { granite 0.2 scallop_wave scale 0.01 turbulence 0.3 omega 0.7 }
         }   
         interior { ior 1.6 }
         }

#declare mouthMat =   material { 

  texture{ pigment{ granite turbulence 0.4 omega 0.8 lambda 3.2 colour_map { [ 0.0  color rgb antColourLight*0.4 ] [ 0.9 color rgb antColour*0.4 ] [ 1.0 rgb antColour*0.1 ] } scale <0.06, .07, .05> }
           finish { specular albedo 0.1 roughness 0.005 diffuse albedo 0.5, 0.1 brilliance 2.0 reflection { 0.015, 0.02 fresnel on } conserve_energy
#if(useAntSubSurface)
      subsurface { translucency <.4, .6, 0.1>*0.1 }  //0.9
#end
          
            }
           normal { granite 0.2 scallop_wave scale 0.001 turbulence 0.3 omega 0.5 lambda 2 }
         }   
         interior { ior 1.6 }
         }


#declare eyeMat =   material {
  texture{ pigment{ color rgb <.01,0.01,0.02>*0.5 }    
           finish { specular albedo 0.1 roughness 0.02 diffuse albedo 0.3 brilliance 2.5 reflection { 0.01, 0.15 fresnel on } conserve_energy
           #if(useAntSubSurface)
            subsurface { translucency <0.2, .2, .1>*.1 }  //0.9
           #end

           }
           normal { average normal_map { [ 2 wrinkles 0.25 scale 0.04 ] [ 1 granite 0.1 scale 0.004 ] } }
         }
         interior { ior 1.4 }
         }



#declare aSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         0.2, <0, 0.2, -0.5> 
         0.5, <0.0, 0.175, -1.4> 
         0.8, <0.0, 0.3, -2.6> 
         1.0, <0.0, 0.05, -3.25> 
       };
/*
#macro mkMouthPart()

blob {
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  #local mp2 =0;
  #while(mp2 < 10)
  #local mp1 = 0; 
  #local mr1 = 0.175;
  #while(mp1 < 100)  
        sphere{< 0, 0, 0>, mr1, 1 translate <0.5-(mp2*0.05), 0, 0> rotate <0, -15+mp1, 0> rotate <-mp1*0.5, 0, 0> translate <mp2*0.05, 0, 0> }//rotate <-mp2*5, 0, 0> }
//        sphere{< 0, 0, 0>, mr1*0.75, 1 translate <0.425, 0.075, 0> rotate <0, -20+mp1, 0> translate <0, 0, -0.025> }
//        sphere{< 0, 0, 0>, mr1*0.75, 1 translate <0.425, -0.075, 0> rotate <0, -20+mp1, 0> translate <0, 0, -0.025>  }

//        sphere{< 0, 0, 0>, mr1*0.65, 1 translate <0.375, 0.125, 0> rotate <0, -25+mp1, 0> translate <0, 0, -0.025> }
//        sphere{< 0, 0, 0>, mr1*0.65, 1 translate <0.375, -0.125, 0> rotate <0, -25+mp1, 0> translate <0, 0, -0.025>  }
        
        #local mp1=mp1+1;  
        #local mr1=mr1*0.98;
        
  #end  
   #local mp2 = mp2+1;
  #end 
        sphere{< 0, 0, 0>, 0.5, 1 scale <0.6, 0.3, 0.4> rotate <40, 0, 0> translate <0.5, 0.045, 0.3> }//rotate <-mp2*5, 0, 0> }
        sphere{< 0, 0, 0>, 0.5, 1 scale <0.6, 0.3, 0.4> rotate <-40, 0, 0> translate <0.5, -0.045, 0.3> }//rotate <-mp2*5, 0, 0> }

        sphere{< 0, 0, 0>, 0.5, -10 scale <1, 0.3, 0.06> rotate <0, 20, 0> translate <0.5, 0.2, 0.23> }//rotate <-mp2*5, 0, 0> }
 
  
//  scale <1, 0.675, 1>
//  rotate <0, -20, 0>
    
}        

#end
*/

#macro mkMouthPart()

blob {
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  #local mp2 =0;
  #while(mp2 < 5)
  #local mp1 = 0; 
  #local mr1 = 0.185;
  #while(mp1 < 120)  
        sphere{< 0, 0, 0>, mr1, 1 translate <0.5-(mp2*0.06), 0, 0> rotate <0, -15+mp1, 0> rotate <-mp1*0.15, 0, 0> scale <1, 1, 1+(mp2/5)> }//rotate <-mp2*5, 0, 0> }
//        sphere{< 0, 0, 0>, mr1*0.75, 1 translate <0.425, 0.075, 0> rotate <0, -20+mp1, 0> translate <0, 0, -0.025> }
//        sphere{< 0, 0, 0>, mr1*0.75, 1 translate <0.425, -0.075, 0> rotate <0, -20+mp1, 0> translate <0, 0, -0.025>  }

//        sphere{< 0, 0, 0>, mr1*0.65, 1 translate <0.375, 0.125, 0> rotate <0, -25+mp1, 0> translate <0, 0, -0.025> }
//        sphere{< 0, 0, 0>, mr1*0.65, 1 translate <0.375, -0.125, 0> rotate <0, -25+mp1, 0> translate <0, 0, -0.025>  }
        
        #local mp1=mp1+2;  
        #local mr1=mr1*(0.97-(mp2*0.001));
        
  #end  
   #local mp2 = mp2+1;
  #end 
        sphere{< 0, 0, 0>, 0.5, 1 scale <0.6, 0.3, 0.4> rotate <40, 0, 0> translate <0.5, 0.045, 0.3> }//rotate <-mp2*5, 0, 0> }
        sphere{< 0, 0, 0>, 0.5, 1 scale <0.6, 0.3, 0.4> rotate <-40, 0, 0> translate <0.5, -0.045, 0.3> }//rotate <-mp2*5, 0, 0> }

        sphere{< 0, 0, 0>, 0.5, -10 scale <1, 0.3, 0.06> rotate <0, 20, 0> translate <0.5, 0.2, 0.23> }//rotate <-mp2*5, 0, 0> }
 
  
//  scale <1, 0.675, 1>
//  rotate <0, -20, 0>
    
}        

#end

#declare mouthPart = object { mkMouthPart() }

// front Leg

#macro mkFrontLeg()   
        #local spos  = 0;
        #local epos = 1;
        #local lspos = spos;    
       
#local flSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         // first bend at body
 //        0.048, <0.2, 0.0, 0>
         0.05, <0.21, -0.01, 0>
 //        0.052, <0.22, -0.05, 0>
         
         // second bend (lowest point)
         0.145, <0.441, -0.455, 0.4> 
         0.15, <0.44, -0.46, 0.4> 
//         0.155, <0.42, -0.38, 0.3> 
         
         // third bend highest point
         0.425, <1.125, 0.195, -0.325> 
 //        0.475, <1.2, 0.22, -0.485> 
         0.5, <1.35, 0.19, -0.52>   
 //        0.55, <1.36, 0.175, -0.55> 
         
         
         0.75, <1.8, -0.75, -0.7> 

         // small section of leg before foot
         0.8, <1.85, -0.85, -0.775> 
         0.9, <2.135, -1.45, -0.8> 

         0.97, <2.35, -1.85, -1.1> 
        
         1.0, <2.45, -1.8, -1.25> 
       };
union {         
blob {
threshold 0.6                
                
        // first part
        #local rad = 0.1;
        #local srad=rad;    
        #while (lspos < 0.15)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin((lspos/0.15)*3.14)*0.2);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end


        // 2nd part
        #local rad = 0.135;
        #local srad=rad;  
        #local lspos = 0.175;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.15)/0.35)*3.14)*0.1)-(lspos/10);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
                

        // 3rd part
        #local rad = 0.05;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.5)/0.25)*3.14)*0.075);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end    

        // hair/spike at end of 3rd part
        #local rad = 0.0125;
        #local srad=rad;  
        #local lspos = 0.70;      
        #local hpos=0.0;

        #while (lspos < 0.82)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   

           #local hpos=hpos+0.0005+ar(0.003);

           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)+<0, 0, hpos>
           
           }  
           #local srad=rad+(sin(((lspos-0.5)/0.1125)*3.14)*0.003);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end    

        // end of hair        
        
         // 4th part - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.775;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
          // #local srad=rad+(sin(((lspos-0.5)/0.25)*3.14)*0.075);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

         // 5th part - foot
        #local rad = 0.04;
        #local srad=rad;  
        #local lspos = 0.905;  
        #while (lspos < 0.9275)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.905)*1);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.035;
        #local srad=rad;  
        #local lspos = 0.9325;  
        #while (lspos < 0.95)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.9325)*0.5);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.955;  
        #while (lspos < 0.97)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.955)*0.25);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.974;  
        #while (lspos < 1.0)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.974)*0.35);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
 
                                                  
     } // end of blob
     
    // hairs         
 union {    
             // 2nd part  hairs
        #local rad = 0.155;
        #local srad=rad;  
        #local lspos = 0.175;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   



           cone { <0, 0, 0> 0.005 <0, -((0.07+ar(0.075))+(sin(((lspos-0.165)/0.34)*4.5)*0.3)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }
             
           #local lspos = getSplinePos(flSpline, lspos, srad*0.25, 0.001);                    
        #end

     
     // 3rd part hairs
        #local rad = 0.08;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.07+ar(0.075))+(lspos/15)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.15, 0.001);                    
        #end
        
         // 4th part hairs - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.755;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.08+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.15, 0.001);                    
        #end  
        
        // add a few hairs down to the end of feet
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.9;  
        #while (lspos < 0.99)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.003 <0, -((0.06+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.2, 0.001);                    
        #end  
        
     
      // feet spikes 
       // big ones at end
           cone { <0, 0, 0> 0.0125 <0, -0.165, 0> 0.0015 rotate <-45, 180, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }        
           cone { <0, 0, 0> 0.0125 <0, -0.165, 0> 0.0015 rotate <-45, 70, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }    
       // next ones back
           cone { <0, 0, 0> 0.008 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }        
           cone { <0, 0, 0> 0.008 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }    
        // at beginning of 3rd segment back
           cone { <0, 0, 0> 0.008 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.945)
           }        
           cone { <0, 0, 0> 0.008 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.945)
           }    
               
             

            material { antHairMat }
  } // end of hairs
} // end of union 
                               
#end


// middle leg

#macro mkMiddleLeg()   
        #local spos  = 0;
        #local epos = 1;
        #local lspos = spos;    
       
#local flSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         // first bend at body
         0.05, <0.21, -0.01, 0>
         
         // second bend 
         0.145, <0.5, -0.1, 0.1> 
         0.15, <0.52, -0.09, 0.1> 
         
         // third bend highest point
         0.425, <1.35, 1.25, 0.125> 
         0.5, <1.45, 1.3, 0.13>   
         
         
         0.75, <2.1, -0.2, 0.2> 
                        
         // small section of leg before foot
         0.9, <2.24, -1.25, 0.25> 

         0.97, <2.55, -1.5, 0.3> 
        
         1.0, <2.8, -1.45, 0.35> 
       };
union {
                
blob {
threshold 0.6                
                
        // first part
        #local rad = 0.1;
        #local srad=rad;    
        #while (lspos < 0.15)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin((lspos/0.15)*3.14)*0.2);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end


        // 2nd part
        #local rad = 0.135;
        #local srad=rad;  
        #local lspos = 0.175;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.15)/0.35)*3.14)*0.1)-(lspos/10);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
                

        // 3rd part
        #local rad = 0.08;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.5)/0.25)*3.14)*0.035);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end    
        
        
         // 4th part - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.755;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.755)*0.1);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

         // 5th part - foot
        #local rad = 0.04;
        #local srad=rad;  
        #local lspos = 0.905;  
        #while (lspos < 0.9275)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.905)*1);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.035;
        #local srad=rad;  
        #local lspos = 0.93;  
        #while (lspos < 0.95)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.93)*0.5);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.9525;  
        #while (lspos < 0.97)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.9525)*0.25);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.974;  
        #while (lspos < 1.0)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.974)*0.35);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
 
                                                  
     } // end of blob

     // hairs         
 union {    
             // 2nd part  hairs
        #local rad = 0.155;
        #local srad=rad;  
        #local lspos = 0.175;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   



           cone { <0, 0, 0> 0.005 <0, -((0.1+ar(0.075))+(sin(((lspos-0.165)/0.34)*4.5)*0.3)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }
             
           #local lspos = getSplinePos(flSpline, lspos, srad*0.25, 0.001);                    
        #end

     
     // 3rd part hairs
        #local rad = 0.08;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.08+ar(0.075))+(lspos/15)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.15, 0.001);                    
        #end
        
         // 4th part hairs - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.755;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.08+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.15, 0.001);                    
        #end  
        
        // add a few hairs down to the end of feet
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.9;  
        #while (lspos < 0.99)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.08+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.2, 0.001);                    
        #end  
        
     
      // feet spikes 
       // big ones at end
           cone { <0, 0, 0> 0.0135 <0, -0.165, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }        
           cone { <0, 0, 0> 0.0135 <0, -0.165, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }    
       // next ones back
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }        
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }    
        // at beginning of 3rd segment back
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.945)
           }        
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.945)
           }    
               
             

            material { antHairMat }
  } // end of hairs
 // end of union

} // end of union          
                           
#end

// back leg

#macro mkBackLeg()   
        #local spos  = 0;
        #local epos = 1;
        #local lspos = spos;    
       
#local flSpline = spline {
         natural_spline
         0.00, <0, 0.0, 0>
         // first bend at body
         0.05, <0.21, -0.01, 0.05>
         
         // second bend 
         0.145, <0.5, -0.1, 0.4> 
        // 0.15, <0.52, -0.09, 0.45> 
         
         // third bend highest point
       //  0.425, <1.35, 1.5, 0.75> 
         0.45, <1.45, 1.65, 1.2>   
         0.5, <1.49, 1.7, 1.25>   
         
         
         0.75, <2.0, -0.3, 2.4> 
                        
         // small section of leg before foot
         0.9, <2.3, -1.0, 3.0> 

         0.97, <2.65, -1.25, 3.4> 
        
         1.0, <2.8, -1.15, 3.6> 
       };
union {                
blob {
threshold 0.6                
                
        // first part
        #local rad = 0.1;
        #local srad=rad;    
        #while (lspos < 0.15)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin((lspos/0.15)*3.14)*0.2);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end


        // 2nd part
        #local rad = 0.155;
        #local srad=rad;  
        #local lspos = 0.165;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.165)/0.34)*4.5)*0.1);//+((0.4-lspos)/3);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
                
        
        // 3rd part
        #local rad = 0.08;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+(sin(((lspos-0.52)/0.23)*2.14)*0.065);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end    
          
         
         // 4th part - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.755;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.755)*0.1);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

         // 5th part - foot
        #local rad = 0.04;
        #local srad=rad;  
        #local lspos = 0.905;  
        #while (lspos < 0.9275)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.905)*1);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.035;
        #local srad=rad;  
        #local lspos = 0.93;  
        #while (lspos < 0.95)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.93)*0.5);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end

        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.9525;  
        #while (lspos < 0.97)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.9525)*0.25);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
       
        #local rad = 0.03;
        #local srad=rad;  
        #local lspos = 0.974;  
        #while (lspos < 1.0)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           sphere { 0, srad, 1 scale <1, 1, 1>   
           //transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           
           }  
           #local srad=rad+((lspos-0.974)*0.35);     
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
 
                                                  
     } // end of blob
     
     // hairs         
 union {    
             // 2nd part  hairs
        #local rad = 0.155;
        #local srad=rad;  
        #local lspos = 0.165;  
        #while (lspos < 0.5)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   



           cone { <0, 0, 0> 0.005 <0, -((0.1+ar(0.075))+(sin(((lspos-0.165)/0.34)*4.5)*0.3)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }
             
           #local lspos = getSplinePos(flSpline, lspos, srad*0.25, 0.001);                    
        #end

     
     // 3rd part hairs
        #local rad = 0.08;
        #local srad=rad;  
        #local lspos = 0.52;  
        #while (lspos < 0.75)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.1+ar(0.075))+(lspos/15)), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end
        
         // 4th part hairs - small leg part above foot
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.755;  
        #while (lspos < 0.9)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.1+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.1, 0.001);                    
        #end  
        
        // add a few hairs down to the end of feet
        #local rad = 0.065;
        #local srad=rad;  
        #local lspos = 0.9;  
        #while (lspos < 0.99)      
           
      
           #local Direction = (flSpline(lspos+0.001) -flSpline(lspos-0.001));   


           cone { <0, 0, 0> 0.005 <0, -((0.1+ar(0.05))), 0> 0.001 rotate <-(30+ar(40)), 0, ar(360)>  // rotate <-(30+ar(40)), 0, ar(360)> 
           transform {Reorient_Trans(z,Direction)}   
           translate flSpline(lspos)
           }  
           #local lspos = getSplinePos(flSpline, lspos, srad*0.2, 0.001);                    
        #end  
        
     
      // feet spikes 
       // big ones at end
           cone { <0, 0, 0> 0.0135 <0, -0.175, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }        
           cone { <0, 0, 0> 0.0135 <0, -0.175, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.999)
           }    
       // next ones back
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }        
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.97)
           }    
        // at beginning of 3rd segment back
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 130, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.929)
           }        
           cone { <0, 0, 0> 0.01 <0, -0.10, 0> 0.0015 rotate <-45, 20, 0>  // rotate <-(30+ar(40)), 0, ar(360)> 
           translate flSpline(0.929)
           }    
               
             

            material { antHairMat }
  } // end of hairs
 // end of union
 }                               
#end

#if(showAnts)

#declare antRotate = <5.25, 100, 0>;

// sample sphere
#macro ant(l1, l2, l3, l4, l5, l6) 
union {
// head
blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #
  
/*
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.4,0.6> translate <0.2, 0.1, -0.2> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.4,0.6> translate <0.225, 0.1, -0.1> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.45,0.7> translate <0.25, 0.125, 0.1> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.6, 1 scale <0.5,0.5,0.75> translate <0.275, 0.125, 0.3> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.7, 1 scale <0.5,0.6,1> translate <0.3, 0.2, 0.5> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.8, 1 scale <0.5,0.7,1> translate <0.325, 0.35, 0.7> rotate <-40, 10, 0> }
*/


  sphere{< 0, 0, 0>, 0.65, 1 scale <0.5,0.4,0.7> translate <0.3, 0.0, 0.0> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.65, -10 scale <0.75,0.5,0.4> translate <0.3, 0.0, -0.35> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.75, 1 scale <0.5,0.4,0.7> translate <0.3, 0.0, 0.1> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.85, 1 scale <0.5,0.4,0.7> translate <0.3, 0.0, 0.2> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 0.95, 1 scale <0.5,0.4,0.6> translate <0.3, 0.025, 0.3> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 1.05, 1 scale <0.5,0.4,0.6> translate <0.3, 0.05, 0.4> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 1.1, 1 scale <0.5,0.4,0.6> translate <0.3, 0.075, 0.5> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 1.15, 1 scale <0.5,0.4,0.5> translate <0.3, 0.1, 0.6> rotate <-40, 10, 0> }
  sphere{< 0, 0, 0>, 1.20, 1 scale <0.5,0.4,0.5> translate <0.3, 0.125, 0.7> rotate <-40, 10, 0> }


  sphere{< 0, 0, 0>, 1.4, 1 scale <1,0.8,1> translate <0, 0, 0.55> rotate <-45, 0, 0> translate <0, 0.2, 0>}


  sphere{< 0, 0, 0>, 0.65, 1 scale <0.5,0.4,0.7> translate <-0.3, 0.0, 0.0> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.65, -10 scale <0.75,0.5,0.4> translate <-0.3, 0.0, -0.35> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.75, 1 scale <0.5,0.4,0.7> translate <-0.3, 0.0, 0.1> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.85, 1 scale <0.5,0.4,0.7> translate <-0.3, 0.0, 0.2> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.95, 1 scale <0.5,0.4,0.6> translate <-0.3, 0.025, 0.3> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 1.05, 1 scale <0.5,0.4,0.6> translate <-0.3, 0.05, 0.4> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 1.1, 1 scale <0.5,0.4,0.6> translate <-0.3, 0.075, 0.5> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 1.15, 1 scale <0.5,0.4,0.5> translate <-0.3, 0.1, 0.6> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 1.20, 1 scale <0.5,0.4,0.5> translate <-0.3, 0.125, 0.7> rotate <-40, -10, 0> }

                                                               
/*
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.6,0.7> translate <-0.35, -0.05, -0.3> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.5, 0.5> translate <-0.35, 0.0, -0.2> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.55, 0.5> translate <-0.35, 0.05, 0.0> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.6, 1 scale <0.5,0.5, 0.75> translate <-0.3, 0, 0.2> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.7, 1 scale <0.5,0.6, 1> translate <-0.325, 0, 0.4> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.8, 1 scale <0.5,0.7, 1> translate <-0.35, 0, 0.5> rotate <-40, -10, 0> }
*/

/*
  sphere{< 0, 0, 0>, 0.3, 1 scale <0.5,0.4,0.8> translate <-0.15, 0.15, -0.3> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.4, 1 scale <0.5,0.4, 0.5> translate <-0.15, 0.1, -0.2> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.5,0.45, 0.5> translate <-0.25, 0.05, 0.0> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.6, 1 scale <0.5,0.5, 0.75> translate <-0.3, 0, 0.2> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.7, 1 scale <0.5,0.6, 1> translate <-0.325, 0, 0.4> rotate <-40, -10, 0> }
  sphere{< 0, 0, 0>, 0.8, 1 scale <0.5,0.7, 1> translate <-0.35, 0, 0.5> rotate <-40, -10, 0> }
*/
// nose/mouth area

  sphere{< 0, 0, 0>, 1, 1 scale <0.5,0.6, 1.2> translate <0, 0.075, 0> rotate <-45, 0, 0> translate <0, 0.25, 0> }
  sphere{< 0, 0, 0>, 1, -0.6 scale <0.55,0.65, 0.8> translate <0, 0.225, 0> rotate <-30, 0, 0> translate <0.5, 0.25, -0.5> }
  sphere{< 0, 0, 0>, 1, -0.6 scale <0.55,0.65, 0.8> translate <0, 0.225, 0> rotate <-30, 0, 0> translate <-0.5, 0.25, -0.5> } 
  sphere{< 0, 0, 0>, 1.0, -1 scale <2,0.7, 0.8> translate <0, -0.1, -0.8> rotate <-40, 0, 0> }


  // eye sockets
  sphere{< 0, 0, 0>, 0.35, -1 scale <0.5,0.475,0.8> rotate <-20, 5, 0> translate <0.7, 0.135, 0.7> rotate <0, 0, 10> rotate <-37, 0, 0> translate <0.075, 0.12, -0.1>}
  sphere{< 0, 0, 0>, 0.35, -1 scale <0.5,0.475,0.8> rotate <-20, -5, 0> translate <-0.7, 0.135, 0.7> rotate <0, 0, -10> rotate <-37, 0, 0> translate <-0.075, 0.12, -0.1> }
//  sphere{< 0, 0, 0>, 0.3, -1 scale <0.5,0.5,0.75> rotate <-5, 5, 0> translate <0.865, 0.115, 0.45> rotate <0, 0, 10> rotate <-37, 0, 0> }
//  sphere{< 0, 0, 0>, 0.3, -1 scale <0.5,0.5,0.75> rotate <-5, -5, 0> translate <-0.865, 0.115, 0.45> rotate <0, 0, -10> rotate <-37, 0, 0> }


  // antennae base
  sphere{< 0, 0, 0>, .115, 1 scale <1,1.1, 1> rotate <-20, 0, 0> translate <0.3, 0.525, 0> rotate <-15, 0, 0> translate <0, -0.0135, -0.09> }
  sphere{< 0, 0, 0>, .075, 1 scale <1,1.1, 1> translate <0, 0.07, 0> rotate <-40, 0, 0> translate <0.3, 0.5, 0.015> rotate <-16, 0, 0> translate <0, -.0135, -0.09> }

  sphere{< 0, 0, 0>, .115, 1 scale <1,1.1, 1> rotate <-20, 0, 0> translate <-0.3, 0.525, 0> rotate <-15, 0, 0> translate <0, -0.0135, -0.09> }
  sphere{< 0, 0, 0>, .075, 1 scale <1,1.1, 1> translate <0, 0.07, 0> rotate <-40, 0, 0> translate <-0.3, 0.5, 0.015> rotate <-16, 0, 0> translate <0, -0.0135, -0.09> }

  
  // mouth surround
//  sphere{< 0, 0, 0>, 0.5, 1 scale <0.65,0.5,0.725> translate <0.35, -0.25, -0.35>  }
//  sphere{< 0, 0, 0>, 0.275, -1 scale <0.65,0.5,.5> translate <0.35, -0.25, -0.35> }
//  sphere{< 0, 0, 0>, 0.275, -1 scale <0.65,0.5,.5> translate <0.35, -0.25, -0.5> }


//  sphere{< 0, 0, 0>, 0.5, 1 scale <0.65,0.5,0.725> translate <-0.35, -0.25, -0.35>  }
//  sphere{< 0, 0, 0>, 0.275, -1 scale <0.65,0.5,.5> translate <-0.35, -0.25, -0.35> }
//  sphere{< 0, 0, 0>, 0.275, -1 scale <0.65,0.5,.5> translate <-0.35, -0.25, -0.5> }


  // body/neck hole
  sphere{< 0, 0, 0>, 0.751, -1 scale <0.25,0.5,1> rotate <25, 0, 0> translate <0, 0.25, 1.5> }
    

  //cylinder{<-1.50,0,0>,< -0.25,1.50,0>, Radius1, Strength}
  // sturm           
  
  
 // sphere { <0, 0, 0> 1  
// scale 0.85  
// translate <0, 0.15, 0.2>       
 rotate <15, 0, 0>
 }
 
 // nose hairs..
union {
 cone { <0, 0.1, -0.38> 0.013, <0, 0.03, -0.45>, 0.002  translate <0, -0.025, 0>}
 cone { <0, 0.1, -0.38> 0.012, <0, 0, -0.45>, 0.002   }
 cone { <0, 0.1, -0.38> 0.015, <0, 0.01, -0.45>, 0.002  translate <0, 0.025, -0.025> }
 cone { <0, 0.1, -0.38> 0.012, <0, 0, -0.485>, 0.002   translate <0, 0.055, -0.05> }
 cone { <0, 0.1, -0.38> 0.0135, <0, 0.02, -0.5>, 0.002  translate <0, 0.085, -0.07> }
 cone { <0, 0.1, -0.38> 0.012, <0, 0.01, -0.5>, 0.002   translate <0, 0.12, -0.08> }
 material { antHairMat }
}  
 object { mouthPart scale <0.85, 1, 0.85> rotate <0, 0, 0> rotate <-30, -30, 0> translate <0.16, -0.175, -0.60> material { mouthMat }  }             
 object { mouthPart scale <0.85, 1, 0.85> scale <-1, 1, 1> rotate <0, 0, 0> rotate <-30, 30, 0> translate <-0.16, -0.175, -0.60>  material { mouthMat} }  
 

 // antennae

blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #

        mkAntennae(0.04, 0.0, 1, aSpline)    
        scale <1, 1, 1.2>  
        rotate <-1, -14, 0>  
        translate <0.265, 0.56, -0.13> 
        material { antennaeMat }        
    }
blob{
  threshold 0.6 // threshold (0.0 < threshold <= Strength) surface falloff threshold #

        mkAntennae(0.04, 0.0, 1, aSpline)    
        rotate <8, 12, 0>
        scale <1, 1, 1.2>    
        translate <-0.265, 0.56 -0.13>  
        material { antennaeMat }        
    }

  // body
  blob {   
  threshold 0.6
  // neck
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.25,0.5,1.5> rotate <-25, 0, 0> translate <0, 0.3, 0.750> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.25,0.5,1.5> rotate <-25, 0, -40> translate <0, 0.3, 0.750> }
  sphere{< 0, 0, 0>, 0.5, 1 scale <0.25,0.5,1.5> rotate <-25, 0, 40> translate <0, 0.3, 0.750> }
  sphere{< 0, 0, 0>, 0.4, 1 scale <0.25,0.5,1.5> rotate <30, 30, 0> translate <0.1, 0.4, 1.250> }
  sphere{< 0, 0, 0>, 0.4, 1 scale <0.25,0.5,1.5> rotate <30, -30, 0> translate <-0.1, 0.4, 1.250> }

  // part from front leg to head
  cylinder { <0.05, 0.45, 0.95>, <0.55, 0.0, 1.85>, 0.175, 1 }
  cylinder { <-0.05, 0.45, 0.95>, <-0.55, 0.0, 1.85>, 0.175, 1 }

  // top part of body
  sphere{< 0, 0, 0>, 0.9, 1 scale <1,0.75,1> rotate <15, 0, 0> translate <0, 0.5, 1.60> }
  sphere{< 0, 0, 0>, 1.0, 1 scale <.61,1,1> rotate <25, 0, 0> translate <0, 0.225, 2.10> }  

  sphere{< 0, 0, 0>, 1.0, 1 scale <.61,0.5,0.5> rotate <15, 0, 0> translate <0, 0.35, 2.20> }  

  sphere{< 0, 0, 0>, 1.0, 1 scale <1,0.7,0.5> rotate <-15, 0, 0> translate <0.1, 0.3, 1.80>  }  
  sphere{< 0, 0, 0>, 1.0, 1 scale <1,0.7,0.5> rotate <-15, 0, 0> translate <-0.1, 0.3, 1.80> }  
  
  // middle part of body
  sphere{< 0, 0, 0>, 1.0, 1 scale <.61,0.5,0.5> rotate <15, 0, 0> translate <0, 0.0, 2.6> }  
  sphere{< 0, 0, 0>, 1.0, 1 scale <.71,0.5,0.5> rotate <15, 0, 0> translate <0, -0.2, 2.7> }  

  sphere{< 0, 0, 0>, 1.1, 1 scale <.71,0.5,0.5> rotate <15, 0, 0> translate <0, 0.0, 3.10> }  
  sphere{< 0, 0, 0>, 1.2, 1 scale <.71,0.5,0.5> rotate <15, 0, 0> translate <0, 0.0, 3.3> }  
  sphere{< 0, 0, 0>, 1.3, 1 scale <.71,0.5,0.5> rotate <15, 0, 0> translate <0, 0.0, 3.5> }  
  
  // end of middle
  sphere{< 0, 0, 0>, 0.25, 1 scale <.71,0.5,0.5> rotate <0, 0, 0> translate <0, 0.0, 3.8> }  
  sphere{< 0, 0, 0>, 0.5, 1 scale <.71,0.5,0.4> rotate <-2.5, 0, 0> translate <0, 0.0, 3.9> }  
  sphere{< 0, 0, 0>, 0.75, 1 scale <.71,0.5,0.3> rotate <-5, 0, 0> translate <0, 0.0, 3.95> }  
  sphere{< 0, 0, 0>, 1.25, 1 scale <.71,0.5,0.2> rotate <-7.5, 0, 0> translate <0, 0.0, 4.0> }  
  sphere{< 0, 0, 0>, 1.75, 1 scale <.71,0.5,0.1> rotate <-12.5, 0, 0> translate <0, 0.0, 4.05> }  

  sphere{< 0, 0, 0>, 1.5, -1 scale <.71,0.5,0.1> rotate <-12.5, 0, 0> translate <0, 0.05, 4.15> }  
  
//sphere{< 0, 0, 0>, 1.0, 1 scale <.61,0.5,0.5> rotate <15, 0, 0> translate <0, 0.35, 2.30> }  
//sphere{< 0, 0, 0>, 1.0, 1 scale <.61,0.5,0.5> rotate <15, 0, 0> translate <0, 0.35, 2.50> }  

 // sphere{< 0, 0, 0>, 1.0, 0.7 scale <1.2,1,1.25> rotate <5, 0, 0> translate <0, -0.2, 3.10> }  
//  sphere{< 0, 0, 0>, 1.0, 1 scale <1.2,1,1.25> rotate <5, 0, 0> translate <0, -0.2, 3.30> }  
 // sphere{< 0, 0, 0>, 1.0, -0.5 scale <1,1,1> rotate <5, 0, 0> translate <0, 0.0, 2.40> }  
  
  }
  
  // rear of body
#declare rearBody =  blob {
  threshold 0.6 
/*  
  #declare rbr=0;
  #declare rbRad=0.8;
  #declare rbh = 1.5;
  #while(rbr < 50)
    sphere{ <0, 0, 0>, rbRad, 1 scale <1,0.7,0.4> translate <0, rbh, 0> rotate <rbr, 0, 0> translate <0, -1.15, 4.2> }
  
    #declare rbr=rbr+1;      
    #if(rbr < 30)
     #declare rbRad=rbRad*1.02;
    #else
     #declare rbRad=rbRad*0.995;    
    #end  
    #declare rbh=rbh*0.9995;
  #end
*/  
    
    sphere{ <0, 0, 0>, 1.25, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.0, 0> }
    sphere{ <0, 0, 0>, 1.275, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.1, 0.2> }
    sphere{ <0, 0, 0>, 1.3, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.2, 0.3> }
    sphere{ <0, 0, 0>, 1.35, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.4, 0.45> }
    sphere{ <0, 0, 0>, 1.35, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.3, 0.6> }
    sphere{ <0, 0, 0>, 1.3, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.2, 0.7> }
    sphere{ <0, 0, 0>, 1.25, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.1, 0.8> }
    sphere{ <0, 0, 0>, 1.15, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.02, 0.9> }
    sphere{ <0, 0, 0>, 1.0, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, -0.05, 1.0> }
 /*
    sphere{ <0, 0, 0>, 1.25, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.15, 4.2> }
    sphere{ <0, 0, 0>, 1.25, 1 scale <1,0.8,0.6> rotate <-25, 0, 0> translate <0, 0.05, 4.6> }
 */
   material {
        texture {  radial  frequency 13//50
        texture_map {
/*
            [ 0.0   antBody3  ]
            [ 0.015   antBody3  ]
            [ 0.0155  antBody1  ]
            [ 0.4   antBody1  ]
            [ 0.6   antBody2  ]
            [ 0.95   antBody2  ]
            [ 0.99   antBody3  ]
            [ 1.0   antBody3  ]
*/                             
            [ 0.0   antBody2  ]
            [ 0.34  antBody2  ]
            [ 0.35  antBody3  ]
            [ 0.355  antBody3  ]
            [ 0.355  antBody4  ]
            [ 0.36  antBody4  ]
            [ 0.36  antBody1  ]
            [ 0.47   antBody1  ]
            [ 0.50   antBody2  ]
            [ 0.62   antBody2  ]
            [ 0.64  antBody3  ]
            [ 0.645  antBody3  ]
            [ 0.645  antBody4  ]
            [ 0.65  antBody4  ]
            [ 0.65  antBody1  ]
            [ 0.74   antBody1  ]
            [ 0.78   antBody2  ]
            [ 0.92   antBody2  ]
            [ 0.94  antBody3  ]
            [ 0.945  antBody3  ]
            [ 0.945  antBody4  ]
            [ 0.95  antBody4  ]            
            [ 0.95  antBody1  ]
            [ 1.0   antBody2  ]
        }
               
        rotate <0, 0, -90>  

        rotate <-65.5, 0, 0>
        translate <0, -3.0, 1.0>   
        turbulence <0.1, 0.15, 0.1>
        omega 0.225
        lambda 1

/*
        rotate <-54.5, 0, 0>
        translate <0, -3.0, 1.0>   
        turbulence <0.05, 0.205, 0.05>
        omega 0.275
        lambda 4
*/
        }
   }  
   scale <1.2, 1.1, 1.7>
   rotate <20, 0, 0>
   translate <0.0, -0.1, 4.62> // z was 4.52   
  
  } 

object { rearBody }

 // rear body hairs..
union {    
 #declare bhz = 0.025;
 #while(bhz < 0.75)  
  #declare bhr = -120+ar(10);
  #while (bhr < 120)
    cone { <0, 0, 0> 0.003, <0, 0.4+ar(0.025), 0>, 0.0005 rotate <10+ar(20)+(bhz*40), 0, 0> translate <0, 0.45+(sin(bhz*1.5)*0.5), 4+bhz+ar(0.1)> rotate <0, 0, bhr> }
    #declare bhr = bhr+5+ar(20);
  #end
    #declare bhz=bhz+0.05+ar(0.1);
 #end
 material { antHairMat }
}  
  
  
// eyes
//sphere{< 0, 0, 0>, 0.35, -1 scale <0.5,0.4,0.8> rotate <-25, 5, 0> translate <0.7, 0.135, 0.7> rotate <0, 0, 10> rotate <-37, 0, 0> translate <0, 0.02, 0.00>}
sphere{< 0, 0, 0>, 0.310  scale <0.25,0.5,0.8> rotate <-14, -10, 30> translate <0.72, 0.12, 0.675> rotate <0, 0, 10> rotate <-30, 0, 0> translate <0.04, 0.08, 0.01>
//sphere{< 0, 0, 0>, 0.30  scale <0.325,0.5,0.75> rotate <-10, 0, 10> translate <0.815, 0.09, 0.455> rotate <0, 0, 10> rotate <-37, 0, 0> 
 material { eyeMat }
}
  sphere{< 0, 0, 0>, 0.310 scale <0.25,0.5,0.8> rotate <-14, 10, -30> translate <-0.72, 0.12, 0.675> rotate <0, 0, -10> rotate <-30, 0, 0> translate <-0.04, 0.08, 0.01>
//  sphere{< 0, 0, 0>, 0.30 scale <0.325,0.5,0.75> rotate <-10, 0, -10> translate <-0.815, 0.09, 0.455> rotate <0, 0, -10> rotate <-37, 0, 0> 
 material { eyeMat }
}                         

union {
  object { mkFrontLeg() rotate l1 translate <0.2, -0.25, 1.9> }
  object { mkFrontLeg() rotate l2 translate <0.2, -0.25, 1.9> scale <-1, 1, 1> }

  object { mkMiddleLeg() rotate l3 translate <0.2, -0.4, 2.7> }
  object { mkMiddleLeg() rotate l4 translate <0.2, -0.4, 2.7> scale <-1, 1, 1> }

  object { mkBackLeg() rotate l5 translate <0.2, -0.3, 3.2> }
  object { mkBackLeg() rotate l6 translate <0.2, -0.3, 3.2> scale <-1, 1, 1> }

  material { antLegMat }        
}

  rotate antRotate  
  

  material { antMat }
 } //------------------------------------------------------ end of blob object  
#end

// army
#declare a1 = object { ant(<0, 10, 20>, <0, -10, 0>, <0, -5, 0>, <0, 10, 0>, <0, 0, 15>, <0, 10, 0>)  translate <0, 2.19, 0> scale 0.01 scale <1.1, 1, 1>  }
#declare a2 = object { ant(<0, 0, 0>, <0, 5, 20>, <0, 0, 0>, <0, 0, 10>, <0, 0, 0>, <0, 0, 10>)  translate <0, 2.19, 0> scale 0.01  scale <1.1, 1, 1> }
#declare a3 = object { ant(<0, 0, 0>, <0, 5, 30>, <0, 10, 10>, <0, 0, 0>, <0, 0, 10>, <0, 0, 0>)  translate <0, 2.19, 0> scale 0.01 scale <1.1, 1, 1> }
#declare a4 = object { ant(<0, 5, 30>, <0, 5, 0>, <0, -5, 0>, <0, 10, 0>, <0, 0, 15>, <0, 10, 0>)  translate <0, 2.19, 0> scale 0.01 scale <1.1, 1, 1> }
#declare a5 = object { ant(<0, 5, 0>, <0, 0, 10>, <0, 5, 10>, <0, 5, 0>, <0, 10, 0>, <0, -5, 10>)  translate <0, 2.19, 0> scale 0.01  scale <1.1, 1, 1> }

// flat    object { ant translate <0, 2.19, 0> scale 0.01 scale <1.15, 0.075, 1.2> rotate <0, 160, 0> translate <-1.9, 0, -1.9> }
// decoy
object { ant(<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>) translate <0, 2.19, 0> scale 0.01 rotate <0, 160, 0> translate <-2, 0, -2> }


// spoon ants

//object { a1 rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
#declare antSpoon = object { spoon  rotate <0, 180, 0> rotate <-15, 0, -37> rotate <0, 50, 0> translate <0.4, 0.22, -3.70> }   

#macro Drop_Object(Surface, Object, Pos, Norm)
    //Allow the user to pass scalars as vectors
    #local Pos = Pos + <0,0,0>;

    //Trace onto the surface
    #local N = <0,0,0>;
    #local SO = trace(Surface, Pos, -y, N);

    //Check if we hit the surface
    #if (vlength(N)>0)   
    #warning "Hit"
        //place the object
        object {
            Object
  
            //Adjust the Normal if the user wants us to
            #if (Norm)
                Reorient_Trans(y,N)
            #end

            //Translate to final position
            translate SO
        }
    #else
        #warning "Missed"
    #end
#end // End Macro

//object { Drop_Object(antSpoon, a1, <0.4, 5, -3.7>, true) }
union {
Drop_Object(antSpoon, object { a3 rotate <0, 39+ar(2), 0>}, <-0.56, 5, -2.58>, true) 
Drop_Object(antSpoon, object { a1 rotate <0, 39+ar(2), 0>}, <-0.48, 5, -2.58>, true) 

Drop_Object(antSpoon, object { a2 rotate <0, 39+ar(2), 0>}, <-0.55, 5, -2.65>, true) 
Drop_Object(antSpoon, object { a3 rotate <0, 39+ar(2), 0>}, <-0.42, 5, -2.675>, true) 
Drop_Object(antSpoon, object { a4 rotate <0, 39+ar(2), 0>}, <-0.485, 5, -2.725>, true) 

Drop_Object(antSpoon, object { a5 rotate <0, 39+ar(2), 0>}, <-0.35, 5, -2.77>, true) 
Drop_Object(antSpoon, object { a1 rotate <0, 39+ar(2), 0>}, <-0.45, 5, -2.78>, true) 

Drop_Object(antSpoon, object { a5 rotate <0, 39+ar(2), 0>}, <-0.3, 5, -2.83>, true) 
Drop_Object(antSpoon, object { a1 rotate <0, 39+ar(2), 0>}, <-0.34, 5, -2.86>, true) 

Drop_Object(antSpoon, object { a5 rotate <0, 39+ar(2), 0>}, <-0.32, 5, -2.92>, true) 
Drop_Object(antSpoon, object { a1 rotate <0, 39+ar(2), 0>}, <-0.24, 5, -2.95>, true) 

}

/*
cylinder { <-0.7, 0, -2.5> <-0.7, 10, -2.5> 0.02 pigment { rgb <1, 0, 0> } }
cylinder { <-0.6, 0, -2.6> <-0.6, 10, -2.6> 0.02 pigment { rgb <0, 1, 0> } }
cylinder { <-0.5, 0, -2.7> <-0.5, 10, -2.7> 0.02 pigment { rgb <0, 0, 1> } }
*/

/*
#declare antRow = 0;
#while(antRow < 35)
#declare antCount=-45;
#while (antCount < 45)
#declare arn = ar(5);   
#declare ascale = 1+ar(0.05);
    #if(arn > 4)
        object { a5 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 3)
        object { a4 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 2)
        object { a3 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 1)
        object { a2 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #else
        object { a1 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.2+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #end
#declare antCount=antCount+25;    
#end
#declare antRow=antRow+1;
#end

// 2nd wave
#declare antRow = 0;
#while(antRow < 35)
#declare antCount=-32.5;
#while (antCount < 33)
#declare arn = ar(5);   
#declare ascale = 1+ar(0.05);
    #if(arn > 4)
        object { a5 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.325+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 3)
        object { a4 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.325+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 2)
        object { a3 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.325+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 1)
        object { a2 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.325+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #else
        object { a1 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.325+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #end
#declare antCount=antCount+25;    
#end
#declare antRow=antRow+1;
#end

// 3rd wave
#declare antRow = 0;
#while(antRow < 33)
#declare antCount=-38.25;
#while (antCount < 39)
#declare arn = ar(5);   
#declare ascale = 1+ar(0.05);
    #if(arn > 4)
        object { a5 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.525+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 3)
        object { a4 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.525+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 2)
        object { a3 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.525+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #elseif(arn > 1)
        object { a2 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.525+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #else
        object { a1 scale ascale rotate <0, -(1+ar(2)), 0> translate <0.525+(antRow*0.15)+ar(0.01), 0, 0> rotate <0, antCount, 0> translate <-0.5, 0, -2.5> } 
    #end
#declare antCount=antCount+12.5;    
#end
#declare antRow=antRow+1;
#end
*/

#end































/******************************************* Lantern ***************************************/

#declare lampBurnerTex = texture
    { 
    pigment 
    { 
        granite
        scallop_wave
        turbulence 0.35
        omega 0.675
        lambda 2.5
        colour_map {
            [ 0.0 color rgb <0.25, 0.1, 0.065>*0.5 ]
            [ 0.7 color rgb <0.2, 0.08, 0.035>*0.5 ]
            [ 0.9 color rgb <0.225, 0.095, 0.05>*0.5 ]
            [ 1.0 color rgb <0.25, 0.11, 0.07>*0.5 ]
            
            } 
            scale 0.05
    }
           // pigment{ color rgb<1.00,0.60,0.00>}
           finish { specular albedo 0.05 roughness 0.1 diffuse albedo 0.7  }     
// texture component
  normal {  
granite 0.2 scale 0.02
  }  
  } 

#declare lampWireTex = texture
    { 
    pigment 
    { 
            rgb <0.1, 0.09, 0.11>
    }
           finish { specular albedo 0.1 roughness 0.01 diffuse albedo 0.4 brilliance 6 reflection { 0.3 0.9
           // roughness 0.00025 
           fresnel on } metallic 0.8 }     
// texture component
//  normal {  
//granite 0.002 scale 0.05
//  }  
  } 

#declare lampNormal =   normal {  
    bozo      
    scallop_wave 
    scale 0.55     
    turbulence 0.575
    lambda 2.5
    omega 0.75
    normal_map {
        [ 0.0 agate 0.02 scale 0.75 agate_turb 0.6 ]            // reduced all by 0.1
        [ 0.1 agate 0.02 scale 0.75 agate_turb 0.6 ]
        [ 0.2 wrinkles 0.011 scale 0.15 turbulence 0.6 ]
        [ 0.956 wrinkles 0.005 scale 0.15 turbulence 0.6 ]
        [ 0.975 agate 0.015 scale 0.75 agate_turb 0.6 ]
        [ 1.0 agate 0.015 scale 0.75 agate_turb 0.6 ]

    }  
          
  }   
  
#declare lampNormal2 =   normal {  
    bozo      
    scallop_wave 
    scale 0.55     
    turbulence 0.575
    lambda 2.5
    omega 0.75
    normal_map {
        [ 0.0 agate 0.065 scale 0.75 agate_turb 0.6 ]            // reduced all by 0.1
        [ 0.1 agate 0.065 scale 0.75 agate_turb 0.6 ]
        [ 0.2 wrinkles 0.041 scale 0.15 turbulence 0.6 ]
        [ 0.956 wrinkles 0.05 scale 0.15 turbulence 0.6 ]
        [ 0.975 agate 0.07 scale 0.75 agate_turb 0.6 ]
        [ 1.0 agate 0.05 scale 0.75 agate_turb 0.6 ]

    }  
          
  }


#declare lampBaseTex = texture
    { 
    pigment 
    { 
rgb <0.015, 0.2, 0.04> 
    }
           // pigment{ color rgb<1.00,0.60,0.00>}
           finish { specular albedo 0.4 roughness 0.01  brilliance 2 diffuse albedo 0.6 reflection{ 0.025 0.4
           // roughness 0.0005
           fresnel on } conserve_energy }     
normal { granite 0.05 scale 0.015 turbulence 0.1 omega 0.7 }
  } 
  

#declare lampDirtTex = texture { lampBaseTex }
#declare lampDirtTex2 = texture { lampBaseTex }



#declare handleHalf = union
    {  
    intersection 
    {            
        torus { 0.02, 0.0065 rotate <90, 0, 0> translate <0, -0.02, 0> }
        box { <0, -0.02, -0.01> <0.11, 0.01, 0.01> }
    
    }
    sphere { <0.02, -0.02, 0> 0.0065 }
     
    
    cylinder { <0.02, -0.02, 0> <-0.075, -0.7, 0> 0.0065 }  
    sphere { <-0.075, -0.7, 0> 0.0065 }
    intersection
    {
        torus { 0.3, 0.0065 rotate x*90 }
        box { <0, -0.31, -0.01> <0.31, 0, 0.01> }
        translate <-0.375, -0.7, 0> 
    }
    sphere { <-0.375, -1, 0> 0.0065 }
    
    cylinder { <-0.475, -1, 0> <-0.375, -1, 0> 0.0065 }    
    
    difference
    {
        torus { 0.03, 0.0065 rotate <90, 0, 0> }
        union
        {
            box { <0, -0.04, -0.01> <0.04, 0.04, 0.01> }
            box { <-0.04, -0.04, -0.01> <0.04, 0, 0.01> }
            box { <-0.04, -0.04, -0.01> <0.04, 0, 0.01> rotate <0, 0, -45> }
        
        }
        translate <-0.475, -1.03, 0>
    }     
    
    difference
    {
        torus { 0.06, 0.0065 rotate <90, 0, 0> }
        union
        {
            box { <-0.07, -0.07, -0.01> <0, 0.07, 0.01> }
            box { <-0.07, 0, -0.01> <0.07, 0.07, 0.01> }
            box { <-0.07, 0, -0.01> <0.07, 0.07, 0.01> rotate <0, 0, -45> }
        
        }                   
        translate <-0.064 0, 0>
        translate <-0.475, -0.9655, 0>
    }  
    sphere { <0, -0.06, 0> 0.0065 
        translate <-0.064, 0, 0>
        translate <-0.475, -0.9655, 0>
    }  
        
    
        
    translate <0.06, 0, 0>

    rotate <15, 0, 0>
        translate <0, 0.97, 0>
    rotate <0, 0, 5.7106> 
    translate <0.2, 0.1, 0> 
    translate <0.275, 0.275, 0>

    }    
#declare letterThickness = 0.3;         
 
// X
#declare X=union { 
    cylinder { <-0.5, -0.5, 0> <0.5, 1.25, 0> letterThickness }
    cylinder { <-0.5, 1.25, 0> <0.5, -0.5, 0> letterThickness }
    sphere { <-0.5, -0.5, 0> letterThickness }
    sphere { <0.5, 1.25, 0> letterThickness }
    sphere { <-0.5, 1.25, 0> letterThickness }
    sphere { <0.5, -0.5, 0> letterThickness }
} 

// 2
#declare Two = union {
    intersection {
        torus { 0.5, letterThickness rotate <90, 0, 0> }
        box { <-(0.6+letterThickness), 0, -(letterThickness+0.1)> <0.6+letterThickness, 0.6+letterThickness, letterThickness+0.1> }
        translate <0, 0.75, 0>
    }                                                                                                                         
    sphere { <-0.5 0.75, 0> letterThickness }
    sphere { <0.5 0.75, 0> letterThickness }
    cylinder { <0.5, 0.75, 0> <-0.5, -0.5, 0> letterThickness }
    sphere { <-0.5, -0.5, 0> letterThickness }
    cylinder { <-0.5, -0.5, 0> <0.5, -0.5, 0> letterThickness }
    sphere { <0.5, -0.50, 0> letterThickness }
}
           
// JUNIOR 
// J
#declare J=union { 
    cylinder { <0.5, 0, 0> <0.5, 1.25, 0> letterThickness }
    intersection {
        torus { 0.5, letterThickness rotate <90, 0, 0> }
        union {
            box { <0, -1.00, -letterThickness*1.1> <1.0, 0, letterThickness*1.1> }
            box { <0, -1.00, -letterThickness*1.1> <1.0, 0, letterThickness*1.1> rotate <0, 0, -45> }
        }    
    }        
    sphere { <0.5, 1.25, 0> letterThickness }
    sphere { <0, -0.5, 0> letterThickness rotate <0, 0, -45> }
}

// U
#declare U=union { 
    cylinder { <0.5, 0, 0> <0.5, 1.25, 0> letterThickness }
    cylinder { <-0.5, 0, 0> <-0.5, 1.25, 0> letterThickness }
    intersection {
        torus { 0.5, letterThickness rotate <90, 0, 0> }
        box { <-1.0, -1.00, -letterThickness*1.1> <1.0, 0, letterThickness*1.1> }
    }        
    sphere { <0.5, 1.25, 0> letterThickness }
    sphere { <-0.5, 1.25, 0> letterThickness }
    
}

// N
#declare N=union { 
    cylinder { <0.5, -0.5, 0> <0.5, 1.25, 0> letterThickness }
    cylinder { <-0.5, -0.5, 0> <-0.5, 1.25, 0> letterThickness } 
    cylinder { <-0.5, 1.25, 0> <0.5, -0.5, 0> letterThickness }
    sphere { <-0.5, -0.5, 0> letterThickness }
    sphere { <-0.5, 1.25, 0> letterThickness }
    sphere { <0.5, -0.5, 0> letterThickness }
    sphere { <0.5, 1.25, 0> letterThickness }
    
}  

// I
#declare I=union { 
    cylinder { <0, -0.5, 0> <0, 1.25, 0> letterThickness }
    sphere { <0, -0.5, 0> letterThickness }
    sphere { <0, 1.25, 0> letterThickness }
    
} 
// O
#declare O=union { 
    cylinder { <0.5, 0, 0> <0.5, 0.75, 0> letterThickness }
    cylinder { <-0.5, 0, 0> <-0.5, 0.75, 0> letterThickness }
    intersection {
        torus { 0.5, letterThickness rotate <90, 0, 0> }
        box { <-1.0, -1.00, -letterThickness*1.1> <1.0, 0, letterThickness*1.1> }
    }        
    intersection {
        torus { 0.5, letterThickness rotate <90, 0, 0> }
        box { <-1.0, 0, -letterThickness*1.1> <1.0, 1.0, letterThickness*1.1>  }
        translate <0, 0.75, 0>
    }        
    
}   
//R
#declare R=union { 
    cylinder { <-0.5, -0.5, 0> <-0.5, 1.25, 0> letterThickness }    
    cylinder { <-0.5, 1.25, 0> <0, 1.25, 0> letterThickness }
    
    intersection {
        torus { 0.45, letterThickness rotate <90, 0, 0> }
        box { <0, -1.00, -letterThickness*1.1> <1.0, 1.0, letterThickness*1.1> }
        translate <0, 0.8, 0>
    }
    cylinder { <-0.5, 0.35, 0> <0, 0.35, 0> letterThickness }  
    cylinder { <0.25, 0.275, 0> <0.5, -0.5, 0> letterThickness }  
    sphere { <-0.5, 1.25, 0> letterThickness }
    sphere { <-0.5, -0.5, 0> letterThickness }
    sphere { <0.25, 0.275, 0> letterThickness }
    sphere { <0.5, -0.5, 0> letterThickness }
    
          
    
} 

#declare getRad = function(sphereRad, sphereHeight) {sqrt((sphereRad-((sphereRad-sphereHeight)/2))*(8*(sphereRad-sphereHeight)))/2 }; 

#declare Lantern = union {

union {
// bottom of base
intersection {
torus { 0.4-getRad(0.02, 0.01),0.02}
box { <-0.43, -0.03, -0.43> <0.43, 0.01, 0.43> }  
    texture { lampDirtTex }   
        texture { 
 pigment { 
    gradient y 
    turbulence 0.175       
    octaves 8
    omega 0.8
    lambda 2.5
    colour_map
    {
        [ 0.0 rgbt <0.01, 0.005, 0, 0> ]
        [ 0.2 rgbt <0.01, 0.005, 0, 0.0> ]
        [ 0.6 rgbt <0.01, 0.005, 0, 0.4> ]
        [ 0.75 rgbt <0.01, 0.005, 0, 1> ]
        [ 0.75 rgbt <1, 1, 1, 1> ]
        [ 1.0 rgbt <1, 1, 1, 1> ]
    }         
    scale <2, 0.05, 1> 
    translate <0, -0.025, 0>               
    
 }
 }       

} 
                 
// base
cone{ <0,0.01,0>,0.4, <0,0.075,0>, 0.35 }

// top of cone part of base
difference {  
    cylinder { <0, 0.075, 0> <0, 0.2, 0> 0.35 }
    intersection {
        torus { 0.35+getRad(0.05, 0.03), 0.05 }  
        box { <-0.5, -0.03, -0.5> <0.5, 0.06, 0.5> }  
        translate <0, 0.105, 0>
    }   
    box { <-0.4, 0.105, -0.4> <0.4, 0.21, 0.4> }  
    translate <0, 0.0, 0>
}
// straight part of base
cylinder { <0, 0.105, 0> <0, 0.21, 0> 0.3+getRad(0.05, 0.03) }

// sloped part at top of base
union {
difference {
torus {  0.3+getRad(0.05, 0.03)-0.025, 0.025 }       
box { <-0.4, 0.015, -0.4> <0.4, 0.1, 0.4> }  
}
cone { <0, 0.015, 0>, 0.3+getRad(0.05, 0.03)-0.025+getRad(0.025, 0.015), <0, 0.1, 0>, 0.25 }
 translate <0, 0.21, 0>
} 

// top of top cone
difference {
torus { 0.225+(0.025-getRad(0.025, 0.0175)), 0.025 }
box { <-0.3, -0.03, -0.3> <0.3, 0.0175, 0.3> }
translate <0, 0.2925, 0>
}   
cylinder { <0, 0, 0> <0, 0.3175, 0> 0.225+(0.025-getRad(0.025, 0.0175)) }


// writing on cone
//intersection {

 object { J scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, 36, 0> }
 object { U scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, 24, 0> }
 object { N scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, 12, 0> }
 object { I scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, 3, 0> }
 object { O scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, -6, 0> }
 object { R scale <0.0325, 0.0275, 0.015> rotate <45, 0, 0> translate <0, 0.270, -0.286> rotate <0, -18, 0> }

// metal part under glass
union
{
   difference { 
    cylinder { <0, 0, 0> <0, 0.05, 0> 0.2 }   
    union {
        sphere { <0, 0.05, 0> 0.19 }

    cylinder { <-0.04, 0, 0> <-0.04, 1, 0> 0.00775 rotate <0, 0, 30> translate <-0.05, 0.09, 0> rotate <0, 0, 60>   
            translate <0.470, 0.081, -0.065>   }

    }    
   }
   torus { 0.195, 0.005 }
   
   difference 
   {
       cylinder { <0, 0, 0> <0, 0.025, 0> 0.225 }   
       torus { 0.225, 0.025 }
       sphere { <0, 0, 0> 0.19 }
       translate <0, 0.05, 0>
               
   } 
   difference {     
    cylinder { <0, 0.075, 0> <0, 0.095, 0> 0.225 }
    sphere { <0, 0.05, 0> 0.19 }
    torus { 0.19, 0.01 translate <0, 0.095, 0> }
   }
   torus { 0.225, 0.01 translate <0, 0.085, 0> }
  

   translate <0, 0.32, 0>
} 


        texture {
            gradient y   
            turbulence 0.0275
            omega 0.9    
            octaves 8
            lambda 2.5
            texture_map
            {
                [ 0.0 lampDirtTex scale <1, 1.66, 1> ] // lampBaseTex ]
                [ 0.125 lampDirtTex scale <1, 1.66, 1> ] // lampBaseTex ]
                [ 0.4  lampBaseTex scale <1, 1.66, 1> ] // lampDirtTex ]
                [ 0.46 lampBaseTex scale <1, 1.66, 1> ] // lampDirtTex ]
                [ 0.54 lampDirtTex scale <1, 1.66, 1> ] // lampBaseTex ]
                [ 0.55 lampDirtTex scale <1, 1.66, 1> ] // lampBaseTex ]
                [ 0.6 lampBaseTex scale <1, 1.66, 1> ] // lampDirtTex ]
                [ 0.675 lampDirtTex scale <1, 1.66, 1> ] // lampBaseTex ]
                [ 1.0 lampBaseTex scale <1, 1.66, 1> ] // lampDirtTex ]
            }                        
            scale <1, 0.6, 1>     
            translate <0, -0.1, 0>
        }  
}

// burner inside glass
union
{
    cone { <0, 0, 0> 0.1 <0, 0.15, 0> 0.05 }
    torus { 0.04, 0.01 translate <0, 0.15, 0> }    
    cylinder { <0, 0.14, 0> <0, 0.16, 0> 0.04 } 
    
    difference {
        cylinder { <0, 0.15, 0> <0, 0.22, 0> 0.03 }
        union
        {   
            cylinder { <0, 0.16, 0> <0, 0.24, 0> 0.025 }
            cylinder { <0, 0.21, -0.03> <0, 0.21, 0.03> 0.007 }
            cylinder { <0, 0.21, -0.03> <0, 0.21, 0.03> 0.007 rotate <0, 45, 0> }
            cylinder { <0, 0.21, -0.03> <0, 0.21, 0.03> 0.007 rotate <0, 90, 0> }
            cylinder { <0, 0.21, -0.03> <0, 0.21, 0.03> 0.007 rotate <0, 135, 0> }
        } 
        
    }
    torus { 0.0275, 0.0025 translate <0, 0.22, 0>  }    
    
    // wick
    union
    {
        cylinder { <0, 0.2, 0> <0, 0.225, 0> 0.018 }
        sphere { 0, 0.018 scale <1, 0.6, 1> translate <0, 0.225, 0> }
        pigment { rgb <0.03, 0.02, 0.01> } 
    }  
    
 
 
// flame
#if(lightLantern)
merge {
 sphere // transparent sphere containing media
 { 0,0.075 scale <1, 4, 1>}
                                light_source {
                                  <0,0.1,0>             // light's position (translated below)
                                  color rgb <1, 0.8, 0.5> // light's color
                                  area_light
                                  <-.1, 0, -.1> <.1, .2, .1> // lights spread out across this distance (x * z)
                                  8, 8                // total number of lights in grid (4x*4z = 16 lights)    
                                  area_illumination on
                                  adaptive 0          // 0,1,2,3...
                                  jitter              // adds random softening of light
                                  circular            // make the shape of the light circular
                             //     orient              // orient light
                                  fade_distance 4
                                  fade_power 2

                                }            
  pigment { rgbt 1 } hollow   
 
                           interior
                           { media
                             {
                               emission colour rgb <0.1, 0.5, 1>*5
                               density
                               { spherical turbulence 0.13 omega 0.89 density_map
                                 {
                                   [0.0 rgb <0, 0, 0.0> ]          
                                   [0.075 rgb <0, 0, 0.3> ]          
                                   [0.15 rgb <0.02, 0.02, 0.45>]
                                   [0.4 rgb <0.01, 0.2, 2>]
                                   [0.475 rgb <0.0, 0.0, 0.35>]
                                   [1 rgb <0.0, 0.0, 0.5> ]
                                 }  
                                scale <0.0175, 0.05, 0.0175> 
                                translate<0,-0.03,0>
                               }
                             }
                           }   
   interior
   { media
     { 
                               emission colour rgb <1, 0.95, 0.9>*15
                               density
                               { spherical turbulence 0.2167 omega 0.66 lambda 2.2 density_map
                                 {
                                   [0.0 rgb <0.0, 0, 0.0> ]          
                                   [0.2 rgb <0.7, 0.3, 0.1> ]          
                                   [0.25 rgb <0.55, 0.4, 0.2>]
                                   [0.5 rgb <0.7, 0.5, 0.3>]
                                   [0.675 rgb <1.0, 1.0, 0.8>]
                                   [1 rgb <1.0, 0.8, 0.5> ]
                                 }  
       scale <0.05, 0.15, 0.05> 
       }   
       
     }
  } 
  translate <0, 0.3, 0>
 }
                       #end
 
 
 
 // end of flame
 
 
 texture { lampBurnerTex  }
    
    
    translate <0, 0.3, 0> 
}

/****************************************************
 metal frame around glass
****************************************************/

union
{
// main body
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0, 0> <0.1, 0, 0> 0.05 }     
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
}
// long part
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.05 }    
sphere { <0.2, 0.1, 0> 0.05 }                    
sphere { <0.1, 1.1, 0> 0.05 }
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.05 }

// torus's on long part
union { 
    torus { 0.05, 0.005 translate <0, 0.025, 0> }
    torus { 0.05, 0.005 translate <0, 0.475, 0> }
    torus { 0.05, 0.005 translate <0, 0.925, 0> }
    
    // connection for handle
    union
    {
        difference
        {
            cylinder { <0, 0, 0> <0.06, 0, 0> 0.01 }
            cylinder { <0, 0, 0> <0.07, 0, 0> 0.0075 }             
        } 
        cylinder { <0, 0, 0> <0.055, 0, 0> 0.015 }   
        torus { 0.01, 0.005 rotate <0, 0, 90> translate <0.055, 0, 0> }                                          
        
        translate <0, 0.97, 0>
    }     
    
    // bottom connection
    union
    {
        difference {
            box { <-0.015, -0.02, -0.02> <0.015, 0.02, 0.02> }
            union
            {
                cylinder { <-0.03, 0.02, -0.02> <0.03, 0.02, -0.02> 0.01 }
                cylinder { <-0.03, -0.02, -0.02> <0.03, -0.02, -0.02> 0.01 }
                cylinder { <-0.025, 0, -0.02> <0.025, 0, -0.02> 0.0075 }        
            }
        }
        difference {
            cylinder { <-0.015, 0, -0.02> <0.015, 0, -0.02> 0.01 }        
            cylinder { <-0.025, 0, -0.02> <0.025, 0, -0.02> 0.0075 }        
        } 
        box { <-0.015, -0.03, -0.01> <0.015, -0.02, 0.02> }
        box { <-0.015, 0.02, -0.01> <0.015, 0.03, 0.02> }
        
        translate <0, 0.075, -0.045>  
    }
    rotate <0, 0, 5.7106> 
    translate <0.2, 0.1, 0> 
    
}   
    

// small decorative part at front
union
{
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0, 0> <0.1, 0, 0> 0.005 }     
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
} 
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.005 } 
sphere { <0.2, 0.1, 0> 0.005 }
sphere { <0.1, 1.1, 0> 0.005 }
intersection {
 torus { 0.1, 0.005 rotate <90, 0, 0> }
 box { <0, 0, -0.1> <0.3, 0.3, 0.1> }
 translate <0, 1.1, 0> 
}  
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.005 }

translate <0, 0, -0.05>
}
// small decorative part at back
union
{
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <-0.1, 0, 0> <0.1, 0, 0> 0.005 }    
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
} 
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.005 } 
sphere { <0.2, 0.1, 0> 0.005 }
sphere { <0.1, 1.1, 0> 0.005 }
intersection {
 torus { 0.1, 0.005 rotate <90, 0, 0> }
 box { <0, 0, -0.1> <0.3, 0.3, 0.1> }
 translate <0, 1.1, 0> 
}  
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.005 }

 
translate <0, 0, 0.05>
}     

// small decorative part at bottom of bottom/top of top
union
{
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <-0.1, -0.05, 0> <0.1, -0.05, 0> 0.005 } 
 
cylinder { <0.25, 0.1, 0> <0.15, 1.1, 0> 0.005 }   
sphere { <0.25, 0.1, 0> 0.005 }
sphere { <0.15, 1.1, 0> 0.005 } 
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.25, 0> <0, 1.25, 0> 0.005 }
 
scale <1, 1, 0.5>
} 

// small decorative part on top of bottom/bottom of top
union
{
intersection {
    torus { 0.05, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0.05, 0> <0.1, 0.05, 0> 0.005 } 
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 00.3, 0.1> }      
    translate <0.05, -0.1, 0>
}

cylinder { <0.15, 0.1, 0> <0.05, 1.1, 0> 0.005 }   
sphere { <0.15, 0.1, 0> 0.005 }
sphere { <0.05, 1.1, 0> 0.005 } 
intersection {
    torus { 0.05, 0.005 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.15, 0> <0, 1.15, 0> 0.005 }


scale <1, 1, 0.5>
} 
 
// connection onto top part
union
{
cylinder { <-0.1, 1.2, 0> <-0.045, 1.2, 0> 0.055 }
torus { 0.055, 0.005 rotate <0, 0, 90> translate <-0.05, 1.2, 0> }
cylinder { <-0.1, 1.2, 0> <-0.05, 1.2, 0> 0.06 }
torus { 0.06, 0.01 rotate <0, 0, 90> translate <-0.065, 1.2, 0> }
difference {
    cylinder { <-0.08, 1.2, 0> <-0.065, 1.2, 0> 0.09 }  
    torus { 0.09, 0.02 rotate <0, 0, 90> translate <-0.065, 1.2, 0> }
    }
    translate <-0.01, 0, 0>
}    
    translate <0.275, 0.275, 0>

        texture {
            gradient y   
            turbulence 0.03275
            omega 0.75    
            octaves 7
            lambda 2.95
            texture_map
            {
                [ 0.0 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.07 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.085 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.11 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.12 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.35 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.41 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.439 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.45 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.65 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.74 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.76 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.87 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.95 lampDirtTex scale <1, 0.71, 1> ] 
                [ 1.0 lampDirtTex scale <1, 0.71, 1> ] 
            }                        
            scale <1, 1.4, 1>   
            rotate <0, 0, 2>  
            translate <0, 0.2, 0>
        }        
}    
  

/****************************************************
 left side frame around glass (copy of above scale -1)
*****************************************************/

union
{
// main body
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0, 0> <0.1, 0, 0> 0.05 }     
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
}
// long part
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.05 }    
sphere { <0.2, 0.1, 0> 0.05 }                    
sphere { <0.1, 1.1, 0> 0.05 }
intersection {
    torus { 0.1, 0.05 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.05 }

// torus's on long part
union { 
    torus { 0.05, 0.005 translate <0, 0.025, 0> }
    torus { 0.05, 0.005 translate <0, 0.475, 0> }
    torus { 0.05, 0.005 translate <0, 0.925, 0> }
    
    // connection for handle
    union
    {
        difference
        {
            cylinder { <0, 0, 0> <0.06, 0, 0> 0.01 }
            cylinder { <0, 0, 0> <0.07, 0, 0> 0.0075 }             
        } 
        cylinder { <0, 0, 0> <0.055, 0, 0> 0.015 }   
        torus { 0.01, 0.005 rotate <0, 0, 90> translate <0.055, 0, 0> }                                          
        
        translate <0, 0.97, 0>
    }     
    
    // bottom connection
    union
    {
        difference {
            box { <-0.015, -0.02, -0.02> <0.015, 0.02, 0.02> }
            union
            {
                cylinder { <-0.03, 0.02, -0.02> <0.03, 0.02, -0.02> 0.01 }
                cylinder { <-0.03, -0.02, -0.02> <0.03, -0.02, -0.02> 0.01 }
                cylinder { <-0.025, 0, -0.02> <0.025, 0, -0.02> 0.0075 }        
            }
        }
        difference {
            cylinder { <-0.015, 0, -0.02> <0.015, 0, -0.02> 0.01 }        
            cylinder { <-0.025, 0, -0.02> <0.025, 0, -0.02> 0.0075 }        
        } 
        box { <-0.015, -0.03, -0.01> <0.015, -0.02, 0.02> }
        box { <-0.015, 0.02, -0.01> <0.015, 0.03, 0.02> }
        
        translate <0, 0.075, -0.045> 
    }
    rotate <0, 0, 5.7106> 
    translate <0.2, 0.1, 0> 
    
}

// small decorative part at front
union
{
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0, 0> <0.1, 0, 0> 0.005 }     
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
} 
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.005 } 
sphere { <0.2, 0.1, 0> 0.005 }
sphere { <0.1, 1.1, 0> 0.005 }
intersection {
 torus { 0.1, 0.005 rotate <90, 0, 0> }
 box { <0, 0, -0.1> <0.3, 0.3, 0.1> }
 translate <0, 1.1, 0> 
}  
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.005 }

translate <0, 0, -0.05>
}
// small decorative part at back
union
{
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <-0.1, 0, 0> <0.1, 0, 0> 0.005 }    
intersection {
    torus { 0.1, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 0.3, 0.1> }      
    translate <0.05, -0.1, 0>
} 
cylinder { <0.2, 0.1, 0> <0.1, 1.1, 0> 0.005 } 
sphere { <0.2, 0.1, 0> 0.005 }
sphere { <0.1, 1.1, 0> 0.005 }
intersection {
 torus { 0.1, 0.005 rotate <90, 0, 0> }
 box { <0, 0, -0.1> <0.3, 0.3, 0.1> }
 translate <0, 1.1, 0> 
}  
cylinder { <-0.1, 1.2, 0> <0, 1.2, 0> 0.005 }

 
translate <0, 0, 0.05>
}     

// small decorative part at bottom of bottom/top of top
union
{
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <-0.1, -0.05, 0> <0.1, -0.05, 0> 0.005 } 
 
cylinder { <0.25, 0.1, 0> <0.15, 1.1, 0> 0.005 }   
sphere { <0.25, 0.1, 0> 0.005 }
sphere { <0.15, 1.1, 0> 0.005 } 
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.25, 0> <0, 1.25, 0> 0.005 }
 
scale <1, 1, 0.5>
} 

// small decorative part on top of bottom/bottom of top
union
{
intersection {
    torus { 0.05, 0.005 rotate <90, 0, 0> }
    box { <0, -0.3, -0.1> <0.3, 0, 0.1> }      
    translate <0.1, 0.1, 0>
}
cylinder { <0.05, 0.05, 0> <0.1, 0.05, 0> 0.005 } 
intersection {
    torus { 0.15, 0.005 rotate <90, 0, 0> }
    box { <-0.3, 0, -0.1> <0, 00.3, 0.1> }      
    translate <0.05, -0.1, 0>
}

cylinder { <0.15, 0.1, 0> <0.05, 1.1, 0> 0.005 }   
sphere { <0.15, 0.1, 0> 0.005 }
sphere { <0.05, 1.1, 0> 0.005 } 
intersection {
    torus { 0.05, 0.005 rotate <90, 0, 0> }
    box { <0, 0, -0.1> <0.3, 0.3, 0.1> }  
    translate <0, 1.1, 0>
} 
cylinder { <-0.1, 1.15, 0> <0, 1.15, 0> 0.005 }


scale <1, 1, 0.5>
}  

// connection onto top part
union
{
cylinder { <-0.1, 1.2, 0> <-0.045, 1.2, 0> 0.055 }
torus { 0.055, 0.005 rotate <0, 0, 90> translate <-0.05, 1.2, 0> }
cylinder { <-0.1, 1.2, 0> <-0.05, 1.2, 0> 0.06 }
torus { 0.06, 0.01 rotate <0, 0, 90> translate <-0.065, 1.2, 0> }
difference {
    cylinder { <-0.08, 1.2, 0> <-0.065, 1.2, 0> 0.09 }  
    torus { 0.09, 0.02 rotate <0, 0, 90> translate <-0.065, 1.2, 0> }
    }
    translate <-0.01, 0, 0>
}   
    
    translate <0.275, 0.275, 0>

        texture {
            gradient y   
            turbulence 0.03275
            omega 0.75    
            octaves 7
            lambda 2.95
            texture_map
            {
                [ 0.0 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.07 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.085 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.11 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.12 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.35 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.41 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.439 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.45 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.65 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.74 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.76 lampDirtTex scale <1, 0.71, 1> ] 
                [ 0.87 lampBaseTex scale <1, 0.71, 1> ] 
                [ 0.95 lampDirtTex scale <1, 0.71, 1> ] 
                [ 1.0 lampDirtTex scale <1, 0.71, 1> ] 
            }                        
            scale <1, 1.4, 1>  
            translate <.5, 0, 0> 
            rotate <0, 0, 2>  
            translate <0, 0.2, 0>
        }        

    scale <-1, 1, 1> 
}   
/****************************************************
End of left side copy
****************************************************/

/****************************************************
Handle
****************************************************/

      

union {

object {handleHalf }
object {handleHalf scale <-1, 1, 1> }    

texture { lampWireTex }

}
/****************************************************
End of handle
****************************************************/


/****************************************************
Top part above glass 
****************************************************/
union
{

      cylinder { <0, 0, 0> <0, 0.2, 0> 0.2 }    
      torus { 0.15, 0.05 translate <0, 0.2, 0> } 
      cylinder { <0, 0.2, 0> <0, 0.25, 0> 0.15 }  
        // vented part at top
      cylinder { <0, 0.25, 0> <0, 0.29, 0> 0.125 }
      torus { 0.125, 0.005 translate <0, 0.285, 0> }
      sphere { <0, 0, 0> 0.13 scale <1, 0.15, 1> translate <0, 0.2875, 0> }
      
      intersection
      {
        cylinder { <0, 0.29, 0> <0, 0.335, 0> 0.13 }
        union
        {
            box { <-0.01, 0.2, -0.2> <0.01, 0.4, 0.2> } 
            box { <-0.2, 0.2, -0.01> <-0.11, 0.4, 0.01> } 
            box { <0.11, 0.2, -0.01> <0.2, 0.4, 0.01> } 
        }
      }      
      
      // top conical part
      union
      { 
        torus { 0.2 0.0075 translate <0, -0.0075, 0> }  
        cone { <0, -0.015, 0> 0.2 <0, 0.02, 0> 0.075 }
        cone { <0, 0, 0> 0.2 <0, 0.04, 0> 0.075 }     
        torus { 0.15, 0.005 translate <0, 0.015, 0> }
        cone { <0, 0.02, 0> 0.15 <0, 0.045, 0> 0.075 }       
        
        // hook/loop at top
        
        union
        {
            box { <-0.05, 0, -0.03> <0.05, 0.005, 0.03> }   
            sphere { <0, 0, 0> 0.0075 scale <1, 0.5, 1> translate <-0.04, 0.005, -0.02> }
            sphere { <0, 0, 0> 0.0075 scale <1, 0.5, 1> translate <-0.04, 0.005, 0.02> }
            sphere { <0, 0, 0> 0.0075 scale <1, 0.5, 1> translate <0.04, 0.005, -0.02> }
            sphere { <0, 0, 0> 0.0075 scale <1, 0.5, 1> translate <0.04, 0.005, 0.02> }
            difference {
                union
                {
                   box { <-0.03, 0.002, -0.01> <0.03, 0.01, 0.01> }
                   cylinder { <-0.03, 0.01, 0> <0.03, 0.01, 0> 0.01 }
                   
                }  
                cylinder { <-0.05, 0.01, 0> <0.05, 0.01, 0> 0.007 }
            }    
            // hook part
            union
            {
                intersection 
                {
                    torus { 0.075 0.0065 rotate <90, 0, 0> }
                    box { <0, -0.11, -0.01> <0.11, 0.11, 0.01> }  
                    translate <0.02, 0.075, 0>                
                } 
                intersection 
                {
                    torus { 0.075 0.0065 rotate <90, 0, 0> }
                    box { <-0.11, -0.11, -0.01> <0, 0.11, 0.01> }     
                    translate <-0.02, 0.075, 0>                
                } 
                cylinder { <-0.02, 0, 0> <0.02, 0, 0> 0.0065 }
                cylinder { <-0.02, 0.15, 0> <0.02, 0.15, 0> 0.0065 }
                


                rotate <100, 0, 0> 
                translate <0, 0.01, 0>
            }
            
            
            translate <0, 0.045, 0>
        }
        
        texture {
            gradient y
            texture_map
            {
                [ 0.0  lampBaseTex ]
                [ 1.0 lampDirtTex ]
            }  
       }
        translate <0, 0.33, 0>
      }   
     
      // bottom conical part above holes
      union
      {
        cone { <0, 0.0, 0> 0.275 <0, 0.025, 0> 0.15 }  
        
        intersection
        { 
            torus { 0.265, 0.01 }
            box { <-0.3, -0.02, -0.3> <0.3, 0, 0.3> }    
        }
        cone { <0, 0, 0> 0.265 <0, 0.0125, 0> 0.15 translate <0, -0.01, 0> }  
        
        
      }   
      
      // bottom part with holes in.
      difference {
        cylinder { <0, -0.09, 0> <0, 0, 0> 0.155 } 
            cylinder { <0, -0.095, 0> <0, 0.05, 0> 0.145 }
            #declare cCount=0;
            #while (cCount <= 180 )
                cylinder { <0, -0.07, -0.17> <0, -0.07, 0.17> 0.012 rotate <0, cCount, 0> }                          
                                          
                #declare cCount=cCount+18;
            #end
        }
        difference {
            cylinder { <0, -0.11, 0> <0, -0.09, 0> 0.165 }    
            cylinder { <0, -0.115, 0> <0, -0.08, 0> 0.15 }    
            torus { 0.165, 0.01 translate <0, -0.09, 0> }
        }     
        torus { 0.165, 0.005 translate <00, -0.105, 0> }
      translate <0, 1.35, 0>   
      
        texture {
            gradient y   
            turbulence 0.0275
            omega 0.65    
            octaves 7
            lambda 2.2
            texture_map
            {
                [ 0.0 lampDirtTex2 scale <1, 2.5, 1>] // lampBaseTex ]
                [ 0.2 lampDirtTex scale <1, 2.5, 1>] // lampBaseTex ]
                [ 0.3 lampBaseTex scale <1, 2.5, 1>] // lampDirtTex ]
                [ 0.6 lampBaseTex scale <1, 2.5, 1>] // lampDirtTex ]
                [ 0.9 lampDirtTex scale <1, 2.5, 1>] // lampBaseTex ]
                [ 1.0 lampDirtTex scale <1, 2.5, 1>] // lampBaseTex ]
            }                        
            scale <1, 0.4, 1>     
            translate <0, 0.05, 0>
        }            

}  
/****************************************************
glass
****************************************************/

difference { 
merge
{
intersection {
//torus { 0.4-getRad(0.02, 0.01),0.02}
sphere { <0, 0, 0> 0.275 scale <1, 1.2, 1> }
box { <-0.43, -0.2150001, -0.43> <0.43, 0.0850001, 0.43> } 
translate <0, 0.64, 0>
}                     

difference
{
    cylinder { <0, 0.42, 0> <0, 0.435, 0> getRad(0.275, 0.179167)  }
    torus { getRad(0.275, 0.179167), 0.01 translate <0, 0.425, 0> }   
    translate <0, -0.01, 0>
} 
                        
cone{ <0,0.725,0>, getRad(0.275, 0.070833), <0, 1.2300001,0>, 0.175 }
torus { 0.165, 0.01 translate <0, 1.23, 0> }    
cylinder { <0, 1.2, 0> <0, 1.24, 0> 0.165 } 


difference { 
    cylinder { <0, 1.24, 0> <0, 1.26, 0> 0.15 }
    torus { 0.15, 0.02 translate <0, 1.26, 0> }
}    
cylinder { <0, 1.26, 0> <0, 1.27, 0> 0.13 }
}
union
{
union
{
intersection {
//torus { 0.4-getRad(0.02, 0.01),0.02}
sphere { <0, 0, 0> 0.275 scale <1, 1.2, 1> }
box { <-0.43, -0.216, -0.43> <0.43, 0.086, 0.43> } 
translate <0, 0.64, 0>
}                     
difference
{
    cylinder { <0, 0.42, 0> <0, 0.435, 0> getRad(0.275, 0.179167)  }
    torus { getRad(0.275, 0.179167), 0.01 translate <0, 0.425, 0> }   
    translate <0, -0.01, 0>
} 
                        
cone{ <0,0.724,0>, getRad(0.275, 0.070833), <0, 1.231,0>, 0.175 }
torus { 0.165, 0.01 translate <0, 1.23, 0> }    
cylinder { <0, 1.2, 0> <0, 1.24, 0> 0.165 } 
difference { 
    cylinder { <0, 1.24, 0> <0, 1.26, 0> 0.15 }
    torus { 0.15, 0.02 translate <0, 1.26, 0> }
}    
cylinder { <0, 1.26, 0> <0, 1.28, 0> 0.13 }
scale <0.95, 1, 0.95> 
}
  cylinder { <0, 0.4, 0> <0, 0.45, 0> getRad(0.26, 0.179167)  }
cylinder { <0, 1.2, 0> <0, 1.281, 0> 0.125 }


}  
         material{ 
                    texture
                    {
                    pigment {
                        rgbf <0.99, 0.99, 0.98, 0.999> 
                    }
                     finish {
    specular albedo 0.11
    roughness 0.002
    ambient 0     
    diffuse 0.2
    brilliance 4
    reflection {
      0.15, 0.65    
      fresnel on
    }
    conserve_energy
  } 
  }   

  interior {
    ior 1.5
    fade_distance 0.5
    fade_power 1001  
  }                 
  } // end of material ---------------------

//pigment { rgbt 1 }
}

// hooked part that links betwen brackets on either side

// right side
union
{
intersection {
    torus { 0.05, 0.006 rotate <90, 0, 0> }
    union
    {
        box { <0, 0, -0.01> <0.11, 0.11, 0.01> }  
        box { <0, 0, -0.01> <0.11, 0.11, 0.01> rotate <0, 0, 60> }  
    }  
}
    sphere { <0, 0, 0> 0.006 scale <1.2, 1, 1> translate <0, 0.05, 0> rotate <0, 0, -90> } 
    cylinder { <-0.05, 0.05, 0> <0, 0.05, 0> 0.006 rotate <0, 0, 60> }   
    difference  
    {
        torus { 0.04, 0.006 rotate <90, 0, 0> }
        union
        {
            box { <0, -0.1, -0.01> <0.1, 0.1, 0.01> }
            box { <-0.1, 0, -0.01> <0.1, 0.1, 0.01> rotate <0, 0, 30> }
        }
        translate <-0.05, 0.09, 0> rotate <0, 0, 60>
    }
    
    cylinder { <-0.04, 0, 0> <-0.04, 0.4, 0> 0.006 rotate <0, 0, 30> translate <-0.05, 0.09, 0> rotate <0, 0, 60> } 
    torus { 0.012 0.005 scale <1, 1, 1> translate <-0.04, 0.18, 0> rotate <0, 0, 30> translate <-0.05, 0.09, 0> rotate <0, 0, 60> } 
     
    texture { lampWireTex }
    
    translate <0.470, 0.401, -0.065> 
}    

// http://www.ebay.com/itm/Antique-Dietz-Little-Wizard-Gem-Railroad-Barn-Lantern-2-18-18-Pat-Red-Globe-/150983296001?_trksid=p2047675.m1850&_trkparms=aid%3D222002%26algo%3DSIC.FIT%26ao%3D1%26asc%3D11%26meid%3D5094950245415893591%26pid%3D100011%26prg%3D1005%26rk%3D5%26sd%3D110985394966%26

// left side (scale -1)
union
{
intersection {
    torus { 0.05, 0.006 rotate <90, 0, 0> }
    union
    {
        box { <0, 0, -0.01> <0.11, 0.11, 0.01> }  
        box { <0, 0, -0.01> <0.11, 0.11, 0.01> rotate <0, 0, 60> }  
    }  
}
    sphere { <0, 0, 0> 0.006 scale <1.2, 1, 1> translate <0, 0.05, 0> rotate <0, 0, -90> } 
    cylinder { <-0.05, 0.05, 0> <0, 0.05, 0> 0.006 rotate <0, 0, 60> }   
    difference  
    {
        torus { 0.04, 0.006 rotate <90, 0, 0> }
        union
        {
            box { <0, -0.1, -0.01> <0.1, 0.1, 0.01> }
            box { <-0.1, 0, -0.01> <0.1, 0.1, 0.01> rotate <0, 0, 30> }
        }
        translate <-0.05, 0.09, 0> rotate <0, 0, 60>
    }
    
    cylinder { <-0.04, 0, 0> <-0.04, 0.4, 0> 0.006 rotate <0, 0, 30> translate <-0.05, 0.09, 0> rotate <0, 0, 60> } 
    torus { 0.012 0.005 scale <1, 1, 1> translate <-0.04, 0.18, 0> rotate <0, 0, 30> translate <-0.05, 0.09, 0> rotate <0, 0, 60> } 
     
   
    translate <0.470, 0.401, -0.065>   
    texture { lampWireTex }

    scale <-1, 1, 1>
} 

// wire around glass  


// WIRE AROUND GLASS
union
{ 

union  {
intersection {
    torus { 0.02, 0.006 rotate <90, 0, 0> }
    union
    { 
     box { <-0.04, 0, -0.01> <0, 0.04, 0.01> rotate <0, 0, 35> }
     box { <-0.04, -0.04, -0.01> <0, 0.0, 0.01> rotate <0, 0, -35> }
    }           
    rotate <20, 0, 0>    
    translate <0.005, 0, 0>
} 

intersection {
    torus { 0.02, 0.006 rotate <90, 0, 0> }
    union
    { 
     box { <0.0, 0, -0.01> <0.04, 0.04, 0.01> rotate <0, 0, -35> }
     box { <0.0, -0.04, -0.01> <0.04, 0.0, 0.01> rotate <0, 0, 35> }
    }     
    rotate <-20, 0, 0>    
    translate <-0.005, 0, 0>
}

translate <0, 0, -0.3>
} 

union  {
intersection {
    torus { 0.02, 0.006 rotate <90, 0, 0> }
    union
    { 
     box { <-0.04, 0, -0.01> <0, 0.04, 0.01> rotate <0, 0, 35> }
     box { <-0.04, -0.04, -0.01> <0, 0.0, 0.01> rotate <0, 0, -35> }
    }           
    rotate <20, 0, 0>    
    translate <0.005, 0, 0>
} 

intersection {
    torus { 0.02, 0.006 rotate <90, 0, 0> }
    union
    { 
     box { <0.0, 0, -0.01> <0.04, 0.04, 0.01> rotate <0, 0, -35> }
     box { <0.0, -0.04, -0.01> <0.04, 0.0, 0.01> rotate <0, 0, 35> }
    }     
    rotate <-20, 0, 0>    
    translate <-0.005, 0, 0>
}

translate <0, 0, -0.3>
scale <1, 1, -1> 
} 

sphere { <0, -0.02, 0> 0.006 rotate <0, 0, -35> rotate <20, 0, 0> translate <0.005, 0, -0.3> } 
sphere { <0, 0.02, 0> 0.006 rotate <0, 0, 35> rotate <20, 0, 0> translate <0.005, 0, -0.3> } 
sphere { <0, -0.02, 0> 0.006 rotate <0, 0, -35> rotate <20, 0, 0> translate <0.005, 0, -0.3> scale <1, 1, -1> } 
sphere { <0, 0.02, 0> 0.006 rotate <0, 0, 35> rotate <20, 0, 0> translate <0.005, 0, -0.3> scale <1, 1, 1> } 

sphere { <0, 0.02, 0> 0.006 rotate <0, 0, -35> rotate <-20, 0, 0> translate <-0.005, 0, -0.3> } 
sphere { <0, -0.02, 0> 0.006 rotate <0, 0, 35> rotate <-20, 0, 0> translate <-0.005, 0, -0.3> } 
sphere { <0, 0.02, 0> 0.006 rotate <0, 0, -35> rotate <-20, 0, 0> translate <-0.005, 0, -0.3> scale <1, 1, -1> } 
sphere { <0, -0.02, 0> 0.006 rotate <0, 0, 35> rotate <-20, 0, 0> translate <-0.005, 0, -0.3> scale <1, 1, -1> } 


intersection {
    torus { 0.3062 0.006 }
    box { <0, -0.01, -0.35> <0.35, 0.01, 0.35> } 
    translate <0, 0, 0.3062>   
    rotate <0, 0, -35>
    translate vrotate(vrotate(<0, -0.02, 0>, <0, 0, -35>), <20, 0, 0>) 

    translate <0.005, 0.00, -0.3>  
} 

intersection {
    torus { 0.2938 0.006 }
    box { <0, -0.01, -0.35> <0.35, 0.01, 0.35> } 
    translate <0, 0, 0.2938>   
    rotate <0, 0, 35>
    translate vrotate(vrotate(<0, 0.02, 0>, <0, 0, 35>), <20, 0, 0>) 

    translate <0.005, 0.00, -0.3>  
} 

intersection {
    torus { 0.3062 0.006 }
    box { <-0.35, -0.01, -0.35> <0, 0.01, 0.35> } 
    translate <0, 0, 0.3062>   
    rotate <0, 0, -35>
    translate vrotate(vrotate(<0, 0.02, 0>, <0, 0, -35>), <-20, 0, 0>) 

    translate <-0.005, 0.00, -0.3>  
} 

intersection {
    torus { 0.2938 0.006 }
    box { <-0.350, -0.01, -0.35> <0, 0.01, 0.35> } 
    translate <0, 0, 0.2938>   
    rotate <0, 0, 35>
    translate vrotate(vrotate(<0, -0.02, 0>, <0, 0, 35>), <-20, 0, 0>) 

    translate <-0.005, 0.00, -0.3>  
} 

 scale <1.0775, 1, 1>
    rotate <0, 0, 0> 
translate <0.0, 0.675, 0> 

 texture { lampWireTex }
}     
 


}                                                                     
                                                                      


/********************** END OF LANTERN ******************************/




#if(showLantern)

object { Lantern 

translate <0, 0.02, 0>
scale 1.8       
rotate <0, 32, 0>


translate <0.5, 0.0, 0.5>
} 
   
   
#end                                      




 
#if(showTripod)
#include "tripod.inc"
object { tripod 
 scale 0.035  
 rotate <0, 95, 0>
 translate <-1.02, 0, -2.5> 
 }

#end