// Title:        PointArrays bezier spline demo scene
// Written by:   Matthew Goulet <povray@bherring.cotse.net>
// Created on:   June 16, 2008
// Last updated: June 24, 2008
//
// This file is licensed under the terms of the CC-LGPL
//

#include "pa_shooting_star.inc"
#include "pointarrays.inc"

#declare Triangle =
array[12] {
        <10.03949100, 0.44978262>, <9.68934640, -0.15351738>, <0.42296231, -0.13181738>, <0.07563849, 0.47308262>,
        <0.07563849, 0.47308262>, <-0.27168565, 1.07788262>, <4.38024760, 9.09198262>, <5.07771820, 9.09028262>,
        <5.07771820, 9.09028262>, <5.77518750, 9.08868262>, <10.38963800, 1.05288262>, <10.03949100, 0.44978262>
};

merge {
        object {
                PA_Bezier_Sweep (PA_Shooting_Star, 0.15, PA_No_Trans, 40, no)
                rotate x*90
                translate y*0.5
        }
        merge {
                #declare Count = 60;
                #declare Ct = 0;
                #while (Ct < Count)
                        #declare Pt = PA_Bezier_Spline_Uniform (PA_Shooting_Star, Ct/Count);
                        superellipsoid {
                                <1,0.2>
                                rotate x*90
                                scale <0.2,1,0.2>
                                translate <Pt.x,0,Pt.y>
                        }
                        #declare Ct = Ct+1;
                #end
        }
        scale 0.12
        rotate <-90,0,-43>
        translate <-2.4,1.95,3.9>
}