
//Array scale
//V - scale vector (or float)
#macro a_scale (Array,V) 

#local C = dimension_size (Array,1);
#local NewArray = array[C]
#while (C > 0)
        #local NewArray[C-1] = Array[C-1]*(V+<0,0,0>);
        #local C = C-1;
#end
NewArray 

#end

//return 1 with the likelyhood of P (from 0 to 1, constant distribution)
//otherwise return 0
#macro Chance (P,Seed)

#local R = abs (rand (Seed)-0.5)*2;
(#if (R >= (1-P)) 1 #else 0 #end)

#end

//Create random number of given mean and maximum deviation
//M - mean value
//D - maximum deviation
//Seed - (declared) random number seed identifier
#macro rand_ext (M,D,Seed)

(M+(rand (Seed)-0.5)*2*D)

#end

//Give a random vector of given mean and max deviation
//M - mean (vector/float)
//D - max deviation (vector/float)
//Seed - (declared) random number seed identifier
#macro v_rand_ext (M,D,Seed)

#local MV = M+<0,0,0>;
#local DV = D+<0,0,0>;
(<rand_ext (MV.x,DV.x,Seed),rand_ext (MV.y,DV.y,Seed),rand_ext (MV.z,DV.z,Seed)>)

#end

//John VanSickle's reorient macro
#macro Reorient (Axis1,Axis2)

 #local vX1 = vnormalize (Axis1);
 #local vX2 = vnormalize (Axis2);
 #local vY = vnormalize (vcross (vX1,vX2));
 #local vZ1 = vnormalize (vcross (vX1,vY));
 #local vZ2 = vnormalize (vcross (vX2,vY));
 matrix <vX1.x,vY.x,vZ1.x,vX1.y,vY.y,vZ1.y,vX1.z,vY.z,vZ1.z,0,0,0>
 matrix <vX2.x,vX2.y,vX2.z,vY.x,vY.y,vY.z,vZ2.x,vZ2.y,vZ2.z,0,0,0>

#end

#declare Seed = seed (3232);

#declare MagnetBracket =
difference {
        difference {
                sphere {0,1}
                box {-1,1-x}
                box {-1,1-y}
        }
        cylinder {z,-z,1 scale <0.7,1,1>}
        scale <-1,1,0.2>
        translate <0.75,0,0>
}

#declare Bolt =
prism {
        #declare C = 0;
        #declare N = 6;
        linear_sweep //linear_sweep
        0,1,N,
        #while (C < N)
                #declare PrismP = vrotate (x,C*(360/N)*y);
                <PrismP.x,PrismP.z>
                #declare C = C+1;
        #end
}

#declare ShooterBody =
union {
        #declare Rmaj = 1.6;
        #declare Rmin = 1.3;
        #declare SRad = 1.3;
        #declare Dist = sqrt (pow (SRad+Rmin,2)-pow (Rmaj,2));
        #declare Angle = acos (1/(SRad+Rmin)*Dist);
        #declare CRad = sin (Angle)*SRad;
        sphere {0,SRad}
        torus {
                Rmaj,Rmin
                rotate z*90
                translate x*Dist
                clipped_by {cylinder {0,x*Dist,CRad}}
        }
        torus {
                0.5,0.2
                rotate z*90
                clipped_by {cylinder {0,x*0.3,0.4}}
                translate x*Dist
        }
        scale <1,0.75,0.75>
}

#declare WS_Normal = <0,0,0>;
#declare WireStart = trace(ShooterBody,0,<1,1,-1>,WS_Normal);
#declare WireEnd = x*(Dist+0.3)+vrotate (y*0.5,-x*40);

//Shooter magnet

#declare ShooterMagnet =
union {
        isosurface {
                function {f_helix1 (x,y,z,2,20,0.015,0.385,1,1,0)}
                contained_by {box {<-0.4,0,-0.4>,<0.4,1,0.4>}}
                rotate -z*90
        }
        torus {0.4,0.03 rotate z*90 translate x}
        torus {0.4,0.03 rotate z*90}
        #declare C = 0;
        #declare N = 2;
        #while (C < N)
                cylinder {y*0.4,x+y*0.4,0.02 rotate (C*(360/N)+90)*x}
                #declare C = C+1;
        #end
        #declare C = 0;
        #declare N = 5;
        #while (C < N)
                cone {y*0.4,0.03,y*0.6+x*0.3,0 rotate C*(360/N)*x translate x}
                #declare C = C+1;
        #end
        translate x*(Dist+0.3)
}    

//Shooter fixtures

#declare ShooterFixture =
union {
        #declare SphTorTouch = sin (Angle)*SRad;
        #declare C = 0;
        #declare N = 3;
        #while (C < N)
                object {
                        MagnetBracket
                        rotate -z*90
                        scale <(Dist+0.3)-SphTorTouch,(CRad-0.4)*3/4,0.5>
                        translate -x*(Rmaj-0.1)+y*CRad*3/4
                        rotate C*(360/N)*x
                }
                #declare C = C+1;
        #end
        #declare C = 0;
        #declare N = 3;
        #while (C<N)
                cylinder {-0.03*z,0.03*z,0.07 translate y*0.4 rotate C*(360/N)*x}
                #declare C = C+1;
        #end
        superellipsoid{
                <1,0.3>
                rotate y*90
                scale <0.1,CRad*3/4+0.08,CRad*3/4+0.08>
                translate -x*(Rmaj-0.24)
        }
        #declare C = 0;
        #declare N = 10;
        union {
                #while (C < N)
                        union {
                                object {Bolt scale -0.05}
                                cylinder {0,y*0.025,0.03}
                                translate y*(CRad*3/4+0.12)
                                rotate C*(360/N)*x
                        }
                        #declare C = C+1;
                #end
                translate -x*(Rmaj-0.24)
        } 
        object {Bolt scale <0.1,0.1,0.1> translate y*0.4 rotate x*40}
        object {Bolt scale <0.1,0.1,0.1> translate y*0.4 rotate -x*40}
        superellipsoid {
                <1,0.1> rotate x*90 scale <SRad+0.04,0.1,SRad*3/4+0.04>
                clipped_by {cylinder {0,x*2,CRad*0.75 inverse}}
                translate -x*(Dist+0.3)
        }
        #declare C = 0;
        #declare N = 8;
        union {
                #while (C < N)
                        #declare B_Normal = <0,0,0>;
                        #declare Point = trace(ShooterBody,0,vrotate(x,C*(360/N)*y),B_Normal);
                        object {
                                Bolt
                                scale -0.07
                                Reorient (y,B_Normal)
                                translate Point+B_Normal*0.08
                        }
                        #declare C = C+1;
                #end
                translate -x*(Dist+0.3)
        }
        translate x*(Dist+0.3)
}
//Shooter wires
#declare WirePath =
spline {
        quadratic_spline
        0.0,  WireStart,
        0.1,  WireStart+WS_Normal*0.25,
        0.3,  WireStart+<0.45,0.35,-0.5>,
        0.45, (WireEnd-WireStart)/2+WireStart+<-0.1,0.4,-0.7>,
        0.7,  (WireEnd-WireStart)/2+WireStart+<0.55,0,-0.3>,
        0.9,  WireEnd+vrotate(y,-x*40)*0.1,
        1.0,  WireEnd
}
#declare WireHolder =
union {
        superellipsoid {<1,0.1> scale <0.2,0.2,0.2> rotate x*90}
        #declare C = 0;
        #declare N = 6;
        #while (C < N)
                union {
                        object {Bolt scale -0.05}
                        cylinder {0,y*0.025,0.03}
                        translate x*0.14+y*0.24
                        rotate C*(360/N)*y
                }
                #declare C = C+1;
        #end
}
#declare ShooterWires =
union {
        object {WireHolder Reorient (y,WS_Normal) translate WireStart}
        object {WireHolder Reorient (y,WS_Normal*<1,1,-1>) translate WireStart*<1,1,-1>}
        blob {
                threshold 0.5
                #declare C = 0;
                #declare N = 1/100;
                #while (C < 1)
                        sphere {WirePath (C),0.07,1}
                        #declare C = C+N;
                #end
        }
        blob {
                threshold 0.5
                #declare C = 0;
                #declare N = 1/100;
                #while (C < 1)
                        sphere {WirePath (C)*<1,1,-1>,.07,1}
                        #declare C = C+N;
                #end
        }
}
//Shooter lamp
#declare ShooterLamp =
union {
        superellipsoid {
                <1,0.1>
                rotate x*90 scale <0.28,0.1,0.28> translate y
        }
        //difference {
                union {
                        cone {0,0.23,y*0.4,0.2}
                        sphere {0,0.2 scale <1,0.3,1> translate y*0.4}
                        translate y*1.1
                }
                /*union {
                        cone {0,0.23,y*0.4,0.2}
                        sphere {0,0.2 scale <1,0.3,1> translate y*0.4}
                        scale 0.95
                        translate -y*0.01
                }
                translate y*1.1*/
        //}
        cone {
                0,0.23,y*0.4,0.2
                clipped_by {box {<-0.25,0,0>,<0.25,0.38,0.25>}}
                scale <0.93,0.93,0.8> 
                rotate -y*70 
                translate y*1.1
        }
        //sphere {0,0.1 translate y*1.2 hollow}
        //light_source {y*1.2 rgb 9 fade_distance 0.35 fade_power 3}
        //hollow
}
//Shooter chassis
#declare RearAxis = <-1.05,-0.3,1.1>;
#declare FrontAxis = <0.75,-0.65,0.9>;

#declare ShooterChassis =
union {
        cylinder {RearAxis-z*0.15,(RearAxis-z*0.15)*<1,1,-1>,0.2}
        union {                                            
                cylinder {RearAxis-z*0.1,(RearAxis-z*0.1)*<1,1,-1>,0.17}
                cone {RearAxis-z*0.1,0.17,RearAxis,0.1}
                cone {(RearAxis-z*0.1)*<1,1,-1>,0.17,RearAxis*<1,1,-1>,0.1}
        }    
        cylinder{FrontAxis-z*0.15,(FrontAxis-z*0.15)*<1,1,-1>,0.17}
        union {
                cylinder {FrontAxis-z*0.1,(FrontAxis-z*0.1)*<1,1,-1>,0.14}
                cone {FrontAxis-z*0.1,0.14,FrontAxis,0.1}
                cone {(FrontAxis-z*0.1)*<1,1,-1>,0.14,FrontAxis*<1,1,-1>,0.1}
        }
        superellipsoid {
                <1,0.1> rotate x*90 scale <SRad+0.05,0.2,SRad*0.75+0.05>
                clipped_by {union {cylinder {0,x*2,CRad*0.75+0.05} box{<-1.4,-1.3,-1.3>,<1.3,1.3,0.1>} inverse}}
                rotate x*90
        }
}
//Shooter back shield
#declare ShooterShield =
intersection {
        difference {
                sphere {0,SRad+0.01 scale <1,0.75,0.75>}
                //sphere {0,SRad scale <1,0.75,0.75>}
                plane {x,SphTorTouch+0.2 inverse}
                plane {y,0}
        }
        cylinder {0,2*y,1 scale <SRad+0.2,1,0.9> translate x*(SphTorTouch+0.2)}
}

//Shooter legs

#declare FLeg1Rmin1=0.2;
#declare FLeg1Rmin2=0.1;
#declare FLeg1Rmaj1=0.6;
#declare FLeg1Rmaj2=0.3;
#declare FLeg1Beam=0.065;
#declare FLeg1Thickness=0.05;

#declare FLeg2Rmin=0.12;
#declare FLeg2Rmaj1=1.2;
#declare FLeg2Rmaj2=0.5;
#declare FLeg2Spike=0.4;
#declare FLeg2Thickness=0.15;

#declare FLegHydrDist=0.2;
#declare FLegHydrRad=0.04;
#declare FLegHydrAngle=120;

#declare RLeg1Rmin1=0.3;
#declare RLeg1Rmin2=0.1;
#declare RLeg1Rmaj1=0.7;
#declare RLeg1Rmaj2=0.5;
#declare RLeg1Beam=0.08;
#declare RLeg1Thickness=0.05;

#declare RLeg2Rmin=0.15;
#declare RLeg2Rmaj1=2.3;
#declare RLeg2Rmaj2=1.2;
#declare RLeg2Spike=0.8;
#declare RLeg2Thickness=0.15;

#declare RLegHydrDist=0.2;
#declare RLegHydrRad=0.04;
#declare RLegHydrAngle=120;

#declare FrontPivot = <FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>;
#declare RearPivot = <-RLeg1Rmaj1-RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>;

#declare FLeg1Hydr =
intersection {
        torus {FLegHydrDist,FLegHydrRad rotate x*90}
        plane {y,0}
        plane {-y,0 rotate z*FLegHydrAngle}
        scale <1,1,0.8>
        translate z*0.02
        rotate -80*z
}
#declare FLeg2Hydr=
intersection {
        torus {FLegHydrDist,FLegHydrRad-0.02 rotate x*90}
        plane {y,0}
        plane {-y,0 rotate z*FLegHydrAngle}
        scale <1,1,0.8>
        translate z*0.02
        rotate -80*z
}
#declare RLeg1Hydr=
intersection {
        torus {RLegHydrDist,RLegHydrRad rotate x*90}
        plane {y,0}
        plane {-y,0 rotate z*RLegHydrAngle}
        scale <1,1,0.8>
        translate z*0.02
        rotate -80*z
}
#declare RLeg2Hydr=
intersection {
        torus {RLegHydrDist,RLegHydrRad-0.02 rotate x*90}
        plane {y,0}
        plane {-y,0 rotate z*RLegHydrAngle}
        scale <1,1,0.8>
        translate z*0.02
        rotate -60*z
}

#declare FLeg1=
union {
        difference {
                cylinder {0,z*0.1,FLeg1Rmin1}
                cone {z*0.1,FLeg1Rmin1-0.03,z*0.07,FLeg1Rmin1-0.05 translate z*0.001}
        }
        object {Bolt scale 0.08 rotate x*90 translate z*0.07}
        intersection {
                difference {
                        cylinder {0,z*FLeg1Thickness,1 scale <FLeg1Rmaj1+FLeg1Rmin1*2,FLeg1Rmaj2+FLeg1Rmin2*2,1>}
                        cylinder {-z,z,1 scale <FLeg1Rmaj1,FLeg1Rmaj2,1>}
                        difference {
                                cylinder{-z*.5,z*.5,1 scale <FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam,FLeg1Rmaj2+FLeg1Rmin2*2-FLeg1Beam,1>}
                                cylinder{-z,z,1 scale <FLeg1Rmaj1+FLeg1Beam,FLeg1Rmaj2+FLeg1Beam,1>}
                        }
                        union {
                                torus {FLeg1Rmaj1+FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Beam/2)>}
                                torus {FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Rmin1-FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Rmin2-FLeg1Beam/2)>}
                                rotate x*90
                                scale <1,1,.7>
                                translate z*FLeg1Thickness
                        }
                        union {
                                torus {FLeg1Rmaj1+FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Beam/2)>}
                                torus {FLeg1Rmaj1+FLeg1Rmin1*2-FLeg1Beam/2,FLeg1Beam/2 scale <1,1,1/(FLeg1Rmaj1+FLeg1Rmin1-FLeg1Beam/2)*(FLeg1Rmaj2+FLeg1Rmin2-FLeg1Beam/2)>}
                                rotate x*90
                                scale <1,1,0.7>
                        }
                }
                box {<-FLeg1Rmaj1-FLeg1Rmin1*2,0,-1>,<0,-FLeg1Rmaj2-FLeg1Rmin2*2,1>}
                translate x*(FLeg1Rmaj1+FLeg1Rmin1)
        }
        cylinder {0,z*.1,FLeg1Rmin2 translate <FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>}
        object {FLeg1Hydr translate <FLeg1Rmaj1+FLeg1Rmin1,-FLeg1Rmaj2-FLeg1Rmin2,0>}
}

#declare FLeg2 =
union {
        union {
                difference {
                        union {
                                cylinder{-z*0.1,0,FLeg1Rmin2+0.03}
                                cylinder{z*0.1,z*0.14,FLeg1Rmin2+0.03}
                        }
                        cone {z*0.14,FLeg1Rmin2,z*0.11,FLeg1Rmin2-0.02 translate z*0.001}
                        cone {0,FLeg1Rmin2,z*0.03,FLeg1Rmin2-0.02 translate -z*0.001}
                }
                object {Bolt rotate x*90 scale <0.06,0.06,0.4> translate -z*0.25}
                translate -z*0.02
        }
        union {
                intersection {
                        difference {
                                sphere {0,1 scale <FLeg2Rmaj1,FLeg2Rmaj2+FLeg2Rmin*2,FLeg2Thickness>}
                                cylinder {-z,z,1 scale <FLeg2Rmaj1,FLeg2Rmaj2,1>}
                                torus {FLeg2Rmaj2,FLeg2Rmin rotate x*90 scale <FLeg2Rmaj1/FLeg2Rmaj2,1,1/FLeg2Rmin*FLeg2Thickness> translate -z*FLeg2Thickness}
                                torus {FLeg2Rmaj2,FLeg2Rmin rotate x*90 scale <FLeg2Rmaj1/FLeg2Rmaj2,1,1/FLeg2Rmin*FLeg2Thickness> translate z*FLeg2Thickness}
                        }
                        box {<0,0,-1>,<FLeg2Rmaj1,FLeg2Rmaj2+FLeg2Rmin*2,1>}
                }
                difference {
                        cylinder {0,-x*FLeg2Spike,1 scale <1,FLeg2Rmaj2+FLeg2Rmin*2,FLeg2Thickness>}
                        cylinder {-z,z,1 scale <FLeg2Spike,FLeg2Rmin*2,1> translate <-FLeg2Spike,FLeg2Rmaj2,0>}
                        box {<-1,-2,-1>,<1,FLeg2Rmaj2,1>}
                }
                object {FLeg2Hydr translate y*FLeg2Rmaj2-z*0.02}
                translate -y*FLeg2Rmaj2+z*0.02
        }
}

#declare RLeg1=
union {
        difference {
                cylinder{0,z*.1,RLeg1Rmin1}
                cone {z*0.1,RLeg1Rmin1-0.03,z*0.07,RLeg1Rmin1-0.05 translate z*0.001}
        }
        object {Bolt scale 0.08 rotate x*90 translate z*0.07}
        intersection {
                difference {
                        cylinder {0,z*RLeg1Thickness,1 scale <RLeg1Rmaj1+RLeg1Rmin1*2,RLeg1Rmaj2+RLeg1Rmin2*2,1>}
                        cylinder {-z,z,1 scale <RLeg1Rmaj1,RLeg1Rmaj2,1>}
                        difference {
                                cylinder {-z*0.5,z*.5,1 scale <RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam,RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam,1>}
                                cylinder {-z,z,1 scale <RLeg1Rmaj1+RLeg1Beam,RLeg1Rmaj2+RLeg1Beam,1>}
                        }
                        union {
                                torus {RLeg1Rmaj1+RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Beam/2)>}
                                torus {RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam/2)>}
                                rotate x*90
                                scale <1,1,0.4>
                                translate z*RLeg1Thickness
                        }
                        union {
                                torus {RLeg1Rmaj1+RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Beam/2)>}
                                torus {RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2,RLeg1Beam/2 scale <1,1,1/(RLeg1Rmaj1+RLeg1Rmin1*2-RLeg1Beam/2)*(RLeg1Rmaj2+RLeg1Rmin2*2-RLeg1Beam/2)>}
                                rotate x*90
                                scale <1,1,0.4>
                        }
                }
                box {<-RLeg1Rmaj1-RLeg1Rmin1*2,0,-1>,<0,-RLeg1Rmaj2-RLeg1Rmin2*2,1>}
                translate x*(RLeg1Rmaj1+RLeg1Rmin1)
        }
        cylinder {0,z*0.1,RLeg1Rmin2 translate <RLeg1Rmaj1+RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>}
        object {RLeg1Hydr translate <RLeg1Rmaj1+RLeg1Rmin1,-RLeg1Rmaj2-RLeg1Rmin2,0>}
        scale <-1,1,1>
}

#declare RLeg2 =
union {
    union {
        difference {
            union {
                cylinder {-z*0.04,0,RLeg1Rmin2+0.03}
                cylinder {z*0.1,z*0.14,RLeg1Rmin2+0.03}
            }
            cone {z*.14,RLeg1Rmin2,z*0.11,RLeg1Rmin2-0.02 translate z*0.001}
            cone {0,RLeg1Rmin2,z*0.03,RLeg1Rmin2-0.02 translate -z*0.001}
        }
        object {Bolt rotate x*90 scale <0.06,0.06,0.24> translate -z*0.08}
        translate -z*0.02
    }
    union {
        intersection {
            difference {
                sphere {0,1 scale <RLeg2Rmaj1,RLeg2Rmaj2+RLeg2Rmin*2,RLeg2Thickness>}
                cylinder {-z,z,1 scale <RLeg2Rmaj1,RLeg2Rmaj2,1>}
                torus {RLeg2Rmaj2,RLeg2Rmin rotate x*90 scale <RLeg2Rmaj1/RLeg2Rmaj2,1,1/RLeg2Rmin*RLeg2Thickness> translate -z*RLeg2Thickness}
                torus {RLeg2Rmaj2,RLeg2Rmin rotate x*90 scale <RLeg2Rmaj1/RLeg2Rmaj2,1,1/RLeg2Rmin*RLeg2Thickness> translate z*RLeg2Thickness}
            }
            box {<0,0,-1>,<RLeg2Rmaj1,RLeg2Rmaj2+RLeg2Rmin*2,1>}
        }
        difference{
            cylinder {0,-x*RLeg2Spike,1 scale <1,RLeg2Rmaj2+RLeg2Rmin*2,RLeg2Thickness>}
            cylinder {-z,z,1 scale <RLeg2Spike,RLeg2Rmin*2,1> translate <-RLeg2Spike,RLeg2Rmaj2,0>}
            box {<-1,-2,-1>,<1,RLeg2Rmaj2,1>}
        }
        object {RLeg2Hydr translate y*RLeg2Rmaj2-z*0.02}
        scale <-1,1,1>
        translate -y*RLeg2Rmaj2+z*0.02
    }
}

//Assemble the Shooter's body parts

#declare ShooterStatic =
union {
        object {ShooterBody}
        object {ShooterMagnet}
        object {ShooterFixture}
        object {ShooterWires}
        object {ShooterLamp}
        object {ShooterChassis}
        object {ShooterShield}
}

//Macro to create Shooter with legs positioned

#macro Shooter (RRLegA1,RRLegA2,LRLegA1,LRLegA2,RFLegA1,RFLegA2,LFLegA1,LFLegA2)

union {
        object {ShooterStatic}
        object {RLeg1 rotate RRLegA1*z translate RearAxis scale <1,1,-1>}
        object {RLeg2 rotate (RRLegA1+RRLegA2)*z translate RearAxis+vrotate(RearPivot,RRLegA1*z) scale <1,1,-1>}
        object {RLeg1 rotate LRLegA1*z translate RearAxis}
        object {RLeg2 rotate (LRLegA1+LRLegA2)*z translate RearAxis+vrotate(RearPivot,LRLegA1*z)}
        object {FLeg1 rotate -RFLegA1*z translate FrontAxis scale <1,1,-1>}
        object {FLeg2 rotate -(RFLegA1+RFLegA2)*z translate FrontAxis+vrotate(FrontPivot,-RFLegA1*z) scale <1,1,-1>}
        object {FLeg1 rotate -LFLegA1*z translate FrontAxis}
        object {FLeg2 rotate -(LFLegA1+LFLegA2)*z translate FrontAxis+vrotate(FrontPivot,-LFLegA1*z)}
}

#end    

#declare EmitterPos =
transform {
        rotate z*10
        translate 1.8*y
        scale 0.2
        translate <-0.5,0,-2>
}

#declare MagneticField =
cylinder {0,x*(Dist+0.9),0.3*3/4 open transform EmitterPos}

object {Shooter (-50,58,-90,120,0,50,0,50) transform EmitterPos}