// ***********************************************************
// Persistence Of Vision Ray Tracer Include File
// File name  : proceduralize.inc
// Version    : 3.6.1 (should work on versions >3.5)
// Description: Macro to "proceduralize" image_maps
// Date       : Apr. 2005
// Author     : Jaime Vives Piqueres
// ***********************************************************

#macro Proceduralize(
  img_name,		// image file name (jpeg only)
  img_mapping,          // mapping type
  img_f,img_t,		// filter and transmit amount
  img_f1,img_f2,        // two finishes to blend
  img_bs1,img_bs2,     	// bump_maps sizes
  img_sc,		// scale
  img_tsp,img_tsw,	// textures separation point and width
  img_turb,img_turb_l,  // turbulence amount and lambda
  t_under		// underliying texture
 )

 #local img_turb=img_turb+<0,0,0>;
 #local p_img=
 pigment{
  image_map{
   jpeg img_name 
   #if (img_f>0)
    filter all img_f 
   #end
   #if (img_t>0)
    transmit all img_t
   #end
   map_type img_mapping
  }
 } 
 #local n_img=
 normal{
  bump_map{
   jpeg img_name
   map_type img_mapping
  }
 }
 #local t1=
 texture{
  pigment{p_img}
  finish{img_f1 conserve_energy}
  normal{n_img img_bs1}
 }
 #local t2=
 texture{
  pigment{p_img}
  finish{img_f2 conserve_energy}
  normal{n_img img_bs2}
 }
 #if ((img_f+img_t)>0)
  #local t1= 
  texture{t_under}
  texture{t1}
  #local t2= 
  texture{t_under}
  texture{t2}
 #end
 #local f_img=
 function{
  pigment{p_img}
 }
 #local t_result=
 texture{
  function{f_img(x,y,z).gray}
  texture_map{
   [0.0 t1]
   #if (img_tsp>0)
   [img_tsp t1]
   [img_tsp+img_tsw t2]
   #end
   [1.0 t2]
  }
  #if ((img_turb.x+img_turb.y+img_turb.z)>0)
  warp{
   turbulence img_turb 
   lambda img_turb_l
  }
  #end
  translate -.5
  scale img_sc
 }
 #local dummy=0; // so POV doesn't takes the following as another layer... :)

 t_result

#end
