// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   IsoWood Include File version 0.3                            %
// %                                                               %
// %   iw_ex_02.pov - Sample File                                  %
// %                                                               %
// %   originally written August 2000 - November 2000              %
// %   for use with IsoWood 0.2 and megapov 0.6                    %
// %   by Christoph Hormann <chris_hormann@gmx.de>                 %
// %   newest version can be found at                              %
// %   http://www.tu-bs.de/~y0013390/iso_wood.html                 %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#debug "including plank\n"

#include "isowood3.inc"
#include "iw_textures.inc"

#macro IW_Plank_Round_CutN_ (Seed, xSize, ySize, zSize, Rotate, Translate, Round, Strength, Strength2, Pigm, Fin, Norm, C_Map, WarpNbr, fn_Disp, fn_Max_Val)

#local rd=seed(Seed);

#local fn_Max=fn_Max_Val+<0,0,0>;

#local Trsx = (rand(rd)-0.5)*Translate*xSize;
#local Trsy = (rand(rd)-0.5)*Translate*ySize;
#local Trsz = (rand(rd)-0.5)*Translate*zSize;
#local Rotx = (rand(rd)-0.5)*Rotate;
#local Roty = (rand(rd)-0.5)*Rotate;

#local fn_Wood =
  function {
    pigment {
      Pigm
      color_map {
        [ 0.000  color rgb 0.0 ]
        [ 1.000  color rgb 1.0 ]
      }
      translate <Trsx, Trsy, Trsz>
      rotate Rotx*x
      rotate Roty*y

      IW_Select_Warp (WarpNbr, Seed, xSize, ySize, zSize)
    }
  }

#local fnShape =function{ f_rounded_box(x, y, z, Round,xSize*0.5,ySize*0.5,zSize*0.5+Round)}
#local fnShape2=function{ (abs(z)-zSize*0.5) }

#local fnShapeT =function{ fnShape (x+fn_Disp(x, y, z).red,y+fn_Disp(x, y, z).green,z+fn_Disp(x, y, z).blue) }
#local fnShape2T=function{ fnShape2(x+fn_Disp(x, y, z).red,y+fn_Disp(x, y, z).green,z+fn_Disp(x, y, z).blue) }
#local fnBumpsT =function{ fn_Wood (x+fn_Disp(x, y, z).red,y+fn_Disp(x, y, z).green,z+fn_Disp(x, y, z).blue).grey }

isosurface{
  function {
    max(
      fnShapeT(x,y,z)+fnBumpsT(x,y,z)*Strength,
      fnShape2T(x,y,z)+fnBumpsT(x,y,z)*Strength2
    )
  }
  contained_by{
     box{ <-xSize*0.5-fn_Max.x,-ySize*0.5-fn_Max.y,-zSize*0.5-fn_Max.z>,
          < xSize*0.5+fn_Max.x, ySize*0.5+fn_Max.y, zSize*0.5+fn_Max.z> }
  }

  accuracy IW_ISOaccuracy
  max_gradient IW_ISOmaxgrad

  translate <xSize*0.5, ySize*0.5, zSize*0.5>
}

#end  //------------------------------------------------------------------------------------

#declare IW_Quality = 2;
#declare IW_ISOmaxgrad = 2;

object {
        IW_Plank_Round_CutN_ (
                17, 0.3, 3.6, 8, 2, 0, 0.018, 0.0035, 0.005,
                pigment { P_IW_10 scale 1.6 } , Fin_W_02 , No_Normal, CM_IW_02, 2
                function {
                        pigment {
                                average
                                pigment_map {
                                        [1 function { f_noise3d(0, 0, z*1.6)*0.3 } color_map{[0 rgb 0][1 rgb x]}]
                                        [1 function { f_noise3d(0, 0, -z*1.6)*0.3 } color_map{[0 rgb 0][1 rgb y]}]
                                }
                        }
                },
        0.3
        )
        scale 0.5
        rotate <90,0,90>
        rotate <0,90,0>
        translate <-3.2,0.05,1>
}

