#macro Blob (Threshold,Radius,Alpha)
        #local Strength_Temp = (Alpha+1)*Threshold;
        #local Radius_Temp = Radius/sqrt(1-sqrt(1/(Alpha+1)));
        Radius_Temp
        //strength Strength_Temp
#end  
/*
#include "dissolution.inc"

#declare Environment =
union {
        object {bot}
        intersection {
                height_field {
                        png "strands06.png"  
                        smooth
                        translate <-0.5,0,-0.5>
                        scale <20,1,20>
                        rotate y*-90   
                } 
                box {<-8,-0.01,-9.99>,<9.99,1.01,9.99>}
                rotate y*90
                scale <0.4,0.07,0.4>
                translate <0,-0.001,0.7>
        }
}
*/
#declare Time = 5*0.5;  

#declare Particle_Count = 15000;// Try also 2000 to see the difference: if Particle_Count < Particles_per_Iter*Iterations then your flow will stop before the end of the simulation  
#declare Particles_per_Iter = 50;
#declare Iterations = Particle_Count/Particles_per_Iter;
#declare Elasticity = 0.35*0.25; 
#declare Acceleration = <0,-9.81,0>; 
#declare Particle_Radius = 0.023*0.36*0.35;   
#declare RS = seed (0);
#declare Random_Pos = 0.05*0.01; // max random amount added to position
#declare Friction = 0.98*0.7;   // 1= no friction
#declare dt = Time/Iterations;   

 
#declare File_Option = 2; // -0 do not save; -1 save file; -2 load file 


#declare File_Name = "par_tut_arr.inc"
#declare Particles_Array = array [Particle_Count][2]

#if (File_Option !=2)
        #declare EmitterPos =
        transform {
                rotate z*10
                translate 1.8*y
                scale 0.2
                translate <-0.5,0,-2>
        }
        #macro Start_Point ()  // this macro defines the starting position. Must return a vector.
                vtransform(vtransform(0.8*0*x*rand(RS),transform {rotate 360*rand(RS)*z}),transform {EmitterPos})                             //erster Term bestimmt Anfangsstreubreite
        #end 

        #macro Start_Vel ()  // this macro defines the starting velocity. Must return a vector.
                vtransform(vtransform ((15+1-5*rand(RS))*x,transform {rotate 0.5*10*rand(RS)*z}),transform {rotate 360*rand(RS)*x})+y*3.2        //zweiter Term bestimmt Streubreite insgesamt
        #end  

        #macro Update_Particle (Particle)
                #declare Particles_Array [Particle][0] = Particles_Array [Particle][0]+Particles_Array [Particle][1]*dt+0.5*Acceleration*dt*dt+<-Random_Pos+2*Random_Pos*rand(RS),-Random_Pos+2*Random_Pos*rand(RS),-Random_Pos+2*Random_Pos*rand(RS)>;
                #declare Particles_Array [Particle][1] = Particles_Array [Particle][1]+Acceleration*dt;
        #end

        #macro Rebound (Particle,Normal)
                #declare Particles_Array [Particle][1] = (Particles_Array [Particle][1]-vdot (Particles_Array [Particle][1],vnormalize (Normal))*vnormalize (Normal)*(1+Elasticity/Friction))*Friction;
        #end
          
//-----main loop

        #declare Present_Iteration = 1;
        #while (Present_Iteration <= Iterations)        
                #declare Present_Particle = 0;
                #while (Present_Particle < Particles_per_Iter*Present_Iteration & Present_Particle < Particle_Count)        
//---- create new particle        
                        #ifndef (Particles_Array [Present_Particle][0])
                                #declare Particles_Array [Present_Particle][0] = Start_Point ();
                                #declare Particles_Array [Present_Particle][1] = Start_Vel ();        
                        #else        
                                #declare Old_Position = Particles_Array [Present_Particle][0];
                                Update_Particle (Present_Particle)        
//---- check for collisions        
                                #declare Normal = <0,0,0>;
                                #declare Vel_Dir = Particles_Array [Present_Particle][0]-Old_Position; 
                                #if (vlength(trace (Environment,Old_Position,Vel_Dir,Normal)-Old_Position)-vlength (Vel_Dir) < Particle_Radius)
                                        #declare Particles_Array [Present_Particle][0] = Particles_Array [Present_Particle][0]-(Particle_Radius-(vlength (trace (Environment,Old_Position,Vel_Dir,Normal)-Old_Position)-vlength (Vel_Dir)))*vnormalize (Vel_Dir);
                                        #if (vdot (Vel_Dir,Normal) < 0)
                                                Rebound (Present_Particle, Normal)
                                        #end
                                #end
                        #end
                        #declare Present_Particle = Present_Particle+1;
                #end           
                #debug concat ("Iterations: ", str (Present_Iteration,0,0), ". Going to ", str (Iterations,0,0), ".\n")
                #declare Present_Iteration = Present_Iteration +1;
        #end           
        #if (File_Option = 1 )
                #fopen arr_file File_Name write  
                #write (arr_file,"//------Particles Data------\n") 
                #local i = 0;
                #while (i < Particle_Count)
                        #ifdef (Particles_Array[i][0])
                                #write (arr_file, "#declare Particles_Array[",i,"][0] = ",Particles_Array[i][0],";\n") 
                        #end
                        #local i = i+1;
                #end
                #fclose arr_file
        #end
#else
        #include File_Name
#end

#declare PA = array[6]{1.414*y,-x-z,x-z,x+z,z-x,-y*1.414}
//#declare PA = a_scale(PA,0.018)

#declare p1 = 0.5*Blob (0.5,Particle_Radius,0.5);

union {                                                                                                                             
        #declare j = 0;                                                       
        #while (j < Particle_Count)                                                                                                              
                #if ((Particles_Array[j][0].x < 4.16-1) & (Particles_Array[j][0].y < 3.6-1))
                        box {                             
                                -p1,p1
                                rotate <360*rand(RS),360*rand(RS),360*rand(RS)>
                                translate Particles_Array[j][0]                     
                        }
                #end
                #declare j = j+1;                                                     
        #end                                                                
}                                                                           
