//  +kfi0 +kff336

// Norbert Kern June 2014 - "300 materials collection"

#version 3.7;

global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        subsurface {}
        noise_generator 3
}

///////////////////////////////////////////////////////////////////////////////////// 

#declare mat = frame_number;

/////////////////////////////////////////////////////////////////////////////////////

#include "stdinc.inc"

#declare MainView = 0;
#declare BehindTheScenes = 1;

#declare CamType = BehindTheScenes;
#declare CamType = MainView;

#declare camloc = <0.05,1.05,-8>;
#declare lookat = <0,1,0>;
camera {
	right	x*image_width/image_height
	up	y
	#switch (CamType)
		#case (MainView)
			direction z*2.7 
                        location camloc 
                        look_at lookat
		#break;
		#case (BehindTheScenes)
			direction z*3.1 
                        location <-15,6,-10> 
                        look_at <-2.2,2,0> 
		#break;
	#end
}

#if (CamType != MainView)
	intersection {
		plane {y-z,0}
		plane {-y-z,0}
		plane {x-z*image_width/image_height,0}
		plane {-x-z*image_width/image_height,0}
		scale <1,1,2.7*16/9>*9/16 //zoom, scale factor on direction for MainView camera
		clipped_by {plane {z,12.2}}
                Reorient_Trans (<0,0,-8>,<0.05,0.05,-8>)
		translate <0.05,1.05,-8> //position of MainView Camera
		hollow on
		no_shadow
		no_reflection
		pigment {rgbt <0.4,0.7,1,0.8>}
	}
#end

/////////////////////////////////////////  scene setup  ////////////////////////////////////////////

#declare set_up =
union {  
        difference {                          // Tekno Frannansa  photo studio  http://news.povray.org/povray.binaries.scene-files/attachment/%3C453d41ff%241%40news.povray.org%3E/photo_studio.pov.txt 
        	box {<-0.52,-0.55,0.15>, <0.52,-1.01,1.01>}
        	superellipsoid {<0.1,0.1>}
        	translate <0,1,-0.5>
        	scale 8
        }
        union {                               // Jonathan Rafael Ghiglia  test with depth of field  http://news.povray.org/povray.binaries.images/message/%3C3b89f9f4%40news.povray.org%3E/#%3C3b89f9f4%40news.povray.org%3E
                #declare I = seed (0);
                #declare i = -9;
                #while (i <= 8)
                        #declare j = 38;
                        #while (j >= 32)
                                object {
                                        superellipsoid {
                                                <0.03,0.03> 
                                                rotate <0.5-rand(I),0.5-rand(I),0.5-rand(I)>*2.5 
                                                scale 0.5
                                        } 
                                        translate <i,-0.075+rand(I)*0.05,j>
                                }
                                #declare j = j-1;
                        #end
                        #declare i = i+1;
                #end
                rotate x*90
                scale 0.5
                translate <0.25,19.25,4.2>
        }
        julia_fractal {                       // Peter Hertel  
                <-0.5,-0.3,0.6,0>
                quaternion sqr
                max_iteration 8
                precision 100
                rotate <15,0,90>
                translate y*0.75
                translate <-2.35,0.6,2>
        }
        intersection {
                height_field {
                        jpeg "strands06"     // Samuel T. Benge  a texture generator for Windows: strands.exe  http://203.29.75.35/povray.binaries.utilities/thread/%3Cweb.4c8d4d9b76e12d9dc003acd0%40news.povray.org%3E/?ttop=373385
                        smooth
                        translate <-0.5,0,-0.5>
                        scale <20,1,20>
                        rotate y*-90   
                } 
                box {<-8,-0.01,-9.99>,<9.99,1.01,9.99>}
                rotate y*90
                scale <0.4,0.07,0.4>
                translate <0,-0.001,0.7>
        }        
        #include "dissolution.inc"              // Newt  Dissolution  http://www.povcomp.com/entries/128.php
        #include "plank.inc"                    // Christoph Hormann  IsoWood  http://www.imagico.de/iso_wood_en.php
        #include "submarine.inc"                // Fabien Mosen  fmworld  http://www.irtc.org/ftp/pub/stills/1999-02-28/fmworld.zip                           
        #include "Pipetree2.inc"                // Gilles Tran/Norbert Kern  Pipetrees  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.50405a41c23a6d9c0f4c71e0@news.povray.org%3E/
        #include "star.inc"                     // Blue Herring  Point Arrays  http://lib.povray.org/searchcollection/index2.php?objectName=PointArrays&version=1.0.0&contributorTag=Blue%20Herring
        #include "shooter2.inc"                 // Margus Ramst  Absurdities  http://news.povray.org/povray.binaries.scene-files/thread/%3C39A10353.9F08EA9E@peak.edu.ee%3E/?ttop=340204&toff=900
        #include "particles.inc"                // Jonathan Rafael Ghiglia  Basic Particle System Take 2  http://news.povray.org/povray.binaries.scene-files/message/%3C3c415a1d%40news.povray.org%3E/#%3C3c415a1d%40news.povray.org%3E
        #include "hand.inc"                     // Ponti Gio  Hand 3D Model  http://archive3d.net/?a=download&id=6ec53bd7
        #include "crystals.inc"                 // David Fontaine  Crystal generator source  http://news.povray.org/povray.binaries.scene-files/thread/%3C39B2D181.6A65121B%40faricy.net%3E/
        #include "blobtower.inc"                // Anders Sandberg  Blood Music  http://www.aleph.se/Nada/Ray/blood.pov
}

//////////////////////////////////////////  commonly used things  ///////////////////////////////////////
      
#macro Ga (Color)

<pow (Color.x,1/a_g),pow (Color.y,1/a_g),pow (Color.z,1/a_g)>

#end

#macro Gat (Color)

<pow (Color.x,1/a_g),pow (Color.y,1/a_g),pow (Color.z,1/a_g),Color.t> 

#end

// H - hue; circular spectrum running red-green-blue-red
// S - saturation, i.e. the amount of color in relation to gray
// L - lightness of the color

#macro hslft (H,S,L,F,T) 

// Construct rgb from hue
#if (H < 1/3) #local R = min (2-H*6,1); #end
#if (H > 2/3) #local R = min ((H-2/3)*6,1); #end
#if (H >= 1/3 & H <= 2/3) #local R = 0; #end
    
#if (H <= 1/3) #local G_ = min (H*6,1); #end
#if (H > 1/3 & H < 2/3) #local G_ = min (2-(H-1/3)*6,1); #end
#if (H >= 2/3) #local G_ = 0; #end
    
#if (H > 1/3 & H <= 2/3) #local B = min ((H-1/3)*6,1); #end
#if (H > 2/3) #local B = min (2-(H-2/3)*6,1); #end
#if (H <= 1/3) #local B = 0; #end

// Incorporate saturation and lightness
#local RGB = ((1-S)+S*<R,G_,B>)*L;
rgbft <RGB.x,RGB.y,RGB.z,F,T> 

#end

#macro hsl  (H,S,L)   hslft (H,S,L,0,0) #end
#macro hslf (H,S,L,F) hslft (H,S,L,F,0) #end
#macro hslt (H,S,L,T) hslft (H,S,L,0,T) #end

#declare radio  = 1;
#declare light  = 1;
#declare envir  = 1;
#declare matra  = 5;

//------------------------------------ the whole enchilada begins here ----------------------------------

#if (mat = 0)  /////////////////////////////////////////////////////////////////////////////////////

// basic texture for comparison

#declare T1 =   
material {
        texture {
                pigment {rgb 1}
                finish {ambient 0 diffuse 0.6}
        }
        interior {ior 1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 1)  /////////////////////////////////////////////////////////////////////////////////////

// mone  XRay Test  http://news.povray.org/povray.binaries.images/message/%3Cweb.4ad90cfb1466e24f18ebfdf70%40news.povray.org%3E/#%3Cweb.4ad90cfb1466e24f18ebfdf70%40news.povray.org%3E

#declare radio  = 0;
#declare light  = 0;
#declare envir  = 0;
#declare matra  = 256;

#declare T1 =   
material {
        texture {
                pigment {
                        aoi
                        color_map {
                                [0.1   rgb  0]
                                [0.3   rgbt <0.3,0.5,1,0.5>]
                                [0.5   rgbt 1]
                                [0.7   rgbt <0.3,0.5,1,0.5>]
                                [0.9   rgb  0]
                        }
                }
                finish {emission 1.2 diffuse 0}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 2) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  cuptexture  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062548551%40news.povray.org%3E/cuptexture.pov.txt?ttop=384820&toff=550

#declare T1 = 
material {
        texture {
                finish {diffuse 1*0.4 phong 0.2}
//              normal {bozo 2 rotate 60 scale 0.006 noise_generator 3}
                normal {
                        average 
                        normal_map {
                                [1,     bozo 0.5 
                                        rotate 60 
                                        scale 0.02 
                                        noise_generator 3 
                                        slope_map {
                                                [0,<5,-10>]
                                                [0.5,<0,0>]
                                        }
                                ]
                                [1,     bozo 4 
                                        rotate 60 
                                        scale 0.006 
                                        noise_generator 3
                                ]
                        }
                }
                pigment {rgb <0.5,0.7,1>} 
        }
        texture {
                finish {diffuse 0.5*0.4 phong 1.8 reflection {0.3,0.5}}
                normal {
                        average 
                        normal_map {
                                [1,     bozo 0.1 
                                        rotate 60 
                                        scale 0.03 
                                        noise_generator 3 
                                        slope_map {
                                                [0,<3,-8>]
                                                [1,<0,0>]
                                        }
                                ]
                                /*[1,     bozo 3.5 
                                        rotate 60 
                                        scale 1.5 
                                        noise_generator 3
                                ]*/
                        }
                } 
                pigment {rgbt <0.6,0.75,1,0.85>}
        }
        scale 0.8
        interior {ior 1.33}
}

#end  /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 3)  /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  12 Catenoids  http://www.irtc.org/ftp/pub/stills/2005-08-31/12_caten.zip

#declare N_Dented1 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.00 dents 1.5         scale 0.3]
                [0.5  dents 1           scale 0.15]
                [0.55 dents 0.125       scale 0.012]
                [0.6  dents 1.25        scale 0.15]
                [1.0  dents 1           scale 0.5]
        }             
}

#declare N_Dented2 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.0  dents 0.25        scale 1]
                [0.3  dents 1           scale 0.1]
                [0.35 dents 0.125       scale 0.01]
                [0.75 dents 1.25        scale 0.1]
                [1.0  dents 0.1         scale 1]
        }
        scale 0.75             
}

#declare N_Dented3 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.0 dents 0.125        scale 0.8]
                [0.3 dents 0.1          scale 0.12]
                [0.4 bumps 0.25         scale 0.1]
                [0.5 dents 0.125        scale 0.01]
                [1.0 dents 0.1          scale 1.2]
        }
        scale 0.5             
}

#declare N_Hammered = 
normal {  
        agate 
        turbulence 0.2
        normal_map {
                [0.00 N_Dented1]
                [0.33 N_Dented2]
                [0.66 N_Dented3]
                [1.00 N_Dented2]
        }
}
        
#declare T1 =
material {
        texture {
                normal {
                        average
                        normal_map {
                                [1.00 bumps   0.075 scale 0.75]
                                [1.00 granite 0.235 scale 4]
                                [0.50 granite 0.235 scale 1]
                                [0.50 granite 0.235 scale 0.3]
                                [0.50 granite 0.400 scale 0.1]
                                [0.25 granite 0.650 scale 0.01]
                        }
                        scale 0.5
                }
                pigment {rgb 1.25*0.7}
        }
        scale 0.15
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 4) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  finish maps  http://news.povray.org/povray.binaries.images/message/%3C3e6c9f39%40news.povray.org%3E/#%3C3e6c9f39%40news.povray.org%3E

#declare p_specular = pigment {image_map {jpeg "bumps2" map_type 0 interpolate 2}}

#declare f_imagemap =
function {
        pigment {
                wrinkles turbulence 0.3 lambda 3
                pigment_map {
                        [0  p_specular]
                        [1  p_specular rotate 90*y translate 1000]
                }
        }
}

#declare N_Sphere =
normal {
        average
        normal_map {
                [1 function {f_imagemap (x,y,z).x} 0.4]//bump_map {jpeg "bumps2" map_type 0 interpolate 2} bump_size 0.2*-5]
                [1 bumps 0.1 scale 0.01]
        }
}

#declare T1 =
material {
        texture {
                pigment_pattern {function {f_imagemap (x,y,z).x}}//image_pattern {jpeg "bumps2" map_type 0 interpolate 2}
                texture_map {
                        [0       pigment {rgb <0.1,0,0>}     normal {N_Sphere} finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.01}]
                        [0.1     pigment {rgb <0.15,0.07,0>} normal {N_Sphere} finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.01}]
                        [0.2     pigment {rgb 0.15}          normal {N_Sphere} finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.01}]
                        [0.6+0.4 pigment {rgb 0.5}           normal {N_Sphere} finish {ambient 0 diffuse 0.6 specular 1.0 roughness 0.03 reflection {0.3, 0.8}}]
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 5) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  Fire hydrant  http://www.oyonale.com/downloads/gt_fhydrant.zip

#declare Rouge = rgb <1,0.2,0.05>;
#declare sc = 1; // rgle le niveau de reflectivit
#declare Copper = Copper*0.8;

#declare txtCopper=
texture{
        pigment {
                crackle solid      
                turbulence 0.2
                color_map{
                        [0 Copper*1.8*5]
                        [1 Copper*1.3*5]
                }
        }
        finish {ambient 0 diffuse 0.8 metallic brilliance 8 specular 0.051 roughness 0.001
        reflection 0.1*sc
        }
} 

#declare txtCopper2 =
texture {
        txtCopper
        normal {crackle solid turbulence 0.2}
}
 
#declare txtCopper3 =
texture {
        txtCopper
        normal {wrinkles bump_size 0.2}
}
 
#declare pPaint0 =
pigment {
        crackle solid
        turbulence 0.1
        color_map{
                [0 Rouge*0.1]
                [1 Rouge*0.2]
        }
}
          
#declare pPaint1 =
pigment {
        crackle solid
        turbulence 0.1
        color_map {
                [0 Rouge*0.3]
                [1 Rouge*0.5]
        }
}
          
#declare pPaint2 =
pigment {
        crackle solid
        turbulence 0.1
        color_map{
                [0 Rouge*1.7]
                [1 Rouge*1.2]
        }
} 
                 
#declare txtPaintTop =
texture {
        pigment {
                gradient y
                pigment_map {
                        [0 pPaint1]
                        [1 pPaint2]
                }
        }
        finish {
                metallic 
                brilliance 6 
                ambient 0 
                diffuse 0.7 
                specular 0.1 
                roughness 0.01 
                reflection 0.1*sc
        }
}
                           
#declare txtTop_1_1 =
texture {
        pigment {
                gradient y
                turbulence 0.1
                poly_wave 0.3
                lambda 4           
                color_map {
                        [0 Copper*0.1]
                        [1 Copper*0.5]
                }
        }
        finish {
                ambient 0 
                diffuse 0.8 
                metallic 
                brilliance 4 
                specular 0.1 
                roughness 0.001
        }
}
 
#declare k = 0.02; // parameter controlling the penetration of the top paint layer : the smaller the more rusty
#declare turb = 0.008; 

#declare txtTop_1_2 =
texture {
        spherical
        turbulence turb
        lambda 3
        texture_map {
                [k*0.5 txtPaintTop]   // external layer
                [k*0.5 txtCopper]
                [k*1   txtCopper]
                [k*5   txtCopper3 scale 0.01] // internal layer
        }
}
                                                      
#declare txtTop_1_2a =
texture {
        spherical
        turbulence turb
        lambda 3
        texture_map {
                [k*0.7  txtPaintTop]   // external
                [k*0.7  txtCopper]
                [k*1    txtCopper]
//              [k*5    txtCopper3 scale 0.1] // internal
                [k*2    txtPaintTop] // internal
        }
}
                                                      
#declare txtTop_1_3 =
texture {
        pigment {
                gradient y
                poly_wave 3
                color_map {
                        [0   Copper]
                        [0.6 Copper]
                        [0.7 Copper*0.5]
                        [1   Copper*0.3]
                }
        }
        finish {ambient 0 diffuse 0.8 metallic brilliance 4 specular 0.1 roughness 0.001 reflection 0.1*sc}
}
 
#declare txtTop =
texture {
        pigment_pattern {
                gradient y   
                turbulence 0.2
                lambda 4
        }
        texture_map{
                [0      txtTop_1_1]
                [0.05   txtTop_1_2a]
                [0.7    txtTop_1_2a]
                [0.8    txtTop_1_3]
                [1      txtTop_1_3]
        }                                        
} 

#declare txtPaint =
texture {
        pigment {pPaint2}
        finish {ambient 0 diffuse 0.8 specular 0.1 roughness 0.01}
} 
                          
#declare txtCopperBase =
texture {
        pigment {     
                gradient y
                pigment_map {
                        [0      color Copper*0.1]
                        [1      crackle 
                                solid 
                                turbulence 0.1 
                                color_map {
                                        [0  Copper*2]
                                        [1  Copper]
                                }
                        ]
                }
        }
        normal {crackle solid turbulence 0.1}
        finish {ambient 0 diffuse 0.8*1.3 metallic brilliance 4 specular 0.1 roughness 0.001}
}
 
#declare txtPaintBase =
texture {
        pigment {pPaint1}
        normal {crackle solid bump_size 1 scale 0.1}
        finish {ambient 0 diffuse 0.8*1.3 specular 1 roughness 0.01}
}
                           
#declare txtBody_1 =
texture {
        pigment {
                gradient y
                pigment_map {
                        [0   pPaint0 scale 0.1*<1,1/4,1>]
                        [0.7 pPaint2 scale 0.1*<1,1/4,1>]
                        [1   color Black scale 0.1*<1,1/4,1>]
                }
        }          
        finish {ambient 0 diffuse 0.8 specular 1 roughness 0.01 reflection 0.1*sc}
}
                           
#declare txtBody_2 =
texture {
        pigment {
                gradient y
                pigment_map {
                        [0 pPaint0 scale 0.1*<1,1/4,1>]
                        [1 pPaint2 scale 0.1*<1,1/4,1>]
                }
        }          
        normal {wrinkles bump_size 0.2 scale 0.1*<1,1/4,1>}
        finish {ambient 0 diffuse 0.8 specular 1 roughness 0.01}
}
 
#declare txtBody =
texture {
        #declare k = 0.012; // parameter controlling the penetration of the top paint layer : the smaller the more rusty
        cylindrical
        turbulence 0.006
        lambda 3
        texture_map {
                [k*0.65 txtBody_1]   // external
                [k*0.66 txtCopper scale <1,1/4,1>]
                [k*1    txtCopper3 scale <1,1/4,1>]
                [k*3    txtBody_2] // internal
        }
}
                     
#declare txtPlug =
texture {
        pigment_pattern {
                gradient x
                turbulence 0.3
                lambda 4
        }
        texture_map {
                [0   txtPaint  scale 0.1]               
                [0.2 txtPaint  scale 0.1]               
                [0.3 txtCopper scale 0.2]                
        }
}

#declare txtBase =
texture {
        #declare k = 0.2*2;
        wrinkles//cylindrical
        turbulence 0.3
        lambda 4
        texture_map {
                [k*0.8 txtCopperBase scale <0.1,1*0.1,0.1>*0.5] // Externe
                [k*1.1 txtPaintBase scale 0.25] // Interne
        }
}

#declare T1 =                        
material {                                              
        texture {txtBase scale 0.2}                                                                     
        interior {ior 3}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 6) /////////////////////////////////////////////////////////////////////////////////////

// Ive  Vanishing Point  http://news.povray.org/povray.binaries.images/message/%3C502092ff%40news.povray.org%3E/#%3C502092ff%40news.povray.org%3E 

#declare T1 =
material {
        texture {
                pigment {rgb <0.912,0.900,0.865>}
                finish {ambient 0 diffuse 0.9}
        }
        texture {
                pigment {rgbf <0.960,0.965,0.975,0.99>}
                finish {ambient 0 diffuse 0.05 reflection {0, 1 fresnel on} conserve_energy}
        }
        interior {ior 1.525}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 7) ///////////////////////////////////////////////////////////////////////////////////// 

// Samuel T. Benge  shiny_metal  http://news.povray.org/povray.binaries.scene-files/attachment/%3C40A50D95.1060507%40hotmail.com%3E/us-ascii

#declare T1 = 
material {
        texture {
                pigment {rgb <1,1,0.8>}
                finish {
                        diffuse 0.3
                        brilliance 4
                        reflection {0.5, 1 fresnel on} conserve_energy//0.75
                        phong 2
                        phong_size 200
                        specular 0.3
                        roughness 0.05
                }
                normal {
                        average
                        normal_map {
                                [1 granite 0.07 scale 0.0007 accuracy 0.1]
                                [1 quilted scale 0.2]
                        }
                }
        }
        scale 0.5
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 8) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Odd highlights on texture  http://news.povray.org/povray.binaries.images/message/%3C51531e7c%40news.povray.org%3E/#%3C51531e7c%40news.povray.org%3E

#declare bstr = 1.5;
#declare cstr = 1.25;

#declare T1 =
material {
        texture {
                pigment {
                        granite
                        turbulence 0.35
                        omega 0.675
                        lambda 2.5
                        color_map {
                                [0      rgb Ga (<0.055,0.02,0.005>)*cstr]
                                [1      rgb Ga (<0.065,0.025,0.0075>)*cstr]
                        }
                        scale 0.025
                }
                finish {
                        specular albedo 0.1 
                        roughness 0.2
                        diffuse albedo 0.6 
                        brilliance 4
                }
                normal {
                        bozo
                        scallop_wave
                        scale 0.55
                        turbulence 0.575
                        lambda 2.5
                        omega 0.75
                        normal_map {
                                [0.0    agate 0.4*bstr scale 0.75 agate_turb 0.6]       
                                [0.1    agate 0.4*bstr scale 0.75 agate_turb 0.6]
                                [0.2    wrinkles 0.31*bstr scale 0.15 turbulence 0.6]
                                [0.956  wrinkles 0.21*bstr scale 0.15 turbulence 0.6]
                                [0.975  agate 0.35*bstr scale 0.75 agate_turb 0.6]
                                [1.0    agate 0.35*bstr scale 0.75 agate_turb 0.6]
                        }               
                }
        }
        texture {
                pigment {
                        wrinkles
                        turbulence 0.235
                        omega 0.8
                        lambda 2.5
                        color_map {
                                [0.0    rgbt Gat (<0.1, 0.045, 0.025, 0.8>)*cstr]
                                [0.05   rgbt Gat (<0.085, 0.0375, 0.025, 0.35>)*cstr]
                                [0.4    rgbt Gat (<0.1, 0.01625, 0.0075, 0.8>)*cstr]
                                [0.45   rgbt Gat (<0.1, 0.02, 0.009, 0.3>)*cstr]
                                [0.5    rgbt Gat (<0.15, 0.085, 0.0625, 0.95>)*cstr]
                                [0.85   rgbt Gat (<0.1, 0.02625, 0.01, 0.8>)*cstr]
                                [0.875  rgbt Gat (<0.1, 0.03125, 0.005, 0.4>)*cstr]
                                [1.0    rgbt Gat (<0.1, 0.03125, 0.005, 0.975>)*cstr]
                        }
                        scale 0.1
                }
                normal {
                        bozo
                        scallop_wave
                        scale 0.655
                        turbulence 0.6575
                        lambda 2.35
                        omega 0.765
                        normal_map {
                                [0.0    agate 0.8*bstr scale 0.75 agate_turb 0.6]        
                                [0.1    agate 0.8*bstr scale 0.75 agate_turb 0.6]
                                [0.2    wrinkles 0.61*bstr scale 0.15 turbulence 0.6]
                                [0.956  wrinkles 0.31*bstr scale 0.15 turbulence 0.6]
                                [0.975  agate 0.65*bstr scale 0.75 agate_turb 0.6]
                                [1.0    agate 0.65*bstr scale 0.75 agate_turb 0.6]
                        }
                }
                finish {
                        specular albedo 0 
                        roughness 0.5 
                        diffuse albedo 0.5 
                        brilliance 3
                }
        }
        texture {
                pigment {
                        granite
                        turbulence 0.235
                        omega 0.8
                        lambda 2.5
                        color_map {
                                [0.0    rgbt Gat (<0.1, 0.075, 0.05, 0.3>)*cstr]
                                [0.05   rgbt Gat (<0.11, 0.075, 0.05, 0.95>)*cstr]
                                [0.4    rgbt Gat (<0.1, 0.0325, 0.015, 0.4>)*cstr]
                                [0.45   rgbt Gat (<0.1, 0.0325, 0.015, 0.9>)*cstr]
                                [0.5    rgbt Gat (<0.15, 0.09, 0.0625, 0.95>)*cstr]
                                [0.85   rgbt Gat (<0.1, 0.04, 0.02, 0.38>)*cstr]
                                [0.875  rgbt Gat (<0.1, 0.0125, 0.005, 0.85>)*cstr]
                                [1.0    rgbt Gat (<0.1, 0.02125, 0.005, 0.975>)*cstr]
                        }               
                        scale 0.5
                }
                normal {
                        bozo
                        scallop_wave
                        scale 0.255
                        turbulence 0.4575
                        lambda 2.25
                        omega 0.725
                        normal_map {
                                [0.0    agate 0.8*bstr scale 0.75 agate_turb 0.6]          
                                [0.1    agate 0.8*bstr scale 0.75 agate_turb 0.6]
                                [0.2    wrinkles 0.61*bstr scale 0.15 turbulence 0.6]
                                [0.956  wrinkles 0.31*bstr scale 0.15 turbulence 0.6]
                                [0.975  agate 0.65*bstr scale 0.75 agate_turb 0.6]
                                [1.0    agate 0.65*bstr scale 0.75 agate_turb 0.6]

                        }
                }
                finish {
                        specular albedo 0 
                        roughness 0.6 
                        diffuse albedo 0.5 
                        brilliance 3 
                        reflection {0.001,0.1 metallic 1} 
                        conserve_energy
                }
        }
        //scale 1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 9) /////////////////////////////////////////////////////////////////////////////////////
 
// Sean Day  Royal Scot  http://www.irtc.org/ftp/pub/stills/2006-08-31/oldroyal.zip

#declare T1 =
material {
        texture {
                pigment {rgb Ga (<1,0.875,0.75>)}
                finish {
                        ambient 0 
                        diffuse 0.65*2 
                        brilliance 5 
                        specular 2.25 
                        roughness 0.02 
                        phong 0.7 
                        phong_size 75 
                        metallic 
                        reflection 0.02*5
                }
                normal {wrinkles 0.2 scale 0.075}//{wood 0.2 scale 0.075}
        }  
        texture {// add a slight touch of rust                                      
                pigment {               
                        wrinkles   
                        scallop_wave
                        turbulence 0.31 
                        omega 0.65 
                        lambda 3 
                        color_map {
                                [0.0  rgbt <1,1,1,1>]
                                [0.2  rgbt <1,1,1,1>]
                                [0.2  rgbt Gat (<0.1,0.035,0.005,1>)] 
                                [0.53 rgbt Gat (<0.1,0.035,0.005,0.14>)]
                                [0.7  rgbt Gat (<0.15,0.085,0.009,0.4>)]
                                [0.89 rgbt Gat (<0.15,0.085,0.009,1>)]
                                [1    rgbt <1,1,1,1>]
                        }  
                        scale 0.25
                }
                finish {ambient 0 diffuse 0.4*3}
                normal {wrinkles 1}
        
        }      
        texture {// add a slight touch of rust                                      
                pigment {               
                        wrinkles   
                        turbulence 0.51 
                        omega 0.675 
                        lambda 2.5 
                        color_map {
                                [0.0   rgbt <1,1,1,1>]
                                [0.3   rgbt <1,1,1,1>]
                                [0.3   rgbt Gat (<0.1,0.035,0.005,1>)] 
                                [0.53  rgbt Gat (<0.1,0.035,0.005,0.24>)]
                                [0.675 rgbt Gat (<0.15,0.085,0.009,0.55>)]
                                [0.79  rgbt Gat (<0.15,0.085,0.009,1>)]
                                [1     rgbt <1,1,1,1>]
                        }  
                        scale 1
                }
                finish {ambient 0 diffuse 0.4*3}
                normal {wrinkles 1}
        
        }
        texture {
                pigment {       
                        bozo
                        turbulence 0.675  
                        omega 0.85
                        lambda 3
                        color_map {
                                [0 rgbt Gat (<0.06,0.04,0.004,0.9>)]
                                [1 rgbt Gat (<0.06,0.04,0.004,0.1>)]
                                                 
                        }    
                        scale <0.7,1.2,0.5> 
                }
                finish {ambient 0 diffuse 0.25*3}     
                normal {
                        average 
                        normal_map {
                                [1.0  dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5]
                                [0.5  granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5]       
                                [0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5]
                        }  
                }
        }
        texture {
                pigment {       
                        bozo
                        turbulence 0.475  
                        omega 0.85
                        lambda 3
                        color_map {
                                [0 rgbt Gat (<0.04,0.03,0.01,0.7>)]
                                [1 rgbt Gat (<0.04,0.03,0.01,0.05>)]
                                                 
                        }    
                        scale <1,3.75,1> 
                }
                finish {ambient 0 diffuse 0.2*3}     
                normal {
                        average 
                        normal_map {
                                [1.0  dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5]
                                [0.5  granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5]       
                                [0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5]
                        }  
                }
        }
        scale 0.15
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 10) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Royal Scot  http://www.irtc.org/ftp/pub/stills/2006-08-31/oldroyal.zip

#declare T1 =
material {
        texture {
                pigment {
                        crackle // gradient x 
                        turbulence 0.025 
                        lambda 3 
                        omega 0.6 
                        color_map {
                                [0.0    rgb Ga (<0.2, 0.2, 0.25>)] 
                                [1.0    rgb Ga (<0.05, 0.04, 0.02>)] 
                        } 
                        scale 10 
                        translate <5,0,0>  
                }
                finish {ambient 0 diffuse 0.6*5 specular 1 roughness 0.08 reflection 0.025 brilliance 3 metallic}
                normal {agate 0.3 agate_turb 0.235 omega 0.6 lambda 3}
        }               
        texture {// add grease/dirt                         
                pigment {               
                        wrinkles   
                        scallop_wave
                        turbulence 0.31 
                        omega 0.65 
                        lambda 3                            
                        color_map {
                                [0.00   rgbt <1,1,1,1>]
                                [0.10   rgbt <1,1,1,1>]
                                [0.15   rgbt Gat (<0.01, 0.002, 0, 1>)]
                                [0.20   rgbt Gat (<0.01, 0.002, 0, 0.5>)]
                                [0.40   rgbt Gat (<0.01, 0.002, 0, 0>)]
                                [0.45   rgbt Gat (<0.025,0.01, 0.001, 0>)]
                                [0.50   rgbt Gat (<0.01, 0.002, 0, 0.5>)]
                                [0.525  rgbt Gat (<0.01, 0.002, 0, 1>)]
                                [0.525  rgbt <1,1,1,1>]
                                [0.80   rgbt <1,1,1,1>]
                                [0.80   rgbt Gat (<0.1, 0.035, 0.005, 1>)] 
                                [0.81   rgbt Gat (<0.1, 0.035, 0.005, 0.04>)]
                                [0.90   rgbt Gat (<0.15, 0.085, 0.009, 0.1>)]
                                [0.94   rgbt Gat (<0.15, 0.085, 0.009, 1>)]
                                [1.00   rgbt <1,1,1,1>]
                        }  
                        scale 3
                }
                finish {ambient 0 diffuse 0.2*5}
                normal {wrinkles 1}
        }
        texture {// add grease/dirt                         
                pigment {               
                        wrinkles   
                        turbulence 1 
                        omega 0.75 
                        lambda 3 
                        color_map {
                                [0.00   rgbt <1,1,1,1>]
                                [0.10   rgbt <1,1,1,1>]
                                [0.15   rgbt Gat (<0.01, 0.002, 0, 1>)]
                                [0.20   rgbt Gat (<0.01, 0.002, 0, 0.5>)]
                                [0.40   rgbt Gat (<0.01, 0.002, 0, 0.1>)]
                                [0.45   rgbt Gat (<0.025, 0.01, 0.001, 0.1>)]
                                [0.50   rgbt Gat (<0.01, 0.002, 0, 0.5>)]
                                [0.525  rgbt Gat (<0.01, 0.002, 0, 1>)]
                                [0.525  rgbt <1,1,1,1>]
                                [0.80   rgbt <1,1,1,1>]
                                [0.80   rgbt Gat (<0.1, 0.035, 0.005, 1>)] 
                                [0.81   rgbt Gat (<0.1, 0.035, 0.005, 0.4>)]
                                [0.90   rgbt Gat (<0.15, 0.085, 0.009, 0.2>)]
                                [0.94   rgbt Gat (<0.15, 0.085, 0.009, 1>)]
                                [1.00   rgbt <1,1,1,1>]
                        }  
                        scale 2.5
                        rotate <20,30,10>
                }
                finish {ambient 0 diffuse 0.2*5}
                normal {wrinkles 1}
        }
        texture {
                pigment {       
                        bozo
                        turbulence 0.675  
                        omega 0.85
                        lambda 3
                        color_map {
                                [0      rgbt Gat (<0.06,0.04,0.004,0.9>)]
                                [1      rgbt Gat (<0.06,0.04,0.004,0.1>)]
                                                 
                        }    
                        scale <0.7,1.2,0.5> 
                }
                finish {ambient 0 diffuse 0.25*5}     
                normal {
                        average 
                        normal_map {
                                [1.0    dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5]
                                [0.5    granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5]       
                                [0.75   wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5]
                        }  
                }
        }
        texture {
                pigment {       
                        bozo
                        turbulence 0.475  
                        omega 0.85
                        lambda 3
                        color_map {
                                [0      rgbt Gat (<0.04,0.03,0.01,0.7>)]
                                [1      rgbt Gat (<0.04,0.03,0.01,0.05>)]
                                                 
                        }    
                        scale <1,3.75,1> 
                }
                finish {ambient 0 diffuse 0.2*5}     
                normal {
                        average 
                        normal_map {
                                [1.0    dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5]
                                [0.5    granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5]       
                                [0.75   wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5]
                        }  
                }
        }
        scale 0.15
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 11) /////////////////////////////////////////////////////////////////////////////////////

// Ross  normals and textures using texture_map  http://news.povray.org/povray.general/thread/%3C42c5bb9d%40news.povray.org%3E/

#declare Step = 8;
#declare Turb = <0.34,0.3,0.7>;

#declare Pig =
pigment {
        leopard scale 0.15
        #declare I = Step;
        #while (I > 0)
                warp {repeat x flip y}
                warp {turbulence Turb}
                scale 1.2
                #declare I = I-1;
        #end
}

#declare fnPig = function {pigment {Pig}}

#declare t3 = 
texture {
        pigment {rgb 1.0} 
        finish {specular 1 roughness 0.003 diffuse 0.3 reflection {0.2,0.4 fresnel on} brilliance 2} 
        normal {function {fnPig (x,y,z).x} bump_size 1}
}

#declare t2 = 
texture {
        pigment {rgb 0.2} 
        finish {specular 0.6 roughness 0.03 diffuse 0.3 brilliance 2} 
        normal {function {fnPig (x,y,z).x} bump_size 1}
}

#declare T1 =
material {
        texture {
                function {fnPig (x,y,z).x}
                texture_map {
                        [0 t3]
                        [1 t2]
                }
        } 
        scale 0.3
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 12) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  gears  http://www.ignorancia.org/uploads/zips/gears-example.zip

#declare metal_image = "Erroded_Metal_Blue_Spots_Rust_UV_CM_1";//your_metal_image_here.jpg";

#declare t_metal1 =
texture {
        pigment {image_map {jpeg metal_image}}
        normal {bump_map {jpeg "Erroded_Metal_Blue_Spots_Rust_UV_CM_1_s" bump_size -1}}
        finish {reflection {0.5} diffuse 0.9*0.5 specular 1 roughness 0.007 brilliance 3}
}

#declare t_metal2 =
texture {
        pigment {image_map {jpeg metal_image}}
        normal {bump_map {jpeg "Erroded_Metal_Blue_Spots_Rust_UV_CM_1_s" bump_size -5}}
        finish {diffuse 0.5}
}

#declare T1 =                        
material {                                              
        texture {
                pigment_pattern {image_map {jpeg "Erroded_Metal_Blue_Spots_Rust_UV_CM_1_s"}}
                texture_map {
                        [0.1  t_metal2]
                        [0.9  t_metal1]
                }
                warp {turbulence 0.5 lambda 5}
                translate -0.5
                scale 3
        }                                                                     
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 13) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  gt_chess  http://www.oyonale.com/downloads/chess.zip  

#declare C_Stone0 = rgb 0.6*<98-15,80,50+15>/255;
#declare yCren = 2.2; 
#declare yStep = 0.224;
#declare yW1b1 = 6.02;

#declare T_RWCrenel =
texture {
        pigment {
                bozo
                turbulence 1
                lambda 3
                color_map {
                        [0.5    C_Stone0*3]
                        [0.8    C_Stone0*0.3*3]
                }
        }
        normal {bozo 2 scale 0.01}
        finish {ambient 0 diffuse 1}
        scale 0.3
}
texture {
        pigment{
                gradient y
                turbulence 0.3 
                omega 1 
                lambda 3
                poly_wave 1.5
                color_map {
                        [0      rgbf <(98-10)/255,80/255,(50+10)/255,1/3>*3]
                        [0.65   rgbf <(98-10)/255,80/255,(50+10)/255,3/3>*0.1*3]
                        [1      rgb  <(98-10)/255,80/255,(50+10)/255>*0.4*3]
                }
        }    
        finish {ambient 0 diffuse 1}
        scale (yCren+yStep)
}
texture {
        pigment {
                function {min (1,max (0,y))}
                turbulence 0.5 lambda 3 poly_wave 2
                color_map{                     
                        [0      rgbf <(98-5)/255,80/255,(50+5)/255,1/3>*3]    
                        [0.5    rgbf <(98-5)/255,80/255,(50+5)/255,3/3>*0.1*3]
                        [1      rgb  <(98-5)/255,80/255,(50+5)/255>*0.4*3]    
                }
        }
        scale yW1b1
}

#declare T1 =
material {
        texture {T_RWCrenel}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 14) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  photo studio  http://news.povray.org/povray.binaries.scene-files/attachment/%3C453d41ff%241%40news.povray.org%3E/photo_studio.pov.txt 

#declare T1 =
material {
        texture {
                pigment {rgb <148,193,28>/255}    // choose your color here
                finish {diffuse 0.7 ambient 0 brilliance 2} 
        } 
        texture {
                pigment {rgb 0.8 transmit 1}
                finish {diffuse 0 ambient 0 phong 1 phong_size 20 metallic 0.5}
                normal {facets coords 1 scale 0.01}
        }
        texture {
                pigment {rgbt 1}
                finish {diffuse 0.6 ambient 0 reflection {0,1 falloff 5} phong 1 phong_size 500}
        }
        scale 0.5
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 15) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  crackcircuit  http://203.29.75.35/povray.binaries.scene-files/thread/%3C3c8bf694@news.povray.org%3E/?ttop=281756&toff=600

#declare fBmod = 1.4; //adjusts the brightness of some stuff in the scene.

#default {finish {diffuse albedo 1/fBmod ambient 0}}

#declare gnRepeats = 4;
#declare gfRepeatDist = 0.10;
#declare gfWireWidth = 0.04;
#declare nMetric = 1;

#declare f_CircuitWire =
function {
	pigment {
		crackle
		metric nMetric
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}

#declare f_CircuitSolid =
function {
	pigment {
		crackle
		solid
		metric nMetric
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}

#declare f_CircuitRepeated =
function (x,y,z, fOffsetX,fOffsetY,fOffsetZ) {
	#local nRepeat = 0;
	#while (nRepeat < gnRepeats)
		min (f_CircuitWire (x-fOffsetX*nRepeat,y-fOffsetY*nRepeat,z-fOffsetZ*nRepeat).red,
		#local nRepeat = nRepeat+1;
	#end //repeat loop
	1
	#local nRepeat = 0;
	#while (nRepeat < gnRepeats)
		)
		#local nRepeat = nRepeat+1;
	#end //repeat loop
}
	
#declare f_CircuitRepeatedInterface = 
function (x,y,z, fAngle) {f_CircuitRepeated (x,y,z, gfRepeatDist*cos (fAngle), 0, gfRepeatDist*sin (fAngle))}

#declare f_Circuit =
function {f_CircuitRepeatedInterface (x,y,z, f_CircuitSolid (x,y,z).x*pi*2)}

#declare tWire =
texture {
	pigment {rgb <1.5,1,0.5>}
	finish {
		diffuse albedo 0.3/fBmod
		reflection {0.3,0.8}
		conserve_energy
		specular 1
		roughness 0.03
	}
}

#declare tBoard =
texture {
	pigment {rgbt <0.15,1,1.5,0.3>}
	finish {
		diffuse albedo 0.3/fBmod
		reflection {0.2}
		specular 0.2
		roughness 0.1
		conserve_energy
	}
}

#declare T1 =
material {
	texture {
		function {
			f_Circuit (x,y,z)
		}
		texture_map {
			[gfWireWidth	tWire]
			[gfWireWidth	tBoard]
		}
	}
        scale 0.25
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 16) /////////////////////////////////////////////////////////////////////////////////////

// Xplo Eristotle  "Rust and Sky" source  http://news.povray.org/povray.text.scene-files/message/%3C38E7BA86.4122748B%40unforgettable.com%3E/#%3C38E7BA86.4122748B%40unforgettable.com%3E

// RUST
#declare rust =
texture {
	pigment {
		granite
		color_map {
			[0.0 rgb Ga (<0.809995, 0.299123, 0.113405>*0.8)]
			[0.4 rgb Ga (<0.209995, 0.096941, 0.031510>*1.2)]
			[0.6 rgb Ga (<0.209995, 0.096941, 0.031510>*1.2)]
			[1.0 rgb Ga (<0.569986, 0.052720, 0.005707>*0.9)]
		}
		scale 0.5
		turbulence 1
	}
        finish {diffuse 0.6*0.8}
	normal {wrinkles 1.5}
        scale 0.04
}

// IRON
#declare iron = 
texture {
	pigment {rgb Ga (<0.25,0.25,0.25>)}
	normal {granite 0.3  scale 0.05}
	finish {roughness 0.01 specular 0.5 reflection 0.05 diffuse 0.6}
}

// RUSTY IRON
#declare rusty_iron = 
texture {
	pigment_pattern {
                bozo
	        turbulence 1
	        omega 0.3
	        lambda 4
        }
	texture_map {
        	[0.0    rust]
		[0.99   rust]
		[1.0    iron]
	}
        scale 0.5
}
        
#declare T1 =
material {
        texture {rusty_iron}
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 17) /////////////////////////////////////////////////////////////////////////////////////

// adapted from Jaimes Vives Piqueres  asceta  http://www.ignorancia.org/uploads/zips/asceta.zip

#declare p_wall1 =
pigment {
        image_map {png "r2"}
        translate -0.5
        scale 10
        warp {turbulence 1 lambda 2}
}

#declare p_wall2=
pigment {
        image_map {png "r2d"}
        translate -0.5
        scale 10
        warp {turbulence 1 lambda 2}
}

#declare T1 = 
material {
        texture {
                pigment {
                        granite 
                        warp {turbulence 1 lambda 3}
                        pigment_map {
                                [0.0  p_wall1]
                                [1.0  p_wall2]
                        }
                }
                normal {granite -1 warp {turbulence 1 lambda 3}}
                finish {diffuse 0.7 specular 0.2 roughness 0.003}
        }
        scale 0.375
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 18) /////////////////////////////////////////////////////////////////////////////////////

// Jaimes Vives Piqueres  bolts1.pov  it seams the original source is replaced by this one... http://www.ignorancia.org/uploads/zips/boltstill.zip

#declare p_map_metal =
pigment {
        image_map {jpeg "im_metal"} 
        scale 3
}

// + "proceduralize" it "a la tran".
#declare p_imagemap =
pigment {
        wrinkles turbulence 0.3 lambda 3
        pigment_map {
                [0.0 p_map_metal]
                [1.0 p_map_metal rotate 90*y translate 1000]
        }
        scale 10
        rotate 90*x
}

// + microsurface normal
#declare p_micro =
pigment {
        onion turbulence 0.5
        color_map {
                [0.0 White]
                [0.45 White]
                [0.55 White*0.96]
                [1.0 White*0.96]
        }
        scale 0.1
}

// + big dents pattern 1
#declare p_dents1 =
pigment {
        granite
        color_map {
                [0.0 White]
                [0.8 White]
                [0.9 White*0.2]
                [1.0 White*0.01]
        }
        turbulence 0.7
        scale 40
}

// + big dents pattern 2
#declare p_dents2 =
pigment {
        crackle
        color_map {
                [0.0 White]
                [0.6 White]
                [0.7 White*0.2]
                [1.0 White*0.01]
        }
        turbulence 0.7
        scale 40
}

// + average all the normals (micro + big dents)
#declare p_brushed =
pigment {
        average 
        turbulence 0
        pigment_map {
                [0.0 p_micro translate 1000*y]
                [0.1 p_micro translate 1000*x]
                [0.2 p_micro translate 1000*z]
                [0.3 p_dents1]
                [0.5 p_imagemap]
                [0.6 p_dents2]
                [0.8 p_micro translate <1000,1000,0>]
                [0.9 p_micro translate <1000,0,1000>]
                [1.0 p_micro translate<0,1000,1000>]
        }
        scale 0.02
}

#declare n_brushed = normal {pigment_pattern {p_brushed} 0.1*10} 

#declare F_MetalA_ =
finish {
        ambient 0
        brilliance 2
        diffuse albedo 0.6
        metallic
        specular 0.80
        roughness 0.05
        reflection 0.1
}

#declare T1 =
material {
        texture {
                pigment {p_imagemap}
                normal {n_brushed}
                finish {F_MetalA_}
        }
        scale 0.1
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 19) /////////////////////////////////////////////////////////////////////////////////////

// Margus Ramst  shrine  http://www.hot.ee/margusrt/code/shrine.zip

#declare StoneTex1 =
texture {
        pigment {
                agate
                color_map {
                        [0    hsl (0.58,0.2,0.5)]
                        [0.5  hsl (0.6,0.2,0.65)]
                        [1    hsl (0.6,0.1,0.75)]
                }
                scale 1/3 
                warp {turbulence 0.4} 
                scale 3
                scale 0.3
                rotate z*50
        }
        normal {
                pigment_pattern {
                        crackle
                        scale 0.6
                        turbulence 0.2
                        solid
                }
                normal_map {
                        [0.5    bozo 0]
                        [0.5    crackle 0.3
                                slope_map {
                                        [0,    <0,0>]
                                        [0.008,<1,1>]
                                        [0.008,<1,0>]
                                }
                                scale 0.3
                                turbulence 0.1
                        ]
                }
        }
        finish {ambient 0 diffuse 0.8}
}

#declare StoneTex2 =
texture {
        pigment {
                granite
                color_map {
                        [0.3  hslt (0.03,0.2,0.5,0.5)]
                        [0.35 hslt (0.01,0.3,0.3,0.6)]
                        [0.4  hslt (0.01,0.3,0.4,0.6)]
                        [0.7  hslt (0,0,0,1)]
                }
                frequency 4
                turbulence 0.5 
                lambda 2.3
                scale <1,2,1>
                rotate z*-30
        }
        finish {ambient 0 diffuse 0.8}
}

#declare StoneTex3 =
texture {
        pigment {
                bozo
                color_map {
                        [0.35 hslt (0.63,0.1,0.5,0.3)]
                        [0.5  hslt (0,0,0,1)]
                }
                turbulence 0.3
                scale 0.5
        }
        finish {ambient 0 diffuse 0.8}
}

#declare StoneTex4 =
texture {
        pigment {
                granite
                color_map {
                        [0.2  hslt (0,0,0,1)]
                        [0.6  hslt (0.03,0.1,0.3,0.2)]
                }
                scale 0.05
                warp {turbulence 0.3}
        }
        finish {ambient 0 diffuse 0.8}
}

#declare StoneTex5 =
texture {
        pigment {
                pigment_pattern {
                        crackle
                        scale 0.6
                        turbulence 0.2
                        solid
                }
                pigment_map {
                        [0.5    rgbf 1]
                        [0.5    pigment_pattern {
                                        crackle
                                        scale 0.3
                                        turbulence 0.1
                                }
                                pigment_map {
                                        [0.004 rgb  0]
                                        [0.004 rgbf 1]
                                }
                        ]
                }
        }
        finish {ambient 0 diffuse 0.8}
}

#declare T1 = 
material {
        texture {StoneTex1}
        texture {StoneTex2}
        texture {StoneTex3}
        texture {StoneTex4}
        texture {StoneTex5}
        scale 0.25
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 20) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  Octree space partitioning experiment  http://news.povray.org/povray.text.scene-files/attachment/%3Cweb.4f2a0580cf27ae8a94d713cc0%40news.povray.org%3E/octree_test.pov.txt

#declare T1 = 
material {
        texture {
                pigment {
                        bozo 
                        scale 0.15
                        turbulence 0.5
                        color_map {
                                [0 color srgb <225,180,105>/255]
                                [1 color srgb <105,90,30>/255]
                        }
                } 
                normal {agate 0.1 scale 0.2 turbulence 0.15}
                finish {specular 0.2 roughness 0.02 reflection {0,0.5 fresnel on} conserve_energy}
        }
        scale 0.5
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 21) /////////////////////////////////////////////////////////////////////////////////////

// Kenneth  old pitted iron  http://news.povray.org/povray.binaries.images/message/%3Cweb.49d3c8d94ee6dd4ef50167bc0%40news.povray.org%3E/#%3Cweb.49d3c8d94ee6dd4ef50167bc0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {
                        granite
                        color_map {
                
                                [0.000 rgb 0.8*<0.4,0.4,0.38>]
                                [0.153 rgb 0.4]
                                [0.398 rgb 0.5*<0.7,0.4,0.25>]
                                [0.398 rgb 0.2*<0.7,0.7,0.7>]
                                [1.000 rgb <0.545,0.38,0.345>]
                        }
                }
                finish {
                        ambient 0
                        diffuse 1
                        phong 0.6
                        phong_size 24
                }
                normal {
                        average
                        normal_map {
                                [1 agate 0.7*2 scale 3]
                                [1 granite 0.7*2 scale 9]
                        }
                }
                scale 0.05
        }
        interior {ior 3}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 22) /////////////////////////////////////////////////////////////////////////////////////

// Rune Skovbo Johansen  CD texture  http://news.povray.org/povray.text.scene-files/thread/%3C367d7b8e.0%40news.povray.org%3E/

#declare radio = 0;
#declare light = 0;
#declare envir = 0;

#include "colors"
#declare r = seed (83503847);
#declare i = 0;
#while (i < 1)
        light_source{      
                -50*z+x*100, 
                rgb 4
                parallel
                rotate z*i*360
        }
        #declare i = i+1/7;
#end

#declare cd_samples    = 9.0; // samples per color cycle.
#declare cd_phong      = 1.0; // phong value
#declare cd_phong_size = 200; // phong_size value
#declare cd_dispertion = 1.5; // frequency of color cycles in unknown units.
#declare cd_offset     = 0.5; // offset of color cycles in color cycles.
#declare cd_cycles     = 5.0; // number of color cycles.
#declare cd_scale      = 2;   // scale of cd texture

// Calculates how many samples will be used for values below cd_offset.
#declare _cd_unused = cd_samples*cd_offset;
#declare _cd_unused = (_cd_unused = int(_cd_unused)?_cd_unused:ceil(_cd_unused));

// (Zero To One) macro which rounds towards the nearest value between 0 and 1.
#macro zto (P) (P<0?0:(P>1?1:P)) #end 

// The cd texture is a average of many textures with different colored highlights.
#declare cd_texture =   // This texture contains the reflective surface and the regular highlight.
texture {
        average
        texture_map {
                [       pigment {rgb 0}
                        finish {
                                emission 0
                                diffuse 0
                                reflection cd_samples*2*cd_cycles+1
                                //phong cd_phong*cd_samples*2*cd_cycles+1
                                //phong_size cd_phong_size
                        }
                ]
                // Some formulas which calculates the colored highlights. The formulas are optimised for realism but they are not based on real physics at all. 
                // A is a counter in the primary while_loop. B and C are some modified versions of the counter.
                #declare A = 0;
                #while (A < cd_cycles+cd_offset)
                        #declare B = A-cd_offset; // We don't want the indifferent values below the offset value to have any texture_map entries.
                        #if (B >= 0)
                                #ifndef (Control)               // The first time this code is accessed the B value is reset.
                                        #declare B_value = B;   
                                        #declare Control = 1;    
                                #end                             
                                #declare B = B-B_value; // The first color cycle have full density, the next ones have each 2/3 density of the previous one (See *1).
                                #declare F = 0;
                                #while (B > 1)
                                        #declare F = F+1;
                                        #declare B = B-1;
                                #end
                                #declare B = (B<0.15?0:(B>0.85?1:(B-0.15)/0.7));
                                #declare Color =
                                        color <
                                        zto (sin ((B+0/3+0.25)*2*pi)+0.5),
                                        zto (sin ((B+1/3+0.25)*2*pi)+0.5),
                                        zto (sin ((B+2/3+0.25)*2*pi)+0.5)
                                        >*pow (B,2)/pow (1.5,F);                     // *1
                        [       pigment {color Color}
                                normal {onion +A*cd_dispertion}
                                finish {
                                        emission 0
                                        diffuse 0
                                        phong cd_phong*8*cd_cycles+1
                                        phong_size cd_phong_size
                                        metallic 1
                                }
                        ]
                        [       pigment {color Color}
                                normal {onion -A*cd_dispertion}
                                finish {
                                        emission 0
                                        diffuse 0
                                        phong cd_phong*8*cd_cycles+1
                                        phong_size cd_phong_size
                                        metallic 1
                                }
                        ]
                #end
                #declare A = A+(1/cd_samples);
        #end
        }
        scale cd_scale
}

#declare T1 = 
material {
        texture {cd_texture scale 0.5}
        interior {ior 1.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 23) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  reflective sphere on checkered floor  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1104_1061242324%40news.povray.org%3E/reflective.pov.txt

#declare st =
texture {
        pigment {rgb <0.83,0.82,0.84>}
        finish {diffuse 0.85*0.2 ambient 0 specular 0.8 roughness 0.02 phong 2 phong_size 300 brilliance 7.3 metallic 0.5 reflection {0.6,1 metallic} conserve_energy}
}

#declare plastic =
texture {
        pigment {rgb 1}
        finish {diffuse 0.94*0.4 ambient 0 phong 3 phong_size 2000 specular 0.3 roughness 0.015 reflection {0.2,0.4} conserve_energy}
}

#declare chps =
pigment {
        function {(pow (abs (sin (x)),1/4)*select (sin (x),-1,0,1)*pow (abs (sin (z)),1/4)*select (sin (z),-1,0,1)+1)*0.5}
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.5/pi
}

#declare parf0 =
pigment {
        average 
        pigment_map {
                #declare i = 0;
                #while (i < 1)
                        [pow (0.5,i*0.25),  chps translate i*0.5 rotate y*i*45 scale pow (0.5,i*0.5)]
                        #declare i = i+1;
                #end
        }
        scale 2
        translate 100
}

#declare terracotta =
texture {
        finish {diffuse 1.3*0.4 phong 0.1}
        normal {
                average 
                normal_map {
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.02 
                                noise_generator 3
                                slope_map {
                                        [0,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.015 
                                noise_generator 3
                                slope_map {
                                        [0,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 2 
                                rotate 60 
                                scale 0.006 
                                noise_generator 3
                        ]
                }
                scale 0.75
        }
        pigment {rgb 0.5}
}

#declare parf  = function {pigment {parf0}}

#declare parfn1 = 
normal {
        function {parf (x,y,z).x} 0.6
        slope_map {
                [0.0, <1, 1>]
                [0.5, <0,-1>]
                [0.5, <0, 1>]
                [1.0, <1,-1>]
        }
}
        
#declare T1 =
material {
        texture {
                function {parf (x,y,z).x}
                texture_map {
                        [0.3, st normal {parfn1}]
                        [0.4, terracotta]
                        [0.6, terracotta]
                        [0.7, plastic normal {parfn1}]
                }
        }
        scale 0.5
        rotate x*90
        interior {ior 2.5}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 24) /////////////////////////////////////////////////////////////////////////////////////

// Nicolas Rougier  Iso-chain  http://news.povray.org/povray.binaries.scene-files/thread/%3C42bbb1a7%40news.povray.org%3E/

#declare p_rust = 
pigment {
        image_map {jpeg "rust.jpg"}
        translate -0.5
        scale 10
        warp {turbulence 1 lambda 2}
}
#declare p_brass = 
pigment {
        image_map {jpeg "iron06.jpg"}
        translate -0.5
        scale 10
        warp {turbulence 1 lambda 2}
}

#declare T1 = 
material {
        texture {
        	pigment {
        	        cells
        	        warp {turbulence 1 lambda 3}
        	        pigment_map {
        		        [0.7 p_rust]
        		        [1.0 p_brass]
        	        }
        	}                
                normal {
                        average
                        normal_map {
                                [1 granite 0.2 scale 0.1]
                                [1 cells -2 warp {turbulence 1 lambda 3}]
                        }
                }
                finish {specular 0.25 roughness 0.01 diffuse 0.75 ambient 0}
        }
        scale 0.1
        interior {ior 2}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 25) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  iridescent beetle texture  http://news.povray.org/povray.binaries.images/message/%3C3dc44d2f%40news.povray.org%3E/#%3C3dc44d2f%40news.povray.org%3E

#declare iric  = 40;                // determines the color variance (0 = no variance; 60 = all colors) 
#declare ranc  = 0.2;               // determines the decrease in color lightness (1 = no decrease; 0 = black at slope 0.5)
#declare RGBc  = <0,0.4,0.6>/0.6;   // main color
#declare HSLc  = CRGB2HSL(RGBc);
#declare col1  = RGBc;
#declare col2  = CHSL2RGB(<HSLc.x-iric*0.5,HSLc.y,HSLc.z>);
#declare col3  = CHSL2RGB(<HSLc.x-iric*1.0,HSLc.y,HSLc.z>);
#declare col4  = CHSL2RGB(<HSLc.x-iric*1.5,HSLc.y,HSLc.z>);
#declare col5  = CHSL2RGB(<HSLc.x-iric*2.0,HSLc.y,HSLc.z>);
#declare col6  = CHSL2RGB(<HSLc.x-iric*2.5,HSLc.y,HSLc.z>);
#declare col7  = CHSL2RGB(<HSLc.x-iric*3.0,HSLc.y,HSLc.z>);
#declare col8  = CHSL2RGB(<HSLc.x-iric*3.5,HSLc.y,HSLc.z>);
#declare col9  = CHSL2RGB(<HSLc.x-iric*4.0,HSLc.y,HSLc.z>);
#declare col10 = CHSL2RGB(<HSLc.x-iric*4.5,HSLc.y,HSLc.z>);
#declare col11 = CHSL2RGB(<HSLc.x-iric*5.0,HSLc.y,HSLc.z>);
        
#declare T1 =
material {
        texture {
                pigment {
                        aoi
                        //slope {lookat-cam_loc,0,1}
                        color_map {
                                [0    rgb col1]
                                [0.05 rgb col2*(1-0.1*(1-ranc))]
                                [0.1  rgb col3*(1-0.2*(1-ranc))]
                                [0.15 rgb col4*(1-0.3*(1-ranc))]
                                [0.2  rgb col5*(1-0.4*(1-ranc))]
                                [0.25 rgb col6*(1-0.5*(1-ranc))]
                                [0.3  rgb col7*(1-0.6*(1-ranc))]
                                [0.35 rgb col8*(1-0.7*(1-ranc))]
                                [0.4  rgb col9*(1-0.8*(1-ranc))]
                                [0.45 rgb col10*(1-0.9*(1-ranc))]
                                [0.5  rgb col11*ranc]
                                [0.55 rgb col10*(1-0.9*(1-ranc))]
                                [0.6  rgb col9*(1-0.8*(1-ranc))]
                                [0.65 rgb col8*(1-0.7*(1-ranc))]
                                [0.7  rgb col7*(1-0.6*(1-ranc))]
                                [0.75 rgb col6*(1-0.5*(1-ranc))]
                                [0.8  rgb col5*(1-0.4*(1-ranc))]
                                [0.85 rgb col4*(1-0.3*(1-ranc))]
                                [0.9  rgb col3*(1-0.2*(1-ranc))]
                                [0.95 rgb col2*(1-0.1*(1-ranc))]
                                [1    rgb col1]
                        }
                }
                normal {
                        average
                        normal_map {
                                [0.3 bumps 1 scale 0.1*0.5]
                                [0.6 granite 1 scale 0.03*0.5]
                                [1.0 dents 1.2 scale 0.02*0.5]
                        }                                      
                }
                finish {
                        ambient 0  
                        diffuse 0.7
                        phong 1
                        phong_size 10
                        brilliance 6
                        reflection {0.2 fresnel on metallic 1}
                        metallic 1
                }
        }
        interior {ior 1.54} // ior of chitin
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 26) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  rofh  http://www.irtc.org/ftp/pub/stills/2000-08-31/rofh.zip 

#declare T1 =
material {
        texture {
        	pigment {
        		bozo
        		color_map {
        			[0.25 rgb <1,0.75,0.45>]
        			[0.50 rgb <0.9,0.75,0.6>]
        			[1.00 rgb <0.85,0.7,0.6>]
        		} 
                        turbulence 0.6 
                        lambda 8 
                        frequency 6 
                        scale 0.125
        	} 
        	finish {
        	        specular 0.75
        	        roughness 0.25
        	        diffuse 0.9*0.3 
        	        brilliance 1
        	        ambient -0.0000001
        	        metallic
        	        reflection 0.2
        	}
        	normal {
                        average 
                        normal_map {
                                #declare Count = 1;
                                #while (Count < 10)
                                        [1 crackle 45/Count turbulence 0.25 scale 0.05/Count]
                                        [1 bumps 90/Count ramp_wave scale 0.05/Count]
                                        [1 bumps 75/Count ramp_wave scale 0.15/Count]
                                        #declare Count = Count+1;
                                #end
                        } 
        	}   
        }	        
        texture {
                pigment {
                        bozo
                        turbulence 0.5 frequency 3 lambda 6
                        color_map {
                                [0.45  rgbt 1]
                                [0.475 rgbt <0.5,0.3,0.2,1/3>*3]
                                [0.6   rgb <0.3,0.1,0>*3]
                                [0.75  rgb <0.3,0.25,0>*5]
                                [0.95  rgb <0.6,0.3,0>*3]
                        }
                        scale 0.125
                }
                finish {specular 1 roughness 0.01 ambient 0 diffuse 1*0.3}
                normal {bumps 5 scale 0.001}
        }
        scale 1.25
        interior {ior 1.6}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 27) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  glasses  http://www.oyonale.com/downloads/gt_glass_wikipedia.zip

#declare T1 = //pitter
material {
        texture {
                pigment {
                        bozo //function {min (1,max (0,y))} turbulence 0.07 lambda 3 scale <0.05,1,1> translate y*0.1
                        turbulence 0.07
                        lambda 3
                        color_map {
                                [0    rgb <41,81,32>/255]
                                [0.2  rgb <40,23,2>*1.5/255]
                                [0.25 rgb <40,23,2>*3/255]
                                [0.4  rgb <1,0.89,0.75>]
                                [0.44 rgb <1,0.99,0.85>]
                        }
                } 
                normal {
                        bumps
                        turbulence 1
                        scale 0.005
                        bump_size 0.2
                }
                finish {
                        ambient 0 
                        diffuse 0.5 
                        specular 1 
                        roughness 0.0125
                        reflection {0.1,0.3 fresnel}
                        conserve_energy
                }
        }
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////
  
#if (mat = 28) /////////////////////////////////////////////////////////////////////////////////////

// LightBeam  Pyramolles  http://news.povray.org/povray.binaries.images/message/%3C41ab2d1c%40news.povray.org%3E/#%3C41ab2d1c%40news.povray.org%3E

#declare T1 = 
material {
        texture {
                pigment {rgb <0.1,0.1,0.05>}
                finish {
                        ambient 0 
                        reflection 0.5
                        diffuse 0.6 
                        specular 0.7 
                        roughness 0.003 
                        phong 0.5 
                        phong_size 10
                }
                normal {
                        granite 0.4 
                        turbulence 0.3 
                        scale 0.3 
                        cubic_wave 
                        slope_map {
                                [0.00, 0.00]
                                [0.75, 0.05]
                                [0.80, 0.10]
                                [1.00, 0.70]
                        }
                }
        } 
        scale 0.5
        interior {ior 1.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////
  
#if (mat = 29) /////////////////////////////////////////////////////////////////////////////////////

// Rune Skovbo Johansen  FurTex  http://runevision.com/3d/povgoodies/furtex.zip

#declare Color = rgb <0.9,0.15,0.3>;

#declare T1 =
material {
        texture {
                average
                texture_map {
                        [       pigment {
                                        bozo
                                        color_map {
                                                [0,     color Color*0.9]
                                                [1,     color Color*1.1]
                                        }
                                        scale 0.001
                                }
                                normal {
                                        average
                                        normal_map {
                                                [       bumps 0.3*2
                                                        warp {turbulence 1}
                                                        scale 0.2
                                                ]
                                                [       bumps 0.2*2
                                                        warp {turbulence 0.5}
                                                        scale 0.001
                                                ]
                                        }
                                }
                                finish {ambient 0 diffuse 0.6*2 brilliance 0.6}
                        ]
                        [       pigment {color -Color}
                                finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
                        ]
                }
        }
        scale 0.5
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////
 
#if (mat = 30) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Pearl  http://news.povray.org/povray.binaries.images/message/%3C507d3b98%241%40news.povray.org%3E/#%3C507d3b98%241%40news.povray.org%3E 

#declare n_pearl = 
normal {
        radial 
        sine_wave 
        frequency 36*4 
        rotate 90*z 
        scale 100 
        rotate x*-45 
        translate -1
}

#declare T1 =
material {
        texture {
                pigment {
                        aoi
                        color_map {
                                [0.0 rgb 1]
                                [0.5 rgb <pow (0.9235295,1/2.2),pow (0.672549,1/2.2),pow (0.37451,1/2.2)>*0.5]
                                [1.0 rgb 1]
                        }
                }
                normal {n_pearl 0.05}
                finish {
                        specular albedo 0.25 
                        metallic 
                        roughness 0.025 
                        diffuse 0.75 
                        brilliance 2
                        reflection {0,1 metallic}
                        conserve_energy
                        irid {0.35 thickness 0.1 turbulence 0.5}
                }
        }
        interior {              
                ior 1.6
                dispersion 10
                dispersion_samples 12
        }        
}

#end /////////////////////////////////////////////////////////////////////////////////////
  
#if (mat = 31) /////////////////////////////////////////////////////////////////////////////////////

// Aaron Gillies  New Ceramics ... One ... More  http://news.povray.org/povray.binaries.images/message/%3C3DF35520.5020400%40spam.com%3E/#%3C3DF35520.5020400%40spam.com%3E

#declare T1 = 
material {
        texture {
                pigment {
                        marble 
                        rotate z*90
                        scale 50
                        turbulence 0.25
                        color_map {
                                [0 rgb 0]
                                [1 rgb <0.5,0.25,0>]
                        }
                }
                normal {
                        marble
                        scale 50 
                        turbulence 0.25
                        rotate z*45
                        normal_map {
                                [0.0 crackle 2 scale 0.04]
                                [0.5 bozo 2 scale 0.04]
                                [1.0 bozo 1 scale 50]
                        }
                }                
                finish {
                        ambient 0
                        diffuse 0.6
                        specular 1
                        roughness 0.005
                        reflection {0, 1}
                        conserve_energy 
                }
        }
        scale 0.02
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////
 
#if (mat = 32) /////////////////////////////////////////////////////////////////////////////////////

// Patrick Dugan  rose gold metal  http://news.povray.org/povray.binaries.images/message/%3C3d2462a0%40news.povray.org%3E/#%3C3d2462a0%40news.povray.org%3E
 
#declare T1 =
material {
        texture {
                pigment {rgb <1,0.5,0.35>}   // Rose Gold color
                finish {
                        reflection {0.4, 1 fresnel on} conserve_energy //0.8
                        diffuse 0.3655 //0.5
                        ambient 0
                        phong 1
                        metallic
                }
                //normal {bumps 1 scale <0.1,0.1,0.3>*0.005}
                //normal {dents 1 scale <0.01,0.01,0.03>*0.005}
                normal {
                        average
                        normal_map {
                                [0.1    bumps 1 scale 0.005]
                                [0.1    dents 1 scale 0.0005]
                                [1.0    crackle 1 
                                        poly_wave 3 
                                        normal_map {
                                                [0      crackle 0  poly_wave 3]
                                                [0.05   crackle 0  poly_wave 3]
                                                [0.05   crackle -3 poly_wave 3]
                                                [1      crackle -9 poly_wave 3]
                                        } 
                                        scale 0.02
                                ]
                        }    
                }      
        }
        interior {ior 0.92}
}

#end ///////////////////////////////////////////////////////////////////////////////////// 

#if (mat = 33) /////////////////////////////////////////////////////////////////////////////////////

// Abe  boulders  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.449423ac72d4de73273c6a720%40news.povray.org%3E/#%3Cweb.449423ac72d4de73273c6a720%40news.povray.org%3E

#declare RockTex =
texture {
        pigment {
                wrinkles//slope y  
                cubic_wave
                color_map {
                        [0  rgb 0.25]
                        [1  rgb 0.60]
                }
        }
        normal {
                pigment_pattern {
                        wrinkles 
                        scale 0.35 
                        poly_wave 3
                }
                //wrinkles  scale 0.1 poly_wave 2
                bump_size 1.8
                accuracy 0.001
        }
        finish {ambient 0 diffuse 0.6*2 brilliance 1} 
} 

#declare f_absnoise3d = function {pow (abs (2*f_noise3d (x,y,z)-1),0.3)}
#declare Spots = function {pattern {crackle form x}}

#macro Turb () 

scale 2 
warp {turbulence 1 lambda 3 octaves 3} 
scale 0.5 
scale 0.05 

#end 

#macro LichenPig (Ltcol,Medcol,Dkcol,Coverage)

pigment_pattern {
        function {Spots (x,y,z)} 
        color_map {
                [0 rgb 1]
                [Coverage rgb 0]
        } 
        translate 10         
        scale 2 
        warp {turbulence 0.3 lambda 2.5 octaves 4} 
        scale 0.5 
        scale 1.5
} 
pigment_map {
        [0.00 
                function {f_noise3d (x,y,z)}
                Turb() 
                color_map {
                        [0.00 rgb Ltcol transmit 1]
                        [1.00 rgb Dkcol transmit 1]
                }
        ]
        [0.01 
                function {f_noise3d (x,y,z)} 
                Turb()
                color_map {
                        [0.00 rgb Ltcol transmit 0]
                        [1.00 rgb Dkcol transmit 0]
                }
        ]
        [0.15 
                function {f_absnoise3d (x,y,z)}
                Turb() 
                color_map {
                        [0.05 rgb Medcol transmit 1]
                        [0.05 rgb Medcol transmit 0]
                        [1.00 rgb Dkcol  transmit 0]
                }
        ]
}
scale 0.25
 
#end 

#declare LichenLt  = <0.6431,0.6863,0.5686>;
#declare LichenMed = <0.5451,0.5843,0.4863>;
#declare LichenDk  = <0.3569,0.4235,0.3137>;

#declare LichenTex =
texture {
        pigment {
                wrinkles//planar
                pigment_map {
                        #local i = 0;
                        #while (i < 100)
                                [i*0.01  LichenPig (LichenLt,LichenMed,LichenDk,0.6*(i*0.01))]
                                #local i=i+1;
                        #end
                }
        }
        normal {
                pigment_pattern {
                        planar
                        pigment_map {
                                #local i = 0;
                                #while (i < 100)
                                        [i*0.01
                                                average
                                                pigment_map {
                                                        [1      LichenPig (0.5,1,0,0.6*(i*0.01))]
                                                        [1      pigment_pattern {wrinkles scale 0.25 poly_wave 2}]
                                                }
                                        ]
                                        #local i = i+1;
                                #end
                        }
                } 
                accuracy 0.005 
                bump_size 0.25
        }
        finish {ambient 0 diffuse 0.6*2 brilliance 2}
}

//#declare RockTrans = transform {rotate -y*55}
        
#declare T1 =
material {
        texture {RockTex}
        texture {LichenTex}
        //transform {RockTrans}
        scale 0.5
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 34) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  old lantern  http://news.povray.org/povray.binaries.images/thread/%3Cweb.514a2e6b2f77df7b65887a1a0%40news.povray.org%3E/?ttop=384970&toff=50&mtop=382650&moff=10

#declare lampBaseNormal =   
normal {
        bozo
        scallop_wave
        scale 0.55
        turbulence 0.575
        lambda 2.5
        omega 0.75
        normal_map {
                [0.0    agate 0.1 scale 0.75 agate_turb 0.6]
                [0.1    agate 0.1 scale 0.75 agate_turb 0.6]
                [0.2    wrinkles 0.1 scale 0.15 turbulence 0.6]
                [0.956  wrinkles 0.05 scale 0.15 turbulence 0.6]
                [0.975  agate 0.1 scale 0.75 agate_turb 0.6]
                [1.0    agate 0.1 scale 0.75 agate_turb 0.6]

        }
}

#declare ldirt = 
texture {
        pigment {
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.8   rgbt 1]
                        [0.8   rgbt Gat (<0.5,0.34,0.25,1>)]
                        [0.925 rgbt Gat (<0.25,0.2,0.15,0.8>)]
                        [1.0   rgbt Gat (<0.5,0.34,0.25,1>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.81 reflection {0.001,0.01 fresnel on}}
}

#declare dirt = 
texture {
        pigment {
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.75  rgbt 1]
                        [0.75  rgbt Gat (<0.5,0.34,0.25,1>)]
                        [0.9   rgbt Gat (<0.25,0.2,0.15,0.5>)]
                        [1.0   rgbt Gat (<0.5,0.34,0.25,1>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.81 reflection {0.001,0.01 fresnel on}}
}

#declare vdirt = 
texture {
        pigment {
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.55  rgbt 1]
                        [0.55  rgbt Gat (<0.25,0.14,0.09,1>)]
                        [0.9   rgbt Gat (<0.08,0.06,0.045,0.125>)]
                        [1.0   rgbt Gat (<0.25,0.14,0.09,0.45>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001 }
        finish {diffuse albedo 0.75 reflection {0.001,0.005 fresnel on}}
}

#declare lampBaseTex = 
texture {
        pigment {rgb Ga (<0.3,0.025,0.003>)}
        finish {
                specular albedo 0.1 
                roughness 0.01 
                diffuse albedo 0.75 
                reflection {0.01,0.05 fresnel on}
        }
        normal {lampBaseNormal scale 0.5}
}
texture {
        pigment {
                bozo
                turbulence 0.456
                omega 0.8
                lambda 2
                octaves 8
                color_map {
                        [0     rgbt 1]
                        [0.3   rgbt 1]
                        [0.3   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.4   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.5   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.6   rgbt Gat (<0.45,0.2,0.07,0.985>)]
                        [0.7   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.8   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.9   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [1.0   rgbt Gat (<0.45,0.2,0.07,0.96>)]
                }
                scale <0.075,0.15,0.075>
        }
        finish {
                specular albedo 0.1 
                roughness 0.01 
                diffuse albedo 0.875 
                reflection {0.01,0.025 fresnel on}
        }
        normal {
                average 
                normal_map {
                        [1      lampBaseNormal scale 0.5]
                        [1      granite 0.8 scale 0.05]
                }
       }
}
texture {ldirt}

#declare lampBaseTexDirt = 
texture {lampBaseTex}
texture {dirt}

#declare lampBaseTexVDirt = 
texture {lampBaseTex}
texture {vdirt}

#declare lampBubblePaint =
texture {
        pigment {
                gradient x 
                turbulence 0.73 
                omega 0.4 
                color_map {
                        [0     rgb Ga (<0.3,0.025,0.003>)]
                        [0.6   rgb Ga (<0.3,0.025,0.003>)]
                        [0.7   rgb Ga (<0.325,0.06,0.01>)]
                        [0.8   rgb Ga (<0.325,0.06,0.01>)]
                        [1.0   rgb Ga (<0.3,0.025,0.003>)]
                }
                scale <0.01,0.1,0.02>
        }
        finish {specular albedo 0.1 roughness 0.01 diffuse albedo 0.75 reflection {0.01,0.05 fresnel on}}
        normal {crackle 3 turbulence 0.5 scale 0.025}
}
texture {
        pigment {
                bozo
                turbulence 0.456
                omega 0.8
                lambda 2
                octaves 8
                color_map {
                        [0     rgbt 1]
                        [0.3   rgbt 1]
                        [0.3   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.4   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.5   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.6   rgbt Gat (<0.45,0.2,0.07,0.985>)]
                        [0.7   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.8   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.9   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [1.0   rgbt Gat (<0.45,0.2,0.07,0.96>)]
                }
                scale <0.075, 0.15, 0.075>
        }
        finish {specular albedo 0.1 roughness 0.01 diffuse albedo 0.875 reflection {0.01,0.025 fresnel on}}
        normal {crackle 3 turbulence 0.5 scale 0.03}
}

#declare lampBubblePaintDirt = 
texture {lampBubblePaint}
texture {dirt}

#declare lampBubblePaintVDirt = 
texture {lampBubblePaint}
texture {vdirt}

#declare lampRust =
texture {
        pigment {
                granite 
                turbulence 0.35 
                omega 0.7 
                lambda 2.2
                color_map {
                        [0.0   rgb Ga (<0.015,0.0045,0>)]
                        [0.3   rgb Ga (<0.05,0.0175,0.00075>)]
                        [1.0   rgb Ga (<0.03,0.009,0.002>)]
                }
                scale 0.2
        }
        finish {specular albedo 0.1*0.5 roughness 0.01 brilliance 5 diffuse albedo 0.575}
        normal {granite 0.12*-24 turbulence 0.35 scale 0.05}
}

#declare  lampRustDirt = 
texture {lampRust}
texture {dirt}

#declare  lampRustVDirt = 
texture {lampRust}
texture {vdirt}

#declare  lampRustLDirt = 
texture {lampRust}
texture {ldirt}

#declare lampPaintRust = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTex scale 4]
                [0.6   lampBaseTex scale 4]
                [0.625 lampBubblePaint scale 2]
                [0.675 lampBubblePaint scale 2]
                [0.7   lampRust scale 3]
                [1.0   lampRust scale 3]
        }
        scale 0.25*0.3
}

#declare lampPaintRustDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexDirt scale 4]
                [0.6   lampBaseTexDirt scale 4]
                [0.625 lampBubblePaintDirt scale 2]
                [0.675 lampBubblePaintDirt scale 2]
                [0.7   lampRustDirt scale 3]
                [1.0   lampRustDirt scale 3]
        }
        scale 0.25*0.3
}

#declare lampPaintRustVDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexVDirt scale 4]
                [0.6   lampBaseTexVDirt scale 4]
                [0.625 lampBubblePaintVDirt scale 2]
                [0.675 lampBubblePaintVDirt scale 2]
                [0.7   lampRustVDirt scale 3] // was VDirt
                [1.0   lampRustVDirt scale 3] // was VDirt
        }
        scale 0.25*0.3
}

#declare lampPaintRustLDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexDirt scale 4]
                [0.6   lampBaseTexDirt scale 4]
                [0.625 lampBubblePaintDirt scale 2]
                [0.675 lampBubblePaintDirt scale 2]
                [0.7   lampRustLDirt scale 3]
                [1.0   lampRustLDirt scale 3]
        }
        scale 0.25*0.3
}               

#declare T1 =
material {
        texture {
                gradient y 
                turbulence 0.025
                texture_map {
                        [0.0   lampRust]
                        [0.025 lampPaintRustVDirt]     //VDirt
                        [0.15  lampPaintRustDirt]      //Dirt
                        [1.0   lampPaintRustDirt]      //Dirt
                }
                scale 3.2
                translate <0,-0.25,0>
        }
        scale 2.07
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 35) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  gt_chess  http://www.oyonale.com/downloads/chess.zip  

#declare C_Stone0 = rgb 0.6*<98,80,50>/255*3;
#declare C_Stone1 = rgb 0.2*<206,184,158>/255*3;
#declare C_Stone2 = rgb 0.2*<227,208,184>/255*3;
#declare C_Moss = rgb 0.2*<128,127,144>/255*3;

#declare T_Tower2 =
texture {
        pigment {
                pigment_pattern{
                        gradient y
                        turbulence 1
                        color_map {
                                [0 White]
                                [1 Black]
                        }
                        scale 0.2
                }                
                pigment_map {
                        [0      slope y
                                pigment_map {
                                        [0      bozo 
                                                turbulence 1 
                                                lambda 3 
                                                color_map {
                                                        [0.3 C_Stone0]
                                                        [0.6 C_Stone0*2] 
                                                }
                                                scale 0.025
                                        ]
                                        [0.5    bozo 
                                                turbulence 1 
                                                lambda 3 
                                                color_map {
                                                        [0.3 C_Stone0]
                                                        [0.6 C_Stone0*2] 
                                                }
                                                scale 0.05
                                        ]
                                        [0.6    color C_Moss*0.3]
                                }
                        ]                    
                        [1      slope y
                                pigment_map {
                                        [0      bozo 
                                                turbulence 1 
                                                lambda 3 
                                                color_map {
                                                        [0.3 C_Stone1]
                                                        [0.6 C_Stone2*2] 
                                                }
                                                scale 0.025
                                        ]
                                        [0.4    bozo 
                                                turbulence 1 
                                                lambda 3 
                                                color_map {
                                                        [0.3 C_Stone2]
                                                        [0.6 C_Stone0*2] 
                                                }
                                                scale 0.05
                                        ]
                                        [0.5    color C_Moss*0.3]
                                }
                        ]
                }                                        
        }
        normal {bumps 1 turbulence 1 scale 0.01} 
        finish {ambient 0 diffuse 1}
}

#declare T1 =
material {
        texture {T_Tower2}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 36) /////////////////////////////////////////////////////////////////////////////////////

// Kari Kivisalo Rust & paint  http://news.povray.org/povray.binaries.scene-files/message/%3C3B141966.1B97D3E1%40x.x%3E/#%3C3B141966.1B97D3E1%40x.x%3E

#declare rf = 0.5;

#declare Paint = 
texture {
        pigment {rgb Ga (<0.1,0.8,1>)}
        finish {diffuse 0.6*0.8 ambient 0 brilliance 1.2 specular 0.5 roughness 0.01}
        normal {
                pigment_pattern {
                        granite scale 25
                        warp {turbulence 0.2 octaves 6 omega 0.8}
                } 
                normal_map {
                        [rf-0.10 bumps  0.05 scale 0.025*3]
                        [rf-0.05*1.5 crackle 1.5*2 turbulence 0.5 scale 0.035*3]
                        [rf-0.01*2 crackle 3.0*2 turbulence 0.5 scale 0.060*3]
                }
        }
}
    
#declare Rust1 =
texture {
        pigment {rgb Ga (<1,0.3,0.1>)}
        finish {diffuse 0.5*1.8 ambient 0 brilliance 1 crand 0.01}
        normal {crackle -1.4 scale 0.0225}
}
texture {
        pigment {
                granite scale 25 
                turbulence 0.6 
                color_map {
                        [0 rgbf Gat (<1,1,0.2,1>)]
                        [1 rgbf Gat (<0.2,1,0.2,0.4>)]
                }
        }
        finish {ambient 0 diffuse 0}
        scale 0.04
}
        
#declare Rust2 =
texture {
        pigment {rgb Ga (<1,0.2,0.1>)}
        finish {diffuse 0.2*1.8 ambient 0 brilliance 1 crand 0.05} 
        normal {
                average
                normal_map {
                        [1 bozo 10 scale 0.0225]
                        [1 granite 1 scale 0.00225]
                }
        }
}
texture {
        pigment {
                granite scale 25 
                turbulence 0.6 
                color_map {
                        [0 rgbt Gat (<1,1,0.2,1>)]
                        [1 rgb   Ga (<0.2,1,0.2>)]
                }
        }
        finish {ambient 0 diffuse 0}
        scale 0.02
}
        
#declare T1 =
material {
        texture {
                pigment_pattern {
                        granite scale 25
                        warp {turbulence 0.2 octaves 6 omega 0.8}
                }
                texture_map {
                        [rf        Paint]
                        [rf        Rust2]
                        [rf+0.0075 Rust2]
                        [rf+0.015  Rust1]
                        [rf+0.1    Rust2]
                }                  
        }
        scale 0.1
        interior {ior 1.54}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 37) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  13 Spiral Spheres  http://images.povcomp.com/entries/extras/148/148_source.zip

#declare T1 =
material {
        texture {
                pigment {
                        crackle 
                        poly_wave 0.1 
                        turbulence 0.1 
                        color_map {
                                [0      rgb 0]
                                [1      rgb <0,153,147>/255]
                        }
                } 
                normal {
                        average 
                        normal_map {
                                [1      granite 0.1] 
                                [1      crackle 1.2
                                        poly_wave 0.05 
                                        turbulence 0.1
                                ]
                        }
                }
                finish {
                        ambient 0 
                        diffuse 0.5 
                        specular 0.7 
                        roughness 0.01 
                        phong 1 
                        brilliance 5 
                        reflection {0.2,1 fresnel on}
                }
        }
        scale 0.5
        interior {ior 1.54}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 38) /////////////////////////////////////////////////////////////////////////////////////

// adaption of Alex Kluchikov  curles  http://203.29.75.35/povray.binaries.scene-files/thread/%3C1103_1063491393@news.povray.org%3E/?ttop=384061&toff=550

#declare frad_ = function {pattern {radial}}
#declare fboz1 = function {pattern {crackle form <1,0,0> scale 1}}
 
#declare f1 =
function(x,y,z) {
        (sin (fboz1 (x,y,z)*24*pi
        + frad_ (fboz1 (x,y,z)-fboz1 (x,y-0.07,z),0,fboz1 (x,y,z)-fboz1 (x+0.07,y,z))*2*pi
        //+clock*pi*2 // uncomment to animate
        )+1)*0.5*(1-fboz1 (x,y,z))
}

#declare chps2 =
pigment {
        function {f1 (x,y,z)}
        turbulence 0.1
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.8/pi
}

#declare st2 =
texture {
        pigment {rgb <0.55,0.2,0.35>}
        finish {
                diffuse 0.425*0.85 ambient 0
                specular 1 roughness 0.01
                phong 2.0 phong_size 300
                brilliance 7.3 
                metallic 0.6
                reflection {0.6,1.0 metallic}
        }
}

#declare plastic2 =
texture {
        pigment {rgb <1,1,0.9>}
        finish {
                diffuse 0.47*0.85 ambient 0 
                phong 3 phong_size 2000 
                specular 0.3 roughness 0.015 
                reflection {0.2,0.4 metallic}
        }
}

#declare parf02 =
pigment {
        average 
        pigment_map {
                #declare i = 0;
                #while (i < 1)
                        [pow (0.5,i*0.25),  
                                chps2 
                                translate i*0.5 
                                rotate y*i*45 
                                scale pow (0.5,i*0.5)
                        ]
                        #declare i = i+1;
                #end
        }
        scale 2
        translate 100
}

#declare terracotta2 =
texture {
        pigment {rgb <0.2,0.35,0.55>}
        finish {diffuse 0.65*0.85 phong 0.1}        
        normal {
                average 
                normal_map {
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.02 
                                noise_generator 3 
                                slope_map {
                                        [5,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.015 
                                noise_generator 3 
                                slope_map {
                                        [5,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 2 
                                rotate 60 
                                scale 0.06 
                                noise_generator 3
                        ]
                }
                scale 0.75
        }
}

#declare parf2 = function {pigment {parf02}} 

#declare parfn2 = 
normal {
        function {parf2 (x,y,z).x} 1
        slope_map {
                [0,<1,1>]
                [0.4,<0,-1>]
                [0.6,<0,1>]
                [1,<1,-1>]
        }
}

#declare T1 = //curles2
material {
        texture {
                function {parf2 (x,y,z).x}
                texture_map {
                        [0.0,   st2      normal {parfn2}]
                        [0.3,   plastic2 normal {parfn2}]
                        [0.7,   terracotta2]
                        [1.0,   plastic2 normal {parfn2}]
                }
        }
        scale 0.5
        interior {ior 2.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 39) /////////////////////////////////////////////////////////////////////////////////////

// Zeger Knaepen  POV 3.7 metals.inc; post your textures here   http://news.povray.org/povray.binaries.images/message/%3C49cffa41%40news.povray.org%3E/#%3C49cffa41%40news.povray.org%3E

#local T1 = 
material {
        texture {
                pigment {
                        crackle solid 
                        scale 0.1
                        color_map {
                                [0 rgb 0.5]
                                [1 rgb 0.9]
                        }
                }
                normal {granite -0.03}
                finish {
                        ambient 0 
                        diffuse 1 
                        brilliance 3 
                        specular 1 
                        roughness 0.01 
                        metallic 
                        reflection {0,0.125 fresnel on metallic 1}
                }
                scale 0.5
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 40) /////////////////////////////////////////////////////////////////////////////////////

// ?

#declare Hexcolor = array[3] {LightWood,Flesh,Tan} 

#declare T1 = 
material {
        texture {
                pigment {
                        hexagon 
                        color Hexcolor[0] 
                        color Hexcolor[1] 
                        color Hexcolor[2]
                        turbulence 4 lambda 4 omega 0.5 octaves 5
                }     
        }
        texture {
                pigment {
                        hexagon
                        pigment {color Hexcolor[0] transmit 0.5}
                        pigment {color Hexcolor[1] transmit 0.5}
                        pigment {color Hexcolor[2] transmit 0.5}
                        turbulence 4 lambda 4 omega 0.5 octaves 5
                        scale 1/3
                }      
        }
        texture {
                pigment {
                        hexagon
                        pigment {color Hexcolor[0] transmit 0.67}
                        pigment {color Hexcolor[1] transmit 0.67}
                        pigment {color Hexcolor[2] transmit 0.67}
                        turbulence 4 lambda 4 omega 0.5 octaves 5
                        scale 1/9
                }
                normal {
                        average
                        normal_map {
                                #declare normalcount = 1;
                                #while (normalcount < 15)
                                        [1      crackle 10 turbulence 1 scale 2/normalcount]
                                        #declare normalcount = normalcount+1;
                                #end
                                [1      hexagon 10 turbulence 4 lambda 4 omega 0.5 octaves 5]
                                [1      hexagon 10 turbulence 4 lambda 4 omega 0.5 octaves 5 scale 1/3]
                                [1      hexagon 10 turbulence 4 lambda 4 omega 0.5 octaves 5 scale 1/9]
                        }  
                        scale 0.1 
                }
                finish {
                        ambient 0
                        specular 0.5 
                        roughness 0.003 
                        diffuse 0.5 
                        reflection {0.1,0.2 fresnel on}
                        conserve_energy 
                }
        }
        interior {ior 1.5}
        scale 0.15
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 41) /////////////////////////////////////////////////////////////////////////////////////

// ?
        
#declare T1 =
material {
        texture {
                average 
                texture_map {
                        [0.3    pigment {rgbt <0.9,0.9, 9,0.8>}
                                finish {
                                        phong 2.9
                                        phong_size 200
                                        specular 2
                                        roughness 0.005
                                }
                        ]                        
                        [0.8    pigment {rgb <0.2,0,0.2>}
                                finish {
                                        phong 2
                                        phong_size 5
                                        roughness 0.05
                                        specular 2
                                        metallic 0.9
                                        reflection 0.3
                                }
                                normal {
                                        facets coords 1 
                                        scale 0.015
                                }
                        ]

                
                }
        }
        interior {ior 1.54}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 42) /////////////////////////////////////////////////////////////////////////////////////

// helge h  metal thing  http://news.povray.org/povray.binaries.images/message/%3Cweb.4404509e56098cd61c6902970%40news.povray.org%3E/#%3Cweb.4404509e56098cd61c6902970%40news.povray.org%3E

#macro _shinyness (_g1)
finish {
        ambient 0
        diffuse min (1,(1.65-_g1))
        specular _g1
        roughness pow (500,-_g1)
        reflection {0.5*max (0,_g1-0.65),2*max(0,_g1-0.65)}
}
#end

// metal finish:

#macro _metal (_g1)
finish {
        ambient 0
        diffuse 1-_g1
        specular _g1*2
        roughness pow (250,-_g1)
        metallic
        reflection {_g1/2,_g1 metallic}
}
#end

#local Brass_color = rgb <0.7,0.612,0.35>*0.9;

#local Bump0 = 
normal {
        granite
        scale 5
        bump_size -0.3
        slope_map {
                [0.0, <0, 1>]
                [0.3, <1, 0>]
                [1.0, <1, 0>]
        }
}
#local Bump1 = normal {bumps scale 0.25 bump_size 0.3}
#local Bump2 = normal {bumps scale 5 bump_size 0.3}

#local CastMetal_normal = 
normal {
        average 
        normal_map {
                [1 Bump0]
                [1 Bump1]
                [1 Bump2]
        }
}

#local T1 = 
material {
        texture {
                pigment {Brass_color}
                normal {CastMetal_normal}
                _metal (0.4)
        }
        interior {ior 2}
        scale 0.05
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 43) /////////////////////////////////////////////////////////////////////////////////////

// Shogun  Quad Revised  http://images.povcomp.com/entries/extras/175/quad.zip

#local T1 = 
material {
        texture {
                pigment {
                        rgb <0.78,0.7733,0.73>
                }
                normal {
                        dents 0.5
                        scale <2,0.002,0.002>
                }    
                finish {
                        metallic
                        ambient 0
                        diffuse 0.5
                        specular 0.5
                        roughness 0.01
                        reflection {0,0.5 fresnel on}
                        conserve_energy
                        brilliance 0.2*10
                }
        }
        interior {ior 1.43}
        scale 1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 44) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern influenced by Shogun  Quad Revised  http://images.povcomp.com/entries/extras/175/quad.zip

#local T1 = 
material {
        texture {
                pigment {rgb 1 }
                normal {
                        average 
                        normal_map {
                                [1      gradient y 
                                        slope_map {
                                                [0.0, 0]  
                                                [0.5, 1]
                                                [1.0, 0] 
                                        }
                                        frequency 10   
                                        bump_size 3
                                        warp {repeat x}
                                        warp {repeat z}
                                ]    
                                [1      gradient y 
                                        slope_map {
                                                [0.0, 0]  
                                                [0.5, 1]
                                                [1.0, 0] 
                                        }
                                        frequency 10   
                                        rotate <90,0,0>
                                        bump_size 3
                                        warp {repeat x}
                                        warp {repeat y}
                                ]    
                                [1      gradient y 
                                        slope_map {
                                                [0.0, 0]  
                                                [0.5, 1]
                                                [1.0, 0] 
                                        }
                                        frequency 10   
                                        rotate <90,90,0>
                                        bump_size 3
                                        warp {repeat z}
                                        warp {repeat y}
                                ]
                        }
                }                
                finish {
                        metallic
                        ambient 0
                        diffuse 0.25
                        specular 0.5
                        roughness 0.001
                        phong 1
                        phong_size 30
                        reflection {0.2,1 fresnel on metallic}
                        conserve_energy
                        brilliance 3
                        irid {1 thickness 0.75}
                }
        }
        scale 1
        interior {ior 1.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

//#if (mat = 45) /////////////////////////////////////////////////////////////////////////////////////

// Ive  POV 3.7 metals.inc; post your textures here  http://news.povray.org/povray.binaries.images/message/%3C49d21bbf%40news.povray.org%3E/#%3C49d21bbf%40news.povray.org%3E
//                                                   http://news.povray.org/povray.binaries.images/message/%3C49d25dc8%241%40news.povray.org%3E/#%3C49d25dc8%241%40news.povray.org%3E 

// some micro normals

#declare P_Micro1 = 
pigment {
        granite turbulence 0
        color_map {
                [0.0 rgb 0.3]
                [1.0 rgb 0.7]
        }
        scale 0.003
}

#declare P_Micro2 = 
pigment {
        onion turbulence 0.5
        color_map {
                [0.0  rgb 1.00]
                [0.45 rgb 0.99]
                [0.55 rgb 0.96]
                [1.0  rgb 0.95]
        }
        scale 0.01
}

#declare P_Macro1 = 
pigment {
        crackle turbulence 1
        color_map {
                [0.00 rgb 0.3]
                [0.01 rgb 0.3]
                [0.02 rgb 0.7]
                [1.00 rgb 0.7]
        }
        scale 0.3
}

// "micro"-normals for blurred reflection - to get some highlights
#macro P_Polish (Polish)

pigment_pattern {
        average
        pigment_map {
                [1 P_Micro1 translate x*20]
                [1 P_Micro1 translate y*20]
                [1 P_Micro1 translate z*20]
                [1 P_Micro2 translate -x*20]
                [1 P_Micro2 translate -y*20]
                [1 P_Micro2 translate -z*20]
        }
}
1-Polish

#end

// "macro"-normals for scratches and dents
#macro P_Dents (Dents)

pigment_pattern {
        average
        pigment_map {
                [1 P_Macro1 translate y*10]
                [1 P_Macro1 translate z*10]
        }
}
Dents

#end

// averaged normals
#macro N_Pattern (Polish,Dents)

normal {
        average
        normal_map {
                [1 P_Polish (Polish)]
                [1 P_Dents (Dents)]
        }
        scale 0.25
}

#end

//******************************************************

// MATERIAL MACROS

#macro MaterialSilver (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.9284,0.9016,0.8678>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.9001
                        specular 0 brilliance 3
                        reflection {0.5,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 3.64}
}

#end 

#macro MaterialGold (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.9927, 0.6952, 0.3302>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.7280
                        specular 0  brilliance 3
                        reflection {0.4,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 2.83}
}

#end

#macro MaterialCopper (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.7802, 0.2985, 0.1078>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.3832
                        specular 0  brilliance 2.4
                        reflection {0.2,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 3.26}
}

#end

#macro MaterialBronze (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.5568, 0.3484, 0.1528>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.3768
                        specular 0  brilliance 2
                        reflection {0.1,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 3.1}
}

#end

#macro MaterialBrass (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.5709, 0.3356, 0.1491>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.3702
                        specular 0  brilliance 3
                        reflection {0.1,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 8.0}
}

#end

#macro MaterialSteel (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.4412, 0.4137, 0.3727>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.4163
                        specular 0  brilliance 2.8
                        reflection {0,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 8.6}
}

#end

#macro MaterialChrome (Polish,Dents)

material {
        texture {
                pigment {rgb Ga (<0.9310, 0.9265, 0.9221>)}
                N_Pattern (Polish,Dents)
                finish {
                        ambient 0  diffuse 1-0.9642
                        specular 0 brilliance 3
                        reflection {0,1 fresnel on metallic}
                        conserve_energy
                }
        }
        interior {ior 15}
}

#end                               

//******************************************************

#if (mat = 45)

#local T1 = MaterialSilver (0.4,0.6)

#end

#if (mat = 46)

#local T1 = MaterialGold (0.6,0.4)

#end

#if (mat = 47)

#local T1 = MaterialCopper (0.5,0.5)
#end


#if (mat = 48)

#local T1 = MaterialBronze (0.5,0.6)

#end

#if (mat = 49)

#local T1 = MaterialBrass (0.5,0.7)

#end

#if (mat = 50)

#local T1 = MaterialSteel (0.7,0.7)

#end

#if (mat = 51)

#local T1 = MaterialChrome (0.3,0.3)
#end

//#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 52) /////////////////////////////////////////////////////////////////////////////////////

// Tsutomu Higo  lphvevnn  http://cyberbusts.main.jp/pov/pov43/lphvevnn.txt

#local T1 = 
material {
        texture {
                pigment {rgb <0.2,0.7,0.5>}
                finish {
                        reflection {0.6,1 fresnel on}
                        conserve_energy                        
                        ambient 0 
                        phong 1 
                        diffuse 0.5*0.5 
                        brilliance 1
                }
                normal {
                        ripples 1 
                        
                        frequency 15 
                        //translate <-300,0,1000>
                }
        }
        scale 0.26
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 53) /////////////////////////////////////////////////////////////////////////////////////

// Mike Sobers  coarse grain paper  http://news.povray.org/povray.newusers/message/%3Cweb.45e7112ef61581391009749b0%40news.povray.org%3E/#%3Cweb.45e7112ef61581391009749b0%40news.povray.org%3E 

#local T1 = 
material {
        texture {
                pigment {
                        granite
                        color_map {
                                [0    rgb <1,0.98,0.95>]
                                [0.2  rgb <1,0.98,0.95>]
                                [0.21 rgb <1,0.96,0.83>]
                                [0.3  rgb <1,0.96,0.83>]
                                [0.40 rgb <1,0.98,0.95>]    
                                [0.50 rgb <1,0.98,0.95>]
                                [0.51 rgb <0.77,0.54,0.33>]
                                [0.6  rgb <0.77,0.54,0.33>]
                                [0.61 rgb <1,0.96,0.83>]
                                [0.9  rgb <1,0.96,0.83>]
                                [0.91 rgb <0.77,0.54,0.33>]
                                [1    rgb <0.77,0.54,0.33>]
                        }
                        scale 0.5
                }
        }
        texture {
                pigment {rgbt <1,0.96,0.83,0.1>}
                normal {dents 1 turbulence 1.7 scale 0.01} //leopard
        }
        interior {ior 1.5}
        scale 0.3
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 54) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  more blended cells (improved code)  http://news.povray.org/povray.binaries.scene-files/attachment/%3C45e320b3%241%40news.povray.org%3E/blendedcells-1.pov.txt?ttop=391298&toff=200

#macro vpow (V,P) <pow (V.x,P),pow (V.y,P),pow (V.z,P)> #end

#macro bits (a,p,n) //convert a series of bits to an integer, (a>>p)&((1<<n)-1)

mod (int (a/pow (2,p)),pow (2,n))

#end

#macro pickcolour (n)

//n = 0 to 15
rgb vpow (<bits (n,0,1),bits (n,1,2)/3,bits (n,3,1)>,2.2/a_g) //vpow compensates for gamma 

#end

//my pattern, each unit square must use a different colour

#declare mycells_p =
pigment {
	//this is the cells-based patten we want to blur
	pigment_pattern {
		checker
			pigment {rgb 0}, //gaps between the cells, when sliced at the correct angle they look like hexagons with triangular gaps between, which look like circles when blurred
			pigment {cells}
	}
	color_map {
		//pick the most visually distinct colors I can
		#local f = 0;
		#while ( f <= 16 )
			#local col = pickcolour(f);
			[f/16,(f+1)/16 color col color col]
			#local f = f+1;
		#end
	}
}

//macro version of the pattern, offset the unit squares pattern (done in a macro in case I want cells picking patterns)

#macro mycells (Offset)  

mycells_p
translate Offset+0.001 //cells don't quite line up with the blend gradient, but 0.001 completely fixes it!!! I'm a bit freaked out by that 

#end

//blur the pattern

#declare blurriness = 1;

#macro blend (V)

pigment_pattern {
	//gradient controlling the blend
	gradient V
	//phase 0.001 //cells and gradient don't quite line up, but this completely fixes it!!! I'm a bit freaked out by that
	//mess with this colour map to reduce blend region		
	color_map {
		[0.5-blurriness/2 rgb 0]
		[0.5+blurriness/2 rgb 1]
	}
}
cubic_wave

#end

#declare blendedcells =
pigment {
	blend (x)
	pigment_map {
		[0
			blend (y)
			pigment_map {
				[0
					blend (z)
					pigment_map {
						[0 mycells(<1,1,1>)]
						[1 mycells(<1,1,0>)]
					}
				]
				[1
					blend (z)
					pigment_map {
						[0 mycells(<1,0,1>)]
						[1 mycells(<1,0,0>)]
					}
				]
			}
		]
		[1
			blend (y)
			pigment_map {
				[0
					blend (z)
					pigment_map {
						[0 mycells(<0,1,1>)]
						[1 mycells(<0,1,0>)]
					}
				]
				[1
					blend (z)
					pigment_map {
						[0 mycells(<0,0,1>)]
						[1 mycells(<0,0,0>)]
					}
				]
			}
		]
	}
}

#declare T1 =
material {
        texture {
	        pigment {
                        blendedcells 
                        Reorient_Trans (<1,1,1>,z) 
                        scale 0.25
                }
	        finish {
                        ambient 0 
                        diffuse albedo 0.7 
                        specular albedo 0.3 
                        roughness 0.01 
                        metallic 
                        reflection {0.3, 0.5 fresnel on metallic} 
                        conserve_energy
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 55) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  cart_pov T_metal  http://www.oyonale.com/downloads/cart_pov.zip

#declare T_Shiny =
texture {
        pigment {rgb 0.2} 
        finish {
                ambient 0 
                diffuse 0.6 
                //metallic 
                brilliance 4 
                specular 1 
                roughness 0.02 
                reflection {0.8-0.6,1 fresnel on}
                conserve_energy
        }
}
    
#declare T_Rusty =
texture {
        pigment {
                bozo 
                turbulence 1 
                color_map {
                        [0.3 DarkWood*0.64]
                        [0.5 DarkBrown*0.64]
                }
        } 
        normal {
                crackle 
                turbulence 1 
                lambda 4 
                bump_size -2 
                scale 0.01
        }
        finish {
                ambient 0 
                diffuse 1 
                specular 0.01 
                roughness 0.1
        }
} 

#declare T1 = 
material {
        texture {
                bozo 
                turbulence 1 
                lambda 4
                translate 0.5
                texture_map {
                        [0.55 T_Shiny]
                        [0.60 T_Rusty]
                }
        }
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 56) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  12 Catenoids  http://www.irtc.org/ftp/pub/stills/2005-08-31/12_caten.zip

#declare T1 =
material {
        texture {
                pigment {rgb 0.2}
                normal {
                        bozo
                        scale 0.2
                        normal_map {
                                [0.00 dents 0.05 scale 0.01]
                                [0.15 dents 0.05 scale 0.001]
                                [0.30 dents 300  scale 0.0005]
                                [0.45 dents 0.02 scale 0.01]
                                [0.50 bumps 0.07 scale 0.01]
                                [1.00 dents 0.05 scale 0.005]
                        }
                } 
                finish {
                        ambient 0
                        brilliance 5
                        diffuse 0.6
                        metallic
                        specular 0.8
                        roughness 0.01
                        reflection {0.65-0.3,0.65+0.3 fresnel on}
                        conserve_energy
                } 
        }
        scale 0.3
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 57) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  12 Catenoids  http://www.irtc.org/ftp/pub/stills/2005-08-31/12_caten.zip

#declare T1 =
material {
        texture {
                pigment {
                        wood 
                        color_map {
                                [0.00 rgb <0.8431, 0.5961, 0.3020>*0.75]
                                [0.10 rgb <0.8627, 0.6275, 0.3451>*0.75]
                                [0.20 rgb <0.8980, 0.6784, 0.4196>*0.75]
                                [0.30 rgb <0.8980, 0.6784, 0.4314>*0.75]
                                [0.40 rgb <0.8980, 0.6824, 0.4275>*0.75]
                                [0.50 rgb <0.8941, 0.6902, 0.4314>*0.75]
                                [0.55 rgb <0.6500, 0.4000, 0.2000>*0.75]
                                [0.60 rgb <0.9059, 0.7059, 0.4471>*0.75]
                                [0.70 rgb <0.8941, 0.7059, 0.4627>*0.75]
                                [0.80 rgb <0.9059, 0.7294, 0.4941>*0.75]
                                [0.90 rgb <0.8980, 0.7059, 0.4706>*0.75]
                                [1.00 rgb <0.9098, 0.7294, 0.4980>*0.75]
                        }                      
                        turbulence 0.5
                        scale <1,1,20>
                }
                finish {
                        diffuse 0.95
                        brilliance 1.2
                        specular 0.2
                        roughness 0.2
                }
        }
        texture {
                normal {
                        average 
                        normal_map {
                                [1 bumps 0.4*2 scale <0.1,0.1,1>]
                                [1 dents 1*2 scale 0.1]
                        }
                        scale 0.125
                }
                pigment {
                        bozo 
                        color_map {
                                [0.0 rgb 0 transmit 0.75]
                                [0.5 rgbt 1]
                        }
                        warp {turbulence 2}
                        rotate z*90
                        scale 0.1           
                }
        }
        scale 0.2
        rotate x*90
        interior {ior 1.45}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 58) /////////////////////////////////////////////////////////////////////////////////////

// Tor Olav Kristensen  Squirted pigments  http://news.povray.org/povray.text.scene-files/thread/%3C3BB3BBA6.388C46C3%40hotmail.com%3E/

#declare CrackleFn =            function {pattern {crackle metric 2}}
#declare ScaledCrackleFn =      function (x,y,z,S) {CrackleFn (x/S,y/S,z/S)}
#declare NoiseFn =              function {0.1+4*f_noise3d (x,y,z)}
#declare NoisyScaledCrackleFn = function (x,y,z,Xo,Yo,Zo) {ScaledCrackleFn (x,y,z,NoiseFn (x+Xo,y+Yo,z+Zo))}
#declare GreyFn =               function {NoisyScaledCrackleFn (x,y,z,0,0,0)*0.25+0.2}
#declare RedFn =                function {NoisyScaledCrackleFn (x,y,z,0.1,0,0)}
#declare GreenFn =              function {NoisyScaledCrackleFn (x,y,z,0,0.1,0)}
#declare BlueFn =               function {NoisyScaledCrackleFn (x,y,z,0,0,0.1)}
#declare NormalFn =             function {NoisyScaledCrackleFn (x,y,z,0,0,0)}

#declare GreyMap =
color_map {
        [0 rgbt <0,0,0,0/1>]
        [1 rgbt <3,3,3,0/1>]
}

#declare RedMap =
color_map {
        [0 rgbt <0,0,0,1/2>]
        [1 rgbt <3,0,0,1/2>]
}

#declare GreenMap =
color_map {
        [0 rgbt <0,0,0,2/3>]
        [1 rgbt <0,3,0,2/3>]
}

#declare BlueMap =
color_map {
        [0 rgbt <0,0,0,3/4>]
        [1 rgbt <0,0,3,3/4>]
}

#declare T1 =
material {
        texture {
                pigment {
                        function {GreyFn (x,y,z)}
                        color_map {GreyMap}
                }
                normal {function {NormalFn (x,y,z)}}
                finish {ambient 0 diffuse 1}
        }
        texture {
                pigment {
                        function {RedFn (x,y,z)}
                        color_map {RedMap}
                }
                normal {function {NormalFn (x,y,z)}}
                finish {ambient 0 diffuse 1}        
        }
        texture {
                pigment {
                        function {GreenFn (x,y,z)}
                        color_map {GreenMap}
                }
                normal {function {NormalFn (x,y,z)}}
                finish {ambient 0 diffuse 1}        
        }
        texture {
                pigment {
                        function {BlueFn (x,y,z)}
                        color_map {BlueMap}
                }
                normal {function {NormalFn (x,y,z)}}
                finish {ambient 0 diffuse 1}
        }
        scale 0.2               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 59) /////////////////////////////////////////////////////////////////////////////////////

// H. E. Day  drunkpat  http://www.irtc.org/ftp/pub/stills/2000-04-30/drunkpat.zip

#declare diff2 = 0.5;

#declare Scarring =
texture {
        pigment {
                bozo 
                color_map {
                        [0      rgb <0.175,0.175,0.175> transmit 0.75]
                        [1      rgb <0.175,0.175,0.175> transmit 1]
                }
                scale 2
        }
}
texture {
        pigment {
                bozo 
                pigment_map {
                        [0      bozo 
                                color_map {
                                        [0      rgb <0.125,0.125,0.125> transmit 0.75]
                                        [1      rgb <0.125,0.125,0.125> transmit 1]
                                }scale 0.125
                        ]
                        [0.5    rgb <0.175,0.175,0.175> transmit 1]
                }
                scale 2
        }
        translate 25
}

#declare Rusting2 =
texture {
        pigment {
                bozo 
                color_map {
                        [0      rgb <1,0.5-0.02,0.4-0.02> transmit 0.875]
                        [1      rgb <1,0.5,0.4> transmit 1]
                }
                scale 2
        }
}
texture {
        pigment {
                bozo 
                pigment_map {
                        [0      bozo 
                                color_map {
                                        [0      rgb <1,0.5-0.02,0.4-0.02> transmit 0.875]
                                        [1      rgb <1,0.5,0.4> transmit 1]
                                }
                                scale 0.125
                        ]
                        [0.5    rgb <0.175,0.175,0.175> transmit 1]
                }
                scale 2
        }
        translate 25
}

#declare Chipping =
texture {
        pigment {
                bozo 
                pigment_map {
                        [0.4    bozo 
                                color_map {
                                        [0.2    rgb 1 transmit 0.25]
                                        [0.3    rgb 1 transmit 1]
                                } 
                                turbulence 0.5 
                                scale 0.0625
                        ]
                        [0.5    rgb <0.175,0.175,0.175> transmit 1]
                }
                scale 8
        }
}

#declare Test =
function {
        pow (f_noise3d (x,y,z),0.3)
        *f_noise3d (x*5,y*5,z*5)
        *pow (f_noise3d (x*20,y*20,z*20),0.3)
}
 
#declare Test2 =
function {
        pow (f_noise3d (x,y,z),2)
        *f_noise3d (x*5,y*5,z*5)
        *pow (f_noise3d (x*20,y*20,z*20),0.3)
}

#declare rusted_metal1 =
texture {
        pigment {
                function {Test (x,y,z)} 
                triangle_wave
                pigment_map {
                        [0.7    bozo 
                                color_map {
                                        [0.4 rgb 1]
                                        [0.5 rgb <0.6,0.65,0.8>]
                                        [0.6 rgb <0.65,0.65,0.65>]
                                } 
                                turbulence 1 
                                scale 1/2
                        ]
                        [0.8    bozo 
                                color_map {
                                        [0 rgb <0.6,0.4-0.02,0.3-0.02>]
                                        [1 rgb <0.6,0.5-0.02,0.4-0.02>*1.5]
                                } 
                                scale 1/3
                        ]
                }
                scale 1.5
        }
        normal {
                function {Test2 (x,y,z)} 
                bump_size 1/3*1.3 
                scale 1/4
        } 
        finish {
                ambient 0 
                diffuse diff2 
                phong 1.5 
                metallic 
                phong_size 10 
                reflection {0.2, 0.5 falloff 5}
                brilliance 2
        }
}
texture {Scarring scale 1/16}
texture {Chipping scale 1/16}
texture {Scarring scale 1/16*<1,4,1>}
texture {Scarring scale 1/32}
texture {Rusting2 scale 1/5*<1,1,2>}

#declare T1 = 
material {
        texture {rusted_metal1 scale 0.25}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 60) /////////////////////////////////////////////////////////////////////////////////////

// Nathan O'Brien  13hystri  http://www.irtc.org/ftp/pub/stills/1999-04-30/13hystri.zip

#declare Normal1 = normal {granite 0.05 scale 0.4}
#declare Normal2 = normal {dents 0.2 scale 0.05}

#declare Skull_Tex1 =
texture{
	pigment {rgb <1,0.975,0.825>} 
	finish {phong 0.25 phong_size 10}  
	normal {
		average
		normal_map {
			[1 Normal1]
			[2 Normal2]
		}
	}
}

#declare Skull_Tex2 =
texture{
	pigment {rgb <0.9,0.8,0.6>} 
	finish {phong 0.25 phong_size 10}  
	normal {
		average
		normal_map {
			[1 Normal1 scale 0.8]
			[2 Normal2 scale 0.8]
		}
	}
}

#declare T1 =                        
material {                                              
        texture {
	        bozo
	        texture_map {
		        [0.0 Skull_Tex1 scale 2]
		        [1.0 Skull_Tex2 scale 2]
	        } 
	        scale 0.35
	        turbulence 0.4
        }                                                                     
        scale 0.15
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 61) /////////////////////////////////////////////////////////////////////////////////////

// Nathan O'Brien  13hystri  http://www.irtc.org/ftp/pub/stills/1999-04-30/13hystri.zip

#declare Normal1 = normal {granite 0.05*4 scale 0.4}
#declare Normal2 = normal {dents 0.2*4 scale 0.05}

#declare Skull_Tex1 =
texture{
	pigment {rgb <1,0.975,0.825>*0.7} 
	finish {phong 0.25 phong_size 10}  
	normal {
		average
		normal_map {
			[1 Normal1]
			[2 Normal2]
		}
	}
}

#declare Skull_Tex2 =
texture{
	pigment {rgb <0.9,0.8,0.6>*0.7} 
	finish {phong 0.25 phong_size 10}  
	normal {
		average
		normal_map {
			[1 Normal1 scale 0.8]
			[2 Normal2 scale 0.8]
		}
	}
}

#declare Wall_Tex2 =
texture {
	crackle
	texture_map {
		[0.0 Skull_Tex1 scale 0.1]
		[1.0 Skull_Tex2 scale 0.1]
	} 
	turbulence <0.4,0.7,0.4>
	scale 10
}

#declare Wall_Tex3 =
texture {
	crackle
	texture_map {
		[0.0 Wall_Tex2 scale 0.05]
		[1.0 Skull_Tex2 scale 0.05]
	} 
	turbulence <0.7,1,0.7>
	scale 20
}  

#declare T1 =                        
material {                                              
        texture {
        	bozo 
        	texture_map {
        		[0.0 Wall_Tex2 scale 2] 
        		[0.5 Wall_Tex2 scale 2]  
        		[0.7 Wall_Tex3 scale <1,2,1>]
        		[1.0 Wall_Tex3 scale <1,2,1>]
        	} 
        	scale 0.5
        	turbulence 0.5
        }                                                                     
        scale 0.15
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 62) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  12 Catenoids  http://www.irtc.org/ftp/pub/stills/2005-08-31/12_caten.zip

#declare T1 =
material {
        texture {
                pigment {
                        wood 
                        color_map {
                                [0.0 rgb <0.58,0.42,0.20>]
                                [0.5 rgb <0.65,0.50,0.25>]
                                [1.0 rgb <0.70,0.55,0.40>]
                        }        
                        turbulence 0.5
                        scale 3
                }
                normal {
                        average 
                        normal_map {
                                [1.0 bumps 0.24 scale <0.21,0.21,1>]
                                [0.5 dents 0.15 scale 0.1]
                        }
                        scale 0.125
                }
                finish {specular 0.75 reflection {0.1,0.5} metallic}
        }
        texture {
                normal {
                        average 
                        normal_map {
                                [1 bumps 0.4 scale <0.1,0.1,1>]
                                [1 dents 1 scale 0.1]
                        }
                        scale 0.125
                }
                pigment {
                        bozo 
                        color_map {
                                [0.0 rgb 0 transmit 0.5]
                                [0.5 rgbt 1]
                        }
                        scale 5
                        warp {turbulence 2}
                        scale 0.2
                }
        }
        scale 0.1
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 63) /////////////////////////////////////////////////////////////////////////////////////

// motorsep  rust  http://blenderartists.org/forum/showthread.php?65353-Povray-Materials-for-Blend2Pov

#declare S = 100;
        
#declare T1 =
material {
        texture {
                pigment {
                        wrinkles
                        color_map {
                                //[0.0      rgb <0.827451,0.400000,0.113725>]
                                [0.291815 rgb <0.705882,0.329412,0.141176>]
                                [0.569395 rgb <0.929412,0.490196,0.207843>]
                                //[0.761566 rgb <0.729412,0.462745,0.207843>]
                                [0.761566 rgb <0.874510,0.380392,0.082353>]
                                [0.857651 rgb <0.611765,0.470588,0.266667>]
                                [1.0      rgb <0.752941,0.447059,0.188235>]
                        }
                        turbulence <0.9931,0.4938,0.0195>*S
                        octaves 8
                        omega 0.7132
                        lambda 2.2602
                        frequency 0.7355
                        phase 1.22
                        poly_wave 1.013
                        warp {
                                turbulence <1.668,1.522,2.948>*S
                                octaves 10
                                omega 0.647
                                lambda 2.035
                        }
                }
                normal {
                        wrinkles, 1000
                        scale 0.5*S
                        normal_map {
                                [0.3    granite, 0.85 scale 0.2*S]
                                [1.0    bumps, 1.2 scale 0.7*S]
                        }
                        warp {
                                turbulence <1.668,1.522,2.948>*S
                                octaves 10
                                omega 0.647
                                lambda 2.035
                        }
                }
                finish {
                        ambient 0
                        diffuse 0.4
                        specular 0.1
                        roughness 0.5
                        crand 0.015
                }
        } 
        scale 0.07
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 64) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia  spider  http://www.math.harvard.edu/~knill/teaching/math21a2001/17-chain/spider.pov (sorry, didn't found original web link)

#declare diff = 0.8;

#declare t_metal = 
texture {
        wrinkles 
        scale 0.1 
        texture_map {
                [0      pigment {rgb <0,0,0>}
                        finish {ambient 0 diffuse 0.2*diff reflection 0.6*<0.9,0.93,1> metallic specular 2 roughness 0.007} 
                        normal {dents 0.35 scale 0.15}
                ]
                [1      pigment {rgb <0.05,0.05,0.215>}
                        finish {ambient 0 diffuse 0.3*diff reflection 0.3*<0.85,0.85,0.915> metallic specular 1 roughness 0.02} 
                        normal {dents 0.5 scale 0.05}
                ]
        } 
}  

#declare r_metal = 
texture {
        wrinkles 
        scale 0.1 
        texture_map {
                [0      pigment {rgb <1,1,0>}
                        finish {ambient 0 diffuse 0.2*diff reflection 0.6*<0.9,0.93,1> metallic specular 2 roughness 0.007} 
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb <1,0,0>}
                        finish {ambient 0 diffuse 0.3*diff reflection 0.3*<0.85,0.85,0.915> metallic specular 1 roughness 0.02} 
                        normal {dents 0.5 scale 0.01}
                ]
        } 
}

#declare g_metal = 
texture {
        //crackle metric 2 form <1,0,0>
        crackle metric 30 offset 0.4 
        texture_map {
                [0      pigment {rgb <0,1,1>}
                        finish {ambient 0 diffuse 0.2*diff reflection 0.3*<0.9,0.93,1> metallic specular 2 roughness 0.007} 
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb <0,0.2,0>}
                        finish {ambient 0 diffuse 0.3*diff reflection 0.15*<0.85,0.85,0.915> metallic specular 1 roughness 0.02} 
                        normal {dents 0.5 scale 0.01}
                ]
        }
        scale 0.1 
}

#declare w_metal = 
texture {
        wrinkles 
        scale 0.1 
        texture_map {
                [0      pigment {rgb <1,1,1>}
                        finish {ambient 0 diffuse 0.2*diff reflection 0.6*<0.9,0.93,1> metallic specular 2 roughness 0.007} 
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb <1,0,0>}
                        finish {ambient 0 diffuse 0.3*diff reflection 0.3*<0.85,0.85,0.915> metallic specular 1 roughness 0.02} 
                        normal {dents 0.5 scale 0.01}
                ]
        } 
}

#declare T1 =
material {
        texture {g_metal}
        scale 0.7
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 65) /////////////////////////////////////////////////////////////////////////////////////

#declare T1 =  //peach
material {
        texture {
                average
                texture_map {
                        [       pigment {
                                        bozo
                                        color_map {
                                                [0.25,  color <0.482,0.325,0.325>]
                                                [1,     color <0.678,0.635,0.612>]
                                        }
                                        scale 0.001
                                }
                                normal {
                                        average
                                        normal_map {
                                                [       bumps 0.3*2
                                                        warp {turbulence 1}
                                                        scale 0.2
                                                ]
                                                [       bumps 0.2*2
                                                        warp {turbulence 0.5}
                                                        scale 0.001
                                                ]
                                        }
                                }
                                finish {ambient 0 diffuse 0.4 brilliance 0.7}
                        ]
                        [       pigment {color <0.95,0.42,0.42>}
                                finish {ambient 0 diffuse 0 phong 0.6 phong_size 2 metallic}
                        ]
                }
        }
        scale 0.7
        interior {ior 1.3}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 66) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  result of a funny mood ....

#declare radio  = 0;

#declare T1 =
material {
        texture {
                pigment {rgbf <1,0.8,0.6,0.9>}
                finish {diffuse 1 phong 1 phong_size 90 reflection {0, 1}}
        }
        interior {
                ior 5 
                dispersion 5 
                dispersion_samples 20
                fade_distance 0.1                                                          
                fade_power 1001
                fade_color rgb <0.3,0.65,1>
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 67) /////////////////////////////////////////////////////////////////////////////////////

// Salty  stucco  http://news.povray.org/povray.binaries.images/message/%3Cweb.41a4ed50a088e9e2c22cd3f0%40news.povray.org%3E/#%3Cweb.41a4ed50a088e9e2c22cd3f0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {
                        agate
                        agate_turb 1.0
                        color_map {
                                [0.0       rgb <0.870588,0.870588,0.737255>]
                                [0.501779  rgb <0.935294,0.935294,0.868627>]
                                [0.75089   rgb <0.967647,0.885400,0.718733>]
                                [1.0       rgb <1,1,1>]
                        }
                        turbulence 0.3
                        octaves 10
                        omega 0.7
                        ramp_wave
                }
                normal {
                        agate 0.2
                        agate_turb 1.0
                        turbulence 0.3
                        octaves 10
                        omega 0.7
                        ramp_wave
                }
                finish {
                        ambient 0
                        diffuse 0.913667-0.3
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 68) /////////////////////////////////////////////////////////////////////////////////////

// Christophe Bouffartigue  cbasia  http://www.irtc.org/ftp/pub/stills/2001-12-31/cbasia.zip

#declare teacol1 = <1,0.96,0.92>;
#declare teacol2 = <0.8,0.56,0.32>;

#declare T_tea1 = 
texture {
	pigment {
		pigment_pattern {
                        bozo
                        warp {turbulence 0.2 lambda 4} 
                        scale 2
                }
		pigment_map {
			[0.45   wrinkles 
                                turbulence 0.3 
                                color_map {
                                        [0 rgb teacol1]
                                        [1 rgb teacol1*0.5]
                                }
                        ]
			[0.65   granite
                                frequency 2 
                                scale 3 
                                warp {turbulence 0.3} 
                                color_map {
                                        [0 rgb teacol2*1.1]
                                        [1 rgb teacol2*0.5]
                                }
                        ]
		}
		warp {turbulence 1 lambda 5 octaves 2}
	}
	normal {granite 0.1 scale 0.1}
	finish {phong 0.2 phong_size 2 specular 0.4 roughness 0.002}
}

#declare T1 = 
material {
        texture {T_tea1}
        scale 0.1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 69) /////////////////////////////////////////////////////////////////////////////////////

// Nathan O'Brien  13oldtek  source sent by author

// WHITE
#macro White_ (STRENGTH)
	rgb (1*STRENGTH)
#end 

// BLUE
#macro Blue_ (STRENGTH)
	rgb <0,0,(1*STRENGTH)>
#end  

// RED
#macro Red_ (STRENGTH)
	rgb <(1*STRENGTH),0,0>
#end  

// YELLOW
#macro Yellow_ (STRENGTH)
	rgb <(1*STRENGTH),(1*STRENGTH),0>
#end

// GREEN
#macro Green_ (STRENGTH)
	rgb <0,(1*STRENGTH),0>
#end

// POVRAY PIGMENT DEFAULT
#default {
	pigment {White_(1)}
} 

#declare Roof_Pigment1 =
pigment {
	granite
	color_map {
		[0.0 White_(0.1)]
		[0.3 White_(0.5)]
		[0.7 White_(0.2)]
		[1.0 White_(0.4)]
	} 
	scale 50
}

#declare Roof_Pigment2 =
pigment {
	Roof_Pigment1
	warp {repeat x*0.25 offset <0,10,0>}
} 

#declare Roof_Pigment3 =
pigment {
	Roof_Pigment2
	warp {repeat y*0.25 offset <20.25,0,0>}
} 

#declare Roof_Pigment4 =
pigment {
	spotted
	color_map {
		[0.0 White_(0.1)]
		[0.3 White_(0.5)]
		[0.7 White_(0.2)]
		[1.0 White_(0.4)]
	} 
	scale 0.1
}

#declare Roof_Pigment5 =
pigment {
	average
	pigment_map {
		[1.0 Roof_Pigment3]
		[0.5 Roof_Pigment4]
	}
}

#declare Roof_Pigment1a =
pigment {
	granite
	color_map {
   		[0.00 rgb <0.518, 0.251, 0.133>]
   		[0.15 rgb <0.824, 0.824, 0.824>]
   		[0.42 rgb <0.318, 0.271, 0.200>]
   		[0.59 rgb <0.459, 0.380, 0.259>]
		[0.65 rgb <0.392, 0.392, 0.392>]
		[0.84 rgb <0.325, 0.263, 0.216>]
		[1.00 rgb <0.506, 0.357, 0.227>]
	} 
	scale 50
}

#declare Roof_Pigment2a =
pigment {
	Roof_Pigment1a
	warp {repeat x*0.25 offset <0,10,0>}
} 

#declare Roof_Pigment3a =
pigment {
	Roof_Pigment2a
	warp {repeat y*0.25 offset <20.25,0,0>}
} 

#declare Roof_Pigment4a =
pigment {
	spotted
	color_map {
   		[0.00 rgb <0.518, 0.251, 0.133>]
   		[0.15 rgb <0.824, 0.824, 0.824>]
   		[0.42 rgb <0.318, 0.271, 0.200>]
   		[0.59 rgb <0.459, 0.380, 0.259>]
		[0.65 rgb <0.392, 0.392, 0.392>]
		[0.84 rgb <0.325, 0.263, 0.216>]
		[1.00 rgb <0.506, 0.357, 0.227>]
	} 
	scale 0.1
}

#declare Roof_Pigment5a =
pigment {
	average
	pigment_map {
		[1.0 Roof_Pigment3a]
		[0.5 Roof_Pigment4a]
	}
}  

#declare Roof_Map =
pigment {
	crackle solid
	pigment_map {
		[0.0 Roof_Pigment5  scale 1.25]
		[0.5 Roof_Pigment5  scale 1.25]
		[0.5 Roof_Pigment5a scale 1.25]
		[1.0 Roof_Pigment5a scale 1.25]
	}
	scale 0.8
}

#declare T1 =                        
material {                                              
        texture {		
                pigment {Roof_Map rotate <90,0,0>}
		normal {
			quilted 0.5 scale 0.25
			warp {repeat z*0.25 offset <0.125,0,0>}
		}
		finish {diffuse 0.7 phong 0.2} 
                scale 0.25
        }                                                                     
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 70) /////////////////////////////////////////////////////////////////////////////////////

// Michael Raiford  Copper Texture  http://news.povray.org/povray.text.scene-files/thread/%3C41e52fcd$1@news.povray.org%3E/?ttop=296020&toff=100

#declare copper_micro_norm = 
normal {
        spotted 0.5 
        scale 0.03
        slope_map {
                [0.0 <1,0>]
                [0.3 <1,0>]
                [0.9 <0,0>]
                [1.0 <0,0>]
        }
}

#declare chinks = 
normal {
        spotted 0.5 
        scale 0.1
        slope_map {
                [0.0 <1,0>]
                [0.6 <1,0>]
                [0.9 <0,0>]
                [1.0 <0,0>]
   }
}

#declare copper_norm = 
normal {
        spotted -1 // 1
        scale 0.0125
        normal_map {
                [0.0 copper_micro_norm]
                [0.6 copper_micro_norm]
                [0.6 chinks]
                [1.0 chinks]
        }
}

#declare T1 =                        
material {
        texture {
                pigment {rgb <0.9,0.66,0.42>}
                finish {
                        diffuse 0.07
                        specular 1 
                        roughness 0.0005
                        metallic
                        reflection {0.7,1 metallic}
                        conserve_energy
                }
                normal {copper_norm}
        }
        interior {ior 1.1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 71) /////////////////////////////////////////////////////////////////////////////////////

// Christophe Bouffartigue  cbcity  fireplug  http://www.irtc.org/ftp/pub/stills/2000-04-30/cbcity.zip

#declare T_Crasse = 
texture {
	pigment {
		wrinkles
		color_map {
			[0.0 Clear]
			[1.0 DarkBrown*0.5 filter 0.5]
		}
	}
}

#declare T_Crasse2 = 
texture {
	pigment {
		wrinkles
		color_map {
			[0.0 Clear]
			[1.0 DarkBrown*0.4 filter 0.6]
		}
	}
} 

#declare T_Rouille = 
texture {
	pigment {
		granite
		color_map {
			[0   DarkTan*0.5]
			[0.7 DarkBrown*0.5]
			[1   Orange*0.5]
		}
	}
	normal {granite 0.6 scale 0.1}
	finish {
                ambient 0.4 diffuse 0.6
		specular 0.3 roughness 0.5
	}
}

#declare T_Fer_Rouge = 
texture {
	pigment {rgb <0.8,0.1,0.05>*0.8}
	normal {
		average
		normal_map {
			[1 wrinkles 1 scale 0.2]
			[1 dents 2 scale 0.04]
		}
	}
	finish {
		ambient 0.4 diffuse 0.6
		specular 1 roughness 0.1 metallic 
	}
}
texture {T_Crasse scale 5}
texture {T_Crasse2 scale 2}

#declare T_Fer_Marron = 
texture {
	pigment {rgb <0.8,0.6,0.4>*0.4}
	normal {
		average
		normal_map {
			[1 wrinkles 0.3 scale 0.2]
			[1 dents 0.5 scale 0.04]
		}
	}
	finish {
		ambient 0.4 diffuse 0.6
		specular 0.6 roughness 0.01 metallic
		phong 0.6 phong_size 20
	}
}
texture {T_Crasse2 scale 3}

#declare T_Fer_Rouge_Rouille = 
texture {
	bozo
	scale 4
	texture_map {
		[0.5 T_Fer_Rouge scale 1/4]
		[1.1 T_Rouille ]
	}
	warp {turbulence 1 lambda 2 octaves 3}
}

#declare T_Bronze_Rouille = 
texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Fer_Marron scale 1/3]
		[1.0 T_Rouille scale 5/3]
	}
	warp {turbulence 1 lambda 2 octaves 3}
}

#declare T1 =                        
material {
        texture {T_Fer_Rouge_Rouille}
        scale 0.1
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 72) /////////////////////////////////////////////////////////////////////////////////////

// Car Paint (plain / old)  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare PaintColor = color White; 
#declare PaintBright = pigment {PaintColor}
#declare PaintDark = pigment {PaintColor*0.5}
 
#declare T1 = 
material {
        texture {
                pigment {
                        aoi
                        pigment_map{
                                [0.0 PaintBright]
                                [0.5 PaintDark]
                                [1.0 PaintBright]
                        }
                }
                normal {bozo 0.05 scale 0.1}
                finish {
                        diffuse 0.65
                        brilliance 0.6
                        reflection {rgb <0.05,0.05,0.05>, rgb <0.2,0.2,0.2> fresnel on}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 73) /////////////////////////////////////////////////////////////////////////////////////

// Car Paint (Metallic / new)  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare PaintColor = color SkyBlue; 
#declare PaintBright =  pigment {PaintColor}
#declare PaintDark = pigment {PaintColor*0.1}
 
#declare T1 = 
material {
        texture {
                pigment {
                        aoi
                        pigment_map {
                                [0.0 PaintBright]
                                [0.5 PaintDark]
                                [1.0 PaintBright]
                        }
                }
                normal {bozo 0.05 scale 0.1}
                finish {
                        specular 0.4
                        roughness 0.05 
                        metallic
                        diffuse 0.25
                        brilliance 1
                        reflection {0.2}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 74) /////////////////////////////////////////////////////////////////////////////////////

// Car Paint (Tuning)  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare PaintColor = color SkyBlue; 
#declare PaintBright =  pigment {PaintColor}
#declare PaintDark = pigment {rgb <1-PaintColor.red, 1-PaintColor.green, 1-PaintColor.blue>}
 
#declare T1 = 
material {
        texture {
                pigment {
                        aoi
                        pigment_map {
                                [0.0 PaintBright]
                                [0.5 PaintDark]
                                [1.0 PaintBright]
                        }
                }
                normal {bozo 0.05 scale 0.1}
                finish {
                        specular 0.4
                        roughness 0.1 
                        metallic
                        diffuse 0.25
                        brilliance 2
                        reflection {0.01,0.3}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 75) /////////////////////////////////////////////////////////////////////////////////////

// Oak Wood  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare T1 = 
material {
        texture {
                pigment {
	                wood
	                turbulence 0.05
	                translate 4*z
	                warp {repeat 8*z offset 0.0} 
                        rotate 86*z
	                //rotate 4*z
	                pigment_map {
	                        [0.0    bozo
                                        color_map {
                                                [0.0 rgb <0.45,0.3,0.2>]
                                                [0.4 rgb <0.4,0.3,0.25>]
                                                [0.5 rgb <0.58,0.4,0.35>]
                                                [1.0 rgb <0.58,0.4,0.35>]
                                        }
                                ]
                                [0.3    bozo
                                        color_map {
                                                [0.0 rgb <0.45,0.3,0.2>]
                                                [0.4 rgb <0.4,0.3,0.25>]
                                                [0.5 rgb <0.58,0.4,0.35>]
                                                [1.0 rgb <0.58,0.4,0.35>]
                                        }
                                ]
	                        [0.7    rgb <0.775,0.56,0.45>]
	                        [1.0    rgb <0.775,0.56,0.45>]
	                }
                }
                finish {diffuse 0.75 specular 0.05 roughness 0.025}
	        translate <0,0,3>
	        scale 0.5
	        rotate 90*x 
        }
        texture {
                pigment {
		        bozo
	                color_map {
		                [0.0 rgbt <0.5,0.3,0.2,0.0>]
		                [0.3 rgbt <0.5,0.3,0.2,0.0>]
		                [0.4 rgbt <0.8,0.6,0.6,1.0>]
		                [1.0 rgbt <0.8,0.6,0.6,1.0>]
		        }
                        scale <1,1,0.02>
		        rotate 90*x 
                }
                normal {
		        bozo
                        scale <1,1,0.02>
		        rotate 90*x 
                }
                finish {diffuse 0.8 specular 0.2}
        }
        scale 0.1
        rotate x*-45
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 76) /////////////////////////////////////////////////////////////////////////////////////

// Sand  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare T1 =
material {
        texture {
                pigment {rgb <0.518,0.339,0.138>}
                normal {bumps 5 scale 0.001}
                finish {specular 0.3 roughness 0.8}
        }
        texture {
                pigment {
                        wrinkles
                        scale 0.001
                        color_map {
	                        [0.0 rgbt <1,0.847,0.644,0>]
	                        [0.2 rgbt <0.658,0.456,0.270,1>]
	                        [0.4 rgbt <0.270,0.191,0.067,0.25>]
	                        [0.6 rgbt <0.947,0.723,0.468,0>]
	                        [0.8 rgbt <0.356,0.250,0.047,1>]
	                        [1.0 rgbt <0.171,0.136,0.1,1>]
                        }
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 77) /////////////////////////////////////////////////////////////////////////////////////

// Cigaret Filter  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare T1 =
material {
        texture {
                pigment {rgb <0.610,0.366,0.141>}
        } 
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*0
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        } 
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*45
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        } 
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*90
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*135
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*180
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*225
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*270
                        color_map {
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        texture {
                pigment {
                        granite
                        scale 1.5
                        rotate y*315
                        color_map{
      	                        [0.00 rgb <0.671,0.421,0.049>]
      	                        [0.12 rgbt <0.958,0.726,0.375,1>]
      	                        [0.12 rgbt <1, 1, 1, 1>]
      	                        [1.00 rgbt <1, 1, 1, 1>]
                        }
                }
        }
        scale 0.1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 78) /////////////////////////////////////////////////////////////////////////////////////

// Orange  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare T1 = 
material {
        texture{
                pigment {
                        bozo
                        color_map {
	                        [0.0 rgb <0.686,0.383,0.024>]
	                        [0.5 rgb <0.686,0.228,0.032>]
	                        [1.0 rgb <0.828,0.516,0.031>]
                        }
                        scale 0.15
                }
                normal {granite 0.2}	
                finish {
                        diffuse 0.8
                        brilliance 1
                        specular 0.15
                        roughness 0.05
                        subsurface {translucency 0.05}
                }
        }
        scale 0.05
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 79) /////////////////////////////////////////////////////////////////////////////////////

// Lapislazuli  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials
 
#declare azul =
texture {
        pigment {
                bozo
                scale 0.7
                turbulence 1
                color_map {
	                [0.0 rgb <0.053,0.112,0.371>*1.5] 
	                [0.2 rgb <0.045,0.098,0.361>*1.5] 
	                [0.4 rgb <0.009,0.026,0.238>*1.5] 
	                [1.0 rgb <0.004,0.007,0.093>*1.5] 	
                }
        }
        finish {
                specular 0.5
                roughness 0.0001
                reflection {0.2}
                brilliance 2
        }
}
 
#declare pyrit =
texture {
        pigment {rgb <0.723,0.516,0>*1.5}
        normal {bumps 0.25 scale 0.001}
        finish {
                specular 1 
                roughness 0.0001
                reflection 0.9
        }
}
 
#declare T1 =
material {
        texture {
                granite
                scale 4.5
                turbulence 0.5
                texture_map {
	                [0.00 pyrit]
	                [0.07 pyrit]
	                [0.12 azul]
	                [1.00 azul]                
                }
        }
        scale 0.1
        interior {ior 1.61}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 80) /////////////////////////////////////////////////////////////////////////////////////

// Travertine  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials 

#declare T1 =  
material {
        texture {
                pigment {
                        agate//marble
                        turbulence 0.5
                        color_map {
                                [0.000 rgbt <0.784, 0.627, 0.522, 0.000>]
                                [0.053 rgbt <0.784, 0.627, 0.624, 0.000>]
                                [0.053 rgbt <0.784, 0.627, 0.624, 0.000>]
                                [0.263 rgbt <0.824, 0.557, 0.376, 0.000>]
                                [0.263 rgbt <0.824, 0.557, 0.376, 0.000>]
                                [0.281 rgbt <0.643, 0.380, 0.376, 0.000>]
                                [0.281 rgbt <0.643, 0.380, 0.376, 0.000>]
                                [0.325 rgbt <0.839, 0.722, 0.722, 0.000>]
                                [0.325 rgbt <0.839, 0.722, 0.722, 0.000>]
                                [0.711 rgbt <0.784, 0.627, 0.522, 0.000>]
                                [0.711 rgbt <0.784, 0.627, 0.522, 0.000>]
                                [0.798 rgbt <0.769, 0.380, 0.376, 0.000>]
                                [0.798 rgbt <0.769, 0.380, 0.376, 0.000>]
                                [0.895 rgbt <0.824, 0.557, 0.376, 0.000>]
                                [0.895 rgbt <0.824, 0.557, 0.376, 0.000>]
                                [0.982 rgbt <0.784, 0.627, 0.522, 0.000>]
                                [0.982 rgbt <0.784, 0.627, 0.522, 0.000>]
                        }
                }
                scale <1,1,2> 
                rotate <40,0,0> 
                rotate <0,0,30>
        } 
        texture {
                pigment {
                        granite
                        turbulence 0.5
                        color_map {
                                [0.000 rgbt <0.784, 0.627, 0.522, 0.500>]
                                [0.053 rgbt <0.784, 0.627, 0.624, 0.500>]
                                [0.053 rgbt <0.784, 0.627, 0.624, 0.500>]
                                [0.263 rgbt <0.824, 0.557, 0.376, 0.500>]
                                [0.263 rgbt <0.824, 0.557, 0.376, 0.500>]
                                [0.281 rgbt <0.643, 0.380, 0.376, 0.500>]
                                [0.281 rgbt <0.643, 0.380, 0.376, 0.500>]
                                [0.325 rgbt <0.839, 0.722, 0.722, 0.500>]
                                [0.325 rgbt <0.839, 0.722, 0.722, 0.500>]
                                [0.711 rgbt <0.784, 0.627, 0.522, 0.500>]
                                [0.711 rgbt <0.784, 0.627, 0.522, 0.500>]
                                [0.798 rgbt <0.769, 0.380, 0.376, 0.500>]
                                [0.798 rgbt <0.769, 0.380, 0.376, 0.500>]
                                [0.895 rgbt <0.824, 0.557, 0.376, 0.500>]
                                [0.895 rgbt <0.824, 0.557, 0.376, 0.500>]
                                [0.982 rgbt <0.784, 0.627, 0.522, 0.500>]
                                [0.982 rgbt <0.784, 0.627, 0.522, 0.500>]
                                [1.001 rgbt <0.784, 0.627, 0.522, 0.500>]
                        }
                }
                scale <2,1,2> 
                rotate <40,0,0> 
                rotate <0,0,30>
        } 
        texture {
                pigment {
                        agate//marble
                        turbulence 2.85
                        color_map {
                                [0.000 rgb 0 transmit 0.6] 
                                [0.050 rgb 0 transmit 1]
                                [0.050 rgb <0.55,0.09,0.09> transmit 0.8] 
                                [0.970 rgb <0.329412,0.329412,0.329412> transmit 0.9]
                                [0.970 rgb 0 transmit 0.9]
                                [1.001 rgb 0 transmit 1]
                        }
                }
                scale <1,2,1.5> 
                rotate <0,0,40>
        } 
        texture {
                pigment {rgb <1,1,0> transmit 0.9} // Main tint
                normal {
                        marble -0.025 
                        turbulence 2.85 
                        scale <1,2,1.5> 
                        rotate <0,0,40>
                }
                finish {phong 0.3 phong_size 20}  
        } 
        /*texture {
                pigment {
                        brick rgb 0.6  // color mortar
                        rgbt < 0.75, 0.5, 0.30, 1>  // Fully transparent brick color 
                        brick_size <25, 5.25, 12.5> 
                        // (cm) format in x ,y and z- POV coordinates (xzy Blender direction) 
                        mortar 0.01                      // (cm)size of the mortar 
                        scale 1
                } 
                finish {ambient 0 diffuse 0.95 phong 0.3 phong_size 30} 
                rotate <-90,0,0>  
        }*/ 
        scale 0.2
        interior {ior 1.7}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 81) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Celadon  http://news.povray.org/povray.binaries.images/message/%3C52ff8bfa%40news.povray.org%3E/#%3C52ff8bfa%40news.povray.org%3E 

#declare T1 =
material {
        texture {
                pigment {
                        bozo
                        pigment_map {
                                [0.0 color srgb <0.762025, 0.883775, 0.762025>]
                                [0.2 color srgb <0.855688, 0.935979, 0.855688>]
                                [0.5 color srgb <0.728519, 0.896481, 0.728519>]
                                [0.8 color srgb <0.937467, 1.000000, 0.937467>]
                                [1.0 color srgb <0.548054, 0.722746, 0.548054>]
                        }
                }
                normal {
                        crackle 0.5 solid
                        warp {turbulence <0.1,0.1,0.1>}
                        scale  0.1
                }
                finish {
                        diffuse 0.6
                        specular 0.5
                        roughness 0.005
                        conserve_energy
                        reflection {
                                0.01,0.2
                                fresnel on
                                falloff 1
                                exponent 1
                        }
                        subsurface {translucency <0.45,0.38,0.33>*0.15}
                }
                scale 0.01
        }
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 82) /////////////////////////////////////////////////////////////////////////////////////

// Skin Light  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare T1 =
material {
        texture {
                pigment {
                        aoi 
                        color_map {
                                [0.35 rgb Ga (<0.9,0.4,0.2>*0.75)]
                                [0.50 rgb Ga (<1,0.95,0.9>)]
                                [0.65 rgb Ga (<0.9,0.4,0.2>*0.75)]
                        }
                }
                normal {
                        crackle 5
                        form <1,0,0>
                        scale 0.0075
                }
                finish {
                        phong 0.01
                        phong_size 10
                        specular 0.01
                        roughness 0.5
                        diffuse 0.6
                        ambient 0
                        subsurface {translucency 0.1} //Ga (<1-3.67*0.2,1-1.37*0.2,1-0.683*0.2>*0.25)}
                        conserve_energy
                }
        }
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 83) /////////////////////////////////////////////////////////////////////////////////////

// Paolo Gibellini  Brick texture  http://news.povray.org/povray.general/message/%3C4d9ed4a0%241%40news.povray.org%3E/#%3C4d9ed4a0%241%40news.povray.org%3E

#declare t_brick_space =
texture{
	pigment {rgb <200,180,160>/255}
	finish {diffuse 0.65}
	normal {granite 0.6 scale 0.4}
}

#declare t_brick =
texture {
	pigment {rgb Ga (<188,67-20,8>/255)}
	finish {diffuse 0.7 roughness 0.15}
	normal {
		average
		normal_map {
			[1.00   boxed 1
			        poly_wave 0.3
			        slope_map{
				        [0.00 <0,0>]
				        [0.02 <0,0>]
				        [0.02 <0,0.5>]
				        [0.60 <1,0>]      // Increase or decrease the bump
			        }
			]
			[1.00   granite 0.15]
		}
	}
}

#declare t_wall =
texture {
	boxed
	poly_wave 0.3
	texture_map {
		[0.00 t_brick_space]
		[0.05 t_brick_space]
		[0.05 t_brick]
		[1.00 t_brick]
	}
	warp {planar}
	rotate -90*x
	scale 0.5
	translate <0.5,0,0.5>
	warp {repeat 1.05*x}
	warp {repeat 1.05*z offset 0.5*x}
	scale 0.4*z
	//#local tseg_Warp_scale = 1;
	//scale tseg_Warp_scale
	warp {
		turbulence <0.3,1.5,0.3>*0.1
		octaves 4
		lambda 1.5
	}
	//scale 1/tseg_Warp_scale
	scale 0.25
	rotate 90*x
}

#declare T1 =
material {
        texture {t_wall}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 84) /////////////////////////////////////////////////////////////////////////////////////

// LanuHum   Material_001_tex  http://news.povray.org/povray.binaries.images/message/%3Cweb.5302425140bf5a347a3e03fe0%40news.povray.org%3E/#%3Cweb.5302425140bf5a347a3e03fe0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb <0.8,0.4141,0.2057>} 
                normal {
                        agate
                        agate_turb 1.491
                        slope_map {
                                [0.0 <0,1>]
                                [0.1 <1,1>]
                                [0.9 <1,1>]
                                [1.0 <0,1>]
                        }
                        accuracy 0.0001
                        warp {repeat x*2 flip <1,0,0>}
                        frequency 2
                        scale <2,2,2>
                } 
                finish {  
                        specular 0.5
                        roughness 0.01
                        diffuse 0.7
                        conserve_energy
                }
        }
        scale 0.4
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

//#if (mat = 85) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare stogam = 2.2;
#declare stodiff = 1.1;

#declare PebbleNormalAndFinish = 
texture {
        normal {bumps 0.2 scale 0.005}
        finish {diffuse 0.7 ambient 0}
}

#declare PebblePatternCount = 6;
#declare PebblePatterns = array [PebblePatternCount]

// A selection of base patterns for the pebbles.
#declare PebblePatterns [0] = 
pigment {
        wrinkles
        scale 0.02
        noise_generator 2
}

#declare PebblePatterns [1] = 
pigment {
        bozo
        turbulence 2.0
        scale 0.05
        noise_generator 2
}

#declare PebblePatterns [2] = 
pigment {
        bozo
        turbulence 4.0
        scale 0.1
        noise_generator 3
}

#declare PebblePatterns [3] = 
pigment {
        wrinkles
        turbulence 1.0
        scale 0.05
}

#declare PebblePatterns [4] = 
pigment {
        granite
        turbulence 0.2
        scale 0.15
}

#declare PebblePatterns [5] = 
pigment {
        granite
        scale 0.6
        turbulence 2.0
}

/****************************************************************************/

#declare PebblecolorCount = 15;
#declare Pebblecolors = array [PebblecolorCount]

// A selection of different color schemes for the pebbles.
#declare Pebblecolors [0] = 
color_map {
        [0.0 rgb <pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff>]
        [0.7 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [1.0 rgb <1, 1, 1>]
}
#declare Pebblecolors [1] = 
color_map {
        [0.0 rgb <pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
        [0.3 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
        [0.8 rgb <1.0, 1.0, 1.0>]
        [1.0 rgb <pow (1.0,stogam)*stodiff, pow (1.0,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
}
#declare Pebblecolors [2] = 
color_map {
        [0.0 rgb <pow (0.4,stogam)*stodiff, pow (0.4,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.2 rgb <1.0, 1.0, 1.0>]
        [0.7 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, 1.0>]
        [1.0 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.4,stogam)*stodiff>]
}
#declare Pebblecolors [3] = 
color_map {
        [0.0 rgb <pow (0.6,stogam)*stodiff, pow (0.4,stogam)*stodiff, pow (0.4,stogam)*stodiff>]
        [0.4 rgb <pow (0.8,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.6 rgb <pow (0.8,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [4] = 
color_map {
        [0.0 rgb <pow (0.8,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.4,stogam)*stodiff>]
        [0.3 rgb <pow (0.8,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
        [0.8 rgb <pow (1.0,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [5] = 
color_map {
        [0.0 rgb <0.0, 0.0, 0.0>]
        [0.3 rgb <pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.7 rgb <pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.8 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, 1.0>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [6] = 
color_map {
        [0.0 rgb <pow (0.7,stogam)*stodiff, pow (0.4,stogam)*stodiff, pow (0.4,stogam)*stodiff> ]
        [0.3 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.75,stogam)*stodiff>]
        [0.7 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.85,stogam)*stodiff>]
        [0.8 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff> ]
        [1.0 rgb <1.0, 1.0, 1.0> ]
}
#declare Pebblecolors [7] = 
color_map {
        [0.0 rgb <0.0, 0.0, 0.0>]
        [0.2 rgb <pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff>]
        [0.7 rgb <pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.8 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [8] = 
color_map {
        [0.0 rgb <pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
        [0.2 rgb <pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.4 rgb <pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff>]
        [0.6 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [0.8 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [9] = 
color_map {
        [0.00 rgb <pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
        [0.25 rgb <pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.73,stogam)*stodiff>]
        [0.50 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [0.75 rgb <pow (1.0,stogam)*stodiff, pow (0.97,stogam)*stodiff, pow (0.97,stogam)*stodiff>]
        [1.00 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [10] = 
color_map {
        [0.0 rgb <pow (0.3,stogam)*stodiff, pow (0.2,stogam)*stodiff, pow (0.0,stogam)*stodiff>]
        [0.2 rgb <pow (0.7,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.5,stogam)*stodiff>]
        [0.7 rgb <pow (0.9,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.8 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [11] = 
color_map {
        [0.0 rgb <pow (0.1,stogam)*stodiff, pow (0.1,stogam)*stodiff, pow (0.1,stogam)*stodiff>]
        [0.3 rgb <pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [0.7 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [1.0 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
}
#declare Pebblecolors [12] = 
color_map {
        [0.0 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [1.0 rgb <1.0, 1.0, 1.0>]
}
#declare Pebblecolors [13] = 
color_map {
        [0.0 rgb <pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff, pow (0.7,stogam)*stodiff>]
        [1.0 rgb <pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff, pow (0.9,stogam)*stodiff>]
}
#declare Pebblecolors [14] = 
color_map {
        [0.0 rgb <pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff, pow (0.6,stogam)*stodiff>]
        [1.0 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
}

/****************************************************************************/

#declare DecalcolorCount = 5;
#declare Decalcolors = array [DecalcolorCount]

// A selection of different color schemes for the dirt/speckle/line overlays.
#declare Decalcolors [0] = 
color_map {
        [0.0 rgb <pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff, pow (0.8,stogam)*stodiff>]
        [0.4 rgb <pow (0.95,stogam)*stodiff,pow (0.95,stogam)*stodiff,pow (0.95,stogam)*stodiff>]
        [1.0 rgb <1, 1, 1>]
}
#declare Decalcolors [1] = 
color_map {
        [0.0 rgbt <pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, pow (0.5,stogam)*stodiff, 0>]
        [0.4 rgbt <pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, 0.6>]
        [1.0 rgbt <0, 0, 0, 0.6>]
}
#declare Decalcolors [2] = 
color_map {
        [0.5 rgbt <0, 0, 0, 1.0>]
        [1.0 rgbt <0, 0, 0, 0.5>]
}
#declare Decalcolors [3] = 
color_map {
        [0.0 rgbt <1, 1, 1, 1>]
        [1.0 rgbt <1, 1, 1, 0.5>]
}
#declare Decalcolors [4] = 
color_map {
        [0.5 rgbt <pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, 1.0>]
        [1.0 rgbt <pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, pow (0.2,stogam)*stodiff, 0.0>]
}

/****************************************************************************/

#declare DecalPatternCount = 17;
#declare DecalPatterns = array [DecalPatternCount]

// A selection of different dirt/speckle/line textures which will be
// overlayed over the base textures to make them more interesting.
#declare DecalPatterns [0] = 
pigment {
        wrinkles
        scale 0.1
        noise_generator 2
        pigment_map {
                [0.75 rgbt <1,1,1,1>]
                [0.85 PebblePatterns [0] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [1] = 
pigment {
        wrinkles
        scale 0.1
        noise_generator 2
        pigment_map {
                [0.75 rgbt <1,1,1,1>]
                [0.85 PebblePatterns [0] color_map {Decalcolors [1]}]
        }
}

#declare DecalPatterns [2] = 
pigment {
        marble
        scale 2
        turbulence 0.5
        pigment_map {
                [0.92 rgbt <1,1,1,1>]
                [0.96 PebblePatterns [0] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [3] = 
pigment {
        marble
        scale 2
        turbulence 4
        pigment_map {
                [0.95 rgbt <1,1,1,1>]
                [1.00 PebblePatterns [0] scale 5 color_map {Decalcolors [2]}]
        }
}

#declare DecalPatterns [4] = 
pigment {
        bozo
        scale 0.2
        noise_generator 3
        pigment_map {
                [0.85 rgbt <1,1,1,1>]
                [0.9 PebblePatterns [0] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [5] = 
pigment {
        bozo
        scale 0.2
        noise_generator 2
        turbulence 1
        pigment_map {
                [0.75 rgbt <1,1,1,1>]
                [0.80 PebblePatterns [0] color_map {Decalcolors [1]}]
        }
}

#declare DecalPatterns [6] = 
pigment {
        bozo
        scale 0.2
        noise_generator 3
        turbulence 2
        pigment_map {
                [0.85 rgbt <1,1,1,1>]
                [0.9 PebblePatterns [0] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [7] = 
pigment {
        bozo
        scale 0.2
        noise_generator 2
        turbulence 4
        pigment_map {
                [0.75 rgbt <1,1,1,1>]
                [0.80 PebblePatterns [0] color_map {Decalcolors [1]}]
        }
}

#declare DecalPatterns [8] = 
pigment {
        marble
        scale 0.1
        turbulence 1
        pigment_map {
                [0.90 rgbt <1,1,1,1>]
                [1.00 PebblePatterns [0] scale 5 color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [9] = 
pigment {
        marble
        scale 0.1
        turbulence 1
        pigment_map {
                [0.75 rgbt <1,1,1,1>]
                [0.80 PebblePatterns [0] scale 5 color_map {Decalcolors [2]}]
        }
}

#declare DecalPatterns [10] = 
pigment {
        wrinkles
        scale 0.5
        noise_generator 2
        pigment_map {
                [0.6 rgbt <1,1,1,1>]
                [0.7 PebblePatterns [2] color_map {Decalcolors [3]}]
        }
}

#declare DecalPatterns [11] = 
pigment {
  wrinkles
  scale 0.5
  noise_generator 2
  pigment_map {
    [0.7 rgbt <1,1,1,1>]
    [0.8 PebblePatterns [2] scale 4 color_map {Decalcolors [4]}]
  }
}

#declare DecalPatterns [12] = 
pigment {
        crackle
        scale 0.2
        noise_generator 2
        pigment_map {
                [0.5 rgbt <1,1,1,1>]
                [0.7 PebblePatterns [2] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [13] = 
pigment {
        crackle
        scale 0.1
        noise_generator 2
        pigment_map {
                [0.5 rgbt <1,1,1,1>]
                [0.7 PebblePatterns [2] color_map {Decalcolors [1]}]
        }
}

#declare DecalPatterns [14] = 
pigment {
        waves
        scale 0.02
        noise_generator 3
        turbulence 2
        pigment_map {
                [0.65 rgbt <1,1,1,1>]
                [1.0 PebblePatterns [2] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [15] = 
pigment {
        quilted
        scale 0.5
        noise_generator 3
        turbulence 1
        pigment_map {
                [0.4 rgbt <1,1,1,1>]
                [0.6 PebblePatterns [2] color_map {Decalcolors [0]}]
        }
}

#declare DecalPatterns [16] = 
pigment {
        quilted
        scale 0.5
        noise_generator 3
        turbulence 1
        pigment_map {
                [0.3 rgbt <1,1,1,1>]
                [0.6 PebblePatterns [2] color_map {Decalcolors [1]}]
        }
}

#if (mat = 85) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan  Hunt pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+17); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+17); // The seed for the pebble patterns.
#declare RandCol = seed (12+17); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 86) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+20); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+20); // The seed for the pebble patterns.
#declare RandCol = seed (12+20); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 87) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+34); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+34); // The seed for the pebble patterns.
#declare RandCol = seed (12+34); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 88) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+36); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+36); // The seed for the pebble patterns.
#declare RandCol = seed (12+36); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 89) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+56); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+56); // The seed for the pebble patterns.
#declare RandCol = seed (12+56); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 90) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+65); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+65); // The seed for the pebble patterns.
#declare RandCol = seed (12+65); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 91) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+78); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+78); // The seed for the pebble patterns.
#declare RandCol = seed (12+78); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 92) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Hunt  pebbles  http://news.povray.org/povray.text.scene-files/message/%3C48d158e3%241%40news.povray.org%3E/#%3C48d158e3%241%40news.povray.org%3E

#declare RandPeb = seed (70+81); // The seed for the pebble shapes and placement.  17, 20, 34, 36, 56, 65, 78, 81
#declare RandPat = seed (83+81); // The seed for the pebble patterns.
#declare RandCol = seed (12+81); // The seed for the pebble color schemes.

#declare T1 = 
material {
        texture {// Add the default texture
                PebbleNormalAndFinish
                pigment {// Select a random pattern.
                        PebblePatterns [rand(RandPat)*PebblePatternCount]
                        color_map {// Choose a random color scheme.
                                Pebblecolors [rand(RandCol)*PebblecolorCount]
                        }
                }
                // Randomize the pattern's position and rotation.
                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
        }
        #declare DecalLoop = 0;  // Decide randomly which of the dirt/speckle/line overlay textures we want to use. 
        #while (DecalLoop < DecalPatternCount)
                #if (rand(RandPat) < 0.2)
                        texture {
                                PebbleNormalAndFinish
                                DecalPatterns [DecalLoop]
                                translate <rand(RandPat)*100, rand(RandPat)*100, rand(RandPat)*100>
                                rotate <rand(RandPat)*360, rand(RandPat)*360, rand(RandPat)*360>
                        }
                #end
                #declare DecalLoop = DecalLoop+1;
        #end
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 93) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  cart_pov  http://www.oyonale.com/downloads/cart_pov.zip

#declare T_Ground =
texture {
        pigment {
                gradient x
                pigment_map {
                        [0.9    wrinkles 
                                turbulence 1 lambda 3 
                                color_map {
                                        [0 rgb <0.9,0.93,0.91>*0.7]
                                        [1 rgb <0.64,0.62,0.59>*0.5]
                                }
                        ]
                        [0.9    rgb <0.85,0.7,0.1>]
                }
                scale 100
        }
        normal {      
                bump_map {jpeg "stone09"} 
                bump_size -5
                rotate x*90
                scale 200
        }
        finish {ambient 0 diffuse 1}
}

#declare T1 =
material { 
        texture {T_Ground}
        scale 0.02
        rotate x*-45               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 94) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  RockTex  http://news.povray.org/povray.text.scene-files/thread/%3C3e0c6248%40news.povray.org%3E/
 
#declare PigmpOne = 
pigment_map {
        [0      rgb <1.0, 0.85, 0.6>*0.45]
        [0.1    rgb <0.5, 0.9, 0.2>*0.15]
        [0.2    rgb <0.75, 0.95, 0.2>*0.15]
        [0.325  rgb <0.9, 0.75, 0.65>]
        [0.5    rgb <0.9, 0.75, 0.55>]
        [0.65   rgb <0.2, 0.1, 0.05>]
        [0.75   rgb <0.95, 0.75, 0.45>]
        [0.825  rgb <0.15, 0.375, 0.05>*0.475]
        [0.875  rgb <0.35, 0.45, 0.0125>*0.5]
        [1      rgb <1, 0.5, 0.2>]
}

#declare PigmpTwo = 
pigment_map {
        [0      rgb <1.0, 0.85, 0.6>*0.3]
        [0.1    rgb <0.5, 0.9, 0.2>*0.1]
        [0.2    rgb <0.75, 0.95, 0.2>*0.1]
        [0.325  rgb <0.9, 0.75, 0.65>]
        [0.5    rgb <0.9, 0.75, 0.55>]
        [0.65   rgb <0.2, 0.1, 0.05>]
        [0.75   rgb <0.95, 0.75, 0.45>]
        [0.825  rgb <0.15, 0.375, 0.05>*0.325]
        [0.85   rgb <0.35, 0.45, 0.0125>*0.35]
        [1      rgb <1, 0.5, 0.2>]
}

#declare RockTex =
texture {
        pigment {
                bozo 
                pigment_map {
                        [0      wrinkles
                                turbulence 0.6 
                                octaves 5
                                pigment_map {PigmpOne}
                                scale 0.75
                        ]
                        [1      agate
                                turbulence 0.6
                                pigment_map {PigmpTwo}
                                scale 0.5
                        ]
                }
                //scale <0.25,2,0.25>
        }
        normal {
                bozo 
                normal_map {
                        [0      wrinkles 0.4
                                turbulence 0.6 
                                octaves 5
                                scale 0.75
                        ]
                        [1      agate 0.2
                                turbulence 0.6
                                scale 0.5
                        ]
                }
                //scale <0.25,2,0.25>
        }
        finish {
                diffuse 1
                ambient 0
                specular 0.35
        }
        rotate x*-90
        //scale <0.5,12,1>
        scale 0.25
}

#declare T1 = 
material {
        texture {RockTex}        
        scale 0.5
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 95) /////////////////////////////////////////////////////////////////////////////////////

// Jim Charter  Boli  http://news.povray.org/povray.binaries.images/message/%3C42055689%241%40news.povray.org%3E/#%3C42055689%241%40news.povray.org%3E

#declare crackle_func =
function {
        pigment {
                average
                pigment_map {
                        [1      crackle
                                turbulence 0.35
                                octaves 4
                                lambda 2.1
                                omega 0.55
                                scale 0.6
                                pigment_map {
                                        [0      rgb 0]
                                        [0.02   rgb 0]
                                        [0.05   rgb 1]
                                        [1      rgb 0.5]
                                }
                        ]
                        [1      crackle 
                                turbulence 0.35
                                octaves 4
                                lambda 2.1
                                omega 0.55
                                scale 0.6                       
                                pigment_map {
                                        [0      rgb 0]
                                        [0.02   rgb 0]
                                        [0.05   crackle 
	                                        turbulence 0.35
                                                octaves 4
                                                lambda 2.1
                                                omega 0.55
                                                scale 0.15
                                                pigment_map {
                                                        [0      rgb 0]
                                                        [0.05   rgb 0]
                                                        [0.1    rgb 0.5]
                                                        [1      rgb 1]
                                                }
                                        ]
                                        [1      crackle 
	                                        turbulence 0.35
                                                octaves 4
                                                lambda 2.1
                                                omega 0.55
                                                scale 0.45
                                                pigment_map {
                                                        [0      rgb 0]
                                                        [0.1    rgb 0]
                                                        [0.3    rgb 0.5]
                                                        [1      rgb 1]
                                                }
                                        ]
                                }
                        ]
                }
        }
} 

#local T1 =
material {
        texture {
                pigment {
                        function {crackle_func (x,y,z).x}
                        color_map {
                                [0      rgb <0.20,0.11,0.02>]
                                [0.15   rgb <0.42,0.21,0.07>]
                        }               
                }
                normal {
                        average
                        normal_map {
                                [1      function {crackle_func (x,y,z).x} 0.7]
                                [1      wrinkles 1 scale 0.001]
                        }
                }
                finish {ambient 0 diffuse 0.7 specular 0.1 roughness 0.01 phong 0.5 phong_size 10}
                scale 0.5
        }
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 96) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/

#declare T1 =  // starfish
material {
        texture {
                pigment {
                        crackle 
                        scale 0.0115 
                        turbulence 0.015 
                        omega 0.7 
                        lambda 5  
                        color_map {
                                [0.0  rgb Ga (<0.7*0.4,0.1*0.4,0.001*0.4>)] 
                                [0.05 rgb Ga (<0.7*0.6,0.1*0.6,0.001*0.6>)] 
                                [0.2  rgb Ga (<0.70,0.100,0.001>)] 
                                [1.0  rgb Ga (<0.45,0.005,0.001>)]
                        } 
                }
                finish {
                        diffuse albedo 0.5 
                        specular albedo 0.05 
                        roughness 0.05 
                        brilliance 1.4 
                        reflection {0.001,0.005 fresnel on} 
                        conserve_energy
                        subsurface {translucency Ga (<1.09,1.59,1.79>*2)*0.05}

                }
                normal {
                        crackle 5 
                        scale 0.0115 
                        turbulence 0.015 
                        omega 0.7 
                        lambda 5
                } 
        } 
        texture {
                pigment {
                        wrinkles 
                        triangle_wave 
                        scale 0.025 
                        turbulence 0.35 
                        omega 0.8 
                        lambda 3.2  
                        color_map {
                                [0.0 rgbt Gat (<0.7, 0.6, 0.001, 0.25>)] 
                                [0.4 rgbt Gat (<0.7, 0.3, 0.001, 1>)] 
                                [0.7 rgbt Gat (<0.7, 0.3, 0.001, 0.5>)] 
                                [1.0 rgbt Gat (<0.5, 0.05,0.001, 1>)] 
                        } 
                }
        }
        interior {ior 1.45}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 97) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee8609f8d61fd8e1370@news.povray.org%3E/

#declare land_tex_finish =      finish {ambient 0 diffuse albedo 0.5 specular 0.07  roughness 0.0035 brilliance 1.1}
#declare land_tex_finish_damp = finish {ambient 0 diffuse albedo 0.3 specular 0.4   roughness 0.001  brilliance 2.5 reflection {0.01, 0.1 fresnel on} conserve_energy}
#declare land_tex_finish_wet =  finish {ambient 0 diffuse albedo 0.3 specular 0.75  roughness 0.001  brilliance 3   reflection {0.01, 0.5 fresnel on} conserve_energy}

// dry textures

#declare dryReduction = 1;

#declare rock_base = 
texture {
        pigment {
                granite 
                triangle_wave 
                omega 0.7 
                lambda 3 
                turbulence 0.275 
                color_map {
                        [0.0    rgb Ga (<0.295, 0.285, 0.27>*dryReduction)] 
                        [1.0    rgb Ga (<0.675, 0.600, 0.45>*dryReduction)] 
                } 
                scale 1.75 
        }  
}

#declare land_tex_1 = 
texture { 
        pigment {
                crackle            
                turbulence 0.75 form <1,0,0>  
                omega 0.7 lambda 4
                scale 0.25     
                color_map {
                        [0.0    rgbt Gat (<0.82*dryReduction, 0.8*dryReduction, 0.785*dryReduction, 0.01>)] 
                        [0.2    rgbt Gat (<0.72*dryReduction, 0.7*dryReduction, 0.600*dryReduction, 0.1>)] 
                        [0.3    rgbt Gat (<0.72*dryReduction, 0.7*dryReduction, 0.600*dryReduction, 1>)] 
                        [0.3    rgbt 1]
                        [1.0    rgbt 1]
                }
        }
}      

#declare land_tex_2 = 
texture { 
        pigment {
                crackle            
                turbulence 0.75// metric 2 form <-2, 1, 0>
                omega 0.7 lambda 3
                scale .02     
                color_map {
                        [0.0    rgbt 1]
                        [0.3    rgbt 1]
                        [0.3    rgbt Gat (<0.20*dryReduction, 0.1*dryReduction, 0.050*dryReduction, 1>)] 
                        [0.5    rgbt Gat (<0.15*dryReduction, 0.1*dryReduction, 0.035*dryReduction, 0.3>)] 
                        [0.9    rgbt Gat (<0.20*dryReduction, 0.1*dryReduction, 0.050*dryReduction, 1>)] 
                        [0.9    rgbt 1]
                        [1.0    rgbt 1]
                }
        }

}

#declare land_tex_3 = 
texture { 
        pigment {
                wrinkles 
                sine_wave           
                turbulence 0.65   
                omega 0.65 lambda 4
                scale 0.602
                color_map {
                        [0.0    rgbt 1]
                        [0.5    rgbt 1]
                        [0.5    rgbt Gat (<0.15*dryReduction, 0.09*dryReduction, 0.015*dryReduction, 1>)] 
                        [1.0    rgbt Gat (<0.15*dryReduction, 0.09*dryReduction, 0.015*dryReduction, 0.7>)] 
                }
        }
}  

#declare land_tex_4 = 
texture { 
        pigment {
                granite 
                sine_wave     
                turbulence 0.45   
                omega 0.65 lambda 4
                scale 1.3
                color_map {
                        [0.0    rgbt 1]
                        [0.65   rgbt 1]
                        [0.65   rgbt Gat (<0.15*dryReduction, 0.09*dryReduction, 0.015*dryReduction, 1>)] 
                        [1.0    rgbt Gat (<0.15*dryReduction, 0.09*dryReduction, 0.015*dryReduction, 0.5>)] 
                }
        }
}

#declare land_tex_5 = 
texture { 
        pigment {
                granite sine_wave           
                turbulence 0.45   
                omega 0.85 lambda 2.7
                scale 0.6
                color_map {
                        [0.0    rgbt 1]
                        [0.7    rgbt 1]
                        [0.7    rgbt Gat (<0.045*dryReduction, 0.155*dryReduction, 0.004*dryReduction, 1>)] 
                        [1.0    rgbt Gat (<0.045*dryReduction, 0.155*dryReduction, 0.004*dryReduction, 0.5>)] 
                }                   
        }
        finish {land_tex_finish}
}

#declare land_tex_dry = 
texture {rock_base}      
texture {land_tex_1}
texture {land_tex_2}
texture {land_tex_3}
texture {land_tex_4} 
texture {land_tex_5} 

// damp textures

#declare dampReduction = 0.52*0.75;

#declare rock_base_damp = 
texture {
        pigment {
                granite 
                triangle_wave 
                omega 0.7 lambda 3 turbulence 0.275 
                color_map {
                        [0.0    rgb Ga (<0.295, 0.25, 0.21>*dampReduction)] 
                        [1.0    rgb Ga (<0.675, 0.45, 0.2>*dampReduction)]
                } 
                scale 1.75 
        }
}

#declare land_tex_1_damp = 
texture { 
        pigment {
                crackle            
                turbulence 0.75 form <1, 0, 0>  
                omega 0.7 lambda 4
                scale 0.25     
                color_map {
                        [0.0   rgbt Gat (<0.82*dampReduction, 0.7*dampReduction, 0.585*dampReduction, 0.01>)] 
                        [0.2   rgbt Gat (<0.72*dampReduction, 0.6*dampReduction, 0.4*dampReduction, 0.1>)] 
                        [0.3   rgbt Gat (<0.72*dampReduction, 0.6*dampReduction, 0.4*dampReduction, 1>)] 
                        [0.3   rgbt 1]
                        [1.0   rgbt 1]
                }
        }
}      

#declare land_tex_2_damp = 
texture { 
        pigment {
                crackle            
                turbulence 0.75// metric 2 form <-2, 1, 0>
                omega 0.7 lambda 3
                scale 0.02     
                color_map {
                        [0.0   rgbt 1]
                        [0.3   rgbt 1]
                        [0.3   rgbt Gat (<0.2*dampReduction, 0.071*dampReduction, 0.035*dampReduction, 1>)] 
                        [0.5   rgbt Gat (<0.15*dampReduction, 0.071*dampReduction, 0.0135*dampReduction, 0.3>)] 
                        [0.9   rgbt Gat (<0.2*dampReduction, 0.071*dampReduction, 0.035*dampReduction, 1>)] 
                        [0.9   rgbt 1]
                        [1.0   rgbt 1]
                }
        }
}

#declare land_tex_3_damp = 
texture { 
        pigment {
                wrinkles sine_wave           
                turbulence 0.65   
                omega 0.65 lambda 4
                scale 0.602
                color_map {
                        [0.0   rgbt 1]
                        [0.5   rgbt 1]
                        [0.5   rgbt Gat (<0.15*dampReduction, 0.069*dampReduction, 0.01*dampReduction, 1>)] 
                        [1.0   rgbt Gat (<0.15*dampReduction, 0.069*dampReduction, 0.01*dampReduction, 0.7>)] 
                 }
        }
}  

#declare land_tex_4_damp = 
texture { 
        pigment {
                granite sine_wave     
                turbulence 0.45   
                omega 0.65 lambda 4
                scale 1.3
                color_map {
                        [0.0   rgbt 1]
                        [0.65  rgbt 1]
                        [0.65  rgbt Gat (<0.15*dampReduction, 0.069*dampReduction, 0.01*dampReduction, 1>)] 
                        [1.0   rgbt Gat (<0.15*dampReduction, 0.069*dampReduction, 0.01*dampReduction, 0.5>)] 
                 }
        }
}

#declare land_tex_5_damp = 
texture { 
        pigment {
                granite sine_wave           
                turbulence 0.45   
                omega 0.85 lambda 2.7
                scale 0.6
                color_map {
                        [0.0   rgbt 1]
                        [0.7   rgbt 1]
                        [0.7   rgbt Gat (<0.025*dampReduction, 0.155*dampReduction, 0.004*dampReduction, 1>)] 
                        [1.0   rgbt Gat (<0.025*dampReduction, 0.155*dampReduction, 0.004*dampReduction, 0.5>)] 
                 }                   
        }
        finish {land_tex_finish_damp}
}

#declare land_tex_damp = 
texture {rock_base_damp}      
texture {land_tex_1_damp}
texture {land_tex_2_damp}
texture {land_tex_3_damp}
texture {land_tex_4_damp}
texture {land_tex_5_damp}

// wet textures 

#declare wetReduction = 0.45*0.5;

#declare rock_base_wet = 
texture {
        pigment {
                granite 
                triangle_wave 
                omega 0.7 
                lambda 3 
                turbulence 0.275 
                color_map {
                        [0.0    rgb Ga (<0.295, 0.25, 0.21>*wetReduction)] 
                        [1.0    rgb Ga (<0.675, 0.45, 0.20>*wetReduction)] 
                } 
                scale 1.75 
        }
}

#declare land_tex_1_wet = 
texture { 
        pigment {
                crackle            
                turbulence 0.75 form <1, 0, 0>  
                omega 0.7 
                lambda 4
                scale 0.25     
                color_map {
                        [0.0    rgbt Gat (<0.82*wetReduction, 0.7*wetReduction, 0.585*wetReduction, 0.01>)] 
                        [0.2    rgbt Gat (<0.72*wetReduction, 0.6*wetReduction, 0.4*wetReduction, 0.1>)] 
                        [0.3    rgbt Gat (<0.72*wetReduction, 0.6*wetReduction, 0.4*wetReduction, 1>)] 
                        [0.3    rgbt 1]
                        [1.0    rgbt 1]
                }
        }
}      

#declare land_tex_2_wet = 
texture { 
        pigment {
                crackle            
                turbulence 0.75// metric 2 form <-2, 1, 0>
                omega 0.7 lambda 3
                scale 0.02     
                color_map {
                        [0.0    rgbt 1]
                        [0.3    rgbt 1]
                        [0.3    rgbt Gat (<0.2*wetReduction, 0.071*wetReduction, 0.035*wetReduction, 1>)] 
                        [0.5    rgbt Gat (<0.15*wetReduction, 0.071*wetReduction, 0.0135*wetReduction, 0.3>)] 
                        [0.9    rgbt Gat (<0.2*wetReduction, 0.071*wetReduction, 0.035*wetReduction, 1>)] 
                        [0.9    rgbt 1]
                        [1.0    rgbt 1]
                }
        }
}

#declare land_tex_3_wet = 
texture { 
        pigment {
                wrinkles 
                sine_wave           
                turbulence 0.65   
                omega 0.65 
                lambda 4
                scale 0.602
                color_map {
                        [0.0    rgbt 1]
                        [0.5    rgbt 1]
                        [0.5    rgbt Gat (<0.15*wetReduction, 0.069*wetReduction, 0.01*wetReduction, 1>)] 
                        [1.0    rgbt Gat (<0.15*wetReduction, 0.069*wetReduction, 0.01*wetReduction, 0.7>)] 
                }
        }
}  

#declare land_tex_4_wet = 
texture { 
        pigment {
                granite sine_wave     
                turbulence 0.45   
                omega 0.65 lambda 4
                scale 1.3
                color_map {
                        [0.0    rgbt 1]
                        [0.65   rgbt 1]
                        [0.65   rgbt Gat (<0.15*wetReduction, 0.069*wetReduction, 0.01*wetReduction, 1>)] 
                        [1.0    rgbt Gat (<0.15*wetReduction, 0.069*wetReduction, 0.01*wetReduction, 0.5>)] 
                }
        }
}

#declare land_tex_5_wet = 
texture { 
        pigment  {
                granite sine_wave           
                turbulence 0.45   
                omega 0.85 lambda 2.7
                scale 0.6
                color_map {
                        [0.0    rgbt 1]
                        [0.7    rgbt 1]
                        [0.7    rgbt Gat (<0.025*wetReduction, 0.155*wetReduction, 0.004*wetReduction, 1>)] 
                        [1.0    rgbt Gat (<0.025*wetReduction, 0.155*wetReduction, 0.004*wetReduction, 0.5>)] 
                }                   
        }
        finish {land_tex_finish_wet}
}

#declare land_tex_wet = 
texture {rock_base_wet}      
texture {land_tex_1_wet}
texture {land_tex_2_wet}
texture {land_tex_3_wet}
texture {land_tex_4_wet}
texture {land_tex_5_wet}

#declare land_tex = 
texture {
        gradient y  
        triangle_wave          
//        turbulence 0.275
//        omega 0.526 lambda 2.5 
        texture_map {
                [0.0    land_tex_wet]// scale 0.2 ]
                [0.48   land_tex_wet]// scale 0.2 ]
                [0.5    land_tex_damp]// scale 0.2 ]
                [0.55   land_tex_damp]// scale 0.2 ]
                [0.65   land_tex_dry]// scale 0.2 ]
                [1.0    land_tex_dry]// scale 0.2 ]
        }   
        scale 5.5   
        turbulence 0.025
        //translate <0,-1.475,0>
}

#declare T1 = 
material {
        texture {land_tex}        
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 98) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/ 

#declare T1 =
material {
        texture {
                pigment {
                        granite 
                        scallop_wave 
                        omega 0.82 
                        lambda 2.3 
                        turbulence 0.45 
                        color_map {
                                [0.0    rgb Ga (<0.03, 0.03, 0.05>)]
                                [0.3    rgb Ga (<0.025, 0.025, 0.03>)]
                                [0.8    rgb Ga (<0.04, 0.04, 0.05>)]
                                [1.0    rgb Ga (<.0225, 0.0265, 0.02>)]
                        }
                }      
        }    
        texture {
                pigment {
                        wrinkles 
                        scallop_wave  
                        omega 0.8 
                        lambda 2.7 
                        turbulence 0.175 
                        color_map {
                                [0.0    rgbt <1, 1, 1, 1>]
                                [0.5    rgbt <1, 1, 1, 1>]
                                [0.5    rgbt Gat (<0.015, 0.035, 0.004, 1>)]
                                [0.51   rgbt Gat (<0.015, 0.035, 0.004, 0.2>)]
                                [0.52   rgbt Gat (<0.015, 0.025, 0.004, 0.05>)]
                                [0.53   rgbt Gat (<0.015, 0.035, 0.004, 0.05>)]
                                [0.54   rgbt Gat (<0.040, 0.040, 0.004, 1>)]
                                [0.54   rgbt <1, 1, 1, 1>]
                                [1.0    rgbt <1, 1, 1, 1>]
            
                        }
                        scale 0.5
                }
        }              
        texture {
                pigment {
                        crackle     
                        scallop_wave
                        turbulence 0.025
                        lambda 3.1
                        omega 0.6255
                        octaves 9
                        color_map {
                                [0.0    rgbt 1]
                                [0.5    rgbt 1]
                                [0.5    rgbt Gat (<1.0, 0.7, 0.3, 1>)]
                                [0.505  rgbt Gat (<1.0, 0.7, 0.3, 0.05>)]
                                [0.51   rgbt Gat (<1.0, 0.7, 0.3, 0.05>)]
                                [0.515  rgbt Gat (<0.8, 0.9, 0.6, 0.01>)]
                                [0.52   rgbt Gat (<0.8, 0.9, 0.7, 0.01>)]
                                [0.5225 rgbt Gat (<0.8, 0.9, 0.6, 1>)]
                                [0.5225 rgbt 1]
                                [1.0    rgbt 1]
                        }        
                        scale 1.25  
                        translate <-0.2,0.1,0> 
                }
        } 
        texture {
                pigment {
                        granite 
                        turbulence 0.075
                        lambda 3.1
                        omega 0.655
                        octaves 9
                        color_map {
                                [0.0    rgbt 1]
                                [0.7    rgbt 1]
                                [0.7    rgbt Gat (<1.0, 0.7, 0.3, 1>)]
                                [0.71   rgbt Gat (<1.0, 0.7, 0.3, 0.05>)]
                                [0.75   rgbt Gat (<1.0, 0.7, 0.3, 0.05>)]
                                [0.76   rgbt Gat (<0.8, 0.9, 0.6, 0.01>)]
                                [0.8    rgbt Gat (<0.8, 0.9, 0.7, 0.01>)]
                                [0.81   rgbt Gat (<0.8, 0.9, 0.6, 1>)]
                                [0.81   rgbt 1]
                                [1.0    rgbt 1]
                        }        
                        scale 0.45
                }
        } 
        texture {
                pigment {
                        bozo  
                        color_map {
                                [0.0    rgbf Gat (<0.98, 0.99, 0.98, 0.99>)] 
                                [1.0    rgbf 1] 
                        } 
                        scale 0.5 
                }
                normal {granite 0.1 scale 0.0001}              
                finish {
                        specular albedo 0.1 
                        roughness 0.025 
                        ambient 0 
                        diffuse albedo 0.2 
                        brilliance 4 
                        reflection {0.01 0.15 fresnel on} 
                        conserve_energy   
                }
        }
        interior {ior 1.5}  
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 99) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/

#declare dampReduction = 0.2;

#declare stoneFinish = 
finish {
        diffuse albedo 0.6
        brilliance 1.6
        specular 0.025 
        roughness 0.15
}

#declare stoneFinishDamp = 
finish {                
        diffuse albedo 0.3         
        brilliance 3.0
        specular 0.4*2 
        roughness 0.002
        phong 0.1*2   
        phong_size 90    
        reflection {0.01, 0.5 fresnel on} 
        conserve_energy
} 

#declare tStone1Wet = 
texture  {
        pigment {
                wrinkles          
                triangle_wave
                turbulence 0.55
                omega 0.85
                lambda 3
                color_map {
                        [0.0    rgb Ga (<1, 0.99, 0.96>*0.75*dampReduction)]
                        [0.2    rgb Ga (<1, 0.96, 0.9>*0.45*dampReduction)]
                        [0.4    rgb Ga (<1, 0.965, 0.96>*0.55*dampReduction)]
                        [0.7    rgb Ga (<1, 0.99, 0.99>*0.35*dampReduction)]
                        [1.0    rgb Ga (<1, 0.95, 0.95>*0.75*dampReduction)]
                }  
                scale <0.75,1.2,0.5>
        }                
}
texture {
        pigment {
                ripples          
                scallop_wave
                turbulence 0.5
                omega 0.55
                lambda 5
                color_map {
                        [0.0    rgbt <1, 1, 1, 1> ]
                        [0.9    rgbt <1, 1, 1, 1> ]
                        [0.92   rgbt Gat (<0.2*dampReduction, 0.170*dampReduction, 0.12*dampReduction, 0.5>)]
                        [0.94   rgbt Gat (<0.1*dampReduction, 0.072*dampReduction, 0.05*dampReduction, 0.2>)]
                        [1.0    rgbt <1, 1, 1, 1> ]
                }
                scale <0.25,0.6,0.15>
        }
        finish {stoneFinishDamp}
}

#declare tStone1Dry = 
texture {
        pigment {
                wrinkles          
                triangle_wave
                turbulence 0.55
                omega 0.85
                lambda 3
                color_map {
                        [0.0    rgb Ga (<1, 0.99, 0.96>*0.75)]
                        [0.2    rgb Ga (<1, 0.96, 0.9>*0.45)]
                        [0.4    rgb Ga (<1, 0.965, 0.96>*0.55)]
                        [0.7    rgb Ga (<1, 0.99, 0.99>*0.35)]
                        [1.0    rgb Ga (<1, 0.95, 0.95>*0.75)]
                }  
                scale <0.75,1.2,0.5>
        }
        normal {
                wrinkles 0.5          
                triangle_wave
                turbulence 0.55
                omega 0.85
                lambda 3  
                scale <0.75,1.2,0.5>
        }                
}
texture {
        pigment {
                ripples         
                scallop_wave
                turbulence 0.5
                omega 0.55
                lambda 5
                color_map {
                        [0.0    rgbt <1, 1, 1, 1> ]
                        [0.9    rgbt <1, 1, 1, 1> ]
                        [0.92   rgbt Gat (<0.2, 0.17, 0.12, 0.5>)]
                        [0.94   rgbt Gat (<0.1, 0.072, 0.05, 0.2>)]
                        [1.0    rgbt <1, 1, 1, 1> ]   
                }
                scale <0.25,0.6,0.15>
        }
        normal {
                ripples 0.5        
                scallop_wave
                turbulence 0.5
                omega 0.55
                lambda 5
                scale <0.25,0.6,0.15>
        }
        finish {stoneFinish}
}

#declare T1 = 
material {
        texture {
                gradient y 
                texture_map {
                        [0.0    tStone1Wet scale 0.3]
                        [0.5    tStone1Dry scale 0.3]
                }
        }
        interior {ior 1.6}
        scale 4.65
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 100) /////////////////////////////////////////////////////////////////////////////////////

// Margus Ramst  grotesque  http://news.povray.org/povray.binaries.scene-files/message/%3C378B53EB.7D10FDF8%40peak.edu.ee%3E/#%3C378B53EB.7D10FDF8%40peak.edu.ee%3E

#declare T1 =
material {
        texture {
                pigment {
                        crackle
                        pigment_map {
                                [0.02   hsl (0.9,0.4,0.7)]
                                [0.07   bozo
                                        color_map {
                                                [0.3    hsl (0.05,0.4,0.9)]
                                                [1      hsl (0.05,0.6,0.7)]
                                        }
                                        turbulence 0.2
                                        scale 0.6667
                                ]
                        }
                        scale 0.3
                        turbulence 0.3
                }
                normal {
                        average
                        normal_map {
                                [1      crackle 0.7 
                                        slope_map {
                                                [0,     <1,0>]
                                                [0.07,  <0,0>]
                                        } 
                                        scale 0.3 
                                        turbulence 0.3
                                ]
                                [1      crackle 1.5 
                                        slope_map {
                                                [0,     <1,0>]
                                                [0.4,   <1,-0.05>]
                                                [0.6,   <0.8,-0.3>]
                                                [1,     <-1,-2>]
                                        } 
                                        scale 0.1 
                                        turbulence 0
                                ]
                                [1      granite 0.3 scale 0.1]
                        }
                }
                finish {
                        diffuse 0.5
                        specular 0.4 
                        roughness 0.04
                        subsurface {translucency srgb <0.2,0.4,0.4>}
                }
        }
        scale 0.5
        interior {ior 1.37}        
}   

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 101) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  Sierpinski Gasket Study  http://paulbourke.net/exhibition/povfrac/final/0028.pov

#declare T1 =  
material {
        texture {
                pigment {
                        bozo
                        turbulence 0.5
                        color_map {
                                [0.0 color Copper*0.1] 
                                [0.5 color Copper*0.2] 
                                [1.0 color Copper*0.3] 
                        } 
                }
                normal {
                        bozo 
                        turbulence 0.5 
                        normal_map {
                                [0 bumps 0.25*3 scale 1.1 turbulence 0.25]
                                [1 granite 0.5*3 turbulence 0.2]
                        }
                } 
                finish {diffuse 0.8 specular 0.1 roughness 0.125}
        }
        texture {
                pigment {rgbf <1,1,1,0.9>}
                normal {crackle 1.25 turbulence 0.2*5}
                finish {specular 0.2 roughness 0.125}
        }
        scale 0.02
        interior {ior 1.5} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 102) /////////////////////////////////////////////////////////////////////////////////////

// Kirk Andrews  OfRocksAndSand  http://www.tektonart.com/wp-content/uploads/2010/01/OfRocksAndSand.zip

#declare r = seed (9);

#declare ProxF =
function {
        pigment {
                average
                pigment_map {
                        #local i = 0;
                        #while (i < 30-20)  // with this setup the material needs to much RAM and time with "(i < 30)"!
                                [       object {
                                                object {set_up translate <rand (r)-0.5,rand (r)-0.5,rand (r)-0.5>*rand (r)*1}
                                                rgb 0,
                                                rgb 1
                                        }
                                ] 
                                #local i = i+1;
                        #end              
                }
        }
}

#declare RockPig =
pigment {      
        cells
        turbulence 2 lambda 15
        scale <2.5,0.8,2.5>*0.2 
        rotate -30*x
        color_map {
                [0.0 rgb Ga (<0.7,0.5,0.3>)]
                [0.5 rgb Ga (<0.4+0.2,0.4,0.4-0.2>)]
                [1.0 rgb Ga (<0.3,0.2,0.1>)]
        }  
        warp {turbulence 0.2}
        scale 0.1
        warp {turbulence 0.2}
        scale 10
}

#declare RockNorm1 =
normal {
        slope y
        normal_map {
                [0.5    granite -2 
                        scale 0.5*y 
                        rotate -30*x   
                        warp {turbulence 0.2}
                        scale 0.1
                        warp {turbulence 0.2}
                        scale 10*0.3
                ]
                [1.0    granite -0.1 scale 0.5*0.6]
        }
}

#declare RockTex =
texture {
        pigment {
                function {ProxF (x,y,z).x}
                pigment_map {
                        [0.0 rgb Ga (<1,0.9,0.8>)]
                        [0.3 RockPig]
                        [1.0 rgb Ga (<0.1,0.05,0>)]
                }
        }
        normal {
                average 
                normal_map {
                        [RockNorm1]
                        [function {ProxF (x,y,z).x}]
                        [granite 0.05 scale 0.05*0.6]
                }
        }  
}

#declare SandPig1 =
pigment {
        function {ProxF (x,y,z).x}
        pigment_map {
                [0.2  rgbt Gat (<0.9,0.7,0.5, 1.25>)*0.8]
                [0.5  rgbt Gat (<0.9,0.7,0.5,0.125>)*0.8]
                [1.0  rgbt Gat (<0.9,0.7,0.5,0.125>)*0.8]
        }
}
  
#declare SandTex =
texture {
        pigment {
                slope y
                pigment_map {
                        [0.7  rgbt Gat (<0.9,0.7,0.5,1.25>)*0.8]
                        [0.7  SandPig1]  
                }
        }
        normal {granite 0.2 scale 0.025}
}

#declare T1 =
material {
        texture {RockTex}
        texture {SandTex}               
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 103) /////////////////////////////////////////////////////////////////////////////////////

// Phil Brewer  quincy  http://www.irtc.org/ftp/pub/stills/2006-08-31/quincy.zip

#declare rusted_metal_tex =
texture {
        pigment {
                bozo
                color_map {
                        [0.0 rgb <42,35,32>/255]
                        [1.0 rgb <60,47,38>/255]
                }
        }
        normal {granite 0.1 scale 2}
        finish {ambient 0 diffuse 0.5*1.5 specular 0.05 roughness 0.05}
}

#declare rusted_metal_tex5 =
texture {
        pigment {
                bozo
                frequency 2
                turbulence 0.4
                octaves 8 lambda 1.5 omega 0.8
                color_map {
                        [0   color <87,71,45>/255]
                        [0.6 color <86,45,10>/255]
                        [1   color <50,21,20>/255]
                } 
        }
        normal {granite 0.7 turbulence 0.4 octaves 8 lambda 1.5 omega 0.8} 
        finish {ambient 0 diffuse 0.5*1.5 specular 0.05 roughness 0.05}
}

#declare rusted_metal_tex6 =
texture {
        bozo
        turbulence 0.4 
        octaves 8 lambda 1.5 omega 0.8  
        texture_map {
                [0.0 rusted_metal_tex5 scale 0.2]
                [0.3 rusted_metal_tex5 scale 0.5]
                [0.5 rusted_metal_tex]
                [1.0 rusted_metal_tex]
        }
}

#declare T1 =
material {
        texture {rusted_metal_tex6}
        scale 0.25               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 104) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia  candles  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3bcb185c@news.povray.org%3E/candles.pov.txt

#declare T1 =
material {
        texture {
                pigment {rgb <1,0.75,0.5>}
                finish {
                        diffuse 0.5 
                        specular 1 roughness 0.02 
                        reflection {0,1 fresnel metallic} 
                        brilliance 4 
                        metallic
                }
                normal {granite -0.3 cubic_wave scale 5}
        }
        scale 0.1               
        interior {ior 2.1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 105) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  Loth  http://www.irtc.org/ftp/pub/stills/2001-08-31/loth.zip

#declare T1 = //menhir
material {
        texture {
                pigment {rgb <0.65+0.1,0.725,0.7>}
                normal {
                        average 
                        normal_map {
                                [bumps 5 scale 0.1 ramp_wave] 
                                [agate 10 scale 0.5 ramp_wave]
                                [granite 2 turbulence 0.8 scale 2] 
                                [crackle 5 turbulence 0.8 scale 1]
                        }
                        scale <1,2,1>
                }
                finish {ambient 0 diffuse 0.6 specular 0.75 roughness 0.01}
        }
        scale 0.1               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 106) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  Boreal  http://hof.povray.org/images/Boreal_big.jpg

#declare stone1_pig =
pigment {
        image_map {png "1a" gamma 1 interpolate 2}
        translate -0.5
        scale 5
        warp {turbulence 0.3 lambda 2}
}

#declare stone2_pig =
pigment {
        image_map {png "4a" gamma 1 interpolate 2}
        translate -0.5
        scale 5
        warp {turbulence 0.3 lambda 2}
}

#declare stone_tex =
texture {
        pigment {
                marble  
                warp {turbulence 0.2 lambda 3}
                pigment_map {
                        [0      stone1_pig]
                        [1      stone2_pig]
                }
        }
        normal {
                marble 0.4
                warp {turbulence 0.4 lambda 3}
        }
        finish {ambient 0 diffuse 0.5 specular 0.2 brilliance 2 roughness 0.05}
        rotate -30
        scale 0.125
}

#declare trans_pig = pigment {rgbt 1}
 
#declare moss1_pig =
pigment {
        image_map {png "m2a" gamma 1 interpolate 2}
        translate -0.5
        scale 3
        warp {turbulence 0.6 lambda 2}
}

#declare moss2_pig =
pigment {
        image_map {png "m4a" gamma 1 interpolate 2}
        translate -0.5
        scale 3
        warp {turbulence 0.6 lambda 2}
}

#declare moss_tex =
texture {
        pigment {
                bozo
                turbulence 0.5 frequency 3 lambda 6  
                pigment_map {
                        [0.6    trans_pig]
                        [0.7    moss1_pig]
                        [1.0    moss2_pig]
                }
        }
        normal {bumps 15 scale 0.001}
        finish {ambient 0 diffuse 0.3 specular 0.2 roughness 0.005}
        rotate -30
        scale 0.125
}

#declare T1 =
material { 
        texture {stone_tex}
        texture {moss_tex}
        scale 5               
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 107) /////////////////////////////////////////////////////////////////////////////////////

// Christophe Bouffartigue  cbfort  http://www.irtc.org/ftp/pub/stills/2001-04-30/cbfort.zip

#declare Pat_Rust = 
pigment {
	bozo
	scale 0.4
	warp {turbulence 0.3 lambda 3}
	scale 4
	warp {turbulence 0.7 lambda 7}
	scale 0.05
	color_map {
		[0.45 rgb 0]
		[0.50 rgb 1]
	}
}

#declare Norm_Rust = 
normal {
	pigment_pattern {Pat_Rust}
	normal_map {
		[0.45 bumps 0.3 turbulence 0.3 scale 0.1]
		[0.50 bumps 1.3 turbulence 0.3 scale 0.01]
	}
}

#declare txtMine1 = 
texture {
	pigment {
		pigment_pattern {Pat_Rust}
		pigment_map {
			[0 rgb <0.3,0.3,0.4>]
			[1 rgb <0.5,0.3,0.1>]
		}
	}
	normal {
		average
		normal_map {
			[1 pigment_pattern {Pat_Rust} bump_size 1.5]
			[1 Norm_Rust]
		}
	}
	finish {specular 0.05 roughness 0.2 reflection 0.05}
}

#declare txtMine2 = 
texture {
	pigment {
		pigment_pattern {Pat_Rust}
		pigment_map {
			[0 rgb <0.3,0.3,0.4>*0.8]
			[1 rgb <0.5,0.3,0.1>*0.8]
		}
	}
	normal {
		average
		normal_map {
			[1 pigment_pattern {Pat_Rust} bump_size 1.5]
			[1 Norm_Rust]
		}
	}
	finish {specular 0.5 roughness 0.1 reflection 0.15}
}

#declare txtMine = 
texture {
	pigment_pattern {
		agate//gradient y
		warp {turbulence 0.3 octaves 2}
		//<0.6,3,0.6>
		//translate -y
	}
	texture_map {
		[0.40 txtMine2]
		[0.42 txtMine1]
	}
}

#declare T1 =
material { 
        texture {txtMine}               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 108) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  snowman  http://www.irtc.org/ftp/pub/stills/2006-02-28/snowman.zip

#declare snowTex = 
texture {
        pigment {rgb <1,1,1>}  // was 0.001
        finish {ambient 0 diffuse 0.9 brilliance 1.75 specular 1.5 roughness 0.0001 reflection 0.025}
        normal {
                average 
                normal_map {
                        [1  granite 0.5 scale 0.002 turbulence 1 omega 0.4 lambda 1.2]
                        [1  wrinkles 0.75 scale 0.15] 
                }     
        }
}

#declare T1 =
material { 
        texture {snowTex}               
        interior {ior 1.31}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 109) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  strings  http://www.irtc.org/ftp/pub/stills/2006-04-30/strings.zip 

#declare silverTex =
texture {
        pigment {rgb Ga (<0.5,0.51,0.525>)}                            
        finish {
                ambient 0 
                diffuse 0.5 
                specular 1*0.5 
                roughness 0.025 
                brilliance 8 
                reflection {0.1,0.025 metallic fresnel on} 
                conserve_energy
        }                 
}      
texture {
        pigment {     
                wrinkles  
                triangle_wave
                turbulence 0.3
                omega 0.7
                color_map {
                        [0.0 rgbt Gat (<0.45, 0.41, 0.39, 1>)] 
                        [0.4 rgbt Gat (<0.45, 0.41, 0.39, 0>)] 
                        [0.7 rgbt Gat (<0.40, 0.35, 0.30, 0>)]
                        [1.0 rgbt Gat (<0.40, 0.35, 0.30, 1>)]
                }      
                scale 0.25
        }
        normal {     
                wrinkles 0.5 
                triangle_wave
                turbulence 0.3
                omega 0.7      
                scale 0.25
        }                            
        finish {
                ambient 0 
                diffuse 0.36 
                specular 1*0.5 
                roughness 0.025 
                brilliance 7 
                reflection {0.051, 0.0125 metallic fresnel on} 
                conserve_energy
        }                 
}      
texture {
        pigment {     
                wrinkles  
                turbulence 0.3
                omega 0.75   
                color_map {
                        [0.00 rgbt <1, 1, 1, 1> ] 
                        [0.80 rgbt <1, 1, 1, 1> ] 
                        [0.80 rgbt Gat (<0.125, 0.05, 0, 1>)] 
                        [0.95 rgbt Gat (<0.125, 0.05, 0, 0.1>)] 
                        [1.00 rgbt Gat (<0.125, 0.05, 0, 0>)]
                }      
                scale 1.5
        }
        normal {     
                wrinkles 0.5 
                turbulence 0.3
                omega 0.75         
                scale 1.5
        }                            
        finish {
                ambient 0 
                diffuse 0.5 
                specular 1*0.5 
                roughness 0.025 
                brilliance 6 
                reflection {0.05, 0.0125 metallic fresnel on} 
                conserve_energy
        }                 
}

#declare T1 =
material {  
        texture {silverTex}
        scale 0.7               
        interior {ior 1.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 110) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  strings  http://www.irtc.org/ftp/pub/stills/2006-04-30/strings.zip 

#declare diff = 0.9;

#declare T1 =  // wood
material {
        texture {
                pigment {
                        bozo                 
                        turbulence 0.1275
                        omega 0.8
                        lambda 3
                        color_map {
                                [ 0.0 rgb Ga (<0.300, 0.010, 0>)]
                                [ 0.1 rgb Ga (<0.200, 0.002, 0>)]
                                [ 0.3 rgb Ga (<0.150, 0.010, 0>)]
                                [ 0.7 rgb Ga (<0.120, 0.005, 0>)]
                                [ 0.9 rgb Ga (<0.243, 0.010, 0>)]
                                [ 1.0 rgb Ga (<0.120,0.0025, 0>)]
                        }                                  
                        rotate <0,90,-1>         
                        scale <50,10,10>       
                }      
                finish {diffuse diff}
        }     
        texture {
                pigment {
                        wood                 
                        turbulence 0.1275
                        omega 0.7
                        lambda 3
                        color_map {
                                [ 0.0 rgbt Gat (<0.2, 0.04, 0, 0.8>)]
                                [ 0.1 rgbt Gat (<0.1, 0.01, 0, 0.1>)]
                                [ 0.3 rgbt Gat (<0.2, 0.04, 0, 0.5>)]
                                [ 0.7 rgbt Gat (<0.1, 0.01, 0, 0.7>)]
                                [ 0.9 rgbt Gat (<0.2, 0.04, 0, 0.1>)]
                                [ 1.0 rgbt Gat (<0.1, 0.01, 0, 0.7>)]
                        }                                  
                        rotate <0,90,-1>         
                        scale <10,10,3>       
                }      
                finish {diffuse diff}        
        }     
        texture {
                pigment {
                        wood                 
                        turbulence 0.11
                        omega 0.67
                        lambda 2
                        color_map {
                                [ 0.000 rgbt <1, 1, 1, 1> ]
                                [ 0.100 rgbt <1, 1, 1, 1> ]
                                [ 0.100 rgbt Gat (<0.03, 0.001, 0.001, 1>)]
                                [ 0.125 rgbt Gat (<0.03, 0.001, 0.001, 0.1>)]
                                [ 0.150 rgbt Gat (<0.03, 0.001, 0.001, 1>)]
                                [ 0.150 rgbt <1, 1, 1, 1> ]
                                [ 0.700 rgbt <1, 1, 1, 1> ]
                                [ 0.700 rgbt Gat (<0.03, 0.001, 0.001, 1>)]
                                [ 0.750 rgbt Gat (<0.03, 0.001, 0.001, 0.1>)]
                                [ 0.800 rgbt Gat (<0.03, 0.001, 0.001, 1>)]
                                [ 0.800 rgbt <1, 1, 1, 1> ]
                        }                                  
                        rotate <0,90,-1>         
                        scale <10,10,3>      
                }
                finish {diffuse diff}       
        }       
        texture {// varnish
                pigment {
                        granite 
                        scallop_wave    
                        turbulence 0.8
                        omega 0.8 
                        color_map {
                                [ 0.000 rgbt Gat (<0.3, 0, 0, 0.95>)]
                                [ 0.075 rgbt Gat (<0.3, 0, 0, 0.95>)]
                                [ 0.075 rgbt Gat (<0.9, 0.8, 0.6, 0.15>)]
                                [ 0.150 rgbt Gat (<0.9, 0.8, 0.6, 0.15>)]
                                [ 0.150 rgbt Gat (<0.3, 0, 0, 0.95>)]
                                [ 0.200 rgbt Gat (<0.3, 0, 0, 0.95>)]
                                [ 0.200 rgbt Gat (<0.5, 0.3, 0.02, 0>)]
                                [ 0.250 rgbt Gat (<0.5, 0.3, 0.02, 0>)]
                                [ 0.250 rgbt Gat (<0.3, 0, 0, 0.95>)]
                                [ 1.000 rgbt Gat (<0.3, 0, 0, 0.95>)]
                        }               
                        scale 100
                }
                finish {ambient 0 diffuse diff phong 1 phong_size 90 reflection 0.025}     
                normal {wrinkles 0.01 turbulence 0.3 scale <100,0.5,0.5> rotate <0,0,-1>}     
        }
        scale 0.05
        rotate x*90               
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 111) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  strings  http://www.irtc.org/ftp/pub/stills/2006-04-30/strings.zip 

#declare freq = 150;

#declare T1 =  // string
material {
        texture {
                pigment {rgb Ga (<0.9,0.565,0.12>)}
                normal {
                        marble 
                        frequency freq/32 
                        bump_size (100/freq) 
                        scallop_wave 
                        turbulence 0.04 
                        omega 0.6 
                        translate <-(freq/64),0,0>
                }
                finish {
                        ambient 0 
                        specular 2 roughness 0.01 
                        phong 2 phong_size 125 
                        brilliance 2 
                        reflection {0.1,0.05 fresnel on metallic} 
                        conserve_energy
                }
        }
        scale 0.1               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 112) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Blue*0.25; 
#declare c2 = Green*0.5;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 113) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Red*0.125; 
#declare c2 = Yellow*0.5;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 114) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Blue*0.2+Green*0.1; 
#declare c2 = Yellow*0.5;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 115) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Violet*0.5; 
#declare c2 = Red;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 116) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Red*0.5; 
#declare c2 = Green;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 117) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Black; 
#declare c2 = White;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 118) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Black; 
#declare c2 = Red;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 119) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Blue*0.5; 
#declare c2 = Orange;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 120) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Black; 
#declare c2 = Aquamarine;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 121) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres car paint  http://news.povray.org/povray.binaries.images/message/%3C41d83ed3%40news.povray.org%3E/#%3C41d83ed3%40news.povray.org%3E

#declare rmin = 0.1;
#declare rmax = 0.33;

#declare c1 = Black; 
#declare c2 = Blue*0.7+Green*0.3;

#declare T1 =
material {
        texture {
                pigment {rgb c2}
                finish {specular 2 metallic roughness 0.1 brilliance 10}
        }
        texture {
                pigment {rgb c1 transmit 0.33}
                finish {
                        specular 1 
                        roughness 0.0125
                        diffuse 1-rmax 
                        reflection {rmin,rmax} 
                        conserve_energy
                        irid {0.05 thickness pi/2*0.5}
                }
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 122) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  baubles  http://www.ignorancia.org/uploads/zips/baubles-demo.zip

#declare p_metal = Brass*0.3+Gold*0.3;

#declare t_metal =
texture {
        pigment {p_metal}
        finish {reflection {p_metal,1} diffuse (1-(p_metal.gray+((1-p_metal.gray)/2)))}
}

#local s_bauble = rgb <0.25,0.65,0.55>;
#local rfi = 0.5;

#local t_bauble_paint =
texture {
        pigment {s_bauble}
        finish {reflection {s_bauble*rfi,s_bauble.gray*rfi} conserve_energy}
}

#local t_b =
texture {
        material_map {       
                png "bauble4" map_type 0 interpolate 2
                texture {t_metal        normal {bump_map {png "bauble4" map_type 0 bump_size  1}}}
                texture {t_bauble_paint normal {bump_map {png "bauble4" map_type 0 bump_size -1}}}
        }
}

#declare T1 =
material {  
        texture {t_b}
        scale 3               
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 123) /////////////////////////////////////////////////////////////////////////////////////

// Margus Ramst  twined_torus  http://www.hot.ee/margusrt/code/twined_torus.zip

#declare T1 =
material {  
        texture {
                pigment {
                        crackle
                        pigment_map {
                                [0      rgb 0.1]
                                [0.12   crackle 
                                        solid 
                                        color_map {
                                                [0 hsl (0.11,0.4,0.6)]
                                                [1 hsl (0.22,0.2,0.8)]
                                        }
                                ]
                        }
                        offset 0.5
                        scale 0.015
                        warp {turbulence 0.1} 
                        scale 2
                }
                normal {
                        crackle 0.5*2 
                        offset 0.5 
                        scale 0.015
                        warp {turbulence 0.1} 
                        scale 2
                }
                finish {ambient 0 specular 0.1 roughness 0.05}
        }
                      
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 124) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/

#declare rock_base = 
texture {
        pigment {
                granite 
                triangle_wave 
                omega 0.6 lambda 3 turbulence 0.275 
                color_map { 
                        [0.0 rgb Ga (<0.175, 0.175, 0.175>)] 
                        [1.0 rgb Ga (<0.425, 0.425, 0.425>)] 
                } 
                scale 0.25 
        }
        finish {ambient 0 diffuse 0.5}
}

#declare rock_tex_1 = 
texture {  
        pigment {
                wrinkles            
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map {
                        [0.0 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [0.5 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [0.5 rgbt Gat (<0.15, 0.09, 0.015, 1>)] //rgbt 1 ]
                        [0.8 rgbt Gat (<0.15, 0.09, 0.015, 0.25>)] //rgbt 1 ]
                        [1.0 rgbt Gat (<0.15, 0.091, 0.015, 0.1>)] //rgbt 1 ]
                }                         
                scale 25
        }
        finish {ambient 0 diffuse 0.45 specular 0 phong 0}
}          

#declare rock_tex_2 = 
texture {  
        pigment {
                wrinkles  
                scallop_wave          
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map {
                        [ 0.00 rgbt Gat (<0.15, 0.09, 0.015, 0.1>)] //rgbt 1 ]
                        [ 0.50 rgbt Gat (<0.15, 0.09, 0.015, 0.5>)] //rgbt 1 ]
                        [ 0.75 rgbt Gat (<0.15, 0.091, 0.015, 1>)] //rgbt 1 ]
                        [ 0.75 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 1.00 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                }                         
                scale 15
        }
        finish {ambient 0 diffuse 0.45 specular 0 phong 0}
}          

#declare rock_tex_3 = 
texture {  
        pigment {
                bozo scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map {
                        [ 0.000 rgbt 1 ]
                        [ 0.900 rgbt 1 ]
                        [ 0.925 rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.975 rgbt Gat (<0.0075, 0.06, 0.0005, 0.4>)] 
                        [ 1.000 rgbt Gat (<0.0075, 0.06, 0.0005, 0>)] 
                 }
        } 
        finish {ambient 0 diffuse 0.5 specular 0 phong 0}
        scale 20
} 

#declare rock_tex_4 = 
texture {  
        pigment {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                color_map {
                        [ 0.00 rgbt 1 ]
                        [ 0.10 rgbt 1 ]
                        [ 0.15 rgbt Gat (<0.1, 0.06, 0.01, 1>)] 
                        [ 0.30 rgbt Gat (<0.1, 0.06, 0.01, 0.1>)] 
                        [ 0.45 rgbt Gat (<0.1, 0.06, 0.01, 1>)] 
                        [ 0.50 rgbt 1 ]
                        [ 0.60 rgbt 1 ]
                        [ 0.65 rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.75 rgbt Gat (<0.0075, 0.06, 0.0005, 0.05>)] 
                        [ 0.90 rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.95 rgbt 1 ]
                        [ 1.00 rgbt 1 ]
                 }
                scale 0.1
        }          
        finish {ambient 0 diffuse 0.45 specular 0 phong 0}
}

#declare rock_tex_dry = 
texture {rock_base scale 10}
texture {rock_tex_1}
texture {rock_tex_2}
texture {rock_tex_3}
texture {rock_tex_4 finish {ambient 0 diffuse 0.7 specular 0 phong 0}}

#declare rock_tex_wet = 
texture {rock_base scale 10}
texture {rock_tex_1}
texture {rock_tex_2}
texture {rock_tex_3}
texture {rock_tex_4 finish {ambient 0 diffuse 0.2 specular 0.5 roughness 0.001 phong 0.5 phong_size 150}}

#declare rock_tex = 
texture {
        gradient y    
        scale 3.3 //5        
        texture_map {
                [0.00 rock_tex_wet scale 0.005]
                [0.50-0.2 rock_tex_wet scale 0.005]
                [0.55-0.1 rock_tex_dry scale 0.005]
                [1.00 rock_tex_dry scale 0.005]
         }   
         //translate <0, -1.45, 0>
}

#declare T1 =
material {  
        texture {rock_tex}               
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 125) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  aliums  http://www.irtc.org/ftp/pub/stills/2005-02-28/aliums.zip

#declare T1 =  // vase
material {
        texture {
                gradient y 
                lambda 4
                omega 0.65
                turbulence 0.15
                scale 4
                texture_map {
                        [0      pigment {
                                        granite 
                                        color_map {
                                                [0.0 rgb Ga (<0.7, 0.6, 0.4>)]
                                                [1.0 rgb Ga (<0.8, 0.7, 0.5>)]  
                                        }                                     
                                        scale 1
                                }
                                finish {ambient 0 diffuse 0.5 specular 0.5 roughness 0.075}
                                normal {granite 0.45 scale 0.05}
                        ]

                        [1      pigment {
                                        granite 
                                        color_map {
                                                [0.0 rgb Ga (<0.9, 0.9, 0.8>)]
                                                [1.0 rgb Ga (<1.0, 0.9, 0.7>)]  
                                        }            
                                        scale 1
                                }
                                finish {ambient 0 diffuse 0.5 specular 0.3 roughness 0.1}
                                normal {granite 0.5 scale 0.05}
                        ]     
                }
        }               
        interior {ior 1.5}
        translate y*-0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 126) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/

#declare T1 =  // sand
material {
        texture {
                pigment {
                        granite 
                        omega 0.8 
                        lambda 2.2 
                        turbulence 1 
                        color_map {
                                [ 0.0 rgb Ga (<0.9, 0.8, 0.7>*1.1)]  
                                [ 0.2 rgb Ga (<0.9, 0.8, 0.7>*1.1)]  
                                [ 0.2 rgb Ga (<0.7, 0.5, 0.2>*1.1)]  
                                [ 0.4 rgb Ga (<0.7, 0.5, 0.2>*1.1)]  
                                [ 0.4 rgb Ga (<0.4, 0.2, 0.1>*1.5)]  
                                [ 0.6 rgb Ga (<0.4, 0.2, 0.1>*1.5)]  
                                [ 0.6 rgb Ga (<0.8, 0.7, 0.6>*1.1)]  
                                [ 0.8 rgb Ga (<0.8, 0.7, 0.6>*1.1)]  
                                [ 0.8 rgb Ga (<0.25,0.225,0.2>*1.5)]  
                                [ 1.0 rgb Ga (<0.25,0.225,0.2>*1.5)]
                        }      
                        scale 0.65
                }    
                normal {granite 0.5 omega 0.8 lambda 2.2 turbulence 1 scale 0.13} 
                finish {diffuse albedo 0.6 specular albedo 0.1 roughness 0.075}
        }
        scale 0.5
        interior {ior 1.55}
}    

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 127) /////////////////////////////////////////////////////////////////////////////////////

// Meothuru  rusty iron  http://news.povray.org/povray.binaries.images/message/%3Cweb.49cf9ea34ee6dd4e1dfafa300%40news.povray.org%3E/#%3Cweb.49cf9ea34ee6dd4e1dfafa300%40news.povray.org%3E

#declare T1 =   
material {
        texture {
                pigment {rgb <0.478431,0.513725,0.462745>
                        /*spherical
                        turbulence <1, 1, 1>
                        omega 1
                        lambda 6
                        color_map {
                                [0.1 rgb <0.478431,0.513725,0.462745>]
                        }*/
                }
                normal {
                        boxed 30
                        turbulence <1,1,1>
                        omega 1
                        lambda 6
                        frequency 15
                }
                finish {
                        ambient 0
                        diffuse 0.3
                        specular 0.6
                        conserve_energy
                        reflection {<0.1,0.1,0.1> metallic 1}
                }
                scale 15
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 128) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  grass_texture  http://news.povray.org/povray.binaries.images/message/%3C3da34957%40news.povray.org%3E/#%3C3da34957%40news.povray.org%3E

#declare grass_tex = 
texture {
	pigment {
                aoi
                color_map {
                        [0.0 rgb <0.1,0.2,0.05>]
                        [0.4 rgb <0.42,0.38,0>]
                        [0.5 rgb <1.2,0.9,0>]
                        [0.6 rgb <0.42,0.38,0>]
                        [1.0 rgb <0.1,0.2,0.05>]
                }
        } 
	finish {ambient 0 diffuse 1} 
}
texture {
         pigment {rgbt <1,pow (220/255,2),pow (180/255,2),1>}
         finish {ambient 0 diffuse 1 phong 0.75 phong_size 15 specular 3.2 roughness 0.006 metallic}
}

#declare T1 =
material {  
        texture {grass_tex}               
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

//#if (mat = 129) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  curles  http://203.29.75.35/povray.binaries.scene-files/thread/%3C1103_1063491393@news.povray.org%3E/?ttop=384061&toff=550

#declare st =
texture {
        pigment {rgb <0.83,0.82,0.84>*1.2}
        finish {
                diffuse 0.85*0.2 ambient 0
                specular 1 roughness 0.01
                phong 2.0 phong_size 300
                brilliance 7.3 
                metallic 0.6
                reflection {0.6,1.0 metallic fresnel on}
                conserve_energy
        }
}

#declare plastic =
texture {
        pigment {rgb 1}
        finish {
                diffuse 0.94*0.2 ambient 0 
                phong 3 phong_size 2000 
                specular 0.3 roughness 0.015 
                reflection {0.2,0.4 fresnel on}
                conserve_energy
        }
}

#declare chps=
pigment {
        function {(pow (abs (sin (x)),1/4)*select (sin (x),-1,0,1)*pow (abs (sin (z)),1/4)*select (sin (z),-1,0,1)+1)/2}
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.5/pi
}

//-------------------------------------------------------------------------------------------------------------------------------------

#declare frada = function {pattern {radial}}
#declare fboz1a = function {pattern {crackle form <1,0,0> scale 1}}
#declare fboz2a = function {pattern {bumps noise_generator 3 rotate 60 scale 1.2}}
#declare fboz3a = function {(sin (x+23)*sin (y+2)+sin (x*2.33443+11)*sin (y*2.4332+76)+sin (x*1.133443+32)*sin (y*1.234332+8)+3)*1/6}
 
#declare f1a = 
function (x,y,z) {
        (sin (fboz1a (x,y,z)*24*pi
        +frada (fboz1a (x,y,z)-fboz1a (x,y-0.07,z),0,fboz1a (x,y,z)-fboz1a (x+0.07,y,z)) //gradient calculation
        *2*pi
        //   +clock*pi*2 // uncomment to animate
        )+1)*(1/2)
        *(1-fboz1a (x,y,z))
}  

#declare f2a = 
function (x,y,z) {
        (sin (fboz2a (x,y,z)*24*pi
        +frada (fboz2a (x,y,z)-fboz2a (x,y-0.07,z),0,fboz2a (x,y,z)-fboz2a (x+0.07,y,z)) //gradient calculation
        *2*pi
        //   +clock*pi*2 // uncomment to animate
        )+1)*(1/2)
}  

#declare f3a = 
function (x,y,z) {
        (sin (fboz3a (x,y,z)*24*pi
        +frada (fboz3a (x,y,z)-fboz3a (x,y-0.07,z),0,fboz3a (x,y,z)-fboz3a (x+0.07,y,z)) //gradient calculation
        *2*pi
        //   +clock*pi*2 // uncomment to animate
        )+1)*(1/2)
}  
  
//-------------------------------------------------------------------------------------------------------------

#declare terracotta =
texture {
        finish {diffuse 1.3*0.5 phong 0.1}
        normal {
                average 
                normal_map {
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.02 
                                noise_generator 3 
                                slope_map {
                                        [5,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.015 
                                noise_generator 3 
                                slope_map {
                                        [5,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 2 
                                rotate 60 
                                scale 0.06 
                                noise_generator 3
                        ]
                }
                scale 0.75
        }
        pigment {rgb 0.1}
}

#if (mat = 129) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  curles  http://203.29.75.35/povray.binaries.scene-files/thread/%3C1103_1063491393@news.povray.org%3E/?ttop=384061&toff=550

#declare chps =
pigment {
        function {f1a (x,y,z)}
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.8/pi
}

#declare parf0 =
pigment {
        average 
        pigment_map {
                #declare i = 0;
                #while (i < 1)
                        [pow (1/2,i/4), chps translate i/2 rotate y*i*45 scale pow (1/2,i/2)]
                        #declare i = i+1;
                #end
        }
        scale 2
        translate 100
}

#declare parfa = function {pigment {parf0}}

#declare parfn1 = 
normal {
        function {parfa (x,y,z).x} 0.6*0.5
        slope_map {
                [0.0,<1,1>]
                [0.5,<0,-1>]
                [0.5,<0,1>]
                [1.0,<1,-1>]
        }
}

#declare parka = 
texture {
        function {parfa (x,y,z).x}
        texture_map {
                [0.3,   st normal {parfn1}]
                [0.3,   terracotta]
                [0.6,   terracotta]
                [0.7,   plastic normal {parfn1}]
        }
}

#declare T1 = 
material {
        texture {parka}        
        scale 0.6*0.3
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  curles  http://203.29.75.35/povray.binaries.scene-files/thread/%3C1103_1063491393@news.povray.org%3E/?ttop=384061&toff=550

#if (mat = 130) /////////////////////////////////////////////////////////////////////////////////////

#declare chps =
pigment {
        function {f2a (x,y,z)}
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.8/pi
}

#declare parf0 =
pigment {
        average 
        pigment_map {
                #declare i = 0;
                #while (i < 1)
                        [pow (0.5,i*0.25), chps translate i*0.5 rotate y*i*45 scale pow (0.5,i*0.5)]
                        #declare i = i+1;
                #end
        }
        scale 2
        translate 100
}

#declare parfb = function {pigment {parf0}}

#declare parfn1 = 
normal {
        function {parfb (x,y,z).x} 0.6*0.5
        slope_map {
                [0.0,<1,1>]
                [0.5,<0,-1>]
                [0.5,<0,1>]
                [1.0,<1,-1>]
        }
}

#declare parkb = 
texture {
        function {parfb (x,y,z).x}
        texture_map {
                [0.3,   st normal {parfn1}]
                [0.3,   terracotta]
                [0.6,   terracotta]
                [0.7,   plastic normal {parfn1}]
        }
}

#declare T1 = 
material {
        texture {parkb}        
        scale 0.6*0.3
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  curles  http://203.29.75.35/povray.binaries.scene-files/thread/%3C1103_1063491393@news.povray.org%3E/?ttop=384061&toff=550

#if (mat = 131) /////////////////////////////////////////////////////////////////////////////////////

#declare chps =
pigment {
        function {f3a (x,y,z)}
        color_map {
                [0, rgb 0]
                [1, rgb 1]
        }
        scale 0.8/pi
}

#declare parf0 =
pigment {
        average 
        pigment_map {
                #declare i = 0;
                #while (i < 1)
                        [pow (0.5,i*0.25), chps translate i*0.5 rotate y*i*45 scale pow (0.5,i*0.5)]
                        #declare i = i+1;
                #end
        }
        scale 2
        translate 100
}

#declare parfc = function {pigment {parf0}}

#declare parfn1 = 
normal {
        function {parfc (x,y,z).x} 0.6*0.5
        slope_map {
                [0.0,<1,1>]
                [0.5,<0,-1>]
                [0.5,<0,1>]
                [1.0,<1,-1>]
        }
}

#declare parkc = 
texture {
        function {parfc (x,y,z).x}
        texture_map {
                [0.3,   st normal {parfn1}]
                [0.3,   terracotta]
                [0.6,   terracotta]
                [0.7,   plastic normal {parfn1}]
        }
}

#declare T1 = 
material {
        texture {parkc}        
        scale 0.6*0.3
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 132) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia torii http://news.povray.org/povray.text.scene-files/thread/%3C3ad84390%40news.povray.org%3E/

//----------gold, brass or what?------- 

#declare t_gold = 
texture {
        pigment_pattern {
                wrinkles 
                scale 0.1
        }
        texture_map {
                [0      pigment {rgb Ga (<1,0.6,0.2>)}
                        finish {ambient 0 diffuse 0.3 reflection {0.3,0.6 metallic} metallic specular 1 roughness 0.01}
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb Ga (<1,0.65,0.3>)}
                        finish {ambient 0 diffuse 0.35 reflection {0.2,0.5 metallic} metallic specular 0.7 roughness 0.04}
                        normal {dents 0.5 scale 0.01}
                ]
        } 
}

#declare T1 = 
material {
        texture {t_gold}
        scale 1
        interior {ior 0.47}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 133) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia torii http://news.povray.org/povray.text.scene-files/thread/%3C3ad84390%40news.povray.org%3E/

//----------simple metal-------

#declare t_metal = 
texture {
        pigment_pattern {
                wrinkles 
                scale 0.1
        }
        texture_map {
                [0      pigment {rgb Ga (<1,0.93,0.9>)}
                        finish {ambient 0 diffuse 0.2 reflection {0.4,0.7 metallic} metallic specular 1 roughness 0.007}
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb Ga (<0.915,0.85,0.85>)}
                        finish {ambient 0 diffuse 0.3 reflection {0.3,0.6 metallic} metallic specular 0.7 roughness 0.02}
                        normal {dents 0.5 scale 0.01}
                ]
        }
}

#declare T1 = 
material {
        texture {t_metal}
        scale 1
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 134) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia torii http://news.povray.org/povray.text.scene-files/thread/%3C3ad84390%40news.povray.org%3E/

#declare t_metal = 
texture {
        pigment_pattern {
                wrinkles 
                scale 0.1
        }
        texture_map {
                [0      pigment {rgb Ga (<1,0.93,0.9>)}
                        finish {ambient 0 diffuse 0.14 reflection {0.4,0.7 metallic} metallic specular 1 roughness 0.007}
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {rgb Ga (<0.915,0.85,0.85>)}
                        finish {ambient 0 diffuse 0.21 reflection {0.3,0.6 metallic} metallic specular 0.7 roughness 0.02}
                        normal {dents 0.5 scale 0.01}
                ]
        }
}

//------------simple rusty metal---- 

#declare t_rusty = 
texture {
        pigment_pattern {
                bozo  
                warp {turbulence 0.8} 
                scale 0.2 
        } 
        texture_map {
                [0      t_metal]
                [0.6    t_metal]
                [0.7    pigment {
                                granite 
                                color_map {
                                        [0 rgb Ga (<0.8,0.4,0.2>*0.8)]
                                        [1 rgb Ga (<0.8,0.5,0.1>*0.8)]
                                } 
                                scale 0.1
                        }
                        finish {ambient 0 diffuse 0.24 specular 0.3 roughness 0.01 metallic}
                        normal {granite 0.5 scale 0.1}
                ]
                [1      pigment {
                                granite 
                                color_map {
                                        [0 rgb Ga (<0.8,0.4,0.2>*0.8)]
                                        [1 rgb Ga (<0.8,0.5,0.1>*0.8)]
                                } 
                                scale 0.1
                        }
                        finish {ambient 0 diffuse 0.36 specular 0.3 roughness 0.01 metallic}
                        normal {granite 0.5 scale 0.1}
                ]
        }
}

#declare T1 = 
material {
        texture {t_rusty}
        scale 1
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 135) /////////////////////////////////////////////////////////////////////////////////////

// Jonathan Rafael Ghiglia torii http://news.povray.org/povray.text.scene-files/thread/%3C3ad84390%40news.povray.org%3E/

//-------iridescent metal--------- 

#declare A = seed (123);
#declare m_r = 0.3;   // 0.2 or 0.1 maybe is better

#declare t_irid = 
texture {
        pigment_pattern {
                wrinkles 
                scale 0.1 
        }
        texture_map {
                [0      pigment {
                                wrinkles 
                                color_map {
                                        #declare n = 100;
                                        #declare i = 0;
                                        #while (i <= 1) 
                                                [i      rgb Ga (<1+m_r*rand(A)-m_r*rand(A), 0.93+m_r*rand(A)-m_r*rand(A), 0.9+m_r*rand(A)-m_r*rand(A)>)] 
                                                #declare i = i+1/n;
                                        #end 
                                }
                                scale 0.05 
                        }
                        finish {
                                ambient 0 
                                diffuse 0.2 
                                reflection {0.4,0.7 metallic} 
                                metallic 
                                specular 1 
                                roughness 0.007
                        }
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {
                                wrinkles 
                                color_map {
                                        #declare n = 100;
                                        #declare i = 0;
                                        #while (i <= 1) 
                                                [i      rgb Ga (<0.915+m_r*rand(A)-m_r*rand(A), 0.85+m_r*rand(A)-m_r*rand(A), 0.85+m_r*rand(A)-m_r*rand(A)>)] 
                                                #declare i = i+1/n;
                                        #end 
                                }
                                scale 0.05 
                        }
                        finish {
                                ambient 0 
                                diffuse 0.3 
                                reflection {0.3,0.6 metallic} 
                                metallic 
                                specular 0.7 
                                roughness 0.02
                        }
                        normal {dents 0.5 scale 0.01}
                ]
        } 
}

#declare T1 = 
material {
        texture {t_irid}
        scale 1
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 136) /////////////////////////////////////////////////////////////////////////////////////

// Tony[B]  pot  http://news.povray.org/povray.binaries.images/message/%3C3d229180%40news.povray.org%3E/#%3C3d229180%40news.povray.org%3E

#declare LayerA =
texture {
        pigment {
                planar 
                turbulence 0.2
                scale 4//max_extent (Pot).y
                color_map {
                        [0.0 rgb <0.50,1,0.50>/12]
                        [0.7 rgb <0.30,1,0.50>/6]
                        [1.0 rgb <0.25,1,0.75>/24]
                }
        }
        finish {
                diffuse 1
                reflection {0.1 metallic}
                phong 0.2 
                phong_size 40 
                metallic
        }
        normal {
                bozo 
                warp {turbulence 0.5}
                scale 3 
                bump_size 1
        }
}

#declare LayerB =
texture {
        pigment {rgbf 1}
        finish {
                diffuse 1.5
                reflection {0,1 fresnel}
                specular 0.125 
                roughness 0.01
        }
}

#declare PotTex =
texture {LayerA}
texture {LayerB}

#declare T1 =
material {
        texture {PotTex}
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 137) /////////////////////////////////////////////////////////////////////////////////////

// Marc Jacquier  Leather  http://news.povray.org/povray.binaries.images/message/%3C3e46d31a%241%40news.povray.org%3E/#%3C3e46d31a%241%40news.povray.org%3E

#declare Leather =
texture {
        pigment {//rgb <0.65,0.4,0.3>}
                average
                pigment_map {
                        [1      crackle 
                                metric 0.3 
                                turbulence 0.1
                                color_map {
                                        [0.95   rgb <0.55,0.4,0.3>]
                                        [1      rgb <0.55,0.4,0.3>*2]
                                }
                        ]
                        [1      crackle 
                                metric 0.3 
                                turbulence 0.1 
                                scale 0.3
                                color_map {
                                        [0.95   rgb <0.55,0.4,0.3>]
                                        [1      rgb <0.55,0.4,0.3>*2]
                                }
                        ]
                        [1      dents 
                                scale 0.01
                                color_map {
                                        [0.95   rgb <0.55,0.4,0.3>]
                                        [1      rgb <0.55,0.4,0.3>*-1]
                                }
                        ]
                }
                scale  0.14
        }        
        normal {
                average
                normal_map {
                        [1      crackle 
                                metric 0.3 
                                turbulence 0.1
                        ]
                        [1      crackle 
                                metric 0.3 
                                turbulence 0.1 
                                scale 0.3
                        ]
                        [1      dents -1 
                                scale 0.01
                        ]
                }
                scale  0.14
        }
        finish {
                ambient 0
                specular 0.4
                roughness 0.02
        }
}

#declare T1 =
material {
        texture {Leather}
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 138) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  abstract_v3_lens  http://evilsuperbrain.com/gallery/finished/abstract_v3_lens.pov

#declare T1 =
material {
	texture {	
		pigment {
                        cells//planar 
                        //poly_wave 0.5 
                        pigment_map {
                                [0 rgb 0.7]
                                [1 radial] 
                        } 
                        //rotate 120*x 
                }
		finish {
			diffuse 0.2 
                        ambient 0 
                        brilliance 2	//just enough to stop it going black.
			specular 1 
                        roughness 0.3 
                        metallic 1	//all the color shows up here, big fat specular highlight looks like metallic paint
		}
		normal {bumps 0.1 scale 0.001}
	}
	texture {
		pigment {rgbt 1}
		finish {
			specular 1 
                        roughness 0.003
			reflection {0.05,1 falloff 5} 
                        conserve_energy
		}
		normal {bumps 0.07 cubic_wave scale 0.00001}
        }
        scale 0.1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 139) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  elements  http://www.irtc.org/ftp/pub/stills/2005-10-31/elements.zip 

#macro vPow (V,P) <pow (V.x,P),pow (V.y,P),pow (V.z,P)> #end

#declare T1 =
material {
	texture {				
		pigment {
			granite
			color_map {
				[-0.3   rgb vPow (<0.3,0.1,0>,0.5+0.5*2)]
				[0.6    rgb vPow (<0.6,0.5,0.3>,0.5+0.5*2)]
				[0.7    rgb vPow (<0.3,0.1,0>,0.5+0.5*2)]
			}
		}		
		normal {
			average
			normal_map {
				[1      granite 0.2
					slope_map {
						[0,   <0.5,0>]
						[0.6, <1,  0>]
						[1,   <0,  0>]
					}
				]
				[1      dents 3 scale 0.01]
			}
		}
		finish {
			reflection {0.04, 1 fresnel}
			specular 1 
                        roughness 0.01
                        diffuse 1
		}
		scale 0.05
	}
	interior {ior 1.33} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 140) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  elements  http://www.irtc.org/ftp/pub/stills/2005-10-31/elements.zip 

#declare rockPattern =
function {
	pigment {
		average
		pigment_map {
			[0.3    pigment_pattern {
					granite
					color_map {
						[0 rgb 1]
						[1 rgb 0]
					}
					scale 10
				}
				poly_wave 2
			]
			[0.1    granite 
                                scale <40,4,40>
				color_map {
                                        [0 rgb 1]
                                        [1 rgb 0]
                                }
			]
			[1      spotted scale 3 poly_wave 2]
		}
	}
}

#declare T1 =
material {
	texture {
		pigment {
			function {pow (min (1, max (0,rockPattern (x,y,z).x*1-0)),0.5)}
			cubic_wave
			pigment_map {
				[0      spotted 
                                        //scale <5,0.5,5>
					warp {turbulence 0.4 lambda 4}
					color_map {
						[0.0 rgb <0.4,0.2,0>]	
						[0.2 rgb <1,0.9,0.8>]
						[0.7 rgb <0.9,0.7,0.5>]
						[1.0 rgb <0.5,0.35,0.2>]
					}
				]
				[1	rgb <0.07,0.01,0>]
			}
		} 
		normal {
			function {pow (min (1, max (0,rockPattern (x,y,z).x*1-0)),0.5)}
			cubic_wave
			normal_map {
				[0      dents -0.3
                                        scale 0.2
					warp {turbulence 0.4 lambda 4}
				]
				[1	wrinkles 0.5
                                        scale 0.2
                                        warp {turbulence 0.4 lambda 4}
                                ]
			}
		}
		finish {
			specular 0.12 
                        roughness 0.01
                        diffuse 0.9
		}
		scale 0.3
	}
	interior {ior 1.6} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 141) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  lockw  http://evilsuperbrain.com/gallery/finished/lockw.pov 

#declare fPlastic =
finish {
	diffuse 1-0.4
	brilliance 2
	specular 1.5
	roughness 0.002 //very smooth plastic
	reflection {0,0.6 falloff 1.5 exponent 0.8}
}

#declare tPlasticRed =
texture {
        pigment {rgb <153,29,133>/255}
	finish {fPlastic}
}

#declare T1 =
material {
        texture {tPlasticRed}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 142) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  cuptexture  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062548551%40news.povray.org%3E/cuptexture.pov.txt?ttop=384820&toff=550

#declare terracota =
texture {
        finish {diffuse 1.3*0.5 phong 0.1}
        normal {
                average 
                normal_map {
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.02 
                                noise_generator 3 
                                slope_map {
                                        [0,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 0.5 
                                rotate 60 
                                scale 0.015 
                                noise_generator 3 
                                slope_map {
                                        [0,<5,-10>]
                                        [0.5,<0,0>]
                                }
                        ]
                        [1,     bozo 4 
                                rotate 60 
                                scale 0.006 
                                noise_generator 3
                        ]
                }
        }
        pigment {rgb <0.9+0.05,0.75,0.68-0.05>*0.7} 
}

#declare t2 =
texture {terracota}
texture {
        pigment {
                rgbt <0.7,0.5,0.45,0.5>
        }
        finish {diffuse 0.3*0.5 phong 1 reflection {0.2,0.6}} 
        normal {bozo -5 noise_generator 3}
} 

#declare T1 = 
material {
        texture {
                bozo 
                scale 0.05 
                noise_generator 3 
                texture_map {
                        [0.40, t2]
                        [0.41, terracota scale 20]
                }    
        }
        scale 1
        interior {ior 1.33}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 143) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Fruit texturing II  http://www.ignorancia.org/uploads/zips/fruitext.zip

#declare r1 = seed (930);    // apple seed

// *** fuji apple colors, pigments and textures ***
// basic pigments
#declare p1 = rgb <0.9,0.15,0.05>;        //Firebrick*0.5+OrangeRed*0.1;
#declare p2 = rgb <1,0.7,0.1>;            //Yellow*0.8+White*0.1;
#declare p3 = rgb <0.95,0.9,0.1>;         //YellowGreen*0.8+White*0.1;

// base texture (bottom layer)
#declare t_base =
texture {
        pigment {
                bozo //cylindrical
                turbulence 0.25
                color_map {
                        [0.0 p1]
                        [0.2 p1]
                        [0.7 p3]
                        [1.0 p2]
                }
                scale 5
                translate 1
        }
}

// pgment for the radial-slope texture ("stripes", second layer)
#declare p_stripes =
pigment {
        pigment_pattern {
                bumps
                turbulence 0.5
                lambda 2
                scale <1,7,1>*0.15
        }
        color_map {
                [0.00 p1]
                [0.45 p1]
                [0.45 p1 transmit 0.9]
                [1.00 p1 transmit 0.9]
        }
}

// *** "soft/hide" texture (third layer), with additional "dirty" layer ***
#declare t_upper =
texture {
        pigment {
                wrinkles //cylindrical
                turbulence 0.25
                color_map {
                        [0.0 p1 transmit 0.8]
                        [0.2 p1 transmit 0.6]
                        [0.7 p3 transmit 0.1]
                        [1.0 p3 transmit 0.0]
                }
                scale 4
                translate 1
        }
} 
texture {
        pigment {
                granite
                turbulence 0.5
                lambda 3
                color_map {
                        [0.00 DarkGreen*0.5 transmit 0.1]
                        [0.10 DarkTan transmit 0.5]
                        [0.20 DarkGreen transmit 0.8]
                        [1.00 DarkTan transmit 0.9]
                }
        }
        normal {
                granite 0.1
                turbulence 0.5
                lambda 3
                scale 0.01
        }
        finish {
                phong 0.3 phong_size 40 
                reflection {0,0.01}
        }
        scale 4
}

/*
   Macro to create the "sloped" texture, intended for internal use on the
   next macro, "m_radial_sloped()". The different layers are mixed here because
   otherwise they can't be layered over the final patterned texture.
   
*/
#macro m_sloped (cnt,n,t_base,p_stripes,t_upper,r_rad)

texture {t_base}
texture {
        pigment {
                slope y
                pigment_map {
                        [0.0 p_stripes translate 10*rand (r_rad) rotate -18*5*z rotate (360*cnt/n)*y]
                        [0.1 p_stripes translate 10*rand (r_rad) rotate -18*4*z rotate (360*cnt/n)*y]
                        [0.3 p_stripes translate 10*rand (r_rad) rotate -18*2*z rotate (360*cnt/n)*y]
                        [0.5 p_stripes translate 10*rand (r_rad) rotate  18*0*z rotate (360*cnt/n)*y]
                        [0.7 p_stripes translate 10*rand (r_rad) rotate  18*2*z rotate (360*cnt/n)*y]
                        [0.9 p_stripes translate 10*rand (r_rad) rotate  18*4*z rotate (360*cnt/n)*y]
                        [1.0 p_stripes translate 10*rand (r_rad) rotate  18*5*z rotate (360*cnt/n)*y]
                }
        }
}
texture {t_upper}

#end // of macro 

/*
   Macro to create the "radial-sloped" texture, calling "m_sloped()" (for the
   rotations following the slope y) for each radial entry and rotating it to
   face the shape. It returns the final texture to use on the fruit object.
   
*/
#macro m_radial_sloped (t_base,p_stripes,t_upper,r_man)

#local cnt = 1;
#local n = 32;

texture {
        radial
        texture_map {
                #declare t_apple_base = m_sloped (0,n,t_base,p_stripes,t_upper,r_man)
                [0      t_apple_base]
                #while (cnt <= n)
                        #declare t_apple_base = m_sloped (cnt,n,t_base,p_stripes,t_upper,r_man)
                        [(cnt/n)        t_apple_base]
                        #declare cnt = cnt+1;
                #end
        }
}

#end // of macro 

#local t_apple = m_radial_sloped (t_base,p_stripes,t_upper,r1)

#declare T1 =
material {
        texture {t_apple}
        scale 0.3
        interior {ior 1.37}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 144) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  snail  http://www.oyonale.com/downloads/escargot.zip

#declare RefBody = 0.25;

#declare C_Snail_Body = rgb <232-30,176,98+30>/255;
#declare N_Snail_Body =
//normal {bump_map{jpeg "snail_bump" interpolate 2} bump_size 3}
normal {crackle 3 turbulence 0.5 scale 0.3}

#declare F_Snail_Body=
finish {
        ambient 0
        diffuse 1
        specular 0.1
        roughness 0.025
        reflection {0.2*RefBody, RefBody fresnel on}
        subsurface {translucency srgb 0.3}        
}

#declare T_Snail_Body = 
texture{
    pigment {
        C_Snail_Body
    }
    normal {N_Snail_Body}
    finish {F_Snail_Body}
}

#declare T1 =
material {
        texture {T_Snail_Body}
        scale 0.3
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 145) /////////////////////////////////////////////////////////////////////////////////////

// based on Christophe Bouffartigue  cbwar  http://www.irtc.org/ftp/pub/stills/2001-10-31/cbwar.zip

#declare colMur1 = <1,0.99,0.92>*1.1;
#declare colMur2 = colMur1*0.9;
#declare EpWr = 0.2;

#declare T_MurClasse = 
texture {
	pigment {rgb colMur1}
	normal {
                dents -0.5 
                scale 3 
                slope_map {
                        [0.4    <0,0>]
                        [0.4    <0,EpWr>]
                        [1.0    <EpWr,0>]
                }
        }
	finish {
                phong 0.3 
                phong_size 5 
                specular 0.2 
                roughness 0.02 
                subsurface {translucency srgb 0.004}
        }
}
texture {
	pigment {
		pigment_pattern {
                        wrinkles 
                        scale 100 
                        color_map {
                                [0 rgb 0]
                                [1 rgb 1]
                        }
                }
		pigment_map {
			[0      rgbf 1]
			[1      wrinkles             
                                scale 20 
                                color_map {
                                        [0 rgbf 1]
                                        [1 rgb colMur2*0.95 transmit 0.9]
                                }
                        ]
		}
	}
        normal {        
                cells 0.5 
                slope_map {
                        [0.4    <0,0>]
                        [0.4    <0,EpWr>]
                        [1.0    <EpWr,0>]
                }
        }
}
texture {
	pigment {
		pigment_pattern {       
                        wrinkles 
                        scale 25 
                        color_map {
                                [0 rgb 0]
                                [1 rgb 1]
                        }
                }
		pigment_map {
			[0      rgbf 1]
			[1      wrinkles 
                                scale 6 
                                color_map {
                                        [0 rgbf 1]      
                                        [1 rgb colMur2*0.9 transmit 0.8]
                                }
                        ]
		}
	}
        normal {        
                granite -0.5 
                scale 0.3 
                slope_map {
                        [0.4    <0,0>]
                        [0.4    <0,EpWr>]
                        [1.0    <EpWr,0>]
                }
        }
}
texture {
	pigment {
		pigment_pattern {
                        wrinkles 
                        scale 6 
                        color_map {
                                [0 rgb 0]
                                [1 rgb 1]       
                        }
                }
		pigment_map {
			[0      rgbf 1]
			[1      wrinkles 
                                scale 2 
                                color_map {
                                        [0 rgbf 1]
                                        [1 rgb colMur2*0.85 filter 0.5]
                                }
                        ]
		}
	}
        normal {
                agate 0.5 
                scale 0.1 
                slope_map {
                        [0.4    <0,0>]
                        [0.4    <0,EpWr>]
                        [1.0    <EpWr,0>]
                }
        }
}

#declare T1 =
material {
        texture {T_MurClasse}
        scale 0.006
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 146) /////////////////////////////////////////////////////////////////////////////////////

// Hugo  Specular Maps and Specular color-filter  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3c8125c7%40news.povray.org%3E/Specular_Maps.pov.txt

#macro Make_Texture ()
	
#local Specular_Subtract = 
<max (min (Specular_Filter.x,1),0.001)
,max (min (Specular_Filter.y,1),0.001)
,max (min (Specular_Filter.z,1),0.001)>; 

#local Specular_Add = <1,1,1>-Specular_Subtract+0.001;

#local f_red =   function {Color_Map (x,y,z).red}
#local f_green = function {Color_Map (x,y,z).green}
#local f_blue =  function {Color_Map (x,y,z).blue}

// For use in layer1
#local Color_Map1 =
pigment {
        average 
        pigment_map {
	        [1 function {f_red (x,y,z)}   color_map {[0 red 0][1 red 3 + Specular_Add.x*3]}]
	        [1 function {f_green (x,y,z)} color_map {[0 green 0][1 green 3 + Specular_Add.y*3]}]
	        [1 function {f_blue (x,y,z)}  color_map {[0 blue 0][1 blue 3 + Specular_Add.z*3]}]
        }
}

// For use in layer 2 = double intensity
#local Color_Map2 =
pigment {
        average 
        pigment_map {
	        [1 function {f_red (x,y,z)}   color_map {[0 red 0][1 red 6 + Specular_Add.x*6 ]}]
	        [1 function {f_green (x,y,z)} color_map {[0 green 0][1 green 6 + Specular_Add.y*6 ]}]
	        [1 function {f_blue (x,y,z)}  color_map {[0 blue 0][1 blue 6 + Specular_Add.z*6 ]}]
        }
}

// Add the opposite of specular color to layer 1 & 2
// Layer 1 color, normal. Uses ordinary reflection & specular
#declare Layer_1 =
texture {
	pigment {Color_Map1}
	finish {ambient 0 specular Specular_Amount roughness Specular_Roughness metallic Metallic_Amount reflection {0,Reflection_Amount fresnel on} conserve_energy}
	normal {function {Bump_Map (x,y,z)} bump_size Bump_Strength}
}

// Layer 2 Color, normal. The underlying layer transmits by values based on reflection_map
#declare Layer_2 =
texture {
	pigment {
                average 
                pigment_map {
		        [1      Color_Map2]
	                [1      function {Reflection_Map (x,y,z)}
	    	                color_map {
                                        [0 rgbt 0] 
                                        [1 transmit 2] 
                                } 
                        ]
	        } 
        }
	finish {ambient 0}
	normal {function {Bump_Map (x,y,z)} bump_size Bump_Strength}
}

// Layer 3 Filter. Subtracts specular color
#declare Layer_3 =
texture {
	pigment {rgbft <0,0,0,0.5,0.5>+Specular_Subtract}
	finish {ambient 0}
}

// Final texture
#local Layers =
texture {Layer_1} 
texture {Layer_2} 
texture {Layer_3};

Layers

#end

#declare Color_Map = 
function {
        pigment {
                cells//granite scale 0.5
                scale 0.1 
                color_map {
                        [0      rgb 0.2] 
                        [1      rgb 0] 
                } 
        } 
}

#declare Bump_Map =
function {
        pattern {
                cells//granite scale 0.5
                scale 0.1  
        } 
}

#declare Reflection_Map =
function {
        pattern {
                cells//granite scale 0.5
                scale 0.1  
        } 
}

#declare Specular_Filter = <236,102,2>/255*2;
#declare Specular_Amount = 1.8;
#declare Specular_Roughness = 0.15;
#declare Metallic_Amount = 0;
#declare Reflection_Amount = 0.5;
#declare Bump_Strength = -0.2;

#declare Red_ = Make_Texture()

#declare T1 =
material {
        texture {Red_}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 147) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  Metallic paint - v2  http://news.povray.org/povray.binaries.scene-files/message/%3C3ec17be0%241%40news.povray.org%3E/#%3C3ec17be0%241%40news.povray.org%3E

#macro m_tMetallicMatte (pPigment,fMetallic,fNoise,fGlitter) //base metallic layer 

texture {
	pigment {
		pPigment
	}
	finish {
		diffuse (1-fMetallic)
		specular fMetallic roughness 0.1 metallic 1
	}
	#if (fNoise > 0)
		normal {
			granite fNoise/10
			scale 0.02
		}
	#end
}

#if (fGlitter > 0)
	texture { //glitter
		pigment {rgbt 1}
		finish {
			specular fGlitter roughness 0.005
		}
		normal {
			granite 1
			scale 0.02
		}
	}
#end 

#end
	
#declare tGlossCoat =                   //gloss coating, this can be layered over anything to give a realistic glossy finish.
texture {
	pigment {rgbt 1}
	finish {
		reflection {
			0.08,		//adjust this to simulate other glossy materials (glass should be a low number, a mirror would be a high number)
			1		//leave this, unless you want a dull looking material, in which case why are you using a gloss coating?! :)
			falloff 5       //this approximates fresnel reflections, without us needing to guess ior values. We simulate fresnel for different materials by adjusting the min reflection value.
		}
		conserve_energy
		specular 1 roughness 0.001 //tune this according to your scene, it won't look perfect because it ignores the reflection falloff.
	}
}

#macro m_tMetallicGloss (pPigment,fMetallic,fNoise,fGlitter)

m_tMetallicMatte (pPigment,fMetallic,fNoise,fGlitter)
texture {tGlossCoat}

#end

//this will affect the ambient setting of the metallic paint.
#default {pigment {rgb 1} finish {diffuse 1 ambient 0.3}}

//striped pigment
#declare pPig =
/*pigment {
	gradient z scale 2.1 translate -1.05
	color_map {
		[0.25	rgb <0.8,0.1,0.1>]
		[0.25	rgb 1]
		[0.50	rgb 1]
		[0.50	rgb <1,0.75,0.5>]
		[0.75	rgb <1,0.75,0.5>]
		[0.75	rgb <0.0,0.3,0.1>]
	}
	scale <3,0.5,1>*2
}*/
pigment {
        pigment_pattern {
                checker 
                rgb 0, 
                rgb 1
                scale 2 
        }
        pigment_map {
                [0      checker rgb <0.8,0.1,0.1>, rgb 1]
                [1      checker rgb <1,0.75,0.5>, rgb <0.0,0.3,0.1>]
        }
        scale 0.5
}

#declare T1 =
material {	
	m_tMetallicGloss (
		pPig,   //our pigment
		0.7,	//how metallic it is
		0.5,	//noisiness
		1	//amount of glitter
	)
        interior {ior 1.54}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 148) /////////////////////////////////////////////////////////////////////////////////////

// Blue Herring  MultiObjectPattern  http://lib.povray.org/searchcollection/index2.php?objectName=MultiObjectPattern&contributorTag=Blue%20Herring
 
#declare Vase_Rough_T =
texture {
        pigment {Tan*1.2}
        normal {
                granite -0.7
                poly_wave 4
                scale 0.5
        }
}
        
#declare T1 =
material {
        texture {Vase_Rough_T}
        scale 0.5
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 149) /////////////////////////////////////////////////////////////////////////////////////

// Rune Skovbo Johansen  Brushed Metal Texture  http://runevision.com/3d/povgoodies/brushed.zip  

#declare Brushed_Depth = 100; // Bump size
#declare Brushed_Pigment = pigment {rgb 0.73*0.7}
#declare Brushed_Finish = 
finish {
        ambient 0
        diffuse 0.5
        specular 0.96
        roughness 0.002
        phong 0.43
        phong_size 25
        brilliance 3.15
        reflection {0.1,1 metallic 1 fresnel on}
        conserve_energy
        metallic 1
}

#declare T1 = 
material {
        texture {     
                average
                texture_map {
                        [1      pigment {Brushed_Pigment}
                                normal {wood  Brushed_Depth poly_wave 2 rotate -45*x scale 0.0001}
                                finish {Brushed_Finish}
                        ]
                        [1      pigment {Brushed_Pigment}
                                normal {wood -Brushed_Depth poly_wave 2 rotate -45*x scale 0.0001}
                                finish {Brushed_Finish}
                        ]
                }
        }
        interior {ior 1.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 150) /////////////////////////////////////////////////////////////////////////////////////

// Bill Hails  melon skin  http://news.povray.org/povray.newusers/message/%3C42752aa2%40news.povray.org%3E/#%3C42752aa2%40news.povray.org%3E

#local FruitD_TexScale = 0.075;

///////// colors

#local CM_FruitD = 
color_map {
        [0.0 rgb <0.451, 0.031, 0.000>]
        [0.1 rgb <0.545, 0.125, 0.000>]
        [0.2 rgb <0.643, 0.333, 0.000>]
        [0.3 rgb <0.675, 0.427, 0.000>]
        [0.4 rgb <0.741, 0.506, 0.000>]
        [0.5 rgb <0.773, 0.584, 0.094>]
        [0.6 rgb <0.773, 0.698, 0.192>]
        [0.7 rgb <0.804, 0.698, 0.224>]
        [0.8 rgb <0.804, 0.776, 0.290>]
        [0.9 rgb <0.804, 0.839, 0.675>]
        [1.0 rgb <1.000, 1.000, 0.871>]
}

///////// functions

#local Fn_FruitDCa = 
function {
        pattern {
                crackle
                sine_wave
                frequency 2
                turbulence 0.3
        }
}

#local Fn_FruitDC = 
function {
        pattern {
                function {Fn_FruitDCa (x,y,z)}
                poly_wave 4
        }
}

///////// pigments

#local P_FruitD1 = 
pigment {
        bozo// gradient y
        scale 2/FruitD_TexScale
        color_map {CM_FruitD}
}

#local P_FruitD2 = 
pigment {
        bozo//gradient y
        scale 6/FruitD_TexScale
        color_map {CM_FruitD}
}

///////// normals

#local N_FruitDL = 
normal {
        granite
        scale 0.5
}

#local N_FruitDC = 
normal {function {Fn_FruitDC (x,y,z)}}

///////// finishes

#local Fin_FruitD = 
finish {
        diffuse 0.7
        ambient 0
        specular 0.2
        roughness 0.3
}

///////// textures

#local T_FruitD1 = 
texture {
        pigment {P_FruitD1}
        normal {N_FruitDL}
        finish {Fin_FruitD}
}

#local T_FruitD2 = 
texture {
        pigment {P_FruitD2 }
        normal {N_FruitDC }
        finish {Fin_FruitD }
}

///////// the final texture

#declare T_FruitD = 
texture {
        function {Fn_FruitDC (x,y,z)}
        scale FruitD_TexScale
        texture_map {
                [0 T_FruitD1]
                [1 T_FruitD2]
        }
        translate -y
}
        
#declare T1 =
material {
        texture {
                function {Fn_FruitDC (x,y,z)}
                scale FruitD_TexScale
                texture_map {
                        [0 T_FruitD1]
                        [1 T_FruitD2]
                }
        }
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 151) /////////////////////////////////////////////////////////////////////////////////////

// Trevor G. Quayle  shiny, denty, rusty, dusty chrome  http://news.povray.org/povray.binaries.images/message/%3Cweb.464b491d4ef76416c150d4c10%40news.povray.org%3E/#%3Cweb.464b491d4ef76416c150d4c10%40news.povray.org%3E

#declare TChrome =
texture {
        pigment {rgb 0.8}
        finish {
                ambient 0
                conserve_energy
                diffuse 0.1
                reflection {0, 1 fresnel on}
        }
        normal {dents 0.05 scale 0.2}
}

#declare TRust =
texture {
        pigment {
                granite 
                scale 10
                color_map {
                        [0.08 rgb <0.89, 0.51, 0.28>]
                        [0.15 rgb <0.70, 0.13, 0.00>]
                        [0.30 rgb <0.69, 0.41, 0.08>]
                        [0.30 rgb <0.49, 0.31, 0.28>]
                        [0.40 rgb <0.89, 0.51, 0.28>]
                        [0.40 rgbt 1]
                }
        }
        finish {ambient 0 diffuse 0.4}
        normal {
                granite
                normal_map {
                        [0.4    average 
                                normal_map {
                                        [1  granite -0.3]
                                        [1  granite 0.2 scale 0.2]
                                }
                        ]
                        [0.4    granite 0]
                }
        }
        scale 0.03333
}

#declare TDusty =
texture {
        pigment {
                #declare PW = 1;
                slope y
                color_map {
                        [pow (0.5, PW)  rgbt 1]
                        [1              rgbt Gat (<0.40784,0.39216,0.18431,0.1>)]

                }
                poly_wave PW
        }
        finish {ambient 0 diffuse 0.6}
        normal {
                slope y
                normal_map {
                        [0.5 granite 0]
                        [1.0 granite 0.2 scale 0.1]
                }
        }
}
        
#declare T1 =
material {
        texture {TChrome}
        texture {TRust}
        texture {TDusty}
        interior {ior 2}
        scale 2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 152) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  nebula  http://news.povray.org/povray.binaries.images/message/%3C485b1eb9%40news.povray.org%3E/#%3C485b1eb9%40news.povray.org%3E

#declare radio  = 0;
#declare envir  = 0;

#declare T1 =
material {
	texture {pigment {rgbt 1}}
	interior {
                media {
                        #declare thick = 40*3;
                        scattering {5, Ga (<1,0.7,0.3>)*thick}
                        absorption thick-Ga (<1,0.7,0.3>)*thick*0.25
                        intervals 1
                        samples 100
                        density {
                                granite
                                poly_wave 1.5
                                translate z*23
                                scale 8*0.5
                                color_map {
                                        [0      rgb 1]
                                        [0.05   rgb Ga (<0.025,0.025,0.025>)*<1,1,0.8>]
                                        [0.125  rgb Ga (<0.0025,0.0025,0.0025>)*<1,0.7,0.1>]
                                        [0.5    rgb 0]
                                }
                        }
                }
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 153) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  textured fog  http://news.povray.org/povray.text.scene-files/attachment/%3Cweb.4ca8b8bb206dd5097f7f41ca0%40news.povray.org%3E/textured_fog.pov.txt

#declare earth_pattern =
pigment {
        pigment_pattern {
                bumps 
                turbulence 1 
                lambda 3
                scale <10,2.5,10>
        }
        rotate y*67
}

#declare T1 = 
material {
        texture {
                pigment {
                        earth_pattern
                        color_map {
                                #local rgb_earthy = rgb <1,0.55,0.3>;
                                [0  rgb_earthy*0.5]
                                [1  rgb_earthy]
                        }
                }
                normal {
                        pigment_pattern {earth_pattern} 
                        1 
                        accuracy 0.001
                }
                finish {diffuse 1}
        }
        scale 0.4
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 154) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  table texture  http://news.povray.org/povray.binaries.animations/message/%3C3ece7304%241%40news.povray.org%3E/#%3C3ece7304%241%40news.povray.org%3E

#declare T1 = 
material {
        texture {               
                pigment {
                        pigment_pattern {
                                granite 
                                poly_wave 0.3 
                                scale <1,1,0.3>*3 
                                rotate <45,45,0> 
                                scale 0.1 
                                warp {turbulence 0.1 octaves 6} 
                                scale 10
                        }
                        warp {repeat x offset y} 
                        warp {repeat z offset x} //break up the pattern at the edge of the tiles
                        pigment_map {
                                [0.0    rgb 0.2]
                                [0.9    checker rgb 1, rgb 0]
                        }
                }
                finish {
                        diffuse 0.6 
                        ambient 0
                        reflection {0.1, 0.5 falloff 5}
                }
        }
        scale 0.5
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 155) /////////////////////////////////////////////////////////////////////////////////////

// Maurice  Brushed Aluminium  http://wiki.blender.org/index.php/Extensions:2.6/Py/Scripts/Render/POV-Ray/Sample_Materials

#declare StripesDepth = 0.01; 
#declare R = seed (1001);

#declare AluminiumBase = 
texture {
        pigment {rgb <0.658824, 0.658824, 0.658824>}
        normal {wood StripesDepth ramp_wave rotate 90*y scale 0.15} 
        finish {
                ambient 0 
                diffuse 0.35*2 
                specular 0.25 
                roughness 0.1  
                reflection {0,0.96 metallic 0.5 fresnel on falloff 1 exponent 1.25} 
                brilliance 3.15
        }
}
 
#declare T1 =
material {
        texture{
                average
                texture_map {
                        #declare V = 0;
                        #while (V < 12-9)        // number of samples up to 256
                                [1      AluminiumBase
                                        normal {
                                                bumps StripesDepth
                                                scale <15,15,0.03>     
                                                translate <rand(R),rand(R),rand(R)>
                                        }
                                ]
                                #declare V = V+1;
                        #end
                }
        }
        interior {ior 2.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 156) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge   Peeling paint texture  http://news.povray.org/povray.text.scene-files/message/%3C380E7A85.D47F210%40aol.com%3E/#%3C380E7A85.D47F210%40aol.com%3E

#declare Walls =
function {
        pigment {
                granite 
                scale 30
                color_map {
                        [0      rgb 0.0]
                        [0.1    rgb 0.1]
                        [0.15   rgb 0.7]
                        [0.2    rgb 0.75]
                        [0.21   rgb 1.0]
                        [0.25   rgb 0.6]
                        [0.7    rgb 0.0]
                        [1      rgb 0.5]
                }
        }
}

#declare T1 =
material {
        texture {
                pigment {
                        granite 
                        scale 30
                        color_map {
                                [0.1    rgb <0.7,0.7,0.5>]
                                [0.18   rgb <0.8,0.8,0.6>]
                                [0.2    rgb <0.7,0.7,0.5>]
                                [0.21   rgb 1]
                                [1      rgb 0.8]
                        }
                }
                normal {function {Walls (x,y,z).x} 1.5}
        }
        scale 0.1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 157) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  simple house paint texture  http://news.povray.org/povray.general/message/%3C40AE4F51.7050507%40hotmail.com%3E/#%3C40AE4F51.7050507%40hotmail.com%3E

#declare T1 =
material {
        texture {
                pigment {rgb <1,0.95,0.9>} // off-white
                finish {brilliance 0.6}
                normal {
                        granite
                        scale 30
                        slope_map {
                                [0.3, <0,0>] 
                                [0.6, <1,0>]
                        }
                        bump_size 0.12
                }
        }
        scale 0.01
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 158) /////////////////////////////////////////////////////////////////////////////////////

// pattern from Samuel T. Benge  Clay Pot  http://news.povray.org/povray.binaries.images/message/%3C3CF27B4E.6070607%40caltel.com%3E/#%3C3CF27B4E.6070607%40caltel.com%3E  
// colors & finish from Margus Ramst  iSponge2  http://www.hot.ee/margusrt/code/isponge2.zip 

#declare mazish =
function {
        pigment {
                cells
                pigment_map {
                        [0.5 function {x} color_map {[0.5 rgb 1][0.5 rgb 0]}]
                        [0.5 function {y} color_map {[0.5 rgb 1][0.5 rgb 0]}]
                }
        }
}

#declare T1 =
material {
        texture {
                pigment {
                        function {mazish (x,y*(x+10)/8+x/8,z).x}
                        color_map {
                                [0.5 rgb <0.42,0.4,0.46>] 
                                [0.5 rgb <0.7,0.6,0.57>]   
                        }
                }
                normal {function {mazish (x,y*(x+10)/8+x/8,z).x} 0.5}
                finish {
                        ambient 0
                        diffuse 0.84
                        brilliance 8 
                        specular 0.5 
                        roughness 0.03 
                        metallic 1
                        reflection {0.03,0.07 falloff 2 exponent 0.8}
                }
        }
        scale 0.5
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 159) /////////////////////////////////////////////////////////////////////////////////////

// Bill Hails  Textures.inc for Tea pic  http://news.povray.org/povray.binaries.scene-files/attachment/%3C4456112b%40news.povray.org%3E/us-ascii?ttop=393045&toff=300

#local C_Porcelain = rgb <1,0.98,0.9>;

#local P_Porcelain = pigment {color C_Porcelain}

#local N_Porcelain = 
normal {
        average
        normal_map {
                [1 bozo 0.4 scale 0.5]
                [1 bozo 0.4]
                [1 bozo 0.4 scale 2]
        }
}

#local F_Porcelain = 
finish {
        ambient 0
        diffuse 0.6
        brilliance 1.5
        specular 0.7
        roughness 0.00025
        reflection {0.75 fresnel on}
        conserve_energy
}

#local T_Porcelain = 
texture {
        pigment {P_Porcelain}
        normal {N_Porcelain}
        finish {F_Porcelain}
}

#local I_Porcelain = interior {ior 1.53}

#declare T1 = 
material {
        texture {T_Porcelain}
        interior {I_Porcelain}
        scale 0.05
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 160) /////////////////////////////////////////////////////////////////////////////////////

// Bill Hails  Textures.inc for Tea pic  http://news.povray.org/povray.binaries.scene-files/attachment/%3C4456112b%40news.povray.org%3E/us-ascii?ttop=393045&toff=300

#local WhitenAmount = 6;
#macro Whiten (color_) (1-(1-color_)/WhitenAmount) #end

#local PM_Table = 
pigment_map {
        [0.00 rgb Whiten (<0.50, 0.50, 1.00>)]
        [0.33 rgb Whiten (<0.50, 1.00, 0.50>)]
        [0.66 rgb Whiten (<1.00, 0.50, 0.50>)]
        [1.00 rgb Whiten (<0.50, 0.50, 1.00>)]
}

#local FN_TableGrain = 
function {
        pattern {
                wood
                frequency 5
                rotate 15*x
                warp {turbulence <0.05,0.05,0.60>}
                translate <47,50,30>
                warp {
                        black_hole <50,50,50>,20
                        falloff 7.0
                        repeat <100,100,100>
                        inverse
                }
                translate -<47,50,30>
                translate 6*x
                warp {
                        repeat x*20
                        offset 0.4*y
                }
                translate -20*z
        }
}

#local FN_TableFineGrain = 
function {
        pattern {
                bozo
                frequency 2
                scale <0.03,0.03,0.7>
        }
}

#local FN_TableShiny = 
function {
        pigment {
                average
                pigment_map {
                        [2 function {1-FN_TableGrain (x,y,z)}]
                        [1 bozo scale 0.1]
                }
        }
}

#local FN_TableSpread = 
function {
        pigment {
                function {FN_TableGrain (x,y,z)}
                pigment_map {
                        [0.0 rgb 0]
                        [0.4 rgb 0]
                        [0.5 rgb 1]
                        [1.0 rgb 1]
                }
        }
}

#local FN_TableP = 
function {
        pigment {
                function {FN_TableSpread (x,y,z).x}
                pigment_map {
                        [0 function {FN_TableFineGrain (x,y,z)}]
                        [1 function {FN_TableShiny (x,y,z).gray}]
                }
        }
}

#local FN_TablePN = 
function {
        pigment {
                function {FN_TableSpread (x,y,z).x}
                pigment_map {
                        [0 function {FN_TableFineGrain (x,y,z)*0.7}]
                        [1 function {FN_TableGrain (x,y,z)}]
                }
        }
}

#local FN_Table = 
function {
        pattern {
                function {FN_TableP (x,y,z).x}
                rotate 50*y
        }
}

#local FN_TableN = 
function {
        pattern {
                function {FN_TablePN (x,y,z).x*0.5}
                rotate 50*y
        }
}

#local P_Table = 
pigment {
        function {FN_Table (x,y,z)}
        pigment_map {PM_Table}
}

#local N_Table = 
normal {
        function {FN_TableN (x,y,z)}
        // sine_wave
        frequency 1
}

#local F_Table = 
finish {
        ambient 0
        diffuse 0.55
        brilliance 0.8
        specular 1.0
        roughness 0.0001
}

#declare T1 = 
material {
        texture {
                pigment {P_Table}
                normal {N_Table}
                finish {F_Table}
        }
        scale 0.15
        interior {ior 1.45}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 161) /////////////////////////////////////////////////////////////////////////////////////

// Marc Jacquier  grass tool demo scene  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3f6636ae%40news.povray.org%3E/Grass_tool_demo_scene.pov.txt

#declare Trans_text =
transform {  
        scale  <4,0.005,4>
        rotate <-20,0,-10>
}
      
#declare T_sec = 
texture {// T_roche_1    
         pigment {
                wrinkles
                turbulence 0.1
                lambda 2
                omega 0.6
                color_map {
                        [0.0       rgb <0.8,0.7,0.5>]
                        [0.434164  rgb <0.7,0.6,0.5>]
                        [0.455516  rgb 1]
                        [0.683274  rgb <0.94,0.92,0.92>]
                        [0.718861  rgb <0.35,0.27,0.14>]
                        [0.797153  rgb <0.35,0.27,0.14>]
                        [0.846975  rgb <0.94,0.92,0.92>]
                        [1.0       rgb <0.78,0.71,0.71>]
            }
        }      
        normal {
                wrinkles 0.5
                //crackle, 0.5
                turbulence 0.1
                lambda 2
                omega 0.6
        }         
        transform {Trans_text}
}

#declare T1 = 
material {
        texture {T_sec finish {ambient 0 diffuse 0.6 specular 0}}
        scale 0.2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 162) /////////////////////////////////////////////////////////////////////////////////////

// Ben Scheele  Recursive trifold symmetry  http://benscheele.com/rg/scene_files/recurset2-retex.txt

#declare radio  = 0;

#declare T1 =
material {                                                                              
        texture {                                                                       
                pigment {rgbf <1-0.45,0,0.45,0.5-0.2*0.45> transmit 0.7-0.2*0.45} 
                finish {                                                                
                       specular 0.7                                                       
                       roughness 0.001                                                    
                       brilliance 0.004                                                   
                       phong 0.3                                                          
                       diffuse 0.8                                                        
                       reflection {                                                     
                               0.1, 0.9                                                   
                               falloff 0.5                                                
                               metallic 0.15                                              
                       }                                                                  
                       conserve_energy                                                    
                }                                                                         
        }                                                                                 
        interior {                                                                      
               ior 1.5                                                                    
               caustics 1.5                                                               
               fade_distance 0.5                                                          
               fade_power 2                                                               
        }                                                                                 
}   

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 163) /////////////////////////////////////////////////////////////////////////////////////

// Jim Charter  JC_StainedStones.inc  http://news.povray.org/povray.binaries.scene-files/attachment/%3C493e6dec@news.povray.org%3E/JC_Stained%20Stones.inc.txt

#declare S = seed (10000100101010101);
        
#declare MG = 4.0;
#declare Finish_Stone =
finish {
        ambient 0
        diffuse 1
        specular 1
        roughness .02
        reflection 0
};        
                                                     
                       
#macro Decl_Pf_Crackle (Scale)
//define a crackle pattern as a function with scaling and translation applied           
        #undef Pf_Crackle   
        #declare Pf_Crackle  =
        function {
                pigment {
                        crackle 
                        poly_wave 1
                        form <1,0,0>
                        scale Scale    
                }
        };  
#end   
#macro Decl_Pf_Boxed (Scale)
//define a boxed pattern as a function with scaling and translation applied           
        #undef Pf_Boxed   
        #declare Pf_Boxed   =
        function {
                
                pigment {
                        boxed 
                        scale Scale*1.075   
                }
        };
#end 

#macro Decl_Pf_Edges (Contrast)     
//define a function which scales smaller toward the edges of the stone
//here a predefined crackle function nested inside the 
//predefined boxed function
         
        #undef Pf_Edges 
        #declare Pf_Edges  =
        function {     
                pigment {
                        function {Pf_Boxed(x,y,z).gray }
                        pigment_map {
                                  
                                [0.0 
                                       
                                        function {(1-Contrast)+Pf_Crackle(x,y,z).gray*Contrast} 
                                        scale 0.08
                                ]  
                                [.12
                                        
                                        function {(1-Contrast/2)+Pf_Crackle(x,y,z).gray*Contrast*0.5} 
                                        scale 0.16
                                ] 
                                [.36
                                        
                                        function {(1-Contrast/3)+Pf_Crackle(x,y,z).gray*Contrast*0.3333} 
                                        scale 0.24
                                ]  
                                [1.0
                                        
                                        function {(1-Contrast/4)+Pf_Crackle(x,y,z).gray*Contrast*0.25} 
                                        scale 0.32
                                ]       
                        } 
                }
        }
#end 
 
#macro Decl_Pf_Granite (Scale) 
//define a granite pattern as a function with scaling and translation applied            
        #undef Pf_Granite 
        #declare Pf_Granite  =
        function {
                pigment {
                        granite
                        scale Scale
                        translate rand(S)*100   
                }
        }
#end 
       
#macro Decl_P_Stone (Pf,PMap)   
//define a granite pigment using a predefined granite function        
        
        #declare P_Stone =        
        pigment {               
                function { 
                        Pf_Granite(x,y,z).gray
                } 
                pigment_map {  
                        PMap
                }
        }                             
#end    

#macro Decl_Pf_Bumps (Scale) 
//define a bump pattern as a function with scaling and translation applied           
        
        #undef Pf_Bumps 
        #declare Pf_Bumps  =
        function {
                pigment {
                        bumps
                        scale Scale 
                        translate <100*rand(S),100*rand(S),0>   
                }
        }
#end    
   
#macro Decl_Pf_GradientY (Height)
//define a gradient pattern as a function with scaling and translation applied          
        
        #undef Pf_GradientY 
        #declare Pf_GradientY  =
        function {
                pigment {
                        gradient y
                        scale <1,2*Height,1>
                        translate y*Height 
                }
        }
#end         

#macro Decl_P_Stain ( StainColor, StonePigment ) 
//Apply dripping stains to underlying stone pigment.  Result is a pigment 

        #ifdef (Pf_Edges)
                #declare P_Base =
                pigment {
                        function {Pf_Edges(x,y,z).gray}
                        pigment_map {
                                [0 rgb StainColor]
                                [1 StonePigment]
                        }
                }
        #else    
                #declare P_Base = StonePigment;
        #end
        
        Decl_Pf_Bumps (<0.075,1.5,1>) 
        
        #declare P_Stain_Top =
        pigment { 
               function {Pf_GradientY (x,y,z).gray}  
               pigment_map {
                       
                       [0      P_Base] 
                       [0.9    function {Pf_Bumps (x,y,z).gray}
                               pigment_map {
                                       [0       rgb StainColor]
                                       [1       P_Base]
                               }
                       ]
               } 
       }
       
       #declare P_Stain_Bottom =
       pigment { 
               function {Pf_GradientY (x,y,z).gray}  
               pigment_map {
                       
                        
                       [0     
                               average
                               pigment_map {
                                        #local M = 0;
                                        #while (M < 5)
                                                Decl_Pf_Bumps (<0.25,0.5,1>)     
                                                [1
                                                        function {Pf_Bumps (x,y,z).gray}
                                                        pigment_map {
                                                                [0       rgb StainColor]
                                                                [1       P_Base]
                                                        }
                                                ]
                                        #local M = M+1;
                                        #end              
                               }
                       ] 
                       [0.5    P_Base]
               } 
               
       }

       #declare P_Stain = 
       pigment { 
               function {Pf_GradientY (x,y,z).gray}  
               pigment_map {
                       
                       [0     rgb StainColor] 
                       [0.01  P_Stain_Bottom] 
                       [0.99  P_Stain_Top]  
                       [1     rgb StainColor]
               } 
               
       }
#end

#local Width    = 1;
#local Height   = 1;
#local Thick    = 1;
#local Round    = 0.03; 
#local StainColor = <0,0,0>; 

//produce the needed function definitions
Decl_Pf_Granite (0.075)         //scale 0.075
Decl_Pf_Crackle (0.75)          //scale 0.75     
Decl_Pf_Boxed (<Width,Height,1>)   
Decl_Pf_Edges (0.4)             //Contrast = 1 - 1 = full  
Decl_Pf_GradientY (Height)  

//probably not the most logical place for this but:
#local StonePigmentMap =
pigment_map {
        [0  rgb CHSL2RGB (<24,0.1,0.99>)]
        [1  rgb CHSL2RGB (<24,0.1,0.1>)]
}  

//produce the pigment definitions
Decl_P_Stone (Pf_Granite, StonePigmentMap)          
Decl_P_Stain (StainColor, P_Stone)  

#declare T1 = 
material {
        texture {
                pigment {P_Stain}
                finish {Finish_Stone}
                normal {pigment_pattern {P_Base} bump_size 0.3}
        }
        scale 0.25
        translate y*0.25
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 164) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  variation of image_map proceduralizing  http://www.ignorancia.org/uploads/zips/asceta.zip 

#declare p_wall1=
pigment {
        image_map {png "t1"}
        translate -0.5
        warp {turbulence 1 lambda 2}
}

#declare p_wall4=
pigment {
        image_map {png "t1a"}
        translate -0.5
        warp {turbulence 1 lambda 2}
}

#declare p_wall2=
pigment {
        image_map {png "t2"}
        translate -0.5
        warp {turbulence 1 lambda 2}
}

#declare p_wall3=
pigment {
        image_map {png "t3"}
        translate -0.5
        warp {turbulence 1 lambda 2}
}
        
#declare T1 =
material {
        texture {
                pigment {
                        dents 
                        warp {turbulence 1 lambda 3}
                        pigment_map {
                                [0.20 p_wall2]
                                [0.25 p_wall1]
                                [0.35 p_wall4]
                                [0.50 p_wall3]
                        }
                }
                normal {
                        dents
                        warp {turbulence 1 lambda 3}
                        normal_map {
                                [0.00 granite -0.5 scale 0.1]
                                [0.20 granite 0.5 scale 0.1] 
                                [0.25 agate 0.5 scale 1]
                                [0.35 dents 0.5 scale 1] 
                                [0.50 bozo 0.5 scale 1]
                                [1.00 bozo -0.5 scale 1]
                        }
                }
                finish {diffuse 0.65 specular 1 roughness 0.002}
        }
        scale 0.2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 165) /////////////////////////////////////////////////////////////////////////////////////

// Xplo Eristotle  "Rust and Sky" source  http://news.povray.org/povray.text.scene-files/message/%3C38E7BA86.4122748B%40unforgettable.com%3E/#%3C38E7BA86.4122748B%40unforgettable.com%3E

// RUST
#declare rust = 
texture {
	pigment {
		granite
		color_map {
			[0.0 rgb Ga (<0.809995, 0.299123, 0.113405>*0.8)]
			[0.4 rgb Ga (<0.209995, 0.096941, 0.031510>*1.2)]
			[0.6 rgb Ga (<0.209995, 0.096941, 0.031510>*1.2)]
			[1.0 rgb Ga (<0.569986, 0.052720, 0.005707>*0.9)]
		}
		scale 0.5
		turbulence 1
	}
	normal {wrinkles}
	finish {diffuse 0.5}
        scale 0.05
}

// IRON
#declare iron = 
texture {
	pigment {rgb Ga (<0.25,0.25,0.25>)}
	normal {granite 0.3  scale 0.1}
	finish {roughness 0.01 specular 0.5 reflection 0.05 diffuse 0.4}
}

// RUSTY IRON
#declare rusty_iron = 
texture {
        pigment_pattern {
                bozo
                turbulence 1
                omega 0.3
                lambda 4
        }
	texture_map {
		[0 rust]
		[1 iron]
	}
}

// STEEL
#declare steel = 
texture {
	pigment {rgb Ga (<0.15,0.15,0.15>)}
	normal {wrinkles 0.02 scale 0.1}
	finish {
                reflection {0.5}
                conserve_energy
                ambient 0
                diffuse 0.3
                phong 1
                phong_size 20
                specular 0.75
                roughness 0.001
                metallic 0.9
                brilliance 2.3
	}
}

// RUSTY STEEL
#declare T1 = 
material {
        texture {
                pigment_pattern {
        	        bozo
                        turbulence 1
        	        omega 0.6
        	        lambda 4
                }
        	texture_map {
        		[0.0  rust]
        		[0.2  rust]
        		[0.5  iron]
        		[0.6  steel]
        		[1.0  steel]
        	}

        }
        interior {ior 2}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 166) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  drops11  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062548551%40news.povray.org%3E/drops11.pov.txt?ttop=321382&toff=450

#declare pbr =
pigment {
        cells 
        color_map {
                [0,     rgb <0.9,0.8,1>]
                [1,     rgb <0.4,0.7,1>]
        }
        scale 0.5
}

#declare pla =
texture {
        pigment {rgb 1}
        finish {diffuse 1.1*0.5 phong 1.2 phong_size 80 reflection {0.1,0.3}}
        normal {bozo 0.3 scale 0.01}
}

#declare T1 = 
material {
        texture {
                pla
                //  pigment {checker color rgb <0.5,0.3,0.9> color rgb 1 
                pigment {//checker color rgb <0.45,0.34,0.35> color rgb <0.9,0.85,1> scale 4
                        gradient x 
                        sine_wave 
                        pigment_map {
                                [0.1,   gradient z 
                                        sine_wave 
                                        pigment_map {
                                                [0.1,   pbr]
                                                [0.35,  rgb 1]
                                                [0.5,   rgb <0.65,0.75,1>]
                                                [0.65,  rgb 1]
                                                [0.9,   pbr]
                                        }
                                ]
                                [0.35,  rgb 1]
                                [0.5,   rgb <0.65,0.75,1>]
                                [0.65,  rgb 1]
                                [0.9,   gradient z 
                                        sine_wave 
                                        pigment_map {
                                                [0.1,   pbr]
                                                [0.35,  rgb 1]
                                                [0.5,   rgb <0.65,0.75,1>]
                                                [0.65,  rgb 1]
                                                [0.9,   pbr]
                                        }
                                ]
                        }
                        scale 4 
                        rotate y*45 
                        scale 5*z 
                        warp {turbulence 0.4 octaves 3}
                        scale z*0.2 
                        rotate y*-45
                        rotate y*-45 
                        scale 5*z 
                        warp {turbulence 0.22 octaves 3}
                        scale z*0.2 
                        rotate y*45 
                        translate y*0.5
                        scale 2.5   
                }
                normal {bozo 1.1 scale 8}
        }
        interior {ior 1.4}
        rotate x*90
        scale 0.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 167) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  cuptexture  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062548551%40news.povray.org%3E/cuptexture.pov.txt?ttop=321382&toff=450

#declare T1 = 
material {
        texture {
                pigment {
                        average 
                        pigment_map {
                                [1,     bozo 
                                        scale 0.2 
                                        scale x*0.1 
                                        color_map {
                                                [0.6,   rgb <1,0.97,0.94>]
                                                [1,     rgb <0.7,0.3,0.1>-0.1]
                                        }
                                ]
                                [1,     bozo 
                                        scale 0.2 
                                        scale z*0.1 
                                        color_map {
                                                [0.6,   rgb <1,0.97,0.94>]
                                                [1,     rgb <0.7,0.3,0.1>-0.1]
                                        }
                                ]
                        }
                }
                finish {diffuse 0.6 phong 0.4 reflection {0, 0.6 fresnel on} conserve_energy}
        }
        interior {ior 1.4}
        rotate x*90
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 168) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  a collection of rusty metals  http://news.povray.org/povray.binaries.scene-files/message/%3C52f73d83%241%40news.povray.org%3E/#%3C52f73d83%241%40news.povray.org%3E
// based on Meothuru  A texture for "Stone with patina" or "Corroded iron"  http://news.povray.org/povray.text.scene-files/message/%3Cweb.4739435b5f90c0125a73e3b40%40news.povray.org%3E/#%3Cweb.4739435b5f90c0125a73e3b40%40news.povray.org%3E

#declare P_Silver3 = rgb <0.94,0.93,0.90>;

#declare F_MetalC  =
finish {
        ambient 0
        brilliance 4
        diffuse 0.25
        metallic
        specular 0.80
        roughness 1/80
        reflection 0.5
}

#declare T_Silver_3C = texture {pigment {P_Silver3} finish {F_MetalC}}

// uncomment the lines below to get the metal corrosion. otherwise 'stone' texture
#declare Me_corrodedMetal1 =
texture {T_Silver_3C}
texture {
        pigment {
                cells
                turbulence 1 octaves 5 omega 1 lambda 5
                //pigment_map {
                        //[0	Black filter 0.0]
                        //[1	White filter 0.99]
                //}
        }
        normal {
                cells -5
                turbulence 1 octaves 5 omega 1 lambda 5
                accuracy 0.001
        }
}

// and with color variation as given by Grassblade:
#declare Me_corrodedMetal2 =
texture {
        pigment {
                cells
                turbulence 1 octaves 5 omega 1 lambda 5
                color_map {
                        [0.0 rgb <0.5,0.3,0.1>]
                        [0.5 rgb <0.45,0.45,0.45>]
                        [1.0 rgb <0.5,0.3,0.1>]
                }
        }
        normal {
                cells -5
                turbulence 1 octaves 5 omega 1 lambda 5
                accuracy 0.001
        }
}

#declare T1 = 
material {
        texture {
                cells
                turbulence 1 octaves 5 omega 1 lambda 5
                texture_map {
                        [0.0 Me_corrodedMetal2]
                        [0.5 T_Silver_3C]
                        [1.0 Me_corrodedMetal2]
                }
        }
        interior {ior 1.1}
        scale 1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 169) /////////////////////////////////////////////////////////////////////////////////////

// Mike Sobers  Rusty steel  http://news.povray.org/povray.binaries.images/message/%3Cweb.49cff2824ee6dd4e5aa5eee10%40news.povray.org%3E/#%3Cweb.49cff2824ee6dd4e5aa5eee10%40news.povray.org%3E
 
#declare base =
texture {
        pigment {rgb <0.91,0.95,0.91>*0.5}
        normal {
                wrinkles
                normal_map {
                        [0.00 granite 0.0 scale 0.001]
                        [0.20 granite 0.0 ]
                        [0.28 wrinkles 0.05 turbulence 0.5 scale 0.005]
                        [0.38 wrinkles 0.05 turbulence 0.5 scale 0.005]
                        [0.40 granite 0.0 ]
                        [0.62 granite 0.05 turbulence 0.5 scale 0.005]
                        [0.90 granite 0.0 ]
                        [1.00 granite 0.0 scale 0.001]
                }
                turbulence 0.05
                scale 300
        }
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 0.0005
                reflection {0.5,1 fresnel on}
                conserve_energy
        }
}

#declare tex1 =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb <0.7,0.4,0.2>]
                        [1 rgb <0.6,0.2,0.05>]
                } 
                turbulence 0.2 
                scale 0.5
        }
        normal {
                bumps 0.2
                turbulence 0.05
                scale 0.5
        }
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.20
                roughness 0.05
                reflection 0.05
        }
}

#declare tex2 =
texture {
        wrinkles
        texture_map {
                [0   base]
                [0.5 tex1]
        }
        scale 0.2 
        turbulence 0.5
}

#declare T1 = 
material {
        texture {
                wrinkles
                texture_map {
                        [0.00  base]
                        [0.10  base]
                        [0.10  tex2 scale 0.005]
                        [0.11  tex2 scale 0.005]
                        [0.12  base]
                        [0.50  base]
                        [0.70  tex2 scale 0.05]
                }
                scale 0.2 
                turbulence 0.5
        }
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 170) /////////////////////////////////////////////////////////////////////////////////////

// David Anjo  Rusty Chrome texture  http://news.povray.org/povray.binaries.scene-files/message/%3C52f73d83%241%40news.povray.org%3E/#%3C52f73d83%241%40news.povray.org%3E

#declare TM_Rusty_Chrome =
texture {
        pigment {
                granite
                color_map {
                        [0.00 rgb <0.400, 0.400, 0.400>]
                        [0.70 rgb <0.498, 0.498, 0.498>]
                        [0.70 rgb <0.898, 0.518, 0.278>]
                        [0.75 rgb <0.698, 0.137, 0.000>]
                        [0.80 rgb <0.698, 0.400, 0.078>]
                        [0.80 rgb <0.698, 0.439, 0.078>]
                        [0.85 rgb <0.498, 0.298, 0.278>]
                        [0.85 rgb <0.498, 0.318, 0.278>]
                        [0.90 rgb <0.878, 0.498, 0.278>]
                        [0.90 rgb <0.498, 0.498, 0.498>]
                        [1.00 rgb <0.400, 0.400, 0.400>]
                }
        }
        finish {
                brilliance 6.0
                phong 0.25    
                metallic
                reflection 0.05
        }
}

#declare T1 = 
material {
        texture {TM_Rusty_Chrome}
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 171) /////////////////////////////////////////////////////////////////////////////////////

// Tim Attwood   OK black metal that looks cast  http://news.povray.org/povray.advanced-users/message/%3C44b074bc%40news.povray.org%3E/#%3C44b074bc%40news.povray.org%3E

#declare TA_CastMetal =
texture {
        pigment {rgb 0.5}
        normal {facets coords 1}	
        finish {
                ambient 0
                brilliance 2
                diffuse 0.6		
                metallic
                specular 0.5
                roughness 0.0833
                reflection 0.1
        }
}

#declare T1 = 
material {
        texture {TA_CastMetal}
        scale 0.3
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 172) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Cross-bedded sandstone macro  http://news.povray.org/povray.binaries.scene-files/attachment/%3C4465d7ec%40news.povray.org%3E/Cross-bedded%20sandstone_mcr.pov.txt

#local RandNr = 2;										
#local Frequency = 5*2;
#local Turbulence = 0.05*2;							
#local Psandstone =
pigment_map {
	[0.0   rgb <1.0, 0.8854, 0.604167>]
	[0.4   rgb <0.98, 0.781, 0.438>   ]
	[0.8   rgb <0.906, 0.656, 0.336>  ]
	[1.0   rgb <0.824, 0.531, 0.234>  ]
}
#local Bedrot1 = <0,0,-15>;		
#local Bedrot2 = <0,0,15>;		
#local Set = 0.5;				
#local Set = 0.1;								
#local Ndepth = 0.05;				
#local Tscale = 1;				
#local Trot = <0,0,0>;			
#local Ttrans = <0,0,0>;			

#local Seed = seed (RandNr);

#declare CrossBeddedSst = 
texture {
        gradient y
        turbulence Turbulence
        frequency Frequency
        texture_map {
                [0.1    pigment {
                                agate
                                agate_turb 1
                                pigment_map {Psandstone}
                                scale  <1,0.01,1>
                        }
                        normal {
                                agate Ndepth
                                agate_turb 1
                                scale  <1,0.01,1>
                        }
                        finish {ambient 0 brilliance 0.5}
                ]
                [Set    pigment {
                                agate
                                agate_turb 1
                                pigment_map {Psandstone}
                                scale  <1,0.01,1>
                                Axis_Rotate_Trans (x, Bedrot1.x)
                                Axis_Rotate_Trans (z, Bedrot1.z)
                                Axis_Rotate_Trans (y, Bedrot1.y)
                        }
                        normal {
                                agate Ndepth
                                agate_turb 1
                                scale <1,0.01,1>
                                Axis_Rotate_Trans (x, Bedrot1.x)
                                Axis_Rotate_Trans (z, Bedrot1.z)
                                Axis_Rotate_Trans (y, Bedrot1.y)
                        }
                        finish {ambient 0 brilliance 0.5}
                ]
                [Set+0.01
                        pigment {
                                agate 
                                agate_turb 1
                                pigment_map {Psandstone}
                                scale  <1,0.01,1>
                        }
                        normal {
                                agate Ndepth
                                agate_turb 1
                                scale  <1,0.01,1>
                        }
                        finish {ambient 0 brilliance 0.5}
                ]
                [Set+0.1  
                        pigment {
                                agate 
                                agate_turb 1
                                pigment_map {Psandstone}
                                scale  <1,0.01,1>
                        }
                        normal {
                                agate Ndepth
                                agate_turb 1
                                scale  <1,0.01,1>
                        }
                        finish {ambient 0 brilliance 0.5}
                ]
                [Set+0.11  
                        pigment {
                                agate
                                agate_turb 1
                                pigment_map {Psandstone}
                                scale  <1,0.01,1>
                                Axis_Rotate_Trans (x, Bedrot2.x)
                                Axis_Rotate_Trans (z, Bedrot2.z)
                                Axis_Rotate_Trans (y, Bedrot2.y)
                                translate <5,3,9>
                        }
                        normal {
                                agate Ndepth
                                agate_turb 1
                                scale  <1,0.01,1>
                                Axis_Rotate_Trans (x, Bedrot2.x)
                                Axis_Rotate_Trans (z, Bedrot2.z)
                                Axis_Rotate_Trans (y, Bedrot2.y)
                                translate <5,3,9>
                        }
                        finish {ambient 0 brilliance 0.5}
                ]
        }
        scale  Tscale
        Axis_Rotate_Trans (x, Trot.x)
        Axis_Rotate_Trans (z, Trot.z)
        Axis_Rotate_Trans (y, Trot.y)
        translate Ttrans
}

#declare T1 = 
material {
        texture {CrossBeddedSst}
        scale 2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 173) /////////////////////////////////////////////////////////////////////////////////////

// Nekar Xenos  FracTex  http://news.povray.org/irtc.stills/message/%3Cop.vgamja01ufxv4h%40go-dynamite%3E/#%3Cop.vgamja01ufxv4h%40go-dynamite%3E

#macro FracTex (Recursions)

#local Count = 0;
#while (Count < Recursions)
        crackle
        rotate Count*30
        triangle_wave
        warp {turbulence 0.3}
        scale 0.5
        texture_map {
                [0      pigment {rgb Fract_colors (Count)}
                        normal {
                                crackle (Recursions-Count)*0.5 
                                slope_map {
                                        [0.0 <-1,1>]
                                        [0.1 <1,-1>]
                                        [1.0 <0,0>]
                                }
                        }
                ]
                [0.1
        #local Count = Count+1;
#end
pigment {rgb  Fract_colors (Count)}
normal {
        crackle  Count/0.5 
        slope_map {
                [0.0 <-1,1>]
                [0.1 <1,-1>]
                [1.0 <0,0>]
        } 
}
#while (Count > 0)
        ]
        }
        #local Count = Count-1;
#end

#end

//texture {FracTex (5)} scale 0.5

#declare Fract_colors = spline {linear_spline 2,<0.3,0.02,0.01>,9,<1,0.4,0.2>};
//#declare Fract_colors = spline {linear_spline 2,<0.11,0.1,0.09>*0.001,7,<0.15,0.13,0.1>*9};

#declare T1 = 
material {
        texture {FracTex (7)}
        scale 2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 174) /////////////////////////////////////////////////////////////////////////////////////
 
// Christophe Bouffartigue  cbwor  http://www.irtc.org/ftp/pub/stills/2001-02-28/cbwor.zip

#declare Pat_Crack = 
pigment {
	bozo
	warp {turbulence 0.2 octaves 3 omega 0.3 lambda 2}
	scale 2
	warp {turbulence 0.7 octaves 3 omega 0.3 lambda 2}
	scale 2
	warp {turbulence 1 octaves 3 omega 0.3 lambda 2}
	scale 6
	warp {turbulence 1 octaves 3 omega 0.3 lambda 2}
	color_map {
                [0 rgb 0]
                [1 rgb 1]
        }
}

#declare N_Crack = 
normal {
	bozo
	warp {turbulence 0.2 octaves 3 omega 0.3 lambda 2}
	scale 2
	warp {turbulence 0.7 octaves 3 omega 0.3 lambda 2}
	scale 2
	warp {turbulence 1 octaves 3 omega 0.3 lambda 2}
	scale 6
	warp {turbulence 1 octaves 3 omega 0.3 lambda 2}
	slope_map {
		[0.4900 <0.5, 0>]
		[0.5000 <0.5, 0.5>]
		[0.6000 <1,   0.5>]
		[0.6000 <1,  -3>]
		[0.6001 <0,  -3>]
		[0.6001 <0,   0>]
		[0.9999 <0,   0>]
	}
}

#declare T_Mur_1 = 
texture {
	pigment {
                pigment_pattern {Pat_Crack} 
                color_map {
                        [0.6001 rgb 0.70*1.1*<1.2,1.15,1>]
                        [0.6001 rgb 0.85*1.1*<1.2,1.15,1>]
                } 
        }
	normal {
                average
		normal_map {
			[4 N_Crack 1.5*2]
			[1 granite  1.2*2 poly_wave 2 scale 0.5]
			[1 wrinkles 1.5*2 poly_wave 2 scale 10]
			[1 wrinkles 1.3*2 poly_wave 2 scale 2]
			[1 dents   -1.8*2 poly_wave 2 scale 2]
		}
	}
}
texture {
	pigment {
		wrinkles
		color_map {
			[0.00 rgbt 1.1*<1.2,1.15,1.0,1>]
                        [0.30 rgbt 1.1*<1.2,1.15,1.0,1>]
			[0.65 rgbt <0.6,0.3,0.2,0.8>*1.1*<1.2,1.15,1.0,1>]
                        [1.00 rgbt <0.5,0.2,0.1,0.6>*1.1*<1.2,1.15,1.0,1>]
		}
		scale <20,40,20>
	}
	normal {bumps 0.6 scale 0.5}
}
texture {
	pigment {
		pigment_pattern {
			planar
			scale <5,5,5>
			warp {turbulence 0.6 octaves 2 lambda 2}
			scale <1/3,4,1/3>
			color_map {
                                [0 rgb 0]
                                [1 rgb 1]
                        }
		}
		pigment_map {
			[0      rgbt 1]
			[0.4    wrinkles
				scale <3,5,3>
				color_map {
					[0.00 rgbt 1.1*<1.2,1.15,1.0,1>]
                                        [0.30 rgbt 1.1*<1.2,1.15,1.0,1>]
					[0.65 rgbt <0.5,0.3,0.1,0.7>*1.1*<1.2,1.15,1.0,1>]
                                        [1.00 rgbt <0.4,0.25,0.1,0.5>*1.1*<1.2,1.15,1.0,1>]
			        }
                        ]
		}
	}
}

#declare T1 = 
material {
        texture {T_Mur_1}
        scale -0.015
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 175) /////////////////////////////////////////////////////////////////////////////////////

// Fabien Mosen  fmsea  http://www.irtc.org/ftp/pub/stills/2000-08-31/fmsea.zip

#declare Couleurs1 = 
color_map {
        [0.0     rgbft <1, 1, 1,                      0.5, 0.0>]
        [0.2     rgbft <0.685540, 0.639375, 0.439460, 0.3, 0.0>]
        [0.4     rgbft <0.709194, 0.599041, 0.457472, 0.5, 0.0>]
        [0.6     rgbft <0.814853, 0.769486, 0.711181, 0.3, 0.0>]
        [0.8     rgbft <0.424531, 0.390284, 0.346269, 0.0, 0.0>]
        [1.0     rgbft <0.266578, 0.224704, 0.170889, 0.0, 0.0>]
}

#declare Couleurs2 = 
color_map {
        [0.0       rgbft <0.707322, 0.146811, 0.146811, 0.0, 0.0>*1.2]
        [0.142857  rgbft <0.956597, 0.956597, 0.210069, 0.2, 0.0>*1.2]
        [0.285714  rgbft <1.0,      0.710925, 0.229133, 0.0, 0.0>*1.5]
        [0.428571  rgbft <0.796294, 0.155153, 0.057839, 0.0, 0.0>*1.2]
        [0.571429  rgbft <0.956597, 0.956597, 0.210069, 0.5, 0.0>]
        [0.714286  rgbft <0.911021, 0.446037, 0.234779, 0.0, 0.0>*1.2]
        [0.857143  rgbft <1.0,      0.125,    0.125,    0.0, 0.0>*1.5]
        [1.0       rgbft <0.956597, 0.956597, 0.210069, 0.3, 0.0>]
}

#declare Pig02 = 
pigment {
        bozo
        color_map {Couleurs1}
        turbulence 0.5
        omega 0.8
        sine_wave   
        scale 2
} 

#declare T1 = 
material {
        texture {pigment {Red + OrangeRed}}
        texture {
                pigment {Pig02} 
                normal {crackle 0.5*2 scale <0.2,0.5,0.2>} 
                finish {phong 0.8}
        }
        scale 0.1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 176) /////////////////////////////////////////////////////////////////////////////////////

// Janet  Chinese Dish with pigment_pattern  http://news.povray.org/povray.binaries.images/message/%3Cweb.4544e61631a11665156dd69f0%40news.povray.org%3E/#%3Cweb.4544e61631a11665156dd69f0%40news.povray.org%3E

//This is the color image
#declare p_map1 = pigment {image_map {jpeg "pattern5" interpolate 2}}

//This is a gray scale image to define the textures
#declare p_mapPM = pigment {image_map {jpeg "pattern5grey" interpolate 2}}

#declare GoldBase = <1,0.875,0.575>;  // mine again  rgb <1,0.775,0.375>
#declare CVect3 = GoldBase - <0,0.1,0.2>;
#declare P_Gold3 = rgb CVect3;
#declare A_GoldC = <0,0,0>;
#declare R_GoldC = P_Gold3*0.65;
#declare D_GoldC = 1-(((R_GoldC.x+R_GoldC.y+R_GoldC.z)*0.33333)+((A_GoldC.x+A_GoldC.y+A_GoldC.z)*0.33333));
#declare M = 1; 

#declare F_MetalC = 
finish {
        brilliance 4 
        diffuse D_GoldC 
        ambient A_GoldC
        reflection R_GoldC
        metallic M 
        specular 0.60 
        roughness 0.0125 
}

#declare FIN = 
finish {
        phong 0.1 
        phong_size 30 
        diffuse 0.6 
        ambient 0 
        brilliance 0.6
}

#declare T1 = 
material {       
        texture {
                pigment_pattern {p_mapPM}
                texture_map{
                        [0      pigment {p_map1}
                                finish {FIN}
                                normal {
                                        average
                                        normal_map {
                                                [       bumps 0.3*3
                                                        warp {turbulence 1}
                                                        scale 0.2
                                                ]
                                                [       bumps 0.2*3
                                                        warp {turbulence 0.5}
                                                        scale 0.001
                                                ]
                                        }
                                }
                        ]
                        [0.9    pigment {p_map1}
                                finish {FIN}
                                normal {
                                        average
                                        normal_map {
                                                [       bumps 0.3*3
                                                        warp {turbulence 1}
                                                        scale 0.2
                                                ]
                                                [       bumps 0.2*3
                                                        warp {turbulence 0.5}
                                                        scale 0.001
                                                ]
                                        }
                                }
                        ]
                        [0.99   pigment {rgb GoldBase}
                                finish {F_MetalC}
                        ]
                        [1      pigment {rgb GoldBase}
                                finish {F_MetalC}
                        ]
                }
        }
        scale 2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

//#if (mat = 177) /////////////////////////////////////////////////////////////////////////////////////

// Ryan Twitchell  rtgarden  http://www.irtc.org/ftp/pub/stills/1999-12-31/rtgarden.zip

#declare Shroom_Finish =
finish {
       phong 0.6
       reflection 0.1
       specular 0.5
       roughness 0.1
       ambient 0
       diffuse albedo 0.8*0.85
       //subsurface {translucency srgb <0.2,0.2,0.2>}
}

#declare Shroom_Normal = normal {wrinkles scale 0.35 bump_size 0.35}

#if (mat = 177) /////////////////////////////////////////////////////////////////////////////////////

#declare Orange_Spots_on_Red =
texture {
        pigment {
                leopard
                turbulence 0.2
                color_map {
                        [0.00 rgb <0.6,0.0, 0.1>]
                        [0.25 rgb <0.6,0.0, 0.1>]
                        [0.30 rgb <0.8,0.25,0.0>]
                        [0.35 rgb <0.6,0.0, 0.1>]
                        [0.45 rgb <0.9,0.4, 0.0>]
                        [0.80 rgb <0.9,0.4, 0.0>]
                        [1.00 rgb <1.0,0.5, 0.0>]
                }
                scale 0.12
        }
        finish {Shroom_Finish}
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {Orange_Spots_on_Red}
        scale 1
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 178) /////////////////////////////////////////////////////////////////////////////////////

#declare Yellow_Orange =
texture {
        pigment {
                hexagon 
                rgb <0.6,0.6,0>, rgb <0.7,0.35,0.1>, rgb <0.9,0.25,0.1>
                turbulence 0.6
                scale 0.5
        }
        finish {Shroom_Finish} 
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {Yellow_Orange}
        scale 0.5
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 179) /////////////////////////////////////////////////////////////////////////////////////

#declare Yellow_Spots_on_Green =
texture {
        pigment {
                quilted
                turbulence 0.3
                color_map {
                        [0.25 rgb <0.85,0.7,0>]
                        [0.5  rgb <0.10,0.7,0.2>]
                        [0.7  rgb <0.85,0.7,0>]
                }
                scale 0.8
        }
        finish {Shroom_Finish}
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {Yellow_Spots_on_Green}
        scale 0.5
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 180) /////////////////////////////////////////////////////////////////////////////////////

#declare MiniMush_Texture01 =
texture {
        pigment {
                granite //leopard
                color_map {
                        [0.0 rgb <0.55,0.55,0.6>]
                        [0.7 rgb <0.55,0.55,0.6>]
                        [0.7 rgb <0.30,0.30,0.35>]
                }
        }
        finish {      
                Shroom_Finish
                metallic
                reflection {0.3, 0.65 fresnel on}
                conserve_energy
                phong 0.8
                ambient 0
                diffuse 0.6
        }
        normal {dents}
        scale 0.027
}

#declare T1 = //rtgarden
material {
        texture {MiniMush_Texture01}
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 181) /////////////////////////////////////////////////////////////////////////////////////

#declare BGInnerPigment =
pigment {
      leopard
      turbulence 0.7
      color_map {
       [0.0 rgb <0.2, 0.6, 0.22>]
       [0.5 rgb <0.2, 0.6, 0.22>]
       [0.7 rgb <0.1, 0, 0.65>]
      }
      scale 0.4
}

#declare Blue_on_Green =
texture {
        pigment {
                leopard
                turbulence 0.4
                pigment_map {
                        [0.0 BGInnerPigment]
                        [0.3 BGInnerPigment]
                        [0.65 rgb <0.1,0.0,0.65>]
                        [0.75 rgb <0.1,0.0,0.7>]
                }
                scale 0.08
        }
        finish {Shroom_Finish}
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {Blue_on_Green}
        scale 1
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 182) /////////////////////////////////////////////////////////////////////////////////////

#declare Blue_to_Purple =
texture {
        pigment {
                agate//gradient z
                turbulence 0.45
                color_map {
                        [0.0 rgb <0.20,0.2,0.7>]
                        [0.4 rgb <0.25,0.3,0.8>]
                        [0.7 rgb <0.35,0.0,0.8>]
                        [0.8 rgb <0.70,0.0,0.85>]
                }
        }
        finish {Shroom_Finish}
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {Blue_to_Purple}
        scale 1
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 183) /////////////////////////////////////////////////////////////////////////////////////

#declare RedPurple_Spots_on_Purple =
texture {
        pigment {
                radial
                turbulence 0.2
                color_map {
                        [0.0 rgb <0.85,0,0.4>]
                        [0.4 rgb <0.50,0,0.6>]
                        [0.5 rgb <0.20,0,0.6>]
                }
        }
        finish {Shroom_Finish}
        normal {Shroom_Normal}
}

#declare T1 = //rtgarden
material {
        texture {RedPurple_Spots_on_Purple}
        scale 1
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 184) /////////////////////////////////////////////////////////////////////////////////////

#declare Purple_Red_Waves =
texture {
         pigment {     
                waves
                turbulence 0.25
                color_map {
                        [0.0 rgb <0.30,0,0.7>]
                        [0.3 rgb <0.55,0,0.55>]
                        [0.5 rgb <0.80,0,0.45>]
                        [0.7 rgb <0.55,0,0.55>]
                        [1.0 rgb <0.30,0,0.7>]
                }
                scale 0.2
        }
        finish {Shroom_Finish diffuse 0.6*0.85 ambient 0}
        normal {Shroom_Normal }
}

#declare T1 = //rtgarden
material {
        texture {Purple_Red_Waves}
        scale 0.5
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 185) /////////////////////////////////////////////////////////////////////////////////////

#declare Black_Stripes_on_White =
texture {
        pigment {
                spotted
                turbulence 0.2
                pigment_map {
                        [0.0    rgb <0.25,0.2,0.25>]
                        [0.35   rgb <0.3,0.24,0.3>]
                        [0.4    bumps //rgb <1.0, 0.9, 1.0>]
                                color_map {
                                        [0.0  rgb <1.0,0.875,1.0>]
                                        [0.8  rgb <1.0,0.875,1.0>]
                                        [0.85 rgb <0.5,0.450,0.5>]
                                        [1.0  rgb <0.4,0.400,0.4>]
                                }
                                scale 0.06
                        ]
                }
                scale <0.25,0.25,40>
                rotate y*80
                translate x*365
        }          
        finish {
                Shroom_Finish
                diffuse 0.75*0.7
                ambient 0
        }
        normal {Shroom_Normal }
}

#declare T1 = //rtgarden
material {
        texture {Black_Stripes_on_White}
        scale 0.3
        rotate x*-45
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 186) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  aviary  http://www.irtc.org/ftp/pub/stills/2000-02-29/aviary.zip
            	
#declare RockTex = 
texture {
	pigment {Wheat}
	normal {
                average 
                normal_map {
                        [0.0 bumps 15*0.2 scale 0.01 ]
                        [0.3 dents 10*0.2 scale 0.002]
                        [0.6 granite 10*0.2 scale 0.001]
                        [1.0 wrinkles 15*0.2 scale 0.1 ramp_wave]
                }  
        }
	finish {specular 0.25 ambient 0}
}
texture {
        pigment {
                bozo
                turbulence 0.5
                frequency 3
                lambda 6
                color_map {
                        [0.50 rgbt 1]
                        [0.65 rgbt <0.5,0.3,0.2,0.6>]
                        [0.70 rgb <0.1,0.3,0>]
                        [0.85 rgb <0.5,0.3,0>*2.5]
                        [0.90 rgb <0.4,0.5,0>]
                }
                scale 1.25
        }
        normal {granite 15*0.2 scale 0.01}
}

#declare T1 = 
material {
        texture {RockTex}
        interior {ior 1.5}
        scale 0.4
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 187) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  My First CGSphere  http://news.povray.org/povray.binaries.images/message/%3Cweb.487c960ee928bccebd1b3ad10%40news.povray.org%3E/#%3Cweb.487c960ee928bccebd1b3ad10%40news.povray.org%3E

//  Hammered gold

#declare P_Gold = rgb <124,114,58>/255;

#declare N_Dented1 = 
normal {
        bumps
        turbulence 0
        normal_map {
                [0.0  dents 1.5   scale 0.3]
                [0.5  dents 1     scale 0.15]
                [0.55 dents 0.125 scale 0.012]
                [0.6  dents 1.25  scale 0.15]
                [1.0  dents 1     scale 0.5]
        }
}

#declare N_Dented2 = 
normal {
        bumps
        turbulence 0
        normal_map {
                [0.0 dents 0.25  scale 1]
                [0.3 dents 1     scale 0.1]
                [0.4 dents 0.125 scale 0.01]
                [0.5 dents 1.25  scale 0.1]
                [1.0 dents 0.1   scale 1]
        }
        scale 0.75
}

#declare N_Dented3 = 
normal {
        bumps
        turbulence 0
        normal_map {
                [0.0 dents 0.125 scale 0.8]
                [0.3 dents 0.100 scale 0.12]
                [0.4 bumps 0.250 scale 0.1]
                [0.5 dents 0.125 scale 0.01]
                [1.0 dents 0.100 scale 1.2]
        }
        scale 0.5
}

#declare N_Hammered3 = 
normal {
        average
        normal_map {
                [1   N_Dented1]
                [1   N_Dented2]
                [1   N_Dented3]
                [0.5 granite 0.5]
        }
}

#declare F_MetalX =
finish {
        ambient 0
        brilliance 20
        diffuse 0.9
        metallic
        specular 4
        roughness 0.004
        reflection {1 metallic}
}

#declare T_Hammered_Gold =
texture {
        pigment {P_Gold}
        normal {N_Hammered3}
        finish {F_MetalX}
}

#declare T1 = 
material {
        texture {T_Hammered_Gold}
        interior {ior 0.47}
        scale 0.03
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 188) /////////////////////////////////////////////////////////////////////////////////////

// Zeger Knaepen  no spherical-greebles  http://news.povray.org/povray.binaries.images/attachment/%3C44738fd7@news.povray.org%3E/us-ascii

#declare Kleur =     <1.0,1.0,0.9>;
#declare Vuilkleur = <0.75,0.8,0.6>;

#declare Gewoon_vuil =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb 0.2*Vuilkleur transmit 0.99]
                        [1 rgb 0.1*Vuilkleur transmit 0.8]
                }
                rotate x*90
                translate -0.5
                translate z*2
        }
        finish {ambient 0 diffuse 0.75}
}

#declare Gewoon_heel_vuil =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb 0.2*Vuilkleur transmit 0.99]
                        [1 rgb 0.1*Vuilkleur transmit 0.6]
                }
                rotate x*90
                translate -0.5
                //scale <4*6,1,3*6>
                translate z*2
        }
        finish {ambient 0 diffuse albedo 0.6}
}

#declare Scar =
texture {
        pigment {
                crackle form <1,0,0>
                color_map {
                        [0 rgbt <0.1,0.01,0,0.8>]
                        [0.2 rgbt <0.1,0.01,0,1>]
                }
                scale 0.5
                turbulence 0.2
                lambda 3
                scale 4
        }
        normal {dents 0.1*2}
        finish {diffuse albedo 0.6 ambient 0}
}

#declare BS = 8;

#declare T1 =
material {
        texture {
                pigment {
                        average
                        pigment_map {
                                [1      cells
                                        pigment_map {
                                                [0      cells
                                                        color_map {
                                                                [0 rgb 0.8*Kleur]
                                                                [1 rgb     Kleur]
                                                        }
                                                        scale 0.5
                                                ]
                                                [.4     cells
                                                        color_map {
                                                                [0 rgb 0.8*Kleur]
                                                                [1 rgb     Kleur]
                                                        }
                                                        translate <0.25,0.5,0.2>
                                                ]
                                        }
                                        scale 1
                                ]
                                [1      cells
                                        color_map {
                                                [0 rgb 0.8*Kleur]
                                                [1 rgb     Kleur]
                                        }
                                        translate <0.25,1.5,0.2>
                                        scale 2
                                        translate <2.25,1.5,3.5>
                                ]
                        }
                        scale 0.25
                }
                normal {
                        average
                        normal_map {
                                [1      cells
                                        normal_map {
                                                [0      cells
                                                        bump_size 0.25*BS
                                                        scale 0.5
                                                ]
                                                [0.4    cells
                                                        bump_size 0.2*BS
                                                        translate <0.25,0.5,0.2>
                                                ]
                                        }
                                        scale 1
                                ]
                                [1      cells
                                        normal_map {
                                                [0      cells
                                                        bump_size 0.25*BS
                                                        scale 0.5
                                                ]
                                                [0.4    cells
                                                        bump_size 0.2*BS
                                                        translate <0.25,0.5,0.2>
                                                ]
                                        }
                                        scale 0.25
                                ]
                                [1      cells
                                        bump_size 0.125*BS
                                        translate <0.25,1.5,0.2>
                                        scale 2
                                        translate <2.25,1.5,3.5>
                                ]
                        }
                        scale 0.125/8
                }
                finish {ambient 0 diffuse albedo 0.6 brilliance 3 specular 1 roughness 0.01 metallic}
                scale 5*3
        }
        texture {Scar             scale <0.25,0.250,1.0>*3}
        texture {Gewoon_vuil      scale <0.50,0.250,1.0>*3} 
        texture {Gewoon_heel_vuil scale <0.25,0.125,0.7>*3} 
        scale 0.4
        interior {ior 2.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 189) /////////////////////////////////////////////////////////////////////////////////////

// Meothuru  a camouflage texture  http://news.povray.org/povray.binaries.images/message/%3Cweb.47c3ab7f3ea3d7f2a42a77a0%40news.povray.org%3E/#%3Cweb.47c3ab7f3ea3d7f2a42a77a0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {
                        cells
                        turbulence <1,1,1>
                        omega 0.33
                        lambda 6
                        matrix <0.66, 0, 0,
                                0.7, 0.66, 0,
                                0, 0, 0.66,
                                0, 0, 0>
                        pigment_map {
                                [0.0 rgb <0.392157, 0.368627, 0.27451>]
                                [0.4 rgb <0.572549, 0.462745, 0.368627>]
                                [1.0 rgb <0.00392157, 0.0196078, 0.054902>]
                        }
                }
                normal {
                        cells
                        1
                        turbulence <1,1,1>
                        omega 0.33
                        lambda 6
                        matrix <0.66, 0, 0,
                               0.7, 0.66, 0,
                               0, 0, 0.66,
                               0, 0, 0>
                }
                finish {
                        ambient 0
                        reflection {rgb <0.1,0.1,0.1> metallic 1}
                }
        }
        scale 0.25
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 190) /////////////////////////////////////////////////////////////////////////////////////

// Janet  a camouflage texture  http://news.povray.org/povray.binaries.images/message/%3Cweb.47ce286592c16960e1b4a5550%40news.povray.org%3E/#%3Cweb.47ce286592c16960e1b4a5550%40news.povray.org%3E 

#declare p1 = 200;
#declare p2 = 600;
#declare p3 = 500;
#declare p4 = 900;

#declare Camo1 =
texture {
        average
        texture_map {
                [1      pigment {
                                crackle
                                scale <1,2,1>*0.075
                                solid
                                turbulence 0.8
                                pigment_map {
                                        [ 0.0 rgb <149,137,108>/p1]
                                        [ 0.1 rgb <119,117, 89>/p2]
                                        [ 0.2 rgb < 87, 90, 64>/p2]
                                        [ 0.3 rgb < 73, 82, 62>/p1]
                                        [ 0.4 rgb < 98,105, 83>/p2]
                                        [ 0.5 rgb <121,125,105>/p2]
                                        [ 0.6 rgb <148,147,117>/p2]
                                        [ 0.7 rgb <107,104, 85>/p1]
                                        [ 0.8 rgb <131,127,113>/p2]
                                        [ 0.9 rgb < 86, 77, 60>/p1]
                                        [ 1.0 rgb <149,137,108>/p1]
                                }
                                rotate <-45,-45,-45>
                        }
                        finish  {specular 0.1 diffuse 0.6*1.8}
                ]
                [1      pigment {
                                cells
                                scale <1,2,1>*0.05
                                turbulence 0.8
                                pigment_map {
                                        [ 0.0 rgb <149,137,108>/p3]
                                        [ 0.1 rgb <119,117, 89>/p3]
                                        [ 0.2 rgb < 87, 90, 64>/p3]
                                        [ 0.3 rgb < 73, 82, 62>/p4]
                                        [ 0.4 rgb < 98,105, 83>/p4]
                                        [ 0.5 rgb <121,125,105>/p4]
                                        [ 0.6 rgb <148,147,117>/p3]
                                        [ 0.7 rgb <107,104, 85>/p3]
                                        [ 0.8 rgb <131,127,113>/p4]
                                        [ 0.9 rgb < 86, 77, 60>/p4]
                                        [ 1.0 rgb <149,137,108>/p2]
                                }
                        }
                        finish  {diffuse 0.8*1.8}
                ]
        }
}

#declare T1 =
material {
        texture {Camo1}
        scale 1.2
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 191) /////////////////////////////////////////////////////////////////////////////////////

// Caleb Hattingh and Braam van Dyk  cbveil  http://www.irtc.org/ftp/pub/stills/2003-12-31/cbveil.zip

#declare T1 =
material {
 	texture {
 	        pigment {rgb <1,1,0.8>}
 	        finish {   
 	                brilliance 1
 	                irid {
 	                        0.4
 	                        thickness 0.05
 	                        turbulence 5
 	                }                  
 	                reflection 0.4
 	                ambient 0 
 	                diffuse 0.36 
 	                phong 1 
 	                phong_size 80       
 	        }
                normal {dents 0.1 scale 0.5}
        }
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 192) /////////////////////////////////////////////////////////////////////////////////////

// Simon Adameit  Non-metal  http://news.povray.org/povray.binaries.images/message/%3C3ea81929%40news.povray.org%3E/#%3C3ea81929%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb 0.9}//<0.5,0.7,1>}
                finish {
                        ambient 0 
                        diffuse 0.3 
                        brilliance 4
                        specular 0.9 
                        roughness 0.01 
                        metallic 1.3
                        reflection {
                                0.25, 1 
                                exponent 0.9 
                                falloff 2 
                                metallic 0.9
                        }
                        irid {
                                0.1 
                                thickness 0.7 
                                turbulence 0.2
                        }
                }
        } 
        interior {ior 0.7}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 193) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  sub surface materials using media  http://www.evilsuperbrain.com/gallery/misc/crystal_sss2.pov

#declare radio  = 0;

#macro m_Pattern ()

agate
agate_turb 0.2
turbulence 0.4 omega 0.35 octaves 5
scale 1.5
rotate <60,45,0>
translate 0.16*y
color_map {
	[0.0  rgb 0.3]
	[0.2  rgb 1]
	[0.3  rgb <0.2,0.03,0>]
	[0.5  rgb <0.4,0.10,0>]
	[0.6  rgb <0.7,0.40,0.1>]
	[0.7  rgb <0.4,0.10,0>]
	[1.0  rgb <0.2,0.03,0>]
}

#end

#declare T1 =
material {
	#local fDensity = 8;
	#local fAbsorb = 0.4;
	interior {
		ior 1.3
		media {
			scattering {
				1, rgb fDensity
				extinction 0
			}
			absorption 0
			density {m_Pattern ()}
		}
		media {
			absorption fAbsorb
			density {rgb fDensity}
		}
	}
	texture {
		pigment {rgbt 1}
		finish {
			reflection {0.01, 0.8 falloff 5 exponent 0.5} 
                        conserve_energy
			phong 2 
                        phong_size 500
		}
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 194) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  moss on rock  http://news.povray.org/povray.binaries.scene-files/attachment/%3Cweb.51915e3367895d373449e5060%40news.povray.org%3E/mossonrock.zip

#declare earthTex = 
texture {
        pigment {
                granite scale 1
                turbulence 0.3 
                omega 0.7 
                lambda 2.8
                color_map {
                        [ 0.0 rgb Ga (<0.15,0.07,0.04>*0.01)*5]
                        [ 0.5 rgb Ga (<0.22,0.11,0.05>*0.01)*5]
                        [ 1.0 rgb Ga (<0.32,0.14,0.05>*0.01)*5]
                }                                     
        }                         
        finish {ambient 0 specular 0.01 roughness 0.1 diffuse albedo 0.5 brilliance 1} 
        normal {   
                average 
                normal_map {
                        [ 1.0 wrinkles 0.725 turbulence 0.325 omega 0.7 scale 0.012 ]
                        [ 1.0 granite 1.25 turbulence 0.325 omega 0.7 scale 0.0135 ]
                        [ 1.0 granite 0.8 turbulence 0.23 scale 0.015 ]
                }
        }
}     

#declare t1_ = 
texture {
        pigment {
                wrinkles      
                omega 0.675
                lambda 2.5 
                turbulence 0.375
                color_map {
                       [ 0.05 rgbf Gat (<0.150,0.225,0.0250,0.30>)]
                       [ 0.10 rgbf Gat (<0.030,0.020,0.0025,0.20>)]
                       [ 0.25 rgbf Gat (<0.030,0.020,0.0025,0.10>)]
                       [ 0.30 rgbf Gat (<0.150,0.225,0.0250,0.35>)]
                       [ 0.70 rgbf Gat (<0.185,0.275,0.0250,0.35>)]
                       [ 0.85 rgbf Gat (<0.200,0.300,0.0350,0.40>)]                                            
                       [ 1.00 rgbf Gat (<0.050,0.020,0.0035,0.10>)]                                            
                }          
                scale 0.065       
        }     
        normal {granite 0.07 scale 0.005}
        finish {ambient 0 specular 0.25 roughness 0.05 diffuse 0.8 brilliance 1.2 reflection {0.01,0.005 fresnel on} conserve_energy}
}          

#declare t2_ = 
texture {
        pigment {
                wrinkles      
                omega 0.675
                lambda 2.5 
                turbulence 0.375
                color_map {
                       [ 0.0 rgbf Gat (<0.05,0.02,0.0025,0.1>)]
                       [ 0.7 rgbf Gat (<0.03,0.02,0.0025,0.1>)]
                       [ 1.0 rgbf Gat (<0.03,0.01,0.0035,0.1>)]                                            
                }                                             
        }     
        finish {ambient 0 specular 0.04 roughness 0.01 diffuse 1.2 brilliance 0.8 reflection {0.01,0.005 fresnel on} conserve_energy}
}

#declare T1 = 
material {
        texture {
                gradient y
                turbulence 0.31*0.01
                texture_map {
                        [0.0 earthTex scale 0.16]
                        [0.2 earthTex scale 0.16]
                        [0.3 t1_ scale 0.16]
                        [0.8 t1_ scale 0.16]
                        [1.0 t2_ scale 0.16]        
                }             
                scale 4  
                translate <0,-0.8,0> 
        }   
        interior {
                ior 1.36              
                fade_power 1001     
                fade_distance 0.1      
                fade_color <0.1,0.5,0.1>
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 195) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  moss on rock  http://news.povray.org/povray.binaries.scene-files/attachment/%3Cweb.51915e3367895d373449e5060%40news.povray.org%3E/mossonrock.zip

#declare rockTexBase = 
texture {
        pigment {rgbt Gat (<0.025,0.0175,0.005,0.01>)}
        finish {
                specular 0.6 
                roughness 0.0075 
                diffuse 0.3 
                brilliance 5 
                reflection {0.025, 0.01 fresnel on metallic 0.4} 
                conserve_energy
        }
} 
texture {
        pigment {  
                bozo  
                omega 0.4
                lambda 2.0
                turbulence 0.25
                color_map {
                        [0.00   rgbt Ga (<0.5,0.42,0.30>)]
                        [0.30   rgbt Ga (<0.4,0.33,0.25>)]
                        [0.80   rgbt Gat (<0.5,0.42,0.33,0.1>)]
                        [0.82   rgbt 1]
                        [1.00   rgbt 1] 
                }
                scale 0.025
        }
        finish {
                specular 0.01 
                roughness 0.2 
                brilliance 1.2 
                diffuse 0.7
        }    
}  
texture {
        pigment {
                wrinkles
                triangle_wave    
                omega 0.8
                lambda 3
                turbulence 1
                color_map {
                        [0.00   rgbt Gat (<0.01,0.0075,0.000,0.1>)]
                        [0.20   rgbt Gat (<0.01,0.0075,0.000,0.8>)]
                        [0.40   rgbt Gat (<0.02,0.0100,0.001,0.1>)]
                        [0.70   rgbt Gat (<0.05,0.0350,0.021,0.7>)]
                        [0.98   rgbt Gat (<0.10,0.0750,0.010,1.0>)]
                        [1.00   rgbt 1]                       
                }                                 
                scale 0.5
        }
        finish {
                specular 0.01 
                roughness 0.2 
                brilliance 1.2 
                diffuse 0.5
        }    
        normal {granite 0.5 scale 0.05}
}


#declare rockTexLDirt = 
texture {rockTexBase}
texture {
        pigment {wrinkles
        triangle_wave    
        omega 0.8
        lambda 3
        turbulence 1
                color_map {
                        [0.0    rgbt Gat (<0.1,0.050,0.000,0.2>)]
                        [0.2    rgbt Gat (<0.1,0.050,0.000,0.8>)]
                        [0.4    rgbt Gat (<0.2,0.125,0.025,0.2>)]
                        [0.8    rgbt Gat (<0.2,0.125,0.025,1.0>)]
                        [0.8    rgbt 1]                       
                        [1.0    rgbt 1]                       
                }                                 
                scale 0.5
                rotate <20,15,10>
        }
        finish {brilliance 1.2 diffuse 0.45}    
        normal {granite 0.5 scale 0.05}
}          

#declare rockTexDirt = 
texture {rockTexBase}
texture {
        pigment {wrinkles
        triangle_wave    
        omega 0.8
        lambda 3
        turbulence 1
                color_map {
                        [0.00   rgbt Gat (<0.100,0.035,0.0000,0.2>)]
                        [0.20   rgbt Gat (<0.100,0.035,0.0000,0.6>)]
                        [0.75   rgbt Gat (<0.175,0.100,0.0125,0.2>)]
                        [0.99   rgbt Gat (<0.175,0.100,0.0125,1.0>)]
                        [0.99   rgbt 1]                       
                        [1.00   rgbt 1]                       
                }                                 
                scale 0.5
                rotate <20,15,10>
        }
        finish {brilliance 1.2 diffuse 0.45}    
        normal {granite 0.5 scale 0.05}
}

#declare rockTexVDirt = 
texture {rockTexBase}
texture {
        pigment {wrinkles
        triangle_wave    
        omega 0.8
        lambda 3
        turbulence 1
                color_map {
                        [0.00   rgbt Gat (<0.075,0.0100,0.00000,0.1>)]
                        [0.20   rgbt Gat (<0.075,0.0100,0.00000,0.3>)]
                        [0.75   rgbt Gat (<0.125,0.0255,0.00125,0.1>)]
                        [1.00   rgbt Gat (<0.125,0.0255,0.00125,0.5>)]
                }                                 
                scale 0.5
                rotate <20,15,10>
        }
        finish {brilliance 1.2 diffuse 0.45}    
        normal {granite 0.5 scale 0.05}
}

#declare rockTexSide =
texture {
        granite scale 3.5//gradient z    
        triangle_wave
        turbulence 0.125
        texture_map {
                [0.0    rockTexLDirt scale 0.25]
                [0.025  rockTexLDirt scale 0.25]
                [0.075  rockTexDirt  scale 0.25]
                [0.1    rockTexVDirt scale 0.25]
                [0.3    rockTexVDirt scale 0.25]
                [0.4    rockTexLDirt scale 0.25]
                [1.0    rockTexLDirt scale 0.25]
        }  
        scale 2
}

#declare rockTexTop = 
texture {
        granite scale 3.5//gradient y    
        triangle_wave
        turbulence 0.125
        texture_map {
                [0.0    rockTexLDirt scale 0.25]
                [0.025  rockTexLDirt scale 0.25]
                [0.075  rockTexDirt  scale 0.25]
                [0.1    rockTexVDirt scale 0.25]
                [1.0    rockTexVDirt scale 0.25]
        }  
        scale 2
        translate <0,-0.8,0>
}


#declare rockTex = 
texture { 
        granite scale 3.5//gradient z    
        triangle_wave
        turbulence 0.05
        texture_map {
                [0.0    rockTexSide]
                [0.075  rockTexSide]
                [0.1    rockTexTop]
                [1.0    rockTexTop]
        } 
        translate <0,0,-1.1> 
}        

#declare T1 = 
material {
        texture {rockTex}  
        interior {ior 1.5}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 196) /////////////////////////////////////////////////////////////////////////////////////

// pattern by Tekno Frannansa  Alienese  http://news.povray.org/povray.binaries.images/message/%3C4c95018f%40news.povray.org%3E/#%3C4c95018f%40news.povray.org%3E

#declare tLetter =
texture {
	pigment {rgb <144,114,58>/255}
	finish {
                ambient 0
                brilliance 20
                diffuse 0.9
                metallic
                specular 4
                roughness 0.004
                reflection {1 metallic}
	}
        normal {quilted bump_size -1 scale 1/11}
}

#declare tBoard =
texture {
	pigment {rgb 0.5}
	finish {
		diffuse albedo 0.21
		specular 0.2
		roughness 0.1
	}
        normal {wrinkles scale 0.01}
}

#declare AlienLetters = array [6];

// build it in boxes of 11x11, from 0,0 to 11,11 with 0-1 and 10-11 as space between letters
#declare AlienLetters [0] = union {box {<1,1>, <2,6,1>} box {0, <1,4,1> Shear_Trans (x-y,y+x,z) translate <1,6>} box {<5,9>, <6,10,1>} scale <1,1,11>/11};
#declare AlienLetters [1] = union {box {<9,1>, <10,6,1>} box {-x, <0,4,1> Shear_Trans (x+y,y-x,z) translate <10,6>} box {<5,9>, <6,10,1>} scale <1,1,11>/11};
#declare AlienLetters [2] = box {0,1 Shear_Trans (x-y,y+x,z) translate <4.5,5.5> scale <1,1,11>/11};
#declare AlienLetters [3] = union {box {<1,1>, <6,2,1>} box {0, <1,4,1> Shear_Trans (x-y,y+x,z) translate <5,2>} box {<9,5>, <10,6,1>} scale <1,1,11>/11};
#declare AlienLetters [4] = union {box {<9,5>, <10,6,1>} box {-x, <0,4,1> Shear_Trans (x+y,y-x,z) translate <10,6>} box {<5,9>, <6,10,1>} scale <1,1,11>/11};
#declare AlienLetters [5] = box {0, <1,8,1> Shear_Trans (x-y,y+x,z) translate <1,2> scale <1,1,11>/11};

#declare Alienese =
texture {
        // combine an on/off pattern for each of the cells making the characters
        // optimal version would test empty space first, then combinations of cells, then individual ones, but lazy approach is just test all using average and saturate that
        pigment_pattern {
                average
                pigment_map {
                        // toggle each one randomly, by using 2x frequency with each letter part, so every combination appears in the color map.
                        // could instead get a nice effect by having a list of every valid combo and doing one big color map on cells for that.
                        #local i = 0; 
                        #while (i < dimension_size (AlienLetters,1))
                                [1      cells 
                                        frequency pow (2,i) 
                                        pigment_map {
                                                [0.5    rgb 0]
                                                [0.5    object {AlienLetters [i] rgb 0, rgb 1} 
                                                        warp {repeat x} 
                                                        warp {repeat y} 
                                                        warp {repeat z} 
                                                ] 
                                        } 
                                ]
                                #local i = i+1; 
                        #end
                }
        }
        texture_map {
                [0.5/dimension_size (AlienLetters,1)    tBoard]
                [0.5/dimension_size (AlienLetters,1)    tLetter]
        }
}

#declare T1 = 
material {
        texture {Alienese scale 0.5}
        interior {ior 2}
        scale 0.25
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 197) /////////////////////////////////////////////////////////////////////////////////////

// pattern by Samuel T. Benge   Copying pigments with crackle  http://news.povray.org/povray.binaries.images/message/%3C488f9b5d%40news.povray.org%3E/#%3C488f9b5d%40news.povray.org%3E

#macro pcc (pgmt, Mod)

#local pgmt2 = function {pattern {pigment_pattern {pgmt}}}
#local pg1 = function {pattern {crackle form x}}
function {
        pgmt2 (
                (pow (pg1 (x+Mod,y,z),2)-pow (pg1 (x-Mod,y,z),2))/(Mod*1.2),
                (pow (pg1 (x,y+Mod,z),2)-pow (pg1 (x,y-Mod,z),2))/(Mod*1.2),
                (pow (pg1 (x,y,z+Mod),2)-pow (pg1 (x,y,z-Mod),2))/(Mod*1.2)
        )
}

#end

#declare T1 = 
material {
        texture {
                pigment {
                        pcc (   pigment {
                                        radial
                                        frequency 24
                                        rotate x*90
                                }
                                ,0.00001
                        )
                }
                normal {
                        pcc (   pigment {
                                        radial
                                        frequency 24
                                        rotate x*90
                                }
                                ,0.00001
                        )
                }
                finish {
                        diffuse 0.4 
                        ambient 0
                        specular 0.7 
                        roughness 0.003
                        phong 1 
                        phong_size 20
                        brilliance 7.3 
                        metallic 1
                        reflection {0, <1,0.9,0.4> metallic fresnel on}
                        conserve_energy
                }
        }
        interior {ior 0.8}
        scale 0.14
}


#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 198) /////////////////////////////////////////////////////////////////////////////////////

// Newt  Dissolution  http://images.povcomp.com/entries/extras/128/128_source.zip

#declare radio = 0;

// micronormals pattern
#declare micron1 = 
pigment {
        crackle turbulence 1
        color_map {
                [0.00   White*0.7]
                [0.01   White*0.7]
                [0.02   White]
                [1.00   White]
        }
        scale 5
}       

#declare micron2 = 
pigment {
        cells 
        turbulence 0.5
        color_map{
                [0.0    White*0.9]
                [1.0    White]
        }
        scale 0.01
}

#declare micronormalsp = 
pigment {
        average turbulence 0
        pigment_map {
                [0.0    micron2]
                [0.1    micron2 rotate 45*x]
                [0.2    micron2 rotate -45*x]
                [0.3    micron1]
                [0.4    micron2 rotate 45*y]
                [0.5    micron2 rotate -45*y]
                [0.6    micron2 rotate 90*z]
                [0.7    micron1 rotate 45]
                [0.8    micron2 rotate 45*z]
                [0.9    micron2 rotate 90*y]
                [1.0    micron2 rotate -45*z]
        }
        scale 0.1
}         

#declare micronormals = normal {pigment_pattern {micronormalsp} 0.4}
      
#declare T1 = 
material {
        texture {
                pigment {
                        slope y              
                        color_map{
                                [0.0    rgbf <0.7,0,0,1>]
                                [0.4    rgbf <0.7,0.63,0.6,1>]
                                [0.6    rgbf <0.7,0.63,0.6,1>]
                                [1.0    rgbf <0.7,0,0,1>]
                        }   
                }
                finish {
                        reflection {0.1, 0.3} 
                        conserve_energy 
                        ambient 0 
                        diffuse 0.6  
                        specular 0.6 
                        roughness 0.001
                } 
                normal {micronormals 0.5}                                       
        }     
        interior {
                ior 1.3
		media {
			scattering {
				2, rgb 2
				extinction 0
			}
			absorption 0
		}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 199) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  a little experiment

#declare envir = 0;
#declare matra = 50;

#declare T1 =
material {
        texture {
                pigment {
                        aoi
                        color_map {
                                [0.0 rgbt <0,0,0,1>]
                                [0.5 rgbt <0.8,0.9,1>]
                                [1.0 rgbt <0,0,0,1>]
                        }
                }
                finish {emission 0 diffuse 1}
        }
	interior {
		ior 1.35
		media {
                        emission <0.75,0.45,0.25>*4
                        density {
				average
				density_map {
					[1,     bozo
						poly_wave 
                                                scale 0.2
						color_map {
							[0.0 rgb 0]
							[0.4 rgb 0]
							[0.5 rgb <1,1,0>]
							[0.6 rgb 0]
							[1.0 rgb 0]				
						}
					]
					[1,     wrinkles 
                                                scale 0.2
						color_map {
							[0.0 rgb 0]
							[0.4 rgb 0]
							[0.5 rgb <1,0,0>]
							[0.6 rgb 0]
							[1.0 rgb 0]						
						}				
					]
				}				
			}
                }	
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 200) /////////////////////////////////////////////////////////////////////////////////////

// Selsek  Cybernetic Organism Caealis - Narcissism  http://images.povcomp.com/entries/extras/102/102_source.zip

#declare Met = <121,102,122>/255;
#declare Rus = <114,93,98>/255;
#declare Met1 = 2*<121,102,122>/255;

#declare Rust1 =
texture {
        pigment {
                slope y
                pigment_map {
                        [0,     granite color_map {[0, rgb Met][0.2, rgb Met][0.2, rgb Rus][0.7, rgb Rus*0.8][1, rgb Rus*0.5]} scale 0.5]
                        [0.5,   granite color_map {[0, rgb Met][0.5, rgb Met][0.5, rgb Rus][0.7, rgb Rus]    [1, rgb Rus*0.5]} scale 0.5]
                        [0.7,   rgb Met]
                        [1,     rgb Met]
                }
                turbulence 0
        }
        normal {wrinkles 0.1 scale 1}
        finish {specular 0 roughness 0.01 brilliance 3 diffuse 0.36}
        scale 0.01
}

#declare Rust2 =
texture {
        pigment {
                slope y
                pigment_map {
                        [0,     agate color_map {[0, rgb Met][0.5, rgb Met][0.6, rgb Rus][1, rgb Rus*0.75]} turbulence 1 octaves 3 omega 1]
                        [0.5,   agate color_map {[0, rgb Met][0.7, rgb Met][0.8, rgb Rus][1, rgb Rus*0.75]} turbulence 1 octaves 3 omega 1]
                        [0.7,   rgb Met]
                        [1,     rgb Met]
                }
                turbulence 0
        }
        normal {wrinkles 0.1 scale 1}
        finish {specular 0 roughness 0.01 brilliance 3 diffuse 0.36}
        scale 0.01
}

#declare Rust3 =
texture {
        pigment {
                slope y
                pigment_map {
                        [0,     agate color_map {[0, rgb Met1][0.5, rgb Met1][0.6, rgb Rus*2][1, rgb Rus]} turbulence 1 octaves 3 omega 1]
                        [0.3,   agate color_map {[0, rgb Met1][0.7, rgb Met1][0.8, rgb Rus*2][1, rgb Rus]} turbulence 1 octaves 3 omega 1]
                        [0.5,   rgb Met1]
                        [1,     rgb Met1]
                }
                turbulence 0
        }
        normal {wrinkles 0.1 scale 1}
        finish {specular 0 roughness 0.01 brilliance 3 diffuse 0.36}
        scale 0.01
}

#declare Rust4a =
texture {
        pigment {
                bozo
                color_map {
                        [0,     rgb <51,35,38>/255]
                        [0.25,  rgb <51,35,38>/255]
                        [0.35,  rgb <171,130,112>/255]
                        [0.39,  rgb 0.3]
                        [0.4,   rgb <103,104,109>/128]
                        [0.6,   rgb <110,114,130>/128]
                        [1,     rgb <108,112,140>/128]
                }
                turbulence 0.5 octaves 4 omega 0.7 lambda 5
        }
        normal {bozo 0.6 turbulence 1 octaves 4 omega 0.7 lambda 5}
        finish {diffuse 0.36}
}

#declare Rust4b =
texture {
        pigment {
                bozo
                color_map {
                        [0,     rgb <51,35,38>/255]
                        [0.25,  rgb <51,35,38>/255]
                        [0.35,  rgb <171,130,112>/255]
                        [0.39,  rgb 0.3]
                        [0.4,   rgb <1,1,0.9>]
                        [0.6,   rgb <1,1,0.8>]
                        [1,     rgb <1,1,0.8>]
                }
                turbulence 0.5 octaves 4 omega 0.7 lambda 5
        }
        normal {bozo 0.6 turbulence 1 octaves 4 omega 0.7 lambda 5}
        finish {diffuse 0.36}
        scale 0.6
}

#declare Rust =
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb  <0.89,0.51,0.28>]
            [0.4 rgb  <0.70,0.13,0.00>]
            [0.5 rgb  <0.69,0.41,0.08>]
            [0.6 rgb  <0.49,0.31,0.28>]
            [1.0 rgb  <0.89,0.51,0.28>]
        }
    }
    finish {ambient 0 diffuse 0.4*0.6}
    normal {granite}
} 

#declare Rusty_Iron = //pov include file
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb <0.42,0.2,0.2>]
            [0.5 rgb <0.5,0.5,0.02>]
            [0.6 rgb <0.6,0.2,0.20>]
            [0.6 rgb <0.3,0.2,0.20>]
        }
    }
    finish {ambient 0 diffuse 0.6*0.6}
    //normal {wrinkles 1 scale 1}
    normal {granite}
}

#declare Ls = <0.5,0.4,0.4>;
#declare Lt = 0.8;

#declare Sale = //sale=dirty
texture {
        pigment {
                bozo 
                color_map {
                        [0.0,   rgb Ls]
                        [0.3,   rgb Ls]
                        [0.4,   rgb Lt*0.8]
                        [1.0,   rgb Lt]
                }
                turbulence 1 
                octaves 3 
                omega 0.8 
                lambda 6
        }
}

#declare Lu = <0.5,0.4,0.4>*0.9;
#declare Lv = <0.6,0.7,0.8>;

#declare Sale2 =
texture {
        pigment {
                bozo 
                color_map {
                        [0.0,   rgb Lu]
                        [0.3,   rgb Lu]
                        [0.4,   rgb Lv*0.8]
                        [1.0,   rgb Lv]
                }
                turbulence 1 
                octaves 3 
                omega 0.8 
                lambda 8
        }
}

#declare Rouille_Tube = //rusty tubes
texture {
        slope y
        texture_map {
                [0.0,   Rusty_Iron scale 0.2]
                [0.3,   Rust scale 0.2]
                [0.4,   wrinkles 
                        texture_map {
                                [0, Rust ]
                                [1, Sale2]
                        }
                ]
                [0.5,   Sale2]
                [0.6,   wrinkles 
                        texture_map {
                                [0, Rust ]
                                [1, Sale2]
                        }
                ]
                [0.7,   Rust scale 0.2]
                [1.0,   Rusty_Iron scale 0.2]
        }
}

#declare T1 =
material {
        texture {Rouille_Tube}
        interior {ior 1.22}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 201) /////////////////////////////////////////////////////////////////////////////////////

// Christoph Gerber  After the Storm  http://images.povcomp.com/entries/extras/153/153_source.zip

#declare GlobeTex = 
texture {
        pigment {
                pigment_pattern {onion turbulence 1 lambda 4 scale 5}
                pigment_map {
                        [0.1    crackle 
                                form <1,0,0> 
                                turbulence 0.2 
                                color_map {
                                        [0      rgb <0.173,0.275,0.125>]
                                        [1      rgb <0.404,0.518,0.239>]
                                } 
                                scale 0.1
                        ]
                        [0.4    rgb <0.173,0.275,0.125>]
                        [0.6    rgb <0.173,0.275,0.125>]
                        [0.9    crackle 
                                form <1,0,0> 
                                turbulence 0.2 
                                color_map {
                                        [0      rgb <0.173,0.275,0.125>]
                                        [1      rgb <0.404,0.518,0.239>]
                                } 
                                scale 0.1
                        ]
                }
        }  
        normal {crackle 1 form <1,0,0> turbulence 0.2 scale 0.1}
        finish {
                ambient 0 diffuse 0.8 
                phong 0.2 phong_size 10 
                brilliance 2 
                irid {0.25 thickness 0.1 turbulence 0.5}
        }
        scale 0.5
}

#declare Spore1BulbTex = 
texture {
        pigment {
                crackle form <1,0,0>
                color_map {
                        [0.0    rgb <0.573,0.275-0.2,0.125-0.1>*2]
                        [0.5    rgb <0.404,0.518,0.239>]
                }
                scale 0.5
        }    
        normal {crackle 1 form <1,0,0> turbulence 0.2 scale 0.5}
        finish {ambient 0 diffuse 0.6 phong 0.2 phong_size 10 irid {0.25 thickness 0.1 turbulence 0.5}}
        scale 0.1
}

#declare T1 =
material {
        texture {
                slope y
                texture_map {
                        [0.0    Spore1BulbTex]
                        [0.5    GlobeTex]
                        [1.0    Spore1BulbTex]
                }
        }
        interior {ior 1.4}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 202) /////////////////////////////////////////////////////////////////////////////////////

// Newt  Sneakin Out  http://images.povcomp.com/entries/extras/62/sneakout.zip

#declare T1 = 
material {
        texture {
                pigment {
                        slope y             
                        color_map {
                                [0.25 rgb <0.7,0.7,0.7>]
                                [0.50 rgb <0.8,1.0,0.0>]
                                [0.75 rgb <0.7,0.7,0.7>]
                        }  
                        translate 0*y 
                }
                finish {   
                        ambient 0
                        brilliance 7
                        diffuse 0.4
                        metallic
                        specular 0.8
                        roughness 0.0125
                        reflection {0.3,0.9 fresnel on}
                        conserve_energy
                }
        }
        interior {ior 1.43}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 203) /////////////////////////////////////////////////////////////////////////////////////

// based on Anthony L. Bennett  The Orbs  http://news.povray.org/povray.text.scene-files/message/%3C3dbf4139%40news.povray.org%3E/#%3C3dbf4139%40news.povray.org%3E

#declare Reflective_Black =
texture {
        pigment {rgb 0.01}
        finish {
                specular 0.2 roughness 0.1
                reflection {0.1,1 fresnel on}
                irid {2 thickness 0.4}
        }
}

#declare BlurAmount = 1;
#declare BlurSamples = 10;

#declare Blurred_Reflective_Black =
texture {
        Reflective_Black 
        normal {
                average 
                normal_map {
                        [1 bumps  BlurAmount scale 0.001]
                        [1 bumps -BlurAmount scale 0.001]
                }
        }
        /*
        average 
        texture_map {
                #declare Ind = 0;
                #declare S = seed (7);
                //#while (Ind < BlurSamples)
                        [1      Reflective_Black normal {average normal_map {[1 bumps BlurAmount scale 0.001][1 bumps -BlurAmount scale 0.001]}}
                                /*normal {
                                        bumps BlurAmount
                                        translate <rand(S),rand(S),rand(S)>*10
                                        scale 1000
                                }*/
                        ]
                        //#declare Ind = Ind+1;
                //#end
        }*/
}

#declare T1 =
material {
        texture {Blurred_Reflective_Black}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 204) /////////////////////////////////////////////////////////////////////////////////////

// asfiXy  first post  http://news.povray.org/povray.binaries.images/thread/%3Cweb.427a2f64d6faa4a749223f780%40news.povray.org%3E/

#declare envir = 0;

#declare T1 =
material {
        texture {
                pigment {
                        cells
                        color_map {
                                [0 rgbf <1,0.625,1,1>]
                                [1 rgbf 1]
                        }
                }
                finish {
                        specular 0.25 metallic
                        roughness 0.05
                }
        }
        interior {
                ior 1.1
                media {
                        emission rgb 1.5
                        samples 100
                        density {
                                cells
                                density_map {
                                        [0.5 rgb <0.625,1,1>]
                                        [0.5 rgb 0]
                                }
                        }
                }
        }
        scale 0.05
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 205) /////////////////////////////////////////////////////////////////////////////////////

// Mike Sobers  [How to make] Stone texture  http://news.povray.org/povray.binaries.scene-files/attachment/%3Cweb.448053c14d93b2301009749b0%40news.povray.org%3E/stonetex3.pov.txt

#declare base =
texture {
        pigment {
                granite
                color_map {
                        [0.3  rgb <0.20,0.20,0.25>]
                        [0.8  rgb <0.15,0.15,0.20>]
                        [1.0  rgb <0.30,0.30,0.35>]
                }
                frequency 6
                rotate <0,10,0>
                turbulence <0.05,0.05,0.05>
                octaves 6
                omega 0.7
                lambda 2
        }
        finish {
                ambient 0
                diffuse 0.3*6
                roughness 1
        }    
        scale 2    
} 

#declare base2 =
texture {
        pigment {
                granite
                color_map {
                        [0.3  rgb <0.4,0.4,0.5>]
                        [0.8  rgb <0.3,0.3,0.4>]
                        [1.0  rgb <0.6,0.6,0.7>]
                }
                frequency 6
                rotate <0, 10, 0>
                turbulence <0.05,0.05,0.05>
                octaves 6
                omega 0.7
                lambda 2  
                scale 0.5
        }
        finish {
                ambient 0
                diffuse 0.3*6
                roughness 1
        }    
        scale 2    
}

#declare overlay = 
texture {
        pigment {
                wrinkles
                turbulence 0.5
                color_map {
                        [0.00 rgbt <0.10,0.10,0.12,1.0>] 
                        [0.20 rgbt <0.10,0.10,0.12,0.6>]
                        [0.45 rgbt <0.05,0.05,0.08,0.5>]
                        [0.65 rgbt <0.10,0.10,0.15,0.5>]  
                        [0.80 rgbt <0.15,0.15,0.20,0.6>]
                        [1.00 rgbt <0.15,0.15,0.20,1.0>]
                }
                frequency 1
        }
        scale 0.2*<3,4,2> 
        finish {
                ambient 0
                diffuse 0.3*6
                specular 0 
                roughness 1/400
        }       
} 

#declare line =
texture {
        pigment {
                wood
                turbulence 0.001 
                color_map {
                        [0, 0.02        color Black transmit 0.5 color Black transmit 1]
                        [0.02           color Clear]
                }
        }
        finish {
                ambient 0
                diffuse 0.3*6
                specular 0.1  
                roughness 0.01
        }    
}

#declare line2 =
texture {
        pigment {
                wood
                turbulence 0.05 
                color_map {
                        [0, 0.01    color Black transmit 0.2 color Black transmit 1]
                        [0.01, 0.5  color Clear color Clear] 
                        [0.5, 0.51  color Black transmit 0.2 color Black transmit 1]
                        [0.51       color Clear]
                } 
                scale 2
        }
        finish {
                ambient 0
                diffuse 0.3*6
                specular 0.1      
                roughness 0.0025
        }     
}
  
#declare overlay2 = 
texture {
        pigment {
                wrinkles
                turbulence 0.5
                color_map {
                        [0.00  rgbt <0.5,0.5,0.6,1>] 
                        [0.20  rgbt <0.5,0.5,0.6,0.8>]
                        [0.45  rgbt <0.1,0.1,0.16,0.6>]
                        [0.65  rgbt <0.2,0.2,0.3,0.6>]  
                        [0.80  rgbt <0.3,0.3,0.5,0.8>]
                        [1.00  rgbt <0.3,0.3,0.5,1>]
                }
                frequency 0.5
        }
        scale 0.15*<3,4,2> 
        finish {
                ambient 0
                diffuse 0.4*6
                specular 0.3
                roughness 0.01
        }        
}

#declare stone1 =                     
texture {base scale 0.5}   
texture {overlay}
texture {line scale <2,2,1.4> rotate <10,65,-20> normal {wrinkles 0.1 scale 0.005}} 
texture {line scale <1,2,1.4> rotate <10,65, 20> normal {wrinkles 0.1 scale 0.005}} 
texture {line scale <1,1,1.4> rotate <10,25,-20> normal {wrinkles 0.1 scale 0.005}}  

#declare T1 =
material {
        texture {stone1}
        interior {ior 1.6} 
        scale 0.3
        rotate 20
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 206) /////////////////////////////////////////////////////////////////////////////////////

// Bob Hughes  Gyroscope set in gimbel rings  http://news.povray.org/povray.binaries.animations/message/%3C405f9a48%241%40news.povray.org%3E/#%3C405f9a48%241%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb <5,5.5,6>*0.5}
                finish {
                        ambient 0 
                        diffuse 0.12 
                        specular 0.3 
                        roughness 0.01
                        metallic 
                        brilliance 8
                        reflection {0.1,0.3 metallic exponent 0.7}
                        conserve_energy
                }
        }
        interior {ior 1.1} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 207) /////////////////////////////////////////////////////////////////////////////////////

// nemesis  How to make semi-believable wood?  http://news.povray.org/povray.newusers/message/%3Cweb.445ceca6d8c1b17066cf3ced0%40news.povray.org%3E/#%3Cweb.445ceca6d8c1b17066cf3ced0%40news.povray.org%3E

#declare cm_wood =
color_map {
        [0.0 rgb 0.8*<0.8,0.70,0.4>]
        [0.4 rgb     <0.6,0.46,0.4>]
        [1.0 rgb 0.6*<0.6,0.46,0.4>]
}

#declare t_wood =
texture {
        pigment {wood color_map {cm_wood} turbulence 0.1}
        normal {wood 0.8 turbulence 0.10}
        finish {ambient 0 diffuse 0.5 phong 0.4 phong_size 46 brilliance 0.6}
} 

#declare T1 =
material {
        texture {t_wood}
        interior {ior 1.4} 
        scale 0.04
        rotate x*88
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 208) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  My First CGSphere  http://news.povray.org/povray.binaries.images/message/%3Cweb.487c960ee928bccebd1b3ad10%40news.povray.org%3E/#%3Cweb.487c960ee928bccebd1b3ad10%40news.povray.org%3E

#declare envir = 0;

//  amber glass with turquoise flecks

#declare N_Stucco = 
normal {
        average
        normal_map {
                [1      bumps   0.075 scale 0.75]
                [1      granite 0.235 scale 4]
                [0.5    granite 0.235 scale 1]
                [0.5    granite 0.235 scale 0.3]
                [0.5    granite 0.400 scale 0.1]
                [0.25   granite 0.650 scale 0.01]
        }
        scale 0.5
}

#declare P1 = 
pigment {
        bozo
        turbulence 0.5
        scale 0.1
        color_map {
                [0      rgb Ga (<189,112,40>/255*1.2) transmit 0.8]
                [1      rgb Ga (<143, 61, 5>/255*1.2) transmit 0.9]
        }
}

#declare T1 =
material {
        texture {
                pigment {
                        bozo
                        scale 0.25
                        turbulence 0.5
                        pigment_map {
                                [0.000 P1]
                                [0.675 P1]
                                [1.000 color Ga ((Turquoise+SeaGreen)/2*1.5)]
                        }
                }
                normal {N_Stucco scale 10}
                finish {
                        diffuse 1*1.8
                        specular 0.15
                        roughness 0.005
                        brilliance 4
                        reflection {0, 0.15 fresnel on}
                        conserve_energy
                }
        }
        texture {
                pigment {
                        bozo
                        scale 0.175
                        turbulence 0.45
                        pigment_map {
                                [0.0 P1]
                                [0.7 P1]
                                [1.0 color Ga (SeaGreen*0.75)]
                        }
                }
                normal {N_Stucco scale 20}
                finish {
                        diffuse 1*1.8
                        specular 0.2
                        roughness 0.005
                        reflection {0, 0.15 fresnel on}
                        conserve_energy
                }   
        }
        interior {ior 1.4}
        scale 0.03
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 209) /////////////////////////////////////////////////////////////////////////////////////

// based on Ben Scheele  Big blown blob  http://benscheele.com/rg/photonic.htm (please don't forget to explore whole wbsite http://benscheele.com !)

#declare envir = 0;

#declare T1 =
material {
	texture {
		pigment {rgbt <1,0.7,0,0.9*0.5>*2}
		finish {
                        specular 0.7 
                        roughness 0.001 
                        brilliance 0.004
                        phong 0.3 
                        diffuse 0.8*1.6 
                        ambient 0
                        reflection {0.2,0.75 falloff 0.8 metallic 0.3}
                        conserve_energy
		}
	}
	interior_texture {
		pigment {rgbt <0,1,1,0.5*0.5>*2}
		finish {
                        specular 0.7 
                        roughness 0.001 
                        brilliance 0.004
                        phong 0.3 
                        diffuse 0.8*0.32 
                        ambient 0
                        reflection {0.2,0.75 falloff 0.8 metallic 0.3}
                        conserve_energy
		}
	}
        interior {
                ior 1.5*3
                caustics 3
                fade_distance 1.5*0.2
                fade_power 20
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 210) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  MSOCP  http://news.povray.org/povray.binaries.images/message/%3Cweb.51e482779b3b97d05bfe13270%40news.povray.org%3E/#%3Cweb.51e482779b3b97d05bfe13270%40news.povray.org%3E

#declare snowTex = 
texture {
        pigment {rgb <1,1,1>}
        finish {
                diffuse albedo 0.7 
                specular albedo 0.2 
                roughness 0.0002 
                brilliance 0.9
                reflection {0.005, 0.05 fresnel on} 
                conserve_energy
                subsurface {translucency <2.95,3.0,3.1>*0.25}
        }
        normal {granite 0.2 scale 0.005}
}

// iceTex
#declare iceTex1 = 
texture {
        pigment {rgbf <1,1,1,0.3>}
        finish {
                diffuse albedo 0.1 
                specular albedo 0.1 
                roughness 0.05 
                brilliance 2.5
                reflection {0.005, 0.01 fresnel on} 
                conserve_energy
                subsurface {translucency <29.5,30,31>*0.25}
        }
        normal {granite 0.1 scale 0.01}
}

#declare iceTex2 = 
texture {
        pigment {rgbf <1,1,1,0.1>}
        finish {
                diffuse albedo 0.5 
                specular albedo 0.15 
                roughness 0.02 
                brilliance 1.2
                reflection {0.005, 0.03 fresnel on} 
                conserve_energy
                subsurface {translucency <29.5,30,31>*0.25}
        }
        normal {granite 0.15 scale 0.008}
}

#declare T1 =
material {
        texture {snowTex scale 0.33*0.25
                /*gradient x
                texture_map {
                        [0.00 iceTex1 scale 0.33] 
                        [0.45 iceTex2 scale 0.33] 
                        [0.75 snowTex scale 0.33] 
                } 
                scale 0.25 
                turbulence 0.275  
                translate <-1.7,0,0>*/  
        }
        interior {ior 1.31}//fade_distance 1 fade_power 1001 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 211) /////////////////////////////////////////////////////////////////////////////////////
                           
// Martial Rameaux  babeldrm  http://www.irtc.org/ftp/pub/stills/1999-12-31/babeldrm.zip

#declare ISOF = function {(y-cos (sqrt (x*x+z*z))+sin (exp (cos (x))*exp (cos (x))*cos (exp (cos (z)))))*0.15}

#declare T1 =
material {
        texture {
                pigment {
                        function {ISOF (x*20,y*20,z*20)}
                        color_map {
                                [0.0   rgb Ga (<0.914,0.347*1.5,0.071>*0.5)]
                                [1.0   rgb Ga (<0.914,0.347,0.071>)]
                        }    
                }
                normal {function {ISOF (x*20,y*20,z*20)}}
                finish {diffuse 0.45 specular 1 roughness 0.005 metallic reflection {0.2,1 metallic fresnel on} conserve_energy brilliance 2}   
        }
        interior {ior 0.47} 
        scale 1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 212) /////////////////////////////////////////////////////////////////////////////////////

// John Bradshaw  SEM texture  http://news.povray.org/povray.binaries.scene-files/thread/%3C3c748c98%40news.povray.org%3E/

#declare radio = 0;
#declare envir = 0;
#declare light = 0;

light_source {
        0
        color rgb 1
        translate vrotate (camloc*2,<0,-80,0>)
        parallel
        point_at lookat
        shadowless
}

light_source {
        0
        color rgb 1
        translate -camloc*2
        parallel
        point_at lookat
}

#declare Col = <0.95,1,0.95>;
#declare filter_amount = 0.4;

#declare SEM_T =
texture {
        pigment {
                aoi
                color_map {
                        [0.00 rgb Col*0.05 filter filter_amount]
                        [0.25 rgb Col*0.3  filter filter_amount]
                        [0.45 rgb Col*1    filter filter_amount]
                        [0.50 rgb Col*2    filter filter_amount]
                        [0.55 rgb Col*1    filter filter_amount]
                        [0.75 rgb Col*0.3  filter filter_amount]
                        [1.00 rgb Col*0.05 filter filter_amount]
                }
        }
        finish {diffuse 0.9 emission 0.8 brilliance 1}
        normal {
	        average 
	        normal_map {
                        [bumps 1.4*0.4*1.7   warp {turbulence <0.5,0,0.25>*2} scale 0.03]
                        [bumps 1*0.4*1.7     warp {turbulence <0.5,0,0.25>} scale 0.0003]
                        [granite 0.6*1.7*1.4 warp {turbulence <0.5,0,0.25>} scale 0.125]
                }
        }  
}

#declare SEM_M = media {scattering {3, 1 extinction 5}}

#declare T1 =
material {
        texture {SEM_T}
        interior {media {SEM_M}}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 213) /////////////////////////////////////////////////////////////////////////////////////

// Tom Melly  tmsummer  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3e36bf5b%40news.povray.org%3E/tmsummer.zip

#declare treeTex =
texture {
        pigment {
                dents 
                turbulence 0.25 
                pigment_map {
                        [0.03   rgb Ga (<0.25,0.25,0.15>)]
                        [0.06   bozo 
                                pigment_map {
                                        [0.0 rgb Ga (<0.45,0.40,0.20>)]
                                        [0.5 rgb Ga (<0.25,0.25,0.15>)]
                                        [1.0 rgb Ga (<0.45,0.45,0.20>)]
                                }
                        ]
                        [0.27   bozo 
                                pigment_map {
                                        [0.0 rgb Ga (<0.45,0.40,0.20>)]
                                        [0.5 rgb Ga (<0.25,0.25,0.15>)]
                                        [1.0 rgb Ga (<0.45,0.45,0.20>)]
                                }
                        ]
                        [0.30   granite 
                                scale 0.5 
                                pigment_map {
                                        [0 rgb Ga (<0.90,0.75,0.45>)]
                                        [1 rgb Ga (<0.85,0.85,0.35>)]
                                }
                        ]
                }
        }
        normal {
                dents 
                turbulence 0.25
                normal_map {
                        [0.04   average 
                                normal_map {
                                        [granite 20 scale 0.25]
                                        [agate 20 scale 0.5]
                                        [bozo 15 scale 0.25]
                                }
                        ]
                        [0.04   average 
                                normal_map {
                                        [granite 0.5 scale 0.25]
                                        [crackle 3 scale 0.03]
                                }
                        ]
                        [0.20   average 
                                normal_map {
                                        [granite 0.5 scale 0.25]
                                        [crackle 3 scale 0.03]
                                }
                        ]
                        [0.25   agate 15 scale 0.50]
                        [0.30   granite 0.2 scale 0.25]
                }
        }
        finish {
                diffuse 0.4
                specular 0.15
                roughness 0.1
        }
}

#declare T1 =
material {
        texture {treeTex}
        interior {ior 1.4} 
        scale 0.3
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 214) /////////////////////////////////////////////////////////////////////////////////////

// Phil Brewer  RC Prop Image, help on wood texture  http://news.povray.org/povray.binaries.images/message/%3Cweb.490a3dc02abe9258916e2c9f0%40news.povray.org%3E/#%3Cweb.490a3dc02abe9258916e2c9f0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb 1}
                finish {
                        ambient 0 
                        diffuse 0.3 
                        specular 0.8 
                        roughness 0.1 
                        brilliance 2 
                        metallic 
                        reflection {0.2,0.35 fresnel on}
                        conserve_energy
                }
                normal {waves 0.35 frequency 2 scale 0.004 turbulence 0.2}
        }
        interior {ior 0.8} 
        rotate x*-45
        scale 0.3
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 215) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  Example files for multipass rendering and compositing in SDL  http://news.povray.org/povray.binaries.scene-files/attachment/%3Cweb.4d7d9ac11aa788e894d713cc0%40news.povray.org%3E/multipassblobs.zip

#declare T1 =
material {
        texture {
                 pigment {
                        dents
                        color_map {
                                [0.00 srgb <202,185,127>/255]
                                [0.25 srgb <247,235,179>/255] 
                                [0.75 srgb <160,135,79 >/255]
                                [1.00 srgb <193,169,112>/255] 
                        } 
                        turbulence 0.3
                        lambda 2
                        octaves 3
                        omega 2
                        scale 3.5 
                }
                normal {agate -0.1 scale 3}
                finish {
                        reflection {0,0.65 fresnel on} 
                        conserve_energy
                        subsurface {translucency <0.41,0.41,0.51>}
                }
        }
        interior {ior 1.5 fade_power 2 fade_distance 3} 
        scale 0.15
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 216) /////////////////////////////////////////////////////////////////////////////////////

// based on Robert W. McGregor  (Making of) Pathways   http://www.povcomp.com/entries/137.php

#declare p_map_metal = pigment {image_map {jpeg "io" map_type 1}}

#declare p_map_metal2 =
pigment {
        wrinkles
        scale 3 
        turbulence 0.3 
        lambda 3
        pigment_map {
                [0.0 p_map_metal]
                [1.0 p_map_metal rotate 90*y translate 15]
        }
}  

#declare fnPig = function {pigment {p_map_metal2}}

#declare N_Hammered = 
normal {
        bozo
        normal_map {
                [0.00 dents 0.05 scale 0.01]
                [0.15 dents 0.05 scale 0.001]
                [0.30 dents 300  scale 0.0005]
                [0.45 dents 0.02 scale 0.01]
                [0.50 bumps 0.07 scale 0.01]
                [1.00 dents 0.05 scale 0.005]
        }
}

#declare T1 =
material {
        texture {
                pigment {p_map_metal2}
                normal {
                        average
                        normal_map {
                                [1.0    function {fnPig (x,y,z).gray} bump_size -1]
                                [0.2    granite 0.5 scale 0.2]
                                [0.2    granite 0.75 scale 0.12]
                                [1.0    N_Hammered bump_size 1]
                        }
                }
                finish {diffuse 0.4 specular 1 roughness 0.003 metallic reflection {0.4,1 metallic fresnel on} conserve_energy brilliance 8}
        }
        interior {ior 1.43} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 217) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  menace  http://www.irtc.org/ftp/pub/stills/2001-04-30/menace.zip

#declare fels = 
texture {
        pigment {
                crackle 
                turbulence 0.2
                pigment_map {
                        [0.08   granite 
                                scale 0.2 
                                color_map {
                                        [0.5    rgb <0.8,0.75,0.68>]
                                        [0.8    rgb <0.2,0.18,0.1>]
                                }
                        ]
                        [0.08   average 
                                pigment_map {
                                        [0.2    granite]
                                        [0.8    crackle  
                                                color_map {
                                                        [0.0 rgb <1,0.9,0.7>]
                                                        [0.7 rgb <0.8,0.7,0.5>]
                                                        [0.8 rgb <0.8,0.75,0.45>]
                                                        [0.9 rgb <0.35,0.3,0.25>]
                                                }
                                        ]
                                } 
                        ] 
                }
        }
        normal {
                average 
                normal_map {
                        [0.6    crackle 1.2 
                                turbulence 0.2
                                slope_map {
                                        [0.0  <0,0>]
                                        [0.08 <0,0>]
                                        [0.08 <0,1>]
                                        [0.7  <1,0>]
                                }
                        ]
                        [0.4    granite 0.9]
                }
        }
        finish {ambient 0 diffuse 0.6 specular 0.15}            
}

#declare T1 =
material {
        texture {fels}
        interior {ior 1.5} 
        scale 0.2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 218) /////////////////////////////////////////////////////////////////////////////////////

// nemesis  modern building - wip 1  http://news.povray.org/povray.binaries.images/message/%3Cweb.465f3326deed9c74773c9a3e0%40news.povray.org%3E/#%3Cweb.465f3326deed9c74773c9a3e0%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb <0,0.1,0>}
                normal {
                        average
                        normal_map {
                                [1.0    quilted 0.07*5 
                                        control0 0.06 
                                        control1 0.06 
                                        scale 2
                                ]
                                [0.5    cells 1
                                        scale 2 
                                        slope_map {
                                               [0.0, 0.5]
                                               [0.7, 0.5]
                                               [0.7, 0]
                                               [1.0, 0]
                                        }
                                ]
                       }
                }
                finish {
                       diffuse 0.005 
                       ambient 0 
                       brilliance 1.4 
                       specular 0.9 
                       roughness 0.01 
                       metallic 0.2 
                       reflection {0.02,3.96 metallic 0.2 fresnel on exponent 3 falloff 20}
                       conserve_energy
                }
        }
        interior {ior 1.5 fade_power 2 fade_distance 3}
        scale 0.0625
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 219) /////////////////////////////////////////////////////////////////////////////////////

// James Moore  Bulls Eye  http://news.povray.org/povray.binaries.scene-files/attachment/%3C406b4328%40news.povray.org%3E/dart.zip

#declare T1 =
material {
	texture {
		pigment {rgb <0.25,0.25,1>}
		finish {
 			ambient 0
		        brilliance 4
    		        diffuse 0.5
	    	        metallic
	    	        specular 0.8
		        roughness 0.0125
    		        reflection 0.5
	    	        irid {0.35 thickness 30 turbulence 0.1}
		}
		normal {
			average
			normal_map {
				[1 gradient y bump_size 0.3 poly_wave 0.3 frequency 5 scale 0.05 rotate x*30]
				[1 gradient y bump_size 0.3 poly_wave 0.3 frequency 5 scale 0.05 rotate x*-30]
			}
		}
	}
	interior {ior 1.4 dispersion 2.5}
        scale 2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 220) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  Grassy Julia  http://www.evilsuperbrain.com/gallery/finished/grassy.zip

#declare grassy_rock =
texture {
	pigment {
		granite
		turbulence 0.3
		poly_wave 2
		pigment_map {
			[0.0
				granite scale <2,1,2> rotate <20,20>
				color_map {
					[0	rgb 0.8*<0.8,0.9,1>]
					[1	rgb 0.4*<1,0.9,0.8>]
				}
			]
			[0.36
				granite scale <2,1,2> rotate <20,20>
				color_map {
					[0	rgb 1*<0.8,0.9,1>]
					[1	rgb 0.6*<1,0.9,0.8>]
				}
			]
			[0.81 rgb <0.3,0.1,0>]
		}
	}
	normal {
		pigment_pattern {granite turbulence 0.3 scale 10} 2 scale 0.1
		slope_map {
			[0.0    <0.5,0>]
			[0.6	<1,  1>]
			[0.6	<1, -1>]
			[1.0    <0,  0>]
		}
	}
	finish {
		specular 0.5 roughness 0.003 metallic 0.3
	}
	scale 0.3
}
texture {//wetness at bottom of rock
	pigment {
		wrinkles //gradient y
		translate -0.5
		scale 3
		turbulence 0.1 
		color_map {
			[0.20 rgbf <0.3,0.27,0.2,1>]
			[0.25 rgbf 1]
		}
	}
}

#declare T1 =
material {
        texture {grassy_rock}
        interior {ior 1.6} 
        scale 5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 221) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  ojglass  http://evilsuperbrain.com/gallery/finished/index.php?image=ojglass

#declare T1 =
material {
	texture {
		pigment {rgbf Gat (<1,0.75,0.5,1>)}
		finish {
			diffuse 0.7
			conserve_energy
			specular 1
			roughness 0.01
		}
	}
	interior {
		ior 1.33
		media {
			scattering {
				5, rgb Ga (<1,0.8,0.1>)
				eccentricity -0.3 // 1 = coke!!
				extinction 0
			}
			absorption 1
			aa_level 3
			aa_threshold 0.3
			density {//want a density that looks like the differential of turbulence.
				spotted
				turbulence 20
				density_map {
					[0  rgb 0]
					[1  rgb 9]
				}
			}
		}
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 222) /////////////////////////////////////////////////////////////////////////////////////

// Tim Nikias Wenclawiak  Too Lonely  http://www.irtc.org/ftp/pub/stills/2002-08-31/tnw_2lon.zip

#declare Random_Stream = seed (0);

#declare Base_Pigment_1 = pigment {crackle rotate y*-62 turbulence 0.6 lambda 3 omega 0.6 octaves 15 color_map {[0 rgb 0.1][1 rgb 0.4]}}
#declare Base_Pigment_2 = pigment {spiral1 5 rotate <90,53,23> turbulence 0.3 lambda 2 omega 0.7 octaves 3 color_map {[0 rgb 0.2*<1,0.9,0.9>][1 rgb 0.5*<1,0.8,0.8>]}}
#declare Base_Pigment   = pigment {wood rotate <32,76,42> turbulence 0.4 lambda 3.5 omega 0.7 octaves 6 pigment_map {[0 Base_Pigment_1][1 Base_Pigment_2]}}

#declare Base_Normal_GridHeight = 0.1;
#declare Base_Normal_YRotation  = 35;
#declare Base_Normal_1 = normal {gradient x Base_Normal_GridHeight slope_map{[0 <0,0>][0.4 <0,0>][0.425 <0,0.5>][0.5 <1,0>][0.575 <1,-0.5>][0.6 <0,0>][1 <0,0>]} rotate y*Base_Normal_YRotation }
#declare Base_Normal_2 = normal {gradient x Base_Normal_GridHeight slope_map{[0 <0,0>][0.4 <0,0>][0.425 <0,0.5>][0.5 <1,0>][0.575 <1,-0.5>][0.6 <0,0>][1 <0,0>]} rotate y*(37+Base_Normal_YRotation) }
#declare Base_Normal   = normal {average scale 0.2 normal_map {[1 Base_Normal_1][1 Base_Normal_2]}}

#declare Blurred_Finish =
finish {
        ambient 0 
        diffuse 0.8
        reflection {0.85*0.2,1*0.2}
        specular 0.2 
        roughness 0.002
        brilliance 5        
}

#declare T1 =
material {
        interior {ior 1.23}
        texture {
                average 
                texture_map {
                        #declare Sample_Count = 0; 
                        #while (Sample_Count < 1)
                                [1      pigment {Base_Pigment}
                                        normal {
                                                average 
                                                normal_map {
                                                        [1  bozo 0.15 scale 0.1 translate rand (Random_Stream)*10]
                                                        [1  Base_Normal]
                                                }
                                        }
                                        finish {Blurred_Finish}
                                ]
                                #declare Sample_Count = Sample_Count+1; 
                        #end
                }
        }
        rotate z*90
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 223) /////////////////////////////////////////////////////////////////////////////////////

// Charles Panke  Material definition  http://news.povray.org/moray.win/thread/%3C3bdde4f5@news.povray.org%3E/?ttop=337512&toff=450

#declare P_Chrome2 = rgb <0.39,0.41,0.43>/vlength (<0.39,0.41,0.43>)*sqrt(3*0.8);

#declare F_MetalD  =
finish {
        ambient 0
        brilliance 5
        diffuse 0.3
        metallic
        specular 1.2
        roughness 0.015
}

#declare T_Chrome_2D = 
texture {
        pigment {P_Chrome2} 
        finish {F_MetalD reflection {0.2*P_Chrome2,0.7*P_Chrome2 fresnel on} conserve_energy}
}

#declare T_Skin = 
texture {
        T_Chrome_2D 
        normal {granite -0.3 scale 0.1 cubic_wave}
}

#declare T1 =
material {
        texture {T_Skin}
        interior {ior 1.43} 
        scale 2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 224) /////////////////////////////////////////////////////////////////////////////////////

// Christoph Gerber  dshore  http://www.irtc.org/ftp/pub/stills/2003-12-31/dshore.zip

#declare gamm = 2.8/2.2;

#macro H_ (Color)
        <pow (Color.x,gamm),pow (Color.y,gamm),pow (Color.z,gamm)>
#end

#declare A = seed (123);
#declare m_r = 0.3;

#declare IridMetal = 
texture {
        pigment_pattern {
                wrinkles
                scale 0.1       
        }
        texture_map {
                [0      pigment {
                                wrinkles 
                                color_map {
                                        #declare n = 100;
                                        #declare i = 0;
                                        #while (i <= 1) 
                                                [i      rgb H_ (<1+ m_r*rand(A)-m_r*rand(A),0.93+m_r*rand(A)-m_r*rand(A),0.9+m_r*rand(A)-m_r*rand(A)>)]
                                                #declare i = i+1/n;
                                        #end
                                }
                                scale 0.05
                        }
                        finish {
                                ambient 0 
                                diffuse 0.4 
                                reflection {0.3, 0.6 metallic fresnel on} 
                                conserve_energy 
                                metallic 
                                specular 1 
                                roughness 0.007
                        }
                        normal {dents 0.35 scale 0.05}
                ]
                [1      pigment {
                                wrinkles 
                                color_map {
                                        #declare n = 100;
                                        #declare i = 0;
                                        #while (i <= 1)
                                                [i      rgb H_ (<0.915+m_r*rand(A)-m_r*rand(A),0.85+m_r*rand(A)-m_r*rand(A),0.85+m_r*rand(A)-m_r*rand(A)>)] 
                                                #declare i = i+1/n;
                                        #end 
                                }
                                scale 0.05
                        }
                        finish {
                                ambient 0 
                                diffuse 0.6 
                                reflection {0.2, 0.4 metallic fresnel on} 
                                conserve_energy 
                                metallic 
                                specular 0.7 
                                roughness 0.02
                        }
                        normal {dents 0.5 scale 0.01}
                ]
        }
}

#declare T1 =
material {
        texture {IridMetal}
        interior {ior 2} 
        scale 14
}  

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 225) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  sculpture  http://news.povray.org/povray.binaries.images/message/%3Cweb.525022ea6a835411b9f02fc70%40news.povray.org%3E/#%3Cweb.525022ea6a835411b9f02fc70%40news.povray.org%3E

#declare sculptBaseTex2 = 
texture {
        pigment {
                granite 
                color_map {
                        [0.0 rgb Ga (<0.01,0.01,0.015>)] 
                        [0.5 rgb Ga (<0.02,0.02,0.03>)]
                        [1.0 rgb Ga (<0.6,0.55,0.5>)]
                }
                scale 0.1
                turbulence 0.15
                omega 0.65
                lambda 2.3 
        }
        finish {
                specular albedo 0.1 
                roughness 0.05 
                diffuse albedo 0.8
                brilliance 2  
                reflection {0.01, 0.04 fresnel on} 
                conserve_energy 
        }
        normal {wrinkles 0.1 scale 0.001}
}

#declare T1 =
material {
        texture {sculptBaseTex2}
        interior {ior 1.6} 
        scale 0.7
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 226) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  sculpture  http://news.povray.org/povray.binaries.images/message/%3Cweb.525022ea6a835411b9f02fc70%40news.povray.org%3E/#%3Cweb.525022ea6a835411b9f02fc70%40news.povray.org%3E

#declare sculptDryTex =
texture {
        pigment {rgb Ga (<0.025,0.021,0.016>)}
        finish {
                specular albedo 0.1 
                roughness 0.9 
                diffuse albedo 0.7
                brilliance 3 
                metallic 0.5 
                reflection {0.008, 0.02 fresnel on} 
                conserve_energy
        }
        normal {wrinkles 0.1 scale 0.001}
}
texture {
        pigment {
                wrinkles 
                turbulence 1 
                omega 0.9 
                lambda 4 
                scale 0.2
                color_map {
                        [0.35 rgbt Gat (<0.01,0.19,0.16,1>)]
                        [1.00 rgbt Gat (<0.01,0.19,0.16,0.5>)]
                }
        }
}

#declare sculptWetTex =
texture {
        pigment {rgb Ga (<0.025,0.021,0.016>*0.2)}
        finish {
                specular 0.2 
                roughness 0.05 
                diffuse  0.05*2.3 
                brilliance 10
                metallic 1 
                reflection {0.01, 0.025 fresnel on} 
                conserve_energy 
        }
        normal {wrinkles 0.1 scale 0.001}
}
texture {
        pigment {
                wrinkles 
                turbulence 1 
                omega 0.9 
                lambda 4 
                scale 0.2
                color_map {
                        [0.35 rgbt Gat (<0.01,0.19,0.16,5>*0.2)]
                        [1.00 rgbt Gat (<0.01,0.19,0.16,2.5>*0.2)]
                }
        }
}

#declare st2 = 
texture {
        spherical  
        poly_wave 4
        texture_map {
                [0.000 sculptDryTex scale <0.166,0.5,0.5>]
                [0.025 sculptDryTex scale <0.166,0.5,0.5>]
                [0.100 sculptWetTex scale <0.166,0.5,0.5>]
        }
        scale <6,2,2>
        translate <0,-1.2,0>
}


#declare T1 = 
material {
        texture {st2}
        interior {ior 1.6}
        scale 0.7
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 227) /////////////////////////////////////////////////////////////////////////////////////

// The pigment author should be Ingo, but I cannot verify it - sorry for that!.

#declare F1 = function {pigment {cells}}
#declare F2 = function (x,y,z) {sin (x)*sin (y)}

#declare awfulseventies = 
pigment {
        function {F2 (x*pi,y*pi,z)*F1 (x,y,z).x}
        color_map {
                [0.10, rgb <0.6,0.5,0>]
                [0.15, rgb <0.3,0.7,0>]
                [0.25, rgb <0.5,0.7,0>]
                [0.50, rgb <0.2,0.6,1>]
                [0.80, rgb <0.1,0,0.1>]
        }
}

#declare N_Dented1 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.00 dents 1.5 scale 0.3]
                [0.5  dents 1 scale 0.15]
                [0.55 dents 0.125 scale 0.012]
                [0.6  dents 1.25 scale 0.15]
                [1.0  dents 1 scale 0.5]
        }             
}

#declare N_Dented2 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.0  dents 0.25 scale 1]
                [0.3  dents 1 scale 0.1]
                [0.35 dents 0.125 scale 0.01]
                [0.75 dents 1.25 scale 0.1]
                [1.0  dents 0.1 scale 1]
        }
        scale 0.75             
}

#declare N_Dented3 = 
normal {
        bumps 
        turbulence 0
        normal_map {
                [0.0 dents 0.125 scale 0.8]
                [0.3 dents 0.1 scale 0.12]
                [0.4 bumps 0.25 scale 0.1]
                [0.5 dents 0.125 scale 0.01]
                [1.0 dents 0.1 scale 1.2]
        }
        scale 0.5             
}

#declare N_Hammered = 
normal {   
        agate 
        turbulence 0.2
        normal_map {
                [0.00 N_Dented1]
                [0.33 N_Dented2]
                [0.66 N_Dented3]
                [1.00 N_Dented2]
        }
}
        
#declare T1 =
material {
        texture {
                pigment {awfulseventies}
                finish {diffuse albedo 1 brilliance 0.5} 
                normal {
                        average
                        normal_map {
                                [1.00 bumps   0.075 scale 0.75]
                                [1.00 granite 0.235 scale 4]
                                [0.50 granite 0.235 scale 1]
                                [0.50 granite 0.235 scale 0.3]
                                [0.50 granite 0.400 scale 0.1]
                                [0.25 granite 0.650 scale 0.01]
                        }
                        scale 0.3
                }
        }
        scale 0.25
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 228) /////////////////////////////////////////////////////////////////////////////////////

// James Moore  Some Strings Attached  http://www.irtc.org/ftp/pub/stills/2003-12-31/ssa.zip

#declare t_wood =
texture {
	pigment {
		wood 
                turbulence 0.1
		color_map {
			[0.00 rgb <0.75,0.6,0.3>*0.9]
			[0.50 rgb <0.75,0.6,0.3>]
			[0.95 rgb <0.75,0.6,0.3>*0.95]
			[1.00 rgb <0.75,0.6,0.3>*0.8]
		}
		scale <0.2, 0.1, 0.2>
		rotate y*85
		translate y*0.125
	}
	finish {specular 0.8 roughness 0.001 reflection {0, 0.2}}
	normal {dents scale <0.2, 0.005, 0.01> turbulence 0.2}
}

#declare t_dirt =
texture {
	pigment {
		wrinkles
		scale 0.2
		color_map {
			[0 rgb <0.7,0.55,0.2>*0.5]
			[1 rgb <0.7,0.55,0.2>*0.25]
		}
	}
	normal {wrinkles scale 0.2}
}

#declare t_table =
texture {
	wrinkles 
        turbulence 0.1
	scale <0.1, 0.05, 0.05>
	texture_map {
		[0.00 t_wood scale <10,20,20>]
		[0.80 t_wood scale <10,20,20>]
		[0.95 t_dirt]
		[1.00 t_dirt]
	}
}

#declare T1 = 
material {
        texture {t_table}
        interior {ior 1.4}
        rotate x*-45
        scale 1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 229) /////////////////////////////////////////////////////////////////////////////////////

// Thomas A. Fine  Fabric Texture Example  http://hea-www.harvard.edu/~fine/POV/fabric.html

#declare H_streaks = pigment {bozo color_map {[0.2 rgb <0.4,0.3,0.2>] [0.8 rgb <0.9,0.8,0.7>]} scale <10,0.1,1>}
#declare V_streaks = pigment {bozo color_map {[0.2 rgb <0.4,0.3,0.2>] [0.8 rgb <0.9,0.8,0.7>]} scale <0.1,10,1>}

#declare T1 = 
material {
        texture {
                pigment {checker pigment {H_streaks} pigment {V_streaks} scale 0.5}
                normal {bump_map {png "fabricbumps" bump_size 20}}
                finish {diffuse 0.8 specular 0.2}
                scale 0.1
        }
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 230) /////////////////////////////////////////////////////////////////////////////////////

// Bob Franke  Hostage  http://www.irtc.org/ftp/pub/stills/2001-04-30/hostage.zip

#declare Rusttex =
texture {
        pigment {
                bozo
                color_map {
                        [0.0 rgb <0.6,0.5,0.3>*0.8]
                        [0.5 rgb <0.4,0.2,0.2>*0.8]
                        [1.0 rgb <0.5,0.3,0.1>*0.8]
                }
                turbulence 0.25
                scale <0.25,0.5,0.25>*0.4
        }
        finish {phong 0.1 phong_size 10}
        normal {bumps 0.6 scale 0.01}
}

// bare old metal
#declare IRONX = 0.4;
#declare OldIron =
texture {
        pigment {
                bozo
                color_map {
                        [0.00 Gray50*IRONX]
                        [0.25 Gray80*IRONX]
                        [0.57 Gray60*IRONX]
                        [0.65 Gray40*IRONX]
                        [0.88 Gray80*IRONX]
                        [1.00 Gray50*IRONX]
                }
                turbulence 1
                scale 0.05
        }
        normal {dents 1 scale 0.1}
}

#declare Rusttex2 =
texture {
        pigment {
                bozo
                color_map {
                        [0.0 rgb <0.6,0.5,0.3>*0.8]
                        [0.5 rgb <0.4,0.2,0.2>*0.8]
                        [1.0 rgb <0.5,0.3,0.1>*0.8]
                }
                turbulence 0.25
                scale <0.25,0.5,0.25>*0.4
        }
        finish {phong 0.1 phong_size 10}
        normal {bumps 0.5 scale 0.01}
        finish {ambient 0}
}

#declare RustyIron =
texture {
        crackle
        texture_map {
                [0.00 OldIron]
                [0.05 OldIron]
                [0.35 Rusttex]
                [1.00 Rusttex]
        }
        scale 0.2
        turbulence 0.5     
}

#declare T1 = 
material {
        texture {
                wrinkles//gradient y       
                texture_map {
                        [0.00  Rusttex scale <0.2,1,0.2>]
                        [0.15  RustyIron scale <0.5,2,0.2> translate <1,0,0>]
                        [1.00  RustyIron]                
                }
        }
        scale 1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 231) /////////////////////////////////////////////////////////////////////////////////////

// Simon Adameit  media velvet/fur  http://news.povray.org/povray.text.scene-files/message/%3C3c73d149%40news.povray.org%3E/#%3C3c73d149%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgbf 1}
                normal {bumps 0.2 scale 0.01}
        }
        interior {
                ior -1
                media {
                        scattering {5, red 5*2 extinction 0 eccentricity 0.3}
                        absorption rgb 10*2
                        samples 5 intervals 1
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 232) /////////////////////////////////////////////////////////////////////////////////////

// Nico  Balls on a shelf  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3fc1b666%40news.povray.org%3E/balls.tgz.gz

#declare BlurAmount = 0.2;  
#declare BlurSamples = 40;  

#declare T1 =
material {
        texture {
                average 
                texture_map {
	                #declare Ind = 0; 
	                #declare S = seed (0); 
	                #while (Ind < BlurSamples) 
	                        [1      pigment {color rgb <0.88,0.87,0.86>*1.2} 
	                                finish {
	                                        specular 0.9
	                                        roughness 0.03*4
	                                        phong 1
	                                        brilliance 7.3
	                                        phong_size 80
	                                        metallic 0.5
	                                        //reflection {0.6, 1 metallic} // uncomment, if you own a supercomputer
                                                irid {0.5*(1.1-rand (S)) thickness 0.5*(1.1-rand (S)) turbulence 0.5*(1.1-rand (S))}
	                                } 
	                                normal {
	                                        bumps BlurAmount 
	                                        translate <rand (S),rand (S),rand (S)>*10 
	                                        scale 1000 
	                                } 
	                        ] 
	                        #declare Ind = Ind+1; 
	                #end 
                } 
        }
        interior {ior 1.53} 
} 

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 233) /////////////////////////////////////////////////////////////////////////////////////

// ts  Black Pearl (no, not a sailing ship!)  http://news.povray.org/povray.binaries.images/message/%3Cweb.43591aed45d6fa38cb16d5100%40news.povray.org%3E/#%3Cweb.43591aed45d6fa38cb16d5100%40news.povray.org%3E

#declare Rmin = 0.1;
#declare Rmax = 0.33;
#declare Trans = 0.5; 
#declare T_inner = White; 
#declare T_outer = Black;

#declare T1 = 
material {
        texture {
                pigment {rgb T_outer transmit Trans}
                finish {specular 1 roughness 0.0125 diffuse 1-Rmax reflection {Rmin,Rmax} conserve_energy}
        }
        texture {
                pigment {rgb T_inner} 
                finish {specular 1 metallic roughness 0.1 brilliance 25 irid {0.03 thickness 0.5 turbulence 0.5}}
                normal {dents 0.15 scale 0.15}
        }
        interior {ior 1.45}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 234) /////////////////////////////////////////////////////////////////////////////////////

// Jim Charter  grapes wip update  http://news.povray.org/povray.binaries.images/message/%3C3D07FE5E.8E7F4A0F%40aol.com%3E/#%3C3D07FE5E.8E7F4A0F%40aol.com%3E
// version with internal povray sslt instead of media plus transparent texture

#declare T1 = 
material {
        #declare Color= rgb <0.5,0.15,0.11>;
        texture {     
                //create veining
                pigment {
                        radial 
                        frequency 80*16 
                        turbulence 0.25
                        color_map {
                                [0.00 rgb Color*0.7]
                                [0.07 rgb Color*0.7]
                                [0.08 rgb Color*1.4]
                                [0.92 rgb Color*1.4]
                                [0.93 rgb Color*0.7]
                                [1.00 rgb Color*0.7]
                        }
                }
                finish {
                        specular 0.05
                        diffuse 0.7
                        roughness 0.02
                        reflection 0
                        subsurface {translucency 0.4}
                }
        }
        texture {     
                //create darkening toward the end of grape
                pigment {
                        gradient y 
                        scale 14
                        color_map {
                                [0  rgb <0.30,0.1,0.85>*Color transmit 0.1]
                                [1  rgb <0.30,0.2,0.65>*Color transmit 0.7]
                      }
                      scale 0.66/1.4
                }
                finish {     
                        specular 0.05
                        diffuse 0.7
                        roughness 0.02
                        reflection 0
                }
        }
        texture {     
                //bloom on skin of grape
                pigment {
                        dents 
                        scale 1.5 
                        rotate 10 
                        pigment_map {
                                [0    rgb Clear]
                                [0.10 rgb Clear]
                                [0.49 LightBlue transmit 0.97]
                                [0.51 LightBlue transmit 0.97]
                                [0.90 rgb Clear]
                                [1    rgb Clear]  
                        }  
                }
                finish {
                        specular 0.05
                        diffuse 0.7
                        roughness 0.2
                        reflection 0
                }
        }
        texture {     
                //bloom on skin of grape
                pigment {
                        dents 
                        
                        pigment_map {
                                [0    rgb Clear]
                                [0.10 rgb Clear]
                                [0.49 LightBlue transmit 0.97]
                                [0.51 LightBlue transmit 0.97]
                                [0.90 rgb Clear]
                                [1    rgb Clear]  
                        }  
                }
                finish {
                        specular 0.05
                        diffuse 0.7
                        roughness 0.2
                        reflection 0
                }
        }
        texture {  //bloom on skin
                pigment {
                        dents 
                        scale 0.5 
                        pigment_map {
                                [0   rgb Clear]
                                [0.1 rgb Clear]
                                [0.5 LightBlue transmit 0.99]
                                [0.9 rgb Clear]
                                [1   rgb Clear]  
                        }  
                }
                finish {
                        specular 0.05
                        diffuse 0.7
                        roughness 0.2
                        reflection 0
                }
        }
        scale 0.5
        interior {ior 1.35}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 235) /////////////////////////////////////////////////////////////////////////////////////

// Denjor  A program to create images of axes using pov  http://news.povray.org/povray.binaries.utilities/attachment/%3C353ECA19.29BDC200%40ssvec.org%3E/jewels.inc.txt

#declare BlackOpal =
texture {
        pigment {rgbt <0,0,0,0.2>}
        finish {
                phong 0.3    
                phong_size 80
                reflection 0.12
        }
}
texture {
        pigment {
                granite
                color_map {
                        [0.00 rgbt <0.000,0.000,0.000,0.988>]
                        [0.04 rgbt <0.000,0.000,0.000,0.929>]
                        [0.10 rgbt <0.467,1.000,0.498,0.486>]
                        [0.15 rgbt <0.000,0.000,0.000,0.937>]
                        [0.24 rgbt <0.000,0.000,0.000,0.918>]
                        [0.30 rgbt <0.451,0.824,1.000,0.478>]
                        [0.35 rgbt <0.000,0.000,0.000,0.929>]
                        [0.41 rgbt <0.000,0.000,0.000,0.929>]
                        [0.46 rgbt <1.000,0.447,0.882,0.486>]
                        [0.52 rgbt <0.000,0.000,0.000,0.918>]
                        [0.61 rgbt <0.000,0.000,0.000,0.949>]
                        [0.66 rgbt <0.957,1.000,0.431,0.486>]
                        [0.72 rgbt <0.000,0.000,0.000,0.937>]
                        [0.80 rgbt <0.000,0.000,0.000,0.949>]
                        [0.85 rgbt <0.463,0.588,1.000,0.486>]
                        [0.90 rgbt <0.000,0.000,0.000,0.937>]
                        [1.00 rgbt <0.000,0.000,0.000,0.988>]
                }
        }
        finish {
                emission 1
                phong 0.3    
                phong_size 80
                reflection 0.14
        }
        scale <3.0,3.0,3.0>
}
texture {
        pigment {
                bozo
                turbulence 0.38  omega 0.57  lambda 1.7
                color_map {
                        [0.00 rgbt <0.000,0.000,0.000,0.086>]
                        [0.44 rgbt <0.000,0.000,0.000,0.478>]
                        [1.00 rgbt <0.000,0.000,0.000,0.988>]
                }
        }
        finish {
                ambient 0
                phong 0.3    
                phong_size 41
                reflection 0.1
        }
}

#declare T1 = 
material {
        texture {BlackOpal}
        interior {ior 1.45}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 236) /////////////////////////////////////////////////////////////////////////////////////

// Paolo Gibellini  Peeling paint texture  http://news.povray.org/povray.binaries.images/message/%3C538f03b0%40news.povray.org%3E/#%3C538f03b0%40news.povray.org%3E

#declare t_stone =
texture {
	pigment {
         granite
         color_map {
            [0.0 rgb <0.67, 0.50, 0.32>]
            [1.0 rgb <0.94, 0.88, 0.79>]
         }
         turbulence 0.75
         ramp_wave
         scale  0.01
	}
}

#declare t_grunge_wall=	
texture {
        pigment {rgbt <0.8,0.8,1,1>}
}
texture {
    pigment {
        granite
        color_map {
            [0.0 rgbt <0.60, 0.60, 0.60, 0.005>]
            [0.4 rgbt <0.70, 0.70, 0.70, 0.007>]
            [0.5 rgbt <0.70, 0.70, 0.70, 1>]
            [0.6 rgbt <0.50, 0.50, 0.50, 1>]
            [1.0 rgbt <0.60, 0.60, 0.60, 1>]
		}
	}
	normal {granite 1.2}
}
texture {
    pigment {
        granite
        color_map {
            [0.0 rgbt <0.60, 0.55, 0.50, 0.005>]
            [0.4 rgbt <0.70, 0.60, 0.50, 0.007>]
            [0.5 rgbt <0.70, 0.65, 0.60, 1>]
            [0.6 rgbt <0.50, 0.45, 0.40, 1>]
            [1.0 rgbt <0.60, 0.55, 0.50, 1>]
		}
	}
	normal {granite 0.6}
	rotate 20*z
	scale 0.1
}

#declare t_grunge_moss=
texture {
	pigment {
		bumps
                color_map {
                        [0.00 rgbt <0.11, 0.29, 0.02, 0.31>]
                        [0.40 rgbt <0.13, 0.15, 0.00, 0.32>]
                        [0.45 rgbt <0.03, 0.20, 0.00, 0.32>]
                        [0.50 rgbt <0.11, 0.25, 0.00, 1.00>]
                        [0.60 rgbt <0.13, 0.19, 0.08, 0.80>]
                        [1.00 rgbt <0.11, 0.29, 0.02, 0.90>]
		}
		turbulence 1.5
	}
	normal {bumps 0.6+1.4 turbulence 1.5 scale 0.005}
        finish {specular 0.3 roughness 0.003}
	scale 0.04
}

#declare t_final =	
texture {t_stone}
texture {t_grunge_wall}
texture {t_grunge_moss}

#declare T1 =
material {
        texture {t_final}
        interior {ior 1.5}
        scale 5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 237) /////////////////////////////////////////////////////////////////////////////////////

// Denjor  A program to create images of axes using pov  http://news.povray.org/povray.binaries.utilities/attachment/%3C353ECA19.29BDC200%40ssvec.org%3E/jewels.inc.txt

#declare Malachite =
texture {
        pigment {
                leopard
                turbulence 0.46*0.5 octaves 7 omega 0.42 lambda 2.6
                color_map {
                        [0.00 rgb <0.157, 0.490, 0.404>]
                        [0.12 rgb <0.149, 0.490, 0.404>]
                        [0.16 rgb <0.267, 0.576, 0.506>]
                        [0.21 rgb <0.137, 0.490, 0.404>]
                        [0.27 rgb <0.071, 0.302, 0.243>]
                        [0.39 rgb <0.129, 0.490, 0.404>]
                        [0.44 rgb <0.063, 0.451, 0.357>]
                        [0.50 rgb <0.118, 0.490, 0.404>]
                        [0.58 rgb <0.063, 0.306, 0.263>]
                        [0.66 rgb <0.110, 0.490, 0.404>]
                        [0.73 rgb <0.278, 0.573, 0.482>*1.2]
                        [0.79 rgb <0.102, 0.294, 0.235>]
                        [0.85 rgb <0.098, 0.490, 0.404>]
                        [0.92 rgb <0.200, 0.537, 0.463>*1.2]
                        [1.00 rgb <0.106, 0.302, 0.263>]
                }
                frequency 2
                translate <-10,5,1>
        }
        finish {
                ambient 0
                diffuse 0.6
                brilliance 1.5
        }
}
texture {
        pigment {
                leopard
                turbulence 0.41*0.5 octaves 8 omega 0.28 lambda 1.2
                color_map {
                        [0.00 rgbf <0.996, 0.996, 0.996, 0.996>]
                        [0.15 rgbf <0.957, 0.957, 0.957, 0.957>]
                        [0.16 rgb  <0.063, 0.286, 0.263>]
                        [0.27 rgb  <0.078, 0.490, 0.404>]
                        [0.33 rgb  <0.220, 0.569, 0.482>*1.2]
                        [0.39 rgb  <0.227, 0.576, 0.467>*1.2]
                        [0.44 rgb  <0.063, 0.451, 0.298>]
                        [0.50 rgb  <0.067, 0.490, 0.404>]
                        [0.60 rgb  <0.063, 0.451, 0.298>]
                        [0.65 rgb  <0.047, 0.490, 0.443>]
                        [0.70 rgb  <0.220, 0.569, 0.482>*1.2]
                        [0.81 rgb  <0.102, 0.286, 0.196>]
                        [0.89 rgb  <0.047, 0.490, 0.404>]
                        [1.00 rgbf <0.149, 0.314, 0.267, 0.996>]
                }
        }
        finish {
                diffuse 0.6
                brilliance 1.5
        }
        translate <0,12,-50>
        rotate <90,87,39>
        scale <1.25, 1.25, 1.25>
}
texture {
        pigment {
                leopard
                turbulence 0.51*0.5 omega 0.34 lambda 2.8
                color_map {
                        [0.00 rgbf <0.996, 0.996, 0.996, 0.996>]
                        [0.30 rgbf <0.976, 0.976, 0.976, 0.976>]
                        [0.31 rgb  <0.239, 0.576, 0.478>*1.2]
                        [0.43 rgb  <0.110, 0.490, 0.404>]
                        [0.49 rgb  <0.063, 0.451, 0.329>]
                        [0.55 rgb  <0.086, 0.490, 0.404>]
                        [0.64 rgb  <0.063, 0.286, 0.263>]
                        [0.71 rgb  <0.078, 0.490, 0.404>]
                        [0.78 rgb  <0.247, 0.569, 0.482>*1.2]
                        [0.88 rgb  <0.102, 0.286, 0.208>]
                        [0.93 rgb  <0.067, 0.490, 0.404>]
                        [1.00 rgbf <0.204, 0.439, 0.380, 0.996>]
                }
                translate <5,10,-5>
        }
        finish {
                ambient 0
                diffuse 0.6
                brilliance 1.5
        }
        translate <-10,5,-16>
        scale <1.5,1.5,1.5>
}
texture {
        pigment {
                leopard
                turbulence 0.41*0.5 omega 0.34 lambda 3.2
                color_map {
                        [0.00 rgbf <0.996, 0.996, 0.996, 0.996>]
                        [0.15 rgbf <0.957, 0.957, 0.957, 0.957>]
                        [0.16 rgb  <0.086, 0.490, 0.404>]
                        [0.39 rgb  <0.227, 0.576, 0.467>*1.2]
                        [0.45 rgb  <0.063, 0.286, 0.263>]
                        [0.50 rgb  <0.067, 0.490, 0.404>]
                        [0.54 rgb  <0.063, 0.451, 0.318>]
                        [0.67 rgb  <0.227, 0.569, 0.482>*1.2]
                        [0.70 rgb  <0.063, 0.451, 0.310>]
                        [0.74 rgb  <0.059, 0.490, 0.404>]
                        [0.81 rgb  <0.102, 0.286, 0.196>]
                        [0.85 rgb  <0.227, 0.569, 0.482>*1.2]
                        [0.89 rgb  <0.059, 0.490, 0.404>]
                        [1.00 rgbf <0.459, 0.651, 0.600, 0.996>]
                }
                translate <0,-10,-5>
                rotate <10,0,0>
        }
        finish {
                ambient 0
                diffuse 0.6
                brilliance 1.5
        }
        translate <0,12,-50>
        rotate <30,-15,0>
}
texture {
        pigment {
                leopard
                turbulence 1.14*0.5 omega 0.34 lambda 3.2
                color_map {
                        [0.00 rgbf <0.996, 0.996, 0.996, 0.996>]
                        [0.18 rgbf <0.969, 0.969, 0.969, 0.969>]
                        [0.19 rgb  <0.063, 0.451, 0.329>]
                        [0.25 rgb  <0.220, 0.396, 0.376>]
                        [0.30 rgb  <0.098, 0.490, 0.404>]
                        [0.37 rgb  <0.220, 0.576, 0.459>*1.2]
                        [0.45 rgb  <0.102, 0.286, 0.188>]
                        [0.47 rgb  <0.078, 0.490, 0.404>]
                        [0.60 rgb  <0.227, 0.408, 0.388>]
                        [0.67 rgb  <0.078, 0.490, 0.404>]
                        [0.78 rgb  <0.247, 0.569, 0.482>*1.2]
                        [0.86 rgb  <0.067, 0.490, 0.404>]
                        [1.00 rgbf <0.157, 0.486, 0.439, 0.996>]
                }
                translate <20,20,-20>
                rotate <0,45,0>
        }
        finish {
                ambient 0
                diffuse 0.6
                brilliance 1.5
        }
        translate <5,10,15>
        scale <3,3,3>
}


#declare T1 = 
material {
        texture {Malachite}
        interior {ior 1.655}
        scale 0.13
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 238) /////////////////////////////////////////////////////////////////////////////////////

// Gleb  Stamp handle  Links are currently (2014.06.19) down (http://news.povray.org/povray.text.scene-files/thread/%3C3dfdda49%40news.povray.org%3E/)
// original post: http://news.povray.org/povray.binaries.images/thread/%3CXns92D495BA44991noonenowherecom%40204.213.191.226%3E/

#declare T_ObjTexture =
texture {
        pigment {rgbt Gat (<0.6364,0.2414,0.0241,0.98*0.5>*2)}
        finish {
                ambient 0
                diffuse 0.8
                brilliance 0.05*4
                phong 0.5     
                phong_size 80 
                reflection {
                        0.8*Ga (<0.5,1.2,0.0382>),Ga (<0.5,1.2,0.0382>)
                        metallic 0.5
                        fresnel on
                } 
                conserve_energy
                irid {       
                        0.25        
                        thickness 0.5
                        turbulence 0.3
                }
        }  
}

#declare T1 = 
material {
        texture {T_ObjTexture}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 239) /////////////////////////////////////////////////////////////////////////////////////

// Daniel Prust  Creationism 102  see http://news.povray.org/povray.binaries.images/message/%3C4027349a%40news.povray.org%3E/#%3C4027349a%40news.povray.org%3E

#declare T1 = 
material {
        texture {		
                pigment {rgbft <0.15,0.15,0.15,1,0.5>} 
		finish {
			specular 0.25
			reflection 0.25
		}
        }  
	interior {
		ior 1.5
		media {
			emission 1
			density {
				average
				density_map {
					[1,     bozo
						poly_wave
						color_map {
							[0.00 rgb <0, 0, 0> ]
							[0.48 rgb <0, 0, 0> ]
							[0.50 rgb <0, 20,20>]
							[0.52 rgb <0, 0, 0> ]
							[1.00 rgb <0, 0, 0> ]				
						}
						scale <0.6,0.8,0.6>
					]
					[1,     wrinkles
						color_map {
							[0.00 rgb <0, 0, 0> ]
							[0.48 rgb <0, 0, 0> ]
							[0.50 rgb <0, 20,0> ]
							[0.52 rgb <0, 0, 0> ]
							[1.00 rgb <0, 0, 0> ]						
						}
						scale <0.6,0.6,0.6>
						rotate 30*z				
					]
				}				
			}		
		}	
	}
        scale 0.25
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 240) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  "meta-superellipsoid" isosurface  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062008134%40news.povray.org%3E/meta.pov.txt

#declare st =
texture {
        pigment {rgb <0.83,0.82,0.87>*1.2}
        finish {
                diffuse 0.75 
                ambient 0 
                specular 0.9 
                roughness 0.03 
                phong 0.5 
                brilliance 8 
                phong_size 80  
                metallic 0.8 
                reflection {0.4,0.9 metallic}
        }
}

#declare T1 = 
material {
        texture {
                st 
                pigment {
                        average 
                        pigment_map {
                                [1,     bozo 
                                        color_map {
                                                [0, rgb 0]
                                                [1, color red 3]
                                        }
                                ]
                                [1,     bozo 
                                        rotate 30 
                                        color_map {
                                                [0, rgb 0]
                                                [1, color green 3]
                                        }
                                ]
                                [1,     bozo 
                                        rotate 60 
                                        color_map {
                                                [0, rgb 0]
                                                [1, color blue 3]
                                        }
                                ]
                        }
                }
        }
        interior {ior 1.32}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 241) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  "meta-superellipsoid" isosurface  http://news.povray.org/povray.binaries.scene-files/attachment/%3C1103_1062008134%40news.povray.org%3E/meta.pov.txt

#declare st =
texture {
        pigment {rgb <0.83,0.82,0.87>*1.2}
        finish {
                diffuse 0.75 
                ambient 0 
                specular 0.9 
                roughness 0.03 
                phong 0.5 
                brilliance 8 
                phong_size 80  
                metallic 0.8 
                reflection {0.4,0.9 metallic}
        }
}
 
#declare blb = function (x,y,z,aa,bb,cc,dd) {dd/(pow(x-aa,4)+pow(y-bb,4)+pow(z-cc,4)+0.001)}

#declare bc = 9;
#declare s = 0.001;
#declare r = 0.25;
#declare aa1 = 
array [bc][8] {
        {0, 0, 0,s,1,1,1,0.3}
        {r, r, r,s, 1,0.6,0.7,0.9}
        {r, r,-r,s, 1, 1,0.5,0.5}
        {r,-r, r,s,0.6, 1,0.5,0.7}
        {r,-r,-r,s,0.7, 1,0.5,0.6}
        {-r, r, r,s,0.7,0.8,0.5,0.6}
        {-r, r,-r,s, 1,0.6,0.5,0.6}
        {-r,-r, r,s, 1,0.5,0.5,0.8}
        {-r,-r,-r,s,0.5, 1,0.6,0.8}
}

#declare T1 = 
material {
        texture {
                st 
                pigment {
                        average 
                        pigment_map {
                                [1      function {
                                                #declare i = 0;
                                                #while (i < bc)
                                                        +blb (x,y,z,aa1 [i][0],aa1 [i][1],aa1 [i][2],aa1 [i][3])*aa1 [i][4]
                                                        #declare i = i+1;
                                                #end
                                        }
                                        color_map {
                                                [0, rgb 0]
                                                [1, red 4]
                                        }
                                ]
                                [1      function {
                                                #declare i = 0;
                                                #while (i < bc)
                                                        +blb (x,y,z,aa1 [i][0],aa1 [i][1],aa1 [i][2],aa1 [i][3])*aa1 [i][5]
                                                        #declare i = i+1;
                                                #end
                                        }
                                        color_map {
                                                [0, rgb 0]
                                                [1, green 4]
                                        }
                                ]
                                [1      function {
                                                #declare i = 0;
                                                #while (i < bc)
                                                        +blb (x,y,z,aa1 [i][0],aa1 [i][1],aa1 [i][2],aa1 [i][3])*aa1 [i][6]
                                                        #declare i = i+1;
                                                #end
                                        }
                                        color_map {
                                                [0, rgb 0]
                                                [1, blue 4]
                                        }
                                ]
                                [1      function {
                                                #declare i = 0;
                                                #while (i < bc)
                                                        +blb (x,y,z,aa1 [i][0],aa1 [i][1],aa1 [i][2],aa1 [i][3])*aa1 [i][7]
                                                        #declare i = i+1;
                                                #end
                                        }
                                        color_map {
                                                [0, rgbt 0]
                                                [1, transmit 4]
                                        }
                                ]
                        }
                }
        }
        interior {ior 1.32}
        scale 7
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 242) /////////////////////////////////////////////////////////////////////////////////////

// Tsutomo Higo  lpleocel  http://www.asahi-net.or.jp/~nj2t-hg/lpleocel.txt

#declare T1 = 
material {
        texture {
                pigment {
                        leopard
                        color_map {
                                [0      rgbt <1.5,1.8,0.5,0>]
                                [0.001  rgbt <0.7,1,0.9,0>]
                                [0.02   rgbt <0,0,0,0.8>]
                                [1      rgbt <0,18,3,1>]
                        }
                        turbulence 0.4
                        rotate z*-45
                }
                finish {diffuse 0.27}
        }
        interior {ior 1.32}
        scale 0.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 243) /////////////////////////////////////////////////////////////////////////////////////

// Tsutomo Higo  lpcrymtf  http://cyberbusts.main.jp/pov/pov97/lpcrymtf.txt

#declare radio = 0;
#declare envir = 0;

#declare Interior_ =
interior {
        fade_distance 2
        fade_power 3
        ior 1.45
        dispersion 0.01
        dispersion_samples 12
}

#declare T1 = 
material {       
        texture {
                pigment {rgbt <0.3,0.3,0.3,1>}
                finish {
                        ambient 0
                        diffuse 0.3
                        reflection 0.2
                        specular 1.8*0.3
                        phong 0.5
                        brilliance 1
                }
        }
        interior {Interior_}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 244) /////////////////////////////////////////////////////////////////////////////////////

// Zeger Knaepen  brick-texture (for Darren New)  http://news.povray.org/povray.text.scene-files/attachment/%3C4052875b%241%40news.povray.org%3E/bricks.pov.txt

#declare T1 = 
material {
	texture {
		#declare Bricksize = <8,3,4.5>;
		#declare Mortar = 0.5;
		brick
		texture {
			pigment {
				granite
				color_map {
					[0 rgb 0.5]
					[1 rgb 0.25]
				}
				scale 0.1
			}
			normal {
				average
				#declare Aantal = 10;
				#declare Blur = 0.0625*2;
				#declare Seed = seed (3541);
				normal_map {
					#while (Aantal > 0)
						[brick 20 brick_size Bricksize mortar Mortar translate Blur*(<rand(Seed),rand(Seed),rand(Seed)>-<rand(Seed),rand(Seed),rand(Seed)>)]
						#declare Aantal = Aantal-1;
					#end
					[granite -20 scale 0.5]
				}
			}
			finish {ambient 0 diffuse 0.75 specular 0}
		}
		texture {
			pigment {
				cells
				pigment_map {
					[0 
						granite
						color_map {
							[0 rgb <1,0.5,0.25>]
							[1 rgb <0.5,0.25,0.125>*1.5]
						}
						scale <10,0.2,0.2>
						warp {turbulence 1}
					]
					[1 
						granite
						color_map {
							[0 rgb <1,0.5,0.25>/4]
							[1 rgb <0.5,0.25,0.125>/3]
						}
						scale <5,0.5,0.5>
						warp {turbulence 1}
					]
				}
				warp {repeat y offset 1189*x*0.5}
				scale Bricksize
			}
			normal {
				average
				#declare Aantal = 50;
				#declare Blur = 0.5;
				#declare Seed = seed (3541);
				normal_map {
					#while (Aantal > 0)
						[brick 150 brick_size Bricksize mortar Mortar translate Blur*(<rand(Seed),rand(Seed),rand(Seed)>-<rand(Seed),rand(Seed),rand(Seed)>)]
						#declare Aantal = Aantal-1;
					#end
					[granite -50 scale 1]
				}
			}
			finish {ambient 0 diffuse 1 specular 0.75 roughness 0.02}
                }
		brick_size Bricksize
		mortar Mortar 
		scale 2 warp {turbulence 0.2} scale 0.5
	}
        interior {ior 1.5}
        scale 0.04
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 245) /////////////////////////////////////////////////////////////////////////////////////

// nemesis  Realistic bricks  http://news.povray.org/povray.binaries.images/message/%3Cweb.44582f18782f552a11c80c7b0%40news.povray.org%3E/#%3Cweb.44582f18782f552a11c80c7b0%40news.povray.org%3E

#declare n_brick_wall =
normal {
        brick
        normal {
                brick 
                normal {granite 0.3}, normal {gradient y} 
                bump_size 2.4
        },
        normal {
                average
                normal_map {
                        [1.1    granite bump_size -0.6 ramp_wave scale 0.32]
                        [0.9    bumps bump_size 0.7 turbulence 0.6 scale 0.62]
                        [1.4    quilted control0 0.2 control1 0.2 bump_size 4.8 scale <8,3,3.8> warp {repeat 3*y offset x*4}]
                }
        }
        mortar 0.2
        bump_size 2.4
}

#declare p0 = pigment {rgb 0.8}
#declare p1 =
pigment {
        bozo
        color_map {
                [0.00 rgb 1]
                [0.46 rgb <0.95,0.68,0.71>]
                [1.00 rgb 0.8*<0.94,0.64,0.59>]
        }
        turbulence 1.8 
        scale 6
}

#declare t_brick_wall =
texture {
        pigment {brick pigment {p0}, pigment {p1} mortar 0.34 turbulence 0.1}
        normal {n_brick_wall turbulence 0.071}
        finish {ambient 0 diffuse 0.34*1.3 specular 0.3 roughness 0.28}
        scale 0.05
}

#declare T1 = 
material {
        texture {t_brick_wall}        
        interior {ior 1.5}
        scale 1.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 246) /////////////////////////////////////////////////////////////////////////////////////

// Tim Attwood  procedural texture as a bump map?  http://news.povray.org/povray.general/message/%3C490f83ba%241%40news.povray.org%3E/#%3C490f83ba%241%40news.povray.org%3E

#declare N_WoodGrain12a = 
normal {
    bozo
    turbulence 0.04
    lambda 2.5
    omega 0.1
    octaves 7
    scale <0.5,0.05,0.05>
}

#declare N_WoodGrain12b = 
normal {
   wood
   turbulence <0.1, 0.04, 1>
   scale <0.15,0.5,1>
   rotate <2,0,0>
}

#declare N_WoodGrain18a = 
normal {
    wood
    turbulence 0.02
    octaves 4
    lambda 4
    scale 0.1
    rotate <2,0,0>
}

#declare T1 = 
material {
        texture {pigment {P_WoodGrain18A color_map {M_Wood18A}}}
        texture {pigment {P_WoodGrain12A color_map {M_Wood18B}}}
        texture {
                pigment {P_WoodGrain12B color_map {M_Wood18B}}
                normal {
                        average
                        normal_map {
                                [1  N_WoodGrain18a]
                                [1  N_WoodGrain12a]
                                [1  N_WoodGrain12b]
                        }
                }
                finish {phong 1}
        }
        interior {ior 1.4}
        rotate <90,0,90>
        scale 0.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 247) /////////////////////////////////////////////////////////////////////////////////////
 
// alphaQuad  My Chessboard  http://news.povray.org/povray.binaries.images/message/%3Cweb.48b2df8073b1f459bc412700%40news.povray.org%3E/#%3Cweb.48b2df8073b1f459bc412700%40news.povray.org%3E 

#declare PlankNormal =
normal {
        gradient x 2 
        slope_map {
                [0 <0,1>]
                [0.05 <1,0>]
                [0.95 <1,0>]
                [1 <0,-1>] 
        }
        scale 2
}

#declare T1 = 
material {
        texture {
                pigment {
                        wood 
                        color_map {
                                [0.4    rgb <0.9,0.7,0.4>]
                                [0.6    rgb <1,0.8,0.6>]
                        }
                        turbulence 0.5
                        scale <1,1,10>*0.5
                        //rotate y*20
                }
                normal {
                        average 
                        normal_map {
                                [1      PlankNormal]
                                [1      wood 0.5 
                                        slope_map {
                                                [0.0 <0,0>]
                                                [0.5 <0.5,1>]
                                                [1.0 <1,0>] 
                                        }
                                        turbulence 0.5 
                                        scale <1,1,10>*0.5
                                ]
                        }
                        //rotate y*20
                }
                finish {specular 0.5 reflection 0.2 diffuse 0.5} 
        }
        interior {ior 1.4}
        rotate <90,0,0>
        scale 0.125
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 248) /////////////////////////////////////////////////////////////////////////////////////

// Nico  Wood texture  http://news.povray.org/povray.text.scene-files/attachment/%3C3fd9e6f9%40news.povray.org%3E/us-ascii?ttop=371103&toff=200

#declare wood_grain = 
pigment {
        wrinkles
        warp {cylindrical orientation y dist_exp 1}
        warp {turbulence 1.25}
        scale <0.5,1,30> 
        warp {turbulence 0.25}
        scale <1,1,5> 
        warp {
                black_hole <0,0.5,0>, 1
                falloff 2
                strength 1.5
                repeat 7
                turbulence 2
                inverse
        }
}

#declare wood_normal = 
function {
        pigment {
                wrinkles
                warp {cylindrical orientation y dist_exp 1}
                warp {turbulence 1.25}
                scale <0.5,1,30> 
                warp {turbulence 0.25}
                scale <1,1,5> 
                color_map {
                        [0 rgb 0.0] 
                        [1 rgb 1.0]
                }
        }
}

#declare h = 1.2;

#macro GammaColor (Color,Gamma)

rgb <pow (Color.red,Gamma),pow (Color.green,Gamma),pow (Color.blue,Gamma)>

#end

#declare woodmap = 
color_map {
        [0.0 GammaColor (<0.949,0.792,0.514>,h)]
        [0.3 GammaColor (<0.855,0.651,0.376>,h)]
        [0.6 GammaColor (<0.831,0.596,0.275>,h)]
        [0.9 GammaColor (<0.620,0.447,0.204>,h)]
}

#declare t_wood = 
texture {
        pigment {wood_grain color_map {woodmap} ramp_wave}
        normal {function {wood_normal (x,y,z).x*0.5*2}}
        finish {specular 0.1}
}
 
#declare T1 = 
material {
        texture {t_wood}        
        interior {ior 1.4}
        scale 0.1
        rotate <90,0,90>
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 249) /////////////////////////////////////////////////////////////////////////////////////

// pattern by David El Tom  brain vs. image_map  http://news.povray.org/povray.binaries.images/message/%3C43d38789%40news.povray.org%3E/#%3C43d38789%40news.povray.org%3E
// wood texture by Nico (see mat248 for reference)

#macro Checker4Tex (PIG1,PIG2,PIG3,PIG4)

#local PIG12 =
texture {
        checker
        texture {PIG1 translate (+z+x) scale <0.5,1,0.5>}
        texture {PIG2 translate (-z+x) scale <0.5,1,0.5>}
        translate (z-x)
        scale <0.5,1,0.5>
}

#local PIG34 =
texture {
        checker
        texture {PIG4 translate (-z-x) scale <0.5,1,0.5>}
        texture {PIG3 translate (+z-x) scale <0.5,1,0.5>}
        translate z+x
        scale <0.5,1,0.5>

}
   
checker
texture {PIG34}
texture {PIG12}
translate -z*0.5 scale <2,1,2>

#end

#declare wood_grain = 
pigment {
        wrinkles
        warp {cylindrical orientation y dist_exp 1}
        warp {turbulence 1.25}
        scale <0.5,1,30> 
        warp {turbulence 0.25}
        scale <1,1,5> 
        warp {
                black_hole <0,0.5,0>, 1
                falloff 2
                strength 1.5
                repeat 7
                turbulence 2
                inverse
        }
}

#declare wood_normal = 
function {
        pigment {
                wrinkles
                warp {cylindrical orientation y dist_exp 1}
                warp {turbulence 1.25}
                scale <0.5,1,30> 
                warp {turbulence 0.25}
                scale <1,1,5> 
                color_map {
                        [0 rgb 0.0] 
                        [1 rgb 1.0]
                }
        }
}

#macro GammaColor (Color,Gamma)

rgb <pow (Color.red,Gamma),pow (Color.green,Gamma),pow (Color.blue,Gamma)>

#end

#declare h = 1.2;
#declare woodmap = 
color_map {
        [0.0 GammaColor (<0.949,0.792,0.514>,h)]
        [0.3 GammaColor (<0.855,0.651,0.376>,h)]
        [0.6 GammaColor (<0.831,0.596,0.275>,h)]
        [0.9 GammaColor (<0.620,0.447,0.204>,h)]
}

#declare t_wood1 = 
texture {
        pigment {wood_grain color_map {woodmap} ramp_wave}
        normal {function {wood_normal (x,y,z).x*0.5*2}}
        finish {specular 0.1}
        rotate y*90
}

#declare h = 1.1*2;
#declare woodmap = 
color_map {
        [0.0 GammaColor (<0.949,0.792,0.514>,h)]
        [0.3 GammaColor (<0.855,0.651,0.376>,h)]
        [0.6 GammaColor (<0.831,0.596,0.275>,h)]
        [0.9 GammaColor (<0.620,0.447,0.204>,h)]
}

#declare t_wood2 = 
texture {
        pigment {wood_grain color_map {woodmap} ramp_wave}
        normal {function {wood_normal (x,y,z).x*0.5*2}}
        finish {specular 0.1}
        rotate y*90
        translate 1
}

#declare h = 1.3*3;
#declare woodmap = 
color_map {
        [0.0 GammaColor (<0.949,0.792,0.514>,h)]
        [0.3 GammaColor (<0.855,0.651,0.376>,h)]
        [0.6 GammaColor (<0.831,0.596,0.275>,h)]
        [0.9 GammaColor (<0.620,0.447,0.204>,h)]
}

#declare t_wood3 = 
texture {
        pigment {wood_grain color_map {woodmap} ramp_wave}
        normal {function {wood_normal (x,y,z).x*0.5*2}}
        finish {specular 0.1}
        translate 2
}

#declare h = 1.4*0.5;
#declare woodmap = 
color_map {
        [0.0 GammaColor (<0.949,0.792,0.514>,h)]
        [0.3 GammaColor (<0.855,0.651,0.376>,h)]
        [0.6 GammaColor (<0.831,0.596,0.275>,h)]
        [0.9 GammaColor (<0.620,0.447,0.204>,h)]
}

#declare t_wood4 = 
texture {
        pigment {wood_grain color_map {woodmap} ramp_wave}
        normal {function {wood_normal (x,y,z).x*0.5*2}}
        finish {specular 0.1}
        translate 3
}

#declare T1 = 
material {
        texture {Checker4Tex (t_wood1,t_wood2,t_wood3,t_wood4)}        
        interior {ior 1.4}
        scale 0.25
        rotate <90,0,90>
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 250) /////////////////////////////////////////////////////////////////////////////////////

// Trevor G Quayle  Wood Floor Texture and Scene  http://news.povray.org/povray.text.scene-files/message/%3Cweb.45acdfaa3fb2bd2ec150d4c10%40news.povray.org%3E/#%3Cweb.45acdfaa3fb2bd2ec150d4c10%40news.povray.org%3E

#declare BM = "wood-31_b.jpg";  //bump map
#declare DM = "wood-31_d.jpg";  //diffuse map
#declare SM = "wood-31_r.jpg";  //specular/reflective map 

#declare Spec = 1;              //specular/reflective strength (again you can use arroway's info)
#declare DifMn = 0.1;             //Min diffuse value
#declare DifMx = 0.5;             //Max diffuse value

#macro SMap (Ref, Dif)

pigment {image_map {jpeg DM map_type 0 interpolate 2}}
normal {bump_map {jpeg BM map_type 0 interpolate 0} bump_size 2}
finish {
        ambient 0 
        diffuse Dif
        conserve_energy
        reflection {0, Ref fresnel on metallic 0}
        specular Ref 
        roughness 0.0005
}

#end

#macro DMap (Ref,Dif)  

image_pattern {jpeg SM map_type 0 interpolate 2}
texture_map {
        [0 SMap (0, Dif)]
        [1 SMap (Ref, Dif)]
}

#end

#declare T1 =
material {
        texture {
                image_pattern {jpeg BM map_type 0 interpolate 2}
                texture_map {
                        [0.4 DMap (Spec, DifMn)]
                        [0.9 DMap (Spec, DifMx)]
                }
                //rotate x*90
        }
        interior {ior 1.36}
        scale 20
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 251) /////////////////////////////////////////////////////////////////////////////////////

// Thomas A. Fine  Fake Wood Texture  http://hea-www.harvard.edu/~fine/POV/src/fakewood.pov

#declare deskwood_streaks =
pigment {
        bozo
        color_map {
                [0.0 rgb <0.25,0.2,0.1>]
                [0.4 rgb <0.50,0.4,0.2>]
                [0.5 rgb <0.68,0.6,0.45>]
                [1.0 rgb <0.68,0.6,0.45>]
        }
        scale <1,0.01,1>
}

#declare deskwood_background = pigment {rgb <0.8,0.7,0.6>}

#declare deskwood_turb =
texture {
        pigment {
	        wood
	        turbulence 0.05
	        translate 4*y
	        warp {repeat 8*y offset 0.0} 
                rotate 86*y
	        rotate 4*z
	        pigment_map {
	                [0.0 deskwood_streaks ]
	                [0.3 deskwood_streaks ]
	                [0.7 deskwood_background ]
	                [1.0 deskwood_background ]
	        }
        }
        finish {diffuse 0.8 specular 0.2}
}

#declare deskwood_random_streaks =
texture {
        pigment {
	        bozo
                color_map {
	                [0.0 rgbt <0.5,0.4,0.2,0.0>]
	                [0.3 rgbt <0.5,0.4,0.2,0.0>]
	                [0.4 rgbt <0.8,0.7,0.6,1.0>]
	                [1.0 rgbt <0.8,0.7,0.6,1.0>]
	        }
	        //scale <4,1,0.1>
                scale <1,1,0.02>
        }
        finish {diffuse 0.8 specular 0.2 }
}

#declare T1 =
material {
        texture {deskwood_turb translate <0,0,3>}
        texture {deskwood_random_streaks rotate 90*x}
        interior {ior 1.36}
        rotate <45,0,0>
        translate z*0.5
        scale 0.14
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 252) /////////////////////////////////////////////////////////////////////////////////////
 
// David El Tom  Veneer pattern  http://news.povray.org/povray.binaries.images/message/%3C469c80fd%40news.povray.org%3E/#%3C469c80fd%40news.povray.org%3E

#macro DE_CreateVeneerPigment (NAME_STRING, WOOD_PATTERN_PIGMENT, WOOD_COLOR_MAP, VENEER_THICKNESS, VENEER_START, DEVIATION_FROM_CENTER)
  // NAME_STRING: string containing the name of the pigment it will be referenced by (eg. "my_veneer_pig")
  // WOOD_PATTERN_PIGMENT: a black white pigment, which will be used as base for the veneer pattern
  // WOOD_COLOR_MAP: the color_map for the resulting pigement
  // VENEER_THICKNESS: thickness of the veneer (increase of radius with one turn) .... ~1-5
  // VENEER_START: minimal radius of the base material the veneer pattern is taken from ... try something around 150
  // DEVIATION_FROM_CENTER: move the wood pattern slightly of center (gives a more natural look) 

  // declare the names of the needed elements
  #local wood_pattern_fcn_name = concat(NAME_STRING,"_w_pattern_fcn");
  #local veneer_pattern_fcn_name = concat(NAME_STRING,"_v_pattern_fcn");

  // declare the wood pattern function based on the given pigment
  Parse_String(concat("#declare ",wood_pattern_fcn_name," ="))
  function {
    pigment {
      WOOD_PATTERN_PIGMENT
      translate x*DEVIATION_FROM_CENTER
    }
  }

  // declare the veneer pattern function based on the formely declared wood pattern function
  Parse_String(concat("#declare ",veneer_pattern_fcn_name," ="))
  function {
    Parse_String(wood_pattern_fcn_name)(VENEER_THICKNESS*(x+((y/VENEER_THICKNESS)-int(y/VENEER_THICKNESS)))*cos((x+((y/VENEER_THICKNESS)-int(y/VENEER_THICKNESS))))
      ,VENEER_THICKNESS*(x+((y/VENEER_THICKNESS)-int(y/VENEER_THICKNESS)))*sin((x+((y/VENEER_THICKNESS)-int(y/VENEER_THICKNESS))))
      ,z).gray 
  }

  // declare the pigment based on the veneer pattern function
  Parse_String(concat("#declare ",NAME_STRING," ="))
  pigment {
    function {
      Parse_String(veneer_pattern_fcn_name)((x+VENEER_START)/(2*pi),y,z)
    }
    color_map {
      WOOD_COLOR_MAP
    }
    rotate x*90
  }
  
#end

#declare wood_cell_strc=
pigment {
        crackle 
        form <1,0,0>
        color_map {
                [0.0 rgb 0.0]
                [0.5 rgb 1.0]
                [1.0 rgb 1.0]
        }
        scale <0.08,0.08,10>*0.5
}

#declare wood_ring_strc =
pigment {
        wood
        color_map {
                [0.0 rgb 0.0]
                [1.0 rgb 1.0]
        }
        ramp_wave
        scale <5,5,3>
        warp {
                turbulence <1,1,3>
                octaves 5
                lambda 1.3
                omega 0.2
        }
        scale <0.2,0.2,1/3>
        scale 0.1
        warp {
                turbulence <1,1,0>*0.2
                octaves 5
                lambda 1.6
                omega 0.1
        }
        scale 10  
}

#declare wood_pattern =
pigment {
        pigment_pattern {wood_cell_strc}
        pigment_map {
                [0 rgb 0]
                [1 wood_ring_strc]
        }
}

#declare my_color_map =
color_map {
        [0.000000 rgb <0.840000, 0.658397, 0.372235>]
        [0.121123 rgb <0.884706, 0.776257, 0.463119>]
        [0.824225 rgb <0.929412, 0.894118, 0.554002>]
        [0.824225 rgb <0.929412, 0.894118, 0.554002>]
        [0.909897 rgb <0.884706, 0.776257, 0.463119>]
        [1.000000 rgb <0.840000, 0.658397, 0.372235>]
}

DE_CreateVeneerPigment ("veneer_pig", wood_pattern, my_color_map, 1, 150, 10)

#declare wood_normal = 
function {
        pigment {
                veneer_pig
                color_map {
                        [0 rgb 1] 
                        [1 rgb 0]
                }
        }
}

#declare T1 =
material {
        texture {
                pigment {veneer_pig}
                normal {function {wood_normal (x,y,z).x*-0.5}}
                finish {ambient 0 diffuse 0.7 specular 0.2}
                scale 0.08
        }
        interior {ior 1.36}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 253) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  icemine  http://www.irtc.org/ftp/pub/stills/2002-04-30/icemine.zip

#macro m_CellProbStart (nSeed,vScale)
	
#declare fCellProbIndex = 0;
#declare vCellProbScale = vScale;
#declare nCellProbSeed = nSeed;
cells
translate nCellProbSeed
scale vCellProbScale
	
#end

#macro m_CellProb (fProb, _Item)
	
[fCellProbIndex    _Item scale 1/vCellProbScale translate -nCellProbSeed]
#if ( fProb = -1 )
	//make sure no other items go after this one.
	#declare fCellProbIndex = 1;
#else
	//step on to end of this item.
	#declare fCellProbIndex = fCellProbIndex + fProb;
#end

[fCellProbIndex    _Item scale 1/vCellProbScale translate -nCellProbSeed]

#if ( fCellProbIndex > 1.01 )
	#warning "Probabilities add up to more than 1"
#end

#end

#declare TEXT_ALIGN_LEFT	= 0;
#declare TEXT_ALIGN_BOTTOM	= 0;
#declare TEXT_ALIGN_RIGHT	= 1;
#declare TEXT_ALIGN_TOP		= 1;
#declare TEXT_ALIGN_CENTRE	= 2; //use for either axis
#declare TEXT_ALIGN_SCALE	= 3;

#macro m_TextBlock (szFont, szText, vfScale, vOffset, eAlignX, eAlignY)

#local vScale = vfScale*<1,1,1>; //deal with vfScale possibly being a float.

//count newlines
#local nStrLen = strlen(szText);
#local nLinesNum = 0;
#local nStrPos = 0;
#while ( nStrPos < nStrLen )
	#if (strcmp (substr (szText,nStrPos+1,1),"\n") = 0 )
		#local nLinesNum = nLinesNum+1;
	#end
	#local nStrPos = nStrPos+1;
#end //while

#if (strcmp (substr (szText,nStrLen,1),"\n") != 0)
	//not newline terminated, need an extra line.
	#local nLinesNum = nLinesNum + 1;
#end

#local oText =
#if (nLinesNum > 1)
	merge {
	        #else
	object {
#end
        #local nLastNewLine = 0;
        #local nLine = 0;
        #while ( nLine < nLinesNum )		
        	#local nStrPos = nLastNewLine;
        	#while ( nStrPos < nStrLen & strcmp(substr(szText,min(nStrPos+1,nStrLen),1),"\n") != 0 )
        		#local nStrPos = nStrPos + 1;
        	#end //while
        	#local oLine = text {ttf "cyrvetic.ttf"/*szFont*/ substr(szText,nLastNewLine+1,nStrPos-nLastNewLine) 1, 0 scale vScale*(x+y) + z }
        	#local nLastNewLine = nStrPos + 1;
        	object {
        		oLine
        		#switch ( eAlignX )
        			#case (TEXT_ALIGN_LEFT)
        				Align_Trans(oLine, -x, 0)
        			#break
        			#case (TEXT_ALIGN_RIGHT)
        				Align_Trans(oLine, x, 1)
        			#break
        			#case (TEXT_ALIGN_SCALE)
        				//scale by 1/bounding box, then centre
        				Align_Trans(oLine, -x, 0)
        				scale <1/(max_extent(oLine).x - min_extent(oLine).x),1,1>
        			#break
        			#case (TEXT_ALIGN_CENTRE)
        				Center_Trans(oLine, x)
        				translate x/2 //move to middle of cube
        			#break
        		#end
        		translate -y*(nLine+1)*vScale.y
        	}
        	#local nLine = nLine + 1;
        #end//while
        #local fHeight = nLinesNum*vScale.y;
        translate fHeight*y
}
	
object {
	oText
	//the bounding box on the text is wrong, so do vertical alignment based on computed height
	#switch (eAlignY)
		#case (TEXT_ALIGN_BOTTOM)
			//do nothing, already aligned
		#break
		#case (TEXT_ALIGN_TOP)
			translate y*(1-fHeight)
		#break
		#case (TEXT_ALIGN_CENTRE)
			translate y*(1-fHeight)/2
		#break
		#case (TEXT_ALIGN_SCALE)
			//scale by 1/bounding box, and keep within unit cube
			scale <1,1/fHeight,1>
		#break
	#end
	clipped_by {box {0, 1}}
	translate vOffset
}

#end

#macro m_ApplyDetails( oBaseObj, fObjectBoundingRad, aoDetails, nDetailArraySize, nDetailsToApply, nDetailSeed, nPosSeed )

union {
	object {oBaseObj}
	#local rsDetail = seed(nDetailSeed);
	#local rsPos = seed(nPosSeed);
	//scatter loop. we may want to use regularity here		
	#local nObj = 0;
	#while (nObj < nDetailsToApply)
		//choose/compute position of detail
		#local vPos = <rand(rsPos),rand(rsPos),rand(rsPos)>;
		//sphere distribution
		#local vPos = vPos*<2,2,0> - <0,1,0>;
		#local vPos = pi*<vPos.x,select(vPos.y,-pow(vPos.y,2)/2,pow(vPos.y,2)/2),0>;
		#local vPos = <cos(vPos.x)*cos(vPos.y),sin(vPos.y),sin(vPos.x)*cos(vPos.y)>;
		//project to object
		#local vNorm = <0,0,0>;
		#local vPos = trace( oBaseObj, vPos*fObjectBoundingRad, -vPos, vNorm );
		#if (vNorm.x != 0 | vNorm.y != 0 | vNorm.z != 0)
			//select detail to apply
			#local nDetail = (nDetailArraySize - .001) * rand(rsDetail);
			//apply it
			object {
				aoDetails[nDetail]
				//rotate to point out of surface, keeping it facing up.
				#if ( vNorm.x != 0 )
					Reorient_Trans(z, <vNorm.x,0,vNorm.z>)
				#else
					#if ( vNorm.z < 0 )
						rotate 180*y
					#end
				#end
				Reorient_Trans(<vNorm.x,0,vNorm.z>, vNorm)
				translate vPos
			}
		#end
		#local nObj = nObj + 1; //only step on if obj created.
	#end //while ( nObj )
} //union

#end

#macro m_pCubeMap (_ItemInNegZ, vOffset, vAxisMask)

#local pXZ =
pigment {
        slope {x }
        pigment_map {
                [0.25   #if (vdot (vAxisMask,x) != 0)
                                _ItemInNegZ rotate 90*y translate vOffset*1
                        #else
                                rgbt 1
                        #end
                ] 
                [0.25   #if (vdot (vAxisMask,z) != 0)
                                _ItemInNegZ translate vOffset*1
                        #else
                                rgbt 1
                        #end
                ] 
                [0.75   #if (vdot (vAxisMask,z) != 0)
                                _ItemInNegZ rotate 180*y translate vOffset*1
                        #else
                                rgbt 1
                        #end
                ]
                [0.75   #if (vdot (vAxisMask,x) != 0)
                                _ItemInNegZ rotate -90*y translate vOffset*1
                        #else
                                rgbt 1
                        #end
                ]
        } //map
} //pigment

slope {y}
pigment_map {
        [0.25   #if (vdot (vAxisMask,y) != 0)
                        _ItemInNegZ rotate -90*x translate vOffset*1
                #else
                        rgbt 1
                #end
        ] 
        [0.25   pXZ] 
        [0.75   pXZ]
        [0.75   #if (vdot (vAxisMask,y) != 0)
                        _ItemInNegZ rotate 90*x translate vOffset*1
                #else
                        rgbt 1
                #end
        ]
}

#end

//standard textures (useful to keep them here to save clutter in the main source file)
#declare pRedPaint =
pigment {rgb <1,0.08,0.03>}

#declare pBluePaint =
pigment {rgb <0.02,0.1,0.6>}
	
#declare pBlackPaint =
pigment {rgb 0.1}
	
#declare pYellowPaint =
pigment {rgb <1,0.9,0.03>}
	
#declare pWhitePaint =
pigment {rgb <0.98,0.97,0.93>}
	
#declare pStripesBY =
pigment {
	gradient x+y
	scale 2
	pigment_map {
                [0.5 pBlackPaint] 
                [0.5 pYellowPaint] 
        }
}

#declare pLoudStuff =
pigment {
	bozo
	turbulence 4
	scale 10
	sine_wave
	color_map {
		[0	rgb <1,1,0>]
		[0.5	rgb <1,0,0>]
		[1	rgb <0,0,0>]
	}
}

#declare pRockTwist =
pigment {
	bozo
	turbulence 4
	scale 10
	sine_wave
	color_map {
		[0	rgb 0.4]
		[1	rgb 0.2]
	}
}

#declare tBoltGun =
texture {
	pigment {
		spotted
		scale 0.04
		color_map {
			[0	rgb 0.1]
			[1	rgb 0.3]
		}
	}
	finish {
		specular 1.0
		roughness 0.1
		reflection 0.2
	}
	normal {
		spotted 1
		scale 0.04
	}
}

#declare tChainMetal =
texture {
	pigment {
		spotted
		scale 0.04
		color_map {
			[0	rgb 0.2]
			[1	rgb 0.3]
		}
	}
	finish {
		specular 1.0
		roughness 0.1
		reflection 0.5
	}
	normal {
		spotted 0.1
		scale 0.02
	}
}

#declare tMithrilSilver =
texture {
	pigment {
		spotted
		scale 0.04
		color_map {
			[0	rgb 0.5]
			[1	rgb 0.7]
		}
	}
	finish {
		specular 1.0
		roughness 0.1
		reflection 0.4
	}
	normal {
		spotted 0.4
		scale 0.04
	}
}

#declare nPanels =
normal {
	cells 3
	slope_map {
		[0.5,	<0,0>]
		[0.5,	<1,0>]
	}
}

#declare f_SpiralPolar =
function (fDist, fTheta, fFreq, fCurve) {
	pow (
		cos (
			(fTheta + (fDist*fCurve))*fFreq*0.5
		)
		,2
	)
}

#declare f_Spiral =
function (u,v, fFreq, fCurve) {
	f_SpiralPolar (sqrt (u*u+v*v), atan2 (v,u), fFreq, fCurve)
}

//base pigment
#declare pBasecolor =
pigment {
	m_CellProbStart (5,<50,7,50>)
	pigment_map {
		m_CellProb (0.2, pRedPaint)
		m_CellProb (0.6, pBluePaint)
		m_CellProb (0.2, pStripesBY)
	}
}

#declare pDecal_Numbers =
pigment {
	object {
		merge {
			m_TextBlock( "cs.ttf",	"9",	0.6, 0*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
			m_TextBlock( "cs.ttf",	"3",	0.6, 1*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
			m_TextBlock( "cs.ttf",	"7",	0.6, 2*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
			m_TextBlock( "cs.ttf",	"2",	0.6, 3*x, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP )
		}
		rgbt 1, rgb 0.04
	}
	warp {repeat x*4 }
	warp {repeat y offset 2*x }
	warp {repeat z }
}

#declare pDecal_Symbols =
pigment {
	object {
		merge {
			m_TextBlock( "lucon.ttf", "\n.\\",	1/2, 0*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
			m_TextBlock( "lucon.ttf", "\\.",		1/2, 1*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
			m_TextBlock( "lucon.ttf", ".\\/",		1/2, 2*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
			m_TextBlock( "lucon.ttf", "\n./",	1/2, 3*x, TEXT_ALIGN_CENTRE, TEXT_ALIGN_TOP )
		}
		rgbt 1, rgb 1
	}
	warp {repeat x*4}
	warp {repeat y offset 3*x}
	warp {repeat z}
}

#declare pDecal_Text =
pigment {
	object {
		merge {
			m_TextBlock(
				"kabel.ttf",
				"Garbage wurble narble\nmoo baa fishy bum\ngurgley gurgle\n\n   foobar:\n   chinky linky 17\n   pintwoul 8.2\n   pludom 4\n\nFOOBAR\n",
				<1,1,1>/16, 0,
				TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP
			)				
			m_TextBlock(
				"kabel.ttf",
				"fact facts factual\nmore facts\nimportant info\nunreadable\n\n\n",
				<1,1,1>/16, 0,
				TEXT_ALIGN_RIGHT, TEXT_ALIGN_BOTTOM
			)
			m_TextBlock(
				"ariblk.ttf",
				"WARNING!\n\nplaying with large pov\nspaceships may be\nhazardous to your\nhealth.\n",
				<1,1,1>/13, x,
				TEXT_ALIGN_CENTRE, TEXT_ALIGN_CENTRE
			)
			m_TextBlock(
				"arial.ttf",
				"some fully justified text saying\nnothing of any interest to\nanyone but me. - Tek   \n",
				<1,1,1>/13, x*2,
				TEXT_ALIGN_SCALE, TEXT_ALIGN_BOTTOM
			)
		}
		rgbt 1, rgb 1
	}
	warp {repeat x*3}
	warp {repeat y offset 7*x}
	warp {repeat z}//offset 7*x}
}

#declare pDecalsZm =
pigment {
	m_CellProbStart(-1,1)
	pigment_map {
		m_CellProb (0.02, pDecal_Numbers)
		m_CellProb (0.12, pDecal_Symbols)
		m_CellProb (0.16, pDecal_Text)
		m_CellProb (-1, rgbt 1)
	}
	translate 0.5
	scale 1.5+1000*z
}

#declare pDecals =
pigment {
	slope {x }
	pigment_map {
		[0.25	pDecalsZm rotate 90*y]
		[0.25	pDecalsZm]
		[0.75	pDecalsZm]
		[0.75	pDecalsZm rotate -90*y]
	}
}

#declare pWindows =
pigment {
	cells
	translate 0.5*z
	scale <1,1,1000>
	pigment_map {
		[0.9	rgbt 1]
		[0.9    function {min (abs (sin (x*pi)),abs (sin (y*pi)))}
			scale <1/5,1,1/5>
			pigment_map {
				[0.5    rgbt 1]
				[0.5    cells //good god not another one.
					color_map {
						[0.7	rgb <1,0.8,0.6>/20]
						[0.7	rgb <1,0.8,0.6>]
					}
				]
			}
		]
	}
	scale <8,1,8>
}

#declare tFullTexture =
texture {
	pigment {pBasecolor}
	finish {brilliance 5}
	normal {
		nPanels
		scale 1.45
	}
}
texture {
	pigment {pDecals}
	finish {
		reflection {
			0.03, 0.07
			//falloff
			//exponent 0.1
		}
		specular 0.7//1
		roughness 0.007//0.004
	}
	normal {
		nPanels
		scale 1.45
	}
}
texture {
	pigment {
		slope {x}
		pigment_map {
			[0.25	pWindows rotate 90*y translate 70]
			[0.25	pWindows translate 4*8000*z ]
			[0.75	pWindows translate 4*8000*z]
			[0.75	pWindows rotate -90*y translate -80]
		}
	}
	finish {diffuse 0.5 emission 0.5}
}

#declare T1 =
material {
	texture {tFullTexture}
        scale 0.05
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 254) /////////////////////////////////////////////////////////////////////////////////////

// Stefano Tessarin   Flowers   http://paulbourke.net/geometry/supershape/0004.pov

#declare T1 =
material {
        texture {
                pigment {
                        gradient y                           
                        color_map {     
                                [0.5  rgb <255,230,217>/255]
                                [0.5  rgb <255,134,121>/255]
                        }                                   
                 }
                 finish {
                        conserve_energy
                        diffuse 0.6
                        ambient 0
                        reflection {0.025, 0.5 fresnel on}
                        specular 0.45
                        roughness 0.005
                        crand 0.1
                }
        }
        scale 1
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 255) /////////////////////////////////////////////////////////////////////////////////////

//  Pure Fun  http://paulbourke.net/exhibition/scc4/final/l_acvhvi.pov

#macro C_ (c,d)

crackle 
color_map {
        [0.0 rgb 0.3*c]
        [0.5 rgb 1-d]
}

#end
 
#declare T1 =
material {
        texture {               
                pigment {
                        cells 
                        pigment_map {
                                [0.0 C_ (z+y*0.5,y)]
                                [0.3 C_ (y+x*0.5,x)]
                                [0.8 C_ (x+y*0.5,y)]
                                [1.0 C_ (y+z*0.5,z)]
                        }
                        turbulence <15,50,20>  
                        scale 4 
                        warp {repeat-x flip x}
                }
                normal {
                        cells 
                        normal_map {
                                [0.00 cells -1]
                                [0.15 cells -1]
                                [0.15 cells  1]
                                [0.55 cells  1]
                                [0.55 cells -1]
                                [0.90 cells -1]
                                [0.90 cells  1]
                                [1.00 cells  1]
                        }
                        turbulence <15,50,20>  
                        scale 4 
                        warp {repeat-x flip x}
                }
                finish {
                        conserve_energy
                        diffuse 0.6
                        ambient 0
                        reflection {0.3, 1 fresnel on metallic 0.5}
                        specular 0.45
                        roughness 0.005
                        metallic
                }
                //translate <9,7,0>
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 256) /////////////////////////////////////////////////////////////////////////////////////

// Zeger Knaepen  Untitled S.F. [W.I.P] take 2  http://news.povray.org/povray.binaries.images/message/%3C4de5104e%241%40news.povray.org%3E/#%3C4de5104e%241%40news.povray.org%3E

#declare envir = 0;

#local Atmosphere = <0.4,0.5,0.9>; 
#declare SunLocation = <-1,1.05,-1>*200;

#declare T1 =
material {
        texture {               
                pigment {
                        pigment_pattern {
                                slope {point_at SunLocation}
                                pigment_map {
                                        [0.5 rgb 1]
                                        [1.0 rgb 0]
                                }
                        }
                        poly_wave 2
                        pigment_map {
                                [0.5    pigment_pattern {
                                                pigment_pattern {
                                                        aoi 
                                                        color_map {
                                                                [0.0 rgb 1]
                                                                [0.5 rgb 0]
                                                                [1.0 rgb 1]
                                                        }
                                                }
                                                color_map {
                                                        [0.00 rgb 0]
                                                        [0.15 rgb 1]
                                                        [0.50 rgb 0]
                                                }
                                        }
                                        color_map {
                                                [0 rgb Atmosphere transmit 1]
                                                [1 rgb 0.25+Atmosphere transmit 0.35]
                                        }
                                        poly_wave 2
                                ]
                                [1      pigment_pattern {
                                                pigment_pattern {
                                                        aoi 
                                                        color_map {
                                                                [0.0 rgb 1]
                                                                [0.5 rgb 0]
                                                                [1.0 rgb 1]
                                                        }
                                                }
                                                color_map {
                                                        [0.00 rgb 0]
                                                        [0.15 rgb 1]
                                                        [0.50 rgb 0]
                                                }
                                        }
                                        color_map {
                                                [0 rgb 1-Atmosphere transmit 1]
                                                [1 rgb 0.25+(1-Atmosphere) transmit 0.35]
                                        }
                                        poly_wave 2
                                ]
                        }
                }
                finish {diffuse 1.5 ambient 0}
        }
}              

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 257) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  More Faked Volumetrics  http://news.povray.org/povray.binaries.scene-files/attachment/%3C40759A8C.2050300%40hotmail.com%3E/us-ascii

#declare sizer = 0.03;
#declare camdif = camloc-lookat; 

#declare disp =
pigment {
        granite
        scale 120*sizer
        rotate y*35
}

#declare T1 =
material {
        texture {pigment {rgb 0}}
        #local V = 0;
        #while (V <= 1)
                texture {
                        pigment {
                                disp
                                pigment_map {
                                        [V      rgbt <1,1,1,1>]
                                        [V+0.5  rgb V]
                                }
                        }
                        finish {
                                emission (<0.05,0.1,0.3>+0.25)/2
                                diffuse 0.6
                                brilliance 2
                        }
                        normal {
                                pigment_pattern {disp} 
                                120-V*100
                                accuracy 5
                        }
                        scale <1+V/1.5,1,1+V/1.5>
                        translate y*V*camdif.y*2.5//y*V*5   
                        translate z*camdif.z//z*-60
                }
                #local V = V+1/200;
        #end
        interior {ior 1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 258) /////////////////////////////////////////////////////////////////////////////////////

// Tom Melly  tmworsh  http://www.irtc.org/ftp/pub/stills/2001-02-28/tmworsh.zip

#declare Pattern_Base_Pig = pigment {rgb <246/255,117/255,1/255>}

#declare Rand1 = seed (777); //777 //575967435(nice) //654 //12348

#declare MandelPig =
pigment {
        mandel 500
        pigment_map {
                [0      Pattern_Base_Pig]
                #declare n = 0.004;
                #while (n < 1)
                        [n      rgb <rand (Rand1),rand (Rand1),rand (Rand1)>]
                        #declare n = n+(0.004*(rand (Rand1)+1));
                #end
        }
        translate <0.65,1.25,0>
        scale <24,12,1>
}
 
#declare T1 =
material {
        texture{
                pigment {MandelPig}
                normal {
                        average 
                        normal_map {
                                [marble 0.5 scale 5 turbulence 1]
                                [quilted 0.5 scale 0.333]
                                [bozo]
                                [bozo 1 scale 0.25]
                        }
                }
                finish {reflection 0.1 diffuse 0.7 brilliance 5 specular 0.6 roughness 0.005 metallic 0}
        }
        scale 0.1
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 259) /////////////////////////////////////////////////////////////////////////////////////

// Norert Kern  tiling pattern test

#declare T1 =
material {
        texture {
                pigment { 
                        tiling 1                                                                                                                                                                                                                                                                                                                                                                             
                        color_map {
                                [0.0 rgb <0.0,0.0,0.0>] 
                                [0.1 rgb <0.0,0.0,0.5>]
                                [1.0 rgb <1.0,0.99,0.97>] 
                        }
                }
                normal {
                        bumps
                        turbulence 1
                        scale 0.03
                        bump_size 0.2
                }
                finish {
                        ambient 0 
                        diffuse 0.6 
                        specular 1 
                        roughness 0.0125
                        reflection {0.1,0.3 fresnel}
                        conserve_energy
                }
        }
        scale 0.25
        rotate x*-90
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 260) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  The Sermon  http://www.irtc.org/ftp/pub/stills/2001-02-28/preacher.zip

#declare defaultFlat = 
texture {
        pigment {
                bozo 
                pigment_map {
  		        [0      crackle 
                                pigment_map {
  			                [0.0    rgb Ga (<1.0, 0.7, 0.1>)]
  			                [0.2    rgb Ga (<0.8, 0.25, 0>*1.25)]
  			                [0.5    rgb Ga (<0.3, 0.1, 0.1>)]
  			                [0.6    rgb Ga (<0.9, 0.45, 0.2>*1.25)]
  			                [0.7    rgb Ga (<0.8, 0.6, 0.1>*1.25)]
  			                [1.0    rgb Ga (<0.7, 0.375, 0.0>/1.25)]
  			        }
  			        scale 7.5
  			        turbulence 0.35
  			        frequency 2
  		        ]
  		        [1      agate 
                                pigment_map {
  			                [0.0    rgb Ga (<1.0, 0.7, 0.1>*1.25)]
  			                [0.2    rgb Ga (<0.9, 0.25, 0 >*1.25)]
  			                [0.45   rgb Ga (<0.8, 0.3, 0.1>*1.25)]
  			                [0.65   rgb Ga (<1.0, 0.25,0.2>*1.25)]
  			                [0.7    rgb Ga (<0.8, 0.4, 0.1>*1.25)]
  			                [1.0    rgb Ga (<0.7, 0.375, 0>*1.25)]
  			        }
  			        scale 5
  			        turbulence 0.5
  		        ]
  	        }
  		scale 3
  	} 		
	finish {ambient 0 diffuse 0.325*1.4} 
        normal {
  		bozo 
                normal_map {
  			[0 facets coords 2 size 5 scallop_wave frequency 5 turbulence 0.3]
  			[1 crackle 3 scale 5 ramp_wave frequency 5 turbulence 0.3]
  		}
  		scale 5
  	}
}

#declare T1 =
material {
	texture {defaultFlat}
        scale 0.002
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 261) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  Foggy Quartz  http://news.povray.org/povray.text.scene-files/message/%3C3961732D.EAD838D1%40aol.com%3E/#%3C3961732D.EAD838D1%40aol.com%3E  

#declare radio = 0;
#declare envir = 0;

#declare T1 =
material {
	texture {
                pigment {rgbf <1,1,1,0.99>}
                finish {phong 1 phong_size 100 reflection {0, 0.7} conserve_energy diffuse 1}
                normal {bumps scallop_wave scale <1,0.05,1>*0.5 no_bump_scale bump_size 0.005}
        }
        interior {
                ior 1.55 
                //caustics 0.2
                media {
                        scattering {5,2}
                        method 2
                        density {
                                agate //planar scale 2 
                                scale 2
                                color_map {
                                        [0 rgb 0]
                                        [1 rgb <1,0.8,1>*0.5]
                                }
                        }
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 262) /////////////////////////////////////////////////////////////////////////////////////

// Tom Melly  tmcont  http://www.irtc.org/ftp/pub/stills/2000-12-31/tmcont.zip

#declare groundleaf =
texture {
        pigment {
                crackle 
                turbulence 0.25 
                scale 0.01 
                pigment_map {
                        [0.0 Gold]
                        [0.5 MediumWood]
                        [1.0 DarkWood]
                }
        }
        normal {crackle 4 turbulence 0.25 scale 0.01}
        finish {ambient 0 diffuse 0.7}
}

#declare groundmuda =
texture{
        pigment {rgb <0.2,0.15,0>}
        normal {
                average 
                normal_map {
                        [bozo 5 scale 0.1]
                        [agate 5 scale 0.1]
                }
        }
        finish {ambient 0 diffuse 0.7 reflection 0.1}
} 

#declare groundmudb =
texture {
        wrinkles turbulence 0.25 scale 0.2
        texture_map {
                [0.50 groundmuda]
                [0.55 groundleaf]
        }
}

#declare groundmud =
texture {
        crackle turbulence 0.3 //gradient y
        texture_map {
                [0.5 groundmudb]
                [1.0 groundleaf]
        }
}

#declare groundTex =
texture {
        wrinkles turbulence 0.25 scale 0.2
        texture_map {
                [0.50 groundmud]
                [0.60 groundleaf]
        }
}

#declare T1 =
material {
	texture {groundTex}
        scale 0.5
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 263) /////////////////////////////////////////////////////////////////////////////////////

// Gilles Tran  escargot  http://www.oyonale.com/downloads/escargot.zip

#declare V_WorldBoundMin = <-474.398682, 1.479103, -145.014023>;
#declare V_WorldBoundMax = <390.939697, 335.499390, 156.039734>;
#declare C_Snail_Shell_Red = rgb <232,176,98>/255; // Red
#declare C_Snail_Shell_Yellow = rgb <222,203,112>/255;// Yellow
#declare C_Snail_Shell_Black = rgb <27,27,20>/255; // Black
#declare RefShell=1; // max fresnel for the shell

#declare F_Snail_Shell=
finish {
        ambient 0 
        diffuse 0.66 
        specular 1.5 
        roughness 0.05*0.1 
        reflection {0,RefShell fresnel on}
}
#declare N_Snail_Shell =
normal {
        gradient y
        turbulence 0.6
        sine_wave 
        scale 0.01 
        bump_size 2
}

#declare T_Snail_Shell_Border = 
texture{
        pigment {C_Snail_Shell_Red}
        finish {F_Snail_Shell}
}

#declare i = 0;
#declare rd = seed(0);

#declare T_Shell =
texture {
        pigment {
                pigment_pattern{
                        gradient x
                        turbulence 0.1
                        lambda 3
                        triangle_wave
                        scale <1/20,1/20,1>
                        color_map{
                                [0.4 Black]
                                [1 White]
                        }
                }
                pigment_map{
                        [0.4     pigment_pattern {
                                        gradient y 
                                        turbulence 0.6 
                                        lambda 3
                                        omega 0.3
                                        scale <1/130,1/40,1>
                                }
                                pigment_map {
                                        [0.0    C_Snail_Shell_Yellow]
                                        [0.3    dents scale 0.005 scale <40/130,1,1> color_map{[0 C_Snail_Shell_Black][0.1 C_Snail_Shell_Red][0.2 C_Snail_Shell_Yellow]}]
                                        [0.5    dents scale 0.005 scale <40/130,1,1> color_map{[0 C_Snail_Shell_Black][0.7 C_Snail_Shell_Red*0.4]}]
                                        [1      C_Snail_Shell_Black]
                                }
                        ]
                        [0.5    pigment_pattern {
                                        gradient y 
                                        turbulence 0.6 
                                        lambda 3
                                        omega 0.3
                                        scale <1/130,1/200,1>
                                }
                                pigment_map {
                                        [0.0    C_Snail_Shell_Red]
                                        [0.3    dents scale 0.005 scale <40/130,1,1> color_map{[0 C_Snail_Shell_Red][0.2 C_Snail_Shell_Yellow]}]
                                        [0.5    dents scale 0.005 scale <40/130,1,1> color_map{[0 C_Snail_Shell_Red][0.2 C_Snail_Shell_Red*0.2]}]
                                }
                        ]
                }
        }
        normal {N_Snail_Shell}
        finish {F_Snail_Shell}
        scale <10,20,10>
}

#declare T1 =
material {
	texture {T_Shell}
        scale 0.3
        rotate x*45
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 264) /////////////////////////////////////////////////////////////////////////////////////

// Robert W. McGregor  BenchTest  http://news.povray.org/povray.text.scene-files/attachment/%3Cweb.4db449aa369114694d713cc0%40news.povray.org%3E/bench.zip

#declare T_Bench = 
texture {
        pigment {
                granite 
                scale 6 
                color_map {
                        [0 rgb 0.5]
                        [1 rgb 0.7] 
                } 
        }
        normal {
                average
                normal_map {
                        [0.5    granite 0.75 
                                scale 0.3
                        ]
                        [1      granite 0.5 
                                scale 3
                        ]
                        [1      bozo
                                scale 0.1
                                turbulence 0.25
                                normal_map {
                                        [0      granite 0.75 
                                                scale 0.5
                                        ]
                                        [1      crackle 1 
                                                scale 0.75
                                        ]
                                }
                        ]
                } 
        }
        finish {
                specular 0.15 
                roughness 0.15 
                reflection {0, 0.5 fresnel on} 
                conserve_energy
                diffuse 0.8 
        }
}

#declare T1 =
material {
	texture {T_Bench}
        scale 0.3
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 265) /////////////////////////////////////////////////////////////////////////////////////

// adapted from Mark Slone  Brick walls and lamp from Venice  http://news.povray.org/povray.binaries.scene-files/thread/%3C3D5C91B1.2050602%40hiwaay.net%3E/?ttop=386478&toff=700

#local BrickWidth  = 1.00;
#local BrickHeight = 0.25;
#local BrickDepth  = BrickWidth*0.5;

#declare R1 = seed (1001); 

#declare Streaks_pigmentY =
pigment {
        granite
        color_map {
                [0.0 rgbt <0.00, 0.00, 0.00, 0.0>]
                [0.4 rgbt <0.25, 0.25, 0.25, 0.0>]
                [0.4 rgbt <0.25, 0.25, 0.25, 1.0>]
                [1.0 rgbt <0.25, 0.25, 0.25, 1.0>]
        }
        scale <2,0.2,2>
}

#local BrickWidth  = 1.00;
#local BrickHeight = 0.25;
#local BrickDepth  = BrickWidth*0.5;

#declare T_venice =
texture {
        pigment {
                crackle
                color_map {
                        [0.00  rgb <0.00, 0.00, 0.00>*2.0] 
                        [0.005 rgb <0.21, 0.01, 0.02>*2.0] 
                        [0.10  rgb <0.51, 0.21, 0.12>*2.0] 
                        [0.20  rgb <0.45, 0.28, 0.28>*2.0] 
                        [0.40  rgb <0.21, 0.11, 0.11>*2.0] 
                        [0.52  rgb <0.23, 0.23, 0.23>*2.0]
                        [0.54  rgb <0.00, 0.00, 0.00>*2.0] 
                        [0.55  rgb <0.10, 0.10, 0.10>*2.0] 
                        [0.56  rgb <0.00, 0.00, 0.00>*2.0] 
                        [0.58  rgb <0.43, 0.43, 0.43>*2.0] 
                        [0.60  rgb <0.25, 0.25, 0.35>*2.0]  
                        [0.80  rgb <0.50, 0.40, 0.40>*2.0] 
                        [1.00  rgb <0.16, 0.16, 0.26>*2.0]
                }
                scale <60,30,60> 
                turbulence 1.0
                octaves 8        
                lambda 2.8       
                omega 0.6        
                warp {repeat x*BrickWidth  offset <rand (R1)*100,rand (R1)*100,rand (R1)*100>} 
                warp {repeat y*BrickHeight offset <rand (R1)*100,rand (R1)*100,rand (R1)*100>}
        }  
        scale (rand(R1)+1)
        translate <rand (R1)*10,rand (R1)*10,rand (R1)*10>
        normal {
                average
                normal_map {
                        [1      gradient z
                                slope_map {
	                                [0.00 <0, 1.00>]
	                                [0.01 <0, 0.70>]
	                                [0.02 <0, 0.10>]
	                                [0.03 <1, 0.00>]
	                                [0.97 <1, 0.00>]
	                                [0.98 <1,-0.10>]
	                                [0.99 <1,-0.70>]
	                                [1.00 <0,-1.00>]
	                        }
                        ]
                        [1      gradient x
                                slope_map {
	                                [0.00 <1, 0>]
	                                [1.00 <1, 0>]
	                        }
                        ]
                        [1      gradient y
                                slope_map {
	                                [0.00 <0, 1.00>]
	                                [0.04 <0, 0.70>]
	                                [0.08 <0, 0.10>]
	                                [0.12 <1, 0.00>]
	                                [0.88 <1, 0.00>]
	                                [0.92 <1,-0.10>]
	                                [0.96 <1,-0.70>]
	                                [1.00 <0,-1.00>]
	                        }
                        ]
                        [1      granite 1
                                scale <10,20,10>  
                                turbulence 1
                                octaves 8       
                                lambda 2.8    
                                omega 0.55     
                                translate <rand (R1)*10,rand (R1)*10,rand (R1)*10>
                        ]
                }
                warp {repeat x*BrickWidth  offset <rand (R1)*100,rand (R1)*100,rand (R1)*100>} 
                warp {repeat y*BrickHeight  offset <rand (R1)*100,rand (R1)*100,rand (R1)*100>}
	}
}
texture {
        pigment {
	        wrinkles
                color_map {
                        [0.0 rgbt <0.54, 0.48, 0.26, 0.8>]
                        [0.1 rgbt <0.53, 0.40, 0.26, 0.8>]
                        [0.2 rgbt <0.62, 0.48, 0.43, 0.8>]
                        [0.3 rgbt <0.69, 0.58, 0.47, 0.8>]
                        [1.0 rgbt <0.88, 0.67, 0.45, 0.8>]
                }
        }
	scale <BrickDepth,BrickHeight,BrickDepth> 
}
texture {
        pigment {
                granite 
                color_map {
                        [0.00  rgbt <1.00, 0.00, 0.00, 0>] 
                        [0.07  rgbt <0.00, 0.00, 0.00, 0>] 
                        [0.12  rgbt <0.30, 0.20, 0.12, 1>] 
                        [0.545 rgbt <0.00, 0.00, 0.00, 1>]
                        [0.550 rgbt <0.10, 0.10, 0.10, 0>]
                        [0.555 rgbt <0.00, 0.00, 0.00, 1>]
                        [1.00  rgbt <0.16, 0.16, 0.16, 1>] 
                }
                scale <80,1,80>  
                turbulence 1
                octaves 8        
                lambda 2.8       
                omega 0.6        
        } 
        scale (rand(R1)+1)
        translate <rand(R1)*10,rand(R1)*10,rand(R1)*10>
}
/*texture {
        pigment {
                gradient y
                pigment_map {
                        [0.00 Streaks_pigmentY]  
                        [0.12 rgbt <0.2,0.2,0.2,1>]
                        [0.88 rgbt <0.2,0.2,0.2,1>]
                        [1.00 Streaks_pigmentY]  
                }
        }  
        scale <1,BrickHeight,1> 
}
texture {
        pigment {
                gradient z
                pigment_map {
                        [0.00 Streaks_pigmentX ]  
                        [0.03 rgbt <0.20, 0.20, 0.20, 1.0>]  
                        [0.97 rgbt <0.20, 0.20, 0.20, 1.0>]  
                        [1.00 Streaks_pigmentX ]  
                }
        }
	scale <BrickDepth,1,BrickWidth>  
}*/

#declare T1 =
material {
	texture {T_venice}
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 266) /////////////////////////////////////////////////////////////////////////////////////

// Dave Blandston  "Play," "Pause," etc. Buttons  http://news.povray.org/povray.text.scene-files/thread/%3Cweb.45b130fbf30b94f38bf1dde90@news.povray.org%3E/?ttop=391674&toff=100

#local ButtonFaceColor = 
texture {
        pigment {
                cells //gradient y
                #local Color1 = color <0.94,0.93,0.8>*0.6; //Top color
                #local Color2 = color <0.94,0.93,0.8>*0.3; //Bottom color
                color_map {
                        [0.0 color Color2] 
                        [0.2 color Color2] 
                        [0.6 color Color1] 
                        [0.7 color Color1] 
                        [1.0 color Color2]
                }
        }
        normal {cells} 
        finish {
                brilliance 2
                diffuse 0.6
                metallic
                reflection 0.6
                specular 0.05
                roughness 0.01
                ambient 0
        } 
} 

#declare T1 =
material {
	texture {ButtonFaceColor}
        scale 0.25
        interior {ior 1.55}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 267) /////////////////////////////////////////////////////////////////////////////////////

// Dave Blandston  "Play," "Pause," etc. Buttons  http://news.povray.org/povray.text.scene-files/thread/%3Cweb.45b130fbf30b94f38bf1dde90@news.povray.org%3E/?ttop=391674&toff=100

#declare envir = 0;
 
#declare T1 =
material {
        texture {
                pigment {rgbf <0.98,1.05,1.02,0.9>}
                finish {
                        emission 0.1
                        diffuse 0.1
                        reflection 0.1
                        specular 0.8
                        roughness 0.0003
                        phong 1
                        phong_size 60
                } 
        } 
        interior {
                ior 1.8
                media {
                        emission <1,1,0.5>*3
                        absorption (1-<0.5,0.5,0.9>)*3
                        method 2
                        intervals 2
                        density {
                                bozo
                                color_map {
                                        [0      rgb 0]
                                        [1      rgb 1]
                                }
                                turbulence 1.5
                                lambda 1
                                scale 0.25
                        }
                        density {
                                bozo
                                color_map {
                                        [0      rgb 0]
                                        [1      rgb 1]
                                }
                                scale 0.5
                        }
                        scale 0.667
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 268) /////////////////////////////////////////////////////////////////////////////////////

// Mick Hazelgrove  The Sermon  http://www.irtc.org/ftp/pub/stills/2001-02-28/preacher.zip  

#declare Pigg = 
pigment {
	crackle 
	color_map {
		[0.00 rgb Ga (<0.8,0.6,0.4>)]
		[0.25 rgb Ga (<0.8,0.8,0.65>)]
		[0.50 rgb 1]
		[0.75 rgb Ga (<0.99,0.9,0.7>)]
		[1.00 rgb Ga (<0.99,0.8,0.6>)]
	}
	scale 2.5
	solid
}
		
#declare Pigg2 = 
pigment {
	crackle 
	color_map {
		[0.00 rgbt 1]
		[0.25 rgb Ga (<0.8,0.9,0.5>)]
		[0.50 rgbt 1]
		[0.75 rgb Ga (<0.99,0.9,0.7>)]
		[1.00 rgbt 1]
	}
	scale 0.75
	solid
}

#declare EggTex = 
texture {
	pigment {Pigg}                                                         
	normal {granite 10*0.2 scallop_wave scale 0.025*0.5}
	finish {ambient 0 diffuse 0.3*1.6 brilliance 2}
}
texture {
	pigment {Pigg2}
	normal {
                bozo 
                normal_map {
                        [0.0 bozo 5*0.2 scallop_wave scale 0.5*0.5]
			[0.2 bozo 20*0.2 scallop_wave scale 1.5*0.5]
			[0.9 bozo 25*0.2 scallop_wave scale 0.5*0.5]
			[1.0 bozo 10*0.2 scallop_wave scale 3*0.5]
	        }
		turbulence 0.3
	}
	finish {specular 0.125 ambient 0 diffuse 0.45*1.6 crand 0.125 brilliance 1.5} 
}

#declare T1 =
material {
	texture {EggTex}
        scale 0.04
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 269) /////////////////////////////////////////////////////////////////////////////////////

//  sap  A moon  http://news.povray.org/povray.text.scene-files/thread/%3C41868d0b%40news.povray.org%3E/

#declare pig =
pigment {
        average
        pigment_map {
                [1      wrinkles
                        warp {turbulence <0.2,0.2,0.2>}
                        color_map {
                                [0 rgb 0]
                                [1 rgb 0.25]
                        }
                ]
                [1      bozo scale 0.1//granite
                        turbulence 1
                        color_map {
                                [0 rgb 0]
                                [1 rgb 0.25]
                        }
                ]
                [1      dents//leopard
                        turbulence 0.2
                        color_map {
                                [0.0 rgb 0.0]//ft <0,0,0,1,1>]
                                [0.3 rgb 0.0]//ft <0,0,0,1,1>]
                                [0.8 rgb 1*2]
                        }
                        scale 0.5*3
                        rotate y*-30
                ]
                [1      dents//leopard
                        turbulence 0.2
                        color_map {
                                [0.0 rgb 0.0]//ft <0,0,0,1,1>]
                                [0.3 rgb 0.0]//ft <0,0,0,1,1>]
                                [0.8 rgb 0.8*1.5]
                        }
                        scale 0.25*3
                        rotate y*-30
                ]
        }
}

#declare fnPig = function {pigment {pig}}

#declare T1 =
material {
	texture {
                pigment {pig}
                normal {function {fnPig (x,y,z).x} bump_size -2}
                finish {specular 0.25 diffuse 0.6*1.5}
        }
        scale 0.2
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 270) /////////////////////////////////////////////////////////////////////////////////////

// pattern by Tekno Frannansa  lace pattern  http://news.povray.org/povray.binaries.images/message/%3C3ff5b4c9%40news.povray.org%3E/#%3C3ff5b4c9%40news.povray.org%3E
// adapted to FurTex  by Rune Skovbo Johansen  http://runevision.com/3d/povgoodies/furtex.zip 

#declare fA = 135; //change this from 0 - 360 to get various different patterns

#declare pig =
pigment {
        granite
        color_map {
                [0.10 rgb 0*0.16] 
                [0.20 rgb <6,5,2>*0.16] 
                [0.30 rgb 0]//-6*0.16] 
                [0.40 rgb <6,2,0>*0.16] 
                [0.47 rgb 0]//-6*0.16] 
                [0.50 rgb <6,5,0>*0.16] 
                [0.57 rgb 0]//-6*0.16] 
                [0.62 rgb <1,0,6>*0.16] 
                [0.71 rgb <4,6,1>*0.16] 
                [0.80 rgb 0] 
                [0.90 rgb 1]//-6*0.16] 
        }
        #local nCount = 0;
        #while (nCount < 20)
                rotate -fA*z
                warp {repeat y flip y}
                #local nCount = nCount+1;
        #end
}

#declare pig2 =
pigment {
        granite
        color_map {
                [0.10 rgb 0*-0.16] 
                [0.20 rgb <6,5,2>*-0.16] 
                [0.30 rgb 0]//-6*0.16] 
                [0.40 rgb <6,2,0>*-0.16] 
                [0.47 rgb 0]//-6*0.16] 
                [0.50 rgb <6,5,0>*-0.16] 
                [0.57 rgb 0]//-6*0.16] 
                [0.62 rgb <1,0,6>*-0.16] 
                [0.71 rgb <4,6,1>*-0.16] 
                [0.80 rgb 0] 
                [0.90 rgb -1]//-6*0.16] 
        }
        #local nCount = 0;
        #while (nCount < 20)
                rotate -fA*z
                warp {repeat y flip y}
                #local nCount = nCount+1;
        #end
}

#declare T1 =
material {
        texture {
                average
                texture_map {
                        [       pigment {pig}
                                normal {
                                        average
                                        normal_map {
                                                [       bumps 0.3*3
                                                        warp {turbulence 1}
                                                        scale 0.2
                                                ]
                                                [       bumps 0.2*3
                                                        warp {turbulence 0.5}
                                                        scale 0.001
                                                ]
                                        }
                                }
                                finish {ambient 0 diffuse 0.6*2 brilliance 0.6}
                        ]
                        [       pigment {pig2}
                                finish {ambient 0 diffuse 0 phong 1 phong_size 2 metallic}
                        ]
                }
        }
        scale 0.5
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 271) /////////////////////////////////////////////////////////////////////////////////////

// Andrew Cocker  Pretty Blocks  http://news.povray.org/povray.binaries.scene-files/attachment/%3C3e310b89%40news.povray.org%3E/Rad_Blocks_v3.5.pov.txt?ttop=393045&toff=650

#declare T_Env =
texture {
        pigment {rgb 1}
        finish {ambient 0 diffuse 0.6}
}

#declare T1 =
material {

        texture {
                bozo
                texture_map {
                        [0      T_Env finish {emission 0.6}]
                        [0.3    pigment {rgb <0.5,0.2,0>} finish {ambient 0 specular 0 diffuse 0.8 reflection {0.3,0.8 fresnel}}]
                        [0.5    pigment {rgb 0} finish {ambient 0 specular 0 diffuse 0.1 reflection {0.3,0.8 fresnel}}]
                        [0.675  T_Env finish {reflection {0.2,0.4 fresnel}}]
                        [0.775  T_Env finish {diffuse 0.6}] 
                }
        }
        interior {ior 1.4}
        scale 3
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 272) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Dirty Glass texture   http://news.povray.org/povray.binaries.images/message/%3Cweb.5144408929e5627a4d6e54800%40news.povray.org%3E/#%3Cweb.5144408929e5627a4d6e54800%40news.povray.org%3E

#declare radio = 0;
#declare envir = 1;

#declare dirt = 
texture {
        pigment {
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.00 rgbt 1]
                        [0.75 rgbt 1]
                        [0.75 rgbt Gat (<0.5, 0.34, 0.25, 1>)]
                        [0.90 rgbt Gat (<0.25, 0.2, 0.15, 0.5>)]
                        [1.00 rgbt Gat (<0.5, 0.34, 0.25, 1.0>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.81 reflection {0.001, 0.01 fresnel on}}
}

#declare vdirt = 
texture {
        pigment {
                bozo scallop_wave turbulence 0.8753 omega 0.775 lambda 3.2 octaves 7
                color_map {
                        [0.00 rgbt 1]
                        [0.55 rgbt 1]
                        [0.55 rgbt Gat (<0.25, 0.14, 0.09, 1>)]
                        [0.90 rgbt Gat (<0.08, 0.06, 0.045, 0.125>)]
                        [1.00 rgbt Gat (<0.25, 0.14, 0.09, 0.45>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.75 reflection {0.001, 0.005 fresnel on}}
}

#declare lampGlassTex = 
texture {
        pigment {rgbf Gat (<0.99,0.96,0.92,1>)}
        finish {
                specular 0
                roughness 0.002
                ambient 0
                diffuse albedo 0.125
                brilliance 4
                reflection {0.01, 0.2 fresnel on}
                conserve_energy
        }
        normal {granite 0.01 turbulence 0.5 scale <0.04,0.1,0.04>}
}

#declare lampGlassTexDirt = 
texture {lampGlassTex}
texture {dirt scale 4}

#declare lampGlassTexVDirt = 
texture {lampGlassTex}
texture {vdirt scale 4}

#declare T1 = 
material {
        texture {
                bozo  
                scallop_wave 
                turbulence 0.675 
                omega 0.7
                texture_map {
                        [0.0  lampGlassTexVDirt]
                        [0.15 lampGlassTexDirt]
                        [1.0  lampGlassTex]
                }
                scale 0.22
        }        
        interior {
                ior 1.5
                fade_distance 2.5*100
                fade_power 1001
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 273) /////////////////////////////////////////////////////////////////////////////////////

// David Heys  Y.A.T.T.  http://news.povray.org/povray.binaries.scene-files/attachment/%3C396f938d%40news.povray.org%3E/curled_torus.pov.txt 

#declare envir = 0;
#declare matra = 255;

#declare T1 = 
material {
        texture {
                pigment {Gold filter 0.5 transmit 0.5}
        }
        interior {
                ior 1.5
                media {
                        emission 1.3
                        method 3
                        density {
                                bozo
                                scale 0.2//<0.4,0.3,0.3>
                                turbulence 0.85
                                octaves 2
                                lambda 1.01
                                omega 0.75
                                rotate 90*z
                                density_map {
                                        [0.0  Gold]
                                        [0.1  Gold*4]
                                        [0.2  Coral*4]
                                        [0.3  Coral]
                                        [0.4  rgb 0]
                                        [0.5  rgb -1]
                                        [0.6  rgb 0]
                                        [0.7  Coral]
                                        [0.8  Coral*4]
                                        [0.9  Gold*4]
                                        [1.0  Gold]
                                }
                        }
                        scale 2
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 274) /////////////////////////////////////////////////////////////////////////////////////

// David Heys  Fire Opal - W.I.P.  http://news.povray.org/povray.binaries.images/message/%3C3968e4b0%40news.povray.org%3E/#%3C3968e4b0%40news.povray.org%3E  

#declare matra  = 15;

#declare T1 =
material {
        texture {
                pigment {Gold*0.75 filter 0.6 transmit 0.4}
                finish {phong 0.06 reflection 0.15}
        }
        interior {
                ior 1.5
                media {
                        emission 1.0*2
                        method 3
                        density {
                                bozo
                                scale <0.4,0.3,0.3>*0.1
                                turbulence 0.85
                                octaves 2
                                lambda 1.01
                                omega 0.75
                                rotate 90*z
                                density_map {
                                        [0      Gold*0.5]
                                        [0.1    Gold*0.25]
                                        [0.2    Coral*0.25]
                                        [0.3    Coral*0.5]
                                        [0.4    agate
                                                color_map {
                                                        [0      Gold*0.5]
                                                        [0.2    rgb 0]
                                                        [0.4    Coral*0.5]
                                                        [0.6    rgb 0]
                                                        [1.0    SpicyPink*0.333]
                                                }
                                                scale 0.1
                                        ]
                                        [0.5    rgb -0.25*2]
                                        [0.6    granite
                                                color_map {
                                                        [0      SpicyPink*0.333]
                                                        [0.2    rgb 0]
                                                        [0.4    Gold*0.5]
                                                        [0.6    rgb 0]
                                                        [1.0    Coral*0.5]
                                                }
                                                scale 0.1
                                        ]
                                        [0.7    Coral*0.5]
                                        [0.8    Coral*0.25]
                                        [0.9    Gold*0.25]
                                        [1      Gold*0.5]
                                }
                        }
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 275) /////////////////////////////////////////////////////////////////////////////////////

// Michael Zier  Two glowing crystals  http://news.povray.org/povray.binaries.scene-files/attachment/%3C398B2A14.AB583D1A%40mail.wh2.tu-dresden.de%3E/badcrystal.pov.txt?ttop=382964&toff=1000

#declare T1 =
material {
        texture {
                pigment {rgbf <0.25490196,0.68627451,0.56862745,0.875>}
                normal {
                        crackle 3
                        turbulence 0.7
                        scale 30*0.005
                }
                finish {
                        ambient 0
                        diffuse 0.1
                        specular 0.5
                        roughness 0.05
                }
        }
        interior {
                ior 1.1   
                media {
                        emission <1,1,0.5>*0.025*100
                        density {
                                agate//spherical
                                color_map {
                                        [0.0 rgb 0]
                                        [0.4 rgb 1]
                                }
                                //scale <50,120,50>
                                scale 0.3
                                turbulence 0.7
                                omega 0.3
                                octaves 3
                                lambda 1.3
                        }
                        density {
                                bozo//wood       
                                turbulence 0.3
                                lambda 1.1 
                                omega 0.3
                                color_map {
                                        [0.0 rgb 0]
                                        [1.0 rgb 1]
                                }
                                scale 0.3        
                                //translate <4465,256,2688>
                                //rotate x*90
                                //scale 10
                        }           
                        intervals 1
                        samples 30,100 
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 276) /////////////////////////////////////////////////////////////////////////////////////

// Tor Olav Kristensen  Isosurface-Toroidal_Noise  http://home.online.no/~t-o-k/POV-Ray/Isosurface-Toroidal_Noise.txt 

#declare WrinkleFn = function {pattern {wrinkles}}

#declare TwistedWrinkleFn =
function {
        WrinkleFn (
                2*cos (2*f_noise3d (4*x,4*y,4*z)*pi),
                2*y +  4*f_noise3d (2*x,2*y,2*z),
                2*sin (2*f_noise3d (4*x,4*y,4*z)*pi)
        )
}

#declare T1 =
material {
        texture {
                pigment {
                        function {TwistedWrinkleFn (x,y,z)}
                        color_map {
                                [0.2 color Brown*0.125]
                                [0.5 color White*0.3+Yellow*0.18]
                                [1.0 color White]
                        }
                }
                normal {function {TwistedWrinkleFn (x,y,z)} bump_size 1}
                finish {diffuse 0.8}
        }
        scale 0.5
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 277) /////////////////////////////////////////////////////////////////////////////////////

// noise sand

#local col1 = 0.6*<60,29,0>/255;
#local col2 = <255,238,207>/255;

#declare T1 =
material {
        texture {
                pigment {
                        dents
                        turbulence 3
                        color_map {
                                [0.0 rgb col1]
                                [0.1 rgb col1]
                                [0.2 rgb (col1+col2)/2]
                                [0.7 rgb col2]
                                [1.0 rgb col2]
                        }
                }
                finish {
                        ambient 0
                        diffuse 1
                }
                scale 0.002
        }
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 278) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare pig_earth1 = 
pigment {
	bozo
	color_map {
		[0.1 rgb <33/255, 43/255, 2/255>]
		[0.9 rgb <11/255, 13/255, 0/255>]
	}
	scale 0.1
}
#declare pig_earth2 = 
pigment {
	bozo
	color_map {
		[0.1 rgb <76/255, 45/255, 2/255>]
		[0.9 rgb <23/255, 15/255, 0/255>]
	}
	scale 0.1
}

#declare pig_earth =
 pigment {
	bozo
	pigment_map {
		[0.35 pig_earth1]
		[0.65 pig_earth2]
	}
	scale 0.2
}

#declare pig_sand = 
pigment {
	agate
	agate_turb 0.5
	color_map {
		[0.25 rgb <221/255, 223/255, 28/255>]
		[0.85 rgb <169/255, 171/255, 21/255>]
	}
	scale 0.4
}

#declare tex_terrain = 
texture {
        pigment_pattern {wrinkles}
	texture_map {
		[0 pigment {pig_sand} finish {specular 0.35 roughness 0.04} normal {granite 2 scale 0.05}]
		[1 pigment {pig_earth} finish {specular 0.35 roughness 0.04} normal {crackle 2 scale 0.05}]
	}
}

#declare T1 =
material {
        texture {tex_terrain}
        interior {ior 1.4}
        scale 0.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 279) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare TdG_RustedMetal = 
texture {
        bozo
        texture_map {
                [0.42   pigment {rgb <0.71,0.54,0.26>}                         
                        finish {
                                ambient 0
                                diffuse 0.7
                                brilliance 6
                                phong 0.75
                                phong_size 80.0
                                reflection {
                                        0.25, 1
                                        fresnel  on
                                        falloff  1
                                        exponent 2
                                        metallic 1
                                }
                        }
                ]
                [0.46   pigment {rgb <0.71,0.54,0.26>}                         
                        finish {
                                ambient 0
                                diffuse 0.7
                                brilliance 6
                                phong 0.75
                                phong_size 80.0
                                reflection {
                                        0.25, 1
                                        fresnel  on
                                        falloff  1
                                        exponent 2
                                        metallic 1
                                }
                        }
                        normal {crackle -2 scale 0.05}
                ]
                [0.50   pigment {
                                granite
                                color_map {
                                        [0.0    rgb Ga (<0.89, 0.51, 0.28>)*0.7]
                                        [0.4    rgb Ga (<0.70, 0.13, 0.00>)*0.7]
                                        [0.5    rgb Ga (<0.69, 0.41, 0.08>)*0.7]
                                        [0.6    rgb Ga (<0.49, 0.31, 0.28>)*0.7]
                                        [1.0    rgb Ga (<0.89, 0.51, 0.28>)*0.7]
                                }
                                scale 0.1
                        }
                        finish {ambient 0 diffuse 0.4}
                        normal {granite 2 scale 0.1}
                ]
                [1.00   pigment {
                                granite
                                color_map {
                                        [0.0    rgb Ga (<0.89, 0.51, 0.28>)*0.7]
                                        [0.4    rgb Ga (<0.70, 0.13, 0.00>)*0.7]
                                        [0.5    rgb Ga (<0.69, 0.41, 0.08>)*0.7]
                                        [0.6    rgb Ga (<0.49, 0.31, 0.28>)*0.7]
                                        [1.0    rgb Ga (<0.89, 0.51, 0.28>)*0.7]
                                }
                                scale 0.1
                        }
                        finish {ambient 0 diffuse 0.5}
                        normal {wrinkles 5 scale 0.05}
                ]
        }
        warp {turbulence <3,2,1>}
}

#declare T1 =
material {
        texture {TdG_RustedMetal}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 280) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare TdG_RustyIron2 = 
texture {
        pigment {
                bumps  
                color_map {
                        [0.0  rgb <1.00, 0.50, 0.00>] 
                        [0.2  rgb <1.00, 0.50, 0.25>] 
                        [0.4  rgb <0.50, 0.25, 0.00>] 
                        [0.6  rgb <0.50, 0.00, 0.00>] 
                        [0.8  rgb <0.50, 0.25, 0.25>] 
                        [1.0  rgb <0.00, 0.00, 0.00>]
                } 
                turbulence 20 
                lambda 2 
                omega 0.5 
                octaves 3 
                frequency 1 
                phase 0 
        } 
        normal {
                bumps 5 
                turbulence 100 
                lambda 2 
                omega 0.5 
                octaves 3 
                frequency 1 
                phase 0 
        } 
        finish {
                specular 0.3 
                roughness 0.15 
        } 
        scale 4 
}

#declare T1 =
material {
        texture {TdG_RustyIron2}
        interior {ior 1.5}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 281) /////////////////////////////////////////////////////////////////////////////////////

// LightBeam  Cellestin code  http://news.povray.org/povray.binaries.scene-files/attachment/%3C41f9190a@news.povray.org%3E/

#declare T1 =
material {
        texture {
	        pigment {
                        aoi 
                        color_map {
                                [0.4    rgb 1]
                                [0.4    rgb 0]
                                [0.6    rgb 0]
                                [0.6    rgb 1]
                        }
                }	
	        finish {brilliance 0 phong 0.3 phong_size 5 /*specular 0.2 roughness 0.1*/}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 282) /////////////////////////////////////////////////////////////////////////////////////
 
// Martial Rameaux  I am so hungry!  http://www.irtc.org/ftp/pub/stills/2005-02-28/imhungry.zip

#declare T_temp =
texture {
        pigment {Orange} 
        normal {bozo 10 scale 0.01}
}
texture {
        pigment {
                bozo 
                color_map {
                        [0 Orange*0.3] 
                        [1 Clear]
                }
                warp {turbulence 0.5}
        }
        normal {
                bozo
                warp {turbulence 0.5} 
                normal_map {
                        [0 granite scale 0.3 bump_size 10 accuracy 0.01] 
                        [1 granite scale 0.3 bump_size 0]
                }
        } 
        scale 0.1
}
texture {
        pigment {
                bozo 
                color_map {
                        [0.5 Clear] 
                        [1.0 Orange*2]
                }
                warp {turbulence 0.5}
        }
        normal {
                bozo 
                warp {turbulence 0.5}
                normal_map {
                        [0.5 granite scale 0.3 bump_size 0] 
                        [1.0 granite scale 0.3 bump_size 10 accuracy 0.01]
                }
        }  
        scale 0.3
}
texture {
        pigment {
                bozo 
                color_map {
                        [0.0 Black] 
                        [0.5 Clear]
                } 
                warp {turbulence 0.5} 
                scale 0.02
        }
        normal {
                bozo
                warp {turbulence 0.5}
                scale 0.02 
                normal_map {
                        [0.0 crackle warp {turbulence 0.5} scale 0.3 scale 0.02 bump_size -10 accuracy 0.01] 
                        [0.5 crackle warp {turbulence 0.5} scale 0.3 scale 0.02 bump_size 0]
                }
        } 
}

#declare T_Haut =
texture {
        gradient y 
        texture_map {
                [0.0 T_temp]
                [0.9 T_temp]
                [0.9 pigment {Clear}]
        } 
        warp {turbulence 2}
        warp {repeat x*20}
        warp {turbulence 2}
}

#declare T_Auge =
texture {
        gradient y 
        texture_map {
                [0.00 T_temp]
                [0.95 T_temp]
                [0.95 T_Haut]
                [1.20 T_Haut]
        }
}

#declare T1 =
material {
        texture {T_Auge}
        interior {ior 1.51}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 283) /////////////////////////////////////////////////////////////////////////////////////

// pattern by Samuel T. Benge  Randomized orientation of pattern instances  http://news.povray.org/povray.text.scene-files/thread/%3C4d757023%40news.povray.org%3E/  

#ifndef (RPI_FCells)
        #declare RPI_FCells =
        function {
                pattern {
                        cells
                        translate (x+y+z)*0.5
                        warp {planar}
                }
        } 
#end

// transform a pigment
#macro RPI_PTransform (Pigment, TwistAmt, ScaleAmt, FadeAmt)

#local Function = function {pattern {pigment_pattern {Pigment}}}
function {
        Function (
                #if (TwistAmt = 0)
                        x
                #else
                        (x*cos (z*2*pi*TwistAmt)-y*sin (z*2*pi*TwistAmt))
                #end
                #if (ScaleAmt != 0)
                        *(1+abs (RPI_FBands (z*64)-0.5)*2*ScaleAmt)
                #end
                ,
                #if (TwistAmt = 0) 
                        y
                #else
                        (x*sin (z*2*pi*TwistAmt)+y*cos (z*2*pi*TwistAmt))
                #end
                #if (ScaleAmt != 0)
                        *(1+abs (RPI_FBands (z*64)-0.5)*2*ScaleAmt)
                #end
                ,
                z
        )
        #if (FadeAmt != 0)
                *(1-abs (RPI_FBands (z*480+(1+sqrt (5))/2 )-0.5)*2*FadeAmt)
        #end
}

#end

// A default pigment
#declare RPI_DefaultPigment =
pigment {
        pigment_pattern {
                cylindrical rotate x*90
        }
        pigment_map {
                [0      rgb 0]
                [1      spiral1 1
                        scale 0.75
                        scallop_wave
                        pigment_map {
                                [0      rgb 0]
                                [1      spiral1 8
                                        scale 0.15
                                        scallop_wave
                                        color_map {
                                                [0      rgb 0.75]
                                                [1      rgb 1]
                                        }
                                ]
                        }
                ]
        }
}

// a ramp wave function
#declare RPI_FBands = function (Dir) {select (-Dir, mod (Dir,1),1-mod (-Dir,1))}

// core function macro - it will be called 9 times in RPI()
#macro RPI_FunctionOffset (xo, yo)

RPI_Func (
        (RPI_FBands (x+0.5)-1+xo+RPI_FCells (x-xo-4,y-yo+11,0)),
        (RPI_FBands (y+0.5)-1+yo+RPI_FCells (x-xo+13,y-yo-27,0)),
        (z+RPI_FCells (x-xo+13,y-yo+59,0))
)

#end

// main macro for generating the pattern
#macro RPI (Pigment)
 
// pigment->function conversion
#local RPI_Func = function {pattern {pigment_pattern {Pigment}}}
 
// This, mostly, is the reason why it's so slow.
function {
        max (
                RPI_FunctionOffset (0,  0),
                RPI_FunctionOffset (-1, 0),
                RPI_FunctionOffset (1,  0),
                RPI_FunctionOffset (0, -1),
                RPI_FunctionOffset (0,  1),
                RPI_FunctionOffset (-1,-1),
                RPI_FunctionOffset (1, -1),
                RPI_FunctionOffset (-1, 1),
                RPI_FunctionOffset (1,  1)
        )
}
 
#end

// combines a series of PNG images into one gradient z pattern
#macro RPI_CompileImages (ImageBaseName, NImages)
 
// calculate zeros for the image name
#local ZeroPadding = log (NImages)/log (10)+1;

pigment_pattern {
        gradient z
        pigment_map {
                #local V = 0;
                #while (V < NImages)
                        #local IMG =
                        pigment {
                                image_map {
                                        png concat (ImageBaseName,str(V+1,-ZeroPadding,0),".png")
                                        interpolate 2
                                }
                                translate -(x+y)*0.5
                                scale 2
                        }
                        [V/NImages            IMG]
                        [V/NImages+1/NImages  IMG]
                        #local V = V+1;
                #end
        }
}
 
#end

#declare pigfunc = 
function {
        pigment {     
                RPI ( 
                        pigment {
                                pigment_pattern {
                                        cylindrical
                                        rotate x*90
                                }
                                pigment_map {
                                        [0      rgb 0]
                                        [1      RPI_PTransform (  
                                                        pigment {
                                                                RPI_CompileImages ( 
                                                                        "HF-leaves",
                                                                        7      
                                                                )
                                                        },
                                                        10,
                                                        0,
                                                        0
                                                )      
                                        ]
                                } 
                        }
                ) 
        }
}

#declare T1 =
material {
        texture {
                pigment {       // calling the RPI macro
                        RPI (   // an encasing pigment to avoid artifacts
                                pigment {
                                        pigment_pattern {
                                                cylindrical
                                                rotate x*90
                                        }
                                        pigment_map {
                                                [0      rgb 0]
                                                [1      RPI_PTransform (  // transforming the pigment for random rotation
                                                                pigment {
                                                                        RPI_CompileImages ( // base name of the images to look for
                                                                                "HF-leaves",
                                                                                7       // number of images to use
                                                                        )
                                                                },
                                                                10,
                                                                0,
                                                                0
                                                        )       
                                                ]
                                        } 
                                } 
                        ) 
                }
                normal {function {pigfunc (x,y,z).x} bump_size 1}
                finish {diffuse 0.7 reflection {0, <0.6,0.3,0> fresnel on} conserve_energy}
        }
        interior {ior 1.35}
        scale 0.2
} 

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 284) /////////////////////////////////////////////////////////////////////////////////////

// Mark James Lewin  Julia Wallpaper  http://news.povray.org/povray.binaries.images/message/%3C3D17F4F3.8010608%40yahoo.com.au%3E/#%3C3D17F4F3.8010608%40yahoo.com.au%3E

#declare T1 =
material {
        texture {
                pigment {rgb <0.5,0.5,0.56>}
                finish {
                        diffuse 0.85*0.5
                        brilliance 2.8
                        specular 0.8
                        roughness 0.05
                        metallic
                        reflection {0.75 metallic}
                }
        }
        interior {ior 2}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 285) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  ukrainian_folk_dance  http://news.povray.org/povray.binaries.scene-files/message/%3C40309b71%40news.povray.org%3E/#%3C40309b71%40news.povray.org%3E

#declare radio = 0;
#declare envir = 0;

#include "colors"
#declare r = seed (83503847);
#declare i = 0;
#while (i < 0.999)
        light_source{       
                -50*z+x*10*2, rgb CHSV2RGB (<i*360,0.9,0.7>)//*0.28
                parallel
                rotate z*i*360
        }
        #declare i = i+1/7;
#end

#declare T1 =
material {
        texture {
                pigment {rgb <0.83,0.82,0.84>}
                finish {diffuse 0 ambient 0 specular 0.05 roughness 0.02 phong 1 brilliance 9 phong_size 120 reflection {1,1}}
                normal {bumps 0.04 noise_generator 3 rotate 60 scale 10}
        }
        interior {ior 1.5}
        scale 0.2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 286) /////////////////////////////////////////////////////////////////////////////////////

// Xilo Musimene  Brushed Metal  http://news.povray.org/povray.binaries.images/message/%3C4082c4b8%40news.povray.org%3E/#%3C4082c4b8%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {rgb 1}
                normal {bump_map {png "brushedmetal_sample.png" map_type 0 interpolate 2} scale <5,1,1> bump_size 7}
                finish {diffuse 0.2 ambient 0 reflection 0.6 brilliance 5 specular 0.01 metallic}
        }
        rotate x*45
        interior {ior 2.47}
        scale 0.2
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 287) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  SSLT settings/issue  http://news.povray.org/povray.binaries.images/message/%3Cweb.538caf5f75a2cf57facb37460%40news.povray.org%3E/#%3Cweb.538caf5f75a2cf57facb37460%40news.povray.org%3E

#declare antcolor =      < 87,64,50>/255*6;
#declare antcolorLight = <181,86,37>/255*1.8;

#declare T1 =
material {
        texture {
                gradient y
                scale 2
                turbulence 0.025
                translate <0,0.075,0>
                omega 0.7
                lambda 2.8
                triangle_wave
                texture_map {
                        [0.45   pigment {
                                        granite  
                                        triangle_wave 
                                        color_map {
                                                [0.0 rgb antcolorLight*0.8] 
                                                [0.0 rgb antcolorLight*0.2] 
                                                [1.0 rgb antcolorLight*0.7] 
                                        } 
                                        turbulence 0.2 
                                        omega 0.65 
                                        lambda 3.2 
                                        scale 0.1 
                                }
                                finish {
                                        specular albedo 0.1 
                                        roughness 0.0015 
                                        diffuse albedo 0.6,0.2 
                                        brilliance 0.9 
                                        reflection {0.005, 0.025 fresnel on} 
                                        conserve_energy
                                        subsurface {translucency <0.4,0.6,0.1>*9*0.1}
                                }
                                normal {
                                        granite 0.2 
                                        scallop_wave 
                                        scale 0.007 
                                        turbulence 0.3 
                                        omega 0.7 
                                }
                        ]
                        [0.6    pigment {
                                        granite 
                                        triangle_wave  
                                        color_map {
                                                [0.0 rgb antcolor*0.2] 
                                                [1.0 rgb antcolor*0.1] 
                                        } 
                                        turbulence 0.5 
                                        omega 0.8 
                                        lambda 2.5 
                                        scale 0.1 
                                }
                                finish {
                                        specular albedo 0.1 
                                        roughness 0.0015  
                                        diffuse albedo 0.5,0.1 
                                        brilliance 1.2 
                                        reflection {0.005, 0.035 fresnel on} 
                                        conserve_energy
                                        subsurface {translucency Ga (<0.4,0.6,0.1>*2)*0.1}
                                }
                                normal {
                                        granite 0.2 
                                        scallop_wave 
                                        scale 0.007 
                                        turbulence 0.3 
                                        omega 0.7
                                }

                        ]
                }
                scale <0.35,1,2>*2.2
        }
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 288) /////////////////////////////////////////////////////////////////////////////////////

// FractRacer  Fake glow  http://news.povray.org/povray.text.scene-files/attachment/%3C530ae02e%40news.povray.org%3E/windows-1252

#declare envir = 0;
#declare matra = 255;

#declare P1 = pigment {rgbt <1,1,1,1>}

#declare I1 = 
interior {
        ior 1.5
	media {
		emission 1
		density {
			agate scale 0.5//cylindrical
			turbulence 0.321
			density_map {
				[0.0 rgb 0]
				[0.4 rgb <0,0,1>]
				[0.8 rgb <0,1,1>]
				[1.0 rgb 1]
			}
		}
	}
}

#declare T1 =
material {
        texture {pigment {P1}}
        interior {I1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 289) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/ 

#declare T1 =
material {
        texture {
                pigment {
                        wrinkles 
                        omega 0.75 
                        triangle_wave 
                        color_map {
                                [0.0 rgbt Gat (<0.10+0.050, 0.3+0.1, 0.1+0.05, 0.12>)] 
                                [0.3 rgbt Gat (<0.25+0.025, 0.3+0.1, 0.1+0.05, 0.12>)]
                                [0.5 rgbt Gat (<0.35+0.025, 0.0025, 0.025, 0.12>)] 
                                [1.0 rgbt Gat (<0.30+0.025, 0.0025, 0.025, 0.12>)]
                        } 
                        scale 0.1 
                }
                finish {
                        diffuse albedo 0.5, 0.2 
                        specular 0.1 
                        roughness 0.05 
                        brilliance 0.8  
                        reflection {0.01, 0.2 fresnel on} 
                        conserve_energy 
                        subsurface {translucency <3,1.59,1.79>*5*0.01}
                }
                normal {granite 0.2 scale 0.0005}
        }  
        interior {ior 1.4} 
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 290) /////////////////////////////////////////////////////////////////////////////////////

// Tekno Frannansa  warning: unpleasant abstract gore effect!  http://news.povray.org/povray.binaries.images/message/%3C439b6cb8%40news.povray.org%3E/#%3C439b6cb8%40news.povray.org%3E

#declare T1 =
material {
        texture {
                pigment {
                        granite 
                        scale 0.1 
                        color_map {
                                [0 rgb <0.3,0.001,0.001>]
                                [1 rgb <0.1,0.001,0.05>]
                        }
                }
                finish {diffuse 1 reflection {0.05, 0.5 falloff 5} specular 1 roughness 0.001}
                normal {agate turbulence 0.2 omega 0.6 lambda 1.7 octaves 10 scale 0.2 accuracy 0.0025}
        }        
        interior {ior 1.35}
        scale 5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 291) /////////////////////////////////////////////////////////////////////////////////////

// Alain  Texture finish for seawater?  http://news.povray.org/povray.advanced-users/message/%3C525dcf33%40news.povray.org%3E/#%3C525dcf33%40news.povray.org%3E

#declare T1 =
material {
        texture {
	        pigment {rgbt 1}
	        finish {
	                ambient 0
	                diffuse 0.15
	                reflection {1 fresnel}
	                conserve_energy
	                specular 1 
                        roughness 0.001
	        }
	}
	interior {
		ior 1.34
		dispersion 1.02
		fade_color rgb <0.7,0.8,0.95>
		fade_distance 50 
		fade_power 1 // or 1001
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 292) /////////////////////////////////////////////////////////////////////////////////////

// Alex Kluchikov  Pacmans  http://news.povray.org/povray.text.scene-files/message/%3Cweb.431dd9a734c2120f32f38e650%40news.povray.org%3E/#%3Cweb.431dd9a734c2120f32f38e650%40news.povray.org%3E

#declare sm1 =
slope_map {
        [0.00, <0,  1.0>]
        [0.02, <1,  0.5>]
        [0.98, <1, -0.5>]
        [1.00, <0, -1.0>]
}
   
#declare T1 =
material {       
        texture {
                pigment {rgb <0.8,0.85,1>}
                finish {
                        diffuse 0.85*0.4 
                        ambient 0 
                        specular 0.8 
                        roughness 0.03 
                        phong 1.0 
                        brilliance 7.3 
                        phong_size 80  
                        metallic 0.5 
                        reflection {0.6-0.2,1.0 metallic}
                }
                normal {
                        average 
                        normal_map {
                                [1,     gradient x slope_map {sm1}]
                                [1,     gradient y slope_map {sm1}]
                        }
                }     
        }
        interior {ior 2.47}
        scale 0.25
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 293) /////////////////////////////////////////////////////////////////////////////////////

// Tor Olav Kristensen  Droid w/ Scooter  http://news.povray.org/povray.binaries.images/message/%3C39294E16.7B9F4C55%40online.no%3E/#%3C39294E16.7B9F4C55%40online.no%3E

#declare T1 =
material {
        texture {
                normal {
                        granite
                        turbulence 1/21
                        frequency 1
                        octaves 2
                        omega 0.2
                        lambda 0.1
                }
                pigment {
                        granite
                        color_map {
                                [0.0 color Black]
                                [0.5 color Red/1.5]
                                [1.0 color Yellow]
                        }
                        turbulence 1/21
                        frequency 1
                        octaves 2
                        omega 0.2
                        lambda 0.1
                }
                finish {
                        specular 0.1
                }
        }
        interior {ior 1.35}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 294) /////////////////////////////////////////////////////////////////////////////////////

// Tor Olav Kristensen  Riemann_Sphere-Isosurface  http://home.online.no/~t-o-k/POV-Ray/Riemann_Sphere-Isosurface.txt

#declare T1 =
material {
        texture {
                pigment {
                        crackle solid
                        color_map {
                                [0 rgb 0.5]
                                [1 rgb 0.9]
                        }
                }
                normal {
                        granite 0.9
                        scale 3
                }
                finish {
                        ambient 0
                        diffuse 0.8-0.3
                        specular 0.1*2
                        roughness 0.1*0.5
                        metallic
                        brilliance 1
                }
        }
        interior {ior 1.5}
        scale 0.13
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 295) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  Wooden Head textures  http://news.povray.org/povray.text.scene-files/message/%3C392C9374.D1513ED6%40aol.com%3E/#%3C392C9374.D1513ED6%40aol.com%3E

#declare Wood =
function {
        pigment {
                function {((x*x+z*z)*0.125)+f_noise3d (x,y,z)*0.25} 
                scale 0.35
                rotate <2,0,7> 
                turbulence 0.1
                pigment_map {
                        [0.5    rgb 0.85]
                        [0.7    function {f_noise3d (x*5,y*0.25,z*5)*4} 
                                color_map {
                                        [0.3    rgb <1,0.95,0.55>]
                                        [1.0    rgb <1,0.95,0.55>*0.75]
                                }
                        ]
                        [0.8    rgb 1]
                }
        }
}

#declare T1 =
material {
        texture {
                function {((x*x+z*z)*0.125)+f_noise3d (x,y,z)*0.25} 
                scale 0.35 
                rotate <2,0,7> 
                translate z*2 
                turbulence 0.1
                texture_map {
                        [0      pigment {
                                        bumps 
                                        scale <0.2,5,0.5> 
                                        pigment_map {
                                                [0.7    function {f_noise3d (x*5,y*0.25,z*5)*4} 
                                                        color_map {
                                                                [0.3    rgb <1,0.8*0.95,0.8*0.55-0.15>*0.9]
                                                                [1.0    rgb <1,0.8*0.95,0.8*0.55>*0.9*0.9]
                                                        }
                                                ]
                                                [0.9    rgb <1,0.9*0.95-0.2,0.8*0.55-0.2>*0.2]
                                        }
                                }
                                //normal {function {f_noise3d (x*5,y*0.25,z*5)*4} bump_size -0.2}
                                normal {function {Wood (x,y,z).gray} bump_size -0.3}
                        ]
                        [0.7    pigment {
                                        function {f_noise3d (x*5,y*0.25,z*5)*4} 
                                        color_map {
                                                [0.3    rgb <1,0.8*0.95-0.05,0.8*0.55-0.05>*0.8*0.9]
                                                [1.0    rgb <1,0.8*0.95-0.1,0.8*0.55-0.1>*0.65*0.9]
                                        }
                                } 
                                normal {function {Wood (x,y,z).gray} bump_size 0.3}
                        ]
                        [0.8    pigment {rgb <1,0.9*0.95-0.15,0.8*0.55-0.15>*0.75*0.9} 
                                //normal {function {f_noise3d (x*5,y*0.25,z*5)*4} bump_size -0.1}
                                normal {function {Wood (x,y,z).gray} bump_size 0.3}
                                finish {specular 0.35 roughness 0.04}
                        ]
                }
        }
        interior {ior 1.4}
        scale 0.7
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 296) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  Wooden Head textures  http://news.povray.org/povray.text.scene-files/message/%3C392C9374.D1513ED6%40aol.com%3E/#%3C392C9374.D1513ED6%40aol.com%3E

#declare T1 =
material {
        texture {
                function {f_noise3d (x,y,z)}
                turbulence 0.1
                texture_map {
                        [0.00   pigment {rgb 0.85}
                                normal {function {pow (f_noise3d (x,y,z),3)*-30} scale 0.00625}
                        ]
                        [0.25   pigment {
                                        granite 
                                        scale 0.1 
                                        color_map {
                                                [0 rgb 1.0]
                                                [1 rgb 0.5]
                                        }
                                }
                                normal {granite scale 0.1}
                        ]
                        [0.50   pigment {rgb <1,1,0.9>}
                                normal {granite scale 0.1}
                        ]
                        [0.75   pigment {rgb <0.6,0.6,0.55>}
                                normal {function {pow (f_noise3d (x,y,z),3)*30} scale 0.00625}
                        ]
                        [1.00   pigment {rgb <0.8,0.8,0.75>}                                
                                normal {function {pow (f_noise3d (x,y,z),3)*30} scale 0.00625}
                        ]
                }
        }
        interior {ior 1.4}
        scale 1.4
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 297) /////////////////////////////////////////////////////////////////////////////////////

// Nathan O'Brien  13oldtek  source sent by author  

// textures for the in shore rocks

#declare ARocks_Tex1a =
texture {pigment {rgb 0}}
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                        [0.00     rgb  <0.024, 0.012, 0.012>]
                        [0.03     rgbf <0.851, 0.812, 0.737, 0.231>]
                        [0.34     rgbf <0.788, 0.690, 0.686, 0.835>]
                        [0.46     rgbf <0.627, 0.506, 0.471, 0.608>]
                        [0.63     rgbf <0.851, 0.812, 0.737, 0.922>]
                        [0.98     rgbf <0.643, 0.655, 0.655, 0.278>]
                        [1.00     rgb  <0.024, 0.012, 0.012>]
                }
        }
        rotate <0,0,50>
        scale <1.5,3,1>*0.1
}
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                        [0.00     rgbf <0.827, 0.627, 0.569, 0.443>]
                        [0.18     rgbf <0.922, 0.827, 0.714, 0.675>]
                        [0.36     rgbf <0.871, 0.702, 0.659, 0.475>]
                        [0.52     rgbf <0.988, 0.922, 0.659, 0.918>]
                        [0.73     rgbf <0.902, 0.812, 0.714, 0.655>]
                        [1.00     rgbf <0.827, 0.627, 0.569, 0.443>]
                }                   
        }
        rotate <0,0,-50>
        scale <0.5,1,0.5>*0.1 
        finish {phong 0.5 reflection 0.1 ambient 0 diffuse 0.5} 
        normal {crackle 0.4 scallop_wave turbulence 0.5 scale 0.2}
}

#declare ARocks_Tex1b =
texture {pigment {rgb 0}}
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                        [0.00     rgb  <0.024, 0.012, 0.012>]
                        [0.03     rgbf <0.851, 0.812, 0.737, 0.231>]
                        [0.34     rgbf <0.788, 0.690, 0.686, 0.835>]
                        [0.46     rgbf <0.627, 0.506, 0.471, 0.608>]
                        [0.63     rgbf <0.851, 0.812, 0.737, 0.922>]
                        [0.98     rgbf <0.643, 0.655, 0.655, 0.278>]
                        [1.00     rgb  <0.024, 0.012, 0.012>]
                }
        }
        rotate <0,0,50>
        scale <1.5,3,1>*0.1
}
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                        [0.00     rgbf <0.827, 0.627, 0.569, 0.443>]
                        [0.18     rgbf <0.922, 0.827, 0.714, 0.675>]
                        [0.36     rgbf <0.871, 0.702, 0.659, 0.475>]
                        [0.52     rgbf <0.988, 0.922, 0.659, 0.918>]
                        [0.73     rgbf <0.902, 0.812, 0.714, 0.655>]
                        [1.00     rgbf <0.827, 0.627, 0.569, 0.443>]
                }
        }
        rotate <0,0,-50>
        scale <0.5,1,0.5>*0.1 
        finish {phong 0.25 ambient 0 diffuse 0.5}
        normal {crackle 0.4 scallop_wave turbulence 0.5 scale 0.2}
} 

#declare ARocks_Tex1 =
texture {
	gradient y
        scale 6.6
	texture_map {
		[0.00   ARocks_Tex1a]  
		[0.05   ARocks_Tex1a]
		[0.10   ARocks_Tex1b]
		[1.00   ARocks_Tex1b]
	}
}

#declare T1 =
material {
        texture {ARocks_Tex1}
        interior {ior 1.5}
        scale 1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 298) /////////////////////////////////////////////////////////////////////////////////////

// Samuel T. Benge  simulated_technology  http://news.povray.org/povray.binaries.scene-files/message/%3C40535FE1.7060603%40hotmail.com%3E/#%3C40535FE1.7060603%40hotmail.com%3E

#declare strands_Y =
pigment {
        cylindrical
        //boxed 
        scale <1,10,1> 
        scale 0.75 
        translate 0.5 
        warp {repeat x} 
        warp {repeat z}
        frequency 3 sine_wave
}

#declare strands_X =
pigment {
        cylindrical
        //boxed 
        scale <1,10,1> 
        rotate z*90 
        scale 0.75 
        translate 0.5 
        warp {repeat y} 
        warp {repeat z}
        frequency 3 sine_wave
 }

#declare strands_Z =
pigment {
        cylindrical
        //boxed 
        scale <1,10,1> 
        rotate x*90 
        scale 0.75 
        translate 0.5 
        warp {repeat x} 
        warp {repeat y}
        frequency 3 sine_wave
}

#declare rbbd =
function {
        pigment {
                pigment_pattern {cells scale 2}
                scale 2
                pigment_map {  
                        [1/3 strands_Y]
                        [1/3 strands_X]
                        [2/3 strands_X]  
                        [2/3 strands_Z]   
                }  
        }
} 

#local T1 =
material { 
        texture {
                pigment {
                        function {rbbd (x,y,z).x}
                        color_map {
                                [1/3    rgb <0.2,0.35,0.55>]
                                [1/3    rgb <1,1,0.9>]
                                [2/3    rgb <1,1,0.9>]
                                [2/3    rgb <0.55,0.2,0.35>]
                        }               
                }
                normal {function {rbbd (x,y,z).x} 1}
                finish {diffuse 0.4 specular 0.3 roughness 0.08 metallic reflection {0.25 metallic}}
        }
        interior {ior 1.5}
        scale 0.0625
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 299) /////////////////////////////////////////////////////////////////////////////////////

// nemesis  glossy metallic reflection  http://news.povray.org/povray.binaries.images/message/%3Cweb.454f674dce679533976a8750%40news.povray.org%3E/#%3Cweb.454f674dce679533976a8750%40news.povray.org%3E

#declare f_reflective_metal = 
finish {
        ambient 0 
        diffuse 0.2
        specular 1.5 
        roughness 0.02 
        brilliance 2
        reflection {0.6 metallic 1} 
        metallic
}

#local p_jvp_micro2 =
pigment {
        crackle turbulence 1
        color_map{
                [0.00   rgb 0.7]
                [0.01   rgb 0.7]
                [0.02   rgb 1]
                [1.00   rgb 1]
        }
        scale 5
}

#local p_jvp_micro1 =
pigment {
        cells
        turbulence 0.5
        color_map {
                [0.0 rgb 0.9]
                [1.0 rgb 1.0]
        }
        scale 0.01
}

#local p_jvp_brushed_new =
pigment {
        average turbulence 0
        pigment_map {
                [0.0    p_jvp_micro1]
                [0.1    p_jvp_micro1 rotate 45*x]
                [0.2    p_jvp_micro1 rotate -45*x]
                [0.3    p_jvp_micro2]
                [0.4    p_jvp_micro1 rotate 45*y]
                [0.5    p_jvp_micro1 rotate -45*y]
                [0.6    p_jvp_micro1 rotate 90*z]
                [0.7    p_jvp_micro2 rotate 45]
                [0.8    p_jvp_micro1 rotate 45*z]
                [0.9    p_jvp_micro1 rotate 90*y]
                [1.0    p_jvp_micro1 rotate -45*z]
        }
        scale 0.1
}

#declare n_jvp_micronormals = normal {pigment_pattern {p_jvp_brushed_new} 0.4}

#declare t_jvp_micronormal_glossy_metal = 
texture {
        pigment {rgb 0.7}
        normal {n_jvp_micronormals}
        finish {f_reflective_metal}
}

#local T1 =
material {
        texture {t_jvp_micronormal_glossy_metal scale 0.04}
        interior {ior 1.5}
        scale 0.25
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 300) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/ 

#declare T1 =
material {
        texture {
                pigment {
                        wrinkles          
                        triangle_wave
                        turbulence 0.6
                        omega 0.85
                        lambda 3.5
                        color_map { 
                                [0.00 rgb Ga (<0.7, 0.69, 0.326>*0.375)]
                                [0.25 rgb Ga (<0.7, 0.6, 0.3>*0.25)]
                                [0.45 rgb Ga (<0.65, 0.6, 0.36>*0.375)]
                                [0.75 rgb Ga (<0.7, 0.64, 0.229>*0.25)]
                                [1.00 rgb Ga (<0.7, 0.625, 0.3>*0.375)]               
                        }  
                        scale <0.75,1.2,0.5>
                }                
        }
        texture {
                pigment {
                        ripples          
                        scallop_wave
                        turbulence 0.55
                        omega 0.6
                        lambda 4.5
                        color_map {
                                [0.00 rgbt <1, 1, 1, 1>]
                                [0.90 rgbt <1, 1, 1, 1>]
                                [0.90 rgbt Gat (<0.2, 0.170, 0.12, 1>)]
                                [0.92 rgbt Gat (<0.2, 0.170, 0.12, 0.3>)]
                                [0.94 rgbt Gat (<0.1, 0.072, 0.05, 0.2>)]
                                [0.99 rgbt Gat (<0.1, 0.072, 0.05, 1>)]
                                [0.99 rgbt <1, 1, 1, 1>]
                                [1.00 rgbt <1, 1, 1, 1>]
                
                        }
                        scale <0.25,0.6,0.15>*1.5
                }
                finish {             
                        diffuse albedo 0.3 
                        brilliance 3
                        specular 0.4 
                        roughness 0.002
                        phong 0.1         
                        phong_size 90         
                        reflection {0.01, 0.5 fresnel on} 
                        conserve_energy
                }
        }    
        interior {ior 1.6}  
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 301) /////////////////////////////////////////////////////////////////////////////////////

// normal definition by Robert W. McGregor  ...thanks for all the fish  http://news.povray.org/povray.binaries.images/message/%3Cweb.4951bf16a9fdfb46bd1b3ad10%40news.povray.org%3E/#%3Cweb.4951bf16a9fdfb46bd1b3ad10%40news.povray.org%3E
// water material by Jaimes Vives Piqueres  Amazonas  http://www.ignorancia.org/uploads/zips/amazonas.zip

#declare radio  = 0;

#declare Bigripple =
normal {
        waves 1
        frequency 6
        turbulence 0.8
        scale <0.5,0.2,0.2>*0.5
        translate -100*z
        rotate -30*y
}
#declare Smallripple =
normal {
        ripples 1
        frequency 3
        turbulence 0.5
        scale <0.35,0.25,0.25>*0.2
        translate 100*z
        rotate -10*z
}

#declare RippleNorm =
normal {
        average
        normal_map {
                [0.8    Smallripple]
                [0.9    Bigripple]  
        }
}

#declare N_Ripples =
normal {
        average
        normal_map {
                [1      RippleNorm scale 1]
                [1      RippleNorm scale 0.33]
                [1      RippleNorm scale 0.10]
                [0.5    RippleNorm scale 0.05]
                [0.25   granite 0.1 scale 0.01]
                [0.125  granite 0.05 scale 0.001]
        }
}

#declare T1 =
material {
        texture {
                pigment {rgbt 1}
                finish {
                        diffuse 0
                        ambient 0
                        reflection {0.02, 0.99 fresnel on} 
                        conserve_energy 
                        specular 0.4 
                        roughness 0.0035
                }
                normal {N_Ripples}
        }
        interior {
                ior 1.33        
                fade_distance 0.1 
                fade_power 1001 
                fade_color (Orange*0.75+Yellow*0.25+Gray10)*0.1
                media {scattering {3, (Orange*0.75+Yellow*0.25+Gray10)*10}}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 302) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/ 

#declare T1 = 
material {
        texture {
                pigment {
                        agate 
                        agate_turb 0.4  omega 0.7 lambda 1.5
                        color_map {
                                [0.0 rgb Ga (<0.9, 0.875, 0.85>)]  
                                [0.5 rgb 1]  
                                [1.0 rgb Ga (<0.8, 0.775, 0.425>)]  
                        } 
                        translate <0.5,0.5,0.5>
                        scale 0.1+0.1
                } 
        }
        texture {
                pigment {
                        granite 
                        turbulence 0.4 omega 0.7
                        color_map {
                                [0.0     rgbt Gat (<0.9, 0.875, 0.82, 0.90>)]  
                                [0.5*1.5 rgbt Gat (<0.5, 0.400, 0.30, 0.05>)]  
                        } 
                        translate <0.5,0.5,0.5>
                        scale 0.1+0.15 
                } 
                finish {
                        specular 0.15 
                        roughness 0.05 
                        brilliance 1.8 
                        diffuse albedo 0.55 
                        phong 0.2 
                        phong_size 55  
                        conserve_energy
                }
                normal {agate 0.4+0.15 scale 0.15+0.075}
 
        }    
        interior {ior 1.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 303) /////////////////////////////////////////////////////////////////////////////////////
 
// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare texMetal1 = 
texture {
	pigment {rgb <0.6,0.3,0.15>}
	finish {
		ambient 0.25
		brilliance 4
		diffuse 0.6
		metallic
		specular 0.8
		roughness 0.0125
		reflection 0.2
	}
}

#declare texMetal3 = 
texture {
	pigment {rgb <0.5,0.2,0.1>}
	finish {
		ambient 0
		brilliance 4
		diffuse 0.6
		metallic
		specular 0.8
		roughness 0.0125
		reflection 0.1
	}
}

#declare texMetal4 = 
texture {
	bozo
	texture_map {
		[0.4 texMetal1]
		[0.6 texMetal3]
	}
}

#declare T1 =
material {
        texture {texMetal4}
        interior {ior 1.1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 304) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  starfish  http://news.povray.org/povray.binaries.scene-files/thread/%3Cweb.532727ee860f8d61fd8e1370@news.povray.org%3E/ 

#declare T1 =   
material {  
        texture {
                pigment {
                        wrinkles 
                        triangle_wave 
                        color_map {
                                [0.0    rgb Ga (<0.6, 0.52, 0.01>*(0.25+0.1))] 
                                [1.0    rgb Ga (<0.32, 0.35, 0.1>*(0.25+0.1))] 
                        } 
                        scale 0.15 
                }
                finish {
                        specular  0.2 
                        roughness 0.05 
                        phong 0.05 
                        phong_size 20
                        diffuse albedo 0.5 0.4 
                        brilliance 1.5   
                }  
                normal {
                        average 
                        normal_map {
                                [1 wrinkles 0.5 scale 0.001] 
                                [1 bumps 0.5 scale 0.02]  
                        } 
                }//wrinkles 1 scale 0.001 } // bumps 1 scale 0.02  }
        }   
        texture {
                pigment {
                        granite 
                        triangle_wave 
                        color_map {
                                [0.0      rgbt Gat (<0.06, 0.035, 0.005, 0.01>)] 
                                [0.2+0.05 rgbt Gat (<0.09, 0.050, 0.008, 0.10>)] 
                                [0.6+0.1  rgbt Gat (<0.09, 0.050, 0.003, 1>)] 
                        } 
                        scale 0.5 
                }
                finish {
                        specular 0.01 
                        roughness 0.25
                        diffuse albedo 0.5 0.4 
                        brilliance 0.85 
                        reflection {0.01, 0.35 fresnel on} 
                        conserve_energy  
                } 
                normal {granite 0.1 scale 0.001}
        }   
        interior {ior 2.6}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 305) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare T1 = // dirty paper
material {
        texture {
                pigment {rgb <1,0.97,0.9>} 
                normal {
                        average
                        normal_map {
                                [1 wrinkles 0.3 scale 0.3]
                                [1 quilted 0.5 scale 3 rotate <0,0,45> turbulence 0.2]
                                [1 quilted 0.5 scale 3 rotate <0,0,-40> turbulence 0.2]
                                [1 granite 0.5 scale 0.01]
                        }
                }
                finish {ambient 0 diffuse 0.5 phong 0.1 phong_size 10}
     } 
     texture {
                pigment {
                        wrinkles  
                        omega 0.675
                        lambda 3
                        turbulence 0.6
                        color_map {
                                [0.0 rgbt Gat (<0.1, 0.05, 0, 1>)]
                                [0.4 rgbt Gat (<0.1, 0.05, 0, 0.9>)]
                                [0.5 rgbt Gat (<0.1, 0.05, 0, 1>)]
                                [0.7 rgbt Gat (<0.1, 0.05, 0, 1>)]
                                [0.8 rgbt Gat (<0.1, 0.05, 0, 0.6>)]
                                [1.0 rgbt Gat (<0.1, 0.05, 0, 1>)]
                        }     
                        scale 1.5
                }
                normal {
                        average
                        normal_map {
                                [1 wrinkles 0.3 scale 0.3]
                                [1 quilted 0.5 scale 3 rotate <0,0,45> turbulence 0.2]
                                [1 quilted 0.5 scale 3 rotate <0,0,-40> turbulence 0.2]  
                                [1 granite 0.5 scale 0.01]
                        }
                }
                finish {ambient 0 diffuse 0.5 phong 0.01 phong_size 5}
        }         
        texture {
                pigment {
                        wrinkles
                        cubic_wave   
                        omega 0.675
                        lambda 3
                        turbulence 0.55
                        color_map {
                                [0.0 rgbt Gat (<0.03, 0.02, 0, 1>)]
                                [0.2 rgbt Gat (<0.03, 0.02, 0, 0.7>)]
                                [0.3 rgbt Gat (<0.03, 0.02, 0, 1>)]
                                [0.8 rgbt Gat (<0.03, 0.02, 0, 1>)]
                                [0.9 rgbt Gat (<0.03, 0.02, 0, 0.9>)]
                                [1.0 rgbt Gat (<0.03, 0.02, 0, 1>)]
                        }     
                        scale 0.5
                }
                normal {
                        average
                        normal_map {
                                [1 wrinkles 0.3 scale 0.3]
                                [1 quilted 0.5 scale 3 rotate <0,0,45> turbulence 0.2]
                                [1 quilted 0.5 scale 3 rotate <0,0,-40> turbulence 0.2]
                                [1 granite 0.5 scale 0.01]
                        }
                }
                finish {ambient 0 diffuse 0.5 phong 0.01 phong_size 5}
        }         
        interior {ior 1.4}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 306) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare brushedChrome = 
texture {
        pigment {rgb <0.5,0.5,0.5>}
        finish {ambient 0 brilliance 8 diffuse 0.4*1.5 specular 0.5 roughness 0.06 metallic reflection {0.1, 0.5 fresnel on metallic} conserve_energy}
        normal {marble 0.0075 rotate <0,0,90> scale <1,0.05,1>}
}  
texture {// add some marks/small scratches
        pigment {
                granite
                scallop_wave
                turbulence 0.5
                omega 0.8
                color_map {
                        [0.000 rgbt 1]
                        [0.075 rgbt 1]
                        [0.075 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt 1]
                        [0.200 rgbt 1]
                        [0.200 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt 1]
                        [1.000 rgbt 1]
                }
                scale 5
        }
        finish {ambient 0 diffuse 0.6*1.5 metallic brilliance 4}  
} 
texture {// add some marks/small scratches
        pigment {
                granite
                scallop_wave
                turbulence 0.75
                omega 0.8
                color_map {
                        [0.000 rgbt 1]
                        [0.075 rgbt 1]
                        [0.075 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt 1]
                        [0.200 rgbt 1]
                        [0.200 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt 1]
                        [1.000 rgbt 1]
                }
                scale 15
        }
        finish {ambient 0 diffuse 0.8*1.5 metallic brilliance 4}
}   
texture {// add some marks/small scratches
        pigment {
                granite
                scallop_wave
                turbulence 0.725
                omega 0.8
                color_map {
                        [0.000 rgbt 1]
                        [0.075 rgbt 1]
                        [0.075 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt Gat (<0.3, 0.3, 0.3, 0.075>)]
                        [0.150 rgbt 1]
                        [0.200 rgbt 1]
                        [0.200 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt Gat (<0.2, 0.2, 0.2, 0.025>)]
                        [0.250 rgbt 1]
                        [1.000 rgbt 1]
                }
                scale 10                                              
                rotate <5,20,55>
        }
        finish {ambient 0 diffuse 0.8*1.5 metallic brilliance 4}        
}

#declare T1 =
material {
        texture {brushedChrome}
        interior {ior 2.43}
        scale 0.1
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 307) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare TConcrete = 
texture {
        pigment {
                crackle 
                color_map {
                        [0    rgb <0.80,0.6,0.40>]
                        [0.25 rgb <0.80,0.8,0.65>]
                        [0.5  rgb 1]
                        [0.75 rgb <0.99,0.9,0.7>]
                        [1    rgb <0.99,0.8,0.6>]
                }
                scale 0.125
                solid
        }                                                         
        normal {granite 1 scale 0.0125}
        finish {ambient 0 diffuse 0.55 brilliance 3}
}
texture {
        pigment {
                crackle 
                color_map {
                        [0.00 rgb 1]
                        [0.25 rgb <0.80,0.9,0.5>]
                        [0.50 rgb 1]
                        [0.75 rgb <0.99,0.9,0.7>]
                        [1.00 rgb 1]
                }
                scale 0.0375
                solid
        }  
        normal {
                bozo 
                normal_map {
                        [0.0 bozo 0.2 scale  2]
                        [0.2 bozo 0.8 scale  6]
                        [0.9 bozo 1.0 scale  1]
                        [1.0 bozo 0.4 scale 12]
                }
                turbulence 0.3
                scale 0.05
        }
        finish {specular 0.0625 ambient 0 diffuse 0.6 crand 0.125 brilliance 2} 
}
texture {
        pigment {
                average
                pigment_map {
                        [1.0    gradient y
                                color_map {
                                        [0.000 rgbf 0.80]
                                        [0.875 rgbf 0.70]
                                        [1.000 rgbf 0.40]
                                } 
                        ]
                        [1.0    gradient y
                                color_map {
                                        [0.000 rgbf 0.80]
                                        [0.875 rgbf 0.70]
                                        [1.000 rgbf 0.40]
                                }
                                translate 0.5 
                        ]
                }      
        }
        normal {granite 0.05 scale 0.5}
        finish {specular 0.05 roughness 4 brilliance 0.8}
} 
texture {
        pigment {
                gradient y
                pigment_map {
                        [0.0    rgb 0 transmit 1]
                        [0.1    rgb 0 transmit 1]
                        [1.0    bozo
                                color_map {
                                        [0.0 rgb 0 transmit 1.00]
                                        [0.6 rgb 0 transmit 1.00]
                                        [0.9 rgb 0 transmit 0.75*0.375]
                                        [1.0 rgb 0 transmit 0.50*0.25]
                                }
                                frequency 1.1
                                scale <0.1,1,0.1>
                        ]
                }
                turbulence 0.1*0
        }
        normal {granite 0.05 scale 0.5}
        finish {specular 0.1 roughness 4 brilliance 0.8}
}
texture {
        pigment {
                gradient y
                pigment_map {
                        [0.0    rgb 0 transmit 1]
                        [0.1    rgb 0 transmit 1]
                        [1.0    bozo
                                color_map {
                                        [0.0 rgb 0 transmit 1.00]
                                        [0.6 rgb 0 transmit 1.00]
                                        [0.9 rgb 0 transmit 0.75*0.375]
                                        [1.0 rgb 0 transmit 0.50*0.25]
                                }
                                frequency 1.1
                                scale <0.1,1,0.1> 
                        ]
                } 
                turbulence 0.1*0
                translate 0.5
        }
        normal {granite 0.05 scale 0.5}
        finish {specular 0.1 roughness 4 brilliance 0.8}
}

#declare T1 =
material {
        texture {TConcrete}
        interior {ior 1.5}
        scale 0.5
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 308) /////////////////////////////////////////////////////////////////////////////////////

// Ian Burgmyer  murcy green water  http://news.povray.org/povray.binaries.scene-files/attachment/%3C37d2b715%40news.povray.org%3E/murky_green_water.zip?ttop=334785&toff=1050

#declare radio = 0;

#declare T1 =
material {
        texture {
                pigment {rgbf <0.520833,1,0.677067,0.614567>}
                normal {
                        bozo 0.808
                        bump_size 1.5
                        scale  0.25
                }
                finish {
                        ambient 0
                        reflection 0.280567
                }
        }
        interior {
                ior 1.11
                media {
                        intervals 1 samples 15
                        variance 1/5.317795
                        emission rgb <0.5,1,0.5>*0.2
                        scattering {2, 1 extinction 4}//{2}
                }
                media {absorption rgb <1,0,1>}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 309) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare handleTex = 
texture {
        pigment {
                agate
                turbulence 1
                lambda 5
                color_map {
                        [0 rgb Ga (<0.002,0.001,0>)]
                        [1 rgb Ga (<0.1,0.1,0.1>)]                                               
                }                                  
                scale 0.01
        }
        normal {dents 5 scale 0.01}
        finish {diffuse 0.8 ambient 0 specular 0.6 roughness 0.02 reflection {0.01, 0.08 fresnel on metallic} conserve_energy}
}                         

#declare T1 =
material {
        texture {handleTex}
        interior {ior 1.5}
        scale 0.6
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 310) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare worktopTex1 = 
texture {
        pigment {
                bozo                 
                turbulence 0.475
                omega 0.7
                lambda 4
                color_map {
                        [0.0 rgb Ga (<0.4, 0.16, 0.045>)]
                        [0.2 rgb Ga (<0.25, 0.120, 0.023>)]
                        [0.4 rgb Ga (<0.35, 0.18, 0.05>)]
                        [0.7 rgb Ga (<0.22, 0.1, 0.03>)]
                        [0.85 rgb Ga (<0.25, 0.120, 0.025>)]
                        [1.0 rgb Ga (<0.21, 0.05, 0.001>)]
                }                                  
                scale <5,0.2,0.2>
                rotate <0,1,0>                
                 
        }      
        finish {diffuse 0.8}      
}     
texture {
        pigment {
                wood                 
                turbulence 0.315
                omega 0.65
                lambda 3.5
                color_map {
                        [0.0 rgbt Gat (<0.4, 0.16, 0.045, 0.35>)]
                        [0.2 rgbt Gat (<0.25, 0.119, 0.023, 0.35>)]
                        [0.4 rgbt Gat (<0.35, 0.20, 0.05, 0.35>)]
                        [0.7 rgbt Gat (<0.22, 0.1, 0.03, 0.35>)]
                        [0.85 rgbt Gat (<0.25, 0.120, 0.025, 0.35>)]
                        [1.0 rgbt Gat (<0.22, 0.05, 0.001, 0.35>)]
                }                                  
                rotate <0,90,0>                                 
                scale <1,0.2,0.2>
                rotate <0,0.5,10>                
                 
        }
        finish {diffuse 0.8}      
}     
texture {// varnish
        pigment {
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0.65 
                color_map {
                        [0.0 rgbt Gat (<0.25, 0.1, 0.05, 0.95>)]
                        [0.075 rgbt Gat (<0.225, 0.08, 0.04, 0.9>)]
                        [0.15 rgbt Gat (<0.3, 0.08, 0.03, 0.95>)]
                        [0.2 rgbt Gat (<0.25, 0.05, 0.02, 0.925>)]
                        [0.25 rgbt Gat (<0.25, 0.08, 0.04, 0.95>)]
                        [1.0 rgbt Gat (<0.2, 0.075, 0.04, 0.9>)]
                }               
                scale 10
        }
        finish {diffuse 0.8 ambient 0 phong 0.1 phong_size 40 specular 0.3 roughness 0.008 reflection 0.01*10}     
        normal {
                average
                normal_map {
                        [1 wrinkles 0.05 turbulence 0.1 scale <100,0.01,0.01> rotate <0,0,1>]
                        [1 dents 1 turbulence 0.2 scale <0.5,0.4,0.4>]
                }
        }         
}

#declare worktopTex2 = 
texture {
        pigment {
                bozo                 
                turbulence 0.375
                omega 0.7
                lambda 4
                color_map {
                        [0.0 rgb Ga (<0.4, 0.16, 0.045>*0.8)]
                        [0.2 rgb Ga (<0.25, 0.110, 0.023>*0.8)]
                        [0.4 rgb Ga (<0.35, 0.20, 0.05>*0.8)]
                        [0.7 rgb Ga (<0.22, 0.1, 0.03>*0.8)]
                        [0.85 rgb Ga (<0.25, 0.120, 0.025>*0.8)]
                        [1.0 rgb Ga (<0.22, 0.05, 0.001>*0.8)]
                }                                  
                scale <5,0.2,0.2>
                rotate <0,1,0>                
                 
        }      
        finish {diffuse 0.8}      
}     
texture {
        pigment {
                wood                 
                turbulence 0.135
                omega 0.65
                lambda 3
                color_map {
                        [0.0 rgbt Gat (<0.4*0.8, 0.16*0.8, 0.045*0.9, 0.5>)]
                        [0.2 rgbt Gat (<0.25*0.8, 0.112*0.8, 0.023*0.9, 0.5>)]
                        [0.4 rgbt Gat (<0.35*0.8, 0.20*0.8, 0.05*0.9, 0.5>)]
                        [0.7 rgbt Gat (<0.22*0.8, 0.1*0.8, 0.03*0.9, 0.5>)]
                        [0.85 rgbt Gat (<0.25*0.8, 0.118*0.8, 0.025*0.9, 0.5>)]
                        [1.0 rgbt Gat (<0.22*0.8, 0.05*0.8, 0.001*0.9, 0.5>)]
                }                                  
                rotate <0,90,0>                                 
                scale <1,0.2,0.2>
                rotate <0,0.5,10>                
                 
        }      
        finish {diffuse 0.8}      
}     
texture {// varnish
        pigment {
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0. 
                color_map {
                        [0.0 rgbt Gat (<0.25, 0.1, 0.05, 0.95>)]
                        [0.075 rgbt Gat (<0.225, 0.07, 0.04, 0.9>)]
                        [0.15 rgbt Gat (<0.3, 0.1, 0.05, 0.95>)]
                        [0.2 rgbt Gat (<0.25, 0.05, 0.02, 0.925>)]
                        [0.25 rgbt Gat (<0.25, 0.04, 0.02, 0.95>)]
                        [1.0 rgbt Gat (<0.2, 0.05, 0.03, 0.9>)]
                }               
                scale 10
        }
        finish {diffuse 0.8 ambient 0 phong 0.1 phong_size 40 specular 0.3 roughness 0.008 reflection 0.01*10}     
        normal {
                average
                normal_map {
                        [1 wrinkles 0.05 turbulence 0.1 scale <100, 0.01, 0.01> rotate <0,0,1>]
                        [1 dents 1 turbulence 0.2 scale <0.5,0.4,0.4>]
                }
        }
}  

#declare wt1 = 
texture {
        gradient x
        texture_map {
                [0.0 worktopTex1]
                [0.5 worktopTex1]
                [0.5 worktopTex2]
                [1.0 worktopTex2]                                
        }    
        scale <10,1,1>                      
}                                  

#declare wt2 = 
texture {
        gradient x
        texture_map
        {
                [0.0 worktopTex1]
                [0.5 worktopTex1]
                [0.5 worktopTex2]
                [1.0 worktopTex2]                                
        }                          
        scale <10,1,1>
        translate <2.5,3,5>                      
} 

#declare worktopTex = 
texture {
        gradient z
        texture_map {
                [0.0 wt1]
                [0.5 wt1]
                [0.5 wt2]
                [1.0 wt2]                
        }           
        scale <1,1,1.25>
}

#declare T1 =
material {
        texture {worktopTex}
        rotate x*90
        interior {ior 1.4}
        scale 0.4
} 

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 311) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare cupboardWoodTex = 
texture {
        pigment {
                bozo                 
                turbulence 0.475
                omega 0.7
                lambda 4
                color_map {
                        [0.00 rgb Ga (<0.38, 0.170, 0.040>)]
                        [0.20 rgb Ga (<0.25, 0.125, 0.030>)]
                        [0.40 rgb Ga (<0.34, 0.230, 0.060>)]
                        [0.70 rgb Ga (<0.21, 0.100, 0.030>)]
                        [0.85 rgb Ga (<0.25, 0.132, 0.035>)]
                        [1.00 rgb Ga (<0.20, 0.050, 0.005>)]
                }                                  
                scale <5,0.2,0.2>
                rotate <0,1,0>                
                 
        }      
        finish {diffuse 0.8}      
}     
texture {
        pigment {
                wood                 
                turbulence 0.315
                omega 0.65
                lambda 3.5
                color_map {
                        [0.00 rgbt Gat (<0.40, 0.160, 0.045, 0.35>)]
                        [0.20 rgbt Gat (<0.30, 0.120, 0.023, 0.35>)]
                        [0.40 rgbt Gat (<0.35, 0.190, 0.050, 0.35>)]
                        [0.70 rgbt Gat (<0.20, 0.100, 0.030, 0.35>)]
                        [0.85 rgbt Gat (<0.25, 0.118, 0.025, 0.35>)]
                        [1.00 rgbt Gat (<0.20, 0.050, 0.001, 0.35>)]
                }                                  
                rotate <0,90,0>                                 
                scale <1,0.2,0.2>
                rotate <0,5,0.1>                
                 
        }      
        finish {diffuse 0.8}      
}     
texture {// varnish
        pigment {
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0.65 
                color_map {
                        [0.000 rgbt Gat (<0.275, 0.180, 0.05, 0.950>)]
                        [0.075 rgbt Gat (<0.225, 0.140, 0.02, 0.900>)]
                        [0.150 rgbt Gat (<0.300, 0.180, 0.03, 0.950>)]
                        [0.200 rgbt Gat (<0.250, 0.135, 0.05, 0.925>)]
                        [0.250 rgbt Gat (<0.250, 0.100, 0.03, 0.950>)]
                        [1.000 rgbt Gat (<0.200, 0.125, 0.05, 0.900>)]
                }               
                scale 10
        }
        finish {diffuse 0.8 ambient 0 phong 0.3 phong_size 40 reflection 0.01}     
        normal {
                average 
                normal_map {
                        [1 wrinkles 0.075 turbulence 0.1 scale <100,0.01,0.01> rotate <0,0,1>]
                        [1 dents 1 turbulence 0.2 scale <0.5,0.4,0.4>]
                }
        }
        
}

#declare T1 =
material {
        texture {cupboardWoodTex}
        interior {ior 1.4}
        scale 0.2
} 

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 312) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Royal Scot  http://www.irtc.org/ftp/pub/stills/2006-08-31/oldroyal.zip

#declare radio  = 2;    // to see the full beauty of this material, you need better radiosity settings!

#declare concreteNormal = 
normal {     
        average
        normal_map {     
                [1 granite 1 omega 0.65 lambda 3.3 turbulence 0.125 scale 3.5]
                [1 wrinkles 1 omega 0.62 lambda 2.5 turbulence 0.15 scale 2]
                [1 wrinkles 1 omega 0.7 lambda 3 turbulence 0.25 scale 0.25]
        }
}        

#declare rock_base = 
texture {
        pigment {
                granite 
                triangle_wave 
                omega 0.6 
                lambda 3 
                turbulence 0.275 
                color_map {
                        [ 0.0   rgb Ga (<0.175, 0.175, 0.175>)] 
                        [ 1.0   rgb Ga (<0.425, 0.425, 0.425>)] 
                } 
                scale 0.25 
        }
        finish {ambient 0 diffuse 0.5*2}    
        normal {concreteNormal}
}

#declare land_tex_1 = 
texture { 
        pigment {
                granite            
                turbulence 0.05   
                omega 0.7 lambda 4
                scale <0.25, .25, 0.25>        
                color_map {
                        [ 0.0   rgbt Gat (<0.15, 0.09, 0.015, 0.5>)] 
                        [ 0.4   rgbt Gat (<0.15, 0.09, 0.015, 1>)] 
                        [ 0.4   rgbt 1 ]
                        [ 1.0   rgbt 1 ]
                }
        }
        finish {ambient 0 diffuse 0.45*2 specular 0 phong 0 brilliance 0.9}
        normal {concreteNormal}
}

#declare land_tex_2 = 
texture { 
        pigment {
                wrinkles 
                cubic_wave           
                turbulence 0.225   
                omega 0.7 lambda 4
                scale <0.15, .15, 0.15>        
                color_map {
                        [ 0.0   rgbt Gat (<0.15, 0.09, 0.015, 0.1>)] 
                        [ 0.4   rgbt Gat (<0.15, 0.09, 0.015, 1>)] 
                        [ 0.4   rgbt 1 ]
                        [ 1.0   rgbt 1 ]
                }
        }
        finish {ambient 0 diffuse 0.45*2 specular 0 phong 0 brilliance 0.9}
        normal {concreteNormal }
}

#declare land_tex_3 = 
texture { 
        pigment {
                wrinkles 
                sine_wave           
                turbulence 0.35   
                omega 0.65 lambda 4
                scale 0.05
                color_map {
                        [ 0.0   rgbt 1 ]
                        [ 0.7   rgbt 1 ]
                        [ 0.7   rgbt Gat (<0.15, 0.09, 0.015, 1>)] 
                        [ 1.0   rgbt Gat (<0.15, 0.09, 0.015, 0.3>)] 
                 }
        }
        finish {ambient 0 diffuse 0.45*2 specular 0 phong 0 brilliance 0.9}
        normal {concreteNormal}
}

#declare land_tex_4 = 
texture { 
        pigment {
                bozo 
                scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map {
                        [ 0.0   rgbt 1 ]
                        [ 0.9   rgbt 1 ]
                        [ 0.925 rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.975 rgbt Gat (<0.0075, 0.06, 0.0005, 0.4>)] 
                        [ 1.0   rgbt Gat (<0.0075, 0.06, 0.0005, 0>)] 
                 }
        }
        finish {ambient 0 diffuse 0.45*2 specular 0 phong 0 brilliance 0.9}
        normal {concreteNormal }
}

#declare land_tex_5 = 
texture { 
        pigment {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                scale 0.01
                color_map {
                        [ 0.0   rgbt 1 ]
                        [ 0.1   rgbt 1 ]
                        [ 0.15  rgbt Gat (<0.1, 0.06, 0.01, 1>)] 
                        [ 0.3   rgbt Gat (<0.1, 0.06, 0.01, 0.1>)] 
                        [ 0.45  rgbt Gat (<0.1, 0.06, 0.01, 1>)] 
                        [ 0.5   rgbt 1 ]
                        [ 0.6   rgbt 1 ]
                        [ 0.65  rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.75  rgbt Gat (<0.0075, 0.06, 0.0005, 0.05>)] 
                        [ 0.9   rgbt Gat (<0.0075, 0.06, 0.0005, 1>)] 
                        [ 0.95  rgbt 1 ]
                        [ 1.0   rgbt 1 ]
                 }
        }
        finish {ambient 0 diffuse 0.45*2 specular 0 phong 0 brilliance 1.21}
        normal {concreteNormal}
}

#declare land_tex_6 = 
texture { 
        pigment {
                gradient z            
                turbulence 0.275
                omega 0.626 lambda 3.0 
                scale <10, 5, 1>
                color_map {
                        [ 0.0   rgbt <1, 1, 1, 1> ]
                        [ 0.1   rgbt <1, 1, 1, 1> ]
                        [ 0.1   rgbt Gat (<0.3, 0.25, 0.0125, 1>)]
                        [ 0.25  rgbt Gat (<0.21, 0.155, 0.0055, 0.75>)]
                        [ 0.35  rgbt Gat (<0.175, 0.05, 0.001, 0.3>)]
                        [ 0.4   rgbt Gat (<0.12, 0.04, 0.0003, 0.075>)]
                        [ 0.8   rgbt Gat (<0.075, 0.016, 0.0001, 0.01>)]
                        [ 0.8   rgbt <1, 1, 1, 1> ]
                        [ 1.0   rgbt <1, 1, 1, 1> ]
                 }
        }
        finish {ambient 0 diffuse 0.6*2} 
        normal {concreteNormal}
}

#declare land_tex_dry = 
texture{
        rock_base   
        scale <2, 2, 2>//95>
}      
texture{
        land_tex_1
        scale <2, 2, 2>//95>
}
texture{
        land_tex_2
        scale <2, 2, 2>//95>
}
texture{
        land_tex_3
        scale <2, 2, 2>//95>
}
texture{
        land_tex_4
        scale <2, 2, 2>//95>
}
texture{
        land_tex_5
        scale <2, 2, 2>//95>
} 
texture{
        pigment {
                gradient x   
                turbulence 0.125
                omega 0.775
                lambda 3.2
                color_map {
                        [ 0.0   rgbt <1, 1, 1, 1> ]
                        [ 0.3   rgbt <1, 1, 1, 1> ]
                        [ 0.3   rgbt Gat (<0.02, 0.01, 0, 1>)]
                        [ 0.4   rgbt Gat (<0.02, 0.01, 0, 0.1>)]
                        [ 0.5   rgbt Gat (<0.02, 0.01, 0, 0.1>)]
                        [ 0.6   rgbt Gat (<0.02, 0.01, 0, 0.1>)]
                        [ 0.7   rgbt Gat (<0.02, 0.01, 0, 1>)]
                        [ 0.7   rgbt <1, 1, 1, 1> ]
                        [ 1.0   rgbt <1, 1, 1, 1> ]
                }            
                scale <2,2,200> 
        }
        finish {ambient 0 diffuse 0.4*2 brilliance 0.85}
        normal {concreteNormal }
}
                
#declare wallTex =
texture {
        pigment {
                wrinkles     
                scallop_wave
                color_map {
                        [ 0.0   rgb Ga (<0.86, 0.8, 0.6>)]
                        [ 0.3   rgb Ga (<0.9, 0.825, 0.77>)]
                        [ 0.6   rgb Ga (<0.95, 0.85, 0.8>)]
                        [ 0.7   rgb Ga (<0.8, 0.625, 0.567>)]
                        [ 0.9   rgb Ga (<0.9, 0.825, 0.77>)]
                }        
                
        }
        finish {ambient 0 diffuse 0.6*2}    
        normal {concreteNormal}
}  
texture {// add grease/dirt                       
        pigment {               
                wrinkles   
                scallop_wave
                turbulence 0.31 
                omega 0.65 
                lambda 3                            
                color_map {
                        [ 0.0   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.1   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.15  rgbt Gat (<0.01, 0.002, 0, 1>)]
                        [ 0.20  rgbt Gat (<0.01, 0.002, 0, 0.7>)]
                        [ 0.40  rgbt Gat (<0.01, 0.002, 0, 0.6>)]
                        [ 0.45  rgbt Gat (<0.025, 0.01, 0.001, 0.2>)]
                        [ 0.5   rgbt Gat (<0.01, 0.002, 0, 0.7>)]
                        [ 0.525 rgbt Gat (<0.01, 0.002, 0, 1>)]
                        [ 0.525 rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.8   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.8   rgbt Gat (<0.1, 0.035, 0.005, 1>)] 
                        [ 0.81  rgbt Gat (<0.1, 0.035, 0.005, 0.4>)]
                        [ 0.9   rgbt Gat (<0.15, 0.085, 0.009, 0.8>)]
                        [ 0.94  rgbt Gat (<0.15, 0.085, 0.009, 1>)]
                        [ 1     rgbt Gat (<1, 1, 1, 1>)]
                }  
                scale <50, 40, 50> 
        }
        finish {ambient 0 diffuse 0.4*2}
        normal {concreteNormal}
}
texture {// add grease/dirt                         
        pigment {               
                wrinkles   
                turbulence 1 
                omega 0.75 
                lambda 3 
                color_map {
                        [ 0.0   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.1   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.15  rgbt Gat (<0.01, 0.002, 0, 1>)]
                        [ 0.20  rgbt Gat (<0.01, 0.002, 0, 0.7>)]
                        [ 0.40  rgbt Gat (<0.01, 0.002, 0, 0.5>)]
                        [ 0.45  rgbt Gat (<0.025, 0.01, 0.001, 0.4>)]
                        [ 0.5   rgbt Gat (<0.01, 0.002, 0, 0.9>)]
                        [ 0.525 rgbt Gat (<0.01, 0.002, 0, 1>)]
                        [ 0.525 rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.8   rgbt Gat (<1, 1, 1, 1>)]
                        [ 0.8   rgbt Gat (<0.1, 0.035, 0.005, 1>)] 
                        [ 0.81  rgbt Gat (<0.1, 0.035, 0.005, 0.8>)]
                        [ 0.9   rgbt Gat (<0.15, 0.085, 0.009, 0.6>)]
                        [ 0.94  rgbt Gat (<0.15, 0.085, 0.009, 1>)]
                        [ 1     rgbt Gat (<1, 1, 1, 1>)]
                }  
                rotate <20,30,20>
                scale <45,55,35> 
        }
        finish {ambient 0 diffuse 0.4*2}
        normal {concreteNormal}

} 
texture {
        pigment  {
                gradient y   
                turbulence 0.115
                omega 0.8
                lambda 2.2
                color_map {
                        [ 0.0   rgbt Gat (<0.05, 0.03, 0, 0.0>)]
                        [ 0.3   rgbt Gat (<0.05, 0.03, 0, 0.2>)]
                        [ 0.6   rgbt Gat (<0.05, 0.03, 0, 0.4>)]
                        [ 0.9   rgbt Gat (<0.05, 0.03, 0, 0.9>)]
                        [ 1.0   rgbt Gat (<0.05, 0.03, 0, 0.99>)]
                }            
                scale <5,375,5>
                translate <0,-100,0> 
        }
        finish {ambient 0 diffuse 0.3*2}
        normal {concreteNormal}
} 

#declare T1 =
material {
        texture {
                gradient y   
                turbulence 0.1
                texture_map {
                        [0.0 land_tex_dry scale <1,0.01,0.0002>]
                        [0.1 land_tex_dry scale <1,0.01,0.0002>]
                        [0.7 wallTex scale 0.004]
                        [1.0 wallTex scale 0.004]
                }         
                scale 275
                translate <0,-30*1.5,0> 
        }
        interior {ior 1.6}
        scale 0.015
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 313) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  Absence  http://www.irtc.org/ftp/pub/stills/2006-10-31/missing.zip

#declare tileTex = 
texture {
        pigment {
                bozo
                turbulence 0.2
                omega 0.65 
                lambda 3.5
                color_map {
                        [0.0 rgb Ga (<0.85, 0.83, 0.55>)]
                        [0.4 rgb Ga (<0.85, 0.83, 0.55>)]
                        [1.0 rgb Ga (<0.70, 0.48, 0.15>)]
                }   
                scale <1.5, 1.3, 1.4>
        }
        finish {ambient 0 phong 0.25 diffuse 0.6 phong_size 25 reflection 0.002}
        normal {granite 0.4 turbulence 1 scale 0.1}  
}        
texture {
        pigment {
                marble
                turbulence 0.375
                omega 0.615 
                lambda 3.5
                color_map {
                        [0.00 rgbt Gat (<1, 1, 1, 1>)]
                        [0.20 rgbt Gat (<1, 1, 1, 1>)]
                        [0.20 rgbt Gat (<0.3, 0.3, 0.3, 1>)]
                        [0.22 rgbt Gat (<0.3, 0.3, 0.3, 0.2>)]
                        [0.25 rgbt Gat (<0.3, 0.3, 0.3, 1>)]
                        [0.25 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<0.2, 0.2, 0.2, 1>)]
                        [0.61 rgbt Gat (<0.2, 0.2, 0.2, 0.3>)]
                        [0.63 rgbt Gat (<0.2, 0.2, 0.2, 1>)]
                        [0.63 rgbt Gat (<1, 1, 1, 1>)]
                        [1.00 rgbt Gat (<1, 1, 1, 1>)]
                }   
                rotate <0, 35, 60> rotate <45, 0, 0>
                scale 0.7
        }
        finish {ambient 0 phong 0.25 diffuse 0.6 phong_size 25 reflection 0.002}
        normal {granite 0.4 turbulence 1 scale 0.1}  
}        
texture {
        pigment {
                marble
                turbulence 0.475
                omega 0.625 
                lambda 3.25
                color_map {
                        [0.00 rgbt Gat (<1, 1, 1, 1>)]
                        [0.10 rgbt Gat (<1, 1, 1, 1>)]
                        [0.10 rgbt Gat (<0.3, 0.1, 0.01, 1>)]
                        [0.15 rgbt Gat (<0.3, 0.1, 0.01, 0.2>)]
                        [0.20 rgbt Gat (<0.3, 0.1, 0.01, 1>)]
                        [0.20 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<0.3, 0.2, 0.03, 1>)]
                        [0.65 rgbt Gat (<0.3, 0.2, 0.03, 0.3>)]
                        [0.70 rgbt Gat (<0.3, 0.2, 0.03, 1>)]
                        [0.80 rgbt Gat (<1, 1, 1, 1>)]
                        [1.00 rgbt Gat (<1, 1, 1, 1>)]
                }                  
                rotate <0,-45,70> 
                rotate <65,0,0>
                scale <1.25,1,2>
        }
        finish {ambient 0 phong 0.25 diffuse 0.6 phong_size 25 reflection 0.002}
        normal {granite 0.4 turbulence 1 scale 0.1}  
}
texture {
        pigment {
                wrinkles 
                scallop_wave
                turbulence 0.875
                omega 0.75 
                lambda 3.5
                color_map {
                        [0.00 rgbt Gat (<1, 1, 1, 1>)]
                        [0.10 rgbt Gat (<1, 1, 1, 1>)]
                        [0.10 rgbt Gat (<0.2, 0.1, 0.01, 1>)]
                        [0.15 rgbt Gat (<0.2, 0.1, 0.01, 0.3>)]
                        [0.20 rgbt Gat (<0.2, 0.1, 0.01, 1>)]
                        [0.20 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<1, 1, 1, 1>)]
                        [0.60 rgbt Gat (<0.1, 0.04, 0.0, 1>)]
                        [0.65 rgbt Gat (<0.1, 0.04, 0.0, 0.4>)]
                        [0.70 rgbt Gat (<0.1, 0.04, 0.0, 1>)]
                        [0.80 rgbt Gat (<1, 1, 1, 1>)]
                        [1.00 rgbt Gat (<1, 1, 1, 1>)]
                }   
        }
        finish {ambient 0 phong 0.25 diffuse 0.6 phong_size 25 reflection 0.002}
        normal {granite 0.4 turbulence 1 scale 0.1}  
} 
texture  {
        pigment {
                gradient x
                turbulence 0.02 
                omega 0.7
                lambda 3
                color_map {
                        [0.000 rgbt Gat (<0.035, 0.025, 0.01, 0>)]
                        [0.100 rgbt Gat (<0.035, 0.025, 0.01, 0.1>)]
                        [0.110 rgbt Gat (<0.15, 0.1, 0.05, 0.3>)]
                        [0.125 rgbt Gat (<0.25, 0.18, 0.08, 0.9>)]
                        [0.400 rgbt Gat (<0.25, 0.18, 0.08, 1>)]
                        [0.400 rgbt Gat (<1, 1, 1, 1>)]
                        [1.000 rgbt Gat (<1, 1, 1, 1>)]
                } 
                scale 100
                translate <-27.75,0,0>
        }
        finish {ambient 0 phong 0.05 diffuse 0.48 phong_size 10 reflection 0}       
        normal {granite 0.4 turbulence 1 scale 0.1}  
}
texture {
        pigment {
                gradient z    
                turbulence 0.015
                omega 0.7
                lambda 3
                color_map {
                        [0.000 rgbt Gat (<1, 1, 1, 1>)]
                        [0.600 rgbt Gat (<1, 1, 1, 1>)]
                        [0.600 rgbt Gat (<0.25, 0.18, 0.08, 1>)]
                        [0.800 rgbt Gat (<0.15, 0.1, 0.05, 0.9>)]
                        [0.825 rgbt Gat (<0.125, 0.08, 0.04, 0.3>)]
                        [0.850 rgbt Gat (<0.1, 0.025, 0.02, 0.15>)]
                        [1.000 rgbt Gat (<0.035, 0.01, 0.001, 0.1>)]
                }                   
                scale 100
                translate <0,0,-64.1>
        }
        finish {ambient 0 phong 0.05 diffuse 0.48 phong_size 10 reflection 0}       
        normal {granite 0.4 turbulence 1 scale 0.1}  
}  
texture {
        pigment {
                bozo
                turbulence 0.5
                omega 0.65 
                lambda 3.5
                color_map {
                        [0.0 rgbt Gat (<0.85, 0.83, 0.55, 1>)]
                        [0.4 rgbt Gat (<0.85, 0.83, 0.55, 0.9>)]
                        [1.0 rgbt Gat (<0.85, 0.83, 0.55, 1>)]
                }                 
                scale 0.5
        }
        finish {ambient 0 phong 0.25 diffuse 0.6 phong_size 25 reflection 0.002}
        normal {granite 0.4 turbulence 1 scale 0.1}  
}

#declare T1 =
material {
        texture {tileTex}
        interior {ior 1.5}
        scale 0.5
} 

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 314) /////////////////////////////////////////////////////////////////////////////////////

// Norbert Kern  warm_up  http://www.irtc.org/ftp/pub/stills/2001-06-30/warm_up.zip 

#declare T1 =      
material {   
        texture {
                pigment {rgbt <0.22,0.22,0.08,1.2>/1.5} 
                finish {
                        ambient 0 
                        diffuse 0.01 
                        specular 1.35 
                        roughness 0.06 
                        reflection {0.03, 1 fresnel on} 
                        conserve_energy 
                        metallic 0.5 
                }
        }   
        interior {
                ior 1.43 
                fade_distance 0.07 
                fade_power 1001 
                fade_color <0.49,0.56,0.14>
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 315) /////////////////////////////////////////////////////////////////////////////////////

// Thomas de Groot  Kepler Solar System, Take 3 missing files  http://news.povray.org/povray.binaries.scene-files/attachment/%3C42e88b8c%40news.povray.org%3E/TdG_Textures.inc.txt

#declare Filter = 0.9;      
#declare Transparency = 0.1;
#declare ScaleX = 1;        
#declare ScaleY = 1;        
#declare ScaleZ = 30;       
#declare FD = 10;           
#declare FP = 2.0;          

// TdG_NorthSeaWater macro
#declare T1 = 
material { 
        texture {    
                pigment {rgbft <0.104167,0.3125,0.260417,Filter,Transparency>}      
                normal {
                        waves , 0.05
                        turbulence 0.5
                        frequency 100.0
                        phase 1.0
                        ramp_wave
                        scale  <ScaleX, ScaleY, ScaleZ>
                }      
                finish {
                        ambient 0
                        diffuse 0
                        brilliance 5.0
                        phong 1.0
                        phong_size 90.0
                        specular 0.4
                        roughness 0.01
                        conserve_energy
                        reflection {0.1, 0.9 falloff 2}
                }      
        }   
        interior {
                ior 1.33
                fade_distance FD
                fade_power FP
                fade_color <0,0.437467,0>
                media {
                        samples 2,2
                        absorption rgb <1,0.05,0.05>
                }
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 316) /////////////////////////////////////////////////////////////////////////////////////

// Just a random raytracer  Water 'Bucket' (Example)  http://news.povray.org/povray.text.scene-files/attachment/%3C3f58be13$1@news.povray.org%3E/watersample.pov.txt

#declare r_0 = normal {bozo 0.2 scale 1.2}
#declare r_1 = normal {bozo 0.7 scale 0.5}
#declare r_2 = normal {bozo 0.8 scale 0.11}
#declare r_3 = normal {bozo 0.6 scale 0.027}
#declare r_4 = normal {bozo 0.1 scale 0.0039}

#declare T1 =
material {
	texture {
		pigment {
			color rgbf <0.8,0.8,1.0,0.97>
		}
		finish {
			diffuse 0.0
			ambient 0.0
			specular 0.3
			roughness 0.001
			reflection {
				0.1, 0.8
				fresnel on
			}
			conserve_energy
		}
		normal {
			average 
			normal_map {
				[1 r_3]
				[1 r_2]
				[1 r_1]
				[1 r_0]
			}
			scale 4
		}
	}
	interior { 
		ior 1.33 
		fade_distance 7
		fade_power 1
		fade_color <0.3, 0.25, 0.2>
	}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 317) /////////////////////////////////////////////////////////////////////////////////////

// Bob Hughes  ridged multifractal w. slope-dependent texture  http://news.povray.org/povray.text.scene-files/thread/%3C3a66c2b7%40news.povray.org%3E/

#declare WaterIce = 0.9; // water < > ice

#declare W1 =
texture {
        pigment {
                ripples 
                phase clock 
                turbulence 0.5-(0.25*WaterIce) 
                frequency 3 
                color_map {
                        [0 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(1.5-(1*WaterIce))]
                        [1 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(2.5-(2*WaterIce))]
                }
                scale 0.01
        }
        normal {
                ripples 0.05-(0.033*WaterIce) phase clock turbulence 0.75-(0.25*WaterIce) scale 0.005-(0.00125*WaterIce) scallop_wave
        }
        finish {
                ambient 0 
                diffuse 1-(0.75*WaterIce) 
                specular 0.75 
                roughness 0.005 
                phong 0.075 
                phong_size 10
                reflection {
                        0.03*(10*WaterIce), 
                        0.09*(10*WaterIce) 
                        falloff 1
                        exponent 0.67
                }
                conserve_energy
        }
        scale 0.125
}

#declare W2 =
texture {
        pigment {
                crackle turbulence 0.5-(0.25*WaterIce) 
                color_map {
                        [0 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(1.5-(1*WaterIce))]
                        [1 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(2.5-(2*WaterIce))]
                }
                scale 0.05
        }
        normal {
                bozo 0.067-(0.05*WaterIce) phase clock turbulence 0.25-(0.25*WaterIce) scale 0.005-(0.00125*WaterIce) scallop_wave
        }
        finish {
                ambient 0 
                diffuse 1-(0.75*WaterIce) 
                specular 0.75 
                roughness 0.005 
                phong 0.075 
                phong_size 10
                reflection {
                        0.03*(10*WaterIce), 
                        0.09*(10*WaterIce) 
                        falloff 1
                        exponent 0.67 
                }
                conserve_energy
        }
        scale 0.25
}

#declare W3 =
texture {
        pigment {
                crackle turbulence 0.5-(0.25*WaterIce) 
                color_map {
                        [0 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(1.5-(1*WaterIce))]
                        [1 rgbf <0.5,0.5+(0.25*WaterIce),0.5+(0.15*WaterIce),0.0125+(0.775*WaterIce)>*(2.5-(2*WaterIce))]
                }
                scale 0.005
        }
        normal {
                wrinkles 0.075-(0.067*WaterIce) phase clock turbulence 0.25-(0.125*WaterIce) scale 0.0025-(0.00125*WaterIce) triangle_wave
        }
        finish {
                ambient 0 
                diffuse 1-(0.75*WaterIce) 
                specular 0.75 
                roughness 0.005 
                phong 0.075 
                phong_size 10
                reflection {
                        0.03*(10*WaterIce), 
                        0.07*(10*WaterIce) 
                        falloff 1
                        exponent 0.67 
                }
                conserve_energy
        }
        scale 0.5
}

#declare T1 = 
material {
        texture {
                bozo turbulence 1.5 frequency 1 
                texture_map {
                        [0.15 W1]
                        [0.20 W2]
                        [0.40 W2]
                        [0.45 W3]
                        [1.00 W3]
                } 
                scale 0.125
        }
        interior {
                ior 1.33
                fade_distance 0.01 
                fade_power 1000 
                fade_color <0.5,0.6,0.8>
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 318) /////////////////////////////////////////////////////////////////////////////////////

// Simon Adameit  find edges postprocess with pov  http://news.povray.org/povray.text.scene-files/thread/%3C3d3eddb0%40news.povray.org%3E/
 
// Step 1

#declare radio  = 0;

#declare T1 =   
material {
        texture {
                pigment {rgb 1}
                finish {diffuse 0.6 emission 0.5 brilliance 0.01}
        }
        interior {ior 1}
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 319) /////////////////////////////////////////////////////////////////////////////////////

// Simon Adameit  find edges postprocess with pov  http://news.povray.org/povray.text.scene-files/thread/%3C3d3eddb0%40news.povray.org%3E/
 
// Step 2

#declare radio  = 0;
#declare light  = 0;
#declare envir  = 0;

#declare Scene_scale = 21;
#declare Radius_Dist = 2;
#declare Radius_Norm = 1;
#declare Di_Dist = 0.02;
#declare Di_Norm = 0.01;

#declare T1 =   
material {
        texture {
                pigment {
                        average
                        pigment_map {
                                [       spherical      
                                        scale Scene_scale 
                                        translate camloc
                                        color_map {
                                                [0  rgb   0]
                                                [1  red   3]  
                                        }
                                ]
                                [       slope {VPerp_Adjust (x,camloc-lookat)}
                                        color_map {
                                                [0  rgb   0]
                                                [1  green 3]
                                        }
                                ]
                                [       slope {VPerp_Adjust (y,camloc-lookat)}
                                        color_map {
                                                [0  rgb   0]
                                                [1  blue  3]
                                        }
                                ]
                        }
                }
                finish {diffuse 0 emission 1}
        }
}

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 320) /////////////////////////////////////////////////////////////////////////////////////

// Simon Adameit  find edges postprocess with pov  http://news.povray.org/povray.text.scene-files/thread/%3C3d3eddb0%40news.povray.org%3E/

#declare radio = 0;
#declare light = 0;
#declare envir = 0;
 
// Step 3

#declare Scene_scale = 22;
#declare Radius_Dist = 2;
#declare Radius_Norm = 1;
#declare Di_Dist = 160/image_width; //0.02;
#declare Di_Norm =  80/image_width; //0.01;

camera {
        orthographic
        location -z
        right image_width*x
        up image_height*y
        look_at 0
}

plane {
        z,2
        pigment {
                image_map {jpeg "materials_test318"}
                translate -0.5
                scale <image_width,image_height,1>
        }
        finish {diffuse 0 emission 1}
}

#declare Ifun =
function {
        pigment {
                image_map {jpeg "materials_test319"}
                translate -0.5
                scale <image_width,image_height,1>
        }
}

#declare Ifun_red_blur =
function {
        (#local Z1 = -Radius_Dist;
        #while (Z1 < Radius_Dist)
                #local Z2 = -Radius_Dist;
                #while (Z2 < Radius_Dist)
                        Ifun (x+Z1,y+Z2,z).red +
                        #local Z2 = Z2+1;
                #end
                #local Z1 = Z1+1;
        #end
        0)
        /(Radius_Dist*Radius_Dist*4)
}

#declare Ifun_green_blur =
function {
        (#local Z1 = -Radius_Norm;
        #while (Z1 < Radius_Norm)
                #local Z2 = -Radius_Norm;
                #while (Z2 < Radius_Norm)
                        Ifun(x+Z1,y+Z2,z).green +
                        #local Z2=Z2+1;
                #end
                 #local Z1 = Z1+1;
        #end
        0)
        /(Radius_Norm*Radius_Norm*4)
}

#declare Ifun_blue_blur =
function {
        (#local Z1 = -Radius_Norm;
        #while (Z1 < Radius_Norm)
                #local Z2 = -Radius_Norm;
                #while (Z2 < Radius_Norm)
                        Ifun (x+Z1,y+Z2,z).blue +
                        #local Z2 = Z2+1;
                #end
                #local Z1 = Z1+1;
        #end
        0)
        /(Radius_Norm*Radius_Norm*4)
}

#declare Ofun_Distance = function {select (abs (Ifun_red_blur(x,y,z)-Ifun(x,y,z).red)-Di_Dist,0,1)}

#declare Ofun_Norm =
function {
        max (
                select (abs (Ifun_green_blur (x,y,z)-Ifun (x,y,z).green)-Di_Norm,0,1),
                select (abs (Ifun_blue_blur  (x,y,z)-Ifun (x,y,z).blue) -Di_Norm,0,1)
        )
}

plane {
        z,1
        pigment{
                function {Ofun_Norm (x,y,z)}
                color_map {
                        [0 rgbt 1]
                        [1 rgb  0]
                }
        }
        finish {emission 1 diffuse 0}
}

plane {
        z,0
        pigment {
                function {Ofun_Distance (x,y,z)}
                color_map {
                        [0 rgbt 1]
                        [1 rgb  0]
                }
        }
        finish {emission 1 diffuse 0}
}        

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat < 320) object {set_up material {T1} hollow /*double_illuminate photons {target refraction on collect off}*/} #end                                                         

/////////////////////////////////////////////////////////////////////////////////////   

#declare PHOT    = 0;           // photons 0 = out; 1 = save photons; 2 = load photons
#declare RAD     = 1*radio;     // radiosity quality settings 0 = out; 1 = poor; 16 = good  (I use powers of two)
                
global_settings {
        max_trace_level matra
        #if (PHOT > 0)
                photons {
                        spacing 0.05
                        autostop 0
                        jitter 1
                        #if (PHOT = 1)
                                save_file "pov.ph"
                        #else
                                load_file "pov.ph"
                        #end                        
                }                                                               
        #end  
        #if(RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 30*RAD                
                        nearest_count min (20,RAD)      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1.6      
                        adc_bailout 0.005
                        normal on
                        media off
                }
        #end
}        

#if (light = 1)                                                        
        light_source {
        	<-1,1.05,-1>*200, rgb 1
                //area_light <5,0,0>,<0,5,0> 5,5 adaptive 1 jitter circular orient        
        }
#end

#if (envir = 1)
        sky_sphere {
                pigment {
                        image_map {
                                jpeg "13490888905_8a5462a53c_o3"  // based on http://www.flickr.com/photos/treecreeper/13490888905/
                                map_type 1 interpolate 2
                        }
                }
                emission rgb 1.4
        }
#end 

#if (mat = 321) /////////////////////////////////////////////////////////////////////////////////////

// Kari Kivisalo  Patina/grime  http://news.povray.org/povray.binaries.images/thread/%3C3B8DD549.D0A9588E%40engineer.com%3E/?mtop=134886

#declare Clear =
texture {
        pigment {color rgb Ga (<0.2,0.1,0.05>)} 
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3*2
                metallic
                specular 0.80
                roughness 0.05
                reflection 0.1
        }
        normal {
                average
                normal_map {
                        [dents 3 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
        scale 0.1*20
}

#declare Grime =
texture {
        pigment {color rgb Ga (<0.1,0.5,0.35>)} 
        finish {diffuse 0.22*2 ambient 0}
        normal {granite 1 scale 0.01}
        normal {
                average
                normal_map {
                        [dents 6 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
        scale 20
}

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)

texture_map {
        [0.4    Clear]
        [0.8    Grime]
}  

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 322) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E
                  
#declare shiny_brass =
texture {
	pigment {rgb <0.8,0.5,0>*0.9}
	finish {brilliance 2 reflection 0.33 metallic conserve_energy}
}

#declare shiny_brass_dents =
texture {
	shiny_brass
	normal {
                dents 1 scale 2 
                slope_map {
                        [0.0, <1,0>] 
                        [0.8, <1,0>] 
                        [0.8, <1,-1>] 
                        [1.0, <0,0>]
            }
        }
}

#declare dull_brass =
texture {
	pigment {
		bumps scale 5
		color_map {
			[0, rgb <0.8,0.5,0>*0.6]
			[1, rgb <0.8,0.5,0>*0.5]
		}
	}
	finish {reflection 0.01 metallic conserve_energy}
}

#declare corroded_brass =
texture {
	pigment {rgb <0.49,0.81,0.77>}
	normal {bumps scale 0.5}
	finish {reflection 0}
}

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)

texture_map {
	[0.28+t_offset shiny_brass]
        [0.46+t_offset shiny_brass_dents]
	[0.50+t_offset dull_brass]
	[0.66+t_offset corroded_brass]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 323) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"

#include "proceduralize.inc"

#declare img_name = "heavy.jpg"
#declare img_mapping = 0;
#declare img_scale = 2*0.02;
#declare img_filter = 0;
#declare img_transmit = 0;
#declare bump_size_1 = 3;
#declare bump_size_2 = 3;
#declare finish_1 = finish {diffuse 1*0.8}
#declare finish_2 = finish {Glossy ambient 0}
#declare change_point = 0.8;
#declare change_width = 0.9;
#declare img_turb = <0.1,0.09,0.08>*2;
#declare img_lambda = 2;
#declare t_base = texture {T_Wood2 rotate 90*x scale img_scale*0.25 finish {ambient 0}}
#declare heavy =
texture {
        Proceduralize (
                img_name,img_mapping,
                img_filter,img_transmit,
                finish_1,finish_2,
                bump_size_1,bump_size_2,
                img_scale,
                change_point,change_width,
                img_turb,img_lambda,
                t_base
        )
}

#declare img_name = "light.jpg"
#declare img_mapping = 0;
#declare img_scale = 1*0.02;
#declare img_filter  =0;
#declare img_transmit = 0;
#declare bump_size_1 = 3;
#declare bump_size_2 = 3;
#declare finish_1 = finish {diffuse 1*0.8}
#declare finish_2 = finish {Glossy ambient 0}
#declare change_point = 0.8;
#declare change_width = 0.9;
#declare img_turb = <0.1,0.05,0.01>*2;
#declare img_lambda = 1;
#declare t_base = texture {T_Wood2 rotate 90*x scale img_scale*0.25 finish {ambient 0}}
#declare light_ =
texture {
        Proceduralize (
                img_name,img_mapping,
                img_filter,img_transmit,
                finish_1,finish_2,
                bump_size_1,bump_size_2,
                img_scale,
                change_point,change_width,
                img_turb,img_lambda,
                t_base
        )
}

#declare img_name = "light.jpg"
#declare img_mapping = 0;
#declare img_scale = 1*0.02;
#declare img_filter = 0;
#declare img_transmit = 0;
#declare bump_size_1 = 3;
#declare bump_size_2 = 3;
#declare finish_1 = finish {diffuse 0.7*0.8}
#declare finish_2 = finish {Glossy diffuse 0.7 ambient 0}
#declare change_point = 0.8;
#declare change_width = 0.9;
#declare img_turb = <0.1,0.05,0.01>*2;
#declare img_lambda = 1;
#declare t_base = texture {T_Wood2 rotate 90*x scale img_scale*0.25 finish {ambient 0}}
#declare dark =
texture {
        Proceduralize (
                img_name,img_mapping,
                img_filter,img_transmit,
                finish_1,finish_2,
                bump_size_1,bump_size_2,
                img_scale,
                change_point,change_width,
                img_turb,img_lambda,
                t_base
        )
}

#declare img_name = "long.jpg"
#declare img_mapping = 0;
#declare img_scale = 1*0.02;
#declare img_filter = 0;
#declare img_transmit = 0;
#declare bump_size_1 = 3;
#declare bump_size_2 = 3;
#declare finish_1 = finish {diffuse 1*0.8}
#declare finish_2 = finish {Glossy ambient 0}
#declare change_point = 0.8;
#declare change_width = 0.9;
#declare img_turb = <0.1,0.05,0.01>*2;
#declare img_lambda = 1;
#declare t_base = texture {T_Wood2 rotate 90*x scale img_scale*0.25 finish {ambient 0}}
#declare long =
texture {
        Proceduralize (
                img_name,img_mapping,
                img_filter,img_transmit,
                finish_1,finish_2,
                bump_size_1,bump_size_2,
                img_scale,
                change_point,change_width,
                img_turb,img_lambda,
                t_base
        )
}

#declare offset_value = 0.06; 

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)
 
texture_map {
	[0.41+offset_value+t_offset heavy scale 25]
	[0.43+offset_value+t_offset light_ scale 25]
	[0.49+offset_value+t_offset light_ scale 25]
	[0.50+offset_value+t_offset long scale 25]
	[0.59+offset_value+t_offset long scale 25]
	[0.60+offset_value+t_offset light_ scale 25]
	[0.75+offset_value+t_offset dark scale 25]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 324) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E

#macro halton (index, base)
	#local out = 0;
	#local fraction = 1/base;
	#local i = index;
	#while (i > 0)
		#local remainder = mod (i, base);
		#local out = out+(fraction*remainder);
		#local i = int (i/base);
		#local fraction = fraction/base;
	#end

	out
#end

// -- Corroded, Scratched Steel Texture ---------------------------------------

/* From a post by Kenneth W */ 

#declare old_pitted_steel_texture =
texture {
	pigment{
		granite scale 0.5 // AGATE works well for this too.
		color_map {
			[0.000 rgb Ga (0.8*<0.4,0.4,0.38>)]
			[0.153 rgb Ga (<0.4,0.4,0.4>)]
			[0.398 rgb Ga (0.5*<0.7,0.4,0.25>)]
			[0.398 rgb Ga (0.2*<0.7,0.7,0.7>)]
			[1.000 rgb Ga (<0.545,0.380,0.345>)]
		}
	}
	normal {granite 0.7 scale 4}
        finish {diffuse 0.7} 
        scale 0.02
}

#declare steel_texture =
texture {
	pigment {
		rgb Ga (<0.7,0.8,1>*0.2)
	}
        finish {diffuse 0.7 reflection 0.5}
    }

#declare s = seed (12);
#declare scratched_steel_texture =
texture {
	pigment {
		rgb Ga (<0.7,0.8,1>*0.2)
	}
        finish {diffuse 0.7 reflection 0.5}
        normal {
        	average
        	normal_map {
	                #declare m = 24;
	                #declare n = 0;
	                #while ( n < m )
			        [ 1 crackle m/2 solid scale <0.2,10,0.2>*20 rotate <halton(n,2)*360, halton(n,3)*360, halton(n,5)*360> ]
	                        #declare n = n + 1;
	                #end
        	}
        }
        scale 0.02
    }

#declare texture_map_offset = 0.04;

#declare I1 = 
interior {ior 1.51}

#macro M1 (t_offset)
 
texture_map {
	[0.35+texture_map_offset+t_offset  scratched_steel_texture]
	[0.45+texture_map_offset+t_offset  steel_texture]
	[0.55+texture_map_offset+t_offset  old_pitted_steel_texture]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 325) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E

#declare clay_outer =
texture {
	pigment {rgb Ga (<186,39,21>/255)}
	finish {brilliance 1.8 specular 0.35 roughness 0.02}
};

#declare clay_inner = 
texture {
	pigment {rgb Ga (<117,68,64>/255)}
	finish {specular 0.2 roughness 0.02}
};

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)
 
texture_map {
	[0.42+t_offset  clay_outer]
	[0.62+t_offset  clay_inner]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 326) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E

// -- Rusted Iron Texture -----------------------------------------------------

#declare original_iron_texture =
texture {
	pigment {rgb Ga (<94,123,133>/255)}
	finish {diffuse 0.5 reflection 0.15 brilliance 1.6}
}

#declare burnished_iron_texture =
	texture {
		pigment {rgb Ga (<202,205,200>/255*1.3)}
		finish {diffuse 0.5 reflection 0.05}
	    }

#declare bright_rust_texture =
texture {
	pigment {rgb Ga (<169,69,17>/255*1.5)}
	finish {diffuse 0.5 reflection 0.05}
	normal { granite 0.5*2 scale 3*0.01}
}

#declare dull_rust_texture =
texture {
	pigment {rgb Ga (<125,79,60>/255*1.5)}
	finish {diffuse 0.5 reflection 0}
	normal {granite 1*2 scale 3*0.01}
}

#declare exposed_red_rust_texture = 
texture {
	pigment {rgb Ga (<146,42,35>/255*0.6)}
	finish {diffuse 0.5 reflection 0}
	normal {granite 0.3*2 scale 8*0.01}
}

#declare exposed_grey_rust_texture = 
texture {
	pigment {rgb Ga (<94,77,79>/255*0.6)}
	finish {diffuse 0.5 reflection 0}
	normal {granite 0.2*2 scale 7*0.01}
}

#declare two_tone_rust =
texture {
	bumps scale 0.5*0.01
	texture_map {
		[ 0.0 bright_rust_texture ]
		[ 0.5 dull_rust_texture ]
	}
}

#declare partially_burnished_iron_texture_1 =
texture {
	bozo scale 0.4 turbulence 0.6 scale 0.01
	texture_map {
		[ 0.0 two_tone_rust ]
		[ 0.7 burnished_iron_texture ]
		[ 0.9 original_iron_texture ]
	}
}

#declare partially_burnished_iron_texture_1 =
texture {
	pigment_pattern {
		average
		pigment_map {
			[ 1 bozo scale 0.4 turbulence 0.3 scale 0.01]
			[ 2 bozo scale 4 scale 0.01]
		}
	}
	texture_map {
		[ 0.0 two_tone_rust ]
		[ 0.7 burnished_iron_texture ]
		[ 0.9 original_iron_texture ]
	}
}

#declare partially_burnished_iron_texture_2 =
texture {
	pigment_pattern {
		average
		pigment_map {
			[ 1 bozo scale 2 turbulence 0.3 scale 0.01]
			[ 2 bozo scale 8 scale 0.01]
		}
	}
	texture_map {
		[ 0.0 two_tone_rust ]
		[ 0.4 burnished_iron_texture ]
		[ 0.8 original_iron_texture ]
	}
}

#declare two_tone_exposed_rust =
texture {
	granite scale 0.3*0.02
	texture_map {
		[ 0.3 exposed_red_rust_texture ]
		[ 0.7 exposed_grey_rust_texture ]
	}
}

#declare texture_map_offset = 0;

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)
 
texture_map {
	[0.36+texture_map_offset+t_offset two_tone_exposed_rust]
	[0.51+texture_map_offset+t_offset two_tone_rust]
	[0.56+texture_map_offset+t_offset partially_burnished_iron_texture_1]
	[0.62+texture_map_offset+t_offset partially_burnished_iron_texture_2]
	[0.69+texture_map_offset+t_offset partially_burnished_iron_texture_2]
	[0.75+texture_map_offset+t_offset partially_burnished_iron_texture_1]
	[0.78+texture_map_offset+t_offset two_tone_rust]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 327) /////////////////////////////////////////////////////////////////////////////////////

// Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E

// -- Stone with Chips and Moss Colour ----------------------------------------

#declare texture_map_offset = 0;

#declare I1 = 
interior {ior 1.5}

#macro M1 (t_offset)
 
texture_map {
	[0.35 + texture_map_offset+t_offset
		pigment {
			crackle scale 3*0.01
			color_map {
				[0.5 color rgb <0.625, 0.5729, 0.454396>*1.1]
				[0.8 color rgb <0.625, 0.5729, 0.454396>*0.6]
			}	
		} 
		normal {crackle 1 scale 3*0.01 slope_map {[0.0, <1,0>] [0.4, <1,0>] [0.4, <1,-1>] [1.0, <0,0>]}}
        ]
	[0.45+texture_map_offset+t_offset
		pigment {color rgb <0.625, 0.5729, 0.454396>*1.1} 
		normal {crackle 0 scale 3*0.01 slope_map {[0.0, <1,0>] [0.4, <1,0>] [0.4, <1,-1>] [1.0, <0,0>]}}
        ]
	[0.5+texture_map_offset+t_offset
		pigment {color rgb <0.625, 0.5729, 0.454396>} 
		normal {crackle 0 scale 3*0.01} 
        ]
	[0.6+texture_map_offset+t_offset
		pigment {color rgb <0.3854, 0.395833, 0.1875>} 
		normal {bumps scale 0.2*0.01}
        ]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 328) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// COPPER WITH CORROSION
#declare t_copper = 
texture {
        pigment {rgb Ga (<203,109,81>/255)}
        normal {granite 0.1 scale 0.1}
        finish {
                specular 0.75 roughness 0.05 metallic
                diffuse 0.4 
                reflection {0,1 fresnel metallic} conserve_energy
        }
}

#declare t_copper_corrosion =
texture {
        pigment {rgb Ga (<0.13,0.37,0.31>*0.5)}
        normal {granite 0.5 scale 0.01}
}

#declare I1 = 
interior {ior 1.1}

#macro M1 (t_offset)
 
texture_map {
	[0.45+t_offset t_copper]
	[0.70+t_offset t_copper_corrosion]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 329) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// BRONZE WITH PATINA/DIRT
#declare t_bronze= 
texture {
        pigment {rgb Ga (<165,113,100>/255)}
        normal {granite 0.1 scale 0.1}
        finish {
                specular 1 roughness 0.025 metallic
                diffuse 0.4 
                reflection {0,1 fresnel metallic} conserve_energy
        }
}

#declare t_bronze_patina =
texture {
        pigment {rgb Ga (<0.184,0.309,0.184>*0.01)}
        normal {granite 0.5 scale 0.01}
} 

#declare I1 = 
interior {ior 1.18}

#macro M1 (t_offset)
 
texture_map {
	[0.44+t_offset t_bronze]
	[0.74+t_offset t_bronze_patina]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 330) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// IRON WITH RUST
#declare t_iron = 
texture {
        pigment {rgb Ga (<0.137255,0.419608,0.556863>*0.25+0.1)}
        normal {granite 0.1 scale 0.1}
        finish {
                specular 1+0.5 
                roughness 0.05*0.1 
                metallic
                diffuse 0.5 
                reflection {0, 1 fresnel metallic} 
                conserve_energy
                brilliance 2
        }
}

#declare t_iron_corrosion =
texture{
        pigment {rgb Ga (0.5*<183,65,14>/255)}
        normal {granite 0.5*5 scale 0.01}
        finish {diffuse 0.5}
}

#declare I1 = 
interior {ior 1.51}

#macro M1 (t_offset)
 
texture_map {
	[0.4+t_offset t_iron]
	[0.7+t_offset t_iron_corrosion]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 331) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// LEAD WITH CORROSION
#declare t_lead = 
texture {
        pigment {rgb Gray20*1.5+SteelBlue*0.1*1.5}
        normal {granite 0.1 scale 0.1}
        finish {
                specular 1  
                metallic
                diffuse 0.5 
                reflection {0,1 fresnel metallic} 
                conserve_energy
        }
}

#declare t_lead_corrosion =
texture {
        pigment {Orange*0.3*1.5+Gray*0.3*1.5}
        normal {granite 0.5 scale 0.01}
}

#declare I1 = 
interior {ior 2.01}

#macro M1 (t_offset)
  
texture_map {
	[0.4+t_offset t_lead]
	[1.0+t_offset t_lead_corrosion]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 332) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// DUSTY MARBLE
#include "stones.inc"
#declare t_marble = 
texture {
        T_Stone18 scale 0.1
        finish {ambient 0 diffuse 0.9}
}
#declare t_marble_dirt=
texture {
        pigment {Gray10*1.5+Tan*0.75}
        normal {granite 0.1 scale 0.01}
}

#declare I1 = 
interior {ior 1.51}

#macro M1 (t_offset)
  
texture_map {
	[0.45+t_offset t_marble]
	[0.85+t_offset t_marble_dirt]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 333) /////////////////////////////////////////////////////////////////////////////////////

// Jaime Vives Piqueres  Ambient Occlusion Baking  http://www.ignorancia.org/uploads/zips/occlusion-baking-demo.zip

// WORN PAINT
#declare t_worn_paint_rust= 
texture {
        pigment {DarkTan*0.01*1.4+SteelBlue*0.5*1.4+Gray10*1.4}
        normal {facets coords 0.3 scale 0.1} //granite 0.05 scale 0.01}
        finish{
                specular 1 
                roughness 0.005 
                phong 0.4 
                phong_size 20 
                metallic
                diffuse 0.3 
                reflection {0,1 fresnel} 
                conserve_energy
        }
}

#declare t_worn_paint=
texture {
        pigment {
                //Turquoise
                SlateBlue
        }
        finish {
                /*Phong_Shiny*/ ambient 0 specular 0.5 roughness 0.003 phong 0.6 phong_size 60 
                reflection {0.2, 1 fresnel metallic} conserve_energy diffuse 0.4
        }
        normal {bumps 0.1 scale 0.01} 
}

#declare I1 = 
interior {ior 1.51}

#macro M1 (t_offset)
  
texture_map {
	[0.480+t_offset t_worn_paint_rust]
	[0.482+t_offset t_worn_paint]
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 334) /////////////////////////////////////////////////////////////////////////////////////

// Sean Day  old lantern  http://news.povray.org/povray.binaries.images/thread/%3Cweb.514a2e6b2f77df7b65887a1a0%40news.povray.org%3E/?ttop=384970&toff=50&mtop=382650&moff=10

#declare lampBaseNormal =   
normal {
        bozo
        scallop_wave
        scale 0.55
        turbulence 0.575
        lambda 2.5
        omega 0.75
        normal_map {
                [0.0    agate 0.1 scale 0.75 agate_turb 0.6]
                [0.1    agate 0.1 scale 0.75 agate_turb 0.6]
                [0.2    wrinkles 0.1 scale 0.15 turbulence 0.6]
                [0.956  wrinkles 0.05 scale 0.15 turbulence 0.6]
                [0.975  agate 0.1 scale 0.75 agate_turb 0.6]
                [1.0    agate 0.1 scale 0.75 agate_turb 0.6]

        }
}

#declare ldirt = 
texture {
        pigment { 
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.8   rgbt 1]
                        [0.8   rgbt Gat (<0.5,0.34,0.25,1>)]
                        [0.925 rgbt Gat (<0.25,0.2,0.15,0.8>)]
                        [1.0   rgbt Gat (<0.5,0.34,0.25,1>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.81+0.1 reflection {0.001,0.01 fresnel on}}
}

#declare dirt = 
texture {
        pigment { 
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.75  rgbt 1]
                        [0.75  rgbt Gat (<0.5,0.34,0.25,1>)]
                        [0.9   rgbt Gat (<0.25,0.2,0.15,0.5>)]
                        [1.0   rgbt Gat (<0.5,0.34,0.25,1>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001}
        finish {diffuse albedo 0.81 reflection {0.001,0.01 fresnel on}}
}

#declare vdirt = 
texture {
        pigment { 
                bozo 
                scallop_wave 
                turbulence 0.8753 
                omega 0.775 
                lambda 3.2 
                octaves 7
                color_map {
                        [0.0   rgbt 1]
                        [0.55  rgbt 1]
                        [0.55  rgbt Gat (<0.25,0.14,0.09,1>)]
                        [0.9   rgbt Gat (<0.08,0.06,0.045,0.125>)]
                        [1.0   rgbt Gat (<0.25,0.14,0.09,0.45>)]
                }
                scale 0.02
        }
        normal {granite 0.5 scale 0.001 }
        finish {diffuse albedo 0.75 reflection {0.001,0.005 fresnel on}}
}

#declare lampBaseTex = 
texture {
        pigment {rgb Ga (<0.003,0.125,0.3>)}
        finish {
                specular albedo 0.1 
                roughness 0.01 
                diffuse albedo 0.75 
                reflection {0.01,0.05 fresnel on}
        }
        normal {lampBaseNormal scale 0.5}
}
texture {
        pigment {
                bozo
                turbulence 0.456
                omega 0.8
                lambda 2
                octaves 8
                color_map {
                        [0     rgbt 1]
                        [0.3   rgbt 1]
                        [0.3   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.4   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.5   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.6   rgbt Gat (<0.45,0.2,0.07,0.985>)]
                        [0.7   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.8   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.9   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [1.0   rgbt Gat (<0.45,0.2,0.07,0.96>)]
                }
                scale <0.075,0.15,0.075>
        }
        finish {
                specular albedo 0.1 
                roughness 0.01 
                diffuse albedo 0.875 
                reflection {0.01,0.025 fresnel on}
        }
        normal {
                average 
                normal_map {
                        [1      lampBaseNormal scale 0.5]
                        [1      granite 0.8 scale 0.05]
                }
       }
}
texture {ldirt}

#declare lampBaseTexDirt = 
texture {lampBaseTex}
texture {dirt}

#declare lampBaseTexVDirt = 
texture {lampBaseTex}
texture {vdirt}

#declare lampBubblePaint =
texture {
        pigment { 
                gradient x 
                turbulence 0.73 
                omega 0.4 
                color_map {
                        [0     rgb Ga (<0.003,0.125,0.300>)]
                        [0.6   rgb Ga (<0.003,0.125,0.300>)]
                        [0.7   rgb Ga (<0.010,0.160,0.325>)]
                        [0.8   rgb Ga (<0.010,0.160,0.325>)]
                        [1.0   rgb Ga (<0.003,0.125,0.300>)]
                }
                scale <0.01,0.1,0.02>
        }
        finish {specular albedo 0.1 roughness 0.01 diffuse albedo 0.75 reflection {0.01,0.05 fresnel on}}
        normal {crackle 3 turbulence 0.5 scale 0.05}
}
texture {
        pigment {
                bozo
                turbulence 0.456
                omega 0.8
                lambda 2
                octaves 8
                color_map {
                        [0     rgbt 1]
                        [0.3   rgbt 1]
                        [0.3   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.4   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.5   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.6   rgbt Gat (<0.45,0.2,0.07,0.985>)]
                        [0.7   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [0.8   rgbt Gat (<0.45,0.2,0.07,0.975>)]
                        [0.9   rgbt Gat (<0.45,0.2,0.07,1>)]
                        [1.0   rgbt Gat (<0.45,0.2,0.07,0.96>)]
                }
                scale <0.075,0.15,0.075>
        }
        finish {specular albedo 0.1 roughness 0.01 diffuse albedo 0.875 reflection {0.01,0.025 fresnel on}}
        normal {crackle 3 turbulence 0.5 scale 0.06}
}

#declare lampBubblePaintDirt = 
texture {lampBubblePaint}
texture {dirt}

#declare lampBubblePaintVDirt = 
texture {lampBubblePaint}
texture {vdirt}

#declare lampRust =
texture {
        pigment { 
                granite 
                turbulence 0.35 
                omega 0.7 
                lambda 2.2
                color_map {
                        [0.0   rgb Ga (<0.015,0.0045,0>)]
                        [0.3   rgb Ga (<0.05,0.0175,0.00075>)]
                        [1.0   rgb Ga (<0.03,0.009,0.002>)]
                }
                scale 0.4
        }
        finish {specular albedo 0.1 roughness 0.01 brilliance 5 diffuse albedo 0.575}
        normal {granite 0.12*-10 turbulence 0.35 scale 0.1}
}

#declare  lampRustDirt = 
texture {lampRust}
texture {dirt}

#declare  lampRustVDirt = 
texture {lampRust}
texture {vdirt}

#declare  lampRustLDirt = 
texture {lampRust}
texture {ldirt}

#declare lampPaintRust = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTex scale 4]
                [0.6-0.1   lampBaseTex scale 4]
                [0.625+0.1 lampBubblePaint scale 2]
                [0.675+0.1 lampBubblePaint scale 2]
                [0.7+0.1   lampRust scale 3]
                [1.0   lampRust scale 3]
        }
        scale 0.25
}

#declare lampPaintRustDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexDirt scale 4]
                [0.6-0.1   lampBaseTexDirt scale 4]
                [0.625+0.1 lampBubblePaintDirt scale 2]
                [0.675+0.1 lampBubblePaintDirt scale 2]
                [0.7+0.1   lampRustDirt scale 3]
                [1.0   lampRustDirt scale 3]
        }
        scale 0.25
}

#declare lampPaintRustVDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexVDirt scale 4]
                [0.6-0.1   lampBaseTexVDirt scale 4]
                [0.625+0.1 lampBubblePaintVDirt scale 2]
                [0.675+0.1 lampBubblePaintVDirt scale 2]
                [0.7+0.1   lampRustVDirt scale 3] // was VDirt
                [1.0   lampRustVDirt scale 3] // was VDirt
        }
        scale 0.25
}

#declare lampPaintRustLDirt = 
texture {
        wrinkles
        cubic_wave
        turbulence 0.0625
        omega 0.675
        octaves 7
        //sine_wave
        //agate
        //agate_turb 0.375
        texture_map {
                [0.0   lampBaseTexDirt scale 4]
                [0.6-0.1   lampBaseTexDirt scale 4]
                [0.625+0.1 lampBubblePaintDirt scale 2]
                [0.675+0.1 lampBubblePaintDirt scale 2]
                [0.7+0.1   lampRustLDirt scale 3]
                [1.0       lampRustLDirt scale 3]
        }
        scale 0.25
}               

#declare I1 = 
interior {ior 1.6}                

#macro M1 (t_offset)
 
texture_map {
        [0.0   lampRust]
        [0.4   lampRust]
        [0.5   lampPaintRustDirt]     
        [0.6   lampPaintRustVDirt]     
        [1.0   lampPaintRustVDirt] 
}
/*
texture_map {
        [0.0   pigment {color rgb x}]
        [0.35  pigment {color rgb x}]
        [0.5   pigment {color rgb y}]     
        [0.55  pigment {color rgb z}]     
        [1.0   pigment {color rgb z}] 
}*/
#end

#end /////////////////////////////////////////////////////////////////////////////////////


#if (mat = 335) /////////////////////////////////////////////////////////////////////////////////////

// H. E. Day  Patina and metal wear test v.5  http://news.povray.org/povray.binaries.images/message/%3C3A998895.8C45A04F%40heday.freeservers.com%3E/#%3C3A998895.8C45A04F%40heday.freeservers.com%3E

#declare Base_Tex2 =
texture {
        pigment {rgb 1}
        finish {ambient 0 diffuse 1*0.625 phong 0.75 metallic}
}

#declare Scratching =
texture {
        pigment {
                bozo 
                color_map {
                        [0.20 rgb 1.25]
                        [0.25 rgbt 1]
                } 
                scale <20,20,1> 
                scale 1/10  
                rotate 71657
        }
        finish {ambient 0 diffuse 1*0.6 phong 0.25 metallic}
}

#declare Scortching =
texture {
        pigment {
                bozo 
                color_map {
                        [0.275 rgbt <0,0,0,0.75>]
                        [0.375 rgbt <0,0,0,0.625>]
                        [1     rgbt <0,0,0,1>]
                } 
                scale <1,1,5> 
                warp {turbulence 1/2} 
                scale 1/3
        }
        finish {ambient 0 diffuse 1*0.6 phong 0.25 metallic 0.5}
}

#declare Base_Tex1 =
texture {
        pigment {rgb 0.5}
        finish {ambient 0 diffuse 1*0.6 phong 0.75*0.5 metallic}
}
texture {Scratching scale 0.05}
texture {Scratching rotate -56767 scale 0.05}
texture {Scratching rotate 8967 scale 0.05}
texture {Scortching scale <1,1,2>*0.05}

#declare I1 = 
interior {ior 1.5}                

#macro M1 (t_offset)
 
texture_map {
        [0.45   Base_Tex2]     
        [0.45   Base_Tex1] 
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat = 336) /////////////////////////////////////////////////////////////////////////////////////

// Aaron Gillies  New Ceramics ... One ... More  http://news.povray.org/povray.binaries.images/message/%3C3DF35520.5020400%40spam.com%3E/#%3C3DF35520.5020400%40spam.com%3E

#declare Tex1 = 
texture {
        pigment {
                bozo//marble 
                //rotate z*90
                scale 20
                turbulence 0.25
                color_map {
                        [0 color rgb 0]
                }
        }
        normal {
                bozo//marble
                scale 20 
                turbulence 0.25
                //rotate z*90
                normal_map {
                        [0.0 crackle 1 scale 0.02]
                        [0.5 bozo 1 scale 0.02]
                }
        }                
        finish {
                ambient 0
                diffuse 0.6
                specular 1
                roughness 0.005
                reflection {0, 1}
                conserve_energy 
        }
        scale 0.02
}

#declare Tex2 = 
texture {
        pigment {
                bozo//marble 
                //rotate z*90
                scale 20
                turbulence 0.25
                color_map {
                        [1 color rgb <0.5,0.25,0>*1.5]
                }
        }
        normal {
                bozo//marble
                scale 20 
                turbulence 0.25
                //rotate z*90
                normal_map {
                        [0.5 bozo 1 scale 0.02]
                        [1.0 bozo 0.5 scale 10]
                }
        }                
        finish {
                ambient 0
                diffuse 0.6
                specular 1
                roughness 0.005
                reflection {0, 1}
                conserve_energy 
        }
        scale 0.02
}

#declare I1 = 
interior {ior 1.5}                

#macro M1 (t_offset)
 
texture_map {
        [0.2   Tex2]     
        [0.6   Tex1] 
}

#end

#end /////////////////////////////////////////////////////////////////////////////////////

#if (mat > 320) 

#include "DF3ProximityPattern.inc"   // Edouard  DF3 Proximity Testbed  http://news.povray.org/povray.binaries.scene-files/message/%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E/#%3Cweb.4be354b9821c7fd821619a220%40news.povray.org%3E
#declare generate_df3 = 0; 
#declare use_df3_proximity_pattern = true; 
#declare add_noise = true; 
Proximity_SetPatternSmoothingMode (on)
Proximity_SetPatternSmoothingValue (20)

//--------------------------------------  proximity setup  ------------------------------------

#declare obj = 
union {
        union {
                #declare I = seed (0);
                #declare i = -9;
                #while (i <= 8)
                        #declare j = 38;
                        #while (j >= 32)
                                object {
                                        superellipsoid {
                                                <0.03,0.03> 
                                                rotate <0.5-rand(I),0.5-rand(I),0.5-rand(I)>*2.5 
                                                scale 0.5
                                        } 
                                        translate <i,-0.075+rand(I)*0.05,j>
                                }
                                #declare j = j-1;
                        #end
                        #declare i = i+1;
                #end
                rotate x*90
                scale 0.5
                translate <0.25,19.25,4.2>
        }
        difference {                    
        	box {<-0.52,-0.55,0.15>, <0.52,-1.01,1.01>}
        	superellipsoid {<0.1,0.1>}
        	translate <0,1,-0.5>
        	scale 8
        }
        #include "particles.inc"
} 

#declare t_offset = 0;
#declare object_name = "prox_scen";  
#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

///////////////////////////////////////////////////////////////////////////////////// 

#declare obj =
julia_fractal {
        <-0.5,-0.3,0.6,0>
        quaternion sqr
        max_iteration 8
        precision 100
        rotate <15,0,90>
        translate y*0.75
        translate <-2.35,0.6,2>
} 

#declare t_offset = 0;
#declare object_name = "prox_juli";  
#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
intersection {
        height_field {
                jpeg "strands06"  
                smooth
                translate <-0.5,0,-0.5>
                scale <20,1,20>
                rotate y*-90   
        } 
        box {<-8,-0.01,-9.99>,<9.99,1.01,9.99>}
        rotate y*90
        scale <0.4,0.07,0.4>
        translate <0,-0.001,0.7>
}         

#declare t_offset = -0.07;
#declare object_name = "prox_stra2";  
#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "dissolution2.inc"} 

#declare t_offset = -0.02;
#declare object_name = "prox_diss";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
union {
        #include "plank.inc"
        #include "crystals2.inc"
} 

#declare t_offset = -0.02;
#declare object_name = "prox_stran";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "submarine2.inc"} 

#declare t_offset = 0;
#declare object_name = "prox_sub";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "star2.inc"} 

#declare t_offset = -0.03;
#declare object_name = "prox_star";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "shooter3.inc"} 

#declare t_offset = 0;
#declare object_name = "prox_shoot";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "hand.inc"} 

#declare t_offset = 0;
#declare object_name = "prox_hand";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////

#declare obj =
object {#include "blobtower.inc"} 

#declare t_offset = -0.1;
#declare object_name = "prox_blob";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

/////////////////////////////////////////////////////////////////////////////////////
  

#declare Wheel =
blob {
        threshold 0.6
        sphere {0,1.3,1 scale <1,1.2,1>}
        cylinder {0,-y*8,0.8,1}
        #declare Teta = 0;
        #while (Teta < 360)
                cylinder {0,x*3.4,0.4,1  rotate y*Teta}
                cylinder {0,y,0.4,1  translate x*3 rotate y*Teta}
                sphere {0,0.6,1 translate x*3 rotate y*Teta}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+6)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+12)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+18)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+24)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+30)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+36)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+42)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+48)}
                sphere {0,0.4,1 translate x*3 rotate y*(Teta+54)}
                sphere {0,0.5,1 translate x*3 rotate y*(Teta+60)}
                sphere {0,0.5,1 translate x*3 rotate y*(Teta+66)}
                #declare Teta=Teta+72;
        #end
}

#declare Eye =
union {
        torus {4.5,0.5}
        difference{
                sphere {0,4.3}
                box {-5,5 scale <1,1,0.05>}
                box {-5,5 scale <1,1,0.05> translate z}
                box {-5,5 scale <1,1,0.05> translate z*2}
                box {-5,5 scale <1,1,0.05> translate z*3}
                box {-5,5 scale <1,1,0.05> translate z*4}
                box {-5,5 scale <1,1,0.05> translate -z}
                box {-5,5 scale <1,1,0.05> translate -z*2}
                box {-5,5 scale <1,1,0.05> translate -z*3}
                box {-5,5 scale <1,1,0.05> translate -z*4}
                scale <1,0.7,1>
        }
}

#declare Ring2 =
union {
        cylinder {-0.2*x,0.2*x,0.6}
        torus {0.55,0.05 rotate z*90 scale <2,1,1> translate -x*0.2}
        torus {0.55,0.05 rotate z*90 scale <2,1,1> translate x*0.2}
}

#declare Elbow2 = 
intersection {
        torus {2,0.5} 
        plane {z,0 inverse} 
        plane {x,0 inverse} 
}

#declare Ring1 = 
union {
        cylinder{-0.2*x,0.2*x,1.2}
        torus {1.1,0.1 rotate z*90 scale <2,1,1> translate -x*0.2}
        torus {1.1,0.1 rotate z*90 scale <2,1,1> translate x*0.2}
        union {
                #declare Teta = 0;
                #while (Teta < 360)
                        union {
                                sphere {0,0.1 translate <0.15,1.2,0>}
                                sphere {0,0.1 translate <-0.15,1.2,0> rotate x*10}
                                rotate x*Teta
                        }
                        #declare Teta = Teta+20;
                #end
        }
}

#declare Elbow1 = 
intersection {
        torus {2,1} 
        plane {z,0 inverse} 
        plane {x,0 inverse} 
}

#declare Elbow =
union {
        intersection {
                torus {5,1.5} 
                plane {x,0 inverse}  
                plane {z,0 inverse}
        }
        object {Ring1 scale 1.5/1.2 translate z*5}
        object {Ring1 scale 1.5/1.2 translate z*5 rotate y*45}
        object {Ring1 rotate y*90 scale 1.5/1.2 translate x*5}
}

#declare ElPipe2 =
union {
        cylinder {-x*6,x*6,2 open}
        cylinder {-x*4,-x*2,3}
        cylinder {-x*2,x*2,2.5}
        sphere {0,0.51 scale <0.5,1.5,1>*1.5 translate <1,2.5,0>}
        object {Wheel scale <0.5,1,1>*0.4 translate <1,6.5,0>}
        torus {2.5,0.2 rotate z*90 translate -x*5}
        torus {2.5,0.2 rotate z*90 translate x}
        torus {2.2,0.2 rotate z*90 translate x*6}
        torus {2.2,0.2 rotate z*90 translate -x*6}
        torus {3.2,0.21 rotate z*90 translate -x*3.4}
        torus {3.2,0.21 rotate z*90 translate -x*2.6}
        torus {2,1 rotate z*90 translate -x*4}
        torus {2,1 rotate z*90 translate -x*2}
        torus {2,0.5 rotate z*90 translate x*2}
        #declare Teta = 0;
        #while (Teta < 360)
                union {
                        torus {1.3,0.3 scale <0.3,1,0.2> translate <-3,0,-3>}
                        torus {1.3,0.3 scale <0.4,1,0.5> translate <-1,0,-3>}
                        cylinder {-x*6,-x*5,0.1  translate -z*2.05}
                        sphere {0,1 scale <2,0.2,0.1> rotate y*45 translate <4.3,2,0>}
                        sphere {0,1 scale <2,0.2,0.1> rotate -y*45 translate <4.3,2,0>}
                        union {
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,2.5,0>}
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,2.5,0> rotate x*10}
                                scale <0.5,1,1>
                                translate x*0.1
                        }
                        union {
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,2.5,0>}
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,2.5,0> rotate x*10}
                                scale <0.5,1,1>
                                translate x*2
                        }
                        union {
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,3,0>}
                                sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,3,0> rotate x*10}
                                scale <0.5,1,1>
                                translate -x*4
                        }
                        cylinder {0,x*6,0.2  translate -z*2.05}
                        rotate x*Teta
                }
                #declare Teta = Teta+15;
        #end
        union {
                union {
                        object {Ring2 rotate y*90 translate <1.5,0,-4>}
                        object {Ring2 rotate x*90 translate <1.5,2,-6>}
                        object {Ring2 rotate x*90 translate <1.5,4.5,-6>}
                        object {Ring2 rotate y*90 translate <1.5,6.5,-4>}
                        object {Ring2 rotate y*90 translate <1.5,6.5,-2>}
                        object {Ring2 translate <3.5,6.5,0>}
                        object {Ring2 translate <7,6.5,0>}
                        object {Ring2 rotate x*90 translate <9,4.5,0>}
                        cylinder {0,-z*4,0.5 translate x*1.5}
                        cylinder {0,-z*3,0.7 translate x*1.5}
                        object {Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
                        object {Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
                        cylinder{0,y*2.5,0.5 translate <1.5,2,-6>}
                        cylinder{0,2*z,0.5 translate <1.5,6.5,-4>}
                        object {Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
                        cylinder{0,3.5*x,0.5 translate <3.5,6.5,0>}
                        object {Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
                        union {
                                cylinder{-4*y,4.5*y,0.5}
                                union {
                                        cylinder{-z*4,z*4,0.2}
                                        cylinder{-z*3,z*3,0.2 translate y}
                                        cylinder{-z*3,z*3,0.2 translate -y}
                                        cylinder{-z*2.5,z*2.5,0.2 translate y*2}
                                        cylinder{-z*2.5,z*2.5,0.2 translate -y*2}
                                        translate -y*0.5
                                }
                                translate 9*x
                        }
                        translate <1,0.5,0>
                }
                union {
                        object {Ring2 rotate y*90 translate <1.5,0,-4>}
                        object {Ring2 rotate x*90 translate <1.5,2,-6>}
                        object {Ring2 rotate x*90 translate <1.5,4.5,-6>}
                        object {Ring2 rotate y*90 translate <1.5,6.5,-4>}
                        object {Ring2 rotate y*90 translate <1.5,6.5,-2>}
                        object {Ring2 translate <3.5,6.5,0>}
                        object {Ring2 translate <7,6.5,0>}
                        object {Ring2 rotate x*90 translate <9,4.5,0>}
                        cylinder {0,-z*4,0.5 translate x*1.5}
                        cylinder {0,-z*3,0.7 translate x*1.5}
                        object {Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
                        object {Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
                        cylinder {0,y*2.5,0.5 translate <1.5,2,-6>}
                        cylinder {0,2*z,0.5 translate <1.5,6.5,-4>}
                        object {Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
                        cylinder {0,3.5*x,0.5 translate <3.5,6.5,0>}
                        object {Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
                        cylinder {-2*y,4.5*y,0.5 translate <9,0,0>}
                        scale <-1,1,-1>
                        translate x*10
                        translate <0,-1,-1>
                }
                scale <0.5,1,1>*0.6
                translate x*3
        }
        scale <2,1,1>
        translate x*12
}       

#declare scaleo = 24;
#declare scaleq = 3.5;

#declare obj = 
object {ElPipe2}

#declare t_offset = 0;
#declare object_name = "prox_tree";  

#declare df3_pattern = Proximity_LoadMap (obj, object_name)

#declare ElPipeN = 
object {
        obj
        material { 	
                texture {
        		pigment_pattern {
        			average
        			pigment_map {
        				[3.0    df3_pattern]
        				[0.6    slope {y altitude <0,1,0>} color_map {[0 rgb 1] [1 rgb 0]} scale 120]
        				[0.4    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 4]
        				[0.3    bozo color_map {[0 rgb 1] [1 rgb 0]}]
        				[0.2    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.33]
        				[0.1    bozo color_map {[0 rgb 1] [1 rgb 0]} scale 0.1]
        			}
        		}
        		M1 (t_offset)
        	}
        }
        interior {I1}
        /*double_illuminate*/ hollow
}

#include "Pipetree3.inc"

/////////////////////////////////////////////////////////////////////////////////////

#end